def normalize_manufacturer(manufacturer):
    """ Normalize a manufacturer name to a specific format """
    if manufacturer and len(manufacturer) > 0:
        manufacturer = manufacturer.strip()  # Remove leading and trailing whitespace
        # Verify and reassign to correct manufacturer names
        if "fs" == manufacturer.lower():
            manufacturer = "FS"
        elif "fiberstore" == manufacturer.lower():
            manufacturer = "FiberStore"
        elif "brocade" == manufacturer.lower():
            manufacturer = "BROCADE"
        # TODO: To be gradually uncommented when required in the future
        # elif "waverider" == manufacturer.lower():
        #     manufacturer = "WaveRider"
        # elif "bdcom" == manufacturer.lower():
        #     manufacturer = "BDCOM"
        # elif "cmts" == manufacturer.lower():
        #     manufacturer = "CMTS"
        # elif "ignitenet" == manufacturer.lower():
        #     manufacturer = "IgniteNet"
        # elif "staros" == manufacturer.lower():
        #     manufacturer = "StarOS"
        # elif "vsol" == manufacturer.lower():
        #     manufacturer = "VSOL"
        # elif "alfocom" == manufacturer.lower():
        #     manufacturer = "ALFOCOM"
        # elif "ligowave" == manufacturer.lower():
        #     manufacturer = "LigoWave"
        # elif "oem" == manufacturer.lower():
        #     manufacturer = "OEM"
        # elif "wtd" == manufacturer.lower():
        #     manufacturer = "WTD"
        # elif "linktel" == manufacturer.lower():
        #     manufacturer = "LINKTEL"
        # elif "us" == manufacturer.lower():
        #     manufacturer = "US"
        # elif "flexoptix" == manufacturer.lower():
        #     manufacturer = "FLEXOPTIX"
        else:
            # Capitalize only first letter
            manufacturer = manufacturer.lower()
            manufacturer = manufacturer[0].upper() + manufacturer[1:]
    return manufacturer
