import os
from typing import Dict
import yaml
import logging


def load_vendor_map() -> Dict[str, str]:
    """
    Load the YAML input file for the vendor code mapped to the vendor.
    """
    specs_filename = "vendor_map.yaml"
    dir_path = os.path.dirname(os.path.realpath(__file__))
    path = os.path.join(dir_path, specs_filename)

    # Load YAML file
    try:
        with open(path) as f:
            return yaml.safe_load(f) or {}
    except FileNotFoundError:
        logging.error(f"Vendor map file not found: {path}")
    except yaml.YAMLError as e:
        logging.error(f"Invalid YAML format in vendor map: {e}")
    except Exception as e:
        logging.error(f"Error loading vendor map: {e}")

    return {}
