"""Unit tests for counter32"""
from preseem import Counter32Sum
import unittest


class TestCounter32Sum(unittest.TestCase):

    def test_new_counter(self):
        """A new counter should return 0 until it is set."""
        self.assertEqual(int(Counter32Sum()), 0)

    def test_reset(self):
        """Calling reset restarts the counter at 0."""
        c = Counter32Sum()
        c.update(0)
        c.update(345)
        self.assertEqual(int(c), 345)
        c.reset()
        self.assertEqual(int(c), 0)

    def test_incr(self):
        """Test an incrementing counter."""
        c = Counter32Sum()
        c.update(10)
        self.assertEqual(int(c), 10)
        c.update(355)
        self.assertEqual(int(c), 355)
        c.update(355)
        self.assertEqual(int(c), 355)
        c.update(356)
        self.assertEqual(int(c), 356)

    def test_rollover(self):
        """Test counter rollover."""
        c = Counter32Sum()
        c.update(1000)
        c.update(2)
        self.assertEqual(int(c), 0xffffffff + 3)
        c.update(5)
        self.assertEqual(int(c), 0xffffffff + 6)

    def test_counterreset(self):
        """Test counter reset."""
        c = Counter32Sum()
        c.update(1000)
        c.update(5, True)
        self.assertEqual(int(c), 1005)
        c.update(10)
        self.assertEqual(int(c), 1010)
