"""Unit tests for counter32"""
from preseem import counter32
import unittest

class TestCounter32(unittest.TestCase):
    def test_new_counter(self):
        """A new counter should return 0 until it is set."""
        self.assertEqual(int(counter32()), 0)

    def test_reset(self):
        """Calling reset restarts the counter at 0."""
        c = counter32()
        c.update(0)
        c.update(345)
        self.assertEqual(int(c), 345)
        c.reset()
        self.assertEqual(int(c), 0)

    def test_incr(self):
        """Test an incrementing counter."""
        c = counter32()
        c.update(10)
        self.assertEqual(int(c), 0)
        c.update(355)
        self.assertEqual(int(c), 345)
        c.update(355)
        self.assertEqual(int(c), 345)
        c.update(356)
        self.assertEqual(int(c), 346)

    def test_rollover(self):
        """Test counter rollover."""
        c = counter32()
        c.update(0)
        c.update(0xfffffffe)
        self.assertEqual(int(c), 0xfffffffe)
        c.update(0xffffffff)
        self.assertEqual(int(c), 0xffffffff)
        c.update(200)
        self.assertEqual(int(c), 0xffffffff + 200)
