import os
from collections import namedtuple
from .netmeta_config_loader import load_config

Specs = namedtuple(
    "Specs",
    ["gpon_min_loss", "gpon_max_loss", "xgspon_min_loss", "xgspon_max_loss", "dist"])


def load_and_set_specs(path=None):
    """
    Load the YAML input file and convert the OLT/ONT PartSpecs to the Specs namedtuple format.

    Use this function when loading a YAML input file with PartSpecs for OLT/ONT.
    """
    global cfg

    # If path not provided, use default model specs
    if (path is None):
        specs_filename = "pon_specs.yaml"
        dir_path = os.path.dirname(os.path.realpath(__file__))
        path = os.path.join(dir_path, specs_filename)

    # Load YAML file
    cfg = load_config(path)

    # Convert PartSpecs for each section
    if "PartSpecs" in cfg:
        for category, part_specs in cfg.get('PartSpecs', {}).items():
            # Convert PartSpecs to namedtuple Specs
            tuple_specs = {
                key: Specs(**value)  # Unpack dict
                for key, value in part_specs.items()
            }
            # Overwrite the YAML input format of PartSpecs with the namedtuple specs format
            cfg["PartSpecs"][category] = tuple_specs

    return cfg


cfg = load_and_set_specs()
