"""Test Dependency Check"""

from unittest import TestCase
import pkg_resources


class TestDependencyCheck(TestCase):

    def mock_check_required_dependency(self, file_content: str):
        """A mock function of preseem.util.check_required_dependency

        Args:
            file_content (str): The requirements in a requirements.txt file.
        """
        pkg_resources.require(file_content)

    def test_dependency_not_found(self):
        """Test check_required_dependency in the case of uninstalled"""
        test_requirements = """
            # aiohttp==3.8.4
            aiohttp>=3.8.4
            aiosignal==1.3.1
            # async-timeout==4.0.2
            async-timeout>4.0.1,<4.0.3
            # asyncssh == 2.5.0
            asyncssh<2.5.0
            testmodule==0.1.1"""
        self.assertRaises(pkg_resources.DistributionNotFound,
                          self.mock_check_required_dependency, test_requirements)

    def test_dependency_mismatch(self):
        """Test check_required_dependency in the case of mismatch"""
        test_requirements = """aiohttp==100.0.0"""
        self.assertRaises(pkg_resources.VersionConflict,
                          self.mock_check_required_dependency, test_requirements)

    def test_dependency_found(self):
        """Test check_required_dependency in the case of installed"""
        try:
            pkg_resources.require("aiohttp>=3.8.4")
        except:
            self.fail("test_dependency_found failed.")
