"""
Thin wrapper for requesting TCP latency metrics
"""
from importlib import import_module
from preseem import PreseemGrpcClient
from ._apiutil import load_api, op, op_sync

# Only supporting TCP latency metrics for now
TCP_LATENCY_METRICS_PACKAGE_PREFIX = 'preseem_protobuf.metrics.tcp_latency_metrics'


class PreseemMetrics:
    """API to Preseem Metrics."""

    def __init__(self, client: PreseemGrpcClient) -> None:
        """Initialize with a GRPC client."""
        self._client = client
        self.cache_enabled = False
        self._objs = {}
        self._types = {}

    def _load(self, wrapper):
        pmod = import_module(f'{TCP_LATENCY_METRICS_PACKAGE_PREFIX}_pb2')
        gmod = import_module(f'{TCP_LATENCY_METRICS_PACKAGE_PREFIX}_pb2_grpc')
        load_api(self, wrapper, pmod, gmod)

    async def init(self):
        """Dynamically load TCP latency protobuf modules."""
        await self._client.connect()
        self._load(op)

    def load(self):
        """Dynamically load TCP latency protobuf modules. (non-asyncio)"""
        self._client._connect()
        self._load(op_sync)
