"""
Load Balancer Manager GRPC integration for requesting URL map syncs
"""
from preseem_protobuf.load_balancer_manager.url_map_pb2 import SyncUrlMapRequest
from preseem_protobuf.load_balancer_manager.url_map_pb2_grpc import UrlMapServiceStub
from preseem import PreseemGrpcClient                                           

class LoadBalancerManagerClient:
    """Client for requesting URL map syncs."""
    def __init__(self, api_key, host, port):                                             
        self._client = PreseemGrpcClient(api_key=api_key, host=host, port=port)    
        self._svc = None 

    def sync_url_map(self):
        if not self._client:
            return
        if not self._svc:
            self._client._connect()
            self._svc = UrlMapServiceStub(self._client._channel)
        return self._svc.SyncUrlMap(SyncUrlMapRequest())