import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_5_0_2Rt_03(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-5.0.2Rt.03")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 1,
                'sw_version': 'TR6-5.0.2Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 413558902,
                'dl_rf_packets': 41072597,
                'dl_rf_packets_dropped': 23442,
                'en_if_speed': 100000000,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 251275953,
                'ul_rf_packets': 11359097,
                'ul_rf_packets_dropped': 1830772
        }
        exp_sta_stats = {
                '00:13:4f:00:d5:95': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.28.46.174',
                                             'mac_address': '00:13:4f:00:d5:95',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '1830772',
                                                              'in_nucast_pkts': '414',
                                                              'in_octets': '251275953',
                                                              'in_ucast_pkts': '11358683',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:13:4f:00:d5:95'}],
                                                              'mac_address': '00:60:b3:ab:e8:b5',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '23442',
                                                              'out_nucast_pkts': '22219419',
                                                              'out_octets': '413558902',
                                                              'out_ucast_pkts': '18853178',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:13:4f:00:d5:95'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'Bgs6votf',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AGCzq+i1',
                                'sw_version': 'TR6-5.0.2Rt',
                                'system_mac_address': '00:60:b3:ab:e8:b5',
                                'uptime': '328229'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:60:b3:ab:e8:b5'}],
                                                                       'mac_address': '00:13:4f:00:d5:95',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:60:b3:ab:e8:b5'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.28.46.174',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABNPANWV',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_6_1_0Rt_02(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-6.1.0Rt.02")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 2,
                'sw_version': 'TR6-6.1.0Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 4265172497,
                'dl_en_packets': 173,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 963528216,
                'dl_rf_packets': 349286173,
                'dl_rf_packets_dropped': 109072,
                'en_if_speed': 100000000,
                'ul_en_bytes': 3727548343,
                'ul_en_packets': 124,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 2715875554,
                'ul_rf_packets': 209048200,
                'ul_rf_packets_dropped': 39374875
        }
        exp_sta_stats = {
                '00:15:6d:f0:e8:32': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.213.181.29',
                                             'mac_address': '00:15:6d:f0:e8:32',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None},
                '00:15:6d:f4:a6:8b': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.213.181.28',
                                             'mac_address': '00:15:6d:f4:a6:8b',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '39374875',
                                                              'in_nucast_pkts': '134051',
                                                              'in_octets': '2715875554',
                                                              'in_ucast_pkts': '208914149',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:15:6d:f0:e8:32'},
                                                                               {       'mac_address': '00:15:6d:f4:a6:8b'}],
                                                              'mac_address': '00:0b:6b:4c:ed:ae',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '109072',
                                                              'out_nucast_pkts': '67192594',
                                                              'out_octets': '963528216',
                                                              'out_ucast_pkts': '282093579',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:6d:f0:e8:32'},
                                                                                                                                    {       'mac_address': '00:15:6d:f4:a6:8b'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '69',
                                                              'in_octets': '4265172497',
                                                              'in_ucast_pkts': '104',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3727548343',
                                                              'out_ucast_pkts': '124',
                                                              'poller_hash': 'ALa0ztrv',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AAtrTO2u',
                                'sw_version': 'TR6-6.1.0Rt',
                                'system_mac_address': '00:0b:6b:4c:ed:ae',
                                'uptime': '4138898'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}],
                                                                       'mac_address': '00:15:6d:f0:e8:32',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.213.181.29',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABVt8Ogy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}],
                                                                       'mac_address': '00:15:6d:f4:a6:8b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.213.181.28',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABVt9KaL',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_6_1_9Rt_01(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-6.1.9Rt.01")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 1,
                'sw_version': 'TR6-6.1.9Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 3836520849,
                'dl_en_packets': 1993,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 3367149110,
                'dl_rf_packets': 16712933,
                'dl_rf_packets_dropped': 102890,
                'en_if_speed': 100000000,
                'ul_en_bytes': 611440004,
                'ul_en_packets': 150,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1486557177,
                'ul_rf_packets': 5071519,
                'ul_rf_packets_dropped': 1648491
        }
        exp_sta_stats = {
                '00:13:4f:10:4b:06': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '00:13:4f:10:4b:06',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '1648491',
                                                              'in_nucast_pkts': '18974',
                                                              'in_octets': '1486557177',
                                                              'in_ucast_pkts': '5052545',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:13:4f:10:4b:06'}],
                                                              'mac_address': '00:60:b3:44:f7:1a',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '102890',
                                                              'out_nucast_pkts': '5250468',
                                                              'out_octets': '3367149110',
                                                              'out_ucast_pkts': '11462465',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:13:4f:10:4b:06'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1137',
                                                              'in_octets': '3836520849',
                                                              'in_ucast_pkts': '856',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2',
                                                              'out_octets': '611440004',
                                                              'out_ucast_pkts': '148',
                                                              'poller_hash': 'Bgs0T3Gv',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AGCzRPca',
                                'sw_version': 'TR6-6.1.9Rt',
                                'system_mac_address': '00:60:b3:44:f7:1a',
                                'uptime': '141629'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:60:b3:44:f7:1a'}],
                                                                       'mac_address': '00:13:4f:10:4b:06',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:60:b3:44:f7:1a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABNPEEsG',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR49_6_1_0Rt_02(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR49-6.1.0Rt.02")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 0,
                'sw_version': 'TR49-6.1.0Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 322542882,
                'dl_en_packets': 244,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 3826972621,
                'dl_rf_packets': 2269210,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 100000000,
                'ul_en_bytes': 160097678,
                'ul_en_packets': 248,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': False,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:60:b3:5e:28:48',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11a',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2254197',
                                                              'out_octets': '3826972621',
                                                              'out_ucast_pkts': '15013',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '13',
                                                              'in_octets': '322542882',
                                                              'in_ucast_pkts': '231',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '160097678',
                                                              'out_ucast_pkts': '248',
                                                              'poller_hash': 'AGCzXihD',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AGCzXihI',
                                'sw_version': 'TR49-6.1.0Rt',
                                'system_mac_address': '00:60:b3:5e:28:48',
                                'uptime': '3301152'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_5_0_2Rt_03(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-5.0.2Rt.03")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 1,
                'sw_version': 'TR6-5.0.2Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 413558902,
                'dl_rf_packets': 41072597,
                'dl_rf_packets_dropped': 23442,
                'en_if_speed': 100000000,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 251275953,
                'ul_rf_packets': 11359097,
                'ul_rf_packets_dropped': 1830772
        }
        exp_sta_stats = {
                '00:13:4f:00:d5:95': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.28.46.174',
                                             'mac_address': '00:13:4f:00:d5:95',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '1830772',
                                                              'in_nucast_pkts': '414',
                                                              'in_octets': '251275953',
                                                              'in_ucast_pkts': '11358683',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:13:4f:00:d5:95'}],
                                                              'mac_address': '00:60:b3:ab:e8:b5',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '23442',
                                                              'out_nucast_pkts': '22219419',
                                                              'out_octets': '413558902',
                                                              'out_ucast_pkts': '18853178',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:13:4f:00:d5:95'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'AGCzq+iy',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AGCzq+i1',
                                'sw_version': 'TR6-5.0.2Rt',
                                'system_mac_address': '00:60:b3:ab:e8:b5',
                                'uptime': '328229'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:60:b3:ab:e8:b5'}],
                                                                       'mac_address': '00:13:4f:00:d5:95',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:60:b3:ab:e8:b5'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.28.46.174',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABNPANWV',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_5_0_5Rt_01(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-5.0.5Rt.01")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 0,
                'sw_version': 'TR6-5.0.5Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 2618640057,
                'dl_rf_packets': 65530167,
                'dl_rf_packets_dropped': 698,
                'en_if_speed': 100000000,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 2816102873,
                'ul_rf_packets': 6779135,
                'ul_rf_packets_dropped': 1959809
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '1959809',
                                                              'in_nucast_pkts': '78359',
                                                              'in_octets': '2816102873',
                                                              'in_ucast_pkts': '6700776',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:19:70:0d:61:e5',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '698',
                                                              'out_nucast_pkts': '54625427',
                                                              'out_octets': '2618640057',
                                                              'out_ucast_pkts': '10904740',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'ABlwDWHi',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'ABlwDWHj',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'ABlwDWHl',
                                'sw_version': 'TR6-5.0.5Rt',
                                'system_mac_address': '00:19:70:0d:61:e5',
                                'uptime': '329809'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_6_1_0Rt_02(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-6.1.0Rt.02")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 2,
                'sw_version': 'TR6-6.1.0Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 4265172497,
                'dl_en_packets': 173,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 963528216,
                'dl_rf_packets': 349286173,
                'dl_rf_packets_dropped': 109072,
                'en_if_speed': 100000000,
                'ul_en_bytes': 3727548343,
                'ul_en_packets': 124,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 2715875554,
                'ul_rf_packets': 209048200,
                'ul_rf_packets_dropped': 39374875
        }
        exp_sta_stats = {
                '00:15:6d:f0:e8:32': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.213.181.29',
                                             'mac_address': '00:15:6d:f0:e8:32',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None},
                '00:15:6d:f4:a6:8b': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '10.213.181.28',
                                             'mac_address': '00:15:6d:f4:a6:8b',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '39374875',
                                                              'in_nucast_pkts': '134051',
                                                              'in_octets': '2715875554',
                                                              'in_ucast_pkts': '208914149',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:15:6d:f0:e8:32'},
                                                                               {       'mac_address': '00:15:6d:f4:a6:8b'}],
                                                              'mac_address': '00:0b:6b:4c:ed:ae',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '109072',
                                                              'out_nucast_pkts': '67192594',
                                                              'out_octets': '963528216',
                                                              'out_ucast_pkts': '282093579',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:6d:f0:e8:32'},
                                                                                                                                    {       'mac_address': '00:15:6d:f4:a6:8b'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '69',
                                                              'in_octets': '4265172497',
                                                              'in_ucast_pkts': '104',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3727548343',
                                                              'out_ucast_pkts': '124',
                                                              'poller_hash': 'AAtrTO2i',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AAtrTO2u',
                                'sw_version': 'TR6-6.1.0Rt',
                                'system_mac_address': '00:0b:6b:4c:ed:ae',
                                'uptime': '4138898'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}],
                                                                       'mac_address': '00:15:6d:f0:e8:32',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.213.181.29',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABVt8Ogy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}],
                                                                       'mac_address': '00:15:6d:f4:a6:8b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:4c:ed:ae'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.213.181.28',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABVt9KaL',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tranzeo_tranzeo_Tranzeo_AP_TR6_6_1_9Rt_01(self):
        obj = self.run_data("tranzeo.tranzeo.Tranzeo AP.TR6-6.1.9Rt.01")
        exp_info = {
                'model': 'Tranzeo AP',
                'sta_count': 1,
                'sw_version': 'TR6-6.1.9Rt',
                'vendor': 'Tranzeo'
        }
        exp_stats = {
                'dl_en_bytes': 3836520849,
                'dl_en_packets': 1993,
                'dl_en_packets_dropped': 0,
                'dl_rf_bytes': 3367149110,
                'dl_rf_packets': 16712933,
                'dl_rf_packets_dropped': 102890,
                'en_if_speed': 100000000,
                'ul_en_bytes': 611440004,
                'ul_en_packets': 150,
                'ul_en_packets_dropped': 0,
                'ul_rf_bytes': 1486557177,
                'ul_rf_packets': 5071519,
                'ul_rf_packets_dropped': 1648491
        }
        exp_sta_stats = {
                '00:13:4f:10:4b:06': {       'dev_macs': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '00:13:4f:10:4b:06',
                                             'name': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '1648491',
                                                              'in_nucast_pkts': '18974',
                                                              'in_octets': '1486557177',
                                                              'in_ucast_pkts': '5052545',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:13:4f:10:4b:06'}],
                                                              'mac_address': '00:60:b3:44:f7:1a',
                                                              'mtu': 1500,
                                                              'name': 'WiFi802.11b',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '102890',
                                                              'out_nucast_pkts': '5250468',
                                                              'out_octets': '3367149110',
                                                              'out_ucast_pkts': '11462465',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:13:4f:10:4b:06'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '54000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1137',
                                                              'in_octets': '3836520849',
                                                              'in_ucast_pkts': '856',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'Ethernet0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2',
                                                              'out_octets': '611440004',
                                                              'out_ucast_pkts': '148',
                                                              'poller_hash': 'AGCzRPcS',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Tranzeo',
                                'model': 'Tranzeo AP',
                                'poller_hash': 'AGCzRPca',
                                'sw_version': 'TR6-6.1.9Rt',
                                'system_mac_address': '00:60:b3:44:f7:1a',
                                'uptime': '141629'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:60:b3:44:f7:1a'}],
                                                                       'mac_address': '00:13:4f:10:4b:06',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:60:b3:44:f7:1a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Tranzeo',
                                         'poller_hash': 'ABNPEEsG',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
