import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestMikrotikModels(DeviceTestCase):
    def test_mikrotik_mikrotik_ap_CRS109_8G_1S_2HnD_6_35_4_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.CRS109-8G-1S-2HnD.6.35.4.01")
        exp_info = {
                'model': 'CRS109-8G-1S-2HnD',
                'rf_chan_width': 20,
                'rf_freq': 2422,
                'sta_count': 0,
                'sw_version': '6.35.4',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 15,
                'dl_en_bytes': 88189079474,
                'dl_en_packets': 548897999,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1761751548,
                'dl_rf_packets': 5148593,
                'en_if_speed': 1000000000,
                'mem': 18.3441162109375,
                'serial_number': '786A04F9278B',
                'ssid': 'ccc@751',
                'system_mac_address': '4c:5e:0c:a8:57:17',
                'temperature': 29.0,
                'ul_en_bytes': 128345389807,
                'ul_en_packets': 766153659,
                'ul_noise_floor': -107.0,
                'ul_rf_bytes': 1499601,
                'ul_rf_packets': 2356
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 15.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:17',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '28080055157',
                                                              'in_ucast_pkts': '66910188',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:18',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '35192732188',
                                                              'out_ucast_pkts': '275220569',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:19',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:1a',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:1b',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '19',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1499601',
                                                              'in_ucast_pkts': '2356',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:1c',
                                                              'mtu': 1500,
                                                              'name': 'wlan2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1761751548',
                                                              'out_ucast_pkts': '5148593',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2422,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -107.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ccc@751'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:16',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '385639551',
                                                              'in_ucast_pkts': '2831345',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:15',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '51551196124',
                                                              'out_ucast_pkts': '400485269',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '59723384766',
                                                              'in_ucast_pkts': '479156466',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:14',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '41601461495',
                                                              'out_ucast_pkts': '90447821',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:a8:57:13',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 18.344116,
                                'model': 'CRS109-8G-1S-2HnD',
                                'serial_number': '786A04F9278B',
                                'sw_version': '6.35.4',
                                'system_mac_address': '4c:5e:0c:a8:57:17',
                                'temperature': 29.0,
                                'uptime': '18100267'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_CRS109_8G_1S_2HnD_6_42_3_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.CRS109-8G-1S-2HnD.6.42.3.01")
        exp_info = {
                'model': 'CRS109-8G-1S-2HnD',
                'rf_chan_width': 40,
                'rf_freq': 2462,
                'sta_count': 0,
                'sw_version': '6.42.3',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 2,
                'dl_en_bytes': 1956406685373,
                'dl_en_packets': 2387514387,
                'dl_noise_floor': None,
                'dl_rf_bytes': 78,
                'dl_rf_packets': 1,
                'en_if_speed': 1000000000,
                'mem': 18.9849853515625,
                'serial_number': '7059066160E0',
                'ssid': 'Hoag-Rd-Demaraction',
                'system_mac_address': '6c:3b:6b:3c:56:c2',
                'temperature': 8.0,
                'ul_en_bytes': 1978140332400,
                'ul_en_packets': 2571732583,
                'ul_noise_floor': -95.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '41670647492',
                                                              'in_ucast_pkts': '291189048',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c2',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '553990670779',
                                                              'out_ucast_pkts': '576217145',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c3',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '88137300427',
                                                              'in_ucast_pkts': '580047118',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c4',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1293944241463',
                                                              'out_ucast_pkts': '1123082650',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1826598737454',
                                                              'in_ucast_pkts': '1516278221',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c5',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '130205420158',
                                                              'out_ucast_pkts': '872432788',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:57:b6',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c1',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '20',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c7',
                                                              'mtu': 1500,
                                                              'name': 'wlan6',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '78',
                                                              'out_ucast_pkts': '1',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2462,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Hoag-Rd-Demaraction'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:c0',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:bf',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:56:be',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 18.984985,
                                'model': 'CRS109-8G-1S-2HnD',
                                'serial_number': '7059066160E0',
                                'sw_version': '6.42.3',
                                'system_mac_address': '6c:3b:6b:3c:56:c2',
                                'temperature': 8.0,
                                'uptime': '4792243'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_CRS109_8G_1S_2HnD_6_43_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.CRS109-8G-1S-2HnD.6.43.8.01")
        exp_info = {
                'model': 'CRS109-8G-1S-2HnD',
                'rf_chan_width': 40,
                'rf_freq': 2412,
                'sta_count': 0,
                'sw_version': '6.43.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 6,
                'dl_en_bytes': 60416908119,
                'dl_en_packets': 89388819,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 18.65234375,
                'serial_number': '883E07611F54',
                'ssid': 'ccc@ccc',
                'system_mac_address': '64:d1:54:fa:60:96',
                'temperature': 8.0,
                'ul_en_bytes': 62559792658,
                'ul_en_packets': 103756175,
                'ul_noise_floor': -103.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:96',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '17',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4553344262',
                                                              'in_ucast_pkts': '27781206',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:97',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '55589523504',
                                                              'out_ucast_pkts': '59354380',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '18',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '94504206',
                                                              'in_ucast_pkts': '696495',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:98',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2070531775',
                                                              'out_ucast_pkts': '14828373',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '19',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '55769059651',
                                                              'in_ucast_pkts': '60911118',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:99',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4899737379',
                                                              'out_ucast_pkts': '29573422',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:95',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '20',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:9a',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '21',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:9b',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2412,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -103.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ccc@ccc'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:94',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:93',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:fa:60:92',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 18.652344,
                                'model': 'CRS109-8G-1S-2HnD',
                                'serial_number': '883E07611F54',
                                'sw_version': '6.43.8',
                                'system_mac_address': '64:d1:54:fa:60:96',
                                'temperature': 8.0,
                                'uptime': '390108'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_Groove_A_52HPn_7_7_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.Groove A-52HPn.7.7.01")
        exp_info = {
                'model': 'Groove A-52HPn',
                'rf_chan_width': 20,
                'rf_freq': 5220,
                'sta_count': 0,
                'sw_version': '7.7',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 4,
                'dl_en_bytes': 625189107,
                'dl_en_packets': 7444235,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 100000000,
                'mem': 62.26806640625,
                'serial_number': '64A8050541F5',
                'ssid': 'ClearWireEG1',
                'system_mac_address': 'e4:8d:8c:f5:19:02',
                'temperature': 38.0,
                'ul_en_bytes': 200652147,
                'ul_en_packets': 663507,
                'ul_noise_floor': -114.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 4.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '3472386',
                                                              'in_octets': '625189107',
                                                              'in_ucast_pkts': '3971849',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:f5:19:02',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '71033',
                                                              'out_octets': '200652147',
                                                              'out_ucast_pkts': '592474',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:f5:19:03',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5220,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -114.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ClearWireEG1'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 62.268066,
                                'model': 'Groove A-52HPn',
                                'serial_number': '64A8050541F5',
                                'sw_version': '7.7',
                                'system_mac_address': 'e4:8d:8c:f5:19:02',
                                'temperature': 38.0,
                                'uptime': '2113390'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_Metal_5SHPn_7_5_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.Metal 5SHPn.7.5.01")
        exp_info = {
                'model': 'Metal 5SHPn',
                'rf_chan_width': 20,
                'rf_freq': 5180,
                'sta_count': 13,
                'sw_version': '7.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 19,
                'dl_en_bytes': 1083017183955,
                'dl_en_packets': 821642604,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1075274954839,
                'dl_rf_packets': 813043801,
                'en_if_speed': 100000000,
                'mem': 61.71875,
                'serial_number': '557004C5A710',
                'ssid': '58-POLE-PUEBLO',
                'system_mac_address': '4c:5e:0c:89:ce:27',
                'temperature': 48.0,
                'ul_en_bytes': 82796943203,
                'ul_en_packets': 496062636,
                'ul_noise_floor': -117.0,
                'ul_rf_bytes': 80467015069,
                'ul_rf_packets': 489790626
        }
        exp_sta_stats = {
                '00:0c:42:dd:a3:60': {       'alt_macs': {'00:0c:42:dd:a3:5f'},
                                             'dev_macs': {'9c:3d:cf:38:2f:e0'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -118.0,
                                             'dl_rf_bytes': 1130546574,
                                             'dl_rf_packets': 83717966,
                                             'dl_rssi': -50.0,
                                             'dl_snr': 68.0,
                                             'ip_address': '10.192.41.6',
                                             'mac_address': '00:0c:42:dd:a3:60',
                                             'name': 'Linda Morris',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': 1468922947,
                                             'ul_rf_packets': 48129817,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 58.0},
                '08:55:31:38:97:af': {       'alt_macs': {'08:55:31:38:97:ae'},
                                             'dev_macs': {'84:d3:43:90:07:65'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -110.0,
                                             'dl_rf_bytes': 751018208,
                                             'dl_rf_packets': 985255,
                                             'dl_rssi': -52.0,
                                             'dl_snr': 58.0,
                                             'ip_address': '10.192.41.3',
                                             'mac_address': '08:55:31:38:97:af',
                                             'name': 'igrid Bourne',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 143942150,
                                             'ul_rf_packets': 1070776,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 57.0},
                '4c:5e:0c:4b:11:79': {       'alt_macs': {'4c:5e:0c:4b:11:78'},
                                             'dev_macs': {'bc:a5:11:dc:45:0f'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -117.0,
                                             'dl_rf_bytes': 4104210481,
                                             'dl_rf_packets': 8137515,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 55.0,
                                             'ip_address': '10.192.41.7',
                                             'mac_address': '4c:5e:0c:4b:11:79',
                                             'name': 'Jeana Machmuller',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 1638768623,
                                             'ul_rf_packets': 4347949,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 54.0},
                '4c:5e:0c:88:d9:46': {       'alt_macs': {'4c:5e:0c:88:d9:45'},
                                             'dev_macs': {'04:a1:51:d2:03:d9'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -117.0,
                                             'dl_rf_bytes': 2718722016,
                                             'dl_rf_packets': 5867441,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 57.0,
                                             'ip_address': '10.192.41.9',
                                             'mac_address': '4c:5e:0c:88:d9:46',
                                             'name': 'Dianne Hilleslan',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 303664586,
                                             'ul_rf_packets': 1793882,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 57.0},
                '4c:5e:0c:8f:40:99': {       'alt_macs': {'4c:5e:0c:8f:40:98'},
                                             'dev_macs': {'48:f8:b3:a0:8f:8f'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -116.0,
                                             'dl_rf_bytes': 4054125712,
                                             'dl_rf_packets': 55017271,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 58.0,
                                             'ip_address': '10.192.41.29',
                                             'mac_address': '4c:5e:0c:8f:40:99',
                                             'name': 'Al Tucker',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': 1202608520,
                                             'ul_rf_packets': 38700448,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 59.0},
                '6c:3b:6b:94:e2:9b': {       'alt_macs': {'6c:3b:6b:94:e2:9a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 67004194,
                                             'dl_rf_packets': 400479,
                                             'dl_rssi': -60.0,
                                             'dl_snr': None,
                                             'ip_address': '10.192.41.28',
                                             'mac_address': '6c:3b:6b:94:e2:9b',
                                             'name': 'E.Engel',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': 1362374293,
                                             'ul_rf_packets': 1335623,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 56.0},
                '6c:3b:6b:94:e2:af': {       'alt_macs': {'6c:3b:6b:94:e2:ae'},
                                             'dev_macs': {'68:ff:7b:ae:eb:35'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -121.0,
                                             'dl_rf_bytes': 1863031835,
                                             'dl_rf_packets': 37526672,
                                             'dl_rssi': -52.0,
                                             'dl_snr': 69.0,
                                             'ip_address': '10.192.41.2',
                                             'mac_address': '6c:3b:6b:94:e2:af',
                                             'name': 'Dave Suchie',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 3892930076,
                                             'ul_rf_packets': 32688594,
                                             'ul_rssi': -53.0,
                                             'ul_snr': 64.0},
                '6c:3b:6b:95:09:63': {       'alt_macs': {'4c:5e:0c:89:3f:7c'},
                                             'dev_macs': {'80:cc:9c:2c:ff:ad'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -116.0,
                                             'dl_rf_bytes': 2596496009,
                                             'dl_rf_packets': 8939335,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 56.0,
                                             'ip_address': '10.192.41.16',
                                             'mac_address': '6c:3b:6b:95:09:63',
                                             'name': 'Gerry Benesky',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 682155952,
                                             'ul_rf_packets': 4588184,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 55.0},
                '6c:3b:6b:a7:80:40': {       'alt_macs': {'4c:5e:0c:89:3f:7c'},
                                             'dev_macs': {'00:26:f2:f4:df:d2'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -119.0,
                                             'dl_rf_bytes': 2621043977,
                                             'dl_rf_packets': 17446241,
                                             'dl_rssi': -69.0,
                                             'dl_snr': 50.0,
                                             'ip_address': '10.192.41.17',
                                             'mac_address': '6c:3b:6b:a7:80:40',
                                             'name': 'Shelly Farrell',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': 2553556201,
                                             'ul_rf_packets': 13081110,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 47.0},
                '6c:3b:6b:ab:b8:bc': {       'alt_macs': {'6c:3b:6b:ab:b8:bb'},
                                             'dev_macs': {'84:d8:1b:83:61:95'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -117.0,
                                             'dl_rf_bytes': 8311931,
                                             'dl_rf_packets': 65967,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 60.0,
                                             'ip_address': '10.192.41.25',
                                             'mac_address': '6c:3b:6b:ab:b8:bc',
                                             'name': 'Carl Mitcham',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': 37423246,
                                             'ul_rf_packets': 141705,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 56.0},
                'b8:69:f4:1e:e0:f8': {       'alt_macs': {'b8:69:f4:1e:e0:f7'},
                                             'dev_macs': {'7c:8b:ca:48:54:59'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -119.0,
                                             'dl_rf_bytes': 835419863,
                                             'dl_rf_packets': 4228173,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 62.0,
                                             'ip_address': '10.192.41.26',
                                             'mac_address': 'b8:69:f4:1e:e0:f8',
                                             'name': 'Kevin Nequette',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -116.0,
                                             'ul_rf_bytes': 548001616,
                                             'ul_rf_packets': 2804799,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 51.0},
                'b8:69:f4:cc:81:13': {       'alt_macs': {'b8:69:f4:cc:81:12'},
                                             'dev_macs': {'00:13:10:46:71:02'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -119.0,
                                             'dl_rf_bytes': 1377377,
                                             'dl_rf_packets': 10549,
                                             'dl_rssi': -80.0,
                                             'dl_snr': 39.0,
                                             'ip_address': '10.192.41.13',
                                             'mac_address': 'b8:69:f4:cc:81:13',
                                             'name': 'Jessie Jackson',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -116.0,
                                             'ul_rf_bytes': 1350010,
                                             'ul_rf_packets': 11895,
                                             'ul_rssi': -79.0,
                                             'ul_snr': 37.0},
                'b8:69:f4:d5:65:8f': {       'alt_macs': {'b8:69:f4:d5:65:8e'},
                                             'dev_macs': {'94:a6:7e:e1:43:6b'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -111.0,
                                             'dl_rf_bytes': 1995596117,
                                             'dl_rf_packets': 31859124,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 53.0,
                                             'ip_address': '10.192.41.8',
                                             'mac_address': 'b8:69:f4:d5:65:8f',
                                             'name': 'Jennifer Atkinson',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -119.0,
                                             'ul_rf_bytes': 1931740243,
                                             'ul_rf_packets': 16962332,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 53.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 19.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1224088',
                                                              'in_octets': '1083017183955',
                                                              'in_ucast_pkts': '820418516',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:89:ce:27',
                                                              'mtu': 1500,
                                                              'name': 'ether1-local',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3670463',
                                                              'out_octets': '82796943203',
                                                              'out_ucast_pkts': '492392173',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '80467015069',
                                                              'in_ucast_pkts': '489790626',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '1468922947',
                                                                                       'in_ucast_pkts': '48129817',
                                                                                       'mac_address': '00:0c:42:dd:a3:60',
                                                                                       'out_octets': '1130546574',
                                                                                       'out_ucast_pkts': '83717966'},
                                                                               {       'in_octets': '1362374293',
                                                                                       'in_ucast_pkts': '1335623',
                                                                                       'mac_address': '6c:3b:6b:94:e2:9b',
                                                                                       'out_octets': '67004194',
                                                                                       'out_ucast_pkts': '400479'},
                                                                               {       'in_octets': '3892930076',
                                                                                       'in_ucast_pkts': '32688594',
                                                                                       'mac_address': '6c:3b:6b:94:e2:af',
                                                                                       'out_octets': '1863031835',
                                                                                       'out_ucast_pkts': '37526672'},
                                                                               {       'in_octets': '682155952',
                                                                                       'in_ucast_pkts': '4588184',
                                                                                       'mac_address': '6c:3b:6b:95:09:63',
                                                                                       'out_octets': '2596496009',
                                                                                       'out_ucast_pkts': '8939335'},
                                                                               {       'in_octets': '2553556201',
                                                                                       'in_ucast_pkts': '13081110',
                                                                                       'mac_address': '6c:3b:6b:a7:80:40',
                                                                                       'out_octets': '2621043977',
                                                                                       'out_ucast_pkts': '17446241'},
                                                                               {       'in_octets': '37423246',
                                                                                       'in_ucast_pkts': '141705',
                                                                                       'mac_address': '6c:3b:6b:ab:b8:bc',
                                                                                       'out_octets': '8311931',
                                                                                       'out_ucast_pkts': '65967'},
                                                                               {       'in_octets': '1350010',
                                                                                       'in_ucast_pkts': '11895',
                                                                                       'mac_address': 'b8:69:f4:cc:81:13',
                                                                                       'out_octets': '1377377',
                                                                                       'out_ucast_pkts': '10549'},
                                                                               {       'in_octets': '1931740243',
                                                                                       'in_ucast_pkts': '16962332',
                                                                                       'mac_address': 'b8:69:f4:d5:65:8f',
                                                                                       'out_octets': '1995596117',
                                                                                       'out_ucast_pkts': '31859124'},
                                                                               {       'in_octets': '548001616',
                                                                                       'in_ucast_pkts': '2804799',
                                                                                       'mac_address': 'b8:69:f4:1e:e0:f8',
                                                                                       'out_octets': '835419863',
                                                                                       'out_ucast_pkts': '4228173'},
                                                                               {       'in_octets': '303664586',
                                                                                       'in_ucast_pkts': '1793882',
                                                                                       'mac_address': '4c:5e:0c:88:d9:46',
                                                                                       'out_octets': '2718722016',
                                                                                       'out_ucast_pkts': '5867441'},
                                                                               {       'in_octets': '1202608520',
                                                                                       'in_ucast_pkts': '38700448',
                                                                                       'mac_address': '4c:5e:0c:8f:40:99',
                                                                                       'out_octets': '4054125712',
                                                                                       'out_ucast_pkts': '55017271'},
                                                                               {       'in_octets': '1638768623',
                                                                                       'in_ucast_pkts': '4347949',
                                                                                       'mac_address': '4c:5e:0c:4b:11:79',
                                                                                       'out_octets': '4104210481',
                                                                                       'out_ucast_pkts': '8137515'},
                                                                               {       'in_octets': '143942150',
                                                                                       'in_ucast_pkts': '1070776',
                                                                                       'mac_address': '08:55:31:38:97:af',
                                                                                       'out_octets': '751018208',
                                                                                       'out_ucast_pkts': '985255'}],
                                                              'mac_address': '4c:5e:0c:89:ce:28',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1075274954839',
                                                              'out_ucast_pkts': '813043801',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5180,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '407188',
                                                                                                                                            'mac_address': '00:0c:42:dd:a3:60',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 58.0},
                                                                                                                                    {       'connected_time': '216923',
                                                                                                                                            'mac_address': '6c:3b:6b:94:e2:9b',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 56.0},
                                                                                                                                    {       'connected_time': '927255',
                                                                                                                                            'mac_address': '6c:3b:6b:94:e2:af',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'snr': 64.0},
                                                                                                                                    {       'connected_time': '216919',
                                                                                                                                            'mac_address': '6c:3b:6b:95:09:63',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 55.0},
                                                                                                                                    {       'connected_time': '698355',
                                                                                                                                            'mac_address': '6c:3b:6b:a7:80:40',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'snr': 47.0},
                                                                                                                                    {       'connected_time': '216925',
                                                                                                                                            'mac_address': '6c:3b:6b:ab:b8:bc',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 56.0},
                                                                                                                                    {       'connected_time': '63347',
                                                                                                                                            'mac_address': 'b8:69:f4:cc:81:13',
                                                                                                                                            'noise_floor': -116.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'snr': 37.0},
                                                                                                                                    {       'connected_time': '216934',
                                                                                                                                            'mac_address': 'b8:69:f4:d5:65:8f',
                                                                                                                                            'noise_floor': -119.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'snr': 53.0},
                                                                                                                                    {       'connected_time': '216927',
                                                                                                                                            'mac_address': 'b8:69:f4:1e:e0:f8',
                                                                                                                                            'noise_floor': -116.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 51.0},
                                                                                                                                    {       'connected_time': '216921',
                                                                                                                                            'mac_address': '4c:5e:0c:88:d9:46',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 57.0},
                                                                                                                                    {       'connected_time': '927253',
                                                                                                                                            'mac_address': '4c:5e:0c:8f:40:99',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 59.0},
                                                                                                                                    {       'connected_time': '216921',
                                                                                                                                            'mac_address': '4c:5e:0c:4b:11:79',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 54.0},
                                                                                                                                    {       'connected_time': '216935',
                                                                                                                                            'mac_address': '08:55:31:38:97:af',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 57.0}],
                                                                                                                   'noise_floor': -117.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '58-POLE-PUEBLO'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 61.71875,
                                'model': 'Metal 5SHPn',
                                'serial_number': '557004C5A710',
                                'sw_version': '7.5',
                                'system_mac_address': '4c:5e:0c:89:ce:27',
                                'temperature': 48.0,
                                'uptime': '927287'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1130546574',
                                                                       'in_ucast_pkts': '83717966',
                                                                       'links': [       {       'in_octets': '1130546574',
                                                                                                'in_ucast_pkts': '83717966',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1468922947',
                                                                                                'out_ucast_pkts': '48129817'}],
                                                                       'mac_address': '00:0c:42:dd:a3:60',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1468922947',
                                                                       'out_ucast_pkts': '48129817',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '407188',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -118.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'snr': 68.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:0c:42:dd:a3:5f',
                                                                                                        '9c:3d:cf:38:2f:e0'],
                                                                       'id': '2',
                                                                       'in_octets': '1468922947',
                                                                       'in_ucast_pkts': '48129817',
                                                                       'mac_address': '00:0c:42:dd:a3:5f',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1130546574',
                                                                       'out_ucast_pkts': '83717966',
                                                                       'poller_hash': 'MDAwYzQyZGRhMzYwZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.6',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Groove 5Hn',
                                         'name': 'Linda Morris',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '00:0c:42:dd:a3:5f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '67004194',
                                                                       'in_ucast_pkts': '400479',
                                                                       'links': [       {       'in_octets': '67004194',
                                                                                                'in_ucast_pkts': '400479',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1362374293',
                                                                                                'out_ucast_pkts': '1335623'}],
                                                                       'mac_address': '6c:3b:6b:94:e2:9b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1362374293',
                                                                       'out_ucast_pkts': '1335623',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216923',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1362374293',
                                                                       'in_ucast_pkts': '1335623',
                                                                       'mac_address': '6c:3b:6b:94:e2:9a',
                                                                       'name': 'ether1',
                                                                       'out_octets': '67004194',
                                                                       'out_ucast_pkts': '400479',
                                                                       'poller_hash': 'NmMzYjZiOTRlMjliZXRoZXIx'}],
                                         'management_ip': '10.192.41.28',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'E.Engel',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:94:e2:9a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1863031835',
                                                                       'in_ucast_pkts': '37526672',
                                                                       'links': [       {       'in_octets': '1863031835',
                                                                                                'in_ucast_pkts': '37526672',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '3892930076',
                                                                                                'out_ucast_pkts': '32688594'}],
                                                                       'mac_address': '6c:3b:6b:94:e2:af',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3892930076',
                                                                       'out_ucast_pkts': '32688594',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '927255',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -121.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'snr': 69.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '68:ff:7b:ae:eb:35',
                                                                                                        '6c:3b:6b:94:e2:ae'],
                                                                       'id': '2',
                                                                       'in_octets': '3892930076',
                                                                       'in_ucast_pkts': '32688594',
                                                                       'mac_address': '6c:3b:6b:94:e2:ae',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1863031835',
                                                                       'out_ucast_pkts': '37526672',
                                                                       'poller_hash': 'NmMzYjZiOTRlMmFmZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.2',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Dave Suchie',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:94:e2:ae'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2596496009',
                                                                       'in_ucast_pkts': '8939335',
                                                                       'links': [       {       'in_octets': '2596496009',
                                                                                                'in_ucast_pkts': '8939335',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '682155952',
                                                                                                'out_ucast_pkts': '4588184'}],
                                                                       'mac_address': '6c:3b:6b:95:09:63',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '682155952',
                                                                       'out_ucast_pkts': '4588184',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216919',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -116.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'snr': 56.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '4c:5e:0c:89:3f:7c',
                                                                                                        '80:cc:9c:2c:ff:ad'],
                                                                       'id': '2',
                                                                       'in_octets': '682155952',
                                                                       'in_ucast_pkts': '4588184',
                                                                       'mac_address': '6c:3b:6b:95:09:62',
                                                                       'name': 'ether1-local',
                                                                       'oper_up': True,
                                                                       'out_octets': '2596496009',
                                                                       'out_ucast_pkts': '8939335',
                                                                       'poller_hash': 'NmMzYjZiOTUwOTYzZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.16',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Gerry Benesky',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:95:09:62'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2621043977',
                                                                       'in_ucast_pkts': '17446241',
                                                                       'links': [       {       'in_octets': '2621043977',
                                                                                                'in_ucast_pkts': '17446241',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '2553556201',
                                                                                                'out_ucast_pkts': '13081110'}],
                                                                       'mac_address': '6c:3b:6b:a7:80:40',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2553556201',
                                                                       'out_ucast_pkts': '13081110',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '698355',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -119.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'snr': 50.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:26:f2:f4:df:d2',
                                                                                                        '4c:5e:0c:89:3f:7c'],
                                                                       'id': '2',
                                                                       'in_octets': '2553556201',
                                                                       'in_ucast_pkts': '13081110',
                                                                       'mac_address': '6c:3b:6b:a7:80:3f',
                                                                       'name': 'ether1-local',
                                                                       'oper_up': True,
                                                                       'out_octets': '2621043977',
                                                                       'out_ucast_pkts': '17446241',
                                                                       'poller_hash': 'NmMzYjZiYTc4MDQwZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.17',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Shelly Farrell',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:a7:80:3f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '8311931',
                                                                       'in_ucast_pkts': '65967',
                                                                       'links': [       {       'in_octets': '8311931',
                                                                                                'in_ucast_pkts': '65967',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '37423246',
                                                                                                'out_ucast_pkts': '141705'}],
                                                                       'mac_address': '6c:3b:6b:ab:b8:bc',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '37423246',
                                                                       'out_ucast_pkts': '141705',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216925',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -117.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'snr': 60.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:3b:6b:ab:b8:bb',
                                                                                                        '84:d8:1b:83:61:95'],
                                                                       'id': '2',
                                                                       'in_octets': '37423246',
                                                                       'in_ucast_pkts': '141705',
                                                                       'mac_address': '6c:3b:6b:ab:b8:bb',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '8311931',
                                                                       'out_ucast_pkts': '65967',
                                                                       'poller_hash': 'NmMzYjZiYWJiOGJjZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.25',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Carl Mitcham',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:ab:b8:bb'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1377377',
                                                                       'in_ucast_pkts': '10549',
                                                                       'links': [       {       'in_octets': '1377377',
                                                                                                'in_ucast_pkts': '10549',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1350010',
                                                                                                'out_ucast_pkts': '11895'}],
                                                                       'mac_address': 'b8:69:f4:cc:81:13',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1350010',
                                                                       'out_ucast_pkts': '11895',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '63347',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -119.0,
                                                                                                                                                     'rssi': -80.0,
                                                                                                                                                     'snr': 39.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:13:10:46:71:02',
                                                                                                        'b8:69:f4:cc:81:12'],
                                                                       'id': '2',
                                                                       'in_octets': '1350010',
                                                                       'in_ucast_pkts': '11895',
                                                                       'mac_address': 'b8:69:f4:cc:81:12',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1377377',
                                                                       'out_ucast_pkts': '10549',
                                                                       'poller_hash': 'Yjg2OWY0Y2M4MTEzZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.13',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Jessie Jackson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'b8:69:f4:cc:81:12'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1995596117',
                                                                       'in_ucast_pkts': '31859124',
                                                                       'links': [       {       'in_octets': '1995596117',
                                                                                                'in_ucast_pkts': '31859124',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1931740243',
                                                                                                'out_ucast_pkts': '16962332'}],
                                                                       'mac_address': 'b8:69:f4:d5:65:8f',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1931740243',
                                                                       'out_ucast_pkts': '16962332',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216934',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -111.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'snr': 53.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '94:a6:7e:e1:43:6b',
                                                                                                        'b8:69:f4:d5:65:8e'],
                                                                       'id': '2',
                                                                       'in_octets': '1931740243',
                                                                       'in_ucast_pkts': '16962332',
                                                                       'mac_address': 'b8:69:f4:d5:65:8e',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1995596117',
                                                                       'out_ucast_pkts': '31859124',
                                                                       'poller_hash': 'Yjg2OWY0ZDU2NThmZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.8',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal G-52SHPacn',
                                         'name': 'Jennifer Atkinson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'b8:69:f4:d5:65:8e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '835419863',
                                                                       'in_ucast_pkts': '4228173',
                                                                       'links': [       {       'in_octets': '835419863',
                                                                                                'in_ucast_pkts': '4228173',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '548001616',
                                                                                                'out_ucast_pkts': '2804799'}],
                                                                       'mac_address': 'b8:69:f4:1e:e0:f8',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '548001616',
                                                                       'out_ucast_pkts': '2804799',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216927',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -119.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'snr': 62.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '7c:8b:ca:48:54:59',
                                                                                                        'b8:69:f4:1e:e0:f7'],
                                                                       'id': '2',
                                                                       'in_octets': '548001616',
                                                                       'in_ucast_pkts': '2804799',
                                                                       'mac_address': 'b8:69:f4:1e:e0:f7',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '835419863',
                                                                       'out_ucast_pkts': '4228173',
                                                                       'poller_hash': 'Yjg2OWY0MWVlMGY4ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.26',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Kevin Nequette',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'b8:69:f4:1e:e0:f7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2718722016',
                                                                       'in_ucast_pkts': '5867441',
                                                                       'links': [       {       'in_octets': '2718722016',
                                                                                                'in_ucast_pkts': '5867441',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '303664586',
                                                                                                'out_ucast_pkts': '1793882'}],
                                                                       'mac_address': '4c:5e:0c:88:d9:46',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '303664586',
                                                                       'out_ucast_pkts': '1793882',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216921',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -117.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'snr': 57.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:a1:51:d2:03:d9',
                                                                                                        '4c:5e:0c:88:d9:45'],
                                                                       'id': '2',
                                                                       'in_octets': '303664586',
                                                                       'in_ucast_pkts': '1793882',
                                                                       'mac_address': '4c:5e:0c:88:d9:45',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2718722016',
                                                                       'out_ucast_pkts': '5867441',
                                                                       'poller_hash': 'NGM1ZTBjODhkOTQ2ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.9',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Dianne Hilleslan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:88:d9:45'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4054125712',
                                                                       'in_ucast_pkts': '55017271',
                                                                       'links': [       {       'in_octets': '4054125712',
                                                                                                'in_ucast_pkts': '55017271',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1202608520',
                                                                                                'out_ucast_pkts': '38700448'}],
                                                                       'mac_address': '4c:5e:0c:8f:40:99',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1202608520',
                                                                       'out_ucast_pkts': '38700448',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '927253',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -116.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'snr': 58.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:f8:b3:a0:8f:8f',
                                                                                                        '4c:5e:0c:8f:40:98'],
                                                                       'id': '2',
                                                                       'in_octets': '1202608520',
                                                                       'in_ucast_pkts': '38700448',
                                                                       'mac_address': '4c:5e:0c:8f:40:98',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4054125712',
                                                                       'out_ucast_pkts': '55017271',
                                                                       'poller_hash': 'NGM1ZTBjOGY0MDk5ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.29',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Al Tucker',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:8f:40:98'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4104210481',
                                                                       'in_ucast_pkts': '8137515',
                                                                       'links': [       {       'in_octets': '4104210481',
                                                                                                'in_ucast_pkts': '8137515',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '1638768623',
                                                                                                'out_ucast_pkts': '4347949'}],
                                                                       'mac_address': '4c:5e:0c:4b:11:79',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1638768623',
                                                                       'out_ucast_pkts': '4347949',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216921',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -117.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'snr': 55.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '4c:5e:0c:4b:11:78',
                                                                                                        'bc:a5:11:dc:45:0f'],
                                                                       'id': '2',
                                                                       'in_octets': '1638768623',
                                                                       'in_ucast_pkts': '4347949',
                                                                       'mac_address': '4c:5e:0c:4b:11:78',
                                                                       'name': 'ether1-local',
                                                                       'oper_up': True,
                                                                       'out_octets': '4104210481',
                                                                       'out_ucast_pkts': '8137515',
                                                                       'poller_hash': 'NGM1ZTBjNGIxMTc5ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.7',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Jeana Machmuller',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:4b:11:78'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '751018208',
                                                                       'in_ucast_pkts': '985255',
                                                                       'links': [       {       'in_octets': '751018208',
                                                                                                'in_ucast_pkts': '985255',
                                                                                                'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                'out_octets': '143942150',
                                                                                                'out_ucast_pkts': '1070776'}],
                                                                       'mac_address': '08:55:31:38:97:af',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '143942150',
                                                                       'out_ucast_pkts': '1070776',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '216935',
                                                                                                                                                     'mac_address': '4c:5e:0c:89:ce:28',
                                                                                                                                                     'noise_floor': -110.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'snr': 58.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-PUEBLO'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:55:31:38:97:ae',
                                                                                                        '84:d3:43:90:07:65'],
                                                                       'id': '2',
                                                                       'in_octets': '143942150',
                                                                       'in_ucast_pkts': '1070776',
                                                                       'mac_address': '08:55:31:38:97:ae',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '751018208',
                                                                       'out_ucast_pkts': '985255',
                                                                       'poller_hash': 'MDg1NTMxMzg5N2FmZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.41.3',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'RBMetalG-52SHPacn',
                                         'name': 'igrid Bourne',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '08:55:31:38:97:ae'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_Metal_G_52SHPacn_7_5_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.Metal G-52SHPacn.7.5.01")
        exp_info = {
                'model': 'Metal G-52SHPacn',
                'rf_chan_width': 20,
                'rf_freq': 5765,
                'sta_count': 10,
                'sw_version': '7.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 12,
                'dl_en_bytes': 594143946705,
                'dl_en_packets': 467482068,
                'dl_noise_floor': None,
                'dl_rf_bytes': 593961673721,
                'dl_rf_packets': 465584493,
                'en_if_speed': 1000000000,
                'mem': 60.9130859375,
                'serial_number': 'A80909A0B2C3',
                'ssid': '58-POLE-LAVETA',
                'system_mac_address': 'b8:69:f4:d5:65:ac',
                'temperature': 31.0,
                'ul_en_bytes': 61487907165,
                'ul_en_packets': 300967340,
                'ul_noise_floor': -113.0,
                'ul_rf_bytes': 61213316043,
                'ul_rf_packets': 299435054
        }
        exp_sta_stats = {
                '08:55:31:38:97:bb': {       'alt_macs': {'08:55:31:38:97:ba'},
                                             'dev_macs': {'e8:9f:80:a9:9b:f3'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -112.0,
                                             'dl_rf_bytes': 2262191147,
                                             'dl_rf_packets': 11459298,
                                             'dl_rssi': -72.0,
                                             'dl_snr': 40.0,
                                             'ip_address': '10.192.42.20',
                                             'mac_address': '08:55:31:38:97:bb',
                                             'name': 'Diane Preiss',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 1230779278,
                                             'ul_rf_packets': 10218136,
                                             'ul_rssi': -72.0,
                                             'ul_snr': 41.0},
                '4c:5e:0c:89:f9:cf': {       'alt_macs': {'4c:5e:0c:89:f9:ce'},
                                             'dev_macs': {'00:24:b2:0b:83:25'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -114.0,
                                             'dl_rf_bytes': 1317456397,
                                             'dl_rf_packets': 54277358,
                                             'dl_rssi': -68.0,
                                             'dl_snr': 46.0,
                                             'ip_address': '10.192.42.3',
                                             'mac_address': '4c:5e:0c:89:f9:cf',
                                             'name': 'Rich Stromberg',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -112.0,
                                             'ul_rf_bytes': 2235612777,
                                             'ul_rf_packets': 35747583,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 53.0},
                '4c:5e:0c:8e:bd:12': {       'alt_macs': {'4c:5e:0c:8e:bd:11'},
                                             'dev_macs': {'c4:04:15:96:80:89'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -112.0,
                                             'dl_rf_bytes': 1369578681,
                                             'dl_rf_packets': 28147107,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 57.0,
                                             'ip_address': '10.192.42.14',
                                             'mac_address': '4c:5e:0c:8e:bd:12',
                                             'name': 'Deborah Clements',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 1717572025,
                                             'ul_rf_packets': 9756770,
                                             'ul_rssi': -45.0,
                                             'ul_snr': 68.0},
                '4c:5e:0c:8f:40:b9': {       'alt_macs': {'4c:5e:0c:8f:40:b8'},
                                             'dev_macs': {'94:10:3e:6e:12:59'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -113.0,
                                             'dl_rf_bytes': 3971599668,
                                             'dl_rf_packets': 2908956,
                                             'dl_rssi': -48.0,
                                             'dl_snr': 65.0,
                                             'ip_address': '10.192.42.16',
                                             'mac_address': '4c:5e:0c:8f:40:b9',
                                             'name': 'Larry Bailey',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 315587460,
                                             'ul_rf_packets': 2295200,
                                             'ul_rssi': -41.0,
                                             'ul_snr': 72.0},
                '6c:3b:6b:94:e2:8d': {       'alt_macs': {'6c:3b:6b:94:e2:8c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 26102595,
                                             'dl_rf_packets': 385835,
                                             'dl_rssi': -80.0,
                                             'dl_snr': None,
                                             'ip_address': '10.192.42.25',
                                             'mac_address': '6c:3b:6b:94:e2:8d',
                                             'name': 'Rafael Mendoza',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -112.0,
                                             'ul_rf_bytes': 644248765,
                                             'ul_rf_packets': 636190,
                                             'ul_rssi': -75.0,
                                             'ul_snr': 37.0},
                '6c:3b:6b:ab:b8:c4': {       'alt_macs': {'6c:3b:6b:ab:b8:c3'},
                                             'dev_macs': {'3c:37:86:f7:97:ec'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -114.0,
                                             'dl_rf_bytes': 991200861,
                                             'dl_rf_packets': 37496533,
                                             'dl_rssi': -70.0,
                                             'dl_snr': 44.0,
                                             'ip_address': '10.192.42.13',
                                             'mac_address': '6c:3b:6b:ab:b8:c4',
                                             'name': 'Ricahrd Sylvester',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 3530862835,
                                             'ul_rf_packets': 30961307,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 49.0},
                '74:4d:28:7e:4c:77': {       'alt_macs': {'74:4d:28:7e:4c:76'},
                                             'dev_macs': {'00:18:f8:b7:7a:90'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -113.0,
                                             'dl_rf_bytes': 571833209,
                                             'dl_rf_packets': 32003750,
                                             'dl_rssi': -82.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.192.42.23',
                                             'mac_address': '74:4d:28:7e:4c:77',
                                             'name': 'Brian Manning',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 2951908443,
                                             'ul_rf_packets': 23826382,
                                             'ul_rssi': -82.0,
                                             'ul_snr': 31.0},
                'b8:69:f4:cc:89:9c': {       'alt_macs': {'b8:69:f4:cc:89:9b'},
                                             'dev_macs': {'b4:75:0e:c9:31:78'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -112.0,
                                             'dl_rf_bytes': 2376403793,
                                             'dl_rf_packets': 5006811,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 49.0,
                                             'ip_address': '10.192.42.21',
                                             'mac_address': 'b8:69:f4:cc:89:9c',
                                             'name': 'James Pavlick',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 585783273,
                                             'ul_rf_packets': 4175746,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 56.0},
                'b8:69:f4:d5:63:81': {       'alt_macs': {'b8:69:f4:d5:63:80'},
                                             'dev_macs': {'c4:41:1e:4b:dd:3b'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -114.0,
                                             'dl_rf_bytes': 1474305282,
                                             'dl_rf_packets': 17586165,
                                             'dl_rssi': -49.0,
                                             'dl_snr': 65.0,
                                             'ip_address': '10.192.42.6',
                                             'mac_address': 'b8:69:f4:d5:63:81',
                                             'name': 'John G Trujillo',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 1009339996,
                                             'ul_rf_packets': 7333517,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 64.0},
                'd4:ca:6d:bc:41:1b': {       'alt_macs': {'d4:ca:6d:bc:41:1a'},
                                             'dev_macs': {'48:f8:b3:11:de:f9'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -121.0,
                                             'dl_rf_bytes': 1577702409,
                                             'dl_rf_packets': 1437246,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 61.0,
                                             'ip_address': '10.192.42.17',
                                             'mac_address': 'd4:ca:6d:bc:41:1b',
                                             'name': 'Beverly Gilroy',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 215764284,
                                             'ul_rf_packets': 1212993,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 44.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 12.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '61213316043',
                                                              'in_ucast_pkts': '299435054',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '644248765',
                                                                                       'in_ucast_pkts': '636190',
                                                                                       'mac_address': '6c:3b:6b:94:e2:8d',
                                                                                       'out_octets': '26102595',
                                                                                       'out_ucast_pkts': '385835'},
                                                                               {       'in_octets': '3530862835',
                                                                                       'in_ucast_pkts': '30961307',
                                                                                       'mac_address': '6c:3b:6b:ab:b8:c4',
                                                                                       'out_octets': '991200861',
                                                                                       'out_ucast_pkts': '37496533'},
                                                                               {       'in_octets': '2951908443',
                                                                                       'in_ucast_pkts': '23826382',
                                                                                       'mac_address': '74:4d:28:7e:4c:77',
                                                                                       'out_octets': '571833209',
                                                                                       'out_ucast_pkts': '32003750'},
                                                                               {       'in_octets': '585783273',
                                                                                       'in_ucast_pkts': '4175746',
                                                                                       'mac_address': 'b8:69:f4:cc:89:9c',
                                                                                       'out_octets': '2376403793',
                                                                                       'out_ucast_pkts': '5006811'},
                                                                               {       'in_octets': '1009339996',
                                                                                       'in_ucast_pkts': '7333517',
                                                                                       'mac_address': 'b8:69:f4:d5:63:81',
                                                                                       'out_octets': '1474305282',
                                                                                       'out_ucast_pkts': '17586165'},
                                                                               {       'in_octets': '215764284',
                                                                                       'in_ucast_pkts': '1212993',
                                                                                       'mac_address': 'd4:ca:6d:bc:41:1b',
                                                                                       'out_octets': '1577702409',
                                                                                       'out_ucast_pkts': '1437246'},
                                                                               {       'in_octets': '2235612777',
                                                                                       'in_ucast_pkts': '35747583',
                                                                                       'mac_address': '4c:5e:0c:89:f9:cf',
                                                                                       'out_octets': '1317456397',
                                                                                       'out_ucast_pkts': '54277358'},
                                                                               {       'in_octets': '1717572025',
                                                                                       'in_ucast_pkts': '9756770',
                                                                                       'mac_address': '4c:5e:0c:8e:bd:12',
                                                                                       'out_octets': '1369578681',
                                                                                       'out_ucast_pkts': '28147107'},
                                                                               {       'in_octets': '315587460',
                                                                                       'in_ucast_pkts': '2295200',
                                                                                       'mac_address': '4c:5e:0c:8f:40:b9',
                                                                                       'out_octets': '3971599668',
                                                                                       'out_ucast_pkts': '2908956'},
                                                                               {       'in_octets': '1230779278',
                                                                                       'in_ucast_pkts': '10218136',
                                                                                       'mac_address': '08:55:31:38:97:bb',
                                                                                       'out_octets': '2262191147',
                                                                                       'out_ucast_pkts': '11459298'}],
                                                              'mac_address': 'b8:69:f4:d5:65:ad',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '593961673721',
                                                              'out_ucast_pkts': '465584493',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5765,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '312301',
                                                                                                                                            'mac_address': '6c:3b:6b:94:e2:8d',
                                                                                                                                            'noise_floor': -112.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'snr': 37.0},
                                                                                                                                    {       'connected_time': '1020003',
                                                                                                                                            'mac_address': '6c:3b:6b:ab:b8:c4',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'snr': 49.0},
                                                                                                                                    {       'connected_time': '481660',
                                                                                                                                            'mac_address': '74:4d:28:7e:4c:77',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -82.0,
                                                                                                                                            'snr': 31.0},
                                                                                                                                    {       'connected_time': '67372',
                                                                                                                                            'mac_address': 'b8:69:f4:cc:89:9c',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'snr': 56.0},
                                                                                                                                    {       'connected_time': '155703',
                                                                                                                                            'mac_address': 'b8:69:f4:d5:63:81',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'snr': 64.0},
                                                                                                                                    {       'connected_time': '160267',
                                                                                                                                            'mac_address': 'd4:ca:6d:bc:41:1b',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'snr': 44.0},
                                                                                                                                    {       'connected_time': '1020001',
                                                                                                                                            'mac_address': '4c:5e:0c:89:f9:cf',
                                                                                                                                            'noise_floor': -112.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 53.0},
                                                                                                                                    {       'connected_time': '1020002',
                                                                                                                                            'mac_address': '4c:5e:0c:8e:bd:12',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -45.0,
                                                                                                                                            'snr': 68.0},
                                                                                                                                    {       'connected_time': '89377',
                                                                                                                                            'mac_address': '4c:5e:0c:8f:40:b9',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -41.0,
                                                                                                                                            'snr': 72.0},
                                                                                                                                    {       'connected_time': '312307',
                                                                                                                                            'mac_address': '08:55:31:38:97:bb',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'snr': 41.0}],
                                                                                                                   'noise_floor': -113.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '58-POLE-LAVETA'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1322541',
                                                              'in_octets': '594143946705',
                                                              'in_ucast_pkts': '466159527',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b8:69:f4:d5:65:ac',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1047400',
                                                              'out_octets': '61487907165',
                                                              'out_ucast_pkts': '299919940',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 60.913086,
                                'model': 'Metal G-52SHPacn',
                                'serial_number': 'A80909A0B2C3',
                                'sw_version': '7.5',
                                'system_mac_address': 'b8:69:f4:d5:65:ac',
                                'temperature': 31.0,
                                'uptime': '1020024'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '26102595',
                                                                       'in_ucast_pkts': '385835',
                                                                       'links': [       {       'in_octets': '26102595',
                                                                                                'in_ucast_pkts': '385835',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '644248765',
                                                                                                'out_ucast_pkts': '636190'}],
                                                                       'mac_address': '6c:3b:6b:94:e2:8d',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '644248765',
                                                                       'out_ucast_pkts': '636190',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '312301',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '644248765',
                                                                       'in_ucast_pkts': '636190',
                                                                       'mac_address': '6c:3b:6b:94:e2:8c',
                                                                       'name': 'ether1',
                                                                       'out_octets': '26102595',
                                                                       'out_ucast_pkts': '385835',
                                                                       'poller_hash': 'NmMzYjZiOTRlMjhkZXRoZXIx'}],
                                         'management_ip': '10.192.42.25',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Rafael Mendoza',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:94:e2:8c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '991200861',
                                                                       'in_ucast_pkts': '37496533',
                                                                       'links': [       {       'in_octets': '991200861',
                                                                                                'in_ucast_pkts': '37496533',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '3530862835',
                                                                                                'out_ucast_pkts': '30961307'}],
                                                                       'mac_address': '6c:3b:6b:ab:b8:c4',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3530862835',
                                                                       'out_ucast_pkts': '30961307',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1020003',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -114.0,
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'snr': 44.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '3c:37:86:f7:97:ec',
                                                                                                        '6c:3b:6b:ab:b8:c3'],
                                                                       'id': '2',
                                                                       'in_octets': '3530862835',
                                                                       'in_ucast_pkts': '30961307',
                                                                       'mac_address': '6c:3b:6b:ab:b8:c3',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '991200861',
                                                                       'out_ucast_pkts': '37496533',
                                                                       'poller_hash': 'NmMzYjZiYWJiOGM0ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.13',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Ricahrd Sylvester',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '6c:3b:6b:ab:b8:c3'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '571833209',
                                                                       'in_ucast_pkts': '32003750',
                                                                       'links': [       {       'in_octets': '571833209',
                                                                                                'in_ucast_pkts': '32003750',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '2951908443',
                                                                                                'out_ucast_pkts': '23826382'}],
                                                                       'mac_address': '74:4d:28:7e:4c:77',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2951908443',
                                                                       'out_ucast_pkts': '23826382',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '481660',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -113.0,
                                                                                                                                                     'rssi': -82.0,
                                                                                                                                                     'snr': 31.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:18:f8:b7:7a:90',
                                                                                                        '74:4d:28:7e:4c:76'],
                                                                       'id': '2',
                                                                       'in_octets': '2951908443',
                                                                       'in_ucast_pkts': '23826382',
                                                                       'mac_address': '74:4d:28:7e:4c:76',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '571833209',
                                                                       'out_ucast_pkts': '32003750',
                                                                       'poller_hash': 'NzQ0ZDI4N2U0Yzc3ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.23',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal G-52SHPacn',
                                         'name': 'Brian Manning',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '74:4d:28:7e:4c:76'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2376403793',
                                                                       'in_ucast_pkts': '5006811',
                                                                       'links': [       {       'in_octets': '2376403793',
                                                                                                'in_ucast_pkts': '5006811',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '585783273',
                                                                                                'out_ucast_pkts': '4175746'}],
                                                                       'mac_address': 'b8:69:f4:cc:89:9c',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '585783273',
                                                                       'out_ucast_pkts': '4175746',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '67372',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -112.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'snr': 49.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:75:0e:c9:31:78'],
                                                                       'id': '2',
                                                                       'in_octets': '585783273',
                                                                       'in_ucast_pkts': '4175746',
                                                                       'mac_address': 'b8:69:f4:cc:89:9b',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2376403793',
                                                                       'out_ucast_pkts': '5006811',
                                                                       'poller_hash': 'Yjg2OWY0Y2M4OTljZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.21',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'James Pavlick',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'b8:69:f4:cc:89:9b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1474305282',
                                                                       'in_ucast_pkts': '17586165',
                                                                       'links': [       {       'in_octets': '1474305282',
                                                                                                'in_ucast_pkts': '17586165',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '1009339996',
                                                                                                'out_ucast_pkts': '7333517'}],
                                                                       'mac_address': 'b8:69:f4:d5:63:81',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1009339996',
                                                                       'out_ucast_pkts': '7333517',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '155703',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -114.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'snr': 65.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:69:f4:d5:63:80',
                                                                                                        'c4:41:1e:4b:dd:3b'],
                                                                       'id': '2',
                                                                       'in_octets': '1009339996',
                                                                       'in_ucast_pkts': '7333517',
                                                                       'mac_address': 'b8:69:f4:d5:63:80',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1474305282',
                                                                       'out_ucast_pkts': '17586165',
                                                                       'poller_hash': 'Yjg2OWY0ZDU2MzgxZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.6',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal G-52SHPacn',
                                         'name': 'John G Trujillo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'b8:69:f4:d5:63:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1577702409',
                                                                       'in_ucast_pkts': '1437246',
                                                                       'links': [       {       'in_octets': '1577702409',
                                                                                                'in_ucast_pkts': '1437246',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '215764284',
                                                                                                'out_ucast_pkts': '1212993'}],
                                                                       'mac_address': 'd4:ca:6d:bc:41:1b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '215764284',
                                                                       'out_ucast_pkts': '1212993',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '160267',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -121.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'snr': 61.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:f8:b3:11:de:f9',
                                                                                                        'd4:ca:6d:bc:41:1a'],
                                                                       'id': '2',
                                                                       'in_octets': '215764284',
                                                                       'in_ucast_pkts': '1212993',
                                                                       'mac_address': 'd4:ca:6d:bc:41:1a',
                                                                       'name': 'ether2',
                                                                       'oper_up': True,
                                                                       'out_octets': '1577702409',
                                                                       'out_ucast_pkts': '1437246',
                                                                       'poller_hash': 'ZDRjYTZkYmM0MTFiZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.17',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Groove 52HPn',
                                         'name': 'Beverly Gilroy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': 'd4:ca:6d:bc:41:1a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1317456397',
                                                                       'in_ucast_pkts': '54277358',
                                                                       'links': [       {       'in_octets': '1317456397',
                                                                                                'in_ucast_pkts': '54277358',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '2235612777',
                                                                                                'out_ucast_pkts': '35747583'}],
                                                                       'mac_address': '4c:5e:0c:89:f9:cf',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2235612777',
                                                                       'out_ucast_pkts': '35747583',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1020001',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -114.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'snr': 46.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:24:b2:0b:83:25',
                                                                                                        '4c:5e:0c:89:f9:ce'],
                                                                       'id': '2',
                                                                       'in_octets': '2235612777',
                                                                       'in_ucast_pkts': '35747583',
                                                                       'mac_address': '4c:5e:0c:89:f9:ce',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1317456397',
                                                                       'out_ucast_pkts': '54277358',
                                                                       'poller_hash': 'NGM1ZTBjODlmOWNmZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.3',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Rich Stromberg',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:89:f9:ce'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1369578681',
                                                                       'in_ucast_pkts': '28147107',
                                                                       'links': [       {       'in_octets': '1369578681',
                                                                                                'in_ucast_pkts': '28147107',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '1717572025',
                                                                                                'out_ucast_pkts': '9756770'}],
                                                                       'mac_address': '4c:5e:0c:8e:bd:12',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1717572025',
                                                                       'out_ucast_pkts': '9756770',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1020002',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -112.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'snr': 57.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '4c:5e:0c:8e:bd:11',
                                                                                                        'c4:04:15:96:80:89'],
                                                                       'id': '2',
                                                                       'in_octets': '1717572025',
                                                                       'in_ucast_pkts': '9756770',
                                                                       'mac_address': '4c:5e:0c:8e:bd:11',
                                                                       'name': 'ether1-local',
                                                                       'oper_up': True,
                                                                       'out_octets': '1369578681',
                                                                       'out_ucast_pkts': '28147107',
                                                                       'poller_hash': 'NGM1ZTBjOGViZDEyZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.14',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Deborah Clements',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:8e:bd:11'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3971599668',
                                                                       'in_ucast_pkts': '2908956',
                                                                       'links': [       {       'in_octets': '3971599668',
                                                                                                'in_ucast_pkts': '2908956',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '315587460',
                                                                                                'out_ucast_pkts': '2295200'}],
                                                                       'mac_address': '4c:5e:0c:8f:40:b9',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '315587460',
                                                                       'out_ucast_pkts': '2295200',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '89377',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -113.0,
                                                                                                                                                     'rssi': -48.0,
                                                                                                                                                     'snr': 65.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '4c:5e:0c:8f:40:b8',
                                                                                                        '94:10:3e:6e:12:59'],
                                                                       'id': '2',
                                                                       'in_octets': '315587460',
                                                                       'in_ucast_pkts': '2295200',
                                                                       'mac_address': '4c:5e:0c:8f:40:b8',
                                                                       'name': 'ether1-local',
                                                                       'oper_up': True,
                                                                       'out_octets': '3971599668',
                                                                       'out_ucast_pkts': '2908956',
                                                                       'poller_hash': 'NGM1ZTBjOGY0MGI5ZXRoZXIx',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.192.42.16',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'Metal 5SHPn',
                                         'name': 'Larry Bailey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '4c:5e:0c:8f:40:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2262191147',
                                                                       'in_ucast_pkts': '11459298',
                                                                       'links': [       {       'in_octets': '2262191147',
                                                                                                'in_ucast_pkts': '11459298',
                                                                                                'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                'out_octets': '1230779278',
                                                                                                'out_ucast_pkts': '10218136'}],
                                                                       'mac_address': '08:55:31:38:97:bb',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1230779278',
                                                                       'out_ucast_pkts': '10218136',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '312307',
                                                                                                                                                     'mac_address': 'b8:69:f4:d5:65:ad',
                                                                                                                                                     'noise_floor': -112.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'snr': 40.0}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '58-POLE-LAVETA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:55:31:38:97:ba',
                                                                                                        'e8:9f:80:a9:9b:f3'],
                                                                       'id': '2',
                                                                       'in_octets': '1230779278',
                                                                       'in_ucast_pkts': '10218136',
                                                                       'mac_address': '08:55:31:38:97:ba',
                                                                       'name': 'ether1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2262191147',
                                                                       'out_ucast_pkts': '11459298',
                                                                       'poller_hash': 'MDg1NTMxMzg5N2JiZXRoZXIx',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.192.42.20',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'RBMetalG-52SHPacn',
                                         'name': 'Diane Preiss',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.5',
                                         'system_mac_address': '08:55:31:38:97:ba'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB2011UiAS_2HnD_6_43_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB2011UiAS-2HnD.6.43.8.01")
        exp_info = {
                'model': 'RB2011UiAS-2HnD',
                'rf_chan_width': 20,
                'rf_freq': 2412,
                'sta_count': 0,
                'sw_version': '6.43.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 6,
                'dl_en_bytes': 2659900437617,
                'dl_en_packets': 3090543130,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 18.170166015625,
                'serial_number': '6F4B05CFAEA9',
                'ssid': 'ccc@751',
                'system_mac_address': 'e4:8d:8c:0b:b1:6f',
                'temperature': 11.0,
                'ul_en_bytes': 2670944865063,
                'ul_en_packets': 3213306660,
                'ul_noise_floor': -95.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2447476029881',
                                                              'in_ucast_pkts': '1850696582',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:6f',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '212766856186',
                                                              'out_ucast_pkts': '1242351912',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:6a',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1875995623',
                                                              'in_ucast_pkts': '10364488',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:70',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '21043378347',
                                                              'out_ucast_pkts': '46333738',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:71',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '63412575464',
                                                              'in_ucast_pkts': '314348275',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:72',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '610857767394',
                                                              'out_ucast_pkts': '473729179',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '17',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '33191927849',
                                                              'in_ucast_pkts': '218579105',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:73',
                                                              'mtu': 1500,
                                                              'name': 'ether9',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '425099983506',
                                                              'out_ucast_pkts': '348559427',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '18',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:74',
                                                              'mtu': 1500,
                                                              'name': 'ether10',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '19',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:75',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2412,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ccc@751'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '90490832048',
                                                              'in_ucast_pkts': '567223752',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:6e',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1192989634450',
                                                              'out_ucast_pkts': '896681497',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '23453076752',
                                                              'in_ucast_pkts': '129330928',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd4:ca:6d:fc:33:74',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '208187245180',
                                                              'out_ucast_pkts': '205650907',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:6c',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:0b:b1:6b',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 18.170166,
                                'model': 'RB2011UiAS-2HnD',
                                'serial_number': '6F4B05CFAEA9',
                                'sw_version': '6.43.8',
                                'system_mac_address': 'e4:8d:8c:0b:b1:6f',
                                'temperature': 11.0,
                                'uptime': '1555088'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB2011UiAS_2HnD_r2_6_43_7_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB2011UiAS-2HnD r2.6.43.7.01")
        exp_info = {
                'model': 'RB2011UiAS-2HnD r2',
                'rf_chan_width': 20,
                'rf_freq': 2412,
                'sta_count': 0,
                'sw_version': '6.43.7',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 8,
                'dl_en_bytes': 7012583616608,
                'dl_en_packets': 8341877945,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 26.0009765625,
                'serial_number': '91DF09E31415',
                'ssid': 'MobileComm',
                'system_mac_address': 'e4:8d:8c:3d:e8:8c',
                'temperature': 20.0,
                'ul_en_bytes': 7030238778106,
                'ul_en_packets': 8488755244,
                'ul_noise_floor': -95.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 8.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:8c',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '10',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1985997576',
                                                              'in_ucast_pkts': '8868487',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:95',
                                                              'mtu': 1500,
                                                              'name': 'ether9',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '10775375199',
                                                              'out_ucast_pkts': '57200912',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:96',
                                                              'mtu': 1500,
                                                              'name': 'ether10',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b8:69:f4:6a:95:e4',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2412,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MobileComm'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '6476027828430',
                                                              'in_ucast_pkts': '4856343428',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:8d',
                                                              'mtu': 1500,
                                                              'name': 'ether1 - 22 '
                                                                      'Link 2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '546300623621',
                                                              'out_ucast_pkts': '3513472910',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1698696725',
                                                              'in_ucast_pkts': '5342475',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:8e',
                                                              'mtu': 1500,
                                                              'name': 'ether2 - 22-60 '
                                                                      'Link 1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2207835479',
                                                              'out_ucast_pkts': '28471157',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:8f',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:90',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '6',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '44782914783',
                                                              'in_ucast_pkts': '225854439',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:91',
                                                              'mtu': 1500,
                                                              'name': 'ether5 - Steve '
                                                                      'Daves',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '358040809703',
                                                              'out_ucast_pkts': '342601916',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '488088179094',
                                                              'in_ucast_pkts': '3245469116',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:92',
                                                              'mtu': 1500,
                                                              'name': 'ether6 - 22 AP',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '6112914134104',
                                                              'out_ucast_pkts': '4547008349',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:93',
                                                              'mtu': 1500,
                                                              'name': 'ether7 -',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '9',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:3d:e8:94',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 26.000977,
                                'model': 'RB2011UiAS-2HnD r2',
                                'serial_number': '91DF09E31415',
                                'sw_version': '6.43.7',
                                'system_mac_address': 'e4:8d:8c:3d:e8:8c',
                                'temperature': 20.0,
                                'uptime': '14949987'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB3011UiAS_6_43_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB3011UiAS.6.43.8.01")
        exp_info = {
                'model': 'RB3011UiAS',
                'rf_chan_width': None,
                'rf_freq': 0,
                'sta_count': 0,
                'sw_version': '6.43.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 76111194510,
                'dl_en_packets': 163835507,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 3.9279937744140625,
                'serial_number': '8EEE08C33335',
                'ssid': 'ccc@751',
                'system_mac_address': 'cc:2d:e0:5c:0a:96',
                'temperature': 11.0,
                'ul_en_bytes': 75331484444,
                'ul_en_packets': 157153567,
                'ul_noise_floor': 0.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:96',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:97',
                                                              'mtu': 1500,
                                                              'name': 'sfp1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:98',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '6342174481',
                                                              'in_ucast_pkts': '32469593',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:99',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '56052139777',
                                                              'out_ucast_pkts': '43976375',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1047422',
                                                              'in_ucast_pkts': '7621',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:9a',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11431018',
                                                              'out_ucast_pkts': '74368',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '17',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '6932983990',
                                                              'in_ucast_pkts': '43382288',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:9b',
                                                              'mtu': 1500,
                                                              'name': 'ether9',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '6152290710',
                                                              'out_ucast_pkts': '38140840',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '18',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:9c',
                                                              'mtu': 1500,
                                                              'name': 'ether10',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '62834988617',
                                                              'in_ucast_pkts': '87976005',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:95',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '13115622939',
                                                              'out_ucast_pkts': '74961984',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:94',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:93',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:5c:0a:92',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd6:ca:6d:c8:ac:bd',
                                                              'name': 'wlan2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'framing': 'FIXED',
                                                                                        'frequency': 0,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': 0.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ccc@751'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 3.9279938,
                                'model': 'RB3011UiAS',
                                'serial_number': '8EEE08C33335',
                                'sw_version': '6.43.8',
                                'system_mac_address': 'cc:2d:e0:5c:0a:96',
                                'temperature': 11.0,
                                'uptime': '141747'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB4011iGS_5HacQ2HnD_6_46_6_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB4011iGS+5HacQ2HnD.6.46.6.01")
        exp_info = {
                'model': 'RB4011iGS+5HacQ2HnD',
                'rf_chan_width': 40,
                'rf_freq': 2437,
                'sta_count': 0,
                'sw_version': '6.46.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 1590169018077,
                'dl_en_packets': 2124951753,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 4.66461181640625,
                'serial_number': 'A2820AEC0674',
                'ssid': 'ccc@ccc',
                'system_mac_address': '74:4d:28:4b:08:d5',
                'temperature': 14.0,
                'ul_en_bytes': 1611610582501,
                'ul_en_packets': 2485995110,
                'ul_noise_floor': -100.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1020265',
                                                              'in_octets': '65005278393',
                                                              'in_ucast_pkts': '177941489',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d5',
                                                              'mtu': 1500,
                                                              'name': 'ether4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '88777786',
                                                              'out_octets': '197018932535',
                                                              'out_ucast_pkts': '272070627',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '10',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d7',
                                                              'mtu': 1500,
                                                              'name': 'ether6',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '14',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d6',
                                                              'mtu': 1500,
                                                              'name': 'ether5',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '738569',
                                                              'in_octets': '124817802',
                                                              'in_ucast_pkts': '738569',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:db',
                                                              'mtu': 1500,
                                                              'name': 'ether10',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '738564',
                                                              'out_octets': '118908804',
                                                              'out_ucast_pkts': '738564',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'sfp-sfpplus1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'c2ZwLXNm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '17',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:dc',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2437,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -100.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ccc@ccc'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '18',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:04:0f:1f',
                                                              'mtu': 1500,
                                                              'name': 'wlan2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d4',
                                                              'mtu': 1500,
                                                              'name': 'ether3',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d3',
                                                              'mtu': 1500,
                                                              'name': 'ether2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '86760360',
                                                              'in_octets': '1359194844485',
                                                              'in_ucast_pkts': '1208763618',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d2',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3288086',
                                                              'out_octets': '236549654029',
                                                              'out_ucast_pkts': '835524919',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '767522',
                                                              'in_octets': '88235495022',
                                                              'in_ucast_pkts': '458564473',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:da',
                                                              'mtu': 1500,
                                                              'name': 'ether9',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '89277912',
                                                              'out_octets': '860539290864',
                                                              'out_ucast_pkts': '740241239',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1252391',
                                                              'in_octets': '77608582375',
                                                              'in_ucast_pkts': '188404497',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d9',
                                                              'mtu': 1500,
                                                              'name': 'ether8',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '88793119',
                                                              'out_octets': '317383796269',
                                                              'out_ucast_pkts': '366544294',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '9',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:4d:28:4b:08:d8',
                                                              'mtu': 1500,
                                                              'name': 'ether7',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 4.664612,
                                'model': 'RB4011iGS+5HacQ2HnD',
                                'serial_number': 'A2820AEC0674',
                                'sw_version': '6.46.6',
                                'system_mac_address': '74:4d:28:4b:08:d5',
                                'temperature': 14.0,
                                'uptime': '14771240'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411_6_25_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411.6.25.01")
        exp_info = {
                'model': 'RB411',
                'rf_chan_width': None,
                'rf_freq': 2442,
                'sta_count': 5,
                'sw_version': '6.25',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 441981718560,
                'dl_en_packets': 342593895,
                'dl_noise_floor': None,
                'dl_rf_bytes': 439612583263,
                'dl_rf_packets': 339256925,
                'en_if_speed': 100000000,
                'mem': 73.57177734375,
                'serial_number': '28CF0192AE6C',
                'ssid': 'fs-ns-arnzen',
                'system_mac_address': '00:0c:42:4f:f6:db',
                'temperature': None,
                'ul_en_bytes': 46508875480,
                'ul_en_packets': 192906051,
                'ul_noise_floor': -98.0,
                'ul_rf_bytes': 45917556264,
                'ul_rf_packets': 191174320
        }
        exp_sta_stats = {
                '02:0c:42:2a:b6:86': {       'alt_macs': {'02:0c:42:2a:b6:85'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 104923773,
                                             'dl_rf_packets': 33501967,
                                             'dl_rssi': -56.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '02:0c:42:2a:b6:86',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 1357641232,
                                             'ul_rf_packets': 12218221,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 44.0},
                '02:0c:42:35:46:b6': {       'alt_macs': {'02:0c:42:35:46:b5'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1617866734,
                                             'dl_rf_packets': 16595353,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.208.27.6',
                                             'mac_address': '02:0c:42:35:46:b6',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -99.0,
                                             'ul_rf_bytes': 1783327665,
                                             'ul_rf_packets': 12969924,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 28.0},
                '02:0c:42:7f:bc:3f': {       'alt_macs': {'02:0c:42:7f:bc:3e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2752882761,
                                             'dl_rf_packets': 11415048,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '10.208.27.4',
                                             'mac_address': '02:0c:42:7f:bc:3f',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 775464296,
                                             'ul_rf_packets': 4293741,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 39.0},
                '02:0c:42:d0:67:e6': {       'alt_macs': {'02:0c:42:d0:67:e5'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2728453585,
                                             'dl_rf_packets': 2152539,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': '10.208.27.9',
                                             'mac_address': '02:0c:42:d0:67:e6',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 174936976,
                                             'ul_rf_packets': 1432043,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 37.0},
                '02:ca:6d:03:d9:b0': {       'alt_macs': {'02:ca:6d:03:d9:af'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2494395653,
                                             'dl_rf_packets': 11753254,
                                             'dl_rssi': -56.0,
                                             'dl_snr': None,
                                             'ip_address': '10.208.27.5',
                                             'mac_address': '02:ca:6d:03:d9:b0',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 857797453,
                                             'ul_rf_packets': 6292829,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 39.0}
        }
        exp_ne_msg = {
                'data': {       'errors': [       {'bad_firmware': {'code': 'BF1006'}},
                                                  {'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '441981718560',
                                                              'in_ucast_pkts': '342593895',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:0c:42:4f:f6:db',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '46508875480',
                                                              'out_ucast_pkts': '192906051',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '45917556264',
                                                              'in_ucast_pkts': '191174320',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '775464296',
                                                                                       'in_ucast_pkts': '4293741',
                                                                                       'mac_address': '02:0c:42:7f:bc:3f',
                                                                                       'out_octets': '2752882761',
                                                                                       'out_ucast_pkts': '11415048'},
                                                                               {       'in_octets': '174936976',
                                                                                       'in_ucast_pkts': '1432043',
                                                                                       'mac_address': '02:0c:42:d0:67:e6',
                                                                                       'out_octets': '2728453585',
                                                                                       'out_ucast_pkts': '2152539'},
                                                                               {       'in_octets': '1357641232',
                                                                                       'in_ucast_pkts': '12218221',
                                                                                       'mac_address': '02:0c:42:2a:b6:86',
                                                                                       'out_octets': '104923773',
                                                                                       'out_ucast_pkts': '33501967'},
                                                                               {       'in_octets': '1783327665',
                                                                                       'in_ucast_pkts': '12969924',
                                                                                       'mac_address': '02:0c:42:35:46:b6',
                                                                                       'out_octets': '1617866734',
                                                                                       'out_ucast_pkts': '16595353'},
                                                                               {       'in_octets': '857797453',
                                                                                       'in_ucast_pkts': '6292829',
                                                                                       'mac_address': '02:ca:6d:03:d9:b0',
                                                                                       'out_octets': '2494395653',
                                                                                       'out_ucast_pkts': '11753254'}],
                                                              'mac_address': '00:15:6d:65:46:f1',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '439612583263',
                                                              'out_ucast_pkts': '339256925',
                                                              'radios': [       {       'framing': 'FIXED',
                                                                                        'frequency': 2442,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '601577',
                                                                                                                                            'mac_address': '02:0c:42:7f:bc:3f',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 39.0},
                                                                                                                                    {       'connected_time': '601578',
                                                                                                                                            'mac_address': '02:0c:42:d0:67:e6',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 37.0},
                                                                                                                                    {       'connected_time': '601579',
                                                                                                                                            'mac_address': '02:0c:42:2a:b6:86',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'snr': 44.0},
                                                                                                                                    {       'connected_time': '601576',
                                                                                                                                            'mac_address': '02:0c:42:35:46:b6',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'snr': 28.0},
                                                                                                                                    {       'connected_time': '601576',
                                                                                                                                            'mac_address': '02:ca:6d:03:d9:b0',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 39.0}],
                                                                                                                   'noise_floor': -98.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'fs-ns-arnzen'}],
                                                              'speed': '11000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 73.57178,
                                'model': 'RB411',
                                'serial_number': '28CF0192AE6C',
                                'sw_version': '6.25',
                                'system_mac_address': '00:0c:42:4f:f6:db',
                                'uptime': '2186547'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2752882761',
                                                                       'in_ucast_pkts': '11415048',
                                                                       'links': [       {       'in_octets': '2752882761',
                                                                                                'in_ucast_pkts': '11415048',
                                                                                                'mac_address': '00:15:6d:65:46:f1',
                                                                                                'out_octets': '775464296',
                                                                                                'out_ucast_pkts': '4293741'}],
                                                                       'mac_address': '02:0c:42:7f:bc:3f',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '775464296',
                                                                       'out_ucast_pkts': '4293741',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 2442,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '601577',
                                                                                                                                                     'mac_address': '00:15:6d:65:46:f1'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-arnzen'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '775464296',
                                                                       'in_ucast_pkts': '4293741',
                                                                       'mac_address': '02:0c:42:7f:bc:3e',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2752882761',
                                                                       'out_ucast_pkts': '11415048',
                                                                       'poller_hash': 'MDIwYzQyN2ZiYzNmZXRoZXIx'}],
                                         'management_ip': '10.208.27.4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '02:0c:42:7f:bc:3e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2728453585',
                                                                       'in_ucast_pkts': '2152539',
                                                                       'links': [       {       'in_octets': '2728453585',
                                                                                                'in_ucast_pkts': '2152539',
                                                                                                'mac_address': '00:15:6d:65:46:f1',
                                                                                                'out_octets': '174936976',
                                                                                                'out_ucast_pkts': '1432043'}],
                                                                       'mac_address': '02:0c:42:d0:67:e6',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '174936976',
                                                                       'out_ucast_pkts': '1432043',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 2442,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '601578',
                                                                                                                                                     'mac_address': '00:15:6d:65:46:f1'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-arnzen'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '174936976',
                                                                       'in_ucast_pkts': '1432043',
                                                                       'mac_address': '02:0c:42:d0:67:e5',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2728453585',
                                                                       'out_ucast_pkts': '2152539',
                                                                       'poller_hash': 'MDIwYzQyZDA2N2U2ZXRoZXIx'}],
                                         'management_ip': '10.208.27.9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '02:0c:42:d0:67:e5'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '104923773',
                                                                       'in_ucast_pkts': '33501967',
                                                                       'links': [       {       'in_octets': '104923773',
                                                                                                'in_ucast_pkts': '33501967',
                                                                                                'mac_address': '00:15:6d:65:46:f1',
                                                                                                'out_octets': '1357641232',
                                                                                                'out_ucast_pkts': '12218221'}],
                                                                       'mac_address': '02:0c:42:2a:b6:86',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1357641232',
                                                                       'out_ucast_pkts': '12218221',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 2442,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '601579',
                                                                                                                                                     'mac_address': '00:15:6d:65:46:f1'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-arnzen'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1357641232',
                                                                       'in_ucast_pkts': '12218221',
                                                                       'mac_address': '02:0c:42:2a:b6:85',
                                                                       'name': 'ether1',
                                                                       'out_octets': '104923773',
                                                                       'out_ucast_pkts': '33501967',
                                                                       'poller_hash': 'MDIwYzQyMmFiNjg2ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '02:0c:42:2a:b6:85'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1617866734',
                                                                       'in_ucast_pkts': '16595353',
                                                                       'links': [       {       'in_octets': '1617866734',
                                                                                                'in_ucast_pkts': '16595353',
                                                                                                'mac_address': '00:15:6d:65:46:f1',
                                                                                                'out_octets': '1783327665',
                                                                                                'out_ucast_pkts': '12969924'}],
                                                                       'mac_address': '02:0c:42:35:46:b6',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1783327665',
                                                                       'out_ucast_pkts': '12969924',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 2442,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '601576',
                                                                                                                                                     'mac_address': '00:15:6d:65:46:f1'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-arnzen'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1783327665',
                                                                       'in_ucast_pkts': '12969924',
                                                                       'mac_address': '02:0c:42:35:46:b5',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1617866734',
                                                                       'out_ucast_pkts': '16595353',
                                                                       'poller_hash': 'MDIwYzQyMzU0NmI2ZXRoZXIx'}],
                                         'management_ip': '10.208.27.6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '02:0c:42:35:46:b5'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2494395653',
                                                                       'in_ucast_pkts': '11753254',
                                                                       'links': [       {       'in_octets': '2494395653',
                                                                                                'in_ucast_pkts': '11753254',
                                                                                                'mac_address': '00:15:6d:65:46:f1',
                                                                                                'out_octets': '857797453',
                                                                                                'out_ucast_pkts': '6292829'}],
                                                                       'mac_address': '02:ca:6d:03:d9:b0',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '857797453',
                                                                       'out_ucast_pkts': '6292829',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 2442,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '601576',
                                                                                                                                                     'mac_address': '00:15:6d:65:46:f1'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-arnzen'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '857797453',
                                                                       'in_ucast_pkts': '6292829',
                                                                       'mac_address': '02:ca:6d:03:d9:af',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2494395653',
                                                                       'out_ucast_pkts': '11753254',
                                                                       'poller_hash': 'MDJjYTZkMDNkOWIwZXRoZXIx'}],
                                         'management_ip': '10.208.27.5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '02:ca:6d:03:d9:af'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411_6_40_4_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411.6.40.4.01")
        exp_info = {
                'model': 'RB411',
                'rf_chan_width': 20,
                'rf_freq': 5180,
                'sta_count': 2,
                'sw_version': '6.40.4',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 9,
                'dl_en_bytes': 235353632105,
                'dl_en_packets': 349170438,
                'dl_noise_floor': None,
                'dl_rf_bytes': 234408077465,
                'dl_rf_packets': 336917475,
                'en_if_speed': 100000000,
                'mem': 76.6845703125,
                'serial_number': '35DA01427BF7',
                'ssid': 'COLI-68',
                'system_mac_address': '00:0c:42:9f:23:40',
                'temperature': None,
                'ul_en_bytes': 9736186644,
                'ul_en_packets': 91545939,
                'ul_noise_floor': -112.0,
                'ul_rf_bytes': 9343101485,
                'ul_rf_packets': 89257589
        }
        exp_sta_stats = {
                '00:0c:42:ce:7f:69': {       'alt_macs': {'00:0c:42:ce:7f:68'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 405525302,
                                             'dl_rf_packets': 85501269,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '10.50.68.40',
                                             'mac_address': '00:0c:42:ce:7f:69',
                                             'name': 'Joe Biermacher',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -112.0,
                                             'ul_rf_bytes': 141238165,
                                             'ul_rf_packets': 43129158,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 49.0},
                '4c:5e:0c:81:a4:27': {       'alt_macs': {'4c:5e:0c:81:a4:26'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1550339936,
                                             'dl_rf_packets': 60428564,
                                             'dl_rssi': -64.0,
                                             'dl_snr': None,
                                             'ip_address': '10.50.68.39',
                                             'mac_address': '4c:5e:0c:81:a4:27',
                                             'name': '17365',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -112.0,
                                             'ul_rf_bytes': 4176567742,
                                             'ul_rf_packets': 38612752,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 55.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 9.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '235353632105',
                                                              'in_ucast_pkts': '349170438',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:0c:42:9f:23:40',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '9736186644',
                                                              'out_ucast_pkts': '91545939',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '9343101485',
                                                              'in_ucast_pkts': '89257589',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '141238165',
                                                                                       'in_ucast_pkts': '43129158',
                                                                                       'mac_address': '00:0c:42:ce:7f:69',
                                                                                       'out_octets': '405525302',
                                                                                       'out_ucast_pkts': '85501269'},
                                                                               {       'in_octets': '4176567742',
                                                                                       'in_ucast_pkts': '38612752',
                                                                                       'mac_address': '4c:5e:0c:81:a4:27',
                                                                                       'out_octets': '1550339936',
                                                                                       'out_ucast_pkts': '60428564'}],
                                                              'mac_address': '00:0c:42:6c:1b:5a',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '234408077465',
                                                              'out_ucast_pkts': '336917475',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5180,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '668809',
                                                                                                                                            'mac_address': '00:0c:42:ce:7f:69',
                                                                                                                                            'noise_floor': -112.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 49.0},
                                                                                                                                    {       'connected_time': '668811',
                                                                                                                                            'mac_address': '4c:5e:0c:81:a4:27',
                                                                                                                                            'noise_floor': -112.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'snr': 55.0}],
                                                                                                                   'noise_floor': -112.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'COLI-68'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 76.68457,
                                'model': 'RB411',
                                'serial_number': '35DA01427BF7',
                                'sw_version': '6.40.4',
                                'system_mac_address': '00:0c:42:9f:23:40',
                                'uptime': '668849'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '405525302',
                                                                       'in_ucast_pkts': '85501269',
                                                                       'links': [       {       'in_octets': '405525302',
                                                                                                'in_ucast_pkts': '85501269',
                                                                                                'mac_address': '00:0c:42:6c:1b:5a',
                                                                                                'out_octets': '141238165',
                                                                                                'out_ucast_pkts': '43129158'}],
                                                                       'mac_address': '00:0c:42:ce:7f:69',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '141238165',
                                                                       'out_ucast_pkts': '43129158',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '668809',
                                                                                                                                                     'mac_address': '00:0c:42:6c:1b:5a'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COLI-68'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '141238165',
                                                                       'in_ucast_pkts': '43129158',
                                                                       'mac_address': '00:0c:42:ce:7f:68',
                                                                       'name': 'ether1',
                                                                       'out_octets': '405525302',
                                                                       'out_ucast_pkts': '85501269',
                                                                       'poller_hash': 'MDAwYzQyY2U3ZjY5ZXRoZXIx'}],
                                         'management_ip': '10.50.68.40',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Joe Biermacher',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.37.3',
                                         'system_mac_address': '00:0c:42:ce:7f:68'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1550339936',
                                                                       'in_ucast_pkts': '60428564',
                                                                       'links': [       {       'in_octets': '1550339936',
                                                                                                'in_ucast_pkts': '60428564',
                                                                                                'mac_address': '00:0c:42:6c:1b:5a',
                                                                                                'out_octets': '4176567742',
                                                                                                'out_ucast_pkts': '38612752'}],
                                                                       'mac_address': '4c:5e:0c:81:a4:27',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4176567742',
                                                                       'out_ucast_pkts': '38612752',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '668811',
                                                                                                                                                     'mac_address': '00:0c:42:6c:1b:5a'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COLI-68'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '4176567742',
                                                                       'in_ucast_pkts': '38612752',
                                                                       'mac_address': '4c:5e:0c:81:a4:26',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1550339936',
                                                                       'out_ucast_pkts': '60428564',
                                                                       'poller_hash': 'NGM1ZTBjODFhNDI3ZXRoZXIx'}],
                                         'management_ip': '10.50.68.39',
                                         'manufacturer': 'Mikrotik',
                                         'name': '17365',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.37.1',
                                         'system_mac_address': '4c:5e:0c:81:a4:26'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411_6_41_3_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411.6.41.3.01")
        exp_info = {
                'model': 'RB411',
                'rf_chan_width': 20,
                'rf_freq': 2484,
                'sta_count': 7,
                'sw_version': '6.41.3',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 7,
                'dl_en_bytes': 1109740108295,
                'dl_en_packets': 810152791,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1108292212538,
                'dl_rf_packets': 805440834,
                'en_if_speed': 100000000,
                'mem': 78.11279296875,
                'serial_number': '291301A46A37',
                'ssid': 'fs-ns-grange-tank',
                'system_mac_address': '00:0c:42:79:32:80',
                'temperature': None,
                'ul_en_bytes': 50756782810,
                'ul_en_packets': 379587354,
                'ul_noise_floor': -94.0,
                'ul_rf_bytes': 49815474971,
                'ul_rf_packets': 375787462
        }
        exp_sta_stats = {
                '02:0c:42:1e:3c:3d': {       'alt_macs': {'02:0c:42:1e:3c:3c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4290257050,
                                             'dl_rf_packets': 263739412,
                                             'dl_rssi': -50.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.18',
                                             'mac_address': '02:0c:42:1e:3c:3d',
                                             'name': 'theramirez',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -93.0,
                                             'ul_rf_bytes': 4100407877,
                                             'ul_rf_packets': 116676570,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 30.0},
                '02:0c:42:79:2a:88': {       'alt_macs': {'02:0c:42:79:2a:87'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3787314674,
                                             'dl_rf_packets': 14552584,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.20',
                                             'mac_address': '02:0c:42:79:2a:88',
                                             'name': 'grumleytrucking',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 2090378738,
                                             'ul_rf_packets': 10692255,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 29.0},
                '02:0c:42:9e:56:10': {       'alt_macs': {'02:0c:42:9e:56:0f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1076125454,
                                             'dl_rf_packets': 5510091,
                                             'dl_rssi': -57.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.41',
                                             'mac_address': '02:0c:42:9e:56:10',
                                             'name': 'pcrcs',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -93.0,
                                             'ul_rf_bytes': 1842668630,
                                             'ul_rf_packets': 3758036,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 33.0},
                '02:0c:42:d0:45:0e': {       'alt_macs': {'02:0c:42:d0:45:0d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1131708893,
                                             'dl_rf_packets': 163580156,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.33',
                                             'mac_address': '02:0c:42:d0:45:0e',
                                             'name': 'kcthesan',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 2277662518,
                                             'ul_rf_packets': 64991983,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 35.0},
                '02:0c:42:d0:5c:70': {       'alt_macs': {'02:0c:42:d0:5c:6f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3821391324,
                                             'dl_rf_packets': 37876833,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.34',
                                             'mac_address': '02:0c:42:d0:5c:70',
                                             'name': 'bakertruck',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 2727599276,
                                             'ul_rf_packets': 26390699,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 30.0},
                '02:ca:6d:19:d0:c8': {       'alt_macs': {'02:ca:6d:19:d0:c7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3005740210,
                                             'dl_rf_packets': 257497535,
                                             'dl_rssi': -46.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.52',
                                             'mac_address': '02:ca:6d:19:d0:c8',
                                             'name': 'chevy',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 1854794013,
                                             'ul_rf_packets': 119245311,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 35.0},
                '02:ca:6d:9d:ec:f9': {       'alt_macs': {'02:ca:6d:9d:ec:f8'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2099116887,
                                             'dl_rf_packets': 37339189,
                                             'dl_rssi': -72.0,
                                             'dl_snr': None,
                                             'ip_address': '10.211.31.40',
                                             'mac_address': '02:ca:6d:9d:ec:f9',
                                             'name': 'mperry',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 3296483430,
                                             'ul_rf_packets': 22306405,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 20.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 7.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1109740108295',
                                                              'in_ucast_pkts': '810152791',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:0c:42:79:32:80',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '50756782810',
                                                              'out_ucast_pkts': '379587354',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '49815474971',
                                                              'in_ucast_pkts': '375787462',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2090378738',
                                                                                       'in_ucast_pkts': '10692255',
                                                                                       'mac_address': '02:0c:42:79:2a:88',
                                                                                       'out_octets': '3787314674',
                                                                                       'out_ucast_pkts': '14552584'},
                                                                               {       'in_octets': '1842668630',
                                                                                       'in_ucast_pkts': '3758036',
                                                                                       'mac_address': '02:0c:42:9e:56:10',
                                                                                       'out_octets': '1076125454',
                                                                                       'out_ucast_pkts': '5510091'},
                                                                               {       'in_octets': '2277662518',
                                                                                       'in_ucast_pkts': '64991983',
                                                                                       'mac_address': '02:0c:42:d0:45:0e',
                                                                                       'out_octets': '1131708893',
                                                                                       'out_ucast_pkts': '163580156'},
                                                                               {       'in_octets': '2727599276',
                                                                                       'in_ucast_pkts': '26390699',
                                                                                       'mac_address': '02:0c:42:d0:5c:70',
                                                                                       'out_octets': '3821391324',
                                                                                       'out_ucast_pkts': '37876833'},
                                                                               {       'in_octets': '4100407877',
                                                                                       'in_ucast_pkts': '116676570',
                                                                                       'mac_address': '02:0c:42:1e:3c:3d',
                                                                                       'out_octets': '4290257050',
                                                                                       'out_ucast_pkts': '263739412'},
                                                                               {       'in_octets': '3296483430',
                                                                                       'in_ucast_pkts': '22306405',
                                                                                       'mac_address': '02:ca:6d:9d:ec:f9',
                                                                                       'out_octets': '2099116887',
                                                                                       'out_ucast_pkts': '37339189'},
                                                                               {       'in_octets': '1854794013',
                                                                                       'in_ucast_pkts': '119245311',
                                                                                       'mac_address': '02:ca:6d:19:d0:c8',
                                                                                       'out_octets': '3005740210',
                                                                                       'out_ucast_pkts': '257497535'}],
                                                              'mac_address': '00:80:48:71:10:59',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1108292212538',
                                                              'out_ucast_pkts': '805440834',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2484,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2083325',
                                                                                                                                            'mac_address': '02:0c:42:79:2a:88',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 29.0},
                                                                                                                                    {       'connected_time': '2077930',
                                                                                                                                            'mac_address': '02:0c:42:9e:56:10',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 33.0},
                                                                                                                                    {       'connected_time': '2083323',
                                                                                                                                            'mac_address': '02:0c:42:d0:45:0e',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 35.0},
                                                                                                                                    {       'connected_time': '2083319',
                                                                                                                                            'mac_address': '02:0c:42:d0:5c:70',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'snr': 30.0},
                                                                                                                                    {       'connected_time': '2083325',
                                                                                                                                            'mac_address': '02:0c:42:1e:3c:3d',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 30.0},
                                                                                                                                    {       'connected_time': '1273149',
                                                                                                                                            'mac_address': '02:ca:6d:9d:ec:f9',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'snr': 20.0},
                                                                                                                                    {       'connected_time': '2083322',
                                                                                                                                            'mac_address': '02:ca:6d:19:d0:c8',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 35.0}],
                                                                                                                   'noise_floor': -94.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'fs-ns-grange-tank'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 78.11279,
                                'model': 'RB411',
                                'serial_number': '291301A46A37',
                                'sw_version': '6.41.3',
                                'system_mac_address': '00:0c:42:79:32:80',
                                'uptime': '2083369'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3787314674',
                                                                       'in_ucast_pkts': '14552584',
                                                                       'links': [       {       'in_octets': '3787314674',
                                                                                                'in_ucast_pkts': '14552584',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '2090378738',
                                                                                                'out_ucast_pkts': '10692255'}],
                                                                       'mac_address': '02:0c:42:79:2a:88',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2090378738',
                                                                       'out_ucast_pkts': '10692255',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2083325',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2090378738',
                                                                       'in_ucast_pkts': '10692255',
                                                                       'mac_address': '02:0c:42:79:2a:87',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3787314674',
                                                                       'out_ucast_pkts': '14552584',
                                                                       'poller_hash': 'MDIwYzQyNzkyYTg4ZXRoZXIx'}],
                                         'management_ip': '10.211.31.20',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'grumleytrucking',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.41.3',
                                         'system_mac_address': '02:0c:42:79:2a:87'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1076125454',
                                                                       'in_ucast_pkts': '5510091',
                                                                       'links': [       {       'in_octets': '1076125454',
                                                                                                'in_ucast_pkts': '5510091',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '1842668630',
                                                                                                'out_ucast_pkts': '3758036'}],
                                                                       'mac_address': '02:0c:42:9e:56:10',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1842668630',
                                                                       'out_ucast_pkts': '3758036',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2077930',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1842668630',
                                                                       'in_ucast_pkts': '3758036',
                                                                       'mac_address': '02:0c:42:9e:56:0f',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1076125454',
                                                                       'out_ucast_pkts': '5510091',
                                                                       'poller_hash': 'MDIwYzQyOWU1NjEwZXRoZXIx'}],
                                         'management_ip': '10.211.31.41',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'pcrcs',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.27',
                                         'system_mac_address': '02:0c:42:9e:56:0f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1131708893',
                                                                       'in_ucast_pkts': '163580156',
                                                                       'links': [       {       'in_octets': '1131708893',
                                                                                                'in_ucast_pkts': '163580156',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '2277662518',
                                                                                                'out_ucast_pkts': '64991983'}],
                                                                       'mac_address': '02:0c:42:d0:45:0e',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2277662518',
                                                                       'out_ucast_pkts': '64991983',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2083323',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2277662518',
                                                                       'in_ucast_pkts': '64991983',
                                                                       'mac_address': '02:0c:42:d0:45:0d',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1131708893',
                                                                       'out_ucast_pkts': '163580156',
                                                                       'poller_hash': 'MDIwYzQyZDA0NTBlZXRoZXIx'}],
                                         'management_ip': '10.211.31.33',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'kcthesan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.26',
                                         'system_mac_address': '02:0c:42:d0:45:0d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3821391324',
                                                                       'in_ucast_pkts': '37876833',
                                                                       'links': [       {       'in_octets': '3821391324',
                                                                                                'in_ucast_pkts': '37876833',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '2727599276',
                                                                                                'out_ucast_pkts': '26390699'}],
                                                                       'mac_address': '02:0c:42:d0:5c:70',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2727599276',
                                                                       'out_ucast_pkts': '26390699',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2083319',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2727599276',
                                                                       'in_ucast_pkts': '26390699',
                                                                       'mac_address': '02:0c:42:d0:5c:6f',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3821391324',
                                                                       'out_ucast_pkts': '37876833',
                                                                       'poller_hash': 'MDIwYzQyZDA1YzcwZXRoZXIx'}],
                                         'management_ip': '10.211.31.34',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'bakertruck',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.26',
                                         'system_mac_address': '02:0c:42:d0:5c:6f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4290257050',
                                                                       'in_ucast_pkts': '263739412',
                                                                       'links': [       {       'in_octets': '4290257050',
                                                                                                'in_ucast_pkts': '263739412',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '4100407877',
                                                                                                'out_ucast_pkts': '116676570'}],
                                                                       'mac_address': '02:0c:42:1e:3c:3d',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4100407877',
                                                                       'out_ucast_pkts': '116676570',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2083325',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '4100407877',
                                                                       'in_ucast_pkts': '116676570',
                                                                       'mac_address': '02:0c:42:1e:3c:3c',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4290257050',
                                                                       'out_ucast_pkts': '263739412',
                                                                       'poller_hash': 'MDIwYzQyMWUzYzNkZXRoZXIx'}],
                                         'management_ip': '10.211.31.18',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'theramirez',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.42.10',
                                         'system_mac_address': '02:0c:42:1e:3c:3c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2099116887',
                                                                       'in_ucast_pkts': '37339189',
                                                                       'links': [       {       'in_octets': '2099116887',
                                                                                                'in_ucast_pkts': '37339189',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '3296483430',
                                                                                                'out_ucast_pkts': '22306405'}],
                                                                       'mac_address': '02:ca:6d:9d:ec:f9',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3296483430',
                                                                       'out_ucast_pkts': '22306405',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1273149',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3296483430',
                                                                       'in_ucast_pkts': '22306405',
                                                                       'mac_address': '02:ca:6d:9d:ec:f8',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2099116887',
                                                                       'out_ucast_pkts': '37339189',
                                                                       'poller_hash': 'MDJjYTZkOWRlY2Y5ZXRoZXIx'}],
                                         'management_ip': '10.211.31.40',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'mperry',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.41.3',
                                         'system_mac_address': '02:ca:6d:9d:ec:f8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3005740210',
                                                                       'in_ucast_pkts': '257497535',
                                                                       'links': [       {       'in_octets': '3005740210',
                                                                                                'in_ucast_pkts': '257497535',
                                                                                                'mac_address': '00:80:48:71:10:59',
                                                                                                'out_octets': '1854794013',
                                                                                                'out_ucast_pkts': '119245311'}],
                                                                       'mac_address': '02:ca:6d:19:d0:c8',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1854794013',
                                                                       'out_ucast_pkts': '119245311',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2484,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2083322',
                                                                                                                                                     'mac_address': '00:80:48:71:10:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'fs-ns-grange-tank'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1854794013',
                                                                       'in_ucast_pkts': '119245311',
                                                                       'mac_address': '02:ca:6d:19:d0:c7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3005740210',
                                                                       'out_ucast_pkts': '257497535',
                                                                       'poller_hash': 'MDJjYTZkMTlkMGM4ZXRoZXIx'}],
                                         'management_ip': '10.211.31.52',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'chevy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.27',
                                         'system_mac_address': '02:ca:6d:19:d0:c7'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_5_26_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.5.26.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': None,
                'rf_freq': 5200,
                'sta_count': 2,
                'sw_version': '5.26',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 11110846578709,
                'dl_en_packets': 12855617485,
                'dl_noise_floor': None,
                'dl_rf_bytes': 11082359859221,
                'dl_rf_packets': 12657793677,
                'en_if_speed': 100000000,
                'mem': 24.10266306445388,
                'serial_number': None,
                'ssid': 'ptp-ncwt-courthouse',
                'system_mac_address': 'd4:ca:6d:60:0b:74',
                'temperature': None,
                'ul_en_bytes': 5761317758518,
                'ul_en_packets': 11257686535,
                'ul_noise_floor': -98.0,
                'ul_rf_bytes': 5737394018674,
                'ul_rf_packets': 11016109833
        }
        exp_sta_stats = {
                '00:15:6d:6a:dc:b8': {       'alt_macs': {'00:15:6d:6a:dc:b7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1293122,
                                             'dl_rf_packets': 6577,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:6a:dc:b8',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 743021,
                                             'ul_rf_packets': 3511,
                                             'ul_rssi': -73.0,
                                             'ul_snr': 25.0},
                '00:15:6d:6b:e4:23': {       'alt_macs': {'00:15:6d:6b:e4:22'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1298683752,
                                             'dl_rf_packets': 61264647,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:6b:e4:23',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 184605740,
                                             'ul_rf_packets': 49910732,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 38.0}
        }
        exp_ne_msg = {
                'data': {       'errors': [       {'bad_firmware': {'code': 'BF1006'}},
                                                  {'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '11110846578709',
                                                              'in_ucast_pkts': '12855617485',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd4:ca:6d:60:0b:74',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5761317758518',
                                                              'out_ucast_pkts': '11257686535',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '5737394018674',
                                                              'in_ucast_pkts': '11016109833',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '743021',
                                                                                       'in_ucast_pkts': '3511',
                                                                                       'mac_address': '00:15:6d:6a:dc:b8',
                                                                                       'out_octets': '1293122',
                                                                                       'out_ucast_pkts': '6577'},
                                                                               {       'in_octets': '184605740',
                                                                                       'in_ucast_pkts': '49910732',
                                                                                       'mac_address': '00:15:6d:6b:e4:23',
                                                                                       'out_octets': '1298683752',
                                                                                       'out_ucast_pkts': '61264647'}],
                                                              'mac_address': '00:15:6d:6b:5b:41',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11082359859221',
                                                              'out_ucast_pkts': '12657793677',
                                                              'radios': [       {       'framing': 'FIXED',
                                                                                        'frequency': 5200,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '660',
                                                                                                                                            'mac_address': '00:15:6d:6a:dc:b8',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'snr': 25.0},
                                                                                                                                    {       'connected_time': '178316',
                                                                                                                                            'mac_address': '00:15:6d:6b:e4:23',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 38.0}],
                                                                                                                   'noise_floor': -98.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ptp-ncwt-courthouse'}],
                                                              'speed': '11000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 24.102663,
                                'model': 'RB411AH',
                                'sw_version': '5.26',
                                'system_mac_address': 'd4:ca:6d:60:0b:74',
                                'uptime': '20470465'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1293122',
                                                                       'in_ucast_pkts': '6577',
                                                                       'links': [       {       'in_octets': '1293122',
                                                                                                'in_ucast_pkts': '6577',
                                                                                                'mac_address': '00:15:6d:6b:5b:41',
                                                                                                'out_octets': '743021',
                                                                                                'out_ucast_pkts': '3511'}],
                                                                       'mac_address': '00:15:6d:6a:dc:b8',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '743021',
                                                                       'out_ucast_pkts': '3511',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660',
                                                                                                                                                     'mac_address': '00:15:6d:6b:5b:41'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ptp-ncwt-courthouse'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '743021',
                                                                       'in_ucast_pkts': '3511',
                                                                       'mac_address': '00:15:6d:6a:dc:b7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1293122',
                                                                       'out_ucast_pkts': '6577',
                                                                       'poller_hash': 'MDAxNTZkNmFkY2I4ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:6a:dc:b7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1298683752',
                                                                       'in_ucast_pkts': '61264647',
                                                                       'links': [       {       'in_octets': '1298683752',
                                                                                                'in_ucast_pkts': '61264647',
                                                                                                'mac_address': '00:15:6d:6b:5b:41',
                                                                                                'out_octets': '184605740',
                                                                                                'out_ucast_pkts': '49910732'}],
                                                                       'mac_address': '00:15:6d:6b:e4:23',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '184605740',
                                                                       'out_ucast_pkts': '49910732',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '178316',
                                                                                                                                                     'mac_address': '00:15:6d:6b:5b:41'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ptp-ncwt-courthouse'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '184605740',
                                                                       'in_ucast_pkts': '49910732',
                                                                       'mac_address': '00:15:6d:6b:e4:22',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1298683752',
                                                                       'out_ucast_pkts': '61264647',
                                                                       'poller_hash': 'MDAxNTZkNmJlNDIzZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:6b:e4:22'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_23_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.23.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': None,
                'rf_freq': 5220,
                'sta_count': 20,
                'sw_version': '6.23',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 49628147343069,
                'dl_en_packets': 37936868635,
                'dl_noise_floor': None,
                'dl_rf_bytes': 49584058989745,
                'dl_rf_packets': 37888334961,
                'en_if_speed': 100000000,
                'mem': 46.6064453125,
                'serial_number': '36D802D91C44',
                'ssid': 'BroadbandVI_SolW_NV2_v',
                'system_mac_address': 'd4:ca:6d:77:12:55',
                'temperature': None,
                'ul_en_bytes': 6025960747131,
                'ul_en_packets': 26652375532,
                'ul_noise_floor': -115.0,
                'ul_rf_bytes': 6023065999204,
                'ul_rf_packets': 26663325076
        }
        exp_sta_stats = {
                '00:0c:42:df:26:bf': {       'alt_macs': {'00:0c:42:df:26:be'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 6830791,
                                             'dl_rf_packets': 13428,
                                             'dl_rssi': -49.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.237',
                                             'mac_address': '00:0c:42:df:26:bf',
                                             'name': 'Andrea/Harrison Klaus/Royer',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 2179113,
                                             'ul_rf_packets': 16641,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 57.0},
                '00:0c:42:ec:4c:30': {       'alt_macs': {'00:0c:42:ec:4c:2f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 619763564,
                                             'dl_rf_packets': 502518,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.192',
                                             'mac_address': '00:0c:42:ec:4c:30',
                                             'name': 'Harris Main House 21931',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 40839399,
                                             'ul_rf_packets': 292925,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 59.0},
                '00:0c:42:ee:26:34': {       'alt_macs': {'00:0c:42:ee:26:33'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 641592,
                                             'dl_rf_packets': 3518,
                                             'dl_rssi': -72.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.182',
                                             'mac_address': '00:0c:42:ee:26:34',
                                             'name': 'Pete & Sandy Obremskey',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 527790,
                                             'ul_rf_packets': 5229,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 48.0},
                '00:0c:42:f0:82:c3': {       'alt_macs': {'00:0c:42:f0:82:c2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 25606747,
                                             'dl_rf_packets': 18155,
                                             'dl_rssi': -72.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.208',
                                             'mac_address': '00:0c:42:f0:82:c3',
                                             'name': 'Elizabeth Kliesh 26665',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 1481281,
                                             'ul_rf_packets': 13146,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 44.0},
                '4c:5e:0c:11:38:a8': {       'alt_macs': {'4c:5e:0c:11:38:a7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 229072026,
                                             'dl_rf_packets': 117730312,
                                             'dl_rssi': -75.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '4c:5e:0c:11:38:a8',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 1677676515,
                                             'ul_rf_packets': 88036614,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 43.0},
                '4c:5e:0c:81:ca:25': {       'alt_macs': {'4c:5e:0c:81:ca:24'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 31990350,
                                             'dl_rf_packets': 40425,
                                             'dl_rssi': -55.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.221',
                                             'mac_address': '4c:5e:0c:81:ca:25',
                                             'name': 'Michael Strasberg 31675',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 3712721,
                                             'ul_rf_packets': 35752,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 58.0},
                '4c:5e:0c:82:3c:49': {       'alt_macs': {'4c:5e:0c:82:3c:48'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 131793092,
                                             'dl_rf_packets': 79968672,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.154',
                                             'mac_address': '4c:5e:0c:82:3c:49',
                                             'name': 'Amy Land-De-Wilde 23304',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 1143884780,
                                             'ul_rf_packets': 43602420,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 57.0},
                '4c:5e:0c:85:55:4b': {       'alt_macs': {'4c:5e:0c:85:55:4a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 35798,
                                             'dl_rf_packets': 396,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.181',
                                             'mac_address': '4c:5e:0c:85:55:4b',
                                             'name': 'Eliazbeth Kliesch 30213',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -116.0,
                                             'ul_rf_bytes': 231164,
                                             'ul_rf_packets': 1377,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 55.0},
                '4c:5e:0c:87:90:8d': {       'alt_macs': {'4c:5e:0c:87:90:8c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 20326247,
                                             'dl_rf_packets': 20657,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.211',
                                             'mac_address': '4c:5e:0c:87:90:8d',
                                             'name': 'Jeffrey Glaze 35648',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 3412139,
                                             'ul_rf_packets': 20776,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 63.0},
                '4c:5e:0c:87:91:9d': {       'alt_macs': {'4c:5e:0c:87:91:9c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 309489,
                                             'dl_rf_packets': 3215,
                                             'dl_rssi': -82.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.166',
                                             'mac_address': '4c:5e:0c:87:91:9d',
                                             'name': 'Lorine Williams 24232',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 506665,
                                             'ul_rf_packets': 2889,
                                             'ul_rssi': -75.0,
                                             'ul_snr': 39.0},
                '4c:5e:0c:87:ae:7f': {       'alt_macs': {'4c:5e:0c:87:ae:7e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 28348,
                                             'dl_rf_packets': 335,
                                             'dl_rssi': -69.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.151',
                                             'mac_address': '4c:5e:0c:87:ae:7f',
                                             'name': 'Lucia Dunderman',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 217825,
                                             'ul_rf_packets': 1338,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 52.0},
                '4c:5e:0c:8b:56:c5': {       'alt_macs': {'4c:5e:0c:8b:56:c4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 373546,
                                             'dl_rf_packets': 1624,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.232',
                                             'mac_address': '4c:5e:0c:8b:56:c5',
                                             'name': ' Harrison Royer Downstairs',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -116.0,
                                             'ul_rf_bytes': 370860,
                                             'ul_rf_packets': 2863,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 69.0},
                '4c:5e:0c:8b:b0:e3': {       'alt_macs': {'4c:5e:0c:8b:b0:e2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 7682460,
                                             'dl_rf_packets': 7789,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.231',
                                             'mac_address': '4c:5e:0c:8b:b0:e3',
                                             'name': 'Charles Ferris',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -116.0,
                                             'ul_rf_bytes': 1335800,
                                             'ul_rf_packets': 8299,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 62.0},
                '4c:5e:0c:8b:e4:cf': {       'alt_macs': {'4c:5e:0c:8b:e4:ce'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 45589489,
                                             'dl_rf_packets': 59602,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.160',
                                             'mac_address': '4c:5e:0c:8b:e4:cf',
                                             'name': 'Brad Bockus 35655',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 11763760,
                                             'ul_rf_packets': 51938,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 51.0},
                'e4:8d:8c:11:14:d7': {       'alt_macs': {'e4:8d:8c:11:14:d6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 13334577,
                                             'dl_rf_packets': 14669,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.196',
                                             'mac_address': 'e4:8d:8c:11:14:d7',
                                             'name': 'Christopher Gangel 36825',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 3620649,
                                             'ul_rf_packets': 13171,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 57.0},
                'e4:8d:8c:f2:2b:15': {       'alt_macs': {'e4:8d:8c:f2:2b:14'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 872308218,
                                             'dl_rf_packets': 615422,
                                             'dl_rssi': -67.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.162',
                                             'mac_address': 'e4:8d:8c:f2:2b:15',
                                             'name': 'Matt Palazzola',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 35143222,
                                             'ul_rf_packets': 275563,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 52.0},
                'e4:8d:8c:f6:70:26': {       'alt_macs': {'e4:8d:8c:f6:70:25'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2800370,
                                             'dl_rf_packets': 16620,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.67',
                                             'mac_address': 'e4:8d:8c:f6:70:26',
                                             'name': 'Dusty Hill',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 12090306,
                                             'ul_rf_packets': 19106,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 58.0},
                'e4:8d:8c:fc:09:23': {       'alt_macs': {'e4:8d:8c:fc:09:22'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4061318571,
                                             'dl_rf_packets': 205300352,
                                             'dl_rssi': -50.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.194',
                                             'mac_address': 'e4:8d:8c:fc:09:23',
                                             'name': 'BCSC Dospiva stx 21347',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 3793976016,
                                             'ul_rf_packets': 138299061,
                                             'ul_rssi': -52.0,
                                             'ul_snr': 63.0},
                'e4:8d:8c:fc:aa:81': {       'alt_macs': {'e4:8d:8c:fc:aa:80'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 376748554,
                                             'dl_rf_packets': 292159,
                                             'dl_rssi': -71.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.198',
                                             'mac_address': 'e4:8d:8c:fc:aa:81',
                                             'name': 'Cheeseburgers in Paradise 29242',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 47929367,
                                             'ul_rf_packets': 244712,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 50.0},
                'e4:8d:8c:fd:51:7b': {       'alt_macs': {'e4:8d:8c:fd:51:7a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 15733057,
                                             'dl_rf_packets': 28043,
                                             'dl_rssi': -53.0,
                                             'dl_snr': None,
                                             'ip_address': '10.107.40.167',
                                             'mac_address': 'e4:8d:8c:fd:51:7b',
                                             'name': 'Jason Miller 24485 Rental Unit',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rf_bytes': 7418528,
                                             'ul_rf_packets': 42535,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 57.0}
        }
        exp_ne_msg = {
                'data': {       'errors': [       {'bad_firmware': {'code': 'BF1006'}},
                                                  {'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '49628147343069',
                                                              'in_ucast_pkts': '37936868635',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd4:ca:6d:77:12:55',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '6025960747131',
                                                              'out_ucast_pkts': '26652375532',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '6023065999204',
                                                              'in_ucast_pkts': '26663325076',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2179113',
                                                                                       'in_ucast_pkts': '16641',
                                                                                       'mac_address': '00:0c:42:df:26:bf',
                                                                                       'out_octets': '6830791',
                                                                                       'out_ucast_pkts': '13428'},
                                                                               {       'in_octets': '40839399',
                                                                                       'in_ucast_pkts': '292925',
                                                                                       'mac_address': '00:0c:42:ec:4c:30',
                                                                                       'out_octets': '619763564',
                                                                                       'out_ucast_pkts': '502518'},
                                                                               {       'in_octets': '527790',
                                                                                       'in_ucast_pkts': '5229',
                                                                                       'mac_address': '00:0c:42:ee:26:34',
                                                                                       'out_octets': '641592',
                                                                                       'out_ucast_pkts': '3518'},
                                                                               {       'in_octets': '1481281',
                                                                                       'in_ucast_pkts': '13146',
                                                                                       'mac_address': '00:0c:42:f0:82:c3',
                                                                                       'out_octets': '25606747',
                                                                                       'out_ucast_pkts': '18155'},
                                                                               {       'in_octets': '3620649',
                                                                                       'in_ucast_pkts': '13171',
                                                                                       'mac_address': 'e4:8d:8c:11:14:d7',
                                                                                       'out_octets': '13334577',
                                                                                       'out_ucast_pkts': '14669'},
                                                                               {       'in_octets': '35143222',
                                                                                       'in_ucast_pkts': '275563',
                                                                                       'mac_address': 'e4:8d:8c:f2:2b:15',
                                                                                       'out_octets': '872308218',
                                                                                       'out_ucast_pkts': '615422'},
                                                                               {       'in_octets': '12090306',
                                                                                       'in_ucast_pkts': '19106',
                                                                                       'mac_address': 'e4:8d:8c:f6:70:26',
                                                                                       'out_octets': '2800370',
                                                                                       'out_ucast_pkts': '16620'},
                                                                               {       'in_octets': '47929367',
                                                                                       'in_ucast_pkts': '244712',
                                                                                       'mac_address': 'e4:8d:8c:fc:aa:81',
                                                                                       'out_octets': '376748554',
                                                                                       'out_ucast_pkts': '292159'},
                                                                               {       'in_octets': '3793976016',
                                                                                       'in_ucast_pkts': '138299061',
                                                                                       'mac_address': 'e4:8d:8c:fc:09:23',
                                                                                       'out_octets': '4061318571',
                                                                                       'out_ucast_pkts': '205300352'},
                                                                               {       'in_octets': '7418528',
                                                                                       'in_ucast_pkts': '42535',
                                                                                       'mac_address': 'e4:8d:8c:fd:51:7b',
                                                                                       'out_octets': '15733057',
                                                                                       'out_ucast_pkts': '28043'},
                                                                               {       'in_octets': '3712721',
                                                                                       'in_ucast_pkts': '35752',
                                                                                       'mac_address': '4c:5e:0c:81:ca:25',
                                                                                       'out_octets': '31990350',
                                                                                       'out_ucast_pkts': '40425'},
                                                                               {       'in_octets': '1143884780',
                                                                                       'in_ucast_pkts': '43602420',
                                                                                       'mac_address': '4c:5e:0c:82:3c:49',
                                                                                       'out_octets': '131793092',
                                                                                       'out_ucast_pkts': '79968672'},
                                                                               {       'in_octets': '231164',
                                                                                       'in_ucast_pkts': '1377',
                                                                                       'mac_address': '4c:5e:0c:85:55:4b',
                                                                                       'out_octets': '35798',
                                                                                       'out_ucast_pkts': '396'},
                                                                               {       'in_octets': '3412139',
                                                                                       'in_ucast_pkts': '20776',
                                                                                       'mac_address': '4c:5e:0c:87:90:8d',
                                                                                       'out_octets': '20326247',
                                                                                       'out_ucast_pkts': '20657'},
                                                                               {       'in_octets': '506665',
                                                                                       'in_ucast_pkts': '2889',
                                                                                       'mac_address': '4c:5e:0c:87:91:9d',
                                                                                       'out_octets': '309489',
                                                                                       'out_ucast_pkts': '3215'},
                                                                               {       'in_octets': '217825',
                                                                                       'in_ucast_pkts': '1338',
                                                                                       'mac_address': '4c:5e:0c:87:ae:7f',
                                                                                       'out_octets': '28348',
                                                                                       'out_ucast_pkts': '335'},
                                                                               {       'in_octets': '1335800',
                                                                                       'in_ucast_pkts': '8299',
                                                                                       'mac_address': '4c:5e:0c:8b:b0:e3',
                                                                                       'out_octets': '7682460',
                                                                                       'out_ucast_pkts': '7789'},
                                                                               {       'in_octets': '11763760',
                                                                                       'in_ucast_pkts': '51938',
                                                                                       'mac_address': '4c:5e:0c:8b:e4:cf',
                                                                                       'out_octets': '45589489',
                                                                                       'out_ucast_pkts': '59602'},
                                                                               {       'in_octets': '370860',
                                                                                       'in_ucast_pkts': '2863',
                                                                                       'mac_address': '4c:5e:0c:8b:56:c5',
                                                                                       'out_octets': '373546',
                                                                                       'out_ucast_pkts': '1624'},
                                                                               {       'in_octets': '1677676515',
                                                                                       'in_ucast_pkts': '88036614',
                                                                                       'mac_address': '4c:5e:0c:11:38:a8',
                                                                                       'out_octets': '229072026',
                                                                                       'out_ucast_pkts': '117730312'}],
                                                              'mac_address': 'd4:ca:6d:14:ca:67',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '49584058989745',
                                                              'out_ucast_pkts': '37888334961',
                                                              'radios': [       {       'framing': 'FIXED',
                                                                                        'frequency': 5220,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '14734',
                                                                                                                                            'mac_address': '00:0c:42:df:26:bf',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 57.0},
                                                                                                                                    {       'connected_time': '18978',
                                                                                                                                            'mac_address': '00:0c:42:ec:4c:30',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'snr': 59.0},
                                                                                                                                    {       'connected_time': '14147',
                                                                                                                                            'mac_address': '00:0c:42:ee:26:34',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 48.0},
                                                                                                                                    {       'connected_time': '14720',
                                                                                                                                            'mac_address': '00:0c:42:f0:82:c3',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'snr': 44.0},
                                                                                                                                    {       'connected_time': '14736',
                                                                                                                                            'mac_address': 'e4:8d:8c:11:14:d7',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 57.0},
                                                                                                                                    {       'connected_time': '14755',
                                                                                                                                            'mac_address': 'e4:8d:8c:f2:2b:15',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 52.0},
                                                                                                                                    {       'connected_time': '14754',
                                                                                                                                            'mac_address': 'e4:8d:8c:f6:70:26',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'snr': 58.0},
                                                                                                                                    {       'connected_time': '19012',
                                                                                                                                            'mac_address': 'e4:8d:8c:fc:aa:81',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'snr': 50.0},
                                                                                                                                    {       'connected_time': '3033095',
                                                                                                                                            'mac_address': 'e4:8d:8c:fc:09:23',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'snr': 63.0},
                                                                                                                                    {       'connected_time': '14751',
                                                                                                                                            'mac_address': 'e4:8d:8c:fd:51:7b',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'snr': 57.0},
                                                                                                                                    {       'connected_time': '14752',
                                                                                                                                            'mac_address': '4c:5e:0c:81:ca:25',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'snr': 58.0},
                                                                                                                                    {       'connected_time': '3033095',
                                                                                                                                            'mac_address': '4c:5e:0c:82:3c:49',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 57.0},
                                                                                                                                    {       'connected_time': '14754',
                                                                                                                                            'mac_address': '4c:5e:0c:85:55:4b',
                                                                                                                                            'noise_floor': -116.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 55.0},
                                                                                                                                    {       'connected_time': '14752',
                                                                                                                                            'mac_address': '4c:5e:0c:87:90:8d',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'snr': 63.0},
                                                                                                                                    {       'connected_time': '14136',
                                                                                                                                            'mac_address': '4c:5e:0c:87:91:9d',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'snr': 39.0},
                                                                                                                                    {       'connected_time': '14716',
                                                                                                                                            'mac_address': '4c:5e:0c:87:ae:7f',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 52.0},
                                                                                                                                    {       'connected_time': '14148',
                                                                                                                                            'mac_address': '4c:5e:0c:8b:b0:e3',
                                                                                                                                            'noise_floor': -116.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'snr': 62.0},
                                                                                                                                    {       'connected_time': '10171',
                                                                                                                                            'mac_address': '4c:5e:0c:8b:e4:cf',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 51.0},
                                                                                                                                    {       'connected_time': '14736',
                                                                                                                                            'mac_address': '4c:5e:0c:8b:56:c5',
                                                                                                                                            'noise_floor': -116.0,
                                                                                                                                            'rssi': -47.0,
                                                                                                                                            'snr': 69.0},
                                                                                                                                    {       'connected_time': '3033094',
                                                                                                                                            'mac_address': '4c:5e:0c:11:38:a8',
                                                                                                                                            'noise_floor': -114.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'snr': 43.0}],
                                                                                                                   'noise_floor': -115.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BroadbandVI_SolW_NV2_v'}],
                                                              'speed': '11000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 46.606445,
                                'model': 'RB411AH',
                                'serial_number': '36D802D91C44',
                                'sw_version': '6.23',
                                'system_mac_address': 'd4:ca:6d:77:12:55',
                                'uptime': '8565033'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '6830791',
                                                                       'in_ucast_pkts': '13428',
                                                                       'links': [       {       'in_octets': '6830791',
                                                                                                'in_ucast_pkts': '13428',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '2179113',
                                                                                                'out_ucast_pkts': '16641'}],
                                                                       'mac_address': '00:0c:42:df:26:bf',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2179113',
                                                                       'out_ucast_pkts': '16641',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14734',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2179113',
                                                                       'in_ucast_pkts': '16641',
                                                                       'mac_address': '00:0c:42:df:26:be',
                                                                       'name': 'ether1',
                                                                       'out_octets': '6830791',
                                                                       'out_ucast_pkts': '13428',
                                                                       'poller_hash': 'MDAwYzQyZGYyNmJmZXRoZXIx'}],
                                         'management_ip': '10.107.40.237',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Andrea/Harrison Klaus/Royer',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '00:0c:42:df:26:be'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '619763564',
                                                                       'in_ucast_pkts': '502518',
                                                                       'links': [       {       'in_octets': '619763564',
                                                                                                'in_ucast_pkts': '502518',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '40839399',
                                                                                                'out_ucast_pkts': '292925'}],
                                                                       'mac_address': '00:0c:42:ec:4c:30',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '40839399',
                                                                       'out_ucast_pkts': '292925',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '18978',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '40839399',
                                                                       'in_ucast_pkts': '292925',
                                                                       'mac_address': '00:0c:42:ec:4c:2f',
                                                                       'name': 'ether1',
                                                                       'out_octets': '619763564',
                                                                       'out_ucast_pkts': '502518',
                                                                       'poller_hash': 'MDAwYzQyZWM0YzMwZXRoZXIx'}],
                                         'management_ip': '10.107.40.192',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Harris Main House 21931',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '00:0c:42:ec:4c:2f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '641592',
                                                                       'in_ucast_pkts': '3518',
                                                                       'links': [       {       'in_octets': '641592',
                                                                                                'in_ucast_pkts': '3518',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '527790',
                                                                                                'out_ucast_pkts': '5229'}],
                                                                       'mac_address': '00:0c:42:ee:26:34',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '527790',
                                                                       'out_ucast_pkts': '5229',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14147',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '527790',
                                                                       'in_ucast_pkts': '5229',
                                                                       'mac_address': '00:0c:42:ee:26:33',
                                                                       'name': 'ether1',
                                                                       'out_octets': '641592',
                                                                       'out_ucast_pkts': '3518',
                                                                       'poller_hash': 'MDAwYzQyZWUyNjM0ZXRoZXIx'}],
                                         'management_ip': '10.107.40.182',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Pete & Sandy Obremskey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.33.5',
                                         'system_mac_address': '00:0c:42:ee:26:33'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '25606747',
                                                                       'in_ucast_pkts': '18155',
                                                                       'links': [       {       'in_octets': '25606747',
                                                                                                'in_ucast_pkts': '18155',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '1481281',
                                                                                                'out_ucast_pkts': '13146'}],
                                                                       'mac_address': '00:0c:42:f0:82:c3',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1481281',
                                                                       'out_ucast_pkts': '13146',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14720',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1481281',
                                                                       'in_ucast_pkts': '13146',
                                                                       'mac_address': '00:0c:42:f0:82:c2',
                                                                       'name': 'ether1',
                                                                       'out_octets': '25606747',
                                                                       'out_ucast_pkts': '18155',
                                                                       'poller_hash': 'MDAwYzQyZjA4MmMzZXRoZXIx'}],
                                         'management_ip': '10.107.40.208',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Elizabeth Kliesh 26665',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '00:0c:42:f0:82:c2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '13334577',
                                                                       'in_ucast_pkts': '14669',
                                                                       'links': [       {       'in_octets': '13334577',
                                                                                                'in_ucast_pkts': '14669',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '3620649',
                                                                                                'out_ucast_pkts': '13171'}],
                                                                       'mac_address': 'e4:8d:8c:11:14:d7',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3620649',
                                                                       'out_ucast_pkts': '13171',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14736',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3620649',
                                                                       'in_ucast_pkts': '13171',
                                                                       'mac_address': 'e4:8d:8c:11:14:d6',
                                                                       'name': 'ether1',
                                                                       'out_octets': '13334577',
                                                                       'out_ucast_pkts': '14669',
                                                                       'poller_hash': 'ZTQ4ZDhjMTExNGQ3ZXRoZXIx'}],
                                         'management_ip': '10.107.40.196',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Christopher Gangel 36825',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': 'e4:8d:8c:11:14:d6'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '872308218',
                                                                       'in_ucast_pkts': '615422',
                                                                       'links': [       {       'in_octets': '872308218',
                                                                                                'in_ucast_pkts': '615422',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '35143222',
                                                                                                'out_ucast_pkts': '275563'}],
                                                                       'mac_address': 'e4:8d:8c:f2:2b:15',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '35143222',
                                                                       'out_ucast_pkts': '275563',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14755',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '35143222',
                                                                       'in_ucast_pkts': '275563',
                                                                       'mac_address': 'e4:8d:8c:f2:2b:14',
                                                                       'name': 'ether1',
                                                                       'out_octets': '872308218',
                                                                       'out_ucast_pkts': '615422',
                                                                       'poller_hash': 'ZTQ4ZDhjZjIyYjE1ZXRoZXIx'}],
                                         'management_ip': '10.107.40.162',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Matt Palazzola',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.29.1',
                                         'system_mac_address': 'e4:8d:8c:f2:2b:14'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2800370',
                                                                       'in_ucast_pkts': '16620',
                                                                       'links': [       {       'in_octets': '2800370',
                                                                                                'in_ucast_pkts': '16620',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '12090306',
                                                                                                'out_ucast_pkts': '19106'}],
                                                                       'mac_address': 'e4:8d:8c:f6:70:26',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '12090306',
                                                                       'out_ucast_pkts': '19106',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14754',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '12090306',
                                                                       'in_ucast_pkts': '19106',
                                                                       'mac_address': 'e4:8d:8c:f6:70:25',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2800370',
                                                                       'out_ucast_pkts': '16620',
                                                                       'poller_hash': 'ZTQ4ZDhjZjY3MDI2ZXRoZXIx'}],
                                         'management_ip': '10.107.40.67',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Dusty Hill',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.30.2',
                                         'system_mac_address': 'e4:8d:8c:f6:70:25'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '376748554',
                                                                       'in_ucast_pkts': '292159',
                                                                       'links': [       {       'in_octets': '376748554',
                                                                                                'in_ucast_pkts': '292159',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '47929367',
                                                                                                'out_ucast_pkts': '244712'}],
                                                                       'mac_address': 'e4:8d:8c:fc:aa:81',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '47929367',
                                                                       'out_ucast_pkts': '244712',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '19012',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '47929367',
                                                                       'in_ucast_pkts': '244712',
                                                                       'mac_address': 'e4:8d:8c:fc:aa:80',
                                                                       'name': 'ether1',
                                                                       'out_octets': '376748554',
                                                                       'out_ucast_pkts': '292159',
                                                                       'poller_hash': 'ZTQ4ZDhjZmNhYTgxZXRoZXIx'}],
                                         'management_ip': '10.107.40.198',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Cheeseburgers in Paradise 29242',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.34.3',
                                         'system_mac_address': 'e4:8d:8c:fc:aa:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4061318571',
                                                                       'in_ucast_pkts': '205300352',
                                                                       'links': [       {       'in_octets': '4061318571',
                                                                                                'in_ucast_pkts': '205300352',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '3793976016',
                                                                                                'out_ucast_pkts': '138299061'}],
                                                                       'mac_address': 'e4:8d:8c:fc:09:23',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3793976016',
                                                                       'out_ucast_pkts': '138299061',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3033095',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3793976016',
                                                                       'in_ucast_pkts': '138299061',
                                                                       'mac_address': 'e4:8d:8c:fc:09:22',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4061318571',
                                                                       'out_ucast_pkts': '205300352',
                                                                       'poller_hash': 'ZTQ4ZDhjZmMwOTIzZXRoZXIx'}],
                                         'management_ip': '10.107.40.194',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'BCSC Dospiva stx 21347',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.33.5',
                                         'system_mac_address': 'e4:8d:8c:fc:09:22'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '15733057',
                                                                       'in_ucast_pkts': '28043',
                                                                       'links': [       {       'in_octets': '15733057',
                                                                                                'in_ucast_pkts': '28043',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '7418528',
                                                                                                'out_ucast_pkts': '42535'}],
                                                                       'mac_address': 'e4:8d:8c:fd:51:7b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '7418528',
                                                                       'out_ucast_pkts': '42535',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14751',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '7418528',
                                                                       'in_ucast_pkts': '42535',
                                                                       'mac_address': 'e4:8d:8c:fd:51:7a',
                                                                       'name': 'ether1',
                                                                       'out_octets': '15733057',
                                                                       'out_ucast_pkts': '28043',
                                                                       'poller_hash': 'ZTQ4ZDhjZmQ1MTdiZXRoZXIx'}],
                                         'management_ip': '10.107.40.167',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Jason Miller 24485 Rental Unit',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.34.3',
                                         'system_mac_address': 'e4:8d:8c:fd:51:7a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '31990350',
                                                                       'in_ucast_pkts': '40425',
                                                                       'links': [       {       'in_octets': '31990350',
                                                                                                'in_ucast_pkts': '40425',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '3712721',
                                                                                                'out_ucast_pkts': '35752'}],
                                                                       'mac_address': '4c:5e:0c:81:ca:25',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3712721',
                                                                       'out_ucast_pkts': '35752',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14752',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3712721',
                                                                       'in_ucast_pkts': '35752',
                                                                       'mac_address': '4c:5e:0c:81:ca:24',
                                                                       'name': 'ether1',
                                                                       'out_octets': '31990350',
                                                                       'out_ucast_pkts': '40425',
                                                                       'poller_hash': 'NGM1ZTBjODFjYTI1ZXRoZXIx'}],
                                         'management_ip': '10.107.40.221',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Michael Strasberg 31675',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.36',
                                         'system_mac_address': '4c:5e:0c:81:ca:24'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '131793092',
                                                                       'in_ucast_pkts': '79968672',
                                                                       'links': [       {       'in_octets': '131793092',
                                                                                                'in_ucast_pkts': '79968672',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '1143884780',
                                                                                                'out_ucast_pkts': '43602420'}],
                                                                       'mac_address': '4c:5e:0c:82:3c:49',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1143884780',
                                                                       'out_ucast_pkts': '43602420',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3033095',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1143884780',
                                                                       'in_ucast_pkts': '43602420',
                                                                       'mac_address': '4c:5e:0c:82:3c:48',
                                                                       'name': 'ether1',
                                                                       'out_octets': '131793092',
                                                                       'out_ucast_pkts': '79968672',
                                                                       'poller_hash': 'NGM1ZTBjODIzYzQ5ZXRoZXIx'}],
                                         'management_ip': '10.107.40.154',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Amy Land-De-Wilde 23304',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '4c:5e:0c:82:3c:48'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '35798',
                                                                       'in_ucast_pkts': '396',
                                                                       'links': [       {       'in_octets': '35798',
                                                                                                'in_ucast_pkts': '396',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '231164',
                                                                                                'out_ucast_pkts': '1377'}],
                                                                       'mac_address': '4c:5e:0c:85:55:4b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '231164',
                                                                       'out_ucast_pkts': '1377',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14754',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '231164',
                                                                       'in_ucast_pkts': '1377',
                                                                       'mac_address': '4c:5e:0c:85:55:4a',
                                                                       'name': 'ether1',
                                                                       'out_octets': '35798',
                                                                       'out_ucast_pkts': '396',
                                                                       'poller_hash': 'NGM1ZTBjODU1NTRiZXRoZXIx'}],
                                         'management_ip': '10.107.40.181',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Eliazbeth Kliesch 30213',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.34',
                                         'system_mac_address': '4c:5e:0c:85:55:4a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '20326247',
                                                                       'in_ucast_pkts': '20657',
                                                                       'links': [       {       'in_octets': '20326247',
                                                                                                'in_ucast_pkts': '20657',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '3412139',
                                                                                                'out_ucast_pkts': '20776'}],
                                                                       'mac_address': '4c:5e:0c:87:90:8d',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3412139',
                                                                       'out_ucast_pkts': '20776',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14752',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3412139',
                                                                       'in_ucast_pkts': '20776',
                                                                       'mac_address': '4c:5e:0c:87:90:8c',
                                                                       'name': 'ether1',
                                                                       'out_octets': '20326247',
                                                                       'out_ucast_pkts': '20657',
                                                                       'poller_hash': 'NGM1ZTBjODc5MDhkZXRoZXIx'}],
                                         'management_ip': '10.107.40.211',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Jeffrey Glaze 35648',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.36',
                                         'system_mac_address': '4c:5e:0c:87:90:8c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '309489',
                                                                       'in_ucast_pkts': '3215',
                                                                       'links': [       {       'in_octets': '309489',
                                                                                                'in_ucast_pkts': '3215',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '506665',
                                                                                                'out_ucast_pkts': '2889'}],
                                                                       'mac_address': '4c:5e:0c:87:91:9d',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '506665',
                                                                       'out_ucast_pkts': '2889',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14136',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '506665',
                                                                       'in_ucast_pkts': '2889',
                                                                       'mac_address': '4c:5e:0c:87:91:9c',
                                                                       'name': 'ether1',
                                                                       'out_octets': '309489',
                                                                       'out_ucast_pkts': '3215',
                                                                       'poller_hash': 'NGM1ZTBjODc5MTlkZXRoZXIx'}],
                                         'management_ip': '10.107.40.166',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Lorine Williams 24232',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '4c:5e:0c:87:91:9c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '28348',
                                                                       'in_ucast_pkts': '335',
                                                                       'links': [       {       'in_octets': '28348',
                                                                                                'in_ucast_pkts': '335',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '217825',
                                                                                                'out_ucast_pkts': '1338'}],
                                                                       'mac_address': '4c:5e:0c:87:ae:7f',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '217825',
                                                                       'out_ucast_pkts': '1338',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14716',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '217825',
                                                                       'in_ucast_pkts': '1338',
                                                                       'mac_address': '4c:5e:0c:87:ae:7e',
                                                                       'name': 'ether1',
                                                                       'out_octets': '28348',
                                                                       'out_ucast_pkts': '335',
                                                                       'poller_hash': 'NGM1ZTBjODdhZTdmZXRoZXIx'}],
                                         'management_ip': '10.107.40.151',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Lucia Dunderman',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.34',
                                         'system_mac_address': '4c:5e:0c:87:ae:7e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7682460',
                                                                       'in_ucast_pkts': '7789',
                                                                       'links': [       {       'in_octets': '7682460',
                                                                                                'in_ucast_pkts': '7789',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '1335800',
                                                                                                'out_ucast_pkts': '8299'}],
                                                                       'mac_address': '4c:5e:0c:8b:b0:e3',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1335800',
                                                                       'out_ucast_pkts': '8299',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14148',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1335800',
                                                                       'in_ucast_pkts': '8299',
                                                                       'mac_address': '4c:5e:0c:8b:b0:e2',
                                                                       'name': 'ether1',
                                                                       'out_octets': '7682460',
                                                                       'out_ucast_pkts': '7789',
                                                                       'poller_hash': 'NGM1ZTBjOGJiMGUzZXRoZXIx'}],
                                         'management_ip': '10.107.40.231',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Charles Ferris',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.33.5',
                                         'system_mac_address': '4c:5e:0c:8b:b0:e2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '45589489',
                                                                       'in_ucast_pkts': '59602',
                                                                       'links': [       {       'in_octets': '45589489',
                                                                                                'in_ucast_pkts': '59602',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '11763760',
                                                                                                'out_ucast_pkts': '51938'}],
                                                                       'mac_address': '4c:5e:0c:8b:e4:cf',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '11763760',
                                                                       'out_ucast_pkts': '51938',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10171',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '11763760',
                                                                       'in_ucast_pkts': '51938',
                                                                       'mac_address': '4c:5e:0c:8b:e4:ce',
                                                                       'name': 'ether1',
                                                                       'out_octets': '45589489',
                                                                       'out_ucast_pkts': '59602',
                                                                       'poller_hash': 'NGM1ZTBjOGJlNGNmZXRoZXIx'}],
                                         'management_ip': '10.107.40.160',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Brad Bockus 35655',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.34.6',
                                         'system_mac_address': '4c:5e:0c:8b:e4:ce'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '373546',
                                                                       'in_ucast_pkts': '1624',
                                                                       'links': [       {       'in_octets': '373546',
                                                                                                'in_ucast_pkts': '1624',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '370860',
                                                                                                'out_ucast_pkts': '2863'}],
                                                                       'mac_address': '4c:5e:0c:8b:56:c5',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '370860',
                                                                       'out_ucast_pkts': '2863',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14736',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '370860',
                                                                       'in_ucast_pkts': '2863',
                                                                       'mac_address': '4c:5e:0c:8b:56:c4',
                                                                       'name': 'ether1',
                                                                       'out_octets': '373546',
                                                                       'out_ucast_pkts': '1624',
                                                                       'poller_hash': 'NGM1ZTBjOGI1NmM1ZXRoZXIx'}],
                                         'management_ip': '10.107.40.232',
                                         'manufacturer': 'Mikrotik',
                                         'name': ' Harrison Royer Downstairs',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.23',
                                         'system_mac_address': '4c:5e:0c:8b:56:c4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '229072026',
                                                                       'in_ucast_pkts': '117730312',
                                                                       'links': [       {       'in_octets': '229072026',
                                                                                                'in_ucast_pkts': '117730312',
                                                                                                'mac_address': 'd4:ca:6d:14:ca:67',
                                                                                                'out_octets': '1677676515',
                                                                                                'out_ucast_pkts': '88036614'}],
                                                                       'mac_address': '4c:5e:0c:11:38:a8',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1677676515',
                                                                       'out_ucast_pkts': '88036614',
                                                                       'radios': [       {       'framing': 'FIXED',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3033094',
                                                                                                                                                     'mac_address': 'd4:ca:6d:14:ca:67'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BroadbandVI_SolW_NV2_v'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1677676515',
                                                                       'in_ucast_pkts': '88036614',
                                                                       'mac_address': '4c:5e:0c:11:38:a7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '229072026',
                                                                       'out_ucast_pkts': '117730312',
                                                                       'poller_hash': 'NGM1ZTBjMTEzOGE4ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:11:38:a7'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_30_2_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.30.2.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2437,
                'sta_count': 0,
                'sw_version': '6.30.2',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 115964517,
                'dl_en_packets': 881537,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 100000000,
                'mem': 34.832763671875,
                'serial_number': '36D804AABF16',
                'ssid': 'nwwnetWW2',
                'system_mac_address': '4c:5e:0c:7f:cc:eb',
                'temperature': None,
                'ul_en_bytes': 111729956,
                'ul_en_packets': 731157,
                'ul_noise_floor': -92.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '115964517',
                                                              'in_ucast_pkts': '881537',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:7f:cc:eb',
                                                              'mtu': 1500,
                                                              'name': '1-ToGround',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '111729956',
                                                              'out_ucast_pkts': '731157',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:6d:94:98:cb',
                                                              'mtu': 1500,
                                                              'name': 'WW AP2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2437,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetWW2'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 34.832764,
                                'model': 'RB411AH',
                                'serial_number': '36D804AABF16',
                                'sw_version': '6.30.2',
                                'system_mac_address': '4c:5e:0c:7f:cc:eb',
                                'uptime': '864448'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_34_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.34.1.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2437,
                'sta_count': 1,
                'sw_version': '6.34.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 2162070323,
                'dl_en_packets': 2508692,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2114813650,
                'dl_rf_packets': 2157505,
                'en_if_speed': 100000000,
                'mem': 35.68115234375,
                'serial_number': '36D8044CF3DD',
                'ssid': 'nwwnetWT4',
                'system_mac_address': '4c:5e:0c:86:f8:bf',
                'temperature': None,
                'ul_en_bytes': 312370020,
                'ul_en_packets': 1997371,
                'ul_noise_floor': -92.0,
                'ul_rf_bytes': 258224795,
                'ul_rf_packets': 1691059
        }
        exp_sta_stats = {
                '00:15:6d:94:ad:5a': {       'alt_macs': {'00:15:6d:94:ad:59'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1785408580,
                                             'dl_rf_packets': 1786613,
                                             'dl_rssi': -48.0,
                                             'dl_snr': None,
                                             'ip_address': '10.28.4.15',
                                             'mac_address': '00:15:6d:94:ad:5a',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 228992714,
                                             'ul_rf_packets': 1510976,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 45.0}
        }
        exp_ne_msg = {
                'data': {       'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2162070323',
                                                              'in_ucast_pkts': '2508692',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:86:f8:bf',
                                                              'mtu': 1500,
                                                              'name': '1-ToGround',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '312370020',
                                                              'out_ucast_pkts': '1997371',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '258224795',
                                                              'in_ucast_pkts': '1691059',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '228992714',
                                                                                       'in_ucast_pkts': '1510976',
                                                                                       'mac_address': '00:15:6d:94:ad:5a',
                                                                                       'out_octets': '1785408580',
                                                                                       'out_ucast_pkts': '1786613'}],
                                                              'mac_address': '00:15:6d:94:d1:fd',
                                                              'mtu': 1500,
                                                              'name': 'WTAP4',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2114813650',
                                                              'out_ucast_pkts': '2157505',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2437,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '429897',
                                                                                                                                            'mac_address': '00:15:6d:94:ad:5a',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'snr': 45.0}],
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetWT4'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 35.681152,
                                'model': 'RB411AH',
                                'serial_number': '36D8044CF3DD',
                                'sw_version': '6.34.1',
                                'system_mac_address': '4c:5e:0c:86:f8:bf',
                                'uptime': '429893'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1785408580',
                                                                       'in_ucast_pkts': '1786613',
                                                                       'links': [       {       'in_octets': '1785408580',
                                                                                                'in_ucast_pkts': '1786613',
                                                                                                'mac_address': '00:15:6d:94:d1:fd',
                                                                                                'out_octets': '228992714',
                                                                                                'out_ucast_pkts': '1510976'}],
                                                                       'mac_address': '00:15:6d:94:ad:5a',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '228992714',
                                                                       'out_ucast_pkts': '1510976',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2437,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '429897',
                                                                                                                                                     'mac_address': '00:15:6d:94:d1:fd'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWT4'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '228992714',
                                                                       'in_ucast_pkts': '1510976',
                                                                       'mac_address': '00:15:6d:94:ad:59',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1785408580',
                                                                       'out_ucast_pkts': '1786613',
                                                                       'poller_hash': 'MDAxNTZkOTRhZDVhZXRoZXIx'}],
                                         'management_ip': '10.28.4.15',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:94:ad:59'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_34_2_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.34.2.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2422,
                'sta_count': 1,
                'sw_version': '6.34.2',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 2209822322,
                'dl_en_packets': 3013348,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2096819529,
                'dl_rf_packets': 2226699,
                'en_if_speed': 100000000,
                'mem': 36.12060546875,
                'serial_number': '36D804B04658',
                'ssid': 'nwwnetWW1',
                'system_mac_address': '4c:5e:0c:86:f8:c4',
                'temperature': None,
                'ul_en_bytes': 494253892,
                'ul_en_packets': 2817647,
                'ul_noise_floor': -87.0,
                'ul_rf_bytes': 372210093,
                'ul_rf_packets': 2079706
        }
        exp_sta_stats = {
                '00:15:6d:94:65:b5': {       'alt_macs': {'00:15:6d:94:65:b4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 350760247,
                                             'dl_rf_packets': 365891,
                                             'dl_rssi': -68.0,
                                             'dl_snr': None,
                                             'ip_address': '10.17.1.251',
                                             'mac_address': '00:15:6d:94:65:b5',
                                             'name': 'WarvelDorris9/1/16',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': 75595841,
                                             'ul_rf_packets': 395528,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 20.0}
        }
        exp_ne_msg = {
                'data': {       'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2209822322',
                                                              'in_ucast_pkts': '3013348',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:86:f8:c4',
                                                              'mtu': 1500,
                                                              'name': '1-ToGround',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '494253892',
                                                              'out_ucast_pkts': '2817647',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '372210093',
                                                              'in_ucast_pkts': '2079706',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '75595841',
                                                                                       'in_ucast_pkts': '395528',
                                                                                       'mac_address': '00:15:6d:94:65:b5',
                                                                                       'out_octets': '350760247',
                                                                                       'out_ucast_pkts': '365891'}],
                                                              'mac_address': '00:15:6d:94:7d:06',
                                                              'mtu': 1500,
                                                              'name': 'WWAP1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2096819529',
                                                              'out_ucast_pkts': '2226699',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2422,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '174454',
                                                                                                                                            'mac_address': '00:15:6d:94:65:b5',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 20.0}],
                                                                                                                   'noise_floor': -87.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetWW1'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 36.120605,
                                'model': 'RB411AH',
                                'serial_number': '36D804B04658',
                                'sw_version': '6.34.2',
                                'system_mac_address': '4c:5e:0c:86:f8:c4',
                                'uptime': '864419'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '350760247',
                                                                       'in_ucast_pkts': '365891',
                                                                       'links': [       {       'in_octets': '350760247',
                                                                                                'in_ucast_pkts': '365891',
                                                                                                'mac_address': '00:15:6d:94:7d:06',
                                                                                                'out_octets': '75595841',
                                                                                                'out_ucast_pkts': '395528'}],
                                                                       'mac_address': '00:15:6d:94:65:b5',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '75595841',
                                                                       'out_ucast_pkts': '395528',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2422,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174454',
                                                                                                                                                     'mac_address': '00:15:6d:94:7d:06'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWW1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '75595841',
                                                                       'in_ucast_pkts': '395528',
                                                                       'mac_address': '00:15:6d:94:65:b4',
                                                                       'name': 'ether1',
                                                                       'out_octets': '350760247',
                                                                       'out_ucast_pkts': '365891',
                                                                       'poller_hash': 'MDAxNTZkOTQ2NWI1ZXRoZXIx'}],
                                         'management_ip': '10.17.1.251',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'WarvelDorris9/1/16',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.43.2',
                                         'system_mac_address': '00:15:6d:94:65:b4'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_35_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.35.1.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2447,
                'sta_count': 1,
                'sw_version': '6.35.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 7,
                'dl_en_bytes': 27865833433,
                'dl_en_packets': 62197673,
                'dl_noise_floor': None,
                'dl_rf_bytes': 23980533889,
                'dl_rf_packets': 20393531,
                'en_if_speed': 100000000,
                'mem': 37.860107421875,
                'serial_number': '36D80468F53D',
                'ssid': 'nwwnetGF5',
                'system_mac_address': '4c:5e:0c:87:66:70',
                'temperature': None,
                'ul_en_bytes': 5219618776,
                'ul_en_packets': 26109151,
                'ul_noise_floor': -111.0,
                'ul_rf_bytes': 3161863295,
                'ul_rf_packets': 15186195
        }
        exp_sta_stats = {
                '00:15:6d:65:f9:d3': {       'alt_macs': {'00:15:6d:65:f9:d2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1920229729,
                                             'dl_rf_packets': 18470905,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.9.5.253',
                                             'mac_address': '00:15:6d:65:f9:d3',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 3161863679,
                                             'ul_rf_packets': 15186197,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 51.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 7.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '27865833433',
                                                              'in_ucast_pkts': '62197673',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:87:66:70',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5219618776',
                                                              'out_ucast_pkts': '26109151',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3161863295',
                                                              'in_ucast_pkts': '15186195',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '3161863679',
                                                                                       'in_ucast_pkts': '15186197',
                                                                                       'mac_address': '00:15:6d:65:f9:d3',
                                                                                       'out_octets': '1920229729',
                                                                                       'out_ucast_pkts': '18470905'}],
                                                              'mac_address': 'd4:ca:6d:13:5b:5a',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '23980533889',
                                                              'out_ucast_pkts': '20393531',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2447,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '10538454',
                                                                                                                                            'mac_address': '00:15:6d:65:f9:d3',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 51.0}],
                                                                                                                   'noise_floor': -111.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetGF5'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 37.860107,
                                'model': 'RB411AH',
                                'serial_number': '36D80468F53D',
                                'sw_version': '6.35.1',
                                'system_mac_address': '4c:5e:0c:87:66:70',
                                'uptime': '10538458'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1920229729',
                                                                       'in_ucast_pkts': '18470905',
                                                                       'links': [       {       'in_octets': '1920229729',
                                                                                                'in_ucast_pkts': '18470905',
                                                                                                'mac_address': 'd4:ca:6d:13:5b:5a',
                                                                                                'out_octets': '3161863679',
                                                                                                'out_ucast_pkts': '15186197'}],
                                                                       'mac_address': '00:15:6d:65:f9:d3',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3161863679',
                                                                       'out_ucast_pkts': '15186197',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2447,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10538454',
                                                                                                                                                     'mac_address': 'd4:ca:6d:13:5b:5a'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetGF5'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3161863679',
                                                                       'in_ucast_pkts': '15186197',
                                                                       'mac_address': '00:15:6d:65:f9:d2',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1920229729',
                                                                       'out_ucast_pkts': '18470905',
                                                                       'poller_hash': 'MDAxNTZkNjVmOWQzZXRoZXIx'}],
                                         'management_ip': '10.9.5.253',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:65:f9:d2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_35_4_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.35.4.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 20,
                'rf_freq': 5320,
                'sta_count': 2,
                'sw_version': '6.35.4',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 12,
                'dl_en_bytes': 199450820274,
                'dl_en_packets': 508884885,
                'dl_noise_floor': None,
                'dl_rf_bytes': 189529696784,
                'dl_rf_packets': 485279390,
                'en_if_speed': 100000000,
                'mem': 39.12353515625,
                'serial_number': '2DF2013156CE',
                'ssid': 'COLI-1WDish',
                'system_mac_address': '00:0c:42:ec:0e:79',
                'temperature': None,
                'ul_en_bytes': 7651018638,
                'ul_en_packets': 66038924,
                'ul_noise_floor': -113.0,
                'ul_rf_bytes': 7017066923,
                'ul_rf_packets': 61077694
        }
        exp_sta_stats = {
                '00:0c:42:6b:a0:bf': {       'alt_macs': {'00:0c:42:6b:a0:be'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2889298614,
                                             'dl_rf_packets': 49761637,
                                             'dl_rssi': -73.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:6b:a0:bf',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 3065911658,
                                             'ul_rf_packets': 29390129,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 43.0},
                '4c:5e:0c:62:a3:0b': {       'alt_macs': {'4c:5e:0c:62:a3:0a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2000462834,
                                             'dl_rf_packets': 39795585,
                                             'dl_rssi': -73.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '4c:5e:0c:62:a3:0b',
                                             'name': 'Shannon Mullen',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -113.0,
                                             'ul_rf_bytes': 1085604136,
                                             'ul_rf_packets': 10409396,
                                             'ul_rssi': -72.0,
                                             'ul_snr': 41.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 12.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '199450820274',
                                                              'in_ucast_pkts': '508884885',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:0c:42:ec:0e:79',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '7651018638',
                                                              'out_ucast_pkts': '66038924',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '7017066923',
                                                              'in_ucast_pkts': '61077694',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '3065911658',
                                                                                       'in_ucast_pkts': '29390129',
                                                                                       'mac_address': '00:0c:42:6b:a0:bf',
                                                                                       'out_octets': '2889298614',
                                                                                       'out_ucast_pkts': '49761637'},
                                                                               {       'in_octets': '1085604136',
                                                                                       'in_ucast_pkts': '10409396',
                                                                                       'mac_address': '4c:5e:0c:62:a3:0b',
                                                                                       'out_octets': '2000462834',
                                                                                       'out_ucast_pkts': '39795585'}],
                                                              'mac_address': '00:0c:42:6b:a0:c7',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '189529696784',
                                                              'out_ucast_pkts': '485279390',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '521587',
                                                                                                                                            'mac_address': '00:0c:42:6b:a0:bf',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'snr': 43.0},
                                                                                                                                    {       'connected_time': '694249',
                                                                                                                                            'mac_address': '4c:5e:0c:62:a3:0b',
                                                                                                                                            'noise_floor': -113.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'snr': 41.0}],
                                                                                                                   'noise_floor': -113.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'COLI-1WDish'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 39.123535,
                                'model': 'RB411AH',
                                'serial_number': '2DF2013156CE',
                                'sw_version': '6.35.4',
                                'system_mac_address': '00:0c:42:ec:0e:79',
                                'uptime': '786021'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2889298614',
                                                                       'in_ucast_pkts': '49761637',
                                                                       'links': [       {       'in_octets': '2889298614',
                                                                                                'in_ucast_pkts': '49761637',
                                                                                                'mac_address': '00:0c:42:6b:a0:c7',
                                                                                                'out_octets': '3065911658',
                                                                                                'out_ucast_pkts': '29390129'}],
                                                                       'mac_address': '00:0c:42:6b:a0:bf',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3065911658',
                                                                       'out_ucast_pkts': '29390129',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '521587',
                                                                                                                                                     'mac_address': '00:0c:42:6b:a0:c7'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COLI-1WDish'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3065911658',
                                                                       'in_ucast_pkts': '29390129',
                                                                       'mac_address': '00:0c:42:6b:a0:be',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2889298614',
                                                                       'out_ucast_pkts': '49761637',
                                                                       'poller_hash': 'MDAwYzQyNmJhMGJmZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:6b:a0:be'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2000462834',
                                                                       'in_ucast_pkts': '39795585',
                                                                       'links': [       {       'in_octets': '2000462834',
                                                                                                'in_ucast_pkts': '39795585',
                                                                                                'mac_address': '00:0c:42:6b:a0:c7',
                                                                                                'out_octets': '1085604136',
                                                                                                'out_ucast_pkts': '10409396'}],
                                                                       'mac_address': '4c:5e:0c:62:a3:0b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1085604136',
                                                                       'out_ucast_pkts': '10409396',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '694249',
                                                                                                                                                     'mac_address': '00:0c:42:6b:a0:c7'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COLI-1WDish'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1085604136',
                                                                       'in_ucast_pkts': '10409396',
                                                                       'mac_address': '4c:5e:0c:62:a3:0a',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2000462834',
                                                                       'out_ucast_pkts': '39795585',
                                                                       'poller_hash': 'NGM1ZTBjNjJhMzBiZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Shannon Mullen',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.40.4',
                                         'system_mac_address': '4c:5e:0c:62:a3:0a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_36_3_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.36.3.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2432,
                'sta_count': 2,
                'sw_version': '6.36.3',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 11,
                'dl_en_bytes': 624380817065,
                'dl_en_packets': 458211430,
                'dl_noise_floor': None,
                'dl_rf_bytes': 622959602788,
                'dl_rf_packets': 446971431,
                'en_if_speed': 100000000,
                'mem': 41.070556640625,
                'serial_number': '36D8042E4097',
                'ssid': 'IndianTrail 900',
                'system_mac_address': '4c:5e:0c:85:66:9a',
                'temperature': None,
                'ul_en_bytes': 40002584279,
                'ul_en_packets': 365467462,
                'ul_noise_floor': -86.0,
                'ul_rf_bytes': 37942196012,
                'ul_rf_packets': 355300237
        }
        exp_sta_stats = {
                '00:15:6d:94:4b:c5': {       'alt_macs': {'00:15:6d:94:4b:c4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 59100675,
                                             'dl_rf_packets': 60248,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:94:4b:c5',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': 11589142,
                                             'ul_rf_packets': 57293,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:15:6d:94:52:ba': {       'alt_macs': {'00:15:6d:94:52:b9'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4030325060,
                                             'dl_rf_packets': 11718361,
                                             'dl_rssi': -71.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:94:52:ba',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': 797719218,
                                             'ul_rf_packets': 9302395,
                                             'ul_rssi': -75.0,
                                             'ul_snr': 11.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '624380817065',
                                                              'in_ucast_pkts': '458211430',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:85:66:9a',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '40002584279',
                                                              'out_ucast_pkts': '365467462',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '37942196012',
                                                              'in_ucast_pkts': '355300237',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '11589142',
                                                                                       'in_ucast_pkts': '57293',
                                                                                       'mac_address': '00:15:6d:94:4b:c5',
                                                                                       'out_octets': '59100675',
                                                                                       'out_ucast_pkts': '60248'},
                                                                               {       'in_octets': '797719218',
                                                                                       'in_ucast_pkts': '9302395',
                                                                                       'mac_address': '00:15:6d:94:52:ba',
                                                                                       'out_octets': '4030325060',
                                                                                       'out_ucast_pkts': '11718361'}],
                                                              'mac_address': '00:15:6d:94:52:bb',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '622959602788',
                                                              'out_ucast_pkts': '446971431',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2432,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '22693',
                                                                                                                                            'mac_address': '00:15:6d:94:4b:c5',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 25.0},
                                                                                                                                    {       'connected_time': '183803',
                                                                                                                                            'mac_address': '00:15:6d:94:52:ba',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'snr': 11.0}],
                                                                                                                   'noise_floor': -86.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'IndianTrail '
                                                                                                 '900'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 41.070557,
                                'model': 'RB411AH',
                                'serial_number': '36D8042E4097',
                                'sw_version': '6.36.3',
                                'system_mac_address': '4c:5e:0c:85:66:9a',
                                'uptime': '6472012'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '59100675',
                                                                       'in_ucast_pkts': '60248',
                                                                       'links': [       {       'in_octets': '59100675',
                                                                                                'in_ucast_pkts': '60248',
                                                                                                'mac_address': '00:15:6d:94:52:bb',
                                                                                                'out_octets': '11589142',
                                                                                                'out_ucast_pkts': '57293'}],
                                                                       'mac_address': '00:15:6d:94:4b:c5',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '11589142',
                                                                       'out_ucast_pkts': '57293',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2432,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '22693',
                                                                                                                                                     'mac_address': '00:15:6d:94:52:bb'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'IndianTrail '
                                                                                                          '900'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '11589142',
                                                                       'in_ucast_pkts': '57293',
                                                                       'mac_address': '00:15:6d:94:4b:c4',
                                                                       'name': 'ether1',
                                                                       'out_octets': '59100675',
                                                                       'out_ucast_pkts': '60248',
                                                                       'poller_hash': 'MDAxNTZkOTQ0YmM1ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:94:4b:c4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4030325060',
                                                                       'in_ucast_pkts': '11718361',
                                                                       'links': [       {       'in_octets': '4030325060',
                                                                                                'in_ucast_pkts': '11718361',
                                                                                                'mac_address': '00:15:6d:94:52:bb',
                                                                                                'out_octets': '797719218',
                                                                                                'out_ucast_pkts': '9302395'}],
                                                                       'mac_address': '00:15:6d:94:52:ba',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '797719218',
                                                                       'out_ucast_pkts': '9302395',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2432,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '183803',
                                                                                                                                                     'mac_address': '00:15:6d:94:52:bb'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'IndianTrail '
                                                                                                          '900'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '797719218',
                                                                       'in_ucast_pkts': '9302395',
                                                                       'mac_address': '00:15:6d:94:52:b9',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4030325060',
                                                                       'out_ucast_pkts': '11718361',
                                                                       'poller_hash': 'MDAxNTZkOTQ1MmJhZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:94:52:b9'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_37_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.37.1.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 20,
                'rf_freq': 5160,
                'sta_count': 1,
                'sw_version': '6.37.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 4,
                'dl_en_bytes': 3183511057672,
                'dl_en_packets': 2481880410,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3182509186694,
                'dl_rf_packets': 2462158179,
                'en_if_speed': 100000000,
                'mem': 41.6259765625,
                'serial_number': '36D80464D7E0',
                'ssid': 'PTP-NCWT-Enos',
                'system_mac_address': '4c:5e:0c:83:4e:d9',
                'temperature': None,
                'ul_en_bytes': 212160261741,
                'ul_en_packets': 1399991019,
                'ul_noise_floor': -94.0,
                'ul_rf_bytes': 206797135634,
                'ul_rf_packets': 1369689009
        }
        exp_sta_stats = {
                '00:15:6d:65:fc:59': {       'alt_macs': {'00:15:6d:65:fc:58'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2734437831,
                                             'dl_rf_packets': 44195839,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '67.16.75.36',
                                             'mac_address': '00:15:6d:65:fc:59',
                                             'name': 'Enos 911 to NCWT',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 4163294166,
                                             'ul_rf_packets': 22566841,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 29.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 4.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3183511057672',
                                                              'in_ucast_pkts': '2481880410',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:83:4e:d9',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '212160261741',
                                                              'out_ucast_pkts': '1399991019',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '206797135634',
                                                              'in_ucast_pkts': '1369689009',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '4163294166',
                                                                                       'in_ucast_pkts': '22566841',
                                                                                       'mac_address': '00:15:6d:65:fc:59',
                                                                                       'out_octets': '2734437831',
                                                                                       'out_ucast_pkts': '44195839'}],
                                                              'mac_address': '00:15:6d:6b:44:21',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3182509186694',
                                                              'out_ucast_pkts': '2462158179',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5160,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '318116',
                                                                                                                                            'mac_address': '00:15:6d:65:fc:59',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 29.0}],
                                                                                                                   'noise_floor': -94.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'PTP-NCWT-Enos'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 41.625977,
                                'model': 'RB411AH',
                                'serial_number': '36D80464D7E0',
                                'sw_version': '6.37.1',
                                'system_mac_address': '4c:5e:0c:83:4e:d9',
                                'uptime': '20470320'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2734437831',
                                                                       'in_ucast_pkts': '44195839',
                                                                       'links': [       {       'in_octets': '2734437831',
                                                                                                'in_ucast_pkts': '44195839',
                                                                                                'mac_address': '00:15:6d:6b:44:21',
                                                                                                'out_octets': '4163294166',
                                                                                                'out_ucast_pkts': '22566841'}],
                                                                       'mac_address': '00:15:6d:65:fc:59',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4163294166',
                                                                       'out_ucast_pkts': '22566841',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5160,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '318116',
                                                                                                                                                     'mac_address': '00:15:6d:6b:44:21'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211A'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PTP-NCWT-Enos'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '4163294166',
                                                                       'in_ucast_pkts': '22566841',
                                                                       'mac_address': '00:15:6d:65:fc:58',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2734437831',
                                                                       'out_ucast_pkts': '44195839',
                                                                       'poller_hash': 'MDAxNTZkNjVmYzU5ZXRoZXIx'}],
                                         'management_ip': '67.16.75.36',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Enos 911 to NCWT',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.37.1',
                                         'system_mac_address': '00:15:6d:65:fc:58'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_40_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.40.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2407,
                'sta_count': 3,
                'sw_version': '6.40',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 5,
                'dl_en_bytes': 1253340833527,
                'dl_en_packets': 1040522034,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1252759703150,
                'dl_rf_packets': 1038024130,
                'en_if_speed': 100000000,
                'mem': 40.34423828125,
                'serial_number': '6290048877F1',
                'ssid': 'nwwnetTN3',
                'system_mac_address': '4c:5e:0c:4b:07:e1',
                'temperature': None,
                'ul_en_bytes': 217441538418,
                'ul_en_packets': 868550179,
                'ul_noise_floor': -110.0,
                'ul_rf_bytes': 216108502203,
                'ul_rf_packets': 859969515
        }
        exp_sta_stats = {
                '4c:5e:0c:10:7d:35': {       'alt_macs': {'4c:5e:0c:10:7d:34'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3356714096,
                                             'dl_rf_packets': 8505628,
                                             'dl_rssi': -46.0,
                                             'dl_snr': None,
                                             'ip_address': '10.41.3.252',
                                             'mac_address': '4c:5e:0c:10:7d:35',
                                             'name': 'Miranda Smith',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -110.0,
                                             'ul_rf_bytes': 2891183007,
                                             'ul_rf_packets': 8610686,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 64.0},
                '4c:5e:0c:11:e1:dd': {       'alt_macs': {'4c:5e:0c:11:e1:dc'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2355832890,
                                             'dl_rf_packets': 409675125,
                                             'dl_rssi': -52.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '4c:5e:0c:11:e1:dd',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -110.0,
                                             'ul_rf_bytes': 150214821,
                                             'ul_rf_packets': 295603454,
                                             'ul_rssi': -45.0,
                                             'ul_snr': 65.0},
                '4c:5e:0c:13:04:56': {       'alt_macs': {'4c:5e:0c:13:04:55'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1854813680,
                                             'dl_rf_packets': 80779133,
                                             'dl_rssi': -39.0,
                                             'dl_snr': None,
                                             'ip_address': '10.41.3.253',
                                             'mac_address': '4c:5e:0c:13:04:56',
                                             'name': 'Scott Nicholson',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -110.0,
                                             'ul_rf_bytes': 110201943,
                                             'ul_rf_packets': 81093387,
                                             'ul_rssi': -32.0,
                                             'ul_snr': 78.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 5.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1253340833527',
                                                              'in_ucast_pkts': '1040522034',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:4b:07:e1',
                                                              'mtu': 1500,
                                                              'name': '1-ToGround',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '217441538418',
                                                              'out_ucast_pkts': '868550179',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '216108502203',
                                                              'in_ucast_pkts': '859969515',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2891183007',
                                                                                       'in_ucast_pkts': '8610686',
                                                                                       'mac_address': '4c:5e:0c:10:7d:35',
                                                                                       'out_octets': '3356714096',
                                                                                       'out_ucast_pkts': '8505628'},
                                                                               {       'in_octets': '150214821',
                                                                                       'in_ucast_pkts': '295603454',
                                                                                       'mac_address': '4c:5e:0c:11:e1:dd',
                                                                                       'out_octets': '2355832890',
                                                                                       'out_ucast_pkts': '409675125'},
                                                                               {       'in_octets': '110201943',
                                                                                       'in_ucast_pkts': '81093387',
                                                                                       'mac_address': '4c:5e:0c:13:04:56',
                                                                                       'out_octets': '1854813680',
                                                                                       'out_ucast_pkts': '80779133'}],
                                                              'mac_address': 'e4:8d:8c:fb:50:c5',
                                                              'mtu': 1500,
                                                              'name': 'TNAP3',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1252759703150',
                                                              'out_ucast_pkts': '1038024130',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2407,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '150536',
                                                                                                                                            'mac_address': '4c:5e:0c:10:7d:35',
                                                                                                                                            'noise_floor': -110.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'snr': 64.0},
                                                                                                                                    {       'connected_time': '6286591',
                                                                                                                                            'mac_address': '4c:5e:0c:11:e1:dd',
                                                                                                                                            'noise_floor': -110.0,
                                                                                                                                            'rssi': -45.0,
                                                                                                                                            'snr': 65.0},
                                                                                                                                    {       'connected_time': '2218059',
                                                                                                                                            'mac_address': '4c:5e:0c:13:04:56',
                                                                                                                                            'noise_floor': -110.0,
                                                                                                                                            'rssi': -32.0,
                                                                                                                                            'snr': 78.0}],
                                                                                                                   'noise_floor': -110.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetTN3'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': False,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e6:8d:8c:fb:50:c5',
                                                              'name': 'wlan1',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 40.34424,
                                'model': 'RB411AH',
                                'serial_number': '6290048877F1',
                                'sw_version': '6.40',
                                'system_mac_address': '4c:5e:0c:4b:07:e1',
                                'uptime': '6286617'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3356714096',
                                                                       'in_ucast_pkts': '8505628',
                                                                       'links': [       {       'in_octets': '3356714096',
                                                                                                'in_ucast_pkts': '8505628',
                                                                                                'mac_address': 'e4:8d:8c:fb:50:c5',
                                                                                                'out_octets': '2891183007',
                                                                                                'out_ucast_pkts': '8610686'}],
                                                                       'mac_address': '4c:5e:0c:10:7d:35',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2891183007',
                                                                       'out_ucast_pkts': '8610686',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '150536',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:50:c5'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetTN3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2891183007',
                                                                       'in_ucast_pkts': '8610686',
                                                                       'mac_address': '4c:5e:0c:10:7d:34',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3356714096',
                                                                       'out_ucast_pkts': '8505628',
                                                                       'poller_hash': 'NGM1ZTBjMTA3ZDM1ZXRoZXIx'}],
                                         'management_ip': '10.41.3.252',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Miranda Smith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.37.5',
                                         'system_mac_address': '4c:5e:0c:10:7d:34'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2355832890',
                                                                       'in_ucast_pkts': '409675125',
                                                                       'links': [       {       'in_octets': '2355832890',
                                                                                                'in_ucast_pkts': '409675125',
                                                                                                'mac_address': 'e4:8d:8c:fb:50:c5',
                                                                                                'out_octets': '150214821',
                                                                                                'out_ucast_pkts': '295603454'}],
                                                                       'mac_address': '4c:5e:0c:11:e1:dd',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '150214821',
                                                                       'out_ucast_pkts': '295603454',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6286591',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:50:c5'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetTN3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '150214821',
                                                                       'in_ucast_pkts': '295603454',
                                                                       'mac_address': '4c:5e:0c:11:e1:dc',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2355832890',
                                                                       'out_ucast_pkts': '409675125',
                                                                       'poller_hash': 'NGM1ZTBjMTFlMWRkZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:11:e1:dc'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1854813680',
                                                                       'in_ucast_pkts': '80779133',
                                                                       'links': [       {       'in_octets': '1854813680',
                                                                                                'in_ucast_pkts': '80779133',
                                                                                                'mac_address': 'e4:8d:8c:fb:50:c5',
                                                                                                'out_octets': '110201943',
                                                                                                'out_ucast_pkts': '81093387'}],
                                                                       'mac_address': '4c:5e:0c:13:04:56',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '110201943',
                                                                       'out_ucast_pkts': '81093387',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2218059',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:50:c5'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetTN3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '110201943',
                                                                       'in_ucast_pkts': '81093387',
                                                                       'mac_address': '4c:5e:0c:13:04:55',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1854813680',
                                                                       'out_ucast_pkts': '80779133',
                                                                       'poller_hash': 'NGM1ZTBjMTMwNDU2ZXRoZXIx'}],
                                         'management_ip': '10.41.3.253',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Scott Nicholson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.30.4',
                                         'system_mac_address': '4c:5e:0c:13:04:55'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_40_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.40.8.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': None,
                'rf_freq': 0,
                'sta_count': 0,
                'sw_version': '6.40.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 3990508239,
                'dl_en_packets': 42057778,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 100000000,
                'mem': 29.364013671875,
                'serial_number': '36D8027DCA59',
                'ssid': 'Garner 900',
                'system_mac_address': 'd4:ca:6d:60:22:e8',
                'temperature': None,
                'ul_en_bytes': 2627412587,
                'ul_en_packets': 19977066,
                'ul_noise_floor': 0.0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3990508239',
                                                              'in_ucast_pkts': '42057778',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd4:ca:6d:60:22:e8',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2627412587',
                                                              'out_ucast_pkts': '19977066',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:6d:93:05:ab',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'framing': 'FIXED',
                                                                                        'frequency': 0,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': 0.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Garner '
                                                                                                 '900'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 29.364014,
                                'model': 'RB411AH',
                                'serial_number': '36D8027DCA59',
                                'sw_version': '6.40.8',
                                'system_mac_address': 'd4:ca:6d:60:22:e8',
                                'uptime': '6637747'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_40_9_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.40.9.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 20,
                'rf_freq': 2457,
                'sta_count': 2,
                'sw_version': '6.40.9',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 2,
                'dl_en_bytes': 45941389373,
                'dl_en_packets': 38701275,
                'dl_noise_floor': None,
                'dl_rf_bytes': 42344508282,
                'dl_rf_packets': 33502990,
                'en_if_speed': 100000000,
                'mem': 43.267822265625,
                'serial_number': '36D802ED0ABC',
                'ssid': 'Junction877-NEOKCOM',
                'system_mac_address': 'd4:ca:6d:28:e6:e8',
                'temperature': None,
                'ul_en_bytes': 2828425430,
                'ul_en_packets': 23546882,
                'ul_noise_floor': -115.0,
                'ul_rf_bytes': 3457260551,
                'ul_rf_packets': 25133980
        }
        exp_sta_stats = {
                '00:15:6d:a9:ef:28': {       'alt_macs': {'00:15:6d:a9:ef:27'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 141672,
                                             'dl_rf_packets': 1895,
                                             'dl_rssi': -67.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:a9:ef:28',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 42446,
                                             'ul_rf_packets': 1354,
                                             'ul_rssi': -72.0,
                                             'ul_snr': 39.0},
                '44:d9:e7:26:da:77': {       'alt_macs': {'44:d9:e7:26:da:76'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3901950770,
                                             'dl_rf_packets': 13298918,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '44:d9:e7:26:da:77',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -115.0,
                                             'ul_rf_bytes': 1382653877,
                                             'ul_rf_packets': 10182917,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 51.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '45941389373',
                                                              'in_ucast_pkts': '38701275',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'd4:ca:6d:28:e6:e8',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2828425430',
                                                              'out_ucast_pkts': '23546882',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3457260551',
                                                              'in_ucast_pkts': '25133980',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '42446',
                                                                                       'in_ucast_pkts': '1354',
                                                                                       'mac_address': '00:15:6d:a9:ef:28',
                                                                                       'out_octets': '141672',
                                                                                       'out_ucast_pkts': '1895'},
                                                                               {       'in_octets': '1382653877',
                                                                                       'in_ucast_pkts': '10182917',
                                                                                       'mac_address': '44:d9:e7:26:da:77',
                                                                                       'out_octets': '3901950770',
                                                                                       'out_ucast_pkts': '13298918'}],
                                                              'mac_address': 'd4:ca:6d:10:03:42',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '42344508282',
                                                              'out_ucast_pkts': '33502990',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2457,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '5195',
                                                                                                                                            'mac_address': '00:15:6d:a9:ef:28',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'snr': 39.0},
                                                                                                                                    {       'connected_time': '272894',
                                                                                                                                            'mac_address': '44:d9:e7:26:da:77',
                                                                                                                                            'noise_floor': -115.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'snr': 51.0}],
                                                                                                                   'noise_floor': -115.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Junction877-NEOKCOM'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 43.267822,
                                'model': 'RB411AH',
                                'serial_number': '36D802ED0ABC',
                                'sw_version': '6.40.9',
                                'system_mac_address': 'd4:ca:6d:28:e6:e8',
                                'uptime': '806610'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '141672',
                                                                       'in_ucast_pkts': '1895',
                                                                       'links': [       {       'in_octets': '141672',
                                                                                                'in_ucast_pkts': '1895',
                                                                                                'mac_address': 'd4:ca:6d:10:03:42',
                                                                                                'out_octets': '42446',
                                                                                                'out_ucast_pkts': '1354'}],
                                                                       'mac_address': '00:15:6d:a9:ef:28',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '42446',
                                                                       'out_ucast_pkts': '1354',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2457,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '5195',
                                                                                                                                                     'mac_address': 'd4:ca:6d:10:03:42'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Junction877-NEOKCOM'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '42446',
                                                                       'in_ucast_pkts': '1354',
                                                                       'mac_address': '00:15:6d:a9:ef:27',
                                                                       'name': 'ether1',
                                                                       'out_octets': '141672',
                                                                       'out_ucast_pkts': '1895',
                                                                       'poller_hash': 'MDAxNTZkYTllZjI4ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:a9:ef:27'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3901950770',
                                                                       'in_ucast_pkts': '13298918',
                                                                       'links': [       {       'in_octets': '3901950770',
                                                                                                'in_ucast_pkts': '13298918',
                                                                                                'mac_address': 'd4:ca:6d:10:03:42',
                                                                                                'out_octets': '1382653877',
                                                                                                'out_ucast_pkts': '10182917'}],
                                                                       'mac_address': '44:d9:e7:26:da:77',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1382653877',
                                                                       'out_ucast_pkts': '10182917',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2457,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '272894',
                                                                                                                                                     'mac_address': 'd4:ca:6d:10:03:42'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Junction877-NEOKCOM'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1382653877',
                                                                       'in_ucast_pkts': '10182917',
                                                                       'mac_address': '44:d9:e7:26:da:76',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3901950770',
                                                                       'out_ucast_pkts': '13298918',
                                                                       'poller_hash': 'NDRkOWU3MjZkYTc3ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '44:d9:e7:26:da:76'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_42_4_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.42.4.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2412,
                'sta_count': 1,
                'sw_version': '6.42.4',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 3,
                'dl_en_bytes': 179480202478,
                'dl_en_packets': 169557266,
                'dl_noise_floor': None,
                'dl_rf_bytes': 178777992862,
                'dl_rf_packets': 172496184,
                'en_if_speed': 100000000,
                'mem': 43.841552734375,
                'serial_number': '629004A06FB8',
                'ssid': 'nwwnetPG3',
                'system_mac_address': '4c:5e:0c:8d:37:c9',
                'temperature': None,
                'ul_en_bytes': 16394702225,
                'ul_en_packets': 143247466,
                'ul_noise_floor': -91.0,
                'ul_rf_bytes': 12384248133,
                'ul_rf_packets': 100396594
        }
        exp_sta_stats = {
                '6c:3b:6b:6f:94:0f': {       'alt_macs': {'6c:3b:6b:6f:94:0e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1042010178,
                                             'dl_rf_packets': 67796549,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.21.5.253',
                                             'mac_address': '6c:3b:6b:6f:94:0f',
                                             'name': 'Dennis Hook',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 961421024,
                                             'ul_rf_packets': 43759050,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 24.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 3.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '179480202478',
                                                              'in_ucast_pkts': '169557266',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:8d:37:c9',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '16394702225',
                                                              'out_ucast_pkts': '143247466',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '12384248133',
                                                              'in_ucast_pkts': '100396594',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '961421024',
                                                                                       'in_ucast_pkts': '43759050',
                                                                                       'mac_address': '6c:3b:6b:6f:94:0f',
                                                                                       'out_octets': '1042010178',
                                                                                       'out_ucast_pkts': '67796549'}],
                                                              'mac_address': '00:15:6d:68:01:4e',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '178777992862',
                                                              'out_ucast_pkts': '172496184',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2412,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '10762061',
                                                                                                                                            'mac_address': '6c:3b:6b:6f:94:0f',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 24.0}],
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetPG3'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 43.841553,
                                'model': 'RB411AH',
                                'serial_number': '629004A06FB8',
                                'sw_version': '6.42.4',
                                'system_mac_address': '4c:5e:0c:8d:37:c9',
                                'uptime': '6555577'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1042010178',
                                                                       'in_ucast_pkts': '67796549',
                                                                       'links': [       {       'in_octets': '1042010178',
                                                                                                'in_ucast_pkts': '67796549',
                                                                                                'mac_address': '00:15:6d:68:01:4e',
                                                                                                'out_octets': '961421024',
                                                                                                'out_ucast_pkts': '43759050'}],
                                                                       'mac_address': '6c:3b:6b:6f:94:0f',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '961421024',
                                                                       'out_ucast_pkts': '43759050',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2412,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10762061',
                                                                                                                                                     'mac_address': '00:15:6d:68:01:4e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetPG3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '961421024',
                                                                       'in_ucast_pkts': '43759050',
                                                                       'mac_address': '6c:3b:6b:6f:94:0e',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1042010178',
                                                                       'out_ucast_pkts': '67796549',
                                                                       'poller_hash': 'NmMzYjZiNmY5NDBmZXRoZXIx'}],
                                         'management_ip': '10.21.5.253',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Dennis Hook',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.30.4',
                                         'system_mac_address': '6c:3b:6b:6f:94:0e'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_43_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.43.8.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 20,
                'rf_freq': 2427,
                'sta_count': 4,
                'sw_version': '6.43.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 7,
                'dl_en_bytes': 421426506892,
                'dl_en_packets': 332739447,
                'dl_noise_floor': None,
                'dl_rf_bytes': 420551454289,
                'dl_rf_packets': 326907438,
                'en_if_speed': 100000000,
                'mem': 35.736083984375,
                'serial_number': '728A06CE1E14',
                'ssid': 'harvestland1',
                'system_mac_address': '6c:3b:6b:4d:f8:b1',
                'temperature': None,
                'ul_en_bytes': 54896109963,
                'ul_en_packets': 257614895,
                'ul_noise_floor': -106.0,
                'ul_rf_bytes': 53760293195,
                'ul_rf_packets': 249228578
        }
        exp_sta_stats = {
                '00:0c:42:65:cd:c2': {       'alt_macs': {'00:0c:42:65:cd:c1'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2140165917,
                                             'dl_rf_packets': 13153285,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:65:cd:c2',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -106.0,
                                             'ul_rf_bytes': 1978646493,
                                             'ul_rf_packets': 12189564,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 36.0},
                '00:0c:42:67:41:fa': {       'alt_macs': {'00:0c:42:67:41:f9'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1051984641,
                                             'dl_rf_packets': 120971414,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:67:41:fa',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -106.0,
                                             'ul_rf_bytes': 243197534,
                                             'ul_rf_packets': 93597405,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 40.0},
                '00:0c:42:67:bc:8a': {       'alt_macs': {'00:0c:42:67:bc:89'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1838190036,
                                             'dl_rf_packets': 52790548,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:67:bc:8a',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -107.0,
                                             'ul_rf_bytes': 1175137001,
                                             'ul_rf_packets': 42172831,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 36.0},
                '00:0c:42:71:1c:43': {       'alt_macs': {'00:0c:42:71:1c:42'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 645646185,
                                             'dl_rf_packets': 7377838,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:71:1c:43',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -106.0,
                                             'ul_rf_bytes': 1109377192,
                                             'ul_rf_packets': 6448234,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 45.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 7.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '421426506892',
                                                              'in_ucast_pkts': '332739447',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:4d:f8:b1',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '54896109963',
                                                              'out_ucast_pkts': '257614895',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '53760293195',
                                                              'in_ucast_pkts': '249228578',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '1978646493',
                                                                                       'in_ucast_pkts': '12189564',
                                                                                       'mac_address': '00:0c:42:65:cd:c2',
                                                                                       'out_octets': '2140165917',
                                                                                       'out_ucast_pkts': '13153285'},
                                                                               {       'in_octets': '1175137001',
                                                                                       'in_ucast_pkts': '42172831',
                                                                                       'mac_address': '00:0c:42:67:bc:8a',
                                                                                       'out_octets': '1838190036',
                                                                                       'out_ucast_pkts': '52790548'},
                                                                               {       'in_octets': '243197534',
                                                                                       'in_ucast_pkts': '93597405',
                                                                                       'mac_address': '00:0c:42:67:41:fa',
                                                                                       'out_octets': '1051984641',
                                                                                       'out_ucast_pkts': '120971414'},
                                                                               {       'in_octets': '1109377192',
                                                                                       'in_ucast_pkts': '6448234',
                                                                                       'mac_address': '00:0c:42:71:1c:43',
                                                                                       'out_octets': '645646185',
                                                                                       'out_ucast_pkts': '7377838'}],
                                                              'mac_address': '6c:3b:6b:6f:94:0e',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '420551454289',
                                                              'out_ucast_pkts': '326907438',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2427,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2403582',
                                                                                                                                            'mac_address': '00:0c:42:65:cd:c2',
                                                                                                                                            'noise_floor': -106.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'snr': 36.0},
                                                                                                                                    {       'connected_time': '2403579',
                                                                                                                                            'mac_address': '00:0c:42:67:bc:8a',
                                                                                                                                            'noise_floor': -107.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'snr': 36.0},
                                                                                                                                    {       'connected_time': '751659',
                                                                                                                                            'mac_address': '00:0c:42:67:41:fa',
                                                                                                                                            'noise_floor': -106.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'snr': 40.0},
                                                                                                                                    {       'connected_time': '1169932',
                                                                                                                                            'mac_address': '00:0c:42:71:1c:43',
                                                                                                                                            'noise_floor': -106.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 45.0}],
                                                                                                                   'noise_floor': -106.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'harvestland1'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 35.736084,
                                'model': 'RB411AH',
                                'serial_number': '728A06CE1E14',
                                'sw_version': '6.43.8',
                                'system_mac_address': '6c:3b:6b:4d:f8:b1',
                                'uptime': '2403606'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2140165917',
                                                                       'in_ucast_pkts': '13153285',
                                                                       'links': [       {       'in_octets': '2140165917',
                                                                                                'in_ucast_pkts': '13153285',
                                                                                                'mac_address': '6c:3b:6b:6f:94:0e',
                                                                                                'out_octets': '1978646493',
                                                                                                'out_ucast_pkts': '12189564'}],
                                                                       'mac_address': '00:0c:42:65:cd:c2',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1978646493',
                                                                       'out_ucast_pkts': '12189564',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2427,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2403582',
                                                                                                                                                     'mac_address': '6c:3b:6b:6f:94:0e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'harvestland1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1978646493',
                                                                       'in_ucast_pkts': '12189564',
                                                                       'mac_address': '00:0c:42:65:cd:c1',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2140165917',
                                                                       'out_ucast_pkts': '13153285',
                                                                       'poller_hash': 'MDAwYzQyNjVjZGMyZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:65:cd:c1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1838190036',
                                                                       'in_ucast_pkts': '52790548',
                                                                       'links': [       {       'in_octets': '1838190036',
                                                                                                'in_ucast_pkts': '52790548',
                                                                                                'mac_address': '6c:3b:6b:6f:94:0e',
                                                                                                'out_octets': '1175137001',
                                                                                                'out_ucast_pkts': '42172831'}],
                                                                       'mac_address': '00:0c:42:67:bc:8a',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1175137001',
                                                                       'out_ucast_pkts': '42172831',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2427,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2403579',
                                                                                                                                                     'mac_address': '6c:3b:6b:6f:94:0e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'harvestland1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1175137001',
                                                                       'in_ucast_pkts': '42172831',
                                                                       'mac_address': '00:0c:42:67:bc:89',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1838190036',
                                                                       'out_ucast_pkts': '52790548',
                                                                       'poller_hash': 'MDAwYzQyNjdiYzhhZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:67:bc:89'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1051984641',
                                                                       'in_ucast_pkts': '120971414',
                                                                       'links': [       {       'in_octets': '1051984641',
                                                                                                'in_ucast_pkts': '120971414',
                                                                                                'mac_address': '6c:3b:6b:6f:94:0e',
                                                                                                'out_octets': '243197534',
                                                                                                'out_ucast_pkts': '93597405'}],
                                                                       'mac_address': '00:0c:42:67:41:fa',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '243197534',
                                                                       'out_ucast_pkts': '93597405',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2427,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '751659',
                                                                                                                                                     'mac_address': '6c:3b:6b:6f:94:0e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'harvestland1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '243197534',
                                                                       'in_ucast_pkts': '93597405',
                                                                       'mac_address': '00:0c:42:67:41:f9',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1051984641',
                                                                       'out_ucast_pkts': '120971414',
                                                                       'poller_hash': 'MDAwYzQyNjc0MWZhZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:67:41:f9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '645646185',
                                                                       'in_ucast_pkts': '7377838',
                                                                       'links': [       {       'in_octets': '645646185',
                                                                                                'in_ucast_pkts': '7377838',
                                                                                                'mac_address': '6c:3b:6b:6f:94:0e',
                                                                                                'out_octets': '1109377192',
                                                                                                'out_ucast_pkts': '6448234'}],
                                                                       'mac_address': '00:0c:42:71:1c:43',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1109377192',
                                                                       'out_ucast_pkts': '6448234',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2427,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1169932',
                                                                                                                                                     'mac_address': '6c:3b:6b:6f:94:0e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'harvestland1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1109377192',
                                                                       'in_ucast_pkts': '6448234',
                                                                       'mac_address': '00:0c:42:71:1c:42',
                                                                       'name': 'ether1',
                                                                       'out_octets': '645646185',
                                                                       'out_ucast_pkts': '7377838',
                                                                       'poller_hash': 'MDAwYzQyNzExYzQzZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:71:1c:42'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_44_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.44.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2467,
                'sta_count': 4,
                'sw_version': '6.44',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 11,
                'dl_en_bytes': 2935441362474,
                'dl_en_packets': 2242019690,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2933528946897,
                'dl_rf_packets': 2231377650,
                'en_if_speed': 100000000,
                'mem': 42.852783203125,
                'serial_number': '728A06616EE4',
                'ssid': 'nwwnetWG3',
                'system_mac_address': '6c:3b:6b:3c:bd:ce',
                'temperature': None,
                'ul_en_bytes': 210198119779,
                'ul_en_packets': 1719965220,
                'ul_noise_floor': -111.0,
                'ul_rf_bytes': 207866442634,
                'ul_rf_packets': 1705174525
        }
        exp_sta_stats = {
                '4c:5e:0c:11:f0:d5': {       'alt_macs': {'4c:5e:0c:11:f0:d4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 18163972,
                                             'dl_rf_packets': 333504,
                                             'dl_rssi': -33.0,
                                             'dl_snr': None,
                                             'ip_address': '10.37.3.24',
                                             'mac_address': '4c:5e:0c:11:f0:d5',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 18215682,
                                             'ul_rf_packets': 334269,
                                             'ul_rssi': -39.0,
                                             'ul_snr': 72.0},
                '4c:5e:0c:65:93:1e': {       'alt_macs': {'4c:5e:0c:65:93:1d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1081973097,
                                             'dl_rf_packets': 4345755,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': '10.37.3.21',
                                             'mac_address': '4c:5e:0c:65:93:1e',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 448047986,
                                             'ul_rf_packets': 3341365,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 49.0},
                '6c:3b:6b:6f:96:a3': {       'alt_macs': {'6c:3b:6b:6f:96:a2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2694855968,
                                             'dl_rf_packets': 354670982,
                                             'dl_rssi': -5.0,
                                             'dl_snr': None,
                                             'ip_address': '10.37.3.254',
                                             'mac_address': '6c:3b:6b:6f:96:a3',
                                             'name': 'BakerCorey-2/14/17',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 2179900196,
                                             'ul_rf_packets': 278233511,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 64.0},
                'd4:ca:6d:13:cd:4d': {       'alt_macs': {'d4:ca:6d:13:cd:4c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1328967961,
                                             'dl_rf_packets': 32707640,
                                             'dl_rssi': -44.0,
                                             'dl_snr': None,
                                             'ip_address': '10.37.3.12',
                                             'mac_address': 'd4:ca:6d:13:cd:4d',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -112.0,
                                             'ul_rf_bytes': 2602734785,
                                             'ul_rf_packets': 25025222,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 66.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2935441362474',
                                                              'in_ucast_pkts': '2242019690',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '6c:3b:6b:3c:bd:ce',
                                                              'mtu': 1500,
                                                              'name': '1-Backhaul',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '210198119779',
                                                              'out_ucast_pkts': '1719965220',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '207866442634',
                                                              'in_ucast_pkts': '1705174525',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2179900196',
                                                                                       'in_ucast_pkts': '278233511',
                                                                                       'mac_address': '6c:3b:6b:6f:96:a3',
                                                                                       'out_octets': '2694855968',
                                                                                       'out_ucast_pkts': '354670982'},
                                                                               {       'in_octets': '2602734785',
                                                                                       'in_ucast_pkts': '25025222',
                                                                                       'mac_address': 'd4:ca:6d:13:cd:4d',
                                                                                       'out_octets': '1328967961',
                                                                                       'out_ucast_pkts': '32707640'},
                                                                               {       'in_octets': '448047986',
                                                                                       'in_ucast_pkts': '3341365',
                                                                                       'mac_address': '4c:5e:0c:65:93:1e',
                                                                                       'out_octets': '1081973097',
                                                                                       'out_ucast_pkts': '4345755'},
                                                                               {       'in_octets': '18215682',
                                                                                       'in_ucast_pkts': '334269',
                                                                                       'mac_address': '4c:5e:0c:11:f0:d5',
                                                                                       'out_octets': '18163972',
                                                                                       'out_ucast_pkts': '333504'}],
                                                              'mac_address': '4c:5e:0c:11:db:05',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2933528946897',
                                                              'out_ucast_pkts': '2231377650',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2467,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '17514302',
                                                                                                                                            'mac_address': '6c:3b:6b:6f:96:a3',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -47.0,
                                                                                                                                            'snr': 64.0},
                                                                                                                                    {       'connected_time': '715256',
                                                                                                                                            'mac_address': 'd4:ca:6d:13:cd:4d',
                                                                                                                                            'noise_floor': -112.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'snr': 66.0},
                                                                                                                                    {       'connected_time': '160539',
                                                                                                                                            'mac_address': '4c:5e:0c:65:93:1e',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 49.0},
                                                                                                                                    {       'connected_time': '11226342',
                                                                                                                                            'mac_address': '4c:5e:0c:11:f0:d5',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -39.0,
                                                                                                                                            'snr': 72.0}],
                                                                                                                   'noise_floor': -111.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'nwwnetWG3'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 42.852783,
                                'model': 'RB411AH',
                                'serial_number': '728A06616EE4',
                                'sw_version': '6.44',
                                'system_mac_address': '6c:3b:6b:3c:bd:ce',
                                'uptime': '18576232'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2694855968',
                                                                       'in_ucast_pkts': '354670982',
                                                                       'links': [       {       'in_octets': '2694855968',
                                                                                                'in_ucast_pkts': '354670982',
                                                                                                'mac_address': '4c:5e:0c:11:db:05',
                                                                                                'out_octets': '2179900196',
                                                                                                'out_ucast_pkts': '278233511'}],
                                                                       'mac_address': '6c:3b:6b:6f:96:a3',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2179900196',
                                                                       'out_ucast_pkts': '278233511',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2467,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '17514302',
                                                                                                                                                     'mac_address': '4c:5e:0c:11:db:05'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWG3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2179900196',
                                                                       'in_ucast_pkts': '278233511',
                                                                       'mac_address': '6c:3b:6b:6f:96:a2',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2694855968',
                                                                       'out_ucast_pkts': '354670982',
                                                                       'poller_hash': 'NmMzYjZiNmY5NmEzZXRoZXIx'}],
                                         'management_ip': '10.37.3.254',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'BakerCorey-2/14/17',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.40',
                                         'system_mac_address': '6c:3b:6b:6f:96:a2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1328967961',
                                                                       'in_ucast_pkts': '32707640',
                                                                       'links': [       {       'in_octets': '1328967961',
                                                                                                'in_ucast_pkts': '32707640',
                                                                                                'mac_address': '4c:5e:0c:11:db:05',
                                                                                                'out_octets': '2602734785',
                                                                                                'out_ucast_pkts': '25025222'}],
                                                                       'mac_address': 'd4:ca:6d:13:cd:4d',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2602734785',
                                                                       'out_ucast_pkts': '25025222',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2467,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '715256',
                                                                                                                                                     'mac_address': '4c:5e:0c:11:db:05'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWG3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2602734785',
                                                                       'in_ucast_pkts': '25025222',
                                                                       'mac_address': 'd4:ca:6d:13:cd:4c',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1328967961',
                                                                       'out_ucast_pkts': '32707640',
                                                                       'poller_hash': 'ZDRjYTZkMTNjZDRkZXRoZXIx'}],
                                         'management_ip': '10.37.3.12',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'd4:ca:6d:13:cd:4c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1081973097',
                                                                       'in_ucast_pkts': '4345755',
                                                                       'links': [       {       'in_octets': '1081973097',
                                                                                                'in_ucast_pkts': '4345755',
                                                                                                'mac_address': '4c:5e:0c:11:db:05',
                                                                                                'out_octets': '448047986',
                                                                                                'out_ucast_pkts': '3341365'}],
                                                                       'mac_address': '4c:5e:0c:65:93:1e',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '448047986',
                                                                       'out_ucast_pkts': '3341365',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2467,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '160539',
                                                                                                                                                     'mac_address': '4c:5e:0c:11:db:05'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWG3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '448047986',
                                                                       'in_ucast_pkts': '3341365',
                                                                       'mac_address': '4c:5e:0c:65:93:1d',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1081973097',
                                                                       'out_ucast_pkts': '4345755',
                                                                       'poller_hash': 'NGM1ZTBjNjU5MzFlZXRoZXIx'}],
                                         'management_ip': '10.37.3.21',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:65:93:1d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '18163972',
                                                                       'in_ucast_pkts': '333504',
                                                                       'links': [       {       'in_octets': '18163972',
                                                                                                'in_ucast_pkts': '333504',
                                                                                                'mac_address': '4c:5e:0c:11:db:05',
                                                                                                'out_octets': '18215682',
                                                                                                'out_ucast_pkts': '334269'}],
                                                                       'mac_address': '4c:5e:0c:11:f0:d5',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '18215682',
                                                                       'out_ucast_pkts': '334269',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2467,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '11226342',
                                                                                                                                                     'mac_address': '4c:5e:0c:11:db:05'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'nwwnetWG3'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '18215682',
                                                                       'in_ucast_pkts': '334269',
                                                                       'mac_address': '4c:5e:0c:11:f0:d4',
                                                                       'name': 'ether1',
                                                                       'out_octets': '18163972',
                                                                       'out_ucast_pkts': '333504',
                                                                       'poller_hash': 'NGM1ZTBjMTFmMGQ1ZXRoZXIx'}],
                                         'management_ip': '10.37.3.24',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:11:f0:d4'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_44_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.44.1.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2417,
                'sta_count': 3,
                'sw_version': '6.44.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 8,
                'dl_en_bytes': 8347668603950,
                'dl_en_packets': 6223819762,
                'dl_noise_floor': None,
                'dl_rf_bytes': 8345150350864,
                'dl_rf_packets': 6201346173,
                'en_if_speed': 100000000,
                'mem': 38.1103515625,
                'serial_number': '6290048419FB',
                'ssid': 'Luellen POP',
                'system_mac_address': '4c:5e:0c:4b:09:f6',
                'temperature': None,
                'ul_en_bytes': 866782746658,
                'ul_en_packets': 4571368926,
                'ul_noise_floor': -111.0,
                'ul_rf_bytes': 863438343020,
                'ul_rf_packets': 4567518390
        }
        exp_sta_stats = {
                '00:0c:42:67:bc:8b': {       'alt_macs': {'00:0c:42:67:bc:8a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 617593104,
                                             'dl_rf_packets': 3429184,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:67:bc:8b',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 192811813,
                                             'ul_rf_packets': 2229541,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 46.0},
                '4c:5e:0c:10:a7:77': {       'alt_macs': {'4c:5e:0c:10:a7:76'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 473897476,
                                             'dl_rf_packets': 316245,
                                             'dl_rssi': -67.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '4c:5e:0c:10:a7:77',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 13262913,
                                             'ul_rf_packets': 184054,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 44.0},
                'e4:8d:8c:2e:65:9e': {       'alt_macs': {'e4:8d:8c:2e:65:9d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1521387827,
                                             'dl_rf_packets': 1102237,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.0.16.179',
                                             'mac_address': 'e4:8d:8c:2e:65:9e',
                                             'name': 'Ron Radford',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -111.0,
                                             'ul_rf_bytes': 143595481,
                                             'ul_rf_packets': 965724,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 50.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 8.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '8347668603950',
                                                              'in_ucast_pkts': '6223819762',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4c:5e:0c:4b:09:f6',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '866782746658',
                                                              'out_ucast_pkts': '4571368926',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '863438343020',
                                                              'in_ucast_pkts': '4567518390',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '192811813',
                                                                                       'in_ucast_pkts': '2229541',
                                                                                       'mac_address': '00:0c:42:67:bc:8b',
                                                                                       'out_octets': '617593104',
                                                                                       'out_ucast_pkts': '3429184'},
                                                                               {       'in_octets': '143595481',
                                                                                       'in_ucast_pkts': '965724',
                                                                                       'mac_address': 'e4:8d:8c:2e:65:9e',
                                                                                       'out_octets': '1521387827',
                                                                                       'out_ucast_pkts': '1102237'},
                                                                               {       'in_octets': '13262913',
                                                                                       'in_ucast_pkts': '184054',
                                                                                       'mac_address': '4c:5e:0c:10:a7:77',
                                                                                       'out_octets': '473897476',
                                                                                       'out_ucast_pkts': '316245'}],
                                                              'mac_address': 'e4:8d:8c:fb:4f:d7',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '8345150350864',
                                                              'out_ucast_pkts': '6201346173',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2417,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '38327',
                                                                                                                                            'mac_address': '00:0c:42:67:bc:8b',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 46.0},
                                                                                                                                    {       'connected_time': '38390',
                                                                                                                                            'mac_address': 'e4:8d:8c:2e:65:9e',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 50.0},
                                                                                                                                    {       'connected_time': '3115',
                                                                                                                                            'mac_address': '4c:5e:0c:10:a7:77',
                                                                                                                                            'noise_floor': -111.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 44.0}],
                                                                                                                   'noise_floor': -111.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Luellen '
                                                                                                 'POP'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 38.11035,
                                'model': 'RB411AH',
                                'serial_number': '6290048419FB',
                                'sw_version': '6.44.1',
                                'system_mac_address': '4c:5e:0c:4b:09:f6',
                                'uptime': '25477900'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '617593104',
                                                                       'in_ucast_pkts': '3429184',
                                                                       'links': [       {       'in_octets': '617593104',
                                                                                                'in_ucast_pkts': '3429184',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:d7',
                                                                                                'out_octets': '192811813',
                                                                                                'out_ucast_pkts': '2229541'}],
                                                                       'mac_address': '00:0c:42:67:bc:8b',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '192811813',
                                                                       'out_ucast_pkts': '2229541',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2417,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '38327',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:d7'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Luellen '
                                                                                                          'POP'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '192811813',
                                                                       'in_ucast_pkts': '2229541',
                                                                       'mac_address': '00:0c:42:67:bc:8a',
                                                                       'name': 'ether1',
                                                                       'out_octets': '617593104',
                                                                       'out_ucast_pkts': '3429184',
                                                                       'poller_hash': 'MDAwYzQyNjdiYzhiZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:67:bc:8a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1521387827',
                                                                       'in_ucast_pkts': '1102237',
                                                                       'links': [       {       'in_octets': '1521387827',
                                                                                                'in_ucast_pkts': '1102237',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:d7',
                                                                                                'out_octets': '143595481',
                                                                                                'out_ucast_pkts': '965724'}],
                                                                       'mac_address': 'e4:8d:8c:2e:65:9e',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '143595481',
                                                                       'out_ucast_pkts': '965724',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2417,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '38390',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:d7'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Luellen '
                                                                                                          'POP'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '143595481',
                                                                       'in_ucast_pkts': '965724',
                                                                       'mac_address': 'e4:8d:8c:2e:65:9d',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1521387827',
                                                                       'out_ucast_pkts': '1102237',
                                                                       'poller_hash': 'ZTQ4ZDhjMmU2NTllZXRoZXIx'}],
                                         'management_ip': '10.0.16.179',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Ron Radford',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.30.4',
                                         'system_mac_address': 'e4:8d:8c:2e:65:9d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '473897476',
                                                                       'in_ucast_pkts': '316245',
                                                                       'links': [       {       'in_octets': '473897476',
                                                                                                'in_ucast_pkts': '316245',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:d7',
                                                                                                'out_octets': '13262913',
                                                                                                'out_ucast_pkts': '184054'}],
                                                                       'mac_address': '4c:5e:0c:10:a7:77',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '13262913',
                                                                       'out_ucast_pkts': '184054',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2417,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3115',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:d7'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211G'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Luellen '
                                                                                                          'POP'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '13262913',
                                                                       'in_ucast_pkts': '184054',
                                                                       'mac_address': '4c:5e:0c:10:a7:76',
                                                                       'name': 'ether1',
                                                                       'out_octets': '473897476',
                                                                       'out_ucast_pkts': '316245',
                                                                       'poller_hash': 'NGM1ZTBjMTBhNzc3ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:10:a7:76'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_44_3_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.44.3.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2407,
                'sta_count': 4,
                'sw_version': '6.44.3',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 4,
                'dl_en_bytes': 97775270693,
                'dl_en_packets': 73863304,
                'dl_noise_floor': None,
                'dl_rf_bytes': 97558347986,
                'dl_rf_packets': 72242182,
                'en_if_speed': 100000000,
                'mem': 39.41650390625,
                'serial_number': '629005366253',
                'ssid': 'BTAP1',
                'system_mac_address': 'e4:8d:8c:f6:bb:b6',
                'temperature': None,
                'ul_en_bytes': 6667496371,
                'ul_en_packets': 54250782,
                'ul_noise_floor': -108.0,
                'ul_rf_bytes': 6370750629,
                'ul_rf_packets': 52819255
        }
        exp_sta_stats = {
                '4c:5e:0c:11:db:08': {       'alt_macs': {'4c:5e:0c:11:db:07'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4111225611,
                                             'dl_rf_packets': 17382090,
                                             'dl_rssi': -49.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '4c:5e:0c:11:db:08',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -108.0,
                                             'ul_rf_bytes': 2411381918,
                                             'ul_rf_packets': 14076620,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 62.0},
                '4c:5e:0c:13:03:30': {       'alt_macs': {'4c:5e:0c:13:03:2f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1125719437,
                                             'dl_rf_packets': 4192364,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.14.0.177',
                                             'mac_address': '4c:5e:0c:13:03:30',
                                             'name': 'HerzogMary',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -108.0,
                                             'ul_rf_bytes': 394390009,
                                             'ul_rf_packets': 3623987,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 54.0},
                '4c:5e:0c:13:04:bc': {       'alt_macs': {'4c:5e:0c:13:04:bb'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3314804195,
                                             'dl_rf_packets': 2799742,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.14.0.165',
                                             'mac_address': '4c:5e:0c:13:04:bc',
                                             'name': 'KauffmanMend',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -107.0,
                                             'ul_rf_bytes': 329823906,
                                             'ul_rf_packets': 2001453,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 46.0},
                'd4:ca:6d:58:26:68': {       'alt_macs': {'d4:ca:6d:58:26:67'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3494192258,
                                             'dl_rf_packets': 43794286,
                                             'dl_rssi': -46.0,
                                             'dl_snr': None,
                                             'ip_address': '10.14.0.254',
                                             'mac_address': 'd4:ca:6d:58:26:68',
                                             'name': 'Kyle King',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -97.0,
                                             'ul_rf_bytes': 2978743272,
                                             'ul_rf_packets': 31050107,
                                             'ul_rssi': -28.0,
                                             'ul_snr': 69.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 4.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '97775270693',
                                                              'in_ucast_pkts': '73863304',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:f6:bb:b6',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '6667496371',
                                                              'out_ucast_pkts': '54250782',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '6370750629',
                                                              'in_ucast_pkts': '52819255',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2978743272',
                                                                                       'in_ucast_pkts': '31050107',
                                                                                       'mac_address': 'd4:ca:6d:58:26:68',
                                                                                       'out_octets': '3494192258',
                                                                                       'out_ucast_pkts': '43794286'},
                                                                               {       'in_octets': '2411381918',
                                                                                       'in_ucast_pkts': '14076620',
                                                                                       'mac_address': '4c:5e:0c:11:db:08',
                                                                                       'out_octets': '4111225611',
                                                                                       'out_ucast_pkts': '17382090'},
                                                                               {       'in_octets': '394390009',
                                                                                       'in_ucast_pkts': '3623987',
                                                                                       'mac_address': '4c:5e:0c:13:03:30',
                                                                                       'out_octets': '1125719437',
                                                                                       'out_ucast_pkts': '4192364'},
                                                                               {       'in_octets': '329823906',
                                                                                       'in_ucast_pkts': '2001453',
                                                                                       'mac_address': '4c:5e:0c:13:04:bc',
                                                                                       'out_octets': '3314804195',
                                                                                       'out_ucast_pkts': '2799742'}],
                                                              'mac_address': 'e4:8d:8c:fb:4f:59',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '97558347986',
                                                              'out_ucast_pkts': '72242182',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2407,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '832406',
                                                                                                                                            'mac_address': 'd4:ca:6d:58:26:68',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -28.0,
                                                                                                                                            'snr': 69.0},
                                                                                                                                    {       'connected_time': '832376',
                                                                                                                                            'mac_address': '4c:5e:0c:11:db:08',
                                                                                                                                            'noise_floor': -108.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'snr': 62.0},
                                                                                                                                    {       'connected_time': '832351',
                                                                                                                                            'mac_address': '4c:5e:0c:13:03:30',
                                                                                                                                            'noise_floor': -108.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'snr': 54.0},
                                                                                                                                    {       'connected_time': '832368',
                                                                                                                                            'mac_address': '4c:5e:0c:13:04:bc',
                                                                                                                                            'noise_floor': -107.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 46.0}],
                                                                                                                   'noise_floor': -108.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BTAP1'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 39.416504,
                                'model': 'RB411AH',
                                'serial_number': '629005366253',
                                'sw_version': '6.44.3',
                                'system_mac_address': 'e4:8d:8c:f6:bb:b6',
                                'uptime': '835906'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3494192258',
                                                                       'in_ucast_pkts': '43794286',
                                                                       'links': [       {       'in_octets': '3494192258',
                                                                                                'in_ucast_pkts': '43794286',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:59',
                                                                                                'out_octets': '2978743272',
                                                                                                'out_ucast_pkts': '31050107'}],
                                                                       'mac_address': 'd4:ca:6d:58:26:68',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2978743272',
                                                                       'out_ucast_pkts': '31050107',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '832406',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BTAP1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2978743272',
                                                                       'in_ucast_pkts': '31050107',
                                                                       'mac_address': 'd4:ca:6d:58:26:67',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3494192258',
                                                                       'out_ucast_pkts': '43794286',
                                                                       'poller_hash': 'ZDRjYTZkNTgyNjY4ZXRoZXIx'}],
                                         'management_ip': '10.14.0.254',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Kyle King',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.42.1',
                                         'system_mac_address': 'd4:ca:6d:58:26:67'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4111225611',
                                                                       'in_ucast_pkts': '17382090',
                                                                       'links': [       {       'in_octets': '4111225611',
                                                                                                'in_ucast_pkts': '17382090',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:59',
                                                                                                'out_octets': '2411381918',
                                                                                                'out_ucast_pkts': '14076620'}],
                                                                       'mac_address': '4c:5e:0c:11:db:08',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2411381918',
                                                                       'out_ucast_pkts': '14076620',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '832376',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BTAP1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2411381918',
                                                                       'in_ucast_pkts': '14076620',
                                                                       'mac_address': '4c:5e:0c:11:db:07',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4111225611',
                                                                       'out_ucast_pkts': '17382090',
                                                                       'poller_hash': 'NGM1ZTBjMTFkYjA4ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '4c:5e:0c:11:db:07'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1125719437',
                                                                       'in_ucast_pkts': '4192364',
                                                                       'links': [       {       'in_octets': '1125719437',
                                                                                                'in_ucast_pkts': '4192364',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:59',
                                                                                                'out_octets': '394390009',
                                                                                                'out_ucast_pkts': '3623987'}],
                                                                       'mac_address': '4c:5e:0c:13:03:30',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '394390009',
                                                                       'out_ucast_pkts': '3623987',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '832351',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BTAP1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '394390009',
                                                                       'in_ucast_pkts': '3623987',
                                                                       'mac_address': '4c:5e:0c:13:03:2f',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1125719437',
                                                                       'out_ucast_pkts': '4192364',
                                                                       'poller_hash': 'NGM1ZTBjMTMwMzMwZXRoZXIx'}],
                                         'management_ip': '10.14.0.177',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'HerzogMary',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.3',
                                         'system_mac_address': '4c:5e:0c:13:03:2f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3314804195',
                                                                       'in_ucast_pkts': '2799742',
                                                                       'links': [       {       'in_octets': '3314804195',
                                                                                                'in_ucast_pkts': '2799742',
                                                                                                'mac_address': 'e4:8d:8c:fb:4f:59',
                                                                                                'out_octets': '329823906',
                                                                                                'out_ucast_pkts': '2001453'}],
                                                                       'mac_address': '4c:5e:0c:13:04:bc',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '329823906',
                                                                       'out_ucast_pkts': '2001453',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2407,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '832368',
                                                                                                                                                     'mac_address': 'e4:8d:8c:fb:4f:59'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BTAP1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '329823906',
                                                                       'in_ucast_pkts': '2001453',
                                                                       'mac_address': '4c:5e:0c:13:04:bb',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3314804195',
                                                                       'out_ucast_pkts': '2799742',
                                                                       'poller_hash': 'NGM1ZTBjMTMwNGJjZXRoZXIx'}],
                                         'management_ip': '10.14.0.165',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'KauffmanMend',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.39.2',
                                         'system_mac_address': '4c:5e:0c:13:04:bb'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_45_2_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.45.2.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 10,
                'rf_freq': 2412,
                'sta_count': 3,
                'sw_version': '6.45.2',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 5,
                'dl_en_bytes': 20911660250,
                'dl_en_packets': 20042504,
                'dl_noise_floor': None,
                'dl_rf_bytes': 20459609903,
                'dl_rf_packets': 16704584,
                'en_if_speed': 100000000,
                'mem': 35.662841796875,
                'serial_number': '62900517A475',
                'ssid': 'MWI NW',
                'system_mac_address': 'e4:8d:8c:f6:bb:b5',
                'temperature': None,
                'ul_en_bytes': 1232170847,
                'ul_en_packets': 11230446,
                'ul_noise_floor': -123.0,
                'ul_rf_bytes': 663446759,
                'ul_rf_packets': 6792556
        }
        exp_sta_stats = {
                '00:0c:42:39:7b:b8': {       'alt_macs': {'00:0c:42:39:7b:b7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 90514843,
                                             'dl_rf_packets': 95793,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:39:7b:b8',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -121.0,
                                             'ul_rf_bytes': 12846339,
                                             'ul_rf_packets': 77401,
                                             'ul_rssi': -73.0,
                                             'ul_snr': 48.0},
                '00:0c:42:67:41:9a': {       'alt_macs': {'00:0c:42:67:41:99'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 138078819,
                                             'dl_rf_packets': 12135123,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:0c:42:67:41:9a',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -121.0,
                                             'ul_rf_bytes': 479627848,
                                             'ul_rf_packets': 5137698,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 59.0},
                '00:15:6d:63:85:ae': {       'alt_macs': {'00:15:6d:63:85:ad'},
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2422202874,
                                             'dl_rf_packets': 1846636,
                                             'dl_rssi': -64.0,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '00:15:6d:63:85:ae',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -123.0,
                                             'ul_rf_bytes': 131751537,
                                             'ul_rf_packets': 1304175,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 53.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 5.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '20911660250',
                                                              'in_ucast_pkts': '20042504',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e4:8d:8c:f6:bb:b5',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1232170847',
                                                              'out_ucast_pkts': '11230446',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '663446759',
                                                              'in_ucast_pkts': '6792556',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '479627848',
                                                                                       'in_ucast_pkts': '5137698',
                                                                                       'mac_address': '00:0c:42:67:41:9a',
                                                                                       'out_octets': '138078819',
                                                                                       'out_ucast_pkts': '12135123'},
                                                                               {       'in_octets': '12846339',
                                                                                       'in_ucast_pkts': '77401',
                                                                                       'mac_address': '00:0c:42:39:7b:b8',
                                                                                       'out_octets': '90514843',
                                                                                       'out_ucast_pkts': '95793'},
                                                                               {       'in_octets': '131751537',
                                                                                       'in_ucast_pkts': '1304175',
                                                                                       'mac_address': '00:15:6d:63:85:ae',
                                                                                       'out_octets': '2422202874',
                                                                                       'out_ucast_pkts': '1846636'}],
                                                              'mac_address': '4c:5e:0c:12:f3:84',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '20459609903',
                                                              'out_ucast_pkts': '16704584',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 2412,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1034410',
                                                                                                                                            'mac_address': '00:0c:42:67:41:9a',
                                                                                                                                            'noise_floor': -121.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'snr': 59.0},
                                                                                                                                    {       'connected_time': '428660',
                                                                                                                                            'mac_address': '00:0c:42:39:7b:b8',
                                                                                                                                            'noise_floor': -121.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'snr': 48.0},
                                                                                                                                    {       'connected_time': '1034421',
                                                                                                                                            'mac_address': '00:15:6d:63:85:ae',
                                                                                                                                            'noise_floor': -123.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'snr': 53.0}],
                                                                                                                   'noise_floor': -123.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MWI '
                                                                                                 'NW'}],
                                                              'speed': '50000000',
                                                              'type': 71},
                                                      {       'admin_up': False,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '4e:5e:0c:12:f3:84',
                                                              'name': 'wlan2',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 35.66284,
                                'model': 'RB411AH',
                                'serial_number': '62900517A475',
                                'sw_version': '6.45.2',
                                'system_mac_address': 'e4:8d:8c:f6:bb:b5',
                                'uptime': '1034451'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '138078819',
                                                                       'in_ucast_pkts': '12135123',
                                                                       'links': [       {       'in_octets': '138078819',
                                                                                                'in_ucast_pkts': '12135123',
                                                                                                'mac_address': '4c:5e:0c:12:f3:84',
                                                                                                'out_octets': '479627848',
                                                                                                'out_ucast_pkts': '5137698'}],
                                                                       'mac_address': '00:0c:42:67:41:9a',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '479627848',
                                                                       'out_ucast_pkts': '5137698',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2412,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1034410',
                                                                                                                                                     'mac_address': '4c:5e:0c:12:f3:84'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MWI '
                                                                                                          'NW'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '479627848',
                                                                       'in_ucast_pkts': '5137698',
                                                                       'mac_address': '00:0c:42:67:41:99',
                                                                       'name': 'ether1',
                                                                       'out_octets': '138078819',
                                                                       'out_ucast_pkts': '12135123',
                                                                       'poller_hash': 'MDAwYzQyNjc0MTlhZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:67:41:99'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '90514843',
                                                                       'in_ucast_pkts': '95793',
                                                                       'links': [       {       'in_octets': '90514843',
                                                                                                'in_ucast_pkts': '95793',
                                                                                                'mac_address': '4c:5e:0c:12:f3:84',
                                                                                                'out_octets': '12846339',
                                                                                                'out_ucast_pkts': '77401'}],
                                                                       'mac_address': '00:0c:42:39:7b:b8',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '12846339',
                                                                       'out_ucast_pkts': '77401',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2412,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '428660',
                                                                                                                                                     'mac_address': '4c:5e:0c:12:f3:84'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MWI '
                                                                                                          'NW'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '12846339',
                                                                       'in_ucast_pkts': '77401',
                                                                       'mac_address': '00:0c:42:39:7b:b7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '90514843',
                                                                       'out_ucast_pkts': '95793',
                                                                       'poller_hash': 'MDAwYzQyMzk3YmI4ZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:0c:42:39:7b:b7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2422202874',
                                                                       'in_ucast_pkts': '1846636',
                                                                       'links': [       {       'in_octets': '2422202874',
                                                                                                'in_ucast_pkts': '1846636',
                                                                                                'mac_address': '4c:5e:0c:12:f3:84',
                                                                                                'out_octets': '131751537',
                                                                                                'out_ucast_pkts': '1304175'}],
                                                                       'mac_address': '00:15:6d:63:85:ae',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '131751537',
                                                                       'out_ucast_pkts': '1304175',
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 2412,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1034421',
                                                                                                                                                     'mac_address': '4c:5e:0c:12:f3:84'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MWI '
                                                                                                          'NW'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '131751537',
                                                                       'in_ucast_pkts': '1304175',
                                                                       'mac_address': '00:15:6d:63:85:ad',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2422202874',
                                                                       'out_ucast_pkts': '1846636',
                                                                       'poller_hash': 'MDAxNTZkNjM4NWFlZXRoZXIx'}],
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:15:6d:63:85:ad'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_ap_RB411AH_6_45_6_01(self):
        obj = self.run_data("mikrotik.mikrotik-ap.RB411AH.6.45.6.01")
        exp_info = {
                'model': 'RB411AH',
                'rf_chan_width': 40,
                'rf_freq': 5765,
                'sta_count': 7,
                'sw_version': '6.45.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 11,
                'dl_en_bytes': 385673092041,
                'dl_en_packets': 307225810,
                'dl_noise_floor': None,
                'dl_rf_bytes': 390739909492,
                'dl_rf_packets': 361993055,
                'en_if_speed': 100000000,
                'mem': 37.36572265625,
                'serial_number': '2DF2010DD72D',
                'ssid': 'hvwisp.com_centercambridge_north',
                'system_mac_address': '00:0c:42:d0:8f:9a',
                'temperature': None,
                'ul_en_bytes': 28049278474,
                'ul_en_packets': 164054650,
                'ul_noise_floor': -102.0,
                'ul_rf_bytes': 27257350217,
                'ul_rf_packets': 160066184
        }
        exp_sta_stats = {
                '00:0c:42:fd:4d:6f': {       'alt_macs': {'00:0c:42:fd:4d:6e'},
                                             'dev_macs': {       '00:0c:42:f8:20:dc',
                                                                 '80:2a:a8:4c:d7:7f',
                                                                 'b8:69:f4:a0:e1:ad'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 556147833,
                                             'dl_rf_packets': 17208586,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.0.8',
                                             'mac_address': '00:0c:42:fd:4d:6f',
                                             'name': 'Center Cambridge - Town Hall',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 1081967335,
                                             'ul_rf_packets': 7472724,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 37.0},
                '00:0c:42:fd:4d:77': {       'alt_macs': {'00:0c:42:fd:4d:76'},
                                             'dev_macs': {'00:0c:42:6c:22:1e'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1895365518,
                                             'dl_rf_packets': 31395638,
                                             'dl_rssi': -57.0,
                                             'dl_snr': None,
                                             'ip_address': '208.71.249.167',
                                             'mac_address': '00:0c:42:fd:4d:77',
                                             'name': 'AndyThomasRadio',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 1907118851,
                                             'ul_rf_packets': 11613602,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 43.0},
                '4c:5e:0c:00:5c:1d': {       'alt_macs': {'4c:5e:0c:00:5c:1c'},
                                             'dev_macs': {'e4:8d:8c:60:7d:fd'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1114604797,
                                             'dl_rf_packets': 28053386,
                                             'dl_rssi': -56.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.0.3',
                                             'mac_address': '4c:5e:0c:00:5c:1d',
                                             'name': 'Bromirski Bridget',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 2010862168,
                                             'ul_rf_packets': 13296850,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 42.0},
                'b8:69:f4:d0:c5:f3': {       'alt_macs': {'b8:69:f4:d0:c5:f2'},
                                             'dev_macs': {'d4:ca:6d:c4:69:35'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1257779310,
                                             'dl_rf_packets': 11406679,
                                             'dl_rssi': -55.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.0.7',
                                             'mac_address': 'b8:69:f4:d0:c5:f3',
                                             'name': 'Landers Michael',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 773462830,
                                             'ul_rf_packets': 4345939,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 43.0},
                'd4:ca:6d:d2:83:93': {       'alt_macs': {'d4:ca:6d:d2:83:92'},
                                             'dev_macs': {'00:0c:42:f8:20:fc'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2036494620,
                                             'dl_rf_packets': 8495273,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.5.6',
                                             'mac_address': 'd4:ca:6d:d2:83:93',
                                             'name': 'Thomas_Farms',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 356145281,
                                             'ul_rf_packets': 1952372,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 45.0},
                'd4:ca:6d:e0:17:83': {       'alt_macs': {'d4:ca:6d:e0:17:82'},
                                             'dev_macs': {'d4:ca:6d:c4:78:e9'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3706443211,
                                             'dl_rf_packets': 105463945,
                                             'dl_rssi': -58.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.0.9',
                                             'mac_address': 'd4:ca:6d:e0:17:83',
                                             'name': 'McGreevy Paul',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 3495611809,
                                             'ul_rf_packets': 50113818,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 41.0},
                'e4:8d:8c:77:ce:bb': {       'alt_macs': {'e4:8d:8c:77:ce:ba'},
                                             'dev_macs': {'6c:3b:6b:ca:37:5d'},
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4254758387,
                                             'dl_rf_packets': 25963450,
                                             'dl_rssi': -52.0,
                                             'dl_snr': None,
                                             'ip_address': '10.22.0.11',
                                             'mac_address': 'e4:8d:8c:77:ce:bb',
                                             'name': 'Koopmann Olive - SXT',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 2100317210,
                                             'ul_rf_packets': 12077036,
                                             'ul_rssi': -53.0,
                                             'ul_snr': 49.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'errors': [{'api_error': {'code': 'AE1000'}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '385673092041',
                                                              'in_ucast_pkts': '307225810',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:0c:42:d0:8f:9a',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '28049278474',
                                                              'out_ucast_pkts': '164054650',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '27257350217',
                                                              'in_ucast_pkts': '160066184',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:0c:42:f8:20:dc',
                                                                                                                        '80:2a:a8:4c:d7:7f',
                                                                                                                        'b8:69:f4:a0:e1:ad'],
                                                                                       'in_octets': '1081967335',
                                                                                       'in_ucast_pkts': '7472724',
                                                                                       'mac_address': '00:0c:42:fd:4d:6f',
                                                                                       'out_octets': '556147833',
                                                                                       'out_ucast_pkts': '17208586'},
                                                                               {       'bridged_mac_addresses': [       '00:0c:42:6c:22:1e'],
                                                                                       'in_octets': '1907118851',
                                                                                       'in_ucast_pkts': '11613602',
                                                                                       'mac_address': '00:0c:42:fd:4d:77',
                                                                                       'out_octets': '1895365518',
                                                                                       'out_ucast_pkts': '31395638'},
                                                                               {       'bridged_mac_addresses': [       'd4:ca:6d:c4:69:35'],
                                                                                       'in_octets': '773462830',
                                                                                       'in_ucast_pkts': '4345939',
                                                                                       'mac_address': 'b8:69:f4:d0:c5:f3',
                                                                                       'out_octets': '1257779310',
                                                                                       'out_ucast_pkts': '11406679'},
                                                                               {       'bridged_mac_addresses': [       '00:0c:42:f8:20:fc'],
                                                                                       'in_octets': '356145281',
                                                                                       'in_ucast_pkts': '1952372',
                                                                                       'mac_address': 'd4:ca:6d:d2:83:93',
                                                                                       'out_octets': '2036494620',
                                                                                       'out_ucast_pkts': '8495273'},
                                                                               {       'bridged_mac_addresses': [       'd4:ca:6d:c4:78:e9'],
                                                                                       'in_octets': '3495611809',
                                                                                       'in_ucast_pkts': '50113818',
                                                                                       'mac_address': 'd4:ca:6d:e0:17:83',
                                                                                       'out_octets': '3706443211',
                                                                                       'out_ucast_pkts': '105463945'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:ca:37:5d'],
                                                                                       'in_octets': '2100317210',
                                                                                       'in_ucast_pkts': '12077036',
                                                                                       'mac_address': 'e4:8d:8c:77:ce:bb',
                                                                                       'out_octets': '4254758387',
                                                                                       'out_ucast_pkts': '25963450'},
                                                                               {       'bridged_mac_addresses': [       'e4:8d:8c:60:7d:fd'],
                                                                                       'in_octets': '2010862168',
                                                                                       'in_ucast_pkts': '13296850',
                                                                                       'mac_address': '4c:5e:0c:00:5c:1d',
                                                                                       'out_octets': '1114604797',
                                                                                       'out_ucast_pkts': '28053386'}],
                                                              'mac_address': '00:0c:42:6c:22:1e',
                                                              'mtu': 1500,
                                                              'name': 'wlan1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '390739909492',
                                                              'out_ucast_pkts': '361993055',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5765,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1966206',
                                                                                                                                            'mac_address': '00:0c:42:fd:4d:6f',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 37.0},
                                                                                                                                    {       'connected_time': '1966205',
                                                                                                                                            'mac_address': '00:0c:42:fd:4d:77',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 43.0},
                                                                                                                                    {       'connected_time': '1966208',
                                                                                                                                            'mac_address': 'b8:69:f4:d0:c5:f3',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 43.0},
                                                                                                                                    {       'connected_time': '1966206',
                                                                                                                                            'mac_address': 'd4:ca:6d:d2:83:93',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'snr': 45.0},
                                                                                                                                    {       'connected_time': '1966207',
                                                                                                                                            'mac_address': 'd4:ca:6d:e0:17:83',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 41.0},
                                                                                                                                    {       'connected_time': '1966209',
                                                                                                                                            'mac_address': 'e4:8d:8c:77:ce:bb',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'snr': 49.0},
                                                                                                                                    {       'connected_time': '869280',
                                                                                                                                            'mac_address': '4c:5e:0c:00:5c:1d',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 42.0}],
                                                                                                                   'noise_floor': -102.0}],
                                                                                        'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'hvwisp.com_centercambridge_north'}],
                                                              'speed': '50000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 37.365723,
                                'model': 'RB411AH',
                                'serial_number': '2DF2010DD72D',
                                'sw_version': '6.45.6',
                                'system_mac_address': '00:0c:42:d0:8f:9a',
                                'uptime': '1966236'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '556147833',
                                                                       'in_ucast_pkts': '17208586',
                                                                       'links': [       {       'in_octets': '556147833',
                                                                                                'in_ucast_pkts': '17208586',
                                                                                                'mac_address': '00:0c:42:6c:22:1e',
                                                                                                'out_octets': '1081967335',
                                                                                                'out_ucast_pkts': '7472724'}],
                                                                       'mac_address': '00:0c:42:fd:4d:6f',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1081967335',
                                                                       'out_ucast_pkts': '7472724',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1966206',
                                                                                                                                                     'mac_address': '00:0c:42:6c:22:1e'}]}],
                                                                                                 'wifi_mode': 'WIFI_STANDARD_80211N'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'hvwisp.com_centercambridge_north'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1081967335',
                                                                       'in_ucast_pkts': '7472724',
                                                                       'mac_address': '00:0c:42:fd:4d:6e',
                                                                       'name': 'ether1',
                                                                       'out_octets': '556147833',
                                                                       'out_ucast_pkts': '17208586',
                                                                       'poller_hash': 'MDAwYzQyZmQ0ZDZmZXRoZXIx'}],
                                         'management_ip': '10.22.0.8',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Center Cambridge - Town Hall',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.6',
                                         'system_mac_address': '00:0c:42:fd:4d:6e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1895365518',
                                                                       'in_ucast_pkts': '31395638',
                                                                       'links': [       {       'in_octets': '1895365518',
                                                                                                'in_ucast_pkts': '31395638',
                                                                                                'mac_address': '00:0c:42:6c:22:1e',
                                                                                                'out_octets': '1907118851',
                                                                                                'out_ucast_pkts': '11613602'}],
                                                                       'mac_address': '00:0c:42:fd:4d:77',
                                                                       'name': 'wlan1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1907118851',
                                                                       'out_ucast_pkts': '11613602',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1966205',
                                                                                                                                                     'mac_address':