import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestAdtranModels(DeviceTestCase):
    def test_adtran_ta5000_TA5000_10_3_2(self):
        obj = self.run_data("adtran.ta5000.TA5000.10.3.2")
        exp_info = {
                'model': 'TA5000',
                'sta_count': 165,
                'sw_version': '10.3.2',
                'vendor': 'Adtran'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                'ADTN20201e5d': {       'dev_macs': ['e8:2c:6d:3c:5a:a0'],
                                        'ip_address': None,
                                        'name': '4@1/10/1',
                                        'serial': 'ADTN20201e5d'},
                'ADTN20201fdc': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1@1/10/5',
                                        'serial': 'ADTN20201fdc'},
                'ADTN20202fb9': {       'dev_macs': ['e8:2c:6d:2a:16:70'],
                                        'ip_address': None,
                                        'name': '2@1/10/4',
                                        'serial': 'ADTN20202fb9'},
                'ADTN20202fc4': {       'dev_macs': ['e8:2c:6d:8d:ce:80'],
                                        'ip_address': None,
                                        'name': '3@1/10/5',
                                        'serial': 'ADTN20202fc4'},
                'ADTN20203579': {       'dev_macs': ['e8:2c:6d:d7:2b:a0'],
                                        'ip_address': None,
                                        'name': '2@1/10/5',
                                        'serial': 'ADTN20203579'},
                'ADTN2020357b': {       'dev_macs': ['c0:56:27:7b:ef:c7'],
                                        'ip_address': None,
                                        'name': '1@1/10/3',
                                        'serial': 'ADTN2020357b'},
                'ADTN202037d4': {       'dev_macs': ['3c:37:86:22:90:e9'],
                                        'ip_address': None,
                                        'name': '1@1/10/2',
                                        'serial': 'ADTN202037d4'},
                'ADTN21134511': {       'dev_macs': ['e8:2c:6d:95:a5:80'],
                                        'ip_address': None,
                                        'name': '7@1/19/2',
                                        'serial': 'ADTN21134511'},
                'ADTN2113459b': {       'dev_macs': ['00:00:00:00:00:34'],
                                        'ip_address': None,
                                        'name': '3@1/19/4',
                                        'serial': 'ADTN2113459b'},
                'ADTN2113459e': {       'dev_macs': ['00:00:00:00:00:41'],
                                        'ip_address': None,
                                        'name': '9@1/19/4',
                                        'serial': 'ADTN2113459e'},
                'ADTN2113461d': {       'dev_macs': ['c0:56:27:74:19:a7'],
                                        'ip_address': None,
                                        'name': '2@1/18/7',
                                        'serial': 'ADTN2113461d'},
                'ADTN21134658': {       'dev_macs': ['e8:2c:6d:d9:2e:30'],
                                        'ip_address': None,
                                        'name': '14@1/18/7',
                                        'serial': 'ADTN21134658'},
                'ADTN21134745': {       'dev_macs': ['e8:2c:6d:75:e2:80'],
                                        'ip_address': None,
                                        'name': '1@1/19/1',
                                        'serial': 'ADTN21134745'},
                'ADTN211348c8': {       'dev_macs': ['e8:2c:6d:3c:0f:00'],
                                        'ip_address': None,
                                        'name': '2@1/10/7',
                                        'serial': 'ADTN211348c8'},
                'ADTN211348e3': {       'dev_macs': ['00:00:00:00:00:21'],
                                        'ip_address': None,
                                        'name': '6@1/18/3',
                                        'serial': 'ADTN211348e3'},
                'ADTN21134ccb': {       'dev_macs': ['60:38:e0:0b:0f:87'],
                                        'ip_address': None,
                                        'name': '3@1/11/1',
                                        'serial': 'ADTN21134ccb'},
                'ADTN21134ccc': {       'dev_macs': ['e8:2c:6d:23:f9:90'],
                                        'ip_address': None,
                                        'name': '2@1/18/8',
                                        'serial': 'ADTN21134ccc'},
                'ADTN21134ccf': {       'dev_macs': ['e8:2c:6d:d7:2d:30'],
                                        'ip_address': None,
                                        'name': '1@1/18/8',
                                        'serial': 'ADTN21134ccf'},
                'ADTN21134cdd': {       'dev_macs': ['00:00:00:00:00:3c'],
                                        'ip_address': None,
                                        'name': '7@1/19/4',
                                        'serial': 'ADTN21134cdd'},
                'ADTN21134ce9': {       'dev_macs': ['00:00:00:00:00:31'],
                                        'ip_address': None,
                                        'name': '2@1/19/4',
                                        'serial': 'ADTN21134ce9'},
                'ADTN21134ceb': {       'dev_macs': ['60:38:e0:9a:11:e8'],
                                        'ip_address': None,
                                        'name': '3@1/18/7',
                                        'serial': 'ADTN21134ceb'},
                'ADTN21134cec': {       'dev_macs': ['e8:2c:6d:bb:6c:b0'],
                                        'ip_address': None,
                                        'name': '1@1/18/7',
                                        'serial': 'ADTN21134cec'},
                'ADTN21134ced': {       'dev_macs': ['e8:2c:6d:96:dd:20'],
                                        'ip_address': None,
                                        'name': '8@1/18/7',
                                        'serial': 'ADTN21134ced'},
                'ADTN21134cee': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '8@1/19/4',
                                        'serial': 'ADTN21134cee'},
                'ADTN21134cf0': {       'dev_macs': ['00:00:00:00:00:36'],
                                        'ip_address': None,
                                        'name': '4@1/19/4',
                                        'serial': 'ADTN21134cf0'},
                'ADTN21134cf5': {       'dev_macs': ['e8:2c:6d:cd:af:e0'],
                                        'ip_address': None,
                                        'name': '8@1/18/3',
                                        'serial': 'ADTN21134cf5'},
                'ADTN21134cf6': {       'dev_macs': ['14:91:82:28:5a:19'],
                                        'ip_address': None,
                                        'name': '7@1/18/3',
                                        'serial': 'ADTN21134cf6'},
                'ADTN21134cf7': {       'dev_macs': ['e8:2c:6d:d7:22:e0'],
                                        'ip_address': None,
                                        'name': '4@1/18/3',
                                        'serial': 'ADTN21134cf7'},
                'ADTN21134cf8': {       'dev_macs': ['c0:56:27:7a:f2:b3'],
                                        'ip_address': None,
                                        'name': '1@1/19/3',
                                        'serial': 'ADTN21134cf8'},
                'ADTN21134cfb': {       'dev_macs': ['e8:2c:6d:23:bf:b0'],
                                        'ip_address': None,
                                        'name': '11@1/18/3',
                                        'serial': 'ADTN21134cfb'},
                'ADTN21134cfc': {       'dev_macs': ['cc:66:18:c5:e5:30'],
                                        'ip_address': None,
                                        'name': '7@1/11/7',
                                        'serial': 'ADTN21134cfc'},
                'ADTN21134cfd': {       'dev_macs': ['00:00:00:00:00:38'],
                                        'ip_address': None,
                                        'name': '5@1/19/4',
                                        'serial': 'ADTN21134cfd'},
                'ADTN21134cfe': {       'dev_macs': ['e8:2c:6d:66:fc:70'],
                                        'ip_address': None,
                                        'name': '5@1/19/1',
                                        'serial': 'ADTN21134cfe'},
                'ADTN21134d00': {       'dev_macs': ['48:f8:b3:38:5a:a4'],
                                        'ip_address': None,
                                        'name': '13@1/18/3',
                                        'serial': 'ADTN21134d00'},
                'ADTN21134d02': {       'dev_macs': ['e8:2c:6d:cd:b2:80'],
                                        'ip_address': None,
                                        'name': '7@1/19/3',
                                        'serial': 'ADTN21134d02'},
                'ADTN21134d87': {       'dev_macs': ['e8:2c:6d:6b:fd:70'],
                                        'ip_address': None,
                                        'name': '1@1/10/7',
                                        'serial': 'ADTN21134d87'},
                'ADTN21134d89': {       'dev_macs': ['e8:2c:6d:d3:be:50'],
                                        'ip_address': None,
                                        'name': '5@1/18/5',
                                        'serial': 'ADTN21134d89'},
                'ADTN21134d8a': {       'dev_macs': ['e8:2c:6d:8d:ad:70'],
                                        'ip_address': None,
                                        'name': '2@1/11/1',
                                        'serial': 'ADTN21134d8a'},
                'ADTN21134da0': {       'dev_macs': ['e8:2c:6d:95:89:60'],
                                        'ip_address': None,
                                        'name': '1@1/18/3',
                                        'serial': 'ADTN21134da0'},
                'ADTN21134da1': {       'dev_macs': ['14:91:82:ba:b3:d9'],
                                        'ip_address': None,
                                        'name': '3@1/18/4',
                                        'serial': 'ADTN21134da1'},
                'ADTN21134da2': {       'dev_macs': ['64:51:06:5c:e6:54'],
                                        'ip_address': None,
                                        'name': '10@1/18/3',
                                        'serial': 'ADTN21134da2'},
                'ADTN21134da3': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '4@1/19/1',
                                        'serial': 'ADTN21134da3'},
                'ADTN21134da6': {       'dev_macs': ['e8:2c:6d:d5:77:00'],
                                        'ip_address': None,
                                        'name': '15@1/18/7',
                                        'serial': 'ADTN21134da6'},
                'ADTN21134dad': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '4@1/19/3',
                                        'serial': 'ADTN21134dad'},
                'ADTN21134daf': {       'dev_macs': ['e8:2c:6d:ba:40:d0'],
                                        'ip_address': None,
                                        'name': '6@1/19/3',
                                        'serial': 'ADTN21134daf'},
                'ADTN21134db4': {       'dev_macs': ['d4:5d:64:41:b0:c8'],
                                        'ip_address': None,
                                        'name': '3@1/19/3',
                                        'serial': 'ADTN21134db4'},
                'ADTN21134dba': {       'dev_macs': ['e8:2c:6d:eb:5d:50'],
                                        'ip_address': None,
                                        'name': '4@1/11/8',
                                        'serial': 'ADTN21134dba'},
                'ADTN21134e6c': {       'dev_macs': ['e8:2c:6d:8d:cc:10'],
                                        'ip_address': None,
                                        'name': '1@1/11/1',
                                        'serial': 'ADTN21134e6c'},
                'ADTN21134e74': {       'dev_macs': ['e8:2c:6d:8d:cb:20'],
                                        'ip_address': None,
                                        'name': '4@1/11/1',
                                        'serial': 'ADTN21134e74'},
                'ADTN21134e75': {       'dev_macs': ['e8:2c:6d:d8:1e:50'],
                                        'ip_address': None,
                                        'name': '2@1/18/4',
                                        'serial': 'ADTN21134e75'},
                'ADTN21134f0c': {       'dev_macs': ['e8:2c:6d:d7:ef:30'],
                                        'ip_address': None,
                                        'name': '7@1/18/8',
                                        'serial': 'ADTN21134f0c'},
                'ADTN2113568a': {       'dev_macs': ['cc:66:18:c2:92:b0'],
                                        'ip_address': None,
                                        'name': '9@1/19/2',
                                        'serial': 'ADTN2113568a'},
                'ADTN2113568c': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '12@1/18/3',
                                        'serial': 'ADTN2113568c'},
                'ADTN2113568e': {       'dev_macs': ['14:91:82:c7:aa:a6'],
                                        'ip_address': None,
                                        'name': '5@1/19/3',
                                        'serial': 'ADTN2113568e'},
                'ADTN2113568f': {       'dev_macs': ['e8:2c:6d:6c:11:10'],
                                        'ip_address': None,
                                        'name': '3@1/11/2',
                                        'serial': 'ADTN2113568f'},
                'ADTN21135690': {       'dev_macs': ['e8:2c:6d:d8:12:40'],
                                        'ip_address': None,
                                        'name': '8@1/19/2',
                                        'serial': 'ADTN21135690'},
                'ADTN21135691': {       'dev_macs': ['cc:66:18:c5:f1:20'],
                                        'ip_address': None,
                                        'name': '10@1/11/3',
                                        'serial': 'ADTN21135691'},
                'ADTN21135692': {       'dev_macs': ['e8:2c:6d:75:df:80'],
                                        'ip_address': None,
                                        'name': '3@1/19/5',
                                        'serial': 'ADTN21135692'},
                'ADTN21135693': {       'dev_macs': ['e8:2c:6d:e7:d8:80'],
                                        'ip_address': None,
                                        'name': '4@1/11/5',
                                        'serial': 'ADTN21135693'},
                'ADTN21135694': {       'dev_macs': ['14:91:82:c7:21:8a'],
                                        'ip_address': None,
                                        'name': '2@1/19/3',
                                        'serial': 'ADTN21135694'},
                'ADTN21135696': {       'dev_macs': ['e8:2c:6d:89:66:76'],
                                        'ip_address': None,
                                        'name': '9@1/11/3',
                                        'serial': 'ADTN21135696'},
                'ADTN21135699': {       'dev_macs': ['e8:2c:6d:3c:62:20'],
                                        'ip_address': None,
                                        'name': '2@1/10/6',
                                        'serial': 'ADTN21135699'},
                'ADTN2113569a': {       'dev_macs': [       'e8:2c:6d:cd:10:40',
                                                            'e0:63:da:40:70:6f'],
                                        'ip_address': None,
                                        'name': '6@1/19/1',
                                        'serial': 'ADTN2113569a'},
                'ADTN2113569c': {       'dev_macs': ['e8:2c:6d:d9:52:70'],
                                        'ip_address': None,
                                        'name': '6@1/19/2',
                                        'serial': 'ADTN2113569c'},
                'ADTN2113569d': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '2@1/18/2',
                                        'serial': 'ADTN2113569d'},
                'ADTN2113569f': {       'dev_macs': ['00:00:00:00:00:3a'],
                                        'ip_address': None,
                                        'name': '6@1/19/4',
                                        'serial': 'ADTN2113569f'},
                'ADTN2113596f': {       'dev_macs': ['e8:2c:6d:9e:fb:b0'],
                                        'ip_address': None,
                                        'name': '2@1/19/5',
                                        'serial': 'ADTN2113596f'},
                'ADTN21135a00': {       'dev_macs': ['e8:2c:6d:9e:7b:20'],
                                        'ip_address': None,
                                        'name': '4@1/11/3',
                                        'serial': 'ADTN21135a00'},
                'ADTN21135a01': {       'dev_macs': ['e8:2c:6d:9e:8e:50'],
                                        'ip_address': None,
                                        'name': '5@1/11/3',
                                        'serial': 'ADTN21135a01'},
                'ADTN21135a02': {       'dev_macs': ['e8:2c:6d:95:8b:10'],
                                        'ip_address': None,
                                        'name': '15@1/18/3',
                                        'serial': 'ADTN21135a02'},
                'ADTN21135a03': {       'dev_macs': ['e8:2c:6d:95:a5:c0'],
                                        'ip_address': None,
                                        'name': '3@1/18/5',
                                        'serial': 'ADTN21135a03'},
                'ADTN21135a04': {       'dev_macs': ['e8:2c:6d:d9:3f:00'],
                                        'ip_address': None,
                                        'name': '1@1/10/4',
                                        'serial': 'ADTN21135a04'},
                'ADTN21135a05': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '6@1/10/1',
                                        'serial': 'ADTN21135a05'},
                'ADTN21135a06': {       'dev_macs': ['14:91:82:bf:a0:26'],
                                        'ip_address': None,
                                        'name': '4@1/19/5',
                                        'serial': 'ADTN21135a06'},
                'ADTN21135a07': {       'dev_macs': ['e8:2c:6d:d5:81:60'],
                                        'ip_address': None,
                                        'name': '1@1/19/2',
                                        'serial': 'ADTN21135a07'},
                'ADTN21135a08': {       'dev_macs': ['e8:2c:6d:9e:7a:70'],
                                        'ip_address': None,
                                        'name': '1@1/18/5',
                                        'serial': 'ADTN21135a08'},
                'ADTN21135a09': {       'dev_macs': ['60:38:e0:92:c4:ce'],
                                        'ip_address': None,
                                        'name': '3@1/19/2',
                                        'serial': 'ADTN21135a09'},
                'ADTN21135a0b': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1@1/18/6',
                                        'serial': 'ADTN21135a0b'},
                'ADTN21135a28': {       'dev_macs': ['e8:2c:6d:96:e4:c0'],
                                        'ip_address': None,
                                        'name': '4@1/18/7',
                                        'serial': 'ADTN21135a28'},
                'ADTN21135a2b': {       'dev_macs': ['e8:2c:6d:3c:16:30'],
                                        'ip_address': None,
                                        'name': '5@1/18/8',
                                        'serial': 'ADTN21135a2b'},
                'ADTN21135a2c': {       'dev_macs': ['3c:37:86:8f:ed:b2'],
                                        'ip_address': None,
                                        'name': '7@1/19/1',
                                        'serial': 'ADTN21135a2c'},
                'ADTN21135a32': {       'dev_macs': ['e8:2c:6d:6b:da:40'],
                                        'ip_address': None,
                                        'name': '7@1/18/2',
                                        'serial': 'ADTN21135a32'},
                'ADTN21135a33': {       'dev_macs': ['e8:2c:6d:8d:e8:00'],
                                        'ip_address': None,
                                        'name': '6@1/18/8',
                                        'serial': 'ADTN21135a33'},
                'ADTN21135a34': {       'dev_macs': ['e8:2c:6d:75:e8:50'],
                                        'ip_address': None,
                                        'name': '3@1/11/4',
                                        'serial': 'ADTN21135a34'},
                'ADTN21135a3b': {       'dev_macs': ['e8:2c:6d:ce:10:40'],
                                        'ip_address': None,
                                        'name': '1@1/11/2',
                                        'serial': 'ADTN21135a3b'},
                'ADTN21135a43': {       'dev_macs': ['e8:2c:6d:63:8c:50'],
                                        'ip_address': None,
                                        'name': '2@1/19/2',
                                        'serial': 'ADTN21135a43'},
                'ADTN21135a44': {       'dev_macs': ['e8:2c:6d:23:fa:80'],
                                        'ip_address': None,
                                        'name': '2@1/18/5',
                                        'serial': 'ADTN21135a44'},
                'ADTN21135a45': {       'dev_macs': ['e8:2c:6d:95:89:b0'],
                                        'ip_address': None,
                                        'name': '6@1/18/2',
                                        'serial': 'ADTN21135a45'},
                'ADTN21135a46': {       'dev_macs': ['00:22:3f:ce:1c:43'],
                                        'ip_address': None,
                                        'name': '4@1/18/8',
                                        'serial': 'ADTN21135a46'},
                'ADTN21135a47': {       'dev_macs': ['e8:2c:6d:ed:b5:20'],
                                        'ip_address': None,
                                        'name': '1@1/11/7',
                                        'serial': 'ADTN21135a47'},
                'ADTN21135a4a': {       'dev_macs': ['e8:2c:6d:3b:bc:40'],
                                        'ip_address': None,
                                        'name': '10@1/18/7',
                                        'serial': 'ADTN21135a4a'},
                'ADTN21135a4b': {       'dev_macs': ['c4:41:1e:c0:3d:de'],
                                        'ip_address': None,
                                        'name': '9@1/18/7',
                                        'serial': 'ADTN21135a4b'},
                'ADTN21135a4c': {       'dev_macs': ['e8:2c:6d:ce:3c:60'],
                                        'ip_address': None,
                                        'name': '1@1/11/3',
                                        'serial': 'ADTN21135a4c'},
                'ADTN21135a4d': {       'dev_macs': ['e8:2c:6d:bb:6a:20'],
                                        'ip_address': None,
                                        'name': '1@1/11/5',
                                        'serial': 'ADTN21135a4d'},
                'ADTN21135a4f': {       'dev_macs': ['e8:2c:6d:cd:b1:20'],
                                        'ip_address': None,
                                        'name': '7@1/11/3',
                                        'serial': 'ADTN21135a4f'},
                'ADTN21135a52': {       'dev_macs': ['e8:2c:6d:eb:59:d0'],
                                        'ip_address': None,
                                        'name': '3@1/18/3',
                                        'serial': 'ADTN21135a52'},
                'ADTN21135a53': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '4@1/18/6',
                                        'serial': 'ADTN21135a53'},
                'ADTN21135a54': {       'dev_macs': ['e8:2c:6d:eb:5a:20'],
                                        'ip_address': None,
                                        'name': '2@1/19/1',
                                        'serial': 'ADTN21135a54'},
                'ADTN21135a56': {       'dev_macs': ['e8:2c:6d:8d:a9:c0'],
                                        'ip_address': None,
                                        'name': '5@1/18/6',
                                        'serial': 'ADTN21135a56'},
                'ADTN21135ae3': {       'dev_macs': ['e8:2c:6d:d5:86:00'],
                                        'ip_address': None,
                                        'name': '2@1/11/8',
                                        'serial': 'ADTN21135ae3'},
                'ADTN21135ae9': {       'dev_macs': ['e8:2c:6d:ba:3b:30'],
                                        'ip_address': None,
                                        'name': '3@1/11/8',
                                        'serial': 'ADTN21135ae9'},
                'ADTN21135aea': {       'dev_macs': ['c8:b3:73:29:1d:8d'],
                                        'ip_address': None,
                                        'name': '5@1/11/8',
                                        'serial': 'ADTN21135aea'},
                'ADTN21135aec': {       'dev_macs': ['e8:2c:6d:23:ef:a0'],
                                        'ip_address': None,
                                        'name': '12@1/18/7',
                                        'serial': 'ADTN21135aec'},
                'ADTN21135af1': {       'dev_macs': ['e8:2c:6d:d5:87:60'],
                                        'ip_address': None,
                                        'name': '6@1/18/5',
                                        'serial': 'ADTN21135af1'},
                'ADTN21135afa': {       'dev_macs': ['e8:2c:6d:d5:d0:40'],
                                        'ip_address': None,
                                        'name': '1@1/11/6',
                                        'serial': 'ADTN21135afa'},
                'ADTN21135afb': {       'dev_macs': ['e8:2c:6d:ba:46:e0'],
                                        'ip_address': None,
                                        'name': '1@1/11/4',
                                        'serial': 'ADTN21135afb'},
                'ADTN21135afd': {       'dev_macs': [       '48:21:0b:48:9b:53',
                                                            'e8:2c:6d:67:00:b0'],
                                        'ip_address': None,
                                        'name': '9@1/18/3',
                                        'serial': 'ADTN21135afd'},
                'ADTN21135afe': {       'dev_macs': ['cc:66:18:c7:ae:90'],
                                        'ip_address': None,
                                        'name': '1@1/18/4',
                                        'serial': 'ADTN21135afe'},
                'ADTN21135aff': {       'dev_macs': ['e8:2c:6d:bb:6c:e0'],
                                        'ip_address': None,
                                        'name': '5@1/18/2',
                                        'serial': 'ADTN21135aff'},
                'ADTN21135b00': {       'dev_macs': ['e8:2c:6d:d5:72:10'],
                                        'ip_address': None,
                                        'name': '3@1/11/6',
                                        'serial': 'ADTN21135b00'},
                'ADTN21135b01': {       'dev_macs': ['e8:2c:6d:95:8a:d0'],
                                        'ip_address': None,
                                        'name': '2@1/11/7',
                                        'serial': 'ADTN21135b01'},
                'ADTN21135b02': {       'dev_macs': ['90:72:40:05:ff:63'],
                                        'ip_address': None,
                                        'name': '2@1/11/5',
                                        'serial': 'ADTN21135b02'},
                'ADTN21135b03': {       'dev_macs': ['e8:2c:6d:d7:17:c0'],
                                        'ip_address': None,
                                        'name': '8@1/18/6',
                                        'serial': 'ADTN21135b03'},
                'ADTN21135b04': {       'dev_macs': ['cc:66:18:c0:d6:e0'],
                                        'ip_address': None,
                                        'name': '2@1/18/1',
                                        'serial': 'ADTN21135b04'},
                'ADTN21135b05': {       'dev_macs': ['e8:2c:6d:e8:70:40'],
                                        'ip_address': None,
                                        'name': '3@1/18/1',
                                        'serial': 'ADTN21135b05'},
                'ADTN21135b06': {       'dev_macs': ['e8:2c:6d:d4:53:00'],
                                        'ip_address': None,
                                        'name': '5@1/18/3',
                                        'serial': 'ADTN21135b06'},
                'ADTN21135b07': {       'dev_macs': ['e8:2c:6d:3c:10:80'],
                                        'ip_address': None,
                                        'name': '5@1/11/7',
                                        'serial': 'ADTN21135b07'},
                'ADTN21135b09': {       'dev_macs': ['e8:2c:6d:8d:af:70'],
                                        'ip_address': None,
                                        'name': '6@1/11/3',
                                        'serial': 'ADTN21135b09'},
                'ADTN21135b0a': {       'dev_macs': ['e8:2c:6d:ce:42:10'],
                                        'ip_address': None,
                                        'name': '6@1/11/7',
                                        'serial': 'ADTN21135b0a'},
                'ADTN21135b0b': {       'dev_macs': ['e8:2c:6d:ce:3e:60'],
                                        'ip_address': None,
                                        'name': '4@1/19/2',
                                        'serial': 'ADTN21135b0b'},
                'ADTN21135b0c': {       'dev_macs': ['e8:2c:6d:75:e3:a0'],
                                        'ip_address': None,
                                        'name': '2@1/11/2',
                                        'serial': 'ADTN21135b0c'},
                'ADTN21135b0d': {       'dev_macs': ['e8:2c:6d:ba:3a:50'],
                                        'ip_address': None,
                                        'name': '3@1/11/3',
                                        'serial': 'ADTN21135b0d'},
                'ADTN21135b0e': {       'dev_macs': ['e8:2c:6d:95:88:e0'],
                                        'ip_address': None,
                                        'name': '4@1/18/1',
                                        'serial': 'ADTN21135b0e'},
                'ADTN21135b0f': {       'dev_macs': ['e8:2c:6d:8d:ab:80'],
                                        'ip_address': None,
                                        'name': '2@1/11/3',
                                        'serial': 'ADTN21135b0f'},
                'ADTN21135b10': {       'dev_macs': ['e8:2c:6d:3c:ad:80'],
                                        'ip_address': None,
                                        'name': '4@1/11/7',
                                        'serial': 'ADTN21135b10'},
                'ADTN21135b11': {       'dev_macs': ['e8:2c:6d:eb:5c:80'],
                                        'ip_address': None,
                                        'name': '4@1/11/6',
                                        'serial': 'ADTN21135b11'},
                'ADTN21135b12': {       'dev_macs': ['e8:2c:6d:6c:28:50'],
                                        'ip_address': None,
                                        'name': '5@1/19/2',
                                        'serial': 'ADTN21135b12'},
                'ADTN21135b13': {       'dev_macs': ['cc:66:18:c5:f1:40'],
                                        'ip_address': None,
                                        'name': '2@1/11/6',
                                        'serial': 'ADTN21135b13'},
                'ADTN21135b14': {       'dev_macs': ['e8:2c:6d:89:65:a0'],
                                        'ip_address': None,
                                        'name': '3@1/11/7',
                                        'serial': 'ADTN21135b14'},
                'ADTN21135b15': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '6@1/18/1',
                                        'serial': 'ADTN21135b15'},
                'ADTN21135b16': {       'dev_macs': ['cc:66:18:c5:e0:30'],
                                        'ip_address': None,
                                        'name': '3@1/18/2',
                                        'serial': 'ADTN21135b16'},
                'ADTN21135b18': {       'dev_macs': ['e8:2c:6d:3c:5a:30'],
                                        'ip_address': None,
                                        'name': '14@1/18/3',
                                        'serial': 'ADTN21135b18'},
                'ADTN21135b19': {       'dev_macs': ['e8:2c:6d:ce:14:90'],
                                        'ip_address': None,
                                        'name': '10@1/19/2',
                                        'serial': 'ADTN21135b19'},
                'ADTN21135b1a': {       'dev_macs': ['e8:2c:6d:7c:aa:40'],
                                        'ip_address': None,
                                        'name': '4@1/18/5',
                                        'serial': 'ADTN21135b1a'},
                'ADTN21135b1b': {       'dev_macs': ['e8:2c:6d:e8:6e:e0'],
                                        'ip_address': None,
                                        'name': '4@1/10/5',
                                        'serial': 'ADTN21135b1b'},
                'ADTN21135b1c': {       'dev_macs': ['48:f8:b3:58:78:e1'],
                                        'ip_address': None,
                                        'name': '2@1/11/4',
                                        'serial': 'ADTN21135b1c'},
                'ADTN21135b1d': {       'dev_macs': ['e8:2c:6d:8d:a9:e0'],
                                        'ip_address': None,
                                        'name': '5@1/18/1',
                                        'serial': 'ADTN21135b1d'},
                'ADTN21135b1e': {       'dev_macs': ['e8:2c:6d:d7:33:70'],
                                        'ip_address': None,
                                        'name': '2@1/18/3',
                                        'serial': 'ADTN21135b1e'},
                'ADTN21135b1f': {       'dev_macs': ['cc:66:18:ce:19:e0'],
                                        'ip_address': None,
                                        'name': '1@1/19/5',
                                        'serial': 'ADTN21135b1f'},
                'ADTN21135b20': {       'dev_macs': ['e8:2c:6d:d5:87:d0'],
                                        'ip_address': None,
                                        'name': '1@1/11/8',
                                        'serial': 'ADTN21135b20'},
                'ADTN21135b21': {       'dev_macs': ['e8:2c:6d:d6:52:10'],
                                        'ip_address': None,
                                        'name': '7@1/18/7',
                                        'serial': 'ADTN21135b21'},
                'ADTN21135b23': {       'dev_macs': ['e8:2c:6d:3c:ad:50'],
                                        'ip_address': None,
                                        'name': '4@1/11/2',
                                        'serial': 'ADTN21135b23'},
                'ADTN21135b26': {       'dev_macs': ['e8:2c:6d:8d:cd:60'],
                                        'ip_address': None,
                                        'name': '3@1/11/5',
                                        'serial': 'ADTN21135b26'},
                'ADTN21135b27': {       'dev_macs': ['e8:2c:6d:29:6f:50'],
                                        'ip_address': None,
                                        'name': '8@1/11/3',
                                        'serial': 'ADTN21135b27'},
                'ADTN21135b28': {       'dev_macs': ['c8:b3:73:4a:0d:fe'],
                                        'ip_address': None,
                                        'name': '7@1/18/4',
                                        'serial': 'ADTN21135b28'},
                'ADTN21135b2a': {       'dev_macs': ['14:91:82:bc:0d:26'],
                                        'ip_address': None,
                                        'name': '1@1/18/2',
                                        'serial': 'ADTN21135b2a'},
                'ADTN21135b2b': {       'dev_macs': ['e8:2c:6d:9e:8b:b0'],
                                        'ip_address': None,
                                        'name': '3@1/19/1',
                                        'serial': 'ADTN21135b2b'},
                'ADTN21135b2c': {       'dev_macs': ['e8:2c:6d:ba:3c:30'],
                                        'ip_address': None,
                                        'name': '1@1/18/1',
                                        'serial': 'ADTN21135b2c'},
                'ADTN21135b31': {       'dev_macs': ['e8:2c:6d:eb:57:70'],
                                        'ip_address': None,
                                        'name': '6@1/18/7',
                                        'serial': 'ADTN21135b31'},
                'ADTN21135b32': {       'dev_macs': ['e8:2c:6d:d5:97:50'],
                                        'ip_address': None,
                                        'name': '6@1/18/4',
                                        'serial': 'ADTN21135b32'},
                'ADTN21135b33': {       'dev_macs': ['e8:2c:6d:3b:c3:b0'],
                                        'ip_address': None,
                                        'name': '5@1/18/4',
                                        'serial': 'ADTN21135b33'},
                'ADTN21135b34': {       'dev_macs': ['e8:2c:6d:6c:0e:20'],
                                        'ip_address': None,
                                        'name': '2@1/18/6',
                                        'serial': 'ADTN21135b34'},
                'ADTN21135b36': {       'dev_macs': ['e8:2c:6d:ba:44:f0'],
                                        'ip_address': None,
                                        'name': '3@1/18/6',
                                        'serial': 'ADTN21135b36'},
                'ADTN21135b37': {       'dev_macs': ['e8:2c:6d:8d:ac:d0'],
                                        'ip_address': None,
                                        'name': '4@1/18/4',
                                        'serial': 'ADTN21135b37'},
                'ADTN21135b38': {       'dev_macs': ['20:23:51:93:17:d1'],
                                        'ip_address': None,
                                        'name': '8@1/18/4',
                                        'serial': 'ADTN21135b38'},
                'ADTN21135b3b': {       'dev_macs': ['e8:2c:6d:d8:1c:f0'],
                                        'ip_address': None,
                                        'name': '6@1/18/6',
                                        'serial': 'ADTN21135b3b'},
                'ADTN21135b3c': {       'dev_macs': ['e8:2c:6d:d7:35:80'],
                                        'ip_address': None,
                                        'name': '5@1/18/7',
                                        'serial': 'ADTN21135b3c'},
                'ADTN21135b3e': {       'dev_macs': ['ac:16:2d:96:ca:10'],
                                        'ip_address': None,
                                        'name': '11@1/18/7',
                                        'serial': 'ADTN21135b3e'},
                'ADTN21135b42': {       'dev_macs': ['60:38:e0:9e:47:80'],
                                        'ip_address': None,
                                        'name': '7@1/18/6',
                                        'serial': 'ADTN21135b42'},
                'ADTN21135ba0': {       'dev_macs': ['60:38:e0:07:28:cf'],
                                        'ip_address': None,
                                        'name': '13@1/18/7',
                                        'serial': 'ADTN21135ba0'},
                'ADTN21135d63': {       'dev_macs': ['e8:2c:6d:18:a7:90'],
                                        'ip_address': None,
                                        'name': '3@1/18/8',
                                        'serial': 'ADTN21135d63'},
                'IPHO0050d250': {       'dev_macs': ['14:91:82:2f:35:a3'],
                                        'ip_address': None,
                                        'name': '2@1/10/1',
                                        'serial': 'IPHO0050d250'},
                'IPHO0050d25c': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '3@1/10/1',
                                        'serial': 'IPHO0050d25c'},
                'TSLS59957214': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1@1/10/1',
                                        'serial': 'TSLS59957214'},
                'adtn21135999': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '8@1/19/3',
                                        'serial': 'adtn21135999'}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Adtran',
                                'model': 'TA5000',
                                'modules': [       {       'id': '1',
                                                           'manufacturer': 'Adtran',
                                                           'mem': 60.098522,
                                                           'model': '1187800L1',
                                                           'name': 'DS1 VG',
                                                           'poller_hash': 'TEJBRFROMjA0MEFHODgxMTE4NzgwMEwx',
                                                           'serial_number': 'LBADTN2040AG881',
                                                           'sw_version': 'K32.0007',
                                                           'temperature': 36.5,
                                                           'uptime': '109411502'},
                                                   {       'id': '10',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1000001',
                                                                                         'in_octets': '13784',
                                                                                         'in_ucast_pkts': '99',
                                                                                         'links': [       {       'in_octets': '13784',
                                                                                                                  'in_ucast_pkts': '99',
                                                                                                                  'out_octets': '8206',
                                                                                                                  'out_ucast_pkts': '7',
                                                                                                                  'poller_hash': 'QURUTjIwMjAxZTVkSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '8206',
                                                                                         'out_ucast_pkts': '7',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyUFJMRUFBQkI3MTEw',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/1',
                                                                                                                 'id': '1000001',
                                                                                                                 'links': [       {       'connected_time': '7283926',
                                                                                                                                          'fiber_length': 243,
                                                                                                                                          'poller_hash': 'QURUTjIwMjAxZTVk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/1',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyUFJMRUFBQkI3MTEwZ3Bvbg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000002',
                                                                                         'in_octets': '7101',
                                                                                         'in_ucast_pkts': '38',
                                                                                         'links': [       {       'in_octets': '7101',
                                                                                                                  'in_ucast_pkts': '38',
                                                                                                                  'out_octets': '5855',
                                                                                                                  'out_ucast_pkts': '60',
                                                                                                                  'poller_hash': 'QURUTjIwMjAzN2Q0SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '5855',
                                                                                         'out_ucast_pkts': '60',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDE2NjE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/2',
                                                                                                                 'id': '1000002',
                                                                                                                 'links': [       {       'connected_time': '53574378',
                                                                                                                                          'fiber_length': 14887,
                                                                                                                                          'poller_hash': 'QURUTjIwMjAzN2Q0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/2',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDE2NjFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000003',
                                                                                         'in_octets': '5379247',
                                                                                         'in_ucast_pkts': '31539',
                                                                                         'links': [       {       'in_octets': '5379247',
                                                                                                                  'in_ucast_pkts': '31539',
                                                                                                                  'out_octets': '45012566',
                                                                                                                  'out_ucast_pkts': '38910',
                                                                                                                  'poller_hash': 'QURUTjIwMjAzNTdiSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '45012566',
                                                                                         'out_ucast_pkts': '38910',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyOTM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/3',
                                                                                                                 'id': '1000003',
                                                                                                                 'links': [       {       'connected_time': '3186960',
                                                                                                                                          'poller_hash': 'QURUTjIwMjAzNTdi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/3',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyOTNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000004',
                                                                                         'in_octets': '2532051788',
                                                                                         'in_ucast_pkts': '830334970',
                                                                                         'links': [       {       'in_octets': '2527466497',
                                                                                                                  'in_ucast_pkts': '830294784',
                                                                                                                  'out_octets': '4258403603',
                                                                                                                  'out_ucast_pkts': '1824371630',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTA0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4585291',
                                                                                                                  'in_ucast_pkts': '40186',
                                                                                                                  'out_octets': '171619495',
                                                                                                                  'out_ucast_pkts': '123917',
                                                                                                                  'poller_hash': 'QURUTjIwMjAyZmI5SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '4430023098',
                                                                                         'out_ucast_pkts': '1824495547',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTk=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/4',
                                                                                                                 'id': '1000004',
                                                                                                                 'links': [       {       'connected_time': '43735507',
                                                                                                                                          'fiber_length': 4107,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '2685526',
                                                                                                                                          'fiber_length': 3907,
                                                                                                                                          'poller_hash': 'QURUTjIwMjAyZmI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/4',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTlncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000005',
                                                                                         'in_octets': '655845957',
                                                                                         'in_ucast_pkts': '612718017',
                                                                                         'links': [       {       'in_octets': '2472917',
                                                                                                                  'in_ucast_pkts': '38132',
                                                                                                                  'out_octets': '382232031',
                                                                                                                  'out_ucast_pkts': '285990',
                                                                                                                  'poller_hash': 'QURUTjIwMjAzNTc5SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '494607',
                                                                                                                  'in_ucast_pkts': '1921',
                                                                                                                  'out_octets': '1450925',
                                                                                                                  'out_ucast_pkts': '2416',
                                                                                                                  'poller_hash': 'QURUTjIwMjAyZmM0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '652878433',
                                                                                                                  'in_ucast_pkts': '612677964',
                                                                                                                  'out_octets': '3756796516',
                                                                                                                  'out_ucast_pkts': '1266466277',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFiSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '4140479472',
                                                                                         'out_ucast_pkts': '1266754683',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/5',
                                                                                                                 'id': '1000005',
                                                                                                                 'links': [       {       'connected_time': '362139',
                                                                                                                                          'fiber_length': 6861,
                                                                                                                                          'poller_hash': 'QURUTjIwMjAzNTc5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '23263923',
                                                                                                                                          'fiber_length': 1460,
                                                                                                                                          'poller_hash': 'QURUTjIwMjAyZmM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '8477039',
                                                                                                                                          'fiber_length': 1401,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/5',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000006',
                                                                                         'in_octets': '3276006619',
                                                                                         'in_ucast_pkts': '3298958345',
                                                                                         'links': [       {       'in_octets': '3276006619',
                                                                                                                  'in_ucast_pkts': '3298958345',
                                                                                                                  'out_octets': '1838134681',
                                                                                                                  'out_ucast_pkts': '1381424241',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1Njk5SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/6',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '1838134681',
                                                                                         'out_ucast_pkts': '1381424241',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDA2Mzg=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/6',
                                                                                                                 'id': '1000006',
                                                                                                                 'links': [       {       'connected_time': '25942854',
                                                                                                                                          'fiber_length': 10297,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njk5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/6',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDA2MzhncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1000007',
                                                                                         'in_octets': '719689215',
                                                                                         'in_ucast_pkts': '6534204391',
                                                                                         'links': [       {       'in_octets': '4812949',
                                                                                                                  'in_ucast_pkts': '4087232796',
                                                                                                                  'out_octets': '6012203',
                                                                                                                  'out_ucast_pkts': '1187185388',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZDg3SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '714876266',
                                                                                                                  'in_ucast_pkts': '2446971595',
                                                                                                                  'out_octets': '384827800',
                                                                                                                  'out_ucast_pkts': '1868780107',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0OGM4SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/10/7',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '390840003',
                                                                                         'out_ucast_pkts': '3055965495',
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/10/7',
                                                                                                                 'id': '1000007',
                                                                                                                 'links': [       {       'connected_time': '87347153',
                                                                                                                                          'fiber_length': 8538,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZDg3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '19179518',
                                                                                                                                          'fiber_length': 6830,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0OGM4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/10/7',
                                                                                                                 'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1000008',
                                                                                         'name': '1/10/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkxOUFBMTkyMTAwMDAwOA==',
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 16.965004,
                                                           'model': '1187503F1',
                                                           'name': 'GPON OLT',
                                                           'poller_hash': 'TEJBRFROMTkxOUFBMTkyMTE4NzUwM0Yx',
                                                           'serial_number': 'LBADTN1919AA192',
                                                           'sw_version': '10.3.36',
                                                           'temperature': 49.8,
                                                           'uptime': '111895803'},
                                                   {       'id': '11',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1100001',
                                                                                         'in_octets': '13293708239',
                                                                                         'in_ucast_pkts': '2552048831',
                                                                                         'links': [       {       'in_octets': '2809181571',
                                                                                                                  'in_ucast_pkts': '383981918',
                                                                                                                  'out_octets': '3771058361',
                                                                                                                  'out_ucast_pkts': '866518761',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZTZjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4214051390',
                                                                                                                  'in_ucast_pkts': '310481672',
                                                                                                                  'out_octets': '2659930178',
                                                                                                                  'out_ucast_pkts': '657077673',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZDhhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4007470490',
                                                                                                                  'in_ucast_pkts': '1780185222',
                                                                                                                  'out_octets': '1955375011',
                                                                                                                  'out_ucast_pkts': '3922397876',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2NiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2263004788',
                                                                                                                  'in_ucast_pkts': '77400019',
                                                                                                                  'out_octets': '1300533569',
                                                                                                                  'out_ucast_pkts': '203170506',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZTc0SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442540F1',
                                                                                         'name': '1/11/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '9686897119',
                                                                                         'out_ucast_pkts': '5649164816',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/1',
                                                                                                                 'id': '1100001',
                                                                                                                 'links': [       {       'connected_time': '5896831',
                                                                                                                                          'fiber_length': 10009,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZTZj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4405189',
                                                                                                                                          'fiber_length': 20079,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZDhh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '22047504',
                                                                                                                                          'fiber_length': 8262,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Ni',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2774129',
                                                                                                                                          'fiber_length': 18534,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZTc0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/1',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTZncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100002',
                                                                                         'in_octets': '8925596906',
                                                                                         'in_ucast_pkts': '9127656227',
                                                                                         'links': [       {       'in_octets': '3596858482',
                                                                                                                  'in_ucast_pkts': '2890494131',
                                                                                                                  'out_octets': '3268757737',
                                                                                                                  'out_ucast_pkts': '2013647696',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTNiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3451049243',
                                                                                                                  'in_ucast_pkts': '2648372126',
                                                                                                                  'out_octets': '3813333546',
                                                                                                                  'out_ucast_pkts': '537210750',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '716167687',
                                                                                                                  'in_ucast_pkts': '480855517',
                                                                                                                  'out_octets': '4259862530',
                                                                                                                  'out_ucast_pkts': '1070478462',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjhmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1161521494',
                                                                                                                  'in_ucast_pkts': '3107934453',
                                                                                                                  'out_octets': '996151002',
                                                                                                                  'out_ucast_pkts': '2670320784',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjIzSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442540F1',
                                                                                         'name': '1/11/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '12338104815',
                                                                                         'out_ucast_pkts': '6291657692',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0Tlc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/2',
                                                                                                                 'id': '1100002',
                                                                                                                 'links': [       {       'connected_time': '30672989',
                                                                                                                                          'fiber_length': 19272,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTNi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '61782155',
                                                                                                                                          'fiber_length': 18105,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '25371101',
                                                                                                                                          'fiber_length': 17578,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njhm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '66283198',
                                                                                                                                          'fiber_length': 16514,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/2',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0TldncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100003',
                                                                                         'in_discards': '1',
                                                                                         'in_octets': '20990663740',
                                                                                         'in_ucast_pkts': '9610055395',
                                                                                         'links': [       {       'in_octets': '2027452934',
                                                                                                                  'in_ucast_pkts': '1744213145',
                                                                                                                  'out_octets': '1745206234',
                                                                                                                  'out_ucast_pkts': '29457623',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTRjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1985815995',
                                                                                                                  'in_ucast_pkts': '833255705',
                                                                                                                  'out_octets': '448778747',
                                                                                                                  'out_ucast_pkts': '1615555184',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1057054808',
                                                                                                                  'in_ucast_pkts': '1226685681',
                                                                                                                  'out_octets': '3059936212',
                                                                                                                  'out_ucast_pkts': '1645214816',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1381989118',
                                                                                                                  'in_ucast_pkts': '291366068',
                                                                                                                  'out_octets': '2330086653',
                                                                                                                  'out_ucast_pkts': '511448551',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTAwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1604476805',
                                                                                                                  'in_ucast_pkts': '458247204',
                                                                                                                  'out_octets': '181298735',
                                                                                                                  'out_ucast_pkts': '754614476',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTAxSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3049307702',
                                                                                                                  'in_ucast_pkts': '382284769',
                                                                                                                  'out_octets': '3220287148',
                                                                                                                  'out_ucast_pkts': '716230020',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjA5SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3002407483',
                                                                                                                  'in_ucast_pkts': '2987949427',
                                                                                                                  'out_octets': '3445314662',
                                                                                                                  'out_ucast_pkts': '4236413975',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTRmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2606693294',
                                                                                                                  'in_ucast_pkts': '38785153',
                                                                                                                  'out_octets': '1225963708',
                                                                                                                  'out_ucast_pkts': '93733019',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjI3SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3618437214',
                                                                                                                  'in_ucast_pkts': '1212002224',
                                                                                                                  'out_octets': '3085353583',
                                                                                                                  'out_ucast_pkts': '3173602645',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1Njk2SURpbnRmUmVn'},
                                                                                                          {       'in_discards': '1',
                                                                                                                  'in_octets': '657028387',
                                                                                                                  'in_ucast_pkts': '435266019',
                                                                                                                  'out_octets': '3120980034',
                                                                                                                  'out_ucast_pkts': '1078362669',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjkxSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442540F1',
                                                                                         'name': '1/11/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '21863205716',
                                                                                         'out_ucast_pkts': '13854632978',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/3',
                                                                                                                 'id': '1100003',
                                                                                                                 'links': [       {       'connected_time': '71122154',
                                                                                                                                          'fiber_length': 17801,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTRj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '9428517',
                                                                                                                                          'fiber_length': 17919,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '76561140',
                                                                                                                                          'fiber_length': 19012,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '31119008',
                                                                                                                                          'fiber_length': 19206,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTAw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '76561100',
                                                                                                                                          'fiber_length': 18907,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '9444470',
                                                                                                                                          'fiber_length': 18157,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '52199858',
                                                                                                                                          'fiber_length': 18125,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTRm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '668861',
                                                                                                                                          'fiber_length': 19811,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjI3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '24539698',
                                                                                                                                          'fiber_length': 17117,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njk2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '17897989',
                                                                                                                                          'fiber_length': 19147,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njkx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/3',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100004',
                                                                                         'in_discards': '8',
                                                                                         'in_errors': '2',
                                                                                         'in_octets': '6963140911',
                                                                                         'in_ucast_pkts': '3356009296',
                                                                                         'links': [       {       'in_octets': '1249670662',
                                                                                                                  'in_ucast_pkts': '103144487',
                                                                                                                  'out_octets': '3003120729',
                                                                                                                  'out_ucast_pkts': '231493127',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWZiSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '8',
                                                                                                                  'in_errors': '2',
                                                                                                                  'in_octets': '2334730018',
                                                                                                                  'in_ucast_pkts': '1337614799',
                                                                                                                  'out_octets': '3906167266',
                                                                                                                  'out_ucast_pkts': '2014018712',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3378740231',
                                                                                                                  'in_ucast_pkts': '1915250010',
                                                                                                                  'out_octets': '3044108321',
                                                                                                                  'out_ucast_pkts': '4022739561',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTM0SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442540F1',
                                                                                         'name': '1/11/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '9953396316',
                                                                                         'out_ucast_pkts': '6268251400',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/4',
                                                                                                                 'id': '1100004',
                                                                                                                 'links': [       {       'connected_time': '4089966',
                                                                                                                                          'fiber_length': 15010,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWZi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '74060843',
                                                                                                                                          'fiber_length': 13993,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '48813806',
                                                                                                                                          'fiber_length': 15835,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/4',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkZncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100005',
                                                                                         'in_octets': '9736965609',
                                                                                         'in_ucast_pkts': '5598621112',
                                                                                         'links': [       {       'in_octets': '1602256384',
                                                                                                                  'in_ucast_pkts': '1244841013',
                                                                                                                  'out_octets': '3200964647',
                                                                                                                  'out_ucast_pkts': '3981781887',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTRkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1729240216',
                                                                                                                  'in_ucast_pkts': '1602267716',
                                                                                                                  'out_octets': '2690101578',
                                                                                                                  'out_ucast_pkts': '2685460522',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjAySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3458387619',
                                                                                                                  'in_ucast_pkts': '1872014179',
                                                                                                                  'out_octets': '675095625',
                                                                                                                  'out_ucast_pkts': '59866596',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjI2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2947081390',
                                                                                                                  'in_ucast_pkts': '879498204',
                                                                                                                  'out_octets': '2365229199',
                                                                                                                  'out_ucast_pkts': '3232173003',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjkzSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/11/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '8931391049',
                                                                                         'out_ucast_pkts': '9959282008',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/5',
                                                                                                                 'id': '1100005',
                                                                                                                 'links': [       {       'connected_time': '74052790',
                                                                                                                                          'fiber_length': 10788,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTRk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '21087388',
                                                                                                                                          'fiber_length': 12093,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '74049861',
                                                                                                                                          'fiber_length': 12273,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjI2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '17879404',
                                                                                                                                          'fiber_length': 11006,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njkz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/5',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100006',
                                                                                         'in_octets': '10934066183',
                                                                                         'in_ucast_pkts': '6674239037',
                                                                                         'links': [       {       'in_octets': '1769787544',
                                                                                                                  'in_ucast_pkts': '919332309',
                                                                                                                  'out_octets': '3321036465',
                                                                                                                  'out_ucast_pkts': '2613445521',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWZhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2631085652',
                                                                                                                  'in_ucast_pkts': '4175946209',
                                                                                                                  'out_octets': '1486871793',
                                                                                                                  'out_ucast_pkts': '3372068063',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjEzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4148545627',
                                                                                                                  'in_ucast_pkts': '17481478',
                                                                                                                  'out_octets': '3997603273',
                                                                                                                  'out_ucast_pkts': '30325285',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjAwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2384647360',
                                                                                                                  'in_ucast_pkts': '1561479041',
                                                                                                                  'out_octets': '2419022164',
                                                                                                                  'out_ucast_pkts': '3472817297',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjExSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/11/6',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '11224533695',
                                                                                         'out_ucast_pkts': '9488656166',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1I=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/6',
                                                                                                                 'id': '1100006',
                                                                                                                 'links': [       {       'connected_time': '20308543',
                                                                                                                                          'fiber_length': 8905,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWZh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '21369456',
                                                                                                                                          'fiber_length': 9810,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjEz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -12.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '364212',
                                                                                                                                          'fiber_length': 11512,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjAw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '25486462',
                                                                                                                                          'fiber_length': 11318,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjEx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/6',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1JncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100007',
                                                                                         'in_discards': '6461400',
                                                                                         'in_errors': '5250447',
                                                                                         'in_octets': '15363018638',
                                                                                         'in_ucast_pkts': '2294901870',
                                                                                         'links': [       {       'in_discards': '6461400',
                                                                                                                  'in_errors': '5250447',
                                                                                                                  'in_octets': '3089812757',
                                                                                                                  'in_ucast_pkts': '801878411',
                                                                                                                  'out_octets': '1386361750',
                                                                                                                  'out_ucast_pkts': '1313446041',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjAxSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3986982231',
                                                                                                                  'in_ucast_pkts': '279623830',
                                                                                                                  'out_octets': '2330232258',
                                                                                                                  'out_ucast_pkts': '452747265',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjE0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '290172207',
                                                                                                                  'in_ucast_pkts': '1897807',
                                                                                                                  'out_octets': '3506458004',
                                                                                                                  'out_ucast_pkts': '3012702',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjEwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4138208958',
                                                                                                                  'in_ucast_pkts': '281688258',
                                                                                                                  'out_octets': '813302132',
                                                                                                                  'out_ucast_pkts': '3833390920',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjA3SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '6155278',
                                                                                                                  'in_ucast_pkts': '707795555',
                                                                                                                  'out_ucast_pkts': '4294967278',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3851687207',
                                                                                                                  'in_ucast_pkts': '222018009',
                                                                                                                  'out_octets': '473132879',
                                                                                                                  'out_ucast_pkts': '437984119',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2ZjSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/11/7',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '8509487023',
                                                                                         'out_ucast_pkts': '10335548325',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/7',
                                                                                                                 'id': '1100007',
                                                                                                                 'links': [       {       'connected_time': '17653540',
                                                                                                                                          'fiber_length': 21171,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '16699322',
                                                                                                                                          'fiber_length': 17764,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjE0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '12199',
                                                                                                                                          'fiber_length': 18154,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '73979106',
                                                                                                                                          'fiber_length': 17759,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '2338426',
                                                                                                                                          'fiber_length': 18582,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '600846',
                                                                                                                                          'fiber_length': 21615,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Zj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/7',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1100008',
                                                                                         'in_discards': '1',
                                                                                         'in_octets': '8606398327',
                                                                                         'in_ucast_pkts': '1739648743',
                                                                                         'links': [       {       'in_octets': '3111495899',
                                                                                                                  'in_ucast_pkts': '36216328',
                                                                                                                  'out_octets': '3482649245',
                                                                                                                  'out_ucast_pkts': '121724564',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjIwSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '1',
                                                                                                                  'in_octets': '189469386',
                                                                                                                  'in_ucast_pkts': '634425303',
                                                                                                                  'out_octets': '400265061',
                                                                                                                  'out_ucast_pkts': '1513615898',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWUzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4214783908',
                                                                                                                  'in_ucast_pkts': '34471877',
                                                                                                                  'out_octets': '847319012',
                                                                                                                  'out_ucast_pkts': '72156828',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWU5SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '122082069',
                                                                                                                  'in_ucast_pkts': '986654995',
                                                                                                                  'out_octets': '648197685',
                                                                                                                  'out_ucast_pkts': '1879627385',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGJhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '968567065',
                                                                                                                  'in_ucast_pkts': '47880240',
                                                                                                                  'out_octets': '1130321548',
                                                                                                                  'out_ucast_pkts': '103248888',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWVhSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/11/8',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '6508752551',
                                                                                         'out_ucast_pkts': '3690373563',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/11/8',
                                                                                                                 'id': '1100008',
                                                                                                                 'links': [       {       'connected_time': '669150',
                                                                                                                                          'fiber_length': 14982,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '19386522',
                                                                                                                                          'fiber_length': 14013,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWUz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '668910',
                                                                                                                                          'fiber_length': 14437,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWU5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '15118269',
                                                                                                                                          'fiber_length': 14827,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGJh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '667528',
                                                                                                                                          'fiber_length': 15063,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWVh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/11/8',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 17.814169,
                                                           'model': '1187503F1',
                                                           'name': 'GPON OLT',
                                                           'poller_hash': 'TEJBRFROMTkzM0FDNTk4MTE4NzUwM0Yx',
                                                           'serial_number': 'LBADTN1933AC598',
                                                           'sw_version': '10.3.36',
                                                           'temperature': 51.2,
                                                           'uptime': '111894852'},
                                                   {       'id': '13',
                                                           'manufacturer': 'Adtran',
                                                           'mem': 19.7443,
                                                           'model': '1187130F1',
                                                           'name': 'VDSL48PCOMBO',
                                                           'poller_hash': 'TEJBRFROMTkyMEFDOTM4MTE4NzEzMEYx',
                                                           'serial_number': 'LBADTN1920AC938',
                                                           'sw_version': 'K32.0007',
                                                           'temperature': 59.0,
                                                           'uptime': '111901580'},
                                                   {       'id': '15',
                                                           'manufacturer': 'Adtran',
                                                           'mem': 7.393962,
                                                           'model': '1187151F1',
                                                           'name': 'RPOTS-48P',
                                                           'poller_hash': 'TEJBRFROMjAxM0FLODQxMTE4NzE1MUYx',
                                                           'serial_number': 'LBADTN2013AK841',
                                                           'sw_version': 'K32.0007',
                                                           'temperature': 30.0,
                                                           'uptime': '111902223'},
                                                   {       'id': '18',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1800001',
                                                                                         'in_octets': '7619637721',
                                                                                         'in_ucast_pkts': '6030539878',
                                                                                         'links': [       {       'in_octets': '8710029',
                                                                                                                  'in_ucast_pkts': '1016436271',
                                                                                                                  'out_octets': '1405054727',
                                                                                                                  'out_ucast_pkts': '2556892307',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjJjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '927737999',
                                                                                                                  'in_ucast_pkts': '2148830349',
                                                                                                                  'out_octets': '3637181696',
                                                                                                                  'out_ucast_pkts': '383952819',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjA0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3863797334',
                                                                                                                  'in_ucast_pkts': '918433962',
                                                                                                                  'out_octets': '147360823',
                                                                                                                  'out_ucast_pkts': '1980299460',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjA1SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1126009012',
                                                                                                                  'in_ucast_pkts': '271188079',
                                                                                                                  'out_octets': '927220640',
                                                                                                                  'out_ucast_pkts': '696439027',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBlSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1693383347',
                                                                                                                  'in_ucast_pkts': '1675651217',
                                                                                                                  'out_octets': '542138790',
                                                                                                                  'out_ucast_pkts': '3313487145',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFkSURpbnRmUmVn'},
                                                                                                          {       'poller_hash': 'QURUTjIxMTM1YjE1SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '6658956676',
                                                                                         'out_ucast_pkts': '8931070758',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/1',
                                                                                                                 'id': '1800001',
                                                                                                                 'links': [       {       'connected_time': '49611637',
                                                                                                                                          'fiber_length': 12907,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjJj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49793332',
                                                                                                                                          'fiber_length': 12869,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '9440270',
                                                                                                                                          'fiber_length': 12575,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '14104497',
                                                                                                                                          'fiber_length': 12304,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49791187',
                                                                                                                                          'fiber_length': 10933,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49788815',
                                                                                                                                          'fiber_length': 11173,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjE1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/1',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800002',
                                                                                         'in_discards': '37',
                                                                                         'in_octets': '8841547359',
                                                                                         'in_ucast_pkts': '7452092425',
                                                                                         'links': [       {       'in_octets': '2842631825',
                                                                                                                  'in_ucast_pkts': '1705281630',
                                                                                                                  'out_octets': '2480093508',
                                                                                                                  'out_ucast_pkts': '3324933389',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjJhSURpbnRmUmVn'},
                                                                                                          {       'poller_hash': 'QURUTjIxMTM1NjlkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1474975785',
                                                                                                                  'in_ucast_pkts': '2900712968',
                                                                                                                  'out_octets': '2222890840',
                                                                                                                  'out_ucast_pkts': '2138027658',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjE2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '882780321',
                                                                                                                  'in_ucast_pkts': '2109471025',
                                                                                                                  'out_octets': '3804319367',
                                                                                                                  'out_ucast_pkts': '4041098936',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWZmSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '37',
                                                                                                                  'in_octets': '3071981828',
                                                                                                                  'in_ucast_pkts': '73859957',
                                                                                                                  'out_octets': '3776065813',
                                                                                                                  'out_ucast_pkts': '175006694',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTQ1SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '569177600',
                                                                                                                  'in_ucast_pkts': '662766845',
                                                                                                                  'out_octets': '3992388025',
                                                                                                                  'out_ucast_pkts': '1456902910',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTMySURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '16275757553',
                                                                                         'out_ucast_pkts': '11135969587',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/2',
                                                                                                                 'id': '1800002',
                                                                                                                 'links': [       {       'connected_time': '49792012',
                                                                                                                                          'fiber_length': 13230,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjJh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '12894942',
                                                                                                                                          'fiber_length': 12461,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njlk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '1298644',
                                                                                                                                          'fiber_length': 12725,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '29993129',
                                                                                                                                          'fiber_length': 12761,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWZm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '668577',
                                                                                                                                          'fiber_length': 13276,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '24980595',
                                                                                                                                          'fiber_length': 13943,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTMy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/2',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800003',
                                                                                         'in_discards': '4',
                                                                                         'in_errors': '1',
                                                                                         'in_octets': '26488362018',
                                                                                         'in_ucast_pkts': '10105865309',
                                                                                         'links': [       {       'in_octets': '334582124',
                                                                                                                  'in_ucast_pkts': '437379274',
                                                                                                                  'out_octets': '2917590018',
                                                                                                                  'out_ucast_pkts': '1042043720',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGEwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1079411488',
                                                                                                                  'in_ucast_pkts': '1724884558',
                                                                                                                  'out_octets': '4025074970',
                                                                                                                  'out_ucast_pkts': '3247432224',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFlSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1608572388',
                                                                                                                  'in_ucast_pkts': '2165876167',
                                                                                                                  'out_octets': '297363197',
                                                                                                                  'out_ucast_pkts': '2090609259',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTUySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2302695311',
                                                                                                                  'in_ucast_pkts': '303965756',
                                                                                                                  'out_octets': '888036758',
                                                                                                                  'out_ucast_pkts': '3644579416',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjA2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1145820218',
                                                                                                                  'in_ucast_pkts': '803514247',
                                                                                                                  'out_octets': '725232018',
                                                                                                                  'out_ucast_pkts': '1933220575',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2Y2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3974264988',
                                                                                                                  'in_ucast_pkts': '770043178',
                                                                                                                  'out_octets': '1802805468',
                                                                                                                  'out_ucast_pkts': '2321320550',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2Y1SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '530610776',
                                                                                                                  'in_ucast_pkts': '46238536',
                                                                                                                  'out_octets': '3240616243',
                                                                                                                  'out_ucast_pkts': '95964373',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWZkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4163487054',
                                                                                                                  'in_ucast_pkts': '1317022660',
                                                                                                                  'out_octets': '238436300',
                                                                                                                  'out_ucast_pkts': '2861498677',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGEySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4059742876',
                                                                                                                  'in_ucast_pkts': '1953565068',
                                                                                                                  'out_octets': '751460085',
                                                                                                                  'out_ucast_pkts': '1197844993',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2ZiSURpbnRmUmVn'},
                                                                                                          {       'poller_hash': 'QURUTjIxMTM1NjhjSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '4',
                                                                                                                  'in_errors': '1',
                                                                                                                  'in_octets': '2235993923',
                                                                                                                  'in_ucast_pkts': '542961992',
                                                                                                                  'out_octets': '258176338',
                                                                                                                  'out_ucast_pkts': '1092003369',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZDAwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1575497348',
                                                                                                                  'in_ucast_pkts': '22483481',
                                                                                                                  'out_octets': '1881202355',
                                                                                                                  'out_ucast_pkts': '34492055',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjE4SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3477683524',
                                                                                                                  'in_ucast_pkts': '17930392',
                                                                                                                  'out_octets': '1195514517',
                                                                                                                  'out_ucast_pkts': '45243949',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTAySURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442540F1',
                                                                                         'name': '1/18/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '18221508267',
                                                                                         'out_ucast_pkts': '19606253160',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/3',
                                                                                                                 'id': '1800003',
                                                                                                                 'links': [       {       'connected_time': '28426412',
                                                                                                                                          'fiber_length': 504,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '28431144',
                                                                                                                                          'fiber_length': 1988,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '28340764',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTUy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '28426332',
                                                                                                                                          'fiber_length': 927,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '28426372',
                                                                                                                                          'fiber_length': 1095,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Y2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '28426352',
                                                                                                                                          'fiber_length': 884,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Y1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '4244604',
                                                                                                                                          'fiber_length': 704,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWZk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '12385445',
                                                                                                                                          'fiber_length': 983,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGEy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '20283474',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Zi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '11154824',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njhj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '8121038',
                                                                                                                                          'fiber_length': 2074,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZDAw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '14095517',
                                                                                                                                          'fiber_length': 2610,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjE4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '2192177',
                                                                                                                                          'fiber_length': 2838,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -12.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/3',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800004',
                                                                                         'in_discards': '147098',
                                                                                         'in_errors': '122201',
                                                                                         'in_octets': '15247021830',
                                                                                         'in_ucast_pkts': '13629841353',
                                                                                         'links': [       {       'in_octets': '2996819400',
                                                                                                                  'in_ucast_pkts': '1442116003',
                                                                                                                  'out_octets': '2380616506',
                                                                                                                  'out_ucast_pkts': '3289571422',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWZlSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3936645757',
                                                                                                                  'in_ucast_pkts': '548586361',
                                                                                                                  'out_octets': '2946446259',
                                                                                                                  'out_ucast_pkts': '1243680952',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZTc1SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '859406904',
                                                                                                                  'in_ucast_pkts': '2344784964',
                                                                                                                  'out_octets': '3039780548',
                                                                                                                  'out_ucast_pkts': '208961772',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGExSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1162244313',
                                                                                                                  'in_ucast_pkts': '3807566084',
                                                                                                                  'out_octets': '1331507867',
                                                                                                                  'out_ucast_pkts': '3992374483',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjM3SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1632767158',
                                                                                                                  'in_ucast_pkts': '2724706255',
                                                                                                                  'out_octets': '4144836983',
                                                                                                                  'out_ucast_pkts': '1563186036',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjMzSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '147098',
                                                                                                                  'in_errors': '122201',
                                                                                                                  'in_octets': '1969205000',
                                                                                                                  'in_ucast_pkts': '109428213',
                                                                                                                  'out_octets': '789611021',
                                                                                                                  'out_ucast_pkts': '153914956',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjMySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1237473722',
                                                                                                                  'in_ucast_pkts': '2212369775',
                                                                                                                  'out_octets': '448230972',
                                                                                                                  'out_ucast_pkts': '1792023812',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjI4SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1452459576',
                                                                                                                  'in_ucast_pkts': '440283698',
                                                                                                                  'out_octets': '4203800565',
                                                                                                                  'out_ucast_pkts': '1711887492',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjM4SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '19284830721',
                                                                                         'out_ucast_pkts': '13955600925',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBLUDc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/4',
                                                                                                                 'id': '1800004',
                                                                                                                 'links': [       {       'connected_time': '22116579',
                                                                                                                                          'fiber_length': 3110,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWZl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '34805725',
                                                                                                                                          'fiber_length': 4262,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZTc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '3392891',
                                                                                                                                          'fiber_length': 6603,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGEx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '49612488',
                                                                                                                                          'fiber_length': 8462,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '36716834',
                                                                                                                                          'fiber_length': 4771,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjMz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '31125454',
                                                                                                                                          'fiber_length': 6698,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjMy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '13937527',
                                                                                                                                          'fiber_length': 5849,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjI4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '7973823',
                                                                                                                                          'fiber_length': 8652,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjM4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/4',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBLUDdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800005',
                                                                                         'in_octets': '9095352799',
                                                                                         'in_ucast_pkts': '7969593639',
                                                                                         'links': [       {       'in_octets': '924804638',
                                                                                                                  'in_ucast_pkts': '1376548811',
                                                                                                                  'out_octets': '627882856',
                                                                                                                  'out_ucast_pkts': '3120716924',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTA4SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2791262411',
                                                                                                                  'in_ucast_pkts': '43235003',
                                                                                                                  'out_octets': '3075191533',
                                                                                                                  'out_ucast_pkts': '160295008',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTQ0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1319321081',
                                                                                                                  'in_ucast_pkts': '110291809',
                                                                                                                  'out_octets': '3356132477',
                                                                                                                  'out_ucast_pkts': '293447654',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTAzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2816770933',
                                                                                                                  'in_ucast_pkts': '411076273',
                                                                                                                  'out_octets': '486784196',
                                                                                                                  'out_ucast_pkts': '1179582560',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '844052855',
                                                                                                                  'in_ucast_pkts': '1776846158',
                                                                                                                  'out_octets': '452314853',
                                                                                                                  'out_ucast_pkts': '178677714',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZDg5SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '399140881',
                                                                                                                  'in_ucast_pkts': '4251595585',
                                                                                                                  'out_octets': '3261804321',
                                                                                                                  'out_ucast_pkts': '1982785',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWYxSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '11260110236',
                                                                                         'out_ucast_pkts': '4934702645',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBORjE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/5',
                                                                                                                 'id': '1800005',
                                                                                                                 'links': [       {       'connected_time': '49705813',
                                                                                                                                          'fiber_length': 15858,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '669329',
                                                                                                                                          'fiber_length': 14001,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '5785152',
                                                                                                                                          'fiber_length': 13910,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '9936419',
                                                                                                                                          'fiber_length': 12629,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '21365691',
                                                                                                                                          'fiber_length': 11901,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZDg5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49703466',
                                                                                                                                          'fiber_length': 11736,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/5',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBORjFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800006',
                                                                                         'in_octets': '21285882621',
                                                                                         'in_ucast_pkts': '9054871787',
                                                                                         'links': [       {       'in_octets': '2537719762',
                                                                                                                  'in_ucast_pkts': '2397011',
                                                                                                                  'out_octets': '1186557865',
                                                                                                                  'out_ucast_pkts': '4466553',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTBiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4204659295',
                                                                                                                  'in_ucast_pkts': '1712648843',
                                                                                                                  'out_octets': '1004427439',
                                                                                                                  'out_ucast_pkts': '3851987959',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjM0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3407808506',
                                                                                                                  'in_ucast_pkts': '479398726',
                                                                                                                  'out_octets': '1266276751',
                                                                                                                  'out_ucast_pkts': '1371524762',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjM2SURpbnRmUmVn'},
                                                                                                          {       'poller_hash': 'QURUTjIxMTM1YTUzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2566137678',
                                                                                                                  'in_ucast_pkts': '2770760610',
                                                                                                                  'out_octets': '1337945229',
                                                                                                                  'out_ucast_pkts': '1556847853',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTU2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4213165805',
                                                                                                                  'in_ucast_pkts': '553973536',
                                                                                                                  'out_octets': '1452939588',
                                                                                                                  'out_ucast_pkts': '1607178186',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjNiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3371744428',
                                                                                                                  'in_ucast_pkts': '1039202244',
                                                                                                                  'out_octets': '3665268755',
                                                                                                                  'out_ucast_pkts': '1782984597',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjQySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '984647147',
                                                                                                                  'in_ucast_pkts': '2496490817',
                                                                                                                  'out_octets': '3921026776',
                                                                                                                  'out_ucast_pkts': '3285256898',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjAzSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/6',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '13834442403',
                                                                                         'out_ucast_pkts': '13460246808',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkNVMDAzRDQ=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/6',
                                                                                                                 'id': '1800006',
                                                                                                                 'links': [       {       'connected_time': '49700181',
                                                                                                                                          'fiber_length': 10404,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTBi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49702490',
                                                                                                                                          'fiber_length': 9060,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -12.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '33692502',
                                                                                                                                          'fiber_length': 10603,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjM2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49696649',
                                                                                                                                          'fiber_length': 10619,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTUz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '48658465',
                                                                                                                                          'fiber_length': 10608,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTU2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '22987591',
                                                                                                                                          'fiber_length': 10559,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjNi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49699639',
                                                                                                                                          'fiber_length': 11058,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjQy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '49599086',
                                                                                                                                          'fiber_length': 9411,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/6',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkNVMDAzRDRncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800007',
                                                                                         'in_discards': '4260',
                                                                                         'in_errors': '1',
                                                                                         'in_octets': '28358583704',
                                                                                         'in_ucast_pkts': '14964591065',
                                                                                         'links': [       {       'in_octets': '1416498165',
                                                                                                                  'in_ucast_pkts': '1801180229',
                                                                                                                  'out_octets': '713669505',
                                                                                                                  'out_ucast_pkts': '3179547903',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2VjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2293778893',
                                                                                                                  'in_ucast_pkts': '12792220',
                                                                                                                  'out_octets': '4132794712',
                                                                                                                  'out_ucast_pkts': '8124816',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0NjFkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2417782027',
                                                                                                                  'in_ucast_pkts': '1363543999',
                                                                                                                  'out_octets': '1113236802',
                                                                                                                  'out_ucast_pkts': '2933034331',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2ViSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1321361551',
                                                                                                                  'in_ucast_pkts': '13751456',
                                                                                                                  'out_octets': '943985440',
                                                                                                                  'out_ucast_pkts': '27729484',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTI4SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3283830513',
                                                                                                                  'in_ucast_pkts': '124470568',
                                                                                                                  'out_octets': '1097758174',
                                                                                                                  'out_ucast_pkts': '177091428',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjNjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2106622569',
                                                                                                                  'in_ucast_pkts': '187476222',
                                                                                                                  'out_octets': '2816566250',
                                                                                                                  'out_ucast_pkts': '337140801',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjMxSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '695107209',
                                                                                                                  'in_ucast_pkts': '1896208166',
                                                                                                                  'out_octets': '3704580340',
                                                                                                                  'out_ucast_pkts': '1141046103',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjIxSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '51229395',
                                                                                                                  'in_ucast_pkts': '1153154981',
                                                                                                                  'out_octets': '1092632388',
                                                                                                                  'out_ucast_pkts': '2644716242',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2VkSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '4118',
                                                                                                                  'in_octets': '2217968562',
                                                                                                                  'in_ucast_pkts': '951714240',
                                                                                                                  'out_octets': '2946593025',
                                                                                                                  'out_ucast_pkts': '1958615203',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTRiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1819303989',
                                                                                                                  'in_ucast_pkts': '530425732',
                                                                                                                  'out_octets': '1504740190',
                                                                                                                  'out_ucast_pkts': '706800617',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTRhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3641191289',
                                                                                                                  'in_ucast_pkts': '2992691899',
                                                                                                                  'out_octets': '3273649499',
                                                                                                                  'out_ucast_pkts': '1469638756',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjNlSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '463490669',
                                                                                                                  'in_ucast_pkts': '2671431854',
                                                                                                                  'out_octets': '679615619',
                                                                                                                  'out_ucast_pkts': '588881956',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YWVjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1553999686',
                                                                                                                  'in_ucast_pkts': '125002004',
                                                                                                                  'out_octets': '2294841579',
                                                                                                                  'out_ucast_pkts': '248923752',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YmEwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2322726161',
                                                                                                                  'in_ucast_pkts': '899142237',
                                                                                                                  'out_octets': '4065818761',
                                                                                                                  'out_ucast_pkts': '2413208446',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0NjU4SURpbnRmUmVn'},
                                                                                                          {       'in_discards': '142',
                                                                                                                  'in_errors': '1',
                                                                                                                  'in_octets': '2753693026',
                                                                                                                  'in_ucast_pkts': '241605258',
                                                                                                                  'out_octets': '235165859',
                                                                                                                  'out_ucast_pkts': '522401194',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGE2SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/7',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '30615648143',
                                                                                         'out_ucast_pkts': '18356901032',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBNODc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/7',
                                                                                                                 'id': '1800007',
                                                                                                                 'links': [       {       'connected_time': '28597701',
                                                                                                                                          'fiber_length': 19328,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Vj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595457',
                                                                                                                                          'fiber_length': 19271,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0NjFk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595457',
                                                                                                                                          'fiber_length': 19046,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Vi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '144849',
                                                                                                                                          'fiber_length': 18640,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTI4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595437',
                                                                                                                                          'fiber_length': 18498,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjNj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28597701',
                                                                                                                                          'fiber_length': 16371,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjMx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595437',
                                                                                                                                          'fiber_length': 19793,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjIx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '16001308',
                                                                                                                                          'fiber_length': 19616,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Vk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595416',
                                                                                                                                          'fiber_length': 19185,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTRi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28595416',
                                                                                                                                          'fiber_length': 17254,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTRh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28591851',
                                                                                                                                          'fiber_length': 17844,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjNl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '5028857',
                                                                                                                                          'fiber_length': 18471,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YWVj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '2179106',
                                                                                                                                          'fiber_length': 19184,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YmEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28596917',
                                                                                                                                          'fiber_length': 18695,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0NjU4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4},
                                                                                                                                  {       'connected_time': '28596734',
                                                                                                                                          'fiber_length': 19726,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.4}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/7',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBNODdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1800008',
                                                                                         'in_discards': '119',
                                                                                         'in_errors': '75',
                                                                                         'in_octets': '14631371536',
                                                                                         'in_ucast_pkts': '13935439371',
                                                                                         'links': [       {       'in_octets': '2221281459',
                                                                                                                  'in_ucast_pkts': '5785293',
                                                                                                                  'out_octets': '3333520802',
                                                                                                                  'out_ucast_pkts': '4839543',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2NmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '88526290',
                                                                                                                  'in_ucast_pkts': '3880162180',
                                                                                                                  'out_octets': '1823259695',
                                                                                                                  'out_ucast_pkts': '3384149174',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2NjSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3691498824',
                                                                                                                  'in_ucast_pkts': '4167418017',
                                                                                                                  'out_octets': '1643339112',
                                                                                                                  'out_ucast_pkts': '825299493',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1ZDYzSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '119',
                                                                                                                  'in_errors': '75',
                                                                                                                  'in_octets': '1718632998',
                                                                                                                  'in_ucast_pkts': '179181288',
                                                                                                                  'out_octets': '4208193560',
                                                                                                                  'out_ucast_pkts': '277099316',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTQ2SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3913075859',
                                                                                                                  'in_ucast_pkts': '79919429',
                                                                                                                  'out_octets': '2567052857',
                                                                                                                  'out_ucast_pkts': '119498586',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTJiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2326082782',
                                                                                                                  'in_ucast_pkts': '3316695223',
                                                                                                                  'out_octets': '899640913',
                                                                                                                  'out_ucast_pkts': '511045762',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTMzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '672273324',
                                                                                                                  'in_ucast_pkts': '2306277941',
                                                                                                                  'out_octets': '217866154',
                                                                                                                  'out_ucast_pkts': '1933728893',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZjBjSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/18/8',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '14692873093',
                                                                                         'out_ucast_pkts': '7055660767',
                                                                                         'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBNS1I=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/18/8',
                                                                                                                 'id': '1800008',
                                                                                                                 'links': [       {       'connected_time': '7973829',
                                                                                                                                          'fiber_length': 14013,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Nm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '49000766',
                                                                                                                                          'fiber_length': 14667,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Nj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '48154079',
                                                                                                                                          'fiber_length': 14417,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1ZDYz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '5702416',
                                                                                                                                          'fiber_length': 13299,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTQ2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '14884088',
                                                                                                                                          'fiber_length': 12450,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTJi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '49090665',
                                                                                                                                          'fiber_length': 11916,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTMz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9},
                                                                                                                                  {       'connected_time': '25578151',
                                                                                                                                          'fiber_length': 12784,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZjBj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.9}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/18/8',
                                                                                                                 'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBNS1JncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 19.223068,
                                                           'model': '1187503F1',
                                                           'name': 'GPON OLT',
                                                           'poller_hash': 'TEJBRFROMTkzM0FDNjAxMTE4NzUwM0Yx',
                                                           'serial_number': 'LBADTN1933AC601',
                                                           'sw_version': '10.3.36',
                                                           'temperature': 55.3,
                                                           'uptime': '64984562'},
                                                   {       'id': '19',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1900001',
                                                                                         'in_octets': '8014963025',
                                                                                         'in_ucast_pkts': '3704471304',
                                                                                         'links': [       {       'in_octets': '1259372092',
                                                                                                                  'in_ucast_pkts': '118524756',
                                                                                                                  'out_octets': '723931922',
                                                                                                                  'out_ucast_pkts': '263736958',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0NzQ1SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '8090503',
                                                                                                                  'in_ucast_pkts': '674133621',
                                                                                                                  'out_octets': '2974871061',
                                                                                                                  'out_ucast_pkts': '1501818631',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTU0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1178861886',
                                                                                                                  'in_ucast_pkts': '974544807',
                                                                                                                  'out_octets': '3768402818',
                                                                                                                  'out_ucast_pkts': '2100280310',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjJiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '754835952',
                                                                                                                  'in_ucast_pkts': '750391554',
                                                                                                                  'out_octets': '2667602292',
                                                                                                                  'out_ucast_pkts': '1535959177',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2ZlSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2142201266',
                                                                                                                  'in_ucast_pkts': '670206822',
                                                                                                                  'out_discards': '12764580',
                                                                                                                  'out_octets': '755071889',
                                                                                                                  'out_ucast_pkts': '1071547053',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjlhSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2671601326',
                                                                                                                  'in_ucast_pkts': '516669744',
                                                                                                                  'out_octets': '735619195',
                                                                                                                  'out_ucast_pkts': '1065134200',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTJjSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/19/1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '12764580',
                                                                                         'out_octets': '11625499177',
                                                                                         'out_ucast_pkts': '7538476329',
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkJVMDBKSkc=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/19/1',
                                                                                                                 'id': '1900001',
                                                                                                                 'links': [       {       'connected_time': '11235522',
                                                                                                                                          'fiber_length': 19935,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0NzQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '31630229',
                                                                                                                                          'fiber_length': 18411,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '31626443',
                                                                                                                                          'fiber_length': 16832,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjJi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '31625721',
                                                                                                                                          'fiber_length': 15740,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Zl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '17297670',
                                                                                                                                          'fiber_length': 16875,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njlh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5},
                                                                                                                                  {       'connected_time': '31625541',
                                                                                                                                          'fiber_length': 15833,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTJj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.5}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/19/1',
                                                                                                                 'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkJVMDBKSkdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1900002',
                                                                                         'in_octets': '22922713828',
                                                                                         'in_ucast_pkts': '11484382416',
                                                                                         'links': [       {       'in_octets': '2903641408',
                                                                                                                  'in_ucast_pkts': '280954603',
                                                                                                                  'out_octets': '2739398481',
                                                                                                                  'out_ucast_pkts': '530173438',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTA3SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1623305869',
                                                                                                                  'in_ucast_pkts': '2061304930',
                                                                                                                  'out_octets': '1425000693',
                                                                                                                  'out_ucast_pkts': '591710906',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTQzSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2710926241',
                                                                                                                  'in_ucast_pkts': '2797338971',
                                                                                                                  'out_octets': '35692897',
                                                                                                                  'out_ucast_pkts': '4243417148',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTA5SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1168844207',
                                                                                                                  'in_ucast_pkts': '2973728579',
                                                                                                                  'out_octets': '1234049551',
                                                                                                                  'out_ucast_pkts': '1949978669',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjBiSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4105086093',
                                                                                                                  'in_ucast_pkts': '291695423',
                                                                                                                  'out_octets': '4175559907',
                                                                                                                  'out_ucast_pkts': '749148431',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjEySURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3601958129',
                                                                                                                  'in_ucast_pkts': '294215987',
                                                                                                                  'out_octets': '2465608770',
                                                                                                                  'out_ucast_pkts': '599085627',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjljSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1947681911',
                                                                                                                  'in_ucast_pkts': '674245569',
                                                                                                                  'out_octets': '3978812858',
                                                                                                                  'out_ucast_pkts': '1546397641',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0NTExSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '4087468264',
                                                                                                                  'in_ucast_pkts': '505792310',
                                                                                                                  'out_octets': '2727810557',
                                                                                                                  'out_ucast_pkts': '963107690',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjkwSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '773801706',
                                                                                                                  'in_ucast_pkts': '1605106044',
                                                                                                                  'out_octets': '2890659162',
                                                                                                                  'out_ucast_pkts': '3479473074',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjhhSURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/19/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '21672592876',
                                                                                         'out_ucast_pkts': '14652492624',
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkNVMDA0TFA=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/19/2',
                                                                                                                 'id': '1900002',
                                                                                                                 'links': [       {       'connected_time': '23852148',
                                                                                                                                          'fiber_length': 8111,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '19202814',
                                                                                                                                          'fiber_length': 6876,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTQz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '11580688',
                                                                                                                                          'fiber_length': 6866,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '23852148',
                                                                                                                                          'fiber_length': 8006,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjBi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '23852148',
                                                                                                                                          'fiber_length': 8336,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjEy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '21189467',
                                                                                                                                          'fiber_length': 7946,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njlj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '23852148',
                                                                                                                                          'fiber_length': 7330,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0NTEx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '2787562',
                                                                                                                                          'fiber_length': 8423,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njkw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7},
                                                                                                                                  {       'connected_time': '23852148',
                                                                                                                                          'fiber_length': 4568,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njhh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.7}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/19/2',
                                                                                                                 'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkNVMDA0TFBncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1900003',
                                                                                         'in_discards': '1808503',
                                                                                         'in_errors': '1508642',
                                                                                         'in_octets': '21734039181',
                                                                                         'in_ucast_pkts': '5039752644',
                                                                                         'links': [       {       'in_octets': '4192418014',
                                                                                                                  'in_ucast_pkts': '572664008',
                                                                                                                  'out_octets': '794569604',
                                                                                                                  'out_ucast_pkts': '661025059',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0Y2Y4SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3894523251',
                                                                                                                  'in_ucast_pkts': '114165043',
                                                                                                                  'out_octets': '4163470981',
                                                                                                                  'out_ucast_pkts': '330358539',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1Njk0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3353263217',
                                                                                                                  'in_ucast_pkts': '1027191687',
                                                                                                                  'out_octets': '2273257705',
                                                                                                                  'out_ucast_pkts': '2220266061',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGI0SURpbnRmUmVn'},
                                                                                                          {       'in_octets': '532197370',
                                                                                                                  'in_ucast_pkts': '127724224',
                                                                                                                  'out_octets': '2293746277',
                                                                                                                  'out_ucast_pkts': '321893922',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGFkSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '3603203629',
                                                                                                                  'in_ucast_pkts': '658119562',
                                                                                                                  'out_octets': '4248289994',
                                                                                                                  'out_ucast_pkts': '1308823259',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1NjhlSURpbnRmUmVn'},
                                                                                                          {       'in_discards': '1808503',
                                                                                                                  'in_errors': '1508642',
                                                                                                                  'in_octets': '4216150287',
                                                                                                                  'in_ucast_pkts': '659673920',
                                                                                                                  'out_octets': '1421449353',
                                                                                                                  'out_ucast_pkts': '1529165899',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZGFmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '1942283413',
                                                                                                                  'in_ucast_pkts': '1880214200',
                                                                                                                  'out_octets': '2858887229',
                                                                                                                  'out_ucast_pkts': '3731240825',
                                                                                                                  'poller_hash': 'QURUTjIxMTM0ZDAySURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/19/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '18053671143',
                                                                                         'out_ucast_pkts': '10102773564',
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkJVMDBNUVU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/19/3',
                                                                                                                 'id': '1900003',
                                                                                                                 'links': [       {       'connected_time': '5797289',
                                                                                                                                          'fiber_length': 23054,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0Y2Y4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -26.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '8643698',
                                                                                                                                          'fiber_length': 22791,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njk0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '20748389',
                                                                                                                                          'fiber_length': 23146,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGI0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '20677361',
                                                                                                                                          'fiber_length': 22824,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGFk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '20738946',
                                                                                                                                          'fiber_length': 23618,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1Njhl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '20753009',
                                                                                                                                          'fiber_length': 22955,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZGFm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '20755879',
                                                                                                                                          'fiber_length': 22116,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM0ZDAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/19/3',
                                                                                                                 'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkJVMDBNUVVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1900004',
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/19/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyUFJMRUFBQkI3MTEz',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/19/4',
                                                                                                                 'id': '1900004',
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/19/4',
                                                                                                                 'poller_hash': 'TEJBRFROMTkwN0FEMTEyUFJMRUFBQkI3MTEzZ3Bvbg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1900005',
                                                                                         'in_octets': '3418430885',
                                                                                         'in_ucast_pkts': '2760532499',
                                                                                         'links': [       {       'in_octets': '789042100',
                                                                                                                  'in_ucast_pkts': '493231398',
                                                                                                                  'out_octets': '1613992680',
                                                                                                                  'out_ucast_pkts': '1215090033',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YjFmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '2306636557',
                                                                                                                  'in_ucast_pkts': '2181595945',
                                                                                                                  'out_octets': '2170551775',
                                                                                                                  'out_ucast_pkts': '3775925336',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1OTZmSURpbnRmUmVn'},
                                                                                                          {       'in_octets': '322752228',
                                                                                                                  'in_ucast_pkts': '85705156',
                                                                                                                  'out_octets': '169655976',
                                                                                                                  'out_ucast_pkts': '77308275',
                                                                                                                  'poller_hash': 'QURUTjIxMTM1YTA2SURpbnRmUmVn'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442530G1',
                                                                                         'name': '1/19/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '3954200431',
                                                                                         'out_ucast_pkts': '5068323644',
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkNVMDBCM1A=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/19/5',
                                                                                                                 'id': '1900005',
                                                                                                                 'links': [       {       'connected_time': '3709561',
                                                                                                                                          'fiber_length': 9562,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YjFm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '3723356',
                                                                                                                                          'fiber_length': 8350,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1OTZm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6},
                                                                                                                                  {       'connected_time': '3723356',
                                                                                                                                          'fiber_length': 9413,
                                                                                                                                          'poller_hash': 'QURUTjIxMTM1YTA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.6}],
                                                                                                                 'max_distance': 30000,
                                                                                                                 'maximum_loss': -10.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'name': '1/19/5',
                                                                                                                 'poller_hash': 'TEJBRFROMTkwN0FEMTEyVjI0QkNVMDBCM1BncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1900006',
                                                                                         'name': '1/19/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyMTkwMDAwNg==',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1900007',
                                                                                         'name': '1/19/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyMTkwMDAwNw==',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1900008',
                                                                                         'name': '1/19/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkwN0FEMTEyMTkwMDAwOA==',
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 24.975725,
                                                           'model': '1187503F2',
                                                           'name': 'GPON OLT',
                                                           'poller_hash': 'TEJBRFROMTkwN0FEMTEyMTE4NzUwM0Yy',
                                                           'serial_number': 'LBADTN1907AD112',
                                                           'sw_version': '10.3.36',
                                                           'temperature': 58.9,
                                                           'uptime': '35790131'},
                                                   {       'id': '2',
                                                           'manufacturer': 'Adtran',
                                                           'mem': 58.000755,
                                                           'model': '1187800L1',
                                                           'name': 'DS1 VG',
                                                           'poller_hash': 'TEJBRFROMjA0MEFHODczMTE4NzgwMEwx',
                                                           'serial_number': 'LBADTN2040AG873',
                                                           'sw_version': 'K32.0007',
                                                           'temperature': 37.3,
                                                           'uptime': '17236977'},
                                                   {       'id': '251',
                                                           'manufacturer': 'Adtran',
                                                           'model': '1187080G1',
                                                           'name': 'Fan Module',
                                                           'poller_hash': 'TEJBRFROMTkzN0FEMjA2MTE4NzA4MEcx',
                                                           'serial_number': 'LBADTN1937AD206',
                                                           'sw_version': 'A02.03',
                                                           'uptime': '140499856'},
                                                   {       'id': '252',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '25200001',
                                                                                         'in_discards': '2875938837',
                                                                                         'in_errors': '26',
                                                                                         'in_nucast_pkts': '23937464570',
                                                                                         'in_octets': '2398816507064830',
                                                                                         'in_ucast_pkts': '1800559634451',
                                                                                         'mac_address': '00:24:45:83:f4:fb',
                                                                                         'manufacturer': 'Hisense',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-LR10',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '61451019',
                                                                                         'out_octets': '191529098435209',
                                                                                         'out_ucast_pkts': '984378558188',
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzg2SjgzQTE0MDA1NjQ=',
                                                                                         'speed': '1000000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': True,
                                                                                         'id': '25200002',
                                                                                         'in_discards': '1665505',
                                                                                         'in_errors': '2',
                                                                                         'in_nucast_pkts': '34700712',
                                                                                         'in_octets': '43678082213448',
                                                                                         'in_ucast_pkts': '149972854248',
                                                                                         'mac_address': '00:24:45:83:f4:fc',
                                                                                         'manufacturer': 'LINKTEL',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-ER',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '7686915747',
                                                                                         'out_octets': '287987403345454',
                                                                                         'out_ucast_pkts': '261168124383',
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzg2MzE3NDUxNDA5OA==',
                                                                                         'speed': '10000000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25200003',
                                                                                         'mac_address': '00:24:45:83:f4:fd',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzg2MDAyNDQ1ODNmNGZk',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25200004',
                                                                                         'mac_address': '00:24:45:83:f4:fe',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzg2MDAyNDQ1ODNmNGZl',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 8.9347,
                                                           'model': '1187040F1',
                                                           'name': 'SM 4-10G',
                                                           'poller_hash': 'TEJBRFROMTk0MUFDNzg2MTE4NzA0MEYx',
                                                           'serial_number': 'LBADTN1941AC786',
                                                           'sw_version': 'K32.0032',
                                                           'temperature': 48.5,
                                                           'uptime': '140499856'},
                                                   {       'id': '253',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '25300001',
                                                                                         'in_discards': '3417778043',
                                                                                         'in_errors': '416',
                                                                                         'in_nucast_pkts': '23990604270',
                                                                                         'in_octets': '1128556958451115',
                                                                                         'in_ucast_pkts': '869737234735',
                                                                                         'mac_address': '00:24:45:83:ec:31',
                                                                                         'manufacturer': 'Hisense',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-LR10',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '36959087',
                                                                                         'out_octets': '102232902788196',
                                                                                         'out_ucast_pkts': '467732943899',
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzQxSjgzQTE0MDA2MTI=',
                                                                                         'speed': '1000000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': True,
                                                                                         'id': '25300002',
                                                                                         'in_discards': '95587',
                                                                                         'in_nucast_pkts': '19322183',
                                                                                         'in_octets': '32612374842646',
                                                                                         'in_ucast_pkts': '104712848439',
                                                                                         'mac_address': '00:24:45:83:ec:32',
                                                                                         'manufacturer': 'LINKTEL',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-ER',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '3265192693',
                                                                                         'out_octets': '200699409280206',
                                                                                         'out_ucast_pkts': '189258992637',
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzQxMzE3MjgxNTIwMg==',
                                                                                         'speed': '10000000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25300003',
                                                                                         'mac_address': '00:24:45:83:ec:33',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzQxMDAyNDQ1ODNlYzMz',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25300004',
                                                                                         'mac_address': '00:24:45:83:ec:34',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0MUFDNzQxMDAyNDQ1ODNlYzM0',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 9.159019,
                                                           'model': '1187040F1',
                                                           'name': 'SM 4-10G',
                                                           'poller_hash': 'TEJBRFROMTk0MUFDNzQxMTE4NzA0MEYx',
                                                           'serial_number': 'LBADTN1941AC741',
                                                           'sw_version': 'K32.0032',
                                                           'uptime': '140499813'},
                                                   {       'id': '254',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1',
                                                                                         'in_discards': '1141800',
                                                                                         'in_unknown_protos': '313072151',
                                                                                         'mac_address': '00:24:45:80:d5:48',
                                                                                         'mtu': 1500,
                                                                                         'name': 'eth0',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTkzNkFDMjYwMDAyNDQ1ODBkNTQ4',
                                                                                         'speed': '100000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '3',
                                                                                         'mac_address': '00:24:45:80:d5:4a',
                                                                                         'mtu': 1500,
                                                                                         'name': 'eth5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTkzNkFDMjYwMDAyNDQ1ODBkNTRh',
                                                                                         'speed': '100000000',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 45.07982,
                                                           'model': '1187011F3',
                                                           'name': 'SCM',
                                                           'poller_hash': 'TEJBRFROMTkzNkFDMjYwMTE4NzAxMUYz',
                                                           'serial_number': 'LBADTN1936AC260',
                                                           'sw_version': 'K30.041',
                                                           'uptime': '119864391'},
                                                   {       'id': '7',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '700051',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/7/51',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1WDA2QTAxMDU=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/7/51',
                                                                                                                 'id': '700051',
                                                                                                                 'name': '1/7/51',
                                                                                                                 'poller_hash': 'TEJBRFROMjAxNUFDMjk1WDA2QTAxMDVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '700052',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/7/52',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1VjM5QTAxNjM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/7/52',
                                                                                                                 'id': '700052',
                                                                                                                 'name': '1/7/52',
                                                                                                                 'poller_hash': 'TEJBRFROMjAxNUFDMjk1VjM5QTAxNjNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '700053',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/7/53',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1WDA2QTAwOTg=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/7/53',
                                                                                                                 'id': '700053',
                                                                                                                 'name': '1/7/53',
                                                                                                                 'poller_hash': 'TEJBRFROMjAxNUFDMjk1WDA2QTAwOThncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '700054',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/7/54',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1VzI4QTA3MzM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/7/54',
                                                                                                                 'id': '700054',
                                                                                                                 'name': '1/7/54',
                                                                                                                 'poller_hash': 'TEJBRFROMjAxNUFDMjk1VzI4QTA3MzNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700055',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/55',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDU1',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700056',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/56',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDU2',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700057',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/57',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDU3',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700058',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/58',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDU4',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700059',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/59',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDU5',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '700060',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/7/60',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjk1NzAwMDYw',
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 63.266937,
                                                           'model': '1174130F2',
                                                           'name': 'ETOS-10',
                                                           'poller_hash': 'TEJBRFROMjAxNUFDMjk1MTE3NDEzMEYy',
                                                           'serial_number': 'LBADTN2015AC295',
                                                           'sw_version': 'E84.0027',
                                                           'temperature': 44.5},
                                                   {       'id': '8',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '800051',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/51',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDUx',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800052',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/52',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDUy',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800053',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/53',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDUz',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800054',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/54',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU0',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800055',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/55',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU1',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800056',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/56',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU2',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800057',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/57',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU3',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800058',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/58',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU4',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800059',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/59',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDU5',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '800060',
                                                                                         'manufacturer': ' ',
                                                                                         'model': '',
                                                                                         'name': '1/8/60',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjAxNUFDMjkyODAwMDYw',
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 63.135017,
                                                           'model': '1174130F2',
                                                           'name': 'ETOS-10',
                                                           'poller_hash': 'TEJBRFROMjAxNUFDMjkyMTE3NDEzMEYy',
                                                           'serial_number': 'LBADTN2015AC292',
                                                           'sw_version': 'E84.0027',
                                                           'temperature': 46.0},
                                                   {       'id': '9',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '900051',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/9/51',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzI4QTA3MTM=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/9/51',
                                                                                                                 'id': '900051',
                                                                                                                 'name': '1/9/51',
                                                                                                                 'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzI4QTA3MTNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '900052',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX10',
                                                                                         'name': '1/9/52',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzWDAzQTAzMTE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/9/52',
                                                                                                                 'id': '900052',
                                                                                                                 'name': '1/9/52',
                                                                                                                 'poller_hash': 'TEJBRFROMTk0OEFBMjQzWDAzQTAzMTFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '900053',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/9/53',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzQwQTA2NzY=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/9/53',
                                                                                                                 'id': '900053',
                                                                                                                 'name': '1/9/53',
                                                                                                                 'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzQwQTA2NzZncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '900054',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/9/54',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzVjM5QTAwOTE=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/9/54',
                                                                                                                 'id': '900054',
                                                                                                                 'name': '1/9/54',
                                                                                                                 'poller_hash': 'TEJBRFROMTk0OEFBMjQzVjM5QTAwOTFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '900055',
                                                                                         'manufacturer': 'WTD',
                                                                                         'model': 'ADTRAN '
                                                                                                  '1000BASE-BX20',
                                                                                         'name': '1/9/55',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzAyQTAyMjI=',
                                                                                         'pons': [       {       'description': 'gpon '
                                                                                                                                '1/9/55',
                                                                                                                 'id': '900055',
                                                                                                                 'name': '1/9/55',
                                                                                                                 'poller_hash': 'TEJBRFROMTk0OEFBMjQzVzAyQTAyMjJncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '900056',
                                                                                         'name': '1/9/56',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzOTAwMDU2',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '900057',
                                                                                         'name': '1/9/57',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzOTAwMDU3',
                                                                                         'type': 208},
                                                                                 {       'admin_up': False,
                                                                                         'id': '900058',
                                                                                         'name': '1/9/58',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMTk0OEFBMjQzOTAwMDU4',
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 42.192398,
                                                           'model': '1187552G1',
                                                           'name': 'GE 8-Port',
                                                           'poller_hash': 'TEJBRFROMTk0OEFBMjQzMTE4NzU1Mkcx',
                                                           'serial_number': 'LBADTN1948AA243',
                                                           'sw_version': 'K32.0029',
                                                           'temperature': 34.0,
                                                           'uptime': '140259660'}],
                                'poller_hash': 'Tm90IFN1cHBvcnRlZA==',
                                'serial_number': 'Not Supported',
                                'sw_version': '10.3.2',
                                'system_mac_address': '00:24:45:80:d5:48'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778648064',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFNMUzU5OTU3MjE0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778648064',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'VFNMUzU5OTU3MjE0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1778648129',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFNMUzU5OTU3MjE0RXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1778648130',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFNMUzU5OTU3MjE0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1778648193',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFNMUzU5OTU3MjE0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1778648194',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFNMUzU5OTU3MjE0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'name': '1@1/10/1',
                                         'poller_hash': 'b250IFRTTFM1OTk1NzIxNA==',
                                         'serial_number': 'TSLS59957214',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778649088',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778649088',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'SVBITzAwNTBkMjUw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:91:82:2f:35:a3'],
                                                                       'id': '1778649153',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwRXRoaW50ZjE='},
                                                               {       'admin_up': False,
                                                                       'id': '1778649154',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwRXRoaW50ZjI='},
                                                               {       'admin_up': False,
                                                                       'id': '1778649155',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwRXRoaW50ZjM='},
                                                               {       'admin_up': False,
                                                                       'id': '1778649156',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1778649217',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwUE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1778649218',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjUwUE9UU2ludGYy'}],
                                         'manufacturer': 'iPhotonix',
                                         'name': '2@1/10/1',
                                         'poller_hash': 'b250IElQSE8wMDUwRDI1MA==',
                                         'serial_number': 'IPHO0050d250',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778650112',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778650112',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'SVBITzAwNTBkMjVj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': False,
                                                                       'id': '1778650177',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjRXRoaW50ZjE='},
                                                               {       'admin_up': False,
                                                                       'id': '1778650178',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjRXRoaW50ZjI='},
                                                               {       'admin_up': False,
                                                                       'id': '1778650179',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjRXRoaW50ZjM='},
                                                               {       'admin_up': False,
                                                                       'id': '1778650180',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjRXRoaW50ZjQ='},
                                                               {       'admin_up': False,
                                                                       'id': '1778650241',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjUE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1778650242',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'SVBITzAwNTBkMjVjUE9UU2ludGYy'}],
                                         'manufacturer': 'iPhotonix',
                                         'name': '3@1/10/1',
                                         'poller_hash': 'b250IElQSE8wMDUwRDI1Qw==',
                                         'serial_number': 'IPHO0050d25c',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778651136',
                                                                       'in_octets': '8206',
                                                                       'in_ucast_pkts': '7',
                                                                       'links': [       {       'in_octets': '8206',
                                                                                                'in_ucast_pkts': '7',
                                                                                                'out_octets': '13784',
                                                                                                'out_ucast_pkts': '99',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyUFJMRUFBQkI3MTEw'}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '13784',
                                                                       'out_ucast_pkts': '99',
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778651136',
                                                                                               'links': [       {       'connected_time': '7283926',
                                                                                                                        'fiber_length': 243,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyUFJMRUFBQkI3MTEwZ3Bvbg==',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAxZTVk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:5a:a0'],
                                                                       'id': '1778651201',
                                                                       'in_octets': '13784',
                                                                       'in_ucast_pkts': '99',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '8206',
                                                                       'out_ucast_pkts': '7',
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1778651202',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1778651203',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1778651204',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1778651265',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1778651266',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZTVkUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/10/1',
                                         'poller_hash': 'b250IEFEVE4yMDIwMUU1RA==',
                                         'serial_number': 'ADTN20201e5d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '7283926'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778653184',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA1SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778653184',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTA1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1778653249',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA1RXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1778653250',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA1RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1778653313',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA1UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1778653314',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA1UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '6@1/10/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEwNQ==',
                                         'serial_number': 'ADTN21135a05',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'L30.02.005.M8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1778910208',
                                                                       'in_octets': '5855',
                                                                       'in_ucast_pkts': '60',
                                                                       'links': [       {       'in_octets': '5855',
                                                                                                'in_ucast_pkts': '60',
                                                                                                'out_octets': '7101',
                                                                                                'out_ucast_pkts': '38',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDE2NjE='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '7101',
                                                                       'out_ucast_pkts': '38',
                                                                       'poller_hash': 'QURUTjIwMjAzN2Q0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1778910208',
                                                                                               'links': [       {       'connected_time': '53574378',
                                                                                                                        'fiber_length': 14887,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDE2NjFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAzN2Q0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '3c:37:86:22:90:e9'],
                                                                       'id': '1778910273',
                                                                       'in_octets': '7101',
                                                                       'in_ucast_pkts': '38',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '5855',
                                                                       'out_ucast_pkts': '60',
                                                                       'poller_hash': 'QURUTjIwMjAzN2Q0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1778910274',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzN2Q0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1778910337',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAzN2Q0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1778910338',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAzN2Q0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/10/2',
                                         'poller_hash': 'b250IEFEVE4yMDIwMzdENA==',
                                         'serial_number': 'ADTN202037d4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '53574378'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779172352',
                                                                       'in_octets': '45012566',
                                                                       'in_ucast_pkts': '38910',
                                                                       'links': [       {       'in_octets': '45012566',
                                                                                                'in_ucast_pkts': '38910',
                                                                                                'out_octets': '5379247',
                                                                                                'out_ucast_pkts': '31539',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyOTM='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '5379247',
                                                                       'out_ucast_pkts': '31539',
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779172352',
                                                                                               'links': [       {       'connected_time': '3186960',
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyOTNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAzNTdi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c0:56:27:7b:ef:c7'],
                                                                       'id': '1779172417',
                                                                       'in_octets': '5379247',
                                                                       'in_ucast_pkts': '31539',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '45012566',
                                                                       'out_ucast_pkts': '38910',
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779172418',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779172419',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1779172420',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1779172481',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiUE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1779172482',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzNTdiUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/10/3',
                                         'poller_hash': 'b250IEFEVE4yMDIwMzU3Qg==',
                                         'serial_number': 'ADTN2020357b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '3186960'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779434496',
                                                                       'in_octets': '4258403603',
                                                                       'in_ucast_pkts': '1824371630',
                                                                       'links': [       {       'in_octets': '4258403603',
                                                                                                'in_ucast_pkts': '1824371630',
                                                                                                'out_octets': '2527466497',
                                                                                                'out_ucast_pkts': '830294784',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTk='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2527466497',
                                                                       'out_ucast_pkts': '830294784',
                                                                       'poller_hash': 'QURUTjIxMTM1YTA0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779434496',
                                                                                               'links': [       {       'connected_time': '43735507',
                                                                                                                        'fiber_length': 4107,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTlncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTA0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d9:3f:00'],
                                                                       'id': '1779434561',
                                                                       'in_octets': '2527466497',
                                                                       'in_ucast_pkts': '830294784',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4258403603',
                                                                       'out_ucast_pkts': '1824371630',
                                                                       'poller_hash': 'QURUTjIxMTM1YTA0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779434562',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779434625',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1779434626',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTA0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/10/4',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEwNA==',
                                         'serial_number': 'ADTN21135a04',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '43735507'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779435520',
                                                                       'in_octets': '171619495',
                                                                       'in_ucast_pkts': '123917',
                                                                       'links': [       {       'in_octets': '171619495',
                                                                                                'in_ucast_pkts': '123917',
                                                                                                'out_octets': '4585291',
                                                                                                'out_ucast_pkts': '40186',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTk='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4585291',
                                                                       'out_ucast_pkts': '40186',
                                                                       'poller_hash': 'QURUTjIwMjAyZmI5SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779435520',
                                                                                               'links': [       {       'connected_time': '2685526',
                                                                                                                        'fiber_length': 3907,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDAyNTlncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAyZmI5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:2a:16:70'],
                                                                       'id': '1779435585',
                                                                       'in_octets': '4585291',
                                                                       'in_ucast_pkts': '40186',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '171619495',
                                                                       'out_ucast_pkts': '123917',
                                                                       'poller_hash': 'QURUTjIwMjAyZmI5RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779435586',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmI5RXRoaW50ZjI='},
                                                               {       'admin_up': False,
                                                                       'id': '1779435649',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmI5UE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1779435650',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmI5UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/10/4',
                                         'poller_hash': 'b250IEFEVE4yMDIwMkZCOQ==',
                                         'serial_number': 'ADTN20202fb9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '2685526'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779696640',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779696640',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAxZmRj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1779696705',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjRXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1779696706',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779696707',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1779696708',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjRXRoaW50ZjQ='},
                                                               {       'admin_up': False,
                                                                       'id': '1779696769',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjUE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1779696770',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAxZmRjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/10/5',
                                         'poller_hash': 'b250IEFEVE4yMDIwMUZEQw==',
                                         'serial_number': 'ADTN20201fdc',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'L30.02.005.M8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779697664',
                                                                       'in_octets': '382232031',
                                                                       'in_ucast_pkts': '285990',
                                                                       'links': [       {       'in_octets': '382232031',
                                                                                                'in_ucast_pkts': '285990',
                                                                                                'out_octets': '2472917',
                                                                                                'out_ucast_pkts': '38132',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2472917',
                                                                       'out_ucast_pkts': '38132',
                                                                       'poller_hash': 'QURUTjIwMjAzNTc5SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779697664',
                                                                                               'links': [       {       'connected_time': '362139',
                                                                                                                        'fiber_length': 6861,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAzNTc5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d7:2b:a0'],
                                                                       'id': '1779697729',
                                                                       'in_octets': '2472917',
                                                                       'in_ucast_pkts': '38132',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '382232031',
                                                                       'out_ucast_pkts': '285990',
                                                                       'poller_hash': 'QURUTjIwMjAzNTc5RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779697730',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAzNTc5RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779697793',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAzNTc5UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1779697794',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIwMjAzNTc5UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/10/5',
                                         'poller_hash': 'b250IEFEVE4yMDIwMzU3OQ==',
                                         'serial_number': 'ADTN20203579',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '362139'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779698688',
                                                                       'in_octets': '1450925',
                                                                       'in_ucast_pkts': '2416',
                                                                       'links': [       {       'in_octets': '1450925',
                                                                                                'in_ucast_pkts': '2416',
                                                                                                'out_octets': '494607',
                                                                                                'out_ucast_pkts': '1921',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '494607',
                                                                       'out_ucast_pkts': '1921',
                                                                       'poller_hash': 'QURUTjIwMjAyZmM0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779698688',
                                                                                               'links': [       {       'connected_time': '23263923',
                                                                                                                        'fiber_length': 1460,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIwMjAyZmM0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:ce:80'],
                                                                       'id': '1779698753',
                                                                       'in_octets': '494607',
                                                                       'in_ucast_pkts': '1921',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1450925',
                                                                       'out_ucast_pkts': '2416',
                                                                       'poller_hash': 'QURUTjIwMjAyZmM0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779698754',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmM0RXRoaW50ZjI='},
                                                               {       'admin_up': False,
                                                                       'id': '1779698817',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmM0UE9UU2ludGYx'},
                                                               {       'admin_up': False,
                                                                       'id': '1779698818',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIwMjAyZmM0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/10/5',
                                         'poller_hash': 'b250IEFEVE4yMDIwMkZDNA==',
                                         'serial_number': 'ADTN20202fc4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'L30.02.005.M8',
                                         'uptime': '23263923'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779699712',
                                                                       'in_octets': '3756796516',
                                                                       'in_ucast_pkts': '1266466277',
                                                                       'links': [       {       'in_octets': '3756796516',
                                                                                                'in_ucast_pkts': '1266466277',
                                                                                                'out_octets': '652878433',
                                                                                                'out_ucast_pkts': '612677964',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '652878433',
                                                                       'out_ucast_pkts': '612677964',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFiSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779699712',
                                                                                               'links': [       {       'connected_time': '8477039',
                                                                                                                        'fiber_length': 1401,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI4NDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjFi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:e8:6e:e0'],
                                                                       'id': '1779699777',
                                                                       'in_octets': '652878433',
                                                                       'in_ucast_pkts': '612677964',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3756796516',
                                                                       'out_ucast_pkts': '1266466277',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFiRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779699778',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFiRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779699841',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFiUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1779699842',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFiUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/10/5',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxQg==',
                                         'serial_number': 'ADTN21135b1b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '8477039'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1779959808',
                                                                       'in_octets': '1838134681',
                                                                       'in_ucast_pkts': '1381424241',
                                                                       'links': [       {       'in_octets': '1838134681',
                                                                                                'in_ucast_pkts': '1381424241',
                                                                                                'out_octets': '3276006619',
                                                                                                'out_ucast_pkts': '3298958345',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDA2Mzg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3276006619',
                                                                       'out_ucast_pkts': '3298958345',
                                                                       'poller_hash': 'QURUTjIxMTM1Njk5SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1779959808',
                                                                                               'links': [       {       'connected_time': '25942854',
                                                                                                                        'fiber_length': 10297,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTYwMDA2MzhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njk5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:62:20'],
                                                                       'id': '1779959873',
                                                                       'in_octets': '3276006619',
                                                                       'in_ucast_pkts': '3298958345',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1838134681',
                                                                       'out_ucast_pkts': '1381424241',
                                                                       'poller_hash': 'QURUTjIxMTM1Njk5RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1779959874',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk5RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1779959937',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk5UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1779959938',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk5UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/10/6',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY5OQ==',
                                         'serial_number': 'ADTN21135699',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '25942854'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1780220928',
                                                                       'in_octets': '6012203',
                                                                       'in_ucast_pkts': '1187185388',
                                                                       'links': [       {       'in_octets': '6012203',
                                                                                                'in_ucast_pkts': '1187185388',
                                                                                                'out_octets': '4812949',
                                                                                                'out_ucast_pkts': '4087232796',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDE='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4812949',
                                                                       'out_ucast_pkts': '4087232796',
                                                                       'poller_hash': 'QURUTjIxMTM0ZDg3SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1780220928',
                                                                                               'links': [       {       'connected_time': '87347153',
                                                                                                                        'fiber_length': 8538,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZDg3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:6b:fd:70'],
                                                                       'id': '1780220993',
                                                                       'in_octets': '4812949',
                                                                       'in_ucast_pkts': '4087232796',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '6012203',
                                                                       'out_ucast_pkts': '1187185388',
                                                                       'poller_hash': 'QURUTjIxMTM0ZDg3RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1780220994',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDg3RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1780221057',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDg3UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1780221058',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDg3UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/10/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNEQ4Nw==',
                                         'serial_number': 'ADTN21134d87',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '87347153'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1780221952',
                                                                       'in_octets': '384827800',
                                                                       'in_ucast_pkts': '1868780107',
                                                                       'links': [       {       'in_octets': '384827800',
                                                                                                'in_ucast_pkts': '1868780107',
                                                                                                'out_octets': '714876266',
                                                                                                'out_ucast_pkts': '2446971595',
                                                                                                'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDE='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '714876266',
                                                                       'out_ucast_pkts': '2446971595',
                                                                       'poller_hash': 'QURUTjIxMTM0OGM4SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1780221952',
                                                                                               'links': [       {       'connected_time': '19179518',
                                                                                                                        'fiber_length': 6830,
                                                                                                                        'poller_hash': 'TEJBRFROMTkxOUFBMTkyVDE3OTUwMDI2MDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0OGM4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:0f:00'],
                                                                       'id': '1780222017',
                                                                       'in_octets': '714876266',
                                                                       'in_ucast_pkts': '2446971595',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '384827800',
                                                                       'out_ucast_pkts': '1868780107',
                                                                       'poller_hash': 'QURUTjIxMTM0OGM4RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1780222018',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0OGM4RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1780222081',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0OGM4UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1780222082',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0OGM4UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/10/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNDhDOA==',
                                         'serial_number': 'ADTN211348c8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '19179518'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795425280',
                                                                       'in_octets': '3771058361',
                                                                       'in_ucast_pkts': '866518761',
                                                                       'links': [       {       'in_octets': '3771058361',
                                                                                                'in_ucast_pkts': '866518761',
                                                                                                'out_octets': '2809181571',
                                                                                                'out_ucast_pkts': '383981918',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2809181571',
                                                                       'out_ucast_pkts': '383981918',
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795425280',
                                                                                               'links': [       {       'connected_time': '5896831',
                                                                                                                        'fiber_length': 10009,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZTZj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:cc:10'],
                                                                       'id': '1795425345',
                                                                       'in_octets': '2809181571',
                                                                       'in_ucast_pkts': '383981918',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3771058361',
                                                                       'out_ucast_pkts': '866518761',
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795425346',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795425347',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795425348',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795425409',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795425410',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTZjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNEU2Qw==',
                                         'serial_number': 'ADTN21134e6c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '5896831'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795426304',
                                                                       'in_octets': '2659930178',
                                                                       'in_ucast_pkts': '657077673',
                                                                       'links': [       {       'in_octets': '2659930178',
                                                                                                'in_ucast_pkts': '657077673',
                                                                                                'out_octets': '4214051390',
                                                                                                'out_ucast_pkts': '310481672',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4214051390',
                                                                       'out_ucast_pkts': '310481672',
                                                                       'poller_hash': 'QURUTjIxMTM0ZDhhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795426304',
                                                                                               'links': [       {       'connected_time': '4405189',
                                                                                                                        'fiber_length': 20079,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -30.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZDhh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:ad:70'],
                                                                       'id': '1795426369',
                                                                       'in_octets': '4214051390',
                                                                       'in_ucast_pkts': '310481672',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2659930178',
                                                                       'out_ucast_pkts': '657077673',
                                                                       'poller_hash': 'QURUTjIxMTM0ZDhhRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795426370',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDhhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795426433',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDhhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795426434',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZDhhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNEQ4QQ==',
                                         'serial_number': 'ADTN21134d8a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '4405189'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795427328',
                                                                       'in_octets': '1955375011',
                                                                       'in_ucast_pkts': '3922397876',
                                                                       'links': [       {       'in_octets': '1955375011',
                                                                                                'in_ucast_pkts': '3922397876',
                                                                                                'out_octets': '4007470490',
                                                                                                'out_ucast_pkts': '1780185222',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4007470490',
                                                                       'out_ucast_pkts': '1780185222',
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795427328',
                                                                                               'links': [       {       'connected_time': '22047504',
                                                                                                                        'fiber_length': 8262,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0Y2Ni',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:38:e0:0b:0f:87'],
                                                                       'id': '1795427393',
                                                                       'in_octets': '4007470490',
                                                                       'in_ucast_pkts': '1780185222',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1955375011',
                                                                       'out_ucast_pkts': '3922397876',
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795427394',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795427395',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795427396',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795427457',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795427458',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2NiUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNENDQg==',
                                         'serial_number': 'ADTN21134ccb',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '22047504'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795428352',
                                                                       'in_octets': '1300533569',
                                                                       'in_ucast_pkts': '203170506',
                                                                       'links': [       {       'in_octets': '1300533569',
                                                                                                'in_ucast_pkts': '203170506',
                                                                                                'out_octets': '2263004788',
                                                                                                'out_ucast_pkts': '77400019',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2263004788',
                                                                       'out_ucast_pkts': '77400019',
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795428352',
                                                                                               'links': [       {       'connected_time': '2774129',
                                                                                                                        'fiber_length': 18534,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1UTZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZTc0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:cb:20'],
                                                                       'id': '1795428417',
                                                                       'in_octets': '2263004788',
                                                                       'in_ucast_pkts': '77400019',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1300533569',
                                                                       'out_ucast_pkts': '203170506',
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795428418',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795428419',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795428420',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795428481',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795428482',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZTc0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNEU3NA==',
                                         'serial_number': 'ADTN21134e74',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '2774129'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795687424',
                                                                       'in_octets': '3268757737',
                                                                       'in_ucast_pkts': '2013647696',
                                                                       'links': [       {       'in_octets': '3268757737',
                                                                                                'in_ucast_pkts': '2013647696',
                                                                                                'out_octets': '3596858482',
                                                                                                'out_ucast_pkts': '2890494131',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0Tlc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3596858482',
                                                                       'out_ucast_pkts': '2890494131',
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795687424',
                                                                                               'links': [       {       'connected_time': '30672989',
                                                                                                                        'fiber_length': 19272,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0TldncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTNi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ce:10:40'],
                                                                       'id': '1795687489',
                                                                       'in_octets': '3596858482',
                                                                       'in_ucast_pkts': '2890494131',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3268757737',
                                                                       'out_ucast_pkts': '2013647696',
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795687490',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795687491',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795687492',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795687553',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795687554',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTNiUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEzQg==',
                                         'serial_number': 'ADTN21135a3b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '30672989'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795688448',
                                                                       'in_octets': '3813333546',
                                                                       'in_ucast_pkts': '537210750',
                                                                       'links': [       {       'in_octets': '3813333546',
                                                                                                'in_ucast_pkts': '537210750',
                                                                                                'out_octets': '3451049243',
                                                                                                'out_ucast_pkts': '2648372126',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0Tlc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3451049243',
                                                                       'out_ucast_pkts': '2648372126',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795688448',
                                                                                               'links': [       {       'connected_time': '61782155',
                                                                                                                        'fiber_length': 18105,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0TldncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjBj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:75:e3:a0'],
                                                                       'id': '1795688513',
                                                                       'in_octets': '3451049243',
                                                                       'in_ucast_pkts': '2648372126',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3813333546',
                                                                       'out_ucast_pkts': '537210750',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795688514',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795688515',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795688516',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795688577',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795688578',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwQw==',
                                         'serial_number': 'ADTN21135b0c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '61782155'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795689472',
                                                                       'in_octets': '4259862530',
                                                                       'in_ucast_pkts': '1070478462',
                                                                       'links': [       {       'in_octets': '4259862530',
                                                                                                'in_ucast_pkts': '1070478462',
                                                                                                'out_octets': '716167687',
                                                                                                'out_ucast_pkts': '480855517',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0Tlc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '716167687',
                                                                       'out_ucast_pkts': '480855517',
                                                                       'poller_hash': 'QURUTjIxMTM1NjhmSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795689472',
                                                                                               'links': [       {       'connected_time': '25371101',
                                                                                                                        'fiber_length': 17578,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0TldncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njhm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:6c:11:10'],
                                                                       'id': '1795689537',
                                                                       'in_octets': '716167687',
                                                                       'in_ucast_pkts': '480855517',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4259862530',
                                                                       'out_ucast_pkts': '1070478462',
                                                                       'poller_hash': 'QURUTjIxMTM1NjhmRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795689538',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjhmRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795689601',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjhmUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795689602',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjhmUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY4Rg==',
                                         'serial_number': 'ADTN2113568f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '25371101'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795690496',
                                                                       'in_octets': '996151002',
                                                                       'in_ucast_pkts': '2670320784',
                                                                       'links': [       {       'in_octets': '996151002',
                                                                                                'in_ucast_pkts': '2670320784',
                                                                                                'out_octets': '1161521494',
                                                                                                'out_ucast_pkts': '3107934453',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0Tlc='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1161521494',
                                                                       'out_ucast_pkts': '3107934453',
                                                                       'poller_hash': 'QURUTjIxMTM1YjIzSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795690496',
                                                                                               'links': [       {       'connected_time': '66283198',
                                                                                                                        'fiber_length': 16514,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0TldncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjIz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:ad:50'],
                                                                       'id': '1795690561',
                                                                       'in_octets': '1161521494',
                                                                       'in_ucast_pkts': '3107934453',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '996151002',
                                                                       'out_ucast_pkts': '2670320784',
                                                                       'poller_hash': 'QURUTjIxMTM1YjIzRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795690562',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIzRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795690625',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIzUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795690626',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIzUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyMw==',
                                         'serial_number': 'ADTN21135b23',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '66283198'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795949568',
                                                                       'in_octets': '1745206234',
                                                                       'in_ucast_pkts': '29457623',
                                                                       'links': [       {       'in_octets': '1745206234',
                                                                                                'in_ucast_pkts': '29457623',
                                                                                                'out_octets': '2027452934',
                                                                                                'out_ucast_pkts': '1744213145',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2027452934',
                                                                       'out_ucast_pkts': '1744213145',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795949568',
                                                                                               'links': [       {       'connected_time': '71122154',
                                                                                                                        'fiber_length': 17801,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTRj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ce:3c:60'],
                                                                       'id': '1795949633',
                                                                       'in_octets': '2027452934',
                                                                       'in_ucast_pkts': '1744213145',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1745206234',
                                                                       'out_ucast_pkts': '29457623',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795949634',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795949635',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795949636',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795949697',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795949698',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE0Qw==',
                                         'serial_number': 'ADTN21135a4c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '71122154'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795950592',
                                                                       'in_octets': '448778747',
                                                                       'in_ucast_pkts': '1615555184',
                                                                       'links': [       {       'in_octets': '448778747',
                                                                                                'in_ucast_pkts': '1615555184',
                                                                                                'out_octets': '1985815995',
                                                                                                'out_ucast_pkts': '833255705',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1985815995',
                                                                       'out_ucast_pkts': '833255705',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795950592',
                                                                                               'links': [       {       'connected_time': '9428517',
                                                                                                                        'fiber_length': 17919,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjBm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:ab:80'],
                                                                       'id': '1795950657',
                                                                       'in_octets': '1985815995',
                                                                       'in_ucast_pkts': '833255705',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '448778747',
                                                                       'out_ucast_pkts': '1615555184',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795950658',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795950659',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795950660',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795950721',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795950722',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBmUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwRg==',
                                         'serial_number': 'ADTN21135b0f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '9428517'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795951616',
                                                                       'in_octets': '3059936212',
                                                                       'in_ucast_pkts': '1645214816',
                                                                       'links': [       {       'in_octets': '3059936212',
                                                                                                'in_ucast_pkts': '1645214816',
                                                                                                'out_octets': '1057054808',
                                                                                                'out_ucast_pkts': '1226685681',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1057054808',
                                                                       'out_ucast_pkts': '1226685681',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBkSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795951616',
                                                                                               'links': [       {       'connected_time': '76561140',
                                                                                                                        'fiber_length': 19012,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjBk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ba:3a:50'],
                                                                       'id': '1795951681',
                                                                       'in_octets': '1057054808',
                                                                       'in_ucast_pkts': '1226685681',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3059936212',
                                                                       'out_ucast_pkts': '1645214816',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBkRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795951682',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBkRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795951745',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBkUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795951746',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBkUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwRA==',
                                         'serial_number': 'ADTN21135b0d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '76561140'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795952640',
                                                                       'in_octets': '2330086653',
                                                                       'in_ucast_pkts': '511448551',
                                                                       'links': [       {       'in_octets': '2330086653',
                                                                                                'in_ucast_pkts': '511448551',
                                                                                                'out_octets': '1381989118',
                                                                                                'out_ucast_pkts': '291366068',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1381989118',
                                                                       'out_ucast_pkts': '291366068',
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795952640',
                                                                                               'links': [       {       'connected_time': '31119008',
                                                                                                                        'fiber_length': 19206,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTAw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:9e:7b:20'],
                                                                       'id': '1795952705',
                                                                       'in_octets': '1381989118',
                                                                       'in_ucast_pkts': '291366068',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2330086653',
                                                                       'out_ucast_pkts': '511448551',
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795952706',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795952707',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795952708',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795952769',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795952770',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAwUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEwMA==',
                                         'serial_number': 'ADTN21135a00',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '31119008'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795953664',
                                                                       'in_octets': '181298735',
                                                                       'in_ucast_pkts': '754614476',
                                                                       'links': [       {       'in_octets': '181298735',
                                                                                                'in_ucast_pkts': '754614476',
                                                                                                'out_octets': '1604476805',
                                                                                                'out_ucast_pkts': '458247204',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1604476805',
                                                                       'out_ucast_pkts': '458247204',
                                                                       'poller_hash': 'QURUTjIxMTM1YTAxSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795953664',
                                                                                               'links': [       {       'connected_time': '76561100',
                                                                                                                        'fiber_length': 18907,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTAx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:9e:8e:50'],
                                                                       'id': '1795953729',
                                                                       'in_octets': '1604476805',
                                                                       'in_ucast_pkts': '458247204',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '181298735',
                                                                       'out_ucast_pkts': '754614476',
                                                                       'poller_hash': 'QURUTjIxMTM1YTAxRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795953730',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAxRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795953793',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAxUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795953794',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTAxUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '5@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEwMQ==',
                                         'serial_number': 'ADTN21135a01',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '76561100'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795954688',
                                                                       'in_octets': '3220287148',
                                                                       'in_ucast_pkts': '716230020',
                                                                       'links': [       {       'in_octets': '3220287148',
                                                                                                'in_ucast_pkts': '716230020',
                                                                                                'out_octets': '3049307702',
                                                                                                'out_ucast_pkts': '382284769',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3049307702',
                                                                       'out_ucast_pkts': '382284769',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795954688',
                                                                                               'links': [       {       'connected_time': '9444470',
                                                                                                                        'fiber_length': 18157,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjA5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:af:70'],
                                                                       'id': '1795954753',
                                                                       'in_octets': '3049307702',
                                                                       'in_ucast_pkts': '382284769',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3220287148',
                                                                       'out_ucast_pkts': '716230020',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795954754',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795954755',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795954756',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795954817',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795954818',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA5UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '6@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwOQ==',
                                         'serial_number': 'ADTN21135b09',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '9444470'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795955712',
                                                                       'in_octets': '3445314662',
                                                                       'in_ucast_pkts': '4236413975',
                                                                       'links': [       {       'in_octets': '3445314662',
                                                                                                'in_ucast_pkts': '4236413975',
                                                                                                'out_octets': '3002407483',
                                                                                                'out_ucast_pkts': '2987949427',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3002407483',
                                                                       'out_ucast_pkts': '2987949427',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRmSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795955712',
                                                                                               'links': [       {       'connected_time': '52199858',
                                                                                                                        'fiber_length': 18125,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTRm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:cd:b1:20'],
                                                                       'id': '1795955777',
                                                                       'in_octets': '3002407483',
                                                                       'in_ucast_pkts': '2987949427',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3445314662',
                                                                       'out_ucast_pkts': '4236413975',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRmRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795955778',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRmRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795955841',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRmUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795955842',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRmUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '7@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE0Rg==',
                                         'serial_number': 'ADTN21135a4f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '52199858'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795956736',
                                                                       'in_octets': '1225963708',
                                                                       'in_ucast_pkts': '93733019',
                                                                       'links': [       {       'in_octets': '1225963708',
                                                                                                'in_ucast_pkts': '93733019',
                                                                                                'out_octets': '2606693294',
                                                                                                'out_ucast_pkts': '38785153',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2606693294',
                                                                       'out_ucast_pkts': '38785153',
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795956736',
                                                                                               'links': [       {       'connected_time': '668861',
                                                                                                                        'fiber_length': 19811,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjI3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:29:6f:50'],
                                                                       'id': '1795956801',
                                                                       'in_octets': '2606693294',
                                                                       'in_ucast_pkts': '38785153',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1225963708',
                                                                       'out_ucast_pkts': '93733019',
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795956802',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795956803',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1795956804',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1795956865',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795956866',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI3UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '8@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyNw==',
                                         'serial_number': 'ADTN21135b27',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '668861'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795957760',
                                                                       'in_octets': '3085353583',
                                                                       'in_ucast_pkts': '3173602645',
                                                                       'links': [       {       'in_octets': '3085353583',
                                                                                                'in_ucast_pkts': '3173602645',
                                                                                                'out_octets': '3618437214',
                                                                                                'out_ucast_pkts': '1212002224',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3618437214',
                                                                       'out_ucast_pkts': '1212002224',
                                                                       'poller_hash': 'QURUTjIxMTM1Njk2SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795957760',
                                                                                               'links': [       {       'connected_time': '24539698',
                                                                                                                        'fiber_length': 17117,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njk2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:89:66:76'],
                                                                       'id': '1795957825',
                                                                       'in_octets': '3618437214',
                                                                       'in_ucast_pkts': '1212002224',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3085353583',
                                                                       'out_ucast_pkts': '3173602645',
                                                                       'poller_hash': 'QURUTjIxMTM1Njk2RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795957826',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk2RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795957889',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk2UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795957890',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1Njk2UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '9@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY5Ng==',
                                         'serial_number': 'ADTN21135696',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '24539698'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1795958784',
                                                                       'in_octets': '3120980034',
                                                                       'in_ucast_pkts': '1078362669',
                                                                       'links': [       {       'in_octets': '3120980034',
                                                                                                'in_ucast_pkts': '1078362669',
                                                                                                'out_discards': '1',
                                                                                                'out_octets': '657028387',
                                                                                                'out_ucast_pkts': '435266019',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_discards': '1',
                                                                       'out_octets': '657028387',
                                                                       'out_ucast_pkts': '435266019',
                                                                       'poller_hash': 'QURUTjIxMTM1NjkxSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1795958784',
                                                                                               'links': [       {       'connected_time': '17897989',
                                                                                                                        'fiber_length': 19147,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA0VTVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njkx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:66:18:c5:f1:20'],
                                                                       'id': '1795958849',
                                                                       'in_discards': '1',
                                                                       'in_octets': '657028387',
                                                                       'in_ucast_pkts': '435266019',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3120980034',
                                                                       'out_ucast_pkts': '1078362669',
                                                                       'poller_hash': 'QURUTjIxMTM1NjkxRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1795958850',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkxRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1795958913',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkxUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1795958914',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkxUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '10@1/11/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY5MQ==',
                                         'serial_number': 'ADTN21135691',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '17897989'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796211712',
                                                                       'in_octets': '3003120729',
                                                                       'in_ucast_pkts': '231493127',
                                                                       'links': [       {       'in_octets': '3003120729',
                                                                                                'in_ucast_pkts': '231493127',
                                                                                                'out_octets': '1249670662',
                                                                                                'out_ucast_pkts': '103144487',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1249670662',
                                                                       'out_ucast_pkts': '103144487',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796211712',
                                                                                               'links': [       {       'connected_time': '4089966',
                                                                                                                        'fiber_length': 15010,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWZi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ba:46:e0'],
                                                                       'id': '1796211777',
                                                                       'in_octets': '1249670662',
                                                                       'in_ucast_pkts': '103144487',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3003120729',
                                                                       'out_ucast_pkts': '231493127',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796211778',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796211779',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796211780',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796211841',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796211842',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZiUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/4',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFGQg==',
                                         'serial_number': 'ADTN21135afb',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '4089966'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796212736',
                                                                       'in_octets': '3906167266',
                                                                       'in_ucast_pkts': '2014018712',
                                                                       'links': [       {       'in_octets': '3906167266',
                                                                                                'in_ucast_pkts': '2014018712',
                                                                                                'out_discards': '8',
                                                                                                'out_errors': '2',
                                                                                                'out_octets': '2334730018',
                                                                                                'out_ucast_pkts': '1337614799',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_discards': '8',
                                                                       'out_errors': '2',
                                                                       'out_octets': '2334730018',
                                                                       'out_ucast_pkts': '1337614799',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796212736',
                                                                                               'links': [       {       'connected_time': '74060843',
                                                                                                                        'fiber_length': 13993,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjFj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:f8:b3:58:78:e1'],
                                                                       'id': '1796212801',
                                                                       'in_discards': '8',
                                                                       'in_errors': '2',
                                                                       'in_octets': '2334730018',
                                                                       'in_ucast_pkts': '1337614799',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3906167266',
                                                                       'out_ucast_pkts': '2014018712',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFjRXRoaW50ZjE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796212802',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796212865',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796212866',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/4',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxQw==',
                                         'serial_number': 'ADTN21135b1c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '74060843'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796213760',
                                                                       'in_octets': '3044108321',
                                                                       'in_ucast_pkts': '4022739561',
                                                                       'links': [       {       'in_octets': '3044108321',
                                                                                                'in_ucast_pkts': '4022739561',
                                                                                                'out_octets': '3378740231',
                                                                                                'out_ucast_pkts': '1915250010',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3378740231',
                                                                       'out_ucast_pkts': '1915250010',
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796213760',
                                                                                               'links': [       {       'connected_time': '48813806',
                                                                                                                        'fiber_length': 15835,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI1QzJVMDA1TkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTM0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:75:e8:50'],
                                                                       'id': '1796213825',
                                                                       'in_octets': '3378740231',
                                                                       'in_ucast_pkts': '1915250010',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3044108321',
                                                                       'out_ucast_pkts': '4022739561',
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796213826',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796213827',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796213828',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796213889',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796213890',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTM0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/4',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEzNA==',
                                         'serial_number': 'ADTN21135a34',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '48813806'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796473856',
                                                                       'in_octets': '3200964647',
                                                                       'in_ucast_pkts': '3981781887',
                                                                       'links': [       {       'in_octets': '3200964647',
                                                                                                'in_ucast_pkts': '3981781887',
                                                                                                'out_octets': '1602256384',
                                                                                                'out_ucast_pkts': '1244841013',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1602256384',
                                                                       'out_ucast_pkts': '1244841013',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796473856',
                                                                                               'links': [       {       'connected_time': '74052790',
                                                                                                                        'fiber_length': 10788,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTRk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:bb:6a:20'],
                                                                       'id': '1796473921',
                                                                       'in_octets': '1602256384',
                                                                       'in_ucast_pkts': '1244841013',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3200964647',
                                                                       'out_ucast_pkts': '3981781887',
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796473922',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796473923',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796473924',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796473985',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796473986',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTRkUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/5',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE0RA==',
                                         'serial_number': 'ADTN21135a4d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '74052790'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796474880',
                                                                       'in_octets': '2690101578',
                                                                       'in_ucast_pkts': '2685460522',
                                                                       'links': [       {       'in_octets': '2690101578',
                                                                                                'in_ucast_pkts': '2685460522',
                                                                                                'out_octets': '1729240216',
                                                                                                'out_ucast_pkts': '1602267716',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1729240216',
                                                                       'out_ucast_pkts': '1602267716',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAySURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796474880',
                                                                                               'links': [       {       'connected_time': '21087388',
                                                                                                                        'fiber_length': 12093,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjAy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '90:72:40:05:ff:63'],
                                                                       'id': '1796474945',
                                                                       'in_octets': '1729240216',
                                                                       'in_ucast_pkts': '1602267716',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2690101578',
                                                                       'out_ucast_pkts': '2685460522',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796474946',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796474947',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796474948',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796475009',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796475010',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAyUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/5',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwMg==',
                                         'serial_number': 'ADTN21135b02',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '21087388'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796475904',
                                                                       'in_octets': '675095625',
                                                                       'in_ucast_pkts': '59866596',
                                                                       'links': [       {       'in_octets': '675095625',
                                                                                                'in_ucast_pkts': '59866596',
                                                                                                'out_octets': '3458387619',
                                                                                                'out_ucast_pkts': '1872014179',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3458387619',
                                                                       'out_ucast_pkts': '1872014179',
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796475904',
                                                                                               'links': [       {       'connected_time': '74049861',
                                                                                                                        'fiber_length': 12273,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjI2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:cd:60'],
                                                                       'id': '1796475969',
                                                                       'in_octets': '3458387619',
                                                                       'in_ucast_pkts': '1872014179',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '675095625',
                                                                       'out_ucast_pkts': '59866596',
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796475970',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796475971',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796475972',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796476033',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796476034',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjI2UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/5',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyNg==',
                                         'serial_number': 'ADTN21135b26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '74049861'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796476928',
                                                                       'in_octets': '2365229199',
                                                                       'in_ucast_pkts': '3232173003',
                                                                       'links': [       {       'in_octets': '2365229199',
                                                                                                'in_ucast_pkts': '3232173003',
                                                                                                'out_octets': '2947081390',
                                                                                                'out_ucast_pkts': '879498204',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2947081390',
                                                                       'out_ucast_pkts': '879498204',
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796476928',
                                                                                               'links': [       {       'connected_time': '17879404',
                                                                                                                        'fiber_length': 11006,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNNUVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njkz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:e7:d8:80'],
                                                                       'id': '1796476993',
                                                                       'in_octets': '2947081390',
                                                                       'in_ucast_pkts': '879498204',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2365229199',
                                                                       'out_ucast_pkts': '3232173003',
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796476994',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796476995',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796476996',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796477057',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796477058',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjkzUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/5',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY5Mw==',
                                         'serial_number': 'ADTN21135693',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '17879404'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796736000',
                                                                       'in_octets': '3321036465',
                                                                       'in_ucast_pkts': '2613445521',
                                                                       'links': [       {       'in_octets': '3321036465',
                                                                                                'in_ucast_pkts': '2613445521',
                                                                                                'out_octets': '1769787544',
                                                                                                'out_ucast_pkts': '919332309',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1I='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1769787544',
                                                                       'out_ucast_pkts': '919332309',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796736000',
                                                                                               'links': [       {       'connected_time': '20308543',
                                                                                                                        'fiber_length': 8905,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1JncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWZh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d5:d0:40'],
                                                                       'id': '1796736065',
                                                                       'in_octets': '1769787544',
                                                                       'in_ucast_pkts': '919332309',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3321036465',
                                                                       'out_ucast_pkts': '2613445521',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796736066',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796736067',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1796736068',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1796736129',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796736130',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/6',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFGQQ==',
                                         'serial_number': 'ADTN21135afa',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '20308543'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796737024',
                                                                       'in_octets': '1486871793',
                                                                       'in_ucast_pkts': '3372068063',
                                                                       'links': [       {       'in_octets': '1486871793',
                                                                                                'in_ucast_pkts': '3372068063',
                                                                                                'out_octets': '2631085652',
                                                                                                'out_ucast_pkts': '4175946209',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1I='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2631085652',
                                                                       'out_ucast_pkts': '4175946209',
                                                                       'poller_hash': 'QURUTjIxMTM1YjEzSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796737024',
                                                                                               'links': [       {       'connected_time': '21369456',
                                                                                                                        'fiber_length': 9810,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1JncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -8.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjEz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:66:18:c5:f1:40'],
                                                                       'id': '1796737089',
                                                                       'in_octets': '2631085652',
                                                                       'in_ucast_pkts': '4175946209',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1486871793',
                                                                       'out_ucast_pkts': '3372068063',
                                                                       'poller_hash': 'QURUTjIxMTM1YjEzRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796737090',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEzRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796737153',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEzUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796737154',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEzUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/6',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxMw==',
                                         'serial_number': 'ADTN21135b13',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '21369456'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796738048',
                                                                       'in_octets': '3997603273',
                                                                       'in_ucast_pkts': '30325285',
                                                                       'links': [       {       'in_octets': '3997603273',
                                                                                                'in_ucast_pkts': '30325285',
                                                                                                'out_octets': '4148545627',
                                                                                                'out_ucast_pkts': '17481478',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1I='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4148545627',
                                                                       'out_ucast_pkts': '17481478',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796738048',
                                                                                               'links': [       {       'connected_time': '364212',
                                                                                                                        'fiber_length': 11512,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1JncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjAw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d5:72:10'],
                                                                       'id': '1796738113',
                                                                       'in_octets': '4148545627',
                                                                       'in_ucast_pkts': '17481478',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3997603273',
                                                                       'out_ucast_pkts': '30325285',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAwRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796738114',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAwRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796738177',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAwUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796738178',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAwUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/6',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwMA==',
                                         'serial_number': 'ADTN21135b00',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '364212'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796739072',
                                                                       'in_octets': '2419022164',
                                                                       'in_ucast_pkts': '3472817297',
                                                                       'links': [       {       'in_octets': '2419022164',
                                                                                                'in_ucast_pkts': '3472817297',
                                                                                                'out_octets': '2384647360',
                                                                                                'out_ucast_pkts': '1561479041',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1I='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2384647360',
                                                                       'out_ucast_pkts': '1561479041',
                                                                       'poller_hash': 'QURUTjIxMTM1YjExSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796739072',
                                                                                               'links': [       {       'connected_time': '25486462',
                                                                                                                        'fiber_length': 11318,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBNQ1JncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjEx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:eb:5c:80'],
                                                                       'id': '1796739137',
                                                                       'in_octets': '2384647360',
                                                                       'in_ucast_pkts': '1561479041',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2419022164',
                                                                       'out_ucast_pkts': '3472817297',
                                                                       'poller_hash': 'QURUTjIxMTM1YjExRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796739138',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjExRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796739201',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjExUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796739202',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjExUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/6',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxMQ==',
                                         'serial_number': 'ADTN21135b11',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '25486462'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796998144',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ3SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796998144',
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTQ3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ed:b5:20'],
                                                                       'id': '1796998209',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ3RXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1796998210',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ3RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796998273',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ3UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796998274',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ3UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE0Nw==',
                                         'serial_number': 'ADTN21135a47',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'M40.00.0013.M8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1796999168',
                                                                       'in_octets': '1386361750',
                                                                       'in_ucast_pkts': '1313446041',
                                                                       'links': [       {       'in_octets': '1386361750',
                                                                                                'in_ucast_pkts': '1313446041',
                                                                                                'out_discards': '6461400',
                                                                                                'out_errors': '5250447',
                                                                                                'out_octets': '3089812757',
                                                                                                'out_ucast_pkts': '801878411',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_discards': '6461400',
                                                                       'out_errors': '5250447',
                                                                       'out_octets': '3089812757',
                                                                       'out_ucast_pkts': '801878411',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAxSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1796999168',
                                                                                               'links': [       {       'connected_time': '17653540',
                                                                                                                        'fiber_length': 21171,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjAx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:95:8a:d0'],
                                                                       'id': '1796999233',
                                                                       'in_discards': '6461400',
                                                                       'in_errors': '5250447',
                                                                       'in_octets': '3089812757',
                                                                       'in_ucast_pkts': '801878411',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1386361750',
                                                                       'out_ucast_pkts': '1313446041',
                                                                       'poller_hash': 'QURUTjIxMTM1YjAxRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1796999234',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAxRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1796999297',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAxUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1796999298',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjAxUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwMQ==',
                                         'serial_number': 'ADTN21135b01',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '17653540'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797000192',
                                                                       'in_octets': '2330232258',
                                                                       'in_ucast_pkts': '452747265',
                                                                       'links': [       {       'in_octets': '2330232258',
                                                                                                'in_ucast_pkts': '452747265',
                                                                                                'out_octets': '3986982231',
                                                                                                'out_ucast_pkts': '279623830',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3986982231',
                                                                       'out_ucast_pkts': '279623830',
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797000192',
                                                                                               'links': [       {       'connected_time': '16699322',
                                                                                                                        'fiber_length': 17764,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjE0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:89:65:a0'],
                                                                       'id': '1797000257',
                                                                       'in_octets': '3986982231',
                                                                       'in_ucast_pkts': '279623830',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2330232258',
                                                                       'out_ucast_pkts': '452747265',
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797000258',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797000259',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797000260',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797000321',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797000322',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxNA==',
                                         'serial_number': 'ADTN21135b14',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '16699322'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797001216',
                                                                       'in_octets': '3506458004',
                                                                       'in_ucast_pkts': '3012702',
                                                                       'links': [       {       'in_octets': '3506458004',
                                                                                                'in_ucast_pkts': '3012702',
                                                                                                'out_octets': '290172207',
                                                                                                'out_ucast_pkts': '1897807',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '290172207',
                                                                       'out_ucast_pkts': '1897807',
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797001216',
                                                                                               'links': [       {       'connected_time': '12199',
                                                                                                                        'fiber_length': 18154,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjEw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:ad:80'],
                                                                       'id': '1797001281',
                                                                       'in_octets': '290172207',
                                                                       'in_ucast_pkts': '1897807',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3506458004',
                                                                       'out_ucast_pkts': '3012702',
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797001282',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797001283',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797001284',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797001345',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797001346',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjEwUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxMA==',
                                         'serial_number': 'ADTN21135b10',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '12199'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797002240',
                                                                       'in_octets': '813302132',
                                                                       'in_ucast_pkts': '3833390920',
                                                                       'links': [       {       'in_octets': '813302132',
                                                                                                'in_ucast_pkts': '3833390920',
                                                                                                'out_octets': '4138208958',
                                                                                                'out_ucast_pkts': '281688258',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4138208958',
                                                                       'out_ucast_pkts': '281688258',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797002240',
                                                                                               'links': [       {       'connected_time': '73979106',
                                                                                                                        'fiber_length': 17759,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjA3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:3c:10:80'],
                                                                       'id': '1797002305',
                                                                       'in_octets': '4138208958',
                                                                       'in_ucast_pkts': '281688258',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '813302132',
                                                                       'out_ucast_pkts': '3833390920',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797002306',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797002307',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797002308',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797002369',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797002370',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA3UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '5@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwNw==',
                                         'serial_number': 'ADTN21135b07',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '73979106'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797003264',
                                                                       'in_ucast_pkts': '4294967278',
                                                                       'links': [       {       'in_ucast_pkts': '4294967278',
                                                                                                'out_octets': '6155278',
                                                                                                'out_ucast_pkts': '707795555',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '6155278',
                                                                       'out_ucast_pkts': '707795555',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797003264',
                                                                                               'links': [       {       'connected_time': '2338426',
                                                                                                                        'fiber_length': 18582,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -30.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjBh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ce:42:10'],
                                                                       'id': '1797003329',
                                                                       'in_octets': '6155278',
                                                                       'in_ucast_pkts': '707795555',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_ucast_pkts': '4294967278',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBhRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797003330',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797003393',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797003394',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '6@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwQQ==',
                                         'serial_number': 'ADTN21135b0a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '2338426'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797004288',
                                                                       'in_octets': '473132879',
                                                                       'in_ucast_pkts': '437984119',
                                                                       'links': [       {       'in_octets': '473132879',
                                                                                                'in_ucast_pkts': '437984119',
                                                                                                'out_octets': '3851687207',
                                                                                                'out_ucast_pkts': '222018009',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEI='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3851687207',
                                                                       'out_ucast_pkts': '222018009',
                                                                       'poller_hash': 'QURUTjIxMTM0Y2ZjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797004288',
                                                                                               'links': [       {       'connected_time': '600846',
                                                                                                                        'fiber_length': 21615,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBMOEJncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0Y2Zj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:66:18:c5:e5:30'],
                                                                       'id': '1797004353',
                                                                       'in_octets': '3851687207',
                                                                       'in_ucast_pkts': '222018009',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '473132879',
                                                                       'out_ucast_pkts': '437984119',
                                                                       'poller_hash': 'QURUTjIxMTM0Y2ZjRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797004354',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2ZjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797004417',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2ZjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797004418',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2ZjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '7@1/11/7',
                                         'poller_hash': 'b250IEFEVE4yMTEzNENGQw==',
                                         'serial_number': 'ADTN21134cfc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '600846'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797260288',
                                                                       'in_octets': '3482649245',
                                                                       'in_ucast_pkts': '121724564',
                                                                       'links': [       {       'in_octets': '3482649245',
                                                                                                'in_ucast_pkts': '121724564',
                                                                                                'out_octets': '3111495899',
                                                                                                'out_ucast_pkts': '36216328',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3111495899',
                                                                       'out_ucast_pkts': '36216328',
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797260288',
                                                                                               'links': [       {       'connected_time': '669150',
                                                                                                                        'fiber_length': 14982,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjIw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d5:87:d0'],
                                                                       'id': '1797260353',
                                                                       'in_octets': '3111495899',
                                                                       'in_ucast_pkts': '36216328',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3482649245',
                                                                       'out_ucast_pkts': '121724564',
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797260354',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797260355',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797260356',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797260417',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797260418',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjIwUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/11/8',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyMA==',
                                         'serial_number': 'ADTN21135b20',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '669150'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797261312',
                                                                       'in_octets': '400265061',
                                                                       'in_ucast_pkts': '1513615898',
                                                                       'links': [       {       'in_octets': '400265061',
                                                                                                'in_ucast_pkts': '1513615898',
                                                                                                'out_discards': '1',
                                                                                                'out_octets': '189469386',
                                                                                                'out_ucast_pkts': '634425303',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_discards': '1',
                                                                       'out_octets': '189469386',
                                                                       'out_ucast_pkts': '634425303',
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797261312',
                                                                                               'links': [       {       'connected_time': '19386522',
                                                                                                                        'fiber_length': 14013,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWUz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d5:86:00'],
                                                                       'id': '1797261377',
                                                                       'in_discards': '1',
                                                                       'in_octets': '189469386',
                                                                       'in_ucast_pkts': '634425303',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '400265061',
                                                                       'out_ucast_pkts': '1513615898',
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797261378',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797261379',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797261380',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797261441',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797261442',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWUzUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/11/8',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFFMw==',
                                         'serial_number': 'ADTN21135ae3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '19386522'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797262336',
                                                                       'in_octets': '847319012',
                                                                       'in_ucast_pkts': '72156828',
                                                                       'links': [       {       'in_octets': '847319012',
                                                                                                'in_ucast_pkts': '72156828',
                                                                                                'out_octets': '4214783908',
                                                                                                'out_ucast_pkts': '34471877',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4214783908',
                                                                       'out_ucast_pkts': '34471877',
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797262336',
                                                                                               'links': [       {       'connected_time': '668910',
                                                                                                                        'fiber_length': 14437,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWU5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ba:3b:30'],
                                                                       'id': '1797262401',
                                                                       'in_octets': '4214783908',
                                                                       'in_ucast_pkts': '34471877',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '847319012',
                                                                       'out_ucast_pkts': '72156828',
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797262402',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797262403',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797262404',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797262465',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797262466',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWU5UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/11/8',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFFOQ==',
                                         'serial_number': 'ADTN21135ae9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '668910'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797263360',
                                                                       'in_octets': '648197685',
                                                                       'in_ucast_pkts': '1879627385',
                                                                       'links': [       {       'in_octets': '648197685',
                                                                                                'in_ucast_pkts': '1879627385',
                                                                                                'out_octets': '122082069',
                                                                                                'out_ucast_pkts': '986654995',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '122082069',
                                                                       'out_ucast_pkts': '986654995',
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797263360',
                                                                                               'links': [       {       'connected_time': '15118269',
                                                                                                                        'fiber_length': 14827,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZGJh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:eb:5d:50'],
                                                                       'id': '1797263425',
                                                                       'in_octets': '122082069',
                                                                       'in_ucast_pkts': '986654995',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '648197685',
                                                                       'out_ucast_pkts': '1879627385',
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797263426',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797263427',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797263428',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797263489',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797263490',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGJhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/11/8',
                                         'poller_hash': 'b250IEFEVE4yMTEzNERCQQ==',
                                         'serial_number': 'ADTN21134dba',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '15118269'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1797264384',
                                                                       'in_octets': '1130321548',
                                                                       'in_ucast_pkts': '103248888',
                                                                       'links': [       {       'in_octets': '1130321548',
                                                                                                'in_ucast_pkts': '103248888',
                                                                                                'out_octets': '968567065',
                                                                                                'out_ucast_pkts': '47880240',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDA='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '968567065',
                                                                       'out_ucast_pkts': '47880240',
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1797264384',
                                                                                               'links': [       {       'connected_time': '667528',
                                                                                                                        'fiber_length': 15063,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNTk4VjI0QkJVMDBKSDBncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWVh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c8:b3:73:29:1d:8d'],
                                                                       'id': '1797264449',
                                                                       'in_octets': '968567065',
                                                                       'in_ucast_pkts': '47880240',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1130321548',
                                                                       'out_ucast_pkts': '103248888',
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhRXRoaW50ZjE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1797264450',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1797264451',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1797264452',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1797264513',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1797264514',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWVhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '5@1/11/8',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFFQQ==',
                                         'serial_number': 'ADTN21135aea',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '667528'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912865792',
                                                                       'in_octets': '1405054727',
                                                                       'in_ucast_pkts': '2556892307',
                                                                       'links': [       {       'in_octets': '1405054727',
                                                                                                'in_ucast_pkts': '2556892307',
                                                                                                'out_octets': '8710029',
                                                                                                'out_ucast_pkts': '1016436271',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '8710029',
                                                                       'out_ucast_pkts': '1016436271',
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912865792',
                                                                                               'links': [       {       'connected_time': '49611637',
                                                                                                                        'fiber_length': 12907,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjJj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:ba:3c:30'],
                                                                       'id': '1912865857',
                                                                       'in_octets': '8710029',
                                                                       'in_ucast_pkts': '1016436271',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1405054727',
                                                                       'out_ucast_pkts': '2556892307',
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1912865858',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912865859',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1912865860',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1912865921',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912865922',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJjUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyQw==',
                                         'serial_number': 'ADTN21135b2c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '49611637'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912866816',
                                                                       'in_octets': '3637181696',
                                                                       'in_ucast_pkts': '383952819',
                                                                       'links': [       {       'in_octets': '3637181696',
                                                                                                'in_ucast_pkts': '383952819',
                                                                                                'out_octets': '927737999',
                                                                                                'out_ucast_pkts': '2148830349',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '927737999',
                                                                       'out_ucast_pkts': '2148830349',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912866816',
                                                                                               'links': [       {       'connected_time': '49793332',
                                                                                                                        'fiber_length': 12869,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjA0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:66:18:c0:d6:e0'],
                                                                       'id': '1912866881',
                                                                       'in_octets': '927737999',
                                                                       'in_ucast_pkts': '2148830349',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3637181696',
                                                                       'out_ucast_pkts': '383952819',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1912866882',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912866883',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1912866884',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1912866945',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912866946',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA0UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwNA==',
                                         'serial_number': 'ADTN21135b04',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '49793332'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912867840',
                                                                       'in_octets': '147360823',
                                                                       'in_ucast_pkts': '1980299460',
                                                                       'links': [       {       'in_octets': '147360823',
                                                                                                'in_ucast_pkts': '1980299460',
                                                                                                'out_octets': '3863797334',
                                                                                                'out_ucast_pkts': '918433962',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3863797334',
                                                                       'out_ucast_pkts': '918433962',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA1SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912867840',
                                                                                               'links': [       {       'connected_time': '9440270',
                                                                                                                        'fiber_length': 12575,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjA1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:e8:70:40'],
                                                                       'id': '1912867905',
                                                                       'in_octets': '3863797334',
                                                                       'in_ucast_pkts': '918433962',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '147360823',
                                                                       'out_ucast_pkts': '1980299460',
                                                                       'poller_hash': 'QURUTjIxMTM1YjA1RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1912867906',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA1RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912867969',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA1UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912867970',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjA1UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwNQ==',
                                         'serial_number': 'ADTN21135b05',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '9440270'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912868864',
                                                                       'in_octets': '927220640',
                                                                       'in_ucast_pkts': '696439027',
                                                                       'links': [       {       'in_octets': '927220640',
                                                                                                'in_ucast_pkts': '696439027',
                                                                                                'out_octets': '1126009012',
                                                                                                'out_ucast_pkts': '271188079',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1126009012',
                                                                       'out_ucast_pkts': '271188079',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912868864',
                                                                                               'links': [       {       'connected_time': '14104497',
                                                                                                                        'fiber_length': 12304,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjBl',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:95:88:e0'],
                                                                       'id': '1912868929',
                                                                       'in_octets': '1126009012',
                                                                       'in_ucast_pkts': '271188079',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '927220640',
                                                                       'out_ucast_pkts': '696439027',
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1912868930',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912868931',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1912868932',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1912868993',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912868994',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjBlUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIwRQ==',
                                         'serial_number': 'ADTN21135b0e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '14104497'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912869888',
                                                                       'in_octets': '542138790',
                                                                       'in_ucast_pkts': '3313487145',
                                                                       'links': [       {       'in_octets': '542138790',
                                                                                                'in_ucast_pkts': '3313487145',
                                                                                                'out_octets': '1693383347',
                                                                                                'out_ucast_pkts': '1675651217',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1693383347',
                                                                       'out_ucast_pkts': '1675651217',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFkSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912869888',
                                                                                               'links': [       {       'connected_time': '49791187',
                                                                                                                        'fiber_length': 10933,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjFk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:8d:a9:e0'],
                                                                       'id': '1912869953',
                                                                       'in_octets': '1693383347',
                                                                       'in_ucast_pkts': '1675651217',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '542138790',
                                                                       'out_ucast_pkts': '3313487145',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFkRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1912869954',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFkRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912870017',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFkUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912870018',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFkUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '5@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxRA==',
                                         'serial_number': 'ADTN21135b1d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '49791187'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1912870912',
                                                                       'links': [       {       'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkY='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1912870912',
                                                                                               'links': [       {       'connected_time': '49788815',
                                                                                                                        'fiber_length': 11173,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBMUkZncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjE1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1912870977',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1RXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1912870978',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1912870979',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1912870980',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1912871041',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1912871042',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE1UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '6@1/18/1',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxNQ==',
                                         'serial_number': 'ADTN21135b15',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '49788815'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913127936',
                                                                       'in_octets': '2480093508',
                                                                       'in_ucast_pkts': '3324933389',
                                                                       'links': [       {       'in_octets': '2480093508',
                                                                                                'in_ucast_pkts': '3324933389',
                                                                                                'out_octets': '2842631825',
                                                                                                'out_ucast_pkts': '1705281630',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2842631825',
                                                                       'out_ucast_pkts': '1705281630',
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913127936',
                                                                                               'links': [       {       'connected_time': '49792012',
                                                                                                                        'fiber_length': 13230,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjJh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:91:82:bc:0d:26'],
                                                                       'id': '1913128001',
                                                                       'in_octets': '2842631825',
                                                                       'in_ucast_pkts': '1705281630',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2480093508',
                                                                       'out_ucast_pkts': '3324933389',
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913128002',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913128003',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913128004',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913128065',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913128066',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjJhUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIyQQ==',
                                         'serial_number': 'ADTN21135b2a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '49792012'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913128960',
                                                                       'links': [       {       'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913128960',
                                                                                               'links': [       {       'connected_time': '12894942',
                                                                                                                        'fiber_length': 12461,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1Njlk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1913129025',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkRXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1913129026',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913129027',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913129028',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkRXRoaW50ZjQ='},
                                                               {       'admin_up': False,
                                                                       'id': '1913129089',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913129090',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1NjlkUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNTY5RA==',
                                         'serial_number': 'ADTN2113569d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '12894942'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913129984',
                                                                       'in_octets': '2222890840',
                                                                       'in_ucast_pkts': '2138027658',
                                                                       'links': [       {       'in_octets': '2222890840',
                                                                                                'in_ucast_pkts': '2138027658',
                                                                                                'out_octets': '1474975785',
                                                                                                'out_ucast_pkts': '2900712968',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1474975785',
                                                                       'out_ucast_pkts': '2900712968',
                                                                       'poller_hash': 'QURUTjIxMTM1YjE2SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913129984',
                                                                                               'links': [       {       'connected_time': '1298644',
                                                                                                                        'fiber_length': 12725,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjE2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:66:18:c5:e0:30'],
                                                                       'id': '1913130049',
                                                                       'in_octets': '1474975785',
                                                                       'in_ucast_pkts': '2900712968',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2222890840',
                                                                       'out_ucast_pkts': '2138027658',
                                                                       'poller_hash': 'QURUTjIxMTM1YjE2RXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913130050',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE2RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913130113',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE2UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913130114',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjE2UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxNg==',
                                         'serial_number': 'ADTN21135b16',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '1298644'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913132032',
                                                                       'in_octets': '3804319367',
                                                                       'in_ucast_pkts': '4041098936',
                                                                       'links': [       {       'in_octets': '3804319367',
                                                                                                'in_ucast_pkts': '4041098936',
                                                                                                'out_octets': '882780321',
                                                                                                'out_ucast_pkts': '2109471025',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '882780321',
                                                                       'out_ucast_pkts': '2109471025',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZmSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913132032',
                                                                                               'links': [       {       'connected_time': '29993129',
                                                                                                                        'fiber_length': 12761,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YWZm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:bb:6c:e0'],
                                                                       'id': '1913132097',
                                                                       'in_octets': '882780321',
                                                                       'in_ucast_pkts': '2109471025',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3804319367',
                                                                       'out_ucast_pkts': '4041098936',
                                                                       'poller_hash': 'QURUTjIxMTM1YWZmRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913132098',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZmRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913132161',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZmUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913132162',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YWZmUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '5@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUFGRg==',
                                         'serial_number': 'ADTN21135aff',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '29993129'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913133056',
                                                                       'in_octets': '3776065813',
                                                                       'in_ucast_pkts': '175006694',
                                                                       'links': [       {       'in_octets': '3776065813',
                                                                                                'in_ucast_pkts': '175006694',
                                                                                                'out_discards': '37',
                                                                                                'out_octets': '3071981828',
                                                                                                'out_ucast_pkts': '73859957',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_discards': '37',
                                                                       'out_octets': '3071981828',
                                                                       'out_ucast_pkts': '73859957',
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913133056',
                                                                                               'links': [       {       'connected_time': '668577',
                                                                                                                        'fiber_length': 13276,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTQ1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:95:89:b0'],
                                                                       'id': '1913133121',
                                                                       'in_discards': '37',
                                                                       'in_octets': '3071981828',
                                                                       'in_ucast_pkts': '73859957',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3776065813',
                                                                       'out_ucast_pkts': '175006694',
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1RXRoaW50ZjE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913133122',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913133123',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913133124',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913133185',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913133186',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTQ1UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '6@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE0NQ==',
                                         'serial_number': 'ADTN21135a45',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '668577'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913134080',
                                                                       'in_octets': '3992388025',
                                                                       'in_ucast_pkts': '1456902910',
                                                                       'links': [       {       'in_octets': '3992388025',
                                                                                                'in_ucast_pkts': '1456902910',
                                                                                                'out_octets': '569177600',
                                                                                                'out_ucast_pkts': '662766845',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlg='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '569177600',
                                                                       'out_ucast_pkts': '662766845',
                                                                       'poller_hash': 'QURUTjIxMTM1YTMySURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913134080',
                                                                                               'links': [       {       'connected_time': '24980595',
                                                                                                                        'fiber_length': 13943,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI0QkJVMDBKWlhncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 30000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTMy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:6b:da:40'],
                                                                       'id': '1913134145',
                                                                       'in_octets': '569177600',
                                                                       'in_ucast_pkts': '662766845',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '3992388025',
                                                                       'out_ucast_pkts': '1456902910',
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913134146',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913134147',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913134148',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913134209',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913134210',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTMyUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '7@1/18/2',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUEzMg==',
                                         'serial_number': 'ADTN21135a32',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '24980595'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913390080',
                                                                       'in_octets': '2917590018',
                                                                       'in_ucast_pkts': '1042043720',
                                                                       'links': [       {       'in_octets': '2917590018',
                                                                                                'in_ucast_pkts': '1042043720',
                                                                                                'out_octets': '334582124',
                                                                                                'out_ucast_pkts': '437379274',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '334582124',
                                                                       'out_ucast_pkts': '437379274',
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913390080',
                                                                                               'links': [       {       'connected_time': '28426412',
                                                                                                                        'fiber_length': 504,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0ZGEw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:95:89:60'],
                                                                       'id': '1913390145',
                                                                       'in_octets': '334582124',
                                                                       'in_ucast_pkts': '437379274',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2917590018',
                                                                       'out_ucast_pkts': '1042043720',
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913390146',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913390147',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913390148',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913390209',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913390210',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0ZGEwUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '1@1/18/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNERBMA==',
                                         'serial_number': 'ADTN21134da0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '28426412'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913391104',
                                                                       'in_octets': '4025074970',
                                                                       'in_ucast_pkts': '3247432224',
                                                                       'links': [       {       'in_octets': '4025074970',
                                                                                                'in_ucast_pkts': '3247432224',
                                                                                                'out_octets': '1079411488',
                                                                                                'out_ucast_pkts': '1724884558',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1079411488',
                                                                       'out_ucast_pkts': '1724884558',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlSURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913391104',
                                                                                               'links': [       {       'connected_time': '28431144',
                                                                                                                        'fiber_length': 1988,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YjFl',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d7:33:70'],
                                                                       'id': '1913391169',
                                                                       'in_octets': '1079411488',
                                                                       'in_ucast_pkts': '1724884558',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4025074970',
                                                                       'out_ucast_pkts': '3247432224',
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913391170',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913391171',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913391172',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913391233',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913391234',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YjFlUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '2@1/18/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUIxRQ==',
                                         'serial_number': 'ADTN21135b1e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '28431144'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913392128',
                                                                       'in_octets': '297363197',
                                                                       'in_ucast_pkts': '2090609259',
                                                                       'links': [       {       'in_octets': '297363197',
                                                                                                'in_ucast_pkts': '2090609259',
                                                                                                'out_octets': '1608572388',
                                                                                                'out_ucast_pkts': '2165876167',
                                                                                                'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVU='}],
                                                                       'name': 'Pon 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1608572388',
                                                                       'out_ucast_pkts': '2165876167',
                                                                       'poller_hash': 'QURUTjIxMTM1YTUySURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913392128',
                                                                                               'links': [       {       'connected_time': '28340764',
                                                                                                                        'fiber_length': 1081,
                                                                                                                        'poller_hash': 'TEJBRFROMTkzM0FDNjAxVjI1QzJVMDA1RVVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM1YTUy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:eb:59:d0'],
                                                                       'id': '1913392193',
                                                                       'in_octets': '1608572388',
                                                                       'in_ucast_pkts': '2165876167',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': True,
                                                                       'out_octets': '297363197',
                                                                       'out_ucast_pkts': '2090609259',
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyRXRoaW50ZjE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '1913392194',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyRXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913392195',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyRXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913392196',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyRXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913392257',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyUE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913392258',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM1YTUyUE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '3@1/18/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNUE1Mg==',
                                         'serial_number': 'ADTN21135a52',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M8',
                                         'uptime': '28340764'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913393152',
                                                                       'name': 'Pon 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3SURpbnRmUmVn',
                                                                       'pons': [       {       'description': 'Pon '
                                                                                                              '1',
                                                                                               'id': '1913393152',
                                                                                               'max_distance': 20000,
                                                                                               'name': 'Pon '
                                                                                                       '1',
                                                                                               'poller_hash': 'QURUTjIxMTM0Y2Y3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:2c:6d:d7:22:e0'],
                                                                       'id': '1913393217',
                                                                       'name': 'Eth 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3RXRoaW50ZjE='},
                                                               {       'admin_up': True,
                                                                       'id': '1913393218',
                                                                       'name': 'Eth 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3RXRoaW50ZjI='},
                                                               {       'admin_up': True,
                                                                       'id': '1913393219',
                                                                       'name': 'Eth 3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3RXRoaW50ZjM='},
                                                               {       'admin_up': True,
                                                                       'id': '1913393220',
                                                                       'name': 'Eth 4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3RXRoaW50ZjQ='},
                                                               {       'admin_up': True,
                                                                       'id': '1913393281',
                                                                       'name': 'POTS 1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3UE9UU2ludGYx'},
                                                               {       'admin_up': True,
                                                                       'id': '1913393282',
                                                                       'name': 'POTS 2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTM0Y2Y3UE9UU2ludGYy'}],
                                         'manufacturer': 'Adtran',
                                         'model': '452 4th GEN OUTDOOR SFU 2P+2GE',
                                         'name': '4@1/18/3',
                                         'poller_hash': 'b250IEFEVE4yMTEzNENGNw==',
                                         'serial_number': 'ADTN21134cf7',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'M40.00.0013.M8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1913394176',
                                                                       'in_octets': '888036758',
                                                                       'in_ucast_pkts': '3644579416',
                                                                       'links': [       {       'in_octets': '888036758',
                                                                                                'in_ucast_pkts': '3644579416',
                   