# preseem-network-poller - poll stats from network elements

## Building and testing

```
python3 -m venv ~/venv/poller
source ~/venv/poller/bin/activate
pip install -r requirements.txt
pip install -r ../requirements.txt
../grpc-model/gen.sh
pip install -U ../grpc-model/
pip install -U ../preseem-sdk/
```

You can do a manual RPM build like this, if you want to.  This example
will build a development RPM of version 0.1.5.
```
gcloud docker --authorize-only
docker run --rm -it --entrypoint bash -v $PWD:/network-poller gcr.io/preseem/preseem-python-cloudbuild:latest
cd network-poller
./package.sh network-poller 0.1.5
```

This will build the rpm in the `rpms` directory.

We need to develop a unit testing strategy for this; right now the only way
to run it is at a customer site.  You can simply scp the rpm there and install
it on site, or you can scp files there or make edits right on the box for
prototyping/debugging.

To run it locally, the simplest way is to use Docker.
Install pre-requisite Aterlo packages like this:
```
docker run --rm -it --entrypoint bash -v $PWD:/network-poller fedora:latest
dnf install -y https://storage.googleapis.com/preseem-release/preseem-release.rpm
dnf install --enablerepo=preseem-alpha -y preseem-netmeta-agent python-preseem-sdk
```

Then you can edit the code on your PC and it will be runnable in the container.
```
cd network-poller
./preseem-network-poller ...
```
