import os.path
import sys
sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase
class TestTarana(DeviceTestCase):

    def test_tarana_G2_30_0196_001_4_021_000_00_10_139_244_130(self):
        obj = self.run_data("tarana.G2.30-0196-001.4.021.000.00.10_139_244_130")
        exp_info = {
                'model': '30-0196-001',
                'sta_count': 27,
                'sw_version': '4.021.000.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S196M2254000072',
                'system_mac_address': '04:f1:7d:06:b0:e7',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:11:6c': {       'dev_macs': ['14:21:03:df:84:bb'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2019518284,
                                             'dl_rf_packets': 1540809,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:11:6c',
                                             'name': 'Michelle_Thamas',
                                             'serial_number': 'S128F1212800277',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 102072737,
                                             'ul_rf_packets': 341237},
                '04:f1:7d:00:25:9f': {       'dev_macs': ['4c:01:43:5b:af:10'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 3016080596,
                                             'dl_rf_packets': 2049625,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:25:9f',
                                             'name': 'Dancan_Chartars',
                                             'serial_number': 'S128F1211600306',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 66236862,
                                             'ul_rf_packets': 574201},
                '04:f1:7d:00:26:f7': {       'dev_macs': ['f8:85:f9:8d:27:7d'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 78672393,
                                             'dl_rf_packets': 61689,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:26:f7',
                                             'name': 'Vandermark_Gijsbertus_56990',
                                             'serial_number': 'S128F1211400228',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6623323,
                                             'ul_rf_packets': 33752},
                '04:f1:7d:00:27:04': {       'dev_macs': ['d0:76:8f:f5:cd:15'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 28611498,
                                             'dl_rf_packets': 36964,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:27:04',
                                             'name': 'Clayton_Bowers',
                                             'serial_number': 'S128F1211400225',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 11488847,
                                             'ul_rf_packets': 31393},
                '04:f1:7d:00:27:b1': {       'dev_macs': ['84:d3:43:5a:e3:a6'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 431378797,
                                             'dl_rf_packets': 321831,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:27:b1',
                                             'name': 'Blair_Smith',
                                             'serial_number': 'S128F1211600238',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 22299259,
                                             'ul_rf_packets': 97141},
                '04:f1:7d:00:28:0d': {       'dev_macs': ['d0:76:8f:03:5e:2b'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 526597,
                                             'dl_rf_packets': 2789,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:0d',
                                             'name': 'Chuck_Wallis',
                                             'serial_number': 'S128F1211400071',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 823467,
                                             'ul_rf_packets': 3510},
                '04:f1:7d:00:28:c0': {       'dev_macs': ['84:d3:43:99:ec:67'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 107822,
                                             'dl_rf_packets': 841,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:c0',
                                             'name': 'Deborah_Snith',
                                             'serial_number': 'S128F1211600020',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 185844,
                                             'ul_rf_packets': 798},
                '04:f1:7d:00:28:d0': {       'dev_macs': ['e4:6c:d1:da:9d:cd'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 869642,
                                             'dl_rf_packets': 1745,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:d0',
                                             'name': 'Blake_Higdon',
                                             'serial_number': 'S128F1211600034',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 298796,
                                             'ul_rf_packets': 925},
                '04:f1:7d:00:29:31': {       'dev_macs': ['34:98:b5:74:c8:46'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 155873,
                                             'dl_rf_packets': 910,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:29:31',
                                             'name': 'Doerr',
                                             'serial_number': 'S128F1211600174',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 124453,
                                             'ul_rf_packets': 813},
                '04:f1:7d:00:2b:a6': {       'dev_macs': ['a0:04:60:69:44:9e'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 1072188533,
                                             'dl_rf_packets': 728842,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2b:a6',
                                             'name': 'Obhiambo',
                                             'serial_number': 'S128F1212500054',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 36429625,
                                             'ul_rf_packets': 357330},
                '04:f1:7d:00:2d:03': {       'dev_macs': ['84:d3:43:5a:db:3a'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 31785381,
                                             'dl_rf_packets': 24424,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2d:03',
                                             'name': 'Norman_Brokaw',
                                             'serial_number': 'S128F1212400098',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2345240,
                                             'ul_rf_packets': 15477},
                '04:f1:7d:00:2d:7d': {       'dev_macs': ['04:bc:9f:60:0f:3f'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 524935040,
                                             'dl_rf_packets': 355943,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2d:7d',
                                             'name': 'Mary_Baird',
                                             'serial_number': 'S128F1212500218',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8655774,
                                             'ul_rf_packets': 54419},
                '04:f1:7d:00:2d:88': {       'dev_macs': ['84:d3:43:14:8d:9a'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 346570,
                                             'dl_rf_packets': 1421,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2d:88',
                                             'name': 'Deborah_Smith',
                                             'serial_number': 'S128F1212500270',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 550217,
                                             'ul_rf_packets': 1345},
                '04:f1:7d:00:2e:4f': {       'dev_macs': ['04:42:1a:56:31:58'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 27687737,
                                             'dl_rf_packets': 41808,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2e:4f',
                                             'name': 'stahaine_Tram',
                                             'serial_number': 'S128F1212500552',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8817989,
                                             'ul_rf_packets': 35494},
                '04:f1:7d:00:2f:5f': {       'dev_macs': ['60:db:98:6c:ef:8c'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 6980800,
                                             'dl_rf_packets': 26469,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2f:5f',
                                             'name': 'Hahn_Timothy_76172',
                                             'serial_number': 'S128F1212800104',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 26570030,
                                             'ul_rf_packets': 27389},
                '04:f1:7d:00:6a:96': {       'dev_macs': ['60:db:98:18:ad:15'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 208376,
                                             'dl_rf_packets': 1212,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:6a:96',
                                             'name': 'Pitch_Furcl',
                                             'serial_number': 'S128F2221502767',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 413451,
                                             'ul_rf_packets': 1741},
                '04:f1:7d:00:6c:e3': {       'dev_macs': ['84:d3:43:5a:de:26'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 374855097,
                                             'dl_rf_packets': 355392,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:6c:e3',
                                             'name': 'Ashlynn_Ostrowski',
                                             'serial_number': 'S128F2221502887',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 89672762,
                                             'ul_rf_packets': 150397},
                '04:f1:7d:00:6d:10': {       'dev_macs': ['84:d3:43:a6:5a:db'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 424097416,
                                             'dl_rf_packets': 286327,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:6d:10',
                                             'name': 'Sally_Menlce',
                                             'serial_number': 'S128F2221502956',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 9515315,
                                             'ul_rf_packets': 96002},
                '04:f1:7d:00:b6:29': {       'dev_macs': ['b8:94:70:92:40:53'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 55382,
                                             'dl_rf_packets': 503,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:b6:29',
                                             'name': 'Deborah_Snith',
                                             'serial_number': 'S150F2222904029',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 105391,
                                             'ul_rf_packets': 347},
                '04:f1:7d:00:b7:2c': {       'dev_macs': ['84:d3:43:14:4d:94'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 17219865,
                                             'dl_rf_packets': 14332,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:b7:2c',
                                             'name': 'Bruce_Jackson_64949',
                                             'serial_number': 'S150F2222906570',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1611582,
                                             'ul_rf_packets': 9743},
                '04:f1:7d:00:ba:08': {       'dev_macs': ['3c:37:86:fb:ef:f0'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2467804,
                                             'dl_rf_packets': 18016,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:ba:08',
                                             'name': 'Richard_Forcick',
                                             'serial_number': 'S150F2223101694',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 38420992,
                                             'ul_rf_packets': 30109},
                '04:f1:7d:00:ba:8b': {       'dev_macs': ['d0:76:8f:94:dd:3a'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 1036690865,
                                             'dl_rf_packets': 806402,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:ba:8b',
                                             'name': 'Cy_Buntins',
                                             'serial_number': 'S150F2223101695',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 15481902,
                                             'ul_rf_packets': 131894},
                '04:f1:7d:00:bb:1c': {       'dev_macs': ['84:d3:43:b5:1a:37'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 356500,
                                             'dl_rf_packets': 1417,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:bb:1c',
                                             'name': 'miller_Mich',
                                             'serial_number': 'S150F2223100262',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 696628,
                                             'ul_rf_packets': 1557},
                '04:f1:7d:00:de:6c': {       'dev_macs': ['14:21:03:a3:71:76'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 6204877,
                                             'dl_rf_packets': 9096,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:de:6c',
                                             'name': 'Cindy_Hall',
                                             'serial_number': 'S150F2223731625',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1652848,
                                             'ul_rf_packets': 8657},
                '04:f1:7d:01:09:84': {       'dev_macs': ['d0:76:8f:73:4f:07'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 146164,
                                             'dl_rf_packets': 753,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:09:84',
                                             'name': 'Leai_Ute',
                                             'serial_number': 'S150F2224123012',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 141116,
                                             'ul_rf_packets': 656},
                '04:f1:7d:01:13:a4': {       'dev_macs': ['d0:76:8f:42:dc:ee'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 101002947,
                                             'dl_rf_packets': 82562,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:13:a4',
                                             'name': 'Gster_Sontag',
                                             'serial_number': 'S150F2224205103',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3536533,
                                             'ul_rf_packets': 17072},
                '04:f1:7d:01:86:f6': {       'dev_macs': ['60:db:98:56:57:5d'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 591209439,
                                             'dl_rf_packets': 472664,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:86:f6',
                                             'name': 'Michael_Chakur',
                                             'serial_number': 'S150F2230215532',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 110921826,
                                             'ul_rf_packets': 304281}
        }
        exp_ne_msg = {
                'data': {       'cpu': 5.6116014,
                                'elevation': 156.471,
                                'gps_sats_tracked': 18,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '5871',
                                                                                       'in_octets': '102072737',
                                                                                       'in_ucast_pkts': '341237',
                                                                                       'out_errors': '58266',
                                                                                       'out_octets': '2019518284',
                                                                                       'out_ucast_pkts': '1540809',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ=='},
                                                                               {       'in_errors': '1072',
                                                                                       'in_octets': '2345240',
                                                                                       'in_ucast_pkts': '15477',
                                                                                       'out_errors': '94',
                                                                                       'out_octets': '31785381',
                                                                                       'out_ucast_pkts': '24424',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ=='},
                                                                               {       'in_errors': '2732',
                                                                                       'in_octets': '36429625',
                                                                                       'in_ucast_pkts': '357330',
                                                                                       'out_errors': '1693',
                                                                                       'out_octets': '1072188533',
                                                                                       'out_ucast_pkts': '728842',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ=='},
                                                                               {       'in_errors': '1720',
                                                                                       'in_octets': '11488847',
                                                                                       'in_ucast_pkts': '31393',
                                                                                       'out_errors': '5919',
                                                                                       'out_octets': '28611498',
                                                                                       'out_ucast_pkts': '36964',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ=='},
                                                                               {       'in_errors': '257',
                                                                                       'in_octets': '298796',
                                                                                       'in_ucast_pkts': '925',
                                                                                       'out_errors': '883',
                                                                                       'out_octets': '869642',
                                                                                       'out_ucast_pkts': '1745',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ=='},
                                                                               {       'in_errors': '330',
                                                                                       'in_octets': '1611582',
                                                                                       'in_ucast_pkts': '9743',
                                                                                       'out_errors': '53',
                                                                                       'out_octets': '17219865',
                                                                                       'out_ucast_pkts': '14332',
                                                                                       'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ=='},
                                                                               {       'in_errors': '2883',
                                                                                       'in_octets': '89672762',
                                                                                       'in_ucast_pkts': '150397',
                                                                                       'out_errors': '192',
                                                                                       'out_octets': '374855097',
                                                                                       'out_ucast_pkts': '355392',
                                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ=='},
                                                                               {       'in_errors': '1265',
                                                                                       'in_octets': '38420992',
                                                                                       'in_ucast_pkts': '30109',
                                                                                       'out_errors': '3880',
                                                                                       'out_octets': '2467804',
                                                                                       'out_ucast_pkts': '18016',
                                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ=='},
                                                                               {       'in_errors': '2002',
                                                                                       'in_octets': '15481902',
                                                                                       'in_ucast_pkts': '131894',
                                                                                       'out_errors': '48',
                                                                                       'out_octets': '1036690865',
                                                                                       'out_ucast_pkts': '806402',
                                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ=='},
                                                                               {       'in_errors': '694',
                                                                                       'in_octets': '1652848',
                                                                                       'in_ucast_pkts': '8657',
                                                                                       'out_errors': '876',
                                                                                       'out_octets': '6204877',
                                                                                       'out_ucast_pkts': '9096',
                                                                                       'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ=='},
                                                                               {       'in_errors': '555',
                                                                                       'in_octets': '185844',
                                                                                       'in_ucast_pkts': '798',
                                                                                       'out_errors': '373',
                                                                                       'out_octets': '107822',
                                                                                       'out_ucast_pkts': '841',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ=='},
                                                                               {       'in_errors': '1601',
                                                                                       'in_octets': '9515315',
                                                                                       'in_ucast_pkts': '96002',
                                                                                       'out_errors': '483',
                                                                                       'out_octets': '424097416',
                                                                                       'out_ucast_pkts': '286327',
                                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ=='},
                                                                               {       'in_errors': '7215',
                                                                                       'in_octets': '66236862',
                                                                                       'in_ucast_pkts': '574201',
                                                                                       'out_errors': '310',
                                                                                       'out_octets': '3016080596',
                                                                                       'out_ucast_pkts': '2049625',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ=='},
                                                                               {       'in_errors': '2972',
                                                                                       'in_octets': '22299259',
                                                                                       'in_ucast_pkts': '97141',
                                                                                       'out_errors': '12529',
                                                                                       'out_octets': '431378797',
                                                                                       'out_ucast_pkts': '321831',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ=='},
                                                                               {       'in_errors': '1217',
                                                                                       'in_octets': '550217',
                                                                                       'in_ucast_pkts': '1345',
                                                                                       'out_errors': '62',
                                                                                       'out_octets': '346570',
                                                                                       'out_ucast_pkts': '1421',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ=='},
                                                                               {       'in_errors': '1898',
                                                                                       'in_octets': '8655774',
                                                                                       'in_ucast_pkts': '54419',
                                                                                       'out_errors': '35',
                                                                                       'out_octets': '524935040',
                                                                                       'out_ucast_pkts': '355943',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ=='},
                                                                               {       'in_errors': '638',
                                                                                       'in_octets': '124453',
                                                                                       'in_ucast_pkts': '813',
                                                                                       'out_errors': '107',
                                                                                       'out_octets': '155873',
                                                                                       'out_ucast_pkts': '910',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ=='},
                                                                               {       'in_errors': '1574',
                                                                                       'in_octets': '8817989',
                                                                                       'in_ucast_pkts': '35494',
                                                                                       'out_errors': '3',
                                                                                       'out_octets': '27687737',
                                                                                       'out_ucast_pkts': '41808',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ=='},
                                                                               {       'in_errors': '162',
                                                                                       'in_octets': '413451',
                                                                                       'in_ucast_pkts': '1741',
                                                                                       'out_errors': '584',
                                                                                       'out_octets': '208376',
                                                                                       'out_ucast_pkts': '1212',
                                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ=='},
                                                                               {       'in_errors': '1235',
                                                                                       'in_octets': '26570030',
                                                                                       'in_ucast_pkts': '27389',
                                                                                       'out_errors': '1011',
                                                                                       'out_octets': '6980800',
                                                                                       'out_ucast_pkts': '26469',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ=='},
                                                                               {       'in_errors': '668',
                                                                                       'in_octets': '141116',
                                                                                       'in_ucast_pkts': '656',
                                                                                       'out_errors': '2047',
                                                                                       'out_octets': '146164',
                                                                                       'out_ucast_pkts': '753',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ=='},
                                                                               {       'in_errors': '343',
                                                                                       'in_octets': '105391',
                                                                                       'in_ucast_pkts': '347',
                                                                                       'out_errors': '144',
                                                                                       'out_octets': '55382',
                                                                                       'out_ucast_pkts': '503',
                                                                                       'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ=='},
                                                                               {       'in_errors': '3815',
                                                                                       'in_octets': '110921826',
                                                                                       'in_ucast_pkts': '304281',
                                                                                       'out_errors': '18057',
                                                                                       'out_octets': '591209439',
                                                                                       'out_ucast_pkts': '472664',
                                                                                       'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ=='},
                                                                               {       'in_errors': '197',
                                                                                       'in_octets': '696628',
                                                                                       'in_ucast_pkts': '1557',
                                                                                       'out_errors': '50',
                                                                                       'out_octets': '356500',
                                                                                       'out_ucast_pkts': '1417',
                                                                                       'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ=='},
                                                                               {       'in_errors': '1307',
                                                                                       'in_octets': '3536533',
                                                                                       'in_ucast_pkts': '17072',
                                                                                       'out_errors': '5006',
                                                                                       'out_octets': '101002947',
                                                                                       'out_ucast_pkts': '82562',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ=='},
                                                                               {       'in_errors': '470',
                                                                                       'in_octets': '823467',
                                                                                       'in_ucast_pkts': '3510',
                                                                                       'out_errors': '27',
                                                                                       'out_octets': '526597',
                                                                                       'out_ucast_pkts': '2789',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ=='},
                                                                               {       'in_errors': '1015',
                                                                                       'in_octets': '6623323',
                                                                                       'in_ucast_pkts': '33752',
                                                                                       'out_errors': '415',
                                                                                       'out_octets': '78672393',
                                                                                       'out_ucast_pkts': '61689',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                              'radios': [       {       'admin_up': True,
                                                                                        'azimuth': 27.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5755,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 41.12228,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1912',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '60296000',
                                                                                                                                            'snr': 24.429651,
                                                                                                                                            'tx_link_rate': '246441000'},
                                                                                                                                    {       'connected_time': '1902',
                                                                                                                                            'distance': 328,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64040000',
                                                                                                                                            'snr': 25.556261,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 368,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63734000',
                                                                                                                                            'snr': 25.464914,
                                                                                                                                            'tx_link_rate': '201389000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 415,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63628000',
                                                                                                                                            'snr': 25.433313,
                                                                                                                                            'tx_link_rate': '188028000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '267484000'},
                                                                                                                                    {       'connected_time': '1832',
                                                                                                                                            'distance': 107,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '55002000',
                                                                                                                                            'snr': 22.79587,
                                                                                                                                            'tx_link_rate': '202347000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 127,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 254,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63584000',
                                                                                                                                            'snr': 25.420189,
                                                                                                                                            'tx_link_rate': '226831000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 53,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 67,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 40,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63883000',
                                                                                                                                            'snr': 25.50954,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '45316000',
                                                                                                                                            'snr': 19.669588,
                                                                                                                                            'tx_link_rate': '119892000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '62608000',
                                                                                                                                            'snr': 25.12804,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 147,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 73,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '62595000',
                                                                                                                                            'snr': 25.12419,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 301,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64033000',
                                                                                                                                            'snr': 25.554161,
                                                                                                                                            'tx_link_rate': '288068000'},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 174,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '50067000',
                                                                                                                                            'snr': 21.227022,
                                                                                                                                            'tx_link_rate': '177711000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 46,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64006000',
                                                                                                                                            'snr': 25.546001,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '54116000',
                                                                                                                                            'snr': 22.517817,
                                                                                                                                            'tx_link_rate': '197098000'},
                                                                                                                                    {       'connected_time': '1712',
                                                                                                                                            'distance': 207,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1682',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63815000',
                                                                                                                                            'snr': 25.489061,
                                                                                                                                            'tx_link_rate': '230197000'},
                                                                                                                                    {       'connected_time': '1442',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1432',
                                                                                                                                            'distance': 435,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ==',
                                                                                                                                            'rssi': -69.5335,
                                                                                                                                            'rx_link_rate': '63959000',
                                                                                                                                            'snr': 25.532059,
                                                                                                                                            'tx_link_rate': '278531000'}]}],
                                                                                        'tx_power': 9},
                                                                                {       'admin_up': True,
                                                                                        'azimuth': 27.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5855,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 51.03394,
                                                                                        'rx_max_sensitivity_loss': 2.17,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1912',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '57616000',
                                                                                                                                            'snr': 23.608692,
                                                                                                                                            'tx_link_rate': '72275000'},
                                                                                                                                    {       'connected_time': '1902',
                                                                                                                                            'distance': 328,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '58862000',
                                                                                                                                            'snr': 23.991968,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 368,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '63607000',
                                                                                                                                            'snr': 25.427185,
                                                                                                                                            'tx_link_rate': '286505000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 415,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '63177000',
                                                                                                                                            'snr': 25.29855,
                                                                                                                                            'tx_link_rate': '286297000'},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '62926000',
                                                                                                                                            'snr': 25.22336,
                                                                                                                                            'tx_link_rate': '275866000'},
                                                                                                                                    {       'connected_time': '1832',
                                                                                                                                            'distance': 107,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '62650000',
                                                                                                                                            'snr': 25.140474,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '61575000',
                                                                                                                                            'snr': 24.817144,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '39694000',
                                                                                                                                            'snr': 17.76335,
                                                                                                                                            'tx_link_rate': '204898000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 127,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '61887000',
                                                                                                                                            'snr': 24.91127,
                                                                                                                                            'tx_link_rate': '288100000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 254,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '60750000',
                                                                                                                                            'snr': 24.567213,
                                                                                                                                            'tx_link_rate': '286223000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 53,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 67,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '63583000',
                                                                                                                                            'snr': 25.419802,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 40,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '60546000',
                                                                                                                                            'snr': 24.50557,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '40094000',
                                                                                                                                            'snr': 17.901466,
                                                                                                                                            'tx_link_rate': '142910000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 147,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '63037000',
                                                                                                                                            'snr': 25.256699,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 73,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64014000',
                                                                                                                                            'snr': 25.548462,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '62294000',
                                                                                                                                            'snr': 25.03362,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 301,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '63860000',
                                                                                                                                            'snr': 25.502533,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 174,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '62937000',
                                                                                                                                            'snr': 25.226616,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '34337000',
                                                                                                                                            'snr': 15.87362,
                                                                                                                                            'tx_link_rate': '192012000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 46,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '61410000',
                                                                                                                                            'snr': 24.767141,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '46853000',
                                                                                                                                            'snr': 20.179075,
                                                                                                                                            'tx_link_rate': '234025000'},
                                                                                                                                    {       'connected_time': '1712',
                                                                                                                                            'distance': 207,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64042000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '288193000'},
                                                                                                                                    {       'connected_time': '1682',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '59030000',
                                                                                                                                            'snr': 24.043396,
                                                                                                                                            'tx_link_rate': '278148000'},
                                                                                                                                    {       'connected_time': '1442',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64041000',
                                                                                                                                            'snr': 25.55668,
                                                                                                                                            'tx_link_rate': '287614000'},
                                                                                                                                    {       'connected_time': '1432',
                                                                                                                                            'distance': 435,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ==',
                                                                                                                                            'rssi': -68.34673,
                                                                                                                                            'rx_link_rate': '64041000',
                                                                                                                                            'snr': 25.556583,
                                                                                                                                            'tx_link_rate': '276162000'}]}],
                                                                                        'tx_power': 0},
                                                                                {       'admin_up': False,
                                                                                        'azimuth': 27.0,
                                                                                        'chan_width': 0,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 0,
                                                                                        'gps_sync': True,
                                                                                        'id': '2',
                                                                                        'oper_up': False,
                                                                                        'rx_max_interference_noise_ratio': -1.0,
                                                                                        'rx_max_sensitivity_loss': -99.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1912',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1902',
                                                                                                                                            'distance': 328,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 368,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 415,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1832',
                                                                                                                                            'distance': 107,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 127,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 254,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 53,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 67,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 40,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 147,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 73,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 301,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 174,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 46,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1712',
                                                                                                                                            'distance': 207,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1682',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1442',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1432',
                                                                                                                                            'distance': 435,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ==',
                                                                                                                                            'rssi': -99.0}]}],
                                                                                        'tx_power': -59},
                                                                                {       'admin_up': False,
                                                                                        'azimuth': 27.0,
                                                                                        'chan_width': 0,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 0,
                                                                                        'gps_sync': True,
                                                                                        'id': '3',
                                                                                        'oper_up': False,
                                                                                        'rx_max_interference_noise_ratio': -1.0,
                                                                                        'rx_max_sensitivity_loss': -99.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1912',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1902',
                                                                                                                                            'distance': 328,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 368,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 415,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1872',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1832',
                                                                                                                                            'distance': 107,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 127,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 254,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 53,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 67,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1822',
                                                                                                                                            'distance': 40,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 140,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 147,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 73,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1812',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 301,
                                                                                                                                            'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1802',
                                                                                                                                            'distance': 174,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 268,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 46,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1792',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1712',
                                                                                                                                            'distance': 207,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1682',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1442',
                                                                                                                                            'distance': 93,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ==',
                                                                                                                                            'rssi': -99.0},
                                                                                                                                    {       'connected_time': '1432',
                                                                                                                                            'distance': 435,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ==',
                                                                                                                                            'rssi': -99.0}]}],
                                                                                        'tx_power': -59}],
                                                              'rf_aggregation_groups': [       {       'airtime': 3.018466,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1',
                                                              'out_octets': '64',
                                                              'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyZ2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1',
                                                              'out_octets': '64',
                                                              'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '11309',
                                                              'in_octets': '9805504725',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '683',
                                                              'out_octets': '795916863',
                                                              'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyZXgx',
                                                              'speed': '10000000000'}],
                                'latitude': 38.953704833984375,
                                'longitude': -90.36178588867188,
                                'manufacturer': 'Tarana',
                                'mem': 17.0,
                                'model': '30-0196-001',
                                'name': 'JRSYILBAmultibandNE',
                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcy',
                                'serial_number': 'S196M2254000072',
                                'sw_version': '4.021.000.00',
                                'system_mac_address': '04:f1:7d:06:b0:e7',
                                'temperature': 40.5,
                                'uptime': '2214'},
                'peers': [       {       'cpu': 20.628931,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2019518284',
                                                                       'in_ucast_pkts': '1540809',
                                                                       'links': [       {       'in_octets': '2019518284',
                                                                                                'in_ucast_pkts': '1540809',
                                                                                                'out_octets': '102072737',
                                                                                                'out_ucast_pkts': '341237',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '102072737',
                                                                       'out_ucast_pkts': '341237',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMjc3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 208.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 12.918363,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 132.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1912',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -78.175644,
                                                                                                                                                     'rx_link_rate': '72275000',
                                                                                                                                                     'snr': 8.9808445,
                                                                                                                                                     'tx_link_rate': '57616000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 208.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 14.473311,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1912',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -84.78473,
                                                                                                                                                     'rx_link_rate': '246441000',
                                                                                                                                                     'snr': 22.721428,
                                                                                                                                                     'tx_link_rate': '60296000'}]}],
                                                                                                 'tx_power': 9},
                                                                                         {       'azimuth': 208.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1912',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 208.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1912',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.80544,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 41.212894,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:df:84:bb'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3462',
                                                                       'in_octets': '2298544334',
                                                                       'in_ucast_pkts': '3356851',
                                                                       'mac_address': '04:f1:7d:00:11:6c',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '11991825648',
                                                                       'out_ucast_pkts': '9731459',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMjc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.955875396728516,
                                         'longitude': -90.36021423339844,
                                         'manufacturer': 'Tarana',
                                         'mem': 25.0,
                                         'model': '30-0128-001',
                                         'name': 'Michelle_Thamas',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMjc3',
                                         'serial_number': 'S128F1212800277',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:11:6c',
                                         'temperature': 17.965,
                                         'uptime': '228707'},
                                 {       'cpu': 20.724094,
                                         'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '31785381',
                                                                       'in_ucast_pkts': '24424',
                                                                       'links': [       {       'in_octets': '31785381',
                                                                                                'in_ucast_pkts': '24424',
                                                                                                'out_octets': '2345240',
                                                                                                'out_ucast_pkts': '15477',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2345240',
                                                                       'out_ucast_pkts': '15477',
                                                                       'poller_hash': 'UzEyOEYxMjEyNDAwMDk4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 213.6,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 36.12026,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 118.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1902',
                                                                                                                                                     'distance': 328,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -73.219635,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '58862000'}]}],
                                                                                                 'tx_power': -62},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 213.6,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.490747,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 118.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1902',
                                                                                                                                                     'distance': 328,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -75.79166,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64040000'}]}],
                                                                                                 'tx_power': -62},
                                                                                         {       'azimuth': 213.6,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1902',
                                                                                                                                                     'distance': 328,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 213.6,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1902',
                                                                                                                                                     'distance': 328,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 28.019688,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 17.769571,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:5a:db:3a'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3534',
                                                                       'in_octets': '1470216465',
                                                                       'in_ucast_pkts': '8141059',
                                                                       'mac_address': '04:f1:7d:00:2d:03',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '33595995471',
                                                                       'out_ucast_pkts': '24611733',
                                                                       'poller_hash': 'UzEyOEYxMjEyNDAwMDk4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.95625305175781,
                                         'longitude': -90.35955047607422,
                                         'manufacturer': 'Tarana',
                                         'mem': 25.0,
                                         'model': '30-0128-001',
                                         'name': 'Norman_Brokaw',
                                         'poller_hash': 'UzEyOEYxMjEyNDAwMDk4',
                                         'serial_number': 'S128F1212400098',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2d:03',
                                         'temperature': 14.655,
                                         'uptime': '228700'},
                                 {       'cpu': 20.075283,
                                         'elevation': 9.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1072188533',
                                                                       'in_ucast_pkts': '728842',
                                                                       'links': [       {       'in_octets': '1072188533',
                                                                                                'in_ucast_pkts': '728842',
                                                                                                'out_octets': '36429625',
                                                                                                'out_ucast_pkts': '357330',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '36429625',
                                                                       'out_ucast_pkts': '357330',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMDU0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 40.07575,
                                                                                                 'rx_max_sensitivity_loss': 0.119999886,
                                                                                                 'rx_path_loss': 125.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 368,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -78.23528,
                                                                                                                                                     'rx_link_rate': '286505000',
                                                                                                                                                     'snr': 25.445137,
                                                                                                                                                     'tx_link_rate': '63607000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 17.1671,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 368,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -83.98826,
                                                                                                                                                     'rx_link_rate': '201389000',
                                                                                                                                                     'snr': 19.48152,
                                                                                                                                                     'tx_link_rate': '63734000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 368,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 368,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 28.274038,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 25.28987,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a0:04:60:69:44:9e'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2342',
                                                                       'in_octets': '3557897115',
                                                                       'in_ucast_pkts': '18152665',
                                                                       'mac_address': '04:f1:7d:00:2b:a6',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '45477499210',
                                                                       'out_ucast_pkts': '33886551',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 25.0,
                                         'model': '30-0128-001',
                                         'name': 'Obhiambo',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMDU0',
                                         'serial_number': 'S128F1212500054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2b:a6',
                                         'temperature': 16.339,
                                         'uptime': '228705'},
                                 {       'cpu': 21.105528,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '28611498',
                                                                       'in_ucast_pkts': '36964',
                                                                       'links': [       {       'in_octets': '28611498',
                                                                                                'in_ucast_pkts': '36964',
                                                                                                'out_octets': '11488847',
                                                                                                'out_ucast_pkts': '31393',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11488847',
                                                                       'out_ucast_pkts': '31393',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI1MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 39.206905,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 415,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -79.061134,
                                                                                                                                                     'rx_link_rate': '286297000',
                                                                                                                                                     'snr': 25.431337,
                                                                                                                                                     'tx_link_rate': '63177000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 20.901747,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 121.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 415,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -78.43026,
                                                                                                                                                     'rx_link_rate': '188028000',
                                                                                                                                                     'snr': 18.480719,
                                                                                                                                                     'tx_link_rate': '63628000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 415,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 415,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.43285,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 15.250566,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:f5:cd:15'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3592',
                                                                       'in_octets': '2275752545',
                                                                       'in_ucast_pkts': '14375570',
                                                                       'mac_address': '04:f1:7d:00:27:04',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '40609856789',
                                                                       'out_ucast_pkts': '30261782',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Clayton_Bowers',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMjI1',
                                         'serial_number': 'S128F1211400225',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:27:04',
                                         'temperature': 15.236,
                                         'uptime': '228697'},
                                 {       'cpu': 20.100502,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '869642',
                                                                       'in_ucast_pkts': '1745',
                                                                       'links': [       {       'in_octets': '869642',
                                                                                                'in_ucast_pkts': '1745',
                                                                                                'out_octets': '298796',
                                                                                                'out_ucast_pkts': '925',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '298796',
                                                                       'out_ucast_pkts': '925',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDM0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.275043,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 128.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 247,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -81.83138,
                                                                                                                                                     'rx_link_rate': '267484000',
                                                                                                                                                     'snr': 24.168556,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 12.725659,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 247,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -84.68215,
                                                                                                                                                     'rx_link_rate': '275866000',
                                                                                                                                                     'snr': 24.734863,
                                                                                                                                                     'tx_link_rate': '62926000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 247,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1872',
                                                                                                                                                     'distance': 247,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.122389,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 1.6555904,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e4:6c:d1:da:9d:cd'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3496',
                                                                       'in_octets': '3362620375',
                                                                       'in_ucast_pkts': '8410016',
                                                                       'mac_address': '04:f1:7d:00:28:d0',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '51726654864',
                                                                       'out_ucast_pkts': '38424879',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDM0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.95564270019531,
                                         'longitude': -90.36063385009766,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Blake_Higdon',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMDM0',
                                         'serial_number': 'S128F1211600034',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:28:d0',
                                         'temperature': 20.81,
                                         'uptime': '228699'},
                                 {       'cpu': 22.18045,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '17219865',
                                                                       'in_ucast_pkts': '14332',
                                                                       'links': [       {       'in_octets': '17219865',
                                                                                                'in_ucast_pkts': '14332',
                                                                                                'out_octets': '1611582',
                                                                                                'out_ucast_pkts': '9743',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1611582',
                                                                       'out_ucast_pkts': '9743',
                                                                       'poller_hash': 'UzE1MEYyMjIyOTA2NTcwMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 200.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 38.570557,
                                                                                                 'rx_max_sensitivity_loss': 10.1,
                                                                                                 'rx_path_loss': 95.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1832',
                                                                                                                                                     'distance': 107,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -50.54113,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -79},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 200.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 14.841851,
                                                                                                 'rx_max_sensitivity_loss': 6.92,
                                                                                                 'rx_path_loss': 97.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1832',
                                                                                                                                                     'distance': 107,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -57.593452,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '62650000'}]}],
                                                                                                 'tx_power': -79},
                                                                                         {       'azimuth': 200.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1832',
                                                                                                                                                     'distance': 107,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 200.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1832',
                                                                                                                                                     'distance': 107,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.36036,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 5.2125163,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:14:4d:94'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3599',
                                                                       'in_octets': '543941815',
                                                                       'in_ucast_pkts': '2562123',
                                                                       'mac_address': '04:f1:7d:00:b7:2c',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '8440423222',
                                                                       'out_ucast_pkts': '6839302',
                                                                       'poller_hash': 'UzE1MEYyMjIyOTA2NTcwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.95473098754883,
                                         'longitude': -90.36132049560547,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Bruce_Jackson_64949',
                                         'poller_hash': 'UzE1MEYyMjIyOTA2NTcw',
                                         'serial_number': 'S150F2222906570',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:b7:2c',
                                         'temperature': 15.991,
                                         'uptime': '228719'},
                                 {       'cpu': 18.91551,
                                         'elevation': 1.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '374855097',
                                                                       'in_ucast_pkts': '355392',
                                                                       'links': [       {       'in_octets': '374855097',
                                                                                                'in_ucast_pkts': '355392',
                                                                                                'out_octets': '89672762',
                                                                                                'out_ucast_pkts': '150397',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '89672762',
                                                                       'out_ucast_pkts': '150397',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyODg3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 23.406454,
                                                                                                 'rx_max_sensitivity_loss': 5.08,
                                                                                                 'rx_path_loss': 106.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -57.34713,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -11},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 8.344347,
                                                                                                 'rx_max_sensitivity_loss': 3.1,
                                                                                                 'rx_path_loss': 107.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -64.70012,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '61575000'}]}],
                                                                                                 'tx_power': -71},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.926603,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 9.344254,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:5a:de:26'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3467',
                                                                       'in_octets': '6786436276',
                                                                       'in_ucast_pkts': '16544860',
                                                                       'mac_address': '04:f1:7d:00:6c:e3',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '50655512414',
                                                                       'out_ucast_pkts': '44118386',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyODg3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Ashlynn_Ostrowski',
                                         'poller_hash': 'UzEyOEYyMjIxNTAyODg3',
                                         'serial_number': 'S128F2221502887',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:6c:e3',
                                         'temperature': 18.836,
                                         'uptime': '228671'},
                                 {       'cpu': 20.349564,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2467804',
                                                                       'in_ucast_pkts': '18016',
                                                                       'links': [       {       'in_octets': '2467804',
                                                                                                'in_ucast_pkts': '18016',
                                                                                                'out_octets': '38420992',
                                                                                                'out_ucast_pkts': '30109',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '38420992',
                                                                       'out_ucast_pkts': '30109',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 13.028857,
                                                                                                 'rx_max_sensitivity_loss': 0.119999886,
                                                                                                 'rx_path_loss': 131.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -71.97707,
                                                                                                                                                     'rx_link_rate': '202347000',
                                                                                                                                                     'snr': 19.552757,
                                                                                                                                                     'tx_link_rate': '55002000'}]}],
                                                                                                 'tx_power': 15},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 6.1911435,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -82.35607,
                                                                                                                                                     'rx_link_rate': '204898000',
                                                                                                                                                     'snr': 19.742065,
                                                                                                                                                     'tx_link_rate': '39694000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 28.181814,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 8.162591,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '3c:37:86:fb:ef:f0'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6575',
                                                                       'in_octets': '182951056',
                                                                       'in_ucast_pkts': '423880',
                                                                       'mac_address': '04:f1:7d:00:ba:08',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '475295354',
                                                                       'out_ucast_pkts': '558905',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Richard_Forcick',
                                         'poller_hash': 'UzE1MEYyMjIzMTAxNjk0',
                                         'serial_number': 'S150F2223101694',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:ba:08',
                                         'temperature': 20.287,
                                         'uptime': '228679'},
                                 {       'cpu': 19.245283,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1036690865',
                                                                       'in_ucast_pkts': '806402',
                                                                       'links': [       {       'in_octets': '1036690865',
                                                                                                'in_ucast_pkts': '806402',
                                                                                                'out_octets': '15481902',
                                                                                                'out_ucast_pkts': '131894',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15481902',
                                                                       'out_ucast_pkts': '131894',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk1MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.996006,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 101.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 127,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -56.214466,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -5},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 14.855241,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 103.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 127,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -62.80061,
                                                                                                                                                     'rx_link_rate': '288100000',
                                                                                                                                                     'snr': 25.550833,
                                                                                                                                                     'tx_link_rate': '61887000'}]}],
                                                                                                 'tx_power': -74},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 127,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 127,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 24.005154,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -5.569196,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:94:dd:3a'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3317',
                                                                       'in_octets': '536435606',
                                                                       'in_ucast_pkts': '3918924',
                                                                       'mac_address': '04:f1:7d:00:ba:8b',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '31622464108',
                                                                       'out_ucast_pkts': '25097179',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAxNjk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Cy_Buntins',
                                         'poller_hash': 'UzE1MEYyMjIzMTAxNjk1',
                                         'serial_number': 'S150F2223101695',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:ba:8b',
                                         'temperature': 16.629,
                                         'uptime': '228686'},
                                 {       'cpu': 22.333752,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '6204877',
                                                                       'in_ucast_pkts': '9096',
                                                                       'links': [       {       'in_octets': '6204877',
                                                                                                'in_ucast_pkts': '9096',
                                                                                                'out_octets': '1652848',
                                                                                                'out_ucast_pkts': '8657',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1652848',
                                                                       'out_ucast_pkts': '8657',
                                                                       'poller_hash': 'UzE1MEYyMjIzNzMxNjI1MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 193.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.341856,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 128.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 254,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -81.987,
                                                                                                                                                     'rx_link_rate': '226831000',
                                                                                                                                                     'snr': 21.335999,
                                                                                                                                                     'tx_link_rate': '63584000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 193.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 10.420329,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 254,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -83.41129,
                                                                                                                                                     'rx_link_rate': '286223000',
                                                                                                                                                     'snr': 25.42644,
                                                                                                                                                     'tx_link_rate': '60750000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'azimuth': 193.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 254,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 193.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 254,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.608664,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 0.6922813,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:21:03:a3:71:76'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3416',
                                                                       'in_octets': '1361998008',
                                                                       'in_ucast_pkts': '7422048',
                                                                       'mac_address': '04:f1:7d:00:de:6c',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '28373599484',
                                                                       'out_ucast_pkts': '20964174',
                                                                       'poller_hash': 'UzE1MEYyMjIzNzMxNjI1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.955848693847656,
                                         'longitude': -90.3599624633789,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Cindy_Hall',
                                         'poller_hash': 'UzE1MEYyMjIzNzMxNjI1',
                                         'serial_number': 'S150F2223731625',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:de:6c',
                                         'temperature': 19.242,
                                         'uptime': '228668'},
                                 {       'cpu': 21.276596,
                                         'elevation': 1.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '107822',
                                                                       'in_ucast_pkts': '841',
                                                                       'links': [       {       'in_octets': '107822',
                                                                                                'in_ucast_pkts': '841',
                                                                                                'out_octets': '185844',
                                                                                                'out_ucast_pkts': '798',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '185844',
                                                                       'out_ucast_pkts': '798',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDIwMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.366522,
                                                                                                 'rx_max_sensitivity_loss': 5.08,
                                                                                                 'rx_path_loss': 105.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -56.054554,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -74},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.880358,
                                                                                                 'rx_max_sensitivity_loss': 3.1,
                                                                                                 'rx_path_loss': 109.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -64.44863,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -74},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 28.075687,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 1.8425287,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:99:ec:67'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3239',
                                                                       'in_octets': '15285557',
                                                                       'in_ucast_pkts': '65062',
                                                                       'mac_address': '04:f1:7d:00:28:c0',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9612283',
                                                                       'out_ucast_pkts': '83050',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDIwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Deborah_Snith',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMDIw',
                                         'serial_number': 'S128F1211600020',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:28:c0',
                                         'temperature': 15.352,
                                         'uptime': '228685'},
                                 {       'cpu': 21.972534,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '424097416',
                                                                       'in_ucast_pkts': '286327',
                                                                       'links': [       {       'in_octets': '424097416',
                                                                                                'in_ucast_pkts': '286327',
                                                                                                'out_octets': '9515315',
                                                                                                'out_ucast_pkts': '96002',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9515315',
                                                                       'out_ucast_pkts': '96002',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyOTU2MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.23825,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 108.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 67,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -59.438286,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -71},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 18.4394,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 109.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 67,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -67.46187,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '63583000'}]}],
                                                                                                 'tx_power': -71},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 67,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 67,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 25.724216,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 3.3809943,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:a6:5a:db'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3586',
                                                                       'in_octets': '1299382038',
                                                                       'in_ucast_pkts': '9637369',
                                                                       'mac_address': '04:f1:7d:00:6d:10',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '34491327175',
                                                                       'out_ucast_pkts': '23788864',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyOTU2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Sally_Menlce',
                                         'poller_hash': 'UzEyOEYyMjIxNTAyOTU2',
                                         'serial_number': 'S128F2221502956',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:6d:10',
                                         'temperature': 16.513,
                                         'uptime': '228686'},
                                 {       'cpu': 20.176544,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '3016080596',
                                                                       'in_ucast_pkts': '2049625',
                                                                       'links': [       {       'in_octets': '3016080596',
                                                                                                'in_ucast_pkts': '2049625',
                                                                                                'out_octets': '66236862',
                                                                                                'out_ucast_pkts': '574201',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '66236862',
                                                                       'out_ucast_pkts': '574201',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMzA2MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 22.454584,
                                                                                                 'rx_max_sensitivity_loss': 10.22,
                                                                                                 'rx_path_loss': 98.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 40,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -54.936073,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '63883000'}]}],
                                                                                                 'tx_power': -17},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.228012,
                                                                                                 'rx_max_sensitivity_loss': 5.08,
                                                                                                 'rx_path_loss': 99.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 40,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -59.002113,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '60546000'}]}],
                                                                                                 'tx_power': -80},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 40,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1822',
                                                                                                                                                     'distance': 40,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.574398,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 3.720201,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '4c:01:43:5b:af:10'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8886',
                                                                       'in_octets': '3542207176',
                                                                       'in_ucast_pkts': '12164458',
                                                                       'mac_address': '04:f1:7d:00:25:9f',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '54725316952',
                                                                       'out_ucast_pkts': '39093902',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMzA2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Dancan_Chartars',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMzA2',
                                         'serial_number': 'S128F1211600306',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:25:9f',
                                         'temperature': 17.732,
                                         'uptime': '228677'},
                                 {       'cpu': 23.74372,
                                         'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '431378797',
                                                                       'in_ucast_pkts': '321831',
                                                                       'links': [       {       'in_octets': '431378797',
                                                                                                'in_ucast_pkts': '321831',
                                                                                                'out_octets': '22299259',
                                                                                                'out_ucast_pkts': '97141',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '22299259',
                                                                       'out_ucast_pkts': '97141',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMjM4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.627483,
                                                                                                 'rx_max_sensitivity_loss': 0.42000008,
                                                                                                 'rx_path_loss': 137.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -77.94845,
                                                                                                                                                     'rx_link_rate': '119892000',
                                                                                                                                                     'snr': 13.01516,
                                                                                                                                                     'tx_link_rate': '45316000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.89437,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -86.04295,
                                                                                                                                                     'rx_link_rate': '142910000',
                                                                                                                                                     'snr': 14.9352865,
                                                                                                                                                     'tx_link_rate': '40094000'}]}],
                                                                                                 'tx_power': 16},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.947582,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 11.61179,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:5a:e3:a6'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3546',
                                                                       'in_octets': '3125262919',
                                                                       'in_ucast_pkts': '21195715',
                                                                       'mac_address': '04:f1:7d:00:27:b1',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70986980806',
                                                                       'out_ucast_pkts': '50112792',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMjM4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Blair_Smith',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMjM4',
                                         'serial_number': 'S128F1211600238',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:27:b1',
                                         'temperature': 19.765,
                                         'uptime': '228688'},
                                 {       'cpu': 20.024876,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '346570',
                                                                       'in_ucast_pkts': '1421',
                                                                       'links': [       {       'in_octets': '346570',
                                                                                                'in_ucast_pkts': '1421',
                                                                                                'out_octets': '550217',
                                                                                                'out_ucast_pkts': '1345',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '550217',
                                                                       'out_ucast_pkts': '1345',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjcwMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 22.825624,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 112.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -66.57133,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '62608000'}]}],
                                                                                                 'tx_power': -66},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.106052,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 111.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -68.308334,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -66},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 140,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.546911,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 9.9638405,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:14:8d:9a'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3393',
                                                                       'in_octets': '45708681',
                                                                       'in_ucast_pkts': '140652',
                                                                       'mac_address': '04:f1:7d:00:2d:88',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '130638219',
                                                                       'out_ucast_pkts': '202893',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjcwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Deborah_Smith',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMjcw',
                                         'serial_number': 'S128F1212500270',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2d:88',
                                         'temperature': 20.113,
                                         'uptime': '228696'},
                                 {       'cpu': 20.125,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '524935040',
                                                                       'in_ucast_pkts': '355943',
                                                                       'links': [       {       'in_octets': '524935040',
                                                                                                'in_ucast_pkts': '355943',
                                                                                                'out_octets': '8655774',
                                                                                                'out_ucast_pkts': '54419',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8655774',
                                                                       'out_ucast_pkts': '54419',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjE4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 18.96052,
                                                                                                 'rx_max_sensitivity_loss': 0.42000008,
                                                                                                 'rx_path_loss': 119.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 147,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -70.72377,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': 1},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 15.74299,
                                                                                                 'rx_max_sensitivity_loss': 0.119999886,
                                                                                                 'rx_path_loss': 121.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 147,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -80.50147,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '63037000'}]}],
                                                                                                 'tx_power': -62},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 147,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 147,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.851604,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 7.2784357,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:bc:9f:60:0f:3f'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3543',
                                                                       'in_octets': '967353630',
                                                                       'in_ucast_pkts': '5687375',
                                                                       'mac_address': '04:f1:7d:00:2d:7d',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '31490567619',
                                                                       'out_ucast_pkts': '22880548',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Mary_Baird',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMjE4',
                                         'serial_number': 'S128F1212500218',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2d:7d',
                                         'temperature': 17.558,
                                         'uptime': '228679'},
                                 {       'cpu': 19.546028,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '155873',
                                                                       'in_ucast_pkts': '910',
                                                                       'links': [       {       'in_octets': '155873',
                                                                                                'in_ucast_pkts': '910',
                                                                                                'out_octets': '124453',
                                                                                                'out_ucast_pkts': '813',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '124453',
                                                                       'out_ucast_pkts': '813',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTc0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 9.800968,
                                                                                                 'rx_max_sensitivity_loss': 3.1,
                                                                                                 'rx_path_loss': 108.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 73,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -61.47214,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '62595000'}]}],
                                                                                                 'tx_power': -68},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.379768,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 109.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 73,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -66.75746,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64014000'}]}],
                                                                                                 'tx_power': -68},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 73,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 73,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 24.959284,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 3.7971356,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '34:98:b5:74:c8:46'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1011',
                                                                       'in_octets': '390289675',
                                                                       'in_ucast_pkts': '1397278',
                                                                       'mac_address': '04:f1:7d:00:29:31',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2876154648',
                                                                       'out_ucast_pkts': '2869716',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTc0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Doerr',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMTc0',
                                         'serial_number': 'S128F1211600174',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:29:31',
                                         'temperature': 16.165,
                                         'uptime': '228680'},
                                 {       'cpu': 19.82434,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '27687737',
                                                                       'in_ucast_pkts': '41808',
                                                                       'links': [       {       'in_octets': '27687737',
                                                                                                'in_ucast_pkts': '41808',
                                                                                                'out_octets': '8817989',
                                                                                                'out_ucast_pkts': '35494',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8817989',
                                                                       'out_ucast_pkts': '35494',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTUyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.888334,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 111.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -62.372623,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -65},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.742022,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 111.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -69.639915,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '62294000'}]}],
                                                                                                 'tx_power': -65},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1812',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.948826,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -6.527019,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:42:1a:56:31:58'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1542',
                                                                       'in_octets': '3736859424',
                                                                       'in_ucast_pkts': '25409433',
                                                                       'mac_address': '04:f1:7d:00:2e:4f',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '99954174266',
                                                                       'out_ucast_pkts': '70788295',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTUyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'stahaine_Tram',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwNTUy',
                                         'serial_number': 'S128F1212500552',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2e:4f',
                                         'temperature': 15.642,
                                         'uptime': '228691'},
                                 {       'cpu': 22.971287,
                                         'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '208376',
                                                                       'in_ucast_pkts': '1212',
                                                                       'links': [       {       'in_octets': '208376',
                                                                                                'in_ucast_pkts': '1212',
                                                                                                'out_octets': '413451',
                                                                                                'out_ucast_pkts': '1741',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '413451',
                                                                       'out_ucast_pkts': '1741',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyNzY3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.498722,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 123.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 301,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -74.79888,
                                                                                                                                                     'rx_link_rate': '288068000',
                                                                                                                                                     'snr': 25.548752,
                                                                                                                                                     'tx_link_rate': '64033000'}]}],
                                                                                                 'tx_power': -62},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.774214,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 119.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 301,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -77.087,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '63860000'}]}],
                                                                                                 'tx_power': -62},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 301,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 301,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.122389,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 7.488028,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:18:ad:15'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3488',
                                                                       'in_octets': '5068164598',
                                                                       'in_ucast_pkts': '4318266',
                                                                       'mac_address': '04:f1:7d:00:6a:96',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2789178582',
                                                                       'out_ucast_pkts': '4377316',
                                                                       'poller_hash': 'UzEyOEYyMjIxNTAyNzY3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Pitch_Furcl',
                                         'poller_hash': 'UzEyOEYyMjIxNTAyNzY3',
                                         'serial_number': 'S128F2221502767',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:6a:96',
                                         'temperature': 17.732,
                                         'uptime': '228689'},
                                 {       'cpu': 21.536524,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '6980800',
                                                                       'in_ucast_pkts': '26469',
                                                                       'links': [       {       'in_octets': '6980800',
                                                                                                'in_ucast_pkts': '26469',
                                                                                                'out_octets': '26570030',
                                                                                                'out_ucast_pkts': '27389',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '26570030',
                                                                       'out_ucast_pkts': '27389',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTA0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 87.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 40.908886,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 121.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 174,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -72.51654,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 87.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.657438,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 122.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 174,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -80.961136,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '62937000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'azimuth': 87.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 174,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 87.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1802',
                                                                                                                                                     'distance': 174,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.164824,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 12.846862,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:6c:ef:8c'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3547',
                                                                       'in_octets': '2250666406',
                                                                       'in_ucast_pkts': '5239254',
                                                                       'mac_address': '04:f1:7d:00:2f:5f',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '21419661915',
                                                                       'out_ucast_pkts': '16367736',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTA0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.95466613769531,
                                         'longitude': -90.3637466430664,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Hahn_Timothy_76172',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTA0',
                                         'serial_number': 'S128F1212800104',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:2f:5f',
                                         'temperature': 21.274,
                                         'uptime': '228688'},
                                 {       'cpu': 23.173803,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '146164',
                                                                       'in_ucast_pkts': '753',
                                                                       'links': [       {       'in_octets': '146164',
                                                                                                'in_ucast_pkts': '753',
                                                                                                'out_octets': '141116',
                                                                                                'out_ucast_pkts': '656',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '141116',
                                                                       'out_ucast_pkts': '656',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTIzMDEyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 45.636852,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 130.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -78.543304,
                                                                                                                                                     'rx_link_rate': '177711000',
                                                                                                                                                     'snr': 17.693035,
                                                                                                                                                     'tx_link_rate': '50067000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.355207,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -87.006355,
                                                                                                                                                     'rx_link_rate': '192012000',
                                                                                                                                                     'snr': 18.781534,
                                                                                                                                                     'tx_link_rate': '34337000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 268,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 25.622389,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 20.234219,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:73:4f:07'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3376',
                                                                       'in_octets': '11975771',
                                                                       'in_ucast_pkts': '57017',
                                                                       'mac_address': '04:f1:7d:01:09:84',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '20917225',
                                                                       'out_ucast_pkts': '82065',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTIzMDEyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Leai_Ute',
                                         'poller_hash': 'UzE1MEYyMjI0MTIzMDEy',
                                         'serial_number': 'S150F2224123012',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:01:09:84',
                                         'temperature': 19.939,
                                         'uptime': '228688'},
                                 {       'cpu': 18.781727,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '55382',
                                                                       'in_ucast_pkts': '503',
                                                                       'links': [       {       'in_octets': '55382',
                                                                                                'in_ucast_pkts': '503',
                                                                                                'out_octets': '105391',
                                                                                                'out_ucast_pkts': '347',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '105391',
                                                                       'out_ucast_pkts': '347',
                                                                       'poller_hash': 'UzE1MEYyMjIyOTA0MDI5MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 26.670073,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 102.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 46,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -60.992153,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64006000'}]}],
                                                                                                 'tx_power': -74},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 44.71496,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 105.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 46,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -60.316257,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '61410000'}]}],
                                                                                                 'tx_power': -74},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 46,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 46,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.122389,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 15.515414,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b8:94:70:92:40:53'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2791',
                                                                       'in_octets': '9808339',
                                                                       'in_ucast_pkts': '21055',
                                                                       'mac_address': '04:f1:7d:00:b6:29',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4179650',
                                                                       'out_ucast_pkts': '44310',
                                                                       'poller_hash': 'UzE1MEYyMjIyOTA0MDI5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Deborah_Snith',
                                         'poller_hash': 'UzE1MEYyMjIyOTA0MDI5',
                                         'serial_number': 'S150F2222904029',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:b6:29',
                                         'temperature': 17.152,
                                         'uptime': '228699'},
                                 {       'cpu': 19.19192,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '591209439',
                                                                       'in_ucast_pkts': '472664',
                                                                       'links': [       {       'in_octets': '591209439',
                                                                                                'in_ucast_pkts': '472664',
                                                                                                'out_octets': '110921826',
                                                                                                'out_ucast_pkts': '304281',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '110921826',
                                                                       'out_ucast_pkts': '304281',
                                                                       'poller_hash': 'UzE1MEYyMjMwMjE1NTMyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 26.5,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 33.51259,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -77.804184,
                                                                                                                                                     'rx_link_rate': '197098000',
                                                                                                                                                     'snr': 19.16287,
                                                                                                                                                     'tx_link_rate': '54116000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 26.5,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 33.28156,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -80.94521,
                                                                                                                                                     'rx_link_rate': '234025000',
                                                                                                                                                     'snr': 21.848175,
                                                                                                                                                     'tx_link_rate': '46853000'}]}],
                                                                                                 'tx_power': -56},
                                                                                         {       'azimuth': 26.5,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 26.5,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1792',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 27.153612,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 9.059454,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:db:98:56:57:5d'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '16',
                                                                       'in_nucast_pkts': '3709',
                                                                       'in_octets': '6623184932',
                                                                       'in_ucast_pkts': '33679356',
                                                                       'mac_address': '04:f1:7d:01:86:f6',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '101300739242',
                                                                       'out_ucast_pkts': '75248728',
                                                                       'poller_hash': 'UzE1MEYyMjMwMjE1NTMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.95290756225586,
                                         'longitude': -90.36222839355469,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Michael_Chakur',
                                         'poller_hash': 'UzE1MEYyMjMwMjE1NTMy',
                                         'serial_number': 'S150F2230215532',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:01:86:f6',
                                         'temperature': 18.255,
                                         'uptime': '228709'},
                                 {       'cpu': 19.472363,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '356500',
                                                                       'in_ucast_pkts': '1417',
                                                                       'links': [       {       'in_octets': '356500',
                                                                                                'in_ucast_pkts': '1417',
                                                                                                'out_octets': '696628',
                                                                                                'out_ucast_pkts': '1557',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '696628',
                                                                       'out_ucast_pkts': '1557',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAwMjYyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 198.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': -1.0,
                                                                                                 'rx_max_sensitivity_loss': 0.119999886,
                                                                                                 'rx_path_loss': 110.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1712',
                                                                                                                                                     'distance': 207,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -67.07124,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -64},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 198.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': -1.0,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 113.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1712',
                                                                                                                                                     'distance': 207,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -73.90974,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -64},
                                                                                         {       'azimuth': 198.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1712',
                                                                                                                                                     'distance': 207,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 198.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1712',
                                                                                                                                                     'distance': 207,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.122389,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 0.795047,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '84:d3:43:b5:1a:37'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3410',
                                                                       'in_octets': '340924613',
                                                                       'in_ucast_pkts': '985136',
                                                                       'mac_address': '04:f1:7d:00:bb:1c',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1344154944',
                                                                       'out_ucast_pkts': '1305322',
                                                                       'poller_hash': 'UzE1MEYyMjIzMTAwMjYyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.955589294433594,
                                         'longitude': -90.36103057861328,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'miller_Mich',
                                         'poller_hash': 'UzE1MEYyMjIzMTAwMjYy',
                                         'serial_number': 'S150F2223100262',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:bb:1c',
                                         'temperature': 17.094,
                                         'uptime': '228700'},
                                 {       'cpu': 20.275345,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '101002947',
                                                                       'in_ucast_pkts': '82562',
                                                                       'links': [       {       'in_octets': '101002947',
                                                                                                'in_ucast_pkts': '82562',
                                                                                                'out_octets': '3536533',
                                                                                                'out_ucast_pkts': '17072',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3536533',
                                                                       'out_ucast_pkts': '17072',
                                                                       'poller_hash': 'UzE1MEYyMjI0MjA1MTAzMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 42.498714,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 123.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1682',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -71.57059,
                                                                                                                                                     'rx_link_rate': '230197000',
                                                                                                                                                     'snr': 21.576706,
                                                                                                                                                     'tx_link_rate': '63815000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 36.903824,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 125.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1682',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -76.89085,
                                                                                                                                                     'rx_link_rate': '278148000',
                                                                                                                                                     'snr': 24.887772,
                                                                                                                                                     'tx_link_rate': '59030000'}]}],
                                                                                                 'tx_power': 9},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1682',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1682',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 34.35632,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 23.951456,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:42:dc:ee'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3568',
                                                                       'in_octets': '2634072703',
                                                                       'in_ucast_pkts': '8180582',
                                                                       'mac_address': '04:f1:7d:01:13:a4',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '26912527874',
                                                                       'out_ucast_pkts': '20508662',
                                                                       'poller_hash': 'UzE1MEYyMjI0MjA1MTAzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0150-001',
                                         'name': 'Gster_Sontag',
                                         'poller_hash': 'UzE1MEYyMjI0MjA1MTAz',
                                         'serial_number': 'S150F2224205103',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:01:13:a4',
                                         'temperature': 17.384,
                                         'uptime': '228698'},
                                 {       'cpu': 24.655819,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '526597',
                                                                       'in_ucast_pkts': '2789',
                                                                       'links': [       {       'in_octets': '526597',
                                                                                                'in_ucast_pkts': '2789',
                                                                                                'out_octets': '823467',
                                                                                                'out_ucast_pkts': '3510',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '823467',
                                                                       'out_ucast_pkts': '3510',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDcxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 13.7305355,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 125.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1442',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -75.95427,
                                                                                                                                                     'rx_link_rate': '288193000',
                                                                                                                                                     'snr': 25.556976,
                                                                                                                                                     'tx_link_rate': '64042000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.513485,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1442',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -80.57855,
                                                                                                                                                     'rx_link_rate': '287614000',
                                                                                                                                                     'snr': 25.518625,
                                                                                                                                                     'tx_link_rate': '64041000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1442',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1442',
                                                                                                                                                     'distance': 93,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.73044,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 2.722765,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd0:76:8f:03:5e:2b'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3670',
                                                                       'in_octets': '116583156',
                                                                       'in_ucast_pkts': '903103',
                                                                       'mac_address': '04:f1:7d:00:28:0d',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '997119311',
                                                                       'out_ucast_pkts': '948976',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Chuck_Wallis',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMDcx',
                                         'serial_number': 'S128F1211400071',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:28:0d',
                                         'temperature': 16.571,
                                         'uptime': '228696'},
                                 {       'cpu': 24.438902,
                                         'elevation': 13.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '78672393',
                                                                       'in_ucast_pkts': '61689',
                                                                       'links': [       {       'in_octets': '78672393',
                                                                                                'in_ucast_pkts': '61689',
                                                                                                'out_octets': '6623323',
                                                                                                'out_ucast_pkts': '33752',
                                                                                                'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6623323',
                                                                       'out_ucast_pkts': '33752',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 209.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 34.782322,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 129.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1432',
                                                                                                                                                     'distance': 435,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -82.98723,
                                                                                                                                                     'rx_link_rate': '276162000',
                                                                                                                                                     'snr': 24.754765,
                                                                                                                                                     'tx_link_rate': '64041000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 209.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5855,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 14.57064,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1432',
                                                                                                                                                     'distance': 435,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx',
                                                                                                                                                     'rssi': -84.70746,
                                                                                                                                                     'rx_link_rate': '278531000',
                                                                                                                                                     'snr': 24.91364,
                                                                                                                                                     'tx_link_rate': '63959000'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'azimuth': 209.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '2',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1432',
                                                                                                                                                     'distance': 435,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]},
                                                                                         {       'azimuth': 209.0,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'id': '3',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1432',
                                                                                                                                                     'distance': 435,
                                                                                                                                                     'poller_hash': 'UzE5Nk0yMjU0MDAwMDcyd2wx'}]}]}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.785444,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 21.133179,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:85:f9:8d:27:7d'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4940',
                                                                       'in_octets': '3529832975',
                                                                       'in_ucast_pkts': '21014101',
                                                                       'mac_address': '04:f1:7d:00:26:f7',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '72525313160',
                                                                       'out_ucast_pkts': '55402756',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMjI4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.957252502441406,
                                         'longitude': -90.35921478271484,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0128-001',
                                         'name': 'Vandermark_Gijsbertus_56990',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMjI4',
                                         'serial_number': 'S128F1211400228',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.021.000.00',
                                         'system_mac_address': '04:f1:7d:00:26:f7',
                                         'temperature': 20.403,
                                         'uptime': '228707'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_977_016_00_10_135_132_131(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.977.016.00.10_135_132_131")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 14,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300003',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S128F1211400031': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 111545078110,
                                           'dl_rf_packets': 81291434,
                                           'ip_address': None,
                                           'name': 'Kieyah_Fyffe',
                                           'serial': 'S128F1211400031',
                                           'serial_number': 'S128F1211400031',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7359657609,
                                           'ul_rf_packets': 42327105},
                'S128F1211400132': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 10051144497,
                                           'dl_rf_packets': 8820136,
                                           'ip_address': None,
                                           'name': 'Angie_Kroeger',
                                           'serial': 'S128F1211400132',
                                           'serial_number': 'S128F1211400132',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2733726156,
                                           'ul_rf_packets': 6875524},
                'S128F1211400171': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 702092934,
                                           'dl_rf_packets': 642830,
                                           'ip_address': None,
                                           'name': 'Jennifer_Ray_49051',
                                           'serial': 'S128F1211400171',
                                           'serial_number': 'S128F1211400171',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 78492505,
                                           'ul_rf_packets': 492909},
                'S128F1211500013': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 113867872218,
                                           'dl_rf_packets': 90367207,
                                           'ip_address': None,
                                           'name': 'Savannah_Szymanski',
                                           'serial': 'S128F1211500013',
                                           'serial_number': 'S128F1211500013',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25475107589,
                                           'ul_rf_packets': 50702193},
                'S128F1211500072': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 82589886935,
                                           'dl_rf_packets': 56608704,
                                           'ip_address': None,
                                           'name': 'Carla_Childers',
                                           'serial': 'S128F1211500072',
                                           'serial_number': 'S128F1211500072',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2038966760,
                                           'ul_rf_packets': 16098680},
                'S128F1212500234': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 666373607312,
                                           'dl_rf_packets': 472455749,
                                           'ip_address': None,
                                           'name': 'Clayton_Corbett_50530',
                                           'serial': 'S128F1212500234',
                                           'serial_number': 'S128F1212500234',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25695928166,
                                           'ul_rf_packets': 232755799},
                'S128F1212500548': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53809661651,
                                           'dl_rf_packets': 43130994,
                                           'ip_address': None,
                                           'name': 'Heather_Sullivan',
                                           'serial': 'S128F1212500548',
                                           'serial_number': 'S128F1212500548',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3517554304,
                                           'ul_rf_packets': 21470664},
                'S128F1212700257': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 407114452703,
                                           'dl_rf_packets': 280482511,
                                           'ip_address': None,
                                           'name': 'Renee_Dove',
                                           'serial': 'S128F1212700257',
                                           'serial_number': 'S128F1212700257',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 11245769456,
                                           'ul_rf_packets': 126478788},
                'S128F1212800054': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 409924967218,
                                           'dl_rf_packets': 311815755,
                                           'ip_address': None,
                                           'name': 'Danita_Bittle',
                                           'serial': 'S128F1212800054',
                                           'serial_number': 'S128F1212800054',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 17431373891,
                                           'ul_rf_packets': 76981758},
                'S128F1212800154': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 773910937027,
                                           'dl_rf_packets': 696398826,
                                           'ip_address': None,
                                           'name': 'Steve_Brockman_46913',
                                           'serial': 'S128F1212800154',
                                           'serial_number': 'S128F1212800154',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 131531096939,
                                           'ul_rf_packets': 497346328},
                'S128F1212800181': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 242352872853,
                                           'dl_rf_packets': 176246456,
                                           'ip_address': None,
                                           'name': 'Rose_Martin_49117',
                                           'serial': 'S128F1212800181',
                                           'serial_number': 'S128F1212800181',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 12424890198,
                                           'ul_rf_packets': 59148886},
                'S150F2224125595': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 471906591144,
                                           'dl_rf_packets': 318549251,
                                           'ip_address': None,
                                           'name': 'Dustin_Draper_47015',
                                           'serial': 'S150F2224125595',
                                           'serial_number': 'S150F2224125595',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 13864498472,
                                           'ul_rf_packets': 152388342},
                'S150F2224125599': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 48388445836,
                                           'dl_rf_packets': 38263708,
                                           'ip_address': None,
                                           'name': 'Wesley_White_49956',
                                           'serial': 'S150F2224125599',
                                           'serial_number': 'S150F2224125599',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5264949395,
                                           'ul_rf_packets': 25847714},
                'S150F2224125601': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 90793124384,
                                           'dl_rf_packets': 72503965,
                                           'ip_address': None,
                                           'name': 'Larry_Soles_49451',
                                           'serial': 'S150F2224125601',
                                           'serial_number': 'S150F2224125601',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 15247110856,
                                           'ul_rf_packets': 57147321}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.412533,
                                'elevation': 336.58,
                                'gps_sats_tracked': 17,
                                'height': 562.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '422427',
                                                                                       'in_octets': '7359657609',
                                                                                       'in_ucast_pkts': '42327105',
                                                                                       'out_errors': '1804747',
                                                                                       'out_octets': '111545078110',
                                                                                       'out_ucast_pkts': '81291434',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ=='},
                                                                               {       'in_errors': '1912251',
                                                                                       'in_octets': '11245769456',
                                                                                       'in_ucast_pkts': '126478788',
                                                                                       'out_errors': '9338056',
                                                                                       'out_octets': '407114452703',
                                                                                       'out_ucast_pkts': '280482511',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ=='},
                                                                               {       'in_errors': '1927202',
                                                                                       'in_octets': '25475107589',
                                                                                       'in_ucast_pkts': '50702193',
                                                                                       'out_errors': '5806455',
                                                                                       'out_octets': '113867872218',
                                                                                       'out_ucast_pkts': '90367207',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ=='},
                                                                               {       'in_errors': '6120175',
                                                                                       'in_octets': '131531096939',
                                                                                       'in_ucast_pkts': '497346328',
                                                                                       'out_errors': '29433563',
                                                                                       'out_octets': '773910937027',
                                                                                       'out_ucast_pkts': '696398826',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ=='},
                                                                               {       'in_errors': '397930',
                                                                                       'in_octets': '3517554304',
                                                                                       'in_ucast_pkts': '21470664',
                                                                                       'out_errors': '1921034',
                                                                                       'out_octets': '53809661651',
                                                                                       'out_ucast_pkts': '43130994',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ=='},
                                                                               {       'in_errors': '13742',
                                                                                       'in_octets': '78492505',
                                                                                       'in_ucast_pkts': '492909',
                                                                                       'out_errors': '45064',
                                                                                       'out_octets': '702092934',
                                                                                       'out_ucast_pkts': '642830',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ=='},
                                                                               {       'in_errors': '2919236',
                                                                                       'in_octets': '25695928166',
                                                                                       'in_ucast_pkts': '232755799',
                                                                                       'out_errors': '13889372',
                                                                                       'out_octets': '666373607312',
                                                                                       'out_ucast_pkts': '472455749',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ=='},
                                                                               {       'in_errors': '2119119',
                                                                                       'in_octets': '17431373891',
                                                                                       'in_ucast_pkts': '76981758',
                                                                                       'out_errors': '11193598',
                                                                                       'out_octets': '409924967218',
                                                                                       'out_ucast_pkts': '311815755',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ=='},
                                                                               {       'in_errors': '568332',
                                                                                       'in_octets': '12424890198',
                                                                                       'in_ucast_pkts': '59148886',
                                                                                       'out_errors': '4049822',
                                                                                       'out_octets': '242352872853',
                                                                                       'out_ucast_pkts': '176246456',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ=='},
                                                                               {       'in_errors': '90557',
                                                                                       'in_octets': '2733726156',
                                                                                       'in_ucast_pkts': '6875524',
                                                                                       'out_errors': '330964',
                                                                                       'out_octets': '10051144497',
                                                                                       'out_ucast_pkts': '8820136',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ=='},
                                                                               {       'in_errors': '1308940',
                                                                                       'in_octets': '13864498472',
                                                                                       'in_ucast_pkts': '152388342',
                                                                                       'out_errors': '5992835',
                                                                                       'out_octets': '471906591144',
                                                                                       'out_ucast_pkts': '318549251',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ=='},
                                                                               {       'in_errors': '637110',
                                                                                       'in_octets': '15247110856',
                                                                                       'in_ucast_pkts': '57147321',
                                                                                       'out_errors': '3065344',
                                                                                       'out_octets': '90793124384',
                                                                                       'out_ucast_pkts': '72503965',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ=='},
                                                                               {       'in_errors': '414063',
                                                                                       'in_octets': '2038966760',
                                                                                       'in_ucast_pkts': '16098680',
                                                                                       'out_errors': '1229025',
                                                                                       'out_octets': '82589886935',
                                                                                       'out_ucast_pkts': '56608704',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ=='},
                                                                               {       'in_errors': '361262',
                                                                                       'in_octets': '5264949395',
                                                                                       'in_ucast_pkts': '25847714',
                                                                                       'out_errors': '1792137',
                                                                                       'out_octets': '48388445836',
                                                                                       'out_ucast_pkts': '38263708',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                              'radios': [       {       'admin_up': True,
                                                                                        'azimuth': 180.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 32.934494,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '615729',
                                                                                                                                            'distance': 2465,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '660559',
                                                                                                                                            'distance': 12837,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '499379',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '13211649',
                                                                                                                                            'distance': 10874,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '561019',
                                                                                                                                            'distance': 10190,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '26889',
                                                                                                                                            'distance': 14043,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '6128339',
                                                                                                                                            'distance': 6994,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '2796999',
                                                                                                                                            'distance': 6499,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '670589',
                                                                                                                                            'distance': 9359,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '589919',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '517679',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '692229',
                                                                                                                                            'distance': 9272,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '569469',
                                                                                                                                            'distance': 6492,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                                                                                            'rssi': -83.26275},
                                                                                                                                    {       'connected_time': '662599',
                                                                                                                                            'distance': 3711,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                                                                                            'rssi': -83.26275}]}],
                                                                                        'tx_power': 0},
                                                                                {       'admin_up': True,
                                                                                        'azimuth': 180.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5805,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 31.241343,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '615729',
                                                                                                                                            'distance': 2465,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '660559',
                                                                                                                                            'distance': 12837,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '499379',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '13211649',
                                                                                                                                            'distance': 10874,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '561019',
                                                                                                                                            'distance': 10190,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '26889',
                                                                                                                                            'distance': 14043,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '6128339',
                                                                                                                                            'distance': 6994,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '2796999',
                                                                                                                                            'distance': 6499,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '670589',
                                                                                                                                            'distance': 9359,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '589919',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '517679',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '692229',
                                                                                                                                            'distance': 9272,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '569469',
                                                                                                                                            'distance': 6492,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                                                                                            'rssi': -82.366684},
                                                                                                                                    {       'connected_time': '662599',
                                                                                                                                            'distance': 3711,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                                                                                            'rssi': -82.366684}]}],
                                                                                        'tx_power': -4}],
                                                              'rf_aggregation_groups': [       {       'airtime': 0.5208334,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '564',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '25080442',
                                                              'in_octets': '38698663489263',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2358353',
                                                              'out_octets': '3320911369647',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '152',
                                                              'out_octets': '11386',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '17434',
                                                              'out_octets': '1228160',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZ2kx'}],
                                'latitude': 38.7607536315918,
                                'longitude': -93.46488952636719,
                                'manufacturer': 'Tarana',
                                'mem': 55.0,
                                'model': '30-0134-001',
                                'name': 'LaMonte5GHzSouth',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDAz',
                                'serial_number': 'S134F1211300003',
                                'sw_version': '0.977.016.00',
                                'temperature': 29.125,
                                'uptime': '17481742'},
                'peers': [       {       'cpu': 20.154552,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '111545078110',
                                                                       'in_ucast_pkts': '81291434',
                                                                       'links': [       {       'in_octets': '111545078110',
                                                                                                'in_ucast_pkts': '81291434',
                                                                                                'out_octets': '7359657609',
                                                                                                'out_ucast_pkts': '42327105',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7359657609',
                                                                       'out_ucast_pkts': '42327105',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 33.188564,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '615729',
                                                                                                                                                     'distance': 2465,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.82189}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 8.404329,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '615729',
                                                                                                                                                     'distance': 2465,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -92.796486}]}],
                                                                                                 'tx_power': 10}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 1.6467513,
                                                                                                                'tx_packet_error_rate': 0.00021413276}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5632',
                                                                       'in_octets': '7359766082',
                                                                       'in_ucast_pkts': '42321173',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '111222722782',
                                                                       'out_ucast_pkts': '81291685',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.73887252807617,
                                         'longitude': -93.4662857055664,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Kieyah_Fyffe',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMDMx',
                                         'serial_number': 'S128F1211400031',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.958,
                                         'uptime': '616070'},
                                 {       'cpu': 20.255016,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '407114452703',
                                                                       'in_ucast_pkts': '280482511',
                                                                       'links': [       {       'in_octets': '407114452703',
                                                                                                'in_ucast_pkts': '280482511',
                                                                                                'out_octets': '11245769456',
                                                                                                'out_ucast_pkts': '126478788',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11245769456',
                                                                       'out_ucast_pkts': '126478788',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 50.8767,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 138.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660559',
                                                                                                                                                     'distance': 12837,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.02102}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 7.7420254,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660559',
                                                                                                                                                     'distance': 12837,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.4528}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 5.510536,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '763',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6131',
                                                                       'in_octets': '11246419217',
                                                                       'in_ucast_pkts': '126472618',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '405980799892',
                                                                       'out_ucast_pkts': '280475681',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.646331787109375,
                                         'longitude': -93.47783660888672,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Renee_Dove',
                                         'poller_hash': 'UzEyOEYxMjEyNzAwMjU3',
                                         'serial_number': 'S128F1212700257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.9,
                                         'uptime': '660768'},
                                 {       'cpu': 21.595655,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '113867872218',
                                                                       'in_ucast_pkts': '90367207',
                                                                       'links': [       {       'in_octets': '113867872218',
                                                                                                'in_ucast_pkts': '90367207',
                                                                                                'out_octets': '25475107589',
                                                                                                'out_ucast_pkts': '50702193',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25475107589',
                                                                       'out_ucast_pkts': '50702193',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.142952,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '499379',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -92.90506}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 30.87093,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 138.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '499379',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.35327}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 13.00416,
                                                                                                                'rx_packet_error_rate': 0.0034482758,
                                                                                                                'tx_interference_signal_ratio': 6.969064,
                                                                                                                'tx_packet_error_rate': 0.0017391305}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4554',
                                                                       'in_octets': '25485803220',
                                                                       'in_ucast_pkts': '50707390',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '113495461528',
                                                                       'out_ucast_pkts': '90360161',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71567916870117,
                                         'longitude': -93.40946960449219,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Savannah_Szymanski',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDEz',
                                         'serial_number': 'S128F1211500013',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '499613'},
                                 {       'cpu': 19.87967,
                                         'elevation': 295.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '773910937027',
                                                                       'in_ucast_pkts': '696398826',
                                                                       'links': [       {       'in_octets': '773910937027',
                                                                                                'in_ucast_pkts': '696398826',
                                                                                                'out_octets': '131531096939',
                                                                                                'out_ucast_pkts': '497346328',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '131531096939',
                                                                       'out_ucast_pkts': '497346328',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 355.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 17.130322,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13211649',
                                                                                                                                                     'distance': 10874,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.802155}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 355.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 39.419678,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13211649',
                                                                                                                                                     'distance': 10874,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.19456}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '32',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '116448',
                                                                       'in_octets': '131534569065',
                                                                       'in_ucast_pkts': '497231985',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '771260519282',
                                                                       'out_ucast_pkts': '696430566',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.66176223754883,
                                         'longitude': -93.46878051757812,
                                         'manufacturer': 'Tarana',
                                         'mem': 29.0,
                                         'model': '30-0128-001',
                                         'name': 'Steve_Brockman_46913',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTU0',
                                         'serial_number': 'S128F1212800154',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.333,
                                         'uptime': '13211868'},
                                 {       'cpu': 20.683191,
                                         'elevation': 12.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53809661651',
                                                                       'in_ucast_pkts': '43130994',
                                                                       'links': [       {       'in_octets': '53809661651',
                                                                                                'in_ucast_pkts': '43130994',
                                                                                                'out_octets': '3517554304',
                                                                                                'out_ucast_pkts': '21470664',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3517554304',
                                                                       'out_ucast_pkts': '21470664',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 50.980167,
                                                                                                 'rx_max_sensitivity_loss': 0.80999994,
                                                                                                 'rx_path_loss': 137.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561019',
                                                                                                                                                     'distance': 10190,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.90199}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 7.099776,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561019',
                                                                                                                                                     'distance': 10190,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.10579}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 25.936317,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5082',
                                                                       'in_octets': '3517646983',
                                                                       'in_ucast_pkts': '21465404',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '53634599610',
                                                                       'out_ucast_pkts': '43128758',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.669837951660156,
                                         'longitude': -93.45140838623047,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Heather_Sullivan',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4',
                                         'serial_number': 'S128F1212500548',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '561235'},
                                 {       'cpu': 18.86753,
                                         'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '702092934',
                                                                       'in_ucast_pkts': '642830',
                                                                       'links': [       {       'in_octets': '702092934',
                                                                                                'in_ucast_pkts': '642830',
                                                                                                'out_octets': '78492505',
                                                                                                'out_ucast_pkts': '492909',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '78492505',
                                                                       'out_ucast_pkts': '492909',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 340.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 27.634466,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26889',
                                                                                                                                                     'distance': 14043,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -88.71975}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 340.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 6.831443,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26889',
                                                                                                                                                     'distance': 14043,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -97.16272}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 15.948604,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '18',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '128542',
                                                                       'in_octets': '84380312351',
                                                                       'in_ucast_pkts': '539823167',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1338557309709',
                                                                       'out_ucast_pkts': '1029140427',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.634849548339844,
                                         'longitude': -93.4756088256836,
                                         'manufacturer': 'Tarana',
                                         'mem': 30.0,
                                         'model': '30-0128-001',
                                         'name': 'Jennifer_Ray_49051',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTcx',
                                         'serial_number': 'S128F1211400171',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '12954419'},
                                 {       'cpu': 20.758032,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '666373607312',
                                                                       'in_ucast_pkts': '472455749',
                                                                       'links': [       {       'in_octets': '666373607312',
                                                                                                'in_ucast_pkts': '472455749',
                                                                                                'out_octets': '25695928166',
                                                                                                'out_ucast_pkts': '232755799',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25695928166',
                                                                       'out_ucast_pkts': '232755799',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.074371,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6128339',
                                                                                                                                                     'distance': 6994,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.83722}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.747107,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6128339',
                                                                                                                                                     'distance': 6994,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.97674}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '17',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '53730',
                                                                       'in_octets': '25696902263',
                                                                       'in_ucast_pkts': '232699943',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '664481589399',
                                                                       'out_ucast_pkts': '472467201',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.69669723510742,
                                         'longitude': -93.4757308959961,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Clayton_Corbett_50530',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMjM0',
                                         'serial_number': 'S128F1212500234',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.816,
                                         'uptime': '6128560'},
                                 {       'cpu': 19.744823,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '409924967218',
                                                                       'in_ucast_pkts': '311815755',
                                                                       'links': [       {       'in_octets': '409924967218',
                                                                                                'in_ucast_pkts': '311815755',
                                                                                                'out_octets': '17431373891',
                                                                                                'out_ucast_pkts': '76981758',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17431373891',
                                                                       'out_ucast_pkts': '76981758',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 315.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 7.180329,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2796999',
                                                                                                                                                     'distance': 6499,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.69003}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 315.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 6.89307,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 141.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2796999',
                                                                                                                                                     'distance': 6499,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -96.19803}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -16.110044,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '25',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '25378',
                                                                       'in_octets': '17432430978',
                                                                       'in_ucast_pkts': '76955912',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '408655748081',
                                                                       'out_ucast_pkts': '311802886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.70980453491211,
                                         'longitude': -93.42867279052734,
                                         'manufacturer': 'Tarana',
                                         'mem': 29.0,
                                         'model': '30-0128-001',
                                         'name': 'Danita_Bittle',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMDU0',
                                         'serial_number': 'S128F1212800054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 16.629,
                                         'uptime': '2797346'},
                                 {       'cpu': 20.692532,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '242352872853',
                                                                       'in_ucast_pkts': '176246456',
                                                                       'links': [       {       'in_octets': '242352872853',
                                                                                                'in_ucast_pkts': '176246456',
                                                                                                'out_octets': '12424890198',
                                                                                                'out_ucast_pkts': '59148886',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '12424890198',
                                                                       'out_ucast_pkts': '59148886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 17.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 13.300032,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 132.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '670589',
                                                                                                                                                     'distance': 9359,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -91.707466}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 17.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 9.605277,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '670589',
                                                                                                                                                     'distance': 9359,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -93.05461}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -15.585099,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11255',
                                                                       'in_octets': '12425028667',
                                                                       'in_ucast_pkts': '59137467',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '241649723785',
                                                                       'out_ucast_pkts': '176245541',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.67723083496094,
                                         'longitude': -93.45409393310547,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0128-001',
                                         'name': 'Rose_Martin_49117',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTgx',
                                         'serial_number': 'S128F1212800181',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.526,
                                         'uptime': '670938'},
                                 {       'cpu': 19.563581,
                                         'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '10051144497',
                                                                       'in_ucast_pkts': '8820136',
                                                                       'links': [       {       'in_octets': '10051144497',
                                                                                                'in_ucast_pkts': '8820136',
                                                                                                'out_octets': '2733726156',
                                                                                                'out_ucast_pkts': '6875524',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2733726156',
                                                                       'out_ucast_pkts': '6875524',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 18.273315,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '589919',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -84.87994}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 12.92862,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '589919',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.807106}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5321',
                                                                       'in_octets': '2733846174',
                                                                       'in_ucast_pkts': '6870038',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '10016733287',
                                                                       'out_ucast_pkts': '8820741',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.742218017578125,
                                         'longitude': -93.47102355957031,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0128-001',
                                         'name': 'Angie_Kroeger',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTMy',
                                         'serial_number': 'S128F1211400132',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 10.243,
                                         'uptime': '590142'},
                                 {       'cpu': 20.722528,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '471906591144',
                                                                       'in_ucast_pkts': '318549251',
                                                                       'links': [       {       'in_octets': '471906591144',
                                                                                                'in_ucast_pkts': '318549251',
                                                                                                'out_octets': '13864498472',
                                                                                                'out_ucast_pkts': '152388342',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '13864498472',
                                                                       'out_ucast_pkts': '152388342',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 33.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 12.526282,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 128.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '517679',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.77588}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 33.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.061642,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 127.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '517679',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -87.16747}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.007518797,
                                                                                                                'tx_interference_signal_ratio': -11.637901,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '382',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14623',
                                                                       'in_octets': '13865693161',
                                                                       'in_ucast_pkts': '152374767',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '470629734193',
                                                                       'out_ucast_pkts': '318548562',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.733699798583984,
                                         'longitude': -93.48733520507812,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0150-001',
                                         'name': 'Dustin_Draper_47015',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk1',
                                         'serial_number': 'S150F2224125595',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.352,
                                         'uptime': '517916'},
                                 {       'cpu': 20.981472,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '90793124384',
                                                                       'in_ucast_pkts': '72503965',
                                                                       'links': [       {       'in_octets': '90793124384',
                                                                                                'in_ucast_pkts': '72503965',
                                                                                                'out_octets': '15247110856',
                                                                                                'out_ucast_pkts': '57147321',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15247110856',
                                                                       'out_ucast_pkts': '57147321',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 6.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 43.594646,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 135.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '692229',
                                                                                                                                                     'distance': 9272,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -88.947586}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 6.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 48.555214,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 139.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '692229',
                                                                                                                                                     'distance': 9272,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -95.148315}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 14.205947,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '55675',
                                                                       'in_errors': '50038',
                                                                       'in_nucast_pkts': '6276',
                                                                       'in_octets': '15317417462',
                                                                       'in_ucast_pkts': '57211466',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '90501473019',
                                                                       'out_ucast_pkts': '72503428',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.6778564453125,
                                         'longitude': -93.47520446777344,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0150-001',
                                         'name': 'Larry_Soles_49451',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NjAx',
                                         'serial_number': 'S150F2224125601',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '692493'},
                                 {       'cpu': 19.684448,
                                         'elevation': 25.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '82589886935',
                                                                       'in_ucast_pkts': '56608704',
                                                                       'links': [       {       'in_octets': '82589886935',
                                                                                                'in_ucast_pkts': '56608704',
                                                                                                'out_octets': '2038966760',
                                                                                                'out_ucast_pkts': '16098680',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2038966760',
                                                                       'out_ucast_pkts': '16098680',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 340.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 7.047847,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 143.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '569469',
                                                                                                                                                     'distance': 6492,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.85479}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 340.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 41.340603,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 145.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '569469',
                                                                                                                                                     'distance': 6492,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -86.23133}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5255',
                                                                       'in_octets': '2039116077',
                                                                       'in_ucast_pkts': '16093389',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '82363060257',
                                                                       'out_ucast_pkts': '56608690',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71841812133789,
                                         'longitude': -93.4135971069336,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': 'Carla_Childers',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDcy',
                                         'serial_number': 'S128F1211500072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.004,
                                         'uptime': '569981'},
                                 {       'cpu': 20.670671,
                                         'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '48388445836',
                                                                       'in_ucast_pkts': '38263708',
                                                                       'links': [       {       'in_octets': '48388445836',
                                                                                                'in_ucast_pkts': '38263708',
                                                                                                'out_octets': '5264949395',
                                                                                                'out_ucast_pkts': '25847714',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5264949395',
                                                                       'out_ucast_pkts': '25847714',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 11.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.61564,
                                                                                                 'rx_max_sensitivity_loss': 0.3000002,
                                                                                                 'rx_path_loss': 126.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '662599',
                                                                                                                                                     'distance': 3711,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -82.56106}]}],
                                                                                                 'tx_power': 3},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 11.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 20.366928,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '662599',
                                                                                                                                                     'distance': 3711,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                                                                                                                     'rssi': -94.234314}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 1.5598637,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': -0.023837408,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5955',
                                                                       'in_octets': '5260006478',
                                                                       'in_ucast_pkts': '25836805',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '48233678231',
                                                                       'out_ucast_pkts': '38263311',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.728084564208984,
                                         'longitude': -93.47294616699219,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0150-001',
                                         'name': 'Wesley_White_49956',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk5',
                                         'serial_number': 'S150F2224125599',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.784,
                                         'uptime': '662804'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_988_004_00_10_100_8_14(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.988.004.00.10_100_8_14")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300017',
                'system_mac_address': '04:f1:7d:00:25:eb',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:23:b0': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2556,
                                             'dl_rf_packets': 14,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:23:b0',
                                             'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                             'serial_number': 'S128F1211800086',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3084441,
                                             'ul_rf_packets': 35078},
                '04:f1:7d:00:28:bd': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 23066481102,
                                             'dl_rf_packets': 25536783,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:bd',
                                             'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                             'serial_number': 'S128F1211600018',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2040239347,
                                             'ul_rf_packets': 15781673},
                '04:f1:7d:00:29:1a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 15173457732,
                                             'dl_rf_packets': 10824924,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:29:1a',
                                             'name': '810-BETH_MOONEY-RES25-R',
                                             'serial_number': 'S128F1211600118',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 762375140,
                                             'ul_rf_packets': 7370516}
        }
        exp_ne_msg = {
                'data': {       'cpu': 30.954504,
                                'elevation': 123.159,
                                'gps_sats_tracked': 14,
                                'height': 45.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '599',
                                                                                       'in_octets': '3084441',
                                                                                       'in_ucast_pkts': '35078',
                                                                                       'out_errors': '2695',
                                                                                       'out_octets': '2556',
                                                                                       'out_ucast_pkts': '14',
                                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ=='},
                                                                               {       'in_errors': '300',
                                                                                       'in_octets': '2040239347',
                                                                                       'in_ucast_pkts': '15781673',
                                                                                       'out_errors': '117511',
                                                                                       'out_octets': '23066481102',
                                                                                       'out_ucast_pkts': '25536783',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ=='},
                                                                               {       'in_errors': '73024',
                                                                                       'in_octets': '762375140',
                                                                                       'in_ucast_pkts': '7370516',
                                                                                       'out_errors': '543609',
                                                                                       'out_octets': '15173457732',
                                                                                       'out_ucast_pkts': '10824924',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                              'radios': [       {       'admin_up': True,
                                                                                        'azimuth': 90.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5755,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 26.164675,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '140076',
                                                                                                                                            'distance': 716,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                                                                                            'rssi': -87.32196},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 636,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                                                                                            'rssi': -87.32196},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 1092,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                                                                                            'rssi': -87.32196}]}],
                                                                                        'tx_power': -61},
                                                                                {       'admin_up': True,
                                                                                        'azimuth': 90.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 30.10134,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '140076',
                                                                                                                                            'distance': 716,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                                                                                            'rssi': -78.134865},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 636,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                                                                                            'rssi': -78.134865},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 1092,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                                                                                            'rssi': -78.134865}]}],
                                                                                        'tx_power': 15}],
                                                              'rf_aggregation_groups': [       {       'airtime': 2.3394456,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '54',
                                                              'out_octets': '4148',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3Z2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '9',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '414291',
                                                              'in_octets': '38381328754',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '63264',
                                                              'out_octets': '4626724732',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgy'}],
                                'latitude': 30.71991539001465,
                                'longitude': -86.11815643310547,
                                'manufacturer': 'Tarana',
                                'mem': 40.0,
                                'model': '30-0134-001',
                                'name': 'BN-TRG1-090-01.DFSCENTRAL',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3',
                                'serial_number': 'S134F1211300017',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:25:eb',
                                'temperature': 51.25,
                                'uptime': '140409'},
                'peers': [       {       'cpu': 21.147583,
                                         'elevation': 15.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2556',
                                                                       'in_ucast_pkts': '14',
                                                                       'links': [       {       'in_octets': '2556',
                                                                                                'in_ucast_pkts': '14',
                                                                                                'out_octets': '3084441',
                                                                                                'out_ucast_pkts': '35078',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3084441',
                                                                       'out_ucast_pkts': '35078',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 253.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 27.18464,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 110.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140076',
                                                                                                                                                     'distance': 716,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -71.66321}]}],
                                                                                                 'tx_power': -77},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 253.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 19.301258,
                                                                                                 'rx_max_sensitivity_loss': 2.98,
                                                                                                 'rx_path_loss': 112.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140076',
                                                                                                                                                     'distance': 716,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -69.60998}]}],
                                                                                                 'tx_power': -77}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 6.750889,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '35153',
                                                                       'in_octets': '3116843',
                                                                       'in_ucast_pkts': '10',
                                                                       'mac_address': '04:f1:7d:00:23:b0',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '34120',
                                                                       'out_ucast_pkts': '399',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.721792221069336,
                                         'longitude': -86.11119842529297,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExODAwMDg2',
                                         'serial_number': 'S128F1211800086',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:23:b0',
                                         'temperature': 24.293,
                                         'uptime': '140430'},
                                 {       'cpu': 23.013287,
                                         'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '23066481102',
                                                                       'in_ucast_pkts': '25536783',
                                                                       'links': [       {       'in_octets': '23066481102',
                                                                                                'in_ucast_pkts': '25536783',
                                                                                                'out_octets': '2040239347',
                                                                                                'out_ucast_pkts': '15781673',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2040239347',
                                                                       'out_ucast_pkts': '15781673',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 7.1334214,
                                                                                                 'rx_max_sensitivity_loss': 1.8299999,
                                                                                                 'rx_path_loss': 111.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -71.14302}]}],
                                                                                                 'tx_power': -7},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 14.8108835,
                                                                                                 'rx_max_sensitivity_loss': 4.96,
                                                                                                 'rx_path_loss': 111.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -67.60989}]}],
                                                                                                 'tx_power': -77}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 8.290967,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 12.12927,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2159583',
                                                                       'in_octets': '63082667566',
                                                                       'in_ucast_pkts': '362354881',
                                                                       'mac_address': '04:f1:7d:00:28:bd',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '578988164771',
                                                                       'out_ucast_pkts': '614897955',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.720535278320312,
                                         'longitude': -86.11167907714844,
                                         'manufacturer': 'Tarana',
                                         'mem': 32.0,
                                         'model': '30-0128-001',
                                         'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMDE4',
                                         'serial_number': 'S128F1211600018',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:28:bd',
                                         'temperature': 23.887,
                                         'uptime': '8632580'},
                                 {       'cpu': 20.260782,
                                         'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15173457732',
                                                                       'in_ucast_pkts': '10824924',
                                                                       'links': [       {       'in_octets': '15173457732',
                                                                                                'in_ucast_pkts': '10824924',
                                                                                                'out_octets': '762375140',
                                                                                                'out_ucast_pkts': '7370516',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '762375140',
                                                                       'out_ucast_pkts': '7370516',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 315.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 31.097239,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 1092,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -79.306335}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 315.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 44.558765,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 142.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 1092,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                                                                                                                     'rssi': -82.42502}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 11.851149,
                                                                                                                'rx_packet_error_rate': 1.6204041e-05,
                                                                                                                'tx_interference_signal_ratio': 31.699345,
                                                                                                                'tx_packet_error_rate': 0.00032784988}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14197',
                                                                       'in_octets': '1600579939',
                                                                       'in_ucast_pkts': '14522302',
                                                                       'mac_address': '04:f1:7d:00:29:1a',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '29794304713',
                                                                       'out_ucast_pkts': '21375281',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.716629028320312,
                                         'longitude': -86.10767364501953,
                                         'manufacturer': 'Tarana',
                                         'mem': 28.0,
                                         'model': '30-0128-001',
                                         'name': '810-BETH_MOONEY-RES25-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMTE4',
                                         'serial_number': 'S128F1211600118',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:29:1a',
                                         'temperature': 26.616,
                                         'uptime': '275381'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_997_028_00_10_11_240_91(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.997.028.00.10_11_240_91")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.997.028.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F2224809083',
                'system_mac_address': '04:f1:7d:01:4e:3a',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:01:20:4a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 51844262121,
                                             'dl_rf_packets': 40922953,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:20:4a',
                                             'name': '11232-RMX6',
                                             'serial_number': 'S150F2224402665',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3394798411,
                                             'ul_rf_packets': 17435256},
                '04:f1:7d:01:88:39': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 22357725769,
                                             'dl_rf_packets': 18157047,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:88:39',
                                             'name': '7904-CED5',
                                             'serial_number': 'S150F2230121277',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2624678709,
                                             'ul_rf_packets': 10539180},
                '04:f1:7d:03:59:04': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 15499814885,
                                             'dl_rf_packets': 15062937,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:03:59:04',
                                             'name': '12833-RMX33',
                                             'serial_number': 'S150F2232417671',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8202864435,
                                             'ul_rf_packets': 10067820}
        }
        exp_ne_msg = {
                'data': {       'cpu': 18.495779,
                                'elevation': 1910.963,
                                'gps_sats_tracked': 21,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '253329',
                                                                                       'in_octets': '8202864435',
                                                                                       'in_ucast_pkts': '10067820',
                                                                                       'out_errors': '877516',
                                                                                       'out_octets': '15499814885',
                                                                                       'out_ucast_pkts': '15062937',
                                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ=='},
                                                                               {       'in_errors': '78439',
                                                                                       'in_octets': '2624678709',
                                                                                       'in_ucast_pkts': '10539180',
                                                                                       'out_errors': '282618',
                                                                                       'out_octets': '22357725769',
                                                                                       'out_ucast_pkts': '18157047',
                                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ=='},
                                                                               {       'in_errors': '331847',
                                                                                       'in_octets': '3394798411',
                                                                                       'in_ucast_pkts': '17435256',
                                                                                       'out_errors': '1193471',
                                                                                       'out_octets': '51844262121',
                                                                                       'out_ucast_pkts': '40922953',
                                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                              'radios': [       {       'admin_up': True,
                                                                                        'azimuth': 0.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 80,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5795,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 59.667503,
                                                                                        'rx_max_sensitivity_loss': 3.1,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1087824',
                                                                                                                                            'distance': 2566,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '49753937',
                                                                                                                                            'tx_link_rate': '148963828'},
                                                                                                                                    {       'connected_time': '334255',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '71270453',
                                                                                                                                            'tx_link_rate': '285081812'},
                                                                                                                                    {       'connected_time': '172444',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                                                                                            'rssi': -73.46582,
                                                                                                                                            'rx_link_rate': '39793628',
                                                                                                                                            'tx_link_rate': '78433500'}]}],
                                                                                        'tx_power': 1},
                                                                                {       'admin_up': True,
                                                                                        'azimuth': 0.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 80,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 44.726063,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1087824',
                                                                                                                                            'distance': 2566,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '36491117',
                                                                                                                                            'tx_link_rate': '102934171'},
                                                                                                                                    {       'connected_time': '334255',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '71070226',
                                                                                                                                            'tx_link_rate': '282486375'},
                                                                                                                                    {       'connected_time': '172444',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                                                                                            'rssi': -74.25467,
                                                                                                                                            'rx_link_rate': '26156505',
                                                                                                                                            'tx_link_rate': '35080667'}]}],
                                                                                        'tx_power': -61}],
                                                              'rf_aggregation_groups': [       {       'airtime': 0.2711777,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZ2kx'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '142',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '194187132',
                                                              'in_octets': '2782358419665',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '637560',
                                                              'out_octets': '381883912609',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgx',
                                                              'speed': '10000000000'}],
                                'latitude': 40.512184143066406,
                                'longitude': -107.54761505126953,
                                'manufacturer': 'Tarana',
                                'mem': 33.0,
                                'model': '30-0134-001',
                                'name': 'RMX-T5-NW-91',
                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgz',
                                'serial_number': 'S134F2224809083',
                                'sw_version': '0.997.028.00',
                                'system_mac_address': '04:f1:7d:01:4e:3a',
                                'temperature': 50.641,
                                'uptime': '6760237'},
                'peers': [       {       'cpu': 21.407686,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15499814885',
                                                                       'in_ucast_pkts': '15062937',
                                                                       'links': [       {       'in_octets': '15499814885',
                                                                                                'in_ucast_pkts': '15062937',
                                                                                                'out_octets': '8202864435',
                                                                                                'out_ucast_pkts': '10067820',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8202864435',
                                                                       'out_ucast_pkts': '10067820',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 40.352093,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1087824',
                                                                                                                                                     'distance': 2566,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -82.14493,
                                                                                                                                                     'rx_link_rate': '148963828',
                                                                                                                                                     'tx_link_rate': '49753937'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 37.56776,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1087824',
                                                                                                                                                     'distance': 2566,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -73.73435,
                                                                                                                                                     'rx_link_rate': '102934171',
                                                                                                                                                     'tx_link_rate': '36491117'}]}],
                                                                                                 'tx_power': -59}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.29049,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 17.199945,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '225',
                                                                       'in_octets': '8202921099',
                                                                       'in_ucast_pkts': '10067273',
                                                                       'mac_address': '04:f1:7d:03:59:04',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15868314258',
                                                                       'out_ucast_pkts': '15316198',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.5145378112793,
                                         'longitude': -107.57792663574219,
                                         'manufacturer': 'Tarana',
                                         'mem': 24.0,
                                         'model': '30-0150-001',
                                         'name': '12833-RMX33',
                                         'poller_hash': 'UzE1MEYyMjMyNDE3Njcx',
                                         'serial_number': 'S150F2232417671',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:03:59:04',
                                         'temperature': 28.416,
                                         'uptime': '1088178'},
                                 {       'cpu': 25.426706,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '22357725769',
                                                                       'in_ucast_pkts': '18157047',
                                                                       'links': [       {       'in_octets': '22357725769',
                                                                                                'in_ucast_pkts': '18157047',
                                                                                                'out_octets': '2624678709',
                                                                                                'out_ucast_pkts': '10539180',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2624678709',
                                                                       'out_ucast_pkts': '10539180',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 25.062023,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 112.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334255',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -70.43143,
                                                                                                                                                     'rx_link_rate': '285081812',
                                                                                                                                                     'tx_link_rate': '71270453'}]}],
                                                                                                 'tx_power': -71},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 27.27884,
                                                                                                 'rx_max_sensitivity_loss': 2.98,
                                                                                                 'rx_path_loss': 109.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334255',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -65.20434,
                                                                                                                                                     'rx_link_rate': '282486375',
                                                                                                                                                     'tx_link_rate': '71070226'}]}],
                                                                                                 'tx_power': -71}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 25.392645,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 7.3731446,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1009',
                                                                       'in_octets': '2625096890',
                                                                       'in_ucast_pkts': '10539296',
                                                                       'mac_address': '04:f1:7d:01:88:39',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22470841269',
                                                                       'out_ucast_pkts': '18234590',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.51382827758789,
                                         'longitude': -107.54873657226562,
                                         'manufacturer': 'Tarana',
                                         'mem': 24.0,
                                         'model': '30-0150-001',
                                         'name': '7904-CED5',
                                         'poller_hash': 'UzE1MEYyMjMwMTIxMjc3',
                                         'serial_number': 'S150F2230121277',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:88:39',
                                         'temperature': 26.964,
                                         'uptime': '335424'},
                                 {       'cpu': 22.78428,
                                         'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '51844262121',
                                                                       'in_ucast_pkts': '40922953',
                                                                       'links': [       {       'in_octets': '51844262121',
                                                                                                'in_ucast_pkts': '40922953',
                                                                                                'out_octets': '3394798411',
                                                                                                'out_ucast_pkts': '17435256',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3394798411',
                                                                       'out_ucast_pkts': '17435256',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.553392,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 144.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '172444',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -85.795685,
                                                                                                                                                     'rx_link_rate': '78433500',
                                                                                                                                                     'tx_link_rate': '39793628'}]}],
                                                                                                 'tx_power': -59},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 0.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 29.251186,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 139.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '172444',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rssi': -81.82978,
                                                                                                                                                     'rx_link_rate': '35080667',
                                                                                                                                                     'tx_link_rate': '26156505'}]}],
                                                                                                 'tx_power': 18}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 24.54049,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 14.144942,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9321',
                                                                       'in_octets': '3394940888',
                                                                       'in_ucast_pkts': '17426670',
                                                                       'mac_address': '04:f1:7d:01:20:4a',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '51901315378',
                                                                       'out_ucast_pkts': '40962312',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.521949768066406,
                                         'longitude': -107.55876159667969,
                                         'manufacturer': 'Tarana',
                                         'mem': 24.0,
                                         'model': '30-0150-001',
                                         'name': '11232-RMX6',
                                         'poller_hash': 'UzE1MEYyMjI0NDAyNjY1',
                                         'serial_number': 'S150F2224402665',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:20:4a',
                                         'temperature': 28.822,
                                         'uptime': '172760'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_3_013_000_00_192_168_10_2(self):
        obj = self.run_data("tarana.tarana.30-0134-001.3.013.000.00.192_168_10_2")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 20,
                'sw_version': '3.013.000.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F2231801669',
                'system_mac_address': '04:f1:7d:03:1c:29',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:02:31:94': {       'dev_macs': ['f0:a7:31:dc:f3:80'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 18609082712,
                                             'dl_rf_packets': 14774672,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:31:94',
                                             'name': 'Betty Renfro',
                                             'serial_number': 'S160M2233401271',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1804510033,
                                             'ul_rf_packets': 6339745},
                '04:f1:7d:02:43:61': {       'dev_macs': ['f0:a7:31:dd:1e:5c'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 45656767152,
                                             'dl_rf_packets': 31831117,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:61',
                                             'name': 'Gene Cummings',
                                             'serial_number': 'S160M2233401787',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 907507166,
                                             'ul_rf_packets': 7119066},
                '04:f1:7d:02:43:62': {       'dev_macs': ['c0:c9:e3:0a:b2:45'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 48906538027,
                                             'dl_rf_packets': 43791990,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:62',
                                             'name': 'Lori Friedrich',
                                             'serial_number': 'S160M2233401796',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 5210494360,
                                             'ul_rf_packets': 35915901},
                '04:f1:7d:02:43:73': {       'dev_macs': ['f0:a7:31:dc:fd:98'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 76535903937,
                                             'dl_rf_packets': 62194123,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:73',
                                             'name': 'Thelma Rojas',
                                             'serial_number': 'S160M2233401269',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 17196379546,
                                             'ul_rf_packets': 39955504},
                '04:f1:7d:02:43:76': {       'dev_macs': ['50:91:e3:aa:04:3c'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 432205185,
                                             'dl_rf_packets': 563100,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:76',
                                             'name': 'Salado Eagle Storage',
                                             'serial_number': 'S160M2233401436',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 551529160,
                                             'ul_rf_packets': 637805},
                '04:f1:7d:02:43:7b': {       'dev_macs': ['b0:95:75:c2:2d:b1'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 31144939967,
                                             'dl_rf_packets': 25606566,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:7b',
                                             'name': 'Angel Gonzalez',
                                             'serial_number': 'S160M2233401803',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2375621322,
                                             'ul_rf_packets': 14825362},
                '04:f1:7d:02:43:ad': {       'dev_macs': ['f0:a7:31:c8:9b:76'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 63241876963,
                                             'dl_rf_packets': 45250861,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:ad',
                                             'name': 'Jon Howell',
                                             'serial_number': 'S160M2233401442',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3413443555,
                                             'ul_rf_packets': 32975312},
                '04:f1:7d:02:43:c7': {       'dev_macs': ['f0:a7:31:dc:f8:94'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 51104198400,
                                             'dl_rf_packets': 39311698,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:c7',
                                             'name': 'Reineer Schelert',
                                             'serial_number': 'S160M2233401744',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2235800404,
                                             'ul_rf_packets': 14071858},
                '04:f1:7d:02:43:ca': {       'dev_macs': ['1c:3b:f3:f3:cb:d8'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 91300192938,
                                             'dl_rf_packets': 69296105,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:ca',
                                             'name': 'Jessica Cloud',
                                             'serial_number': 'S160M2233401752',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 12526226370,
                                             'ul_rf_packets': 54156530},
                '04:f1:7d:02:43:d1': {       'dev_macs': ['a4:2b:b0:08:21:20'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 79664787364,
                                             'dl_rf_packets': 59124297,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:d1',
                                             'name': 'Andrea Beavers',
                                             'serial_number': 'S160M2233401745',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4186677405,
                                             'ul_rf_packets': 26624114},
                '04:f1:7d:02:43:f2': {       'dev_macs': ['f0:a7:31:dc:f5:30'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 444303690,
                                             'dl_rf_packets': 638015,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:43:f2',
                                             'name': 'Madison Slagel',
                                             'serial_number': 'S160M2233401773',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 134087087,
                                             'ul_rf_packets': 515761},
                '04:f1:7d:02:44:04': {       'dev_macs': ['40:ed:00:a9:b1:bc'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 65379973159,
                                             'dl_rf_packets': 51469920,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:04',
                                             'name': 'Kevin Kloesel',
                                             'serial_number': 'S160M2233401437',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6572403309,
                                             'ul_rf_packets': 24606210},
                '04:f1:7d:02:44:08': {       'dev_macs': ['00:5f:67:d4:09:31'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 47049486453,
                                             'dl_rf_packets': 34318505,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:08',
                                             'name': 'Beverly Wallace',
                                             'serial_number': 'S160M2233401462',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3637774940,
                                             'ul_rf_packets': 29098301},
                '04:f1:7d:02:44:15': {       'dev_macs': [       'b0:a7:b9:89:df:78',
                                                                 'b0:a7:b9:89:df:79'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 20181160169,
                                             'dl_rf_packets': 15924470,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:15',
                                             'name': 'Cheri Summers',
                                             'serial_number': 'S160M2233401470',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4943086729,
                                             'ul_rf_packets': 15174150},
                '04:f1:7d:02:44:17': {       'dev_macs': ['40:3f:8c:ad:06:b5'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 67395679024,
                                             'dl_rf_packets': 56476207,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:17',
                                             'name': 'April Wiede',
                                             'serial_number': 'S160M2233401468',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8164138269,
                                             'ul_rf_packets': 35564496},
                '04:f1:7d:02:44:1f': {       'dev_macs': ['54:af:97:80:b0:99'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 34686288306,
                                             'dl_rf_packets': 25765257,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:1f',
                                             'name': 'Philip Mynarcik',
                                             'serial_number': 'S160M2233401449',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1880229716,
                                             'ul_rf_packets': 16190525},
                '04:f1:7d:02:44:24': {       'dev_macs': ['5c:62:8b:eb:c8:a4'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 24472929626,
                                             'dl_rf_packets': 24743872,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:24',
                                             'name': 'Greg Gouveia',
                                             'serial_number': 'S160M2233401482',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 9682040301,
                                             'ul_rf_packets': 19106196},
                '04:f1:7d:02:44:31': {       'dev_macs': ['cc:2d:e0:ca:59:d1'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2527074807,
                                             'dl_rf_packets': 3983759,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:31',
                                             'name': 'Office',
                                             'serial_number': 'S160M2233401483',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 409172350,
                                             'ul_rf_packets': 3199595},
                '04:f1:7d:02:44:32': {       'dev_macs': ['40:ed:00:a9:a6:80'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 62051238,
                                             'dl_rf_packets': 479265,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:32',
                                             'name': 'Sara_Lutz',
                                             'serial_number': 'S160M2233401466',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1136704512,
                                             'ul_rf_packets': 777462},
                '04:f1:7d:02:44:37': {       'dev_macs': ['d8:ec:5e:59:15:09'],
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 7694838807,
                                             'dl_rf_packets': 5437400,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:02:44:37',
                                             'name': 'Sherrie Coblentz',
                                             'serial_number': 'S160M2233401484',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 377573604,
                                             'ul_rf_packets': 3883092}
        }
        exp_ne_msg = {
                'data': {       'cpu': 44.68085,
                                'elevation': 243.608,
                                'gps_sats_tracked': 22,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '117896',
                                                                                       'in_octets': '6572403309',
                                                                                       'in_ucast_pkts': '24606210',
                                                                                       'out_errors': '261452',
                                                                                       'out_octets': '65379973159',
                                                                                       'out_ucast_pkts': '51469920',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDM3MQ=='},
                                                                               {       'in_errors': '64284',
                                                                                       'in_octets': '3637774940',
                                                                                       'in_ucast_pkts': '29098301',
                                                                                       'out_errors': '379029',
                                                                                       'out_octets': '47049486453',
                                                                                       'out_ucast_pkts': '34318505',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDYyMQ=='},
                                                                               {       'in_errors': '95991',
                                                                                       'in_octets': '377573604',
                                                                                       'in_ucast_pkts': '3883092',
                                                                                       'out_errors': '500337',
                                                                                       'out_octets': '7694838807',
                                                                                       'out_ucast_pkts': '5437400',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDg0MQ=='},
                                                                               {       'in_errors': '292856',
                                                                                       'in_octets': '4943086729',
                                                                                       'in_ucast_pkts': '15174150',
                                                                                       'out_errors': '1523870',
                                                                                       'out_octets': '20181160169',
                                                                                       'out_ucast_pkts': '15924470',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDcwMQ=='},
                                                                               {       'in_errors': '172944',
                                                                                       'in_octets': '3413443555',
                                                                                       'in_ucast_pkts': '32975312',
                                                                                       'out_errors': '914282',
                                                                                       'out_octets': '63241876963',
                                                                                       'out_ucast_pkts': '45250861',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDQyMQ=='},
                                                                               {       'in_errors': '680423',
                                                                                       'in_octets': '12526226370',
                                                                                       'in_ucast_pkts': '54156530',
                                                                                       'out_errors': '3090082',
                                                                                       'out_octets': '91300192938',
                                                                                       'out_ucast_pkts': '69296105',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzUyMQ=='},
                                                                               {       'in_errors': '106715',
                                                                                       'in_octets': '9682040301',
                                                                                       'in_ucast_pkts': '19106196',
                                                                                       'out_errors': '396597',
                                                                                       'out_octets': '24472929626',
                                                                                       'out_ucast_pkts': '24743872',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDgyMQ=='},
                                                                               {       'in_errors': '67770',
                                                                                       'in_octets': '2375621322',
                                                                                       'in_ucast_pkts': '14825362',
                                                                                       'out_errors': '620019',
                                                                                       'out_octets': '31144939967',
                                                                                       'out_ucast_pkts': '25606566',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxODAzMQ=='},
                                                                               {       'in_errors': '132204',
                                                                                       'in_octets': '1804510033',
                                                                                       'in_ucast_pkts': '6339745',
                                                                                       'out_errors': '639216',
                                                                                       'out_octets': '18609082712',
                                                                                       'out_ucast_pkts': '14774672',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxMjcxMQ=='},
                                                                               {       'in_errors': '74021',
                                                                                       'in_octets': '1136704512',
                                                                                       'in_ucast_pkts': '777462',
                                                                                       'out_errors': '422781',
                                                                                       'out_octets': '62051238',
                                                                                       'out_ucast_pkts': '479265',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDY2MQ=='},
                                                                               {       'in_errors': '491987',
                                                                                       'in_octets': '17196379546',
                                                                                       'in_ucast_pkts': '39955504',
                                                                                       'out_errors': '2365461',
                                                                                       'out_octets': '76535903937',
                                                                                       'out_ucast_pkts': '62194123',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxMjY5MQ=='},
                                                                               {       'in_errors': '219882',
                                                                                       'in_octets': '907507166',
                                                                                       'in_ucast_pkts': '7119066',
                                                                                       'out_errors': '960472',
                                                                                       'out_octets': '45656767152',
                                                                                       'out_ucast_pkts': '31831117',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzg3MQ=='},
                                                                               {       'in_errors': '159950',
                                                                                       'in_octets': '8164138269',
                                                                                       'in_ucast_pkts': '35564496',
                                                                                       'out_errors': '590294',
                                                                                       'out_octets': '67395679024',
                                                                                       'out_ucast_pkts': '56476207',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDY4MQ=='},
                                                                               {       'in_errors': '24824',
                                                                                       'in_octets': '134087087',
                                                                                       'in_ucast_pkts': '515761',
                                                                                       'out_errors': '264675',
                                                                                       'out_octets': '444303690',
                                                                                       'out_ucast_pkts': '638015',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzczMQ=='},
                                                                               {       'in_errors': '63014',
                                                                                       'in_octets': '409172350',
                                                                                       'in_ucast_pkts': '3199595',
                                                                                       'out_errors': '392376',
                                                                                       'out_octets': '2527074807',
                                                                                       'out_ucast_pkts': '3983759',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDgzMQ=='},
                                                                               {       'in_errors': '92560',
                                                                                       'in_octets': '551529160',
                                                                                       'in_ucast_pkts': '637805',
                                                                                       'out_errors': '396846',
                                                                                       'out_octets': '432205185',
                                                                                       'out_ucast_pkts': '563100',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDM2MQ=='},
                                                                               {       'in_errors': '94485',
                                                                                       'in_octets': '5210494360',
                                                                                       'in_ucast_pkts': '35915901',
                                                                                       'out_errors': '259477',
                                                                                       'out_octets': '48906538027',
                                                                                       'out_ucast_pkts': '43791990',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzk2MQ=='},
                                                                               {       'in_errors': '20634',
                                                                                       'in_octets': '1880229716',
                                                                                       'in_ucast_pkts': '16190525',
                                                                                       'out_errors': '320812',
                                                                                       'out_octets': '34686288306',
                                                                                       'out_ucast_pkts': '25765257',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDQ5MQ=='},
                                                                               {       'in_errors': '209337',
                                                                                       'in_octets': '2235800404',
                                                                                       'in_ucast_pkts': '14071858',
                                                                                       'out_errors': '936365',
                                                                                       'out_octets': '51104198400',
                                                                                       'out_ucast_pkts': '39311698',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzQ0MQ=='},
                                                                               {       'in_errors': '119391',
                                                                                       'in_octets': '4186677405',
                                                                                       'in_ucast_pkts': '26624114',
                                                                                       'out_errors': '243331',
                                                                                       'out_octets': '79664787364',
                                                                                       'out_ucast_pkts': '59124297',
                                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzQ1MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                              'radios': [       {       'admin_up': True,
                                                                                        'azimuth': 45.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5200,
                                                                                        'gps_sync': True,
                                                                                        'id': '0',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 49.11163,
                                                                                        'rx_max_sensitivity_loss': 0.09000015,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '202553',
                                                                                                                                            'distance': 3189,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDM3MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '59731000',
                                                                                                                                            'snr': 25.45886,
                                                                                                                                            'tx_link_rate': '269238000'},
                                                                                                                                    {       'connected_time': '202533',
                                                                                                                                            'distance': 4643,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDYyMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '59992000',
                                                                                                                                            'snr': 25.541775,
                                                                                                                                            'tx_link_rate': '213341000'},
                                                                                                                                    {       'connected_time': '202513',
                                                                                                                                            'distance': 6418,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDg0MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '50567000',
                                                                                                                                            'snr': 22.46172,
                                                                                                                                            'tx_link_rate': '109380000'},
                                                                                                                                    {       'connected_time': '202513',
                                                                                                                                            'distance': 6867,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDcwMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '10885000',
                                                                                                                                            'snr': 15.647611,
                                                                                                                                            'tx_link_rate': '14874000'},
                                                                                                                                    {       'connected_time': '202503',
                                                                                                                                            'distance': 6432,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDQyMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '58565000',
                                                                                                                                            'snr': 25.086384,
                                                                                                                                            'tx_link_rate': '198457000'},
                                                                                                                                    {       'connected_time': '202483',
                                                                                                                                            'distance': 7349,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzUyMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '18470000',
                                                                                                                                            'snr': 14.188763,
                                                                                                                                            'tx_link_rate': '35973000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 1661,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDgyMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '267436000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 3745,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxODAzMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '59714000',
                                                                                                                                            'snr': 25.453444,
                                                                                                                                            'tx_link_rate': '121386000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 5313,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxMjcxMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '41055000',
                                                                                                                                            'snr': 19.16039,
                                                                                                                                            'tx_link_rate': '132361000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 5326,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDY2MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '57226000',
                                                                                                                                            'snr': 24.655529,
                                                                                                                                            'tx_link_rate': '173664000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 3819,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxMjY5MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '48636000',
                                                                                                                                            'snr': 21.80834,
                                                                                                                                            'tx_link_rate': '90751000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 7142,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzg3MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '35289000',
                                                                                                                                            'snr': 17.98298,
                                                                                                                                            'tx_link_rate': '87679000'},
                                                                                                                                    {       'connected_time': '202453',
                                                                                                                                            'distance': 897,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDY4MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '258061000'},
                                                                                                                                    {       'connected_time': '202453',
                                                                                                                                            'distance': 6907,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzczMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '268445000'},
                                                                                                                                    {       'connected_time': '202443',
                                                                                                                                            'distance': 5326,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDgzMQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '55032000',
                                                                                                                                            'snr': 23.942282,
                                                                                                                                            'tx_link_rate': '184179000'},
                                                                                                                                    {       'connected_time': '202443',
                                                                                                                                            'distance': 1078,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDM2MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '59562000',
                                                                                                                                            'snr': 25.404797,
                                                                                                                                            'tx_link_rate': '216326000'},
                                                                                                                                    {       'connected_time': '202433',
                                                                                                                                            'distance': 1045,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzk2MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '267299000'},
                                                                                                                                    {       'connected_time': '202433',
                                                                                                                                            'distance': 7899,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDQ5MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '265793000'},
                                                                                                                                    {       'connected_time': '202393',
                                                                                                                                            'distance': 2351,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzQ0MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '42751000',
                                                                                                                                            'snr': 19.764784,
                                                                                                                                            'tx_link_rate': '132934000'},
                                                                                                                                    {       'connected_time': '202373',
                                                                                                                                            'distance': 2023,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzQ1MQ==',
                                                                                                                                            'rssi': -66.3016,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '269212000'}]}],
                                                                                        'tx_power': 8},
                                                                                {       'admin_up': True,
                                                                                        'azimuth': 45.0,
                                                                                        'chan_width': 40,
                                                                                        'dl_percent': 82,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5750,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'oper_up': True,
                                                                                        'rx_max_interference_noise_ratio': 24.809399,
                                                                                        'rx_max_sensitivity_loss': 0.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '202553',
                                                                                                                                            'distance': 3189,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDM3MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '269618000'},
                                                                                                                                    {       'connected_time': '202533',
                                                                                                                                            'distance': 4643,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDYyMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '235478000'},
                                                                                                                                    {       'connected_time': '202513',
                                                                                                                                            'distance': 6418,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDg0MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '59208000',
                                                                                                                                            'snr': 25.292126,
                                                                                                                                            'tx_link_rate': '173961000'},
                                                                                                                                    {       'connected_time': '202513',
                                                                                                                                            'distance': 6867,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDcwMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '1910000',
                                                                                                                                            'snr': 7.0675774,
                                                                                                                                            'tx_link_rate': '3287000'},
                                                                                                                                    {       'connected_time': '202503',
                                                                                                                                            'distance': 6432,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDQyMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '59931000',
                                                                                                                                            'snr': 25.522423,
                                                                                                                                            'tx_link_rate': '119659000'},
                                                                                                                                    {       'connected_time': '202483',
                                                                                                                                            'distance': 7349,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzUyMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '4048000',
                                                                                                                                            'snr': 7.490817,
                                                                                                                                            'tx_link_rate': '8506000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 1661,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDgyMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '266603000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 3745,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxODAzMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '178647000'},
                                                                                                                                    {       'connected_time': '202473',
                                                                                                                                            'distance': 5313,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxMjcxMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '51117000',
                                                                                                                                            'snr': 22.646048,
                                                                                                                                            'tx_link_rate': '129690000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 5326,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDY2MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60034000',
                                                                                                                                            'snr': 25.555233,
                                                                                                                                            'tx_link_rate': '186785000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 3819,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxMjY5MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '51040000',
                                                                                                                                            'snr': 22.620197,
                                                                                                                                            'tx_link_rate': '94863000'},
                                                                                                                                    {       'connected_time': '202463',
                                                                                                                                            'distance': 7142,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzg3MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '32288000',
                                                                                                                                            'snr': 15.910826,
                                                                                                                                            'tx_link_rate': '104463000'},
                                                                                                                                    {       'connected_time': '202453',
                                                                                                                                            'distance': 897,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDY4MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '267696000'},
                                                                                                                                    {       'connected_time': '202453',
                                                                                                                                            'distance': 6907,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzczMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '263466000'},
                                                                                                                                    {       'connected_time': '202443',
                                                                                                                                            'distance': 5326,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDgzMQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '59969000',
                                                                                                                                            'snr': 25.534645,
                                                                                                                                            'tx_link_rate': '190390000'},
                                                                                                                                    {       'connected_time': '202443',
                                                                                                                                            'distance': 1078,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDM2MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '45377000',
                                                                                                                                            'snr': 20.686825,
                                                                                                                                            'tx_link_rate': '156953000'},
                                                                                                                                    {       'connected_time': '202433',
                                                                                                                                            'distance': 1045,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzk2MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '267509000'},
                                                                                                                                    {       'connected_time': '202433',
                                                                                                                                            'distance': 7899,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNDQ5MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '228964000'},
                                                                                                                                    {       'connected_time': '202393',
                                                                                                                                            'distance': 2351,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzQ0MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '48518000',
                                                                                                                                            'snr': 21.76789,
                                                                                                                                            'tx_link_rate': '137761000'},
                                                                                                                                    {       'connected_time': '202373',
                                                                                                                                            'distance': 2023,
                                                                                                                                            'poller_hash': 'UzE2ME0yMjMzNDAxNzQ1MQ==',
                                                                                                                                            'rssi': -74.01189,
                                                                                                                                            'rx_link_rate': '60040000',
                                                                                                                                            'snr': 25.556976,
                                                                                                                                            'tx_link_rate': '269619000'}]}],
                                                                                        'tx_power': 4}],
                                                              'rf_aggregation_groups': [       {       'airtime': 4.214015,
                                                                                                       'name': 'rf_group'}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '1192',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '909981',
                                                              'in_octets': '776887058415',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '63965',
                                                              'out_octets': '96193761568',
                                                              'poller_hash': 'UzEzNEYyMjMxODAxNjY5Z2kx',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjMxODAxNjY5ZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjMxODAxNjY5ZXgx'}],
                                'latitude': 30.941896438598633,
                                'longitude': -97.48981475830078,
                                'manufacturer': 'Tarana',
                                'mem': 37.0,
                                'model': '30-0134-001',
                                'name': 'Tarana NW',
                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5',
                                'serial_number': 'S134F2231801669',
                                'sw_version': '3.013.000.00',
                                'system_mac_address': '04:f1:7d:03:1c:29',
                                'temperature': 57.375,
                                'uptime': '202932'},
                'peers': [       {       'cpu': 21.777222,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '65379973159',
                                                                       'in_ucast_pkts': '51469920',
                                                                       'links': [       {       'in_octets': '65379973159',
                                                                                                'in_ucast_pkts': '51469920',
                                                                                                'out_octets': '6572403309',
                                                                                                'out_ucast_pkts': '24606210',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6572403309',
                                                                       'out_ucast_pkts': '24606210',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDM3MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 218.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 34.14121,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 125.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202553',
                                                                                                                                                     'distance': 3189,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -78.13507,
                                                                                                                                                     'rx_link_rate': '269238000',
                                                                                                                                                     'snr': 25.490358,
                                                                                                                                                     'tx_link_rate': '59731000'}]}],
                                                                                                 'tx_power': 4},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 218.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 8.196347,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 123.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202553',
                                                                                                                                                     'distance': 3189,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -81.86475,
                                                                                                                                                     'rx_link_rate': '269618000',
                                                                                                                                                     'snr': 25.517262,
                                                                                                                                                     'tx_link_rate': '60040000'}]}],
                                                                                                 'tx_power': -51}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.497116,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 8.362617,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ed:00:a9:b1:bc'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1344',
                                                                       'in_octets': '6587720085',
                                                                       'in_ucast_pkts': '24757101',
                                                                       'mac_address': '04:f1:7d:02:44:04',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '65398218786',
                                                                       'out_ucast_pkts': '51654637',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDM3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.964746475219727,
                                         'longitude': -97.4699478149414,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Kevin Kloesel',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDM3',
                                         'serial_number': 'S160M2233401437',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:44:04',
                                         'temperature': 36.37,
                                         'uptime': '204231'},
                                 {       'cpu': 22.981367,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '47049486453',
                                                                       'in_ucast_pkts': '34318505',
                                                                       'links': [       {       'in_octets': '47049486453',
                                                                                                'in_ucast_pkts': '34318505',
                                                                                                'out_octets': '3637774940',
                                                                                                'out_ucast_pkts': '29098301',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3637774940',
                                                                       'out_ucast_pkts': '29098301',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDYyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 178.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 35.979343,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 134.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202533',
                                                                                                                                                     'distance': 4643,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -85.8309,
                                                                                                                                                     'rx_link_rate': '213341000',
                                                                                                                                                     'snr': 21.388742,
                                                                                                                                                     'tx_link_rate': '59992000'}]}],
                                                                                                 'tx_power': 12},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 178.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 16.180826,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202533',
                                                                                                                                                     'distance': 4643,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -85.859955,
                                                                                                                                                     'rx_link_rate': '235478000',
                                                                                                                                                     'snr': 23.050488,
                                                                                                                                                     'tx_link_rate': '60040000'}]}],
                                                                                                 'tx_power': -51}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 21.376747,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 8.710785,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:5f:67:d4:09:31'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '552',
                                                                       'in_octets': '3638761422',
                                                                       'in_ucast_pkts': '29102903',
                                                                       'mac_address': '04:f1:7d:02:44:08',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '46913981633',
                                                                       'out_ucast_pkts': '34322173',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDYyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.983604431152344,
                                         'longitude': -97.49134063720703,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Beverly Wallace',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDYy',
                                         'serial_number': 'S160M2233401462',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:44:08',
                                         'temperature': 34.744,
                                         'uptime': '204171'},
                                 {       'cpu': 21.60804,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '7694838807',
                                                                       'in_ucast_pkts': '5437400',
                                                                       'links': [       {       'in_octets': '7694838807',
                                                                                                'in_ucast_pkts': '5437400',
                                                                                                'out_octets': '377573604',
                                                                                                'out_ucast_pkts': '3883092',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '377573604',
                                                                       'out_ucast_pkts': '3883092',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDg0MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 226.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 55.991154,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 132.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202513',
                                                                                                                                                     'distance': 6418,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -73.77073,
                                                                                                                                                     'rx_link_rate': '109380000',
                                                                                                                                                     'snr': 12.739849,
                                                                                                                                                     'tx_link_rate': '50567000'}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 226.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 47.10843,
                                                                                                 'rx_max_sensitivity_loss': 0.119999886,
                                                                                                 'rx_path_loss': 132.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202513',
                                                                                                                                                     'distance': 6418,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -77.288124,
                                                                                                                                                     'rx_link_rate': '173961000',
                                                                                                                                                     'snr': 18.293259,
                                                                                                                                                     'tx_link_rate': '59208000'}]}],
                                                                                                 'tx_power': 11}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 23.289284,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 24.167984,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:ec:5e:59:15:09'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '692',
                                                                       'in_octets': '378029646',
                                                                       'in_ucast_pkts': '3884466',
                                                                       'mac_address': '04:f1:7d:02:44:37',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '7674241694',
                                                                       'out_ucast_pkts': '5439036',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDg0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.981624603271484,
                                         'longitude': -97.44132232666016,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Sherrie Coblentz',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDg0',
                                         'serial_number': 'S160M2233401484',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:44:37',
                                         'temperature': 35.325,
                                         'uptime': '204171'},
                                 {       'cpu': 22.027534,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '20181160169',
                                                                       'in_ucast_pkts': '15924470',
                                                                       'links': [       {       'in_octets': '20181160169',
                                                                                                'in_ucast_pkts': '15924470',
                                                                                                'out_octets': '4943086729',
                                                                                                'out_ucast_pkts': '15174150',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4943086729',
                                                                       'out_ucast_pkts': '15174150',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDcwMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 153.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 32.079678,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 147.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202513',
                                                                                                                                                     'distance': 6867,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -86.96848,
                                                                                                                                                     'rx_link_rate': '14874000',
                                                                                                                                                     'snr': 6.167854,
                                                                                                                                                     'tx_link_rate': '10885000'}]}],
                                                                                                 'tx_power': 24},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 153.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 30.889734,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202513',
                                                                                                                                                     'distance': 6867,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -86.037094,
                                                                                                                                                     'rx_link_rate': '3287000',
                                                                                                                                                     'snr': 3.4954839,
                                                                                                                                                     'tx_link_rate': '1910000'}]}],
                                                                                                 'tx_power': -51}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 26.559183,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 18.234991,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b0:a7:b9:89:df:78',
                                                                                                        'b0:a7:b9:89:df:79'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14135',
                                                                       'in_octets': '5022116808',
                                                                       'in_ucast_pkts': '15234244',
                                                                       'mac_address': '04:f1:7d:02:44:15',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '20142119412',
                                                                       'out_ucast_pkts': '15947008',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDcwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.997055053710938,
                                         'longitude': -97.52204132080078,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Cheri Summers',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDcw',
                                         'serial_number': 'S160M2233401470',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:44:15',
                                         'temperature': 36.196,
                                         'uptime': '204175'},
                                 {       'cpu': 21.098627,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '63241876963',
                                                                       'in_ucast_pkts': '45250861',
                                                                       'links': [       {       'in_octets': '63241876963',
                                                                                                'in_ucast_pkts': '45250861',
                                                                                                'out_octets': '3413443555',
                                                                                                'out_ucast_pkts': '32975312',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3413443555',
                                                                       'out_ucast_pkts': '32975312',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDQyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 227.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 38.09923,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202503',
                                                                                                                                                     'distance': 6432,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -76.023,
                                                                                                                                                     'rx_link_rate': '198457000',
                                                                                                                                                     'snr': 20.2407,
                                                                                                                                                     'tx_link_rate': '58565000'}]}],
                                                                                                 'tx_power': 19},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 227.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 40.223125,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 131.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202503',
                                                                                                                                                     'distance': 6432,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -80.6814,
                                                                                                                                                     'rx_link_rate': '119659000',
                                                                                                                                                     'snr': 13.670544,
                                                                                                                                                     'tx_link_rate': '59931000'}]}],
                                                                                                 'tx_power': -51}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 20.943989,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 25.249147,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f0:a7:31:c8:9b:76'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '597',
                                                                       'in_octets': '3420376724',
                                                                       'in_ucast_pkts': '33051544',
                                                                       'mac_address': '04:f1:7d:02:43:ad',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '63126419074',
                                                                       'out_ucast_pkts': '45325063',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDQyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.981435775756836,
                                         'longitude': -97.44081115722656,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0160-001',
                                         'name': 'Jon Howell',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDQy',
                                         'serial_number': 'S160M2233401442',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:43:ad',
                                         'temperature': 34.802,
                                         'uptime': '204180'},
                                 {       'cpu': 21.383648,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '91300192938',
                                                                       'in_ucast_pkts': '69296105',
                                                                       'links': [       {       'in_octets': '91300192938',
                                                                                                'in_ucast_pkts': '69296105',
                                                                                                'out_octets': '12526226370',
                                                                                                'out_ucast_pkts': '54156530',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '12526226370',
                                                                       'out_ucast_pkts': '54156530',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzUyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 156.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 39.85472,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 148.5,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202483',
                                                                                                                                                     'distance': 7349,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -87.49845,
                                                                                                                                                     'rx_link_rate': '35973000',
                                                                                                                                                     'snr': 7.3479023,
                                                                                                                                                     'tx_link_rate': '18470000'}]}],
                                                                                                 'tx_power': 24},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 156.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 28.958433,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 146.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202483',
                                                                                                                                                     'distance': 7349,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -88.006996,
                                                                                                                                                     'rx_link_rate': '8506000',
                                                                                                                                                     'snr': 4.2274413,
                                                                                                                                                     'tx_link_rate': '4048000'}]}],
                                                                                                 'tx_power': -51}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 32.70837,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 28.839268,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:3b:f3:f3:cb:d8'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14829',
                                                                       'in_octets': '12536637496',
                                                                       'in_ucast_pkts': '54174826',
                                                                       'mac_address': '04:f1:7d:02:43:ca',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '91053021308',
                                                                       'out_ucast_pkts': '69323972',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNzUyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 31.002309799194336,
                                         'longitude': -97.52086639404297,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Jessica Cloud',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNzUy',
                                         'serial_number': 'S160M2233401752',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:43:ca',
                                         'temperature': 35.789,
                                         'uptime': '204175'},
                                 {       'cpu': 21.446384,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '24472929626',
                                                                       'in_ucast_pkts': '24743872',
                                                                       'links': [       {       'in_octets': '24472929626',
                                                                                                'in_ucast_pkts': '24743872',
                                                                                                'out_octets': '9682040301',
                                                                                                'out_ucast_pkts': '19106196',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9682040301',
                                                                       'out_ucast_pkts': '19106196',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDgyMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 236.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 49.588684,
                                                                                                 'rx_max_sensitivity_loss': 0.42000008,
                                                                                                 'rx_path_loss': 119.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 1661,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -72.54392,
                                                                                                                                                     'rx_link_rate': '267436000',
                                                                                                                                                     'snr': 25.362797,
                                                                                                                                                     'tx_link_rate': '60040000'}]}],
                                                                                                 'tx_power': 1},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 236.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 51.330914,
                                                                                                 'rx_max_sensitivity_loss': 0.9299998,
                                                                                                 'rx_path_loss': 119.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 1661,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -74.740135,
                                                                                                                                                     'rx_link_rate': '266603000',
                                                                                                                                                     'snr': 25.30373,
                                                                                                                                                     'tx_link_rate': '60040000'}]}],
                                                                                                 'tx_power': -54}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 20.55292,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 44.335464,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '5c:62:8b:eb:c8:a4'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '552',
                                                                       'in_octets': '9687459308',
                                                                       'in_ucast_pkts': '19187843',
                                                                       'mac_address': '04:f1:7d:02:44:24',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '24458647191',
                                                                       'out_ucast_pkts': '24829886',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDgyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.9503116607666,
                                         'longitude': -97.47564697265625,
                                         'manufacturer': 'Tarana',
                                         'mem': 27.0,
                                         'model': '30-0160-001',
                                         'name': 'Greg Gouveia',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxNDgy',
                                         'serial_number': 'S160M2233401482',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:44:24',
                                         'temperature': 34.396,
                                         'uptime': '204174'},
                                 {       'cpu': 21.204517,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '31144939967',
                                                                       'in_ucast_pkts': '25606566',
                                                                       'links': [       {       'in_octets': '31144939967',
                                                                                                'in_ucast_pkts': '25606566',
                                                                                                'out_octets': '2375621322',
                                                                                                'out_ucast_pkts': '14825362',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2375621322',
                                                                       'out_ucast_pkts': '14825362',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxODAzMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 232.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 42.13814,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 133.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 3745,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -76.95445,
                                                                                                                                                     'rx_link_rate': '121386000',
                                                                                                                                                     'snr': 13.825135,
                                                                                                                                                     'tx_link_rate': '59714000'}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 232.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 28.188864,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 136.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 3745,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -89.2985,
                                                                                                                                                     'rx_link_rate': '178647000',
                                                                                                                                                     'snr': 18.67169,
                                                                                                                                                     'tx_link_rate': '60040000'}]}],
                                                                                                 'tx_power': 16}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 18.937428,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 18.302572,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b0:95:75:c2:2d:b1'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '558',
                                                                       'in_octets': '2396844793',
                                                                       'in_ucast_pkts': '14885153',
                                                                       'mac_address': '04:f1:7d:02:43:7b',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '31267290195',
                                                                       'out_ucast_pkts': '25785957',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxODAzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.96251678466797,
                                         'longitude': -97.45895385742188,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Angel Gonzalez',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxODAz',
                                         'serial_number': 'S160M2233401803',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:43:7b',
                                         'temperature': 34.222,
                                         'uptime': '204181'},
                                 {       'cpu': 21.722847,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '18609082712',
                                                                       'in_ucast_pkts': '14774672',
                                                                       'links': [       {       'in_octets': '18609082712',
                                                                                                'in_ucast_pkts': '14774672',
                                                                                                'out_octets': '1804510033',
                                                                                                'out_ucast_pkts': '6339745',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1804510033',
                                                                       'out_ucast_pkts': '6339745',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxMjcxMQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 174.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 23.364304,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 5313,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -89.840065,
                                                                                                                                                     'rx_link_rate': '132361000',
                                                                                                                                                     'snr': 14.794248,
                                                                                                                                                     'tx_link_rate': '41055000'}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 174.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 18.196764,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 140.0,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202473',
                                                                                                                                                     'distance': 5313,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -88.680595,
                                                                                                                                                     'rx_link_rate': '129690000',
                                                                                                                                                     'snr': 14.560255,
                                                                                                                                                     'tx_link_rate': '51117000'}]}],
                                                                                                 'tx_power': 25}],
                                                                       'rf_aggregation_groups': [       {       'name': 'peer_rf_group',
                                                                                                                'rx_interference_signal_ratio': 22.725395,
                                                                                                                'rx_packet_error_rate': 0.0,
                                                                                                                'tx_interference_signal_ratio': 8.640324,
                                                                                                                'tx_packet_error_rate': 0.0}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f0:a7:31:dc:f3:80'],
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '719',
                                                                       'in_octets': '1803710717',
                                                                       'in_ucast_pkts': '6336176',
                                                                       'mac_address': '04:f1:7d:02:31:94',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '18507564383',
                                                                       'out_ucast_pkts': '14740423',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxMjcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.989322662353516,
                                         'longitude': -97.4959945678711,
                                         'manufacturer': 'Tarana',
                                         'mem': 26.0,
                                         'model': '30-0160-001',
                                         'name': 'Betty Renfro',
                                         'poller_hash': 'UzE2ME0yMjMzNDAxMjcx',
                                         'serial_number': 'S160M2233401271',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.013.000.00',
                                         'system_mac_address': '04:f1:7d:02:31:94',
                                         'temperature': 35.905,
                                         'uptime': '204181'},
                                 {       'cpu': 22.014925,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '62051238',
                                                                       'in_ucast_pkts': '479265',
                                                                       'links': [       {       'in_octets': '62051238',
                                                                                                'in_ucast_pkts': '479265',
                                                                                                'out_octets': '1136704512',
                                                                                                'out_ucast_pkts': '777462',
                                                                                                'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1136704512',
                                                                       'out_ucast_pkts': '777462',
                                                                       'poller_hash': 'UzE2ME0yMjMzNDAxNDY2MQ==',
                                                                       'radios': [       {       'admin_up': True,
                                                                                                 'azimuth': 80.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5200,
                                                                                                 'id': '0',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 24.348495,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 137.75,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202463',
                                                                                                                                                     'distance': 5326,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -88.44661,
                                                                                                                                                     'rx_link_rate': '173664000',
                                                                                                                                                     'snr': 18.269146,
                                                                                                                                                     'tx_link_rate': '57226000'}]}],
                                                                                                 'tx_power': -53},
                                                                                         {       'admin_up': True,
                                                                                                 'azimuth': 80.0,
                                                                                                 'chan_width': 40,
                                                                                                 'dl_percent': 82,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'oper_up': True,
                                                                                                 'rx_max_interference_noise_ratio': 9.447879,
                                                                                                 'rx_max_sensitivity_loss': 0.0,
                                                                                                 'rx_path_loss': 135.25,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '202463',
                                                                                                                                                     'distance': 5326,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjMxODAxNjY5d2wx',
                                                                                                                                                     'rssi': -86.44518,
                                                                                                                                                     'rx_link_rate': '186785000',
                                                                                                                                                     'snr': 19.322453,
                                                                                                                                                     'tx_link_rate': '60034000'}]}],
                                     