import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestTachyon(DeviceTestCase):
    def test_tachyon_tna30x_TNA_301_1_11_5_rev_54369_01(self):
        obj = self.run_data("tachyon.tna30x.TNA-301.1.11.5 rev 54369.01")
        exp_info = {
         'model': 'TNA-301', 'sw_version': '1.11.5 rev 54369', 'vendor': 'Tachyon'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '78:5e:e8:d0:49:1c': {       'dev_macs': [       '48:a9:8a:9b:e6:b6',
                                                                 '78:5e:e8:d0:49:1a'],
                                             'ip_address': '10.167.233.3',
                                             'mac_address': '78:5e:e8:d0:49:1c',
                                             'name': 'Matt Larsen'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_errors': '0',
                                                              'in_octets': '2757702401962',
                                                              'in_ucast_pkts': '3109593478',
                                                              'mac_address': '78:5e:e8:d0:2b:97',
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '258490110326',
                                                              'out_ucast_pkts': '844958230',
                                                              'poller_hash': 'Nzg6NWU6ZTg6ZDA6MmI6OTcuZXRoMA==',
                                                              'speed': '2500000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_errors': '0',
                                                              'out_octets': '56047952794',
                                                              'out_ucast_pkts': '774543317',
                                                              'poller_hash': 'Nzg6NWU6ZTg6ZDA6MmI6OTcuZXRoMQ==',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'links': [       {       'bridged_mac_addresses': [       '48:a9:8a:9b:e6:b6',
                                                                                                                        '78:5e:e8:d0:49:1a'],
                                                                                       'in_octets': '219569430279',
                                                                                       'in_ucast_pkts': '778255398',
                                                                                       'mac_address': '78:5e:e8:d0:49:1c',
                                                                                       'out_octets': '2651816046113',
                                                                                       'out_ucast_pkts': '2887435973'}],
                                                              'mac_address': '78:5e:e8:d0:2b:99',
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': 'wlan0',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '332837',
                                                                                                                                            'distance': 259,
                                                                                                                                            'mac_address': '78:5e:e8:d0:49:1c',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_link_rate': '2502000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 40}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'VISTABEAM.COM-SCC1'}]}],
                                'manufacturer': 'Tachyon',
                                'mem': 66.0,
                                'model': 'TNA-301',
                                'name': 'SBCOUNTRYCLUB-SCC1',
                                'poller_hash': 'Nzg6NUU6RTg6RDA6MkI6OTk=',
                                'serial_number': 'TNA3011322300094',
                                'sw_version': '1.11.5 rev 54369',
                                'system_mac_address': '78:5e:e8:d0:2b:97',
                                'temperature': 8.0,
                                'uptime': '9059616'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '2651816046113',
                                                                       'in_ucast_pkts': '2887435973',
                                                                       'links': [       {       'in_octets': '2651816046113',
                                                                                                'in_ucast_pkts': '2887435973',
                                                                                                'mac_address': '78:5e:e8:d0:2b:99',
                                                                                                'out_octets': '219569430279',
                                                                                                'out_ucast_pkts': '778255398'}],
                                                                       'mac_address': '78:5e:e8:d0:49:1c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '219569430279',
                                                                       'out_ucast_pkts': '778255398',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': 'wlan0',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '332837',
                                                                                                                                                     'distance': 259,
                                                                                                                                                     'mac_address': '78:5e:e8:d0:2b:99',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 15.0,
                                                                                                                                                     'tx_link_rate': '2502000000',
                                                                                                                                                     'tx_mcs': 10}]}],
                                                                                                 'tx_power': 40}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VISTABEAM.COM-SCC1'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'Ethernet',
                                                                       'in_octets': '219569430279',
                                                                       'in_ucast_pkts': '778255398',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_octets': '2651816046113',
                                                                       'out_ucast_pkts': '2887435973',
                                                                       'poller_hash': 'Nzg6NUU6RTg6RDA6NDk6MUNFdGhlcm5ldA=='}],
                                         'management_ip': '10.167.233.3',
                                         'manufacturer': 'Tachyon',
                                         'name': 'Matt Larsen',
                                         'poller_hash': 'Nzg6NUU6RTg6RDA6NDk6MUM=',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tachyon_tna30x_TNA_303X_1_12_0_rev_54564_01(self):
        obj = self.run_data("tachyon.tna30x.TNA-303X.1.12.0 rev 54564.01")
        exp_info = {
         'model': 'TNA-303X', 'sw_version': '1.12.0 rev 54564', 'vendor': 'Tachyon'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '78:5e:e8:d0:5a:1a': {       'dev_macs': [       '84:d3:43:0f:95:42',
                                                                 '78:5e:e8:d0:5a:18'],
                                             'ip_address': '100.93.22.46',
                                             'mac_address': '78:5e:e8:d0:5a:1a',
                                             'name': '12233_Terrazas_Irving'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_errors': '0',
                                                              'in_octets': '1652869174750',
                                                              'in_ucast_pkts': '1239825908',
                                                              'mac_address': '78:5e:e8:d0:57:ea',
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '79027620863',
                                                              'out_ucast_pkts': '525144806',
                                                              'poller_hash': 'Nzg6NWU6ZTg6ZDA6NTc6ZWEuZXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_errors': '0',
                                                              'out_octets': '4659095690',
                                                              'out_ucast_pkts': '56980506',
                                                              'poller_hash': 'Nzg6NWU6ZTg6ZDA6NTc6ZWEuZXRoMQ==',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'links': [       {       'bridged_mac_addresses': [       '84:d3:43:0f:95:42',
                                                                                                                        '78:5e:e8:d0:5a:18'],
                                                                                       'in_octets': '68786282890',
                                                                                       'in_ucast_pkts': '1235129095',
                                                                                       'mac_address': '78:5e:e8:d0:5a:1a',
                                                                                       'out_octets': '1679744204356',
                                                                                       'out_ucast_pkts': '517699737'}],
                                                              'mac_address': '78:5e:e8:d0:57:ec',
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 69120,
                                                                                        'id': 'wlan0',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '4812289',
                                                                                                                                            'distance': 601,
                                                                                                                                            'mac_address': '78:5e:e8:d0:5a:1a',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '2502000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '2502000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 51}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'DOT2-AP-303X-S'}]}],
                                'manufacturer': 'Tachyon',
                                'mem': 50.0,
                                'model': 'TNA-303X',
                                'name': 'DOT2-AP-303X-S',
                                'poller_hash': 'Nzg6NUU6RTg6RDA6NTc6RUM=',
                                'serial_number': 'TNA3031242400113',
                                'sw_version': '1.12.0 rev 54564',
                                'system_mac_address': '78:5e:e8:d0:57:ea',
                                'temperature': 17.0,
                                'uptime': '4812314'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '1679744204356',
                                                                       'in_ucast_pkts': '517699737',
                                                                       'links': [       {       'in_octets': '1679744204356',
                                                                                                'in_ucast_pkts': '517699737',
                                                                                                'mac_address': '78:5e:e8:d0:57:ec',
                                                                                                'out_octets': '68786282890',
                                                                                                'out_ucast_pkts': '1235129095'}],
                                                                       'mac_address': '78:5e:e8:d0:5a:1a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '68786282890',
                                                                       'out_ucast_pkts': '1235129095',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': 'wlan0',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4812289',
                                                                                                                                                     'distance': 601,
                                                                                                                                                     'mac_address': '78:5e:e8:d0:57:ec',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '2502000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_power': 51}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'DOT2-AP-303X-S'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'Ethernet',
                                                                       'in_octets': '68786282890',
                                                                       'in_ucast_pkts': '1235129095',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_octets': '1679744204356',
                                                                       'out_ucast_pkts': '517699737',
                                                                       'poller_hash': 'Nzg6NUU6RTg6RDA6NUE6MUFFdGhlcm5ldA=='}],
                                         'management_ip': '100.93.22.46',
                                         'manufacturer': 'Tachyon',
                                         'model': 'TNA-303X',
                                         'name': '12233_Terrazas_Irving',
                                         'poller_hash': 'Nzg6NUU6RTg6RDA6NUE6MUE=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '1.12.0.r54564'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tachyon_tna30x_TNA_303X_1_12_0_rev_54573_1(self):
        obj = self.run_data("tachyon.tna30x.TNA-303X.1.12.0 rev 54573.1")
        exp_info = {
         'model': 'TNA-303X', 'sw_version': '1.12.0 rev 54573', 'vendor': 'Tachyon'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
