import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestBdcomModels(DeviceTestCase):
    def test_bdcom_p3600_P3600_16E_10_1_0G_Build_104155_01(self):
        obj = self.run_data("bdcom.p3600.P3600-16E.10.1.0G Build 104155.01")
        exp_info = {
                'model': 'P3600-16E',
                'sta_count': 25,
                'sw_version': '10.1.0G Build 104155',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '0000329000586'
        }
        exp_sta_stats = {
                '30:68:93:52:47:e8': {       'dev_macs': ['30:68:93:52:47:eb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:47:e8',
                                             'name': 'EPON0/3:2',
                                             'serial_number': None},
                '30:68:93:52:54:d8': {       'dev_macs': ['30:68:93:52:54:db'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:54:d8',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '30:68:93:b2:04:b0': {       'dev_macs': ['30:68:93:b2:04:b3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:04:b0',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '3c:64:cf:a4:16:50': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:16:50',
                                             'name': 'EPON0/2:9',
                                             'serial_number': None},
                '4c:d7:c8:61:9e:78': {       'dev_macs': ['4c:d7:c8:61:9e:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:9e:78',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '4c:d7:c8:61:ec:c8': {       'dev_macs': ['4c:d7:c8:61:ec:c9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:ec:c8',
                                             'name': 'EPON0/3:1',
                                             'serial_number': None},
                '4c:d7:c8:63:32:b8': {       'dev_macs': ['4c:d7:c8:63:32:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:32:b8',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                '4c:d7:c8:64:0c:78': {       'dev_macs': ['4c:d7:c8:64:0c:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:0c:78',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '6c:68:a4:2d:bf:a6': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2d:bf:a6',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '6c:68:a4:7a:f9:52': {       'dev_macs': ['6c:68:a4:7a:f9:53'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7a:f9:52',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '6c:68:a4:7a:fa:02': {       'dev_macs': ['6c:68:a4:7a:fa:03'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7a:fa:02',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '6c:68:a4:7b:8f:a2': {       'dev_macs': ['6c:68:a4:7b:8f:a3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:8f:a2',
                                             'name': 'EPON0/2:1',
                                             'serial_number': None},
                '6c:68:a4:b1:13:48': {       'dev_macs': ['6c:68:a4:b1:13:49'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b1:13:48',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '6c:68:a4:ed:9a:90': {       'dev_macs': ['6c:68:a4:ed:9a:91'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ed:9a:90',
                                             'name': 'EPON0/4:1',
                                             'serial_number': None},
                '6c:68:a4:ee:5d:a0': {       'dev_macs': ['6c:68:a4:ee:5d:a1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:5d:a0',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '8c:90:2d:57:3e:a8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:3e:a8',
                                             'name': 'EPON0/2:6',
                                             'serial_number': None},
                '8c:90:2d:57:40:00': {       'dev_macs': ['8c:90:2d:57:40:03'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:40:00',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '8c:90:2d:57:90:50': {       'dev_macs': ['8c:90:2d:57:90:53'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:90:50',
                                             'name': 'EPON0/1:11',
                                             'serial_number': None},
                '98:ba:5f:2a:23:b8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:23:b8',
                                             'name': 'EPON0/1:9',
                                             'serial_number': None},
                '98:ba:5f:2a:38:40': {       'dev_macs': ['98:ba:5f:2a:38:43'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:38:40',
                                             'name': 'EPON0/1:8',
                                             'serial_number': None},
                '98:ba:5f:2a:38:60': {       'dev_macs': ['98:ba:5f:2a:38:63'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:38:60',
                                             'name': 'EPON0/1:10',
                                             'serial_number': None},
                'e0:d3:62:41:f3:20': {       'dev_macs': ['e0:d3:62:41:f3:23'],
                                             'ip_address': None,
                                             'mac_address': 'e0:d3:62:41:f3:20',
                                             'name': 'EPON0/7:1',
                                             'serial_number': None},
                'e0:d3:62:42:e2:00': {       'dev_macs': ['e0:d3:62:42:e2:03'],
                                             'ip_address': None,
                                             'mac_address': 'e0:d3:62:42:e2:00',
                                             'name': 'EPON0/1:12',
                                             'serial_number': None},
                'ec:75:0c:1f:ac:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:ac:88',
                                             'name': 'EPON0/2:11',
                                             'serial_number': None},
                'ec:75:0c:20:2f:f0': {       'dev_macs': ['ec:75:0c:20:2f:f3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:2f:f0',
                                             'name': 'EPON0/2:7',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 22.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'GigaEthernet0/1',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:bc',
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YmNpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/2',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:bd',
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YmRpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/3',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:be',
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YmVpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/4',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:bf',
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YmZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c0',
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzBpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/6',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c1',
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzFpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/7',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c2',
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzJpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c3',
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzNpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/1',
                                                              'in_octets': '752166201498',
                                                              'in_ucast_pkts': '573743481',
                                                              'mac_address': '00:55:b1:cf:3a:c4',
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': True,
                                                              'out_octets': '46378394848',
                                                              'out_ucast_pkts': '193234028',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzRpbnRm',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/2',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c5',
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzVpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/3',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c6',
                                                              'name': 'TGigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/4',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c7',
                                                              'name': 'TGigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzdpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c8',
                                                              'name': 'TGigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzhpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/6',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:c9',
                                                              'name': 'TGigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6YzlpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/1',
                                                              'in_octets': '13103042481',
                                                              'in_ucast_pkts': '59445389',
                                                              'links': [       {       'oper_up': False,
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7a:fa:03'],
                                                                                       'in_octets': '2136869781',
                                                                                       'in_ucast_pkts': '10677217',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '86622406999',
                                                                                       'out_ucast_pkts': '62652644',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b1:13:49'],
                                                                                       'in_octets': '1045590247',
                                                                                       'in_ucast_pkts': '3047542',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10603340923',
                                                                                       'out_ucast_pkts': '8711317',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:5d:a1'],
                                                                                       'in_octets': '5137559363',
                                                                                       'in_ucast_pkts': '25517113',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '76675610779',
                                                                                       'out_ucast_pkts': '59268600',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:9e:79'],
                                                                                       'in_octets': '2307175217',
                                                                                       'in_ucast_pkts': '10685282',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '38543853073',
                                                                                       'out_ucast_pkts': '30845925',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:38:43'],
                                                                                       'in_octets': '26802995',
                                                                                       'in_ucast_pkts': '185873',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23111605',
                                                                                       'out_ucast_pkts': '117159',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:38:63'],
                                                                                       'in_octets': '1440797664',
                                                                                       'in_ucast_pkts': '4844179',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16505857144',
                                                                                       'out_ucast_pkts': '12292874',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:90:53'],
                                                                                       'in_octets': '791938658',
                                                                                       'in_ucast_pkts': '3819833',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17283019513',
                                                                                       'out_ucast_pkts': '13874737',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'e0:d3:62:42:e2:03'],
                                                                                       'in_octets': '216313789',
                                                                                       'in_ucast_pkts': '668354',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '2770558421',
                                                                                       'out_ucast_pkts': '2204772',
                                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:3a:ca',
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'out_octets': '249027803617',
                                                              'out_ucast_pkts': '189968506',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm',
                                                              'pons': [       {       'description': '0/1',
                                                                                      'id': 'EPON0/1',
                                                                                      'links': [       {       'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '24070',
                                                                                                               'fiber_length': 1837,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -29.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '24078',
                                                                                                               'fiber_length': 1991,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -28.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '24070',
                                                                                                               'fiber_length': 2155,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '24071',
                                                                                                               'fiber_length': 2250,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '2219223',
                                                                                                               'fiber_length': 2312,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '24084',
                                                                                                               'fiber_length': 1952,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '24087',
                                                                                                               'fiber_length': 1757,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '24084',
                                                                                                               'fiber_length': 1889,
                                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/1',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/2',
                                                              'in_octets': '24257804121',
                                                              'in_ucast_pkts': '99929817',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:7b:8f:a3'],
                                                                                       'in_octets': '323518279',
                                                                                       'in_ucast_pkts': '1520946',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6545150975',
                                                                                       'out_ucast_pkts': '5125800',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7a:f9:53'],
                                                                                       'in_octets': '416957734',
                                                                                       'in_ucast_pkts': '1803919',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '4989396483',
                                                                                       'out_ucast_pkts': '4126893',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:32:b9'],
                                                                                       'in_octets': '10206020659',
                                                                                       'in_ucast_pkts': '33293464',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '135041356370',
                                                                                       'out_ucast_pkts': '104948232',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:0c:79'],
                                                                                       'in_octets': '591456513',
                                                                                       'in_ucast_pkts': '4049212',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17720217008',
                                                                                       'out_ucast_pkts': '13923492',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:40:03'],
                                                                                       'in_octets': '2725029457',
                                                                                       'in_ucast_pkts': '14708807',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '57276591114',
                                                                                       'out_ucast_pkts': '42633632',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:2f:f3'],
                                                                                       'in_octets': '1524517974',
                                                                                       'in_ucast_pkts': '4091892',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '12759632226',
                                                                                       'out_ucast_pkts': '10178869',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:04:b3'],
                                                                                       'in_octets': '3203779217',
                                                                                       'in_ucast_pkts': '19724103',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '58921545265',
                                                                                       'out_ucast_pkts': '44776127',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:54:db'],
                                                                                       'in_octets': '3997304521',
                                                                                       'in_ucast_pkts': '12221405',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '47409080865',
                                                                                       'out_ucast_pkts': '38074244',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:3a:cb',
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'out_octets': '375872241862',
                                                              'out_ucast_pkts': '289043138',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm',
                                                              'pons': [       {       'description': '0/2',
                                                                                      'id': 'EPON0/2',
                                                                                      'links': [       {       'connected_time': '24056',
                                                                                                               'fiber_length': 3244,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '24077',
                                                                                                               'fiber_length': 2354,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '22696',
                                                                                                               'fiber_length': 2354,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -28.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '24042',
                                                                                                               'fiber_length': 3183,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '24084',
                                                                                                               'fiber_length': 3590,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -28.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '24084',
                                                                                                               'fiber_length': 3231,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '24084',
                                                                                                               'fiber_length': 2698,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '24080',
                                                                                                               'fiber_length': 2664,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/2',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/3',
                                                              'in_octets': '2229758678',
                                                              'in_ucast_pkts': '16166994',
                                                              'links': [       {       'bridged_mac_addresses': [       '4c:d7:c8:61:ec:c9'],
                                                                                       'in_octets': '2203501533',
                                                                                       'in_ucast_pkts': '15975874',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '58768343523',
                                                                                       'out_ucast_pkts': '43775767',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:47:eb'],
                                                                                       'in_octets': '26255795',
                                                                                       'in_ucast_pkts': '191131',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14345456',
                                                                                       'out_ucast_pkts': '100233',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:3a:cc',
                                                              'name': 'EPON0/3',
                                                              'oper_up': True,
                                                              'out_octets': '58782866541',
                                                              'out_ucast_pkts': '43876114',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRm',
                                                              'pons': [       {       'description': '0/3',
                                                                                      'id': 'EPON0/3',
                                                                                      'links': [       {       'connected_time': '24078',
                                                                                                               'fiber_length': 2226,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '24062',
                                                                                                               'fiber_length': 2464,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/3',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/4',
                                                              'in_octets': '1478111498',
                                                              'in_ucast_pkts': '6260612',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:ed:9a:91'],
                                                                                       'in_octets': '1478111311',
                                                                                       'in_ucast_pkts': '6260610',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28238782263',
                                                                                       'out_ucast_pkts': '21489899',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:3a:cd',
                                                              'name': 'EPON0/4',
                                                              'oper_up': True,
                                                              'out_octets': '28238791122',
                                                              'out_ucast_pkts': '21489914',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2RpbnRm',
                                                              'pons': [       {       'description': '0/4',
                                                                                      'id': 'EPON0/4',
                                                                                      'links': [       {       'connected_time': '24075',
                                                                                                               'fiber_length': 2412,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/4',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2RpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:ce',
                                                              'name': 'EPON0/5',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2VpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/6',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:cf',
                                                              'name': 'EPON0/6',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2ZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/7',
                                                              'in_octets': '4260304244',
                                                              'in_ucast_pkts': '9904416',
                                                              'links': [       {       'bridged_mac_addresses': [       'e0:d3:62:41:f3:23'],
                                                                                       'in_octets': '4260542820',
                                                                                       'in_ucast_pkts': '9904660',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '37837151595',
                                                                                       'out_ucast_pkts': '28341338',
                                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:3a:d0',
                                                              'name': 'EPON0/7',
                                                              'oper_up': True,
                                                              'out_octets': '37837157769',
                                                              'out_ucast_pkts': '28341347',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDBpbnRm',
                                                              'pons': [       {       'description': '0/7',
                                                                                      'id': 'EPON0/7',
                                                                                      'links': [       {       'connected_time': '24084',
                                                                                                               'fiber_length': 3022,
                                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -28.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/7',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDBpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d1',
                                                              'name': 'EPON0/8',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDFpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/9',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d2',
                                                              'name': 'EPON0/9',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDJpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/10',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d3',
                                                              'name': 'EPON0/10',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDNpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/11',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d4',
                                                              'name': 'EPON0/11',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDRpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/12',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d5',
                                                              'name': 'EPON0/12',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDVpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/13',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d6',
                                                              'name': 'EPON0/13',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/14',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d7',
                                                              'name': 'EPON0/14',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDdpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/15',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d8',
                                                              'name': 'EPON0/15',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDhpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/16',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:3a:d9',
                                                              'name': 'EPON0/16',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDlpbnRm'}],
                                'manufacturer': 'BDCOM',
                                'mem': 71.0,
                                'model': 'P3600-16E',
                                'serial_number': '0000329000586',
                                'sw_version': '10.1.0G Build 104155',
                                'temperature': 66.0},
                'peers': [       {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"power-off"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:1',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZpbnRm',
                                                                       'pons': [       {       'description': '0/1:1',
                                                                                               'id': 'EPON0/1:1',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '6c:68:a4:2d:bf:a6',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:1',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'power-off',
                                         'offline_time': '2025-08-12T09:31:21.161575Z',
                                         'poller_hash': 'NmM6Njg6YTQ6MmQ6YmY6YTZvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '6c:68:a4:2d:bf:a6'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:2',
                                                                       'in_octets': '86622406999',
                                                                       'in_ucast_pkts': '62652644',
                                                                       'links': [       {       'in_octets': '86622406999',
                                                                                                'in_ucast_pkts': '62652644',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2136869781',
                                                                                                'out_ucast_pkts': '10677217',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'out_octets': '2136869781',
                                                                       'out_ucast_pkts': '10677217',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJpbnRm',
                                                                       'pons': [       {       'description': '0/1:2',
                                                                                               'id': 'EPON0/1:2',
                                                                                               'links': [       {       'connected_time': '24070',
                                                                                                                        'fiber_length': 1837,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -25.8,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2136869781',
                                                                       'in_ucast_pkts': '10677217',
                                                                       'mac_address': '6c:68:a4:7a:fa:02',
                                                                       'name': 'eth0',
                                                                       'out_octets': '86622406999',
                                                                       'out_ucast_pkts': '62652644',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'NmM6Njg6YTQ6N2E6ZmE6MDJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7a:fa:02',
                                         'uptime': '24070'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:3',
                                                                       'in_octets': '10603340923',
                                                                       'in_ucast_pkts': '8711317',
                                                                       'links': [       {       'in_octets': '10603340923',
                                                                                                'in_ucast_pkts': '8711317',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1045590247',
                                                                                                'out_ucast_pkts': '3047542',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'out_octets': '1045590247',
                                                                       'out_ucast_pkts': '3047542',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhpbnRm',
                                                                       'pons': [       {       'description': '0/1:3',
                                                                                               'id': 'EPON0/1:3',
                                                                                               'links': [       {       'connected_time': '24078',
                                                                                                                        'fiber_length': 1991,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1045590247',
                                                                       'in_ucast_pkts': '3047542',
                                                                       'mac_address': '6c:68:a4:b1:13:48',
                                                                       'name': 'eth0',
                                                                       'out_octets': '10603340923',
                                                                       'out_ucast_pkts': '8711317',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NmM6Njg6YTQ6YjE6MTM6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:b1:13:48',
                                         'uptime': '24078'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:4',
                                                                       'in_octets': '76675610779',
                                                                       'in_ucast_pkts': '59268600',
                                                                       'links': [       {       'in_octets': '76675610779',
                                                                                                'in_ucast_pkts': '59268600',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '5137559363',
                                                                                                'out_ucast_pkts': '25517113',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'out_octets': '5137559363',
                                                                       'out_ucast_pkts': '25517113',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:4',
                                                                                               'id': 'EPON0/1:4',
                                                                                               'links': [       {       'connected_time': '24070',
                                                                                                                        'fiber_length': 2155,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -23.1,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5137559363',
                                                                       'in_ucast_pkts': '25517113',
                                                                       'mac_address': '6c:68:a4:ee:5d:a0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '76675610779',
                                                                       'out_ucast_pkts': '59268600',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'NmM6Njg6YTQ6ZWU6NWQ6YTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:ee:5d:a0',
                                         'uptime': '24070'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:5',
                                                                       'in_octets': '38543853073',
                                                                       'in_ucast_pkts': '30845925',
                                                                       'links': [       {       'in_octets': '38543853073',
                                                                                                'in_ucast_pkts': '30845925',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2307175217',
                                                                                                'out_ucast_pkts': '10685282',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:5',
                                                                       'oper_up': True,
                                                                       'out_octets': '2307175217',
                                                                       'out_ucast_pkts': '10685282',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhpbnRm',
                                                                       'pons': [       {       'description': '0/1:5',
                                                                                               'id': 'EPON0/1:5',
                                                                                               'links': [       {       'connected_time': '24071',
                                                                                                                        'fiber_length': 2250,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -23.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/1:5',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2307175217',
                                                                       'in_ucast_pkts': '10685282',
                                                                       'mac_address': '4c:d7:c8:61:9e:78',
                                                                       'name': 'eth0',
                                                                       'out_octets': '38543853073',
                                                                       'out_ucast_pkts': '30845925',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/1:5',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjE6OWU6NzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:61:9e:78',
                                         'uptime': '24071'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:8',
                                                                       'in_octets': '23111605',
                                                                       'in_ucast_pkts': '117159',
                                                                       'links': [       {       'in_octets': '23111605',
                                                                                                'in_ucast_pkts': '117159',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '26802995',
                                                                                                'out_ucast_pkts': '185873',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:8',
                                                                       'oper_up': True,
                                                                       'out_octets': '26802995',
                                                                       'out_ucast_pkts': '185873',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBpbnRm',
                                                                       'pons': [       {       'description': '0/1:8',
                                                                                               'id': 'EPON0/1:8',
                                                                                               'links': [       {       'connected_time': '2219223',
                                                                                                                        'fiber_length': 2312,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:8',
                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '26802995',
                                                                       'in_ucast_pkts': '185873',
                                                                       'mac_address': '98:ba:5f:2a:38:40',
                                                                       'name': 'eth0',
                                                                       'out_octets': '23111605',
                                                                       'out_ucast_pkts': '117159',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:8',
                                         'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '98:ba:5f:2a:38:40',
                                         'uptime': '2219223'},
                                 {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"power-off"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:9',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/1:9',
                                                                                               'id': 'EPON0/1:9',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:9',
                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '98:ba:5f:2a:23:b8',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:9',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'power-off',
                                         'offline_time': '2025-08-10T06:05:52.161575Z',
                                         'poller_hash': 'OTg6YmE6NWY6MmE6MjM6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:ba:5f:2a:23:b8'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:10',
                                                                       'in_octets': '16505857144',
                                                                       'in_ucast_pkts': '12292874',
                                                                       'links': [       {       'in_octets': '16505857144',
                                                                                                'in_ucast_pkts': '12292874',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1440797664',
                                                                                                'out_ucast_pkts': '4844179',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:10',
                                                                       'oper_up': True,
                                                                       'out_octets': '1440797664',
                                                                       'out_ucast_pkts': '4844179',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBpbnRm',
                                                                       'pons': [       {       'description': '0/1:10',
                                                                                               'id': 'EPON0/1:10',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 1952,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -23.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:10',
                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1440797664',
                                                                       'in_ucast_pkts': '4844179',
                                                                       'mac_address': '98:ba:5f:2a:38:60',
                                                                       'name': 'eth0',
                                                                       'out_octets': '16505857144',
                                                                       'out_ucast_pkts': '12292874',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:10',
                                         'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6NjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '98:ba:5f:2a:38:60',
                                         'uptime': '24084'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:11',
                                                                       'in_octets': '17283019513',
                                                                       'in_ucast_pkts': '13874737',
                                                                       'links': [       {       'in_octets': '17283019513',
                                                                                                'in_ucast_pkts': '13874737',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '791938658',
                                                                                                'out_ucast_pkts': '3819833',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:11',
                                                                       'oper_up': True,
                                                                       'out_octets': '791938658',
                                                                       'out_ucast_pkts': '3819833',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:11',
                                                                                               'id': 'EPON0/1:11',
                                                                                               'links': [       {       'connected_time': '24087',
                                                                                                                        'fiber_length': 1757,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:11',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '791938658',
                                                                       'in_ucast_pkts': '3819833',
                                                                       'mac_address': '8c:90:2d:57:90:50',
                                                                       'name': 'eth0',
                                                                       'out_octets': '17283019513',
                                                                       'out_ucast_pkts': '13874737',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:11',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6OTA6NTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '8c:90:2d:57:90:50',
                                         'uptime': '24087'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:12',
                                                                       'in_octets': '2770558421',
                                                                       'in_ucast_pkts': '2204772',
                                                                       'links': [       {       'in_octets': '2770558421',
                                                                                                'in_ucast_pkts': '2204772',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '216313789',
                                                                                                'out_ucast_pkts': '668354',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRm'}],
                                                                       'name': 'EPON0/1:12',
                                                                       'oper_up': True,
                                                                       'out_octets': '216313789',
                                                                       'out_ucast_pkts': '668354',
                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBpbnRm',
                                                                       'pons': [       {       'description': '0/1:12',
                                                                                               'id': 'EPON0/1:12',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 1889,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2FpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:12',
                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '216313789',
                                                                       'in_ucast_pkts': '668354',
                                                                       'mac_address': 'e0:d3:62:42:e2:00',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2770558421',
                                                                       'out_ucast_pkts': '2204772',
                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:12',
                                         'poller_hash': 'ZTA6ZDM6NjI6NDI6ZTI6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'e0:d3:62:42:e2:00',
                                         'uptime': '24084'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:1',
                                                                       'in_octets': '6545150975',
                                                                       'in_ucast_pkts': '5125800',
                                                                       'links': [       {       'in_octets': '6545150975',
                                                                                                'in_ucast_pkts': '5125800',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '323518279',
                                                                                                'out_ucast_pkts': '1520946',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '323518279',
                                                                       'out_ucast_pkts': '1520946',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJpbnRm',
                                                                       'pons': [       {       'description': '0/2:1',
                                                                                               'id': 'EPON0/2:1',
                                                                                               'links': [       {       'connected_time': '24056',
                                                                                                                        'fiber_length': 3244,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -21.1,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '323518279',
                                                                       'in_ucast_pkts': '1520946',
                                                                       'mac_address': '6c:68:a4:7b:8f:a2',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6545150975',
                                                                       'out_ucast_pkts': '5125800',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:1',
                                         'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6YTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7b:8f:a2',
                                         'uptime': '24056'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:2',
                                                                       'in_octets': '4989396483',
                                                                       'in_ucast_pkts': '4126893',
                                                                       'links': [       {       'in_octets': '4989396483',
                                                                                                'in_ucast_pkts': '4126893',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '416957734',
                                                                                                'out_ucast_pkts': '1803919',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'out_octets': '416957734',
                                                                       'out_ucast_pkts': '1803919',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJpbnRm',
                                                                       'pons': [       {       'description': '0/2:2',
                                                                                               'id': 'EPON0/2:2',
                                                                                               'links': [       {       'connected_time': '24077',
                                                                                                                        'fiber_length': 2354,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -18.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '416957734',
                                                                       'in_ucast_pkts': '1803919',
                                                                       'mac_address': '6c:68:a4:7a:f9:52',
                                                                       'name': 'eth0',
                                                                       'out_octets': '4989396483',
                                                                       'out_ucast_pkts': '4126893',
                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NmM6Njg6YTQ6N2E6Zjk6NTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:7a:f9:52',
                                         'uptime': '24077'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:3',
                                                                       'in_octets': '135041356370',
                                                                       'in_ucast_pkts': '104948232',
                                                                       'links': [       {       'in_octets': '135041356370',
                                                                                                'in_ucast_pkts': '104948232',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '10206020659',
                                                                                                'out_ucast_pkts': '33293464',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': True,
                                                                       'out_octets': '10206020659',
                                                                       'out_ucast_pkts': '33293464',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/2:3',
                                                                                               'id': 'EPON0/2:3',
                                                                                               'links': [       {       'connected_time': '22696',
                                                                                                                        'fiber_length': 2354,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.1,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:3',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10206020659',
                                                                       'in_ucast_pkts': '33293464',
                                                                       'mac_address': '4c:d7:c8:63:32:b8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '135041356370',
                                                                       'out_ucast_pkts': '104948232',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjM6MzI6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:63:32:b8',
                                         'uptime': '22696'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:4',
                                                                       'in_octets': '17720217008',
                                                                       'in_ucast_pkts': '13923492',
                                                                       'links': [       {       'in_octets': '17720217008',
                                                                                                'in_ucast_pkts': '13923492',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '591456513',
                                                                                                'out_ucast_pkts': '4049212',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'out_octets': '591456513',
                                                                       'out_ucast_pkts': '4049212',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhpbnRm',
                                                                       'pons': [       {       'description': '0/2:4',
                                                                                               'id': 'EPON0/2:4',
                                                                                               'links': [       {       'connected_time': '24042',
                                                                                                                        'fiber_length': 3183,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -20.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/2:4',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '591456513',
                                                                       'in_ucast_pkts': '4049212',
                                                                       'mac_address': '4c:d7:c8:64:0c:78',
                                                                       'name': 'eth0',
                                                                       'out_octets': '17720217008',
                                                                       'out_ucast_pkts': '13923492',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjQ6MGM6NzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:64:0c:78',
                                         'uptime': '24042'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:5',
                                                                       'in_octets': '57276591114',
                                                                       'in_ucast_pkts': '42633632',
                                                                       'links': [       {       'in_octets': '57276591114',
                                                                                                'in_ucast_pkts': '42633632',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2725029457',
                                                                                                'out_ucast_pkts': '14708807',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:5',
                                                                       'oper_up': True,
                                                                       'out_octets': '2725029457',
                                                                       'out_ucast_pkts': '14708807',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBpbnRm',
                                                                       'pons': [       {       'description': '0/2:5',
                                                                                               'id': 'EPON0/2:5',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 3590,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.0,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:5',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2725029457',
                                                                       'in_ucast_pkts': '14708807',
                                                                       'mac_address': '8c:90:2d:57:40:00',
                                                                       'name': 'eth0',
                                                                       'out_octets': '57276591114',
                                                                       'out_ucast_pkts': '42633632',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:5',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6NDA6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '8c:90:2d:57:40:00',
                                         'uptime': '24084'},
                                 {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"power-off"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:6',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:6',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThpbnRm',
                                                                       'pons': [       {       'description': '0/2:6',
                                                                                               'id': 'EPON0/2:6',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:6',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '8c:90:2d:57:3e:a8',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:6',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'power-off',
                                         'offline_time': '2025-08-17T07:47:00.161575Z',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6M2U6YThvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '8c:90:2d:57:3e:a8'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:7',
                                                                       'in_octets': '12759632226',
                                                                       'in_ucast_pkts': '10178869',
                                                                       'links': [       {       'in_octets': '12759632226',
                                                                                                'in_ucast_pkts': '10178869',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1524517974',
                                                                                                'out_ucast_pkts': '4091892',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:7',
                                                                       'oper_up': True,
                                                                       'out_octets': '1524517974',
                                                                       'out_ucast_pkts': '4091892',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBpbnRm',
                                                                       'pons': [       {       'description': '0/2:7',
                                                                                               'id': 'EPON0/2:7',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 3231,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:7',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1524517974',
                                                                       'in_ucast_pkts': '4091892',
                                                                       'mac_address': 'ec:75:0c:20:2f:f0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '12759632226',
                                                                       'out_ucast_pkts': '10178869',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:7',
                                         'poller_hash': 'ZWM6NzU6MGM6MjA6MmY6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:20:2f:f0',
                                         'uptime': '24084'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:8',
                                                                       'in_octets': '58921545265',
                                                                       'in_ucast_pkts': '44776127',
                                                                       'links': [       {       'in_octets': '58921545265',
                                                                                                'in_ucast_pkts': '44776127',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3203779217',
                                                                                                'out_ucast_pkts': '19724103',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:8',
                                                                       'oper_up': True,
                                                                       'out_octets': '3203779217',
                                                                       'out_ucast_pkts': '19724103',
                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBpbnRm',
                                                                       'pons': [       {       'description': '0/2:8',
                                                                                               'id': 'EPON0/2:8',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 2698,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:8',
                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3203779217',
                                                                       'in_ucast_pkts': '19724103',
                                                                       'mac_address': '30:68:93:b2:04:b0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '58921545265',
                                                                       'out_ucast_pkts': '44776127',
                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:8',
                                         'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6YjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:b2:04:b0',
                                         'uptime': '24084'},
                                 {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"power-off"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:9',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBpbnRm',
                                                                       'pons': [       {       'description': '0/2:9',
                                                                                               'id': 'EPON0/2:9',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:9',
                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '3c:64:cf:a4:16:50',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:9',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'power-off',
                                         'offline_time': '2025-07-20T09:42:07.161575Z',
                                         'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '3c:64:cf:a4:16:50'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:10',
                                                                       'in_octets': '47409080865',
                                                                       'in_ucast_pkts': '38074244',
                                                                       'links': [       {       'in_octets': '47409080865',
                                                                                                'in_ucast_pkts': '38074244',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3997304521',
                                                                                                'out_ucast_pkts': '12221405',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:10',
                                                                       'oper_up': True,
                                                                       'out_octets': '3997304521',
                                                                       'out_ucast_pkts': '12221405',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:10',
                                                                                               'id': 'EPON0/2:10',
                                                                                               'links': [       {       'connected_time': '24080',
                                                                                                                        'fiber_length': 2664,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -22.4,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:10',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3997304521',
                                                                       'in_ucast_pkts': '12221405',
                                                                       'mac_address': '30:68:93:52:54:d8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '47409080865',
                                                                       'out_ucast_pkts': '38074244',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:10',
                                         'poller_hash': 'MzA6Njg6OTM6NTI6NTQ6ZDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:52:54:d8',
                                         'uptime': '24080'},
                                 {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"llid-admin-down"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:11',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRm'}],
                                                                       'name': 'EPON0/2:11',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhpbnRm',
                                                                       'pons': [       {       'description': '0/2:11',
                                                                                               'id': 'EPON0/2:11',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2JpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:11',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': 'ec:75:0c:1f:ac:88',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:11',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'llid-admin-down',
                                         'offline_time': '2025-08-17T11:41:14.161575Z',
                                         'poller_hash': 'ZWM6NzU6MGM6MWY6YWM6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'ec:75:0c:1f:ac:88'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:1',
                                                                       'in_octets': '58768343523',
                                                                       'in_ucast_pkts': '43775767',
                                                                       'links': [       {       'in_octets': '58768343523',
                                                                                                'in_ucast_pkts': '43775767',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2203501533',
                                                                                                'out_ucast_pkts': '15975874',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRm'}],
                                                                       'name': 'EPON0/3:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2203501533',
                                                                       'out_ucast_pkts': '15975874',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhpbnRm',
                                                                       'pons': [       {       'description': '0/3:1',
                                                                                               'id': 'EPON0/3:1',
                                                                                               'links': [       {       'connected_time': '24078',
                                                                                                                        'fiber_length': 2226,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -16.6,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/3:1',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2203501533',
                                                                       'in_ucast_pkts': '15975874',
                                                                       'mac_address': '4c:d7:c8:61:ec:c8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '58768343523',
                                                                       'out_ucast_pkts': '43775767',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/3:1',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWM6YzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:61:ec:c8',
                                         'uptime': '24078'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:2',
                                                                       'in_octets': '14345456',
                                                                       'in_ucast_pkts': '100233',
                                                                       'links': [       {       'in_octets': '14345456',
                                                                                                'in_ucast_pkts': '100233',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '26255795',
                                                                                                'out_ucast_pkts': '191131',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRm'}],
                                                                       'name': 'EPON0/3:2',
                                                                       'oper_up': True,
                                                                       'out_octets': '26255795',
                                                                       'out_ucast_pkts': '191131',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/3:2',
                                                                                               'id': 'EPON0/3:2',
                                                                                               'links': [       {       'connected_time': '24062',
                                                                                                                        'fiber_length': 2464,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2NpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.8,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:2',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '26255795',
                                                                       'in_ucast_pkts': '191131',
                                                                       'mac_address': '30:68:93:52:47:e8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '14345456',
                                                                       'out_ucast_pkts': '100233',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/3:2',
                                         'poller_hash': 'MzA6Njg6OTM6NTI6NDc6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:52:47:e8',
                                         'uptime': '24062'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/4:1',
                                                                       'in_octets': '28238782263',
                                                                       'in_ucast_pkts': '21489899',
                                                                       'links': [       {       'in_octets': '28238782263',
                                                                                                'in_ucast_pkts': '21489899',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1478111311',
                                                                                                'out_ucast_pkts': '6260610',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2RpbnRm'}],
                                                                       'name': 'EPON0/4:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1478111311',
                                                                       'out_ucast_pkts': '6260610',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBpbnRm',
                                                                       'pons': [       {       'description': '0/4:1',
                                                                                               'id': 'EPON0/4:1',
                                                                                               'links': [       {       'connected_time': '24075',
                                                                                                                        'fiber_length': 2412,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6Y2RpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -19.8,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -3.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '0/4:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1478111311',
                                                                       'in_ucast_pkts': '6260610',
                                                                       'mac_address': '6c:68:a4:ed:9a:90',
                                                                       'name': 'eth0',
                                                                       'out_octets': '28238782263',
                                                                       'out_ucast_pkts': '21489899',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBldGgw'}],
                                         'manufacturer': 'VSOL',
                                         'model': 'HG3221D',
                                         'name': 'EPON0/4:1',
                                         'poller_hash': 'NmM6Njg6YTQ6ZWQ6OWE6OTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:ed:9a:90',
                                         'uptime': '24075'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/7:1',
                                                                       'in_octets': '37837151595',
                                                                       'in_ucast_pkts': '28341338',
                                                                       'links': [       {       'in_octets': '37837151595',
                                                                                                'in_ucast_pkts': '28341338',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '4260542820',
                                                                                                'out_ucast_pkts': '9904660',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDBpbnRm'}],
                                                                       'name': 'EPON0/7:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '4260542820',
                                                                       'out_ucast_pkts': '9904660',
                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBpbnRm',
                                                                       'pons': [       {       'description': '0/7:1',
                                                                                               'id': 'EPON0/7:1',
                                                                                               'links': [       {       'connected_time': '24084',
                                                                                                                        'fiber_length': 3022,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6M2E6ZDBpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -23.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/7:1',
                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '4260542820',
                                                                       'in_ucast_pkts': '9904660',
                                                                       'mac_address': 'e0:d3:62:41:f3:20',
                                                                       'name': 'eth0',
                                                                       'out_octets': '37837151595',
                                                                       'out_ucast_pkts': '28341338',
                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/7:1',
                                         'poller_hash': 'ZTA6ZDM6NjI6NDE6ZjM6MjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'e0:d3:62:41:f3:20',
                                         'uptime': '24084'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_bdcom_p3600_P3600_16E_10_1_0G_Build_136974_01(self):
        obj = self.run_data("bdcom.p3600.P3600-16E.10.1.0G Build 136974.01")
        exp_info = {
                'model': 'P3600-16E',
                'sta_count': 262,
                'sw_version': '10.1.0G Build 136974',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '0000329001187'
        }
        exp_sta_stats = {
                '0c:ef:15:20:dc:08': {       'dev_macs': ['0c:ef:15:20:dc:0a'],
                                             'ip_address': None,
                                             'mac_address': '0c:ef:15:20:dc:08',
                                             'name': 'EPON0/15:23',
                                             'serial_number': None},
                '0c:ef:15:20:ec:70': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '0c:ef:15:20:ec:70',
                                             'name': 'EPON0/10:18',
                                             'serial_number': None},
                '30:68:93:51:ed:50': {       'dev_macs': ['30:68:93:51:ed:52'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:51:ed:50',
                                             'name': 'EPON0/15:5',
                                             'serial_number': None},
                '30:68:93:51:f1:10': {       'dev_macs': ['30:68:93:51:f1:12'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:51:f1:10',
                                             'name': 'EPON0/1:9',
                                             'serial_number': None},
                '30:68:93:51:f9:50': {       'dev_macs': ['30:68:93:51:f9:53'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:51:f9:50',
                                             'name': 'EPON0/12:9',
                                             'serial_number': None},
                '30:68:93:51:fe:10': {       'dev_macs': ['30:68:93:51:fe:13'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:51:fe:10',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '30:68:93:52:12:40': {       'dev_macs': ['30:68:93:52:12:43'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:12:40',
                                             'name': 'EPON0/1:8',
                                             'serial_number': None},
                '30:68:93:52:1f:c0': {       'dev_macs': ['30:68:93:52:1f:c3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:1f:c0',
                                             'name': 'EPON0/16:19',
                                             'serial_number': None},
                '30:68:93:52:24:10': {       'dev_macs': ['30:68:93:52:24:13'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:24:10',
                                             'name': 'EPON0/12:13',
                                             'serial_number': None},
                '30:68:93:52:2b:28': {       'dev_macs': ['30:68:93:52:2b:2b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:2b:28',
                                             'name': 'EPON0/9:18',
                                             'serial_number': None},
                '30:68:93:52:2b:e8': {       'dev_macs': ['30:68:93:52:2b:eb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:2b:e8',
                                             'name': 'EPON0/3:11',
                                             'serial_number': None},
                '30:68:93:52:2d:48': {       'dev_macs': ['30:68:93:52:2d:4b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:2d:48',
                                             'name': 'EPON0/8:2',
                                             'serial_number': None},
                '30:68:93:52:30:d8': {       'dev_macs': ['30:68:93:52:30:da'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:30:d8',
                                             'name': 'EPON0/7:11',
                                             'serial_number': None},
                '30:68:93:52:32:c8': {       'dev_macs': ['30:68:93:52:32:ca'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:32:c8',
                                             'name': 'EPON0/7:16',
                                             'serial_number': None},
                '30:68:93:52:32:d0': {       'dev_macs': ['30:68:93:52:32:d3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:32:d0',
                                             'name': 'EPON0/7:25',
                                             'serial_number': None},
                '30:68:93:52:33:98': {       'dev_macs': ['30:68:93:52:33:9b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:33:98',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '30:68:93:52:3e:80': {       'dev_macs': ['30:68:93:52:3e:83'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:3e:80',
                                             'name': 'EPON0/12:15',
                                             'serial_number': None},
                '30:68:93:52:3e:88': {       'dev_macs': ['30:68:93:52:3e:8b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:3e:88',
                                             'name': 'EPON0/16:22',
                                             'serial_number': None},
                '30:68:93:52:58:70': {       'dev_macs': ['30:68:93:52:58:73'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:58:70',
                                             'name': 'EPON0/10:16',
                                             'serial_number': None},
                '30:68:93:52:58:c0': {       'dev_macs': ['30:68:93:52:58:c3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:52:58:c0',
                                             'name': 'EPON0/8:10',
                                             'serial_number': None},
                '30:68:93:b1:a0:90': {       'dev_macs': ['30:68:93:b1:a0:92'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:a0:90',
                                             'name': 'EPON0/10:5',
                                             'serial_number': None},
                '30:68:93:b1:b8:a8': {       'dev_macs': ['30:68:93:b1:b8:ab'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:b8:a8',
                                             'name': 'EPON0/16:21',
                                             'serial_number': None},
                '30:68:93:b1:bb:b8': {       'dev_macs': ['30:68:93:b1:bb:bb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:bb:b8',
                                             'name': 'EPON0/8:9',
                                             'serial_number': None},
                '30:68:93:b1:bc:b8': {       'dev_macs': ['30:68:93:b1:bc:bb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:bc:b8',
                                             'name': 'EPON0/10:14',
                                             'serial_number': None},
                '30:68:93:b1:bc:d0': {       'dev_macs': ['30:68:93:b1:bc:d2'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:bc:d0',
                                             'name': 'EPON0/3:18',
                                             'serial_number': None},
                '30:68:93:b1:e5:58': {       'dev_macs': ['30:68:93:b1:e5:5b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:e5:58',
                                             'name': 'EPON0/16:20',
                                             'serial_number': None},
                '30:68:93:b1:ec:f8': {       'dev_macs': ['30:68:93:b1:ec:fa'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:ec:f8',
                                             'name': 'EPON0/10:15',
                                             'serial_number': None},
                '30:68:93:b1:f0:38': {       'dev_macs': ['30:68:93:b1:f0:3a'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:f0:38',
                                             'name': 'EPON0/14:19',
                                             'serial_number': None},
                '30:68:93:b1:f6:98': {       'dev_macs': ['30:68:93:b1:f6:9b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:f6:98',
                                             'name': 'EPON0/2:13',
                                             'serial_number': None},
                '30:68:93:b1:f6:c8': {       'dev_macs': ['30:68:93:b1:f6:cb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:f6:c8',
                                             'name': 'EPON0/15:22',
                                             'serial_number': None},
                '30:68:93:b1:fd:80': {       'dev_macs': ['30:68:93:b1:fd:83'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:fd:80',
                                             'name': 'EPON0/12:16',
                                             'serial_number': None},
                '30:68:93:b1:ff:80': {       'dev_macs': ['30:68:93:b1:ff:83'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:ff:80',
                                             'name': 'EPON0/11:14',
                                             'serial_number': None},
                '30:68:93:b1:ff:88': {       'dev_macs': ['30:68:93:b1:ff:8b'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b1:ff:88',
                                             'name': 'EPON0/12:14',
                                             'serial_number': None},
                '30:68:93:b2:00:90': {       'dev_macs': ['30:68:93:b2:00:93'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:00:90',
                                             'name': 'EPON0/12:10',
                                             'serial_number': None},
                '30:68:93:b2:01:18': {       'dev_macs': ['30:68:93:b2:01:1a'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:01:18',
                                             'name': 'EPON0/4:12',
                                             'serial_number': None},
                '30:68:93:b2:04:f0': {       'dev_macs': ['30:68:93:b2:04:f3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:04:f0',
                                             'name': 'EPON0/5:11',
                                             'serial_number': None},
                '30:68:93:b2:05:a8': {       'dev_macs': ['30:68:93:b2:05:ab'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:05:a8',
                                             'name': 'EPON0/12:12',
                                             'serial_number': None},
                '30:68:93:b2:06:c0': {       'dev_macs': ['30:68:93:b2:06:c2'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:06:c0',
                                             'name': 'EPON0/15:20',
                                             'serial_number': None},
                '30:68:93:b2:0f:b8': {       'dev_macs': ['30:68:93:b2:0f:bb'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:0f:b8',
                                             'name': 'EPON0/7:26',
                                             'serial_number': None},
                '30:68:93:b2:13:a0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:13:a0',
                                             'name': 'EPON0/8:8',
                                             'serial_number': None},
                '30:68:93:b2:14:c0': {       'dev_macs': ['30:68:93:b2:14:c3'],
                                             'ip_address': None,
                                             'mac_address': '30:68:93:b2:14:c0',
                                             'name': 'EPON0/14:20',
                                             'serial_number': None},
                '3c:64:cf:a3:bd:38': {       'dev_macs': ['3c:64:cf:a3:bd:3b'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a3:bd:38',
                                             'name': 'EPON0/9:19',
                                             'serial_number': None},
                '3c:64:cf:a3:be:20': {       'dev_macs': ['3c:64:cf:a3:be:23'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a3:be:20',
                                             'name': 'EPON0/5:10',
                                             'serial_number': None},
                '3c:64:cf:a3:c6:98': {       'dev_macs': ['3c:64:cf:a3:c6:9b'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a3:c6:98',
                                             'name': 'EPON0/1:11',
                                             'serial_number': None},
                '3c:64:cf:a3:cf:00': {       'dev_macs': ['3c:64:cf:a3:cf:03'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a3:cf:00',
                                             'name': 'EPON0/14:21',
                                             'serial_number': None},
                '3c:64:cf:a3:fa:c0': {       'dev_macs': ['3c:64:cf:a3:fa:c3'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a3:fa:c0',
                                             'name': 'EPON0/3:17',
                                             'serial_number': None},
                '3c:64:cf:a4:10:68': {       'dev_macs': ['3c:64:cf:a4:10:6b'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:10:68',
                                             'name': 'EPON0/3:16',
                                             'serial_number': None},
                '3c:64:cf:a4:16:78': {       'dev_macs': ['3c:64:cf:a4:16:7b'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:16:78',
                                             'name': 'EPON0/15:21',
                                             'serial_number': None},
                '3c:64:cf:a4:1a:f0': {       'dev_macs': ['3c:64:cf:a4:1a:f3'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:1a:f0',
                                             'name': 'EPON0/3:15',
                                             'serial_number': None},
                '3c:64:cf:a4:25:00': {       'dev_macs': ['3c:64:cf:a4:25:03'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:25:00',
                                             'name': 'EPON0/13:19',
                                             'serial_number': None},
                '3c:64:cf:a4:2f:d8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:2f:d8',
                                             'name': 'EPON0/13:18',
                                             'serial_number': None},
                '3c:64:cf:a4:81:c8': {       'dev_macs': ['3c:64:cf:a4:81:cb'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:a4:81:c8',
                                             'name': 'EPON0/11:17',
                                             'serial_number': None},
                '3c:64:cf:fe:e0:d8': {       'dev_macs': ['3c:64:cf:fe:e0:db'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:fe:e0:d8',
                                             'name': 'EPON0/11:15',
                                             'serial_number': None},
                '3c:64:cf:fe:e2:18': {       'dev_macs': ['3c:64:cf:fe:e2:1b'],
                                             'ip_address': None,
                                             'mac_address': '3c:64:cf:fe:e2:18',
                                             'name': 'EPON0/10:17',
                                             'serial_number': None},
                '4c:d7:c8:60:f2:28': {       'dev_macs': ['4c:d7:c8:60:f2:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:60:f2:28',
                                             'name': 'EPON0/3:13',
                                             'serial_number': None},
                '4c:d7:c8:61:13:78': {       'dev_macs': ['4c:d7:c8:61:13:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:13:78',
                                             'name': 'EPON0/8:3',
                                             'serial_number': None},
                '4c:d7:c8:61:15:28': {       'dev_macs': ['4c:d7:c8:61:15:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:15:28',
                                             'name': 'EPON0/5:8',
                                             'serial_number': None},
                '4c:d7:c8:61:3b:b8': {       'dev_macs': ['4c:d7:c8:61:3b:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:3b:b8',
                                             'name': 'EPON0/13:8',
                                             'serial_number': None},
                '4c:d7:c8:61:43:88': {       'dev_macs': ['4c:d7:c8:61:43:89'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:43:88',
                                             'name': 'EPON0/2:7',
                                             'serial_number': None},
                '4c:d7:c8:61:46:e8': {       'dev_macs': ['4c:d7:c8:61:46:e9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:46:e8',
                                             'name': 'EPON0/9:12',
                                             'serial_number': None},
                '4c:d7:c8:61:47:08': {       'dev_macs': ['4c:d7:c8:61:47:09'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:47:08',
                                             'name': 'EPON0/6:6',
                                             'serial_number': None},
                '4c:d7:c8:61:47:88': {       'dev_macs': ['4c:d7:c8:61:47:89'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:47:88',
                                             'name': 'EPON0/3:14',
                                             'serial_number': None},
                '4c:d7:c8:61:4b:08': {       'dev_macs': ['4c:d7:c8:61:4b:09'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:4b:08',
                                             'name': 'EPON0/9:6',
                                             'serial_number': None},
                '4c:d7:c8:61:4e:b8': {       'dev_macs': ['4c:d7:c8:61:4e:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:4e:b8',
                                             'name': 'EPON0/10:4',
                                             'serial_number': None},
                '4c:d7:c8:61:70:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:70:88',
                                             'name': 'EPON0/13:16',
                                             'serial_number': None},
                '4c:d7:c8:61:8e:38': {       'dev_macs': ['4c:d7:c8:61:8e:39'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:8e:38',
                                             'name': 'EPON0/4:8',
                                             'serial_number': None},
                '4c:d7:c8:61:a0:88': {       'dev_macs': ['4c:d7:c8:61:a0:89'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:a0:88',
                                             'name': 'EPON0/7:19',
                                             'serial_number': None},
                '4c:d7:c8:61:e9:18': {       'dev_macs': ['4c:d7:c8:61:e9:19'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:e9:18',
                                             'name': 'EPON0/9:13',
                                             'serial_number': None},
                '4c:d7:c8:61:e9:d8': {       'dev_macs': ['4c:d7:c8:61:e9:d9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:e9:d8',
                                             'name': 'EPON0/2:6',
                                             'serial_number': None},
                '4c:d7:c8:61:e9:f8': {       'dev_macs': ['4c:d7:c8:61:e9:f9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:e9:f8',
                                             'name': 'EPON0/10:3',
                                             'serial_number': None},
                '4c:d7:c8:61:eb:18': {       'dev_macs': ['4c:d7:c8:61:eb:19'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:eb:18',
                                             'name': 'EPON0/3:8',
                                             'serial_number': None},
                '4c:d7:c8:61:ed:f8': {       'dev_macs': ['4c:d7:c8:61:ed:f9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:61:ed:f8',
                                             'name': 'EPON0/16:17',
                                             'serial_number': None},
                '4c:d7:c8:62:18:38': {       'dev_macs': ['4c:d7:c8:62:18:39'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:18:38',
                                             'name': 'EPON0/8:5',
                                             'serial_number': None},
                '4c:d7:c8:62:1a:e8': {       'dev_macs': ['4c:d7:c8:62:1a:e9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:1a:e8',
                                             'name': 'EPON0/7:21',
                                             'serial_number': None},
                '4c:d7:c8:62:43:98': {       'dev_macs': ['4c:d7:c8:62:43:99'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:43:98',
                                             'name': 'EPON0/9:8',
                                             'serial_number': None},
                '4c:d7:c8:62:63:38': {       'dev_macs': ['4c:d7:c8:62:63:39'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:63:38',
                                             'name': 'EPON0/5:9',
                                             'serial_number': None},
                '4c:d7:c8:62:6d:b8': {       'dev_macs': ['4c:d7:c8:62:6d:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:6d:b8',
                                             'name': 'EPON0/6:8',
                                             'serial_number': None},
                '4c:d7:c8:62:78:28': {       'dev_macs': ['4c:d7:c8:62:78:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:78:28',
                                             'name': 'EPON0/11:9',
                                             'serial_number': None},
                '4c:d7:c8:62:7b:b8': {       'dev_macs': ['4c:d7:c8:62:7b:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:7b:b8',
                                             'name': 'EPON0/1:12',
                                             'serial_number': None},
                '4c:d7:c8:62:7b:d8': {       'dev_macs': ['4c:d7:c8:62:7b:d9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:7b:d8',
                                             'name': 'EPON0/14:15',
                                             'serial_number': None},
                '4c:d7:c8:62:86:a8': {       'dev_macs': ['4c:d7:c8:62:86:a9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:86:a8',
                                             'name': 'EPON0/14:14',
                                             'serial_number': None},
                '4c:d7:c8:62:91:98': {       'dev_macs': ['4c:d7:c8:62:91:99'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:91:98',
                                             'name': 'EPON0/7:15',
                                             'serial_number': None},
                '4c:d7:c8:62:9d:98': {       'dev_macs': ['4c:d7:c8:62:9d:99'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:9d:98',
                                             'name': 'EPON0/3:10',
                                             'serial_number': None},
                '4c:d7:c8:62:9f:08': {       'dev_macs': ['4c:d7:c8:62:9f:09'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:9f:08',
                                             'name': 'EPON0/5:5',
                                             'serial_number': None},
                '4c:d7:c8:62:bb:d8': {       'dev_macs': ['4c:d7:c8:62:bb:d9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:bb:d8',
                                             'name': 'EPON0/2:11',
                                             'serial_number': None},
                '4c:d7:c8:62:bb:e8': {       'dev_macs': ['4c:d7:c8:62:bb:e9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:bb:e8',
                                             'name': 'EPON0/14:12',
                                             'serial_number': None},
                '4c:d7:c8:62:d2:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:d2:18',
                                             'name': 'EPON0/7:23',
                                             'serial_number': None},
                '4c:d7:c8:62:dd:78': {       'dev_macs': ['4c:d7:c8:62:dd:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:dd:78',
                                             'name': 'EPON0/13:13',
                                             'serial_number': None},
                '4c:d7:c8:62:df:b8': {       'dev_macs': ['4c:d7:c8:62:df:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:df:b8',
                                             'name': 'EPON0/4:7',
                                             'serial_number': None},
                '4c:d7:c8:62:e9:28': {       'dev_macs': ['4c:d7:c8:62:e9:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:e9:28',
                                             'name': 'EPON0/13:9',
                                             'serial_number': None},
                '4c:d7:c8:62:eb:c8': {       'dev_macs': ['4c:d7:c8:62:eb:c9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:eb:c8',
                                             'name': 'EPON0/9:7',
                                             'serial_number': None},
                '4c:d7:c8:62:f0:28': {       'dev_macs': ['4c:d7:c8:62:f0:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:62:f0:28',
                                             'name': 'EPON0/7:17',
                                             'serial_number': None},
                '4c:d7:c8:63:0a:98': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:0a:98',
                                             'name': 'EPON0/14:17',
                                             'serial_number': None},
                '4c:d7:c8:63:3c:e8': {       'dev_macs': ['4c:d7:c8:63:3c:e9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:3c:e8',
                                             'name': 'EPON0/3:9',
                                             'serial_number': None},
                '4c:d7:c8:63:50:e8': {       'dev_macs': ['4c:d7:c8:63:50:e9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:50:e8',
                                             'name': 'EPON0/14:13',
                                             'serial_number': None},
                '4c:d7:c8:63:52:f8': {       'dev_macs': ['4c:d7:c8:63:52:f9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:52:f8',
                                             'name': 'EPON0/13:14',
                                             'serial_number': None},
                '4c:d7:c8:63:61:78': {       'dev_macs': ['4c:d7:c8:63:61:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:61:78',
                                             'name': 'EPON0/9:9',
                                             'serial_number': None},
                '4c:d7:c8:63:6f:a8': {       'dev_macs': ['4c:d7:c8:63:6f:a9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:6f:a8',
                                             'name': 'EPON0/7:20',
                                             'serial_number': None},
                '4c:d7:c8:63:70:a8': {       'dev_macs': ['4c:d7:c8:63:70:a9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:70:a8',
                                             'name': 'EPON0/3:2',
                                             'serial_number': None},
                '4c:d7:c8:63:90:28': {       'dev_macs': ['4c:d7:c8:63:90:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:90:28',
                                             'name': 'EPON0/11:10',
                                             'serial_number': None},
                '4c:d7:c8:63:9e:88': {       'dev_macs': ['4c:d7:c8:63:9e:89'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:9e:88',
                                             'name': 'EPON0/6:5',
                                             'serial_number': None},
                '4c:d7:c8:63:ba:b8': {       'dev_macs': ['4c:d7:c8:63:ba:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:ba:b8',
                                             'name': 'EPON0/10:13',
                                             'serial_number': None},
                '4c:d7:c8:63:be:b8': {       'dev_macs': ['4c:d7:c8:63:be:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:be:b8',
                                             'name': 'EPON0/6:4',
                                             'serial_number': None},
                '4c:d7:c8:63:e6:58': {       'dev_macs': ['4c:d7:c8:63:e6:59'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:63:e6:58',
                                             'name': 'EPON0/12:8',
                                             'serial_number': None},
                '4c:d7:c8:64:17:78': {       'dev_macs': ['4c:d7:c8:64:17:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:17:78',
                                             'name': 'EPON0/15:6',
                                             'serial_number': None},
                '4c:d7:c8:64:24:08': {       'dev_macs': ['4c:d7:c8:64:24:09'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:24:08',
                                             'name': 'EPON0/16:16',
                                             'serial_number': None},
                '4c:d7:c8:64:6f:78': {       'dev_macs': ['4c:d7:c8:64:6f:79'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:6f:78',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '4c:d7:c8:64:76:d8': {       'dev_macs': ['4c:d7:c8:64:76:d9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:76:d8',
                                             'name': 'EPON0/1:6',
                                             'serial_number': None},
                '4c:d7:c8:64:7a:b8': {       'dev_macs': ['4c:d7:c8:64:7a:b9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:7a:b8',
                                             'name': 'EPON0/15:17',
                                             'serial_number': None},
                '4c:d7:c8:64:87:28': {       'dev_macs': ['4c:d7:c8:64:87:29'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:87:28',
                                             'name': 'EPON0/7:18',
                                             'serial_number': None},
                '4c:d7:c8:64:b8:c8': {       'dev_macs': ['4c:d7:c8:64:b8:c9'],
                                             'ip_address': None,
                                             'mac_address': '4c:d7:c8:64:b8:c8',
                                             'name': 'EPON0/14:8',
                                             'serial_number': None},
                '6c:68:a4:1e:69:ff': {       'dev_macs': ['6c:68:a4:1e:6a:00'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:69:ff',
                                             'name': 'EPON0/3:1',
                                             'serial_number': None},
                '6c:68:a4:1e:96:9f': {       'dev_macs': ['6c:68:a4:1e:96:a0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:96:9f',
                                             'name': 'EPON0/11:1',
                                             'serial_number': None},
                '6c:68:a4:1e:f9:cf': {       'dev_macs': ['6c:68:a4:1e:f9:d0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:f9:cf',
                                             'name': 'EPON0/9:1',
                                             'serial_number': None},
                '6c:68:a4:1e:ff:bf': {       'dev_macs': ['6c:68:a4:1e:ff:c0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:ff:bf',
                                             'name': 'EPON0/6:1',
                                             'serial_number': None},
                '6c:68:a4:1f:04:ef': {       'dev_macs': ['6c:68:a4:1f:04:f0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:04:ef',
                                             'name': 'EPON0/4:1',
                                             'serial_number': None},
                '6c:68:a4:1f:0d:bf': {       'dev_macs': ['6c:68:a4:1f:0d:c0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:0d:bf',
                                             'name': 'EPON0/9:2',
                                             'serial_number': None},
                '6c:68:a4:1f:10:0f': {       'dev_macs': [       '6c:68:a4:1f:10:10',
                                                                 '6c:68:a4:1f:10:11'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:10:0f',
                                             'name': 'EPON0/7:5',
                                             'serial_number': None},
                '6c:68:a4:1f:19:ef': {       'dev_macs': ['6c:68:a4:1f:19:f0'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:19:ef',
                                             'name': 'EPON0/7:3',
                                             'serial_number': None},
                '6c:68:a4:1f:85:3f': {       'dev_macs': ['6c:68:a4:1f:85:40'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:85:3f',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '6c:68:a4:20:13:7f': {       'dev_macs': ['6c:68:a4:20:13:80'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:13:7f',
                                             'name': 'EPON0/14:1',
                                             'serial_number': None},
                '6c:68:a4:20:1c:3f': {       'dev_macs': ['6c:68:a4:20:1c:40'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:1c:3f',
                                             'name': 'EPON0/7:1',
                                             'serial_number': None},
                '6c:68:a4:2b:c1:86': {       'dev_macs': ['6c:68:a4:2b:c1:87'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2b:c1:86',
                                             'name': 'EPON0/16:8',
                                             'serial_number': None},
                '6c:68:a4:2b:c2:06': {       'dev_macs': ['6c:68:a4:2b:c2:07'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2b:c2:06',
                                             'name': 'EPON0/15:8',
                                             'serial_number': None},
                '6c:68:a4:2b:e5:f6': {       'dev_macs': ['6c:68:a4:2b:e5:f7'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2b:e5:f6',
                                             'name': 'EPON0/13:5',
                                             'serial_number': None},
                '6c:68:a4:2b:f0:26': {       'dev_macs': ['6c:68:a4:2b:f0:27'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2b:f0:26',
                                             'name': 'EPON0/7:8',
                                             'serial_number': None},
                '6c:68:a4:2b:fa:66': {       'dev_macs': ['6c:68:a4:2b:fa:67'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2b:fa:66',
                                             'name': 'EPON0/13:6',
                                             'serial_number': None},
                '6c:68:a4:2c:13:66': {       'dev_macs': ['6c:68:a4:2c:13:67'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:13:66',
                                             'name': 'EPON0/14:2',
                                             'serial_number': None},
                '6c:68:a4:2c:3b:c6': {       'dev_macs': ['6c:68:a4:2c:3b:c7'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:3b:c6',
                                             'name': 'EPON0/15:16',
                                             'serial_number': None},
                '6c:68:a4:2e:a8:e6': {       'dev_macs': ['6c:68:a4:2e:a8:e7'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2e:a8:e6',
                                             'name': 'EPON0/5:1',
                                             'serial_number': None},
                '6c:68:a4:2e:b6:b6': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2e:b6:b6',
                                             'name': 'EPON0/7:2',
                                             'serial_number': None},
                '6c:68:a4:2e:ba:86': {       'dev_macs': ['6c:68:a4:2e:ba:87'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2e:ba:86',
                                             'name': 'EPON0/16:1',
                                             'serial_number': None},
                '6c:68:a4:5a:6c:0c': {       'dev_macs': ['6c:68:a4:5a:6c:0d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:5a:6c:0c',
                                             'name': 'EPON0/7:4',
                                             'serial_number': None},
                '6c:68:a4:5b:a5:5c': {       'dev_macs': ['6c:68:a4:5b:a5:5d'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:5b:a5:5c',
                                             'name': 'EPON0/12:1',
                                             'serial_number': None},
                '6c:68:a4:5b:c6:dc': {       'dev_macs': ['6c:68:a4:5b:c6:dd'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:5b:c6:dc',
                                             'name': 'EPON0/11:2',
                                             'serial_number': None},
                '6c:68:a4:7a:12:a2': {       'dev_macs': ['6c:68:a4:7a:12:a3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7a:12:a2',
                                             'name': 'EPON0/16:9',
                                             'serial_number': None},
                '6c:68:a4:7a:1c:02': {       'dev_macs': ['6c:68:a4:7a:1c:03'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7a:1c:02',
                                             'name': 'EPON0/4:2',
                                             'serial_number': None},
                '6c:68:a4:7a:d5:02': {       'dev_macs': ['6c:68:a4:7a:d5:03'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7a:d5:02',
                                             'name': 'EPON0/6:9',
                                             'serial_number': None},
                '6c:68:a4:7b:02:52': {       'dev_macs': ['6c:68:a4:7b:02:53'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:02:52',
                                             'name': 'EPON0/10:2',
                                             'serial_number': None},
                '6c:68:a4:7b:1b:c2': {       'dev_macs': ['6c:68:a4:7b:1b:c3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:1b:c2',
                                             'name': 'EPON0/7:9',
                                             'serial_number': None},
                '6c:68:a4:7b:8e:72': {       'dev_macs': ['6c:68:a4:7b:8e:73'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:8e:72',
                                             'name': 'EPON0/8:1',
                                             'serial_number': None},
                '6c:68:a4:7b:8f:22': {       'dev_macs': ['6c:68:a4:7b:8f:23'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:8f:22',
                                             'name': 'EPON0/8:4',
                                             'serial_number': None},
                '6c:68:a4:7b:93:f2': {       'dev_macs': ['6c:68:a4:7b:93:f3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:93:f2',
                                             'name': 'EPON0/16:15',
                                             'serial_number': None},
                '6c:68:a4:7b:a7:e2': {       'dev_macs': ['6c:68:a4:7b:a7:e3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:a7:e2',
                                             'name': 'EPON0/9:10',
                                             'serial_number': None},
                '6c:68:a4:7b:d2:d2': {       'dev_macs': ['6c:68:a4:7b:d2:d3'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:7b:d2:d2',
                                             'name': 'EPON0/4:3',
                                             'serial_number': None},
                '6c:68:a4:98:f2:16': {       'dev_macs': ['6c:68:a4:98:f2:17'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:98:f2:16',
                                             'name': 'EPON0/4:4',
                                             'serial_number': None},
                '6c:68:a4:99:1e:36': {       'dev_macs': ['6c:68:a4:99:1e:37'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:99:1e:36',
                                             'name': 'EPON0/11:6',
                                             'serial_number': None},
                '6c:68:a4:99:22:36': {       'dev_macs': ['6c:68:a4:99:22:37'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:99:22:36',
                                             'name': 'EPON0/3:6',
                                             'serial_number': None},
                '6c:68:a4:99:48:86': {       'dev_macs': ['6c:68:a4:99:48:87'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:99:48:86',
                                             'name': 'EPON0/16:7',
                                             'serial_number': None},
                '6c:68:a4:99:55:56': {       'dev_macs': ['6c:68:a4:99:55:57'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:99:55:56',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '6c:68:a4:9a:1a:b6': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:9a:1a:b6',
                                             'name': 'EPON0/13:15',
                                             'serial_number': None},
                '6c:68:a4:b0:21:58': {       'dev_macs': ['6c:68:a4:b0:21:59'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:21:58',
                                             'name': 'EPON0/3:3',
                                             'serial_number': None},
                '6c:68:a4:b0:27:18': {       'dev_macs': ['6c:68:a4:b0:27:19'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:27:18',
                                             'name': 'EPON0/16:6',
                                             'serial_number': None},
                '6c:68:a4:b0:28:58': {       'dev_macs': ['6c:68:a4:b0:28:59'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:28:58',
                                             'name': 'EPON0/12:3',
                                             'serial_number': None},
                '6c:68:a4:b0:2e:f8': {       'dev_macs': ['6c:68:a4:b0:2e:f9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:2e:f8',
                                             'name': 'EPON0/16:3',
                                             'serial_number': None},
                '6c:68:a4:b0:3b:e8': {       'dev_macs': ['6c:68:a4:b0:3b:e9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:3b:e8',
                                             'name': 'EPON0/13:3',
                                             'serial_number': None},
                '6c:68:a4:b0:42:18': {       'dev_macs': ['6c:68:a4:b0:42:19'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:42:18',
                                             'name': 'EPON0/3:4',
                                             'serial_number': None},
                '6c:68:a4:b0:55:48': {       'dev_macs': ['6c:68:a4:b0:55:49'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:55:48',
                                             'name': 'EPON0/13:1',
                                             'serial_number': None},
                '6c:68:a4:b0:56:18': {       'dev_macs': ['6c:68:a4:b0:56:19'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:56:18',
                                             'name': 'EPON0/16:5',
                                             'serial_number': None},
                '6c:68:a4:b0:5c:e8': {       'dev_macs': ['6c:68:a4:b0:5c:e9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:5c:e8',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '6c:68:a4:b0:70:48': {       'dev_macs': ['6c:68:a4:b0:70:49'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:70:48',
                                             'name': 'EPON0/2:1',
                                             'serial_number': None},
                '6c:68:a4:b0:78:68': {       'dev_macs': ['6c:68:a4:b0:78:69'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:78:68',
                                             'name': 'EPON0/7:6',
                                             'serial_number': None},
                '6c:68:a4:b0:81:98': {       'dev_macs': ['6c:68:a4:b0:81:99'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:81:98',
                                             'name': 'EPON0/13:4',
                                             'serial_number': None},
                '6c:68:a4:b0:99:98': {       'dev_macs': ['6c:68:a4:b0:99:99'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:99:98',
                                             'name': 'EPON0/11:4',
                                             'serial_number': None},
                '6c:68:a4:b0:99:f8': {       'dev_macs': ['6c:68:a4:b0:99:f9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:99:f8',
                                             'name': 'EPON0/15:1',
                                             'serial_number': None},
                '6c:68:a4:b0:9b:b8': {       'dev_macs': ['6c:68:a4:b0:9b:b9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:9b:b8',
                                             'name': 'EPON0/11:3',
                                             'serial_number': None},
                '6c:68:a4:b0:9b:d8': {       'dev_macs': ['6c:68:a4:b0:9b:d9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:9b:d8',
                                             'name': 'EPON0/16:4',
                                             'serial_number': None},
                '6c:68:a4:b0:9f:a8': {       'dev_macs': ['6c:68:a4:b0:9f:a9'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:9f:a8',
                                             'name': 'EPON0/10:1',
                                             'serial_number': None},
                '6c:68:a4:b0:a6:08': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:b0:a6:08',
                                             'name': 'EPON0/3:5',
                                             'serial_number': None},
                '6c:68:a4:ed:8d:c0': {       'dev_macs': ['6c:68:a4:ed:8d:c1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ed:8d:c0',
                                             'name': 'EPON0/12:4',
                                             'serial_number': None},
                '6c:68:a4:ed:af:10': {       'dev_macs': ['6c:68:a4:ed:af:11'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ed:af:10',
                                             'name': 'EPON0/15:7',
                                             'serial_number': None},
                '6c:68:a4:ed:cc:d0': {       'dev_macs': ['6c:68:a4:ed:cc:d1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ed:cc:d0',
                                             'name': 'EPON0/13:10',
                                             'serial_number': None},
                '6c:68:a4:ed:fb:70': {       'dev_macs': ['6c:68:a4:ed:fb:71'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ed:fb:70',
                                             'name': 'EPON0/7:7',
                                             'serial_number': None},
                '6c:68:a4:ee:06:e0': {       'dev_macs': ['6c:68:a4:ee:06:e1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:06:e0',
                                             'name': 'EPON0/3:7',
                                             'serial_number': None},
                '6c:68:a4:ee:1f:d0': {       'dev_macs': ['6c:68:a4:ee:1f:d1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:1f:d0',
                                             'name': 'EPON0/12:5',
                                             'serial_number': None},
                '6c:68:a4:ee:26:40': {       'dev_macs': ['6c:68:a4:ee:26:41'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:26:40',
                                             'name': 'EPON0/12:2',
                                             'serial_number': None},
                '6c:68:a4:ee:39:a0': {       'dev_macs': ['6c:68:a4:ee:39:a1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:39:a0',
                                             'name': 'EPON0/16:2',
                                             'serial_number': None},
                '6c:68:a4:ee:3b:a0': {       'dev_macs': ['6c:68:a4:ee:3b:a1'],
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:ee:3b:a0',
                                             'name': 'EPON0/13:2',
                                             'serial_number': None},
                '8c:90:2d:56:e8:30': {       'dev_macs': ['8c:90:2d:56:e8:33'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:56:e8:30',
                                             'name': 'EPON0/6:3',
                                             'serial_number': None},
                '8c:90:2d:56:ea:80': {       'dev_macs': ['8c:90:2d:56:ea:83'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:56:ea:80',
                                             'name': 'EPON0/14:4',
                                             'serial_number': None},
                '8c:90:2d:57:02:98': {       'dev_macs': ['8c:90:2d:57:02:9b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:02:98',
                                             'name': 'EPON0/12:7',
                                             'serial_number': None},
                '8c:90:2d:57:03:b8': {       'dev_macs': ['8c:90:2d:57:03:bb'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:03:b8',
                                             'name': 'EPON0/2:12',
                                             'serial_number': None},
                '8c:90:2d:57:04:70': {       'dev_macs': ['8c:90:2d:57:04:73'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:04:70',
                                             'name': 'EPON0/16:13',
                                             'serial_number': None},
                '8c:90:2d:57:17:a0': {       'dev_macs': ['8c:90:2d:57:17:a2'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:17:a0',
                                             'name': 'EPON0/10:10',
                                             'serial_number': None},
                '8c:90:2d:57:1b:30': {       'dev_macs': ['8c:90:2d:57:1b:32'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:1b:30',
                                             'name': 'EPON0/11:8',
                                             'serial_number': None},
                '8c:90:2d:57:1b:78': {       'dev_macs': ['8c:90:2d:57:1b:7b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:1b:78',
                                             'name': 'EPON0/6:2',
                                             'serial_number': None},
                '8c:90:2d:57:1d:10': {       'dev_macs': ['8c:90:2d:57:1d:13'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:1d:10',
                                             'name': 'EPON0/1:7',
                                             'serial_number': None},
                '8c:90:2d:57:3b:08': {       'dev_macs': ['8c:90:2d:57:3b:0a'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:3b:08',
                                             'name': 'EPON0/4:11',
                                             'serial_number': None},
                '8c:90:2d:57:3b:18': {       'dev_macs': ['8c:90:2d:57:3b:1b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:3b:18',
                                             'name': 'EPON0/9:16',
                                             'serial_number': None},
                '8c:90:2d:57:3c:38': {       'dev_macs': ['8c:90:2d:57:3c:3b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:3c:38',
                                             'name': 'EPON0/5:3',
                                             'serial_number': None},
                '8c:90:2d:57:3d:c0': {       'dev_macs': ['8c:90:2d:57:3d:c2'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:3d:c0',
                                             'name': 'EPON0/9:4',
                                             'serial_number': None},
                '8c:90:2d:57:4c:d0': {       'dev_macs': ['8c:90:2d:57:4c:d3'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:4c:d0',
                                             'name': 'EPON0/15:13',
                                             'serial_number': None},
                '8c:90:2d:57:4d:70': {       'dev_macs': ['8c:90:2d:57:4d:72'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:4d:70',
                                             'name': 'EPON0/9:14',
                                             'serial_number': None},
                '8c:90:2d:57:4d:80': {       'dev_macs': ['8c:90:2d:57:4d:83'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:4d:80',
                                             'name': 'EPON0/15:4',
                                             'serial_number': None},
                '8c:90:2d:57:4e:88': {       'dev_macs': ['8c:90:2d:57:4e:8b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:4e:88',
                                             'name': 'EPON0/15:12',
                                             'serial_number': None},
                '8c:90:2d:57:50:80': {       'dev_macs': ['8c:90:2d:57:50:82'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:50:80',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '8c:90:2d:57:97:28': {       'dev_macs': ['8c:90:2d:57:97:2b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:97:28',
                                             'name': 'EPON0/7:10',
                                             'serial_number': None},
                '8c:90:2d:57:97:c8': {       'dev_macs': ['8c:90:2d:57:97:cb'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:97:c8',
                                             'name': 'EPON0/10:6',
                                             'serial_number': None},
                '8c:90:2d:57:98:e0': {       'dev_macs': ['8c:90:2d:57:98:e3'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:98:e0',
                                             'name': 'EPON0/6:7',
                                             'serial_number': None},
                '8c:90:2d:57:99:80': {       'dev_macs': ['8c:90:2d:57:99:83'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:99:80',
                                             'name': 'EPON0/14:5',
                                             'serial_number': None},
                '8c:90:2d:57:9a:10': {       'dev_macs': ['8c:90:2d:57:9a:13'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:9a:10',
                                             'name': 'EPON0/4:6',
                                             'serial_number': None},
                '8c:90:2d:57:9b:c8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:9b:c8',
                                             'name': 'EPON0/6:10',
                                             'serial_number': None},
                '8c:90:2d:57:a0:88': {       'dev_macs': ['8c:90:2d:57:a0:8b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:a0:88',
                                             'name': 'EPON0/10:7',
                                             'serial_number': None},
                '8c:90:2d:57:b1:98': {       'dev_macs': ['8c:90:2d:57:b1:9b'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:b1:98',
                                             'name': 'EPON0/13:11',
                                             'serial_number': None},
                '8c:90:2d:57:b8:b0': {       'dev_macs': ['8c:90:2d:57:b8:b3'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:b8:b0',
                                             'name': 'EPON0/10:12',
                                             'serial_number': None},
                '8c:90:2d:57:b8:c8': {       'dev_macs': ['8c:90:2d:57:b8:cb'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:b8:c8',
                                             'name': 'EPON0/14:9',
                                             'serial_number': None},
                '8c:90:2d:57:b9:a0': {       'dev_macs': ['8c:90:2d:57:b9:a3'],
                                             'ip_address': None,
                                             'mac_address': '8c:90:2d:57:b9:a0',
                                             'name': 'EPON0/13:12',
                                             'serial_number': None},
                '98:ba:5f:2a:26:88': {       'dev_macs': ['98:ba:5f:2a:26:8b'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:26:88',
                                             'name': 'EPON0/7:12',
                                             'serial_number': None},
                '98:ba:5f:2a:32:e0': {       'dev_macs': ['98:ba:5f:2a:32:e3'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:32:e0',
                                             'name': 'EPON0/15:15',
                                             'serial_number': None},
                '98:ba:5f:2a:38:38': {       'dev_macs': ['98:ba:5f:2a:38:3b'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:38:38',
                                             'name': 'EPON0/4:9',
                                             'serial_number': None},
                '98:ba:5f:2a:39:88': {       'dev_macs': ['98:ba:5f:2a:39:8b'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:39:88',
                                             'name': 'EPON0/10:11',
                                             'serial_number': None},
                '98:ba:5f:2a:3f:88': {       'dev_macs': ['98:ba:5f:2a:3f:8a'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:3f:88',
                                             'name': 'EPON0/9:15',
                                             'serial_number': None},
                '98:ba:5f:2a:41:20': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:41:20',
                                             'name': 'EPON0/11:12',
                                             'serial_number': None},
                '98:ba:5f:2a:46:e0': {       'dev_macs': ['98:ba:5f:2a:46:e3'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:46:e0',
                                             'name': 'EPON0/15:3',
                                             'serial_number': None},
                '98:ba:5f:2a:63:10': {       'dev_macs': ['98:ba:5f:2a:63:13'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:63:10',
                                             'name': 'EPON0/14:7',
                                             'serial_number': None},
                '98:ba:5f:2a:67:80': {       'dev_macs': ['98:ba:5f:2a:67:83'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:67:80',
                                             'name': 'EPON0/16:11',
                                             'serial_number': None},
                '98:ba:5f:2a:68:08': {       'dev_macs': ['98:ba:5f:2a:68:0b'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:68:08',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '98:ba:5f:2a:a8:58': {       'dev_macs': ['98:ba:5f:2a:a8:5b'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:a8:58',
                                             'name': 'EPON0/3:19',
                                             'serial_number': None},
                '98:ba:5f:2a:a9:40': {       'dev_macs': ['98:ba:5f:2a:a9:43'],
                                             'ip_address': None,
                                             'mac_address': '98:ba:5f:2a:a9:40',
                                             'name': 'EPON0/7:27',
                                             'serial_number': None},
                'ac:12:8e:91:7f:c0': {       'dev_macs': ['08:55:31:a1:c2:19'],
                                             'ip_address': None,
                                             'mac_address': 'ac:12:8e:91:7f:c0',
                                             'name': 'EPON0/15:9',
                                             'serial_number': None},
                'b0:19:21:81:df:d0': {       'dev_macs': ['b0:19:21:81:df:d2'],
                                             'ip_address': None,
                                             'mac_address': 'b0:19:21:81:df:d0',
                                             'name': 'EPON0/10:9',
                                             'serial_number': None},
                'e0:d3:62:41:fd:28': {       'dev_macs': ['e0:d3:62:41:fd:2b'],
                                             'ip_address': None,
                                             'mac_address': 'e0:d3:62:41:fd:28',
                                             'name': 'EPON0/11:16',
                                             'serial_number': None},
                'e0:d3:62:42:1f:f8': {       'dev_macs': ['e0:d3:62:42:1f:fb'],
                                             'ip_address': None,
                                             'mac_address': 'e0:d3:62:42:1f:f8',
                                             'name': 'EPON0/4:13',
                                             'serial_number': None},
                'e0:d3:62:42:52:80': {       'dev_macs': ['e0:d3:62:42:52:83'],
                                             'ip_address': None,
                                             'mac_address': 'e0:d3:62:42:52:80',
                                             'name': 'EPON0/13:17',
                                             'serial_number': None},
                'ec:75:0c:1f:b1:88': {       'dev_macs': ['ec:75:0c:1f:b1:8b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:b1:88',
                                             'name': 'EPON0/9:20',
                                             'serial_number': None},
                'ec:75:0c:1f:cd:40': {       'dev_macs': ['ec:75:0c:1f:cd:42'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:cd:40',
                                             'name': 'EPON0/16:18',
                                             'serial_number': None},
                'ec:75:0c:1f:df:e0': {       'dev_macs': ['ec:75:0c:1f:df:e3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:df:e0',
                                             'name': 'EPON0/9:17',
                                             'serial_number': None},
                'ec:75:0c:1f:e2:f0': {       'dev_macs': ['ec:75:0c:1f:e2:f3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:e2:f0',
                                             'name': 'EPON0/14:18',
                                             'serial_number': None},
                'ec:75:0c:1f:e3:a8': {       'dev_macs': ['ec:75:0c:1f:e3:ab'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:e3:a8',
                                             'name': 'EPON0/15:19',
                                             'serial_number': None},
                'ec:75:0c:1f:f2:10': {       'dev_macs': ['ec:75:0c:1f:f2:13'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:f2:10',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                'ec:75:0c:1f:fa:18': {       'dev_macs': ['ec:75:0c:1f:fa:1a'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:fa:18',
                                             'name': 'EPON0/8:7',
                                             'serial_number': None},
                'ec:75:0c:1f:fc:58': {       'dev_macs': ['ec:75:0c:1f:fc:5b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:fc:58',
                                             'name': 'EPON0/11:13',
                                             'serial_number': None},
                'ec:75:0c:1f:fc:f0': {       'dev_macs': ['ec:75:0c:1f:fc:f3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:1f:fc:f0',
                                             'name': 'EPON0/3:12',
                                             'serial_number': None},
                'ec:75:0c:20:13:d8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:13:d8',
                                             'name': 'EPON0/15:11',
                                             'serial_number': None},
                'ec:75:0c:20:36:18': {       'dev_macs': ['ec:75:0c:20:36:1b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:36:18',
                                             'name': 'EPON0/9:5',
                                             'serial_number': None},
                'ec:75:0c:20:3d:90': {       'dev_macs': ['ec:75:0c:20:3d:93'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:3d:90',
                                             'name': 'EPON0/7:22',
                                             'serial_number': None},
                'ec:75:0c:20:57:f8': {       'dev_macs': ['ec:75:0c:20:57:fb'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:57:f8',
                                             'name': 'EPON0/15:10',
                                             'serial_number': None},
                'ec:75:0c:20:65:78': {       'dev_macs': ['ec:75:0c:20:65:7b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:65:78',
                                             'name': 'EPON0/12:11',
                                             'serial_number': None},
                'ec:75:0c:20:6e:d8': {       'dev_macs': ['ec:75:0c:20:6e:db'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:6e:d8',
                                             'name': 'EPON0/14:6',
                                             'serial_number': None},
                'ec:75:0c:20:71:b0': {       'dev_macs': ['ec:75:0c:20:71:b3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:20:71:b0',
                                             'name': 'EPON0/16:14',
                                             'serial_number': None},
                'ec:75:0c:64:41:60': {       'dev_macs': ['ec:75:0c:64:41:63'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:64:41:60',
                                             'name': 'EPON0/7:24',
                                             'serial_number': None},
                'ec:75:0c:71:aa:e0': {       'dev_macs': ['ec:75:0c:71:aa:e3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:aa:e0',
                                             'name': 'EPON0/12:6',
                                             'serial_number': None},
                'ec:75:0c:71:ac:f8': {       'dev_macs': ['ec:75:0c:71:ac:fb'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:ac:f8',
                                             'name': 'EPON0/4:10',
                                             'serial_number': None},
                'ec:75:0c:71:c0:78': {       'dev_macs': ['ec:75:0c:71:c0:7b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c0:78',
                                             'name': 'EPON0/15:14',
                                             'serial_number': None},
                'ec:75:0c:71:c2:c0': {       'dev_macs': ['ec:75:0c:71:c2:c2'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c2:c0',
                                             'name': 'EPON0/10:8',
                                             'serial_number': None},
                'ec:75:0c:71:c3:e0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c3:e0',
                                             'name': 'EPON0/5:7',
                                             'serial_number': None},
                'ec:75:0c:71:c6:18': {       'dev_macs': ['ec:75:0c:71:c6:1b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c6:18',
                                             'name': 'EPON0/13:7',
                                             'serial_number': None},
                'ec:75:0c:71:c8:a0': {       'dev_macs': ['ec:75:0c:71:c8:a3'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c8:a0',
                                             'name': 'EPON0/5:6',
                                             'serial_number': None},
                'ec:75:0c:71:c9:20': {       'dev_macs': ['ec:75:0c:71:c9:23'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:c9:20',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                'ec:75:0c:71:d4:58': {       'dev_macs': ['ec:75:0c:71:d4:5b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:d4:58',
                                             'name': 'EPON0/7:13',
                                             'serial_number': None},
                'ec:75:0c:71:f1:c0': {       'dev_macs': ['ec:75:0c:71:f1:c2'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:f1:c0',
                                             'name': 'EPON0/9:3',
                                             'serial_number': None},
                'ec:75:0c:71:fc:80': {       'dev_macs': ['ec:75:0c:71:fc:83'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:fc:80',
                                             'name': 'EPON0/11:11',
                                             'serial_number': None},
                'ec:75:0c:71:ff:a0': {       'dev_macs': ['ec:75:0c:71:ff:a2'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:71:ff:a0',
                                             'name': 'EPON0/11:7',
                                             'serial_number': None},
                'ec:75:0c:72:00:10': {       'dev_macs': ['ec:75:0c:72:00:12'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:00:10',
                                             'name': 'EPON0/4:5',
                                             'serial_number': None},
                'ec:75:0c:72:20:40': {       'dev_macs': ['ec:75:0c:72:20:43'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:20:40',
                                             'name': 'EPON0/15:18',
                                             'serial_number': None},
                'ec:75:0c:72:20:78': {       'dev_macs': ['ec:75:0c:72:20:7a'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:20:78',
                                             'name': 'EPON0/5:2',
                                             'serial_number': None},
                'ec:75:0c:72:22:c0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:22:c0',
                                             'name': 'EPON0/14:10',
                                             'serial_number': None},
                'ec:75:0c:72:28:d8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:28:d8',
                                             'name': 'EPON0/14:11',
                                             'serial_number': None},
                'ec:75:0c:72:2d:18': {       'dev_macs': ['ec:75:0c:72:2d:1b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:2d:18',
                                             'name': 'EPON0/2:9',
                                             'serial_number': None},
                'ec:75:0c:72:2f:08': {       'dev_macs': ['ec:75:0c:72:2f:0b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:2f:08',
                                             'name': 'EPON0/7:14',
                                             'serial_number': None},
                'ec:75:0c:72:30:a0': {       'dev_macs': ['ec:75:0c:72:30:a2'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:30:a0',
                                             'name': 'EPON0/5:4',
                                             'serial_number': None},
                'ec:75:0c:72:30:e8': {       'dev_macs': ['ec:75:0c:72:30:ea'],
                                             'ip_address': None,
                                             'mac_address': 'ec:75:0c:72:30:e8',
                                             'name': 'EPON0/1:10',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 32.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'GigaEthernet0/1',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:83',
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODNpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/2',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:84',
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODRpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/3',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:85',
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODVpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/4',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:86',
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:87',
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODdpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/6',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:88',
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODhpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/7',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:89',
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6ODlpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'GigaEthernet0/8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:8a',
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGFpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/1',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:8b',
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGJpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/2',
                                                              'in_octets': '8500297962115',
                                                              'in_ucast_pkts': '6595030771',
                                                              'mac_address': '00:55:b1:cf:83:8c',
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': True,
                                                              'out_octets': '814711735152',
                                                              'out_ucast_pkts': '2750921405',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGNpbnRm',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/3',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:8d',
                                                              'name': 'TGigaEthernet0/3',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGRpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/4',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:8e',
                                                              'name': 'TGigaEthernet0/4',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGVpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:8f',
                                                              'name': 'TGigaEthernet0/5',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OGZpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'TGigaEthernet0/6',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:55:b1:cf:83:90',
                                                              'name': 'TGigaEthernet0/6',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTBpbnRm'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/1',
                                                              'in_octets': '19440757098',
                                                              'in_ucast_pkts': '126423859',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1f:85:40'],
                                                                                       'in_octets': '1120293971',
                                                                                       'in_ucast_pkts': '3216442',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8976419241',
                                                                                       'out_ucast_pkts': '7451489',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:5c:e9'],
                                                                                       'in_octets': '71046863',
                                                                                       'in_ucast_pkts': '400114',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1457374295',
                                                                                       'out_ucast_pkts': '1211957',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:51:fe:13'],
                                                                                       'in_octets': '223309660',
                                                                                       'in_ucast_pkts': '1326278',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '3397058111',
                                                                                       'out_ucast_pkts': '2716589',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:6f:79'],
                                                                                       'in_octets': '10919412',
                                                                                       'in_ucast_pkts': '61341',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '9197280',
                                                                                       'out_ucast_pkts': '49937',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:33:9b'],
                                                                                       'in_octets': '22304471',
                                                                                       'in_ucast_pkts': '154448',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16309498',
                                                                                       'out_ucast_pkts': '77644',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:76:d9'],
                                                                                       'in_octets': '1322597447',
                                                                                       'in_ucast_pkts': '9298542',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '50876203595',
                                                                                       'out_ucast_pkts': '34697711',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:1d:13'],
                                                                                       'in_octets': '1794504267',
                                                                                       'in_ucast_pkts': '11746262',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28846658885',
                                                                                       'out_ucast_pkts': '22592115',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:12:43'],
                                                                                       'in_octets': '7382412902',
                                                                                       'in_ucast_pkts': '69383527',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '134626806078',
                                                                                       'out_ucast_pkts': '94168366',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:51:f1:12'],
                                                                                       'in_octets': '1475217889',
                                                                                       'in_ucast_pkts': '7114567',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27722403668',
                                                                                       'out_ucast_pkts': '21517809',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:30:ea'],
                                                                                       'in_octets': '556998995',
                                                                                       'in_ucast_pkts': '2772794',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8981098131',
                                                                                       'out_ucast_pkts': '6630241',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a3:c6:9b'],
                                                                                       'in_octets': '1771192578',
                                                                                       'in_ucast_pkts': '11311606',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '37374097371',
                                                                                       'out_ucast_pkts': '27767495',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:7b:b9'],
                                                                                       'in_octets': '3690841183',
                                                                                       'in_ucast_pkts': '9638010',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '26369234343',
                                                                                       'out_ucast_pkts': '21539617',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:91',
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'out_octets': '328656210816',
                                                              'out_ucast_pkts': '240435817',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm',
                                                              'pons': [       {       'description': '0/1',
                                                                                      'id': 'EPON0/1',
                                                                                      'links': [       {       'connected_time': '110725',
                                                                                                               'fiber_length': 1613,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '56272',
                                                                                                               'fiber_length': 1895,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 1007,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110716',
                                                                                                               'fiber_length': 1016,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '23838',
                                                                                                               'fiber_length': 1315,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '234461',
                                                                                                               'fiber_length': 1159,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '1203',
                                                                                                               'fiber_length': 1965,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 2508,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110373',
                                                                                                               'fiber_length': 1963,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 2516,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '107688',
                                                                                                               'fiber_length': 1506,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 1847,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -35.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/1',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/2',
                                                              'in_octets': '24674241406',
                                                              'in_ucast_pkts': '80535899',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:b0:70:49'],
                                                                                       'in_octets': '7681068505',
                                                                                       'in_ucast_pkts': '8942728',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16219315888',
                                                                                       'out_ucast_pkts': '13926493',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:c9:23'],
                                                                                       'in_octets': '639425090',
                                                                                       'in_ucast_pkts': '6105448',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23176120472',
                                                                                       'out_ucast_pkts': '16659611',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:f2:13'],
                                                                                       'in_octets': '3178864312',
                                                                                       'in_ucast_pkts': '10102002',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '39694294046',
                                                                                       'out_ucast_pkts': '30026746',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:68:0b'],
                                                                                       'in_octets': '233262805',
                                                                                       'in_ucast_pkts': '976855',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '2912850604',
                                                                                       'out_ucast_pkts': '2424325',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:e9:d9'],
                                                                                       'in_octets': '2781789729',
                                                                                       'in_ucast_pkts': '12941512',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '40361188639',
                                                                                       'out_ucast_pkts': '30561725',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:43:89'],
                                                                                       'in_octets': '977471978',
                                                                                       'in_ucast_pkts': '2576956',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6704955104',
                                                                                       'out_ucast_pkts': '5365532',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:99:55:57'],
                                                                                       'in_octets': '2886207906',
                                                                                       'in_ucast_pkts': '13077318',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '53389628166',
                                                                                       'out_ucast_pkts': '40925786',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:2d:1b'],
                                                                                       'in_octets': '25137979',
                                                                                       'in_ucast_pkts': '175541',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15712332',
                                                                                       'out_ucast_pkts': '93903',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:50:82'],
                                                                                       'in_octets': '2311907879',
                                                                                       'in_ucast_pkts': '9834356',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '29352802329',
                                                                                       'out_ucast_pkts': '23075482',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:bb:d9'],
                                                                                       'in_octets': '1321678719',
                                                                                       'in_ucast_pkts': '4869487',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10751257936',
                                                                                       'out_ucast_pkts': '9156729',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:03:bb'],
                                                                                       'in_octets': '829183264',
                                                                                       'in_ucast_pkts': '3370150',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '9628864706',
                                                                                       'out_ucast_pkts': '7758169',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:f6:9b'],
                                                                                       'in_octets': '1808903355',
                                                                                       'in_ucast_pkts': '7563940',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '21121396522',
                                                                                       'out_ucast_pkts': '17854388',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:92',
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'out_octets': '253327630579',
                                                              'out_ucast_pkts': '197833725',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm',
                                                              'pons': [       {       'description': '0/2',
                                                                                      'id': 'EPON0/2',
                                                                                      'links': [       {       'connected_time': '110718',
                                                                                                               'fiber_length': 1511,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -17.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '99694',
                                                                                                               'fiber_length': 1334,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -16.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '63123',
                                                                                                               'fiber_length': 1816,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -16.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 1866,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -17.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '15625',
                                                                                                               'fiber_length': 1869,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -17.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '27534',
                                                                                                               'fiber_length': 1978,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107005',
                                                                                                               'fiber_length': 1487,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110727',
                                                                                                               'fiber_length': 1070,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -16.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 1266,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '47831',
                                                                                                               'fiber_length': 1944,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -15.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 1175,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -15.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 1251,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/2',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/3',
                                                              'in_octets': '38841232531',
                                                              'in_ucast_pkts': '144336254',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1e:6a:00'],
                                                                                       'in_octets': '2336900058',
                                                                                       'in_ucast_pkts': '8754302',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '38774462292',
                                                                                       'out_ucast_pkts': '30084167',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:21:59'],
                                                                                       'in_octets': '1495268906',
                                                                                       'in_ucast_pkts': '4464893',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15707125555',
                                                                                       'out_ucast_pkts': '12508456',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:42:19'],
                                                                                       'in_octets': '1169839092',
                                                                                       'in_ucast_pkts': '6569186',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '66334951775',
                                                                                       'out_ucast_pkts': '45633364',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:99:22:37'],
                                                                                       'in_octets': '1025497014',
                                                                                       'in_ucast_pkts': '5793270',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '36905163764',
                                                                                       'out_ucast_pkts': '28899131',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:06:e1'],
                                                                                       'in_octets': '586120511',
                                                                                       'in_ucast_pkts': '4000800',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15713215931',
                                                                                       'out_ucast_pkts': '11683817',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:70:a9'],
                                                                                       'in_octets': '3326082891',
                                                                                       'in_ucast_pkts': '10282809',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '30122740925',
                                                                                       'out_ucast_pkts': '24079147',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:eb:19'],
                                                                                       'in_octets': '1539362233',
                                                                                       'in_ucast_pkts': '2310498',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5442412757',
                                                                                       'out_ucast_pkts': '4433716',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:3c:e9'],
                                                                                       'in_octets': '3055296827',
                                                                                       'in_ucast_pkts': '24445434',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '58848225268',
                                                                                       'out_ucast_pkts': '42719208',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:9d:99'],
                                                                                       'in_octets': '2607131867',
                                                                                       'in_ucast_pkts': '7142959',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '29089365465',
                                                                                       'out_ucast_pkts': '23091163',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:2b:eb'],
                                                                                       'in_octets': '819179441',
                                                                                       'in_ucast_pkts': '4503880',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13500273284',
                                                                                       'out_ucast_pkts': '10005292',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:fc:f3'],
                                                                                       'in_octets': '2139112305',
                                                                                       'in_ucast_pkts': '10149969',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '33933197573',
                                                                                       'out_ucast_pkts': '27144922',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:60:f2:29'],
                                                                                       'in_octets': '4115765016',
                                                                                       'in_ucast_pkts': '16230928',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '54226494446',
                                                                                       'out_ucast_pkts': '43591455',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:47:89'],
                                                                                       'in_octets': '2009812676',
                                                                                       'in_ucast_pkts': '11063572',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '45703889259',
                                                                                       'out_ucast_pkts': '35479470',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDc6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a4:1a:f3'],
                                                                                       'in_octets': '6166401680',
                                                                                       'in_ucast_pkts': '7469160',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17780020435',
                                                                                       'out_ucast_pkts': '14323450',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MWE6ZjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a4:10:6b'],
                                                                                       'in_octets': '37490616',
                                                                                       'in_ucast_pkts': '256389',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '20536487',
                                                                                       'out_ucast_pkts': '98314',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTA6NjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a3:fa:c3'],
                                                                                       'in_octets': '843642897',
                                                                                       'in_ucast_pkts': '4361510',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14573521611',
                                                                                       'out_ucast_pkts': '11266656',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6ZmE6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:bc:d2'],
                                                                                       'in_octets': '5429520677',
                                                                                       'in_ucast_pkts': '15757553',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '61155856309',
                                                                                       'out_ucast_pkts': '48072571',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6YmM6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:a8:5b'],
                                                                                       'in_octets': '139559294',
                                                                                       'in_ucast_pkts': '778799',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '2063046991',
                                                                                       'out_ucast_pkts': '1691979',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6YTg6NThpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:93',
                                                              'name': 'EPON0/3',
                                                              'oper_up': True,
                                                              'out_octets': '539902360408',
                                                              'out_ucast_pkts': '414827895',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm',
                                                              'pons': [       {       'description': '0/3',
                                                                                      'id': 'EPON0/3',
                                                                                      'links': [       {       'connected_time': '107347',
                                                                                                               'fiber_length': 1772,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '95877',
                                                                                                               'fiber_length': 1616,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107590',
                                                                                                               'fiber_length': 2476,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 1671,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 1282,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '99654',
                                                                                                               'fiber_length': 1887,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110719',
                                                                                                               'fiber_length': 1587,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 1764,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2341,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 1670,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107419',
                                                                                                               'fiber_length': 2388,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110716',
                                                                                                               'fiber_length': 1550,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107445',
                                                                                                               'fiber_length': 1827,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NDc6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110727',
                                                                                                               'fiber_length': 1879,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MWE6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 1715,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTA6NjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107398',
                                                                                                               'fiber_length': 2404,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6ZmE6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110731',
                                                                                                               'fiber_length': 1667,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6YmM6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '72126',
                                                                                                               'fiber_length': 1845,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6YTg6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/3',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/4',
                                                              'in_octets': '24147229401',
                                                              'in_ucast_pkts': '87095911',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1f:04:f0'],
                                                                                       'in_octets': '857056056',
                                                                                       'in_ucast_pkts': '4441301',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '26311034774',
                                                                                       'out_ucast_pkts': '20715188',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6MDQ6ZWZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7a:1c:03'],
                                                                                       'in_octets': '23526087',
                                                                                       'in_ucast_pkts': '106094',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14453764',
                                                                                       'out_ucast_pkts': '57540',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6MWM6MDJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:d2:d3'],
                                                                                       'in_octets': '8091324779',
                                                                                       'in_ucast_pkts': '16951581',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '46678832367',
                                                                                       'out_ucast_pkts': '37591652',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6ZDI6ZDJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:98:f2:17'],
                                                                                       'in_octets': '4449563261',
                                                                                       'in_ucast_pkts': '21526043',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '87739234952',
                                                                                       'out_ucast_pkts': '67074645',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OTg6ZjI6MTZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:00:12'],
                                                                                       'in_octets': '618908972',
                                                                                       'in_ucast_pkts': '3431448',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13229831439',
                                                                                       'out_ucast_pkts': '10277904',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MDA6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:9a:13'],
                                                                                       'in_octets': '1607481921',
                                                                                       'in_ucast_pkts': '3757815',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16582848146',
                                                                                       'out_ucast_pkts': '12987574',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OWE6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:df:b9'],
                                                                                       'in_octets': '977738720',
                                                                                       'in_ucast_pkts': '5548241',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '22097907342',
                                                                                       'out_ucast_pkts': '17138065',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZGY6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:8e:39'],
                                                                                       'in_octets': '1356788723',
                                                                                       'in_ucast_pkts': '6466268',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19622872243',
                                                                                       'out_ucast_pkts': '15270118',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6OGU6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:38:3b'],
                                                                                       'in_octets': '407366931',
                                                                                       'in_ucast_pkts': '2115077',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8417232125',
                                                                                       'out_ucast_pkts': '6464914',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:ac:fb'],
                                                                                       'in_octets': '2714085806',
                                                                                       'in_ucast_pkts': '7598147',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '25026023360',
                                                                                       'out_ucast_pkts': '19961126',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YWM6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:3b:0a'],
                                                                                       'in_octets': '743958986',
                                                                                       'in_ucast_pkts': '4586451',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15796325512',
                                                                                       'out_ucast_pkts': '11956705',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2I6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:01:1a'],
                                                                                       'in_octets': '1166753988',
                                                                                       'in_ucast_pkts': '5806299',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '21604847945',
                                                                                       'out_ucast_pkts': '16903718',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDE6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'e0:d3:62:42:1f:fb'],
                                                                                       'in_octets': '1134614564',
                                                                                       'in_ucast_pkts': '4761260',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13097267681',
                                                                                       'out_ucast_pkts': '10297232',
                                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDI6MWY6ZjhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:94',
                                                              'name': 'EPON0/4',
                                                              'oper_up': True,
                                                              'out_octets': '316222234835',
                                                              'out_ucast_pkts': '246713864',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTRpbnRm',
                                                              'pons': [       {       'description': '0/4',
                                                                                      'id': 'EPON0/4',
                                                                                      'links': [       {       'connected_time': '97948',
                                                                                                               'fiber_length': 1563,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6MDQ6ZWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110712',
                                                                                                               'fiber_length': 1777,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6MWM6MDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '57517',
                                                                                                               'fiber_length': 1498,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6ZDI6ZDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '47773',
                                                                                                               'fiber_length': 1752,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTg6ZjI6MTZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '102403',
                                                                                                               'fiber_length': 1508,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MDA6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110706',
                                                                                                               'fiber_length': 2169,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OWE6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '107651',
                                                                                                               'fiber_length': 2451,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ZGY6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '107599',
                                                                                                               'fiber_length': 1459,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6OGU6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -32.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '106888',
                                                                                                               'fiber_length': 2425,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzg6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 2224,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6YWM6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 1414,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6M2I6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 2255,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDE6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1},
                                                                                                       {       'connected_time': '110708',
                                                                                                               'fiber_length': 1705,
                                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDI6MWY6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.1}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/4',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/5',
                                                              'in_octets': '27439156534',
                                                              'in_ucast_pkts': '75310692',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:2e:a8:e7'],
                                                                                       'in_octets': '4797624067',
                                                                                       'in_ucast_pkts': '12926437',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '53365515082',
                                                                                       'out_ucast_pkts': '40967122',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmU6YTg6ZTZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:20:7a'],
                                                                                       'in_octets': '12939772185',
                                                                                       'in_ucast_pkts': '27868272',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '136025146052',
                                                                                       'out_ucast_pkts': '102905543',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MjA6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:3c:3b'],
                                                                                       'in_octets': '449641084',
                                                                                       'in_ucast_pkts': '2622515',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6092855274',
                                                                                       'out_ucast_pkts': '4829084',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2M6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:30:a2'],
                                                                                       'in_octets': '195576905',
                                                                                       'in_ucast_pkts': '1100976',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '4324880743',
                                                                                       'out_ucast_pkts': '3558703',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:9f:09'],
                                                                                       'in_octets': '4176931879',
                                                                                       'in_ucast_pkts': '7295297',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18785264248',
                                                                                       'out_ucast_pkts': '15604621',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6OWY6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:c8:a3'],
                                                                                       'in_octets': '4003431074',
                                                                                       'in_ucast_pkts': '19457037',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '65658880689',
                                                                                       'out_ucast_pkts': '49967311',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6Yzg6YTBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YzM6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:15:29'],
                                                                                       'in_octets': '271175427',
                                                                                       'in_ucast_pkts': '1879112',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10206212485',
                                                                                       'out_ucast_pkts': '7760591',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6MTU6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:63:39'],
                                                                                       'in_octets': '281020723',
                                                                                       'in_ucast_pkts': '915874',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '2445843671',
                                                                                       'out_ucast_pkts': '2061397',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6NjM6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a3:be:23'],
                                                                                       'in_octets': '138889681',
                                                                                       'in_ucast_pkts': '512780',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1474245780',
                                                                                       'out_ucast_pkts': '1271598',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6YmU6MjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:04:f3'],
                                                                                       'in_octets': '185658822',
                                                                                       'in_ucast_pkts': '732507',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1812527954',
                                                                                       'out_ucast_pkts': '1573709',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6ZjBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:95',
                                                              'name': 'EPON0/5',
                                                              'oper_up': True,
                                                              'out_octets': '300196900452',
                                                              'out_ucast_pkts': '230517143',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTVpbnRm',
                                                              'pons': [       {       'description': '0/5',
                                                                                      'id': 'EPON0/5',
                                                                                      'links': [       {       'connected_time': '68285',
                                                                                                               'fiber_length': 1945,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmU6YTg6ZTZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '1190749',
                                                                                                               'fiber_length': 1847,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MjA6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110719',
                                                                                                               'fiber_length': 1885,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6M2M6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '31131',
                                                                                                               'fiber_length': 1765,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '106979',
                                                                                                               'fiber_length': 1908,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6OWY6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '21892',
                                                                                                               'fiber_length': 1663,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6Yzg6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'poller_hash': 'ZWM6NzU6MGM6NzE6YzM6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '11665',
                                                                                                               'fiber_length': 1824,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6MTU6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 1834,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6NjM6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 1626,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6YmU6MjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '76981',
                                                                                                               'fiber_length': 1714,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDQ6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/5',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTVpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/6',
                                                              'in_octets': '14453261731',
                                                              'in_ucast_pkts': '91327098',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1e:ff:c0'],
                                                                                       'in_octets': '1733327206',
                                                                                       'in_ucast_pkts': '7576619',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '24401531560',
                                                                                       'out_ucast_pkts': '20140564',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6ZmY6YmZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:1b:7b'],
                                                                                       'in_octets': '5238776113',
                                                                                       'in_ucast_pkts': '55678322',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '121130406728',
                                                                                       'out_ucast_pkts': '82686785',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MWI6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:56:e8:33'],
                                                                                       'in_octets': '119100752',
                                                                                       'in_ucast_pkts': '706185',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '2482220302',
                                                                                       'out_ucast_pkts': '1977535',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTY6ZTg6MzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:be:b9'],
                                                                                       'in_octets': '1420676693',
                                                                                       'in_ucast_pkts': '4583934',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23476274892',
                                                                                       'out_ucast_pkts': '18832704',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6YmU6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:9e:89'],
                                                                                       'in_octets': '1317329649',
                                                                                       'in_ucast_pkts': '7097760',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27843333640',
                                                                                       'out_ucast_pkts': '21701840',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6OWU6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:47:09'],
                                                                                       'in_octets': '18130154',
                                                                                       'in_ucast_pkts': '90252',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13919966',
                                                                                       'out_ucast_pkts': '60135',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDc6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:98:e3'],
                                                                                       'in_octets': '2213995559',
                                                                                       'in_ucast_pkts': '4718297',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '11356094542',
                                                                                       'out_ucast_pkts': '10535026',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTg6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:6d:b9'],
                                                                                       'in_octets': '1689394086',
                                                                                       'in_ucast_pkts': '8552945',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27093549514',
                                                                                       'out_ucast_pkts': '21665227',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6NmQ6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7a:d5:03'],
                                                                                       'in_octets': '702815508',
                                                                                       'in_ucast_pkts': '2322812',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6032941870',
                                                                                       'out_ucast_pkts': '4971560',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6ZDU6MDJpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OWI6YzhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:96',
                                                              'name': 'EPON0/6',
                                                              'oper_up': True,
                                                              'out_octets': '243830452926',
                                                              'out_ucast_pkts': '182574665',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTZpbnRm',
                                                              'pons': [       {       'description': '0/6',
                                                                                      'id': 'EPON0/6',
                                                                                      'links': [       {       'connected_time': '110716',
                                                                                                               'fiber_length': 2129,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6ZmY6YmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 2395,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MWI6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '85677',
                                                                                                               'fiber_length': 3358,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTY6ZTg6MzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '107372',
                                                                                                               'fiber_length': 3063,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6YmU6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 2038,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6OWU6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110716',
                                                                                                               'fiber_length': 2280,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NDc6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110723',
                                                                                                               'fiber_length': 2336,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTg6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '26425',
                                                                                                               'fiber_length': 2325,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6NmQ6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 2549,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6ZDU6MDJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'poller_hash': 'OGM6OTA6MmQ6NTc6OWI6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/6',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTZpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/7',
                                                              'in_octets': '69194023943',
                                                              'in_ucast_pkts': '230445143',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:20:1c:40'],
                                                                                       'in_octets': '6107874919',
                                                                                       'in_ucast_pkts': '42718008',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '157562967481',
                                                                                       'out_ucast_pkts': '112370345',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MWM6M2ZpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmU6YjY6YjZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:1f:19:f0'],
                                                                                       'in_octets': '118367053',
                                                                                       'in_ucast_pkts': '544224',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '821629404',
                                                                                       'out_ucast_pkts': '703822',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6MTk6ZWZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:5a:6c:0d'],
                                                                                       'in_octets': '1399372177',
                                                                                       'in_ucast_pkts': '13400223',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '35730491969',
                                                                                       'out_ucast_pkts': '25246342',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NWE6NmM6MGNpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:32:ca'],
                                                                                       'in_octets': '2861687631',
                                                                                       'in_ucast_pkts': '18272431',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '60391159346',
                                                                                       'out_ucast_pkts': '43432474',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzI6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:1f:10:10',
                                                                                                                        '6c:68:a4:1f:10:11'],
                                                                                       'in_octets': '686049006',
                                                                                       'in_ucast_pkts': '2493560',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '11424923309',
                                                                                       'out_ucast_pkts': '9465913',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6MTA6MGZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:78:69'],
                                                                                       'in_octets': '10347905674',
                                                                                       'in_ucast_pkts': '43037993',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '104220705292',
                                                                                       'out_ucast_pkts': '77173310',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6Nzg6NjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ed:fb:71'],
                                                                                       'in_octets': '1651775398',
                                                                                       'in_ucast_pkts': '12308438',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '41382757432',
                                                                                       'out_ucast_pkts': '29149803',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6ZmI6NzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2b:f0:27'],
                                                                                       'in_octets': '975800929',
                                                                                       'in_ucast_pkts': '5795139',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '34866474292',
                                                                                       'out_ucast_pkts': '25125033',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmI6ZjA6MjZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:1b:c3'],
                                                                                       'in_octets': '415923425',
                                                                                       'in_ucast_pkts': '2820564',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '11508685730',
                                                                                       'out_ucast_pkts': '8747613',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6MWI6YzJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:97:2b'],
                                                                                       'in_octets': '2502134745',
                                                                                       'in_ucast_pkts': '3764997',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14807653543',
                                                                                       'out_ucast_pkts': '11732334',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTc6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:30:da'],
                                                                                       'in_octets': '15393445561',
                                                                                       'in_ucast_pkts': '25596003',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '52995055615',
                                                                                       'out_ucast_pkts': '46344458',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzA6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:26:8b'],
                                                                                       'in_octets': '2948305794',
                                                                                       'in_ucast_pkts': '5728952',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18456468559',
                                                                                       'out_ucast_pkts': '15144486',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6MjY6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:d4:5b'],
                                                                                       'in_octets': '23549228',
                                                                                       'in_ucast_pkts': '156024',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14445613',
                                                                                       'out_ucast_pkts': '98484',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6ZDQ6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:2f:0b'],
                                                                                       'in_octets': '22094380',
                                                                                       'in_ucast_pkts': '164404',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13469523',
                                                                                       'out_ucast_pkts': '88162',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MmY6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:91:99'],
                                                                                       'in_octets': '3945404977',
                                                                                       'in_ucast_pkts': '5447659',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10528249747',
                                                                                       'out_ucast_pkts': '9320130',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6OTE6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:f0:29'],
                                                                                       'in_octets': '1259187093',
                                                                                       'in_ucast_pkts': '3836908',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18497906778',
                                                                                       'out_ucast_pkts': '14408326',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZjA6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:87:29'],
                                                                                       'in_octets': '21823153',
                                                                                       'in_ucast_pkts': '117446',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5878986',
                                                                                       'out_ucast_pkts': '43875',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6ODc6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:a0:89'],
                                                                                       'in_octets': '1407659840',
                                                                                       'in_ucast_pkts': '5084412',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18421171397',
                                                                                       'out_ucast_pkts': '14395014',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6YTA6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:6f:a9'],
                                                                                       'in_octets': '20040045',
                                                                                       'in_ucast_pkts': '114166',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19298102',
                                                                                       'out_ucast_pkts': '51383',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NmY6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:1a:e9'],
                                                                                       'in_octets': '8294284162',
                                                                                       'in_ucast_pkts': '15425357',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '38857382957',
                                                                                       'out_ucast_pkts': '31884810',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6MWE6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:3d:93'],
                                                                                       'in_octets': '595220654',
                                                                                       'in_ucast_pkts': '2287484',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10380052395',
                                                                                       'out_ucast_pkts': '7860559',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6M2Q6OTBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZDI6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:64:41:63'],
                                                                                       'in_octets': '2742189070',
                                                                                       'in_ucast_pkts': '4539817',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8612498108',
                                                                                       'out_ucast_pkts': '7259094',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NjQ6NDE6NjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:32:d3'],
                                                                                       'in_octets': '1041973728',
                                                                                       'in_ucast_pkts': '4739748',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16126520861',
                                                                                       'out_ucast_pkts': '12627972',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzI6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:0f:bb'],
                                                                                       'in_octets': '1354677777',
                                                                                       'in_ucast_pkts': '7779470',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '44818722742',
                                                                                       'out_ucast_pkts': '32158330',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MGY6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:a9:43'],
                                                                                       'in_octets': '3060702829',
                                                                                       'in_ucast_pkts': '4272051',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6370201851',
                                                                                       'out_ucast_pkts': '6112586',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6YTk6NDBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:97',
                                                              'name': 'EPON0/7',
                                                              'oper_up': True,
                                                              'out_octets': '716838855668',
                                                              'out_ucast_pkts': '540962611',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTdpbnRm',
                                                              'pons': [       {       'description': '0/7',
                                                                                      'id': 'EPON0/7',
                                                                                      'links': [       {       'connected_time': '91482',
                                                                                                               'fiber_length': 2207,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MWM6M2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'poller_hash': 'NmM6Njg6YTQ6MmU6YjY6YjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3288,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6MTk6ZWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '82807',
                                                                                                               'fiber_length': 3155,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NWE6NmM6MGNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110635',
                                                                                                               'fiber_length': 1920,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MzI6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '106925',
                                                                                                               'fiber_length': 3241,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6MTA6MGZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '58548',
                                                                                                               'fiber_length': 3183,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6Nzg6NjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '107306',
                                                                                                               'fiber_length': 3048,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6ZmI6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '5590',
                                                                                                               'fiber_length': 2075,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmI6ZjA6MjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3094,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6MWI6YzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '108624',
                                                                                                               'fiber_length': 1968,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTc6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 3458,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MzA6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110729',
                                                                                                               'fiber_length': 3006,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6MjY6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 1973,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6ZDQ6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 3319,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MmY6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 1944,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6OTE6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2224,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ZjA6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2959,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6ODc6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110720',
                                                                                                               'fiber_length': 3468,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6YTA6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '16963',
                                                                                                               'fiber_length': 2054,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NmY6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '107356',
                                                                                                               'fiber_length': 3139,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6MWE6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '14648',
                                                                                                               'fiber_length': 2249,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6M2Q6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -18.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZDI6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 1970,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NjQ6NDE6NjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 2044,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MzI6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 3321,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MGY6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 2104,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6YTk6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/7',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTdpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/8',
                                                              'in_octets': '17895058068',
                                                              'in_ucast_pkts': '52979225',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:7b:8e:73'],
                                                                                       'in_octets': '1000572857',
                                                                                       'in_ucast_pkts': '4581461',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14452042098',
                                                                                       'out_ucast_pkts': '11308709',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OGU6NzJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:2d:4b'],
                                                                                       'in_octets': '2198572756',
                                                                                       'in_ucast_pkts': '12582967',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27020463381',
                                                                                       'out_ucast_pkts': '20961310',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MmQ6NDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:13:79'],
                                                                                       'in_octets': '11064642',
                                                                                       'in_ucast_pkts': '73333',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6935178',
                                                                                       'out_ucast_pkts': '47501',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6MTM6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:8f:23'],
                                                                                       'in_octets': '3000897097',
                                                                                       'in_ucast_pkts': '7333653',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23059527835',
                                                                                       'out_ucast_pkts': '18090065',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6MjJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:18:39'],
                                                                                       'in_octets': '3884314807',
                                                                                       'in_ucast_pkts': '7901461',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '22997348075',
                                                                                       'out_ucast_pkts': '18766646',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6MTg6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:fa:1a'],
                                                                                       'in_octets': '1153909659',
                                                                                       'in_ucast_pkts': '7318518',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '26327079839',
                                                                                       'out_ucast_pkts': '20809380',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZmE6MThpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MTM6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:bb:bb'],
                                                                                       'in_octets': '6134109357',
                                                                                       'in_ucast_pkts': '10538929',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16546939102',
                                                                                       'out_ucast_pkts': '15677269',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6YmI6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:58:c3'],
                                                                                       'in_octets': '511720376',
                                                                                       'in_ucast_pkts': '2648907',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5835598760',
                                                                                       'out_ucast_pkts': '4501894',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NTg6YzBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:98',
                                                              'name': 'EPON0/8',
                                                              'oper_up': True,
                                                              'out_octets': '136250155881',
                                                              'out_ucast_pkts': '110180364',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OThpbnRm',
                                                              'pons': [       {       'description': '0/8',
                                                                                      'id': 'EPON0/8',
                                                                                      'links': [       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2078,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6OGU6NzJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '924570',
                                                                                                               'fiber_length': 2615,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MmQ6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2884,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6MTM6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '106906',
                                                                                                               'fiber_length': 2263,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6OGY6MjJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2082,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6MTg6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2124,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZmE6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'poller_hash': 'MzA6Njg6OTM6YjI6MTM6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2858,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6YmI6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2202,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NTg6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -19.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/8',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OThpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/9',
                                                              'in_octets': '42092907518',
                                                              'in_ucast_pkts': '168019811',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1e:f9:d0'],
                                                                                       'in_octets': '2396790254',
                                                                                       'in_ucast_pkts': '20484074',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '65787326736',
                                                                                       'out_ucast_pkts': '47103663',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Zjk6Y2ZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:1f:0d:c0'],
                                                                                       'in_octets': '3321949865',
                                                                                       'in_ucast_pkts': '19277628',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '52736762521',
                                                                                       'out_ucast_pkts': '43882986',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6MGQ6YmZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:f1:c2'],
                                                                                       'in_octets': '2322871947',
                                                                                       'in_ucast_pkts': '11387626',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '52817381403',
                                                                                       'out_ucast_pkts': '38331620',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6ZjE6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:3d:c2'],
                                                                                       'in_octets': '10194766814',
                                                                                       'in_ucast_pkts': '21263297',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '54513998970',
                                                                                       'out_ucast_pkts': '46039386',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2Q6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:36:1b'],
                                                                                       'in_octets': '866065408',
                                                                                       'in_ucast_pkts': '4943809',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '20168377011',
                                                                                       'out_ucast_pkts': '15136069',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6MzY6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:4b:09'],
                                                                                       'in_octets': '2418104202',
                                                                                       'in_ucast_pkts': '11050702',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '43859587510',
                                                                                       'out_ucast_pkts': '31908376',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NGI6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:eb:c9'],
                                                                                       'in_octets': '1012072079',
                                                                                       'in_ucast_pkts': '2302030',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6152146531',
                                                                                       'out_ucast_pkts': '5612988',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZWI6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:43:99'],
                                                                                       'in_octets': '1415317200',
                                                                                       'in_ucast_pkts': '9188400',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '60354106836',
                                                                                       'out_ucast_pkts': '42459883',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6NDM6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:61:79'],
                                                                                       'in_octets': '869694746',
                                                                                       'in_ucast_pkts': '3920214',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14401779749',
                                                                                       'out_ucast_pkts': '10643166',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NjE6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:a7:e3'],
                                                                                       'in_octets': '893011908',
                                                                                       'in_ucast_pkts': '2289202',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14150207708',
                                                                                       'out_ucast_pkts': '11411671',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6YTc6ZTJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:46:e9'],
                                                                                       'in_octets': '1332787001',
                                                                                       'in_ucast_pkts': '7976200',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '22981396422',
                                                                                       'out_ucast_pkts': '17654205',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDY6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:e9:19'],
                                                                                       'in_octets': '647987075',
                                                                                       'in_ucast_pkts': '3339422',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13127534150',
                                                                                       'out_ucast_pkts': '10366428',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:4d:72'],
                                                                                       'in_octets': '5762062883',
                                                                                       'in_ucast_pkts': '18073478',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '47952515792',
                                                                                       'out_ucast_pkts': '36193849',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NGQ6NzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:3f:8a'],
                                                                                       'in_octets': '360893600',
                                                                                       'in_ucast_pkts': '1798077',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '6423723180',
                                                                                       'out_ucast_pkts': '5286008',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6M2Y6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:3b:1b'],
                                                                                       'in_octets': '3596465658',
                                                                                       'in_ucast_pkts': '11392591',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '34128648464',
                                                                                       'out_ucast_pkts': '26658400',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6M2I6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:df:e3'],
                                                                                       'in_octets': '1085977238',
                                                                                       'in_ucast_pkts': '5271301',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '25580206022',
                                                                                       'out_ucast_pkts': '20312139',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZGY6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:2b:2b'],
                                                                                       'in_octets': '1045306671',
                                                                                       'in_ucast_pkts': '5294631',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17908656186',
                                                                                       'out_ucast_pkts': '14227997',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MmI6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a3:bd:3b'],
                                                                                       'in_octets': '1222665798',
                                                                                       'in_ucast_pkts': '5130322',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15762492644',
                                                                                       'out_ucast_pkts': '12532379',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6YmQ6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:b1:8b'],
                                                                                       'in_octets': '1329284467',
                                                                                       'in_ucast_pkts': '3636968',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '12030822509',
                                                                                       'out_ucast_pkts': '10439716',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6YjE6ODhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:99',
                                                              'name': 'EPON0/9',
                                                              'oper_up': True,
                                                              'out_octets': '580837031658',
                                                              'out_ucast_pkts': '446214766',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTlpbnRm',
                                                              'pons': [       {       'description': '0/9',
                                                                                      'id': 'EPON0/9',
                                                                                      'links': [       {       'connected_time': '110722',
                                                                                                               'fiber_length': 3828,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6Zjk6Y2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '107083',
                                                                                                               'fiber_length': 3943,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6MGQ6YmZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '74125',
                                                                                                               'fiber_length': 2719,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6ZjE6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3502,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6M2Q6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '27912',
                                                                                                               'fiber_length': 2336,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6MzY6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '587957',
                                                                                                               'fiber_length': 2422,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NGI6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2737,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ZWI6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '106268',
                                                                                                               'fiber_length': 3027,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6NDM6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2557,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NjE6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '29200',
                                                                                                               'fiber_length': 2923,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6YTc6ZTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '106713',
                                                                                                               'fiber_length': 2865,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NDY6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '25104',
                                                                                                               'fiber_length': 2876,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 2750,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NGQ6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3674,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6M2Y6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2620,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6M2I6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110701',
                                                                                                               'fiber_length': 3872,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZGY6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '99837',
                                                                                                               'fiber_length': 2310,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MmI6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '9345',
                                                                                                               'fiber_length': 2672,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6YmQ6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '26891',
                                                                                                               'fiber_length': 3930,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6YjE6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/9',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTlpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/10',
                                                              'in_octets': '69536238699',
                                                              'in_ucast_pkts': '204295314',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:b0:9f:a9'],
                                                                                       'in_octets': '41891566',
                                                                                       'in_ucast_pkts': '157385',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '185828699',
                                                                                       'out_ucast_pkts': '221707',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6OWY6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:02:53'],
                                                                                       'in_octets': '1806560356',
                                                                                       'in_ucast_pkts': '10118556',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '48615612071',
                                                                                       'out_ucast_pkts': '39298053',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6MDI6NTJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:e9:f9'],
                                                                                       'in_octets': '3174851937',
                                                                                       'in_ucast_pkts': '9358998',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '22893472682',
                                                                                       'out_ucast_pkts': '19934968',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:4e:b9'],
                                                                                       'in_octets': '5476411028',
                                                                                       'in_ucast_pkts': '12796809',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '40422032279',
                                                                                       'out_ucast_pkts': '33607860',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NGU6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:a0:92'],
                                                                                       'in_octets': '1921039620',
                                                                                       'in_ucast_pkts': '10615265',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '43776379678',
                                                                                       'out_ucast_pkts': '32432184',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6YTA6OTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:97:cb'],
                                                                                       'in_octets': '1777095',
                                                                                       'in_ucast_pkts': '11886',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1142260',
                                                                                       'out_ucast_pkts': '6307',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTc6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:a0:8b'],
                                                                                       'in_octets': '25763113818',
                                                                                       'in_ucast_pkts': '27914302',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '38685249195',
                                                                                       'out_ucast_pkts': '33685920',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6YTA6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:c2:c2'],
                                                                                       'in_octets': '4884931647',
                                                                                       'in_ucast_pkts': '28827927',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '99652096585',
                                                                                       'out_ucast_pkts': '75119289',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YzI6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'b0:19:21:81:df:d2'],
                                                                                       'in_octets': '1957584212',
                                                                                       'in_ucast_pkts': '6833960',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '22155197972',
                                                                                       'out_ucast_pkts': '17430126',
                                                                                       'poller_hash': 'YjA6MTk6MjE6ODE6ZGY6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:17:a2'],
                                                                                       'in_octets': '3446687993',
                                                                                       'in_ucast_pkts': '18066063',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '57951944093',
                                                                                       'out_ucast_pkts': '41554093',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MTc6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:39:8b'],
                                                                                       'in_octets': '4193312367',
                                                                                       'in_ucast_pkts': '21584389',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '101581760344',
                                                                                       'out_ucast_pkts': '73921054',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Mzk6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:b8:b3'],
                                                                                       'in_octets': '2795588679',
                                                                                       'in_ucast_pkts': '9512281',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27729784483',
                                                                                       'out_ucast_pkts': '21651240',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6Yjg6YjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:ba:b9'],
                                                                                       'in_octets': '1162468213',
                                                                                       'in_ucast_pkts': '4350408',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19644839062',
                                                                                       'out_ucast_pkts': '14994657',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6YmE6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:bc:bb'],
                                                                                       'in_octets': '6618287341',
                                                                                       'in_ucast_pkts': '12551356',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '34209039250',
                                                                                       'out_ucast_pkts': '29029694',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6YmM6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:ec:fa'],
                                                                                       'in_octets': '2742557975',
                                                                                       'in_ucast_pkts': '15038527',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '46227355197',
                                                                                       'out_ucast_pkts': '35198417',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZWM6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:58:73'],
                                                                                       'in_octets': '916575494',
                                                                                       'in_ucast_pkts': '3648706',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10811805785',
                                                                                       'out_ucast_pkts': '8304605',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6NTg6NzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:fe:e2:1b'],
                                                                                       'in_octets': '2219676168',
                                                                                       'in_ucast_pkts': '10543434',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '48767222282',
                                                                                       'out_ucast_pkts': '36506938',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6ZmU6ZTI6MThpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'MGM6ZWY6MTU6MjA6ZWM6NzBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9a',
                                                              'name': 'EPON0/10',
                                                              'oper_up': True,
                                                              'out_octets': '673393559109',
                                                              'out_ucast_pkts': '520865626',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWFpbnRm',
                                                              'pons': [       {       'description': '0/10',
                                                                                      'id': 'EPON0/10',
                                                                                      'links': [       {       'connected_time': '1433192',
                                                                                                               'fiber_length': 2404,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6OWY6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '187',
                                                                                                               'fiber_length': 3102,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6MDI6NTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2372,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 2202,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NGU6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2938,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6YTA6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '9340',
                                                                                                               'fiber_length': 2434,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTc6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '1414882',
                                                                                                               'fiber_length': 3079,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6YTA6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '325',
                                                                                                               'fiber_length': 3048,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6YzI6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2143,
                                                                                                               'poller_hash': 'YjA6MTk6MjE6ODE6ZGY6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2949,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MTc6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '72972',
                                                                                                               'fiber_length': 3397,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Mzk6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110382',
                                                                                                               'fiber_length': 3021,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6Yjg6YjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 2291,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6YmE6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 2302,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6YmM6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '83496',
                                                                                                               'fiber_length': 2435,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZWM6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '104301',
                                                                                                               'fiber_length': 2349,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6NTg6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'connected_time': '110731',
                                                                                                               'fiber_length': 2213,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6ZmU6ZTI6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.9},
                                                                                                       {       'poller_hash': 'MGM6ZWY6MTU6MjA6ZWM6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/10',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWFpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/11',
                                                              'in_octets': '23765792438',
                                                              'in_ucast_pkts': '74761429',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:1e:96:a0'],
                                                                                       'in_octets': '2576151024',
                                                                                       'in_ucast_pkts': '8051820',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18204085539',
                                                                                       'out_ucast_pkts': '15173063',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6OTY6OWZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:5b:c6:dd'],
                                                                                       'in_octets': '1547564145',
                                                                                       'in_ucast_pkts': '6926917',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28420717021',
                                                                                       'out_ucast_pkts': '22331962',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NWI6YzY6ZGNpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:9b:b9'],
                                                                                       'in_octets': '7261467343',
                                                                                       'in_ucast_pkts': '12847508',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28815492970',
                                                                                       'out_ucast_pkts': '24168818',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6OWI6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:99:99'],
                                                                                       'in_octets': '5481600244',
                                                                                       'in_ucast_pkts': '11850817',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '36797677188',
                                                                                       'out_ucast_pkts': '29815559',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6OTk6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:99:1e:37'],
                                                                                       'in_octets': '95629131',
                                                                                       'in_ucast_pkts': '525737',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1745225972',
                                                                                       'out_ucast_pkts': '1466102',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6MWU6MzZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:ff:a2'],
                                                                                       'in_octets': '1134427355',
                                                                                       'in_ucast_pkts': '3689241',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14262852175',
                                                                                       'out_ucast_pkts': '11526640',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6ZmY6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:1b:32'],
                                                                                       'in_octets': '363725807',
                                                                                       'in_ucast_pkts': '1451833',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '4705187562',
                                                                                       'out_ucast_pkts': '4311890',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MWI6MzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:78:29'],
                                                                                       'in_octets': '893727463',
                                                                                       'in_ucast_pkts': '3575773',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '10684345907',
                                                                                       'out_ucast_pkts': '8617962',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6Nzg6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:90:29'],
                                                                                       'in_octets': '7853618',
                                                                                       'in_ucast_pkts': '46714',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5505409',
                                                                                       'out_ucast_pkts': '42499',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6OTA6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:fc:83'],
                                                                                       'in_octets': '1420696319',
                                                                                       'in_ucast_pkts': '8330057',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28002729460',
                                                                                       'out_ucast_pkts': '21762072',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6ZmM6ODBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6NDE6MjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:fc:5b'],
                                                                                       'in_octets': '1176651932',
                                                                                       'in_ucast_pkts': '7545859',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27045171155',
                                                                                       'out_ucast_pkts': '20738849',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:ff:83'],
                                                                                       'in_octets': '22036905',
                                                                                       'in_ucast_pkts': '161906',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13030968',
                                                                                       'out_ucast_pkts': '87442',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZmY6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:fe:e0:db'],
                                                                                       'in_octets': '455294145',
                                                                                       'in_ucast_pkts': '3019317',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8719695229',
                                                                                       'out_ucast_pkts': '7254107',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6ZmU6ZTA6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'e0:d3:62:41:fd:2b'],
                                                                                       'in_octets': '323990517',
                                                                                       'in_ucast_pkts': '1474206',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '3102196460',
                                                                                       'out_ucast_pkts': '2623939',
                                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDE6ZmQ6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a4:81:cb'],
                                                                                       'in_octets': '1004839887',
                                                                                       'in_ucast_pkts': '5263346',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17337292162',
                                                                                       'out_ucast_pkts': '13577840',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6ODE6YzhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9b',
                                                              'name': 'EPON0/11',
                                                              'oper_up': True,
                                                              'out_octets': '227864673963',
                                                              'out_ucast_pkts': '183503317',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWJpbnRm',
                                                              'pons': [       {       'description': '0/11',
                                                                                      'id': 'EPON0/11',
                                                                                      'links': [       {       'connected_time': '110716',
                                                                                                               'fiber_length': 3694,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6OTY6OWZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110549',
                                                                                                               'fiber_length': 3486,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NWI6YzY6ZGNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '98756',
                                                                                                               'fiber_length': 3457,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6OWI6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -31.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110722',
                                                                                                               'fiber_length': 3369,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6OTk6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 3906,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6MWU6MzZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '88984',
                                                                                                               'fiber_length': 3402,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6ZmY6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '22413',
                                                                                                               'fiber_length': 4347,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MWI6MzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 3867,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6Nzg6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110717',
                                                                                                               'fiber_length': 4456,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6OTA6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '107532',
                                                                                                               'fiber_length': 4285,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6ZmM6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'poller_hash': 'OTg6YmE6NWY6MmE6NDE6MjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '99466',
                                                                                                               'fiber_length': 3849,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 4514,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZmY6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 3705,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6ZmU6ZTA6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '105620',
                                                                                                               'fiber_length': 3178,
                                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDE6ZmQ6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2},
                                                                                                       {       'connected_time': '44971',
                                                                                                               'fiber_length': 4530,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6ODE6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.2}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/11',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWJpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/12',
                                                              'in_octets': '52147020973',
                                                              'in_ucast_pkts': '178136465',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:5b:a5:5d'],
                                                                                       'in_octets': '17405833611',
                                                                                       'in_ucast_pkts': '56681565',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '146831710139',
                                                                                       'out_ucast_pkts': '125694123',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6NWI6YTU6NWNpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:26:41'],
                                                                                       'in_octets': '3553226672',
                                                                                       'in_ucast_pkts': '10410410',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '24095240224',
                                                                                       'out_ucast_pkts': '19436557',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6MjY6NDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:28:59'],
                                                                                       'in_octets': '1021787931',
                                                                                       'in_ucast_pkts': '10207083',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '30464789014',
                                                                                       'out_ucast_pkts': '21617576',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6Mjg6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ed:8d:c1'],
                                                                                       'in_octets': '10316480872',
                                                                                       'in_ucast_pkts': '18832348',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '68378276617',
                                                                                       'out_ucast_pkts': '56038918',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6OGQ6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:1f:d1'],
                                                                                       'in_octets': '2557979317',
                                                                                       'in_ucast_pkts': '6137006',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '25945632333',
                                                                                       'out_ucast_pkts': '19899747',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6MWY6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:aa:e3'],
                                                                                       'in_octets': '1021502326',
                                                                                       'in_ucast_pkts': '4028278',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16031719253',
                                                                                       'out_ucast_pkts': '13001125',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YWE6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:02:9b'],
                                                                                       'in_octets': '239297746',
                                                                                       'in_ucast_pkts': '1596253',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '4563616784',
                                                                                       'out_ucast_pkts': '3544633',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MDI6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:e6:59'],
                                                                                       'in_octets': '1355625773',
                                                                                       'in_ucast_pkts': '9652542',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '32503419933',
                                                                                       'out_ucast_pkts': '23763473',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6ZTY6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:51:f9:53'],
                                                                                       'in_octets': '6990711177',
                                                                                       'in_ucast_pkts': '24596172',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '75660275722',
                                                                                       'out_ucast_pkts': '60823717',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6Zjk6NTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:00:93'],
                                                                                       'in_octets': '560681941',
                                                                                       'in_ucast_pkts': '3832621',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17394534938',
                                                                                       'out_ucast_pkts': '13484960',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDA6OTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:65:7b'],
                                                                                       'in_octets': '253403367',
                                                                                       'in_ucast_pkts': '1943357',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5910403144',
                                                                                       'out_ucast_pkts': '4390681',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6NjU6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:05:ab'],
                                                                                       'in_octets': '1255853600',
                                                                                       'in_ucast_pkts': '5729217',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '24113518420',
                                                                                       'out_ucast_pkts': '19469885',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDU6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:24:13'],
                                                                                       'in_octets': '2182960805',
                                                                                       'in_ucast_pkts': '12156703',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '40347813427',
                                                                                       'out_ucast_pkts': '30852173',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MjQ6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:ff:8b'],
                                                                                       'in_octets': '2341372382',
                                                                                       'in_ucast_pkts': '5855897',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '18969557821',
                                                                                       'out_ucast_pkts': '15480797',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZmY6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:3e:83'],
                                                                                       'in_octets': '36714616',
                                                                                       'in_ucast_pkts': '303419',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23092787',
                                                                                       'out_ucast_pkts': '137539',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6M2U6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:fd:83'],
                                                                                       'in_octets': '1054067978',
                                                                                       'in_ucast_pkts': '6173576',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '37245413383',
                                                                                       'out_ucast_pkts': '27446843',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZmQ6ODBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9c',
                                                              'name': 'EPON0/12',
                                                              'oper_up': True,
                                                              'out_octets': '568482724082',
                                                              'out_ucast_pkts': '455094054',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWNpbnRm',
                                                              'pons': [       {       'description': '0/12',
                                                                                      'id': 'EPON0/12',
                                                                                      'links': [       {       'connected_time': '19339',
                                                                                                               'fiber_length': 4054,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6NWI6YTU6NWNpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '31414',
                                                                                                               'fiber_length': 3014,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6MjY6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110721',
                                                                                                               'fiber_length': 3909,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6Mjg6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110722',
                                                                                                               'fiber_length': 3116,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6OGQ6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '107504',
                                                                                                               'fiber_length': 3338,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6MWY6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '98657',
                                                                                                               'fiber_length': 3068,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6YWE6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110724',
                                                                                                               'fiber_length': 3199,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MDI6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110722',
                                                                                                               'fiber_length': 3199,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6ZTY6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '54812',
                                                                                                               'fiber_length': 3840,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6Zjk6NTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3888,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDA6OTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110706',
                                                                                                               'fiber_length': 3191,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6NjU6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3757,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDU6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3060,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MjQ6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 3152,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZmY6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '10078',
                                                                                                               'fiber_length': 3763,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6M2U6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7},
                                                                                                       {       'connected_time': '17293',
                                                                                                               'fiber_length': 3231,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZmQ6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.7}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/12',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWNpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/13',
                                                              'in_octets': '44513261342',
                                                              'in_ucast_pkts': '158837623',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:b0:55:49'],
                                                                                       'in_octets': '2914493148',
                                                                                       'in_ucast_pkts': '14818244',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '41628025185',
                                                                                       'out_ucast_pkts': '34671757',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NTU6NDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:3b:a1'],
                                                                                       'in_octets': '32807165',
                                                                                       'in_ucast_pkts': '171562',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '11285568',
                                                                                       'out_ucast_pkts': '60392',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6M2I6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:3b:e9'],
                                                                                       'in_octets': '2624102069',
                                                                                       'in_ucast_pkts': '16727773',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '57099552989',
                                                                                       'out_ucast_pkts': '46033957',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6M2I6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:81:99'],
                                                                                       'in_octets': '34176729',
                                                                                       'in_ucast_pkts': '216299',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '7222469',
                                                                                       'out_ucast_pkts': '51109',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6ODE6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2b:e5:f7'],
                                                                                       'in_octets': '1157918411',
                                                                                       'in_ucast_pkts': '2893889',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13328240053',
                                                                                       'out_ucast_pkts': '9831463',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmI6ZTU6ZjZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2b:fa:67'],
                                                                                       'in_octets': '4686988141',
                                                                                       'in_ucast_pkts': '13850167',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '52923523451',
                                                                                       'out_ucast_pkts': '40044680',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmI6ZmE6NjZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:c6:1b'],
                                                                                       'in_octets': '913514733',
                                                                                       'in_ucast_pkts': '4731147',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17718978000',
                                                                                       'out_ucast_pkts': '14140078',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YzY6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:3b:b9'],
                                                                                       'in_octets': '3648596612',
                                                                                       'in_ucast_pkts': '14194134',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '50481535096',
                                                                                       'out_ucast_pkts': '39376541',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6M2I6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:e9:29'],
                                                                                       'in_octets': '3114225310',
                                                                                       'in_ucast_pkts': '12631164',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '43935331806',
                                                                                       'out_ucast_pkts': '33635075',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZTk6MjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ed:cc:d1'],
                                                                                       'in_octets': '7897610250',
                                                                                       'in_ucast_pkts': '17125234',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '57745078059',
                                                                                       'out_ucast_pkts': '44115180',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6Y2M6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:b1:9b'],
                                                                                       'in_octets': '7777874380',
                                                                                       'in_ucast_pkts': '29006637',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '89917289919',
                                                                                       'out_ucast_pkts': '69018630',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6YjE6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:b9:a3'],
                                                                                       'in_octets': '2504377070',
                                                                                       'in_ucast_pkts': '10545189',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28996645789',
                                                                                       'out_ucast_pkts': '23657964',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6Yjk6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:dd:79'],
                                                                                       'in_octets': '4892516822',
                                                                                       'in_ucast_pkts': '11381061',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '29049803291',
                                                                                       'out_ucast_pkts': '22426860',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ZGQ6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:52:f9'],
                                                                                       'in_octets': '8320857',
                                                                                       'in_ucast_pkts': '48941',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5601174',
                                                                                       'out_ucast_pkts': '43187',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NTI6ZjhpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OWE6MWE6YjZpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NzA6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'e0:d3:62:42:52:83'],
                                                                                       'in_octets': '788675650',
                                                                                       'in_ucast_pkts': '3678940',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '13376574722',
                                                                                       'out_ucast_pkts': '10546529',
                                                                                       'poller_hash': 'ZTA6ZDM6NjI6NDI6NTI6ODBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MmY6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a4:25:03'],
                                                                                       'in_octets': '1517479584',
                                                                                       'in_ucast_pkts': '6817347',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '16185110751',
                                                                                       'out_ucast_pkts': '12606474',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MjU6MDBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9d',
                                                              'name': 'EPON0/13',
                                                              'oper_up': True,
                                                              'out_octets': '512415191681',
                                                              'out_ucast_pkts': '400278831',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWRpbnRm',
                                                              'pons': [       {       'description': '0/13',
                                                                                      'id': 'EPON0/13',
                                                                                      'links': [       {       'connected_time': '17538',
                                                                                                               'fiber_length': 3231,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NTU6NDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3079,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6M2I6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '69932',
                                                                                                               'fiber_length': 3170,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6M2I6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3042,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6ODE6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110720',
                                                                                                               'fiber_length': 3317,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmI6ZTU6ZjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -30.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '96145',
                                                                                                               'fiber_length': 3090,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmI6ZmE6NjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '107622',
                                                                                                               'fiber_length': 3045,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6YzY6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3055,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6M2I6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2962,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ZTk6MjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '49989',
                                                                                                               'fiber_length': 3222,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6Y2M6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '66101',
                                                                                                               'fiber_length': 2571,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6YjE6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3121,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6Yjk6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '105718',
                                                                                                               'fiber_length': 2659,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ZGQ6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'connected_time': '8325',
                                                                                                               'fiber_length': 2998,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NTI6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'poller_hash': 'NmM6Njg6YTQ6OWE6MWE6YjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'poller_hash': 'NGM6ZDc6Yzg6NjE6NzA6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 3042,
                                                                                                               'poller_hash': 'ZTA6ZDM6NjI6NDI6NTI6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0},
                                                                                                       {       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MmY6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '24186',
                                                                                                               'fiber_length': 2636,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MjU6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.0,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 6.0}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/13',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWRpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/14',
                                                              'in_octets': '56581223930',
                                                              'in_ucast_pkts': '132637797',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:20:13:80'],
                                                                                       'in_octets': '6460238397',
                                                                                       'in_ucast_pkts': '7231284',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '12379904605',
                                                                                       'out_ucast_pkts': '10873375',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MjA6MTM6N2ZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2c:13:67'],
                                                                                       'in_octets': '1681224635',
                                                                                       'in_ucast_pkts': '9615276',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '36679065210',
                                                                                       'out_ucast_pkts': '27570361',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6MTM6NjZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:56:ea:83'],
                                                                                       'in_octets': '20560358',
                                                                                       'in_ucast_pkts': '150403',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '12202566',
                                                                                       'out_ucast_pkts': '81778',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTY6ZWE6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:99:83'],
                                                                                       'in_octets': '4704258869',
                                                                                       'in_ucast_pkts': '10390992',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '26602635995',
                                                                                       'out_ucast_pkts': '20602789',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6OTk6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:6e:db'],
                                                                                       'in_octets': '1662154932',
                                                                                       'in_ucast_pkts': '7172046',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17443345712',
                                                                                       'out_ucast_pkts': '14116062',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6NmU6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:63:13'],
                                                                                       'in_octets': '16414490143',
                                                                                       'in_ucast_pkts': '20730897',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28011481190',
                                                                                       'out_ucast_pkts': '28828153',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6NjM6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:b8:c9'],
                                                                                       'in_octets': '5180335588',
                                                                                       'in_ucast_pkts': '14278314',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '47396923537',
                                                                                       'out_ucast_pkts': '36727622',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6Yjg6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:b8:cb'],
                                                                                       'in_octets': '1624509262',
                                                                                       'in_ucast_pkts': '7107040',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '42010441879',
                                                                                       'out_ucast_pkts': '30814208',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6Yjg6YzhpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MjI6YzBpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6Mjg6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:bb:e9'],
                                                                                       'in_octets': '2916531800',
                                                                                       'in_ucast_pkts': '12864991',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '38653273701',
                                                                                       'out_ucast_pkts': '28156479',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:63:50:e9'],
                                                                                       'in_octets': '6580285381',
                                                                                       'in_ucast_pkts': '9867364',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '23029691427',
                                                                                       'out_ucast_pkts': '18856194',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NTA6ZThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:86:a9'],
                                                                                       'in_octets': '14747133',
                                                                                       'in_ucast_pkts': '84846',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '7943214',
                                                                                       'out_ucast_pkts': '49971',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6ODY6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:62:7b:d9'],
                                                                                       'in_octets': '2095747455',
                                                                                       'in_ucast_pkts': '9445967',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '31263541724',
                                                                                       'out_ucast_pkts': '24927441',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6ZDhpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6MGE6OThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:e2:f3'],
                                                                                       'in_octets': '688587391',
                                                                                       'in_ucast_pkts': '2184020',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5633097677',
                                                                                       'out_ucast_pkts': '4528267',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZTI6ZjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:f0:3a'],
                                                                                       'in_octets': '2272764283',
                                                                                       'in_ucast_pkts': '8034722',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '36020592222',
                                                                                       'out_ucast_pkts': '28643183',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZjA6MzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:14:c3'],
                                                                                       'in_octets': '3991211335',
                                                                                       'in_ucast_pkts': '11049171',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '30709242496',
                                                                                       'out_ucast_pkts': '24681856',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MTQ6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a3:cf:03'],
                                                                                       'in_octets': '272985509',
                                                                                       'in_ucast_pkts': '2429166',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '8596900490',
                                                                                       'out_ucast_pkts': '5946880',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6Y2Y6MDBpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9e',
                                                              'name': 'EPON0/14',
                                                              'oper_up': True,
                                                              'out_octets': '384453762502',
                                                              'out_ucast_pkts': '305423968',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWVpbnRm',
                                                              'pons': [       {       'description': '0/14',
                                                                                      'id': 'EPON0/14',
                                                                                      'links': [       {       'connected_time': '110732',
                                                                                                               'fiber_length': 5558,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MjA6MTM6N2ZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '65845',
                                                                                                               'fiber_length': 4201,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmM6MTM6NjZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '109844',
                                                                                                               'fiber_length': 3635,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTY6ZWE6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '76167',
                                                                                                               'fiber_length': 3635,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6OTk6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3569,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6NmU6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '1372748',
                                                                                                               'fiber_length': 4101,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6NjM6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '2280',
                                                                                                               'fiber_length': 5192,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6Yjg6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107457',
                                                                                                               'fiber_length': 4999,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6Yjg6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'ZWM6NzU6MGM6NzI6MjI6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'poller_hash': 'ZWM6NzU6MGM6NzI6Mjg6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '107710',
                                                                                                               'fiber_length': 5192,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '137546',
                                                                                                               'fiber_length': 3823,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NTA6ZThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 3600,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6ODY6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -26.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '107289',
                                                                                                               'fiber_length': 3880,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'NGM6ZDc6Yzg6NjM6MGE6OThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '92308',
                                                                                                               'fiber_length': 3770,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZTI6ZjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110736',
                                                                                                               'fiber_length': 5421,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZjA6MzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110741',
                                                                                                               'fiber_length': 4003,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MTQ6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '106891',
                                                                                                               'fiber_length': 5263,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6Y2Y6MDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/14',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWVpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/15',
                                                              'in_octets': '176715253514',
                                                              'in_ucast_pkts': '704006843',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:b0:99:f9'],
                                                                                       'in_octets': '1533152866',
                                                                                       'in_ucast_pkts': '6054094',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '17024803945',
                                                                                       'out_ucast_pkts': '13465619',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6OTk6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:46:e3'],
                                                                                       'in_octets': '3838725711',
                                                                                       'in_ucast_pkts': '21754032',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '73761366741',
                                                                                       'out_ucast_pkts': '54873758',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6NDY6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:4d:83'],
                                                                                       'in_octets': '467857864',
                                                                                       'in_ucast_pkts': '1919091',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '12254779049',
                                                                                       'out_ucast_pkts': '9101260',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NGQ6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:51:ed:52'],
                                                                                       'in_octets': '2865078972',
                                                                                       'in_ucast_pkts': '10331279',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '42278049898',
                                                                                       'out_ucast_pkts': '33461063',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZWQ6NTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:17:79'],
                                                                                       'in_octets': '1119766518',
                                                                                       'in_ucast_pkts': '5919323',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27666226939',
                                                                                       'out_ucast_pkts': '21457141',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6MTc6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ed:af:11'],
                                                                                       'in_octets': '1863361517',
                                                                                       'in_ucast_pkts': '10148478',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '37029674917',
                                                                                       'out_ucast_pkts': '27548641',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWQ6YWY6MTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2b:c2:07'],
                                                                                       'in_octets': '8565931246',
                                                                                       'in_ucast_pkts': '14833977',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '41860532997',
                                                                                       'out_ucast_pkts': '34338483',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmI6YzI6MDZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '08:55:31:a1:c2:19'],
                                                                                       'in_octets': '135413088590',
                                                                                       'in_ucast_pkts': '557687209',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1398442220705',
                                                                                       'out_ucast_pkts': '1122123787',
                                                                                       'poller_hash': 'YWM6MTI6OGU6OTE6N2Y6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:57:fb'],
                                                                                       'in_octets': '91162680',
                                                                                       'in_ucast_pkts': '514268',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1944605495',
                                                                                       'out_ucast_pkts': '1609453',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6NTc6ZjhpbnRm'},
                                                                               {       'oper_up': False,
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6MTM6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:4e:8b'],
                                                                                       'in_octets': '12681601371',
                                                                                       'in_ucast_pkts': '29226076',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '35914935381',
                                                                                       'out_ucast_pkts': '35863225',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NGU6ODhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:4c:d3'],
                                                                                       'in_octets': '1004588168',
                                                                                       'in_ucast_pkts': '6184351',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '27337939302',
                                                                                       'out_ucast_pkts': '20615155',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NGM6ZDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:71:c0:7b'],
                                                                                       'in_octets': '1049715721',
                                                                                       'in_ucast_pkts': '6095872',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '34371602265',
                                                                                       'out_ucast_pkts': '26733708',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6YzA6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:32:e3'],
                                                                                       'in_octets': '1182861177',
                                                                                       'in_ucast_pkts': '5890618',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '40953942353',
                                                                                       'out_ucast_pkts': '31481669',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6MzI6ZTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2c:3b:c7'],
                                                                                       'in_octets': '553567743',
                                                                                       'in_ucast_pkts': '4070497',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19670834133',
                                                                                       'out_ucast_pkts': '14557184',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmM6M2I6YzZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:7a:b9'],
                                                                                       'in_octets': '1075117720',
                                                                                       'in_ucast_pkts': '4555624',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '20345605072',
                                                                                       'out_ucast_pkts': '15515805',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6N2E6YjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:72:20:43'],
                                                                                       'in_octets': '23422336',
                                                                                       'in_ucast_pkts': '166942',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '14153558',
                                                                                       'out_ucast_pkts': '90166',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MjA6NDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:e3:ab'],
                                                                                       'in_octets': '1386266790',
                                                                                       'in_ucast_pkts': '7721361',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '31226325837',
                                                                                       'out_ucast_pkts': '24455808',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZTM6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b2:06:c2'],
                                                                                       'in_octets': '304618748',
                                                                                       'in_ucast_pkts': '1415779',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '5435107248',
                                                                                       'out_ucast_pkts': '4513230',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjI6MDY6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '3c:64:cf:a4:16:7b'],
                                                                                       'in_octets': '401531110',
                                                                                       'in_ucast_pkts': '2856893',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '3342190328',
                                                                                       'out_ucast_pkts': '5393133',
                                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:f6:cb'],
                                                                                       'in_octets': '1212046121',
                                                                                       'in_ucast_pkts': '6164963',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '15778309715',
                                                                                       'out_ucast_pkts': '12114726',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6YzhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '0c:ef:15:20:dc:0a'],
                                                                                       'in_octets': '83855277',
                                                                                       'in_ucast_pkts': '501175',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '3335177631',
                                                                                       'out_ucast_pkts': '2706113',
                                                                                       'poller_hash': 'MGM6ZWY6MTU6MjA6ZGM6MDhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:9f',
                                                              'name': 'EPON0/15',
                                                              'oper_up': True,
                                                              'out_octets': '1889974519052',
                                                              'out_ucast_pkts': '1512023141',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWZpbnRm',
                                                              'pons': [       {       'description': '0/15',
                                                                                      'id': 'EPON0/15',
                                                                                      'links': [       {       'connected_time': '110732',
                                                                                                               'fiber_length': 4039,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6OTk6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '106422',
                                                                                                               'fiber_length': 3734,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6NDY6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '3109038',
                                                                                                               'fiber_length': 3898,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NGQ6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3455,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6ZWQ6NTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '66838',
                                                                                                               'fiber_length': 3447,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6MTc6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '108328',
                                                                                                               'fiber_length': 3707,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWQ6YWY6MTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 4530,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmI6YzI6MDZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110764',
                                                                                                               'fiber_length': 4109,
                                                                                                               'poller_hash': 'YWM6MTI6OGU6OTE6N2Y6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110741',
                                                                                                               'fiber_length': 3979,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6NTc6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'poller_hash': 'ZWM6NzU6MGM6MjA6MTM6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'tx_link_rate': '1000000000'},
                                                                                                       {       'connected_time': '9687',
                                                                                                               'fiber_length': 4105,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NGU6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110736',
                                                                                                               'fiber_length': 3509,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NGM6ZDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3522,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6YzA6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '58091',
                                                                                                               'fiber_length': 4508,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6MzI6ZTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110732',
                                                                                                               'fiber_length': 4714,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmM6M2I6YzZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '73832',
                                                                                                               'fiber_length': 4097,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6N2E6YjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110739',
                                                                                                               'fiber_length': 3794,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MjA6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3660,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZTM6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110736',
                                                                                                               'fiber_length': 4572,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjI6MDY6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 3361,
                                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTQ6MTY6NzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -24.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110738',
                                                                                                               'fiber_length': 4571,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6YzhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8},
                                                                                                       {       'connected_time': '110735',
                                                                                                               'fiber_length': 4097,
                                                                                                               'poller_hash': 'MGM6ZWY6MTU6MjA6ZGM6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -29.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.8}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/15',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OWZpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'EPON0/16',
                                                              'in_octets': '101122939673',
                                                              'in_ucast_pkts': '236326679',
                                                              'links': [       {       'bridged_mac_addresses': [       '6c:68:a4:2e:ba:87'],
                                                                                       'in_octets': '985629385',
                                                                                       'in_ucast_pkts': '5606869',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '20199427475',
                                                                                       'out_ucast_pkts': '15311970',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmU6YmE6ODZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:ee:39:a1'],
                                                                                       'in_octets': '1452624477',
                                                                                       'in_ucast_pkts': '5810791',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19933180577',
                                                                                       'out_ucast_pkts': '14698092',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6Mzk6YTBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:2e:f9'],
                                                                                       'in_octets': '16158345',
                                                                                       'in_ucast_pkts': '85192',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19038966',
                                                                                       'out_ucast_pkts': '54232',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6MmU6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:9b:d9'],
                                                                                       'in_octets': '2019644406',
                                                                                       'in_ucast_pkts': '8433037',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '28392686604',
                                                                                       'out_ucast_pkts': '22583763',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6OWI6ZDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:56:19'],
                                                                                       'in_octets': '121315224',
                                                                                       'in_ucast_pkts': '427738',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '1268853661',
                                                                                       'out_ucast_pkts': '1114779',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NTY6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:b0:27:19'],
                                                                                       'in_octets': '1928644564',
                                                                                       'in_ucast_pkts': '9265877',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '39230804795',
                                                                                       'out_ucast_pkts': '30239585',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6Mjc6MThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:99:48:87'],
                                                                                       'in_octets': '3789553026',
                                                                                       'in_ucast_pkts': '15377858',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '45991406807',
                                                                                       'out_ucast_pkts': '34545435',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6NDg6ODZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:2b:c1:87'],
                                                                                       'in_octets': '13088890726',
                                                                                       'in_ucast_pkts': '17794105',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '34145725161',
                                                                                       'out_ucast_pkts': '29020863',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6MmI6YzE6ODZpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7a:12:a3'],
                                                                                       'in_octets': '2482428554',
                                                                                       'in_ucast_pkts': '14330003',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '58801424884',
                                                                                       'out_ucast_pkts': '42694071',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2E6MTI6YTJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '98:ba:5f:2a:67:83'],
                                                                                       'in_octets': '3676486993',
                                                                                       'in_ucast_pkts': '32231580',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '96675538089',
                                                                                       'out_ucast_pkts': '70373495',
                                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Njc6ODBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '8c:90:2d:57:04:73'],
                                                                                       'in_octets': '1267421134',
                                                                                       'in_ucast_pkts': '2741250',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '9122741016',
                                                                                       'out_ucast_pkts': '7282395',
                                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MDQ6NzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:20:71:b3'],
                                                                                       'in_octets': '43312755058',
                                                                                       'in_ucast_pkts': '40246652',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '43781683820',
                                                                                       'out_ucast_pkts': '39517103',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MjA6NzE6YjBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '6c:68:a4:7b:93:f3'],
                                                                                       'in_octets': '12176897491',
                                                                                       'in_ucast_pkts': '14897701',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '35527257451',
                                                                                       'out_ucast_pkts': '28303414',
                                                                                       'poller_hash': 'NmM6Njg6YTQ6N2I6OTM6ZjJpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:64:24:09'],
                                                                                       'in_octets': '2194738556',
                                                                                       'in_ucast_pkts': '11214591',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '41998548315',
                                                                                       'out_ucast_pkts': '32603527',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6MjQ6MDhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '4c:d7:c8:61:ed:f9'],
                                                                                       'in_octets': '1313080123',
                                                                                       'in_ucast_pkts': '12497645',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '106850513592',
                                                                                       'out_ucast_pkts': '71396560',
                                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWQ6ZjhpbnRm'},
                                                                               {       'bridged_mac_addresses': [       'ec:75:0c:1f:cd:42'],
                                                                                       'in_octets': '3302258916',
                                                                                       'in_ucast_pkts': '10208175',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '53222054929',
                                                                                       'out_ucast_pkts': '40027077',
                                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6Y2Q6NDBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:1f:c3'],
                                                                                       'in_octets': '1147485803',
                                                                                       'in_ucast_pkts': '5114692',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19349950318',
                                                                                       'out_ucast_pkts': '15731225',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MWY6YzBpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:e5:5b'],
                                                                                       'in_octets': '1355262618',
                                                                                       'in_ucast_pkts': '5329973',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '19412831615',
                                                                                       'out_ucast_pkts': '15977705',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZTU6NThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:b1:b8:ab'],
                                                                                       'in_octets': '1383971320',
                                                                                       'in_ucast_pkts': '8878794',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '24399718380',
                                                                                       'out_ucast_pkts': '19840323',
                                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6Yjg6YThpbnRm'},
                                                                               {       'bridged_mac_addresses': [       '30:68:93:52:3e:8b'],
                                                                                       'in_octets': '4108398903',
                                                                                       'in_ucast_pkts': '15835837',
                                                                                       'oper_up': True,
                                                                                       'out_octets': '103539863109',
                                                                                       'out_ucast_pkts': '72824132',
                                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6M2U6ODhpbnRm'}],
                                                              'mac_address': '00:55:b1:cf:83:a0',
                                                              'name': 'EPON0/16',
                                                              'oper_up': True,
                                                              'out_octets': '801863651596',
                                                              'out_ucast_pkts': '604144839',
                                                              'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6YTBpbnRm',
                                                              'pons': [       {       'description': '0/16',
                                                                                      'id': 'EPON0/16',
                                                                                      'links': [       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2938,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmU6YmE6ODZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -25.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110727',
                                                                                                               'fiber_length': 2948,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6Mzk6YTBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2662,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6MmU6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2695,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6OWI6ZDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '1986',
                                                                                                               'fiber_length': 2628,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NTY6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.7,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '106564',
                                                                                                               'fiber_length': 3043,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6Mjc6MThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110719',
                                                                                                               'fiber_length': 3249,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6NDg6ODZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.3,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 3201,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6MmI6YzE6ODZpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2946,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2E6MTI6YTJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -22.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '107429',
                                                                                                               'fiber_length': 3034,
                                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Njc6ODBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.4,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110728',
                                                                                                               'fiber_length': 2789,
                                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MDQ6NzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '107466',
                                                                                                               'fiber_length': 2617,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MjA6NzE6YjBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110726',
                                                                                                               'fiber_length': 2993,
                                                                                                               'poller_hash': 'NmM6Njg6YTQ6N2I6OTM6ZjJpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -23.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '21059',
                                                                                                               'fiber_length': 2716,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6MjQ6MDhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.1,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110725',
                                                                                                               'fiber_length': 3248,
                                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWQ6ZjhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -20.5,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '107179',
                                                                                                               'fiber_length': 3293,
                                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6Y2Q6NDBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.6,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '107487',
                                                                                                               'fiber_length': 2607,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MWY6YzBpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.9,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110727',
                                                                                                               'fiber_length': 2659,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZTU6NThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.8,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '110731',
                                                                                                               'fiber_length': 2620,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6Yjg6YThpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -27.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5},
                                                                                                       {       'connected_time': '106676',
                                                                                                               'fiber_length': 2661,
                                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6M2U6ODhpbnRmZXBvbg==',
                                                                                                               'rx_link_rate': '1000000000',
                                                                                                               'rx_power': -21.2,
                                                                                                               'tx_link_rate': '1000000000',
                                                                                                               'tx_power': 5.5}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -6.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': '0/16',
                                                                                      'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6YTBpbnRmZXBvbg==',
                                                                                      'pon_technology': 'EPON',
                                                                                      'rx_link_rate': '1000000000',
                                                                                      'split_ratio': 64,
                                                                                      'tx_link_rate': '1000000000'}],
                                                              'speed': '1000000000'}],
                                'manufacturer': 'BDCOM',
                                'mem': 73.0,
                                'model': 'P3600-16E',
                                'serial_number': '0000329001187',
                                'sw_version': '10.1.0G Build 136974',
                                'temperature': 55.0},
                'peers': [       {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:1',
                                                                       'in_octets': '8976419241',
                                                                       'in_ucast_pkts': '7451489',
                                                                       'links': [       {       'in_octets': '8976419241',
                                                                                                'in_ucast_pkts': '7451489',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1120293971',
                                                                                                'out_ucast_pkts': '3216442',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '1120293971',
                                                                       'out_ucast_pkts': '3216442',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZpbnRm',
                                                                       'pons': [       {       'description': '0/1:1',
                                                                                               'id': 'EPON0/1:1',
                                                                                               'links': [       {       'connected_time': '110725',
                                                                                                                        'fiber_length': 1613,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1120293971',
                                                                       'in_ucast_pkts': '3216442',
                                                                       'mac_address': '6c:68:a4:1f:85:3f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '8976419241',
                                                                       'out_ucast_pkts': '7451489',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6ODU6M2ZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:85:3f',
                                         'uptime': '110725'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:2',
                                                                       'in_octets': '1457374295',
                                                                       'in_ucast_pkts': '1211957',
                                                                       'links': [       {       'in_octets': '1457374295',
                                                                                                'in_ucast_pkts': '1211957',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '71046863',
                                                                                                'out_ucast_pkts': '400114',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'out_octets': '71046863',
                                                                       'out_ucast_pkts': '400114',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/1:2',
                                                                                               'id': 'EPON0/1:2',
                                                                                               'links': [       {       'connected_time': '56272',
                                                                                                                        'fiber_length': 1895,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:2',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '71046863',
                                                                       'in_ucast_pkts': '400114',
                                                                       'mac_address': '6c:68:a4:b0:5c:e8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1457374295',
                                                                       'out_ucast_pkts': '1211957',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'NmM6Njg6YTQ6YjA6NWM6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:b0:5c:e8',
                                         'uptime': '56272'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:3',
                                                                       'in_octets': '3397058111',
                                                                       'in_ucast_pkts': '2716589',
                                                                       'links': [       {       'in_octets': '3397058111',
                                                                                                'in_ucast_pkts': '2716589',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '223309660',
                                                                                                'out_ucast_pkts': '1326278',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'out_octets': '223309660',
                                                                       'out_ucast_pkts': '1326278',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:3',
                                                                                               'id': 'EPON0/1:3',
                                                                                               'links': [       {       'connected_time': '110728',
                                                                                                                        'fiber_length': 1007,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:3',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '223309660',
                                                                       'in_ucast_pkts': '1326278',
                                                                       'mac_address': '30:68:93:51:fe:10',
                                                                       'name': 'eth0',
                                                                       'out_octets': '3397058111',
                                                                       'out_ucast_pkts': '2716589',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'MzA6Njg6OTM6NTE6ZmU6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:51:fe:10',
                                         'uptime': '110728'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:4',
                                                                       'in_octets': '9197280',
                                                                       'in_ucast_pkts': '49937',
                                                                       'links': [       {       'in_octets': '9197280',
                                                                                                'in_ucast_pkts': '49937',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '10919412',
                                                                                                'out_ucast_pkts': '61341',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'out_octets': '10919412',
                                                                       'out_ucast_pkts': '61341',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhpbnRm',
                                                                       'pons': [       {       'description': '0/1:4',
                                                                                               'id': 'EPON0/1:4',
                                                                                               'links': [       {       'connected_time': '110716',
                                                                                                                        'fiber_length': 1016,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:4',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10919412',
                                                                       'in_ucast_pkts': '61341',
                                                                       'mac_address': '4c:d7:c8:64:6f:78',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9197280',
                                                                       'out_ucast_pkts': '49937',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjQ6NmY6NzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:64:6f:78',
                                         'uptime': '110716'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:5',
                                                                       'in_octets': '16309498',
                                                                       'in_ucast_pkts': '77644',
                                                                       'links': [       {       'in_octets': '16309498',
                                                                                                'in_ucast_pkts': '77644',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '22304471',
                                                                                                'out_ucast_pkts': '154448',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:5',
                                                                       'oper_up': True,
                                                                       'out_octets': '22304471',
                                                                       'out_ucast_pkts': '154448',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThpbnRm',
                                                                       'pons': [       {       'description': '0/1:5',
                                                                                               'id': 'EPON0/1:5',
                                                                                               'links': [       {       'connected_time': '23838',
                                                                                                                        'fiber_length': 1315,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:5',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '22304471',
                                                                       'in_ucast_pkts': '154448',
                                                                       'mac_address': '30:68:93:52:33:98',
                                                                       'name': 'eth0',
                                                                       'out_octets': '16309498',
                                                                       'out_ucast_pkts': '77644',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:5',
                                         'poller_hash': 'MzA6Njg6OTM6NTI6MzM6OThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:52:33:98',
                                         'uptime': '23838'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:6',
                                                                       'in_octets': '50876203595',
                                                                       'in_ucast_pkts': '34697711',
                                                                       'links': [       {       'in_octets': '50876203595',
                                                                                                'in_ucast_pkts': '34697711',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1322597447',
                                                                                                'out_ucast_pkts': '9298542',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:6',
                                                                       'oper_up': True,
                                                                       'out_octets': '1322597447',
                                                                       'out_ucast_pkts': '9298542',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhpbnRm',
                                                                       'pons': [       {       'description': '0/1:6',
                                                                                               'id': 'EPON0/1:6',
                                                                                               'links': [       {       'connected_time': '234461',
                                                                                                                        'fiber_length': 1159,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:6',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1322597447',
                                                                       'in_ucast_pkts': '9298542',
                                                                       'mac_address': '4c:d7:c8:64:76:d8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '50876203595',
                                                                       'out_ucast_pkts': '34697711',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/1:6',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjQ6NzY6ZDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:64:76:d8',
                                         'uptime': '234461'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:7',
                                                                       'in_octets': '28846658885',
                                                                       'in_ucast_pkts': '22592115',
                                                                       'links': [       {       'in_octets': '28846658885',
                                                                                                'in_ucast_pkts': '22592115',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1794504267',
                                                                                                'out_ucast_pkts': '11746262',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:7',
                                                                       'oper_up': True,
                                                                       'out_octets': '1794504267',
                                                                       'out_ucast_pkts': '11746262',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:7',
                                                                                               'id': 'EPON0/1:7',
                                                                                               'links': [       {       'connected_time': '1203',
                                                                                                                        'fiber_length': 1965,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -16.4,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:7',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1794504267',
                                                                       'in_ucast_pkts': '11746262',
                                                                       'mac_address': '8c:90:2d:57:1d:10',
                                                                       'name': 'eth0',
                                                                       'out_octets': '28846658885',
                                                                       'out_ucast_pkts': '22592115',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:7',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6MWQ6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '8c:90:2d:57:1d:10',
                                         'uptime': '1203'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:8',
                                                                       'in_octets': '134626806078',
                                                                       'in_ucast_pkts': '94168366',
                                                                       'links': [       {       'in_octets': '134626806078',
                                                                                                'in_ucast_pkts': '94168366',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '7382412902',
                                                                                                'out_ucast_pkts': '69383527',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:8',
                                                                       'oper_up': True,
                                                                       'out_octets': '7382412902',
                                                                       'out_ucast_pkts': '69383527',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBpbnRm',
                                                                       'pons': [       {       'description': '0/1:8',
                                                                                               'id': 'EPON0/1:8',
                                                                                               'links': [       {       'connected_time': '110723',
                                                                                                                        'fiber_length': 2508,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:8',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7382412902',
                                                                       'in_ucast_pkts': '69383527',
                                                                       'mac_address': '30:68:93:52:12:40',
                                                                       'name': 'eth0',
                                                                       'out_octets': '134626806078',
                                                                       'out_ucast_pkts': '94168366',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:8',
                                         'poller_hash': 'MzA6Njg6OTM6NTI6MTI6NDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:52:12:40',
                                         'uptime': '110723'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:9',
                                                                       'in_octets': '27722403668',
                                                                       'in_ucast_pkts': '21517809',
                                                                       'links': [       {       'in_octets': '27722403668',
                                                                                                'in_ucast_pkts': '21517809',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1475217889',
                                                                                                'out_ucast_pkts': '7114567',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:9',
                                                                       'oper_up': True,
                                                                       'out_octets': '1475217889',
                                                                       'out_ucast_pkts': '7114567',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBpbnRm',
                                                                       'pons': [       {       'description': '0/1:9',
                                                                                               'id': 'EPON0/1:9',
                                                                                               'links': [       {       'connected_time': '110373',
                                                                                                                        'fiber_length': 1963,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:9',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1475217889',
                                                                       'in_ucast_pkts': '7114567',
                                                                       'mac_address': '30:68:93:51:f1:10',
                                                                       'name': 'eth0',
                                                                       'out_octets': '27722403668',
                                                                       'out_ucast_pkts': '21517809',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:9',
                                         'poller_hash': 'MzA6Njg6OTM6NTE6ZjE6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:51:f1:10',
                                         'uptime': '110373'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:10',
                                                                       'in_octets': '8981098131',
                                                                       'in_ucast_pkts': '6630241',
                                                                       'links': [       {       'in_octets': '8981098131',
                                                                                                'in_ucast_pkts': '6630241',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '556998995',
                                                                                                'out_ucast_pkts': '2772794',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:10',
                                                                       'oper_up': True,
                                                                       'out_octets': '556998995',
                                                                       'out_ucast_pkts': '2772794',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/1:10',
                                                                                               'id': 'EPON0/1:10',
                                                                                               'links': [       {       'connected_time': '110724',
                                                                                                                        'fiber_length': 2516,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -16.4,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:10',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '556998995',
                                                                       'in_ucast_pkts': '2772794',
                                                                       'mac_address': 'ec:75:0c:72:30:e8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '8981098131',
                                                                       'out_ucast_pkts': '6630241',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:10',
                                         'poller_hash': 'ZWM6NzU6MGM6NzI6MzA6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:72:30:e8',
                                         'uptime': '110724'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:11',
                                                                       'in_octets': '37374097371',
                                                                       'in_ucast_pkts': '27767495',
                                                                       'links': [       {       'in_octets': '37374097371',
                                                                                                'in_ucast_pkts': '27767495',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1771192578',
                                                                                                'out_ucast_pkts': '11311606',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:11',
                                                                       'oper_up': True,
                                                                       'out_octets': '1771192578',
                                                                       'out_ucast_pkts': '11311606',
                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThpbnRm',
                                                                       'pons': [       {       'description': '0/1:11',
                                                                                               'id': 'EPON0/1:11',
                                                                                               'links': [       {       'connected_time': '107688',
                                                                                                                        'fiber_length': 1506,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -17.1,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:11',
                                                                                               'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1771192578',
                                                                       'in_ucast_pkts': '11311606',
                                                                       'mac_address': '3c:64:cf:a3:c6:98',
                                                                       'name': 'eth0',
                                                                       'out_octets': '37374097371',
                                                                       'out_ucast_pkts': '27767495',
                                                                       'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/1:11',
                                         'poller_hash': 'M2M6NjQ6Y2Y6YTM6YzY6OThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '3c:64:cf:a3:c6:98',
                                         'uptime': '107688'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/1:12',
                                                                       'in_octets': '26369234343',
                                                                       'in_ucast_pkts': '21539617',
                                                                       'links': [       {       'in_octets': '26369234343',
                                                                                                'in_ucast_pkts': '21539617',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3690841183',
                                                                                                'out_ucast_pkts': '9638010',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRm'}],
                                                                       'name': 'EPON0/1:12',
                                                                       'oper_up': True,
                                                                       'out_octets': '3690841183',
                                                                       'out_ucast_pkts': '9638010',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/1:12',
                                                                                               'id': 'EPON0/1:12',
                                                                                               'links': [       {       'connected_time': '110717',
                                                                                                                        'fiber_length': 1847,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTFpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -28.5,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.9}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/1:12',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3690841183',
                                                                       'in_ucast_pkts': '9638010',
                                                                       'mac_address': '4c:d7:c8:62:7b:b8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '26369234343',
                                                                       'out_ucast_pkts': '21539617',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/1:12',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjI6N2I6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:62:7b:b8',
                                         'uptime': '110717'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:1',
                                                                       'in_octets': '16219315888',
                                                                       'in_ucast_pkts': '13926493',
                                                                       'links': [       {       'in_octets': '16219315888',
                                                                                                'in_ucast_pkts': '13926493',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '7681068505',
                                                                                                'out_ucast_pkts': '8942728',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '7681068505',
                                                                       'out_ucast_pkts': '8942728',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:1',
                                                                                               'id': 'EPON0/2:1',
                                                                                               'links': [       {       'connected_time': '110718',
                                                                                                                        'fiber_length': 1511,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7681068505',
                                                                       'in_ucast_pkts': '8942728',
                                                                       'mac_address': '6c:68:a4:b0:70:48',
                                                                       'name': 'eth0',
                                                                       'out_octets': '16219315888',
                                                                       'out_ucast_pkts': '13926493',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/2:1',
                                         'poller_hash': 'NmM6Njg6YTQ6YjA6NzA6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:b0:70:48',
                                         'uptime': '110718'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:3',
                                                                       'in_octets': '23176120472',
                                                                       'in_ucast_pkts': '16659611',
                                                                       'links': [       {       'in_octets': '23176120472',
                                                                                                'in_ucast_pkts': '16659611',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '639425090',
                                                                                                'out_ucast_pkts': '6105448',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': True,
                                                                       'out_octets': '639425090',
                                                                       'out_ucast_pkts': '6105448',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBpbnRm',
                                                                       'pons': [       {       'description': '0/2:3',
                                                                                               'id': 'EPON0/2:3',
                                                                                               'links': [       {       'connected_time': '99694',
                                                                                                                        'fiber_length': 1334,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:3',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '639425090',
                                                                       'in_ucast_pkts': '6105448',
                                                                       'mac_address': 'ec:75:0c:71:c9:20',
                                                                       'name': 'eth0',
                                                                       'out_octets': '23176120472',
                                                                       'out_ucast_pkts': '16659611',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'ZWM6NzU6MGM6NzE6Yzk6MjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:71:c9:20',
                                         'uptime': '99694'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:4',
                                                                       'in_octets': '39694294046',
                                                                       'in_ucast_pkts': '30026746',
                                                                       'links': [       {       'in_octets': '39694294046',
                                                                                                'in_ucast_pkts': '30026746',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3178864312',
                                                                                                'out_ucast_pkts': '10102002',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'out_octets': '3178864312',
                                                                       'out_ucast_pkts': '10102002',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBpbnRm',
                                                                       'pons': [       {       'description': '0/2:4',
                                                                                               'id': 'EPON0/2:4',
                                                                                               'links': [       {       'connected_time': '63123',
                                                                                                                        'fiber_length': 1816,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:4',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3178864312',
                                                                       'in_ucast_pkts': '10102002',
                                                                       'mac_address': 'ec:75:0c:1f:f2:10',
                                                                       'name': 'eth0',
                                                                       'out_octets': '39694294046',
                                                                       'out_ucast_pkts': '30026746',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'ZWM6NzU6MGM6MWY6ZjI6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:1f:f2:10',
                                         'uptime': '63123'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:5',
                                                                       'in_octets': '2912850604',
                                                                       'in_ucast_pkts': '2424325',
                                                                       'links': [       {       'in_octets': '2912850604',
                                                                                                'in_ucast_pkts': '2424325',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '233262805',
                                                                                                'out_ucast_pkts': '976855',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:5',
                                                                       'oper_up': True,
                                                                       'out_octets': '233262805',
                                                                       'out_ucast_pkts': '976855',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:5',
                                                                                               'id': 'EPON0/2:5',
                                                                                               'links': [       {       'connected_time': '110723',
                                                                                                                        'fiber_length': 1866,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -13.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:5',
                                                                                               'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '233262805',
                                                                       'in_ucast_pkts': '976855',
                                                                       'mac_address': '98:ba:5f:2a:68:08',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2912850604',
                                                                       'out_ucast_pkts': '2424325',
                                                                       'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:5',
                                         'poller_hash': 'OTg6YmE6NWY6MmE6Njg6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '98:ba:5f:2a:68:08',
                                         'uptime': '110723'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:6',
                                                                       'in_octets': '40361188639',
                                                                       'in_ucast_pkts': '30561725',
                                                                       'links': [       {       'in_octets': '40361188639',
                                                                                                'in_ucast_pkts': '30561725',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2781789729',
                                                                                                'out_ucast_pkts': '12941512',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:6',
                                                                       'oper_up': True,
                                                                       'out_octets': '2781789729',
                                                                       'out_ucast_pkts': '12941512',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:6',
                                                                                               'id': 'EPON0/2:6',
                                                                                               'links': [       {       'connected_time': '15625',
                                                                                                                        'fiber_length': 1869,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.4,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:6',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2781789729',
                                                                       'in_ucast_pkts': '12941512',
                                                                       'mac_address': '4c:d7:c8:61:e9:d8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '40361188639',
                                                                       'out_ucast_pkts': '30561725',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/2:6',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjE6ZTk6ZDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:61:e9:d8',
                                         'uptime': '15625'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:7',
                                                                       'in_octets': '6704955104',
                                                                       'in_ucast_pkts': '5365532',
                                                                       'links': [       {       'in_octets': '6704955104',
                                                                                                'in_ucast_pkts': '5365532',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '977471978',
                                                                                                'out_ucast_pkts': '2576956',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:7',
                                                                       'oper_up': True,
                                                                       'out_octets': '977471978',
                                                                       'out_ucast_pkts': '2576956',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhpbnRm',
                                                                       'pons': [       {       'description': '0/2:7',
                                                                                               'id': 'EPON0/2:7',
                                                                                               'links': [       {       'connected_time': '27534',
                                                                                                                        'fiber_length': 1978,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -13.8,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:7',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '977471978',
                                                                       'in_ucast_pkts': '2576956',
                                                                       'mac_address': '4c:d7:c8:61:43:88',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6704955104',
                                                                       'out_ucast_pkts': '5365532',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/2:7',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjE6NDM6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:61:43:88',
                                         'uptime': '27534'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:8',
                                                                       'in_octets': '53389628166',
                                                                       'in_ucast_pkts': '40925786',
                                                                       'links': [       {       'in_octets': '53389628166',
                                                                                                'in_ucast_pkts': '40925786',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2886207906',
                                                                                                'out_ucast_pkts': '13077318',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:8',
                                                                       'oper_up': True,
                                                                       'out_octets': '2886207906',
                                                                       'out_ucast_pkts': '13077318',
                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZpbnRm',
                                                                       'pons': [       {       'description': '0/2:8',
                                                                                               'id': 'EPON0/2:8',
                                                                                               'links': [       {       'connected_time': '107005',
                                                                                                                        'fiber_length': 1487,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -13.4,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:8',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2886207906',
                                                                       'in_ucast_pkts': '13077318',
                                                                       'mac_address': '6c:68:a4:99:55:56',
                                                                       'name': 'eth0',
                                                                       'out_octets': '53389628166',
                                                                       'out_ucast_pkts': '40925786',
                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/2:8',
                                         'poller_hash': 'NmM6Njg6YTQ6OTk6NTU6NTZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:99:55:56',
                                         'uptime': '107005'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:9',
                                                                       'in_octets': '15712332',
                                                                       'in_ucast_pkts': '93903',
                                                                       'links': [       {       'in_octets': '15712332',
                                                                                                'in_ucast_pkts': '93903',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '25137979',
                                                                                                'out_ucast_pkts': '175541',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:9',
                                                                       'oper_up': True,
                                                                       'out_octets': '25137979',
                                                                       'out_ucast_pkts': '175541',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThpbnRm',
                                                                       'pons': [       {       'description': '0/2:9',
                                                                                               'id': 'EPON0/2:9',
                                                                                               'links': [       {       'connected_time': '110727',
                                                                                                                        'fiber_length': 1070,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.8}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:9',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '25137979',
                                                                       'in_ucast_pkts': '175541',
                                                                       'mac_address': 'ec:75:0c:72:2d:18',
                                                                       'name': 'eth0',
                                                                       'out_octets': '15712332',
                                                                       'out_ucast_pkts': '93903',
                                                                       'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:9',
                                         'poller_hash': 'ZWM6NzU6MGM6NzI6MmQ6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:72:2d:18',
                                         'uptime': '110727'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:10',
                                                                       'in_octets': '29352802329',
                                                                       'in_ucast_pkts': '23075482',
                                                                       'links': [       {       'in_octets': '29352802329',
                                                                                                'in_ucast_pkts': '23075482',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2311907879',
                                                                                                'out_ucast_pkts': '9834356',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:10',
                                                                       'oper_up': True,
                                                                       'out_octets': '2311907879',
                                                                       'out_ucast_pkts': '9834356',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBpbnRm',
                                                                       'pons': [       {       'description': '0/2:10',
                                                                                               'id': 'EPON0/2:10',
                                                                                               'links': [       {       'connected_time': '110724',
                                                                                                                        'fiber_length': 1266,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -19.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:10',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2311907879',
                                                                       'in_ucast_pkts': '9834356',
                                                                       'mac_address': '8c:90:2d:57:50:80',
                                                                       'name': 'eth0',
                                                                       'out_octets': '29352802329',
                                                                       'out_ucast_pkts': '23075482',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:10',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6NTA6ODBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '8c:90:2d:57:50:80',
                                         'uptime': '110724'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:11',
                                                                       'in_octets': '10751257936',
                                                                       'in_ucast_pkts': '9156729',
                                                                       'links': [       {       'in_octets': '10751257936',
                                                                                                'in_ucast_pkts': '9156729',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1321678719',
                                                                                                'out_ucast_pkts': '4869487',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:11',
                                                                       'oper_up': True,
                                                                       'out_octets': '1321678719',
                                                                       'out_ucast_pkts': '4869487',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhpbnRm',
                                                                       'pons': [       {       'description': '0/2:11',
                                                                                               'id': 'EPON0/2:11',
                                                                                               'links': [       {       'connected_time': '47831',
                                                                                                                        'fiber_length': 1944,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.5,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:11',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1321678719',
                                                                       'in_ucast_pkts': '4869487',
                                                                       'mac_address': '4c:d7:c8:62:bb:d8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '10751257936',
                                                                       'out_ucast_pkts': '9156729',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/2:11',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjI6YmI6ZDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:62:bb:d8',
                                         'uptime': '47831'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:12',
                                                                       'in_octets': '9628864706',
                                                                       'in_ucast_pkts': '7758169',
                                                                       'links': [       {       'in_octets': '9628864706',
                                                                                                'in_ucast_pkts': '7758169',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '829183264',
                                                                                                'out_ucast_pkts': '3370150',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:12',
                                                                       'oper_up': True,
                                                                       'out_octets': '829183264',
                                                                       'out_ucast_pkts': '3370150',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhpbnRm',
                                                                       'pons': [       {       'description': '0/2:12',
                                                                                               'id': 'EPON0/2:12',
                                                                                               'links': [       {       'connected_time': '110724',
                                                                                                                        'fiber_length': 1175,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -12.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:12',
                                                                                               'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '829183264',
                                                                       'in_ucast_pkts': '3370150',
                                                                       'mac_address': '8c:90:2d:57:03:b8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9628864706',
                                                                       'out_ucast_pkts': '7758169',
                                                                       'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:12',
                                         'poller_hash': 'OGM6OTA6MmQ6NTc6MDM6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '8c:90:2d:57:03:b8',
                                         'uptime': '110724'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/2:13',
                                                                       'in_octets': '21121396522',
                                                                       'in_ucast_pkts': '17854388',
                                                                       'links': [       {       'in_octets': '21121396522',
                                                                                                'in_ucast_pkts': '17854388',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1808903355',
                                                                                                'out_ucast_pkts': '7563940',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRm'}],
                                                                       'name': 'EPON0/2:13',
                                                                       'oper_up': True,
                                                                       'out_octets': '1808903355',
                                                                       'out_ucast_pkts': '7563940',
                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThpbnRm',
                                                                       'pons': [       {       'description': '0/2:13',
                                                                                               'id': 'EPON0/2:13',
                                                                                               'links': [       {       'connected_time': '110723',
                                                                                                                        'fiber_length': 1251,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTJpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -21.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/2:13',
                                                                                               'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1808903355',
                                                                       'in_ucast_pkts': '7563940',
                                                                       'mac_address': '30:68:93:b1:f6:98',
                                                                       'name': 'eth0',
                                                                       'out_octets': '21121396522',
                                                                       'out_ucast_pkts': '17854388',
                                                                       'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/2:13',
                                         'poller_hash': 'MzA6Njg6OTM6YjE6ZjY6OThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:b1:f6:98',
                                         'uptime': '110723'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:1',
                                                                       'in_octets': '38774462292',
                                                                       'in_ucast_pkts': '30084167',
                                                                       'links': [       {       'in_octets': '38774462292',
                                                                                                'in_ucast_pkts': '30084167',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2336900058',
                                                                                                'out_ucast_pkts': '8754302',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:1',
                                                                       'oper_up': True,
                                                                       'out_octets': '2336900058',
                                                                       'out_ucast_pkts': '8754302',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZpbnRm',
                                                                       'pons': [       {       'description': '0/3:1',
                                                                                               'id': 'EPON0/3:1',
                                                                                               'links': [       {       'connected_time': '107347',
                                                                                                                        'fiber_length': 1772,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:1',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2336900058',
                                                                       'in_ucast_pkts': '8754302',
                                                                       'mac_address': '6c:68:a4:1e:69:ff',
                                                                       'name': 'eth0',
                                                                       'out_octets': '38774462292',
                                                                       'out_ucast_pkts': '30084167',
                                                                       'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:1',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6Njk6ZmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:69:ff',
                                         'uptime': '107347'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:2',
                                                                       'in_octets': '30122740925',
                                                                       'in_ucast_pkts': '24079147',
                                                                       'links': [       {       'in_octets': '30122740925',
                                                                                                'in_ucast_pkts': '24079147',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3326082891',
                                                                                                'out_ucast_pkts': '10282809',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:2',
                                                                       'oper_up': True,
                                                                       'out_octets': '3326082891',
                                                                       'out_ucast_pkts': '10282809',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThpbnRm',
                                                                       'pons': [       {       'description': '0/3:2',
                                                                                               'id': 'EPON0/3:2',
                                                                                               'links': [       {       'connected_time': '99654',
                                                                                                                        'fiber_length': 1887,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:2',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3326082891',
                                                                       'in_ucast_pkts': '10282809',
                                                                       'mac_address': '4c:d7:c8:63:70:a8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '30122740925',
                                                                       'out_ucast_pkts': '24079147',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:2',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjM6NzA6YThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:63:70:a8',
                                         'uptime': '99654'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:3',
                                                                       'in_octets': '15707125555',
                                                                       'in_ucast_pkts': '12508456',
                                                                       'links': [       {       'in_octets': '15707125555',
                                                                                                'in_ucast_pkts': '12508456',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1495268906',
                                                                                                'out_ucast_pkts': '4464893',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:3',
                                                                       'oper_up': True,
                                                                       'out_octets': '1495268906',
                                                                       'out_ucast_pkts': '4464893',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThpbnRm',
                                                                       'pons': [       {       'description': '0/3:3',
                                                                                               'id': 'EPON0/3:3',
                                                                                               'links': [       {       'connected_time': '95877',
                                                                                                                        'fiber_length': 1616,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:3',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1495268906',
                                                                       'in_ucast_pkts': '4464893',
                                                                       'mac_address': '6c:68:a4:b0:21:58',
                                                                       'name': 'eth0',
                                                                       'out_octets': '15707125555',
                                                                       'out_ucast_pkts': '12508456',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:3',
                                         'poller_hash': 'NmM6Njg6YTQ6YjA6MjE6NThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:b0:21:58',
                                         'uptime': '95877'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:4',
                                                                       'in_octets': '66334951775',
                                                                       'in_ucast_pkts': '45633364',
                                                                       'links': [       {       'in_octets': '66334951775',
                                                                                                'in_ucast_pkts': '45633364',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1169839092',
                                                                                                'out_ucast_pkts': '6569186',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:4',
                                                                       'oper_up': True,
                                                                       'out_octets': '1169839092',
                                                                       'out_ucast_pkts': '6569186',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThpbnRm',
                                                                       'pons': [       {       'description': '0/3:4',
                                                                                               'id': 'EPON0/3:4',
                                                                                               'links': [       {       'connected_time': '107590',
                                                                                                                        'fiber_length': 2476,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.3,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:4',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1169839092',
                                                                       'in_ucast_pkts': '6569186',
                                                                       'mac_address': '6c:68:a4:b0:42:18',
                                                                       'name': 'eth0',
                                                                       'out_octets': '66334951775',
                                                                       'out_ucast_pkts': '45633364',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:4',
                                         'poller_hash': 'NmM6Njg6YTQ6YjA6NDI6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:b0:42:18',
                                         'uptime': '107590'},
                                 {       'extra': '{"oper_up": false, "status": '
                                                  '"deregistered", "reason": '
                                                  '"wire-down"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:5',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhpbnRm',
                                                                       'pons': [       {       'description': '0/3:5',
                                                                                               'id': 'EPON0/3:5',
                                                                                               'links': [       {       'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'tx_link_rate': '1000000000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:5',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '6c:68:a4:b0:a6:08',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:5',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'wire-down',
                                         'offline_time': '2025-08-07T13:37:42.360113Z',
                                         'poller_hash': 'NmM6Njg6YTQ6YjA6YTY6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '6c:68:a4:b0:a6:08'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:6',
                                                                       'in_octets': '36905163764',
                                                                       'in_ucast_pkts': '28899131',
                                                                       'links': [       {       'in_octets': '36905163764',
                                                                                                'in_ucast_pkts': '28899131',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1025497014',
                                                                                                'out_ucast_pkts': '5793270',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:6',
                                                                       'oper_up': True,
                                                                       'out_octets': '1025497014',
                                                                       'out_ucast_pkts': '5793270',
                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZpbnRm',
                                                                       'pons': [       {       'description': '0/3:6',
                                                                                               'id': 'EPON0/3:6',
                                                                                               'links': [       {       'connected_time': '110726',
                                                                                                                        'fiber_length': 1671,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:6',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1025497014',
                                                                       'in_ucast_pkts': '5793270',
                                                                       'mac_address': '6c:68:a4:99:22:36',
                                                                       'name': 'eth0',
                                                                       'out_octets': '36905163764',
                                                                       'out_ucast_pkts': '28899131',
                                                                       'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:6',
                                         'poller_hash': 'NmM6Njg6YTQ6OTk6MjI6MzZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:99:22:36',
                                         'uptime': '110726'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:7',
                                                                       'in_octets': '15713215931',
                                                                       'in_ucast_pkts': '11683817',
                                                                       'links': [       {       'in_octets': '15713215931',
                                                                                                'in_ucast_pkts': '11683817',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '586120511',
                                                                                                'out_ucast_pkts': '4000800',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:7',
                                                                       'oper_up': True,
                                                                       'out_octets': '586120511',
                                                                       'out_ucast_pkts': '4000800',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBpbnRm',
                                                                       'pons': [       {       'description': '0/3:7',
                                                                                               'id': 'EPON0/3:7',
                                                                                               'links': [       {       'connected_time': '110717',
                                                                                                                        'fiber_length': 1282,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.7,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 1.6}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:7',
                                                                                               'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '586120511',
                                                                       'in_ucast_pkts': '4000800',
                                                                       'mac_address': '6c:68:a4:ee:06:e0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '15713215931',
                                                                       'out_ucast_pkts': '11683817',
                                                                       'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:7',
                                         'poller_hash': 'NmM6Njg6YTQ6ZWU6MDY6ZTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:ee:06:e0',
                                         'uptime': '110717'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:8',
                                                                       'in_octets': '5442412757',
                                                                       'in_ucast_pkts': '4433716',
                                                                       'links': [       {       'in_octets': '5442412757',
                                                                                                'in_ucast_pkts': '4433716',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '1539362233',
                                                                                                'out_ucast_pkts': '2310498',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:8',
                                                                       'oper_up': True,
                                                                       'out_octets': '1539362233',
                                                                       'out_ucast_pkts': '2310498',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThpbnRm',
                                                                       'pons': [       {       'description': '0/3:8',
                                                                                               'id': 'EPON0/3:8',
                                                                                               'links': [       {       'connected_time': '110719',
                                                                                                                        'fiber_length': 1587,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:8',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1539362233',
                                                                       'in_ucast_pkts': '2310498',
                                                                       'mac_address': '4c:d7:c8:61:eb:18',
                                                                       'name': 'eth0',
                                                                       'out_octets': '5442412757',
                                                                       'out_ucast_pkts': '4433716',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:8',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjE6ZWI6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:61:eb:18',
                                         'uptime': '110719'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:9',
                                                                       'in_octets': '58848225268',
                                                                       'in_ucast_pkts': '42719208',
                                                                       'links': [       {       'in_octets': '58848225268',
                                                                                                'in_ucast_pkts': '42719208',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '3055296827',
                                                                                                'out_ucast_pkts': '24445434',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:9',
                                                                       'oper_up': True,
                                                                       'out_octets': '3055296827',
                                                                       'out_ucast_pkts': '24445434',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/3:9',
                                                                                               'id': 'EPON0/3:9',
                                                                                               'links': [       {       'connected_time': '110726',
                                                                                                                        'fiber_length': 1764,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:9',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3055296827',
                                                                       'in_ucast_pkts': '24445434',
                                                                       'mac_address': '4c:d7:c8:63:3c:e8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '58848225268',
                                                                       'out_ucast_pkts': '42719208',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:9',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjM6M2M6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:63:3c:e8',
                                         'uptime': '110726'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:10',
                                                                       'in_octets': '29089365465',
                                                                       'in_ucast_pkts': '23091163',
                                                                       'links': [       {       'in_octets': '29089365465',
                                                                                                'in_ucast_pkts': '23091163',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2607131867',
                                                                                                'out_ucast_pkts': '7142959',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:10',
                                                                       'oper_up': True,
                                                                       'out_octets': '2607131867',
                                                                       'out_ucast_pkts': '7142959',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThpbnRm',
                                                                       'pons': [       {       'description': '0/3:10',
                                                                                               'id': 'EPON0/3:10',
                                                                                               'links': [       {       'connected_time': '110726',
                                                                                                                        'fiber_length': 2341,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -18.2,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.5}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:10',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2607131867',
                                                                       'in_ucast_pkts': '7142959',
                                                                       'mac_address': '4c:d7:c8:62:9d:98',
                                                                       'name': 'eth0',
                                                                       'out_octets': '29089365465',
                                                                       'out_ucast_pkts': '23091163',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:10',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjI6OWQ6OThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:62:9d:98',
                                         'uptime': '110726'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:11',
                                                                       'in_octets': '13500273284',
                                                                       'in_ucast_pkts': '10005292',
                                                                       'links': [       {       'in_octets': '13500273284',
                                                                                                'in_ucast_pkts': '10005292',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '819179441',
                                                                                                'out_ucast_pkts': '4503880',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:11',
                                                                       'oper_up': True,
                                                                       'out_octets': '819179441',
                                                                       'out_ucast_pkts': '4503880',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThpbnRm',
                                                                       'pons': [       {       'description': '0/3:11',
                                                                                               'id': 'EPON0/3:11',
                                                                                               'links': [       {       'connected_time': '110723',
                                                                                                                        'fiber_length': 1670,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.3}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:11',
                                                                                               'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '819179441',
                                                                       'in_ucast_pkts': '4503880',
                                                                       'mac_address': '30:68:93:52:2b:e8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '13500273284',
                                                                       'out_ucast_pkts': '10005292',
                                                                       'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/3:11',
                                         'poller_hash': 'MzA6Njg6OTM6NTI6MmI6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '30:68:93:52:2b:e8',
                                         'uptime': '110723'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:12',
                                                                       'in_octets': '33933197573',
                                                                       'in_ucast_pkts': '27144922',
                                                                       'links': [       {       'in_octets': '33933197573',
                                                                                                'in_ucast_pkts': '27144922',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '2139112305',
                                                                                                'out_ucast_pkts': '10149969',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:12',
                                                                       'oper_up': True,
                                                                       'out_octets': '2139112305',
                                                                       'out_ucast_pkts': '10149969',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBpbnRm',
                                                                       'pons': [       {       'description': '0/3:12',
                                                                                               'id': 'EPON0/3:12',
                                                                                               'links': [       {       'connected_time': '107419',
                                                                                                                        'fiber_length': 2388,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -17.9,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:12',
                                                                                               'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2139112305',
                                                                       'in_ucast_pkts': '10149969',
                                                                       'mac_address': 'ec:75:0c:1f:fc:f0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '33933197573',
                                                                       'out_ucast_pkts': '27144922',
                                                                       'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBldGgw'}],
                                         'manufacturer': 'MTKc',
                                         'model': '0x00000000',
                                         'name': 'EPON0/3:12',
                                         'poller_hash': 'ZWM6NzU6MGM6MWY6ZmM6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'ec:75:0c:1f:fc:f0',
                                         'uptime': '107419'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:13',
                                                                       'in_octets': '54226494446',
                                                                       'in_ucast_pkts': '43591455',
                                                                       'links': [       {       'in_octets': '54226494446',
                                                                                                'in_ucast_pkts': '43591455',
                                                                                                'oper_up': True,
                                                                                                'out_octets': '4115765016',
                                                                                                'out_ucast_pkts': '16230928',
                                                                                                'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRm'}],
                                                                       'name': 'EPON0/3:13',
                                                                       'oper_up': True,
                                                                       'out_octets': '4115765016',
                                                                       'out_ucast_pkts': '16230928',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhpbnRm',
                                                                       'pons': [       {       'description': '0/3:13',
                                                                                               'id': 'EPON0/3:13',
                                                                                               'links': [       {       'connected_time': '110716',
                                                                                                                        'fiber_length': 1550,
                                                                                                                        'poller_hash': 'MDA6NTU6YjE6Y2Y6ODM6OTNpbnRmZXBvbg==',
                                                                                                                        'rx_link_rate': '1000000000',
                                                                                                                        'rx_power': -14.5,
                                                                                                                        'tx_link_rate': '1000000000',
                                                                                                                        'tx_power': 2.4}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '0/3:13',
                                                                                               'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhpbnRmZXBvbg==',
                                                                                               'pon_technology': 'EPON',
                                                                                               'rx_link_rate': '1000000000',
                                                                                               'tx_link_rate': '1000000000'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '4115765016',
                                                                       'in_ucast_pkts': '16230928',
                                                                       'mac_address': '4c:d7:c8:60:f2:28',
                                                                       'name': 'eth0',
                                                                       'out_octets': '54226494446',
                                                                       'out_ucast_pkts': '43591455',
                                                                       'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhldGgw'}],
                                         'model': 'H225/H225',
                                         'name': 'EPON0/3:13',
                                         'poller_hash': 'NGM6ZDc6Yzg6NjA6ZjI6MjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '4c:d7:c8:60:f2:28',
                                         'uptime': '110716'},
                                 {       'extra': '{"oper_up": true, "status": '
                                                  '"auto-configured", "reason": "N/A"}',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'EPON0/3:14',
                                                                       'in_octets': '45703889259',
                                                                       'in_ucast_pkts': '35479470',
                                                                       'links': [       {       'in_octets': '45703889259',
                                                                                                'in_ucast_pkts': '35479470',
                                                                                                'oper_up': True,
                                                                                                'out_oct