import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestZteModels(DeviceTestCase):

    def test_zte_zxa10_c620_V2_0_10_0120_1(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.10.0120_1")
        exp_info = {
         'model': 'C620', 'sta_count': 7, 'sw_version': 'V2.0.10', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'TPLGDD8D0400': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/10:3',
                                        'serial': 'TPLGDD8D0400',
                                        'serial_number': None},
                'TPLGDD8D1C98': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/4:2',
                                        'serial': 'TPLGDD8D1C98',
                                        'serial_number': None},
                'TPLGDD8D1D68': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/10:2',
                                        'serial': 'TPLGDD8D1D68',
                                        'serial_number': None},
                'TPLGDD8D21F0': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/4:3',
                                        'serial': 'TPLGDD8D21F0',
                                        'serial_number': None},
                'TPLGDD8D2410': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/7:1',
                                        'serial': 'TPLGDD8D2410',
                                        'serial_number': None},
                'TPLGDD8D2900': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/4:1',
                                        'serial': 'TPLGDD8D2900',
                                        'serial_number': None},
                'TPLGDD8D6668': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/10:1',
                                        'serial': 'TPLGDD8D6668',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278465',
                                                                                         'name': 'gpon_olt-1/1/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY1',
                                                                                         'pons': [       {       'description': '285278465.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278465.2',
                                                                                                                 'id': 'gpon_olt-1/1/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278466',
                                                                                         'name': 'gpon_olt-1/1/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY2',
                                                                                         'pons': [       {       'description': '285278466.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278466.2',
                                                                                                                 'id': 'gpon_olt-1/1/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278467',
                                                                                         'name': 'gpon_olt-1/1/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY3',
                                                                                         'pons': [       {       'description': '285278467.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278467.2',
                                                                                                                 'id': 'gpon_olt-1/1/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278468',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDox'},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZwb25ncG9uX29udS0xLzEvNDoy'},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDoz'}],
                                                                                         'name': 'gpon_olt-1/1/4',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4',
                                                                                         'pons': [       {       'description': '285278468.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278468.2',
                                                                                                                 'id': 'gpon_olt-1/1/4',
                                                                                                                 'links': [       {       'connected_time': '708',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQyOTAwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '10806',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQxQzk4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '4146',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQyMUYwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278469',
                                                                                         'name': 'gpon_olt-1/1/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY5',
                                                                                         'pons': [       {       'description': '285278469.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278469.2',
                                                                                                                 'id': 'gpon_olt-1/1/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278470',
                                                                                         'name': 'gpon_olt-1/1/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcw',
                                                                                         'pons': [       {       'description': '285278470.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278470.2',
                                                                                                                 'id': 'gpon_olt-1/1/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278471',
                                                                                         'name': 'gpon_olt-1/1/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcx',
                                                                                         'pons': [       {       'description': '285278471.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278471.2',
                                                                                                                 'id': 'gpon_olt-1/1/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278472',
                                                                                         'name': 'gpon_olt-1/1/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcy',
                                                                                         'pons': [       {       'description': '285278472.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/8',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278472.2',
                                                                                                                 'id': 'gpon_olt-1/1/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278473',
                                                                                         'name': 'gpon_olt-1/1/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcz',
                                                                                         'pons': [       {       'description': '285278473.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/9',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278473.2',
                                                                                                                 'id': 'gpon_olt-1/1/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278474',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6MQ=='},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mg=='},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mw=='}],
                                                                                         'name': 'gpon_olt-1/1/10',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0',
                                                                                         'pons': [       {       'description': '285278474.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/10',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278474.2',
                                                                                                                 'id': 'gpon_olt-1/1/10',
                                                                                                                 'links': [       {       'connected_time': '80231',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '9037',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQxRDY4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '1178',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQwNDAwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278475',
                                                                                         'name': 'gpon_olt-1/1/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc1',
                                                                                         'pons': [       {       'description': '285278475.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/11',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278475.2',
                                                                                                                 'id': 'gpon_olt-1/1/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278476',
                                                                                         'name': 'gpon_olt-1/1/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc2',
                                                                                         'pons': [       {       'description': '285278476.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/12',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278476.2',
                                                                                                                 'id': 'gpon_olt-1/1/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278477',
                                                                                         'name': 'gpon_olt-1/1/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc3',
                                                                                         'pons': [       {       'description': '285278477.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/13',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278477.2',
                                                                                                                 'id': 'gpon_olt-1/1/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278478',
                                                                                         'name': 'gpon_olt-1/1/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc4',
                                                                                         'pons': [       {       'description': '285278478.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/14',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278478.2',
                                                                                                                 'id': 'gpon_olt-1/1/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278479',
                                                                                         'name': 'gpon_olt-1/1/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc5',
                                                                                         'pons': [       {       'description': '285278479.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/15',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278479.2',
                                                                                                                 'id': 'gpon_olt-1/1/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278480',
                                                                                         'name': 'gpon_olt-1/1/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDgw',
                                                                                         'pons': [       {       'description': '285278480.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/16',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0ODAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278480.2',
                                                                                                                 'id': 'gpon_olt-1/1/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0ODAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/1 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwMjI5',
                                                           'serial_number': '772138100229',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278721.2',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278722.2',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278723.2',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278724.2',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278725.2',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278726.2',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQyNDEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNzox'}],
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278727.2',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'links': [       {       'connected_time': '9366',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQyNDEwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI4',
                                                                                         'pons': [       {       'description': '285278728.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/8',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278728.2',
                                                                                                                 'id': 'gpon_olt-1/2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI5',
                                                                                         'pons': [       {       'description': '285278729.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/9',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278729.2',
                                                                                                                 'id': 'gpon_olt-1/2/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMw',
                                                                                         'pons': [       {       'description': '285278730.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/10',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278730.2',
                                                                                                                 'id': 'gpon_olt-1/2/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMx',
                                                                                         'pons': [       {       'description': '285278731.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/11',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278731.2',
                                                                                                                 'id': 'gpon_olt-1/2/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMy',
                                                                                         'pons': [       {       'description': '285278732.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/12',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278732.2',
                                                                                                                 'id': 'gpon_olt-1/2/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMz',
                                                                                         'pons': [       {       'description': '285278733.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/13',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278733.2',
                                                                                                                 'id': 'gpon_olt-1/2/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM0',
                                                                                         'pons': [       {       'description': '285278734.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/14',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278734.2',
                                                                                                                 'id': 'gpon_olt-1/2/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM1',
                                                                                         'pons': [       {       'description': '285278735.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/15',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278735.2',
                                                                                                                 'id': 'gpon_olt-1/2/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM2',
                                                                                         'pons': [       {       'description': '285278736.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/16',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278736.2',
                                                                                                                 'id': 'gpon_olt-1/2/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/2 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwNDc3',
                                                           'serial_number': '772138100477',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/3',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'FCSDA',
                                                           'name': '1/1/3 FCSDA',
                                                           'poller_hash': 'NzcyMDgyMjAwMDMz',
                                                           'serial_number': '772082200033'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjMz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM0'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM1'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM2'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzcyNTY5MzAwMDEw',
                                                           'serial_number': '772569300010',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDky'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzcyNTY5MzAwMDM1',
                                                           'serial_number': '772569300035',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMDgx',
                                                           'serial_number': '772391900081'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMDc1',
                                                           'serial_number': '772391900075'}],
                                'poller_hash': 'NzcyNDI4MjAwMDk0b2x0',
                                'serial_number': '772428200094',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.10',
                                'system_mac_address': 'd8:0a:e6:b5:15:ce'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/4.1:1',
                                                                       'name': 'vport-1/1/4.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZldGh2cG9ydC0xLzEvNC4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:1',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:1',
                                                                                               'id': 'gpon_onu-1/1/4:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:1',
                                                                                               'poller_hash': 'VFBMR0REOEQyOTAwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:1',
                                         'poller_hash': 'VFBMR0REOEQyOTAw',
                                         'serial_number': 'TPLGDD8D2900',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '708'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/4.2:1',
                                                                       'name': 'vport-1/1/4.2:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZldGh2cG9ydC0xLzEvNC4yOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:2',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZwb25ncG9uX29udS0xLzEvNDoy',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:2',
                                                                                               'id': 'gpon_onu-1/1/4:2',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:2',
                                                                                               'poller_hash': 'VFBMR0REOEQxQzk4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:2',
                                         'poller_hash': 'VFBMR0REOEQxQzk4',
                                         'serial_number': 'TPLGDD8D1C98',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '10806'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/4.3:1',
                                                                       'name': 'vport-1/1/4.3:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZldGh2cG9ydC0xLzEvNC4zOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:3',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDoz',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:3',
                                                                                               'id': 'gpon_onu-1/1/4:3',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:3',
                                                                                               'poller_hash': 'VFBMR0REOEQyMUYwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:3',
                                         'poller_hash': 'VFBMR0REOEQyMUYw',
                                         'serial_number': 'TPLGDD8D21F0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '4146'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/10.1:1',
                                                                       'name': 'vport-1/1/10.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZldGh2cG9ydC0xLzEvMTAuMTox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:1',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6MQ==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:1',
                                                                                               'id': 'gpon_onu-1/1/10:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:1',
                                                                                               'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:1',
                                         'poller_hash': 'VFBMR0REOEQ2NjY4',
                                         'serial_number': 'TPLGDD8D6668',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '80231'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/10.2:1',
                                                                       'name': 'vport-1/1/10.2:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZldGh2cG9ydC0xLzEvMTAuMjox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:2',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mg==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:2',
                                                                                               'id': 'gpon_onu-1/1/10:2',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:2',
                                                                                               'poller_hash': 'VFBMR0REOEQxRDY4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:2',
                                         'poller_hash': 'VFBMR0REOEQxRDY4',
                                         'serial_number': 'TPLGDD8D1D68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '9037'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/10.3:1',
                                                                       'name': 'vport-1/1/10.3:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZldGh2cG9ydC0xLzEvMTAuMzox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:3',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mw==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:3',
                                                                                               'id': 'gpon_onu-1/1/10:3',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:3',
                                                                                               'poller_hash': 'VFBMR0REOEQwNDAwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:3',
                                         'poller_hash': 'VFBMR0REOEQwNDAw',
                                         'serial_number': 'TPLGDD8D0400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '1178'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/7.1:1',
                                                                       'name': 'vport-1/2/7.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyNDEwcGVlcmludGZldGh2cG9ydC0xLzIvNy4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/7:1',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI3'}],
                                                                       'name': 'gpon_onu-1/2/7:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyNDEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNzox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/7:1',
                                                                                               'id': 'gpon_onu-1/2/7:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjcnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/2/7:1',
                                                                                               'poller_hash': 'VFBMR0REOEQyNDEwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/2/7:1',
                                         'poller_hash': 'VFBMR0REOEQyNDEw',
                                         'serial_number': 'TPLGDD8D2410',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '9366'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_zte_zxa10_c620_V2_0_10_0120_2(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.10.0120_2")
        exp_info = {
         'model': 'C620', 'sta_count': 7, 'sw_version': 'V2.0.10', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'TPLGDD8D0400': {       'dev_macs': ['8c:86:dd:8d:04:03'],
                                        'ip_address': None,
                                        'name': '1/1/10:3',
                                        'serial': 'TPLGDD8D0400',
                                        'serial_number': None},
                'TPLGDD8D1C98': {       'dev_macs': ['8c:86:dd:8d:1c:9b'],
                                        'ip_address': None,
                                        'name': '1/1/4:2',
                                        'serial': 'TPLGDD8D1C98',
                                        'serial_number': None},
                'TPLGDD8D1D68': {       'dev_macs': ['8c:86:dd:8d:1d:6b'],
                                        'ip_address': None,
                                        'name': '1/1/10:2',
                                        'serial': 'TPLGDD8D1D68',
                                        'serial_number': None},
                'TPLGDD8D21F0': {       'dev_macs': ['8c:86:dd:8d:21:f3'],
                                        'ip_address': None,
                                        'name': '1/1/4:3',
                                        'serial': 'TPLGDD8D21F0',
                                        'serial_number': None},
                'TPLGDD8D2410': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/7:1',
                                        'serial': 'TPLGDD8D2410',
                                        'serial_number': None},
                'TPLGDD8D2900': {       'dev_macs': ['8c:86:dd:8d:29:03'],
                                        'ip_address': None,
                                        'name': '1/1/4:1',
                                        'serial': 'TPLGDD8D2900',
                                        'serial_number': None},
                'TPLGDD8D6668': {       'dev_macs': ['8c:86:dd:8d:66:6b'],
                                        'ip_address': None,
                                        'name': '1/1/10:1',
                                        'serial': 'TPLGDD8D6668',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278465',
                                                                                         'name': 'gpon_olt-1/1/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY1',
                                                                                         'pons': [       {       'description': '285278465.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278465.2',
                                                                                                                 'id': 'gpon_olt-1/1/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278466',
                                                                                         'name': 'gpon_olt-1/1/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY2',
                                                                                         'pons': [       {       'description': '285278466.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278466.2',
                                                                                                                 'id': 'gpon_olt-1/1/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278467',
                                                                                         'name': 'gpon_olt-1/1/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY3',
                                                                                         'pons': [       {       'description': '285278467.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278467.2',
                                                                                                                 'id': 'gpon_olt-1/1/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278468',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDox'},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZwb25ncG9uX29udS0xLzEvNDoy'},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDoz'}],
                                                                                         'name': 'gpon_olt-1/1/4',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4',
                                                                                         'pons': [       {       'description': '285278468.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278468.2',
                                                                                                                 'id': 'gpon_olt-1/1/4',
                                                                                                                 'links': [       {       'connected_time': '18768',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQyOTAwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '17434',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQxQzk4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '18768',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQyMUYwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278469',
                                                                                         'name': 'gpon_olt-1/1/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY5',
                                                                                         'pons': [       {       'description': '285278469.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278469.2',
                                                                                                                 'id': 'gpon_olt-1/1/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278470',
                                                                                         'name': 'gpon_olt-1/1/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcw',
                                                                                         'pons': [       {       'description': '285278470.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278470.2',
                                                                                                                 'id': 'gpon_olt-1/1/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278471',
                                                                                         'name': 'gpon_olt-1/1/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcx',
                                                                                         'pons': [       {       'description': '285278471.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278471.2',
                                                                                                                 'id': 'gpon_olt-1/1/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278472',
                                                                                         'name': 'gpon_olt-1/1/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcy',
                                                                                         'pons': [       {       'description': '285278472.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/8',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278472.2',
                                                                                                                 'id': 'gpon_olt-1/1/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278473',
                                                                                         'name': 'gpon_olt-1/1/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDcz',
                                                                                         'pons': [       {       'description': '285278473.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/9',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278473.2',
                                                                                                                 'id': 'gpon_olt-1/1/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278474',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6MQ=='},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mg=='},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mw=='}],
                                                                                         'name': 'gpon_olt-1/1/10',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0',
                                                                                         'pons': [       {       'description': '285278474.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/10',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278474.2',
                                                                                                                 'id': 'gpon_olt-1/1/10',
                                                                                                                 'links': [       {       'connected_time': '15535',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '18768',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQxRDY4cGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '18768',
                                                                                                                                          'poller_hash': 'VFBMR0REOEQwNDAwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278475',
                                                                                         'name': 'gpon_olt-1/1/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc1',
                                                                                         'pons': [       {       'description': '285278475.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/11',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278475.2',
                                                                                                                 'id': 'gpon_olt-1/1/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278476',
                                                                                         'name': 'gpon_olt-1/1/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc2',
                                                                                         'pons': [       {       'description': '285278476.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/12',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278476.2',
                                                                                                                 'id': 'gpon_olt-1/1/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278477',
                                                                                         'name': 'gpon_olt-1/1/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc3',
                                                                                         'pons': [       {       'description': '285278477.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/13',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278477.2',
                                                                                                                 'id': 'gpon_olt-1/1/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278478',
                                                                                         'name': 'gpon_olt-1/1/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc4',
                                                                                         'pons': [       {       'description': '285278478.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/14',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278478.2',
                                                                                                                 'id': 'gpon_olt-1/1/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278479',
                                                                                         'name': 'gpon_olt-1/1/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc5',
                                                                                         'pons': [       {       'description': '285278479.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/15',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278479.2',
                                                                                                                 'id': 'gpon_olt-1/1/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Nzknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278480',
                                                                                         'name': 'gpon_olt-1/1/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDgw',
                                                                                         'pons': [       {       'description': '285278480.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/16',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0ODAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278480.2',
                                                                                                                 'id': 'gpon_olt-1/1/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0ODAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/1 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwMjI5',
                                                           'serial_number': '772138100229',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278721.2',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278722.2',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278723.2',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278724.2',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278725.2',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278726.2',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278727.2',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI4',
                                                                                         'pons': [       {       'description': '285278728.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/8',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278728.2',
                                                                                                                 'id': 'gpon_olt-1/2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzI5',
                                                                                         'pons': [       {       'description': '285278729.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/9',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278729.2',
                                                                                                                 'id': 'gpon_olt-1/2/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3Mjknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMw',
                                                                                         'pons': [       {       'description': '285278730.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/10',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278730.2',
                                                                                                                 'id': 'gpon_olt-1/2/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMx',
                                                                                         'pons': [       {       'description': '285278731.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/11',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278731.2',
                                                                                                                 'id': 'gpon_olt-1/2/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMy',
                                                                                         'pons': [       {       'description': '285278732.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/12',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278732.2',
                                                                                                                 'id': 'gpon_olt-1/2/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzMz',
                                                                                         'pons': [       {       'description': '285278733.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/13',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278733.2',
                                                                                                                 'id': 'gpon_olt-1/2/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM0',
                                                                                         'pons': [       {       'description': '285278734.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/14',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278734.2',
                                                                                                                 'id': 'gpon_olt-1/2/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM1',
                                                                                         'pons': [       {       'description': '285278735.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/15',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278735.2',
                                                                                                                 'id': 'gpon_olt-1/2/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDc3Mjg1Mjc4NzM2',
                                                                                         'pons': [       {       'description': '285278736.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/16',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278736.2',
                                                                                                                 'id': 'gpon_olt-1/2/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0NzcyODUyNzg3MzYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/2 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwNDc3',
                                                           'serial_number': '772138100477',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/3',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'FCSDA',
                                                           'name': '1/1/3 FCSDA',
                                                           'poller_hash': 'NzcyMDgyMjAwMDMz',
                                                           'serial_number': '772082200033'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjMz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM0'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM1'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDEwMjg1Mjc5MjM2'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzcyNTY5MzAwMDEw',
                                                           'serial_number': '772569300010',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDM1Mjg1Mjc5NDky'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzcyNTY5MzAwMDM1',
                                                           'serial_number': '772569300035',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMDgx',
                                                           'serial_number': '772391900081'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMDc1',
                                                           'serial_number': '772391900075'}],
                                'poller_hash': 'NzcyNDI4MjAwMDk0b2x0',
                                'serial_number': '772428200094',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.10',
                                'system_mac_address': 'd8:0a:e6:b5:15:ce'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:29:03'],
                                                                       'id': 'vport-1/1/4.1:1',
                                                                       'name': 'vport-1/1/4.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZldGh2cG9ydC0xLzEvNC4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:1',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyOTAwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:1',
                                                                                               'id': 'gpon_onu-1/1/4:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:1',
                                                                                               'poller_hash': 'VFBMR0REOEQyOTAwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:1',
                                         'poller_hash': 'VFBMR0REOEQyOTAw',
                                         'serial_number': 'TPLGDD8D2900',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '18768'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:1c:9b'],
                                                                       'id': 'vport-1/1/4.2:1',
                                                                       'name': 'vport-1/1/4.2:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZldGh2cG9ydC0xLzEvNC4yOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:2',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxQzk4cGVlcmludGZwb25ncG9uX29udS0xLzEvNDoy',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:2',
                                                                                               'id': 'gpon_onu-1/1/4:2',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:2',
                                                                                               'poller_hash': 'VFBMR0REOEQxQzk4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:2',
                                         'poller_hash': 'VFBMR0REOEQxQzk4',
                                         'serial_number': 'TPLGDD8D1C98',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '17434'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:21:f3'],
                                                                       'id': 'vport-1/1/4.3:1',
                                                                       'name': 'vport-1/1/4.3:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZldGh2cG9ydC0xLzEvNC4zOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/4:3',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDY4'}],
                                                                       'name': 'gpon_onu-1/1/4:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQyMUYwcGVlcmludGZwb25ncG9uX29udS0xLzEvNDoz',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/4:3',
                                                                                               'id': 'gpon_onu-1/1/4:3',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0Njgnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/4:3',
                                                                                               'poller_hash': 'VFBMR0REOEQyMUYwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/4:3',
                                         'poller_hash': 'VFBMR0REOEQyMUYw',
                                         'serial_number': 'TPLGDD8D21F0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '18768'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:66:6b'],
                                                                       'id': 'vport-1/1/10.1:1',
                                                                       'name': 'vport-1/1/10.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZldGh2cG9ydC0xLzEvMTAuMTox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:1',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6MQ==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:1',
                                                                                               'id': 'gpon_onu-1/1/10:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:1',
                                                                                               'poller_hash': 'VFBMR0REOEQ2NjY4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:1',
                                         'poller_hash': 'VFBMR0REOEQ2NjY4',
                                         'serial_number': 'TPLGDD8D6668',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '15535'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:1d:6b'],
                                                                       'id': 'vport-1/1/10.2:1',
                                                                       'name': 'vport-1/1/10.2:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZldGh2cG9ydC0xLzEvMTAuMjox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:2',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQxRDY4cGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mg==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:2',
                                                                                               'id': 'gpon_onu-1/1/10:2',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:2',
                                                                                               'poller_hash': 'VFBMR0REOEQxRDY4cGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:2',
                                         'poller_hash': 'VFBMR0REOEQxRDY4',
                                         'serial_number': 'TPLGDD8D1D68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '18768'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:86:dd:8d:04:03'],
                                                                       'id': 'vport-1/1/10.3:1',
                                                                       'name': 'vport-1/1/10.3:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZldGh2cG9ydC0xLzEvMTAuMzox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/10:3',
                                                                       'links': [       {       'poller_hash': 'NzcyMTM4MTAwMjI5Mjg1Mjc4NDc0'}],
                                                                       'name': 'gpon_onu-1/1/10:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMR0REOEQwNDAwcGVlcmludGZwb25ncG9uX29udS0xLzEvMTA6Mw==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/10:3',
                                                                                               'id': 'gpon_onu-1/1/10:3',
                                                                                               'links': [       {       'poller_hash': 'Yic3NzIxMzgxMDAyMjkyODUyNzg0NzQnb2x0cG9uMg=='}],
                                                                                               'name': 'gpon_onu-1/1/10:3',
                                                                                               'poller_hash': 'VFBMR0REOEQwNDAwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/10:3',
                                         'poller_hash': 'VFBMR0REOEQwNDAw',
                                         'serial_number': 'TPLGDD8D0400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '18768'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/7.1:1',
                                                                       'name': 'vport-1/2/7.1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMR0REOEQyNDEwcGVlcmludGZldGh2cG9ydC0xLzIvNy4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/7:1',
                                                                       'name': 'gpon_onu-1/2/7:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMR0REOEQyNDEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNzox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/7:1',
                                                                                               'id': 'gpon_onu-1/2/7:1',
                                                                                               'name': 'gpon_onu-1/2/7:1',
                                                                                               'poller_hash': 'VFBMR0REOEQyNDEwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/2/7:1',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'DyingGasp',
                                         'offline_time': '2025-12-02T19:06:03Z',
                                         'poller_hash': 'VFBMR0REOEQyNDEw',
                                         'serial_number': 'TPLGDD8D2410',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_zte_zxa10_c620_V2_0_10_0121(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.10.0121")
        exp_info = {
         'model': 'C620', 'sta_count': 1, 'sw_version': 'V2.0.10', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'TPLGDD8D2220': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/1/11:1',
                                        'serial': 'TPLGDD8D2220',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278465',
                                                                                         'name': 'gpon_olt-1/1/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDY1',
                                                                                         'pons': [       {       'description': '285278465.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278465.2',
                                                                                                                 'id': 'gpon_olt-1/1/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278466',
                                                                                         'name': 'gpon_olt-1/1/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDY2',
                                                                                         'pons': [       {       'description': '285278466.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278466.2',
                                                                                                                 'id': 'gpon_olt-1/1/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278467',
                                                                                         'name': 'gpon_olt-1/1/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDY3',
                                                                                         'pons': [       {       'description': '285278467.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278467.2',
                                                                                                                 'id': 'gpon_olt-1/1/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278468',
                                                                                         'name': 'gpon_olt-1/1/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDY4',
                                                                                         'pons': [       {       'description': '285278468.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278468.2',
                                                                                                                 'id': 'gpon_olt-1/1/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278469',
                                                                                         'name': 'gpon_olt-1/1/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDY5',
                                                                                         'pons': [       {       'description': '285278469.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278469.2',
                                                                                                                 'id': 'gpon_olt-1/1/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Njknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278470',
                                                                                         'name': 'gpon_olt-1/1/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDcw',
                                                                                         'pons': [       {       'description': '285278470.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278470.2',
                                                                                                                 'id': 'gpon_olt-1/1/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278471',
                                                                                         'name': 'gpon_olt-1/1/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDcx',
                                                                                         'pons': [       {       'description': '285278471.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278471.2',
                                                                                                                 'id': 'gpon_olt-1/1/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278472',
                                                                                         'name': 'gpon_olt-1/1/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDcy',
                                                                                         'pons': [       {       'description': '285278472.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/8',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278472.2',
                                                                                                                 'id': 'gpon_olt-1/1/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/8',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278473',
                                                                                         'name': 'gpon_olt-1/1/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDcz',
                                                                                         'pons': [       {       'description': '285278473.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/9',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278473.2',
                                                                                                                 'id': 'gpon_olt-1/1/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/9',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278474',
                                                                                         'name': 'gpon_olt-1/1/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc0',
                                                                                         'pons': [       {       'description': '285278474.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/10',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278474.2',
                                                                                                                 'id': 'gpon_olt-1/1/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/10',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278475',
                                                                                         'name': 'gpon_olt-1/1/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc1',
                                                                                         'pons': [       {       'description': '285278475.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/11',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278475.2',
                                                                                                                 'id': 'gpon_olt-1/1/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/11',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278476',
                                                                                         'name': 'gpon_olt-1/1/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc2',
                                                                                         'pons': [       {       'description': '285278476.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/12',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278476.2',
                                                                                                                 'id': 'gpon_olt-1/1/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/12',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0NzYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278477',
                                                                                         'name': 'gpon_olt-1/1/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc3',
                                                                                         'pons': [       {       'description': '285278477.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/13',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278477.2',
                                                                                                                 'id': 'gpon_olt-1/1/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/13',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278478',
                                                                                         'name': 'gpon_olt-1/1/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc4',
                                                                                         'pons': [       {       'description': '285278478.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/14',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278478.2',
                                                                                                                 'id': 'gpon_olt-1/1/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/14',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzgnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278479',
                                                                                         'name': 'gpon_olt-1/1/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDc5',
                                                                                         'pons': [       {       'description': '285278479.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/15',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278479.2',
                                                                                                                 'id': 'gpon_olt-1/1/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/15',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0Nzknb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278480',
                                                                                         'name': 'gpon_olt-1/1/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwMDQxMjg1Mjc4NDgw',
                                                                                         'pons': [       {       'description': '285278480.1',
                                                                                                                 'id': 'xgs-pon_olt-1/1/16',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0ODAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278480.2',
                                                                                                                 'id': 'gpon_olt-1/1/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/1/16',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDAwNDEyODUyNzg0ODAnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/1 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwMDQx',
                                                           'serial_number': '772138100041',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/1',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278721.2',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjEnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/2',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278722.2',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjInb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/3',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278723.2',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjMnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/4',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278724.2',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjQnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/5',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278725.2',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjUnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/6',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278726.2',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3MjYnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'xgs-pon_olt-1/2/7',
                                                                                                                 'max_distance': 40000,
                                                                                                                 'name': 'xgs-pon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '9953280000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '9953280000'},
                                                                                                         {       'description': '285278727.2',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3NzIxMzgxMDA0MjYyODUyNzg3Mjcnb2x0cG9uMg==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI4'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzI5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzMw'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzMx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzMy'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzMz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzM0'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzM1'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyMTM4MTAwNDI2Mjg1Mjc4NzM2'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFCL',
                                                           'name': '1/1/2 GFCL',
                                                           'poller_hash': 'NzcyMTM4MTAwNDI2',
                                                           'serial_number': '772138100426',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/3',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'FCSDA',
                                                           'name': '1/1/3 FCSDA',
                                                           'poller_hash': 'NzcyMDgyMjAwMDM0',
                                                           'serial_number': '772082200034'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDIzMjg1Mjc5MjMz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDIzMjg1Mjc5MjM0'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDIzMjg1Mjc5MjM1'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcyNTY5MzAwMDIzMjg1Mjc5MjM2'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzcyNTY5MzAwMDIz',
                                                           'serial_number': '772569300023',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzcxNTI3ODAwMDg3Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcxNTI3ODAwMDg3Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcxNTI3ODAwMDg3Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzcxNTI3ODAwMDg3Mjg1Mjc5NDky'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzcxNTI3ODAwMDg3',
                                                           'serial_number': '771527800087',
                                                           'sw_version': 'V2.2.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMDg3',
                                                           'serial_number': '772391900087'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzcyMzkxOTAwMTk3',
                                                           'serial_number': '772391900197'}],
                                'poller_hash': 'NzcyNDI4MjAwMDkyb2x0',
                                'serial_number': '772428200092',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.10',
                                'system_mac_address': 'd8:0a:e6:b5:15:d2'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/1/11.1:1',
                                                                       'name': 'vport-1/1/11.1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMR0REOEQyMjIwcGVlcmludGZldGh2cG9ydC0xLzEvMTEuMTox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/1/11:1',
                                                                       'name': 'gpon_onu-1/1/11:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMR0REOEQyMjIwcGVlcmludGZwb25ncG9uX29udS0xLzEvMTE6MQ==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/1/11:1',
                                                                                               'id': 'gpon_onu-1/1/11:1',
                                                                                               'name': 'gpon_onu-1/1/11:1',
                                                                                               'poller_hash': 'VFBMR0REOEQyMjIwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/1/11:1',
                                         'offline_reason': 'OFFLINE_REASON_POWER_OFF',
                                         'offline_reason_detail': 'DyingGasp',
                                         'offline_time': '2025-12-02T19:06:03Z',
                                         'poller_hash': 'VFBMR0REOEQyMjIw',
                                         'serial_number': 'TPLGDD8D2220',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_zte_zxa10_c620_V2_0_10_01(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.10.01")
        exp_info = {
         'model': 'C620', 'sta_count': None, 'sw_version': 'V2.0.10', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_zte_zxa10_c620_V2_0_20_00(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.20.00")
        exp_info = {
         'model': 'C620', 'sta_count': 2, 'sw_version': 'V2.0.30', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'MONU00543E50': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/5:1',
                                        'serial': 'MONU00543E50',
                                        'serial_number': None},
                'TPLG5F2A4DA0': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/5:2',
                                        'serial': 'TPLG5F2A4DA0',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox'}],
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'links': [       {       'connected_time': '2800803',
                                                                                                                                          'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI4',
                                                                                         'pons': [       {       'description': '285278728.1',
                                                                                                                 'id': 'gpon_olt-1/2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI5',
                                                                                         'pons': [       {       'description': '285278729.1',
                                                                                                                 'id': 'gpon_olt-1/2/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMw',
                                                                                         'pons': [       {       'description': '285278730.1',
                                                                                                                 'id': 'gpon_olt-1/2/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMx',
                                                                                         'pons': [       {       'description': '285278731.1',
                                                                                                                 'id': 'gpon_olt-1/2/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMy',
                                                                                         'pons': [       {       'description': '285278732.1',
                                                                                                                 'id': 'gpon_olt-1/2/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMz',
                                                                                         'pons': [       {       'description': '285278733.1',
                                                                                                                 'id': 'gpon_olt-1/2/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM0',
                                                                                         'pons': [       {       'description': '285278734.1',
                                                                                                                 'id': 'gpon_olt-1/2/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM1',
                                                                                         'pons': [       {       'description': '285278735.1',
                                                                                                                 'id': 'gpon_olt-1/2/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM2',
                                                                                         'pons': [       {       'description': '285278736.1',
                                                                                                                 'id': 'gpon_olt-1/2/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFGL',
                                                           'name': '1/1/2 GFGL',
                                                           'poller_hash': 'NzM1MDU3NTAwMDEz',
                                                           'serial_number': '735057500013',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjMz'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM0'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM1'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM2'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279237',
                                                                                         'name': 'gei-1/4/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM3'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMzE3',
                                                           'serial_number': '735277700317',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDky'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279493',
                                                                                         'name': 'gei-1/5/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkz'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMjE3',
                                                           'serial_number': '735277700217',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjkx',
                                                           'serial_number': '735461600691'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjgz',
                                                           'serial_number': '735461600683'}],
                                'poller_hash': 'MjE5Mjc0OTk1MDQ5b2x0',
                                'serial_number': '219274995049',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.30',
                                'system_mac_address': 'd4:c1:c8:18:bc:28'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/5.1:1',
                                                                       'name': 'vport-1/2/5.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZldGh2cG9ydC0xLzIvNS4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:1',
                                                                       'links': [       {       'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1'}],
                                                                       'name': 'gpon_onu-1/2/5:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:1',
                                                                                               'id': 'gpon_onu-1/2/5:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ=='}],
                                                                                               'name': 'gpon_onu-1/2/5:1',
                                                                                               'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'SofTel',
                                         'model': 'MONUH225',
                                         'name': '1/2/5:1',
                                         'poller_hash': 'TU9OVTAwNTQzRTUw',
                                         'serial_number': 'MONU00543E50',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '2800803'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/5.2:1',
                                                                       'name': 'vport-1/2/5.2:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZldGh2cG9ydC0xLzIvNS4yOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:2',
                                                                       'name': 'gpon_onu-1/2/5:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNToy',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:2',
                                                                                               'id': 'gpon_onu-1/2/5:2',
                                                                                               'name': 'gpon_onu-1/2/5:2',
                                                                                               'poller_hash': 'VFBMRzVGMkE0REEwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'name': '1/2/5:2',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'poller_hash': 'VFBMRzVGMkE0REEw',
                                         'serial_number': 'TPLG5F2A4DA0',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_zte_zxa10_c620_V2_0_20_01(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.20.01")
        exp_info = {
         'model': 'C620', 'sta_count': 3, 'sw_version': 'V2.0.30', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'MONU00322071': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/16:1',
                                        'serial': 'MONU00322071',
                                        'serial_number': None},
                'MONU00543E50': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/5:1',
                                        'serial': 'MONU00543E50',
                                        'serial_number': None},
                'TPLG5F2A4DA0': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/5:2',
                                        'serial': 'TPLG5F2A4DA0',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox'},
                                                                                                          {       'oper_up': True,
                                                                                                                  'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNToy'}],
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'links': [       {       'connected_time': '379544',
                                                                                                                                          'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'},
                                                                                                                                  {       'connected_time': '456540',
                                                                                                                                          'poller_hash': 'VFBMRzVGMkE0REEwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI4',
                                                                                         'pons': [       {       'description': '285278728.1',
                                                                                                                 'id': 'gpon_olt-1/2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI5',
                                                                                         'pons': [       {       'description': '285278729.1',
                                                                                                                 'id': 'gpon_olt-1/2/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMw',
                                                                                         'pons': [       {       'description': '285278730.1',
                                                                                                                 'id': 'gpon_olt-1/2/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMx',
                                                                                         'pons': [       {       'description': '285278731.1',
                                                                                                                 'id': 'gpon_olt-1/2/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMy',
                                                                                         'pons': [       {       'description': '285278732.1',
                                                                                                                 'id': 'gpon_olt-1/2/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMz',
                                                                                         'pons': [       {       'description': '285278733.1',
                                                                                                                 'id': 'gpon_olt-1/2/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM0',
                                                                                         'pons': [       {       'description': '285278734.1',
                                                                                                                 'id': 'gpon_olt-1/2/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM1',
                                                                                         'pons': [       {       'description': '285278735.1',
                                                                                                                 'id': 'gpon_olt-1/2/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM2',
                                                                                         'pons': [       {       'description': '285278736.1',
                                                                                                                 'id': 'gpon_olt-1/2/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFGL',
                                                           'name': '1/1/2 GFGL',
                                                           'poller_hash': 'NzM1MDU3NTAwMDEz',
                                                           'serial_number': '735057500013',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjMz'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM0'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM1'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM2'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279237',
                                                                                         'name': 'gei-1/4/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM3'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMzE3',
                                                           'serial_number': '735277700317',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDky'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279493',
                                                                                         'name': 'gei-1/5/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkz'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMjE3',
                                                           'serial_number': '735277700217',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjkx',
                                                           'serial_number': '735461600691'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjgz',
                                                           'serial_number': '735461600683'}],
                                'poller_hash': 'MjE5Mjc0OTk1MDQ5b2x0',
                                'serial_number': '219274995049',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.30',
                                'system_mac_address': 'd4:c1:c8:18:bc:28'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/5.1:1',
                                                                       'name': 'vport-1/2/5.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZldGh2cG9ydC0xLzIvNS4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:1',
                                                                       'links': [       {       'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1'}],
                                                                       'name': 'gpon_onu-1/2/5:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:1',
                                                                                               'id': 'gpon_onu-1/2/5:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ=='}],
                                                                                               'name': 'gpon_onu-1/2/5:1',
                                                                                               'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'SofTel',
                                         'model': 'MONUH225',
                                         'name': '1/2/5:1',
                                         'poller_hash': 'TU9OVTAwNTQzRTUw',
                                         'serial_number': 'MONU00543E50',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '379544'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/5.2:1',
                                                                       'name': 'vport-1/2/5.2:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZldGh2cG9ydC0xLzIvNS4yOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:2',
                                                                       'links': [       {       'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1'}],
                                                                       'name': 'gpon_onu-1/2/5:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNToy',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:2',
                                                                                               'id': 'gpon_onu-1/2/5:2',
                                                                                               'links': [       {       'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ=='}],
                                                                                               'name': 'gpon_onu-1/2/5:2',
                                                                                               'poller_hash': 'VFBMRzVGMkE0REEwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'model': 'XX230v',
                                         'name': '1/2/5:2',
                                         'poller_hash': 'VFBMRzVGMkE0REEw',
                                         'serial_number': 'TPLG5F2A4DA0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '456540'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/16.1:1',
                                                                       'name': 'vport-1/2/16.1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcmludGZldGh2cG9ydC0xLzIvMTYuMTox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/16:1',
                                                                       'name': 'gpon_onu-1/2/16:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcmludGZwb25ncG9uX29udS0xLzIvMTY6MQ==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/16:1',
                                                                                               'id': 'gpon_onu-1/2/16:1',
                                                                                               'name': 'gpon_onu-1/2/16:1',
                                                                                               'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcnBvbg=='}]}],
                                         'manufacturer': 'SofTel',
                                         'name': '1/2/16:1',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'poller_hash': 'TU9OVTAwMzIyMDcx',
                                         'serial_number': 'MONU00322071',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_zte_zxa10_c620_V2_0_20_02(self):
        obj = self.run_data("zte.zxa10.c620.V2.0.20.02")
        exp_info = {
         'model': 'C620', 'sta_count': 3, 'sw_version': 'V2.0.30', 'vendor': 'ZTE'
        }
        exp_stats = {
         'serial_number': None
        }
        exp_sta_stats = {
                'MONU00322071': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/16:1',
                                        'serial': 'MONU00322071',
                                        'serial_number': None},
                'MONU00543E50': {       'dev_macs': ['1c:ef:03:54:3e:51'],
                                        'ip_address': None,
                                        'name': '1/2/5:1',
                                        'serial': 'MONU00543E50',
                                        'serial_number': None},
                'TPLG5F2A4DA0': {       'dev_macs': [],
                                        'ip_address': None,
                                        'name': '1/2/5:2',
                                        'serial': 'TPLG5F2A4DA0',
                                        'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'ZTE',
                                'model': 'C620',
                                'modules': [       {       'id': '1/1/2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285278721',
                                                                                         'name': 'gpon_olt-1/2/1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIx',
                                                                                         'pons': [       {       'description': '285278721.1',
                                                                                                                 'id': 'gpon_olt-1/2/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/1',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278722',
                                                                                         'name': 'gpon_olt-1/2/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIy',
                                                                                         'pons': [       {       'description': '285278722.1',
                                                                                                                 'id': 'gpon_olt-1/2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/2',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278723',
                                                                                         'name': 'gpon_olt-1/2/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzIz',
                                                                                         'pons': [       {       'description': '285278723.1',
                                                                                                                 'id': 'gpon_olt-1/2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/3',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278724',
                                                                                         'name': 'gpon_olt-1/2/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI0',
                                                                                         'pons': [       {       'description': '285278724.1',
                                                                                                                 'id': 'gpon_olt-1/2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/4',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278725',
                                                                                         'links': [       {       'oper_up': True,
                                                                                                                  'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox'}],
                                                                                         'name': 'gpon_olt-1/2/5',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1',
                                                                                         'pons': [       {       'description': '285278725.1',
                                                                                                                 'id': 'gpon_olt-1/2/5',
                                                                                                                 'links': [       {       'connected_time': '2800803',
                                                                                                                                          'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000'}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/5',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278726',
                                                                                         'name': 'gpon_olt-1/2/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI2',
                                                                                         'pons': [       {       'description': '285278726.1',
                                                                                                                 'id': 'gpon_olt-1/2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/6',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278727',
                                                                                         'name': 'gpon_olt-1/2/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI3',
                                                                                         'pons': [       {       'description': '285278727.1',
                                                                                                                 'id': 'gpon_olt-1/2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/7',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjcnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278728',
                                                                                         'name': 'gpon_olt-1/2/8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI4',
                                                                                         'pons': [       {       'description': '285278728.1',
                                                                                                                 'id': 'gpon_olt-1/2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/8',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjgnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278729',
                                                                                         'name': 'gpon_olt-1/2/9',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI5',
                                                                                         'pons': [       {       'description': '285278729.1',
                                                                                                                 'id': 'gpon_olt-1/2/9',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/9',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3Mjknb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278730',
                                                                                         'name': 'gpon_olt-1/2/10',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMw',
                                                                                         'pons': [       {       'description': '285278730.1',
                                                                                                                 'id': 'gpon_olt-1/2/10',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/10',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzAnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278731',
                                                                                         'name': 'gpon_olt-1/2/11',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMx',
                                                                                         'pons': [       {       'description': '285278731.1',
                                                                                                                 'id': 'gpon_olt-1/2/11',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/11',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzEnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278732',
                                                                                         'name': 'gpon_olt-1/2/12',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMy',
                                                                                         'pons': [       {       'description': '285278732.1',
                                                                                                                 'id': 'gpon_olt-1/2/12',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/12',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzInb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278733',
                                                                                         'name': 'gpon_olt-1/2/13',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzMz',
                                                                                         'pons': [       {       'description': '285278733.1',
                                                                                                                 'id': 'gpon_olt-1/2/13',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/13',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzMnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278734',
                                                                                         'name': 'gpon_olt-1/2/14',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM0',
                                                                                         'pons': [       {       'description': '285278734.1',
                                                                                                                 'id': 'gpon_olt-1/2/14',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/14',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzQnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278735',
                                                                                         'name': 'gpon_olt-1/2/15',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM1',
                                                                                         'pons': [       {       'description': '285278735.1',
                                                                                                                 'id': 'gpon_olt-1/2/15',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/15',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzUnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285278736',
                                                                                         'name': 'gpon_olt-1/2/16',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzM2',
                                                                                         'pons': [       {       'description': '285278736.1',
                                                                                                                 'id': 'gpon_olt-1/2/16',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon_olt-1/2/16',
                                                                                                                 'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MzYnb2x0cG9uMQ==',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'GFGL',
                                                           'name': '1/1/2 GFGL',
                                                           'poller_hash': 'NzM1MDU3NTAwMDEz',
                                                           'serial_number': '735057500013',
                                                           'sw_version': 'V2.1.0'},
                                                   {       'id': '1/1/4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279233',
                                                                                         'name': 'xgei-1/4/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjMz'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279234',
                                                                                         'name': 'xgei-1/4/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM0'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279235',
                                                                                         'name': 'xgei-1/4/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM1'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279236',
                                                                                         'name': 'xgei-1/4/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM2'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279237',
                                                                                         'name': 'gei-1/4/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMzE3Mjg1Mjc5MjM3'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/4 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMzE3',
                                                           'serial_number': '735277700317',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '285279489',
                                                                                         'name': 'xgei-1/5/1',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDg5'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279490',
                                                                                         'name': 'xgei-1/5/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkw'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279491',
                                                                                         'name': 'xgei-1/5/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '285279492',
                                                                                         'name': 'xgei-1/5/4',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDky'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '285279493',
                                                                                         'name': 'gei-1/5/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NzM1Mjc3NzAwMjE3Mjg1Mjc5NDkz'}],
                                                           'manufacturer': 'ZTE',
                                                           'model': 'SPUF',
                                                           'name': '1/1/5 SPUF',
                                                           'poller_hash': 'NzM1Mjc3NzAwMjE3',
                                                           'serial_number': '735277700217',
                                                           'sw_version': 'V2.5.0'},
                                                   {       'id': '1/1/6',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/6 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjkx',
                                                           'serial_number': '735461600691'},
                                                   {       'id': '1/1/7',
                                                           'manufacturer': 'ZTE',
                                                           'model': 'PRSF',
                                                           'name': '1/1/7 PRSF',
                                                           'poller_hash': 'NzM1NDYxNjAwNjgz',
                                                           'serial_number': '735461600683'}],
                                'poller_hash': 'MjE5Mjc0OTk1MDQ5b2x0',
                                'serial_number': '219274995049',
                                'status': 'ELEMENT_STATUS_ONLINE',
                                'sw_version': 'V2.0.30',
                                'system_mac_address': 'd4:c1:c8:18:bc:28'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:ef:03:54:3e:51'],
                                                                       'id': 'vport-1/2/5.1:1',
                                                                       'name': 'vport-1/2/5.1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZldGh2cG9ydC0xLzIvNS4xOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:1',
                                                                       'links': [       {       'poller_hash': 'NzM1MDU3NTAwMDEzMjg1Mjc4NzI1'}],
                                                                       'name': 'gpon_onu-1/2/5:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcmludGZwb25ncG9uX29udS0xLzIvNTox',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:1',
                                                                                               'id': 'gpon_onu-1/2/5:1',
                                                                                               'links': [       {       'poller_hash': 'Yic3MzUwNTc1MDAwMTMyODUyNzg3MjUnb2x0cG9uMQ=='}],
                                                                                               'name': 'gpon_onu-1/2/5:1',
                                                                                               'poller_hash': 'TU9OVTAwNTQzRTUwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'SofTel',
                                         'model': 'MONUH225',
                                         'name': '1/2/5:1',
                                         'poller_hash': 'TU9OVTAwNTQzRTUw',
                                         'serial_number': 'MONU00543E50',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'uptime': '2800803'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/5.2:1',
                                                                       'name': 'vport-1/2/5.2:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZldGh2cG9ydC0xLzIvNS4yOjE='},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/5:2',
                                                                       'name': 'gpon_onu-1/2/5:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'VFBMRzVGMkE0REEwcGVlcmludGZwb25ncG9uX29udS0xLzIvNToy',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/5:2',
                                                                                               'id': 'gpon_onu-1/2/5:2',
                                                                                               'name': 'gpon_onu-1/2/5:2',
                                                                                               'poller_hash': 'VFBMRzVGMkE0REEwcGVlcnBvbg==',
                                                                                               'pon_technology': 'GPON'}]}],
                                         'manufacturer': 'TP-Link',
                                         'name': '1/2/5:2',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'poller_hash': 'VFBMRzVGMkE0REEw',
                                         'serial_number': 'TPLG5F2A4DA0',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'vport-1/2/16.1:1',
                                                                       'name': 'vport-1/2/16.1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcmludGZldGh2cG9ydC0xLzIvMTYuMTox'},
                                                               {       'admin_up': True,
                                                                       'id': 'gpon_onu-1/2/16:1',
                                                                       'name': 'gpon_onu-1/2/16:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcmludGZwb25ncG9uX29udS0xLzIvMTY6MQ==',
                                                                       'pons': [       {       'description': 'gpon_onu-1/2/16:1',
                                                                                               'id': 'gpon_onu-1/2/16:1',
                                                                                               'name': 'gpon_onu-1/2/16:1',
                                                                                               'poller_hash': 'TU9OVTAwMzIyMDcxcGVlcnBvbg=='}]}],
                                         'manufacturer': 'SofTel',
                                         'name': '1/2/16:1',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'poller_hash': 'TU9OVTAwMzIyMDcx',
                                         'serial_number': 'MONU00322071',
                                         'status': 'ELEMENT_STATUS_OFFLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
