import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):

    def test_mimosa_a5_A5_360_14_2_5_0_01(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.0.01")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 40,
                'rf_freq': 6165,
                'rf_tx_power': 24,
                'sta_count': 6,
                'sw_version': '2.5.0',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 1958427979,
                'dl_rf_packets': 415380079,
                'temperature': 48.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 2463811624,
                'ul_rf_packets': 309485676
        }
        exp_sta_stats = {
                '20:b5:c6:06:a2:1a': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.3',
                                             'mac_address': '20:b5:c6:06:a2:1a',
                                             'name': '1010 Kennedy',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -81.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.5,
                                             'ul_snr': 29.4},
                '20:b5:c6:06:ab:57': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.33',
                                             'mac_address': '20:b5:c6:06:ab:57',
                                             'name': 'Key Plaza Creperie',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -83.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53.4,
                                             'ul_snr': 30.1},
                '20:b5:c6:10:52:09': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 150000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.23',
                                             'mac_address': '20:b5:c6:10:52:09',
                                             'name': 'Wesley- Poinciana_Mcarthy',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -88.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.3,
                                             'ul_snr': 27.6},
                '20:b5:c6:10:5d:60': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.128',
                                             'mac_address': '20:b5:c6:10:5d:60',
                                             'name': 'KW_Spine_And_Injury',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -90.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 29.3},
                '20:b5:c6:11:42:18': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.53',
                                             'mac_address': '20:b5:c6:11:42:18',
                                             'name': 'DR Scooters',
                                             'temperature': None,
                                             'ul_link_rate': 67500000,
                                             'ul_noise_floor': -92.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.2,
                                             'ul_snr': 20.9},
                '20:b5:c6:13:0d:d2': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.101.5.22',
                                             'mac_address': '20:b5:c6:13:0d:d2',
                                             'name': 'Ball Field',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -89.69999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.8,
                                             'ul_snr': 28.9}
        }
        exp_ne_msg = {
                'data': {       'elevation': 13.5,
                                'gps_sats_tracked': 7,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '2924546',
                                                              'in_errors': '5',
                                                              'in_nucast_pkts': '10107212',
                                                              'in_octets': '3123635787',
                                                              'in_ucast_pkts': '345813265',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:07:b6:fc',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1305089',
                                                              'out_octets': '988588095',
                                                              'out_ucast_pkts': '273953206',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2463811624',
                                                              'in_ucast_pkts': '309485676',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '20:b5:c6:13:0d:d2'},
                                                                               {       'mac_address': '20:b5:c6:06:ab:57'},
                                                                               {       'mac_address': '20:b5:c6:11:42:18'},
                                                                               {       'mac_address': '20:b5:c6:06:a2:1a'},
                                                                               {       'mac_address': '20:b5:c6:10:5d:60'},
                                                                               {       'mac_address': '20:b5:c6:10:52:09'}],
                                                              'mac_address': '20:b5:c6:07:b6:ec',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1958427979',
                                                              'out_ucast_pkts': '415380079',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 8000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 6165,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2958699',
                                                                                                                                            'mac_address': '20:b5:c6:13:0d:d2',
                                                                                                                                            'noise_floor': -89.7,
                                                                                                                                            'rssi': -60.8,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 28.9,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2958712',
                                                                                                                                            'mac_address': '20:b5:c6:06:ab:57',
                                                                                                                                            'noise_floor': -83.5,
                                                                                                                                            'rssi': -53.4,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2958704',
                                                                                                                                            'mac_address': '20:b5:c6:11:42:18',
                                                                                                                                            'noise_floor': -92.1,
                                                                                                                                            'rssi': -71.2,
                                                                                                                                            'rx_link_rate': '67500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 20.9,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '20465',
                                                                                                                                            'mac_address': '20:b5:c6:06:a2:1a',
                                                                                                                                            'noise_floor': -81.9,
                                                                                                                                            'rssi': -52.5,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 29.4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2958710',
                                                                                                                                            'mac_address': '20:b5:c6:10:5d:60',
                                                                                                                                            'noise_floor': -90.3,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 29.3,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2958699',
                                                                                                                                            'mac_address': '20:b5:c6:10:52:09',
                                                                                                                                            'noise_floor': -88.9,
                                                                                                                                            'rssi': -61.3,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 27.6,
                                                                                                                                            'tx_link_rate': '150000000',
                                                                                                                                            'tx_mcs': 7}]}],
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BW.1111'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 24.56399,
                                'longitude': -81.7681,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGB7bs',
                                'serial_number': '2014741869',
                                'sw_version': '2.5.0',
                                'system_mac_address': '20:b5:c6:07:b6:fc',
                                'temperature': 48.0,
                                'uptime': '1561822'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:13:0d:d2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2958699',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhMN'}],
                                         'management_ip': '10.101.5.22',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Ball Field',
                                         'poller_hash': 'ILXGEw3S',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:06:ab:57',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2958712',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgar'}],
                                         'management_ip': '10.101.5.33',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Key Plaza Creperie',
                                         'poller_hash': 'ILXGBqtX',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:11:42:18',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2958704',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'tx_link_rate': '67500000'}]}],
                                                                                                 'tx_link_rate': '67500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhFC'}],
                                         'management_ip': '10.101.5.53',
                                         'manufacturer': 'Mimosa',
                                         'name': 'DR Scooters',
                                         'poller_hash': 'ILXGEUIY',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:06:a2:1a',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '20465',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgai'}],
                                         'management_ip': '10.101.5.3',
                                         'manufacturer': 'Mimosa',
                                         'name': '1010 Kennedy',
                                         'poller_hash': 'ILXGBqIa',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:10:5d:60',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2958710',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhBd'}],
                                         'management_ip': '10.101.5.128',
                                         'manufacturer': 'Mimosa',
                                         'name': 'KW_Spine_And_Injury',
                                         'poller_hash': 'ILXGEF1g',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:07:b6:ec'}],
                                                                       'mac_address': '20:b5:c6:10:52:09',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 6165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '150000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2958699',
                                                                                                                                                     'mac_address': '20:b5:c6:07:b6:ec',
                                                                                                                                                     'rx_link_rate': '150000000',
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BW.1111'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhBS'}],
                                         'management_ip': '10.101.5.23',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Wesley- Poinciana_Mcarthy',
                                         'poller_hash': 'ILXGEFIJ',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_14_2_5_1_01(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.1.01")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 40,
                'rf_freq': 5800,
                'rf_tx_power': 24,
                'sta_count': 10,
                'sw_version': '2.5.1',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 2658964421,
                'dl_rf_packets': 46157337,
                'temperature': 44.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1592618629,
                'ul_rf_packets': 17628881
        }
        exp_sta_stats = {
                '20:b5:c6:00:f8:ac': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 240000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:00:f8:ac',
                                             'name': 'Mimi_ToddC5',
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -83.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.6,
                                             'ul_snr': 26.4},
                '20:b5:c6:05:70:f4': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:05:70:f4',
                                             'name': 'HoustonSmith',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -75.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -45.7,
                                             'ul_snr': 30.2},
                '20:b5:c6:05:f8:c1': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.10.16',
                                             'mac_address': '20:b5:c6:05:f8:c1',
                                             'name': 'denise_harris',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -66.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -35.2,
                                             'ul_snr': 31.2},
                '20:b5:c6:05:ff:12': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:05:ff:12',
                                             'name': 'Cody_Vazquez',
                                             'temperature': None,
                                             'ul_link_rate': 360000000,
                                             'ul_noise_floor': -82.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -50.6,
                                             'ul_snr': 31.5},
                '20:b5:c6:06:19:fc': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.10.31',
                                             'mac_address': '20:b5:c6:06:19:fc',
                                             'name': 'Jonathan_Surgeon_Unit21',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -77.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -45.6,
                                             'ul_snr': 31.4},
                '20:b5:c6:07:04:d8': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.10.42',
                                             'mac_address': '20:b5:c6:07:04:d8',
                                             'name': 'Ryan_Storm',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -70.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -39.2,
                                             'ul_snr': 31.6},
                '20:b5:c6:07:06:6f': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:07:06:6f',
                                             'name': 'JamesBurrus',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -73.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.2,
                                             'ul_snr': 31.3},
                '20:b5:c6:10:f7:62': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:10:f7:62',
                                             'name': 'Doug_Holloway',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -70.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -39.5,
                                             'ul_snr': 31.3},
                '20:b5:c6:19:52:f9': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:19:52:f9',
                                             'name': 'Richard_Nelson',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -82.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51.8,
                                             'ul_snr': 30.8},
                '20:b5:c6:1a:ac:ae': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': '20:b5:c6:1a:ac:ae',
                                             'name': 'Hannah_Cook',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -66.30000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -33.2,
                                             'ul_snr': 33.1}
        }
        exp_ne_msg = {
                'data': {       'elevation': 258.89,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '20738',
                                                              'in_errors': '401',
                                                              'in_nucast_pkts': '1089006',
                                                              'in_octets': '377525318',
                                                              'in_ucast_pkts': '35129258',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:06:c7:c4',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '86026',
                                                              'out_octets': '1562935828',
                                                              'out_ucast_pkts': '17153431',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '2788',
                                                              'in_octets': '1592618629',
                                                              'in_ucast_pkts': '17626093',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '20:b5:c6:06:19:fc'},
                                                                               {       'mac_address': '20:b5:c6:1a:ac:ae'},
                                                                               {       'mac_address': '20:b5:c6:00:f8:ac'},
                                                                               {       'mac_address': '20:b5:c6:05:f8:c1'},
                                                                               {       'mac_address': '20:b5:c6:05:70:f4'},
                                                                               {       'mac_address': '20:b5:c6:07:06:6f'},
                                                                               {       'mac_address': '20:b5:c6:10:f7:62'},
                                                                               {       'mac_address': '20:b5:c6:19:52:f9'},
                                                                               {       'mac_address': '20:b5:c6:05:ff:12'},
                                                                               {       'mac_address': '20:b5:c6:07:04:d8'}],
                                                              'mac_address': '20:b5:c6:06:c7:b4',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2658964421',
                                                              'out_ucast_pkts': '46157337',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5800,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:06:19:fc',
                                                                                                                                            'noise_floor': -77.0,
                                                                                                                                            'rssi': -45.6,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:1a:ac:ae',
                                                                                                                                            'noise_floor': -66.3,
                                                                                                                                            'rssi': -33.2,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 33.1,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:00:f8:ac',
                                                                                                                                            'noise_floor': -83.0,
                                                                                                                                            'rssi': -56.6,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 26.4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '30917',
                                                                                                                                            'mac_address': '20:b5:c6:05:f8:c1',
                                                                                                                                            'noise_floor': -66.4,
                                                                                                                                            'rssi': -35.2,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.2,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30938',
                                                                                                                                            'mac_address': '20:b5:c6:05:70:f4',
                                                                                                                                            'noise_floor': -75.9,
                                                                                                                                            'rssi': -45.7,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 30.2,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30938',
                                                                                                                                            'mac_address': '20:b5:c6:07:06:6f',
                                                                                                                                            'noise_floor': -73.5,
                                                                                                                                            'rssi': -42.2,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.3,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:10:f7:62',
                                                                                                                                            'noise_floor': -70.8,
                                                                                                                                            'rssi': -39.5,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.3,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:19:52:f9',
                                                                                                                                            'noise_floor': -82.6,
                                                                                                                                            'rssi': -51.8,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 30.8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30938',
                                                                                                                                            'mac_address': '20:b5:c6:05:ff:12',
                                                                                                                                            'noise_floor': -82.1,
                                                                                                                                            'rssi': -50.6,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 31.5,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '30857',
                                                                                                                                            'mac_address': '20:b5:c6:07:04:d8',
                                                                                                                                            'noise_floor': -70.8,
                                                                                                                                            'rssi': -39.2,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.6,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TaneynetAp_5GhzDeerrun'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 36.60886,
                                'longitude': -93.10404,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGBse0',
                                'serial_number': '2018437350',
                                'sw_version': '2.5.1',
                                'system_mac_address': '20:b5:c6:06:c7:c4',
                                'temperature': 44.0,
                                'uptime': '45569'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:06:19:fc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYZ'}],
                                         'management_ip': '10.10.10.31',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Jonathan_Surgeon_Unit21',
                                         'poller_hash': 'ILXGBhn8',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:1a:ac:ae',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhqs'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Hannah_Cook',
                                         'poller_hash': 'ILXGGqyu',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:00:f8:ac',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgD4'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Mimi_ToddC5',
                                         'poller_hash': 'ILXGAPis',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.1'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:05:f8:c1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30917',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgX4'}],
                                         'management_ip': '10.10.10.16',
                                         'manufacturer': 'Mimosa',
                                         'name': 'denise_harris',
                                         'poller_hash': 'ILXGBfjB',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:05:70:f4',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30938',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgVw'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'HoustonSmith',
                                         'poller_hash': 'ILXGBXD0',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.4.1'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:07:06:6f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30938',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgcG'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'JamesBurrus',
                                         'poller_hash': 'ILXGBwZv',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.4.1'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:10:f7:62',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhD3'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Doug_Holloway',
                                         'poller_hash': 'ILXGEPdi',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.1'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:19:52:f9',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhlS'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Richard_Nelson',
                                         'poller_hash': 'ILXGGVL5',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:05:ff:12',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30938',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '360000000'}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgX/'}],
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Cody_Vazquez',
                                         'poller_hash': 'ILXGBf8S',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.4.1'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:c7:b4'}],
                                                                       'mac_address': '20:b5:c6:07:04:d8',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '30857',
                                                                                                                                                     'mac_address': '20:b5:c6:06:c7:b4',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TaneynetAp_5GhzDeerrun'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgcE'}],
                                         'management_ip': '10.10.10.42',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Ryan_Storm',
                                         'poller_hash': 'ILXGBwTY',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_14_2_5_2_01(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.2.01")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 40,
                'rf_freq': 5685,
                'rf_tx_power': 18,
                'sta_count': 16,
                'sw_version': '2.5.2',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 2983233210,
                'dl_rf_packets': 648792143,
                'temperature': 36.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 372098153,
                'ul_rf_packets': 494538019
        }
        exp_sta_stats = {
                '20:b5:c6:05:38:35': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.1.233',
                                             'mac_address': '20:b5:c6:05:38:35',
                                             'name': 'Christopher_Winking',
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -81.69999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.1,
                                             'ul_snr': 12.6},
                '20:b5:c6:05:71:84': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.77',
                                             'mac_address': '20:b5:c6:05:71:84',
                                             'name': 'BillShafer',
                                             'temperature': None,
                                             'ul_link_rate': 45000000,
                                             'ul_noise_floor': -83.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.4,
                                             'ul_snr': 13.1},
                '20:b5:c6:05:71:93': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 87000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.197',
                                             'mac_address': '20:b5:c6:05:71:93',
                                             'name': 'Gary_Oney_C5',
                                             'temperature': None,
                                             'ul_link_rate': 29000000,
                                             'ul_noise_floor': -85.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -72.2,
                                             'ul_snr': 12.8},
                '20:b5:c6:05:75:38': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.51',
                                             'mac_address': '20:b5:c6:05:75:38',
                                             'name': 'ChristaMcNett',
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -84.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.3,
                                             'ul_snr': 14.7},
                '20:b5:c6:05:77:ab': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.177',
                                             'mac_address': '20:b5:c6:05:77:ab',
                                             'name': 'HeatherOsagiede',
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -85.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.4,
                                             'ul_snr': 15.8},
                '20:b5:c6:05:7d:63': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.144',
                                             'mac_address': '20:b5:c6:05:7d:63',
                                             'name': 'SteveBeaumont',
                                             'temperature': None,
                                             'ul_link_rate': 135000000,
                                             'ul_noise_floor': -85.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.1,
                                             'ul_snr': 21.4},
                '20:b5:c6:05:81:00': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 120000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.105',
                                             'mac_address': '20:b5:c6:05:81:00',
                                             'name': 'WesternStation9',
                                             'temperature': None,
                                             'ul_link_rate': 45000000,
                                             'ul_noise_floor': -86.39999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -76.8,
                                             'ul_snr': 9.6},
                '20:b5:c6:05:9d:c4': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '20:b5:c6:05:9d:c4',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 7000000,
                                             'ul_noise_floor': -86.39999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -83.6,
                                             'ul_snr': 2.8},
                '20:b5:c6:05:fa:05': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.163',
                                             'mac_address': '20:b5:c6:05:fa:05',
                                             'name': 'Gerald_Oney_C5',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -87.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65.7,
                                             'ul_snr': 22.1},
                '20:b5:c6:05:fe:e2': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.183',
                                             'mac_address': '20:b5:c6:05:fe:e2',
                                             'name': 'Chris_McPeakC5',
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -82.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 20.2},
                '20:b5:c6:06:0f:28': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.235',
                                             'mac_address': '20:b5:c6:06:0f:28',
                                             'name': 'JayEgizio',
                                             'temperature': None,
                                             'ul_link_rate': 30000000,
                                             'ul_noise_floor': -84.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -76.7,
                                             'ul_snr': 8.1},
                '20:b5:c6:06:12:bb': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 150000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.241',
                                             'mac_address': '20:b5:c6:06:12:bb',
                                             'name': 'Fred_HowardC5',
                                             'temperature': None,
                                             'ul_link_rate': 45000000,
                                             'ul_noise_floor': -84.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -77.5,
                                             'ul_snr': 7.3},
                '20:b5:c6:06:30:4d': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 240000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.234',
                                             'mac_address': '20:b5:c6:06:30:4d',
                                             'name': 'NickSchafer',
                                             'temperature': None,
                                             'ul_link_rate': 29000000,
                                             'ul_noise_floor': -83.89999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -73.1,
                                             'ul_snr': 10.8},
                '20:b5:c6:06:b4:30': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.252',
                                             'mac_address': '20:b5:c6:06:b4:30',
                                             'name': 'EricCrooks',
                                             'temperature': None,
                                             'ul_link_rate': 7000000,
                                             'ul_noise_floor': -85.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -79.4,
                                             'ul_snr': 5.8},
                '20:b5:c6:07:18:82': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.236',
                                             'mac_address': '20:b5:c6:07:18:82',
                                             'name': 'ShannonKing',
                                             'temperature': None,
                                             'ul_link_rate': 45000000,
                                             'ul_noise_floor': -81.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.7,
                                             'ul_snr': 12.1},
                '20:b5:c6:13:0e:71': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.199.0.32',
                                             'mac_address': '20:b5:c6:13:0e:71',
                                             'name': 'Amy_Sandrik',
                                             'temperature': None,
                                             'ul_link_rate': 7000000,
                                             'ul_noise_floor': -79.19999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -75.6,
                                             'ul_snr': 3.6}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1069321509',
                                                              'in_errors': '762',
                                                              'in_nucast_pkts': '2650980',
                                                              'in_octets': '4023637373',
                                                              'in_ucast_pkts': '1670957466',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:0c:e6:54',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '43153',
                                                              'out_octets': '4125154469',
                                                              'out_ucast_pkts': '482488594',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '177',
                                                              'in_nucast_pkts': '29575',
                                                              'in_octets': '372098153',
                                                              'in_ucast_pkts': '494508444',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '20:b5:c6:05:9d:c4'},
                                                                               {       'mac_address': '20:b5:c6:05:75:38'},
                                                                               {       'mac_address': '20:b5:c6:13:0e:71'},
                                                                               {       'mac_address': '20:b5:c6:05:71:84'},
                                                                               {       'mac_address': '20:b5:c6:05:81:00'},
                                                                               {       'mac_address': '20:b5:c6:05:71:93'},
                                                                               {       'mac_address': '20:b5:c6:05:fe:e2'},
                                                                               {       'mac_address': '20:b5:c6:05:fa:05'},
                                                                               {       'mac_address': '20:b5:c6:05:77:ab'},
                                                                               {       'mac_address': '20:b5:c6:06:30:4d'},
                                                                               {       'mac_address': '20:b5:c6:07:18:82'},
                                                                               {       'mac_address': '20:b5:c6:05:7d:63'},
                                                                               {       'mac_address': '20:b5:c6:06:b4:30'},
                                                                               {       'mac_address': '20:b5:c6:05:38:35'},
                                                                               {       'mac_address': '20:b5:c6:06:0f:28'},
                                                                               {       'mac_address': '20:b5:c6:06:12:bb'}],
                                                              'mac_address': '20:b5:c6:0c:e6:44',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '28416',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2983233210',
                                                              'out_ucast_pkts': '648792143',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5685,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '340',
                                                                                                                                            'mac_address': '20:b5:c6:05:9d:c4',
                                                                                                                                            'noise_floor': -86.4,
                                                                                                                                            'rssi': -83.6,
                                                                                                                                            'rx_link_rate': '7000000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'snr': 2.8,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:05:75:38',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -69.3,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 14.7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:13:0e:71',
                                                                                                                                            'noise_floor': -79.2,
                                                                                                                                            'rssi': -75.6,
                                                                                                                                            'rx_link_rate': '7000000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'snr': 3.6,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '76808',
                                                                                                                                            'mac_address': '20:b5:c6:05:71:84',
                                                                                                                                            'noise_floor': -83.5,
                                                                                                                                            'rssi': -70.4,
                                                                                                                                            'rx_link_rate': '45000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 13.1,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '76699',
                                                                                                                                            'mac_address': '20:b5:c6:05:81:00',
                                                                                                                                            'noise_floor': -86.4,
                                                                                                                                            'rssi': -76.8,
                                                                                                                                            'rx_link_rate': '45000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 9.6,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '427',
                                                                                                                                            'mac_address': '20:b5:c6:05:71:93',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -72.2,
                                                                                                                                            'rx_link_rate': '29000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 12.8,
                                                                                                                                            'tx_link_rate': '87000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '76808',
                                                                                                                                            'mac_address': '20:b5:c6:05:fe:e2',
                                                                                                                                            'noise_floor': -82.2,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 20.2,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:05:fa:05',
                                                                                                                                            'noise_floor': -87.8,
                                                                                                                                            'rssi': -65.7,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 22.1,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:05:77:ab',
                                                                                                                                            'noise_floor': -85.2,
                                                                                                                                            'rssi': -69.4,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 15.8,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:06:30:4d',
                                                                                                                                            'noise_floor': -83.9,
                                                                                                                                            'rssi': -73.1,
                                                                                                                                            'rx_link_rate': '29000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 10.8,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '33402',
                                                                                                                                            'mac_address': '20:b5:c6:07:18:82',
                                                                                                                                            'noise_floor': -81.8,
                                                                                                                                            'rssi': -69.7,
                                                                                                                                            'rx_link_rate': '45000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 12.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '76808',
                                                                                                                                            'mac_address': '20:b5:c6:05:7d:63',
                                                                                                                                            'noise_floor': -85.5,
                                                                                                                                            'rssi': -64.1,
                                                                                                                                            'rx_link_rate': '135000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 21.4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '76370',
                                                                                                                                            'mac_address': '20:b5:c6:06:b4:30',
                                                                                                                                            'noise_floor': -85.2,
                                                                                                                                            'rssi': -79.4,
                                                                                                                                            'rx_link_rate': '7000000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'snr': 5.8,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '67635',
                                                                                                                                            'mac_address': '20:b5:c6:05:38:35',
                                                                                                                                            'noise_floor': -81.7,
                                                                                                                                            'rssi': -69.1,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 12.6,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '1863',
                                                                                                                                            'mac_address': '20:b5:c6:06:0f:28',
                                                                                                                                            'noise_floor': -84.8,
                                                                                                                                            'rssi': -76.7,
                                                                                                                                            'rx_link_rate': '30000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 8.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '76753',
                                                                                                                                            'mac_address': '20:b5:c6:06:12:bb',
                                                                                                                                            'noise_floor': -84.8,
                                                                                                                                            'rssi': -77.5,
                                                                                                                                            'rx_link_rate': '45000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 7.3,
                                                                                                                                            'tx_link_rate': '150000000',
                                                                                                                                            'tx_mcs': 7}]}],
                                                                                        'tx_power': 18}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Taneynet_AP360_BriggsRd'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGDOZE',
                                'serial_number': '2013917245',
                                'sw_version': '2.5.2',
                                'system_mac_address': '20:b5:c6:0c:e6:54',
                                'temperature': 36.0,
                                'uptime': '460265'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:9d:c4',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '340',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '7000000'}]}],
                                                                                                 'tx_link_rate': '7000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgWd'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'ILXGBZ3E',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'N/A'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:75:38',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgV1'}],
                                         'management_ip': '10.199.0.51',
                                         'manufacturer': 'Mimosa',
                                         'name': 'ChristaMcNett',
                                         'poller_hash': 'ILXGBXU4',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:13:0e:71',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '7000000'}]}],
                                                                                                 'tx_link_rate': '7000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhMO'}],
                                         'management_ip': '10.199.0.32',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Amy_Sandrik',
                                         'poller_hash': 'ILXGEw5x',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:71:84',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76808',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '45000000'}]}],
                                                                                                 'tx_link_rate': '45000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgVx'}],
                                         'management_ip': '10.199.0.77',
                                         'manufacturer': 'Mimosa',
                                         'name': 'BillShafer',
                                         'poller_hash': 'ILXGBXGE',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:81:00',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76699',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'tx_link_rate': '45000000'}]}],
                                                                                                 'tx_link_rate': '45000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgWB'}],
                                         'management_ip': '10.199.0.105',
                                         'manufacturer': 'Mimosa',
                                         'name': 'WesternStation9',
                                         'poller_hash': 'ILXGBYEA',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:71:93',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '427',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '87000000',
                                                                                                                                                     'tx_link_rate': '29000000'}]}],
                                                                                                 'tx_link_rate': '29000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgVx'}],
                                         'management_ip': '10.199.0.197',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Gary_Oney_C5',
                                         'poller_hash': 'ILXGBXGT',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:fe:e2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76808',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgX+'}],
                                         'management_ip': '10.199.0.183',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Chris_McPeakC5',
                                         'poller_hash': 'ILXGBf7i',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:fa:05',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgX6'}],
                                         'management_ip': '10.199.0.163',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Gerald_Oney_C5',
                                         'poller_hash': 'ILXGBfoF',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:77:ab',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgV3'}],
                                         'management_ip': '10.199.0.177',
                                         'manufacturer': 'Mimosa',
                                         'name': 'HeatherOsagiede',
                                         'poller_hash': 'ILXGBXer',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:06:30:4d',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'tx_link_rate': '29000000'}]}],
                                                                                                 'tx_link_rate': '29000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYw'}],
                                         'management_ip': '10.199.0.234',
                                         'manufacturer': 'Mimosa',
                                         'name': 'NickSchafer',
                                         'poller_hash': 'ILXGBjBN',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:07:18:82',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33402',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '45000000'}]}],
                                                                                                 'tx_link_rate': '45000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgcY'}],
                                         'management_ip': '10.199.0.236',
                                         'manufacturer': 'Mimosa',
                                         'name': 'ShannonKing',
                                         'poller_hash': 'ILXGBxiC',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:7d:63',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76808',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '135000000'}]}],
                                                                                                 'tx_link_rate': '135000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgV9'}],
                                         'management_ip': '10.199.0.144',
                                         'manufacturer': 'Mimosa',
                                         'name': 'SteveBeaumont',
                                         'poller_hash': 'ILXGBX1j',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:06:b4:30',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76370',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'tx_link_rate': '7000000'}]}],
                                                                                                 'tx_link_rate': '7000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xga0'}],
                                         'management_ip': '10.199.0.252',
                                         'manufacturer': 'Mimosa',
                                         'name': 'EricCrooks',
                                         'poller_hash': 'ILXGBrQw',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:05:38:35',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '67635',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgU4'}],
                                         'management_ip': '10.199.1.233',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Christopher_Winking',
                                         'poller_hash': 'ILXGBTg1',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:06:0f:28',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1863',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '30000000'}]}],
                                                                                                 'tx_link_rate': '30000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYP'}],
                                         'management_ip': '10.199.0.235',
                                         'manufacturer': 'Mimosa',
                                         'name': 'JayEgizio',
                                         'poller_hash': 'ILXGBg8o',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:0c:e6:44'}],
                                                                       'mac_address': '20:b5:c6:06:12:bb',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5685,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '150000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '76753',
                                                                                                                                                     'mac_address': '20:b5:c6:0c:e6:44',
                                                                                                                                                     'rx_link_rate': '150000000',
                                                                                                                                                     'tx_link_rate': '45000000'}]}],
                                                                                                 'tx_link_rate': '45000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Taneynet_AP360_BriggsRd'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYS'}],
                                         'management_ip': '10.199.0.241',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Fred_HowardC5',
                                         'poller_hash': 'ILXGBhK7',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_14_2_5_2_02(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.2.02")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 80,
                'rf_freq': 5310,
                'rf_tx_power': 18,
                'sta_count': 13,
                'sw_version': '2.5.2',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 1726665369,
                'dl_rf_packets': 3481720019,
                'temperature': 20.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 4211679133,
                'ul_rf_packets': 316975208
        }
        exp_sta_stats = {
                '20:b5:c6:01:b4:d0': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 433500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.41',
                                             'mac_address': '20:b5:c6:01:b4:d0',
                                             'name': 'Curtis Nelson',
                                             'temperature': None,
                                             'ul_link_rate': 325000000,
                                             'ul_noise_floor': -69.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.8,
                                             'ul_snr': 27.1},
                '20:b5:c6:05:1c:fa': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 325000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.93',
                                             'mac_address': '20:b5:c6:05:1c:fa',
                                             'name': 'Scott and Jane Wachter',
                                             'temperature': None,
                                             'ul_link_rate': 325000000,
                                             'ul_noise_floor': -75.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -48.4,
                                             'ul_snr': 26.9},
                '20:b5:c6:05:1e:14': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 260000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.55',
                                             'mac_address': '20:b5:c6:05:1e:14',
                                             'name': 'Lana Lammers',
                                             'temperature': None,
                                             'ul_link_rate': 325000000,
                                             'ul_noise_floor': -75.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.6,
                                             'ul_snr': 28.8},
                '20:b5:c6:05:39:49': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 195000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.99',
                                             'mac_address': '20:b5:c6:05:39:49',
                                             'name': 'Kevin Psota',
                                             'temperature': None,
                                             'ul_link_rate': 292500000,
                                             'ul_noise_floor': -72.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.6,
                                             'ul_snr': 27.7},
                '20:b5:c6:05:39:79': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.89',
                                             'mac_address': '20:b5:c6:05:39:79',
                                             'name': 'Sarah Birkby',
                                             'temperature': None,
                                             'ul_link_rate': 16500000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.8,
                                             'ul_snr': None},
                '20:b5:c6:05:39:eb': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 390000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.109',
                                             'mac_address': '20:b5:c6:05:39:eb',
                                             'name': 'Michelle and Ross Epley',
                                             'temperature': None,
                                             'ul_link_rate': 390000000,
                                             'ul_noise_floor': -73.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.1,
                                             'ul_snr': 29.8},
                '20:b5:c6:05:3b:23': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 390000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.91',
                                             'mac_address': '20:b5:c6:05:3b:23',
                                             'name': 'Larry Heathers',
                                             'temperature': None,
                                             'ul_link_rate': 390000000,
                                             'ul_noise_floor': -79.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -50.8,
                                             'ul_snr': 28.7},
                '20:b5:c6:05:6c:d4': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 16500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.29',
                                             'mac_address': '20:b5:c6:05:6c:d4',
                                             'name': 'Sarah Peters',
                                             'temperature': None,
                                             'ul_link_rate': 292500000,
                                             'ul_noise_floor': -79.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.4,
                                             'ul_snr': 27.5},
                '20:b5:c6:05:7e:da': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 390000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.25',
                                             'mac_address': '20:b5:c6:05:7e:da',
                                             'name': 'Jessica Johnson',
                                             'temperature': None,
                                             'ul_link_rate': 433500000,
                                             'ul_noise_floor': -73.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.0,
                                             'ul_snr': 29.7},
                '20:b5:c6:06:4c:39': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 325000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.23',
                                             'mac_address': '20:b5:c6:06:4c:39',
                                             'name': 'Oswald Evans',
                                             'temperature': None,
                                             'ul_link_rate': 292500000,
                                             'ul_noise_floor': -82.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55.9,
                                             'ul_snr': 26.5},
                '20:b5:c6:06:92:05': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 325000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.47',
                                             'mac_address': '20:b5:c6:06:92:05',
                                             'name': 'Dennis Crowell',
                                             'temperature': None,
                                             'ul_link_rate': 292500000,
                                             'ul_noise_floor': -65.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -38.3,
                                             'ul_snr': 26.7},
                '20:b5:c6:07:c1:29': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 325000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.137',
                                             'mac_address': '20:b5:c6:07:c1:29',
                                             'name': 'Travis Mieth',
                                             'temperature': None,
                                             'ul_link_rate': 325000000,
                                             'ul_noise_floor': -69.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -41.7,
                                             'ul_snr': 27.4},
                '20:b5:c6:1a:a5:37': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 292500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.5.19',
                                             'mac_address': '20:b5:c6:1a:a5:37',
                                             'name': 'Jon Timmerman',
                                             'temperature': None,
                                             'ul_link_rate': 260000000,
                                             'ul_noise_floor': -76.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.7,
                                             'ul_snr': 26.3}
        }
        exp_ne_msg = {
                'data': {       'elevation': 628.29,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '15144882',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '129923926',
                                                              'in_octets': '3460944162',
                                                              'in_ucast_pkts': '1594638982',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:04:f4:44',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '17705994',
                                                              'out_octets': '3846360182',
                                                              'out_ucast_pkts': '3835195529',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '38',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4211679133',
                                                              'in_ucast_pkts': '316975208',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '20:b5:c6:05:39:79'},
                                                                               {       'mac_address': '20:b5:c6:05:1c:fa'},
                                                                               {       'mac_address': '20:b5:c6:06:4c:39'},
                                                                               {       'mac_address': '20:b5:c6:1a:a5:37'},
                                                                               {       'mac_address': '20:b5:c6:07:c1:29'},
                                                                               {       'mac_address': '20:b5:c6:05:39:49'},
                                                                               {       'mac_address': '20:b5:c6:05:39:eb'},
                                                                               {       'mac_address': '20:b5:c6:05:3b:23'},
                                                                               {       'mac_address': '20:b5:c6:05:1e:14'},
                                                                               {       'mac_address': '20:b5:c6:01:b4:d0'},
                                                                               {       'mac_address': '20:b5:c6:05:6c:d4'},
                                                                               {       'mac_address': '20:b5:c6:06:92:05'},
                                                                               {       'mac_address': '20:b5:c6:05:7e:da'}],
                                                              'mac_address': '20:b5:c6:04:f4:34',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '6',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1726665369',
                                                              'out_ucast_pkts': '3481720019',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 8000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5310,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1149957',
                                                                                                                                            'mac_address': '20:b5:c6:05:39:79',
                                                                                                                                            'rssi': -69.8,
                                                                                                                                            'rx_link_rate': '16500000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'tx_link_rate': '7500000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'connected_time': '3878256',
                                                                                                                                            'mac_address': '20:b5:c6:05:1c:fa',
                                                                                                                                            'noise_floor': -75.3,
                                                                                                                                            'rssi': -48.4,
                                                                                                                                            'rx_link_rate': '325000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 26.9,
                                                                                                                                            'tx_link_rate': '325000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3878257',
                                                                                                                                            'mac_address': '20:b5:c6:06:4c:39',
                                                                                                                                            'noise_floor': -82.4,
                                                                                                                                            'rssi': -55.9,
                                                                                                                                            'rx_link_rate': '292500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 26.5,
                                                                                                                                            'tx_link_rate': '325000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '2381331',
                                                                                                                                            'mac_address': '20:b5:c6:1a:a5:37',
                                                                                                                                            'noise_floor': -76.0,
                                                                                                                                            'rssi': -49.7,
                                                                                                                                            'rx_link_rate': '260000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 26.3,
                                                                                                                                            'tx_link_rate': '292500000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '2521013',
                                                                                                                                            'mac_address': '20:b5:c6:07:c1:29',
                                                                                                                                            'noise_floor': -69.1,
                                                                                                                                            'rssi': -41.7,
                                                                                                                                            'rx_link_rate': '325000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 27.4,
                                                                                                                                            'tx_link_rate': '325000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3878251',
                                                                                                                                            'mac_address': '20:b5:c6:05:39:49',
                                                                                                                                            'noise_floor': -72.3,
                                                                                                                                            'rssi': -44.6,
                                                                                                                                            'rx_link_rate': '292500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 27.7,
                                                                                                                                            'tx_link_rate': '195000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '95324',
                                                                                                                                            'mac_address': '20:b5:c6:05:39:eb',
                                                                                                                                            'noise_floor': -73.9,
                                                                                                                                            'rssi': -44.1,
                                                                                                                                            'rx_link_rate': '390000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 29.8,
                                                                                                                                            'tx_link_rate': '390000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '3878253',
                                                                                                                                            'mac_address': '20:b5:c6:05:3b:23',
                                                                                                                                            'noise_floor': -79.5,
                                                                                                                                            'rssi': -50.8,
                                                                                                                                            'rx_link_rate': '390000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 28.7,
                                                                                                                                            'tx_link_rate': '390000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '3878254',
                                                                                                                                            'mac_address': '20:b5:c6:05:1e:14',
                                                                                                                                            'noise_floor': -75.4,
                                                                                                                                            'rssi': -46.6,
                                                                                                                                            'rx_link_rate': '325000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 28.8,
                                                                                                                                            'tx_link_rate': '260000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '3878255',
                                                                                                                                            'mac_address': '20:b5:c6:01:b4:d0',
                                                                                                                                            'noise_floor': -69.9,
                                                                                                                                            'rssi': -42.8,
                                                                                                                                            'rx_link_rate': '325000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 27.1,
                                                                                                                                            'tx_link_rate': '433500000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '174360',
                                                                                                                                            'mac_address': '20:b5:c6:05:6c:d4',
                                                                                                                                            'noise_floor': -79.9,
                                                                                                                                            'rssi': -52.4,
                                                                                                                                            'rx_link_rate': '292500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 27.5,
                                                                                                                                            'tx_link_rate': '16500000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'connected_time': '3878253',
                                                                                                                                            'mac_address': '20:b5:c6:06:92:05',
                                                                                                                                            'noise_floor': -65.0,
                                                                                                                                            'rssi': -38.3,
                                                                                                                                            'rx_link_rate': '292500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 26.7,
                                                                                                                                            'tx_link_rate': '325000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '879022',
                                                                                                                                            'mac_address': '20:b5:c6:05:7e:da',
                                                                                                                                            'noise_floor': -73.7,
                                                                                                                                            'rssi': -44.0,
                                                                                                                                            'rx_link_rate': '433500000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 29.7,
                                                                                                                                            'tx_link_rate': '390000000',
                                                                                                                                            'tx_mcs': 8}]}],
                                                                                        'tx_power': 18}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '5-D'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 41.02555,
                                'longitude': -98.91602,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGBPQ0',
                                'serial_number': '2017610774',
                                'sw_version': '2.5.2',
                                'system_mac_address': '20:b5:c6:04:f4:44',
                                'temperature': 20.0,
                                'uptime': '20433061'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:39:79',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1149957',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '7500000',
                                                                                                                                                     'tx_link_rate': '16500000'}]}],
                                                                                                 'tx_link_rate': '16500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgU5'}],
                                         'management_ip': '192.168.5.89',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Sarah Birkby',
                                         'poller_hash': 'ILXGBTl5',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:1c:fa',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '325000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878256',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '325000000',
                                                                                                                                                     'tx_link_rate': '325000000'}]}],
                                                                                                 'tx_link_rate': '325000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgUc'}],
                                         'management_ip': '192.168.5.93',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Scott and Jane Wachter',
                                         'poller_hash': 'ILXGBRz6',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:06:4c:39',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '325000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878257',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '325000000',
                                                                                                                                                     'tx_link_rate': '292500000'}]}],
                                                                                                 'tx_link_rate': '292500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgZM'}],
                                         'management_ip': '192.168.5.23',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Oswald Evans',
                                         'poller_hash': 'ILXGBkw5',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:1a:a5:37',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '292500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2381331',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '292500000',
                                                                                                                                                     'tx_link_rate': '260000000'}]}],
                                                                                                 'tx_link_rate': '260000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhql'}],
                                         'management_ip': '192.168.5.19',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Jon Timmerman',
                                         'poller_hash': 'ILXGGqU3',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:07:c1:29',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '325000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2521013',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '325000000',
                                                                                                                                                     'tx_link_rate': '325000000'}]}],
                                                                                                 'tx_link_rate': '325000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgfB'}],
                                         'management_ip': '192.168.5.137',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Travis Mieth',
                                         'poller_hash': 'ILXGB8Ep',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:39:49',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '195000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878251',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '195000000',
                                                                                                                                                     'tx_link_rate': '292500000'}]}],
                                                                                                 'tx_link_rate': '292500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgU5'}],
                                         'management_ip': '192.168.5.99',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Kevin Psota',
                                         'poller_hash': 'ILXGBTlJ',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:39:eb',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '390000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '95324',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '390000000',
                                                                                                                                                     'tx_link_rate': '390000000'}]}],
                                                                                                 'tx_link_rate': '390000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgU5'}],
                                         'management_ip': '192.168.5.109',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Michelle and Ross Epley',
                                         'poller_hash': 'ILXGBTnr',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:3b:23',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '390000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878253',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '390000000',
                                                                                                                                                     'tx_link_rate': '390000000'}]}],
                                                                                                 'tx_link_rate': '390000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgU7'}],
                                         'management_ip': '192.168.5.91',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Larry Heathers',
                                         'poller_hash': 'ILXGBTsj',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:1e:14',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '260000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878254',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '260000000',
                                                                                                                                                     'tx_link_rate': '325000000'}]}],
                                                                                                 'tx_link_rate': '325000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgUe'}],
                                         'management_ip': '192.168.5.55',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Lana Lammers',
                                         'poller_hash': 'ILXGBR4U',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:01:b4:d0',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '433500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878255',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '433500000',
                                                                                                                                                     'tx_link_rate': '325000000'}]}],
                                                                                                 'tx_link_rate': '325000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgG0'}],
                                         'management_ip': '192.168.5.41',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Curtis Nelson',
                                         'poller_hash': 'ILXGAbTQ',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:6c:d4',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '16500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174360',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '16500000',
                                                                                                                                                     'tx_link_rate': '292500000'}]}],
                                                                                                 'tx_link_rate': '292500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgVs'}],
                                         'management_ip': '192.168.5.29',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Sarah Peters',
                                         'poller_hash': 'ILXGBWzU',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:06:92:05',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '325000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3878253',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '325000000',
                                                                                                                                                     'tx_link_rate': '292500000'}]}],
                                                                                                 'tx_link_rate': '292500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgaS'}],
                                         'management_ip': '192.168.5.47',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Dennis Crowell',
                                         'poller_hash': 'ILXGBpIF',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:f4:34'}],
                                                                       'mac_address': '20:b5:c6:05:7e:da',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5310,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '390000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '879022',
                                                                                                                                                     'mac_address': '20:b5:c6:04:f4:34',
                                                                                                                                                     'rx_link_rate': '390000000',
                                                                                                                                                     'tx_link_rate': '433500000'}]}],
                                                                                                 'tx_link_rate': '433500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '5-D'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgV+'}],
                                         'management_ip': '192.168.5.25',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Jessica Johnson',
                                         'poller_hash': 'ILXGBX7a',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_14_2_5_4_2_01(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.4.2.01")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 40,
                'rf_freq': 5510,
                'rf_tx_power': 18,
                'sta_count': 8,
                'sw_version': '2.5.4.2',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 2824144842,
                'dl_rf_packets': 4200036139,
                'temperature': 32.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1023592101,
                'ul_rf_packets': 2500320449
        }
        exp_sta_stats = {
                '04:18:d6:8e:a7:d5': {       'alt_macs': {       None,
                                                                 '04:18:d6:8f:a7:d5',
                                                                 '06:18:d6:8f:a7:d5'},
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.19.218',
                                             'mac_address': '04:18:d6:8e:a7:d5',
                                             'name': 'Ubiquiti Networks_8e:a7:d5',
                                             'temperature': None,
                                             'ul_link_rate': 243000000,
                                             'ul_noise_floor': -81.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.8,
                                             'ul_snr': 22.1},
                '18:e8:29:dc:b5:36': {       'alt_macs': {       None,
                                                                 '18:e8:29:dd:b5:36',
                                                                 '1a:e8:29:dd:b5:36'},
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.19.238',
                                             'mac_address': '18:e8:29:dc:b5:36',
                                             'name': '18:e8:29:dc:b5:36',
                                             'temperature': None,
                                             'ul_link_rate': 216000000,
                                             'ul_noise_floor': -77.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 20.9},
                '20:b5:c6:06:2d:14': {       'alt_macs': {'20:b5:c6:06:2d:13'},
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': -90.3,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -50.25,
                                             'dl_snr': 40.05,
                                             'ip_address': '10.99.19.233',
                                             'mac_address': '20:b5:c6:06:2d:14',
                                             'name': 'new-c5',
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -75.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -48.0,
                                             'ul_snr': 27.9},
                '20:b5:c6:11:4f:c0': {       'alt_macs': {'20:b5:c6:11:4f:bf'},
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': -95.4,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -43.85,
                                             'dl_snr': 51.55,
                                             'ip_address': '10.99.19.235',
                                             'mac_address': '20:b5:c6:11:4f:c0',
                                             'name': 'new-c5',
                                             'temperature': None,
                                             'ul_link_rate': 360000000,
                                             'ul_noise_floor': -71.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -41.2,
                                             'ul_snr': 30.7},
                '20:b5:c6:13:38:ad': {       'alt_macs': {'20:b5:c6:15:17:87'},
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': -75.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -38.65,
                                             'dl_snr': 36.35,
                                             'ip_address': '10.99.19.236',
                                             'mac_address': '20:b5:c6:13:38:ad',
                                             'name': 'new-C5c',
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -75.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.1,
                                             'ul_snr': 29.1},
                '20:b5:c6:18:ee:31': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.19.234',
                                             'mac_address': '20:b5:c6:18:ee:31',
                                             'name': 'mimosa',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -64.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -34.1,
                                             'ul_snr': 30.0},
                '20:b5:c6:19:48:11': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 400000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.19.5',
                                             'mac_address': '20:b5:c6:19:48:11',
                                             'name': 'mimosa',
                                             'temperature': None,
                                             'ul_link_rate': 400000000,
                                             'ul_noise_floor': -77.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.5,
                                             'ul_snr': 31.0},
                '74:ac:b9:80:97:c4': {       'alt_macs': {       None,
                                                                 '74:ac:b9:81:97:c4',
                                                                 '76:ac:b9:81:97:c4'},
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.19.14',
                                             'mac_address': '74:ac:b9:80:97:c4',
                                             'name': '74:ac:b9:80:97:c4',
                                             'temperature': None,
                                             'ul_link_rate': 300000000,
                                             'ul_noise_floor': -82.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.1,
                                             'ul_snr': 23.1}
        }
        exp_ne_msg = {
                'data': {       'elevation': 1778.9,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '62',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2956751',
                                                              'in_octets': '1111627723',
                                                              'in_ucast_pkts': '4173753897',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:04:fa:98',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '560978',
                                                              'out_octets': '2197816427',
                                                              'out_ucast_pkts': '2485592302',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '3797706',
                                                              'in_octets': '1023592101',
                                                              'in_ucast_pkts': '2496522743',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2235552963',
                                                                                       'in_ucast_pkts': '271210239',
                                                                                       'mac_address': '18:e8:29:dc:b5:36',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3412775454',
                                                                                       'out_ucast_pkts': '571715508'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1029454864',
                                                                                       'in_ucast_pkts': '2185764',
                                                                                       'mac_address': '74:ac:b9:80:97:c4',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1697040983',
                                                                                       'out_ucast_pkts': '4710920'},
                                                                               {       'mac_address': '20:b5:c6:18:ee:31'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '801083230',
                                                                                       'in_ucast_pkts': '213810663',
                                                                                       'mac_address': '04:18:d6:8e:a7:d5',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1910075456',
                                                                                       'out_ucast_pkts': '324625745'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '56',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3914068062',
                                                                                       'in_ucast_pkts': '54124361',
                                                                                       'mac_address': '20:b5:c6:06:2d:14',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '117174',
                                                                                       'out_octets': '2106301115',
                                                                                       'out_ucast_pkts': '85322307'},
                                                                               {       'mac_address': '20:b5:c6:19:48:11'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '41',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2061151925',
                                                                                       'in_ucast_pkts': '6555951',
                                                                                       'mac_address': '20:b5:c6:13:38:ad',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '26',
                                                                                       'out_nucast_pkts': '405460',
                                                                                       'out_octets': '3050928883',
                                                                                       'out_ucast_pkts': '6516943'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '30',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3929808126',
                                                                                       'in_ucast_pkts': '21183712',
                                                                                       'mac_address': '20:b5:c6:11:4f:c0',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '31291',
                                                                                       'out_octets': '274750886',
                                                                                       'out_ucast_pkts': '57512099'}],
                                                              'mac_address': '20:b5:c6:04:fa:88',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '9472',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2824144842',
                                                              'out_ucast_pkts': '4200036139',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5510,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1900658',
                                                                                                                                            'mac_address': '18:e8:29:dc:b5:36',
                                                                                                                                            'noise_floor': -77.9,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '216000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 20.9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '145794',
                                                                                                                                            'mac_address': '74:ac:b9:80:97:c4',
                                                                                                                                            'noise_floor': -82.2,
                                                                                                                                            'rssi': -59.1,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 23.1,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '160653',
                                                                                                                                            'mac_address': '20:b5:c6:18:ee:31',
                                                                                                                                            'noise_floor': -64.1,
                                                                                                                                            'rssi': -34.1,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1867293',
                                                                                                                                            'mac_address': '04:18:d6:8e:a7:d5',
                                                                                                                                            'noise_floor': -81.9,
                                                                                                                                            'rssi': -59.8,
                                                                                                                                            'rx_link_rate': '243000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 22.1,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '561811',
                                                                                                                                            'mac_address': '20:b5:c6:06:2d:14',
                                                                                                                                            'noise_floor': -75.9,
                                                                                                                                            'rssi': -48.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 27.9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '1866561',
                                                                                                                                            'mac_address': '20:b5:c6:19:48:11',
                                                                                                                                            'noise_floor': -77.5,
                                                                                                                                            'rssi': -46.5,
                                                                                                                                            'rx_link_rate': '400000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1900588',
                                                                                                                                            'mac_address': '20:b5:c6:13:38:ad',
                                                                                                                                            'noise_floor': -75.2,
                                                                                                                                            'rssi': -46.1,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 29.1,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '150018',
                                                                                                                                            'mac_address': '20:b5:c6:11:4f:c0',
                                                                                                                                            'noise_floor': -71.9,
                                                                                                                                            'rssi': -41.2,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 18}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'VE-360-5G'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 36.17055,
                                'longitude': -105.9674,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGBPqI',
                                'serial_number': '2014130430',
                                'sw_version': '2.5.4.2',
                                'system_mac_address': '20:b5:c6:04:fa:98',
                                'temperature': 32.0,
                                'uptime': '3223261'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '5',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3412775454',
                                                                       'in_ucast_pkts': '571715508',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3412775454',
                                                                                                'in_ucast_pkts': '571715508',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2235552963',
                                                                                                'out_ucast_pkts': '271210239'}],
                                                                       'mac_address': '18:e8:29:dc:b5:36',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2235552963',
                                                                       'out_ucast_pkts': '271210239',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900658',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '216000000'}]}],
                                                                                                 'tx_link_rate': '216000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '49',
                                                                       'in_octets': '1625387625',
                                                                       'in_ucast_pkts': '267513191',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '18:e8:29:dd:b5:36',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_discards': '469656',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2494293060',
                                                                       'out_ucast_pkts': '568931807',
                                                                       'poller_hash': '8hjoKdy1',
                                                                       'speed': '100000000',
                                                                       'type': 6},
                                                               {       'admin_up': False,
                                                                       'id': '3',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '1a:e8:29:dd:b5:36',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': '8xjoKdy1',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.238',
                                         'poller_hash': 'GOgp3LU2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:dd:b5:36'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '5',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1697040983',
                                                                       'in_ucast_pkts': '4710920',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1697040983',
                                                                                                'in_ucast_pkts': '4710920',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1029454864',
                                                                                                'out_ucast_pkts': '2185764'}],
                                                                       'mac_address': '74:ac:b9:80:97:c4',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1029454864',
                                                                       'out_ucast_pkts': '2185764',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '145794',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '300000000'}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '216',
                                                                       'in_octets': '904884427',
                                                                       'in_ucast_pkts': '2031874',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '74:ac:b9:81:97:c4',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_discards': '417',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1558999305',
                                                                       'out_ucast_pkts': '4592561',
                                                                       'poller_hash': '8nSsuYCX',
                                                                       'speed': '100000000',
                                                                       'type': 6},
                                                               {       'admin_up': False,
                                                                       'id': '3',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '76:ac:b9:81:97:c4',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': '83SsuYCX',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.14',
                                         'poller_hash': 'dKy5gJfE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '74:ac:b9:81:97:c4'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:fa:88'}],
                                                                       'mac_address': '20:b5:c6:18:ee:31',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '160653',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhju'}],
                                         'management_ip': '10.99.19.234',
                                         'manufacturer': 'Mimosa',
                                         'name': 'mimosa',
                                         'poller_hash': 'ILXGGO4x',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '5',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1910075456',
                                                                       'in_ucast_pkts': '324625745',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1910075456',
                                                                                                'in_ucast_pkts': '324625745',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '801083230',
                                                                                                'out_ucast_pkts': '213810663'}],
                                                                       'mac_address': '04:18:d6:8e:a7:d5',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '801083230',
                                                                       'out_ucast_pkts': '213810663',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1867293',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '243000000'}]}],
                                                                                                 'tx_link_rate': '243000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1875488',
                                                                       'in_octets': '3218246987',
                                                                       'in_ucast_pkts': '210279761',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '04:18:d6:8f:a7:d5',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_discards': '149904',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2904405792',
                                                                       'out_ucast_pkts': '323354428',
                                                                       'poller_hash': '8gQY1o6n',
                                                                       'speed': '100000000',
                                                                       'type': 6},
                                                               {       'admin_up': False,
                                                                       'id': '3',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '06:18:d6:8f:a7:d5',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': '8wQY1o6n',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.218',
                                         'poller_hash': 'BBjWjqfV',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:8f:a7:d5'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '117174',
                                                                       'in_octets': '2106301115',
                                                                       'in_ucast_pkts': '85322307',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '117174',
                                                                                                'in_octets': '2106301115',
                                                                                                'in_ucast_pkts': '85322307',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '56',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3914068062',
                                                                                                'out_ucast_pkts': '54124361'}],
                                                                       'mac_address': '20:b5:c6:06:2d:14',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '56',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3914068062',
                                                                       'out_ucast_pkts': '54124361',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561811',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'noise_floor': -90.3,
                                                                                                                                                     'rssi': -50.25,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'snr': 40.05,
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000',
                                                                                                 'tx_power': 8}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6',
                                                                       'in_octets': '2447139013',
                                                                       'in_ucast_pkts': '53374110',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:06:2d:13',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2382275371',
                                                                       'out_ucast_pkts': '85890366',
                                                                       'poller_hash': '8SC1xgYt',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.233',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5',
                                         'name': 'new-c5',
                                         'poller_hash': 'ILXGBi0U',
                                         'serial_number': '3016197328',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.2',
                                         'system_mac_address': '20:b5:c6:06:2d:13',
                                         'temperature': 50.0},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:04:fa:88'}],
                                                                       'mac_address': '20:b5:c6:19:48:11',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1866561',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'tx_link_rate': '400000000'}]}],
                                                                                                 'tx_link_rate': '400000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhlI'}],
                                         'management_ip': '10.99.19.5',
                                         'manufacturer': 'Mimosa',
                                         'name': 'mimosa',
                                         'poller_hash': 'ILXGGUgR',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '26',
                                                                       'in_nucast_pkts': '405460',
                                                                       'in_octets': '3050928883',
                                                                       'in_ucast_pkts': '6516943',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '26',
                                                                                                'in_nucast_pkts': '405460',
                                                                                                'in_octets': '3050928883',
                                                                                                'in_ucast_pkts': '6516943',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '41',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2061151925',
                                                                                                'out_ucast_pkts': '6555951'}],
                                                                       'mac_address': '20:b5:c6:13:38:ad',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '41',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2061151925',
                                                                       'out_ucast_pkts': '6555951',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900588',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'noise_floor': -75.0,
                                                                                                                                                     'rssi': -38.65,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'snr': 36.35,
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000',
                                                                                                 'tx_power': -3}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2530',
                                                                       'in_octets': '871891051',
                                                                       'in_ucast_pkts': '4076305',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:15:17:87',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2897477196',
                                                                       'out_ucast_pkts': '9077427',
                                                                       'poller_hash': '8SC1xhM4',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.236',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5c',
                                         'name': 'new-C5c',
                                         'poller_hash': 'ILXGEzit',
                                         'serial_number': '3071613329',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.2',
                                         'system_mac_address': '20:b5:c6:15:17:87',
                                         'temperature': 28.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '31291',
                                                                       'in_octets': '274750886',
                                                                       'in_ucast_pkts': '57512099',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '31291',
                                                                                                'in_octets': '274750886',
                                                                                                'in_ucast_pkts': '57512099',
                                                                                                'mac_address': '20:b5:c6:04:fa:88',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '30',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3929808126',
                                                                                                'out_ucast_pkts': '21183712'}],
                                                                       'mac_address': '20:b5:c6:11:4f:c0',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '30',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3929808126',
                                                                       'out_ucast_pkts': '21183712',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5510,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '150018',
                                                                                                                                                     'mac_address': '20:b5:c6:04:fa:88',
                                                                                                                                                     'noise_floor': -95.4,
                                                                                                                                                     'rssi': -43.85,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'snr': 51.55,
                                                                                                                                                     'tx_link_rate': '360000000'}]}],
                                                                                                 'tx_link_rate': '360000000',
                                                                                                 'tx_power': 8}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VE-360-5G'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '38',
                                                                       'in_octets': '3459182909',
                                                                       'in_ucast_pkts': '20978491',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:11:4f:bf',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '487206044',
                                                                       'out_ucast_pkts': '57661168',
                                                                       'poller_hash': '8SC1xhFP',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.99.19.235',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5',
                                         'name': 'new-c5',
                                         'poller_hash': 'ILXGEU/A',
                                         'serial_number': '3019080667',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.2',
                                         'system_mac_address': '20:b5:c6:11:4f:bf',
                                         'temperature': 44.0}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_14_2_5_5_5_10_0_27_5(self):
        obj = self.run_data("mimosa.a5.A5-360-14.2.5.5.5.10_0_27_5")
        exp_info = {
                'model': 'A5-360-14',
                'rf_chan_width': 40,
                'rf_freq': 5230,
                'rf_tx_power': 24,
                'sta_count': 12,
                'sw_version': '2.5.5.5',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 3974520600,
                'dl_rf_packets': 1023487023,
                'temperature': 35.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 3869815943,
                'ul_rf_packets': 1217068409
        }
        exp_sta_stats = {
                '20:b5:c6:1d:37:2f': {       'alt_macs': {'20:b5:c6:1e:14:f3'},
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': -87.3,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -56.05,
                                             'dl_snr': 31.25,
                                             'ip_address': '10.0.27.34',
                                             'mac_address': '20:b5:c6:1d:37:2f',
                                             'name': '1259-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 200000000,
                                             'ul_noise_floor': -80.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -50.6,
                                             'ul_snr': 30.1},
                '20:b5:c6:1e:43:1d': {       'alt_macs': {'20:b5:c6:1e:d2:db'},
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': -89.7,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -48.1,
                                             'dl_snr': 41.6,
                                             'ip_address': '10.0.27.36',
                                             'mac_address': '20:b5:c6:1e:43:1d',
                                             'name': '1260-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -62.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -40.2,
                                             'ul_snr': 22.3},
                '20:b5:c6:f9:d1:3f': {       'alt_macs': {'20:b5:c6:fb:e9:98'},
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': -90.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -61.75,
                                             'dl_snr': 28.75,
                                             'ip_address': '10.0.27.32',
                                             'mac_address': '20:b5:c6:f9:d1:3f',
                                             'name': '958-mimosa_muskie',
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -85.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.3,
                                             'ul_snr': 27.6},
                '20:b5:c6:f9:f4:68': {       'alt_macs': {'20:b5:c6:fc:d4:21'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -90.80000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -57.35,
                                             'dl_snr': 33.45,
                                             'ip_address': '10.0.27.43',
                                             'mac_address': '20:b5:c6:f9:f4:68',
                                             'name': '934-mimosa_muskie',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -82.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.7,
                                             'ul_snr': 30.1},
                '20:b5:c6:f9:f5:80': {       'alt_macs': {'20:b5:c6:fc:d6:41'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -90.30000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -60.2,
                                             'dl_snr': 30.1,
                                             'ip_address': '10.0.27.45',
                                             'mac_address': '20:b5:c6:f9:f5:80',
                                             'name': '1211-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -83.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53.6,
                                             'ul_snr': 30.0},
                '20:b5:c6:f9:f5:a7': {       'alt_macs': {'20:b5:c6:fc:d6:4b'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -49.95,
                                             'dl_snr': 41.05,
                                             'ip_address': '10.0.27.37',
                                             'mac_address': '20:b5:c6:f9:f5:a7',
                                             'name': '1258-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -77.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.7,
                                             'ul_snr': 30.7},
                '20:b5:c6:fa:f5:81': {       'alt_macs': {'20:b5:c6:fc:ee:d1'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -90.3,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -47.55,
                                             'dl_snr': 42.75,
                                             'ip_address': '10.0.27.42',
                                             'mac_address': '20:b5:c6:fa:f5:81',
                                             'name': '1135-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -75.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -45.2,
                                             'ul_snr': 29.8},
                '20:b5:c6:fb:6a:60': {       'alt_macs': {'20:b5:c6:fe:e3:e7'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -89.9,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -46.7,
                                             'dl_snr': 43.2,
                                             'ip_address': '10.0.27.41',
                                             'mac_address': '20:b5:c6:fb:6a:60',
                                             'name': '1125-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -73.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -43.0,
                                             'ul_snr': 30.3},
                '20:b5:c6:fb:70:f5': {       'alt_macs': {'20:b5:c6:fe:f5:e8'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -90.3,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -49.75,
                                             'dl_snr': 40.55,
                                             'ip_address': '10.0.27.33',
                                             'mac_address': '20:b5:c6:fb:70:f5',
                                             'name': '1108-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 150000000,
                                             'ul_noise_floor': -74.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.5,
                                             'ul_snr': 29.7},
                '20:b5:c6:fb:71:b7': {       'alt_macs': {'20:b5:c6:fe:f5:e6'},
                                             'dev_macs': None,
                                             'dl_link_rate': 45000000,
                                             'dl_noise_floor': -90.8,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -66.5,
                                             'dl_snr': 24.3,
                                             'ip_address': '10.0.27.40',
                                             'mac_address': '20:b5:c6:fb:71:b7',
                                             'name': '901-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.1,
                                             'ul_snr': 23.9},
                '20:b5:c6:fd:53:16': {       'alt_macs': {'20:b5:c6:ff:18:2f'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -91.2,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -56.2,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.0.27.38',
                                             'mac_address': '20:b5:c6:fd:53:16',
                                             'name': '937-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -82.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.4,
                                             'ul_snr': 30.2},
                '20:b5:c6:fd:53:4a': {       'alt_macs': {'20:b5:c6:ff:18:51'},
                                             'dev_macs': None,
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -90.80000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -55.2,
                                             'dl_snr': 35.6,
                                             'ip_address': '10.0.27.35',
                                             'mac_address': '20:b5:c6:fd:53:4a',
                                             'name': '928-mimosa_minnow',
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -80.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.7,
                                             'ul_snr': 30.3}
        }
        exp_ne_msg = {
                'data': {       'elevation': 340.9,
                                'gps_sats_tracked': 8,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '57300957',
                                                              'in_errors': '39',
                                                              'in_nucast_pkts': '194015335',
                                                              'in_octets': '3884858352',
                                                              'in_ucast_pkts': '3079008426',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:01:09:9c',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '13694543',
                                                              'out_octets': '2054049937',
                                                              'out_ucast_pkts': '1115653894',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3869815943',
                                                              'in_ucast_pkts': '1217068409',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '292',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '530689371',
                                                                                       'in_ucast_pkts': '24235577',
                                                                                       'mac_address': '20:b5:c6:fb:71:b7',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '12',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '301702744',
                                                                                       'out_ucast_pkts': '82986775'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '142',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1761197427',
                                                                                       'in_ucast_pkts': '137344501',
                                                                                       'mac_address': '20:b5:c6:1d:37:2f',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '3',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1320668356',
                                                                                       'out_ucast_pkts': '504390817'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '151',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3886600109',
                                                                                       'in_ucast_pkts': '38125308',
                                                                                       'mac_address': '20:b5:c6:f9:f5:a7',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2886964870',
                                                                                       'out_ucast_pkts': '250468587'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '142',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2719267922',
                                                                                       'in_ucast_pkts': '92292925',
                                                                                       'mac_address': '20:b5:c6:1e:43:1d',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '348952717',
                                                                                       'out_ucast_pkts': '319876603'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '677',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2710861295',
                                                                                       'in_ucast_pkts': '81643903',
                                                                                       'mac_address': '20:b5:c6:f9:d1:3f',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '17',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '151254669',
                                                                                       'out_ucast_pkts': '386768066'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '142',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '4178421703',
                                                                                       'in_ucast_pkts': '14531699',
                                                                                       'mac_address': '20:b5:c6:fb:70:f5',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4149539045',
                                                                                       'out_ucast_pkts': '67386421'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '163',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3923984434',
                                                                                       'in_ucast_pkts': '25553646',
                                                                                       'mac_address': '20:b5:c6:f9:f4:68',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4145412251',
                                                                                       'out_ucast_pkts': '218161336'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '147',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1752953873',
                                                                                       'in_ucast_pkts': '54465958',
                                                                                       'mac_address': '20:b5:c6:fb:6a:60',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '255731077',
                                                                                       'out_ucast_pkts': '320127364'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '219',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3132691607',
                                                                                       'in_ucast_pkts': '161630343',
                                                                                       'mac_address': '20:b5:c6:f9:f5:80',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '5',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4270357816',
                                                                                       'out_ucast_pkts': '1114923989'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '150',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3279571517',
                                                                                       'in_ucast_pkts': '25679855',
                                                                                       'mac_address': '20:b5:c6:fa:f5:81',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2774529136',
                                                                                       'out_ucast_pkts': '168664785'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '141',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2538831231',
                                                                                       'in_ucast_pkts': '151629958',
                                                                                       'mac_address': '20:b5:c6:fd:53:16',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '2',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3625483767',
                                                                                       'out_ucast_pkts': '567066725'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '145',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1294227259',
                                                                                       'in_ucast_pkts': '13900473',
                                                                                       'mac_address': '20:b5:c6:fd:53:4a',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '809279906',
                                                                                       'out_ucast_pkts': '53142201'}],
                                                              'mac_address': '20:b5:c6:01:09:8c',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3974520600',
                                                              'out_ucast_pkts': '1023487023',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 8000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '241826',
                                                                                                                                            'mac_address': '20:b5:c6:fb:71:b7',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -62.1,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 23.9,
                                                                                                                                            'tx_link_rate': '45000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'connected_time': '4900398',
                                                                                                                                            'mac_address': '20:b5:c6:1d:37:2f',
                                                                                                                                            'noise_floor': -80.7,
                                                                                                                                            'rssi': -50.6,
                                                                                                                                            'rx_link_rate': '200000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 30.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '3316536',
                                                                                                                                            'mac_address': '20:b5:c6:f9:f5:a7',
                                                                                                                                            'noise_floor': -77.4,
                                                                                                                                            'rssi': -46.7,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 30.7,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '4900397',
                                                                                                                                            'mac_address': '20:b5:c6:1e:43:1d',
                                                                                                                                            'noise_floor': -62.5,
                                                                                                                                            'rssi': -40.2,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 22.3,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '233504',
                                                                                                                                            'mac_address': '20:b5:c6:f9:d1:3f',
                                                                                                                                            'noise_floor': -85.9,
                                                                                                                                            'rssi': -58.3,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 27.6,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '732699',
                                                                                                                                            'mac_address': '20:b5:c6:fb:70:f5',
                                                                                                                                            'noise_floor': -74.2,
                                                                                                                                            'rssi': -44.5,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 29.7,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '4900396',
                                                                                                                                            'mac_address': '20:b5:c6:f9:f4:68',
                                                                                                                                            'noise_floor': -82.8,
                                                                                                                                            'rssi': -52.7,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.1,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '4900400',
                                                                                                                                            'mac_address': '20:b5:c6:fb:6a:60',
                                                                                                                                            'noise_floor': -73.3,
                                                                                                                                            'rssi': -43.0,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 30.3,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '593343',
                                                                                                                                            'mac_address': '20:b5:c6:f9:f5:80',
                                                                                                                                            'noise_floor': -83.6,
                                                                                                                                            'rssi': -53.6,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1983448',
                                                                                                                                            'mac_address': '20:b5:c6:fa:f5:81',
                                                                                                                                            'noise_floor': -75.0,
                                                                                                                                            'rssi': -45.2,
                                                                                                                                            'rx_link_rate': '150000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 29.8,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '4900395',
                                                                                                                                            'mac_address': '20:b5:c6:fd:53:16',
                                                                                                                                            'noise_floor': -82.6,
                                                                                                                                            'rssi': -52.4,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.2,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '695215',
                                                                                                                                            'mac_address': '20:b5:c6:fd:53:4a',
                                                                                                                                            'noise_floor': -80.0,
                                                                                                                                            'rssi': -49.7,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.3,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '#CampComm-LS'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 49.77009,
                                'longitude': -94.66074,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-14',
                                'poller_hash': 'ILXGAQmM',
                                'serial_number': '2016127371',
                                'sw_version': '2.5.5.5',
                                'system_mac_address': '20:b5:c6:01:09:9c',
                                'temperature': 35.0,
                                'uptime': '5742781'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '12',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '301702744',
                                                                       'in_ucast_pkts': '82986775',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '12',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '301702744',
                                                                                                'in_ucast_pkts': '82986775',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '292',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '530689371',
                                                                                                'out_ucast_pkts': '24235577'}],
                                                                       'mac_address': '20:b5:c6:fb:71:b7',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '292',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '530689371',
                                                                       'out_ucast_pkts': '24235577',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '241826',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.8,
                                                                                                                                                     'rssi': -66.5,
                                                                                                                                                     'rx_link_rate': '45000000',
                                                                                                                                                     'snr': 24.3,
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000',
                                                                                                 'tx_power': 16}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '51075',
                                                                       'in_octets': '16469809',
                                                                       'in_ucast_pkts': '21592426',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fe:f5:e6',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '97459224',
                                                                       'out_ucast_pkts': '80641398',
                                                                       'poller_hash': '8SC1xvtx',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.40',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '901-mimosa_walleye',
                                         'poller_hash': 'ILXG+3G3',
                                         'serial_number': '3107695366',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fe:f5:e6',
                                         'temperature': 19.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '3',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1320668356',
                                                                       'in_ucast_pkts': '504390817',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '3',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1320668356',
                                                                                                'in_ucast_pkts': '504390817',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '142',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1761197427',
                                                                                                'out_ucast_pkts': '137344501'}],
                                                                       'mac_address': '20:b5:c6:1d:37:2f',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '142',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1761197427',
                                                                       'out_ucast_pkts': '137344501',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4900398',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -87.3,
                                                                                                                                                     'rssi': -56.05,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'snr': 31.25,
                                                                                                                                                     'tx_link_rate': '200000000'}]}],
                                                                                                 'tx_link_rate': '200000000',
                                                                                                 'tx_power': 13}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '407606',
                                                                       'in_octets': '2625847539',
                                                                       'in_ucast_pkts': '120517347',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:1e:14:f3',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4116166721',
                                                                       'out_ucast_pkts': '488932158',
                                                                       'poller_hash': '8SC1xh03',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.34',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1259-mimosa_minnow',
                                         'poller_hash': 'ILXGHTcv',
                                         'serial_number': '3116311138',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:1e:14:f3',
                                         'temperature': 11.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2886964870',
                                                                       'in_ucast_pkts': '250468587',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2886964870',
                                                                                                'in_ucast_pkts': '250468587',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '151',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3886600109',
                                                                                                'out_ucast_pkts': '38125308'}],
                                                                       'mac_address': '20:b5:c6:f9:f5:a7',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '151',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3886600109',
                                                                       'out_ucast_pkts': '38125308',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3316536',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -49.95,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 41.05,
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000',
                                                                                                 'tx_power': 13}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '301583',
                                                                       'in_octets': '1578637050',
                                                                       'in_ucast_pkts': '25794646',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:d6:4b',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1422424177',
                                                                       'out_ucast_pkts': '239759049',
                                                                       'poller_hash': '8SC1xvn1',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.37',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1258-mimosa_minnow',
                                         'poller_hash': 'ILXG+fWn',
                                         'serial_number': '3101764920',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fc:d6:4b',
                                         'temperature': 22.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '348952717',
                                                                       'in_ucast_pkts': '319876603',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '348952717',
                                                                                                'in_ucast_pkts': '319876603',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '142',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2719267922',
                                                                                                'out_ucast_pkts': '92292925'}],
                                                                       'mac_address': '20:b5:c6:1e:43:1d',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '142',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2719267922',
                                                                       'out_ucast_pkts': '92292925',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4900397',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -89.7,
                                                                                                                                                     'rssi': -48.1,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'snr': 41.6,
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '393373',
                                                                       'in_octets': '3701784864',
                                                                       'in_ucast_pkts': '74553853',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:1e:d2:db',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2408213006',
                                                                       'out_ucast_pkts': '304470966',
                                                                       'poller_hash': '8SC1xh5D',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.36',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1260-mimosa_minnow',
                                         'poller_hash': 'ILXGHkMd',
                                         'serial_number': '3124501085',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:1e:d2:db',
                                         'temperature': 24.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '17',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '151254669',
                                                                       'in_ucast_pkts': '386768066',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '17',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '151254669',
                                                                                                'in_ucast_pkts': '386768066',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '677',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2710861295',
                                                                                                'out_ucast_pkts': '81643903'}],
                                                                       'mac_address': '20:b5:c6:f9:d1:3f',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '677',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2710861295',
                                                                       'out_ucast_pkts': '81643903',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '233504',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.5,
                                                                                                                                                     'rssi': -61.75,
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'snr': 28.75,
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '319552',
                                                                       'in_octets': '430474319',
                                                                       'in_ucast_pkts': '69624307',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fb:e9:98',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3602114716',
                                                                       'out_ucast_pkts': '376317787',
                                                                       'poller_hash': '8SC1xvnR',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.32',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '958-mimosa_muskie',
                                         'poller_hash': 'ILXG+dE/',
                                         'serial_number': '3106630249',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fb:e9:98',
                                         'temperature': 22.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4149539045',
                                                                       'in_ucast_pkts': '67386421',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4149539045',
                                                                                                'in_ucast_pkts': '67386421',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '142',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '4178421703',
                                                                                                'out_ucast_pkts': '14531699'}],
                                                                       'mac_address': '20:b5:c6:fb:70:f5',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '142',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4178421703',
                                                                       'out_ucast_pkts': '14531699',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '732699',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.3,
                                                                                                                                                     'rssi': -49.75,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 40.55,
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '63921',
                                                                       'in_octets': '3630604531',
                                                                       'in_ucast_pkts': '11714299',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fe:f5:e8',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3856173853',
                                                                       'out_ucast_pkts': '64925375',
                                                                       'poller_hash': '8SC1xvtw',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.33',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1108-mimosa_walleye',
                                         'poller_hash': 'ILXG+3D1',
                                         'serial_number': '3101542139',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fe:f5:e8',
                                         'temperature': 24.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4145412251',
                                                                       'in_ucast_pkts': '218161336',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4145412251',
                                                                                                'in_ucast_pkts': '218161336',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '163',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3923984434',
                                                                                                'out_ucast_pkts': '25553646'}],
                                                                       'mac_address': '20:b5:c6:f9:f4:68',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '163',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3923984434',
                                                                       'out_ucast_pkts': '25553646',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4900396',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.8,
                                                                                                                                                     'rssi': -57.35,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 33.45,
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '808681608',
                                                                       'in_ucast_pkts': '8152540',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:d4:21',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1505796591',
                                                                       'out_ucast_pkts': '202769513',
                                                                       'poller_hash': '8SC1xvn0',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.43',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '934-mimosa_muskie',
                                         'poller_hash': 'ILXG+fRo',
                                         'serial_number': '3137936007',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fc:d4:21',
                                         'temperature': 21.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '255731077',
                                                                       'in_ucast_pkts': '320127364',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '255731077',
                                                                                                'in_ucast_pkts': '320127364',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '147',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1752953873',
                                                                                                'out_ucast_pkts': '54465958'}],
                                                                       'mac_address': '20:b5:c6:fb:6a:60',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '147',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1752953873',
                                                                       'out_ucast_pkts': '54465958',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4900400',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -89.9,
                                                                                                                                                     'rssi': -46.7,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 43.2,
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '397335',
                                                                       'in_octets': '2762484386',
                                                                       'in_ucast_pkts': '36662262',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fe:e3:e7',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2317791108',
                                                                       'out_ucast_pkts': '304745084',
                                                                       'poller_hash': '8SC1xvtq',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.41',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1125-mimosa_minnow',
                                         'poller_hash': 'ILXG+2pg',
                                         'serial_number': '3127464237',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fe:e3:e7',
                                         'temperature': 15.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '5',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4270357816',
                                                                       'in_ucast_pkts': '1114923989',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '5',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4270357816',
                                                                                                'in_ucast_pkts': '1114923989',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '219',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3132691607',
                                                                                                'out_ucast_pkts': '161630343'}],
                                                                       'mac_address': '20:b5:c6:f9:f5:80',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '219',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3132691607',
                                                                       'out_ucast_pkts': '161630343',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '593343',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.3,
                                                                                                                                                     'rssi': -60.2,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 30.1,
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000',
                                                                                                 'tx_power': 15}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '484124',
                                                                       'in_octets': '3176174717',
                                                                       'in_ucast_pkts': '144644625',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:d6:41',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '986590689',
                                                                       'out_ucast_pkts': '1099823670',
                                                                       'poller_hash': '8SC1xvn1',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.45',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1211-mimosa_walleye',
                                         'poller_hash': 'ILXG+fWA',
                                         'serial_number': '3132644408',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fc:d6:41',
                                         'temperature': 18.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2774529136',
                                                                       'in_ucast_pkts': '168664785',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2774529136',
                                                                                                'in_ucast_pkts': '168664785',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '150',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3279571517',
                                                                                                'out_ucast_pkts': '25679855'}],
                                                                       'mac_address': '20:b5:c6:fa:f5:81',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '150',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3279571517',
                                                                       'out_ucast_pkts': '25679855',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1983448',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.3,
                                                                                                                                                     'rssi': -47.55,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 42.75,
                                                                                                                                                     'tx_link_rate': '150000000'}]}],
                                                                                                 'tx_link_rate': '150000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '173271',
                                                                       'in_octets': '1800257138',
                                                                       'in_ucast_pkts': '18021984',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:ee:d1',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1924222853',
                                                                       'out_ucast_pkts': '162007776',
                                                                       'poller_hash': '8SC1xvr1',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.42',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1135-mimosa_minnow',
                                         'poller_hash': 'ILXG+vWB',
                                         'serial_number': '3119023953',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:fc:ee:d1',
                                         'temperature': 21.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3625483767',
                                                                       'in_ucast_pkts': '567066725',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '2',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3625483767',
                                                                                                'in_ucast_pkts': '567066725',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '141',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2538831231',
                                                                                                'out_ucast_pkts': '151629958'}],
                                                                       'mac_address': '20:b5:c6:fd:53:16',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '141',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2538831231',
                                                                       'out_ucast_pkts': '151629958',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4900395',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -91.2,
                                                                                                                                                     'rssi': -56.2,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '395984',
                                                                       'in_octets': '486635752',
                                                                       'in_ucast_pkts': '133896001',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:ff:18:2f',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2383493487',
                                                                       'out_ucast_pkts': '551699937',
                                                                       'poller_hash': '8SC1xv1T',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.38',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '937-mimosa_minnow',
                                         'poller_hash': 'ILXG/VMW',
                                         'serial_number': '3113730459',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:ff:18:2f',
                                         'temperature': 19.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '809279906',
                                                                       'in_ucast_pkts': '53142201',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '1',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '809279906',
                                                                                                'in_ucast_pkts': '53142201',
                                                                                                'mac_address': '20:b5:c6:01:09:8c',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '145',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1294227259',
                                                                                                'out_ucast_pkts': '13900473'}],
                                                                       'mac_address': '20:b5:c6:fd:53:4a',
                                                                       'mtu': 3200,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '145',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1294227259',
                                                                       'out_ucast_pkts': '13900473',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '695215',
                                                                                                                                                     'mac_address': '20:b5:c6:01:09:8c',
                                                                                                                                                     'noise_floor': -90.8,
                                                                                                                                                     'rssi': -55.2,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 35.6,
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000',
                                                                                                 'tx_power': 14}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-LS'}],
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '3',
                                                                       'in_nucast_pkts': '65620',
                                                                       'in_octets': '721661105',
                                                                       'in_ucast_pkts': '11249752',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:ff:18:51',
                                                                       'mtu': 3200,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '489552757',
                                                                       'out_ucast_pkts': '50829047',
                                                                       'poller_hash': '8SC1xv1T',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.27.35',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '928-mimosa_minnow',
                                         'poller_hash': 'ILXG/VNK',
                                         'serial_number': '3129427134',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.5.5.5',
                                         'system_mac_address': '20:b5:c6:ff:18:51',
                                         'temperature': 23.0}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_180_2_5_2_01(self):
        obj = self.run_data("mimosa.a5.A5-360-180.2.5.2.01")
        exp_info = {
                'model': 'A5-360-180',
                'rf_chan_width': 80,
                'rf_freq': 5775,
                'rf_tx_power': 22,
                'sta_count': 8,
                'sw_version': '2.5.2',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 3042442177,
                'dl_rf_packets': 407513637,
                'temperature': 40.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 4268658179,
                'ul_rf_packets': 2439850912
        }
        exp_sta_stats = {
                '20:b5:c6:05:67:91': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 780000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.5',
                                             'mac_address': '20:b5:c6:05:67:91',
                                             'name': 'dsandoval',
                                             'temperature': None,
                                             'ul_link_rate': 650000000,
                                             'ul_noise_floor': -55.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -33.6,
                                             'ul_snr': 22.0},
                '20:b5:c6:06:28:18': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 585000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.69',
                                             'mac_address': '20:b5:c6:06:28:18',
                                             'name': 'malabika',
                                             'temperature': None,
                                             'ul_link_rate': 433000000,
                                             'ul_noise_floor': -63.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -36.6,
                                             'ul_snr': 26.6},
                '20:b5:c6:06:32:88': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 867000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.84',
                                             'mac_address': '20:b5:c6:06:32:88',
                                             'name': 'new-c5',
                                             'temperature': None,
                                             'ul_link_rate': 650000000,
                                             'ul_noise_floor': -61.599999999999994,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -36.8,
                                             'ul_snr': 24.8},
                '20:b5:c6:10:c8:12': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.3',
                                             'mac_address': '20:b5:c6:10:c8:12',
                                             'name': 'Alfredo Castillo',
                                             'temperature': None,
                                             'ul_link_rate': 585000000,
                                             'ul_noise_floor': -82.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.7,
                                             'ul_snr': 22.9},
                '20:b5:c6:11:50:a1': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 87000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.9',
                                             'mac_address': '20:b5:c6:11:50:a1',
                                             'name': 'new-c5',
                                             'temperature': None,
                                             'ul_link_rate': 58000000,
                                             'ul_noise_floor': -78.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.9,
                                             'ul_snr': 23.4},
                '20:b5:c6:13:69:e9': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 58000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.38',
                                             'mac_address': '20:b5:c6:13:69:e9',
                                             'name': 'mimosa',
                                             'temperature': None,
                                             'ul_link_rate': 87000000,
                                             'ul_noise_floor': -83.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.1,
                                             'ul_snr': 24.9},
                '20:b5:c6:13:7a:09': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 585000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.78',
                                             'mac_address': '20:b5:c6:13:7a:09',
                                             'name': 'New C5c',
                                             'temperature': None,
                                             'ul_link_rate': 650000000,
                                             'ul_noise_floor': -67.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -45.4,
                                             'ul_snr': 22.3},
                '20:b5:c6:19:45:fe': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 22000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.99.10.24',
                                             'mac_address': '20:b5:c6:19:45:fe',
                                             'name': 'mimosa',
                                             'temperature': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -78.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.9,
                                             'ul_snr': 14.6}
        }
        exp_ne_msg = {
                'data': {       'elevation': 1730.1,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '108485',
                                                              'in_errors': '70',
                                                              'in_nucast_pkts': '91388076',
                                                              'in_octets': '454928234',
                                                              'in_ucast_pkts': '4178567197',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:06:e7:f4',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2289639',
                                                              'out_octets': '1827200578',
                                                              'out_ucast_pkts': '2394128078',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '23',
                                                              'in_nucast_pkts': '2283933',
                                                              'in_octets': '4268658179',
                                                              'in_ucast_pkts': '2437566979',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '20:b5:c6:05:67:91'},
                                                                               {       'mac_address': '20:b5:c6:11:50:a1'},
                                                                               {       'mac_address': '20:b5:c6:13:69:e9'},
                                                                               {       'mac_address': '20:b5:c6:19:45:fe'},
                                                                               {       'mac_address': '20:b5:c6:06:32:88'},
                                                                               {       'mac_address': '20:b5:c6:06:28:18'},
                                                                               {       'mac_address': '20:b5:c6:10:c8:12'},
                                                                               {       'mac_address': '20:b5:c6:13:7a:09'}],
                                                              'mac_address': '20:b5:c6:06:e7:e4',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '28487',
                                                              'out_errors': '6',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3042442177',
                                                              'out_ucast_pkts': '407513637',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5775,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '5115682',
                                                                                                                                            'mac_address': '20:b5:c6:05:67:91',
                                                                                                                                            'noise_floor': -55.6,
                                                                                                                                            'rssi': -33.6,
                                                                                                                                            'rx_link_rate': '650000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_link_rate': '780000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '4951165',
                                                                                                                                            'mac_address': '20:b5:c6:11:50:a1',
                                                                                                                                            'noise_floor': -78.3,
                                                                                                                                            'rssi': -54.9,
                                                                                                                                            'rx_link_rate': '58000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 23.4,
                                                                                                                                            'tx_link_rate': '87000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '631316',
                                                                                                                                            'mac_address': '20:b5:c6:13:69:e9',
                                                                                                                                            'noise_floor': -83.0,
                                                                                                                                            'rssi': -58.1,
                                                                                                                                            'rx_link_rate': '87000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 24.9,
                                                                                                                                            'tx_link_rate': '58000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '624631',
                                                                                                                                            'mac_address': '20:b5:c6:19:45:fe',
                                                                                                                                            'noise_floor': -78.5,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 14.6,
                                                                                                                                            'tx_link_rate': '22000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'connected_time': '2645151',
                                                                                                                                            'mac_address': '20:b5:c6:06:32:88',
                                                                                                                                            'noise_floor': -61.6,
                                                                                                                                            'rssi': -36.8,
                                                                                                                                            'rx_link_rate': '650000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 24.8,
                                                                                                                                            'tx_link_rate': '867000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1157746',
                                                                                                                                            'mac_address': '20:b5:c6:06:28:18',
                                                                                                                                            'noise_floor': -63.2,
                                                                                                                                            'rssi': -36.6,
                                                                                                                                            'rx_link_rate': '433000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 26.6,
                                                                                                                                            'tx_link_rate': '585000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '668231',
                                                                                                                                            'mac_address': '20:b5:c6:10:c8:12',
                                                                                                                                            'noise_floor': -82.6,
                                                                                                                                            'rssi': -59.7,
                                                                                                                                            'rx_link_rate': '585000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 22.9,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'connected_time': '2612404',
                                                                                                                                            'mac_address': '20:b5:c6:13:7a:09',
                                                                                                                                            'noise_floor': -67.7,
                                                                                                                                            'rssi': -45.4,
                                                                                                                                            'rx_link_rate': '650000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 22.3,
                                                                                                                                            'tx_link_rate': '585000000',
                                                                                                                                            'tx_mcs': 6}]}],
                                                                                        'tx_power': 22}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MDWEST'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'latitude': 35.99369,
                                'longitude': -106.04959,
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-180',
                                'poller_hash': 'ILXGBufk',
                                'serial_number': '2021284080',
                                'sw_version': '2.5.2',
                                'system_mac_address': '20:b5:c6:06:e7:f4',
                                'temperature': 40.0,
                                'uptime': '6032389'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:05:67:91',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '780000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '5115682',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '780000000',
                                                                                                                                                     'tx_link_rate': '650000000'}]}],
                                                                                                 'tx_link_rate': '650000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgVn'}],
                                         'management_ip': '10.99.10.5',
                                         'manufacturer': 'Mimosa',
                                         'name': 'dsandoval',
                                         'poller_hash': 'ILXGBWeR',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:11:50:a1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4951165',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '87000000',
                                                                                                                                                     'tx_link_rate': '58000000'}]}],
                                                                                                 'tx_link_rate': '58000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhFQ'}],
                                         'management_ip': '10.99.10.9',
                                         'manufacturer': 'Mimosa',
                                         'name': 'new-c5',
                                         'poller_hash': 'ILXGEVCh',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:13:69:e9',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '631316',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '58000000',
                                                                                                                                                     'tx_link_rate': '87000000'}]}],
                                                                                                 'tx_link_rate': '87000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhNp'}],
                                         'management_ip': '10.99.10.38',
                                         'manufacturer': 'Mimosa',
                                         'name': 'mimosa',
                                         'poller_hash': 'ILXGE2np',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:19:45:fe',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '22000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '624631',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '22000000',
                                                                                                                                                     'tx_link_rate': '130000000'}]}],
                                                                                                 'tx_link_rate': '130000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhlF'}],
                                         'management_ip': '10.99.10.24',
                                         'manufacturer': 'Mimosa',
                                         'name': 'mimosa',
                                         'poller_hash': 'ILXGGUX+',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:06:32:88',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '867000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2645151',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '867000000',
                                                                                                                                                     'tx_link_rate': '650000000'}]}],
                                                                                                 'tx_link_rate': '650000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYy'}],
                                         'management_ip': '10.99.10.84',
                                         'manufacturer': 'Mimosa',
                                         'name': 'new-c5',
                                         'poller_hash': 'ILXGBjKI',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:06:28:18',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '585000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1157746',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '585000000',
                                                                                                                                                     'tx_link_rate': '433000000'}]}],
                                                                                                 'tx_link_rate': '433000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xgYo'}],
                                         'management_ip': '10.99.10.69',
                                         'manufacturer': 'Mimosa',
                                         'name': 'malabika',
                                         'poller_hash': 'ILXGBigY',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:10:c8:12',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '668231',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '585000000'}]}],
                                                                                                 'tx_link_rate': '585000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhDI'}],
                                         'management_ip': '10.99.10.3',
                                         'manufacturer': 'Mimosa',
                                         'name': 'Alfredo Castillo',
                                         'poller_hash': 'ILXGEMgS',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:06:e7:e4'}],
                                                                       'mac_address': '20:b5:c6:13:7a:09',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5775,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '585000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2612404',
                                                                                                                                                     'mac_address': '20:b5:c6:06:e7:e4',
                                                                                                                                                     'rx_link_rate': '585000000',
                                                                                                                                                     'tx_link_rate': '650000000'}]}],
                                                                                                 'tx_link_rate': '650000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MDWEST'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xhN6'}],
                                         'management_ip': '10.99.10.78',
                                         'manufacturer': 'Mimosa',
                                         'name': 'New C5c',
                                         'poller_hash': 'ILXGE3oJ',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.5.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5_360_180_2_5_2_02(self):
        obj = self.run_data("mimosa.a5.A5-360-180.2.5.2.02")
        exp_info = {
                'model': 'A5-360-180',
                'rf_chan_width': 40,
                'rf_freq': 5230,
                'rf_tx_power': 22,
                'sta_count': 35,
                'sw_version': '2.5.2',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 274674620,
                'dl_rf_packets': 1511010687,
                'temperature': 20.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 4163086299,
                'ul_rf_packets': 2987299711
        }
        exp_sta_stats = {
                '14:59:c0:3d:68:41': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '14:59:c0:3d:68:41',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 60000000,
                                             'ul_noise_floor': -83.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -73.1,
                                             'ul_snr': 9.9},
                '38:94:ed:12:4a:38': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 90000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '38:94:ed:12:4a:38',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 45000000,
                                             'ul_noise_floor': -80.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.2,
                                             'ul_snr': 9.2},
                '3c:37:86:14:80:96': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:14:80:96',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -79.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.9,
                                             'ul_snr': 18.2},
                '3c:37:86:14:af:ad': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:14:af:ad',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 60000000,
                                             'ul_noise_floor': -82.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.7,
                                             'ul_snr': 10.8},
                '3c:37:86:14:b1:1e': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:14:b1:1e',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 162000000,
                                             'ul_noise_floor': -81.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.7,
                                             'ul_snr': 18.1},
                '3c:37:86:1f:21:91': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:1f:21:91',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -88.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.5,
                                             'ul_snr': 25.8},
                '3c:37:86:1f:21:e2': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:1f:21:e2',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -85.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.4,
                                             'ul_snr': 14.4},
                '3c:37:86:1f:22:66': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '3c:37:86:1f:22:66',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -70.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.6,
                                             'ul_snr': 17.4},
                '5c:e2:8c:f1:ab:8d': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '5c:e2:8c:f1:ab:8d',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 14000000,
                                             'ul_noise_floor': -78.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -73.9,
                                             'ul_snr': 4.9},
                '5c:e2:8c:f1:ae:6d': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '5c:e2:8c:f1:ae:6d',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 41000000,
                                             'ul_noise_floor': -77.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.1,
                                             'ul_snr': 9.5},
                '78:d2:94:48:2c:b4': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:48:2c:b4',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 200000000,
                                             'ul_noise_floor': -81.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55.2,
                                             'ul_snr': 26.4},
                '78:d2:94:48:34:1f': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 270000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:48:34:1f',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -81.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57.3,
                                             'ul_snr': 24.5},
                '78:d2:94:48:3d:fa': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:48:3d:fa',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -82.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.2,
                                             'ul_snr': 23.7},
                '78:d2:94:48:40:43': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:48:40:43',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -81.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.4,
                                             'ul_snr': 20.4},
                '78:d2:94:48:42:9b': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:48:42:9b',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -81.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.4,
                                             'ul_snr': 25.3},
                '78:d2:94:49:cf:43': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:49:cf:43',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -79.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.9,
                                             'ul_snr': 18.7},
                '78:d2:94:49:cf:be': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 270000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:49:cf:be',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -88.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.9,
                                             'ul_snr': 20.1},
                '78:d2:94:b8:f0:6f': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:b8:f0:6f',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -84.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65.8,
                                             'ul_snr': 18.2},
                '78:d2:94:b8:f3:cc': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:b8:f3:cc',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.3,
                                             'ul_snr': 19.7},
                '78:d2:94:b8:f5:f7': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:b8:f5:f7',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 360000000,
                                             'ul_noise_floor': -91.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.8,
                                             'ul_snr': 28.3},
                '78:d2:94:be:2c:27': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:be:2c:27',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -71.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -47.9,
                                             'ul_snr': 23.9},
                '78:d2:94:bf:09:e3': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 270000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:bf:09:e3',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 120000000,
                                             'ul_noise_floor': -86.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.3,
                                             'ul_snr': 22.6},
                '78:d2:94:c0:78:68': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:c0:78:68',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 81000000,
                                             'ul_noise_floor': -81.19999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.1,
                                             'ul_snr': 15.1},
                '78:d2:94:c1:f5:8e': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:c1:f5:8e',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 270000000,
                                             'ul_noise_floor': -83.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.2,
                                             'ul_snr': 25.4},
                '78:d2:94:c1:f5:91': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 270000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '78:d2:94:c1:f5:91',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 108000000,
                                             'ul_noise_floor': -87.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.7,
                                             'ul_snr': 20.0},
                '8c:3b:ad:10:98:d7': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 135000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:10:98:d7',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -86.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.2,
                                             'ul_snr': 16.4},
                '8c:3b:ad:10:9d:b7': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:10:9d:b7',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 135000000,
                                             'ul_noise_floor': -83.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.4,
                                             'ul_snr': 24.9},
                '8c:3b:ad:15:10:df': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:15:10:df',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -83.60000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.9,
                                             'ul_snr': 14.7},
                '8c:3b:ad:19:36:ff': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:19:36:ff',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 90000000,
                                             'ul_noise_floor': -82.39999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.3,
                                             'ul_snr': 11.1},
                '8c:3b:ad:19:37:83': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:19:37:83',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 243000000,
                                             'ul_noise_floor': -79.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.6,
                                             'ul_snr': 20.8},
                '8c:3b:ad:1a:5f:fa': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:1a:5f:fa',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 180000000,
                                             'ul_noise_floor': -82.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.5,
                                             'ul_snr': 26.1},
                '8c:3b:ad:1a:6e:82': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 7000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:1a:6e:82',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 360000000,
                                             'ul_noise_floor': -82.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.1,
                                             'ul_snr': 28.4},
                '8c:3b:ad:1d:2f:a2': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 360000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:1d:2f:a2',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 240000000,
                                             'ul_noise_floor': -79.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.3,
                                             'ul_snr': 23.6},
                '8c:3b:ad:34:aa:16': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 300000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:34:aa:16',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 270000000,
                                             'ul_noise_floor': -83.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.7,
                                             'ul_snr': 25.1},
                '8c:3b:ad:34:b1:27': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_link_rate': 90000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '8c:3b:ad:34:b1:27',
                                             'name': None,
                                             'temperature': None,
                                             'ul_link_rate': 60000000,
                                             'ul_noise_floor': -84.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.5,
                                             'ul_snr': 14.8}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '718092',
                                                              'in_errors': '4674',
                                                              'in_nucast_pkts': '100934428',
                                                              'in_octets': '2299662595',
                                                              'in_ucast_pkts': '1348479015',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:00:ff:88',
                                                              'mtu': 1500,
                                                              'name': 'A5EthPort',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '96643',
                                                              'out_octets': '2184633106',
                                                              'out_ucast_pkts': '2993392670',
                                                              'speed': '1048576000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '574',
                                                              'in_nucast_pkts': '27727',
                                                              'in_octets': '4163086299',
                                                              'in_ucast_pkts': '2987271984',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '78:d2:94:be:2c:27'},
                                                                               {       'mac_address': '3c:37:86:1f:22:66'},
                                                                               {       'mac_address': '78:d2:94:48:2c:b4'},
                                                                               {       'mac_address': '8c:3b:ad:34:b1:27'},
                                                                               {       'mac_address': '3c:37:86:14:b1:1e'},
                                                                               {       'mac_address': '78:d2:94:48:40:43'},
                                                                               {       'mac_address': '78:d2:94:c0:78:68'},
                                                                               {       'mac_address': '3c:37:86:1f:21:91'},
                                                                               {       'mac_address': '5c:e2:8c:f1:ae:6d'},
                                                                               {       'mac_address': '8c:3b:ad:1a:5f:fa'},
                                                                               {       'mac_address': '78:d2:94:48:34:1f'},
                                                                               {       'mac_address': '78:d2:94:b8:f5:f7'},
                                                                               {       'mac_address': '78:d2:94:b8:f3:cc'},
                                                                               {       'mac_address': '8c:3b:ad:19:37:83'},
                                                                               {       'mac_address': '3c:37:86:1f:21:e2'},
                                                                               {       'mac_address': '78:d2:94:bf:09:e3'},
                                                                               {       'mac_address': '78:d2:94:49:cf:43'},
                                                                               {       'mac_address': '8c:3b:ad:34:aa:16'},
                                                                               {       'mac_address': '3c:37:86:14:af:ad'},
                                                                               {       'mac_address': '5c:e2:8c:f1:ab:8d'},
                                                                               {       'mac_address': '78:d2:94:c1:f5:91'},
                                                                               {       'mac_address': '8c:3b:ad:10:98:d7'},
                                                                               {       'mac_address': '78:d2:94:49:cf:be'},
                                                                               {       'mac_address': '8c:3b:ad:10:9d:b7'},
                                                                               {       'mac_address': '14:59:c0:3d:68:41'},
                                                                               {       'mac_address': '3c:37:86:14:80:96'},
                                                                               {       'mac_address': '38:94:ed:12:4a:38'},
                                                                               {       'mac_address': '78:d2:94:48:3d:fa'},
                                                                               {       'mac_address': '8c:3b:ad:19:36:ff'},
                                                                               {       'mac_address': '78:d2:94:b8:f0:6f'},
                                                                               {       'mac_address': '78:d2:94:48:42:9b'},
                                                                               {       'mac_address': '8c:3b:ad:15:10:df'},
                                                                               {       'mac_address': '8c:3b:ad:1a:6e:82'},
                                                                               {       'mac_address': '78:d2:94:c1:f5:8e'},
                                                                               {       'mac_address': '8c:3b:ad:1d:2f:a2'}],
                                                              'mac_address': '20:b5:c6:00:ff:78',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '407',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '274674620',
                                                              'out_ucast_pkts': '1511010687',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '78:d2:94:be:2c:27',
                                                                                                                                            'noise_floor': -71.8,
                                                                                                                                            'rssi': -47.9,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 23.9,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '3c:37:86:1f:22:66',
                                                                                                                                            'noise_floor': -70.0,
                                                                                                                                            'rssi': -52.6,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 17.4,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '78:d2:94:48:2c:b4',
                                                                                                                                            'noise_floor': -81.6,
                                                                                                                                            'rssi': -55.2,
                                                                                                                                            'rx_link_rate': '200000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 26.4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '8c:3b:ad:34:b1:27',
                                                                                                                                            'noise_floor': -84.3,
                                                                                                                                            'rssi': -69.5,
                                                                                                                                            'rx_link_rate': '60000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 14.8,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 1},
                                                                                                                                    {       'mac_address': '3c:37:86:14:b1:1e',
                                                                                                                                            'noise_floor': -81.8,
                                                                                                                                            'rssi': -63.7,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 18.1,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '78:d2:94:48:40:43',
                                                                                                                                            'noise_floor': -81.8,
                                                                                                                                            'rssi': -61.4,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 20.4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '78:d2:94:c0:78:68',
                                                                                                                                            'noise_floor': -81.2,
                                                                                                                                            'rssi': -66.1,
                                                                                                                                            'rx_link_rate': '81000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 15.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '3c:37:86:1f:21:91',
                                                                                                                                            'noise_floor': -88.3,
                                                                                                                                            'rssi': -62.5,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.8,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '5c:e2:8c:f1:ae:6d',
                                                                                                                                            'noise_floor': -77.6,
                                                                                                                                            'rssi': -68.1,
                                                                                                                                            'rx_link_rate': '41000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 9.5,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '8c:3b:ad:1a:5f:fa',
                                                                                                                                            'noise_floor': -82.6,
                                                                                                                                            'rssi': -56.5,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 26.1,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '78:d2:94:48:34:1f',
                                                                                                                                            'noise_floor': -81.8,
                                                                                                                                            'rssi': -57.3,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 24.5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '78:d2:94:b8:f5:f7',
                                                                                                                                            'noise_floor': -91.1,
                                                                                                                                            'rssi': -62.8,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 28.3,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '78:d2:94:b8:f3:cc',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -66.3,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 19.7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '8c:3b:ad:19:37:83',
                                                                                                                                            'noise_floor': -79.4,
                                                                                                                                            'rssi': -58.6,
                                                                                                                                            'rx_link_rate': '243000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 20.8,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '3c:37:86:1f:21:e2',
                                                                                                                                            'noise_floor': -85.8,
                                                                                                                                            'rssi': -71.4,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 14.4,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '78:d2:94:bf:09:e3',
                                                                                                                                            'noise_floor': -86.9,
                                                                                                                                            'rssi': -64.3,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 22.6,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '78:d2:94:49:cf:43',
                                                                                                                                            'noise_floor': -79.6,
                                                                                                                                            'rssi': -60.9,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 18.7,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '8c:3b:ad:34:aa:16',
                                                                                                                                            'noise_floor': -83.8,
                                                                                                                                            'rssi': -58.7,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 25.1,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '3c:37:86:14:af:ad',
                                                                                                                                            'noise_floor': -82.5,
                                                                                                                                            'rssi': -71.7,
                                                                                                                                            'rx_link_rate': '60000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 10.8,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '5c:e2:8c:f1:ab:8d',
                                                                                                                                            'noise_floor': -78.8,
                                                                                                                                            'rssi': -73.9,
                                                                                                                                            'rx_link_rate': '14000000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'snr': 4.9,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '78:d2:94:c1:f5:91',
                                                                                                                                            'noise_floor': -87.7,
                                                                                                                                            'rssi': -67.7,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '8c:3b:ad:10:98:d7',
                                                                                                                                            'noise_floor': -86.6,
                                                                                                                                            'rssi': -70.2,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 16.4,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '78:d2:94:49:cf:be',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -67.9,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 20.1,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '8c:3b:ad:10:9d:b7',
                                                                                                                                            'noise_floor': -83.3,
                                                                                                                                            'rssi': -58.4,
                                                                                                                                            'rx_link_rate': '135000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 24.9,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '14:59:c0:3d:68:41',
                                                                                                                                            'noise_floor': -83.0,
                                                                                                                                            'rssi': -73.1,
                                                                                                                                            'rx_link_rate': '60000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 9.9,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '3c:37:86:14:80:96',
                                                                                                                                            'noise_floor': -79.1,
                                                                                                                                            'rssi': -60.9,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 18.2,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '38:94:ed:12:4a:38',
                                                                                                                                            'noise_floor': -80.4,
                                                                                                                                            'rssi': -71.2,
                                                                                                                                            'rx_link_rate': '45000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 9.2,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '78:d2:94:48:3d:fa',
                                                                                                                                            'noise_floor': -82.9,
                                                                                                                                            'rssi': -59.2,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 23.7,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '8c:3b:ad:19:36:ff',
                                                                                                                                            'noise_floor': -82.4,
                                                                                                                                            'rssi': -71.3,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 11.1,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '78:d2:94:b8:f0:6f',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -65.8,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 18.2,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '78:d2:94:48:42:9b',
                                                                                                                                            'noise_floor': -81.7,
                                                                                                                                            'rssi': -56.4,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.3,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '8c:3b:ad:15:10:df',
                                                                                                                                            'noise_floor': -83.6,
                                                                                                                                            'rssi': -68.9,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 14.7,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '8c:3b:ad:1a:6e:82',
                                                                                                                                            'noise_floor': -82.5,
                                                                                                                                            'rssi': -54.1,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 28.4,
                                                                                                                                            'tx_link_rate': '7000000',
                                                                                                                                            'tx_mcs': 0},
                                                                                                                                    {       'mac_address': '78:d2:94:c1:f5:8e',
                                                                                                                                            'noise_floor': -83.6,
                                                                                                                                            'rssi': -58.2,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 25.4,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '8c:3b:ad:1d:2f:a2',
                                                                                                                                            'noise_floor': -79.9,
                                                                                                                                            'rssi': -56.3,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 23.6,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8}]}],
                                                                                        'tx_power': 22}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'LL-360-5G'}],
                                                              'speed': '1073741824',
                                                              'type': 71}],
                                'manufacturer': 'Mimosa',
                                'model': 'A5-360-180',
                                'poller_hash': 'ILXGAP94',
                                'serial_number': '2021002817',
                                'sw_version': '2.5.2',
                                'system_mac_address': '20:b5:c6:00:ff:88',
                                'temperature': 20.0,
                                'uptime': '551991'},
                'peers': [       {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:be:2c:27',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlL4s'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUviwn',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:1f:22:66',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hh8i'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGHyJm',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:48:2c:b4',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '200000000'}]}],
                                                                                                 'tx_link_rate': '200000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEgs'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSCy0',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:34:b1:27',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'tx_link_rate': '60000000'}]}],
                                                                                                 'tx_link_rate': '60000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rTSx'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutNLEn',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:14:b1:1e',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '162000000'}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hhSx'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGFLEe',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:48:40:43',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEhA'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSEBD',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:c0:78:68',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '81000000'}]}],
                                                                                                 'tx_link_rate': '81000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlMB4'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUwHho',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:1f:21:91',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hh8h'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGHyGR',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '5c:e2:8c:f1:ae:6d',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '41000000'}]}],
                                                                                                 'tx_link_rate': '41000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8VzijPGu'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'XOKM8a5t',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:1a:5f:fa',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRpf'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutGl/6',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:48:34:1f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'tx_link_rate': '130000000'}]}],
                                                                                                 'tx_link_rate': '130000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEg0'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSDQf',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:b8:f5:f7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '360000000'}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlLj1'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUuPX3',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:b8:f3:cc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlLjz'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUuPPM',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:19:37:83',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '243000000'}]}],
                                                                                                 'tx_link_rate': '243000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRk3'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutGTeD',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:1f:21:e2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hh8h'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGHyHi',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:bf:09:e3',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlL8J'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUvwnj',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:49:cf:43',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '180000000'}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEnP'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSc9D',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:34:aa:16',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '270000000'}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rTSq'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutNKoW',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:14:af:ad',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'tx_link_rate': '60000000'}]}],
                                                                                                 'tx_link_rate': '60000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hhSv'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGFK+t',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '5c:e2:8c:f1:ab:8d',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '14000000'}]}],
                                                                                                 'tx_link_rate': '14000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8VzijPGr'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'XOKM8auN',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:c1:f5:91',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'tx_link_rate': '108000000'}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlMH1'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUwfWR',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:10:98:d7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRCY'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutEJjX',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:49:cf:be',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'tx_link_rate': '120000000'}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEnP'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSc++',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:10:9d:b7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '135000000'}]}],
                                                                                                 'tx_link_rate': '135000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRCd'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutEJ23',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '14:59:c0:3d:68:41',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '60000000'}]}],
                                                                                                 'tx_link_rate': '60000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8RRZwD1o'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'FFnAPWhB',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '3c:37:86:14:80:96',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Tw3hhSA'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'PDeGFICW',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '38:94:ed:12:4a:38',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'tx_link_rate': '45000000'}]}],
                                                                                                 'tx_link_rate': '45000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8TiU7RJK'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'OJTtEko4',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:48:3d:fa',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEg9'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSD36',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:19:36:ff',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRk2'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutGTb/',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:b8:f0:6f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlLjw'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUuPBv',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:48:42:9b',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlEhC'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUSEKb',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:15:10:df',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '90000000'}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRUQ'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutFRDf',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:1a:6e:82',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '7000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '7000000',
                                                                                                                                                     'tx_link_rate': '360000000'}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rRpu'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutGm6C',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '78:d2:94:c1:f5:8e',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'tx_link_rate': '270000000'}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8XjSlMH1'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'eNKUwfWO',
                                         'status': 'ELEMENT_STATUS_ERROR'},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:00:ff:78'}],
                                                                       'mac_address': '8c:3b:ad:1d:2f:a2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '20:b5:c6:00:ff:78',
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'tx_link_rate': '240000000'}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LL-360-5G'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8Yw7rR0v'}],
                                         'manufacturer': 'Mimosa',
                                         'poller_hash': 'jDutHS+i',
                                         'status': 'ELEMENT_STATUS_ERROR'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5c_2_2_12_0_01(self):
        obj = self.run_data("mimosa.a5.A5c-2.2.12.0.01")
        exp_info = {
                'model': 'A5c-2',
                'rf_chan_width': 40,
                'rf_freq': 5670,
                'rf_tx_power': 13,
                'sta_count': 7,
                'sw_version': '2.12.0',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 1047439537,
                'dl_rf_packets': 1269692763,
                'temperature': 21.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1842789713,
                'ul_rf_packets': 318821895
        }
        exp_sta_stats = {
                '20:b5:c6:1e:3a:10': {       'alt_macs': {'20:b5:c6:1e:d3:dd'},
                                             'dev_macs': {'c4:ad:34:fb:cb:6f'},
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -92.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -63.8,
                                             'dl_snr': 28.7,
                                             'ip_address': '10.0.7.33',
                                             'mac_address': '20:b5:c6:1e:3a:10',
                                             'name': '299-Minnow',
                                             'temperature': None,
                                             'ul_link_rate': 156500000,
                                             'ul_noise_floor': -90.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.6,
                                             'ul_snr': 28.8},
                '20:b5:c6:f0:79:6d': {       'alt_macs': {'20:b5:c6:f6:fe:65'},
                                             'dev_macs': {'f8:27:2e:07:0d:c2'},
                                             'dl_link_rate': 118000000,
                                             'dl_noise_floor': -89.9,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -64.3,
                                             'dl_snr': 25.6,
                                             'ip_address': '10.0.7.60',
                                             'mac_address': '20:b5:c6:f0:79:6d',
                                             'name': '102-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 103500000,
                                             'ul_noise_floor': -91.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 23.9},
                '20:b5:c6:f7:fa:86': {       'alt_macs': {'20:b5:c6:f9:03:7c'},
                                             'dev_macs': {'f8:27:2e:06:e4:6a'},
                                             'dl_link_rate': 164000000,
                                             'dl_noise_floor': -92.80000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -71.95,
                                             'dl_snr': 20.85,
                                             'ip_address': '10.0.7.67',
                                             'mac_address': '20:b5:c6:f7:fa:86',
                                             'name': '777-mimosa_muskie',
                                             'temperature': None,
                                             'ul_link_rate': 88000000,
                                             'ul_noise_floor': -88.8,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.8,
                                             'ul_snr': 18.0},
                '20:b5:c6:f8:c7:0e': {       'alt_macs': {'20:b5:c6:fa:de:c1'},
                                             'dev_macs': {'30:de:4b:3d:8c:11'},
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -93.2,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -60.45,
                                             'dl_snr': 32.75,
                                             'ip_address': '10.0.7.93',
                                             'mac_address': '20:b5:c6:f8:c7:0e',
                                             'name': '954-mimosa_muskie',
                                             'temperature': None,
                                             'ul_link_rate': 160000000,
                                             'ul_noise_floor': -88.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 30.1},
                '20:b5:c6:f9:d1:09': {       'alt_macs': {'20:b5:c6:fb:e8:24'},
                                             'dev_macs': {'f8:27:2e:06:db:fa'},
                                             'dl_link_rate': 199000000,
                                             'dl_noise_floor': -92.9,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -66.25,
                                             'dl_snr': 26.65,
                                             'ip_address': '10.0.7.87',
                                             'mac_address': '20:b5:c6:f9:d1:09',
                                             'name': '971-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 146000000,
                                             'ul_noise_floor': -91.3,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65.8,
                                             'ul_snr': 25.5},
                '20:b5:c6:f9:f4:99': {       'alt_macs': set(),
                                             'dev_macs': {'f8:27:2e:07:04:e6'},
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.0.7.94',
                                             'mac_address': '20:b5:c6:f9:f4:99',
                                             'name': '1176-Minnow',
                                             'temperature': None,
                                             'ul_link_rate': 176000000,
                                             'ul_noise_floor': -85.7,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55.1,
                                             'ul_snr': 30.6},
                '20:b5:c6:fa:f5:22': {       'alt_macs': {'20:b5:c6:fc:ee:63'},
                                             'dev_macs': {'98:ee:cb:9d:95:bb'},
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -93.4,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -59.95,
                                             'dl_snr': 33.45,
                                             'ip_address': '10.0.7.49',
                                             'mac_address': '20:b5:c6:fa:f5:22',
                                             'name': '1117-mimosa_walleye',
                                             'temperature': None,
                                             'ul_link_rate': 150500000,
                                             'ul_noise_floor': -88.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.6,
                                             'ul_snr': 31.5}
        }
        exp_ne_msg = {
                'data': {       'gps_sats_tracked': 2,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '223608284',
                                                              'in_octets': '1366491386',
                                                              'in_ucast_pkts': '741530060',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:25:6d:f0',
                                                              'mtu': 1500,
                                                              'name': 'eth1_emac1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2223028540',
                                                              'out_ucast_pkts': '318398418',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1842789713',
                                                              'in_ucast_pkts': '318821895',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'f8:27:2e:06:e4:6a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '66',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2271673688',
                                                                                       'in_ucast_pkts': '18175158',
                                                                                       'mac_address': '20:b5:c6:f7:fa:86',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2008969268',
                                                                                       'out_ucast_pkts': '74256681'},
                                                                               {       'bridged_mac_addresses': [       'f8:27:2e:06:db:fa'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '84',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2187624002',
                                                                                       'in_ucast_pkts': '70211633',
                                                                                       'mac_address': '20:b5:c6:f9:d1:09',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '3',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3317686156',
                                                                                       'out_ucast_pkts': '242956408'},
                                                                               {       'bridged_mac_addresses': [       '30:de:4b:3d:8c:11'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '65',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1679718112',
                                                                                       'in_ucast_pkts': '14047289',
                                                                                       'mac_address': '20:b5:c6:f8:c7:0e',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1705258315',
                                                                                       'out_ucast_pkts': '54346479'},
                                                                               {       'bridged_mac_addresses': [       'c4:ad:34:fb:cb:6f'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '84',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2773257374',
                                                                                       'in_ucast_pkts': '17457359',
                                                                                       'mac_address': '20:b5:c6:1e:3a:10',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '5',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '520506934',
                                                                                       'out_ucast_pkts': '182413167'},
                                                                               {       'bridged_mac_addresses': [       'f8:27:2e:07:04:e6'],
                                                                                       'mac_address': '20:b5:c6:f9:f4:99'},
                                                                               {       'bridged_mac_addresses': [       '98:ee:cb:9d:95:bb'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '71',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '310856509',
                                                                                       'in_ucast_pkts': '712869',
                                                                                       'mac_address': '20:b5:c6:fa:f5:22',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3724578501',
                                                                                       'out_ucast_pkts': '28915183'},
                                                                               {       'bridged_mac_addresses': [       'f8:27:2e:07:0d:c2'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '69',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1423723795',
                                                                                       'in_ucast_pkts': '164463452',
                                                                                       'mac_address': '20:b5:c6:f0:79:6d',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2239858670',
                                                                                       'out_ucast_pkts': '514394690'}],
                                                              'mac_address': '20:b5:c6:24:2d:7b',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1047439537',
                                                              'out_ucast_pkts': '1269692763',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 8000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5670,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1776',
                                                                                                                                            'mac_address': '20:b5:c6:f7:fa:86',
                                                                                                                                            'noise_floor': -88.8,
                                                                                                                                            'rssi': -70.8,
                                                                                                                                            'rx_link_rate': '88000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '164000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '6897',
                                                                                                                                            'mac_address': '20:b5:c6:f9:d1:09',
                                                                                                                                            'noise_floor': -91.3,
                                                                                                                                            'rssi': -65.8,
                                                                                                                                            'rx_link_rate': '146000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 25.5,
                                                                                                                                            'tx_link_rate': '199000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1693',
                                                                                                                                            'mac_address': '20:b5:c6:f8:c7:0e',
                                                                                                                                            'noise_floor': -88.1,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '160000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 30.1,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '6923',
                                                                                                                                            'mac_address': '20:b5:c6:1e:3a:10',
                                                                                                                                            'noise_floor': -90.4,
                                                                                                                                            'rssi': -61.6,
                                                                                                                                            'rx_link_rate': '156500000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 28.8,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '8602',
                                                                                                                                            'mac_address': '20:b5:c6:f9:f4:99',
                                                                                                                                            'noise_floor': -85.7,
                                                                                                                                            'rssi': -55.1,
                                                                                                                                            'rx_link_rate': '176000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 30.6,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '1742',
                                                                                                                                            'mac_address': '20:b5:c6:fa:f5:22',
                                                                                                                                            'noise_floor': -88.1,
                                                                                                                                            'rssi': -56.6,
                                                                                                                                            'rx_link_rate': '150500000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 31.5,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '6861',
                                                                                                                                            'mac_address': '20:b5:c6:f0:79:6d',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '103500000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 23.9,
                                                                                                                                            'tx_link_rate': '118000000',
                                                                                                                                            'tx_mcs': 4}]}],
                                                                                        'tx_power': 13}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '#CampComm-25'}],
                                                              'type': 6}],
                                'manufacturer': 'Mimosa',
                                'model': 'A5c-2',
                                'poller_hash': 'ILXGJC17',
                                'serial_number': '2184952791',
                                'sw_version': '2.12.0',
                                'system_mac_address': '20:b5:c6:25:6d:f0',
                                'temperature': 21.0,
                                'uptime': '2504443'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2008969268',
                                                                       'in_ucast_pkts': '74256681',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2008969268',
                                                                                                'in_ucast_pkts': '74256681',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '66',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2271673688',
                                                                                                'out_ucast_pkts': '18175158'}],
                                                                       'mac_address': '20:b5:c6:f7:fa:86',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '66',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2271673688',
                                                                       'out_ucast_pkts': '18175158',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '164000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1776',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -92.8,
                                                                                                                                                     'rssi': -71.95,
                                                                                                                                                     'rx_link_rate': '164000000',
                                                                                                                                                     'snr': 20.85,
                                                                                                                                                     'tx_link_rate': '88000000'}]}],
                                                                                                 'tx_link_rate': '88000000',
                                                                                                 'tx_power': 2}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '180000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2041723',
                                                                       'in_octets': '2198931698',
                                                                       'in_ucast_pkts': '16176947',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:f9:03:7c',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2374568962',
                                                                       'out_ucast_pkts': '74278258',
                                                                       'poller_hash': '8SC1xvf6',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.67',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '777-mimosa_muskie',
                                         'poller_hash': 'ILXG9/qG',
                                         'serial_number': '3118526989',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:f9:03:7c',
                                         'temperature': 35.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '3',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3317686156',
                                                                       'in_ucast_pkts': '242956408',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '3',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3317686156',
                                                                                                'in_ucast_pkts': '242956408',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '84',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2187624002',
                                                                                                'out_ucast_pkts': '70211633'}],
                                                                       'mac_address': '20:b5:c6:f9:d1:09',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '84',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2187624002',
                                                                       'out_ucast_pkts': '70211633',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '199000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6897',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -92.9,
                                                                                                                                                     'rssi': -66.25,
                                                                                                                                                     'rx_link_rate': '199000000',
                                                                                                                                                     'snr': 26.65,
                                                                                                                                                     'tx_link_rate': '146000000'}]}],
                                                                                                 'tx_link_rate': '146000000',
                                                                                                 'tx_power': 7}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '300000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8574974',
                                                                       'in_octets': '2042871474',
                                                                       'in_ucast_pkts': '62278856',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fb:e8:24',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '288573597',
                                                                       'out_ucast_pkts': '243167310',
                                                                       'poller_hash': '8SC1xvnR',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.87',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '971-mimosa_walleye',
                                         'poller_hash': 'ILXG+dEJ',
                                         'serial_number': '3118729930',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:fb:e8:24',
                                         'temperature': 30.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1705258315',
                                                                       'in_ucast_pkts': '54346479',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '1',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1705258315',
                                                                                                'in_ucast_pkts': '54346479',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '65',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1679718112',
                                                                                                'out_ucast_pkts': '14047289'}],
                                                                       'mac_address': '20:b5:c6:f8:c7:0e',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '65',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1679718112',
                                                                       'out_ucast_pkts': '14047289',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1693',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -93.2,
                                                                                                                                                     'rssi': -60.45,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 32.75,
                                                                                                                                                     'tx_link_rate': '160000000'}]}],
                                                                                                 'tx_link_rate': '160000000',
                                                                                                 'tx_power': 7}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '360000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '41',
                                                                       'in_octets': '1623047543',
                                                                       'in_ucast_pkts': '13990266',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fa:de:c1',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1987417351',
                                                                       'out_ucast_pkts': '54348371',
                                                                       'poller_hash': '8SC1xvjH',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.93',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '954-mimosa_muskie',
                                         'poller_hash': 'ILXG+McO',
                                         'serial_number': '3135045051',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:fa:de:c1',
                                         'temperature': 85.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '5',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '520506934',
                                                                       'in_ucast_pkts': '182413167',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '5',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '520506934',
                                                                                                'in_ucast_pkts': '182413167',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '84',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2773257374',
                                                                                                'out_ucast_pkts': '17457359'}],
                                                                       'mac_address': '20:b5:c6:1e:3a:10',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '84',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2773257374',
                                                                       'out_ucast_pkts': '17457359',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6923',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -92.5,
                                                                                                                                                     'rssi': -63.8,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 28.7,
                                                                                                                                                     'tx_link_rate': '156500000'}]}],
                                                                                                 'tx_link_rate': '156500000',
                                                                                                 'tx_power': 7}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '304000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2472625056',
                                                                       'in_ucast_pkts': '17236777',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:1e:d3:dd',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1544047926',
                                                                       'out_ucast_pkts': '182617339',
                                                                       'poller_hash': '8SC1xh46',
                                                                       'speed': '100000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.33',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '299-Minnow',
                                         'poller_hash': 'ILXGHjoQ',
                                         'serial_number': '3125114916',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:1e:d3:dd',
                                         'temperature': 86.0},
                                 {       'errors': [{'snmp_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'links': [       {       'mac_address': '20:b5:c6:24:2d:7b'}],
                                                                       'mac_address': '20:b5:c6:f9:f4:99',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '8602',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'tx_link_rate': '176000000'}]}],
                                                                                                 'tx_link_rate': '176000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth1',
                                                                       'oper_up': True,
                                                                       'poller_hash': '8SC1xvn0'}],
                                         'management_ip': '10.0.7.94',
                                         'manufacturer': 'Mimosa',
                                         'name': '1176-Minnow',
                                         'poller_hash': 'ILXG+fSZ',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '2.12.0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3724578501',
                                                                       'in_ucast_pkts': '28915183',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '1',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3724578501',
                                                                                                'in_ucast_pkts': '28915183',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '71',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '310856509',
                                                                                                'out_ucast_pkts': '712869'}],
                                                                       'mac_address': '20:b5:c6:fa:f5:22',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '71',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '310856509',
                                                                       'out_ucast_pkts': '712869',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '200000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1742',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -93.4,
                                                                                                                                                     'rssi': -59.95,
                                                                                                                                                     'rx_link_rate': '200000000',
                                                                                                                                                     'snr': 33.45,
                                                                                                                                                     'tx_link_rate': '150500000'}]}],
                                                                                                 'tx_link_rate': '150500000',
                                                                                                 'tx_power': 7}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '300000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '335',
                                                                       'in_octets': '226921441',
                                                                       'in_ucast_pkts': '579936',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:ee:63',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3906646991',
                                                                       'out_ucast_pkts': '28925823',
                                                                       'poller_hash': '8SC1xvr1',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.49',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '1117-mimosa_walleye',
                                         'poller_hash': 'ILXG+vUi',
                                         'serial_number': '3104132380',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:fc:ee:63',
                                         'temperature': 35.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2239858670',
                                                                       'in_ucast_pkts': '514394690',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2239858670',
                                                                                                'in_ucast_pkts': '514394690',
                                                                                                'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '69',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1423723795',
                                                                                                'out_ucast_pkts': '164463452'}],
                                                                       'mac_address': '20:b5:c6:f0:79:6d',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '69',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1423723795',
                                                                       'out_ucast_pkts': '164463452',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 8000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5670,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '118000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6861',
                                                                                                                                                     'mac_address': '20:b5:c6:24:2d:7b',
                                                                                                                                                     'noise_floor': -89.9,
                                                                                                                                                     'rssi': -64.3,
                                                                                                                                                     'rx_link_rate': '118000000',
                                                                                                                                                     'snr': 25.6,
                                                                                                                                                     'tx_link_rate': '103500000'}]}],
                                                                                                 'tx_link_rate': '103500000',
                                                                                                 'tx_power': 2}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '#CampComm-25'}],
                                                                       'speed': '193000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7326983',
                                                                       'in_octets': '1451174075',
                                                                       'in_ucast_pkts': '159180587',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:f6:fe:65',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '295725631',
                                                                       'out_ucast_pkts': '514583960',
                                                                       'poller_hash': '8SC1xvB5',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.0.7.60',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': '102-mimosa_walleye',
                                         'poller_hash': 'ILXG8Hlt',
                                         'serial_number': '3103570689',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.12.0',
                                         'system_mac_address': '20:b5:c6:f6:fe:65',
                                         'temperature': 32.0}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mimosa_a5_A5c_2_2_14_0_01(self):
        obj = self.run_data("mimosa.a5.A5c-2.2.14.0.01")
        exp_info = {
                'model': 'A5c-2',
                'rf_chan_width': 40,
                'rf_freq': 5330,
                'rf_tx_power': 24,
                'sta_count': 15,
                'sw_version': '2.14.0',
                'vendor': 'Mimosa'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': 346704578,
                'dl_rf_packets': 3297500998,
                'temperature': -3.0,
                'ul_noise_floor': None,
                'ul_rf_bytes': 2327310008,
                'ul_rf_packets': 1266437288
        }
        exp_sta_stats = {
                '20:b5:c6:13:5d:e1': {       'alt_macs': {'20:b5:c6:14:dd:8d'},
                                             'dev_macs': {       '01:00:5e:00:90:01',
                                                                 '01:00:5e:01:01:01',
                                                                 '20:b5:c6:13:5d:e1'},
                                             'dl_link_rate': 169000000,
                                             'dl_noise_floor': -92.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -75.55,
                                             'dl_snr': 16.95,
                                             'ip_address': '10.100.50.14',
                                             'mac_address': '20:b5:c6:13:5d:e1',
                                             'name': 'June_Lovelace',
                                             'temperature': None,
                                             'ul_link_rate': 132000000,
                                             'ul_noise_floor': -84.19999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.1,
                                             'ul_snr': 15.1},
                '20:b5:c6:18:e8:22': {       'alt_macs': {'20:b5:c6:19:aa:86'},
                                             'dev_macs': {'b0:19:21:09:43:9d'},
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': -86.60000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -69.9,
                                             'dl_snr': 16.7,
                                             'ip_address': '10.100.50.6',
                                             'mac_address': '20:b5:c6:18:e8:22',
                                             'name': 'Darla_Lovelace',
                                             'temperature': None,
                                             'ul_link_rate': 201000000,
                                             'ul_noise_floor': -89.69999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65.8,
                                             'ul_snr': 23.9},
                '20:b5:c6:18:e9:15': {       'alt_macs': {'20:b5:c6:19:b7:8c'},
                                             'dev_macs': {'20:b5:c6:18:e9:15'},
                                             'dl_link_rate': 208000000,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -71.75,
                                             'dl_snr': 21.25,
                                             'ip_address': '10.100.50.50',
                                             'mac_address': '20:b5:c6:18:e9:15',
                                             'name': 'Devon_Drinnon',
                                             'temperature': None,
                                             'ul_link_rate': 157000000,
                                             'ul_noise_floor': -87.5,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.2,
                                             'ul_snr': 19.3},
                '20:b5:c6:18:fb:06': {       'alt_macs': {'20:b5:c6:19:b8:d4'},
                                             'dev_macs': {'01:00:5e:7f:ff:fb'},
                                             'dl_link_rate': 83000000,
                                             'dl_noise_floor': -91.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -64.8,
                                             'dl_snr': 26.7,
                                             'ip_address': '10.100.50.4',
                                             'mac_address': '20:b5:c6:18:fb:06',
                                             'name': 'Kim_Miller',
                                             'temperature': None,
                                             'ul_link_rate': 290000000,
                                             'ul_noise_floor': -86.80000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.2,
                                             'ul_snr': 24.6},
                '20:b5:c6:1a:b7:59': {       'alt_macs': {'20:b5:c6:1d:74:d9'},
                                             'dev_macs': {       '20:b5:c6:1a:b7:59',
                                                                 '33:33:00:00:00:0c',
                                                                 '60:32:b1:30:c3:86'},
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': -90.1,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -55.45,
                                             'dl_snr': 34.65,
                                             'ip_address': '10.100.50.18',
                                             'mac_address': '20:b5:c6:1a:b7:59',
                                             'name': 'Holly_Trout',
                                             'temperature': None,
                                             'ul_link_rate': 319000000,
                                             'ul_noise_floor': -81.9,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.8,
                                             'ul_snr': 29.1},
                '20:b5:c6:1c:e9:ae': {       'alt_macs': {'20:b5:c6:1d:20:8f'},
                                             'dev_macs': {'20:b5:c6:1c:e9:ae'},
                                             'dl_link_rate': 200000000,
                                             'dl_noise_floor': -89.3,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -61.35,
                                             'dl_snr': 27.95,
                                             'ip_address': '10.100.50.12',
                                             'mac_address': '20:b5:c6:1c:e9:ae',
                                             'name': 'Tate_Beer_2904',
                                             'temperature': None,
                                             'ul_link_rate': 264000000,
                                             'ul_noise_floor': -81.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.6,
                                             'ul_snr': 24.8},
                '20:b5:c6:1c:ed:1f': {       'alt_macs': {'20:b5:c6:1d:20:a7'},
                                             'dev_macs': {       '01:00:5e:00:01:bb',
                                                                 '20:b5:c6:1c:ed:1f'},
                                             'dl_link_rate': 171000000,
                                             'dl_noise_floor': -88.1,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -64.5,
                                             'dl_snr': 23.6,
                                             'ip_address': '10.100.50.34',
                                             'mac_address': '20:b5:c6:1c:ed:1f',
                                             'name': 'Bev_Johnson',
                                             'temperature': None,
                                             'ul_link_rate': 225000000,
                                             'ul_noise_floor': -82.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.2,
                                             'ul_snr': 22.8},
                '20:b5:c6:1d:05:21': {       'alt_macs': {'20:b5:c6:1d:9e:d7'},
                                             'dev_macs': None,
                                             'dl_link_rate': 170000000,
                                             'dl_noise_floor': -88.8,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -63.75,
                                             'dl_snr': 25.05,
                                             'ip_address': '10.100.50.36',
                                             'mac_address': '20:b5:c6:1d:05:21',
                                             'name': 'Robert_Irwin',
                                             'temperature': None,
                                             'ul_link_rate': 171000000,
                                             'ul_noise_floor': -78.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57.7,
                                             'ul_snr': 20.3},
                '20:b5:c6:1e:34:53': {       'alt_macs': {'20:b5:c6:1e:ca:37'},
                                             'dev_macs': {       '20:b5:c6:1e:34:53',
                                                                 '84:d8:1b:c4:f9:83'},
                                             'dl_link_rate': 226000000,
                                             'dl_noise_floor': -90.8,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -65.5,
                                             'dl_snr': 25.3,
                                             'ip_address': '10.100.50.10',
                                             'mac_address': '20:b5:c6:1e:34:53',
                                             'name': 'Debra_Stidham',
                                             'temperature': None,
                                             'ul_link_rate': 230000000,
                                             'ul_noise_floor': -84.30000000000001,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.7,
                                             'ul_snr': 23.6},
                '20:b5:c6:1f:29:1b': {       'alt_macs': {'20:b5:c6:1f:a4:f9'},
                                             'dev_macs': {'c8:9e:43:e3:85:f5'},
                                             'dl_link_rate': 112000000,
                                             'dl_noise_floor': -88.9,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -73.25,
                                             'dl_snr': 15.65,
                                             'ip_address': '10.100.50.16',
                                             'mac_address': '20:b5:c6:1f:29:1b',
                                             'name': 'Lonnie_Campbell',
                                             'temperature': None,
                                             'ul_link_rate': 145000000,
                                             'ul_noise_floor': -85.6,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.2,
                                             'ul_snr': 18.4},
                '20:b5:c6:f0:b6:0a': {       'alt_macs': {'20:b5:c6:f7:aa:4f'},
                                             'dev_macs': {       '00:5f:67:58:93:a5',
                                                                 '20:b5:c6:f0:b6:0a'},
                                             'dl_link_rate': 183000000,
                                             'dl_noise_floor': -85.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -64.7,
                                             'dl_snr': 20.8,
                                             'ip_address': '10.100.50.22',
                                             'mac_address': '20:b5:c6:f0:b6:0a',
                                             'name': 'Wayne_Horton',
                                             'temperature': None,
                                             'ul_link_rate': 226000000,
                                             'ul_noise_floor': -86.2,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.2,
                                             'ul_snr': 26.0},
                '20:b5:c6:f8:53:75': {       'alt_macs': {'20:b5:c6:fa:05:19'},
                                             'dev_macs': {'20:b5:c6:f8:53:75'},
                                             'dl_link_rate': 88000000,
                                             'dl_noise_floor': -89.30000000000001,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -57.2,
                                             'dl_snr': 32.1,
                                             'ip_address': '10.100.50.28',
                                             'mac_address': '20:b5:c6:f8:53:75',
                                             'name': 'Lori_Barnett_2912',
                                             'temperature': None,
                                             'ul_link_rate': 384000000,
                                             'ul_noise_floor': -83.1,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.6,
                                             'ul_snr': 28.5},
                '20:b5:c6:f8:6c:3b': {       'alt_macs': {'20:b5:c6:fa:4b:90'},
                                             'dev_macs': {       '01:00:5e:00:01:3c',
                                                                 '01:00:5e:59:bc:01'},
                                             'dl_link_rate': 180000000,
                                             'dl_noise_floor': -57.099999999999994,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -59.05,
                                             'dl_snr': -1.95,
                                             'ip_address': '10.100.50.40',
                                             'mac_address': '20:b5:c6:f8:6c:3b',
                                             'name': 'Hammon_Coop',
                                             'temperature': None,
                                             'ul_link_rate': 313000000,
                                             'ul_noise_floor': -84.4,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55.5,
                                             'ul_snr': 28.9},
                '20:b5:c6:f9:d3:60': {       'alt_macs': {'20:b5:c6:fc:1d:d1'},
                                             'dev_macs': {       '20:23:51:d9:c5:7d',
                                                                 '20:b5:c6:f9:d3:60'},
                                             'dl_link_rate': 228000000,
                                             'dl_noise_floor': -64.9,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -67.15,
                                             'dl_snr': -2.25,
                                             'ip_address': '10.100.50.42',
                                             'mac_address': '20:b5:c6:f9:d3:60',
                                             'name': 'Kathy_Flick',
                                             'temperature': None,
                                             'ul_link_rate': 236000000,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.7,
                                             'ul_snr': 25.3},
                '20:b5:c6:fb:65:85': {       'alt_macs': {'20:b5:c6:fe:d8:05'},
                                             'dev_macs': {'20:b5:c6:fb:65:85'},
                                             'dl_link_rate': 127000000,
                                             'dl_noise_floor': -89.5,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -69.7,
                                             'dl_snr': 19.8,
                                             'ip_address': '10.100.50.38',
                                             'mac_address': '20:b5:c6:fb:65:85',
                                             'name': 'Ralp_winn',
                                             'temperature': None,
                                             'ul_link_rate': 164000000,
                                             'ul_noise_floor': -85.69999999999999,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.6,
                                             'ul_snr': 19.1}
        }
        exp_ne_msg = {
                'data': {       'gps_sats_tracked': 3,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '14',
                                                              'in_nucast_pkts': '118556',
                                                              'in_octets': '3386011605',
                                                              'in_ucast_pkts': '3272090036',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '20:b5:c6:49:49:f9',
                                                              'mtu': 1500,
                                                              'name': 'eth1_emac1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '517611248',
                                                              'out_ucast_pkts': '1247769536',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '28077',
                                                              'in_nucast_pkts': '885051',
                                                              'in_octets': '2327310008',
                                                              'in_ucast_pkts': '1265552237',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '194',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1945488818',
                                                                                       'in_ucast_pkts': '49754819',
                                                                                       'mac_address': '20:b5:c6:1d:05:21',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '46992',
                                                                                       'out_octets': '2653728724',
                                                                                       'out_ucast_pkts': '224513372'},
                                                                               {       'bridged_mac_addresses': [       '20:23:51:d9:c5:7d',
                                                                                                                        '20:b5:c6:f9:d3:60'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '157',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3222079769',
                                                                                       'in_ucast_pkts': '3496702',
                                                                                       'mac_address': '20:b5:c6:f9:d3:60',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '88236',
                                                                                       'out_octets': '617023529',
                                                                                       'out_ucast_pkts': '1833117'},
                                                                               {       'bridged_mac_addresses': [       '01:00:5e:00:90:01',
                                                                                                                        '01:00:5e:01:01:01',
                                                                                                                        '20:b5:c6:13:5d:e1'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '254',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '4204874330',
                                                                                       'in_ucast_pkts': '9409184',
                                                                                       'mac_address': '20:b5:c6:13:5d:e1',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '163722',
                                                                                       'out_octets': '958748666',
                                                                                       'out_ucast_pkts': '15002014'},
                                                                               {       'bridged_mac_addresses': [       'b0:19:21:09:43:9d'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '202',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1061737146',
                                                                                       'in_ucast_pkts': '49097726',
                                                                                       'mac_address': '20:b5:c6:18:e8:22',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '108030',
                                                                                       'out_octets': '3863474045',
                                                                                       'out_ucast_pkts': '91506239'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:1c:e9:ae'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '282',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '4253807007',
                                                                                       'in_ucast_pkts': '69466378',
                                                                                       'mac_address': '20:b5:c6:1c:e9:ae',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '162387',
                                                                                       'out_octets': '661980889',
                                                                                       'out_ucast_pkts': '136269416'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:f8:53:75'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '193',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '133213273',
                                                                                       'in_ucast_pkts': '85583039',
                                                                                       'mac_address': '20:b5:c6:f8:53:75',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '2',
                                                                                       'out_nucast_pkts': '82548',
                                                                                       'out_octets': '1537037576',
                                                                                       'out_ucast_pkts': '184215996'},
                                                                               {       'bridged_mac_addresses': [       '01:00:5e:00:01:3c',
                                                                                                                        '01:00:5e:59:bc:01'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '253',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1402273693',
                                                                                       'in_ucast_pkts': '110022933',
                                                                                       'mac_address': '20:b5:c6:f8:6c:3b',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '197211',
                                                                                       'out_octets': '2988167060',
                                                                                       'out_ucast_pkts': '263457970'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:fb:65:85'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '108',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '190253893',
                                                                                       'in_ucast_pkts': '635309',
                                                                                       'mac_address': '20:b5:c6:fb:65:85',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '2',
                                                                                       'out_nucast_pkts': '1170',
                                                                                       'out_octets': '1899271330',
                                                                                       'out_ucast_pkts': '1572518'},
                                                                               {       'bridged_mac_addresses': [       '01:00:5e:7f:ff:fb'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '504',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2623262767',
                                                                                       'in_ucast_pkts': '103495619',
                                                                                       'mac_address': '20:b5:c6:18:fb:06',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '10',
                                                                                       'out_nucast_pkts': '171544',
                                                                                       'out_octets': '2384708115',
                                                                                       'out_ucast_pkts': '208624416'},
                                                                               {       'bridged_mac_addresses': [       '00:5f:67:58:93:a5',
                                                                                                                        '20:b5:c6:f0:b6:0a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '181',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3301004664',
                                                                                       'in_ucast_pkts': '7617612',
                                                                                       'mac_address': '20:b5:c6:f0:b6:0a',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '87463',
                                                                                       'out_octets': '2766152491',
                                                                                       'out_ucast_pkts': '15448961'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:1e:34:53',
                                                                                                                        '84:d8:1b:c4:f9:83'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '549',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '4110788740',
                                                                                       'in_ucast_pkts': '12952164',
                                                                                       'mac_address': '20:b5:c6:1e:34:53',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '3',
                                                                                       'out_nucast_pkts': '220354',
                                                                                       'out_octets': '1108319304',
                                                                                       'out_ucast_pkts': '46343660'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:18:e9:15'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '238',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '265523285',
                                                                                       'in_ucast_pkts': '160427282',
                                                                                       'mac_address': '20:b5:c6:18:e9:15',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '206926',
                                                                                       'out_octets': '1281618646',
                                                                                       'out_ucast_pkts': '394709087'},
                                                                               {       'bridged_mac_addresses': [       '20:b5:c6:1a:b7:59',
                                                                                                                        '60:32:b1:30:c3:86'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '261',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2288636654',
                                                                                       'in_ucast_pkts': '37406411',
                                                                                       'mac_address': '20:b5:c6:1a:b7:59',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '2',
                                                                                       'out_nucast_pkts': '220074',
                                                                                       'out_octets': '2235134730',
                                                                                       'out_ucast_pkts': '110292085'},
                                                                               {       'bridged_mac_addresses': [       'c8:9e:43:e3:85:f5'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '568',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3079687797',
                                                                                       'in_ucast_pkts': '13071758',
                                                                                       'mac_address': '20:b5:c6:1f:29:1b',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '219424',
                                                                                       'out_octets': '4287392051',
                                                                                       'out_ucast_pkts': '29707214'},
                                                                               {       'bridged_mac_addresses': [       '01:00:5e:00:01:bb',
                                                                                                                        '20:b5:c6:1c:ed:1f'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '95',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2626552568',
                                                                                       'in_ucast_pkts': '8122697',
                                                                                       'mac_address': '20:b5:c6:1c:ed:1f',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1',
                                                                                       'out_nucast_pkts': '29735',
                                                                                       'out_octets': '2793646113',
                                                                                       'out_ucast_pkts': '23890082'}],
                                                              'mac_address': '20:b5:c6:44:4a:bf',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '181479',
                                                              'out_errors': '143',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '346704578',
                                                              'out_ucast_pkts': '3297500998',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5330,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:1d:05:21',
                                                                                                                                            'noise_floor': -78.0,
                                                                                                                                            'rssi': -57.7,
                                                                                                                                            'rx_link_rate': '171000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 20.3,
                                                                                                                                            'tx_link_rate': '170000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:f9:d3:60',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -63.7,
                                                                                                                                            'rx_link_rate': '236000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 25.3,
                                                                                                                                            'tx_link_rate': '228000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:13:5d:e1',
                                                                                                                                            'noise_floor': -84.2,
                                                                                                                                            'rssi': -69.1,
                                                                                                                                            'rx_link_rate': '132000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'snr': 15.1,
                                                                                                                                            'tx_link_rate': '169000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '4120',
                                                                                                                                            'mac_address': '20:b5:c6:18:e8:22',
                                                                                                                                            'noise_floor': -89.7,
                                                                                                                                            'rssi': -65.8,
                                                                                                                                            'rx_link_rate': '201000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 23.9,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '4119',
                                                                                                                                            'mac_address': '20:b5:c6:1c:e9:ae',
                                                                                                                                            'noise_floor': -81.4,
                                                                                                                                            'rssi': -56.6,
                                                                                                                                            'rx_link_rate': '264000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 24.8,
                                                                                                                                            'tx_link_rate': '200000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:f8:53:75',
                                                                                                                                            'noise_floor': -83.1,
                                                                                                                                            'rssi': -54.6,
                                                                                                                                            'rx_link_rate': '384000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 28.5,
                                                                                                                                            'tx_link_rate': '88000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:f8:6c:3b',
                                                                                                                                            'noise_floor': -84.4,
                                                                                                                                            'rssi': -55.5,
                                                                                                                                            'rx_link_rate': '313000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 28.9,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '150',
                                                                                                                                            'mac_address': '20:b5:c6:fb:65:85',
                                                                                                                                            'noise_floor': -85.7,
                                                                                                                                            'rssi': -66.6,
                                                                                                                                            'rx_link_rate': '164000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 19.1,
                                                                                                                                            'tx_link_rate': '127000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '4118',
                                                                                                                                            'mac_address': '20:b5:c6:18:fb:06',
                                                                                                                                            'noise_floor': -86.8,
                                                                                                                                            'rssi': -62.2,
                                                                                                                                            'rx_link_rate': '290000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 24.6,
                                                                                                                                            'tx_link_rate': '83000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:f0:b6:0a',
                                                                                                                                            'noise_floor': -86.2,
                                                                                                                                            'rssi': -60.2,
                                                                                                                                            'rx_link_rate': '226000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '183000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:1e:34:53',
                                                                                                                                            'noise_floor': -84.3,
                                                                                                                                            'rssi': -60.7,
                                                                                                                                            'rx_link_rate': '230000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 23.6,
                                                                                                                                            'tx_link_rate': '226000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '4119',
                                                                                                                                            'mac_address': '20:b5:c6:18:e9:15',
                                                                                                                                            'noise_floor': -87.5,
                                                                                                                                            'rssi': -68.2,
                                                                                                                                            'rx_link_rate': '157000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 19.3,
                                                                                                                                            'tx_link_rate': '208000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '4121',
                                                                                                                                            'mac_address': '20:b5:c6:1a:b7:59',
                                                                                                                                            'noise_floor': -81.9,
                                                                                                                                            'rssi': -52.8,
                                                                                                                                            'rx_link_rate': '319000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 29.1,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '4118',
                                                                                                                                            'mac_address': '20:b5:c6:1f:29:1b',
                                                                                                                                            'noise_floor': -85.6,
                                                                                                                                            'rssi': -67.2,
                                                                                                                                            'rx_link_rate': '145000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 18.4,
                                                                                                                                            'tx_link_rate': '112000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '4118',
                                                                                                                                            'mac_address': '20:b5:c6:1c:ed:1f',
                                                                                                                                            'noise_floor': -82.0,
                                                                                                                                            'rssi': -59.2,
                                                                                                                                            'rx_link_rate': '225000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 22.8,
                                                                                                                                            'tx_link_rate': '171000000',
                                                                                                                                            'tx_mcs': 4}]}],
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '100 '
                                                                                                 '50'}],
                                                              'type': 6}],
                                'manufacturer': 'Mimosa',
                                'model': 'A5c-2',
                                'poller_hash': 'ILXGREq/',
                                'serial_number': '2184934120',
                                'sw_version': '2.14.0',
                                'system_mac_address': '20:b5:c6:49:49:f9',
                                'temperature': -3.0,
                                'uptime': '1786338'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '46992',
                                                                       'in_octets': '2653728724',
                                                                       'in_ucast_pkts': '224513372',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '1',
                                                                                                'in_nucast_pkts': '46992',
                                                                                                'in_octets': '2653728724',
                                                                                                'in_ucast_pkts': '224513372',
                                                                                                'mac_address': '20:b5:c6:44:4a:bf',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '194',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1945488818',
                                                                                                'out_ucast_pkts': '49754819'}],
                                                                       'mac_address': '20:b5:c6:1d:05:21',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '194',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1945488818',
                                                                       'out_ucast_pkts': '49754819',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5330,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '170000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4121',
                                                                                                                                                     'mac_address': '20:b5:c6:44:4a:bf',
                                                                                                                                                     'noise_floor': -88.8,
                                                                                                                                                     'rssi': -63.75,
                                                                                                                                                     'rx_link_rate': '170000000',
                                                                                                                                                     'snr': 25.05,
                                                                                                                                                     'tx_link_rate': '171000000'}]}],
                                                                                                 'tx_link_rate': '171000000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '100 '
                                                                                                          '50'}],
                                                                       'speed': '168000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4340',
                                                                       'in_octets': '713769606',
                                                                       'in_ucast_pkts': '49278682',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:1d:9e:d7',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3459657902',
                                                                       'out_ucast_pkts': '224146955',
                                                                       'poller_hash': '8SC1xh0F',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.100.50.36',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': 'Robert_Irwin',
                                         'poller_hash': 'ILXGHQUh',
                                         'serial_number': '3129402890',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.14.0',
                                         'system_mac_address': '20:b5:c6:1d:9e:d7',
                                         'temperature': 21.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '88236',
                                                                       'in_octets': '617023529',
                                                                       'in_ucast_pkts': '1833117',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '88236',
                                                                                                'in_octets': '617023529',
                                                                                                'in_ucast_pkts': '1833117',
                                                                                                'mac_address': '20:b5:c6:44:4a:bf',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '157',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3222079769',
                                                                                                'out_ucast_pkts': '3496702'}],
                                                                       'mac_address': '20:b5:c6:f9:d3:60',
                                                                       'mtu': 1500,
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '157',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3222079769',
                                                                       'out_ucast_pkts': '3496702',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5330,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '228000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4121',
                                                                                                                                                     'mac_address': '20:b5:c6:44:4a:bf',
                                                                                                                                                     'noise_floor': -64.9,
                                                                                                                                                     'rssi': -67.15,
                                                                                                                                                     'rx_link_rate': '228000000',
                                                                                                                                                     'snr': -2.25,
                                                                                                                                                     'tx_link_rate': '236000000'}]}],
                                                                                                 'tx_link_rate': '236000000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '100 '
                                                                                                          '50'}],
                                                                       'speed': '180000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2986731212',
                                                                       'in_ucast_pkts': '3052785',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '20:b5:c6:fc:1d:d1',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1_emac1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '462567154',
                                                                       'out_ucast_pkts': '1314710',
                                                                       'poller_hash': '8SC1xvnT',
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.100.50.42',
                                         'manufacturer': 'Mimosa',
                                         'model': 'C5x',
                                         'name': 'Kathy_Flick',
                                         'poller_hash': 'ILXG+dNg',
                                         'serial_number': '3132388001',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.14.0',
                                         'system_mac_address': '20:b5:c6:fc:1d:d1',
                                         'temperature': 19.0},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '163722',
                                                                       'in_octets': '958748666',
                                                                       'in_ucast_pkts': '15002014',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '163722',
                                                                                                'in_octets': '958748666',
                                                                                                'in_ucast_pkts': '150