import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_vecima_vistamax_OBR3500_4_7_2RC14_01(self):
        obj = self.run_data("vecima.vistamax.OBR3500.4.7.2RC14.01")
        exp_info = {
                'model': 'OBR3500',
                'sta_count': 21,
                'sw_version': '4.7.2RC14',
                'vendor': 'Vecima'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:18:48:00:96:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:96:26',
                                             'name': None},
                '00:18:48:00:9c:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9c:9f',
                                             'name': None},
                '00:18:48:00:9e:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9e:92',
                                             'name': None},
                '00:18:48:00:9e:f6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9e:f6',
                                             'name': None},
                '00:18:48:00:9f:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9f:38',
                                             'name': None},
                '00:18:48:00:9f:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9f:3a',
                                             'name': None},
                '00:18:48:00:9f:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:9f:40',
                                             'name': None},
                '00:18:48:00:a5:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a5:7d',
                                             'name': None},
                '00:18:48:00:a5:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a5:b2',
                                             'name': None},
                '00:18:48:00:a5:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a5:e4',
                                             'name': None},
                '00:18:48:00:a5:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a5:f8',
                                             'name': None},
                '00:18:48:00:a7:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a7:1f',
                                             'name': None},
                '00:18:48:00:a9:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a9:ba',
                                             'name': None},
                '00:18:48:00:a9:c1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a9:c1',
                                             'name': None},
                '00:18:48:00:a9:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:a9:ec',
                                             'name': None},
                '00:18:48:00:ac:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:ac:af',
                                             'name': None},
                '00:18:48:00:c0:45': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:00:c0:45',
                                             'name': None},
                '00:18:48:01:55:f7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:01:55:f7',
                                             'name': None},
                '00:18:48:01:74:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:01:74:57',
                                             'name': None},
                '00:18:48:01:74:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:01:74:58',
                                             'name': None},
                '00:18:48:01:75:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:18:48:01:75:5f',
                                             'name': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '5693320191985',
                                                              'in_ucast_pkts': '4351965595',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:18:48:00:66:64',
                                                              'mtu': 1508,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '405340886728',
                                                              'out_ucast_pkts': '2710306493',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1482323353743',
                                                              'in_ucast_pkts': '1203027095691',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:18:48:00:96:26'},
                                                                               {       'mac_address': '00:18:48:00:9c:9f'},
                                                                               {       'mac_address': '00:18:48:00:9e:92'},
                                                                               {       'mac_address': '00:18:48:00:9e:f6'},
                                                                               {       'mac_address': '00:18:48:00:9f:38'},
                                                                               {       'mac_address': '00:18:48:00:9f:3a'},
                                                                               {       'mac_address': '00:18:48:00:9f:40'},
                                                                               {       'mac_address': '00:18:48:00:a5:7d'},
                                                                               {       'mac_address': '00:18:48:00:a5:b2'},
                                                                               {       'mac_address': '00:18:48:00:a5:e4'},
                                                                               {       'mac_address': '00:18:48:00:a5:f8'},
                                                                               {       'mac_address': '00:18:48:00:a7:1f'},
                                                                               {       'mac_address': '00:18:48:00:a9:ba'},
                                                                               {       'mac_address': '00:18:48:00:a9:c1'},
                                                                               {       'mac_address': '00:18:48:00:a9:ec'},
                                                                               {       'mac_address': '00:18:48:00:ac:af'},
                                                                               {       'mac_address': '00:18:48:00:c0:45'},
                                                                               {       'mac_address': '00:18:48:01:74:57'},
                                                                               {       'mac_address': '00:18:48:01:74:58'},
                                                                               {       'mac_address': '00:18:48:01:75:5f'},
                                                                               {       'mac_address': '00:18:48:01:55:f7'}],
                                                              'mac_address': '00:18:48:00:66:65',
                                                              'mtu': 1508,
                                                              'name': 'wimax0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11867772647455',
                                                              'out_ucast_pkts': '1195370709350',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:18:48:00:96:26'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9c:9f'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9e:92'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9e:f6'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9f:38'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9f:3a'},
                                                                                                                                    {       'mac_address': '00:18:48:00:9f:40'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a5:7d'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a5:b2'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a5:e4'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a5:f8'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a7:1f'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a9:ba'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a9:c1'},
                                                                                                                                    {       'mac_address': '00:18:48:00:a9:ec'},
                                                                                                                                    {       'mac_address': '00:18:48:00:ac:af'},
                                                                                                                                    {       'mac_address': '00:18:48:00:c0:45'},
                                                                                                                                    {       'mac_address': '00:18:48:01:74:57'},
                                                                                                                                    {       'mac_address': '00:18:48:01:74:58'},
                                                                                                                                    {       'mac_address': '00:18:48:01:75:5f'},
                                                                                                                                    {       'mac_address': '00:18:48:01:55:f7'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '10000000',
                                                              'type': 184}],
                                'manufacturer': 'Vecima',
                                'model': 'OBR3500',
                                'poller_hash': 'ABhIAGZl',
                                'sw_version': '4.7.2RC14',
                                'system_mac_address': '00:18:48:00:66:64',
                                'uptime': '6559732'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:96:26',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJYm',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9c:9f',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJyf',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9e:92',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJ6S',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9e:f6',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJ72',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9f:38',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJ84',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9f:3a',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJ86',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:9f:40',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAJ9A',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a5:7d',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKV9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a5:b2',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKWy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a5:e4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKXk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a5:f8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKX4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a7:1f',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKcf',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a9:ba',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKm6',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a9:c1',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKnB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:a9:ec',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKns',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:ac:af',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAKyv',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:00:c0:45',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAMBF',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:01:74:57',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAXRX',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:01:74:58',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAXRY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:01:75:5f',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAXVf',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:18:48:00:66:65'}],
                                                                       'mac_address': '00:18:48:01:55:f7',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:18:48:00:66:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'poller_hash': 'ABhIAVX3',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
