import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestProximStats(DeviceTestCase):
    
    def test_proxim_proxim_Tsunami_MP_8200_BSU_G_v2_6_6_01(self):
        obj = self.run_data("proxim.proxim.Tsunami MP-8200-BSU-G.v2.6.6.01")
        exp_info = {
                'model': 'Tsunami MP-8200-BSU-G',
                'sta_count': 29,
                'sw_version': 'v2.6.6',
                'vendor': 'Proxim'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_packets': None,
                'dl_rf_packets_dropped': None,
                'rf_packets_retransmitted': None,
                'ul_noise_floor': None,
                'ul_rf_packets': None,
                'ul_rf_packets_dropped': None
        }
        exp_sta_stats = {
                '00:20:a6:d3:cc:12': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 61761904,
                                             'dl_rf_packets_dropped': 14161,
                                             'dl_rssi': -63,
                                             'dl_snr': 31,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:d3:cc:12',
                                             'name': 'Davies, Mishiko',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -101,
                                             'ul_rf_packets': 25936362,
                                             'ul_rf_packets_dropped': 1482,
                                             'ul_rssi': -69,
                                             'ul_snr': 32},
                '00:20:a6:f0:cf:ce': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 69936174,
                                             'dl_rf_packets_dropped': 63729,
                                             'dl_rssi': -66,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:cf:ce',
                                             'name': 'Clark, Robert',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 33954565,
                                             'ul_rf_packets_dropped': 1414,
                                             'ul_rssi': -70,
                                             'ul_snr': 29},
                '00:20:a6:f0:d0:5a': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 975833,
                                             'dl_rf_packets_dropped': 5879,
                                             'dl_rssi': -73,
                                             'dl_snr': 21,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:5a',
                                             'name': 'Ingeman, Nels',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 330593,
                                             'ul_rf_packets_dropped': 845,
                                             'ul_rssi': -80,
                                             'ul_snr': 20},
                '00:20:a6:f0:d0:67': {       'dev_macs': None,
                                             'dl_link_rate': 117000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 65687158,
                                             'dl_rf_packets_dropped': 561,
                                             'dl_rssi': -59,
                                             'dl_snr': 35,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:67',
                                             'name': 'Norton, Edward',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 117000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 27753497,
                                             'ul_rf_packets_dropped': 522,
                                             'ul_rssi': -65,
                                             'ul_snr': 35},
                '00:20:a6:f0:d0:d1': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 246758,
                                             'dl_rf_packets_dropped': 4997,
                                             'dl_rssi': -76,
                                             'dl_snr': 18,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:d1',
                                             'name': 'Hartzell, Robert',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 117851,
                                             'ul_rf_packets_dropped': 14,
                                             'ul_rssi': -78,
                                             'ul_snr': 21},
                '00:20:a6:f0:d0:da': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 55474292,
                                             'dl_rf_packets_dropped': 145312,
                                             'dl_rssi': -67,
                                             'dl_snr': 27,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:da',
                                             'name': 'Therrien, Chuck',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 50420643,
                                             'ul_rf_packets_dropped': 5463,
                                             'ul_rssi': -71,
                                             'ul_snr': 28},
                '00:20:a6:f0:d0:f7': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 165037002,
                                             'dl_rf_packets_dropped': 56133,
                                             'dl_rssi': -56,
                                             'dl_snr': 38,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:f7',
                                             'name': 'Ostrom, Kenneth',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 122896987,
                                             'ul_rf_packets_dropped': 13427,
                                             'ul_rssi': -62,
                                             'ul_snr': 38},
                '00:20:a6:f0:d0:fc': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 40251241,
                                             'dl_rf_packets_dropped': 44111,
                                             'dl_rssi': -72,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:fc',
                                             'name': 'Nevin, Betty',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 17274918,
                                             'ul_rf_packets_dropped': 3721,
                                             'ul_rssi': -74,
                                             'ul_snr': 24},
                '00:20:a6:f0:d3:c9': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 104765309,
                                             'dl_rf_packets_dropped': 45455,
                                             'dl_rssi': -64,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d3:c9',
                                             'name': 'Britton John',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 34146107,
                                             'ul_rf_packets_dropped': 2080,
                                             'ul_rssi': -69,
                                             'ul_snr': 30},
                '00:20:a6:f0:d5:2d': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 238479525,
                                             'dl_rf_packets_dropped': 1939648,
                                             'dl_rssi': -65,
                                             'dl_snr': 29,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:2d',
                                             'name': 'Gomez, Andre',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 42215760,
                                             'ul_rf_packets_dropped': 7507,
                                             'ul_rssi': -70,
                                             'ul_snr': 29},
                '00:20:a6:f0:d5:4c': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 148831971,
                                             'dl_rf_packets_dropped': 18836,
                                             'dl_rssi': -69,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:4c',
                                             'name': 'Mcalister Michael',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 52116342,
                                             'ul_rf_packets_dropped': 620,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d5:78': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 33190893,
                                             'dl_rf_packets_dropped': 884,
                                             'dl_rssi': -67,
                                             'dl_snr': 27,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:78',
                                             'name': 'Peters, Fred',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 16008278,
                                             'ul_rf_packets_dropped': 340,
                                             'ul_rssi': -74,
                                             'ul_snr': 25},
                '00:20:a6:f0:d5:84': {       'dev_macs': None,
                                             'dl_link_rate': 13000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 4214227,
                                             'dl_rf_packets_dropped': 2697,
                                             'dl_rssi': -72,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:84',
                                             'name': 'Clark, Toni',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 1561589,
                                             'ul_rf_packets_dropped': 478,
                                             'ul_rssi': -78,
                                             'ul_snr': 21},
                '00:20:a6:f0:d5:87': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 36179178,
                                             'dl_rf_packets_dropped': 24203,
                                             'dl_rssi': -72,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:87',
                                             'name': 'Gibbs, Joe',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 19960647,
                                             'ul_rf_packets_dropped': 465,
                                             'ul_rssi': -79,
                                             'ul_snr': 20},
                '00:20:a6:f0:d5:93': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 71260527,
                                             'dl_rf_packets_dropped': 37205,
                                             'dl_rssi': -62,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:93',
                                             'name': 'Asher, Charlotte',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 29401485,
                                             'ul_rf_packets_dropped': 1672,
                                             'ul_rssi': -70,
                                             'ul_snr': 29},
                '00:20:a6:f0:d5:b1': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 117666043,
                                             'dl_rf_packets_dropped': 20735,
                                             'dl_rssi': -61,
                                             'dl_snr': 33,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:b1',
                                             'name': 'Wright, Angie',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 43711929,
                                             'ul_rf_packets_dropped': 6486,
                                             'ul_rssi': -68,
                                             'ul_snr': 30},
                '00:20:a6:f0:d5:b8': {       'dev_macs': None,
                                             'dl_link_rate': 117000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 152439875,
                                             'dl_rf_packets_dropped': 164081,
                                             'dl_rssi': -59,
                                             'dl_snr': 35,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:b8',
                                             'name': 'Gile, Robert',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 117000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 68555376,
                                             'ul_rf_packets_dropped': 4628,
                                             'ul_rssi': -64,
                                             'ul_snr': 34},
                '00:20:a6:f0:d5:d5': {       'dev_macs': None,
                                             'dl_link_rate': 117000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 244786365,
                                             'dl_rf_packets_dropped': 2816,
                                             'dl_rssi': -60,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:d5',
                                             'name': 'Smith, Stanley Sandra',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 258592691,
                                             'ul_rf_packets_dropped': 4160,
                                             'ul_rssi': -65,
                                             'ul_snr': 35},
                '00:20:a6:f0:d5:da': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 227702331,
                                             'dl_rf_packets_dropped': 48941,
                                             'dl_rssi': -62,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:da',
                                             'name': 'Yesavage, Maria',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 54845799,
                                             'ul_rf_packets_dropped': 1703,
                                             'ul_rssi': -64,
                                             'ul_snr': 34},
                '00:20:a6:f0:d5:de': {       'dev_macs': None,
                                             'dl_link_rate': 26000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 1367395,
                                             'dl_rf_packets_dropped': 591,
                                             'dl_rssi': -75,
                                             'dl_snr': 19,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:de',
                                             'name': 'Yates, Danny & Denise',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 626004,
                                             'ul_rf_packets_dropped': 31,
                                             'ul_rssi': -79,
                                             'ul_snr': 19},
                '00:20:a6:f0:d6:04': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 371688317,
                                             'dl_rf_packets_dropped': 5812,
                                             'dl_rssi': -66,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:04',
                                             'name': 'Ehlers, Judy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 80668688,
                                             'ul_rf_packets_dropped': 1620,
                                             'ul_rssi': -71,
                                             'ul_snr': 29},
                '00:20:a6:f0:d6:0d': {       'dev_macs': None,
                                             'dl_link_rate': 26000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 400797,
                                             'dl_rf_packets_dropped': 503,
                                             'dl_rssi': -79,
                                             'dl_snr': 15,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:0d',
                                             'name': 'Orcutt, Doris & Robert',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 13000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 158131,
                                             'ul_rf_packets_dropped': 4,
                                             'ul_rssi': -79,
                                             'ul_snr': 19},
                '00:20:a6:f0:d6:49': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 1344890,
                                             'dl_rf_packets_dropped': 150206,
                                             'dl_rssi': -72,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:49',
                                             'name': 'Patterson, Nick & Missy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 849990,
                                             'ul_rf_packets_dropped': 99,
                                             'ul_rssi': -75,
                                             'ul_snr': 23},
                '00:20:a6:f0:d6:6c': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 230227704,
                                             'dl_rf_packets_dropped': 20921,
                                             'dl_rssi': -67,
                                             'dl_snr': 27,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:6c',
                                             'name': 'Adkins, Kristina',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 61632317,
                                             'ul_rf_packets_dropped': 6766,
                                             'ul_rssi': -71,
                                             'ul_snr': 29},
                '00:20:a6:f0:d6:6e': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 173260209,
                                             'dl_rf_packets_dropped': 115701,
                                             'dl_rssi': -68,
                                             'dl_snr': 26,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:6e',
                                             'name': 'Mauthan, Jack & Kathy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 35932574,
                                             'ul_rf_packets_dropped': 1519,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d6:c0': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 38775945,
                                             'dl_rf_packets_dropped': 4374,
                                             'dl_rssi': -67,
                                             'dl_snr': 27,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:c0',
                                             'name': 'Simon, Thomas #2',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 19859599,
                                             'ul_rf_packets_dropped': 2484,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d6:cb': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 93175749,
                                             'dl_rf_packets_dropped': 1881,
                                             'dl_rssi': -63,
                                             'dl_snr': 31,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:cb',
                                             'name': 'Shipman, Michelle',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 29910130,
                                             'ul_rf_packets_dropped': 10004,
                                             'ul_rssi': -69,
                                             'ul_snr': 31},
                '00:20:a6:f0:d6:db': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 2645798,
                                             'dl_rf_packets_dropped': 1874,
                                             'dl_rssi': -66,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:db',
                                             'name': 'Vanik, Linda',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 1220121,
                                             'ul_rf_packets_dropped': 585,
                                             'ul_rssi': -74,
                                             'ul_snr': 25},
                '00:20:a6:f6:09:77': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -94,
                                             'dl_rf_packets': 45151969,
                                             'dl_rf_packets_dropped': 1732,
                                             'dl_rssi': -62,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:09:77',
                                             'name': 'McCarthy, Glenda',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 11013550,
                                             'ul_rf_packets_dropped': 183,
                                             'ul_rssi': -66,
                                             'ul_snr': 30}
        }
        exp_ne_msg = {
                'data': {       'elevation': 10.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '162707',
                                                              'in_nucast_pkts': '35615737',
                                                              'in_octets': '539796473',
                                                              'in_ucast_pkts': '409234379',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:20:a6:f0:c6:88',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2711086640',
                                                              'out_ucast_pkts': '3516546971',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_errors': '2493484',
                                                              'in_octets': '2380424505400',
                                                              'in_ucast_pkts': '642269081',
                                                              'links': [       {       'in_discards': '465',
                                                                                       'in_ucast_pkts': '19960647',
                                                                                       'mac_address': '00:20:a6:f0:d5:87',
                                                                                       'out_discards': '24203',
                                                                                       'out_retransmits': '309652',
                                                                                       'out_ucast_pkts': '36179178'},
                                                                               {       'in_discards': '340',
                                                                                       'in_ucast_pkts': '16008278',
                                                                                       'mac_address': '00:20:a6:f0:d5:78',
                                                                                       'out_discards': '884',
                                                                                       'out_retransmits': '24480',
                                                                                       'out_ucast_pkts': '33190893'},
                                                                               {       'in_discards': '6766',
                                                                                       'in_ucast_pkts': '61632317',
                                                                                       'mac_address': '00:20:a6:f0:d6:6c',
                                                                                       'out_discards': '20921',
                                                                                       'out_retransmits': '211430',
                                                                                       'out_ucast_pkts': '230227704'},
                                                                               {       'in_discards': '4628',
                                                                                       'in_ucast_pkts': '68555376',
                                                                                       'mac_address': '00:20:a6:f0:d5:b8',
                                                                                       'out_discards': '164081',
                                                                                       'out_retransmits': '2183859',
                                                                                       'out_ucast_pkts': '152439875'},
                                                                               {       'in_discards': '10004',
                                                                                       'in_ucast_pkts': '29910130',
                                                                                       'mac_address': '00:20:a6:f0:d6:cb',
                                                                                       'out_discards': '1881',
                                                                                       'out_retransmits': '15802',
                                                                                       'out_ucast_pkts': '93175749'},
                                                                               {       'in_discards': '7507',
                                                                                       'in_ucast_pkts': '42215760',
                                                                                       'mac_address': '00:20:a6:f0:d5:2d',
                                                                                       'out_discards': '1939648',
                                                                                       'out_retransmits': '13505562',
                                                                                       'out_ucast_pkts': '238479525'},
                                                                               {       'in_discards': '1672',
                                                                                       'in_ucast_pkts': '29401485',
                                                                                       'mac_address': '00:20:a6:f0:d5:93',
                                                                                       'out_discards': '37205',
                                                                                       'out_retransmits': '756546',
                                                                                       'out_ucast_pkts': '71260527'},
                                                                               {       'in_discards': '2080',
                                                                                       'in_ucast_pkts': '34146107',
                                                                                       'mac_address': '00:20:a6:f0:d3:c9',
                                                                                       'out_discards': '45455',
                                                                                       'out_retransmits': '596024',
                                                                                       'out_ucast_pkts': '104765309'},
                                                                               {       'in_discards': '1703',
                                                                                       'in_ucast_pkts': '54845799',
                                                                                       'mac_address': '00:20:a6:f0:d5:da',
                                                                                       'out_discards': '48941',
                                                                                       'out_retransmits': '669932',
                                                                                       'out_ucast_pkts': '227702331'},
                                                                               {       'in_discards': '1519',
                                                                                       'in_ucast_pkts': '35932574',
                                                                                       'mac_address': '00:20:a6:f0:d6:6e',
                                                                                       'out_discards': '115701',
                                                                                       'out_retransmits': '1755621',
                                                                                       'out_ucast_pkts': '173260209'},
                                                                               {       'in_discards': '6486',
                                                                                       'in_ucast_pkts': '43711929',
                                                                                       'mac_address': '00:20:a6:f0:d5:b1',
                                                                                       'out_discards': '20735',
                                                                                       'out_retransmits': '161641',
                                                                                       'out_ucast_pkts': '117666043'},
                                                                               {       'in_discards': '1414',
                                                                                       'in_ucast_pkts': '33954565',
                                                                                       'mac_address': '00:20:a6:f0:cf:ce',
                                                                                       'out_discards': '63729',
                                                                                       'out_retransmits': '827777',
                                                                                       'out_ucast_pkts': '69936174'},
                                                                               {       'in_discards': '2484',
                                                                                       'in_ucast_pkts': '19859599',
                                                                                       'mac_address': '00:20:a6:f0:d6:c0',
                                                                                       'out_discards': '4374',
                                                                                       'out_retransmits': '40111',
                                                                                       'out_ucast_pkts': '38775945'},
                                                                               {       'in_discards': '99',
                                                                                       'in_ucast_pkts': '849990',
                                                                                       'mac_address': '00:20:a6:f0:d6:49',
                                                                                       'out_discards': '150206',
                                                                                       'out_retransmits': '135556',
                                                                                       'out_ucast_pkts': '1344890'},
                                                                               {       'in_discards': '1620',
                                                                                       'in_ucast_pkts': '80668688',
                                                                                       'mac_address': '00:20:a6:f0:d6:04',
                                                                                       'out_discards': '5812',
                                                                                       'out_retransmits': '43783',
                                                                                       'out_ucast_pkts': '371688317'},
                                                                               {       'in_discards': '183',
                                                                                       'in_ucast_pkts': '11013550',
                                                                                       'mac_address': '00:20:a6:f6:09:77',
                                                                                       'out_discards': '1732',
                                                                                       'out_retransmits': '21392',
                                                                                       'out_ucast_pkts': '45151969'},
                                                                               {       'in_discards': '478',
                                                                                       'in_ucast_pkts': '1561589',
                                                                                       'mac_address': '00:20:a6:f0:d5:84',
                                                                                       'out_discards': '2697',
                                                                                       'out_retransmits': '5748',
                                                                                       'out_ucast_pkts': '4214227'},
                                                                               {       'in_discards': '14',
                                                                                       'in_ucast_pkts': '117851',
                                                                                       'mac_address': '00:20:a6:f0:d0:d1',
                                                                                       'out_discards': '4997',
                                                                                       'out_retransmits': '12415',
                                                                                       'out_ucast_pkts': '246758'},
                                                                               {       'in_discards': '4',
                                                                                       'in_ucast_pkts': '158131',
                                                                                       'mac_address': '00:20:a6:f0:d6:0d',
                                                                                       'out_discards': '503',
                                                                                       'out_retransmits': '3909',
                                                                                       'out_ucast_pkts': '400797'},
                                                                               {       'in_discards': '3721',
                                                                                       'in_ucast_pkts': '17274918',
                                                                                       'mac_address': '00:20:a6:f0:d0:fc',
                                                                                       'out_discards': '44111',
                                                                                       'out_retransmits': '152061',
                                                                                       'out_ucast_pkts': '40251241'},
                                                                               {       'in_discards': '31',
                                                                                       'in_ucast_pkts': '626004',
                                                                                       'mac_address': '00:20:a6:f0:d5:de',
                                                                                       'out_discards': '591',
                                                                                       'out_retransmits': '3227',
                                                                                       'out_ucast_pkts': '1367395'},
                                                                               {       'in_discards': '845',
                                                                                       'in_ucast_pkts': '330593',
                                                                                       'mac_address': '00:20:a6:f0:d0:5a',
                                                                                       'out_discards': '5879',
                                                                                       'out_retransmits': '9921',
                                                                                       'out_ucast_pkts': '975833'},
                                                                               {       'in_discards': '522',
                                                                                       'in_ucast_pkts': '27753497',
                                                                                       'mac_address': '00:20:a6:f0:d0:67',
                                                                                       'out_discards': '561',
                                                                                       'out_retransmits': '16013',
                                                                                       'out_ucast_pkts': '65687158'},
                                                                               {       'in_discards': '13427',
                                                                                       'in_ucast_pkts': '122896987',
                                                                                       'mac_address': '00:20:a6:f0:d0:f7',
                                                                                       'out_discards': '56133',
                                                                                       'out_retransmits': '1002135',
                                                                                       'out_ucast_pkts': '165037002'},
                                                                               {       'in_discards': '5463',
                                                                                       'in_ucast_pkts': '50420643',
                                                                                       'mac_address': '00:20:a6:f0:d0:da',
                                                                                       'out_discards': '145312',
                                                                                       'out_retransmits': '1060868',
                                                                                       'out_ucast_pkts': '55474292'},
                                                                               {       'in_discards': '585',
                                                                                       'in_ucast_pkts': '1220121',
                                                                                       'mac_address': '00:20:a6:f0:d6:db',
                                                                                       'out_discards': '1874',
                                                                                       'out_retransmits': '11433',
                                                                                       'out_ucast_pkts': '2645798'},
                                                                               {       'in_discards': '1482',
                                                                                       'in_ucast_pkts': '25936362',
                                                                                       'mac_address': '00:20:a6:d3:cc:12',
                                                                                       'out_discards': '14161',
                                                                                       'out_retransmits': '145150',
                                                                                       'out_ucast_pkts': '61761904'},
                                                                               {       'in_discards': '620',
                                                                                       'in_ucast_pkts': '52116342',
                                                                                       'mac_address': '00:20:a6:f0:d5:4c',
                                                                                       'out_discards': '18836',
                                                                                       'out_retransmits': '400979',
                                                                                       'out_ucast_pkts': '148831971'},
                                                                               {       'in_discards': '4160',
                                                                                       'in_ucast_pkts': '258592691',
                                                                                       'mac_address': '00:20:a6:f0:d5:d5',
                                                                                       'out_discards': '2816',
                                                                                       'out_retransmits': '65414',
                                                                                       'out_ucast_pkts': '244786365'}],
                                                              'mac_address': '00:0b:6b:b7:1b:d1',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_octets': '18565280077519',
                                                              'out_ucast_pkts': '2335501466',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:20:a6:f0:d5:87',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:78',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:6c',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:b8',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '117000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '117000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:cb',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:2d',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:93',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d3:c9',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:da',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:6e',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:b1',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:cf:ce',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:c0',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:49',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:04',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:09:77',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:84',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '13000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:d1',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:0d',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '13000000',
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '26000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:fc',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:de',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '26000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:5a',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:67',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '117000000',
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '117000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:f7',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:da',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:db',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:d3:cc:12',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:4c',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:d5',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '117000000'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'latitude': 37.4097,
                                'longitude': -121.9171,
                                'manufacturer': 'Proxim',
                                'model': 'Tsunami MP-8200-BSU-G',
                                'poller_hash': 'AAtrtxvR',
                                'sw_version': 'v2.6.6',
                                'system_mac_address': '00:20:a6:f0:c6:88',
                                'uptime': '6813142'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '24203',
                                                                       'in_ucast_pkts': '36179178',
                                                                       'links': [       {       'in_discards': '24203',
                                                                                                'in_ucast_pkts': '36179178',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '465',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '19960647'}],
                                                                       'mac_address': '00:20:a6:f0:d5:87',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '465',
                                                                       'out_ucast_pkts': '19960647',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '465',
                                                                       'in_ucast_pkts': '19960647',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '24203',
                                                                       'out_ucast_pkts': '36179178',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Gibbs, Joe',
                                         'poller_hash': 'ACCm8NWH',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '884',
                                                                       'in_ucast_pkts': '33190893',
                                                                       'links': [       {       'in_discards': '884',
                                                                                                'in_ucast_pkts': '33190893',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '340',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '16008278'}],
                                                                       'mac_address': '00:20:a6:f0:d5:78',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '340',
                                                                       'out_ucast_pkts': '16008278',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '340',
                                                                       'in_ucast_pkts': '16008278',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '884',
                                                                       'out_ucast_pkts': '33190893',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Peters, Fred',
                                         'poller_hash': 'ACCm8NV4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '20921',
                                                                       'in_ucast_pkts': '230227704',
                                                                       'links': [       {       'in_discards': '20921',
                                                                                                'in_ucast_pkts': '230227704',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '6766',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '61632317'}],
                                                                       'mac_address': '00:20:a6:f0:d6:6c',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '6766',
                                                                       'out_ucast_pkts': '61632317',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '6766',
                                                                       'in_ucast_pkts': '61632317',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '20921',
                                                                       'out_ucast_pkts': '230227704',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Adkins, Kristina',
                                         'poller_hash': 'ACCm8NZs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '164081',
                                                                       'in_ucast_pkts': '152439875',
                                                                       'links': [       {       'in_discards': '164081',
                                                                                                'in_ucast_pkts': '152439875',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '4628',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '68555376'}],
                                                                       'mac_address': '00:20:a6:f0:d5:b8',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4628',
                                                                       'out_ucast_pkts': '68555376',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '117000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4628',
                                                                       'in_ucast_pkts': '68555376',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '164081',
                                                                       'out_ucast_pkts': '152439875',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Gile, Robert',
                                         'poller_hash': 'ACCm8NW4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1881',
                                                                       'in_ucast_pkts': '93175749',
                                                                       'links': [       {       'in_discards': '1881',
                                                                                                'in_ucast_pkts': '93175749',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '10004',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '29910130'}],
                                                                       'mac_address': '00:20:a6:f0:d6:cb',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '10004',
                                                                       'out_ucast_pkts': '29910130',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '10004',
                                                                       'in_ucast_pkts': '29910130',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1881',
                                                                       'out_ucast_pkts': '93175749',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Shipman, Michelle',
                                         'poller_hash': 'ACCm8NbL',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1939648',
                                                                       'in_ucast_pkts': '238479525',
                                                                       'links': [       {       'in_discards': '1939648',
                                                                                                'in_ucast_pkts': '238479525',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '7507',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '42215760'}],
                                                                       'mac_address': '00:20:a6:f0:d5:2d',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '7507',
                                                                       'out_ucast_pkts': '42215760',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '7507',
                                                                       'in_ucast_pkts': '42215760',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1939648',
                                                                       'out_ucast_pkts': '238479525',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Gomez, Andre',
                                         'poller_hash': 'ACCm8NUt',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '37205',
                                                                       'in_ucast_pkts': '71260527',
                                                                       'links': [       {       'in_discards': '37205',
                                                                                                'in_ucast_pkts': '71260527',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1672',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '29401485'}],
                                                                       'mac_address': '00:20:a6:f0:d5:93',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1672',
                                                                       'out_ucast_pkts': '29401485',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1672',
                                                                       'in_ucast_pkts': '29401485',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '37205',
                                                                       'out_ucast_pkts': '71260527',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Asher, Charlotte',
                                         'poller_hash': 'ACCm8NWT',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '45455',
                                                                       'in_ucast_pkts': '104765309',
                                                                       'links': [       {       'in_discards': '45455',
                                                                                                'in_ucast_pkts': '104765309',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '2080',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '34146107'}],
                                                                       'mac_address': '00:20:a6:f0:d3:c9',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '2080',
                                                                       'out_ucast_pkts': '34146107',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '2080',
                                                                       'in_ucast_pkts': '34146107',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '45455',
                                                                       'out_ucast_pkts': '104765309',
                                                                       'poller_hash': '8gAgpvDT'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Britton John',
                                         'poller_hash': 'ACCm8NPJ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '48941',
                                                                       'in_ucast_pkts': '227702331',
                                                                       'links': [       {       'in_discards': '48941',
                                                                                                'in_ucast_pkts': '227702331',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1703',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '54845799'}],
                                                                       'mac_address': '00:20:a6:f0:d5:da',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1703',
                                                                       'out_ucast_pkts': '54845799',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1703',
                                                                       'in_ucast_pkts': '54845799',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '48941',
                                                                       'out_ucast_pkts': '227702331',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Yesavage, Maria',
                                         'poller_hash': 'ACCm8NXa',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '115701',
                                                                       'in_ucast_pkts': '173260209',
                                                                       'links': [       {       'in_discards': '115701',
                                                                                                'in_ucast_pkts': '173260209',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1519',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '35932574'}],
                                                                       'mac_address': '00:20:a6:f0:d6:6e',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1519',
                                                                       'out_ucast_pkts': '35932574',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1519',
                                                                       'in_ucast_pkts': '35932574',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '115701',
                                                                       'out_ucast_pkts': '173260209',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Mauthan, Jack & Kathy',
                                         'poller_hash': 'ACCm8NZu',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '20735',
                                                                       'in_ucast_pkts': '117666043',
                                                                       'links': [       {       'in_discards': '20735',
                                                                                                'in_ucast_pkts': '117666043',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '6486',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '43711929'}],
                                                                       'mac_address': '00:20:a6:f0:d5:b1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '6486',
                                                                       'out_ucast_pkts': '43711929',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '6486',
                                                                       'in_ucast_pkts': '43711929',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '20735',
                                                                       'out_ucast_pkts': '117666043',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Wright, Angie',
                                         'poller_hash': 'ACCm8NWx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '63729',
                                                                       'in_ucast_pkts': '69936174',
                                                                       'links': [       {       'in_discards': '63729',
                                                                                                'in_ucast_pkts': '69936174',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1414',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '33954565'}],
                                                                       'mac_address': '00:20:a6:f0:cf:ce',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1414',
                                                                       'out_ucast_pkts': '33954565',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1414',
                                                                       'in_ucast_pkts': '33954565',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '63729',
                                                                       'out_ucast_pkts': '69936174',
                                                                       'poller_hash': '8gAgpvDP'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Clark, Robert',
                                         'poller_hash': 'ACCm8M/O',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4374',
                                                                       'in_ucast_pkts': '38775945',
                                                                       'links': [       {       'in_discards': '4374',
                                                                                                'in_ucast_pkts': '38775945',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '2484',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '19859599'}],
                                                                       'mac_address': '00:20:a6:f0:d6:c0',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '2484',
                                                                       'out_ucast_pkts': '19859599',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '2484',
                                                                       'in_ucast_pkts': '19859599',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '4374',
                                                                       'out_ucast_pkts': '38775945',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Simon, Thomas #2',
                                         'poller_hash': 'ACCm8NbA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '150206',
                                                                       'in_ucast_pkts': '1344890',
                                                                       'links': [       {       'in_discards': '150206',
                                                                                                'in_ucast_pkts': '1344890',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '99',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '849990'}],
                                                                       'mac_address': '00:20:a6:f0:d6:49',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '99',
                                                                       'out_ucast_pkts': '849990',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '99',
                                                                       'in_ucast_pkts': '849990',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '150206',
                                                                       'out_ucast_pkts': '1344890',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Patterson, Nick & Missy',
                                         'poller_hash': 'ACCm8NZJ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '5812',
                                                                       'in_ucast_pkts': '371688317',
                                                                       'links': [       {       'in_discards': '5812',
                                                                                                'in_ucast_pkts': '371688317',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1620',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '80668688'}],
                                                                       'mac_address': '00:20:a6:f0:d6:04',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1620',
                                                                       'out_ucast_pkts': '80668688',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1620',
                                                                       'in_ucast_pkts': '80668688',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '5812',
                                                                       'out_ucast_pkts': '371688317',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Ehlers, Judy',
                                         'poller_hash': 'ACCm8NYE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1732',
                                                                       'in_ucast_pkts': '45151969',
                                                                       'links': [       {       'in_discards': '1732',
                                                                                                'in_ucast_pkts': '45151969',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '183',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '11013550'}],
                                                                       'mac_address': '00:20:a6:f6:09:77',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '183',
                                                                       'out_ucast_pkts': '11013550',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '183',
                                                                       'in_ucast_pkts': '11013550',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1732',
                                                                       'out_ucast_pkts': '45151969',
                                                                       'poller_hash': '8gAgpvYJ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'McCarthy, Glenda',
                                         'poller_hash': 'ACCm9gl3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2697',
                                                                       'in_ucast_pkts': '4214227',
                                                                       'links': [       {       'in_discards': '2697',
                                                                                                'in_ucast_pkts': '4214227',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '478',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '1561589'}],
                                                                       'mac_address': '00:20:a6:f0:d5:84',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '478',
                                                                       'out_ucast_pkts': '1561589',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '13000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '478',
                                                                       'in_ucast_pkts': '1561589',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2697',
                                                                       'out_ucast_pkts': '4214227',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Clark, Toni',
                                         'poller_hash': 'ACCm8NWE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4997',
                                                                       'in_ucast_pkts': '246758',
                                                                       'links': [       {       'in_discards': '4997',
                                                                                                'in_ucast_pkts': '246758',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '14',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '117851'}],
                                                                       'mac_address': '00:20:a6:f0:d0:d1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '14',
                                                                       'out_ucast_pkts': '117851',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -76.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '14',
                                                                       'in_ucast_pkts': '117851',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '4997',
                                                                       'out_ucast_pkts': '246758',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hartzell, Robert',
                                         'poller_hash': 'ACCm8NDR',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '503',
                                                                       'in_ucast_pkts': '400797',
                                                                       'links': [       {       'in_discards': '503',
                                                                                                'in_ucast_pkts': '400797',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '4',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '158131'}],
                                                                       'mac_address': '00:20:a6:f0:d6:0d',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4',
                                                                       'out_ucast_pkts': '158131',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -79.0,
                                                                                                                                                     'rx_link_rate': '26000000',
                                                                                                                                                     'snr': 15.0,
                                                                                                                                                     'tx_link_rate': '13000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4',
                                                                       'in_ucast_pkts': '158131',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '503',
                                                                       'out_ucast_pkts': '400797',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Orcutt, Doris & Robert',
                                         'poller_hash': 'ACCm8NYN',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '44111',
                                                                       'in_ucast_pkts': '40251241',
                                                                       'links': [       {       'in_discards': '44111',
                                                                                                'in_ucast_pkts': '40251241',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '3721',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '17274918'}],
                                                                       'mac_address': '00:20:a6:f0:d0:fc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3721',
                                                                       'out_ucast_pkts': '17274918',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3721',
                                                                       'in_ucast_pkts': '17274918',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '44111',
                                                                       'out_ucast_pkts': '40251241',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Nevin, Betty',
                                         'poller_hash': 'ACCm8ND8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '591',
                                                                       'in_ucast_pkts': '1367395',
                                                                       'links': [       {       'in_discards': '591',
                                                                                                'in_ucast_pkts': '1367395',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '31',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '626004'}],
                                                                       'mac_address': '00:20:a6:f0:d5:de',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '31',
                                                                       'out_ucast_pkts': '626004',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '26000000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '31',
                                                                       'in_ucast_pkts': '626004',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '591',
                                                                       'out_ucast_pkts': '1367395',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Yates, Danny & Denise',
                                         'poller_hash': 'ACCm8NXe',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '5879',
                                                                       'in_ucast_pkts': '975833',
                                                                       'links': [       {       'in_discards': '5879',
                                                                                                'in_ucast_pkts': '975833',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '845',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '330593'}],
                                                                       'mac_address': '00:20:a6:f0:d0:5a',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '845',
                                                                       'out_ucast_pkts': '330593',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 21.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '845',
                                                                       'in_ucast_pkts': '330593',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '5879',
                                                                       'out_ucast_pkts': '975833',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Ingeman, Nels',
                                         'poller_hash': 'ACCm8NBa',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '561',
                                                                       'in_ucast_pkts': '65687158',
                                                                       'links': [       {       'in_discards': '561',
                                                                                                'in_ucast_pkts': '65687158',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '522',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '27753497'}],
                                                                       'mac_address': '00:20:a6:f0:d0:67',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '522',
                                                                       'out_ucast_pkts': '27753497',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '117000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '522',
                                                                       'in_ucast_pkts': '27753497',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '561',
                                                                       'out_ucast_pkts': '65687158',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Norton, Edward',
                                         'poller_hash': 'ACCm8NBn',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '56133',
                                                                       'in_ucast_pkts': '165037002',
                                                                       'links': [       {       'in_discards': '56133',
                                                                                                'in_ucast_pkts': '165037002',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '13427',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '122896987'}],
                                                                       'mac_address': '00:20:a6:f0:d0:f7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '13427',
                                                                       'out_ucast_pkts': '122896987',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '13427',
                                                                       'in_ucast_pkts': '122896987',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '56133',
                                                                       'out_ucast_pkts': '165037002',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Ostrom, Kenneth',
                                         'poller_hash': 'ACCm8ND3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '145312',
                                                                       'in_ucast_pkts': '55474292',
                                                                       'links': [       {       'in_discards': '145312',
                                                                                                'in_ucast_pkts': '55474292',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '5463',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '50420643'}],
                                                                       'mac_address': '00:20:a6:f0:d0:da',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '5463',
                                                                       'out_ucast_pkts': '50420643',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '5463',
                                                                       'in_ucast_pkts': '50420643',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '145312',
                                                                       'out_ucast_pkts': '55474292',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Therrien, Chuck',
                                         'poller_hash': 'ACCm8NDa',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1874',
                                                                       'in_ucast_pkts': '2645798',
                                                                       'links': [       {       'in_discards': '1874',
                                                                                                'in_ucast_pkts': '2645798',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '585',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '1220121'}],
                                                                       'mac_address': '00:20:a6:f0:d6:db',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '585',
                                                                       'out_ucast_pkts': '1220121',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '585',
                                                                       'in_ucast_pkts': '1220121',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1874',
                                                                       'out_ucast_pkts': '2645798',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Vanik, Linda',
                                         'poller_hash': 'ACCm8Nbb',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '14161',
                                                                       'in_ucast_pkts': '61761904',
                                                                       'links': [       {       'in_discards': '14161',
                                                                                                'in_ucast_pkts': '61761904',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '1482',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '25936362'}],
                                                                       'mac_address': '00:20:a6:d3:cc:12',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1482',
                                                                       'out_ucast_pkts': '25936362',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1482',
                                                                       'in_ucast_pkts': '25936362',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '14161',
                                                                       'out_ucast_pkts': '61761904',
                                                                       'poller_hash': '8gAgptPM'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Davies, Mishiko',
                                         'poller_hash': 'ACCm08wS',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '18836',
                                                                       'in_ucast_pkts': '148831971',
                                                                       'links': [       {       'in_discards': '18836',
                                                                                                'in_ucast_pkts': '148831971',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '620',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '52116342'}],
                                                                       'mac_address': '00:20:a6:f0:d5:4c',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '620',
                                                                       'out_ucast_pkts': '52116342',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '620',
                                                                       'in_ucast_pkts': '52116342',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '18836',
                                                                       'out_ucast_pkts': '148831971',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Mcalister Michael',
                                         'poller_hash': 'ACCm8NVM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2816',
                                                                       'in_ucast_pkts': '244786365',
                                                                       'links': [       {       'in_discards': '2816',
                                                                                                'in_ucast_pkts': '244786365',
                                                                                                'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                'out_discards': '4160',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '258592691'}],
                                                                       'mac_address': '00:20:a6:f0:d5:d5',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4160',
                                                                       'out_ucast_pkts': '258592691',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:d1',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4160',
                                                                       'in_ucast_pkts': '258592691',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2816',
                                                                       'out_ucast_pkts': '244786365',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Smith, Stanley Sandra',
                                         'poller_hash': 'ACCm8NXV',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_proxim_proxim_Tsunami_MP_8200_BSU_G_v3_0_1_01(self):
        obj = self.run_data("proxim.proxim.Tsunami MP-8200-BSU-G.v3.0.1.01")
        exp_info = {
                'model': 'Tsunami MP-8200-BSU-G',
                'sta_count': 28,
                'sw_version': 'v3.0.1',
                'vendor': 'Proxim'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_packets': None,
                'dl_rf_packets_dropped': None,
                'rf_packets_retransmitted': None,
                'ul_noise_floor': None,
                'ul_rf_packets': None,
                'ul_rf_packets_dropped': None
        }
        exp_sta_stats = {
                '00:20:a6:f0:cf:eb': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 229119874,
                                             'dl_rf_packets_dropped': 20896,
                                             'dl_rssi': -74,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:cf:eb',
                                             'name': 'KNITE, BRANDY',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 50882130,
                                             'ul_rf_packets_dropped': 4269,
                                             'ul_rssi': -75,
                                             'ul_snr': 23},
                '00:20:a6:f0:d0:31': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 52878250,
                                             'dl_rf_packets_dropped': 488,
                                             'dl_rssi': -66,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:31',
                                             'name': 'Cole, Carl & Verlon',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 17645707,
                                             'ul_rf_packets_dropped': 484,
                                             'ul_rssi': -71,
                                             'ul_snr': 28},
                '00:20:a6:f0:d0:cc': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 27950001,
                                             'dl_rf_packets_dropped': 199,
                                             'dl_rssi': -58,
                                             'dl_snr': 38,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d0:cc',
                                             'name': 'Hammer, Delbert',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 10972775,
                                             'ul_rf_packets_dropped': 112,
                                             'ul_rssi': -62,
                                             'ul_snr': 36},
                '00:20:a6:f0:d1:46': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 213193579,
                                             'dl_rf_packets_dropped': 548,
                                             'dl_rssi': -61,
                                             'dl_snr': 35,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d1:46',
                                             'name': 'Jones, Janet',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 62993943,
                                             'ul_rf_packets_dropped': 3251,
                                             'ul_rssi': -65,
                                             'ul_snr': 35},
                '00:20:a6:f0:d3:fc': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 113269541,
                                             'dl_rf_packets_dropped': 386,
                                             'dl_rssi': -58,
                                             'dl_snr': 38,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d3:fc',
                                             'name': 'Shedd, Shaleigh/Ryan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 65000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 36915126,
                                             'ul_rf_packets_dropped': 403,
                                             'ul_rssi': -62,
                                             'ul_snr': 37},
                '00:20:a6:f0:d4:18': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 259166005,
                                             'dl_rf_packets_dropped': 211,
                                             'dl_rssi': -50,
                                             'dl_snr': 46,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:18',
                                             'name': 'Christina Dedrick',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 96584092,
                                             'ul_rf_packets_dropped': 551,
                                             'ul_rssi': -55,
                                             'ul_snr': 43},
                '00:20:a6:f0:d4:ab': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 109256587,
                                             'dl_rf_packets_dropped': 2888,
                                             'dl_rssi': -64,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:ab',
                                             'name': 'Long, Hawanda',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 55164120,
                                             'ul_rf_packets_dropped': 4005,
                                             'ul_rssi': -72,
                                             'ul_snr': 26},
                '00:20:a6:f0:d4:b1': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 41361556,
                                             'dl_rf_packets_dropped': 20817,
                                             'dl_rssi': -71,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:b1',
                                             'name': 'Hard, Walter',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 15054878,
                                             'ul_rf_packets_dropped': 1953,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d4:e3': {       'dev_macs': None,
                                             'dl_link_rate': 117000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 26330845,
                                             'dl_rf_packets_dropped': 2639,
                                             'dl_rssi': -58,
                                             'dl_snr': 38,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:e3',
                                             'name': 'Hart, Micheal',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 9801843,
                                             'ul_rf_packets_dropped': 123,
                                             'ul_rssi': -59,
                                             'ul_snr': 39},
                '00:20:a6:f0:d4:f2': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 61249615,
                                             'dl_rf_packets_dropped': 17635,
                                             'dl_rssi': -72,
                                             'dl_snr': 24,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:f2',
                                             'name': 'Wright, Stacy ',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 26619974,
                                             'ul_rf_packets_dropped': 3416,
                                             'ul_rssi': -74,
                                             'ul_snr': 24},
                '00:20:a6:f0:d4:fd': {       'dev_macs': None,
                                             'dl_link_rate': 26000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 226831263,
                                             'dl_rf_packets_dropped': 25362,
                                             'dl_rssi': -76,
                                             'dl_snr': 20,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:fd',
                                             'name': 'Root, Coleen',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 72930491,
                                             'ul_rf_packets_dropped': 8864,
                                             'ul_rssi': -77,
                                             'ul_snr': 20},
                '00:20:a6:f0:d5:01': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 272244214,
                                             'dl_rf_packets_dropped': 24186,
                                             'dl_rssi': -74,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:01',
                                             'name': 'Pennington, Paul',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 91833806,
                                             'ul_rf_packets_dropped': 3598,
                                             'ul_rssi': -77,
                                             'ul_snr': 20},
                '00:20:a6:f0:d5:10': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 321541440,
                                             'dl_rf_packets_dropped': 1114512,
                                             'dl_rssi': -71,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:10',
                                             'name': 'Biggs Raeshel',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 71577569,
                                             'ul_rf_packets_dropped': 20871,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d5:11': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 93059894,
                                             'dl_rf_packets_dropped': 1507,
                                             'dl_rssi': -62,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:11',
                                             'name': 'Haywood, Sharon & Lee',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 32921931,
                                             'ul_rf_packets_dropped': 5164,
                                             'ul_rssi': -70,
                                             'ul_snr': 30},
                '00:20:a6:f0:d5:42': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 108504516,
                                             'dl_rf_packets_dropped': 821,
                                             'dl_rssi': -66,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:42',
                                             'name': 'Satoafaiga, Atilia',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 29898548,
                                             'ul_rf_packets_dropped': 3463,
                                             'ul_rssi': -70,
                                             'ul_snr': 29},
                '00:20:a6:f0:d5:83': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 18242826,
                                             'dl_rf_packets_dropped': 3884,
                                             'dl_rssi': -67,
                                             'dl_snr': 29,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:83',
                                             'name': 'Travis, Denise and Hall, Paul',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 4328237,
                                             'ul_rf_packets_dropped': 3129,
                                             'ul_rssi': -74,
                                             'ul_snr': 25},
                '00:20:a6:f0:d5:8f': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 330355,
                                             'dl_rf_packets_dropped': 201,
                                             'dl_rssi': -68,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:8f',
                                             'name': 'Duval, Norm and Linda',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 148265,
                                             'ul_rf_packets_dropped': 24,
                                             'ul_rssi': -74,
                                             'ul_snr': 25},
                '00:20:a6:f0:d5:c2': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 31757974,
                                             'dl_rf_packets_dropped': 2369,
                                             'dl_rssi': -74,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:c2',
                                             'name': 'Hoffman, William & Bobbie',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 16210913,
                                             'ul_rf_packets_dropped': 892,
                                             'ul_rssi': -76,
                                             'ul_snr': 21},
                '00:20:a6:f0:d5:c5': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 487486,
                                             'dl_rf_packets_dropped': 2,
                                             'dl_rssi': -64,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:c5',
                                             'name': 'GV Baptist Church #2',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 505546,
                                             'ul_rf_packets_dropped': 1,
                                             'ul_rssi': -67,
                                             'ul_snr': 32},
                '00:20:a6:f0:d5:d6': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 246869509,
                                             'dl_rf_packets_dropped': 48161,
                                             'dl_rssi': -68,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:d6',
                                             'name': 'Gregory, MCcoy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 54560019,
                                             'ul_rf_packets_dropped': 17019,
                                             'ul_rssi': -75,
                                             'ul_snr': 23},
                '00:20:a6:f0:d6:4b': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 80502185,
                                             'dl_rf_packets_dropped': 3349,
                                             'dl_rssi': -66,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:4b',
                                             'name': 'Dailey, David',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 52646960,
                                             'ul_rf_packets_dropped': 33616,
                                             'ul_rssi': -75,
                                             'ul_snr': 24},
                '00:20:a6:f0:d6:50': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 396526525,
                                             'dl_rf_packets_dropped': 67239,
                                             'dl_rssi': -72,
                                             'dl_snr': 24,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:50',
                                             'name': 'Mabry Stacy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 127888752,
                                             'ul_rf_packets_dropped': 45692,
                                             'ul_rssi': -76,
                                             'ul_snr': 22},
                '00:20:a6:f0:d6:5f': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 27606431,
                                             'dl_rf_packets_dropped': 1094,
                                             'dl_rssi': -71,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:5f',
                                             'name': 'Lowe, Curtis and Susan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 10865621,
                                             'ul_rf_packets_dropped': 754,
                                             'ul_rssi': -74,
                                             'ul_snr': 23},
                '00:20:a6:f0:d6:90': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 1287566,
                                             'dl_rf_packets_dropped': 268,
                                             'dl_rssi': -70,
                                             'dl_snr': 26,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:90',
                                             'name': 'Special Weapons and Things',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 1210924,
                                             'ul_rf_packets_dropped': 51,
                                             'ul_rssi': -73,
                                             'ul_snr': 26},
                '00:20:a6:f0:d6:bd': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 49718921,
                                             'dl_rf_packets_dropped': 761,
                                             'dl_rssi': -62,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:bd',
                                             'name': 'Dowd, Alan and Regina ',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 11758901,
                                             'ul_rf_packets_dropped': 1175,
                                             'ul_rssi': -68,
                                             'ul_snr': 31},
                '00:20:a6:f0:d6:ce': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 60426373,
                                             'dl_rf_packets_dropped': 1518,
                                             'dl_rssi': -64,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:ce',
                                             'name': 'Hlas, Frank & Lisa',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 21054427,
                                             'ul_rf_packets_dropped': 4123,
                                             'ul_rssi': -72,
                                             'ul_snr': 26},
                '00:20:a6:f0:d6:f7': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 10687691,
                                             'dl_rf_packets_dropped': 1237,
                                             'dl_rssi': -64,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:f7',
                                             'name': 'Miller, Scott R',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 2816510,
                                             'ul_rf_packets_dropped': 337,
                                             'ul_rssi': -71,
                                             'ul_snr': 28},
                '00:20:a6:f6:0b:70': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -96,
                                             'dl_rf_packets': 1153198,
                                             'dl_rf_packets_dropped': 9,
                                             'dl_rssi': -59,
                                             'dl_snr': 37,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:0b:70',
                                             'name': 'Scott, Bill',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 411803,
                                             'ul_rf_packets_dropped': 32,
                                             'ul_rssi': -67,
                                             'ul_snr': 29}
        }
        exp_ne_msg = {
                'data': {       'elevation': 10.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '105266',
                                                              'in_nucast_pkts': '703831449',
                                                              'in_octets': '966135621',
                                                              'in_ucast_pkts': '1813008960',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:20:a6:f0:c6:60',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1859732243',
                                                              'out_ucast_pkts': '2640453010',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_errors': '126517852',
                                                              'in_octets': '9954216949916',
                                                              'in_ucast_pkts': '2238426594',
                                                              'links': [       {       'in_discards': '3251',
                                                                                       'in_ucast_pkts': '62993943',
                                                                                       'mac_address': '00:20:a6:f0:d1:46',
                                                                                       'out_discards': '548',
                                                                                       'out_retransmits': '16768',
                                                                                       'out_ucast_pkts': '213193579'},
                                                                               {       'in_discards': '123',
                                                                                       'in_ucast_pkts': '9801843',
                                                                                       'mac_address': '00:20:a6:f0:d4:e3',
                                                                                       'out_discards': '2639',
                                                                                       'out_retransmits': '57106',
                                                                                       'out_ucast_pkts': '26330845'},
                                                                               {       'in_discards': '8864',
                                                                                       'in_ucast_pkts': '72930491',
                                                                                       'mac_address': '00:20:a6:f0:d4:fd',
                                                                                       'out_discards': '25362',
                                                                                       'out_retransmits': '216108',
                                                                                       'out_ucast_pkts': '226831263'},
                                                                               {       'in_discards': '403',
                                                                                       'in_ucast_pkts': '36915126',
                                                                                       'mac_address': '00:20:a6:f0:d3:fc',
                                                                                       'out_discards': '386',
                                                                                       'out_retransmits': '9564',
                                                                                       'out_ucast_pkts': '113269541'},
                                                                               {       'in_discards': '1953',
                                                                                       'in_ucast_pkts': '15054878',
                                                                                       'mac_address': '00:20:a6:f0:d4:b1',
                                                                                       'out_discards': '20817',
                                                                                       'out_retransmits': '170745',
                                                                                       'out_ucast_pkts': '41361556'},
                                                                               {       'in_discards': '1',
                                                                                       'in_ucast_pkts': '505546',
                                                                                       'mac_address': '00:20:a6:f0:d5:c5',
                                                                                       'out_discards': '2',
                                                                                       'out_retransmits': '7',
                                                                                       'out_ucast_pkts': '487486'},
                                                                               {       'in_discards': '3463',
                                                                                       'in_ucast_pkts': '29898548',
                                                                                       'mac_address': '00:20:a6:f0:d5:42',
                                                                                       'out_discards': '821',
                                                                                       'out_retransmits': '7496',
                                                                                       'out_ucast_pkts': '108504516'},
                                                                               {       'in_discards': '1175',
                                                                                       'in_ucast_pkts': '11758901',
                                                                                       'mac_address': '00:20:a6:f0:d6:bd',
                                                                                       'out_discards': '761',
                                                                                       'out_retransmits': '232',
                                                                                       'out_ucast_pkts': '49718921'},
                                                                               {       'in_discards': '4123',
                                                                                       'in_ucast_pkts': '21054427',
                                                                                       'mac_address': '00:20:a6:f0:d6:ce',
                                                                                       'out_discards': '1518',
                                                                                       'out_retransmits': '4876',
                                                                                       'out_ucast_pkts': '60426373'},
                                                                               {       'in_discards': '5164',
                                                                                       'in_ucast_pkts': '32921931',
                                                                                       'mac_address': '00:20:a6:f0:d5:11',
                                                                                       'out_discards': '1507',
                                                                                       'out_retransmits': '56',
                                                                                       'out_ucast_pkts': '93059894'},
                                                                               {       'in_discards': '4269',
                                                                                       'in_ucast_pkts': '50882130',
                                                                                       'mac_address': '00:20:a6:f0:cf:eb',
                                                                                       'out_discards': '20896',
                                                                                       'out_retransmits': '236188',
                                                                                       'out_ucast_pkts': '229119874'},
                                                                               {       'in_discards': '32',
                                                                                       'in_ucast_pkts': '411803',
                                                                                       'mac_address': '00:20:a6:f6:0b:70',
                                                                                       'out_discards': '9',
                                                                                       'out_retransmits': '15',
                                                                                       'out_ucast_pkts': '1153198'},
                                                                               {       'in_discards': '3129',
                                                                                       'in_ucast_pkts': '4328237',
                                                                                       'mac_address': '00:20:a6:f0:d5:83',
                                                                                       'out_discards': '3884',
                                                                                       'out_retransmits': '5642',
                                                                                       'out_ucast_pkts': '18242826'},
                                                                               {       'in_discards': '337',
                                                                                       'in_ucast_pkts': '2816510',
                                                                                       'mac_address': '00:20:a6:f0:d6:f7',
                                                                                       'out_discards': '1237',
                                                                                       'out_retransmits': '30258',
                                                                                       'out_ucast_pkts': '10687691'},
                                                                               {       'in_discards': '112',
                                                                                       'in_ucast_pkts': '10972775',
                                                                                       'mac_address': '00:20:a6:f0:d0:cc',
                                                                                       'out_discards': '199',
                                                                                       'out_retransmits': '5907',
                                                                                       'out_ucast_pkts': '27950001'},
                                                                               {       'in_discards': '51',
                                                                                       'in_ucast_pkts': '1210924',
                                                                                       'mac_address': '00:20:a6:f0:d6:90',
                                                                                       'out_discards': '268',
                                                                                       'out_retransmits': '4812',
                                                                                       'out_ucast_pkts': '1287566'},
                                                                               {       'in_discards': '4005',
                                                                                       'in_ucast_pkts': '55164120',
                                                                                       'mac_address': '00:20:a6:f0:d4:ab',
                                                                                       'out_discards': '2888',
                                                                                       'out_retransmits': '47512',
                                                                                       'out_ucast_pkts': '109256587'},
                                                                               {       'in_discards': '17019',
                                                                                       'in_ucast_pkts': '54560019',
                                                                                       'mac_address': '00:20:a6:f0:d5:d6',
                                                                                       'out_discards': '48161',
                                                                                       'out_retransmits': '208716',
                                                                                       'out_ucast_pkts': '246869509'},
                                                                               {       'in_discards': '20871',
                                                                                       'in_ucast_pkts': '71577569',
                                                                                       'mac_address': '00:20:a6:f0:d5:10',
                                                                                       'out_discards': '1114512',
                                                                                       'out_retransmits': '10973547',
                                                                                       'out_ucast_pkts': '321541440'},
                                                                               {       'in_discards': '754',
                                                                                       'in_ucast_pkts': '10865621',
                                                                                       'mac_address': '00:20:a6:f0:d6:5f',
                                                                                       'out_discards': '1094',
                                                                                       'out_retransmits': '9422',
                                                                                       'out_ucast_pkts': '27606431'},
                                                                               {       'in_discards': '45692',
                                                                                       'in_ucast_pkts': '127888752',
                                                                                       'mac_address': '00:20:a6:f0:d6:50',
                                                                                       'out_discards': '67239',
                                                                                       'out_retransmits': '805515',
                                                                                       'out_ucast_pkts': '396526525'},
                                                                               {       'in_discards': '24',
                                                                                       'in_ucast_pkts': '148265',
                                                                                       'mac_address': '00:20:a6:f0:d5:8f',
                                                                                       'out_discards': '201',
                                                                                       'out_retransmits': '3275',
                                                                                       'out_ucast_pkts': '330355'},
                                                                               {       'in_discards': '33616',
                                                                                       'in_ucast_pkts': '52646960',
                                                                                       'mac_address': '00:20:a6:f0:d6:4b',
                                                                                       'out_discards': '3349',
                                                                                       'out_retransmits': '32381',
                                                                                       'out_ucast_pkts': '80502185'},
                                                                               {       'in_discards': '892',
                                                                                       'in_ucast_pkts': '16210913',
                                                                                       'mac_address': '00:20:a6:f0:d5:c2',
                                                                                       'out_discards': '2369',
                                                                                       'out_retransmits': '44359',
                                                                                       'out_ucast_pkts': '31757974'},
                                                                               {       'in_discards': '3416',
                                                                                       'in_ucast_pkts': '26619974',
                                                                                       'mac_address': '00:20:a6:f0:d4:f2',
                                                                                       'out_discards': '17635',
                                                                                       'out_retransmits': '236688',
                                                                                       'out_ucast_pkts': '61249615'},
                                                                               {       'in_discards': '484',
                                                                                       'in_ucast_pkts': '17645707',
                                                                                       'mac_address': '00:20:a6:f0:d0:31',
                                                                                       'out_discards': '488',
                                                                                       'out_retransmits': '4380',
                                                                                       'out_ucast_pkts': '52878250'},
                                                                               {       'in_discards': '3598',
                                                                                       'in_ucast_pkts': '91833806',
                                                                                       'mac_address': '00:20:a6:f0:d5:01',
                                                                                       'out_discards': '24186',
                                                                                       'out_retransmits': '719658',
                                                                                       'out_ucast_pkts': '272244214'},
                                                                               {       'in_discards': '551',
                                                                                       'in_ucast_pkts': '96584092',
                                                                                       'mac_address': '00:20:a6:f0:d4:18',
                                                                                       'out_discards': '211',
                                                                                       'out_retransmits': '9640',
                                                                                       'out_ucast_pkts': '259166005'}],
                                                              'mac_address': '00:0b:6b:b7:1b:5d',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_octets': '103025579674366',
                                                              'out_ucast_pkts': '803336914',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:20:a6:f0:d1:46',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:e3',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '117000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:fd',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '26000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d3:fc',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '65000000',
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:b1',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:c5',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:42',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:bd',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:ce',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:11',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:cf:eb',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:0b:70',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:83',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:f7',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:cc',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:90',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:ab',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:d6',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:10',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:5f',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:50',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:8f',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:4b',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:c2',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:f2',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d0:31',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:01',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:18',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '130000000'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'latitude': 37.4097,
                                'longitude': -121.9171,
                                'manufacturer': 'Proxim',
                                'model': 'Tsunami MP-8200-BSU-G',
                                'poller_hash': 'AAtrtxtd',
                                'sw_version': 'v3.0.1',
                                'system_mac_address': '00:20:a6:f0:c6:60',
                                'uptime': '38889493'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '548',
                                                                       'in_ucast_pkts': '213193579',
                                                                       'links': [       {       'in_discards': '548',
                                                                                                'in_ucast_pkts': '213193579',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '3251',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '62993943'}],
                                                                       'mac_address': '00:20:a6:f0:d1:46',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3251',
                                                                       'out_ucast_pkts': '62993943',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3251',
                                                                       'in_ucast_pkts': '62993943',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '548',
                                                                       'out_ucast_pkts': '213193579',
                                                                       'poller_hash': '8gAgpvDR'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Jones, Janet',
                                         'poller_hash': 'ACCm8NFG',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2639',
                                                                       'in_ucast_pkts': '26330845',
                                                                       'links': [       {       'in_discards': '2639',
                                                                                                'in_ucast_pkts': '26330845',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '123',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '9801843'}],
                                                                       'mac_address': '00:20:a6:f0:d4:e3',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '123',
                                                                       'out_ucast_pkts': '9801843',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '123',
                                                                       'in_ucast_pkts': '9801843',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2639',
                                                                       'out_ucast_pkts': '26330845',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hart, Micheal',
                                         'poller_hash': 'ACCm8NTj',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '25362',
                                                                       'in_ucast_pkts': '226831263',
                                                                       'links': [       {       'in_discards': '25362',
                                                                                                'in_ucast_pkts': '226831263',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '8864',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '72930491'}],
                                                                       'mac_address': '00:20:a6:f0:d4:fd',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '8864',
                                                                       'out_ucast_pkts': '72930491',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -76.0,
                                                                                                                                                     'rx_link_rate': '26000000',
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '8864',
                                                                       'in_ucast_pkts': '72930491',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '25362',
                                                                       'out_ucast_pkts': '226831263',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Root, Coleen',
                                         'poller_hash': 'ACCm8NT9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '386',
                                                                       'in_ucast_pkts': '113269541',
                                                                       'links': [       {       'in_discards': '386',
                                                                                                'in_ucast_pkts': '113269541',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '403',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '36915126'}],
                                                                       'mac_address': '00:20:a6:f0:d3:fc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '403',
                                                                       'out_ucast_pkts': '36915126',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '65000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '403',
                                                                       'in_ucast_pkts': '36915126',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '386',
                                                                       'out_ucast_pkts': '113269541',
                                                                       'poller_hash': '8gAgpvDT'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Shedd, Shaleigh/Ryan',
                                         'poller_hash': 'ACCm8NP8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '20817',
                                                                       'in_ucast_pkts': '41361556',
                                                                       'links': [       {       'in_discards': '20817',
                                                                                                'in_ucast_pkts': '41361556',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '1953',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '15054878'}],
                                                                       'mac_address': '00:20:a6:f0:d4:b1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1953',
                                                                       'out_ucast_pkts': '15054878',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1953',
                                                                       'in_ucast_pkts': '15054878',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '20817',
                                                                       'out_ucast_pkts': '41361556',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hard, Walter',
                                         'poller_hash': 'ACCm8NSx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2',
                                                                       'in_ucast_pkts': '487486',
                                                                       'links': [       {       'in_discards': '2',
                                                                                                'in_ucast_pkts': '487486',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '1',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '505546'}],
                                                                       'mac_address': '00:20:a6:f0:d5:c5',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1',
                                                                       'out_ucast_pkts': '505546',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1',
                                                                       'in_ucast_pkts': '505546',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2',
                                                                       'out_ucast_pkts': '487486',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'GV Baptist Church #2',
                                         'poller_hash': 'ACCm8NXF',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '821',
                                                                       'in_ucast_pkts': '108504516',
                                                                       'links': [       {       'in_discards': '821',
                                                                                                'in_ucast_pkts': '108504516',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '3463',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '29898548'}],
                                                                       'mac_address': '00:20:a6:f0:d5:42',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3463',
                                                                       'out_ucast_pkts': '29898548',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3463',
                                                                       'in_ucast_pkts': '29898548',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '821',
                                                                       'out_ucast_pkts': '108504516',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Satoafaiga, Atilia',
                                         'poller_hash': 'ACCm8NVC',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '761',
                                                                       'in_ucast_pkts': '49718921',
                                                                       'links': [       {       'in_discards': '761',
                                                                                                'in_ucast_pkts': '49718921',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '1175',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '11758901'}],
                                                                       'mac_address': '00:20:a6:f0:d6:bd',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1175',
                                                                       'out_ucast_pkts': '11758901',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1175',
                                                                       'in_ucast_pkts': '11758901',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '761',
                                                                       'out_ucast_pkts': '49718921',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Dowd, Alan and Regina ',
                                         'poller_hash': 'ACCm8Na9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1518',
                                                                       'in_ucast_pkts': '60426373',
                                                                       'links': [       {       'in_discards': '1518',
                                                                                                'in_ucast_pkts': '60426373',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '4123',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '21054427'}],
                                                                       'mac_address': '00:20:a6:f0:d6:ce',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4123',
                                                                       'out_ucast_pkts': '21054427',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4123',
                                                                       'in_ucast_pkts': '21054427',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1518',
                                                                       'out_ucast_pkts': '60426373',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hlas, Frank & Lisa',
                                         'poller_hash': 'ACCm8NbO',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1507',
                                                                       'in_ucast_pkts': '93059894',
                                                                       'links': [       {       'in_discards': '1507',
                                                                                                'in_ucast_pkts': '93059894',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '5164',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '32921931'}],
                                                                       'mac_address': '00:20:a6:f0:d5:11',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '5164',
                                                                       'out_ucast_pkts': '32921931',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '5164',
                                                                       'in_ucast_pkts': '32921931',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1507',
                                                                       'out_ucast_pkts': '93059894',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Haywood, Sharon & Lee',
                                         'poller_hash': 'ACCm8NUR',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '20896',
                                                                       'in_ucast_pkts': '229119874',
                                                                       'links': [       {       'in_discards': '20896',
                                                                                                'in_ucast_pkts': '229119874',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '4269',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '50882130'}],
                                                                       'mac_address': '00:20:a6:f0:cf:eb',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4269',
                                                                       'out_ucast_pkts': '50882130',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4269',
                                                                       'in_ucast_pkts': '50882130',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '20896',
                                                                       'out_ucast_pkts': '229119874',
                                                                       'poller_hash': '8gAgpvDP'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'KNITE, BRANDY',
                                         'poller_hash': 'ACCm8M/r',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '9',
                                                                       'in_ucast_pkts': '1153198',
                                                                       'links': [       {       'in_discards': '9',
                                                                                                'in_ucast_pkts': '1153198',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '32',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '411803'}],
                                                                       'mac_address': '00:20:a6:f6:0b:70',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '32',
                                                                       'out_ucast_pkts': '411803',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '32',
                                                                       'in_ucast_pkts': '411803',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '9',
                                                                       'out_ucast_pkts': '1153198',
                                                                       'poller_hash': '8gAgpvYL'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Scott, Bill',
                                         'poller_hash': 'ACCm9gtw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '3884',
                                                                       'in_ucast_pkts': '18242826',
                                                                       'links': [       {       'in_discards': '3884',
                                                                                                'in_ucast_pkts': '18242826',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '3129',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '4328237'}],
                                                                       'mac_address': '00:20:a6:f0:d5:83',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3129',
                                                                       'out_ucast_pkts': '4328237',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3129',
                                                                       'in_ucast_pkts': '4328237',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '3884',
                                                                       'out_ucast_pkts': '18242826',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Travis, Denise and Hall, Paul',
                                         'poller_hash': 'ACCm8NWD',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1237',
                                                                       'in_ucast_pkts': '10687691',
                                                                       'links': [       {       'in_discards': '1237',
                                                                                                'in_ucast_pkts': '10687691',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '337',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '2816510'}],
                                                                       'mac_address': '00:20:a6:f0:d6:f7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '337',
                                                                       'out_ucast_pkts': '2816510',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '337',
                                                                       'in_ucast_pkts': '2816510',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1237',
                                                                       'out_ucast_pkts': '10687691',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Miller, Scott R',
                                         'poller_hash': 'ACCm8Nb3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '199',
                                                                       'in_ucast_pkts': '27950001',
                                                                       'links': [       {       'in_discards': '199',
                                                                                                'in_ucast_pkts': '27950001',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '112',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '10972775'}],
                                                                       'mac_address': '00:20:a6:f0:d0:cc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '112',
                                                                       'out_ucast_pkts': '10972775',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '112',
                                                                       'in_ucast_pkts': '10972775',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '199',
                                                                       'out_ucast_pkts': '27950001',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hammer, Delbert',
                                         'poller_hash': 'ACCm8NDM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '268',
                                                                       'in_ucast_pkts': '1287566',
                                                                       'links': [       {       'in_discards': '268',
                                                                                                'in_ucast_pkts': '1287566',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '51',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '1210924'}],
                                                                       'mac_address': '00:20:a6:f0:d6:90',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '51',
                                                                       'out_ucast_pkts': '1210924',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '51',
                                                                       'in_ucast_pkts': '1210924',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '268',
                                                                       'out_ucast_pkts': '1287566',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Special Weapons and Things',
                                         'poller_hash': 'ACCm8NaQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2888',
                                                                       'in_ucast_pkts': '109256587',
                                                                       'links': [       {       'in_discards': '2888',
                                                                                                'in_ucast_pkts': '109256587',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '4005',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '55164120'}],
                                                                       'mac_address': '00:20:a6:f0:d4:ab',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4005',
                                                                       'out_ucast_pkts': '55164120',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4005',
                                                                       'in_ucast_pkts': '55164120',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2888',
                                                                       'out_ucast_pkts': '109256587',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Long, Hawanda',
                                         'poller_hash': 'ACCm8NSr',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '48161',
                                                                       'in_ucast_pkts': '246869509',
                                                                       'links': [       {       'in_discards': '48161',
                                                                                                'in_ucast_pkts': '246869509',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '17019',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '54560019'}],
                                                                       'mac_address': '00:20:a6:f0:d5:d6',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '17019',
                                                                       'out_ucast_pkts': '54560019',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '17019',
                                                                       'in_ucast_pkts': '54560019',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '48161',
                                                                       'out_ucast_pkts': '246869509',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Gregory, MCcoy',
                                         'poller_hash': 'ACCm8NXW',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1114512',
                                                                       'in_ucast_pkts': '321541440',
                                                                       'links': [       {       'in_discards': '1114512',
                                                                                                'in_ucast_pkts': '321541440',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '20871',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '71577569'}],
                                                                       'mac_address': '00:20:a6:f0:d5:10',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '20871',
                                                                       'out_ucast_pkts': '71577569',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '20871',
                                                                       'in_ucast_pkts': '71577569',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1114512',
                                                                       'out_ucast_pkts': '321541440',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Biggs Raeshel',
                                         'poller_hash': 'ACCm8NUQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1094',
                                                                       'in_ucast_pkts': '27606431',
                                                                       'links': [       {       'in_discards': '1094',
                                                                                                'in_ucast_pkts': '27606431',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '754',
                                                                                                'out_retransmits': '1',
                                                                                                'out_ucast_pkts': '10865621'}],
                                                                       'mac_address': '00:20:a6:f0:d6:5f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '754',
                                                                       'out_ucast_pkts': '10865621',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '754',
                                                                       'in_ucast_pkts': '10865621',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1094',
                                                                       'out_ucast_pkts': '27606431',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Lowe, Curtis and Susan',
                                         'poller_hash': 'ACCm8NZf',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '67239',
                                                                       'in_ucast_pkts': '396526525',
                                                                       'links': [       {       'in_discards': '67239',
                                                                                                'in_ucast_pkts': '396526525',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '45692',
                                                                                                'out_retransmits': '1',
                                                                                                'out_ucast_pkts': '127888752'}],
                                                                       'mac_address': '00:20:a6:f0:d6:50',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '45692',
                                                                       'out_ucast_pkts': '127888752',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '45692',
                                                                       'in_ucast_pkts': '127888752',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '67239',
                                                                       'out_ucast_pkts': '396526525',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Mabry Stacy',
                                         'poller_hash': 'ACCm8NZQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '201',
                                                                       'in_ucast_pkts': '330355',
                                                                       'links': [       {       'in_discards': '201',
                                                                                                'in_ucast_pkts': '330355',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '24',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '148265'}],
                                                                       'mac_address': '00:20:a6:f0:d5:8f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '24',
                                                                       'out_ucast_pkts': '148265',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '24',
                                                                       'in_ucast_pkts': '148265',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '201',
                                                                       'out_ucast_pkts': '330355',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Duval, Norm and Linda',
                                         'poller_hash': 'ACCm8NWP',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '3349',
                                                                       'in_ucast_pkts': '80502185',
                                                                       'links': [       {       'in_discards': '3349',
                                                                                                'in_ucast_pkts': '80502185',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '33616',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '52646960'}],
                                                                       'mac_address': '00:20:a6:f0:d6:4b',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '33616',
                                                                       'out_ucast_pkts': '52646960',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '33616',
                                                                       'in_ucast_pkts': '52646960',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '3349',
                                                                       'out_ucast_pkts': '80502185',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Dailey, David',
                                         'poller_hash': 'ACCm8NZL',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2369',
                                                                       'in_ucast_pkts': '31757974',
                                                                       'links': [       {       'in_discards': '2369',
                                                                                                'in_ucast_pkts': '31757974',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '892',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '16210913'}],
                                                                       'mac_address': '00:20:a6:f0:d5:c2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '892',
                                                                       'out_ucast_pkts': '16210913',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '892',
                                                                       'in_ucast_pkts': '16210913',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2369',
                                                                       'out_ucast_pkts': '31757974',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hoffman, William & Bobbie',
                                         'poller_hash': 'ACCm8NXC',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '17635',
                                                                       'in_ucast_pkts': '61249615',
                                                                       'links': [       {       'in_discards': '17635',
                                                                                                'in_ucast_pkts': '61249615',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '3416',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '26619974'}],
                                                                       'mac_address': '00:20:a6:f0:d4:f2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3416',
                                                                       'out_ucast_pkts': '26619974',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3416',
                                                                       'in_ucast_pkts': '26619974',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '17635',
                                                                       'out_ucast_pkts': '61249615',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Wright, Stacy ',
                                         'poller_hash': 'ACCm8NTy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '488',
                                                                       'in_ucast_pkts': '52878250',
                                                                       'links': [       {       'in_discards': '488',
                                                                                                'in_ucast_pkts': '52878250',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '484',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '17645707'}],
                                                                       'mac_address': '00:20:a6:f0:d0:31',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '484',
                                                                       'out_ucast_pkts': '17645707',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '484',
                                                                       'in_ucast_pkts': '17645707',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '488',
                                                                       'out_ucast_pkts': '52878250',
                                                                       'poller_hash': '8gAgpvDQ'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Cole, Carl & Verlon',
                                         'poller_hash': 'ACCm8NAx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '24186',
                                                                       'in_ucast_pkts': '272244214',
                                                                       'links': [       {       'in_discards': '24186',
                                                                                                'in_ucast_pkts': '272244214',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '3598',
                                                                                                'out_retransmits': '1',
                                                                                                'out_ucast_pkts': '91833806'}],
                                                                       'mac_address': '00:20:a6:f0:d5:01',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3598',
                                                                       'out_ucast_pkts': '91833806',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3598',
                                                                       'in_ucast_pkts': '91833806',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '24186',
                                                                       'out_ucast_pkts': '272244214',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Pennington, Paul',
                                         'poller_hash': 'ACCm8NUB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '211',
                                                                       'in_ucast_pkts': '259166005',
                                                                       'links': [       {       'in_discards': '211',
                                                                                                'in_ucast_pkts': '259166005',
                                                                                                'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                'out_discards': '551',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '96584092'}],
                                                                       'mac_address': '00:20:a6:f0:d4:18',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '551',
                                                                       'out_ucast_pkts': '96584092',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:0b:6b:b7:1b:5d',
                                                                                                                                                     'noise_floor': -96.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 46.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '551',
                                                                       'in_ucast_pkts': '96584092',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '211',
                                                                       'out_ucast_pkts': '259166005',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Christina Dedrick',
                                         'poller_hash': 'ACCm8NQY',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_proxim_proxim_Tsunami_MP_8200_BSU_G_v3_2_1_01(self):
        obj = self.run_data("proxim.proxim.Tsunami MP-8200-BSU-G.v3.2.1.01")
        exp_info = {
                'model': 'Tsunami MP-8200-BSU-G',
                'sta_count': 30,
                'sw_version': 'v3.2.1',
                'vendor': 'Proxim'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_packets': None,
                'dl_rf_packets_dropped': None,
                'rf_packets_retransmitted': None,
                'ul_noise_floor': None,
                'ul_rf_packets': None,
                'ul_rf_packets_dropped': None
        }
        exp_sta_stats = {
                '00:20:a6:d3:9f:ba': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 4608337,
                                             'dl_rf_packets_dropped': 15695,
                                             'dl_rssi': -67,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:d3:9f:ba',
                                             'name': 'Rieneth, William and Robin',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 2624573,
                                             'ul_rf_packets_dropped': 2040,
                                             'ul_rssi': -73,
                                             'ul_snr': 25},
                '00:20:a6:f0:cf:e1': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 67961859,
                                             'dl_rf_packets_dropped': 703826,
                                             'dl_rssi': -66,
                                             'dl_snr': 26,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:cf:e1',
                                             'name': 'Devault, Tim & Jessie',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 11730649,
                                             'ul_rf_packets_dropped': 45372,
                                             'ul_rssi': -71,
                                             'ul_snr': 27},
                '00:20:a6:f0:cf:e5': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 14162972,
                                             'dl_rf_packets_dropped': 193600,
                                             'dl_rssi': -70,
                                             'dl_snr': 22,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:cf:e5',
                                             'name': 'Thrasher, Brian',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 39000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 6013125,
                                             'ul_rf_packets_dropped': 68777,
                                             'ul_rssi': -74,
                                             'ul_snr': 25},
                '00:20:a6:f0:d4:98': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 60831147,
                                             'dl_rf_packets_dropped': 168124,
                                             'dl_rssi': -59,
                                             'dl_snr': 33,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:98',
                                             'name': 'Ziniel, Dennis',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 117000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 15568792,
                                             'ul_rf_packets_dropped': 30495,
                                             'ul_rssi': -63,
                                             'ul_snr': 34},
                '00:20:a6:f0:d4:aa': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 39601118,
                                             'dl_rf_packets_dropped': 19522,
                                             'dl_rssi': -51,
                                             'dl_snr': 41,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:aa',
                                             'name': 'Atwood, Frank and Mary',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 10906109,
                                             'ul_rf_packets_dropped': 7107,
                                             'ul_rssi': -55,
                                             'ul_snr': 42},
                '00:20:a6:f0:d4:ba': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 88801982,
                                             'dl_rf_packets_dropped': 377174,
                                             'dl_rssi': -67,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:ba',
                                             'name': 'Martinez, Wanda',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 27843103,
                                             'ul_rf_packets_dropped': 50586,
                                             'ul_rssi': -72,
                                             'ul_snr': 26},
                '00:20:a6:f0:d4:db': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 3405,
                                             'dl_rf_packets_dropped': 2,
                                             'dl_rssi': -63,
                                             'dl_snr': 29,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:db',
                                             'name': 'Bensusan, Denise',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 1280,
                                             'ul_rf_packets_dropped': 10,
                                             'ul_rssi': -70,
                                             'ul_snr': 27},
                '00:20:a6:f0:d4:e1': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 69547484,
                                             'dl_rf_packets_dropped': 319901,
                                             'dl_rssi': -59,
                                             'dl_snr': 33,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d4:e1',
                                             'name': 'Ackerman, Stacy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 28551256,
                                             'ul_rf_packets_dropped': 42294,
                                             'ul_rssi': -66,
                                             'ul_snr': 31},
                '00:20:a6:f0:d5:0e': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 126848812,
                                             'dl_rf_packets_dropped': 804000,
                                             'dl_rssi': -68,
                                             'dl_snr': 24,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:0e',
                                             'name': 'Black, Chuck',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 23443696,
                                             'ul_rf_packets_dropped': 65301,
                                             'ul_rssi': -70,
                                             'ul_snr': 26},
                '00:20:a6:f0:d5:1e': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 25637558,
                                             'dl_rf_packets_dropped': 28604,
                                             'dl_rssi': -60,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:1e',
                                             'name': 'Strasser, Tom #2',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 6710303,
                                             'ul_rf_packets_dropped': 4777,
                                             'ul_rssi': -63,
                                             'ul_snr': 34},
                '00:20:a6:f0:d5:27': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 2039243,
                                             'dl_rf_packets_dropped': 18,
                                             'dl_rssi': -49,
                                             'dl_snr': 43,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:27',
                                             'name': 'Armstrong Jackie',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -100,
                                             'ul_rf_packets': 802886,
                                             'ul_rf_packets_dropped': 5,
                                             'ul_rssi': -57,
                                             'ul_snr': 43},
                '00:20:a6:f0:d5:2f': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 109804616,
                                             'dl_rf_packets_dropped': 407527,
                                             'dl_rssi': -58,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:2f',
                                             'name': 'Murphy, James',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 23174675,
                                             'ul_rf_packets_dropped': 15436,
                                             'ul_rssi': -65,
                                             'ul_snr': 32},
                '00:20:a6:f0:d5:32': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 10630793,
                                             'dl_rf_packets_dropped': 956173,
                                             'dl_rssi': -69,
                                             'dl_snr': 23,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:32',
                                             'name': 'Eaton, Ralph',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 3709687,
                                             'ul_rf_packets_dropped': 7112,
                                             'ul_rssi': -70,
                                             'ul_snr': 27},
                '00:20:a6:f0:d5:41': {       'dev_macs': None,
                                             'dl_link_rate': 39000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 11275485,
                                             'dl_rf_packets_dropped': 127913,
                                             'dl_rssi': -75,
                                             'dl_snr': 17,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:41',
                                             'name': 'Cutshaw, Dorothy',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 5339386,
                                             'ul_rf_packets_dropped': 28462,
                                             'ul_rssi': -79,
                                             'ul_snr': 20},
                '00:20:a6:f0:d5:cd': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 5987010,
                                             'dl_rf_packets_dropped': 829410,
                                             'dl_rssi': -65,
                                             'dl_snr': 27,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:cd',
                                             'name': 'Moore, Rollan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 1900840,
                                             'ul_rf_packets_dropped': 16251,
                                             'ul_rssi': -72,
                                             'ul_snr': 27},
                '00:20:a6:f0:d5:d8': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 11756236,
                                             'dl_rf_packets_dropped': 16008,
                                             'dl_rssi': -60,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:d8',
                                             'name': 'Lyberg, Robert A.',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 6147049,
                                             'ul_rf_packets_dropped': 1771,
                                             'ul_rssi': -65,
                                             'ul_snr': 33},
                '00:20:a6:f0:d5:dc': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 100525748,
                                             'dl_rf_packets_dropped': 294095,
                                             'dl_rssi': -60,
                                             'dl_snr': 32,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:dc',
                                             'name': 'Roth, Jessica',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 33384353,
                                             'ul_rf_packets_dropped': 20055,
                                             'ul_rssi': -63,
                                             'ul_snr': 34},
                '00:20:a6:f0:d5:ea': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 8694652,
                                             'dl_rf_packets_dropped': 22591,
                                             'dl_rssi': -64,
                                             'dl_snr': 28,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d5:ea',
                                             'name': 'Joann,Oxsen',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -99,
                                             'ul_rf_packets': 4169800,
                                             'ul_rf_packets_dropped': 3224,
                                             'ul_rssi': -72,
                                             'ul_snr': 27},
                '00:20:a6:f0:d6:59': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 7013139,
                                             'dl_rf_packets_dropped': 240035,
                                             'dl_rssi': -63,
                                             'dl_snr': 29,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:59',
                                             'name': 'Tina Greenwood',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 2387010,
                                             'ul_rf_packets_dropped': 3979,
                                             'ul_rssi': -68,
                                             'ul_snr': 28},
                '00:20:a6:f0:d6:bb': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 2800411,
                                             'dl_rf_packets_dropped': 25735,
                                             'dl_rssi': -69,
                                             'dl_snr': 23,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:bb',
                                             'name': 'Hatch, Alan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 1436644,
                                             'ul_rf_packets_dropped': 3269,
                                             'ul_rssi': -71,
                                             'ul_snr': 26},
                '00:20:a6:f0:d6:bc': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 84717178,
                                             'dl_rf_packets_dropped': 1242005,
                                             'dl_rssi': -66,
                                             'dl_snr': 26,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:bc',
                                             'name': 'Short, Brian',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 14185684,
                                             'ul_rf_packets_dropped': 53553,
                                             'ul_rssi': -70,
                                             'ul_snr': 28},
                '00:20:a6:f0:d6:c1': {       'dev_macs': None,
                                             'dl_link_rate': 130000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 151003086,
                                             'dl_rf_packets_dropped': 50920,
                                             'dl_rssi': -56,
                                             'dl_snr': 36,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:c1',
                                             'name': 'Dyer, Tom',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 130000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 55730020,
                                             'ul_rf_packets_dropped': 18342,
                                             'ul_rssi': -58,
                                             'ul_snr': 39},
                '00:20:a6:f0:d6:c8': {       'dev_macs': None,
                                             'dl_link_rate': 117000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 8614144,
                                             'dl_rf_packets_dropped': 1776,
                                             'dl_rssi': -58,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:c8',
                                             'name': 'Reed, Lori',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 5951039,
                                             'ul_rf_packets_dropped': 971,
                                             'ul_rssi': -64,
                                             'ul_snr': 34},
                '00:20:a6:f0:d6:ca': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 6498997,
                                             'dl_rf_packets_dropped': 4945,
                                             'dl_rssi': -59,
                                             'dl_snr': 33,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:ca',
                                             'name': 'French, Jennifer',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -98,
                                             'ul_rf_packets': 3062947,
                                             'ul_rf_packets_dropped': 1742,
                                             'ul_rssi': -66,
                                             'ul_snr': 32},
                '00:20:a6:f0:d6:e2': {       'dev_macs': None,
                                             'dl_link_rate': 104000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 1742894,
                                             'dl_rf_packets_dropped': 3501,
                                             'dl_rssi': -62,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:e2',
                                             'name': 'Roberts, John and Pamela ',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 759670,
                                             'ul_rf_packets_dropped': 447,
                                             'ul_rssi': -64,
                                             'ul_snr': 33},
                '00:20:a6:f0:d6:f1': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 67492513,
                                             'dl_rf_packets_dropped': 2675082,
                                             'dl_rssi': -75,
                                             'dl_snr': 17,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f0:d6:f1',
                                             'name': 'Shuman, Fred ',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 26000000,
                                             'ul_noise_floor': -97,
                                             'ul_rf_packets': 26635832,
                                             'ul_rf_packets_dropped': 208996,
                                             'ul_rssi': -76,
                                             'ul_snr': 21},
                '00:20:a6:f6:0a:50': {       'dev_macs': None,
                                             'dl_link_rate': 78000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 108741012,
                                             'dl_rf_packets_dropped': 2533772,
                                             'dl_rssi': -58,
                                             'dl_snr': 34,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:0a:50',
                                             'name': 'Harris, Karen',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 27325303,
                                             'ul_rf_packets_dropped': 19767,
                                             'ul_rssi': -63,
                                             'ul_snr': 33},
                '00:20:a6:f6:0a:6c': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 47769063,
                                             'dl_rf_packets_dropped': 647768,
                                             'dl_rssi': -61,
                                             'dl_snr': 31,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:0a:6c',
                                             'name': 'Lee, David',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 104000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 9886058,
                                             'ul_rf_packets_dropped': 67614,
                                             'ul_rssi': -68,
                                             'ul_snr': 28},
                '00:20:a6:f6:0a:c3': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 15756717,
                                             'dl_rf_packets_dropped': 16655,
                                             'dl_rssi': -62,
                                             'dl_snr': 30,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:0a:c3',
                                             'name': 'McDermott, Kenneth & Lisa',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 78000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 12962343,
                                             'ul_rf_packets_dropped': 2881,
                                             'ul_rssi': -69,
                                             'ul_snr': 27},
                '00:20:a6:f6:0a:d7': {       'dev_macs': None,
                                             'dl_link_rate': 52000000,
                                             'dl_noise_floor': -92,
                                             'dl_rf_packets': 11872252,
                                             'dl_rf_packets_dropped': 53607,
                                             'dl_rssi': -67,
                                             'dl_snr': 25,
                                             'ip_address': None,
                                             'mac_address': '00:20:a6:f6:0a:d7',
                                             'name': 'Hubbard, Charles',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 52000000,
                                             'ul_noise_floor': -96,
                                             'ul_rf_packets': 6305539,
                                             'ul_rf_packets_dropped': 6080,
                                             'ul_rssi': -73,
                                             'ul_snr': 23}
        }
        exp_ne_msg = {
                'data': {       'elevation': 10.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '115555',
                                                              'in_nucast_pkts': '176445668',
                                                              'in_octets': '251015331',
                                                              'in_ucast_pkts': '28416607',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:20:a6:f0:87:27',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '441472403',
                                                              'out_ucast_pkts': '561488833',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_errors': '61792193',
                                                              'in_octets': '2701952628736',
                                                              'in_ucast_pkts': '1285214638',
                                                              'links': [       {       'in_discards': '971',
                                                                                       'in_ucast_pkts': '5951039',
                                                                                       'mac_address': '00:20:a6:f0:d6:c8',
                                                                                       'out_discards': '1776',
                                                                                       'out_retransmits': '21555',
                                                                                       'out_ucast_pkts': '8614144'},
                                                                               {       'in_discards': '20055',
                                                                                       'in_ucast_pkts': '33384353',
                                                                                       'mac_address': '00:20:a6:f0:d5:dc',
                                                                                       'out_discards': '294095',
                                                                                       'out_retransmits': '2261883',
                                                                                       'out_ucast_pkts': '100525748'},
                                                                               {       'in_discards': '15436',
                                                                                       'in_ucast_pkts': '23174675',
                                                                                       'mac_address': '00:20:a6:f0:d5:2f',
                                                                                       'out_discards': '407527',
                                                                                       'out_retransmits': '3114505',
                                                                                       'out_ucast_pkts': '109804616'},
                                                                               {       'in_discards': '65301',
                                                                                       'in_ucast_pkts': '23443696',
                                                                                       'mac_address': '00:20:a6:f0:d5:0e',
                                                                                       'out_discards': '804000',
                                                                                       'out_retransmits': '1444999',
                                                                                       'out_ucast_pkts': '126848812'},
                                                                               {       'in_discards': '2881',
                                                                                       'in_ucast_pkts': '12962343',
                                                                                       'mac_address': '00:20:a6:f6:0a:c3',
                                                                                       'out_discards': '16655',
                                                                                       'out_retransmits': '82657',
                                                                                       'out_ucast_pkts': '15756717'},
                                                                               {       'in_discards': '68777',
                                                                                       'in_ucast_pkts': '6013125',
                                                                                       'mac_address': '00:20:a6:f0:cf:e5',
                                                                                       'out_discards': '193600',
                                                                                       'out_retransmits': '37997',
                                                                                       'out_ucast_pkts': '14162972'},
                                                                               {       'in_discards': '19767',
                                                                                       'in_ucast_pkts': '27325303',
                                                                                       'mac_address': '00:20:a6:f6:0a:50',
                                                                                       'out_discards': '2533772',
                                                                                       'out_retransmits': '8876036',
                                                                                       'out_ucast_pkts': '108741012'},
                                                                               {       'in_discards': '208996',
                                                                                       'in_ucast_pkts': '26635832',
                                                                                       'mac_address': '00:20:a6:f0:d6:f1',
                                                                                       'out_discards': '2675082',
                                                                                       'out_retransmits': '2303910',
                                                                                       'out_ucast_pkts': '67492513'},
                                                                               {       'in_discards': '7107',
                                                                                       'in_ucast_pkts': '10906109',
                                                                                       'mac_address': '00:20:a6:f0:d4:aa',
                                                                                       'out_discards': '19522',
                                                                                       'out_retransmits': '134237',
                                                                                       'out_ucast_pkts': '39601118'},
                                                                               {       'in_discards': '2040',
                                                                                       'in_ucast_pkts': '2624573',
                                                                                       'mac_address': '00:20:a6:d3:9f:ba',
                                                                                       'out_discards': '15695',
                                                                                       'out_retransmits': '57059',
                                                                                       'out_ucast_pkts': '4608337'},
                                                                               {       'in_discards': '4777',
                                                                                       'in_ucast_pkts': '6710303',
                                                                                       'mac_address': '00:20:a6:f0:d5:1e',
                                                                                       'out_discards': '28604',
                                                                                       'out_retransmits': '186688',
                                                                                       'out_ucast_pkts': '25637558'},
                                                                               {       'in_discards': '18342',
                                                                                       'in_ucast_pkts': '55730020',
                                                                                       'mac_address': '00:20:a6:f0:d6:c1',
                                                                                       'out_discards': '50920',
                                                                                       'out_retransmits': '744588',
                                                                                       'out_ucast_pkts': '151003086'},
                                                                               {       'in_discards': '5',
                                                                                       'in_ucast_pkts': '802886',
                                                                                       'mac_address': '00:20:a6:f0:d5:27',
                                                                                       'out_discards': '18',
                                                                                       'out_retransmits': '911',
                                                                                       'out_ucast_pkts': '2039243'},
                                                                               {       'in_discards': '7112',
                                                                                       'in_ucast_pkts': '3709687',
                                                                                       'mac_address': '00:20:a6:f0:d5:32',
                                                                                       'out_discards': '956173',
                                                                                       'out_retransmits': '1386125',
                                                                                       'out_ucast_pkts': '10630793'},
                                                                               {       'in_discards': '53553',
                                                                                       'in_ucast_pkts': '14185684',
                                                                                       'mac_address': '00:20:a6:f0:d6:bc',
                                                                                       'out_discards': '1242005',
                                                                                       'out_retransmits': '2874465',
                                                                                       'out_ucast_pkts': '84717178'},
                                                                               {       'in_discards': '3224',
                                                                                       'in_ucast_pkts': '4169800',
                                                                                       'mac_address': '00:20:a6:f0:d5:ea',
                                                                                       'out_discards': '22591',
                                                                                       'out_retransmits': '80614',
                                                                                       'out_ucast_pkts': '8694652'},
                                                                               {       'in_discards': '45372',
                                                                                       'in_ucast_pkts': '11730649',
                                                                                       'mac_address': '00:20:a6:f0:cf:e1',
                                                                                       'out_discards': '703826',
                                                                                       'out_retransmits': '1717874',
                                                                                       'out_ucast_pkts': '67961859'},
                                                                               {       'in_discards': '67614',
                                                                                       'in_ucast_pkts': '9886058',
                                                                                       'mac_address': '00:20:a6:f6:0a:6c',
                                                                                       'out_discards': '647768',
                                                                                       'out_retransmits': '444294',
                                                                                       'out_ucast_pkts': '47769063'},
                                                                               {       'in_discards': '3979',
                                                                                       'in_ucast_pkts': '2387010',
                                                                                       'mac_address': '00:20:a6:f0:d6:59',
                                                                                       'out_discards': '240035',
                                                                                       'out_retransmits': '507926',
                                                                                       'out_ucast_pkts': '7013139'},
                                                                               {       'in_discards': '1742',
                                                                                       'in_ucast_pkts': '3062947',
                                                                                       'mac_address': '00:20:a6:f0:d6:ca',
                                                                                       'out_discards': '4945',
                                                                                       'out_retransmits': '44373',
                                                                                       'out_ucast_pkts': '6498997'},
                                                                               {       'in_discards': '447',
                                                                                       'in_ucast_pkts': '759670',
                                                                                       'mac_address': '00:20:a6:f0:d6:e2',
                                                                                       'out_discards': '3501',
                                                                                       'out_retransmits': '16252',
                                                                                       'out_ucast_pkts': '1742894'},
                                                                               {       'in_discards': '16251',
                                                                                       'in_ucast_pkts': '1900840',
                                                                                       'mac_address': '00:20:a6:f0:d5:cd',
                                                                                       'out_discards': '829410',
                                                                                       'out_retransmits': '524302',
                                                                                       'out_ucast_pkts': '5987010'},
                                                                               {       'in_discards': '42294',
                                                                                       'in_ucast_pkts': '28551256',
                                                                                       'mac_address': '00:20:a6:f0:d4:e1',
                                                                                       'out_discards': '319901',
                                                                                       'out_retransmits': '1208451',
                                                                                       'out_ucast_pkts': '69547484'},
                                                                               {       'in_discards': '10',
                                                                                       'in_ucast_pkts': '1280',
                                                                                       'mac_address': '00:20:a6:f0:d4:db',
                                                                                       'out_discards': '2',
                                                                                       'out_retransmits': '7',
                                                                                       'out_ucast_pkts': '3405'},
                                                                               {       'in_discards': '50586',
                                                                                       'in_ucast_pkts': '27843103',
                                                                                       'mac_address': '00:20:a6:f0:d4:ba',
                                                                                       'out_discards': '377174',
                                                                                       'out_retransmits': '82265',
                                                                                       'out_ucast_pkts': '88801982'},
                                                                               {       'in_discards': '28462',
                                                                                       'in_ucast_pkts': '5339386',
                                                                                       'mac_address': '00:20:a6:f0:d5:41',
                                                                                       'out_discards': '127913',
                                                                                       'out_retransmits': '59740',
                                                                                       'out_ucast_pkts': '11275485'},
                                                                               {       'in_discards': '3269',
                                                                                       'in_ucast_pkts': '1436644',
                                                                                       'mac_address': '00:20:a6:f0:d6:bb',
                                                                                       'out_discards': '25735',
                                                                                       'out_retransmits': '95778',
                                                                                       'out_ucast_pkts': '2800411'},
                                                                               {       'in_discards': '1771',
                                                                                       'in_ucast_pkts': '6147049',
                                                                                       'mac_address': '00:20:a6:f0:d5:d8',
                                                                                       'out_discards': '16008',
                                                                                       'out_retransmits': '113204',
                                                                                       'out_ucast_pkts': '11756236'},
                                                                               {       'in_discards': '6080',
                                                                                       'in_ucast_pkts': '6305539',
                                                                                       'mac_address': '00:20:a6:f6:0a:d7',
                                                                                       'out_discards': '53607',
                                                                                       'out_retransmits': '48564',
                                                                                       'out_ucast_pkts': '11872252'},
                                                                               {       'in_discards': '30495',
                                                                                       'in_ucast_pkts': '15568792',
                                                                                       'mac_address': '00:20:a6:f0:d4:98',
                                                                                       'out_discards': '168124',
                                                                                       'out_retransmits': '264170',
                                                                                       'out_ucast_pkts': '60831147'}],
                                                              'mac_address': '30:14:4a:d8:ce:cf',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_octets': '25569068934162',
                                                              'out_ucast_pkts': '2854659119',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:20:a6:f0:d6:c8',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '117000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:dc',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:2f',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:0e',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:0a:c3',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:cf:e5',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '39000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:0a:50',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:f1',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:aa',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:d3:9f:ba',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:1e',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:c1',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:27',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '130000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:32',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:bc',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:ea',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:cf:e1',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:0a:6c',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:59',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:ca',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:e2',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:cd',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:e1',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '104000000',
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:db',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:ba',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:41',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '26000000',
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '39000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d6:bb',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d5:d8',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '78000000',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '104000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f6:0a:d7',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '52000000'},
                                                                                                                                    {       'mac_address': '00:20:a6:f0:d4:98',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '117000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '104000000'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'latitude': 37.4097,
                                'longitude': -121.9171,
                                'manufacturer': 'Proxim',
                                'model': 'Tsunami MP-8200-BSU-G',
                                'poller_hash': 'MBRK2M7P',
                                'sw_version': 'v3.2.1',
                                'system_mac_address': '00:20:a6:f0:87:27',
                                'uptime': '13297450'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1776',
                                                                       'in_ucast_pkts': '8614144',
                                                                       'links': [       {       'in_discards': '1776',
                                                                                                'in_ucast_pkts': '8614144',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '971',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '5951039'}],
                                                                       'mac_address': '00:20:a6:f0:d6:c8',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '971',
                                                                       'out_ucast_pkts': '5951039',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '971',
                                                                       'in_ucast_pkts': '5951039',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1776',
                                                                       'out_ucast_pkts': '8614144',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Reed, Lori',
                                         'poller_hash': 'ACCm8NbI',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '294095',
                                                                       'in_ucast_pkts': '100525748',
                                                                       'links': [       {       'in_discards': '294095',
                                                                                                'in_ucast_pkts': '100525748',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '20055',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '33384353'}],
                                                                       'mac_address': '00:20:a6:f0:d5:dc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '20055',
                                                                       'out_ucast_pkts': '33384353',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '20055',
                                                                       'in_ucast_pkts': '33384353',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '294095',
                                                                       'out_ucast_pkts': '100525748',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Roth, Jessica',
                                         'poller_hash': 'ACCm8NXc',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '407527',
                                                                       'in_ucast_pkts': '109804616',
                                                                       'links': [       {       'in_discards': '407527',
                                                                                                'in_ucast_pkts': '109804616',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '15436',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '23174675'}],
                                                                       'mac_address': '00:20:a6:f0:d5:2f',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '15436',
                                                                       'out_ucast_pkts': '23174675',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '15436',
                                                                       'in_ucast_pkts': '23174675',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '407527',
                                                                       'out_ucast_pkts': '109804616',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Murphy, James',
                                         'poller_hash': 'ACCm8NUv',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '804000',
                                                                       'in_ucast_pkts': '126848812',
                                                                       'links': [       {       'in_discards': '804000',
                                                                                                'in_ucast_pkts': '126848812',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '65301',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '23443696'}],
                                                                       'mac_address': '00:20:a6:f0:d5:0e',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '65301',
                                                                       'out_ucast_pkts': '23443696',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '65301',
                                                                       'in_ucast_pkts': '23443696',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '804000',
                                                                       'out_ucast_pkts': '126848812',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Black, Chuck',
                                         'poller_hash': 'ACCm8NUO',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '16655',
                                                                       'in_ucast_pkts': '15756717',
                                                                       'links': [       {       'in_discards': '16655',
                                                                                                'in_ucast_pkts': '15756717',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '2881',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '12962343'}],
                                                                       'mac_address': '00:20:a6:f6:0a:c3',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '2881',
                                                                       'out_ucast_pkts': '12962343',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '2881',
                                                                       'in_ucast_pkts': '12962343',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '16655',
                                                                       'out_ucast_pkts': '15756717',
                                                                       'poller_hash': '8gAgpvYK'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'McDermott, Kenneth & Lisa',
                                         'poller_hash': 'ACCm9grD',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '193600',
                                                                       'in_ucast_pkts': '14162972',
                                                                       'links': [       {       'in_discards': '193600',
                                                                                                'in_ucast_pkts': '14162972',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '68777',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '6013125'}],
                                                                       'mac_address': '00:20:a6:f0:cf:e5',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '68777',
                                                                       'out_ucast_pkts': '6013125',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '39000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '68777',
                                                                       'in_ucast_pkts': '6013125',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '193600',
                                                                       'out_ucast_pkts': '14162972',
                                                                       'poller_hash': '8gAgpvDP'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Thrasher, Brian',
                                         'poller_hash': 'ACCm8M/l',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2533772',
                                                                       'in_ucast_pkts': '108741012',
                                                                       'links': [       {       'in_discards': '2533772',
                                                                                                'in_ucast_pkts': '108741012',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '19767',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '27325303'}],
                                                                       'mac_address': '00:20:a6:f6:0a:50',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '19767',
                                                                       'out_ucast_pkts': '27325303',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '19767',
                                                                       'in_ucast_pkts': '27325303',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2533772',
                                                                       'out_ucast_pkts': '108741012',
                                                                       'poller_hash': '8gAgpvYK'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Harris, Karen',
                                         'poller_hash': 'ACCm9gpQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2675082',
                                                                       'in_ucast_pkts': '67492513',
                                                                       'links': [       {       'in_discards': '2675082',
                                                                                                'in_ucast_pkts': '67492513',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '208996',
                                                                                                'out_retransmits': '2',
                                                                                                'out_ucast_pkts': '26635832'}],
                                                                       'mac_address': '00:20:a6:f0:d6:f1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '208996',
                                                                       'out_ucast_pkts': '26635832',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '208996',
                                                                       'in_ucast_pkts': '26635832',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2675082',
                                                                       'out_ucast_pkts': '67492513',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Shuman, Fred ',
                                         'poller_hash': 'ACCm8Nbx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '19522',
                                                                       'in_ucast_pkts': '39601118',
                                                                       'links': [       {       'in_discards': '19522',
                                                                                                'in_ucast_pkts': '39601118',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '7107',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '10906109'}],
                                                                       'mac_address': '00:20:a6:f0:d4:aa',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '7107',
                                                                       'out_ucast_pkts': '10906109',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 41.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '7107',
                                                                       'in_ucast_pkts': '10906109',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '19522',
                                                                       'out_ucast_pkts': '39601118',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Atwood, Frank and Mary',
                                         'poller_hash': 'ACCm8NSq',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '15695',
                                                                       'in_ucast_pkts': '4608337',
                                                                       'links': [       {       'in_discards': '15695',
                                                                                                'in_ucast_pkts': '4608337',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '2040',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '2624573'}],
                                                                       'mac_address': '00:20:a6:d3:9f:ba',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '2040',
                                                                       'out_ucast_pkts': '2624573',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '2040',
                                                                       'in_ucast_pkts': '2624573',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '15695',
                                                                       'out_ucast_pkts': '4608337',
                                                                       'poller_hash': '8gAgptOf'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Rieneth, William and Robin',
                                         'poller_hash': 'ACCm05+6',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '28604',
                                                                       'in_ucast_pkts': '25637558',
                                                                       'links': [       {       'in_discards': '28604',
                                                                                                'in_ucast_pkts': '25637558',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '4777',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '6710303'}],
                                                                       'mac_address': '00:20:a6:f0:d5:1e',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '4777',
                                                                       'out_ucast_pkts': '6710303',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '4777',
                                                                       'in_ucast_pkts': '6710303',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '28604',
                                                                       'out_ucast_pkts': '25637558',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Strasser, Tom #2',
                                         'poller_hash': 'ACCm8NUe',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '50920',
                                                                       'in_ucast_pkts': '151003086',
                                                                       'links': [       {       'in_discards': '50920',
                                                                                                'in_ucast_pkts': '151003086',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '18342',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '55730020'}],
                                                                       'mac_address': '00:20:a6:f0:d6:c1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '18342',
                                                                       'out_ucast_pkts': '55730020',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '18342',
                                                                       'in_ucast_pkts': '55730020',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '50920',
                                                                       'out_ucast_pkts': '151003086',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Dyer, Tom',
                                         'poller_hash': 'ACCm8NbB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '18',
                                                                       'in_ucast_pkts': '2039243',
                                                                       'links': [       {       'in_discards': '18',
                                                                                                'in_ucast_pkts': '2039243',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '5',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '802886'}],
                                                                       'mac_address': '00:20:a6:f0:d5:27',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '5',
                                                                       'out_ucast_pkts': '802886',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '130000000',
                                                                                                                                                     'snr': 43.0,
                                                                                                                                                     'tx_link_rate': '130000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '5',
                                                                       'in_ucast_pkts': '802886',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '18',
                                                                       'out_ucast_pkts': '2039243',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Armstrong Jackie',
                                         'poller_hash': 'ACCm8NUn',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '956173',
                                                                       'in_ucast_pkts': '10630793',
                                                                       'links': [       {       'in_discards': '956173',
                                                                                                'in_ucast_pkts': '10630793',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '7112',
                                                                                                'out_retransmits': '2',
                                                                                                'out_ucast_pkts': '3709687'}],
                                                                       'mac_address': '00:20:a6:f0:d5:32',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '7112',
                                                                       'out_ucast_pkts': '3709687',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '7112',
                                                                       'in_ucast_pkts': '3709687',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '956173',
                                                                       'out_ucast_pkts': '10630793',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Eaton, Ralph',
                                         'poller_hash': 'ACCm8NUy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1242005',
                                                                       'in_ucast_pkts': '84717178',
                                                                       'links': [       {       'in_discards': '1242005',
                                                                                                'in_ucast_pkts': '84717178',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '53553',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '14185684'}],
                                                                       'mac_address': '00:20:a6:f0:d6:bc',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '53553',
                                                                       'out_ucast_pkts': '14185684',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '53553',
                                                                       'in_ucast_pkts': '14185684',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '1242005',
                                                                       'out_ucast_pkts': '84717178',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Short, Brian',
                                         'poller_hash': 'ACCm8Na8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '22591',
                                                                       'in_ucast_pkts': '8694652',
                                                                       'links': [       {       'in_discards': '22591',
                                                                                                'in_ucast_pkts': '8694652',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '3224',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '4169800'}],
                                                                       'mac_address': '00:20:a6:f0:d5:ea',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3224',
                                                                       'out_ucast_pkts': '4169800',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3224',
                                                                       'in_ucast_pkts': '4169800',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '22591',
                                                                       'out_ucast_pkts': '8694652',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Joann,Oxsen',
                                         'poller_hash': 'ACCm8NXq',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '703826',
                                                                       'in_ucast_pkts': '67961859',
                                                                       'links': [       {       'in_discards': '703826',
                                                                                                'in_ucast_pkts': '67961859',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '45372',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '11730649'}],
                                                                       'mac_address': '00:20:a6:f0:cf:e1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '45372',
                                                                       'out_ucast_pkts': '11730649',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '45372',
                                                                       'in_ucast_pkts': '11730649',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '703826',
                                                                       'out_ucast_pkts': '67961859',
                                                                       'poller_hash': '8gAgpvDP'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Devault, Tim & Jessie',
                                         'poller_hash': 'ACCm8M/h',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '647768',
                                                                       'in_ucast_pkts': '47769063',
                                                                       'links': [       {       'in_discards': '647768',
                                                                                                'in_ucast_pkts': '47769063',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '67614',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '9886058'}],
                                                                       'mac_address': '00:20:a6:f6:0a:6c',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '67614',
                                                                       'out_ucast_pkts': '9886058',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '67614',
                                                                       'in_ucast_pkts': '9886058',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '647768',
                                                                       'out_ucast_pkts': '47769063',
                                                                       'poller_hash': '8gAgpvYK'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Lee, David',
                                         'poller_hash': 'ACCm9gps',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '240035',
                                                                       'in_ucast_pkts': '7013139',
                                                                       'links': [       {       'in_discards': '240035',
                                                                                                'in_ucast_pkts': '7013139',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '3979',
                                                                                                'out_retransmits': '2',
                                                                                                'out_ucast_pkts': '2387010'}],
                                                                       'mac_address': '00:20:a6:f0:d6:59',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3979',
                                                                       'out_ucast_pkts': '2387010',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3979',
                                                                       'in_ucast_pkts': '2387010',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '240035',
                                                                       'out_ucast_pkts': '7013139',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Tina Greenwood',
                                         'poller_hash': 'ACCm8NZZ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4945',
                                                                       'in_ucast_pkts': '6498997',
                                                                       'links': [       {       'in_discards': '4945',
                                                                                                'in_ucast_pkts': '6498997',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '1742',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '3062947'}],
                                                                       'mac_address': '00:20:a6:f0:d6:ca',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1742',
                                                                       'out_ucast_pkts': '3062947',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1742',
                                                                       'in_ucast_pkts': '3062947',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '4945',
                                                                       'out_ucast_pkts': '6498997',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'French, Jennifer',
                                         'poller_hash': 'ACCm8NbK',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '3501',
                                                                       'in_ucast_pkts': '1742894',
                                                                       'links': [       {       'in_discards': '3501',
                                                                                                'in_ucast_pkts': '1742894',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '447',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '759670'}],
                                                                       'mac_address': '00:20:a6:f0:d6:e2',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '447',
                                                                       'out_ucast_pkts': '759670',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '447',
                                                                       'in_ucast_pkts': '759670',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '3501',
                                                                       'out_ucast_pkts': '1742894',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Roberts, John and Pamela ',
                                         'poller_hash': 'ACCm8Nbi',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '829410',
                                                                       'in_ucast_pkts': '5987010',
                                                                       'links': [       {       'in_discards': '829410',
                                                                                                'in_ucast_pkts': '5987010',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '16251',
                                                                                                'out_retransmits': '3',
                                                                                                'out_ucast_pkts': '1900840'}],
                                                                       'mac_address': '00:20:a6:f0:d5:cd',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '16251',
                                                                       'out_ucast_pkts': '1900840',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '16251',
                                                                       'in_ucast_pkts': '1900840',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '829410',
                                                                       'out_ucast_pkts': '5987010',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Moore, Rollan',
                                         'poller_hash': 'ACCm8NXN',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '319901',
                                                                       'in_ucast_pkts': '69547484',
                                                                       'links': [       {       'in_discards': '319901',
                                                                                                'in_ucast_pkts': '69547484',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '42294',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '28551256'}],
                                                                       'mac_address': '00:20:a6:f0:d4:e1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '42294',
                                                                       'out_ucast_pkts': '28551256',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '104000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '42294',
                                                                       'in_ucast_pkts': '28551256',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '319901',
                                                                       'out_ucast_pkts': '69547484',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Ackerman, Stacy',
                                         'poller_hash': 'ACCm8NTh',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '2',
                                                                       'in_ucast_pkts': '3405',
                                                                       'links': [       {       'in_discards': '2',
                                                                                                'in_ucast_pkts': '3405',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '10',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '1280'}],
                                                                       'mac_address': '00:20:a6:f0:d4:db',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '10',
                                                                       'out_ucast_pkts': '1280',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '10',
                                                                       'in_ucast_pkts': '1280',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '2',
                                                                       'out_ucast_pkts': '3405',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Bensusan, Denise',
                                         'poller_hash': 'ACCm8NTb',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '377174',
                                                                       'in_ucast_pkts': '88801982',
                                                                       'links': [       {       'in_discards': '377174',
                                                                                                'in_ucast_pkts': '88801982',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '50586',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '27843103'}],
                                                                       'mac_address': '00:20:a6:f0:d4:ba',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '50586',
                                                                       'out_ucast_pkts': '27843103',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '50586',
                                                                       'in_ucast_pkts': '27843103',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '377174',
                                                                       'out_ucast_pkts': '88801982',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Martinez, Wanda',
                                         'poller_hash': 'ACCm8NS6',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '127913',
                                                                       'in_ucast_pkts': '11275485',
                                                                       'links': [       {       'in_discards': '127913',
                                                                                                'in_ucast_pkts': '11275485',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '28462',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '5339386'}],
                                                                       'mac_address': '00:20:a6:f0:d5:41',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '28462',
                                                                       'out_ucast_pkts': '5339386',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '26000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '28462',
                                                                       'in_ucast_pkts': '5339386',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '127913',
                                                                       'out_ucast_pkts': '11275485',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Cutshaw, Dorothy',
                                         'poller_hash': 'ACCm8NVB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '25735',
                                                                       'in_ucast_pkts': '2800411',
                                                                       'links': [       {       'in_discards': '25735',
                                                                                                'in_ucast_pkts': '2800411',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '3269',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '1436644'}],
                                                                       'mac_address': '00:20:a6:f0:d6:bb',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '3269',
                                                                       'out_ucast_pkts': '1436644',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '3269',
                                                                       'in_ucast_pkts': '1436644',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '25735',
                                                                       'out_ucast_pkts': '2800411',
                                                                       'poller_hash': '8gAgpvDW'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hatch, Alan',
                                         'poller_hash': 'ACCm8Na7',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '16008',
                                                                       'in_ucast_pkts': '11756236',
                                                                       'links': [       {       'in_discards': '16008',
                                                                                                'in_ucast_pkts': '11756236',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '1771',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '6147049'}],
                                                                       'mac_address': '00:20:a6:f0:d5:d8',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '1771',
                                                                       'out_ucast_pkts': '6147049',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '78000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '1771',
                                                                       'in_ucast_pkts': '6147049',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '16008',
                                                                       'out_ucast_pkts': '11756236',
                                                                       'poller_hash': '8gAgpvDV'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Lyberg, Robert A.',
                                         'poller_hash': 'ACCm8NXY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '53607',
                                                                       'in_ucast_pkts': '11872252',
                                                                       'links': [       {       'in_discards': '53607',
                                                                                                'in_ucast_pkts': '11872252',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '6080',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '6305539'}],
                                                                       'mac_address': '00:20:a6:f6:0a:d7',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '6080',
                                                                       'out_ucast_pkts': '6305539',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '52000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '52000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '6080',
                                                                       'in_ucast_pkts': '6305539',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '53607',
                                                                       'out_ucast_pkts': '11872252',
                                                                       'poller_hash': '8gAgpvYK'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Hubbard, Charles',
                                         'poller_hash': 'ACCm9grX',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '168124',
                                                                       'in_ucast_pkts': '60831147',
                                                                       'links': [       {       'in_discards': '168124',
                                                                                                'in_ucast_pkts': '60831147',
                                                                                                'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                'out_discards': '30495',
                                                                                                'out_retransmits': '0',
                                                                                                'out_ucast_pkts': '15568792'}],
                                                                       'mac_address': '00:20:a6:f0:d4:98',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_discards': '30495',
                                                                       'out_ucast_pkts': '15568792',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:14:4a:d8:ce:cf',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '104000000',
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '117000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_discards': '30495',
                                                                       'in_ucast_pkts': '15568792',
                                                                       'name': 'Ethernet',
                                                                       'oper_up': True,
                                                                       'out_discards': '168124',
                                                                       'out_ucast_pkts': '60831147',
                                                                       'poller_hash': '8gAgpvDU'}],
                                         'manufacturer': 'Proxim',
                                         'name': 'Ziniel, Dennis',
                                         'poller_hash': 'ACCm8NSY',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
