"""Test IP-MAC data structure"""
import unittest

from node_ip_resolver import NodeIpResolver

class TestNodeIpResolver(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_01(self):
        """Input an entry."""
        resolver = NodeIpResolver()
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1'}
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)

    def test_02(self):
        """Input two entries with duplicate IPs.  This IP is hidden from results."""
        resolver = NodeIpResolver()
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1',
                   '00:01:02:0a:0b:0d': '192.0.2.1',
                   '0a:01:02:0a:0b:01': '192.0.2.2'}
        r = resolver.set('source1', node_ip)
        self.assertEqual({'00:01:02:0a:0b:0c': None, '00:01:02:0a:0b:0d': None, '0a:01:02:0a:0b:01': '192.0.2.2'}, r)
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1',
                   '00:01:02:0a:0b:0d': '192.0.2.3',
                   '0a:01:02:0a:0b:01': '192.0.2.2'}
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)

    def test_03(self):
        """Input two IP entries that agree, from different sources"""
        resolver = NodeIpResolver()
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1'}
        r = resolver.set('source1', node_ip)
        r = resolver.set('source2', node_ip)
        self.assertEqual(node_ip, r)

    def test_04(self):
        """A source is removed."""
        resolver = NodeIpResolver()
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1'}
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)
        r = resolver.set('source1', {})
        self.assertEqual({}, r)
        self.assertEqual(resolver.source_node_ip, {})
        self.assertEqual(resolver.ip_source_id, {})

    def test_05(self):
        """An invalid IP address is handled properly."""
        resolver = NodeIpResolver()
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.1'}
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)
        node_ip = {'00:01:02:0a:0b:0c': '169.254.0.100'}  # link-local IP
        r = resolver.set('source1', node_ip)
        self.assertEqual({'00:01:02:0a:0b:0c': None}, r)
        self.assertEqual(resolver.source_node_ip, {})
        self.assertEqual(resolver.ip_source_id, {})
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.2'}  # link-local IP
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.3'}  # invalid ip
        r = resolver.set('source1', node_ip)
        self.assertEqual(node_ip, r)
        node_ip = {'00:01:02:0a:0b:0c': '192.0.2.256'}  # invalid ip
        r = resolver.set('source1', node_ip)
        self.assertEqual({'00:01:02:0a:0b:0c': None}, r)
        self.assertEqual(resolver.source_node_ip, {})
        self.assertEqual(resolver.ip_source_id, {})
