import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCmtsModels(DeviceTestCase):
    def test_cmts_cisco_uBR10012_12_2_33_SCG6_01(self):
        obj = self.run_data("cmts.cisco.uBR10012.12.2(33)SCG6.01")
        exp_info = {
         'model': 'uBR10012', 'sw_version': None, 'vendor': 'CMTS'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:ac:e0:b8:07:92': {       'alt_macs': {'00:ac:e0:b8:07:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.71',
                                             'mac_address': '00:ac:e0:b8:07:92',
                                             'name': None},
                '00:ac:e0:bf:40:92': {       'alt_macs': {'00:ac:e0:bf:40:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.42',
                                             'mac_address': '00:ac:e0:bf:40:92',
                                             'name': None},
                '08:3e:0c:10:67:72': {       'alt_macs': {'08:3e:0c:10:67:74'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.47',
                                             'mac_address': '08:3e:0c:10:67:72',
                                             'name': None},
                '08:3e:0c:e8:51:b2': {       'alt_macs': {'08:3e:0c:e8:51:b4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.44',
                                             'mac_address': '08:3e:0c:e8:51:b2',
                                             'name': None},
                '08:3e:0c:ec:39:b2': {       'alt_macs': {'08:3e:0c:ec:39:b4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.89',
                                             'mac_address': '08:3e:0c:ec:39:b2',
                                             'name': None},
                '08:3e:0c:ec:43:02': {       'alt_macs': {'08:3e:0c:ec:43:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.128',
                                             'mac_address': '08:3e:0c:ec:43:02',
                                             'name': None},
                '08:3e:0c:ec:ce:c2': {       'alt_macs': {'08:3e:0c:ec:ce:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.101',
                                             'mac_address': '08:3e:0c:ec:ce:c2',
                                             'name': None},
                '0c:f8:93:de:7d:e2': {       'alt_macs': {'0c:f8:93:de:7d:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.58',
                                             'mac_address': '0c:f8:93:de:7d:e2',
                                             'name': None},
                '10:86:8c:16:1e:12': {       'alt_macs': {'10:86:8c:16:1e:13'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.22',
                                             'mac_address': '10:86:8c:16:1e:12',
                                             'name': None},
                '14:ab:f0:d0:22:e2': {       'alt_macs': {'14:ab:f0:d0:22:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.100',
                                             'mac_address': '14:ab:f0:d0:22:e2',
                                             'name': None},
                '14:ab:f0:d3:47:d2': {       'alt_macs': {'14:ab:f0:d3:47:d4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.25',
                                             'mac_address': '14:ab:f0:d3:47:d2',
                                             'name': None},
                '14:cf:e2:9c:ce:e2': {       'alt_macs': {'14:cf:e2:9c:ce:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.95',
                                             'mac_address': '14:cf:e2:9c:ce:e2',
                                             'name': None},
                '14:cf:e2:a0:15:c2': {       'alt_macs': {'14:cf:e2:a0:15:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.2',
                                             'mac_address': '14:cf:e2:a0:15:c2',
                                             'name': None},
                '14:cf:e2:a0:26:12': {       'alt_macs': {'14:cf:e2:a0:26:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.98',
                                             'mac_address': '14:cf:e2:a0:26:12',
                                             'name': None},
                '14:cf:e2:a9:1f:12': {       'alt_macs': {'14:cf:e2:a9:1f:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.86',
                                             'mac_address': '14:cf:e2:a9:1f:12',
                                             'name': None},
                '24:94:cb:28:6f:1d': {       'alt_macs': set(),
                                             'dev_macs': {'44:10:91:66:03:e4'},
                                             'ip_address': '10.0.196.40',
                                             'mac_address': '24:94:cb:28:6f:1d',
                                             'name': None},
                '2c:99:24:52:71:e3': {       'alt_macs': {'2c:99:24:52:71:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.116',
                                             'mac_address': '2c:99:24:52:71:e3',
                                             'name': None},
                '2c:99:24:8e:4d:23': {       'alt_macs': {'2c:99:24:8e:4d:24'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.136',
                                             'mac_address': '2c:99:24:8e:4d:23',
                                             'name': None},
                '2c:99:24:8e:56:13': {       'alt_macs': {'2c:99:24:8e:56:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.103',
                                             'mac_address': '2c:99:24:8e:56:13',
                                             'name': None},
                '2c:99:24:8e:59:2b': {       'alt_macs': {'2c:99:24:8e:59:2c'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.133',
                                             'mac_address': '2c:99:24:8e:59:2b',
                                             'name': None},
                '2c:99:24:8e:5f:03': {       'alt_macs': {'2c:99:24:8e:5f:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.96',
                                             'mac_address': '2c:99:24:8e:5f:03',
                                             'name': None},
                '2c:99:24:d6:60:c9': {       'alt_macs': {'2c:99:24:d6:60:ca'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.157',
                                             'mac_address': '2c:99:24:d6:60:c9',
                                             'name': None},
                '2c:99:24:d8:34:79': {       'alt_macs': {'2c:99:24:d8:34:7a'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.84',
                                             'mac_address': '2c:99:24:d8:34:79',
                                             'name': None},
                '38:70:0c:02:e8:b8': {       'alt_macs': {'38:70:0c:02:e8:b9'},
                                             'dev_macs': {'e4:90:7e:f6:83:a0'},
                                             'ip_address': '10.0.196.119',
                                             'mac_address': '38:70:0c:02:e8:b8',
                                             'name': None},
                '38:70:0c:3e:cc:3a': {       'alt_macs': {'38:70:0c:3e:cc:3b'},
                                             'dev_macs': {'9c:c9:eb:32:e0:f9'},
                                             'ip_address': '10.0.196.7',
                                             'mac_address': '38:70:0c:3e:cc:3a',
                                             'name': None},
                '38:70:0c:40:aa:0a': {       'alt_macs': {'38:70:0c:40:aa:0b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.132',
                                             'mac_address': '38:70:0c:40:aa:0a',
                                             'name': None},
                '38:70:0c:63:a7:54': {       'alt_macs': {'38:70:0c:63:a7:55'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.109',
                                             'mac_address': '38:70:0c:63:a7:54',
                                             'name': None},
                '38:70:0c:68:4f:ca': {       'alt_macs': {'38:70:0c:68:4f:cb'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.29',
                                             'mac_address': '38:70:0c:68:4f:ca',
                                             'name': None},
                '38:70:0c:6a:57:e5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.166',
                                             'mac_address': '38:70:0c:6a:57:e5',
                                             'name': None},
                '38:70:0c:6a:7e:c7': {       'alt_macs': {'38:70:0c:6a:7e:c8'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.107',
                                             'mac_address': '38:70:0c:6a:7e:c7',
                                             'name': None},
                '38:70:0c:6a:bf:5d': {       'alt_macs': {'38:70:0c:6a:bf:5e'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.139',
                                             'mac_address': '38:70:0c:6a:bf:5d',
                                             'name': None},
                '38:70:0c:6a:ea:4b': {       'alt_macs': {'38:70:0c:6a:ea:4c'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.36',
                                             'mac_address': '38:70:0c:6a:ea:4b',
                                             'name': None},
                '38:70:0c:6d:47:d2': {       'alt_macs': {'38:70:0c:6d:47:d3'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.164',
                                             'mac_address': '38:70:0c:6d:47:d2',
                                             'name': None},
                '38:70:0c:85:c3:8a': {       'alt_macs': {'38:70:0c:85:c3:8b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.138',
                                             'mac_address': '38:70:0c:85:c3:8a',
                                             'name': None},
                '38:70:0c:8f:01:b1': {       'alt_macs': {'38:70:0c:8f:01:b2'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.140',
                                             'mac_address': '38:70:0c:8f:01:b1',
                                             'name': None},
                '38:70:0c:8f:5b:5a': {       'alt_macs': {'38:70:0c:8f:5b:5b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.102',
                                             'mac_address': '38:70:0c:8f:5b:5a',
                                             'name': None},
                '38:70:0c:8f:6b:ec': {       'alt_macs': {'38:70:0c:8f:6b:ed'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.105',
                                             'mac_address': '38:70:0c:8f:6b:ec',
                                             'name': None},
                '38:70:0c:8f:85:7d': {       'alt_macs': {'38:70:0c:8f:85:7e'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.141',
                                             'mac_address': '38:70:0c:8f:85:7d',
                                             'name': None},
                '38:70:0c:8f:a6:0e': {       'alt_macs': {'38:70:0c:8f:a6:0f'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.142',
                                             'mac_address': '38:70:0c:8f:a6:0e',
                                             'name': None},
                '38:70:0c:8f:ac:90': {       'alt_macs': {'38:70:0c:8f:ac:91'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.3',
                                             'mac_address': '38:70:0c:8f:ac:90',
                                             'name': None},
                '38:70:0c:8f:bc:a4': {       'alt_macs': {'38:70:0c:8f:bc:a5'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.143',
                                             'mac_address': '38:70:0c:8f:bc:a4',
                                             'name': None},
                '38:70:0c:8f:c2:70': {       'alt_macs': {'38:70:0c:8f:c2:71'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.80',
                                             'mac_address': '38:70:0c:8f:c2:70',
                                             'name': None},
                '38:70:0c:92:91:7f': {       'alt_macs': {'38:70:0c:92:91:80'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.160',
                                             'mac_address': '38:70:0c:92:91:7f',
                                             'name': None},
                '38:70:0c:93:98:3e': {       'alt_macs': {'38:70:0c:93:98:3f'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.165',
                                             'mac_address': '38:70:0c:93:98:3e',
                                             'name': None},
                '38:70:0c:96:38:30': {       'alt_macs': {'38:70:0c:96:38:31'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.163',
                                             'mac_address': '38:70:0c:96:38:30',
                                             'name': None},
                '38:70:0c:ea:0e:fa': {       'alt_macs': {'38:70:0c:ea:0e:fb'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.112',
                                             'mac_address': '38:70:0c:ea:0e:fa',
                                             'name': None},
                '38:70:0c:f2:84:3a': {       'alt_macs': {'38:70:0c:f2:84:3b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.114',
                                             'mac_address': '38:70:0c:f2:84:3a',
                                             'name': None},
                '3c:7a:8a:75:a7:42': {       'alt_macs': {'3c:7a:8a:75:a7:43'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.135',
                                             'mac_address': '3c:7a:8a:75:a7:42',
                                             'name': None},
                '3c:7a:8a:76:94:4a': {       'alt_macs': {'3c:7a:8a:76:94:4b'},
                                             'dev_macs': {'6c:cd:d6:ae:51:00'},
                                             'ip_address': '10.0.196.79',
                                             'mac_address': '3c:7a:8a:76:94:4a',
                                             'name': None},
                '3c:7a:8a:78:0d:3a': {       'alt_macs': {'3c:7a:8a:78:0d:3b'},
                                             'dev_macs': {'90:9a:4a:f2:7e:17'},
                                             'ip_address': '10.0.196.92',
                                             'mac_address': '3c:7a:8a:78:0d:3a',
                                             'name': None},
                '3c:7a:8a:7a:f6:e2': {       'alt_macs': {'3c:7a:8a:7a:f6:e3'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.152',
                                             'mac_address': '3c:7a:8a:7a:f6:e2',
                                             'name': None},
                '3c:7a:8a:7d:b7:aa': {       'alt_macs': {'3c:7a:8a:7d:b7:ab'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.75',
                                             'mac_address': '3c:7a:8a:7d:b7:aa',
                                             'name': None},
                '3c:7a:8a:7e:91:fa': {       'alt_macs': {'3c:7a:8a:7e:91:fb'},
                                             'dev_macs': {'44:a5:6e:45:d0:d5'},
                                             'ip_address': '10.0.196.123',
                                             'mac_address': '3c:7a:8a:7e:91:fa',
                                             'name': None},
                '3c:7a:8a:7e:c0:32': {       'alt_macs': {'3c:7a:8a:7e:c0:33'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.156',
                                             'mac_address': '3c:7a:8a:7e:c0:32',
                                             'name': None},
                '3c:7a:8a:ec:11:2a': {       'alt_macs': {'3c:7a:8a:ec:11:2b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.125',
                                             'mac_address': '3c:7a:8a:ec:11:2a',
                                             'name': None},
                '3c:7a:8a:ec:11:52': {       'alt_macs': {'3c:7a:8a:ec:11:53'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.124',
                                             'mac_address': '3c:7a:8a:ec:11:52',
                                             'name': None},
                '3c:7a:8a:ef:02:0a': {       'alt_macs': {'3c:7a:8a:ef:02:0b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.28',
                                             'mac_address': '3c:7a:8a:ef:02:0a',
                                             'name': None},
                '3c:7a:8a:f2:92:12': {       'alt_macs': {'3c:7a:8a:f2:92:13'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.115',
                                             'mac_address': '3c:7a:8a:f2:92:12',
                                             'name': None},
                '40:70:09:71:53:5c': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.82',
                                             'mac_address': '40:70:09:71:53:5c',
                                             'name': None},
                '40:70:09:71:a2:32': {       'alt_macs': {'40:70:09:71:a2:34'},
                                             'dev_macs': {'b0:39:56:6b:c8:09'},
                                             'ip_address': '10.0.196.51',
                                             'mac_address': '40:70:09:71:a2:32',
                                             'name': None},
                '40:70:09:86:0b:62': {       'alt_macs': {'40:70:09:86:0b:64'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.53',
                                             'mac_address': '40:70:09:86:0b:62',
                                             'name': None},
                '40:70:09:8a:27:92': {       'alt_macs': {'40:70:09:8a:27:94'},
                                             'dev_macs': {'c0:c1:c0:fb:af:a1'},
                                             'ip_address': '10.0.196.66',
                                             'mac_address': '40:70:09:8a:27:92',
                                             'name': None},
                '40:70:09:8c:07:a2': {       'alt_macs': {'40:70:09:8c:07:a4'},
                                             'dev_macs': {'f0:9f:c2:36:00:dc'},
                                             'ip_address': '10.0.196.52',
                                             'mac_address': '40:70:09:8c:07:a2',
                                             'name': None},
                '40:70:09:91:e4:c2': {       'alt_macs': {'40:70:09:91:e4:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.15',
                                             'mac_address': '40:70:09:91:e4:c2',
                                             'name': None},
                '40:70:09:94:7a:02': {       'alt_macs': {'40:70:09:94:7a:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.19',
                                             'mac_address': '40:70:09:94:7a:02',
                                             'name': None},
                '40:70:09:aa:b2:e2': {       'alt_macs': {'40:70:09:aa:b2:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.17',
                                             'mac_address': '40:70:09:aa:b2:e2',
                                             'name': None},
                '40:70:09:ac:13:82': {       'alt_macs': {'40:70:09:ac:13:84'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.113',
                                             'mac_address': '40:70:09:ac:13:82',
                                             'name': None},
                '54:65:de:6f:6a:52': {       'alt_macs': {'54:65:de:6f:6a:54'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.31',
                                             'mac_address': '54:65:de:6f:6a:52',
                                             'name': None},
                '54:65:de:6f:c4:d2': {       'alt_macs': {'54:65:de:6f:c4:d4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.158',
                                             'mac_address': '54:65:de:6f:c4:d2',
                                             'name': None},
                '54:65:de:bd:4e:62': {       'alt_macs': {'54:65:de:bd:4e:64'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.90',
                                             'mac_address': '54:65:de:bd:4e:62',
                                             'name': None},
                '54:65:de:fe:9d:22': {       'alt_macs': {'54:65:de:fe:9d:24'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.54',
                                             'mac_address': '54:65:de:fe:9d:22',
                                             'name': None},
                '5c:8f:e0:1a:e7:82': {       'alt_macs': {'5c:8f:e0:1a:e7:83'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.148',
                                             'mac_address': '5c:8f:e0:1a:e7:82',
                                             'name': None},
                '5c:8f:e0:1b:06:7a': {       'alt_macs': {'5c:8f:e0:1b:06:7b'},
                                             'dev_macs': {'94:a6:7e:75:65:68'},
                                             'ip_address': '10.0.196.37',
                                             'mac_address': '5c:8f:e0:1b:06:7a',
                                             'name': None},
                '5c:8f:e0:1b:14:a2': {       'alt_macs': {'5c:8f:e0:1b:14:a3'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.147',
                                             'mac_address': '5c:8f:e0:1b:14:a2',
                                             'name': None},
                '5c:8f:e0:1b:a7:b2': {       'alt_macs': {'5c:8f:e0:1b:a7:b3'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.48',
                                             'mac_address': '5c:8f:e0:1b:a7:b2',
                                             'name': None},
                '5c:8f:e0:1b:c1:5a': {       'alt_macs': {'5c:8f:e0:1b:c1:5b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.118',
                                             'mac_address': '5c:8f:e0:1b:c1:5a',
                                             'name': None},
                '5c:8f:e0:27:ed:12': {       'alt_macs': {'5c:8f:e0:27:ed:13'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.110',
                                             'mac_address': '5c:8f:e0:27:ed:12',
                                             'name': None},
                '5c:8f:e0:28:69:92': {       'alt_macs': {'5c:8f:e0:28:69:93'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.145',
                                             'mac_address': '5c:8f:e0:28:69:92',
                                             'name': None},
                '5c:8f:e0:28:74:9a': {       'alt_macs': {'5c:8f:e0:28:74:9b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.149',
                                             'mac_address': '5c:8f:e0:28:74:9a',
                                             'name': None},
                '5c:8f:e0:4f:ac:1a': {       'alt_macs': {'5c:8f:e0:4f:ac:1b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.9',
                                             'mac_address': '5c:8f:e0:4f:ac:1a',
                                             'name': None},
                '60:19:71:ee:44:72': {       'alt_macs': {'60:19:71:ee:44:74'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.106',
                                             'mac_address': '60:19:71:ee:44:72',
                                             'name': None},
                '78:71:9c:8b:f9:b2': {       'alt_macs': {'78:71:9c:8b:f9:b4'},
                                             'dev_macs': {'60:32:b1:3e:0a:78'},
                                             'ip_address': '10.0.196.97',
                                             'mac_address': '78:71:9c:8b:f9:b2',
                                             'name': None},
                '78:71:9c:8d:0f:82': {       'alt_macs': {'78:71:9c:8d:0f:84'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.94',
                                             'mac_address': '78:71:9c:8d:0f:82',
                                             'name': None},
                '78:71:9c:90:f2:b2': {       'alt_macs': {'78:71:9c:90:f2:b4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.122',
                                             'mac_address': '78:71:9c:90:f2:b2',
                                             'name': None},
                '78:71:9c:94:20:72': {       'alt_macs': {'78:71:9c:94:20:74'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.104',
                                             'mac_address': '78:71:9c:94:20:72',
                                             'name': None},
                '78:71:9c:9b:e1:12': {       'alt_macs': {'78:71:9c:9b:e1:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.121',
                                             'mac_address': '78:71:9c:9b:e1:12',
                                             'name': None},
                '78:71:9c:a1:7d:c2': {       'alt_macs': {'78:71:9c:a1:7d:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.129',
                                             'mac_address': '78:71:9c:a1:7d:c2',
                                             'name': None},
                '8c:09:f4:04:06:62': {       'alt_macs': {'8c:09:f4:04:06:64'},
                                             'dev_macs': {'60:38:e0:33:04:34'},
                                             'ip_address': '10.0.196.49',
                                             'mac_address': '8c:09:f4:04:06:62',
                                             'name': None},
                '8c:09:f4:10:7b:82': {       'alt_macs': {'8c:09:f4:10:7b:84'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.55',
                                             'mac_address': '8c:09:f4:10:7b:82',
                                             'name': None},
                '90:1a:ca:5e:14:c2': {       'alt_macs': {'90:1a:ca:5e:14:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.30',
                                             'mac_address': '90:1a:ca:5e:14:c2',
                                             'name': None},
                '90:1a:ca:5e:3a:82': {       'alt_macs': {'90:1a:ca:5e:3a:84'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.76',
                                             'mac_address': '90:1a:ca:5e:3a:82',
                                             'name': None},
                '90:1a:ca:61:ca:52': {       'alt_macs': {'90:1a:ca:61:ca:54'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.88',
                                             'mac_address': '90:1a:ca:61:ca:52',
                                             'name': None},
                '90:1a:ca:71:7f:52': {       'alt_macs': {'90:1a:ca:71:7f:54'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.35',
                                             'mac_address': '90:1a:ca:71:7f:52',
                                             'name': None},
                '90:1a:ca:7b:69:92': {       'alt_macs': {'90:1a:ca:7b:69:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.46',
                                             'mac_address': '90:1a:ca:7b:69:92',
                                             'name': None},
                '90:1a:ca:7c:2b:62': {       'alt_macs': {'90:1a:ca:7c:2b:64'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.21',
                                             'mac_address': '90:1a:ca:7c:2b:62',
                                             'name': None},
                '90:1a:ca:d9:7a:d2': {       'alt_macs': {'90:1a:ca:d9:7a:d4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.126',
                                             'mac_address': '90:1a:ca:d9:7a:d2',
                                             'name': None},
                '90:1a:ca:db:eb:f2': {       'alt_macs': {'90:1a:ca:db:eb:f4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.91',
                                             'mac_address': '90:1a:ca:db:eb:f2',
                                             'name': None},
                '94:87:7c:00:27:12': {       'alt_macs': {'94:87:7c:00:27:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.10',
                                             'mac_address': '94:87:7c:00:27:12',
                                             'name': None},
                '94:87:7c:01:e3:a2': {       'alt_macs': {'94:87:7c:01:e3:a4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.5',
                                             'mac_address': '94:87:7c:01:e3:a2',
                                             'name': None},
                '94:87:7c:06:b4:02': {       'alt_macs': {'94:87:7c:06:b4:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.45',
                                             'mac_address': '94:87:7c:06:b4:02',
                                             'name': None},
                '94:87:7c:0a:91:22': {       'alt_macs': {'94:87:7c:0a:91:24'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.6',
                                             'mac_address': '94:87:7c:0a:91:22',
                                             'name': None},
                '94:87:7c:0b:19:02': {       'alt_macs': {'94:87:7c:0b:19:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.120',
                                             'mac_address': '94:87:7c:0b:19:02',
                                             'name': None},
                '94:87:7c:10:62:22': {       'alt_macs': {'94:87:7c:10:62:24'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.26',
                                             'mac_address': '94:87:7c:10:62:22',
                                             'name': None},
                '98:6b:3d:c3:17:e2': {       'alt_macs': {'98:6b:3d:c3:17:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.61',
                                             'mac_address': '98:6b:3d:c3:17:e2',
                                             'name': None},
                '98:6b:3d:c5:50:42': {       'alt_macs': {'98:6b:3d:c5:50:44'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.85',
                                             'mac_address': '98:6b:3d:c5:50:42',
                                             'name': None},
                '98:6b:3d:c6:d7:92': {       'alt_macs': {'98:6b:3d:c6:d7:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.99',
                                             'mac_address': '98:6b:3d:c6:d7:92',
                                             'name': None},
                '98:6b:3d:c7:56:62': {       'alt_macs': {'98:6b:3d:c7:56:64'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.24',
                                             'mac_address': '98:6b:3d:c7:56:62',
                                             'name': None},
                '98:6b:3d:d2:0d:b2': {       'alt_macs': {'98:6b:3d:d2:0d:b4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.60',
                                             'mac_address': '98:6b:3d:d2:0d:b2',
                                             'name': None},
                '98:6b:3d:dc:60:42': {       'alt_macs': {'98:6b:3d:dc:60:44'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.67',
                                             'mac_address': '98:6b:3d:dc:60:42',
                                             'name': None},
                '98:6b:3d:dc:a2:82': {       'alt_macs': {'98:6b:3d:dc:a2:84'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.16',
                                             'mac_address': '98:6b:3d:dc:a2:82',
                                             'name': None},
                '98:6b:3d:e5:51:e2': {       'alt_macs': {'98:6b:3d:e5:51:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.78',
                                             'mac_address': '98:6b:3d:e5:51:e2',
                                             'name': None},
                '9c:34:26:44:02:3a': {       'alt_macs': {'9c:34:26:44:02:3b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.144',
                                             'mac_address': '9c:34:26:44:02:3a',
                                             'name': None},
                '9c:34:26:4e:92:5a': {       'alt_macs': {'9c:34:26:4e:92:5b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.134',
                                             'mac_address': '9c:34:26:4e:92:5a',
                                             'name': None},
                '9c:34:26:ac:47:5a': {       'alt_macs': {'9c:34:26:ac:47:5b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.50',
                                             'mac_address': '9c:34:26:ac:47:5a',
                                             'name': None},
                '9c:34:26:b0:be:6a': {       'alt_macs': {'9c:34:26:b0:be:6b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.162',
                                             'mac_address': '9c:34:26:b0:be:6a',
                                             'name': None},
                '9c:34:26:b0:f7:d2': {       'alt_macs': {'9c:34:26:b0:f7:d3'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.150',
                                             'mac_address': '9c:34:26:b0:f7:d2',
                                             'name': None},
                'ac:b3:13:04:d1:12': {       'alt_macs': {'ac:b3:13:04:d1:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.27',
                                             'mac_address': 'ac:b3:13:04:d1:12',
                                             'name': None},
                'ac:b3:13:0c:b0:52': {       'alt_macs': {'ac:b3:13:0c:b0:54'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.12',
                                             'mac_address': 'ac:b3:13:0c:b0:52',
                                             'name': None},
                'ac:b3:13:0e:bb:02': {       'alt_macs': {'ac:b3:13:0e:bb:04'},
                                             'dev_macs': {'70:8b:cd:ac:dc:80'},
                                             'ip_address': '10.0.196.159',
                                             'mac_address': 'ac:b3:13:0e:bb:02',
                                             'name': None},
                'ac:b3:13:77:26:e2': {       'alt_macs': {'ac:b3:13:77:26:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.81',
                                             'mac_address': 'ac:b3:13:77:26:e2',
                                             'name': None},
                'ac:b3:13:78:36:72': {       'alt_macs': {'ac:b3:13:78:36:74'},
                                             'dev_macs': {'14:91:82:fd:e6:89'},
                                             'ip_address': '10.0.196.34',
                                             'mac_address': 'ac:b3:13:78:36:72',
                                             'name': None},
                'ac:b3:13:80:8a:02': {       'alt_macs': {'ac:b3:13:80:8a:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.14',
                                             'mac_address': 'ac:b3:13:80:8a:02',
                                             'name': None},
                'ac:b3:13:85:c2:72': {       'alt_macs': {'ac:b3:13:85:c2:74'},
                                             'dev_macs': {'b0:b9:8a:51:1f:1a'},
                                             'ip_address': '10.0.196.127',
                                             'mac_address': 'ac:b3:13:85:c2:72',
                                             'name': None},
                'ac:b3:13:8f:85:32': {       'alt_macs': {'ac:b3:13:8f:85:34'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.11',
                                             'mac_address': 'ac:b3:13:8f:85:32',
                                             'name': None},
                'ac:b3:13:9f:dc:c2': {       'alt_macs': {'ac:b3:13:9f:dc:c4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.62',
                                             'mac_address': 'ac:b3:13:9f:dc:c2',
                                             'name': None},
                'ac:b3:13:a1:a9:e2': {       'alt_macs': {'ac:b3:13:a1:a9:e4'},
                                             'dev_macs': {'78:d2:94:b0:d4:ff'},
                                             'ip_address': '10.0.196.33',
                                             'mac_address': 'ac:b3:13:a1:a9:e2',
                                             'name': None},
                'ac:b3:13:a2:05:12': {       'alt_macs': {'ac:b3:13:a2:05:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.43',
                                             'mac_address': 'ac:b3:13:a2:05:12',
                                             'name': None},
                'ac:b3:13:a4:98:02': {       'alt_macs': {'ac:b3:13:a4:98:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.87',
                                             'mac_address': 'ac:b3:13:a4:98:02',
                                             'name': None},
                'ac:b3:13:a9:70:02': {       'alt_macs': {'ac:b3:13:a9:70:04'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.77',
                                             'mac_address': 'ac:b3:13:a9:70:02',
                                             'name': None},
                'ac:b3:13:ac:c4:c2': {       'alt_macs': {'ac:b3:13:ac:c4:c4'},
                                             'dev_macs': {'6c:ae:f6:4f:03:20'},
                                             'ip_address': '10.0.196.111',
                                             'mac_address': 'ac:b3:13:ac:c4:c2',
                                             'name': None},
                'ac:b3:13:b2:b4:52': {       'alt_macs': {'ac:b3:13:b2:b4:54'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.56',
                                             'mac_address': 'ac:b3:13:b2:b4:52',
                                             'name': None},
                'ac:b3:13:b5:5b:72': {       'alt_macs': {'ac:b3:13:b5:5b:74'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.130',
                                             'mac_address': 'ac:b3:13:b5:5b:72',
                                             'name': None},
                'ac:b3:13:b6:cb:92': {       'alt_macs': {'ac:b3:13:b6:cb:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.13',
                                             'mac_address': 'ac:b3:13:b6:cb:92',
                                             'name': None},
                'c0:c5:22:e1:67:3a': {       'alt_macs': {'c0:c5:22:e1:67:3b'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.153',
                                             'mac_address': 'c0:c5:22:e1:67:3a',
                                             'name': None},
                'c0:c5:22:f9:75:a4': {       'alt_macs': {'c0:c5:22:f9:75:a5'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.146',
                                             'mac_address': 'c0:c5:22:f9:75:a4',
                                             'name': None},
                'cc:a4:62:26:71:92': {       'alt_macs': {'cc:a4:62:26:71:94'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.69',
                                             'mac_address': 'cc:a4:62:26:71:92',
                                             'name': None},
                'cc:a4:62:37:0c:12': {       'alt_macs': set(),
                                             'dev_macs': {'dc:ef:09:17:05:e9'},
                                             'ip_address': '10.0.196.20',
                                             'mac_address': 'cc:a4:62:37:0c:12',
                                             'name': None},
                'e8:89:2c:7e:83:e2': {       'alt_macs': {'e8:89:2c:7e:83:e4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.23',
                                             'mac_address': 'e8:89:2c:7e:83:e2',
                                             'name': None},
                'f8:ed:a5:db:b3:f2': {       'alt_macs': {'f8:ed:a5:db:b3:f4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.73',
                                             'mac_address': 'f8:ed:a5:db:b3:f2',
                                             'name': None},
                'f8:ed:a5:dc:5e:e2': {       'alt_macs': set(),
                                             'dev_macs': {'14:91:82:29:0a:63'},
                                             'ip_address': '10.0.196.38',
                                             'mac_address': 'f8:ed:a5:dc:5e:e2',
                                             'name': None},
                'f8:ed:a5:df:27:12': {       'alt_macs': {'f8:ed:a5:df:27:14'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.63',
                                             'mac_address': 'f8:ed:a5:df:27:12',
                                             'name': None},
                'f8:ed:a5:e8:1a:d2': {       'alt_macs': {'f8:ed:a5:e8:1a:d4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.8',
                                             'mac_address': 'f8:ed:a5:e8:1a:d2',
                                             'name': None},
                'f8:ed:a5:f2:aa:b2': {       'alt_macs': {'f8:ed:a5:f2:aa:b4'},
                                             'dev_macs': set(),
                                             'ip_address': '10.0.196.4',
                                             'mac_address': 'f8:ed:a5:f2:aa:b2',
                                             'name': None}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_cmts_generic_CMTS_12_2_33_SCG6_01(self):
        obj = self.run_data("cmts.generic.CMTS.12.2(33)SCG6.01")
        exp_info = {
         'model': 'uBR10012', 'sw_version': None, 'vendor': 'CMTS'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:1d:d3:60:3f:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.255',
                                             'mac_address': '00:1d:d3:60:3f:22',
                                             'name': None},
                '00:1d:d5:3b:30:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.117',
                                             'mac_address': '00:1d:d5:3b:30:52',
                                             'name': None},
                '00:1d:d5:40:7a:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.75',
                                             'mac_address': '00:1d:d5:40:7a:12',
                                             'name': None},
                '00:1d:d5:43:e4:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.55',
                                             'mac_address': '00:1d:d5:43:e4:02',
                                             'name': None},
                '00:1d:d5:44:2f:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.12',
                                             'mac_address': '00:1d:d5:44:2f:22',
                                             'name': None},
                '00:1d:d5:44:3a:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.197',
                                             'mac_address': '00:1d:d5:44:3a:62',
                                             'name': None},
                '00:1d:d5:45:e8:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.152',
                                             'mac_address': '00:1d:d5:45:e8:92',
                                             'name': None},
                '00:1d:d5:4b:1d:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.11',
                                             'mac_address': '00:1d:d5:4b:1d:f2',
                                             'name': None},
                '00:ac:e0:8f:7c:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.204',
                                             'mac_address': '00:ac:e0:8f:7c:d2',
                                             'name': None},
                '00:ac:e0:90:7e:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.137',
                                             'mac_address': '00:ac:e0:90:7e:e2',
                                             'name': None},
                '00:ac:e0:91:89:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.143',
                                             'mac_address': '00:ac:e0:91:89:22',
                                             'name': None},
                '00:ac:e0:91:f8:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.27',
                                             'mac_address': '00:ac:e0:91:f8:82',
                                             'name': None},
                '00:ac:e0:98:3d:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.35',
                                             'mac_address': '00:ac:e0:98:3d:22',
                                             'name': None},
                '00:ac:e0:9a:f5:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.1',
                                             'mac_address': '00:ac:e0:9a:f5:22',
                                             'name': None},
                '00:ac:e0:9c:c4:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.69',
                                             'mac_address': '00:ac:e0:9c:c4:f2',
                                             'name': None},
                '00:ac:e0:9f:72:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.253',
                                             'mac_address': '00:ac:e0:9f:72:d2',
                                             'name': None},
                '00:ac:e0:b4:7c:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.34',
                                             'mac_address': '00:ac:e0:b4:7c:92',
                                             'name': None},
                '00:ac:e0:b8:47:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.168',
                                             'mac_address': '00:ac:e0:b8:47:22',
                                             'name': None},
                '00:ac:e0:bc:b9:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.224',
                                             'mac_address': '00:ac:e0:bc:b9:62',
                                             'name': None},
                '08:3e:0c:0c:cf:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.47',
                                             'mac_address': '08:3e:0c:0c:cf:72',
                                             'name': None},
                '08:3e:0c:0d:25:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.76',
                                             'mac_address': '08:3e:0c:0d:25:42',
                                             'name': None},
                '08:3e:0c:0d:fd:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.18',
                                             'mac_address': '08:3e:0c:0d:fd:52',
                                             'name': None},
                '08:3e:0c:0e:55:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.52',
                                             'mac_address': '08:3e:0c:0e:55:62',
                                             'name': None},
                '08:3e:0c:0e:cc:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.215',
                                             'mac_address': '08:3e:0c:0e:cc:a2',
                                             'name': None},
                '08:3e:0c:0f:30:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.236',
                                             'mac_address': '08:3e:0c:0f:30:d2',
                                             'name': None},
                '08:3e:0c:0f:31:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.217',
                                             'mac_address': '08:3e:0c:0f:31:82',
                                             'name': None},
                '08:3e:0c:11:b9:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.140',
                                             'mac_address': '08:3e:0c:11:b9:52',
                                             'name': None},
                '08:3e:0c:15:34:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.14',
                                             'mac_address': '08:3e:0c:15:34:e2',
                                             'name': None},
                '08:3e:0c:16:3e:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.42',
                                             'mac_address': '08:3e:0c:16:3e:a2',
                                             'name': None},
                '08:3e:0c:16:7c:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.44',
                                             'mac_address': '08:3e:0c:16:7c:82',
                                             'name': None},
                '08:3e:0c:16:86:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.196',
                                             'mac_address': '08:3e:0c:16:86:52',
                                             'name': None},
                '08:3e:0c:e4:ff:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.205',
                                             'mac_address': '08:3e:0c:e4:ff:82',
                                             'name': None},
                '08:3e:0c:e8:70:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.149',
                                             'mac_address': '08:3e:0c:e8:70:72',
                                             'name': None},
                '08:3e:0c:e8:d2:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.187',
                                             'mac_address': '08:3e:0c:e8:d2:02',
                                             'name': None},
                '08:3e:0c:e9:c6:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.81',
                                             'mac_address': '08:3e:0c:e9:c6:12',
                                             'name': None},
                '08:3e:0c:ec:b4:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.38',
                                             'mac_address': '08:3e:0c:ec:b4:a2',
                                             'name': None},
                '08:3e:0c:ed:3f:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.82',
                                             'mac_address': '08:3e:0c:ed:3f:72',
                                             'name': None},
                '0c:f8:93:d9:30:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.212',
                                             'mac_address': '0c:f8:93:d9:30:b2',
                                             'name': None},
                '0c:f8:93:dd:35:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.166',
                                             'mac_address': '0c:f8:93:dd:35:92',
                                             'name': None},
                '0c:f8:93:dd:61:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.175',
                                             'mac_address': '0c:f8:93:dd:61:b2',
                                             'name': None},
                '0c:f8:93:dd:7d:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.29',
                                             'mac_address': '0c:f8:93:dd:7d:f2',
                                             'name': None},
                '0c:f8:93:dd:d7:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.72',
                                             'mac_address': '0c:f8:93:dd:d7:f2',
                                             'name': None},
                '0c:f8:93:de:07:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.79',
                                             'mac_address': '0c:f8:93:de:07:72',
                                             'name': None},
                '0c:f8:93:de:0e:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.40',
                                             'mac_address': '0c:f8:93:de:0e:b2',
                                             'name': None},
                '0c:f8:93:de:56:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.235',
                                             'mac_address': '0c:f8:93:de:56:82',
                                             'name': None},
                '0c:f8:93:de:5a:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.177',
                                             'mac_address': '0c:f8:93:de:5a:c2',
                                             'name': None},
                '0c:f8:93:de:ae:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.165',
                                             'mac_address': '0c:f8:93:de:ae:72',
                                             'name': None},
                '0c:f8:93:de:c4:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.62',
                                             'mac_address': '0c:f8:93:de:c4:72',
                                             'name': None},
                '0c:f8:93:de:c7:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.4',
                                             'mac_address': '0c:f8:93:de:c7:c2',
                                             'name': None},
                '0c:f8:93:de:d1:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.176',
                                             'mac_address': '0c:f8:93:de:d1:02',
                                             'name': None},
                '0c:f8:93:e0:a8:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.17',
                                             'mac_address': '0c:f8:93:e0:a8:f2',
                                             'name': None},
                '0c:f8:93:e1:ae:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.120',
                                             'mac_address': '0c:f8:93:e1:ae:f2',
                                             'name': None},
                '0c:f8:93:e2:10:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.10',
                                             'mac_address': '0c:f8:93:e2:10:a2',
                                             'name': None},
                '0c:f8:93:e2:32:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.105',
                                             'mac_address': '0c:f8:93:e2:32:f2',
                                             'name': None},
                '0c:f8:93:e2:84:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.230',
                                             'mac_address': '0c:f8:93:e2:84:12',
                                             'name': None},
                '0c:f8:93:e2:c0:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.0',
                                             'mac_address': '0c:f8:93:e2:c0:12',
                                             'name': None},
                '0c:f8:93:e2:d0:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.84',
                                             'mac_address': '0c:f8:93:e2:d0:e2',
                                             'name': None},
                '0c:f8:93:e2:e3:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.98',
                                             'mac_address': '0c:f8:93:e2:e3:c2',
                                             'name': None},
                '0c:f8:93:e3:19:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.167',
                                             'mac_address': '0c:f8:93:e3:19:32',
                                             'name': None},
                '0c:f8:93:e3:22:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.221',
                                             'mac_address': '0c:f8:93:e3:22:52',
                                             'name': None},
                '0c:f8:93:e3:2f:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.113',
                                             'mac_address': '0c:f8:93:e3:2f:52',
                                             'name': None},
                '0c:f8:93:e3:8d:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.122',
                                             'mac_address': '0c:f8:93:e3:8d:32',
                                             'name': None},
                '0c:f8:93:e3:97:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.60',
                                             'mac_address': '0c:f8:93:e3:97:02',
                                             'name': None},
                '0c:f8:93:e3:a8:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.145',
                                             'mac_address': '0c:f8:93:e3:a8:72',
                                             'name': None},
                '0c:f8:93:e3:ab:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.136',
                                             'mac_address': '0c:f8:93:e3:ab:12',
                                             'name': None},
                '0c:f8:93:e4:30:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.18',
                                             'mac_address': '0c:f8:93:e4:30:a2',
                                             'name': None},
                '0c:f8:93:e4:52:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.156',
                                             'mac_address': '0c:f8:93:e4:52:32',
                                             'name': None},
                '0c:f8:93:e4:67:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.157',
                                             'mac_address': '0c:f8:93:e4:67:72',
                                             'name': None},
                '0c:f8:93:e4:ce:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.231',
                                             'mac_address': '0c:f8:93:e4:ce:e2',
                                             'name': None},
                '0c:f8:93:e5:38:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.241',
                                             'mac_address': '0c:f8:93:e5:38:f2',
                                             'name': None},
                '10:86:8c:0c:f9:4a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.254',
                                             'mac_address': '10:86:8c:0c:f9:4a',
                                             'name': None},
                '10:86:8c:0d:01:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.107',
                                             'mac_address': '10:86:8c:0d:01:92',
                                             'name': None},
                '10:86:8c:12:0b:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.216',
                                             'mac_address': '10:86:8c:12:0b:f2',
                                             'name': None},
                '10:86:8c:13:52:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.37',
                                             'mac_address': '10:86:8c:13:52:82',
                                             'name': None},
                '10:86:8c:13:b2:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.40',
                                             'mac_address': '10:86:8c:13:b2:62',
                                             'name': None},
                '10:86:8c:14:bd:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.13',
                                             'mac_address': '10:86:8c:14:bd:b2',
                                             'name': None},
                '10:86:8c:15:0a:3a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.190',
                                             'mac_address': '10:86:8c:15:0a:3a',
                                             'name': None},
                '10:86:8c:15:2a:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.29',
                                             'mac_address': '10:86:8c:15:2a:d2',
                                             'name': None},
                '10:86:8c:16:a6:2a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.182',
                                             'mac_address': '10:86:8c:16:a6:2a',
                                             'name': None},
                '10:86:8c:16:d8:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.181',
                                             'mac_address': '10:86:8c:16:d8:22',
                                             'name': None},
                '10:86:8c:17:26:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.222',
                                             'mac_address': '10:86:8c:17:26:fa',
                                             'name': None},
                '10:86:8c:17:2c:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.202',
                                             'mac_address': '10:86:8c:17:2c:a2',
                                             'name': None},
                '10:86:8c:17:30:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.12',
                                             'mac_address': '10:86:8c:17:30:f2',
                                             'name': None},
                '10:86:8c:17:36:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.173',
                                             'mac_address': '10:86:8c:17:36:6a',
                                             'name': None},
                '10:86:8c:17:36:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.173',
                                             'mac_address': '10:86:8c:17:36:b2',
                                             'name': None},
                '10:86:8c:18:0a:aa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.14',
                                             'mac_address': '10:86:8c:18:0a:aa',
                                             'name': None},
                '14:ab:f0:5b:d0:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.121',
                                             'mac_address': '14:ab:f0:5b:d0:32',
                                             'name': None},
                '14:ab:f0:5c:2f:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.94',
                                             'mac_address': '14:ab:f0:5c:2f:b2',
                                             'name': None},
                '14:ab:f0:5c:37:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.1',
                                             'mac_address': '14:ab:f0:5c:37:72',
                                             'name': None},
                '14:ab:f0:5c:41:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.58',
                                             'mac_address': '14:ab:f0:5c:41:32',
                                             'name': None},
                '14:ab:f0:60:47:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.46',
                                             'mac_address': '14:ab:f0:60:47:42',
                                             'name': None},
                '14:ab:f0:64:00:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.123',
                                             'mac_address': '14:ab:f0:64:00:22',
                                             'name': None},
                '14:ab:f0:cd:ec:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.177',
                                             'mac_address': '14:ab:f0:cd:ec:22',
                                             'name': None},
                '14:ab:f0:ce:e1:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.33',
                                             'mac_address': '14:ab:f0:ce:e1:42',
                                             'name': None},
                '14:ab:f0:d2:64:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.71',
                                             'mac_address': '14:ab:f0:d2:64:b2',
                                             'name': None},
                '14:ab:f0:d5:10:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.74',
                                             'mac_address': '14:ab:f0:d5:10:d2',
                                             'name': None},
                '14:ab:f0:d6:86:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.26',
                                             'mac_address': '14:ab:f0:d6:86:72',
                                             'name': None},
                '14:cf:e2:1f:1a:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.61',
                                             'mac_address': '14:cf:e2:1f:1a:c2',
                                             'name': None},
                '14:cf:e2:21:c5:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.41',
                                             'mac_address': '14:cf:e2:21:c5:02',
                                             'name': None},
                '14:cf:e2:22:23:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.5',
                                             'mac_address': '14:cf:e2:22:23:a2',
                                             'name': None},
                '14:cf:e2:22:2b:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.158',
                                             'mac_address': '14:cf:e2:22:2b:72',
                                             'name': None},
                '14:cf:e2:24:ad:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.20',
                                             'mac_address': '14:cf:e2:24:ad:b2',
                                             'name': None},
                '14:cf:e2:24:c3:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.232',
                                             'mac_address': '14:cf:e2:24:c3:d2',
                                             'name': None},
                '14:cf:e2:2c:7a:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.243',
                                             'mac_address': '14:cf:e2:2c:7a:d2',
                                             'name': None},
                '14:cf:e2:9e:56:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.220',
                                             'mac_address': '14:cf:e2:9e:56:e2',
                                             'name': None},
                '14:cf:e2:9e:57:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.45',
                                             'mac_address': '14:cf:e2:9e:57:72',
                                             'name': None},
                '14:cf:e2:9e:b6:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.81',
                                             'mac_address': '14:cf:e2:9e:b6:d2',
                                             'name': None},
                '14:cf:e2:9f:16:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.82',
                                             'mac_address': '14:cf:e2:9f:16:d2',
                                             'name': None},
                '14:cf:e2:9f:2f:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.61',
                                             'mac_address': '14:cf:e2:9f:2f:02',
                                             'name': None},
                '14:cf:e2:9f:f0:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.49',
                                             'mac_address': '14:cf:e2:9f:f0:42',
                                             'name': None},
                '14:cf:e2:a0:33:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.85',
                                             'mac_address': '14:cf:e2:a0:33:22',
                                             'name': None},
                '14:cf:e2:a0:4e:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.223',
                                             'mac_address': '14:cf:e2:a0:4e:82',
                                             'name': None},
                '14:cf:e2:a0:54:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.79',
                                             'mac_address': '14:cf:e2:a0:54:92',
                                             'name': None},
                '14:cf:e2:a1:ef:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.38',
                                             'mac_address': '14:cf:e2:a1:ef:12',
                                             'name': None},
                '14:cf:e2:a3:37:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.92',
                                             'mac_address': '14:cf:e2:a3:37:52',
                                             'name': None},
                '14:cf:e2:a7:54:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.65',
                                             'mac_address': '14:cf:e2:a7:54:72',
                                             'name': None},
                '14:cf:e2:a7:ef:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.214',
                                             'mac_address': '14:cf:e2:a7:ef:c2',
                                             'name': None},
                '14:cf:e2:a9:36:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.181',
                                             'mac_address': '14:cf:e2:a9:36:d2',
                                             'name': None},
                '14:cf:e2:ac:91:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.3',
                                             'mac_address': '14:cf:e2:ac:91:e2',
                                             'name': None},
                '14:cf:e2:ac:f4:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.45',
                                             'mac_address': '14:cf:e2:ac:f4:02',
                                             'name': None},
                '14:cf:e2:ad:50:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.115',
                                             'mac_address': '14:cf:e2:ad:50:a2',
                                             'name': None},
                '14:cf:e2:b0:35:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.73',
                                             'mac_address': '14:cf:e2:b0:35:32',
                                             'name': None},
                '14:cf:e2:b3:ed:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.78',
                                             'mac_address': '14:cf:e2:b3:ed:f2',
                                             'name': None},
                '14:cf:e2:ba:a5:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.108',
                                             'mac_address': '14:cf:e2:ba:a5:02',
                                             'name': None},
                '20:73:55:9d:8c:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.253',
                                             'mac_address': '20:73:55:9d:8c:52',
                                             'name': None},
                '20:73:55:9d:c2:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.250',
                                             'mac_address': '20:73:55:9d:c2:72',
                                             'name': None},
                '20:73:55:9e:e4:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.199',
                                             'mac_address': '20:73:55:9e:e4:f2',
                                             'name': None},
                '20:73:55:9f:ce:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.152',
                                             'mac_address': '20:73:55:9f:ce:e2',
                                             'name': None},
                '20:73:55:a4:6b:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.137',
                                             'mac_address': '20:73:55:a4:6b:22',
                                             'name': None},
                '20:73:55:a6:13:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.190',
                                             'mac_address': '20:73:55:a6:13:42',
                                             'name': None},
                '20:73:55:a8:ff:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.171',
                                             'mac_address': '20:73:55:a8:ff:d2',
                                             'name': None},
                '20:73:55:a9:1e:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.170',
                                             'mac_address': '20:73:55:a9:1e:c2',
                                             'name': None},
                '20:73:55:a9:2d:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.149',
                                             'mac_address': '20:73:55:a9:2d:62',
                                             'name': None},
                '20:73:55:a9:89:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.228',
                                             'mac_address': '20:73:55:a9:89:b2',
                                             'name': None},
                '20:73:55:a9:b4:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.248',
                                             'mac_address': '20:73:55:a9:b4:42',
                                             'name': None},
                '28:7a:ee:12:22:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.57',
                                             'mac_address': '28:7a:ee:12:22:d2',
                                             'name': None},
                '28:7a:ee:15:6f:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.19',
                                             'mac_address': '28:7a:ee:15:6f:f2',
                                             'name': None},
                '2c:99:24:26:fe:2b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.92',
                                             'mac_address': '2c:99:24:26:fe:2b',
                                             'name': None},
                '2c:99:24:30:47:c3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.216',
                                             'mac_address': '2c:99:24:30:47:c3',
                                             'name': None},
                '2c:99:24:30:6a:f3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.28',
                                             'mac_address': '2c:99:24:30:6a:f3',
                                             'name': None},
                '2c:99:24:30:a5:6b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.22',
                                             'mac_address': '2c:99:24:30:a5:6b',
                                             'name': None},
                '2c:99:24:31:5c:8b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.120',
                                             'mac_address': '2c:99:24:31:5c:8b',
                                             'name': None},
                '2c:99:24:31:94:2b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.192',
                                             'mac_address': '2c:99:24:31:94:2b',
                                             'name': None},
                '2c:99:24:31:94:5b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.185',
                                             'mac_address': '2c:99:24:31:94:5b',
                                             'name': None},
                '2c:99:24:31:94:7b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.162',
                                             'mac_address': '2c:99:24:31:94:7b',
                                             'name': None},
                '2c:99:24:31:96:13': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.186',
                                             'mac_address': '2c:99:24:31:96:13',
                                             'name': None},
                '2c:99:24:31:c8:03': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.183',
                                             'mac_address': '2c:99:24:31:c8:03',
                                             'name': None},
                '2c:99:24:33:be:03': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.174',
                                             'mac_address': '2c:99:24:33:be:03',
                                             'name': None},
                '2c:99:24:34:ba:83': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.108',
                                             'mac_address': '2c:99:24:34:ba:83',
                                             'name': None},
                '2c:99:24:5e:8d:bb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.95',
                                             'mac_address': '2c:99:24:5e:8d:bb',
                                             'name': None},
                '2c:99:24:72:43:33': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.18',
                                             'mac_address': '2c:99:24:72:43:33',
                                             'name': None},
                '2c:99:24:73:b9:73': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.82',
                                             'mac_address': '2c:99:24:73:b9:73',
                                             'name': None},
                '2c:99:24:75:34:23': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.162',
                                             'mac_address': '2c:99:24:75:34:23',
                                             'name': None},
                '2c:99:24:7c:ab:c3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.84',
                                             'mac_address': '2c:99:24:7c:ab:c3',
                                             'name': None},
                '2c:99:24:8e:47:43': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.103',
                                             'mac_address': '2c:99:24:8e:47:43',
                                             'name': None},
                '2c:99:24:8e:49:d3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.109',
                                             'mac_address': '2c:99:24:8e:49:d3',
                                             'name': None},
                '2c:99:24:8e:5f:43': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.88',
                                             'mac_address': '2c:99:24:8e:5f:43',
                                             'name': None},
                '2c:99:24:97:d9:53': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.93',
                                             'mac_address': '2c:99:24:97:d9:53',
                                             'name': None},
                '2c:99:24:97:df:73': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.53',
                                             'mac_address': '2c:99:24:97:df:73',
                                             'name': None},
                '2c:99:24:97:e0:13': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.185',
                                             'mac_address': '2c:99:24:97:e0:13',
                                             'name': None},
                '2c:99:24:97:e3:73': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.132',
                                             'mac_address': '2c:99:24:97:e3:73',
                                             'name': None},
                '2c:99:24:d6:11:30': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.195',
                                             'mac_address': '2c:99:24:d6:11:30',
                                             'name': None},
                '2c:99:24:d6:12:aa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.178',
                                             'mac_address': '2c:99:24:d6:12:aa',
                                             'name': None},
                '2c:99:24:d6:78:af': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.196',
                                             'mac_address': '2c:99:24:d6:78:af',
                                             'name': None},
                '2c:99:24:d6:8a:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.171',
                                             'mac_address': '2c:99:24:d6:8a:fa',
                                             'name': None},
                '2c:99:24:d6:bb:9f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.194',
                                             'mac_address': '2c:99:24:d6:bb:9f',
                                             'name': None},
                '2c:99:24:d7:08:2f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.10',
                                             'mac_address': '2c:99:24:d7:08:2f',
                                             'name': None},
                '2c:99:24:d7:0b:b6': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.111',
                                             'mac_address': '2c:99:24:d7:0b:b6',
                                             'name': None},
                '38:4c:90:7b:0d:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.131',
                                             'mac_address': '38:4c:90:7b:0d:22',
                                             'name': None},
                '38:4c:90:7f:75:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.144',
                                             'mac_address': '38:4c:90:7f:75:22',
                                             'name': None},
                '38:4c:90:91:dd:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.118',
                                             'mac_address': '38:4c:90:91:dd:52',
                                             'name': None},
                '38:4c:90:99:80:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.186',
                                             'mac_address': '38:4c:90:99:80:12',
                                             'name': None},
                '38:70:0c:00:a7:85': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.8',
                                             'mac_address': '38:70:0c:00:a7:85',
                                             'name': None},
                '38:70:0c:02:e6:49': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.130',
                                             'mac_address': '38:70:0c:02:e6:49',
                                             'name': None},
                '38:70:0c:02:f0:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.90',
                                             'mac_address': '38:70:0c:02:f0:c2',
                                             'name': None},
                '38:70:0c:03:86:77': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.124',
                                             'mac_address': '38:70:0c:03:86:77',
                                             'name': None},
                '38:70:0c:05:15:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.129',
                                             'mac_address': '38:70:0c:05:15:62',
                                             'name': None},
                '38:70:0c:3d:9d:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.131',
                                             'mac_address': '38:70:0c:3d:9d:b2',
                                             'name': None},
                '38:70:0c:3e:43:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.97',
                                             'mac_address': '38:70:0c:3e:43:12',
                                             'name': None},
                '38:70:0c:3e:c6:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.128',
                                             'mac_address': '38:70:0c:3e:c6:22',
                                             'name': None},
                '38:70:0c:3e:cd:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.187',
                                             'mac_address': '38:70:0c:3e:cd:a2',
                                             'name': None},
                '38:70:0c:3e:d5:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.95',
                                             'mac_address': '38:70:0c:3e:d5:f2',
                                             'name': None},
                '38:70:0c:40:cb:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.105',
                                             'mac_address': '38:70:0c:40:cb:12',
                                             'name': None},
                '38:70:0c:40:d8:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.188',
                                             'mac_address': '38:70:0c:40:d8:32',
                                             'name': None},
                '38:70:0c:40:df:ba': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.178',
                                             'mac_address': '38:70:0c:40:df:ba',
                                             'name': None},
                '38:70:0c:62:d6:b9': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.183',
                                             'mac_address': '38:70:0c:62:d6:b9',
                                             'name': None},
                '38:70:0c:64:35:e6': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.127',
                                             'mac_address': '38:70:0c:64:35:e6',
                                             'name': None},
                '38:70:0c:66:41:8f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.87',
                                             'mac_address': '38:70:0c:66:41:8f',
                                             'name': None},
                '38:70:0c:66:58:8e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.132',
                                             'mac_address': '38:70:0c:66:58:8e',
                                             'name': None},
                '38:70:0c:67:00:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.199',
                                             'mac_address': '38:70:0c:67:00:e2',
                                             'name': None},
                '38:70:0c:67:13:49': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.197',
                                             'mac_address': '38:70:0c:67:13:49',
                                             'name': None},
                '38:70:0c:67:14:3e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.136',
                                             'mac_address': '38:70:0c:67:14:3e',
                                             'name': None},
                '38:70:0c:68:21:4e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.89',
                                             'mac_address': '38:70:0c:68:21:4e',
                                             'name': None},
                '38:70:0c:68:68:4a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.151',
                                             'mac_address': '38:70:0c:68:68:4a',
                                             'name': None},
                '38:70:0c:69:9f:45': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.31',
                                             'mac_address': '38:70:0c:69:9f:45',
                                             'name': None},
                '38:70:0c:69:e3:a1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.166',
                                             'mac_address': '38:70:0c:69:e3:a1',
                                             'name': None},
                '38:70:0c:6a:82:94': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.137',
                                             'mac_address': '38:70:0c:6a:82:94',
                                             'name': None},
                '38:70:0c:6a:8a:eb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.28',
                                             'mac_address': '38:70:0c:6a:8a:eb',
                                             'name': None},
                '38:70:0c:6a:96:d0': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.133',
                                             'mac_address': '38:70:0c:6a:96:d0',
                                             'name': None},
                '38:70:0c:6a:b7:30': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.116',
                                             'mac_address': '38:70:0c:6a:b7:30',
                                             'name': None},
                '38:70:0c:6a:b8:d4': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.233',
                                             'mac_address': '38:70:0c:6a:b8:d4',
                                             'name': None},
                '38:70:0c:6a:b9:21': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.163',
                                             'mac_address': '38:70:0c:6a:b9:21',
                                             'name': None},
                '38:70:0c:6d:40:8c': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.88',
                                             'mac_address': '38:70:0c:6d:40:8c',
                                             'name': None},
                '38:70:0c:6d:41:ea': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.66',
                                             'mac_address': '38:70:0c:6d:41:ea',
                                             'name': None},
                '38:70:0c:6d:42:a0': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.115',
                                             'mac_address': '38:70:0c:6d:42:a0',
                                             'name': None},
                '38:70:0c:6d:43:b8': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.33',
                                             'mac_address': '38:70:0c:6d:43:b8',
                                             'name': None},
                '38:70:0c:6d:4f:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.120',
                                             'mac_address': '38:70:0c:6d:4f:7a',
                                             'name': None},
                '38:70:0c:6d:52:ec': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.109',
                                             'mac_address': '38:70:0c:6d:52:ec',
                                             'name': None},
                '38:70:0c:7e:8f:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.234',
                                             'mac_address': '38:70:0c:7e:8f:6a',
                                             'name': None},
                '38:70:0c:7f:0d:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.11',
                                             'mac_address': '38:70:0c:7f:0d:52',
                                             'name': None},
                '38:70:0c:81:e1:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.35',
                                             'mac_address': '38:70:0c:81:e1:02',
                                             'name': None},
                '38:70:0c:81:e3:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.68',
                                             'mac_address': '38:70:0c:81:e3:02',
                                             'name': None},
                '38:70:0c:82:51:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.97',
                                             'mac_address': '38:70:0c:82:51:fa',
                                             'name': None},
                '38:70:0c:82:e8:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.25',
                                             'mac_address': '38:70:0c:82:e8:52',
                                             'name': None},
                '38:70:0c:83:66:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.90',
                                             'mac_address': '38:70:0c:83:66:32',
                                             'name': None},
                '38:70:0c:83:78:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.88',
                                             'mac_address': '38:70:0c:83:78:6a',
                                             'name': None},
                '38:70:0c:8e:af:d3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.104',
                                             'mac_address': '38:70:0c:8e:af:d3',
                                             'name': None},
                '38:70:0c:8f:19:5f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.9',
                                             'mac_address': '38:70:0c:8f:19:5f',
                                             'name': None},
                '38:70:0c:8f:1f:da': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.73',
                                             'mac_address': '38:70:0c:8f:1f:da',
                                             'name': None},
                '38:70:0c:8f:29:2d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.114',
                                             'mac_address': '38:70:0c:8f:29:2d',
                                             'name': None},
                '38:70:0c:8f:3c:66': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.49',
                                             'mac_address': '38:70:0c:8f:3c:66',
                                             'name': None},
                '38:70:0c:8f:3c:74': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.141',
                                             'mac_address': '38:70:0c:8f:3c:74',
                                             'name': None},
                '38:70:0c:8f:3f:d8': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.134',
                                             'mac_address': '38:70:0c:8f:3f:d8',
                                             'name': None},
                '38:70:0c:8f:43:0b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.84',
                                             'mac_address': '38:70:0c:8f:43:0b',
                                             'name': None},
                '38:70:0c:8f:51:c1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.138',
                                             'mac_address': '38:70:0c:8f:51:c1',
                                             'name': None},
                '38:70:0c:8f:58:20': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.225',
                                             'mac_address': '38:70:0c:8f:58:20',
                                             'name': None},
                '38:70:0c:8f:5d:28': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.126',
                                             'mac_address': '38:70:0c:8f:5d:28',
                                             'name': None},
                '38:70:0c:8f:61:49': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.47',
                                             'mac_address': '38:70:0c:8f:61:49',
                                             'name': None},
                '38:70:0c:8f:6e:93': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.85',
                                             'mac_address': '38:70:0c:8f:6e:93',
                                             'name': None},
                '38:70:0c:8f:87:a6': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.91',
                                             'mac_address': '38:70:0c:8f:87:a6',
                                             'name': None},
                '38:70:0c:8f:89:20': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.119',
                                             'mac_address': '38:70:0c:8f:89:20',
                                             'name': None},
                '38:70:0c:8f:8a:c4': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.151',
                                             'mac_address': '38:70:0c:8f:8a:c4',
                                             'name': None},
                '38:70:0c:8f:91:f5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.197',
                                             'mac_address': '38:70:0c:8f:91:f5',
                                             'name': None},
                '38:70:0c:8f:95:67': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.110',
                                             'mac_address': '38:70:0c:8f:95:67',
                                             'name': None},
                '38:70:0c:8f:97:89': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.122',
                                             'mac_address': '38:70:0c:8f:97:89',
                                             'name': None},
                '38:70:0c:8f:9d:63': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.6',
                                             'mac_address': '38:70:0c:8f:9d:63',
                                             'name': None},
                '38:70:0c:8f:a8:ae': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.118',
                                             'mac_address': '38:70:0c:8f:a8:ae',
                                             'name': None},
                '38:70:0c:8f:ab:8d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.27',
                                             'mac_address': '38:70:0c:8f:ab:8d',
                                             'name': None},
                '38:70:0c:8f:b3:20': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.225',
                                             'mac_address': '38:70:0c:8f:b3:20',
                                             'name': None},
                '38:70:0c:8f:b7:d4': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.124',
                                             'mac_address': '38:70:0c:8f:b7:d4',
                                             'name': None},
                '38:70:0c:8f:b7:f7': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.9',
                                             'mac_address': '38:70:0c:8f:b7:f7',
                                             'name': None},
                '38:70:0c:8f:ba:97': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.63',
                                             'mac_address': '38:70:0c:8f:ba:97',
                                             'name': None},
                '38:70:0c:8f:bb:af': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.7',
                                             'mac_address': '38:70:0c:8f:bb:af',
                                             'name': None},
                '38:70:0c:8f:bc:ab': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.199',
                                             'mac_address': '38:70:0c:8f:bc:ab',
                                             'name': None},
                '38:70:0c:8f:c7:7f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.91',
                                             'mac_address': '38:70:0c:8f:c7:7f',
                                             'name': None},
                '38:70:0c:8f:c8:7b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.16',
                                             'mac_address': '38:70:0c:8f:c8:7b',
                                             'name': None},
                '38:70:0c:8f:d2:f4': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.139',
                                             'mac_address': '38:70:0c:8f:d2:f4',
                                             'name': None},
                '38:70:0c:8f:d5:16': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.241',
                                             'mac_address': '38:70:0c:8f:d5:16',
                                             'name': None},
                '38:70:0c:92:26:8e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.102',
                                             'mac_address': '38:70:0c:92:26:8e',
                                             'name': None},
                '38:70:0c:92:2f:b0': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.142',
                                             'mac_address': '38:70:0c:92:2f:b0',
                                             'name': None},
                '38:70:0c:92:8d:88': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.43',
                                             'mac_address': '38:70:0c:92:8d:88',
                                             'name': None},
                '38:70:0c:92:9f:be': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.245',
                                             'mac_address': '38:70:0c:92:9f:be',
                                             'name': None},
                '38:70:0c:93:a4:93': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.126',
                                             'mac_address': '38:70:0c:93:a4:93',
                                             'name': None},
                '38:70:0c:93:c6:6d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.123',
                                             'mac_address': '38:70:0c:93:c6:6d',
                                             'name': None},
                '38:70:0c:93:c8:34': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.168',
                                             'mac_address': '38:70:0c:93:c8:34',
                                             'name': None},
                '38:70:0c:93:c9:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.135',
                                             'mac_address': '38:70:0c:93:c9:92',
                                             'name': None},
                '38:70:0c:93:f1:e7': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.33',
                                             'mac_address': '38:70:0c:93:f1:e7',
                                             'name': None},
                '38:70:0c:94:1a:eb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.198',
                                             'mac_address': '38:70:0c:94:1a:eb',
                                             'name': None},
                '38:70:0c:94:1b:93': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.125',
                                             'mac_address': '38:70:0c:94:1b:93',
                                             'name': None},
                '38:70:0c:94:20:40': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.5',
                                             'mac_address': '38:70:0c:94:20:40',
                                             'name': None},
                '38:70:0c:94:21:9e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.145',
                                             'mac_address': '38:70:0c:94:21:9e',
                                             'name': None},
                '38:70:0c:94:2d:a6': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.126',
                                             'mac_address': '38:70:0c:94:2d:a6',
                                             'name': None},
                '38:70:0c:94:32:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.224',
                                             'mac_address': '38:70:0c:94:32:92',
                                             'name': None},
                '38:70:0c:94:36:7b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.34',
                                             'mac_address': '38:70:0c:94:36:7b',
                                             'name': None},
                '38:70:0c:94:41:d4': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.24',
                                             'mac_address': '38:70:0c:94:41:d4',
                                             'name': None},
                '38:70:0c:94:d3:0d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.64',
                                             'mac_address': '38:70:0c:94:d3:0d',
                                             'name': None},
                '38:70:0c:94:e0:ce': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.106',
                                             'mac_address': '38:70:0c:94:e0:ce',
                                             'name': None},
                '38:70:0c:94:ed:38': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.121',
                                             'mac_address': '38:70:0c:94:ed:38',
                                             'name': None},
                '38:70:0c:95:25:fc': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.113',
                                             'mac_address': '38:70:0c:95:25:fc',
                                             'name': None},
                '38:70:0c:95:5b:08': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.202',
                                             'mac_address': '38:70:0c:95:5b:08',
                                             'name': None},
                '38:70:0c:95:70:7f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.70',
                                             'mac_address': '38:70:0c:95:70:7f',
                                             'name': None},
                '38:70:0c:95:fb:7c': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.48',
                                             'mac_address': '38:70:0c:95:fb:7c',
                                             'name': None},
                '38:70:0c:97:24:2a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.50',
                                             'mac_address': '38:70:0c:97:24:2a',
                                             'name': None},
                '38:70:0c:97:24:85': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.215',
                                             'mac_address': '38:70:0c:97:24:85',
                                             'name': None},
                '38:70:0c:97:5e:68': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.69',
                                             'mac_address': '38:70:0c:97:5e:68',
                                             'name': None},
                '38:70:0c:ea:2d:8a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.104',
                                             'mac_address': '38:70:0c:ea:2d:8a',
                                             'name': None},
                '38:70:0c:ea:41:0a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.77',
                                             'mac_address': '38:70:0c:ea:41:0a',
                                             'name': None},
                '38:70:0c:ea:86:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.79',
                                             'mac_address': '38:70:0c:ea:86:7a',
                                             'name': None},
                '38:70:0c:ec:8c:ca': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.179',
                                             'mac_address': '38:70:0c:ec:8c:ca',
                                             'name': None},
                '38:70:0c:ed:04:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.144',
                                             'mac_address': '38:70:0c:ed:04:42',
                                             'name': None},
                '38:70:0c:ed:8c:1a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.140',
                                             'mac_address': '38:70:0c:ed:8c:1a',
                                             'name': None},
                '38:70:0c:ed:8e:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.160',
                                             'mac_address': '38:70:0c:ed:8e:22',
                                             'name': None},
                '38:70:0c:ed:c1:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.184',
                                             'mac_address': '38:70:0c:ed:c1:7a',
                                             'name': None},
                '38:70:0c:ee:ef:1a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.170',
                                             'mac_address': '38:70:0c:ee:ef:1a',
                                             'name': None},
                '38:70:0c:f5:d7:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.111',
                                             'mac_address': '38:70:0c:f5:d7:82',
                                             'name': None},
                '38:70:0c:f6:01:aa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.252',
                                             'mac_address': '38:70:0c:f6:01:aa',
                                             'name': None},
                '3c:7a:8a:76:af:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.138',
                                             'mac_address': '3c:7a:8a:76:af:62',
                                             'name': None},
                '3c:7a:8a:7b:8b:1a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.99',
                                             'mac_address': '3c:7a:8a:7b:8b:1a',
                                             'name': None},
                '3c:7a:8a:7e:3c:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.244',
                                             'mac_address': '3c:7a:8a:7e:3c:52',
                                             'name': None},
                '3c:7a:8a:7e:64:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.15',
                                             'mac_address': '3c:7a:8a:7e:64:a2',
                                             'name': None},
                '3c:7a:8a:7e:93:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.124',
                                             'mac_address': '3c:7a:8a:7e:93:42',
                                             'name': None},
                '3c:7a:8a:7e:99:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.42',
                                             'mac_address': '3c:7a:8a:7e:99:42',
                                             'name': None},
                '3c:7a:8a:7e:ae:5a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.23',
                                             'mac_address': '3c:7a:8a:7e:ae:5a',
                                             'name': None},
                '3c:7a:8a:7e:c7:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.86',
                                             'mac_address': '3c:7a:8a:7e:c7:92',
                                             'name': None},
                '3c:7a:8a:7e:d0:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.51',
                                             'mac_address': '3c:7a:8a:7e:d0:42',
                                             'name': None},
                '3c:7a:8a:7f:c3:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.208',
                                             'mac_address': '3c:7a:8a:7f:c3:72',
                                             'name': None},
                '3c:7a:8a:80:07:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.160',
                                             'mac_address': '3c:7a:8a:80:07:72',
                                             'name': None},
                '3c:7a:8a:81:5a:5a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.157',
                                             'mac_address': '3c:7a:8a:81:5a:5a',
                                             'name': None},
                '3c:7a:8a:eb:59:3a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.96',
                                             'mac_address': '3c:7a:8a:eb:59:3a',
                                             'name': None},
                '3c:7a:8a:ec:0f:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.166',
                                             'mac_address': '3c:7a:8a:ec:0f:92',
                                             'name': None},
                '3c:7a:8a:ec:10:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.153',
                                             'mac_address': '3c:7a:8a:ec:10:c2',
                                             'name': None},
                '3c:7a:8a:ed:90:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.239',
                                             'mac_address': '3c:7a:8a:ed:90:e2',
                                             'name': None},
                '3c:7a:8a:ed:92:aa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.19',
                                             'mac_address': '3c:7a:8a:ed:92:aa',
                                             'name': None},
                '3c:7a:8a:ed:a8:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.175',
                                             'mac_address': '3c:7a:8a:ed:a8:72',
                                             'name': None},
                '3c:7a:8a:ef:17:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.203',
                                             'mac_address': '3c:7a:8a:ef:17:d2',
                                             'name': None},
                '3c:7a:8a:ef:1a:8a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.63',
                                             'mac_address': '3c:7a:8a:ef:1a:8a',
                                             'name': None},
                '3c:7a:8a:ef:31:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.211',
                                             'mac_address': '3c:7a:8a:ef:31:e2',
                                             'name': None},
                '3c:7a:8a:f4:a0:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.4',
                                             'mac_address': '3c:7a:8a:f4:a0:22',
                                             'name': None},
                '3c:7a:8a:f4:aa:ba': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.122',
                                             'mac_address': '3c:7a:8a:f4:aa:ba',
                                             'name': None},
                '3c:7a:8a:f4:b0:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.207',
                                             'mac_address': '3c:7a:8a:f4:b0:02',
                                             'name': None},
                '3c:7a:8a:f4:b0:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.154',
                                             'mac_address': '3c:7a:8a:f4:b0:92',
                                             'name': None},
                '3c:7a:8a:f5:02:5a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.67',
                                             'mac_address': '3c:7a:8a:f5:02:5a',
                                             'name': None},
                '3c:7a:8a:f5:0b:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.20',
                                             'mac_address': '3c:7a:8a:f5:0b:a2',
                                             'name': None},
                '3c:7a:8a:f5:11:ba': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.155',
                                             'mac_address': '3c:7a:8a:f5:11:ba',
                                             'name': None},
                '3c:7a:8a:f5:17:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.30',
                                             'mac_address': '3c:7a:8a:f5:17:02',
                                             'name': None},
                '40:70:09:66:14:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.69',
                                             'mac_address': '40:70:09:66:14:72',
                                             'name': None},
                '40:70:09:6a:8d:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.75',
                                             'mac_address': '40:70:09:6a:8d:b2',
                                             'name': None},
                '40:70:09:6d:b7:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.188',
                                             'mac_address': '40:70:09:6d:b7:72',
                                             'name': None},
                '40:70:09:75:b0:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.32',
                                             'mac_address': '40:70:09:75:b0:32',
                                             'name': None},
                '40:70:09:76:21:5c': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.201',
                                             'mac_address': '40:70:09:76:21:5c',
                                             'name': None},
                '40:70:09:77:59:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.240',
                                             'mac_address': '40:70:09:77:59:52',
                                             'name': None},
                '40:70:09:7a:3d:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.219',
                                             'mac_address': '40:70:09:7a:3d:52',
                                             'name': None},
                '40:70:09:7f:94:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.242',
                                             'mac_address': '40:70:09:7f:94:82',
                                             'name': None},
                '40:70:09:80:90:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.41',
                                             'mac_address': '40:70:09:80:90:52',
                                             'name': None},
                '40:70:09:81:35:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.60',
                                             'mac_address': '40:70:09:81:35:62',
                                             'name': None},
                '40:70:09:81:d9:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.57',
                                             'mac_address': '40:70:09:81:d9:22',
                                             'name': None},
                '40:70:09:84:9c:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.176',
                                             'mac_address': '40:70:09:84:9c:f2',
                                             'name': None},
                '40:70:09:88:23:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.160',
                                             'mac_address': '40:70:09:88:23:c2',
                                             'name': None},
                '40:70:09:89:86:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.162',
                                             'mac_address': '40:70:09:89:86:82',
                                             'name': None},
                '40:70:09:89:93:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.161',
                                             'mac_address': '40:70:09:89:93:c2',
                                             'name': None},
                '40:70:09:8a:21:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.53',
                                             'mac_address': '40:70:09:8a:21:62',
                                             'name': None},
                '40:70:09:8b:46:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.2',
                                             'mac_address': '40:70:09:8b:46:02',
                                             'name': None},
                '40:70:09:8e:ce:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.68',
                                             'mac_address': '40:70:09:8e:ce:82',
                                             'name': None},
                '40:70:09:95:08:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.153',
                                             'mac_address': '40:70:09:95:08:72',
                                             'name': None},
                '40:70:09:95:13:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.230',
                                             'mac_address': '40:70:09:95:13:e2',
                                             'name': None},
                '40:70:09:9d:26:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.60',
                                             'mac_address': '40:70:09:9d:26:92',
                                             'name': None},
                '40:70:09:9e:68:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.140',
                                             'mac_address': '40:70:09:9e:68:a2',
                                             'name': None},
                '40:70:09:a6:d3:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.81',
                                             'mac_address': '40:70:09:a6:d3:e2',
                                             'name': None},
                '40:70:09:a7:b2:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.193',
                                             'mac_address': '40:70:09:a7:b2:d2',
                                             'name': None},
                '40:70:09:a8:76:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.39',
                                             'mac_address': '40:70:09:a8:76:f2',
                                             'name': None},
                '40:70:09:ad:31:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.19',
                                             'mac_address': '40:70:09:ad:31:d2',
                                             'name': None},
                '40:70:09:ae:03:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.188',
                                             'mac_address': '40:70:09:ae:03:52',
                                             'name': None},
                '40:70:09:ae:8a:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.191',
                                             'mac_address': '40:70:09:ae:8a:a2',
                                             'name': None},
                '40:70:09:b1:28:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.72',
                                             'mac_address': '40:70:09:b1:28:62',
                                             'name': None},
                '40:70:09:b5:5f:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.93',
                                             'mac_address': '40:70:09:b5:5f:22',
                                             'name': None},
                '40:70:09:b8:b0:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.30',
                                             'mac_address': '40:70:09:b8:b0:82',
                                             'name': None},
                '40:70:09:bb:77:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.52',
                                             'mac_address': '40:70:09:bb:77:52',
                                             'name': None},
                '40:70:09:bc:74:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.23',
                                             'mac_address': '40:70:09:bc:74:32',
                                             'name': None},
                '40:70:09:c0:d7:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.41',
                                             'mac_address': '40:70:09:c0:d7:52',
                                             'name': None},
                '54:65:de:65:52:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.207',
                                             'mac_address': '54:65:de:65:52:52',
                                             'name': None},
                '54:65:de:6f:39:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.103',
                                             'mac_address': '54:65:de:6f:39:12',
                                             'name': None},
                '54:65:de:6f:fc:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.66',
                                             'mac_address': '54:65:de:6f:fc:32',
                                             'name': None},
                '54:65:de:70:82:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.219',
                                             'mac_address': '54:65:de:70:82:d2',
                                             'name': None},
                '54:65:de:78:70:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.36',
                                             'mac_address': '54:65:de:78:70:02',
                                             'name': None},
                '54:65:de:79:e5:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.184',
                                             'mac_address': '54:65:de:79:e5:32',
                                             'name': None},
                '54:65:de:7a:28:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.142',
                                             'mac_address': '54:65:de:7a:28:02',
                                             'name': None},
                '54:65:de:bd:2e:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.238',
                                             'mac_address': '54:65:de:bd:2e:e2',
                                             'name': None},
                '54:65:de:f7:6e:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.99',
                                             'mac_address': '54:65:de:f7:6e:82',
                                             'name': None},
                '5c:57:1a:b6:f6:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.146',
                                             'mac_address': '5c:57:1a:b6:f6:22',
                                             'name': None},
                '5c:8f:e0:00:b8:6b': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.70',
                                             'mac_address': '5c:8f:e0:00:b8:6b',
                                             'name': None},
                '5c:8f:e0:1a:f4:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.112',
                                             'mac_address': '5c:8f:e0:1a:f4:02',
                                             'name': None},
                '5c:8f:e0:1a:fb:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.10',
                                             'mac_address': '5c:8f:e0:1a:fb:fa',
                                             'name': None},
                '5c:8f:e0:1b:05:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.156',
                                             'mac_address': '5c:8f:e0:1b:05:6a',
                                             'name': None},
                '5c:8f:e0:1b:05:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.229',
                                             'mac_address': '5c:8f:e0:1b:05:a2',
                                             'name': None},
                '5c:8f:e0:1b:0d:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.161',
                                             'mac_address': '5c:8f:e0:1b:0d:32',
                                             'name': None},
                '5c:8f:e0:1b:23:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.169',
                                             'mac_address': '5c:8f:e0:1b:23:b2',
                                             'name': None},
                '5c:8f:e0:1c:02:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.25',
                                             'mac_address': '5c:8f:e0:1c:02:92',
                                             'name': None},
                '5c:8f:e0:1c:a3:4a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.205',
                                             'mac_address': '5c:8f:e0:1c:a3:4a',
                                             'name': None},
                '5c:8f:e0:1c:c2:ca': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.177',
                                             'mac_address': '5c:8f:e0:1c:c2:ca',
                                             'name': None},
                '5c:8f:e0:1d:13:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.59',
                                             'mac_address': '5c:8f:e0:1d:13:7a',
                                             'name': None},
                '5c:8f:e0:1e:7f:aa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.6',
                                             'mac_address': '5c:8f:e0:1e:7f:aa',
                                             'name': None},
                '5c:8f:e0:1f:08:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.187',
                                             'mac_address': '5c:8f:e0:1f:08:6a',
                                             'name': None},
                '5c:8f:e0:25:7c:2a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.132',
                                             'mac_address': '5c:8f:e0:25:7c:2a',
                                             'name': None},
                '5c:8f:e0:25:94:33': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.152',
                                             'mac_address': '5c:8f:e0:25:94:33',
                                             'name': None},
                '5c:8f:e0:27:48:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.169',
                                             'mac_address': '5c:8f:e0:27:48:12',
                                             'name': None},
                '5c:8f:e0:28:37:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.164',
                                             'mac_address': '5c:8f:e0:28:37:52',
                                             'name': None},
                '5c:8f:e0:28:3d:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.159',
                                             'mac_address': '5c:8f:e0:28:3d:92',
                                             'name': None},
                '5c:8f:e0:28:58:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.246',
                                             'mac_address': '5c:8f:e0:28:58:32',
                                             'name': None},
                '5c:8f:e0:28:5f:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.2',
                                             'mac_address': '5c:8f:e0:28:5f:42',
                                             'name': None},
                '5c:8f:e0:28:6d:4a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.151',
                                             'mac_address': '5c:8f:e0:28:6d:4a',
                                             'name': None},
                '5c:8f:e0:28:79:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.107',
                                             'mac_address': '5c:8f:e0:28:79:02',
                                             'name': None},
                '5c:8f:e0:29:30:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.141',
                                             'mac_address': '5c:8f:e0:29:30:82',
                                             'name': None},
                '5c:8f:e0:2b:67:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.117',
                                             'mac_address': '5c:8f:e0:2b:67:a2',
                                             'name': None},
                '5c:8f:e0:2b:9c:fb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.5',
                                             'mac_address': '5c:8f:e0:2b:9c:fb',
                                             'name': None},
                '5c:8f:e0:4f:ec:ea': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.77',
                                             'mac_address': '5c:8f:e0:4f:ec:ea',
                                             'name': None},
                '60:19:71:16:4f:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.83',
                                             'mac_address': '60:19:71:16:4f:b2',
                                             'name': None},
                '60:19:71:1f:21:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.90',
                                             'mac_address': '60:19:71:1f:21:42',
                                             'name': None},
                '60:19:71:33:57:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.196',
                                             'mac_address': '60:19:71:33:57:72',
                                             'name': None},
                '60:19:71:37:22:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.39',
                                             'mac_address': '60:19:71:37:22:f2',
                                             'name': None},
                '60:19:71:e1:7d:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.74',
                                             'mac_address': '60:19:71:e1:7d:52',
                                             'name': None},
                '60:19:71:e9:3a:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.100',
                                             'mac_address': '60:19:71:e9:3a:42',
                                             'name': None},
                '60:19:71:ea:e3:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.190',
                                             'mac_address': '60:19:71:ea:e3:52',
                                             'name': None},
                '60:19:71:ec:5e:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.175',
                                             'mac_address': '60:19:71:ec:5e:b2',
                                             'name': None},
                '60:19:71:ef:37:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.150',
                                             'mac_address': '60:19:71:ef:37:c2',
                                             'name': None},
                '60:19:71:f5:16:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.192',
                                             'mac_address': '60:19:71:f5:16:82',
                                             'name': None},
                '60:19:71:f8:ea:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.204',
                                             'mac_address': '60:19:71:f8:ea:92',
                                             'name': None},
                '78:71:9c:8d:9f:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.100',
                                             'mac_address': '78:71:9c:8d:9f:92',
                                             'name': None},
                '78:71:9c:8d:a0:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.44',
                                             'mac_address': '78:71:9c:8d:a0:12',
                                             'name': None},
                '78:71:9c:8d:ac:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.52',
                                             'mac_address': '78:71:9c:8d:ac:72',
                                             'name': None},
                '78:71:9c:91:05:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.45',
                                             'mac_address': '78:71:9c:91:05:82',
                                             'name': None},
                '78:71:9c:91:08:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.176',
                                             'mac_address': '78:71:9c:91:08:a2',
                                             'name': None},
                '78:71:9c:93:92:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.237',
                                             'mac_address': '78:71:9c:93:92:32',
                                             'name': None},
                '78:71:9c:93:a5:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.56',
                                             'mac_address': '78:71:9c:93:a5:f2',
                                             'name': None},
                '78:71:9c:95:76:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.251',
                                             'mac_address': '78:71:9c:95:76:62',
                                             'name': None},
                '78:71:9c:99:44:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.148',
                                             'mac_address': '78:71:9c:99:44:b2',
                                             'name': None},
                '78:71:9c:9b:d1:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.7',
                                             'mac_address': '78:71:9c:9b:d1:a2',
                                             'name': None},
                '78:71:9c:9b:d4:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.24',
                                             'mac_address': '78:71:9c:9b:d4:f2',
                                             'name': None},
                '78:71:9c:9d:ef:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.217',
                                             'mac_address': '78:71:9c:9d:ef:b2',
                                             'name': None},
                '78:71:9c:a1:1b:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.209',
                                             'mac_address': '78:71:9c:a1:1b:82',
                                             'name': None},
                '78:71:9c:a1:3a:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.121',
                                             'mac_address': '78:71:9c:a1:3a:22',
                                             'name': None},
                '8c:09:f4:00:8e:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.21',
                                             'mac_address': '8c:09:f4:00:8e:f2',
                                             'name': None},
                '8c:09:f4:00:bb:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.171',
                                             'mac_address': '8c:09:f4:00:bb:a2',
                                             'name': None},
                '8c:09:f4:01:f3:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.65',
                                             'mac_address': '8c:09:f4:01:f3:12',
                                             'name': None},
                '8c:09:f4:03:10:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.73',
                                             'mac_address': '8c:09:f4:03:10:92',
                                             'name': None},
                '8c:09:f4:06:a6:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.8',
                                             'mac_address': '8c:09:f4:06:a6:22',
                                             'name': None},
                '8c:09:f4:07:0a:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.192',
                                             'mac_address': '8c:09:f4:07:0a:12',
                                             'name': None},
                '8c:09:f4:08:e9:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.113',
                                             'mac_address': '8c:09:f4:08:e9:f2',
                                             'name': None},
                '8c:09:f4:09:7d:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.198',
                                             'mac_address': '8c:09:f4:09:7d:a2',
                                             'name': None},
                '8c:09:f4:0a:72:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.200',
                                             'mac_address': '8c:09:f4:0a:72:62',
                                             'name': None},
                '8c:09:f4:0c:4c:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.154',
                                             'mac_address': '8c:09:f4:0c:4c:12',
                                             'name': None},
                '8c:09:f4:0c:a6:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.146',
                                             'mac_address': '8c:09:f4:0c:a6:82',
                                             'name': None},
                '8c:09:f4:0e:9a:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.206',
                                             'mac_address': '8c:09:f4:0e:9a:12',
                                             'name': None},
                '8c:09:f4:0f:35:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.57',
                                             'mac_address': '8c:09:f4:0f:35:22',
                                             'name': None},
                '8c:09:f4:0f:72:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.50',
                                             'mac_address': '8c:09:f4:0f:72:62',
                                             'name': None},
                '8c:09:f4:10:bf:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.157',
                                             'mac_address': '8c:09:f4:10:bf:f2',
                                             'name': None},
                '8c:09:f4:16:26:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.249',
                                             'mac_address': '8c:09:f4:16:26:92',
                                             'name': None},
                '90:0d:cb:55:a7:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.54',
                                             'mac_address': '90:0d:cb:55:a7:e2',
                                             'name': None},
                '90:0d:cb:56:11:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.44',
                                             'mac_address': '90:0d:cb:56:11:12',
                                             'name': None},
                '90:0d:cb:56:99:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.37',
                                             'mac_address': '90:0d:cb:56:99:d2',
                                             'name': None},
                '90:0d:cb:56:a0:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.128',
                                             'mac_address': '90:0d:cb:56:a0:22',
                                             'name': None},
                '90:0d:cb:57:72:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.43',
                                             'mac_address': '90:0d:cb:57:72:c2',
                                             'name': None},
                '90:0d:cb:57:c4:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.26',
                                             'mac_address': '90:0d:cb:57:c4:12',
                                             'name': None},
                '90:0d:cb:5a:d7:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.89',
                                             'mac_address': '90:0d:cb:5a:d7:82',
                                             'name': None},
                '90:0d:cb:5b:a8:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.3',
                                             'mac_address': '90:0d:cb:5b:a8:22',
                                             'name': None},
                '90:0d:cb:5b:db:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.58',
                                             'mac_address': '90:0d:cb:5b:db:72',
                                             'name': None},
                '90:0d:cb:5c:20:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.8',
                                             'mac_address': '90:0d:cb:5c:20:d2',
                                             'name': None},
                '90:0d:cb:5d:1d:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.39',
                                             'mac_address': '90:0d:cb:5d:1d:c2',
                                             'name': None},
                '90:0d:cb:5d:71:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.174',
                                             'mac_address': '90:0d:cb:5d:71:f2',
                                             'name': None},
                '90:0d:cb:5d:7b:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.127',
                                             'mac_address': '90:0d:cb:5d:7b:d2',
                                             'name': None},
                '90:0d:cb:5d:7c:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.130',
                                             'mac_address': '90:0d:cb:5d:7c:f2',
                                             'name': None},
                '90:0d:cb:5d:b0:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.21',
                                             'mac_address': '90:0d:cb:5d:b0:e2',
                                             'name': None},
                '90:0d:cb:61:4c:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.170',
                                             'mac_address': '90:0d:cb:61:4c:32',
                                             'name': None},
                '90:0d:cb:61:4e:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.97',
                                             'mac_address': '90:0d:cb:61:4e:02',
                                             'name': None},
                '90:1a:ca:59:54:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.64',
                                             'mac_address': '90:1a:ca:59:54:b2',
                                             'name': None},
                '90:1a:ca:59:76:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.6',
                                             'mac_address': '90:1a:ca:59:76:c2',
                                             'name': None},
                '90:1a:ca:5c:75:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.91',
                                             'mac_address': '90:1a:ca:5c:75:32',
                                             'name': None},
                '90:1a:ca:5c:f0:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.38',
                                             'mac_address': '90:1a:ca:5c:f0:f2',
                                             'name': None},
                '90:1a:ca:5e:17:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.62',
                                             'mac_address': '90:1a:ca:5e:17:f2',
                                             'name': None},
                '90:1a:ca:62:de:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.226',
                                             'mac_address': '90:1a:ca:62:de:62',
                                             'name': None},
                '90:1a:ca:67:d6:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.3',
                                             'mac_address': '90:1a:ca:67:d6:72',
                                             'name': None},
                '90:1a:ca:68:b5:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.46',
                                             'mac_address': '90:1a:ca:68:b5:42',
                                             'name': None},
                '90:1a:ca:6d:d2:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.211',
                                             'mac_address': '90:1a:ca:6d:d2:f2',
                                             'name': None},
                '90:1a:ca:6e:be:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.115',
                                             'mac_address': '90:1a:ca:6e:be:b2',
                                             'name': None},
                '90:1a:ca:75:8d:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.71',
                                             'mac_address': '90:1a:ca:75:8d:32',
                                             'name': None},
                '90:1a:ca:78:e1:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.31',
                                             'mac_address': '90:1a:ca:78:e1:82',
                                             'name': None},
                '90:1a:ca:79:55:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.58',
                                             'mac_address': '90:1a:ca:79:55:d2',
                                             'name': None},
                '90:1a:ca:7a:02:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.249',
                                             'mac_address': '90:1a:ca:7a:02:02',
                                             'name': None},
                '90:1a:ca:7a:95:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.106',
                                             'mac_address': '90:1a:ca:7a:95:62',
                                             'name': None},
                '90:1a:ca:7b:66:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.77',
                                             'mac_address': '90:1a:ca:7b:66:52',
                                             'name': None},
                '90:1a:ca:7b:6f:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.239',
                                             'mac_address': '90:1a:ca:7b:6f:e2',
                                             'name': None},
                '90:1a:ca:7b:b4:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.37',
                                             'mac_address': '90:1a:ca:7b:b4:52',
                                             'name': None},
                '90:1a:ca:7b:cc:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.235',
                                             'mac_address': '90:1a:ca:7b:cc:b2',
                                             'name': None},
                '90:1a:ca:7c:37:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.193',
                                             'mac_address': '90:1a:ca:7c:37:32',
                                             'name': None},
                '90:1a:ca:7c:5b:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.182',
                                             'mac_address': '90:1a:ca:7c:5b:d2',
                                             'name': None},
                '90:1a:ca:7f:56:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.51',
                                             'mac_address': '90:1a:ca:7f:56:42',
                                             'name': None},
                '90:1a:ca:80:86:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.189',
                                             'mac_address': '90:1a:ca:80:86:92',
                                             'name': None},
                '90:1a:ca:d3:b8:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.94',
                                             'mac_address': '90:1a:ca:d3:b8:f2',
                                             'name': None},
                '90:1a:ca:d6:09:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.251',
                                             'mac_address': '90:1a:ca:d6:09:02',
                                             'name': None},
                '90:1a:ca:da:f7:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.76',
                                             'mac_address': '90:1a:ca:da:f7:42',
                                             'name': None},
                '90:1a:ca:db:4f:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.255',
                                             'mac_address': '90:1a:ca:db:4f:32',
                                             'name': None},
                '90:1a:ca:db:8f:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.194',
                                             'mac_address': '90:1a:ca:db:8f:22',
                                             'name': None},
                '90:1a:ca:db:b7:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.55',
                                             'mac_address': '90:1a:ca:db:b7:f2',
                                             'name': None},
                '90:1a:ca:db:ef:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.236',
                                             'mac_address': '90:1a:ca:db:ef:32',
                                             'name': None},
                '90:1a:ca:db:f7:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.105',
                                             'mac_address': '90:1a:ca:db:f7:42',
                                             'name': None},
                '90:1a:ca:dc:01:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.24',
                                             'mac_address': '90:1a:ca:dc:01:72',
                                             'name': None},
                '90:1a:ca:dc:21:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.80',
                                             'mac_address': '90:1a:ca:dc:21:12',
                                             'name': None},
                '90:1a:ca:dd:4d:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.22',
                                             'mac_address': '90:1a:ca:dd:4d:32',
                                             'name': None},
                '90:1a:ca:e3:2c:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.153',
                                             'mac_address': '90:1a:ca:e3:2c:22',
                                             'name': None},
                '94:87:7c:04:d7:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.48',
                                             'mac_address': '94:87:7c:04:d7:92',
                                             'name': None},
                '94:87:7c:05:42:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.243',
                                             'mac_address': '94:87:7c:05:42:12',
                                             'name': None},
                '94:87:7c:05:46:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.237',
                                             'mac_address': '94:87:7c:05:46:72',
                                             'name': None},
                '94:87:7c:05:5d:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.213',
                                             'mac_address': '94:87:7c:05:5d:12',
                                             'name': None},
                '94:87:7c:06:b2:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.32',
                                             'mac_address': '94:87:7c:06:b2:f2',
                                             'name': None},
                '94:87:7c:07:35:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.184',
                                             'mac_address': '94:87:7c:07:35:62',
                                             'name': None},
                '94:87:7c:07:40:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.0',
                                             'mac_address': '94:87:7c:07:40:52',
                                             'name': None},
                '94:87:7c:08:fc:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.46',
                                             'mac_address': '94:87:7c:08:fc:82',
                                             'name': None},
                '94:87:7c:0a:f9:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.238',
                                             'mac_address': '94:87:7c:0a:f9:32',
                                             'name': None},
                '94:87:7c:0b:0c:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.30',
                                             'mac_address': '94:87:7c:0b:0c:e2',
                                             'name': None},
                '94:87:7c:0c:bb:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.125',
                                             'mac_address': '94:87:7c:0c:bb:02',
                                             'name': None},
                '94:87:7c:0d:9f:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.127',
                                             'mac_address': '94:87:7c:0d:9f:e2',
                                             'name': None},
                '94:87:7c:10:67:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.54',
                                             'mac_address': '94:87:7c:10:67:32',
                                             'name': None},
                '98:6b:3d:c1:a9:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.158',
                                             'mac_address': '98:6b:3d:c1:a9:12',
                                             'name': None},
                '98:6b:3d:c4:a3:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.218',
                                             'mac_address': '98:6b:3d:c4:a3:52',
                                             'name': None},
                '98:6b:3d:ca:33:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.102',
                                             'mac_address': '98:6b:3d:ca:33:a2',
                                             'name': None},
                '98:6b:3d:cc:41:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.40',
                                             'mac_address': '98:6b:3d:cc:41:e2',
                                             'name': None},
                '98:6b:3d:d0:36:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.210',
                                             'mac_address': '98:6b:3d:d0:36:72',
                                             'name': None},
                '98:6b:3d:d3:c4:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.145',
                                             'mac_address': '98:6b:3d:d3:c4:12',
                                             'name': None},
                '98:6b:3d:e8:b5:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.83',
                                             'mac_address': '98:6b:3d:e8:b5:e2',
                                             'name': None},
                '98:6b:3d:e9:fa:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.144',
                                             'mac_address': '98:6b:3d:e9:fa:92',
                                             'name': None},
                '98:6b:3d:ea:1e:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.112',
                                             'mac_address': '98:6b:3d:ea:1e:02',
                                             'name': None},
                '98:6b:3d:ea:66:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.111',
                                             'mac_address': '98:6b:3d:ea:66:d2',
                                             'name': None},
                '98:6b:3d:ed:27:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.47',
                                             'mac_address': '98:6b:3d:ed:27:f2',
                                             'name': None},
                '98:6b:3d:ed:29:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.250',
                                             'mac_address': '98:6b:3d:ed:29:72',
                                             'name': None},
                '98:6b:3d:ed:a5:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.43',
                                             'mac_address': '98:6b:3d:ed:a5:42',
                                             'name': None},
                '9c:34:26:43:4b:da': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.193',
                                             'mac_address': '9c:34:26:43:4b:da',
                                             'name': None},
                '9c:34:26:43:ee:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.71',
                                             'mac_address': '9c:34:26:43:ee:6a',
                                             'name': None},
                '9c:34:26:43:f4:9a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.155',
                                             'mac_address': '9c:34:26:43:f4:9a',
                                             'name': None},
                '9c:34:26:43:f5:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.107',
                                             'mac_address': '9c:34:26:43:f5:7a',
                                             'name': None},
                '9c:34:26:43:fb:7a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.136',
                                             'mac_address': '9c:34:26:43:fb:7a',
                                             'name': None},
                '9c:34:26:44:01:1a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.17',
                                             'mac_address': '9c:34:26:44:01:1a',
                                             'name': None},
                '9c:34:26:44:01:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.51',
                                             'mac_address': '9c:34:26:44:01:42',
                                             'name': None},
                '9c:34:26:44:12:ba': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.164',
                                             'mac_address': '9c:34:26:44:12:ba',
                                             'name': None},
                '9c:34:26:44:12:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.28',
                                             'mac_address': '9c:34:26:44:12:fa',
                                             'name': None},
                '9c:34:26:44:13:3a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.167',
                                             'mac_address': '9c:34:26:44:13:3a',
                                             'name': None},
                '9c:34:26:44:14:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.168',
                                             'mac_address': '9c:34:26:44:14:22',
                                             'name': None},
                '9c:34:26:44:19:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.179',
                                             'mac_address': '9c:34:26:44:19:22',
                                             'name': None},
                '9c:34:26:4a:dc:5a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.2',
                                             'mac_address': '9c:34:26:4a:dc:5a',
                                             'name': None},
                '9c:34:26:4a:dd:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.59',
                                             'mac_address': '9c:34:26:4a:dd:b2',
                                             'name': None},
                '9c:34:26:4a:de:6a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.178',
                                             'mac_address': '9c:34:26:4a:de:6a',
                                             'name': None},
                '9c:34:26:4a:de:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.112',
                                             'mac_address': '9c:34:26:4a:de:82',
                                             'name': None},
                '9c:34:26:4a:df:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.29',
                                             'mac_address': '9c:34:26:4a:df:d2',
                                             'name': None},
                '9c:34:26:4f:60:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.172',
                                             'mac_address': '9c:34:26:4f:60:72',
                                             'name': None},
                '9c:34:26:a6:bf:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.64',
                                             'mac_address': '9c:34:26:a6:bf:d2',
                                             'name': None},
                '9c:34:26:a7:20:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.98',
                                             'mac_address': '9c:34:26:a7:20:62',
                                             'name': None},
                '9c:34:26:a7:6b:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.95',
                                             'mac_address': '9c:34:26:a7:6b:32',
                                             'name': None},
                '9c:34:26:a8:24:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.96',
                                             'mac_address': '9c:34:26:a8:24:62',
                                             'name': None},
                '9c:34:26:b2:83:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.54',
                                             'mac_address': '9c:34:26:b2:83:f2',
                                             'name': None},
                'ac:b3:13:05:73:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.150',
                                             'mac_address': 'ac:b3:13:05:73:e2',
                                             'name': None},
                'ac:b3:13:06:05:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.156',
                                             'mac_address': 'ac:b3:13:06:05:c2',
                                             'name': None},
                'ac:b3:13:0b:74:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.134',
                                             'mac_address': 'ac:b3:13:0b:74:82',
                                             'name': None},
                'ac:b3:13:0c:9c:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.229',
                                             'mac_address': 'ac:b3:13:0c:9c:42',
                                             'name': None},
                'ac:b3:13:76:a2:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.167',
                                             'mac_address': 'ac:b3:13:76:a2:a2',
                                             'name': None},
                'ac:b3:13:7f:68:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.203',
                                             'mac_address': 'ac:b3:13:7f:68:02',
                                             'name': None},
                'ac:b3:13:7f:d3:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.14',
                                             'mac_address': 'ac:b3:13:7f:d3:32',
                                             'name': None},
                'ac:b3:13:82:03:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.222',
                                             'mac_address': 'ac:b3:13:82:03:32',
                                             'name': None},
                'ac:b3:13:83:d5:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.36',
                                             'mac_address': 'ac:b3:13:83:d5:e2',
                                             'name': None},
                'ac:b3:13:85:52:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.179',
                                             'mac_address': 'ac:b3:13:85:52:82',
                                             'name': None},
                'ac:b3:13:85:5e:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.67',
                                             'mac_address': 'ac:b3:13:85:5e:a2',
                                             'name': None},
                'ac:b3:13:85:e1:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.66',
                                             'mac_address': 'ac:b3:13:85:e1:12',
                                             'name': None},
                'ac:b3:13:8f:d8:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.106',
                                             'mac_address': 'ac:b3:13:8f:d8:02',
                                             'name': None},
                'ac:b3:13:8f:e1:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.210',
                                             'mac_address': 'ac:b3:13:8f:e1:f2',
                                             'name': None},
                'ac:b3:13:91:a0:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.42',
                                             'mac_address': 'ac:b3:13:91:a0:82',
                                             'name': None},
                'ac:b3:13:91:de:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.25',
                                             'mac_address': 'ac:b3:13:91:de:a2',
                                             'name': None},
                'ac:b3:13:98:38:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.232',
                                             'mac_address': 'ac:b3:13:98:38:32',
                                             'name': None},
                'ac:b3:13:98:cc:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.174',
                                             'mac_address': 'ac:b3:13:98:cc:42',
                                             'name': None},
                'ac:b3:13:98:db:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.221',
                                             'mac_address': 'ac:b3:13:98:db:42',
                                             'name': None},
                'ac:b3:13:9b:ac:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.128',
                                             'mac_address': 'ac:b3:13:9b:ac:62',
                                             'name': None},
                'ac:b3:13:9b:e9:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.15',
                                             'mac_address': 'ac:b3:13:9b:e9:d2',
                                             'name': None},
                'ac:b3:13:a2:62:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.208',
                                             'mac_address': 'ac:b3:13:a2:62:02',
                                             'name': None},
                'ac:b3:13:a2:b3:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.164',
                                             'mac_address': 'ac:b3:13:a2:b3:a2',
                                             'name': None},
                'ac:b3:13:a3:34:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.61',
                                             'mac_address': 'ac:b3:13:a3:34:02',
                                             'name': None},
                'ac:b3:13:a3:b9:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.70',
                                             'mac_address': 'ac:b3:13:a3:b9:22',
                                             'name': None},
                'ac:b3:13:a5:cb:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.101',
                                             'mac_address': 'ac:b3:13:a5:cb:a2',
                                             'name': None},
                'ac:b3:13:a7:2e:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.16',
                                             'mac_address': 'ac:b3:13:a7:2e:42',
                                             'name': None},
                'ac:b3:13:ad:ef:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.240',
                                             'mac_address': 'ac:b3:13:ad:ef:12',
                                             'name': None},
                'ac:b3:13:af:06:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.254',
                                             'mac_address': 'ac:b3:13:af:06:92',
                                             'name': None},
                'ac:b3:13:b2:42:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.226',
                                             'mac_address': 'ac:b3:13:b2:42:12',
                                             'name': None},
                'ac:b3:13:b6:dc:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.110',
                                             'mac_address': 'ac:b3:13:b6:dc:b2',
                                             'name': None},
                'ac:b3:13:b7:9b:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.63',
                                             'mac_address': 'ac:b3:13:b7:9b:92',
                                             'name': None},
                'ac:b3:13:b8:a2:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.248',
                                             'mac_address': 'ac:b3:13:b8:a2:e2',
                                             'name': None},
                'ac:b3:13:c2:68:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.201',
                                             'mac_address': 'ac:b3:13:c2:68:c2',
                                             'name': None},
                'ac:b3:13:c5:a3:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.143',
                                             'mac_address': 'ac:b3:13:c5:a3:c2',
                                             'name': None},
                'ac:ec:80:01:06:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.214',
                                             'mac_address': 'ac:ec:80:01:06:c2',
                                             'name': None},
                'ac:ec:80:02:ed:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.172',
                                             'mac_address': 'ac:ec:80:02:ed:c2',
                                             'name': None},
                'ac:ec:80:03:1a:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.118',
                                             'mac_address': 'ac:ec:80:03:1a:12',
                                             'name': None},
                'ac:ec:80:08:36:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.195',
                                             'mac_address': 'ac:ec:80:08:36:e2',
                                             'name': None},
                'c0:c5:22:41:f9:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.183',
                                             'mac_address': 'c0:c5:22:41:f9:52',
                                             'name': None},
                'c0:c5:22:4d:73:ea': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.7',
                                             'mac_address': 'c0:c5:22:4d:73:ea',
                                             'name': None},
                'c0:c5:22:4e:55:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.244',
                                             'mac_address': 'c0:c5:22:4e:55:c2',
                                             'name': None},
                'c0:c5:22:d5:61:ea': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.194',
                                             'mac_address': 'c0:c5:22:d5:61:ea',
                                             'name': None},
                'c0:c5:22:de:cd:ca': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.31',
                                             'mac_address': 'c0:c5:22:de:cd:ca',
                                             'name': None},
                'c0:c5:22:e1:21:8a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.21',
                                             'mac_address': 'c0:c5:22:e1:21:8a',
                                             'name': None},
                'c0:c5:22:e1:65:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.158',
                                             'mac_address': 'c0:c5:22:e1:65:e2',
                                             'name': None},
                'c0:c5:22:e1:9c:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.133',
                                             'mac_address': 'c0:c5:22:e1:9c:82',
                                             'name': None},
                'c0:c5:22:e2:2b:4a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.172',
                                             'mac_address': 'c0:c5:22:e2:2b:4a',
                                             'name': None},
                'c0:c5:22:e2:2c:ea': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.163',
                                             'mac_address': 'c0:c5:22:e2:2c:ea',
                                             'name': None},
                'c0:c5:22:e2:34:da': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.20',
                                             'mac_address': 'c0:c5:22:e2:34:da',
                                             'name': None},
                'c0:c5:22:e2:92:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.110',
                                             'mac_address': 'c0:c5:22:e2:92:12',
                                             'name': None},
                'c0:c5:22:e2:c4:5a': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.134',
                                             'mac_address': 'c0:c5:22:e2:c4:5a',
                                             'name': None},
                'c0:c5:22:e2:f6:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.108',
                                             'mac_address': 'c0:c5:22:e2:f6:a2',
                                             'name': None},
                'c0:c5:22:e4:05:fa': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.185',
                                             'mac_address': 'c0:c5:22:e4:05:fa',
                                             'name': None},
                'c0:c5:22:fc:86:3e': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.129',
                                             'mac_address': 'c0:c5:22:fc:86:3e',
                                             'name': None},
                'cc:a4:62:24:23:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.186',
                                             'mac_address': 'cc:a4:62:24:23:f2',
                                             'name': None},
                'cc:a4:62:28:16:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.159',
                                             'mac_address': 'cc:a4:62:28:16:92',
                                             'name': None},
                'cc:a4:62:29:de:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.89',
                                             'mac_address': 'cc:a4:62:29:de:f2',
                                             'name': None},
                'cc:a4:62:38:ee:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.131',
                                             'mac_address': 'cc:a4:62:38:ee:a2',
                                             'name': None},
                'cc:a4:62:39:9d:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.26',
                                             'mac_address': 'cc:a4:62:39:9d:62',
                                             'name': None},
                'cc:a4:62:46:98:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.72',
                                             'mac_address': 'cc:a4:62:46:98:22',
                                             'name': None},
                'cc:a4:62:46:a4:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.67',
                                             'mac_address': 'cc:a4:62:46:a4:62',
                                             'name': None},
                'e8:3e:fc:19:ae:a2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.154',
                                             'mac_address': 'e8:3e:fc:19:ae:a2',
                                             'name': None},
                'e8:3e:fc:1e:73:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.223',
                                             'mac_address': 'e8:3e:fc:1e:73:32',
                                             'name': None},
                'e8:89:2c:7d:07:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.147',
                                             'mac_address': 'e8:89:2c:7d:07:92',
                                             'name': None},
                'e8:89:2c:7d:44:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.53',
                                             'mac_address': 'e8:89:2c:7d:44:62',
                                             'name': None},
                'e8:89:2c:7d:c4:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.146',
                                             'mac_address': 'e8:89:2c:7d:c4:e2',
                                             'name': None},
                'e8:89:2c:7d:f1:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.129',
                                             'mac_address': 'e8:89:2c:7d:f1:c2',
                                             'name': None},
                'e8:89:2c:7d:fc:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.180',
                                             'mac_address': 'e8:89:2c:7d:fc:e2',
                                             'name': None},
                'e8:89:2c:7e:03:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.142',
                                             'mac_address': 'e8:89:2c:7e:03:d2',
                                             'name': None},
                'e8:89:2c:7e:40:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.147',
                                             'mac_address': 'e8:89:2c:7e:40:c2',
                                             'name': None},
                'e8:89:2c:7e:64:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.50',
                                             'mac_address': 'e8:89:2c:7e:64:32',
                                             'name': None},
                'e8:89:2c:7e:8b:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.195',
                                             'mac_address': 'e8:89:2c:7e:8b:62',
                                             'name': None},
                'e8:89:2c:7e:b1:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.218',
                                             'mac_address': 'e8:89:2c:7e:b1:f2',
                                             'name': None},
                'e8:89:2c:81:53:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.101',
                                             'mac_address': 'e8:89:2c:81:53:62',
                                             'name': None},
                'e8:89:2c:81:7c:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.101',
                                             'mac_address': 'e8:89:2c:81:7c:52',
                                             'name': None},
                'e8:89:2c:82:00:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.114',
                                             'mac_address': 'e8:89:2c:82:00:42',
                                             'name': None},
                'e8:89:2c:82:98:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.86',
                                             'mac_address': 'e8:89:2c:82:98:42',
                                             'name': None},
                'e8:89:2c:83:47:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.135',
                                             'mac_address': 'e8:89:2c:83:47:32',
                                             'name': None},
                'e8:ed:05:6d:35:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.252',
                                             'mac_address': 'e8:ed:05:6d:35:72',
                                             'name': None},
                'e8:ed:05:71:33:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.9',
                                             'mac_address': 'e8:ed:05:71:33:82',
                                             'name': None},
                'e8:ed:05:71:8a:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.92',
                                             'mac_address': 'e8:ed:05:71:8a:d2',
                                             'name': None},
                'e8:ed:05:74:3e:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.87',
                                             'mac_address': 'e8:ed:05:74:3e:e2',
                                             'name': None},
                'e8:ed:05:76:1d:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.139',
                                             'mac_address': 'e8:ed:05:76:1d:62',
                                             'name': None},
                'e8:ed:05:7d:a2:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.116',
                                             'mac_address': 'e8:ed:05:7d:a2:32',
                                             'name': None},
                'e8:ed:05:7e:85:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.114',
                                             'mac_address': 'e8:ed:05:7e:85:12',
                                             'name': None},
                'f8:ed:a5:db:1b:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.227',
                                             'mac_address': 'f8:ed:a5:db:1b:32',
                                             'name': None},
                'f8:ed:a5:db:86:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.163',
                                             'mac_address': 'f8:ed:a5:db:86:92',
                                             'name': None},
                'f8:ed:a5:db:8c:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.247',
                                             'mac_address': 'f8:ed:a5:db:8c:52',
                                             'name': None},
                'f8:ed:a5:dc:0f:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.138',
                                             'mac_address': 'f8:ed:a5:dc:0f:02',
                                             'name': None},
                'f8:ed:a5:dc:53:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.143',
                                             'mac_address': 'f8:ed:a5:dc:53:b2',
                                             'name': None},
                'f8:ed:a5:dc:69:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.125',
                                             'mac_address': 'f8:ed:a5:dc:69:62',
                                             'name': None},
                'f8:ed:a5:dc:cb:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.155',
                                             'mac_address': 'f8:ed:a5:dc:cb:02',
                                             'name': None},
                'f8:ed:a5:dc:dd:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.182',
                                             'mac_address': 'f8:ed:a5:dc:dd:c2',
                                             'name': None},
                'f8:ed:a5:dd:34:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.93',
                                             'mac_address': 'f8:ed:a5:dd:34:f2',
                                             'name': None},
                'f8:ed:a5:dd:b9:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.245',
                                             'mac_address': 'f8:ed:a5:dd:b9:f2',
                                             'name': None},
                'f8:ed:a5:de:e8:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.102',
                                             'mac_address': 'f8:ed:a5:de:e8:72',
                                             'name': None},
                'f8:ed:a5:df:81:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.65',
                                             'mac_address': 'f8:ed:a5:df:81:12',
                                             'name': None},
                'f8:ed:a5:df:9f:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.83',
                                             'mac_address': 'f8:ed:a5:df:9f:92',
                                             'name': None},
                'f8:ed:a5:df:e0:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.38.165',
                                             'mac_address': 'f8:ed:a5:df:e0:12',
                                             'name': None},
                'f8:ed:a5:e0:0e:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.133',
                                             'mac_address': 'f8:ed:a5:e0:0e:62',
                                             'name': None},
                'f8:ed:a5:e0:1d:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.119',
                                             'mac_address': 'f8:ed:a5:e0:1d:72',
                                             'name': None},
                'f8:ed:a5:e0:3d:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.103',
                                             'mac_address': 'f8:ed:a5:e0:3d:b2',
                                             'name': None},
                'f8:ed:a5:e0:82:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.13',
                                             'mac_address': 'f8:ed:a5:e0:82:e2',
                                             'name': None},
                'f8:ed:a5:e0:b2:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.13',
                                             'mac_address': 'f8:ed:a5:e0:b2:d2',
                                             'name': None},
                'f8:ed:a5:e0:d4:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.191',
                                             'mac_address': 'f8:ed:a5:e0:d4:02',
                                             'name': None},
                'f8:ed:a5:e0:fc:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.49',
                                             'mac_address': 'f8:ed:a5:e0:fc:d2',
                                             'name': None},
                'f8:ed:a5:e5:0d:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.4',
                                             'mac_address': 'f8:ed:a5:e5:0d:02',
                                             'name': None},
                'f8:ed:a5:e5:2c:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.74',
                                             'mac_address': 'f8:ed:a5:e5:2c:42',
                                             'name': None},
                'f8:ed:a5:e5:8d:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.11',
                                             'mac_address': 'f8:ed:a5:e5:8d:22',
                                             'name': None},
                'f8:ed:a5:e5:92:c2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.198',
                                             'mac_address': 'f8:ed:a5:e5:92:c2',
                                             'name': None},
                'f8:ed:a5:e5:b0:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.56',
                                             'mac_address': 'f8:ed:a5:e5:b0:42',
                                             'name': None},
                'f8:ed:a5:e6:3d:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.15',
                                             'mac_address': 'f8:ed:a5:e6:3d:02',
                                             'name': None},
                'f8:ed:a5:e6:c5:b2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.130',
                                             'mac_address': 'f8:ed:a5:e6:c5:b2',
                                             'name': None},
                'f8:ed:a5:e6:c9:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.17',
                                             'mac_address': 'f8:ed:a5:e6:c9:82',
                                             'name': None},
                'f8:ed:a5:e6:d3:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.181',
                                             'mac_address': 'f8:ed:a5:e6:d3:22',
                                             'name': None},
                'f8:ed:a5:e6:e9:62': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.56',
                                             'mac_address': 'f8:ed:a5:e6:e9:62',
                                             'name': None},
                'f8:ed:a5:e7:3e:92': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.180',
                                             'mac_address': 'f8:ed:a5:e7:3e:92',
                                             'name': None},
                'f8:ed:a5:e7:ec:22': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.27',
                                             'mac_address': 'f8:ed:a5:e7:ec:22',
                                             'name': None},
                'f8:ed:a5:e7:f9:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.68',
                                             'mac_address': 'f8:ed:a5:e7:f9:32',
                                             'name': None},
                'f8:ed:a5:e8:23:52': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.161',
                                             'mac_address': 'f8:ed:a5:e8:23:52',
                                             'name': None},
                'f8:ed:a5:e8:3d:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.209',
                                             'mac_address': 'f8:ed:a5:e8:3d:d2',
                                             'name': None},
                'f8:ed:a5:e8:77:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.135',
                                             'mac_address': 'f8:ed:a5:e8:77:32',
                                             'name': None},
                'f8:ed:a5:ee:cd:32': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.16',
                                             'mac_address': 'f8:ed:a5:ee:cd:32',
                                             'name': None},
                'f8:ed:a5:f0:74:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.116',
                                             'mac_address': 'f8:ed:a5:f0:74:12',
                                             'name': None},
                'f8:ed:a5:f0:7c:72': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.98',
                                             'mac_address': 'f8:ed:a5:f0:7c:72',
                                             'name': None},
                'f8:ed:a5:f0:ee:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.86',
                                             'mac_address': 'f8:ed:a5:f0:ee:e2',
                                             'name': None},
                'f8:ed:a5:f1:73:f2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.78',
                                             'mac_address': 'f8:ed:a5:f1:73:f2',
                                             'name': None},
                'f8:ed:a5:f1:80:d2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.62',
                                             'mac_address': 'f8:ed:a5:f1:80:d2',
                                             'name': None},
                'f8:ed:a5:f1:c6:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.117',
                                             'mac_address': 'f8:ed:a5:f1:c6:82',
                                             'name': None},
                'f8:ed:a5:f1:dd:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.22',
                                             'mac_address': 'f8:ed:a5:f1:dd:82',
                                             'name': None},
                'f8:ed:a5:f1:e3:12': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.99',
                                             'mac_address': 'f8:ed:a5:f1:e3:12',
                                             'name': None},
                'f8:ed:a5:f1:e3:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.37.36',
                                             'mac_address': 'f8:ed:a5:f1:e3:82',
                                             'name': None},
                'f8:ed:a5:f1:e5:82': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.119',
                                             'mac_address': 'f8:ed:a5:f1:e5:82',
                                             'name': None},
                'f8:ed:a5:f2:4e:e2': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.94',
                                             'mac_address': 'f8:ed:a5:f2:4e:e2',
                                             'name': None},
                'f8:ed:a5:f2:5c:02': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.104',
                                             'mac_address': 'f8:ed:a5:f2:5c:02',
                                             'name': None},
                'f8:ed:a5:f2:5d:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.206',
                                             'mac_address': 'f8:ed:a5:f2:5d:42',
                                             'name': None},
                'f8:ed:a5:f2:b5:42': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'ip_address': '10.0.36.85',
                                             'mac_address': 'f8:ed:a5:f2:b5:42',
                                             'name': None}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_cmts_minicmts_MiniCMTS_3_89_75_01(self):
        obj = self.run_data("cmts.minicmts.MiniCMTS.3.89.75.01")
        exp_info = {
         'model': 'MiniCMTS', 'sw_version': None, 'vendor': 'CMTS'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '08:36:c9:5a:96:30': {       'alt_macs': set(),
                                             'dev_macs': {'08:36:c9:5a:96:31'},
                                             'ip_address': '10.11.81.116',
                                             'mac_address': '08:36:c9:5a:96:30',
                                             'name': None},
                '08:36:c9:5a:97:88': {       'alt_macs': set(),
                                             'dev_macs': {'08:36:c9:5a:97:89'},
                                             'ip_address': '10.11.81.122',
                                             'mac_address': '08:36:c9:5a:97:88',
                                             'name': None},
                '08:36:c9:5a:e2:28': {       'alt_macs': set(),
                                             'dev_macs': {'08:36:c9:5a:e2:29'},
                                             'ip_address': '10.11.81.155',
                                             'mac_address': '08:36:c9:5a:e2:28',
                                             'name': None},
                '14:59:c0:0a:d4:50': {       'alt_macs': set(),
                                             'dev_macs': {'14:59:c0:0a:d4:51'},
                                             'ip_address': '10.11.81.117',
                                             'mac_address': '14:59:c0:0a:d4:50',
                                             'name': None},
                '14:59:c0:fd:c6:a8': {       'alt_macs': set(),
                                             'dev_macs': {'14:59:c0:fd:c6:a9'},
                                             'ip_address': '10.11.81.127',
                                             'mac_address': '14:59:c0:fd:c6:a8',
                                             'name': None},
                '14:59:c0:fd:d9:88': {       'alt_macs': set(),
                                             'dev_macs': {'14:59:c0:fd:d9:89'},
                                             'ip_address': '10.11.81.132',
                                             'mac_address': '14:59:c0:fd:d9:88',
                                             'name': None},
                '18:a6:f7:b2:d3:fc': {       'alt_macs': set(),
                                             'dev_macs': {'18:a6:f7:b2:d3:fe'},
                                             'ip_address': '10.11.81.247',
                                             'mac_address': '18:a6:f7:b2:d3:fc',
                                             'name': None},
                '18:a6:f7:b3:12:54': {       'alt_macs': set(),
                                             'dev_macs': {'18:a6:f7:b3:12:56'},
                                             'ip_address': '10.11.81.223',
                                             'mac_address': '18:a6:f7:b3:12:54',
                                             'name': None},
                '18:a6:f7:bd:8b:c0': {       'alt_macs': set(),
                                             'dev_macs': {'18:a6:f7:bd:8b:c2'},
                                             'ip_address': '10.11.81.171',
                                             'mac_address': '18:a6:f7:bd:8b:c0',
                                             'name': None},
                '18:a6:f7:bd:a4:0c': {       'alt_macs': set(),
                                             'dev_macs': {'18:a6:f7:bd:a4:0e'},
                                             'ip_address': '10.11.81.118',
                                             'mac_address': '18:a6:f7:bd:a4:0c',
                                             'name': None},
                '28:80:88:19:49:18': {       'alt_macs': set(),
                                             'dev_macs': {'28:80:88:19:49:19'},
                                             'ip_address': '10.11.81.135',
                                             'mac_address': '28:80:88:19:49:18',
                                             'name': None},
                '28:80:88:a0:4c:20': {       'alt_macs': set(),
                                             'dev_macs': {'28:80:88:a0:4c:21'},
                                             'ip_address': '10.11.81.145',
                                             'mac_address': '28:80:88:a0:4c:20',
                                             'name': None},
                '28:80:88:a0:59:f8': {       'alt_macs': set(),
                                             'dev_macs': {'28:80:88:a0:59:f9'},
                                             'ip_address': '10.11.81.123',
                                             'mac_address': '28:80:88:a0:59:f8',
                                             'name': None},
                '28:80:88:a0:5a:30': {       'alt_macs': set(),
                                             'dev_macs': {'28:80:88:a0:5a:31'},
                                             'ip_address': '10.11.81.130',
                                             'mac_address': '28:80:88:a0:5a:30',
                                             'name': None},
                '38:94:ed:e9:1a:80': {       'alt_macs': set(),
                                             'dev_macs': {'38:94:ed:e9:1a:81'},
                                             'ip_address': '10.11.81.142',
                                             'mac_address': '38:94:ed:e9:1a:80',
                                             'name': None},
                '3c:37:86:00:b7:70': {       'alt_macs': set(),
                                             'dev_macs': {'3c:37:86:00:b7:71'},
                                             'ip_address': '10.11.81.139',
                                             'mac_address': '3c:37:86:00:b7:70',
                                             'name': None},
                '3c:37:86:de:2f:98': {       'alt_macs': set(),
                                             'dev_macs': {'3c:37:86:de:2f:99'},
                                             'ip_address': '10.11.81.160',
                                             'mac_address': '3c:37:86:de:2f:98',
                                             'name': None},
                '7c:8b:ca:39:fd:58': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:39:fd:5a'},
                                             'ip_address': '10.11.81.136',
                                             'mac_address': '7c:8b:ca:39:fd:58',
                                             'name': None},
                '7c:8b:ca:3a:10:bc': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:3a:10:be'},
                                             'ip_address': '10.11.81.121',
                                             'mac_address': '7c:8b:ca:3a:10:bc',
                                             'name': None},
                '7c:8b:ca:3a:23:08': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:3a:23:0a'},
                                             'ip_address': '10.11.81.161',
                                             'mac_address': '7c:8b:ca:3a:23:08',
                                             'name': None},
                '7c:8b:ca:3a:29:c8': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:3a:29:ca'},
                                             'ip_address': '10.11.81.162',
                                             'mac_address': '7c:8b:ca:3a:29:c8',
                                             'name': None},
                '7c:8b:ca:3e:a4:c4': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:3e:a4:c6'},
                                             'ip_address': '10.11.81.182',
                                             'mac_address': '7c:8b:ca:3e:a4:c4',
                                             'name': None},
                '7c:8b:ca:44:2b:2c': {       'alt_macs': set(),
                                             'dev_macs': {'7c:8b:ca:44:2b:2e'},
                                             'ip_address': '10.11.81.140',
                                             'mac_address': '7c:8b:ca:44:2b:2c',
                                             'name': None},
                '7c:8b:ca:44:39:fc': {       'alt_macs': set(),
                                             'dev_macs': {       '08:d4:0c:6c:8f:e0',
                                                                 '26:ca:b2:a6:bd:ca',
                                                                 '30:63:6b:5f:c9:09',
                                                                 '5e:ac:7a:8a:d3:26',
                                                                 '6e:1f:a9:27:c9:0f',
                                                                 '80:e8:6f:60:0d:c4',
                                                                 '8c:ea:48:b6:6e:52',
                                                                 'a8:1d:16:7f:56:a1',
                                                                 'ce:11:ba:38:c3:f4'},
                                             'ip_address': '10.11.81.125',
                                             'mac_address': '7c:8b:ca:44:39:fc',
                                             'name': None},
                '94:a6:7e:19:da:6c': {       'alt_macs': set(),
                                             'dev_macs': {'94:a6:7e:19:da:6d'},
                                             'ip_address': '10.11.81.129',
                                             'mac_address': '94:a6:7e:19:da:6c',
                                             'name': None},
                '9c:c9:eb:02:a0:48': {       'alt_macs': set(),
                                             'dev_macs': {'9c:c9:eb:02:a0:49'},
                                             'ip_address': '10.11.81.128',
                                             'mac_address': '9c:c9:eb:02:a0:48',
                                             'name': None},
                'bc:a5:11:84:39:cc': {       'alt_macs': set(),
                                             'dev_macs': {'bc:a5:11:84:39:cd'},
                                             'ip_address': '10.11.81.137',
                                             'mac_address': 'bc:a5:11:84:39:cc',
                                             'name': None},
                'd4:6e:0e:8f:97:78': {       'alt_macs': set(),
                                             'dev_macs': {'d4:6e:0e:8f:97:7a'},
                                             'ip_address': '10.11.81.210',
                                             'mac_address': 'd4:6e:0e:8f:97:78',
                                             'name': None}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
