import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 22,
                'sw_version': '4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 6
        }
        exp_sta_stats = {
                '68:d7:9a:06:a7:41': {       'dev_macs': ['2c:c8:1b:49:4c:df'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:a7:41',
                                             'name': '#15 14753 Melissa Smith'},
                '74:83:c2:43:fe:e7': {       'dev_macs': ['48:8f:5a:4e:d4:26'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:fe:e7',
                                             'name': '#10 12707 Laurel Schrang'},
                '74:83:c2:68:1f:80': {       'dev_macs': ['2c:c8:1b:49:64:1f'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:1f:80',
                                             'name': '#21 13024 Cindy Klugiewicz'},
                '74:83:c2:68:1f:fe': {       'dev_macs': ['48:8f:5a:c4:3d:5d'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:1f:fe',
                                             'name': '#17 12855 Pam Walter'},
                'b4:fb:e4:79:90:0b': {       'dev_macs': [       'c4:ad:34:40:74:55',
                                                                 'f0:9f:c2:08:80:d0'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:0b',
                                             'name': '#19 11810 Jason Davis'},
                'b4:fb:e4:79:90:51': {       'dev_macs': ['48:8f:5a:4e:d3:cb'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:51',
                                             'name': '#09 12025 Benjamin Durr'},
                'b4:fb:e4:79:90:92': {       'dev_macs': ['cc:2d:e0:91:ac:c5'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:92',
                                             'name': '#08 12313 Debra Zimbelman'},
                'b4:fb:e4:79:90:e2': {       'dev_macs': ['2c:c8:1b:49:63:8b'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:e2',
                                             'name': '#16 12185 Cody Chevalier'},
                'b4:fb:e4:79:9c:72': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:9c:72',
                                             'name': '#12 12449 VACANT'},
                'b4:fb:e4:eb:10:2c': {       'dev_macs': ['08:55:31:81:b3:22'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:10:2c',
                                             'name': '#02 11503 Nicholas Brieger'},
                'b4:fb:e4:eb:2b:57': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2b:57',
                                             'name': '#06 12193 VACANT'},
                'b4:fb:e4:eb:2b:d4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2b:d4',
                                             'name': '#22 11499 VACANT'},
                'b4:fb:e4:eb:2d:78': {       'dev_macs': ['c4:ad:34:40:73:ce'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2d:78',
                                             'name': '#14 11601 Nicholas Peters'},
                'b4:fb:e4:f9:d6:88': {       'dev_macs': ['cc:2d:e0:91:ae:a8'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d6:88',
                                             'name': '#04 11629 Kristoffer Totos'},
                'b4:fb:e4:f9:d7:2d': {       'dev_macs': ['c4:ad:34:40:73:89'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:2d',
                                             'name': '#18 11537 Michael White'},
                'b4:fb:e4:f9:d7:3c': {       'dev_macs': ['cc:2d:e0:91:27:6e'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:3c',
                                             'name': '#23 11507 Chuck Rickards'},
                'b4:fb:e4:f9:d7:4b': {       'dev_macs': ['c4:ad:34:40:73:80'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:4b',
                                             'name': '#01 11849 Gary Neff'},
                'b4:fb:e4:f9:d7:55': {       'dev_macs': ['48:8f:5a:4e:d3:d9'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:55',
                                             'name': '#11 11609 Kelly Miller'},
                'b4:fb:e4:f9:d9:4e': {       'dev_macs': ['cc:2d:e0:91:ae:b6'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:4e',
                                             'name': '#20 11541 David Bluel'},
                'b4:fb:e4:f9:d9:62': {       'dev_macs': ['48:8f:5a:4e:d4:0a'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:62',
                                             'name': '#03 11528 Deirdra Hanners'},
                'b4:fb:e4:f9:d9:71': {       'dev_macs': ['cc:2d:e0:91:a4:12'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:71',
                                             'name': '#07 12320 Lucas Piontkowski'},
                'b4:fb:e4:f9:da:f2': {       'dev_macs': ['cc:2d:e0:91:a9:36'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:da:f2',
                                             'name': '#13 11936 Susan Cummings'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '83',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '147589048950',
                                                              'in_ucast_pkts': '525288465',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '136772539615',
                                                              'out_ucast_pkts': '653111196',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkZXRoMGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '17704692984121',
                                                              'in_ucast_pkts': '50631343977',
                                                              'links': [       {       'in_octets': '33519513519',
                                                                                       'out_octets': '902802075472',
                                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxcGVlcmludGY='},
                                                                               {       'in_octets': '27406148601',
                                                                                       'out_octets': '563043547298',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3cGVlcmludGY='},
                                                                               {       'in_octets': '22417660231',
                                                                                       'out_octets': '157368719312',
                                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwcGVlcmludGY='},
                                                                               {       'in_octets': '26911252637',
                                                                                       'out_octets': '257806782917',
                                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlcGVlcmludGY='},
                                                                               {       'in_octets': '2132227246',
                                                                                       'out_octets': '10137328279',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBicGVlcmludGY='},
                                                                               {       'in_octets': '5803933430',
                                                                                       'out_octets': '188152273569',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxcGVlcmludGY='},
                                                                               {       'in_octets': '34183478071',
                                                                                       'out_octets': '1328431239258',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkycGVlcmludGY='},
                                                                               {       'in_octets': '22202458405',
                                                                                       'out_octets': '277506574241',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUycGVlcmludGY='},
                                                                               {       'in_octets': '1652995632',
                                                                                       'out_octets': '36117095748',
                                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjcGVlcmludGY='},
                                                                               {       'in_octets': '34378191363',
                                                                                       'out_octets': '1043877012242',
                                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4cGVlcmludGY='},
                                                                               {       'in_octets': '148556313823',
                                                                                       'out_octets': '1032306600644',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4cGVlcmludGY='},
                                                                               {       'in_octets': '343608052211',
                                                                                       'out_octets': '1033057469488',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkcGVlcmludGY='},
                                                                               {       'in_octets': '4037568999',
                                                                                       'out_octets': '21436654479',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjcGVlcmludGY='},
                                                                               {       'in_octets': '19600919925',
                                                                                       'out_octets': '188335141438',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRicGVlcmludGY='},
                                                                               {       'in_octets': '37886659693',
                                                                                       'out_octets': '561600328813',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1cGVlcmludGY='},
                                                                               {       'in_octets': '6338788982',
                                                                                       'out_octets': '77777982154',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlcGVlcmludGY='},
                                                                               {       'in_octets': '100281499482',
                                                                                       'out_octets': '1326028495831',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYycGVlcmludGY='},
                                                                               {       'in_octets': '626219251',
                                                                                       'out_octets': '5502382548',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxcGVlcmludGY='},
                                                                               {       'in_octets': '1049836548',
                                                                                       'out_octets': '34870727506',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYycGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '152',
                                                              'out_octets': '170580221389923',
                                                              'out_ucast_pkts': '125884099823',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY=',
                                                              'pons': [       {       'description': 'Escalante',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '8104559',
                                                                                                               'fiber_length': 160,
                                                                                                               'poller_hash': 'NjhkNzlhMDZhNzQxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2386238',
                                                                                                               'fiber_length': 135,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmZWU3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104560',
                                                                                                               'fiber_length': 89,
                                                                                                               'poller_hash': 'NzQ4M2MyNjgxZjgwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104558',
                                                                                                               'fiber_length': 136,
                                                                                                               'poller_hash': 'NzQ4M2MyNjgxZmZlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1470464',
                                                                                                               'fiber_length': 113,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDBicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4375726',
                                                                                                               'fiber_length': 147,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDUxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104558',
                                                                                                               'fiber_length': 158,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDkycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4386466',
                                                                                                               'fiber_length': 148,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MGUycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1428854',
                                                                                                               'fiber_length': 224,
                                                                                                               'poller_hash': 'YjRmYmU0ZWIxMDJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7072646',
                                                                                                               'fiber_length': 175,
                                                                                                               'poller_hash': 'YjRmYmU0ZWIyZDc4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104550',
                                                                                                               'fiber_length': 201,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNjg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1722055',
                                                                                                               'fiber_length': 124,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzJkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '93459',
                                                                                                               'fiber_length': 84,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzNjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2339528',
                                                                                                               'fiber_length': 235,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzRicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1478964',
                                                                                                               'fiber_length': 140,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzU1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1480754',
                                                                                                               'fiber_length': 100,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTRlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4723717',
                                                                                                               'fiber_length': 213,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '73619',
                                                                                                               'fiber_length': 169,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTcxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '613371',
                                                                                                               'fiber_length': 163,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkYWYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'name': 'pon2',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMmludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'name': 'pon4',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uNGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '170217517125291',
                                                              'in_ucast_pkts': '126109888153',
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-RJ45-1G',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '17649044948354',
                                                              'out_ucast_pkts': '50856362854',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkc2ZwMWludGY=',
                                                              'speed': '1000000000'},
                                                      {       'id': 'sfp2',
                                                              'name': 'SFP+ 2',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkc2ZwMmludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 17.0,
                                'model': 'UFiber OLT4',
                                'serial_number': 'UBNTe4b43f1d',
                                'sw_version': '4.0.5',
                                'system_mac_address': 'b4:fb:e4:b4:3f:1d',
                                'temperature': 34.75,
                                'uptime': '77941385'},
                'peers': [       {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0Nzk5YzcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5YzcycG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0Nzk5YzcyZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#12 12449 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4799c72',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:79:9c:72'},
                                 {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0ZWIyYjU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyYjU3cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0ZWIyYjU3ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#06 12193 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4eb2b57',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:eb:2b:57'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0ZWIyYmQ0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyYmQ0cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0ZWIyYmQ0ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#22 11499 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4eb2bd4',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:eb:2b:d4'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '902802075472',
                                                                       'links': [       {       'in_octets': '902802075472',
                                                                                                'out_octets': '33519513519',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33519513519',
                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104559',
                                                                                                                        'fiber_length': 160,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.908,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.25}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDZhNzQxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:4c:df'],
                                                                       'id': '1',
                                                                       'in_octets': '33519513519',
                                                                       'mac_address': '68:d7:9a:07:a7:41',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '902802075472',
                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#15 14753 Melissa Smith',
                                         'serial_number': 'UBNT9a06a741',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '68:d7:9a:06:a7:41',
                                         'temperature': 38.0,
                                         'uptime': '8104619'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '563043547298',
                                                                       'links': [       {       'in_octets': '563043547298',
                                                                                                'out_octets': '27406148601',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '27406148601',
                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2386238',
                                                                                                                        'fiber_length': 135,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.276,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.01}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmZWU3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d4:26'],
                                                                       'id': '1',
                                                                       'in_octets': '27406148601',
                                                                       'mac_address': '74:83:c2:44:fe:e7',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '563043547298',
                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#10 12707 Laurel Schrang',
                                         'serial_number': 'UBNTc243fee7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:43:fe:e7',
                                         'temperature': 38.0,
                                         'uptime': '3812018'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '157368719312',
                                                                       'links': [       {       'in_octets': '157368719312',
                                                                                                'out_octets': '22417660231',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '22417660231',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104560',
                                                                                                                        'fiber_length': 89,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.93,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.474}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjgxZjgwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:64:1f'],
                                                                       'id': '1',
                                                                       'in_octets': '22417660231',
                                                                       'mac_address': '74:83:c2:69:1f:80',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '157368719312',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#21 13024 Cindy Klugiewicz',
                                         'serial_number': 'UBNTc2681f80',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:68:1f:80',
                                         'temperature': 39.0,
                                         'uptime': '8104619'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '257806782917',
                                                                       'links': [       {       'in_octets': '257806782917',
                                                                                                'out_octets': '26911252637',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '26911252637',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104558',
                                                                                                                        'fiber_length': 136,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.502,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.158}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjgxZmZlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:c4:3d:5d'],
                                                                       'id': '1',
                                                                       'in_octets': '26911252637',
                                                                       'mac_address': '74:83:c2:69:1f:fe',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '257806782917',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#17 12855 Pam Walter',
                                         'serial_number': 'UBNTc2681ffe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:68:1f:fe',
                                         'temperature': 46.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '10137328279',
                                                                       'links': [       {       'in_octets': '10137328279',
                                                                                                'out_octets': '2132227246',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2132227246',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1470464',
                                                                                                                        'fiber_length': 113,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.85,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.542}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDBicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:74:55',
                                                                                                        'f0:9f:c2:08:80:d0'],
                                                                       'id': '1',
                                                                       'in_octets': '2132227246',
                                                                       'mac_address': 'b4:fb:e4:7a:90:0b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10137328279',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#19 11810 Jason Davis',
                                         'serial_number': 'UBNTe479900b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:0b',
                                         'temperature': 45.0,
                                         'uptime': '5233507'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188152273569',
                                                                       'links': [       {       'in_octets': '188152273569',
                                                                                                'out_octets': '5803933430',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5803933430',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4375726',
                                                                                                                        'fiber_length': 147,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.784,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.972}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDUxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d3:cb'],
                                                                       'id': '1',
                                                                       'in_octets': '5803933430',
                                                                       'mac_address': 'b4:fb:e4:7a:90:51',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188152273569',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#09 12025 Benjamin Durr',
                                         'serial_number': 'UBNTe4799051',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:51',
                                         'temperature': 39.0,
                                         'uptime': '8106259'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1328431239258',
                                                                       'links': [       {       'in_octets': '1328431239258',
                                                                                                'out_octets': '34183478071',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '34183478071',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104558',
                                                                                                                        'fiber_length': 158,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.218,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.686}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDkycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ac:c5'],
                                                                       'id': '1',
                                                                       'in_octets': '34183478071',
                                                                       'mac_address': 'b4:fb:e4:7a:90:92',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1328431239258',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#08 12313 Debra Zimbelman',
                                         'serial_number': 'UBNTe4799092',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:92',
                                         'temperature': 57.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '277506574241',
                                                                       'links': [       {       'in_octets': '277506574241',
                                                                                                'out_octets': '22202458405',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '22202458405',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4386466',
                                                                                                                        'fiber_length': 148,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.892,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.908}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MGUycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:63:8b'],
                                                                       'id': '1',
                                                                       'in_octets': '22202458405',
                                                                       'mac_address': 'b4:fb:e4:7a:90:e2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '277506574241',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#16 12185 Cody Chevalier',
                                         'serial_number': 'UBNTe47990e2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:e2',
                                         'temperature': 60.0,
                                         'uptime': '4386526'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '36117095748',
                                                                       'links': [       {       'in_octets': '36117095748',
                                                                                                'out_octets': '1652995632',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1652995632',
                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1428854',
                                                                                                                        'fiber_length': 224,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.186,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.686}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIxMDJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:55:31:81:b3:22'],
                                                                       'id': '1',
                                                                       'in_octets': '1652995632',
                                                                       'mac_address': 'b4:fb:e4:ec:10:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36117095748',
                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#02 11503 Nicholas Brieger',
                                         'serial_number': 'UBNTe4eb102c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:eb:10:2c',
                                         'temperature': 59.0,
                                         'uptime': '2874049'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1043877012242',
                                                                       'links': [       {       'in_octets': '1043877012242',
                                                                                                'out_octets': '34378191363',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '34378191363',
                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7072646',
                                                                                                                        'fiber_length': 175,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.624,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.538}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyZDc4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:ce'],
                                                                       'id': '1',
                                                                       'in_octets': '34378191363',
                                                                       'mac_address': 'b4:fb:e4:ec:2d:78',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1043877012242',
                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#14 11601 Nicholas Peters',
                                         'serial_number': 'UBNTe4eb2d78',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:eb:2d:78',
                                         'temperature': 58.0,
                                         'uptime': '7072701'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1032306600644',
                                                                       'links': [       {       'in_octets': '1032306600644',
                                                                                                'out_octets': '148556313823',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '148556313823',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104550',
                                                                                                                        'fiber_length': 201,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.648,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.492}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNjg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ae:a8'],
                                                                       'id': '1',
                                                                       'in_octets': '148556313823',
                                                                       'mac_address': 'b4:fb:e4:fa:d6:88',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1032306600644',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#04 11629 Kristoffer Totos',
                                         'serial_number': 'UBNTe4f9d688',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d6:88',
                                         'temperature': 41.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1033057469488',
                                                                       'links': [       {       'in_octets': '1033057469488',
                                                                                                'out_octets': '343608052211',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '343608052211',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1722055',
                                                                                                                        'fiber_length': 124,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.536,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.466}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzJkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:89'],
                                                                       'id': '1',
                                                                       'in_octets': '343608052211',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:2d',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1033057469488',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#18 11537 Michael White',
                                         'serial_number': 'UBNTe4f9d72d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:2d',
                                         'temperature': 39.0,
                                         'uptime': '3812461'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '21436654479',
                                                                       'links': [       {       'in_octets': '21436654479',
                                                                                                'out_octets': '4037568999',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4037568999',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '93459',
                                                                                                                        'fiber_length': 84,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.892,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzNjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:27:6e'],
                                                                       'id': '1',
                                                                       'in_octets': '4037568999',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:3c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21436654479',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#23 11507 Chuck Rickards',
                                         'serial_number': 'UBNTe4f9d73c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:3c',
                                         'temperature': 52.0,
                                         'uptime': '240140'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188335141438',
                                                                       'links': [       {       'in_octets': '188335141438',
                                                                                                'out_octets': '19600919925',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '19600919925',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2339528',
                                                                                                                        'fiber_length': 235,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.77,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.72}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzRicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:80'],
                                                                       'id': '1',
                                                                       'in_octets': '19600919925',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:4b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188335141438',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#01 11849 Gary Neff',
                                         'serial_number': 'UBNTe4f9d74b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:4b',
                                         'temperature': 52.0,
                                         'uptime': '3812168'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '561600328813',
                                                                       'links': [       {       'in_octets': '561600328813',
                                                                                                'out_octets': '37886659693',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '37886659693',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1478964',
                                                                                                                        'fiber_length': 140,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.524,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.318}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzU1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d3:d9'],
                                                                       'id': '1',
                                                                       'in_octets': '37886659693',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:55',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '561600328813',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#11 11609 Kelly Miller',
                                         'serial_number': 'UBNTe4f9d755',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:55',
                                         'temperature': 39.0,
                                         'uptime': '3271751'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '77777982154',
                                                                       'links': [       {       'in_octets': '77777982154',
                                                                                                'out_octets': '6338788982',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6338788982',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1480754',
                                                                                                                        'fiber_length': 100,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.732,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.616}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTRlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ae:b6'],
                                                                       'id': '1',
                                                                       'in_octets': '6338788982',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:4e',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '77777982154',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#20 11541 David Bluel',
                                         'serial_number': 'UBNTe4f9d94e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:4e',
                                         'temperature': 50.0,
                                         'uptime': '2345237'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1326028495831',
                                                                       'links': [       {       'in_octets': '1326028495831',
                                                                                                'out_octets': '100281499482',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '100281499482',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4723717',
                                                                                                                        'fiber_length': 213,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.758,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.718}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d4:0a'],
                                                                       'id': '1',
                                                                       'in_octets': '100281499482',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:62',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1326028495831',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#03 11528 Deirdra Hanners',
                                         'serial_number': 'UBNTe4f9d962',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:62',
                                         'temperature': 57.0,
                                         'uptime': '8106099'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '5502382548',
                                                                       'links': [       {       'in_octets': '5502382548',
                                                                                                'out_octets': '626219251',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '626219251',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '73619',
                                                                                                                        'fiber_length': 169,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.938,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.602}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTcxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:a4:12'],
                                                                       'id': '1',
                                                                       'in_octets': '626219251',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:71',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5502382548',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#07 12320 Lucas Piontkowski',
                                         'serial_number': 'UBNTe4f9d971',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:71',
                                         'temperature': 42.0,
                                         'uptime': '73697'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '34870727506',
                                                                       'links': [       {       'in_octets': '34870727506',
                                                                                                'out_octets': '1049836548',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1049836548',
                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '613371',
                                                                                                                        'fiber_length': 163,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.898,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.764}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkYWYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:a9:36'],
                                                                       'id': '1',
                                                                       'in_octets': '1049836548',
                                                                       'mac_address': 'b4:fb:e4:fa:da:f2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '34870727506',
                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#13 11936 Susan Cummings',
                                         'serial_number': 'UBNTe4f9daf2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:da:f2',
                                         'temperature': 40.0,
                                         'uptime': '3812962'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_10_1_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.10.1.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 64,
                'sw_version': '4.10.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 6
        }
        exp_sta_stats = {
                '18:e8:29:f0:d0:52': {       'dev_macs': ['e8:65:d4:ea:38:b7'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:d0:52',
                                             'name': 'Kiki Ilunga 1165 '
                                                     '18:e8:29:f0:d0:52'},
                '18:e8:29:f0:d0:b1': {       'dev_macs': ['b4:0f:3b:01:d3:a7'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:d0:b1',
                                             'name': 'Victoria Johnson 254 '
                                                     '18:e8:29:f0:d0:b1'},
                '18:e8:29:f0:d1:2a': {       'dev_macs': ['b4:0f:3b:01:d1:4f'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:d1:2a',
                                             'name': 'Pinky Chiliza-4815 '
                                                     '18:e8:29:f0:d1:2a'},
                '18:e8:29:f0:d1:33': {       'dev_macs': ['b4:0f:3b:01:bf:df'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:d1:33',
                                             'name': 'Mzokhanyayo Knowledge Khoza - '
                                                     '5066 |18:e8:29:f0:d1:33'},
                '18:e8:29:f0:d1:7e': {       'dev_macs': ['80:af:ca:0b:62:8d'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:d1:7e',
                                             'name': '\u200bHlophe Phandle-2931 '
                                                     '18:e8:29:f0:d1:7e'},
                '68:d7:9a:06:e7:69': {       'dev_macs': ['80:af:ca:02:97:19'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:e7:69',
                                             'name': 'Mothie (Gino) Lallan 472 '
                                                     '68:d7:9a:06:e7:69'},
                '70:a7:41:30:51:f4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:30:51:f4',
                                             'name': 'Brenda Thabitha Dlamini 3351 '
                                                     '70:a7:41:30:51:f4'},
                '70:a7:41:30:a6:60': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:30:a6:60',
                                             'name': 'Neliswa Mngadi-3452 '
                                                     '70:a7:41:30:a6:60'},
                '70:a7:41:30:a7:88': {       'dev_macs': ['80:af:ca:54:ab:3d'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:30:a7:88',
                                             'name': 'Nomthandazo Portia Sebothoma '
                                                     '4748 70:a7:41:30:a7:88'},
                '70:a7:41:30:b2:8c': {       'dev_macs': ['04:95:e6:1f:9a:98'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:30:b2:8c',
                                             'name': 'Monwabisi Christopher Tekete '
                                                     '3468 70:a7:41:30:b2:8c'},
                '70:a7:41:34:ce:b4': {       'dev_macs': ['80:af:ca:02:9e:b1'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:34:ce:b4',
                                             'name': 'Kamran Ali Bajwa-1554 '
                                                     '70:a7:41:34:ce:b4'},
                '70:a7:41:34:f3:e4': {       'dev_macs': ['80:af:ca:02:cd:65'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:34:f3:e4',
                                             'name': 'Duduzile Veronica Nhlumayo 3406 '
                                                     '70:a7:41:34:f3:e4'},
                '70:a7:41:34:f4:74': {       'dev_macs': ['80:af:ca:02:81:f1'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:34:f4:74',
                                             'name': 'Fusion Prop (Engen)-79 '
                                                     '70:a7:41:34:f4:74'},
                '70:a7:41:35:6b:05': {       'dev_macs': ['80:af:ca:54:f2:11'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6b:05',
                                             'name': 'Khanyisile Luthuli 4465 '
                                                     '70:a7:41:35:6b:05'},
                '70:a7:41:35:6e:65': {       'dev_macs': ['cc:2d:21:3b:e5:f0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6e:65',
                                             'name': 'Bheki Mngadi 3551 '
                                                     '70:a7:41:35:6e:65'},
                '70:a7:41:35:6e:a9': {       'dev_macs': ['80:af:ca:02:c0:e1'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6e:a9',
                                             'name': 'Nduduzo Brian Mdletshe 3529 '
                                                     '70:a7:41:35:6e:a9'},
                '70:a7:41:35:6e:b9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6e:b9',
                                             'name': 'Rayyan Hoosen-3533 (faulty) '
                                                     '70:a7:41:35:6e:b9'},
                '70:a7:41:35:6e:bd': {       'dev_macs': ['50:0f:f5:07:4f:c8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6e:bd',
                                             'name': 'Sibonakaliso Mnyandu-1565 '
                                                     '70:a7:41:35:6e:bd'},
                '70:a7:41:35:6f:a1': {       'dev_macs': ['cc:2d:21:3b:b7:b0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:6f:a1',
                                             'name': 'Chiliza Mphiliseni-3479 '
                                                     '70:a7:41:35:6f:a1'},
                '70:a7:41:35:70:4d': {       'dev_macs': ['80:af:ca:02:d2:8d'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:4d',
                                             'name': 'Bonga Chiliza 2390 '
                                                     '70:a7:41:35:70:4d'},
                '70:a7:41:35:70:51': {       'dev_macs': ['cc:2d:21:3b:e5:e8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:51',
                                             'name': 'Caroline Goldstone 1197 '
                                                     '70:a7:41:35:70:51'},
                '70:a7:41:35:70:6d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:6d',
                                             'name': 'Snesihle Zindela-3485 '
                                                     '70:a7:41:35:70:6d'},
                '70:a7:41:35:70:71': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:71',
                                             'name': 'Mbali Mbanjwa 1903 '
                                                     '70:a7:41:35:70:71'},
                '70:a7:41:35:70:8d': {       'dev_macs': ['cc:2d:21:3b:ae:18'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:8d',
                                             'name': 'Mazwi Mngadi 3509 '
                                                     '70:a7:41:35:70:8d'},
                '70:a7:41:35:70:99': {       'dev_macs': ['80:af:ca:22:51:05'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:99',
                                             'name': 'Precious Hlengiwe Mngadi 3524 '
                                                     '70:a7:41:35:70:99'},
                '70:a7:41:35:70:9d': {       'dev_macs': ['cc:2d:21:3b:b7:d0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:70:9d',
                                             'name': 'Lungile Mnguni 3496 '
                                                     '70:a7:41:35:70:9d'},
                '70:a7:41:35:72:9d': {       'dev_macs': ['08:55:31:30:2d:db'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:72:9d',
                                             'name': 'Mbali Mbanjwa-1903 (new) '
                                                     '70:a7:41:35:72:9d'},
                '70:a7:41:35:74:c5': {       'dev_macs': ['f4:1e:57:a7:15:47'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:74:c5',
                                             'name': 'Collins & Boffa-926 '
                                                     '70:a7:41:35:74:c5'},
                '70:a7:41:35:75:b9': {       'dev_macs': ['80:af:ca:33:b6:59'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:35:75:b9',
                                             'name': 'GSL Distributors-472 '
                                                     '70:a7:41:35:75:b9'},
                '70:a7:41:36:01:64': {       'dev_macs': ['cc:2d:21:3b:d4:a0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:01:64',
                                             'name': 'Shaun Anthoo 70:a7:41:36:01:64'},
                '70:a7:41:36:04:7c': {       'dev_macs': ['cc:2d:21:3b:e5:c8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:04:7c',
                                             'name': 'Ali Khan 3563 70:a7:41:36:04:7c'},
                '70:a7:41:36:05:34': {       'dev_macs': ['cc:2d:21:3b:e6:98'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:05:34',
                                             'name': 'Wenzile Mlambo-3615 '
                                                     '70:a7:41:36:05:34'},
                '70:a7:41:36:05:b4': {       'dev_macs': ['04:95:e6:1f:98:58'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:05:b4',
                                             'name': 'Ntando Gumede 655 '
                                                     '70:a7:41:36:05:b4'},
                '70:a7:41:36:06:60': {       'dev_macs': ['48:8f:5a:3c:7d:6f'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:06:60',
                                             'name': 'Nokuthula Sibisi-426 '
                                                     '70:a7:41:36:06:60'},
                '70:a7:41:36:06:94': {       'dev_macs': ['cc:2d:21:3b:e5:b0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:06:94',
                                             'name': 'Busisiwe Ngubo 3549 '
                                                     '70:a7:41:36:06:94'},
                '70:a7:41:36:06:e8': {       'dev_macs': ['80:af:ca:33:b6:85'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:06:e8',
                                             'name': 'Sunesh Lallan 1064 '
                                                     '70:a7:41:36:06:e8'},
                '70:a7:41:36:07:30': {       'dev_macs': ['80:af:ca:4a:29:ed'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:07:30',
                                             'name': 'Mosena Maharaj 433 '
                                                     '70:a7:41:36:07:30'},
                '70:a7:41:36:1f:5c': {       'dev_macs': ['d8:32:14:3c:1c:b0'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:1f:5c',
                                             'name': 'Thobeka Maweni  4334 '
                                                     '70:a7:41:36:1f:5c'},
                '78:45:58:06:5b:b8': {       'dev_macs': ['50:0f:f5:3a:db:48'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:5b:b8',
                                             'name': 'Zinhle Nxele 3481 '
                                                     '78:45:58:06:5b:b8'},
                '78:45:58:06:61:4c': {       'dev_macs': ['04:95:e6:1f:9e:88'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:61:4c',
                                             'name': 'Audrey Dlamini-957 '
                                                     '78:45:58:06:61:4c'},
                '78:45:58:06:7e:bc': {       'dev_macs': ['50:0f:f5:26:9b:b0'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:7e:bc',
                                             'name': 'Lindeni Dlamini 2152 '
                                                     '78:45:58:06:7e:bc'},
                '78:45:58:06:89:80': {       'dev_macs': ['80:af:ca:02:8e:55'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:89:80',
                                             'name': 'Nqobile Ratube 3356 '
                                                     '78:45:58:06:89:80'},
                '8c:30:66:fa:a4:8a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '8c:30:66:fa:a4:8a',
                                             'name': 'Rayyan Hoosen (new) '
                                                     '08c:30:66:fa:a4:8a'},
                'ac:8b:a9:e2:6c:b8': {       'dev_macs': ['80:af:ca:02:cd:75'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e2:6c:b8',
                                             'name': 'Audrey Herbst-2606  '
                                                     'ac:8b:a9:e2:6c:b8'},
                'ac:8b:a9:e2:6e:d0': {       'dev_macs': ['d8:32:14:3c:07:78'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e2:6e:d0',
                                             'name': 'Myuri Ramgoolam 1335 '
                                                     'ac:8b:a9:e2:6e:d0'},
                'ac:8b:a9:e2:70:c0': {       'dev_macs': ['50:0f:f5:26:79:30'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e2:70:c0',
                                             'name': 'Coastal Gas & Welding Umz 1219 '
                                                     'ac:8b:a9:e2:70:c0'},
                'ac:8b:a9:e3:35:0c': {       'dev_macs': ['80:af:ca:54:f0:7d'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e3:35:0c',
                                             'name': 'Leevashnee Govender-768 '
                                                     'ac:8b:a9:e3:35:0c'},
                'ac:8b:a9:e6:f2:04': {       'dev_macs': ['d8:32:14:2d:73:b0'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e6:f2:04',
                                             'name': 'Bonga Vezi 4625 '
                                                     'ac:8b:a9:e6:f2:04'},
                'ac:8b:a9:ea:21:2c': {       'dev_macs': ['b4:0f:3b:01:dc:b7'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:ea:21:2c',
                                             'name': 'Sanele Mbhele 4794 '
                                                     'ac:8b:a9:ea:21:2c'},
                'ac:8b:a9:ea:98:c8': {       'dev_macs': ['d8:32:14:2d:87:f8'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:ea:98:c8',
                                             'name': 'Sithembiso Hlatshwayo-974 '
                                                     'ac:8b:a9:ea:98:c8'},
                'ac:8b:a9:ea:9d:88': {       'dev_macs': ['80:af:ca:54:f6:79'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:ea:9d:88',
                                             'name': 'Shireen Balicharan 4685 '
                                                     'ac:8b:a9:ea:9d:88'},
                'ac:8b:a9:ea:a1:b8': {       'dev_macs': ['e8:65:d4:52:76:e8'],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:ea:a1:b8',
                                             'name': 'Kathija Khan 314 '
                                                     'ac:8b:a9:ea:a1:b8'},
                'd0:21:f9:0b:03:e8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:0b:03:e8',
                                             'name': 'Kuhle Catherine Mthuli 3380 '
                                                     'd0:21:f9:0b:03:e8'},
                'd0:21:f9:0b:12:b4': {       'dev_macs': ['b4:0f:3b:01:dc:ef'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:0b:12:b4',
                                             'name': 'Rajkumar Sivpersad 4791 '
                                                     'd0:21:f9:0b:12:b4'},
                'd0:21:f9:0b:14:00': {       'dev_macs': ['50:0f:f5:35:3e:50'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:0b:14:00',
                                             'name': 'The\u200bolin Govender-3189 '
                                                     'd0:21:f9:0b:14:00'},
                'd0:21:f9:0b:14:6c': {       'dev_macs': ['cc:2d:21:3b:b8:00'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:0b:14:6c',
                                             'name': 'Ntombenhle Makhanya 3484 '
                                                     'd0:21:f9:0b:14:6c'},
                'd0:21:f9:15:3b:6c': {       'dev_macs': ['80:af:ca:22:4b:51'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:15:3b:6c',
                                             'name': 'Msomi Qiniso 3490 '
                                                     'd0:21:f9:15:3b:6c'},
                'd0:21:f9:15:3b:f4': {       'dev_macs': ['50:0f:f5:07:50:08'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:15:3b:f4',
                                             'name': 'Edwin Trevor Eddie 2890 '
                                                     'd0:21:f9:15:3b:f4'},
                'd0:21:f9:15:3d:f8': {       'dev_macs': ['50:0f:f5:26:79:a8'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:15:3d:f8',
                                             'name': 'Immaculate Hlengiwe Ngcobo 3495 '
                                                     'd0:21:f9:15:3d:f8'},
                'd0:21:f9:15:41:ec': {       'dev_macs': ['80:af:ca:02:c1:d5'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:15:41:ec',
                                             'name': 'Blessing Sizwe Nyuswa 649 '
                                                     'd0:21:f9:15:41:ec'},
                'd0:21:f9:1a:9a:68': {       'dev_macs': ['80:af:ca:02:c7:b9'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:1a:9a:68',
                                             'name': 'Rajiv Soothama 317 '
                                                     'd0:21:f9:1a:9a:68'},
                'd0:21:f9:a5:5e:28': {       'dev_macs': ['cc:2d:21:3b:ae:30'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:a5:5e:28',
                                             'name': 'Clementia Shonaphi Boikanyo 3499 '
                                                     'd0:21:f9:a5:5e:28'},
                'd0:21:f9:a5:62:5c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:a5:62:5c',
                                             'name': 'Gregory Mjanyelwa 1485 '
                                                     'd0:21:f9:a5:62:5c'},
                'd0:21:f9:a5:68:68': {       'dev_macs': ['50:0f:f5:26:7f:28'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:a5:68:68',
                                             'name': 'Nomfundo Mathenjwa-1522 '
                                                     'd0:21:f9:a5:68:68'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '6019787531410',
                                                              'in_ucast_pkts': '4738558429',
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'DAC-SFP10-1M',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '800861718827',
                                                              'out_ucast_pkts': '2261113203',
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgyc2ZwMWludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '411894789022',
                                                              'in_ucast_pkts': '944735017',
                                                              'links': [       {       'in_octets': '1073351603',
                                                                                       'out_octets': '16753457322',
                                                                                       'poller_hash': 'MThlODI5ZjBkMDUycGVlcmludGY='},
                                                                               {       'in_octets': '31904278',
                                                                                       'out_octets': '937095783',
                                                                                       'poller_hash': 'MThlODI5ZjBkMTJhcGVlcmludGY='},
                                                                               {       'in_octets': '16978674906',
                                                                                       'out_octets': '291374175971',
                                                                                       'poller_hash': 'NzBhNzQxMzRjZWI0cGVlcmludGY='},
                                                                               {       'in_octets': '3538714558',
                                                                                       'out_octets': '22822530233',
                                                                                       'poller_hash': 'NzBhNzQxMzRmNDc0cGVlcmludGY='},
                                                                               {       'in_octets': '190885295068',
                                                                                       'out_octets': '26357188001',
                                                                                       'poller_hash': 'NzBhNzQxMzU3NGM1cGVlcmludGY='},
                                                                               {       'in_octets': '11894096065',
                                                                                       'out_octets': '79685041233',
                                                                                       'poller_hash': 'NzBhNzQxMzU3NWI5cGVlcmludGY='},
                                                                               {       'in_octets': '822343657',
                                                                                       'out_octets': '16685777454',
                                                                                       'poller_hash': 'NzBhNzQxMzYwMTY0cGVlcmludGY='},
                                                                               {       'in_octets': '11111012139',
                                                                                       'out_octets': '108984880505',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNDdjcGVlcmludGY='},
                                                                               {       'in_octets': '313279339',
                                                                                       'out_octets': '10756368963',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNjYwcGVlcmludGY='},
                                                                               {       'in_octets': '18885616645',
                                                                                       'out_octets': '38530323323',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNmU4cGVlcmludGY='},
                                                                               {       'in_octets': '2677736124',
                                                                                       'out_octets': '32533536014',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNzMwcGVlcmludGY='},
                                                                               {       'in_octets': '3483735552',
                                                                                       'out_octets': '27135510492',
                                                                                       'poller_hash': 'NzBhNzQxMzYxZjVjcGVlcmludGY='},
                                                                               {       'in_octets': '30444004669',
                                                                                       'out_octets': '268328963151',
                                                                                       'poller_hash': 'NjhkNzlhMDZlNzY5cGVlcmludGY='},
                                                                               {       'in_octets': '6596405649',
                                                                                       'out_octets': '39927699270',
                                                                                       'poller_hash': 'YWM4YmE5ZTI2Y2I4cGVlcmludGY='},
                                                                               {       'in_octets': '2417357247',
                                                                                       'out_octets': '31868030978',
                                                                                       'poller_hash': 'YWM4YmE5ZTI2ZWQwcGVlcmludGY='},
                                                                               {       'in_octets': '782727654',
                                                                                       'out_octets': '3575036976',
                                                                                       'poller_hash': 'YWM4YmE5ZTI3MGMwcGVlcmludGY='},
                                                                               {       'in_octets': '3371005889',
                                                                                       'out_octets': '64202894842',
                                                                                       'poller_hash': 'YWM4YmE5ZTMzNTBjcGVlcmludGY='},
                                                                               {       'in_octets': '5318789407',
                                                                                       'out_octets': '100957762613',
                                                                                       'poller_hash': 'YWM4YmE5ZWFhMWI4cGVlcmludGY='},
                                                                               {       'in_octets': '2339952190',
                                                                                       'out_octets': '21160236032',
                                                                                       'poller_hash': 'ZDAyMWY5MGIxMmI0cGVlcmludGY='},
                                                                               {       'in_octets': '4273664435',
                                                                                       'out_octets': '88836307174',
                                                                                       'poller_hash': 'ZDAyMWY5MGIxNDAwcGVlcmludGY='},
                                                                               {       'in_octets': '7671504790',
                                                                                       'out_octets': '145903763237',
                                                                                       'poller_hash': 'ZDAyMWY5MTUzYmY0cGVlcmludGY='},
                                                                               {       'in_octets': '11449485358',
                                                                                       'out_octets': '158307380886',
                                                                                       'poller_hash': 'ZDAyMWY5MWE5YTY4cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '2344747779359',
                                                              'out_ucast_pkts': '1891952792',
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY=',
                                                              'pons': [       {       'description': 'PON1 '
                                                                                                     '- '
                                                                                                     'St. '
                                                                                                     'Andrews '
                                                                                                     '| '
                                                                                                     'St. '
                                                                                                     'Patricks '
                                                                                                     '| '
                                                                                                     'Bank '
                                                                                                     'Rd '
                                                                                                     '| '
                                                                                                     'Engen',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '20824',
                                                                                                               'fiber_length': 2896,
                                                                                                               'poller_hash': 'MThlODI5ZjBkMDUycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8744',
                                                                                                               'fiber_length': 2754,
                                                                                                               'poller_hash': 'MThlODI5ZjBkMTJhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 3046,
                                                                                                               'poller_hash': 'NzBhNzQxMzRjZWI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 2853,
                                                                                                               'poller_hash': 'NzBhNzQxMzRmNDc0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 2705,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3NGM1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 2932,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3NWI5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '300101',
                                                                                                               'fiber_length': 2824,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwMTY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 2648,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNDdjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '13824',
                                                                                                               'fiber_length': 15435,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNjYwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '143717',
                                                                                                               'fiber_length': 2807,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNmU4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 2728,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNzMwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '149088',
                                                                                                               'fiber_length': 2565,
                                                                                                               'poller_hash': 'NzBhNzQxMzYxZjVjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 2755,
                                                                                                               'poller_hash': 'NjhkNzlhMDZlNzY5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 2783,
                                                                                                               'poller_hash': 'YWM4YmE5ZTI2Y2I4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 2751,
                                                                                                               'poller_hash': 'YWM4YmE5ZTI2ZWQwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '146327',
                                                                                                               'fiber_length': 2968,
                                                                                                               'poller_hash': 'YWM4YmE5ZTI3MGMwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 2626,
                                                                                                               'poller_hash': 'YWM4YmE5ZTMzNTBjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 2333,
                                                                                                               'poller_hash': 'YWM4YmE5ZWFhMWI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '131757',
                                                                                                               'fiber_length': 2500,
                                                                                                               'poller_hash': 'ZDAyMWY5MGIxMmI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 2539,
                                                                                                               'poller_hash': 'ZDAyMWY5MGIxNDAwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '392724',
                                                                                                               'fiber_length': 3259,
                                                                                                               'poller_hash': 'ZDAyMWY5MTUzYmY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 2474,
                                                                                                               'poller_hash': 'ZDAyMWY5MWE5YTY4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '223328373368',
                                                              'in_ucast_pkts': '772505483',
                                                              'links': [       {       'in_octets': '42475648',
                                                                                       'out_octets': '865163868',
                                                                                       'poller_hash': 'MThlODI5ZjBkMGIxcGVlcmludGY='},
                                                                               {       'in_octets': '9198169206',
                                                                                       'out_octets': '99091187382',
                                                                                       'poller_hash': 'MThlODI5ZjBkMTdlcGVlcmludGY='},
                                                                               {       'in_octets': '2408087607',
                                                                                       'out_octets': '12259543101',
                                                                                       'poller_hash': 'NzBhNzQxMzBhNzg4cGVlcmludGY='},
                                                                               {       'in_octets': '2365405922',
                                                                                       'out_octets': '21772669215',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MDhkcGVlcmludGY='},
                                                                               {       'in_octets': '7907473070',
                                                                                       'out_octets': '94182984660',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MDk5cGVlcmludGY='},
                                                                               {       'in_octets': '6534456623',
                                                                                       'out_octets': '38971430783',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MjlkcGVlcmludGY='},
                                                                               {       'in_octets': '3024187627',
                                                                                       'out_octets': '56535826153',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNWI0cGVlcmludGY='},
                                                                               {       'in_octets': '15617050879',
                                                                                       'out_octets': '37620427408',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNjk0cGVlcmludGY='},
                                                                               {       'in_octets': '79962063620',
                                                                                       'out_octets': '275918323002',
                                                                                       'poller_hash': 'Nzg0NTU4MDY2MTRjcGVlcmludGY='},
                                                                               {       'in_octets': '4737047724',
                                                                                       'out_octets': '74859785038',
                                                                                       'poller_hash': 'Nzg0NTU4MDY3ZWJjcGVlcmludGY='},
                                                                               {       'in_octets': '3423168416',
                                                                                       'out_octets': '74374373462',
                                                                                       'poller_hash': 'Nzg0NTU4MDY4OTgwcGVlcmludGY='},
                                                                               {       'in_octets': '1469655288',
                                                                                       'out_octets': '29245303724',
                                                                                       'poller_hash': 'YWM4YmE5ZTZmMjA0cGVlcmludGY='},
                                                                               {       'in_octets': '5472952647',
                                                                                       'out_octets': '118435362847',
                                                                                       'poller_hash': 'YWM4YmE5ZWE5OGM4cGVlcmludGY='},
                                                                               {       'in_octets': '3725836770',
                                                                                       'out_octets': '66113421052',
                                                                                       'poller_hash': 'YWM4YmE5ZWE5ZDg4cGVlcmludGY='},
                                                                               {       'in_octets': '8503818511',
                                                                                       'out_octets': '117360791716',
                                                                                       'poller_hash': 'ZDAyMWY5MGIxNDZjcGVlcmludGY='},
                                                                               {       'in_octets': '771046131',
                                                                                       'out_octets': '4696855353',
                                                                                       'poller_hash': 'ZDAyMWY5MTUzYjZjcGVlcmludGY='},
                                                                               {       'in_octets': '3242404910',
                                                                                       'out_octets': '85396456504',
                                                                                       'poller_hash': 'ZDAyMWY5MTUzZGY4cGVlcmludGY='},
                                                                               {       'in_octets': '828977644',
                                                                                       'out_octets': '18512787191',
                                                                                       'poller_hash': 'ZDAyMWY5YTU1ZTI4cGVlcmludGY='},
                                                                               {       'in_octets': '14024977132',
                                                                                       'out_octets': '424358915344',
                                                                                       'poller_hash': 'ZDAyMWY5YTU2ODY4cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '2271783865094',
                                                              'out_ucast_pkts': '1742786101',
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY=',
                                                              'pons': [       {       'description': 'PON2 '
                                                                                                     '- '
                                                                                                     'Shayamoya '
                                                                                                     '1',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '2124',
                                                                                                               'fiber_length': 4513,
                                                                                                               'poller_hash': 'MThlODI5ZjBkMGIxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 4524,
                                                                                                               'poller_hash': 'MThlODI5ZjBkMTdlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4513,
                                                                                                               'poller_hash': 'NzBhNzQxMzBhNzg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '50505',
                                                                                                               'fiber_length': 4329,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MDhkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '180068',
                                                                                                               'fiber_length': 4566,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MDk5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4412,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MjlkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501504',
                                                                                                               'fiber_length': 4772,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNWI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 3812,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNjk0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 4495,
                                                                                                               'poller_hash': 'Nzg0NTU4MDY2MTRjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '323492',
                                                                                                               'fiber_length': 4337,
                                                                                                               'poller_hash': 'Nzg0NTU4MDY3ZWJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '328622',
                                                                                                               'fiber_length': 4528,
                                                                                                               'poller_hash': 'Nzg0NTU4MDY4OTgwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4510,
                                                                                                               'poller_hash': 'YWM4YmE5ZTZmMjA0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '222049',
                                                                                                               'fiber_length': 4410,
                                                                                                               'poller_hash': 'YWM4YmE5ZWE5OGM4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 4328,
                                                                                                               'poller_hash': 'YWM4YmE5ZWE5ZDg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 3652,
                                                                                                               'poller_hash': 'ZDAyMWY5MGIxNDZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '24424',
                                                                                                               'fiber_length': 4615,
                                                                                                               'poller_hash': 'ZDAyMWY5MTUzYjZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 4551,
                                                                                                               'poller_hash': 'ZDAyMWY5MTUzZGY4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4284,
                                                                                                               'poller_hash': 'ZDAyMWY5YTU1ZTI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4442,
                                                                                                               'poller_hash': 'ZDAyMWY5YTU2ODY4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgycG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '161963718714',
                                                              'in_ucast_pkts': '541065274',
                                                              'links': [       {       'in_octets': '1469538649',
                                                                                       'out_octets': '46017265849',
                                                                                       'poller_hash': 'MThlODI5ZjBkMTMzcGVlcmludGY='},
                                                                               {       'in_octets': '9417900494',
                                                                                       'out_octets': '63438779106',
                                                                                       'poller_hash': 'NzBhNzQxMzBiMjhjcGVlcmludGY='},
                                                                               {       'in_octets': '3391583622',
                                                                                       'out_octets': '67639459170',
                                                                                       'poller_hash': 'NzBhNzQxMzRmM2U0cGVlcmludGY='},
                                                                               {       'in_octets': '1803076532',
                                                                                       'out_octets': '40587112062',
                                                                                       'poller_hash': 'NzBhNzQxMzU2YjA1cGVlcmludGY='},
                                                                               {       'in_octets': '40022425981',
                                                                                       'out_octets': '65790496142',
                                                                                       'poller_hash': 'NzBhNzQxMzU2ZTY1cGVlcmludGY='},
                                                                               {       'in_octets': '1734283964',
                                                                                       'out_octets': '15385590842',
                                                                                       'poller_hash': 'NzBhNzQxMzU2ZWE5cGVlcmludGY='},
                                                                               {       'in_octets': '3560172259',
                                                                                       'out_octets': '60927561473',
                                                                                       'poller_hash': 'NzBhNzQxMzU2ZWJkcGVlcmludGY='},
                                                                               {       'in_octets': '66693381',
                                                                                       'out_octets': '2550320',
                                                                                       'poller_hash': 'NzBhNzQxMzU2ZmExcGVlcmludGY='},
                                                                               {       'in_octets': '9239667907',
                                                                                       'out_octets': '155926878473',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MDRkcGVlcmludGY='},
                                                                               {       'in_octets': '10525930229',
                                                                                       'out_octets': '142718593772',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MDUxcGVlcmludGY='},
                                                                               {       'in_octets': '85323045',
                                                                                       'out_octets': '460433909',
                                                                                       'poller_hash': 'NzBhNzQxMzU3MDlkcGVlcmludGY='},
                                                                               {       'in_octets': '2956355356',
                                                                                       'out_octets': '47725595117',
                                                                                       'poller_hash': 'NzBhNzQxMzYwNTM0cGVlcmludGY='},
                                                                               {       'in_octets': '3736197684',
                                                                                       'out_octets': '26768815977',
                                                                                       'poller_hash': 'Nzg0NTU4MDY1YmI4cGVlcmludGY='},
                                                                               {       'in_octets': '13547212781',
                                                                                       'out_octets': '209061785946',
                                                                                       'poller_hash': 'YWM4YmE5ZWEyMTJjcGVlcmludGY='},
                                                                               {       'in_octets': '4852908858',
                                                                                       'out_octets': '63155084823',
                                                                                       'poller_hash': 'ZDAyMWY5MTU0MWVjcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '1403132537638',
                                                              'out_ucast_pkts': '1103230347',
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY=',
                                                              'pons': [       {       'description': 'PON4 '
                                                                                                     '- '
                                                                                                     'Shayamoya '
                                                                                                     '2',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '501506',
                                                                                                               'fiber_length': 4129,
                                                                                                               'poller_hash': 'MThlODI5ZjBkMTMzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '115527',
                                                                                                               'fiber_length': 4374,
                                                                                                               'poller_hash': 'NzBhNzQxMzBiMjhjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4248,
                                                                                                               'poller_hash': 'NzBhNzQxMzRmM2U0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 4287,
                                                                                                               'poller_hash': 'NzBhNzQxMzU2YjA1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 4288,
                                                                                                               'poller_hash': 'NzBhNzQxMzU2ZTY1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '232720',
                                                                                                               'fiber_length': 4227,
                                                                                                               'poller_hash': 'NzBhNzQxMzU2ZWE5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '237240',
                                                                                                               'fiber_length': 4283,
                                                                                                               'poller_hash': 'NzBhNzQxMzU2ZWJkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4277,
                                                                                                               'poller_hash': 'NzBhNzQxMzU2ZmExcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501505',
                                                                                                               'fiber_length': 4201,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MDRkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '458785',
                                                                                                               'fiber_length': 4292,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MDUxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '25174',
                                                                                                               'fiber_length': 4284,
                                                                                                               'poller_hash': 'NzBhNzQxMzU3MDlkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '137597',
                                                                                                               'fiber_length': 4489,
                                                                                                               'poller_hash': 'NzBhNzQxMzYwNTM0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501506',
                                                                                                               'fiber_length': 4149,
                                                                                                               'poller_hash': 'Nzg0NTU4MDY1YmI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '501496',
                                                                                                               'fiber_length': 4376,
                                                                                                               'poller_hash': 'YWM4YmE5ZWEyMTJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '150928',
                                                                                                               'fiber_length': 4171,
                                                                                                               'poller_hash': 'ZDAyMWY5MTU0MWVjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1461440696',
                                                              'in_ucast_pkts': '6133193',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4184894401',
                                                              'out_ucast_pkts': '9186909',
                                                              'poller_hash': 'ZDAyMWY5YmJhYTgyZXRoMGludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 17.0,
                                'model': 'UFiber OLT4',
                                'serial_number': 'UBNTf9bbaa82',
                                'sw_version': '4.10.1',
                                'system_mac_address': 'd0:21:f9:bb:aa:82',
                                'temperature': 47.75,
                                'uptime': '501667'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzBhNzQxMzA1MWY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzA1MWY0cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NzBhNzQxMzA1MWY0ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Brenda Thabitha Dlamini 3351 '
                                                 '70:a7:41:30:51:f4',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'offline_time': '2025-12-04T11:22:51Z',
                                         'serial_number': 'UBNT413051f4',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:a7:41:30:51:f4'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzBhNzQxMzBhNjYwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzBhNjYwcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NzBhNzQxMzBhNjYwZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Neliswa Mngadi-3452 '
                                                 '70:a7:41:30:a6:60',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT4130a660',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:a7:41:30:a6:60'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWI5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2ZWI5cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWI5ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Rayyan Hoosen-3533 (faulty) '
                                                 '70:a7:41:35:6e:b9',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT41356eb9',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:a7:41:35:6e:b9'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzBhNzQxMzU3MDZkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDZkcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDZkZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Snesihle Zindela-3485 '
                                                 '70:a7:41:35:70:6d',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT4135706d',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:a7:41:35:70:6d'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzBhNzQxMzU3MDcxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDcxcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDcxZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Mbali Mbanjwa 1903 70:a7:41:35:70:71',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT41357071',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:a7:41:35:70:71'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OGMzMDY2ZmFhNDhhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'OGMzMDY2ZmFhNDhhcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'OGMzMDY2ZmFhNDhhZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Wave-Fiber-ONU',
                                         'name': 'Rayyan Hoosen (new) '
                                                 '08c:30:66:fa:a4:8a',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT66faa48a',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '8c:30:66:fa:a4:8a'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZDAyMWY5MGIwM2U4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MGIwM2U4cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZDAyMWY5MGIwM2U4ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Kuhle Catherine Mthuli 3380 '
                                                 'd0:21:f9:0b:03:e8',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTf90b03e8',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'd0:21:f9:0b:03:e8'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZDAyMWY5YTU2MjVjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5YTU2MjVjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZDAyMWY5YTU2MjVjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Gregory Mjanyelwa 1485 '
                                                 'd0:21:f9:a5:62:5c',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTf9a5625c',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'd0:21:f9:a5:62:5c'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '16753457322',
                                                                       'links': [       {       'in_octets': '16753457322',
                                                                                                'out_octets': '1073351603',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1073351603',
                                                                       'poller_hash': 'MThlODI5ZjBkMDUycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '20824',
                                                                                                                        'fiber_length': 2896,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.404}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjBkMDUycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:65:d4:ea:38:b7'],
                                                                       'id': '1',
                                                                       'in_octets': '1073351603',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16753457322',
                                                                       'poller_hash': 'MThlODI5ZjBkMDUyZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': 'Kiki Ilunga 1165 18:e8:29:f0:d0:52',
                                         'serial_number': 'UBNT29f0d052',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '18:e8:29:f0:d0:52',
                                         'temperature': 50.0,
                                         'uptime': '20872'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '937095783',
                                                                       'links': [       {       'in_octets': '937095783',
                                                                                                'out_octets': '31904278',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '31904278',
                                                                       'poller_hash': 'MThlODI5ZjBkMTJhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8744',
                                                                                                                        'fiber_length': 2754,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -27.694,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.198}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjBkMTJhcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:0f:3b:01:d1:4f'],
                                                                       'id': '1',
                                                                       'in_octets': '31904278',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '937095783',
                                                                       'poller_hash': 'MThlODI5ZjBkMTJhZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': 'Pinky Chiliza-4815 18:e8:29:f0:d1:2a',
                                         'serial_number': 'UBNT29f0d12a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '18:e8:29:f0:d1:2a',
                                         'temperature': 51.0,
                                         'uptime': '8791'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '291374175971',
                                                                       'links': [       {       'in_octets': '291374175971',
                                                                                                'out_octets': '16978674906',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '16978674906',
                                                                       'poller_hash': 'NzBhNzQxMzRjZWI0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 3046,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.306,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.532}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzRjZWI0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:9e:b1'],
                                                                       'id': '1',
                                                                       'in_octets': '16978674906',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '291374175971',
                                                                       'poller_hash': 'NzBhNzQxMzRjZWI0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Kamran Ali Bajwa-1554 '
                                                 '70:a7:41:34:ce:b4',
                                         'serial_number': 'UBNT4134ceb4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:34:ce:b4',
                                         'temperature': 41.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '22822530233',
                                                                       'links': [       {       'in_octets': '22822530233',
                                                                                                'out_octets': '3538714558',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3538714558',
                                                                       'poller_hash': 'NzBhNzQxMzRmNDc0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 2853,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.464}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzRmNDc0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:81:f1'],
                                                                       'id': '1',
                                                                       'in_octets': '3538714558',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '22822530233',
                                                                       'poller_hash': 'NzBhNzQxMzRmNDc0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Fusion Prop (Engen)-79 '
                                                 '70:a7:41:34:f4:74',
                                         'serial_number': 'UBNT4134f474',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:34:f4:74',
                                         'temperature': 47.0,
                                         'uptime': '590532'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '26357188001',
                                                                       'links': [       {       'in_octets': '26357188001',
                                                                                                'out_octets': '190885295068',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '190885295068',
                                                                       'poller_hash': 'NzBhNzQxMzU3NGM1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 2705,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.978,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3NGM1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f4:1e:57:a7:15:47'],
                                                                       'id': '1',
                                                                       'in_octets': '190885295068',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26357188001',
                                                                       'poller_hash': 'NzBhNzQxMzU3NGM1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Collins & Boffa-926 '
                                                 '70:a7:41:35:74:c5',
                                         'serial_number': 'UBNT413574c5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:74:c5',
                                         'temperature': 55.0,
                                         'uptime': '590537'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '79685041233',
                                                                       'links': [       {       'in_octets': '79685041233',
                                                                                                'out_octets': '11894096065',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11894096065',
                                                                       'poller_hash': 'NzBhNzQxMzU3NWI5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 2932,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.218,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.708}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3NWI5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:33:b6:59'],
                                                                       'id': '1',
                                                                       'in_octets': '11894096065',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '79685041233',
                                                                       'poller_hash': 'NzBhNzQxMzU3NWI5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'GSL Distributors-472 '
                                                 '70:a7:41:35:75:b9',
                                         'serial_number': 'UBNT413575b9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:75:b9',
                                         'temperature': 47.0,
                                         'uptime': '590538'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '16685777454',
                                                                       'links': [       {       'in_octets': '16685777454',
                                                                                                'out_octets': '822343657',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '822343657',
                                                                       'poller_hash': 'NzBhNzQxMzYwMTY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '300101',
                                                                                                                        'fiber_length': 2824,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.186,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.23}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwMTY0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:d4:a0'],
                                                                       'id': '1',
                                                                       'in_octets': '822343657',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16685777454',
                                                                       'poller_hash': 'NzBhNzQxMzYwMTY0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Shaun Anthoo 70:a7:41:36:01:64',
                                         'serial_number': 'UBNT41360164',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:01:64',
                                         'temperature': 43.0,
                                         'uptime': '300166'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '108984880505',
                                                                       'links': [       {       'in_octets': '108984880505',
                                                                                                'out_octets': '11111012139',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11111012139',
                                                                       'poller_hash': 'NzBhNzQxMzYwNDdjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 2648,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.756,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.308}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNDdjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:e5:c8'],
                                                                       'id': '1',
                                                                       'in_octets': '11111012139',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '108984880505',
                                                                       'poller_hash': 'NzBhNzQxMzYwNDdjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Ali Khan 3563 70:a7:41:36:04:7c',
                                         'serial_number': 'UBNT4136047c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:04:7c',
                                         'temperature': 45.0,
                                         'uptime': '568513'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '10756368963',
                                                                       'links': [       {       'in_octets': '10756368963',
                                                                                                'out_octets': '313279339',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '313279339',
                                                                       'poller_hash': 'NzBhNzQxMzYwNjYwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '13824',
                                                                                                                        'fiber_length': 15435,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -27.446,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.598}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNjYwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:3c:7d:6f'],
                                                                       'id': '1',
                                                                       'in_octets': '313279339',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10756368963',
                                                                       'poller_hash': 'NzBhNzQxMzYwNjYwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Nokuthula Sibisi-426 '
                                                 '70:a7:41:36:06:60',
                                         'serial_number': 'UBNT41360660',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:06:60',
                                         'temperature': 44.0,
                                         'uptime': '13883'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '38530323323',
                                                                       'links': [       {       'in_octets': '38530323323',
                                                                                                'out_octets': '18885616645',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '18885616645',
                                                                       'poller_hash': 'NzBhNzQxMzYwNmU4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '143717',
                                                                                                                        'fiber_length': 2807,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -27.958,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.644}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNmU4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:33:b6:85'],
                                                                       'id': '1',
                                                                       'in_octets': '18885616645',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '38530323323',
                                                                       'poller_hash': 'NzBhNzQxMzYwNmU4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Sunesh Lallan 1064 70:a7:41:36:06:e8',
                                         'serial_number': 'UBNT413606e8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:06:e8',
                                         'temperature': 45.0,
                                         'uptime': '143782'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '32533536014',
                                                                       'links': [       {       'in_octets': '32533536014',
                                                                                                'out_octets': '2677736124',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2677736124',
                                                                       'poller_hash': 'NzBhNzQxMzYwNzMwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 2728,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.376,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.382}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNzMwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:4a:29:ed'],
                                                                       'id': '1',
                                                                       'in_octets': '2677736124',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '32533536014',
                                                                       'poller_hash': 'NzBhNzQxMzYwNzMwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Mosena Maharaj 433 70:a7:41:36:07:30',
                                         'serial_number': 'UBNT41360730',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:07:30',
                                         'temperature': 52.0,
                                         'uptime': '590530'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '27135510492',
                                                                       'links': [       {       'in_octets': '27135510492',
                                                                                                'out_octets': '3483735552',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3483735552',
                                                                       'poller_hash': 'NzBhNzQxMzYxZjVjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '149088',
                                                                                                                        'fiber_length': 2565,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.968,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.082}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYxZjVjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:32:14:3c:1c:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '3483735552',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27135510492',
                                                                       'poller_hash': 'NzBhNzQxMzYxZjVjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Thobeka Maweni  4334 '
                                                 '70:a7:41:36:1f:5c',
                                         'serial_number': 'UBNT41361f5c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:1f:5c',
                                         'temperature': 45.0,
                                         'uptime': '149146'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '268328963151',
                                                                       'links': [       {       'in_octets': '268328963151',
                                                                                                'out_octets': '30444004669',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '30444004669',
                                                                       'poller_hash': 'NjhkNzlhMDZlNzY5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 2755,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.558,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.842}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDZlNzY5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:97:19'],
                                                                       'id': '1',
                                                                       'in_octets': '30444004669',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '268328963151',
                                                                       'poller_hash': 'NjhkNzlhMDZlNzY5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Mothie (Gino) Lallan 472 '
                                                 '68:d7:9a:06:e7:69',
                                         'serial_number': 'UBNT9a06e769',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '68:d7:9a:06:e7:69',
                                         'temperature': 48.0,
                                         'uptime': '590533'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '39927699270',
                                                                       'links': [       {       'in_octets': '39927699270',
                                                                                                'out_octets': '6596405649',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6596405649',
                                                                       'poller_hash': 'YWM4YmE5ZTI2Y2I4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 2783,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.146,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.99}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTI2Y2I4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:cd:75'],
                                                                       'id': '1',
                                                                       'in_octets': '6596405649',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39927699270',
                                                                       'poller_hash': 'YWM4YmE5ZTI2Y2I4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Audrey Herbst-2606  '
                                                 'ac:8b:a9:e2:6c:b8',
                                         'serial_number': 'UBNTa9e26cb8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:e2:6c:b8',
                                         'temperature': 50.0,
                                         'uptime': '590541'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '31868030978',
                                                                       'links': [       {       'in_octets': '31868030978',
                                                                                                'out_octets': '2417357247',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2417357247',
                                                                       'poller_hash': 'YWM4YmE5ZTI2ZWQwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 2751,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.966}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTI2ZWQwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:32:14:3c:07:78'],
                                                                       'id': '1',
                                                                       'in_octets': '2417357247',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '31868030978',
                                                                       'poller_hash': 'YWM4YmE5ZTI2ZWQwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Myuri Ramgoolam 1335 '
                                                 'ac:8b:a9:e2:6e:d0',
                                         'serial_number': 'UBNTa9e26ed0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:e2:6e:d0',
                                         'temperature': 43.0,
                                         'uptime': '590538'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '3575036976',
                                                                       'links': [       {       'in_octets': '3575036976',
                                                                                                'out_octets': '782727654',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '782727654',
                                                                       'poller_hash': 'YWM4YmE5ZTI3MGMwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '146327',
                                                                                                                        'fiber_length': 2968,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.19,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.924}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTI3MGMwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:26:79:30'],
                                                                       'id': '1',
                                                                       'in_octets': '782727654',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3575036976',
                                                                       'poller_hash': 'YWM4YmE5ZTI3MGMwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Coastal Gas & Welding Umz 1219 '
                                                 'ac:8b:a9:e2:70:c0',
                                         'serial_number': 'UBNTa9e270c0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:e2:70:c0',
                                         'temperature': 45.0,
                                         'uptime': '146386'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '64202894842',
                                                                       'links': [       {       'in_octets': '64202894842',
                                                                                                'out_octets': '3371005889',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3371005889',
                                                                       'poller_hash': 'YWM4YmE5ZTMzNTBjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 2626,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.19,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.974}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTMzNTBjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:54:f0:7d'],
                                                                       'id': '1',
                                                                       'in_octets': '3371005889',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '64202894842',
                                                                       'poller_hash': 'YWM4YmE5ZTMzNTBjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Leevashnee Govender-768 '
                                                 'ac:8b:a9:e3:35:0c',
                                         'serial_number': 'UBNTa9e3350c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:e3:35:0c',
                                         'temperature': 47.0,
                                         'uptime': '590537'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '100957762613',
                                                                       'links': [       {       'in_octets': '100957762613',
                                                                                                'out_octets': '5318789407',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5318789407',
                                                                       'poller_hash': 'YWM4YmE5ZWFhMWI4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 2333,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.386}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZWFhMWI4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e8:65:d4:52:76:e8'],
                                                                       'id': '1',
                                                                       'in_octets': '5318789407',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '100957762613',
                                                                       'poller_hash': 'YWM4YmE5ZWFhMWI4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Kathija Khan 314 ac:8b:a9:ea:a1:b8',
                                         'serial_number': 'UBNTa9eaa1b8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:ea:a1:b8',
                                         'temperature': 46.0,
                                         'uptime': '570896'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '21160236032',
                                                                       'links': [       {       'in_octets': '21160236032',
                                                                                                'out_octets': '2339952190',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2339952190',
                                                                       'poller_hash': 'ZDAyMWY5MGIxMmI0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '131757',
                                                                                                                        'fiber_length': 2500,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.756,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.336}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MGIxMmI0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:0f:3b:01:dc:ef'],
                                                                       'id': '1',
                                                                       'in_octets': '2339952190',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21160236032',
                                                                       'poller_hash': 'ZDAyMWY5MGIxMmI0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Rajkumar Sivpersad 4791 '
                                                 'd0:21:f9:0b:12:b4',
                                         'serial_number': 'UBNTf90b12b4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:0b:12:b4',
                                         'temperature': 38.0,
                                         'uptime': '131815'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '88836307174',
                                                                       'links': [       {       'in_octets': '88836307174',
                                                                                                'out_octets': '4273664435',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4273664435',
                                                                       'poller_hash': 'ZDAyMWY5MGIxNDAwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 2539,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.948,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.684}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MGIxNDAwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:35:3e:50'],
                                                                       'id': '1',
                                                                       'in_octets': '4273664435',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '88836307174',
                                                                       'poller_hash': 'ZDAyMWY5MGIxNDAwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'The\u200bolin Govender-3189 '
                                                 'd0:21:f9:0b:14:00',
                                         'serial_number': 'UBNTf90b1400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:0b:14:00',
                                         'temperature': 42.0,
                                         'uptime': '590538'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '145903763237',
                                                                       'links': [       {       'in_octets': '145903763237',
                                                                                                'out_octets': '7671504790',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7671504790',
                                                                       'poller_hash': 'ZDAyMWY5MTUzYmY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '392724',
                                                                                                                        'fiber_length': 3259,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -29.208,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.542}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MTUzYmY0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:07:50:08'],
                                                                       'id': '1',
                                                                       'in_octets': '7671504790',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '145903763237',
                                                                       'poller_hash': 'ZDAyMWY5MTUzYmY0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Edwin Trevor Eddie 2890 '
                                                 'd0:21:f9:15:3b:f4',
                                         'serial_number': 'UBNTf9153bf4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:15:3b:f4',
                                         'temperature': 39.0,
                                         'uptime': '392780'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '158307380886',
                                                                       'links': [       {       'in_octets': '158307380886',
                                                                                                'out_octets': '11449485358',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11449485358',
                                                                       'poller_hash': 'ZDAyMWY5MWE5YTY4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 2474,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.366,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.31}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MWE5YTY4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:c7:b9'],
                                                                       'id': '1',
                                                                       'in_octets': '11449485358',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '158307380886',
                                                                       'poller_hash': 'ZDAyMWY5MWE5YTY4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Rajiv Soothama 317 d0:21:f9:1a:9a:68',
                                         'serial_number': 'UBNTf91a9a68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:1a:9a:68',
                                         'temperature': 43.0,
                                         'uptime': '590532'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '865163868',
                                                                       'links': [       {       'in_octets': '865163868',
                                                                                                'out_octets': '42475648',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '42475648',
                                                                       'poller_hash': 'MThlODI5ZjBkMGIxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2124',
                                                                                                                        'fiber_length': 4513,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.814,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjBkMGIxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:0f:3b:01:d3:a7'],
                                                                       'id': '1',
                                                                       'in_octets': '42475648',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '865163868',
                                                                       'poller_hash': 'MThlODI5ZjBkMGIxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': 'Victoria Johnson 254 '
                                                 '18:e8:29:f0:d0:b1',
                                         'serial_number': 'UBNT29f0d0b1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '18:e8:29:f0:d0:b1',
                                         'temperature': 52.0,
                                         'uptime': '2169'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '99091187382',
                                                                       'links': [       {       'in_octets': '99091187382',
                                                                                                'out_octets': '9198169206',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9198169206',
                                                                       'poller_hash': 'MThlODI5ZjBkMTdlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 4524,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.85,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.514}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjBkMTdlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:0b:62:8d'],
                                                                       'id': '1',
                                                                       'in_octets': '9198169206',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '99091187382',
                                                                       'poller_hash': 'MThlODI5ZjBkMTdlZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'NanoG',
                                         'name': '\u200bHlophe Phandle-2931 '
                                                 '18:e8:29:f0:d1:7e',
                                         'serial_number': 'UBNT29f0d17e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '18:e8:29:f0:d1:7e',
                                         'temperature': 54.0,
                                         'uptime': '590573'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '12259543101',
                                                                       'links': [       {       'in_octets': '12259543101',
                                                                                                'out_octets': '2408087607',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2408087607',
                                                                       'poller_hash': 'NzBhNzQxMzBhNzg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4513,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.098,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.212}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzBhNzg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:54:ab:3d'],
                                                                       'id': '1',
                                                                       'in_octets': '2408087607',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12259543101',
                                                                       'poller_hash': 'NzBhNzQxMzBhNzg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Nomthandazo Portia Sebothoma 4748 '
                                                 '70:a7:41:30:a7:88',
                                         'serial_number': 'UBNT4130a788',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:30:a7:88',
                                         'temperature': 47.0,
                                         'uptime': '590534'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '21772669215',
                                                                       'links': [       {       'in_octets': '21772669215',
                                                                                                'out_octets': '2365405922',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2365405922',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDhkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '50505',
                                                                                                                        'fiber_length': 4329,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.85,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.57}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDhkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:ae:18'],
                                                                       'id': '1',
                                                                       'in_octets': '2365405922',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21772669215',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDhkZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Mazwi Mngadi 3509 70:a7:41:35:70:8d',
                                         'serial_number': 'UBNT4135708d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:70:8d',
                                         'temperature': 46.0,
                                         'uptime': '50563'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '94182984660',
                                                                       'links': [       {       'in_octets': '94182984660',
                                                                                                'out_octets': '7907473070',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7907473070',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDk5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '180068',
                                                                                                                        'fiber_length': 4566,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -26.574,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.248}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDk5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:22:51:05'],
                                                                       'id': '1',
                                                                       'in_octets': '7907473070',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '94182984660',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDk5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Precious Hlengiwe Mngadi 3524 '
                                                 '70:a7:41:35:70:99',
                                         'serial_number': 'UBNT41357099',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:70:99',
                                         'temperature': 46.0,
                                         'uptime': '180135'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '38971430783',
                                                                       'links': [       {       'in_octets': '38971430783',
                                                                                                'out_octets': '6534456623',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6534456623',
                                                                       'poller_hash': 'NzBhNzQxMzU3MjlkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4412,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.756,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.96}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MjlkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:55:31:30:2d:db'],
                                                                       'id': '1',
                                                                       'in_octets': '6534456623',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '38971430783',
                                                                       'poller_hash': 'NzBhNzQxMzU3MjlkZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Mbali Mbanjwa-1903 (new) '
                                                 '70:a7:41:35:72:9d',
                                         'serial_number': 'UBNT4135729d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:72:9d',
                                         'temperature': 42.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '56535826153',
                                                                       'links': [       {       'in_octets': '56535826153',
                                                                                                'out_octets': '3024187627',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3024187627',
                                                                       'poller_hash': 'NzBhNzQxMzYwNWI0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501504',
                                                                                                                        'fiber_length': 4772,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.466,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.508}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNWI0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:95:e6:1f:98:58'],
                                                                       'id': '1',
                                                                       'in_octets': '3024187627',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '56535826153',
                                                                       'poller_hash': 'NzBhNzQxMzYwNWI0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Ntando Gumede 655 70:a7:41:36:05:b4',
                                         'serial_number': 'UBNT413605b4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:05:b4',
                                         'temperature': 42.0,
                                         'uptime': '590540'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '37620427408',
                                                                       'links': [       {       'in_octets': '37620427408',
                                                                                                'out_octets': '15617050879',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '15617050879',
                                                                       'poller_hash': 'NzBhNzQxMzYwNjk0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 3812,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.396}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNjk0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:e5:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '15617050879',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '37620427408',
                                                                       'poller_hash': 'NzBhNzQxMzYwNjk0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Busisiwe Ngubo 3549 '
                                                 '70:a7:41:36:06:94',
                                         'serial_number': 'UBNT41360694',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:06:94',
                                         'temperature': 48.0,
                                         'uptime': '590538'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '275918323002',
                                                                       'links': [       {       'in_octets': '275918323002',
                                                                                                'out_octets': '79962063620',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '79962063620',
                                                                       'poller_hash': 'Nzg0NTU4MDY2MTRjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 4495,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.372,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.272}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDY2MTRjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:95:e6:1f:9e:88'],
                                                                       'id': '1',
                                                                       'in_octets': '79962063620',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '275918323002',
                                                                       'poller_hash': 'Nzg0NTU4MDY2MTRjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Audrey Dlamini-957 78:45:58:06:61:4c',
                                         'serial_number': 'UBNT5806614c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '78:45:58:06:61:4c',
                                         'temperature': 37.0,
                                         'uptime': '590528'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '74859785038',
                                                                       'links': [       {       'in_octets': '74859785038',
                                                                                                'out_octets': '4737047724',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4737047724',
                                                                       'poller_hash': 'Nzg0NTU4MDY3ZWJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '323492',
                                                                                                                        'fiber_length': 4337,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.436,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.58}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDY3ZWJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:26:9b:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '4737047724',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '74859785038',
                                                                       'poller_hash': 'Nzg0NTU4MDY3ZWJjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Lindeni Dlamini 2152 '
                                                 '78:45:58:06:7e:bc',
                                         'serial_number': 'UBNT58067ebc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '78:45:58:06:7e:bc',
                                         'temperature': 38.0,
                                         'uptime': '323547'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '74374373462',
                                                                       'links': [       {       'in_octets': '74374373462',
                                                                                                'out_octets': '3423168416',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3423168416',
                                                                       'poller_hash': 'Nzg0NTU4MDY4OTgwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '328622',
                                                                                                                        'fiber_length': 4528,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.604}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDY4OTgwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:8e:55'],
                                                                       'id': '1',
                                                                       'in_octets': '3423168416',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '74374373462',
                                                                       'poller_hash': 'Nzg0NTU4MDY4OTgwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Nqobile Ratube 3356 '
                                                 '78:45:58:06:89:80',
                                         'serial_number': 'UBNT58068980',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '78:45:58:06:89:80',
                                         'temperature': 45.0,
                                         'uptime': '328688'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '29245303724',
                                                                       'links': [       {       'in_octets': '29245303724',
                                                                                                'out_octets': '1469655288',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1469655288',
                                                                       'poller_hash': 'YWM4YmE5ZTZmMjA0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4510,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.436,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.864}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTZmMjA0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:32:14:2d:73:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '1469655288',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '29245303724',
                                                                       'poller_hash': 'YWM4YmE5ZTZmMjA0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Bonga Vezi 4625 ac:8b:a9:e6:f2:04',
                                         'serial_number': 'UBNTa9e6f204',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:e6:f2:04',
                                         'temperature': 44.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '118435362847',
                                                                       'links': [       {       'in_octets': '118435362847',
                                                                                                'out_octets': '5472952647',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5472952647',
                                                                       'poller_hash': 'YWM4YmE5ZWE5OGM4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '222049',
                                                                                                                        'fiber_length': 4410,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.984}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZWE5OGM4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:32:14:2d:87:f8'],
                                                                       'id': '1',
                                                                       'in_octets': '5472952647',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '118435362847',
                                                                       'poller_hash': 'YWM4YmE5ZWE5OGM4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Sithembiso Hlatshwayo-974 '
                                                 'ac:8b:a9:ea:98:c8',
                                         'serial_number': 'UBNTa9ea98c8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:ea:98:c8',
                                         'temperature': 42.0,
                                         'uptime': '222114'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '66113421052',
                                                                       'links': [       {       'in_octets': '66113421052',
                                                                                                'out_octets': '3725836770',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3725836770',
                                                                       'poller_hash': 'YWM4YmE5ZWE5ZDg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 4328,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.978,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.852}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZWE5ZDg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:54:f6:79'],
                                                                       'id': '1',
                                                                       'in_octets': '3725836770',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '66113421052',
                                                                       'poller_hash': 'YWM4YmE5ZWE5ZDg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Shireen Balicharan 4685 '
                                                 'ac:8b:a9:ea:9d:88',
                                         'serial_number': 'UBNTa9ea9d88',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:ea:9d:88',
                                         'temperature': 43.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '117360791716',
                                                                       'links': [       {       'in_octets': '117360791716',
                                                                                                'out_octets': '8503818511',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '8503818511',
                                                                       'poller_hash': 'ZDAyMWY5MGIxNDZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 3652,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -33.01,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.92}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MGIxNDZjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:b8:00'],
                                                                       'id': '1',
                                                                       'in_octets': '8503818511',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '117360791716',
                                                                       'poller_hash': 'ZDAyMWY5MGIxNDZjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Ntombenhle Makhanya 3484 '
                                                 'd0:21:f9:0b:14:6c',
                                         'serial_number': 'UBNTf90b146c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:0b:14:6c',
                                         'temperature': 40.0,
                                         'uptime': '590536'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4696855353',
                                                                       'links': [       {       'in_octets': '4696855353',
                                                                                                'out_octets': '771046131',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '771046131',
                                                                       'poller_hash': 'ZDAyMWY5MTUzYjZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '24424',
                                                                                                                        'fiber_length': 4615,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -26.382,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.418}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MTUzYjZjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:22:4b:51'],
                                                                       'id': '1',
                                                                       'in_octets': '771046131',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4696855353',
                                                                       'poller_hash': 'ZDAyMWY5MTUzYjZjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Msomi Qiniso 3490 d0:21:f9:15:3b:6c',
                                         'serial_number': 'UBNTf9153b6c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:15:3b:6c',
                                         'temperature': 48.0,
                                         'uptime': '24489'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '85396456504',
                                                                       'links': [       {       'in_octets': '85396456504',
                                                                                                'out_octets': '3242404910',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3242404910',
                                                                       'poller_hash': 'ZDAyMWY5MTUzZGY4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 4551,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.558,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.096}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MTUzZGY4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:26:79:a8'],
                                                                       'id': '1',
                                                                       'in_octets': '3242404910',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '85396456504',
                                                                       'poller_hash': 'ZDAyMWY5MTUzZGY4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Immaculate Hlengiwe Ngcobo 3495 '
                                                 'd0:21:f9:15:3d:f8',
                                         'serial_number': 'UBNTf9153df8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:15:3d:f8',
                                         'temperature': 41.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '18512787191',
                                                                       'links': [       {       'in_octets': '18512787191',
                                                                                                'out_octets': '828977644',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '828977644',
                                                                       'poller_hash': 'ZDAyMWY5YTU1ZTI4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4284,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.766,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.884}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5YTU1ZTI4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:ae:30'],
                                                                       'id': '1',
                                                                       'in_octets': '828977644',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '18512787191',
                                                                       'poller_hash': 'ZDAyMWY5YTU1ZTI4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Clementia Shonaphi Boikanyo 3499 '
                                                 'd0:21:f9:a5:5e:28',
                                         'serial_number': 'UBNTf9a55e28',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:a5:5e:28',
                                         'temperature': 41.0,
                                         'uptime': '590525'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '424358915344',
                                                                       'links': [       {       'in_octets': '424358915344',
                                                                                                'out_octets': '14024977132',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '14024977132',
                                                                       'poller_hash': 'ZDAyMWY5YTU2ODY4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4442,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQysy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.558,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.804}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5YTU2ODY4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:26:7f:28'],
                                                                       'id': '1',
                                                                       'in_octets': '14024977132',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '424358915344',
                                                                       'poller_hash': 'ZDAyMWY5YTU2ODY4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Nomfundo Mathenjwa-1522 '
                                                 'd0:21:f9:a5:68:68',
                                         'serial_number': 'UBNTf9a56868',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:a5:68:68',
                                         'temperature': 42.0,
                                         'uptime': '590536'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '46017265849',
                                                                       'links': [       {       'in_octets': '46017265849',
                                                                                                'out_octets': '1469538649',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1469538649',
                                                                       'poller_hash': 'MThlODI5ZjBkMTMzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 4129,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.098,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.72}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjBkMTMzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:0f:3b:01:bf:df'],
                                                                       'id': '1',
                                                                       'in_octets': '1469538649',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '46017265849',
                                                                       'poller_hash': 'MThlODI5ZjBkMTMzZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'NanoG',
                                         'name': 'Mzokhanyayo Knowledge Khoza - 5066 '
                                                 '|18:e8:29:f0:d1:33',
                                         'serial_number': 'UBNT29f0d133',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '18:e8:29:f0:d1:33',
                                         'temperature': 52.0,
                                         'uptime': '590590'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '63438779106',
                                                                       'links': [       {       'in_octets': '63438779106',
                                                                                                'out_octets': '9417900494',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9417900494',
                                                                       'poller_hash': 'NzBhNzQxMzBiMjhjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '115527',
                                                                                                                        'fiber_length': 4374,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.486,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.904}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzBiMjhjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '04:95:e6:1f:9a:98'],
                                                                       'id': '1',
                                                                       'in_octets': '9417900494',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '63438779106',
                                                                       'poller_hash': 'NzBhNzQxMzBiMjhjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Monwabisi Christopher Tekete 3468 '
                                                 '70:a7:41:30:b2:8c',
                                         'serial_number': 'UBNT4130b28c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:30:b2:8c',
                                         'temperature': 42.0,
                                         'uptime': '590689'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '67639459170',
                                                                       'links': [       {       'in_octets': '67639459170',
                                                                                                'out_octets': '3391583622',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3391583622',
                                                                       'poller_hash': 'NzBhNzQxMzRmM2U0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4248,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.976}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzRmM2U0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:cd:65'],
                                                                       'id': '1',
                                                                       'in_octets': '3391583622',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '67639459170',
                                                                       'poller_hash': 'NzBhNzQxMzRmM2U0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Duduzile Veronica Nhlumayo 3406 '
                                                 '70:a7:41:34:f3:e4',
                                         'serial_number': 'UBNT4134f3e4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:34:f3:e4',
                                         'temperature': 46.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '40587112062',
                                                                       'links': [       {       'in_octets': '40587112062',
                                                                                                'out_octets': '1803076532',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1803076532',
                                                                       'poller_hash': 'NzBhNzQxMzU2YjA1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 4287,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.086,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.538}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2YjA1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:54:f2:11'],
                                                                       'id': '1',
                                                                       'in_octets': '1803076532',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '40587112062',
                                                                       'poller_hash': 'NzBhNzQxMzU2YjA1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Khanyisile Luthuli 4465 '
                                                 '70:a7:41:35:6b:05',
                                         'serial_number': 'UBNT41356b05',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:6b:05',
                                         'temperature': 46.0,
                                         'uptime': '590538'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '65790496142',
                                                                       'links': [       {       'in_octets': '65790496142',
                                                                                                'out_octets': '40022425981',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '40022425981',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZTY1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 4288,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.316,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.758}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2ZTY1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:e5:f0'],
                                                                       'id': '1',
                                                                       'in_octets': '40022425981',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '65790496142',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZTY1ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 58.0,
                                         'model': 'Loco',
                                         'name': 'Bheki Mngadi 3551 70:a7:41:35:6e:65',
                                         'serial_number': 'UBNT41356e65',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:6e:65',
                                         'temperature': 42.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '15385590842',
                                                                       'links': [       {       'in_octets': '15385590842',
                                                                                                'out_octets': '1734283964',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1734283964',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWE5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '232720',
                                                                                                                        'fiber_length': 4227,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.518,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.946}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2ZWE5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:c0:e1'],
                                                                       'id': '1',
                                                                       'in_octets': '1734283964',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15385590842',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWE5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Nduduzo Brian Mdletshe 3529 '
                                                 '70:a7:41:35:6e:a9',
                                         'serial_number': 'UBNT41356ea9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:6e:a9',
                                         'temperature': 45.0,
                                         'uptime': '232784'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '60927561473',
                                                                       'links': [       {       'in_octets': '60927561473',
                                                                                                'out_octets': '3560172259',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3560172259',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWJkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '237240',
                                                                                                                        'fiber_length': 4283,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.316,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.448}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2ZWJkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:07:4f:c8'],
                                                                       'id': '1',
                                                                       'in_octets': '3560172259',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '60927561473',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZWJkZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Sibonakaliso Mnyandu-1565 '
                                                 '70:a7:41:35:6e:bd',
                                         'serial_number': 'UBNT41356ebd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:6e:bd',
                                         'temperature': 43.0,
                                         'uptime': '237305'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '2550320',
                                                                       'links': [       {       'in_octets': '2550320',
                                                                                                'out_octets': '66693381',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '66693381',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZmExcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4277,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.704,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.43}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU2ZmExcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:b7:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '66693381',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2550320',
                                                                       'poller_hash': 'NzBhNzQxMzU2ZmExZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Chiliza Mphiliseni-3479 '
                                                 '70:a7:41:35:6f:a1',
                                         'serial_number': 'UBNT41356fa1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:6f:a1',
                                         'temperature': 43.0,
                                         'uptime': '590542'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '155926878473',
                                                                       'links': [       {       'in_octets': '155926878473',
                                                                                                'out_octets': '9239667907',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9239667907',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDRkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501505',
                                                                                                                        'fiber_length': 4201,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.528,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.372}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDRkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:d2:8d'],
                                                                       'id': '1',
                                                                       'in_octets': '9239667907',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '155926878473',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDRkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Bonga Chiliza 2390 70:a7:41:35:70:4d',
                                         'serial_number': 'UBNT4135704d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:70:4d',
                                         'temperature': 49.0,
                                         'uptime': '590536'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '142718593772',
                                                                       'links': [       {       'in_octets': '142718593772',
                                                                                                'out_octets': '10525930229',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '10525930229',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDUxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '458785',
                                                                                                                        'fiber_length': 4292,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.924,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.87}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDUxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:e5:e8'],
                                                                       'id': '1',
                                                                       'in_octets': '10525930229',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '142718593772',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDUxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Caroline Goldstone 1197 '
                                                 '70:a7:41:35:70:51',
                                         'serial_number': 'UBNT41357051',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:70:51',
                                         'temperature': 47.0,
                                         'uptime': '458847'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '460433909',
                                                                       'links': [       {       'in_octets': '460433909',
                                                                                                'out_octets': '85323045',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '85323045',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDlkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '25174',
                                                                                                                        'fiber_length': 4284,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.372,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.604}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzU3MDlkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:b7:d0'],
                                                                       'id': '1',
                                                                       'in_octets': '85323045',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '460433909',
                                                                       'poller_hash': 'NzBhNzQxMzU3MDlkZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Lungile Mnguni 3496 '
                                                 '70:a7:41:35:70:9d',
                                         'serial_number': 'UBNT4135709d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:35:70:9d',
                                         'temperature': 40.0,
                                         'uptime': '25235'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '47725595117',
                                                                       'links': [       {       'in_octets': '47725595117',
                                                                                                'out_octets': '2956355356',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2956355356',
                                                                       'poller_hash': 'NzBhNzQxMzYwNTM0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '137597',
                                                                                                                        'fiber_length': 4489,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.756,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.432}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzYwNTM0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:21:3b:e6:98'],
                                                                       'id': '1',
                                                                       'in_octets': '2956355356',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '47725595117',
                                                                       'poller_hash': 'NzBhNzQxMzYwNTM0ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Wenzile Mlambo-3615 '
                                                 '70:a7:41:36:05:34',
                                         'serial_number': 'UBNT41360534',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '70:a7:41:36:05:34',
                                         'temperature': 44.0,
                                         'uptime': '137655'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '26768815977',
                                                                       'links': [       {       'in_octets': '26768815977',
                                                                                                'out_octets': '3736197684',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3736197684',
                                                                       'poller_hash': 'Nzg0NTU4MDY1YmI4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501506',
                                                                                                                        'fiber_length': 4149,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.202,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.038}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDY1YmI4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:0f:f5:3a:db:48'],
                                                                       'id': '1',
                                                                       'in_octets': '3736197684',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26768815977',
                                                                       'poller_hash': 'Nzg0NTU4MDY1YmI4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Zinhle Nxele 3481 78:45:58:06:5b:b8',
                                         'serial_number': 'UBNT58065bb8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': '78:45:58:06:5b:b8',
                                         'temperature': 40.0,
                                         'uptime': '590539'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '209061785946',
                                                                       'links': [       {       'in_octets': '209061785946',
                                                                                                'out_octets': '13547212781',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '13547212781',
                                                                       'poller_hash': 'YWM4YmE5ZWEyMTJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '501496',
                                                                                                                        'fiber_length': 4376,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.44,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.6}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZWEyMTJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b4:0f:3b:01:dc:b7'],
                                                                       'id': '1',
                                                                       'in_octets': '13547212781',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '209061785946',
                                                                       'poller_hash': 'YWM4YmE5ZWEyMTJjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 57.0,
                                         'model': 'Loco',
                                         'name': 'Sanele Mbhele 4794 ac:8b:a9:ea:21:2c',
                                         'serial_number': 'UBNTa9ea212c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'ac:8b:a9:ea:21:2c',
                                         'temperature': 39.0,
                                         'uptime': '590536'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '63155084823',
                                                                       'links': [       {       'in_octets': '63155084823',
                                                                                                'out_octets': '4852908858',
                                                                                                'poller_hash': 'ZDAyMWY5YmJhYTgycG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4852908858',
                                                                       'poller_hash': 'ZDAyMWY5MTU0MWVjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '150928',
                                                                                                                        'fiber_length': 4171,
                                                                                                                        'poller_hash': 'ZDAyMWY5YmJhYTgyVUYtR1AtQys0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -26.574,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.58}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MTU0MWVjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:af:ca:02:c1:d5'],
                                                                       'id': '1',
                                                                       'in_octets': '4852908858',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '63155084823',
                                                                       'poller_hash': 'ZDAyMWY5MTU0MWVjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Blessing Sizwe Nyuswa 649 '
                                                 'd0:21:f9:15:41:ec',
                                         'serial_number': 'UBNTf91541ec',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.10.1',
                                         'system_mac_address': 'd0:21:f9:15:41:ec',
                                         'temperature': 37.0,
                                         'uptime': '150991'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_5_3_10_60_57_2(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.5.3.10_60_57_2")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 53,
                'sw_version': '4.5.3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 4
        }
        exp_sta_stats = {
                '18:e8:29:19:6c:11': {       'dev_macs': ['a0:40:a0:71:2d:88'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:6c:11',
                                             'name': 'Island View - 12705 - Karen '
                                                     'Mulvahill - 14204'},
                '18:e8:29:19:70:7b': {       'dev_macs': ['10:0c:6b:2d:94:8a'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:70:7b',
                                             'name': 'Island View-12545-John '
                                                     'Wadas-16542'},
                '18:e8:29:19:74:e5': {       'dev_macs': ['e0:63:da:99:cd:79'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:74:e5',
                                             'name': 'Island View - 12571 - John Scott '
                                                     '- 18909'},
                '18:e8:29:19:b0:a9': {       'dev_macs': ['3c:37:86:c8:4c:76'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b0:a9',
                                             'name': 'Island View - 12771 - Bill Brown '
                                                     '- 13712'},
                '18:e8:29:19:b0:f9': {       'dev_macs': ['b0:39:56:50:a7:80'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b0:f9',
                                             'name': 'Island View - 12563 - Don '
                                                     'DAnnunzio - 17717'},
                '18:e8:29:19:b1:12': {       'dev_macs': ['a0:04:60:04:24:be'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b1:12',
                                             'name': 'Island View - 12585 - Ronald '
                                                     'Jones - 14376'},
                '18:e8:29:19:b2:57': {       'dev_macs': ['f4:92:bf:66:6a:d1'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:57',
                                             'name': 'Island View - 12527 - John '
                                                     'Christophersen - 17017'},
                '18:e8:29:19:b2:61': {       'dev_macs': ['6c:b0:ce:10:fa:03'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:61',
                                             'name': 'Island View - 12755 - Paul '
                                                     'Christopheren - 16068'},
                '18:e8:29:19:b2:6b': {       'dev_macs': ['10:0c:6b:d6:f0:fe'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:6b',
                                             'name': 'Island View - 12727 - Rich '
                                                     'Sutliff - 14696'},
                '18:e8:29:19:b2:7f': {       'dev_macs': ['78:d2:94:18:c2:98'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:7f',
                                             'name': 'Island View - 12811 - Robert '
                                                     'Shirkey - 13719'},
                '18:e8:29:19:b2:98': {       'dev_macs': ['d8:07:b6:74:c5:ee'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:98',
                                             'name': 'Island VIew - 12655 - Al Blinke '
                                                     '- 15472'},
                '18:e8:29:19:b2:9d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:9d',
                                             'name': 'Island View - 12637 - Milton '
                                                     'Hartig - 13676'},
                '18:e8:29:19:b2:a7': {       'dev_macs': ['f8:32:e4:b2:fc:50'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:a7',
                                             'name': 'Island View - 12831 - DomeHouse '
                                                     'LLC - 13718'},
                '18:e8:29:19:b2:ac': {       'dev_macs': ['08:36:c9:14:fc:10'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:ac',
                                             'name': 'Island View - 12891 - Terry Fera '
                                                     '- 15115'},
                '18:e8:29:19:b2:b1': {       'dev_macs': ['78:d2:94:18:e9:d8'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:b1',
                                             'name': 'Island View - 12371 - Christine '
                                                     'Polo - 20910'},
                '18:e8:29:19:b3:f6': {       'dev_macs': ['6c:3b:6b:92:e4:29'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b3:f6',
                                             'name': 'Island View - 12973 - Christine '
                                                     'Kay - 16910'},
                '18:e8:29:19:b3:fb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b3:fb',
                                             'name': 'Island View - 12693 - Mary '
                                                     'Jaross - 15893'},
                '18:e8:29:19:b4:0a': {       'dev_macs': ['e0:63:da:f9:95:4f'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:0a',
                                             'name': 'Island View - 12803 - Stephen '
                                                     'Rigotti - 14850'},
                '18:e8:29:19:b4:91': {       'dev_macs': ['60:b7:6e:1e:fa:76'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:91',
                                             'name': 'Island View - 12515 - Brandon '
                                                     'Theophilus - 18564'},
                '18:e8:29:19:b4:c3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:c3',
                                             'name': 'Island View - 12493 - Alex Parks '
                                                     '- 16106'},
                '18:e8:29:f5:ff:97': {       'dev_macs': ['74:ac:b9:46:e6:45'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:ff:97',
                                             'name': 'Foxview - 12010 - Douglas Jester '
                                                     '- 16616'},
                '68:d7:9a:06:87:03': {       'dev_macs': ['cc:40:d0:50:f6:20'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:87:03',
                                             'name': 'Island View - 12331 - William '
                                                     'Cron - 13536'},
                '68:d7:9a:06:88:e4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:88:e4',
                                             'name': 'UBNT9a0688e4'},
                '68:d7:9a:06:8a:ad': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:8a:ad',
                                             'name': 'Island Dr - 12901 - Dan Cermak - '
                                                     '20905'},
                '68:d7:9a:06:8a:f2': {       'dev_macs': ['40:ed:00:a9:df:2c'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:8a:f2',
                                             'name': 'Island View - 12445 - Stanley '
                                                     'Pruss -  15077'},
                '74:83:c2:43:f7:28': {       'dev_macs': ['74:b6:b6:05:8c:80'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:f7:28',
                                             'name': 'Foxview - 11907 - Todd Hoogland '
                                                     '- 17100'},
                '74:83:c2:43:f7:90': {       'dev_macs': ['48:22:54:32:d5:d1'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:f7:90',
                                             'name': 'Island View - 12531 - Malcolm '
                                                     'Hickok - 21903'},
                '74:83:c2:43:fb:46': {       'dev_macs': ['14:91:82:2e:cf:55'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:fb:46',
                                             'name': 'Island View Dr - 12931 - Judy '
                                                     'Burns - 15696'},
                '74:83:c2:68:af:3b': {       'dev_macs': ['8c:3b:ad:f1:f0:12'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:af:3b',
                                             'name': 'N Foxview - 11981 - Tina Serne - '
                                                     '17978'},
                '78:45:58:90:da:70': {       'dev_macs': ['40:ed:00:85:28:a5'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:da:70',
                                             'name': 'Island View - 12875 - Bridget '
                                                     'Lamont - 13721'},
                '78:45:58:90:e0:f4': {       'dev_macs': ['c8:9e:43:db:81:8b'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e0:f4',
                                             'name': 'Island View - 12851 - Joanne '
                                                     'Whitley - 14649'},
                '78:45:58:90:e1:88': {       'dev_macs': ['c0:06:c3:2f:d4:3d'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e1:88',
                                             'name': 'Shores Ct - 12372 - Maginot, '
                                                     'Anne & Peter - 20791'},
                '78:45:58:90:e8:94': {       'dev_macs': ['50:91:e3:43:0d:f4'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e8:94',
                                             'name': 'Island Lake Dr - 13015 -Marilee '
                                                     'Milroy - 13348'},
                '78:45:58:95:18:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:95:18:18',
                                             'name': 'Foxview - 11886 - James Hatch - '
                                                     '21764'},
                '78:45:58:95:28:a4': {       'dev_macs': ['28:87:ba:76:31:21'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:95:28:a4',
                                             'name': 'Peterson Park - 10323 - Rich '
                                                     'Simons - 21424'},
                '78:8a:20:73:6f:2c': {       'dev_macs': ['24:4b:fe:39:0b:19'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:6f:2c',
                                             'name': 'Foxview - 11850 - Paul Belden - '
                                                     '17943'},
                '78:8a:20:73:72:15': {       'dev_macs': ['68:d7:9a:d0:82:f8'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:72:15',
                                             'name': 'Island View - 12260 - Thomas '
                                                     'Shaver - 13374'},
                '78:8a:20:73:72:bf': {       'dev_macs': ['80:02:9c:53:0a:b0'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:72:bf',
                                             'name': 'Foxview - 12155 - Jeffery '
                                                     'McGalliard - 17944'},
                '78:8a:20:73:79:18': {       'dev_macs': ['00:01:9f:1e:4b:01'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:79:18',
                                             'name': 'Foxview - 12097 - Steve Holmes - '
                                                     '18097'},
                '78:8a:20:78:e8:a3': {       'dev_macs': ['14:59:c0:a4:a6:6b'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:e8:a3',
                                             'name': 'Foxview - 12236 - Randy Harmson '
                                                     '- 15026'},
                '78:8a:20:78:f0:a5': {       'dev_macs': ['80:cc:9c:2c:d0:ac'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:f0:a5',
                                             'name': 'Foxview - 12191 - Jim Flutur -  '
                                                     '13587'},
                '78:8a:20:c0:40:96': {       'dev_macs': ['48:dd:0c:be:7a:20'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:96',
                                             'name': 'Foxview - 11945 - Phil Smith - '
                                                     '17942'},
                '78:8a:20:c0:40:aa': {       'dev_macs': ['74:ac:b9:fd:bc:a6'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:aa',
                                             'name': 'Foxview - 11963 - David Watkins '
                                                     '- 17965'},
                '78:8a:20:c0:40:c8': {       'dev_macs': ['30:de:4b:9e:af:e1'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:c8',
                                             'name': 'Island View - 12411 - Paul Hsieh '
                                                     '- 17977'},
                '78:8a:20:c0:41:18': {       'dev_macs': ['e0:63:da:f9:07:c8'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:18',
                                             'name': 'Foxview - 11920 - Chase, Janeen '
                                                     '- 21513'},
                '78:8a:20:c0:41:2c': {       'dev_macs': ['8c:3b:ad:3d:32:a3'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:2c',
                                             'name': 'Foxview - 12158 - Carolyn Grauer '
                                                     '- 21816'},
                '78:8a:20:c0:41:45': {       'dev_macs': ['00:01:9f:20:4e:b9'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:45',
                                             'name': 'Shores Ct - 12390 - Ann Anderson '
                                                     '- 18014'},
                '78:8a:20:c0:41:54': {       'dev_macs': ['48:8f:5a:d2:68:7d'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:54',
                                             'name': 'Christmas Cove - 10720 - Willard '
                                                     'Kolarik'},
                '78:8a:20:c0:41:72': {       'dev_macs': ['44:a5:6e:78:04:4a'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:72',
                                             'name': 'Island View - 12271 - Peter '
                                                     'Wolcott - 13381'},
                '78:8a:20:c0:42:b7': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:42:b7',
                                             'name': 'UBNT20c042b7'},
                '78:8a:20:c0:43:11': {       'dev_macs': ['38:94:ed:5a:74:1e'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:43:11',
                                             'name': 'Shores Ct - 12375 - Joseph '
                                                     'Defors - 15486'},
                'b4:fb:e4:79:68:2e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:68:2e',
                                             'name': 'UBNTe479682e'},
                'fc:ec:da:e0:5e:65': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:e0:5e:65',
                                             'name': 'UBNTdae05e65'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 4.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '17432437662040',
                                                              'in_ucast_pkts': '13403734956',
                                                              'manufacturer': 'Maxxwax',
                                                              'model': 'MW-SFP+DAC-1M',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '1960754435039',
                                                              'out_ucast_pkts': '5159145010',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRic2ZwMWludGY=',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '132619257054',
                                                              'in_ucast_pkts': '478026886',
                                                              'links': [       {       'in_octets': '20334980259',
                                                                                       'out_octets': '382126985882',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4cGVlcmludGY='},
                                                                               {       'in_octets': '299534420',
                                                                                       'out_octets': '1200060485',
                                                                                       'poller_hash': 'MThlODI5MTliMmIxcGVlcmludGY='},
                                                                               {       'in_octets': '57927547038',
                                                                                       'out_octets': '738675917692',
                                                                                       'poller_hash': 'MThlODI5MTliNDkxcGVlcmludGY='},
                                                                               {       'in_octets': '54057044262',
                                                                                       'out_octets': '1084558219988',
                                                                                       'poller_hash': 'NjhkNzlhMDY4YWYycGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '2206807730808',
                                                              'out_ucast_pkts': '1642226790',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY=',
                                                              'pons': [       {       'description': 'pon1',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 805,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 753,
                                                                                                               'poller_hash': 'MThlODI5MTliMmIxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 979,
                                                                                                               'poller_hash': 'MThlODI5MTliNDkxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 837,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4YWYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '982136526966',
                                                              'in_ucast_pkts': '1764271804',
                                                              'links': [       {       'in_octets': '2875320771',
                                                                                       'out_octets': '6767013935',
                                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjcGVlcmludGY='},
                                                                               {       'in_octets': '28844222892',
                                                                                       'out_octets': '215852524750',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1cGVlcmludGY='},
                                                                               {       'in_octets': '29760272385',
                                                                                       'out_octets': '1004391321993',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmcGVlcmludGY='},
                                                                               {       'in_octets': '7011212619',
                                                                                       'out_octets': '5572730769',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4cGVlcmludGY='},
                                                                               {       'in_octets': '65006343841',
                                                                                       'out_octets': '722698902912',
                                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzcGVlcmludGY='},
                                                                               {       'in_octets': '26498294287',
                                                                                       'out_octets': '645815695042',
                                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1cGVlcmludGY='},
                                                                               {       'in_octets': '28901479743',
                                                                                       'out_octets': '340845759857',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2cGVlcmludGY='},
                                                                               {       'in_octets': '525422464390',
                                                                                       'out_octets': '875156510117',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhcGVlcmludGY='},
                                                                               {       'in_octets': '6015029149',
                                                                                       'out_octets': '37764131492',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4cGVlcmludGY='},
                                                                               {       'in_octets': '9495503296',
                                                                                       'out_octets': '63838111302',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjcGVlcmludGY='},
                                                                               {       'in_octets': '14549160824',
                                                                                       'out_octets': '188409558464',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcycGVlcmludGY='},
                                                                               {       'in_octets': '214824761527',
                                                                                       'out_octets': '712397394726',
                                                                                       'poller_hash': 'MThlODI5ZjVmZjk3cGVlcmludGY='},
                                                                               {       'in_octets': '16592512237',
                                                                                       'out_octets': '252309439843',
                                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0cGVlcmludGY='},
                                                                               {       'in_octets': '2480037101',
                                                                                       'out_octets': '3867703421',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4cGVlcmludGY='},
                                                                               {       'in_octets': '3859797070',
                                                                                       'out_octets': '218246124809',
                                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNicGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '5294179544000',
                                                              'out_ucast_pkts': '4227859375',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY=',
                                                              'pons': [       {       'description': 'pon2',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2247,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 975,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1448,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1398,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1137,
                                                                                                               'poller_hash': 'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1350,
                                                                                                               'poller_hash': 'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1904,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1833,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1894,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1296,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 951,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1475,
                                                                                                               'poller_hash': 'MThlODI5ZjVmZjk3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 2354,
                                                                                                               'poller_hash': 'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2019,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 1729,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'in_errors': '0',
                                                              'in_octets': '187879663770',
                                                              'in_ucast_pkts': '733145429',
                                                              'links': [       {       'in_octets': '63692729499',
                                                                                       'out_octets': '1248255671903',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1cGVlcmludGY='},
                                                                               {       'in_octets': '5530696993',
                                                                                       'out_octets': '76576807976',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0cGVlcmludGY='},
                                                                               {       'in_octets': '57572867345',
                                                                                       'out_octets': '514072433979',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExcGVlcmludGY='},
                                                                               {       'in_octets': '5850564344',
                                                                                       'out_octets': '195572574649',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4cGVlcmludGY='},
                                                                               {       'in_octets': '28482786557',
                                                                                       'out_octets': '367692822981',
                                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon3',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '3205860065741',
                                                              'out_ucast_pkts': '2484178192',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY=',
                                                              'pons': [       {       'description': 'pon3',
                                                                                      'id': '3',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1051,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1254,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4322406',
                                                                                                               'fiber_length': 1160,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '696276',
                                                                                                               'fiber_length': 963,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 701,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon3',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '324120174550',
                                                              'in_ucast_pkts': '1563494514',
                                                              'links': [       {       'in_octets': '32455680456',
                                                                                       'out_octets': '678532036424',
                                                                                       'poller_hash': 'MThlODI5MTk2YzExcGVlcmludGY='},
                                                                               {       'in_octets': '1239678225',
                                                                                       'out_octets': '4915886238',
                                                                                       'poller_hash': 'MThlODI5MTk3MDdicGVlcmludGY='},
                                                                               {       'in_octets': '952532292',
                                                                                       'out_octets': '1375491216',
                                                                                       'poller_hash': 'MThlODI5MTk3NGU1cGVlcmludGY='},
                                                                               {       'in_octets': '1260143510',
                                                                                       'out_octets': '1734780886',
                                                                                       'poller_hash': 'MThlODI5MTliMGE5cGVlcmludGY='},
                                                                               {       'in_octets': '2380974756',
                                                                                       'out_octets': '4845405777',
                                                                                       'poller_hash': 'MThlODI5MTliMGY5cGVlcmludGY='},
                                                                               {       'in_octets': '1472743210',
                                                                                       'out_octets': '8140378726',
                                                                                       'poller_hash': 'MThlODI5MTliMTEycGVlcmludGY='},
                                                                               {       'in_octets': '33981904572',
                                                                                       'out_octets': '918992463273',
                                                                                       'poller_hash': 'MThlODI5MTliMjU3cGVlcmludGY='},
                                                                               {       'in_octets': '7464622801',
                                                                                       'out_octets': '154147386163',
                                                                                       'poller_hash': 'MThlODI5MTliMjYxcGVlcmludGY='},
                                                                               {       'in_octets': '36544651',
                                                                                       'out_octets': '40935539',
                                                                                       'poller_hash': 'MThlODI5MTliMjZicGVlcmludGY='},
                                                                               {       'in_octets': '1104833731',
                                                                                       'out_octets': '337998269',
                                                                                       'poller_hash': 'MThlODI5MTliMjdmcGVlcmludGY='},
                                                                               {       'in_octets': '2776436093',
                                                                                       'out_octets': '14599689500',
                                                                                       'poller_hash': 'MThlODI5MTliMjk4cGVlcmludGY='},
                                                                               {       'in_octets': '77755899',
                                                                                       'out_octets': '475854997',
                                                                                       'poller_hash': 'MThlODI5MTliMmE3cGVlcmludGY='},
                                                                               {       'in_octets': '2309536034',
                                                                                       'out_octets': '27306362339',
                                                                                       'poller_hash': 'MThlODI5MTliMmFjcGVlcmludGY='},
                                                                               {       'in_octets': '3089520612',
                                                                                       'out_octets': '33990849922',
                                                                                       'poller_hash': 'MThlODI5MTliM2Y2cGVlcmludGY='},
                                                                               {       'in_octets': '388447918',
                                                                                       'out_octets': '139759797',
                                                                                       'poller_hash': 'MThlODI5MTliNDBhcGVlcmludGY='},
                                                                               {       'in_octets': '435561254',
                                                                                       'out_octets': '297617759',
                                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwcGVlcmludGY='},
                                                                               {       'in_octets': '27249793080',
                                                                                       'out_octets': '410031384428',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0cGVlcmludGY='},
                                                                               {       'in_octets': '3237963499',
                                                                                       'out_octets': '60424821524',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0cGVlcmludGY='},
                                                                               {       'in_octets': '176',
                                                                                       'out_octets': '0',
                                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkcGVlcmludGY='},
                                                                               {       'in_octets': '51881481642',
                                                                                       'out_octets': '31896289481',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwcGVlcmludGY='},
                                                                               {       'in_octets': '7828326027',
                                                                                       'out_octets': '178128411569',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '4842897763204',
                                                              'out_ucast_pkts': '3568612716',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY=',
                                                              'pons': [       {       'description': 'pon4',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '4484758',
                                                                                                               'fiber_length': 1721,
                                                                                                               'poller_hash': 'MThlODI5MTk2YzExcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 1419,
                                                                                                               'poller_hash': 'MThlODI5MTk3MDdicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1361,
                                                                                                               'poller_hash': 'MThlODI5MTk3NGU1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 1874,
                                                                                                               'poller_hash': 'MThlODI5MTliMGE5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1340,
                                                                                                               'poller_hash': 'MThlODI5MTliMGY5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1356,
                                                                                                               'poller_hash': 'MThlODI5MTliMTEycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1227,
                                                                                                               'poller_hash': 'MThlODI5MTliMjU3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1776,
                                                                                                               'poller_hash': 'MThlODI5MTliMjYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '185592',
                                                                                                               'fiber_length': 1747,
                                                                                                               'poller_hash': 'MThlODI5MTliMjZicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1737394',
                                                                                                               'fiber_length': 1929,
                                                                                                               'poller_hash': 'MThlODI5MTliMjdmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1626,
                                                                                                               'poller_hash': 'MThlODI5MTliMjk4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 1966,
                                                                                                               'poller_hash': 'MThlODI5MTliMmE3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 2131,
                                                                                                               'poller_hash': 'MThlODI5MTliMmFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 2421,
                                                                                                               'poller_hash': 'MThlODI5MTliM2Y2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '575075',
                                                                                                               'fiber_length': 1900,
                                                                                                               'poller_hash': 'MThlODI5MTliNDBhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2134,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2734303',
                                                                                                               'fiber_length': 2014,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 2366,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 2134,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3377329',
                                                                                                               'fiber_length': 1196,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '477264',
                                                                                                               'fiber_length': 2310,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '1',
                                                              'in_errors': '3',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '21243180341',
                                                              'in_ucast_pkts': '127696014',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '36341474912',
                                                              'out_ucast_pkts': '125425445',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRiZXRoMGludGY=',
                                                              'speed': '1000000000'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 13.0,
                                'model': 'UFiber OLT4',
                                'serial_number': 'UBNT20fdf74b',
                                'sw_version': '4.5.3',
                                'system_mac_address': '78:8a:20:fd:f7:4b',
                                'temperature': 45.25,
                                'uptime': '5032002'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'Nzg4YTIwYzA0MmI3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MmI3cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MmI3ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNT20c042b7',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT20c042b7',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '78:8a:20:c0:42:b7'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliMjlkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjlkcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliMjlkZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12637 - Milton Hartig '
                                                 '- 13676',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b29d',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b2:9d'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliM2ZicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliM2ZicG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliM2ZiZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12693 - Mary Jaross - '
                                                 '15893',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b3fb',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b3:fb'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliNGMzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNGMzcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliNGMzZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12493 - Alex Parks - '
                                                 '16106',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b4c3',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b4:c3'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'Nzg0NTU4OTUxODE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTUxODE4cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg0NTU4OTUxODE4ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Foxview - 11886 - James Hatch - '
                                                 '21764',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT58951818',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '78:45:58:95:18:18'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjhkNzlhMDY4OGU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4OGU0cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NjhkNzlhMDY4OGU0ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNT9a0688e4',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT9a0688e4',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '68:d7:9a:06:88:e4'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZmNlY2RhZTA1ZTY1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZTA1ZTY1cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhZTA1ZTY1ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNTdae05e65',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTdae05e65',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'fc:ec:da:e0:5e:65'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0Nzk2ODJlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk2ODJlcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0Nzk2ODJlZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNTe479682e',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTe479682e',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:79:68:2e'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '382126985882',
                                                                       'links': [       {       'in_octets': '382126985882',
                                                                                                'out_octets': '20334980259',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '20334980259',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 805,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.538,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.948}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '30:de:4b:9e:af:e1'],
                                                                       'id': '1',
                                                                       'in_octets': '20334980259',
                                                                       'mac_address': '78:8a:20:c1:40:c8',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '382126985882',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12411 - Paul Hsieh - '
                                                 '17977',
                                         'serial_number': 'UBNT20c040c8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:c8',
                                         'temperature': 35.0,
                                         'uptime': '5032189'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1200060485',
                                                                       'links': [       {       'in_octets': '1200060485',
                                                                                                'out_octets': '299534420',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '299534420',
                                                                       'poller_hash': 'MThlODI5MTliMmIxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 753,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.832,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.28}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmIxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:d2:94:18:e9:d8'],
                                                                       'id': '1',
                                                                       'in_octets': '299534420',
                                                                       'mac_address': '18:e8:29:1a:b2:b1',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1200060485',
                                                                       'poller_hash': 'MThlODI5MTliMmIxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12371 - Christine Polo '
                                                 '- 20910',
                                         'serial_number': 'UBNT2919b2b1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:b1',
                                         'temperature': 27.0,
                                         'uptime': '5032195'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '738675917692',
                                                                       'links': [       {       'in_octets': '738675917692',
                                                                                                'out_octets': '57927547038',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '57927547038',
                                                                       'poller_hash': 'MThlODI5MTliNDkxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 979,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.728,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.618}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNDkxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:b7:6e:1e:fa:76'],
                                                                       'id': '1',
                                                                       'in_octets': '57927547038',
                                                                       'mac_address': '18:e8:29:1a:b4:91',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '738675917692',
                                                                       'poller_hash': 'MThlODI5MTliNDkxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12515 - Brandon '
                                                 'Theophilus - 18564',
                                         'serial_number': 'UBNT2919b491',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b4:91',
                                         'temperature': 35.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1084558219988',
                                                                       'links': [       {       'in_octets': '1084558219988',
                                                                                                'out_octets': '54057044262',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '54057044262',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 837,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.354,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4YWYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ed:00:a9:df:2c'],
                                                                       'id': '1',
                                                                       'in_octets': '54057044262',
                                                                       'mac_address': '68:d7:9a:07:8a:f2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1084558219988',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12445 - Stanley Pruss '
                                                 '-  15077',
                                         'serial_number': 'UBNT9a068af2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:8a:f2',
                                         'temperature': 32.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '6767013935',
                                                                       'links': [       {       'in_octets': '6767013935',
                                                                                                'out_octets': '2875320771',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2875320771',
                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2247,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.426,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.566}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '24:4b:fe:39:0b:19'],
                                                                       'id': '1',
                                                                       'in_octets': '2875320771',
                                                                       'mac_address': '78:8a:20:74:6f:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6767013935',
                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 11850 - Paul Belden - '
                                                 '17943',
                                         'serial_number': 'UBNT20736f2c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:6f:2c',
                                         'temperature': 36.0,
                                         'uptime': '5032237'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '215852524750',
                                                                       'links': [       {       'in_octets': '215852524750',
                                                                                                'out_octets': '28844222892',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28844222892',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 975,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.412,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.414}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '68:d7:9a:d0:82:f8'],
                                                                       'id': '1',
                                                                       'in_octets': '28844222892',
                                                                       'mac_address': '78:8a:20:74:72:15',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '215852524750',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Island View - 12260 - Thomas Shaver '
                                                 '- 13374',
                                         'serial_number': 'UBNT20737215',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:72:15',
                                         'temperature': 32.0,
                                         'uptime': '5032234'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1004391321993',
                                                                       'links': [       {       'in_octets': '1004391321993',
                                                                                                'out_octets': '29760272385',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '29760272385',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1448,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.45,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.278}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:02:9c:53:0a:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '29760272385',
                                                                       'mac_address': '78:8a:20:74:72:bf',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1004391321993',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 12155 - Jeffery McGalliard '
                                                 '- 17944',
                                         'serial_number': 'UBNT207372bf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:72:bf',
                                         'temperature': 37.0,
                                         'uptime': '5032231'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '5572730769',
                                                                       'links': [       {       'in_octets': '5572730769',
                                                                                                'out_octets': '7011212619',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7011212619',
                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1398,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.788,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.412}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:01:9f:1e:4b:01'],
                                                                       'id': '1',
                                                                       'in_octets': '7011212619',
                                                                       'mac_address': '78:8a:20:74:79:18',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5572730769',
                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 12097 - Steve Holmes - '
                                                 '18097',
                                         'serial_number': 'UBNT20737918',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:79:18',
                                         'temperature': 35.0,
                                         'uptime': '5032242'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '722698902912',
                                                                       'links': [       {       'in_octets': '722698902912',
                                                                                                'out_octets': '65006343841',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '65006343841',
                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1137,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.86,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.986}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:59:c0:a4:a6:6b'],
                                                                       'id': '1',
                                                                       'in_octets': '65006343841',
                                                                       'mac_address': '78:8a:20:79:e8:a3',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '722698902912',
                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12236 - Randy Harmson - '
                                                 '15026',
                                         'serial_number': 'UBNT2078e8a3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:78:e8:a3',
                                         'temperature': 38.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '645815695042',
                                                                       'links': [       {       'in_octets': '645815695042',
                                                                                                'out_octets': '26498294287',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '26498294287',
                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1350,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.398,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.99}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:cc:9c:2c:d0:ac'],
                                                                       'id': '1',
                                                                       'in_octets': '26498294287',
                                                                       'mac_address': '78:8a:20:79:f0:a5',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '645815695042',
                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12191 - Jim Flutur -  '
                                                 '13587',
                                         'serial_number': 'UBNT2078f0a5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:78:f0:a5',
                                         'temperature': 43.0,
                                         'uptime': '5032187'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '340845759857',
                                                                       'links': [       {       'in_octets': '340845759857',
                                                                                                'out_octets': '28901479743',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28901479743',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1904,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.078,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:dd:0c:be:7a:20'],
                                                                       'id': '1',
                                                                       'in_octets': '28901479743',
                                                                       'mac_address': '78:8a:20:c1:40:96',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '340845759857',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11945 - Phil Smith - 17942',
                                         'serial_number': 'UBNT20c04096',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:96',
                                         'temperature': 31.0,
                                         'uptime': '5032187'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '875156510117',
                                                                       'links': [       {       'in_octets': '875156510117',
                                                                                                'out_octets': '525422464390',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '525422464390',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1833,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.872,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.906}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:ac:b9:fd:bc:a6'],
                                                                       'id': '1',
                                                                       'in_octets': '525422464390',
                                                                       'mac_address': '78:8a:20:c1:40:aa',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '875156510117',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11963 - David Watkins - '
                                                 '17965',
                                         'serial_number': 'UBNT20c040aa',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:aa',
                                         'temperature': 27.0,
                                         'uptime': '5032188'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '37764131492',
                                                                       'links': [       {       'in_octets': '37764131492',
                                                                                                'out_octets': '6015029149',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6015029149',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1894,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.078,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:f9:07:c8'],
                                                                       'id': '1',
                                                                       'in_octets': '6015029149',
                                                                       'mac_address': '78:8a:20:c1:41:18',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '37764131492',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11920 - Chase, Janeen - '
                                                 '21513',
                                         'serial_number': 'UBNT20c04118',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:18',
                                         'temperature': 33.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '63838111302',
                                                                       'links': [       {       'in_octets': '63838111302',
                                                                                                'out_octets': '9495503296',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9495503296',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1296,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.416,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.662}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:3b:ad:3d:32:a3'],
                                                                       'id': '1',
                                                                       'in_octets': '9495503296',
                                                                       'mac_address': '78:8a:20:c1:41:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '63838111302',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12158 - Carolyn Grauer - '
                                                 '21816',
                                         'serial_number': 'UBNT20c0412c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:2c',
                                         'temperature': 32.0,
                                         'uptime': '5032191'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188409558464',
                                                                       'links': [       {       'in_octets': '188409558464',
                                                                                                'out_octets': '14549160824',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '14549160824',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 951,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.562}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '44:a5:6e:78:04:4a'],
                                                                       'id': '1',
                                                                       'in_octets': '14549160824',
                                                                       'mac_address': '78:8a:20:c1:41:72',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188409558464',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12271 - Peter Wolcott '
                                                 '- 13381',
                                         'serial_number': 'UBNT20c04172',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:72',
                                         'temperature': 36.0,
                                         'uptime': '5032188'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '712397394726',
                                                                       'links': [       {       'in_octets': '712397394726',
                                                                                                'out_octets': '214824761527',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '214824761527',
                                                                       'poller_hash': 'MThlODI5ZjVmZjk3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1475,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.564,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.032}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjVmZjk3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:ac:b9:46:e6:45'],
                                                                       'id': '1',
                                                                       'in_octets': '214824761527',
                                                                       'mac_address': '18:e8:29:f6:ff:97',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '712397394726',
                                                                       'poller_hash': 'MThlODI5ZjVmZjk3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12010 - Douglas Jester - '
                                                 '16616',
                                         'serial_number': 'UBNT29f5ff97',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:f5:ff:97',
                                         'temperature': 28.0,
                                         'uptime': '5032179'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '252309439843',
                                                                       'links': [       {       'in_octets': '252309439843',
                                                                                                'out_octets': '16592512237',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '16592512237',
                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 2354,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.938,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.556}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '28:87:ba:76:31:21'],
                                                                       'id': '1',
                                                                       'in_octets': '16592512237',
                                                                       'mac_address': '78:45:58:96:28:a4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '252309439843',
                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Peterson Park - 10323 - Rich Simons '
                                                 '- 21424',
                                         'serial_number': 'UBNT589528a4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:95:28:a4',
                                         'temperature': 31.0,
                                         'uptime': '8187325'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '3867703421',
                                                                       'links': [       {       'in_octets': '3867703421',
                                                                                                'out_octets': '2480037101',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2480037101',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2019,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.228,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.696}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:b6:b6:05:8c:80'],
                                                                       'id': '1',
                                                                       'in_octets': '2480037101',
                                                                       'mac_address': '74:83:c2:44:f7:28',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3867703421',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11907 - Todd Hoogland - '
                                                 '17100',
                                         'serial_number': 'UBNTc243f728',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:f7:28',
                                         'temperature': 26.0,
                                         'uptime': '5032181'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '218246124809',
                                                                       'links': [       {       'in_octets': '218246124809',
                                                                                                'out_octets': '3859797070',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3859797070',
                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 1729,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.35,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.708}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:3b:ad:f1:f0:12'],
                                                                       'id': '1',
                                                                       'in_octets': '3859797070',
                                                                       'mac_address': '74:83:c2:69:af:3b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '218246124809',
                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': 'N Foxview - 11981 - Tina Serne - '
                                                 '17978',
                                         'serial_number': 'UBNTc268af3b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:68:af:3b',
                                         'temperature': 27.0,
                                         'uptime': '5032221'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1248255671903',
                                                                       'links': [       {       'in_octets': '1248255671903',
                                                                                                'out_octets': '63692729499',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '63692729499',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1051,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.532,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.618}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:01:9f:20:4e:b9'],
                                                                       'id': '1',
                                                                       'in_octets': '63692729499',
                                                                       'mac_address': '78:8a:20:c1:41:45',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1248255671903',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12390 - Ann Anderson - '
                                                 '18014',
                                         'serial_number': 'UBNT20c04145',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:45',
                                         'temperature': 31.0,
                                         'uptime': '5032190'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '76576807976',
                                                                       'links': [       {       'in_octets': '76576807976',
                                                                                                'out_octets': '5530696993',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5530696993',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1254,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.898}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:d2:68:7d'],
                                                                       'id': '1',
                                                                       'in_octets': '5530696993',
                                                                       'mac_address': '78:8a:20:c1:41:54',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '76576807976',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Christmas Cove - 10720 - Willard '
                                                 'Kolarik',
                                         'serial_number': 'UBNT20c04154',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:54',
                                         'temperature': 33.0,
                                         'uptime': '5255084'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '514072433979',
                                                                       'links': [       {       'in_octets': '514072433979',
                                                                                                'out_octets': '57572867345',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '57572867345',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4322406',
                                                                                                                        'fiber_length': 1160,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.982}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '38:94:ed:5a:74:1e'],
                                                                       'id': '1',
                                                                       'in_octets': '57572867345',
                                                                       'mac_address': '78:8a:20:c1:43:11',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '514072433979',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12375 - Joseph Defors - '
                                                 '15486',
                                         'serial_number': 'UBNT20c04311',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:43:11',
                                         'temperature': 34.0,
                                         'uptime': '4322459'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '195572574649',
                                                                       'links': [       {       'in_octets': '195572574649',
                                                                                                'out_octets': '5850564344',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5850564344',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '696276',
                                                                                                                        'fiber_length': 963,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.316,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.266}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c0:06:c3:2f:d4:3d'],
                                                                       'id': '1',
                                                                       'in_octets': '5850564344',
                                                                       'mac_address': '78:45:58:91:e1:88',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '195572574649',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12372 - Maginot, Anne & '
                                                 'Peter - 20791',
                                         'serial_number': 'UBNT5890e188',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e1:88',
                                         'temperature': 28.0,
                                         'uptime': '738817'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '367692822981',
                                                                       'links': [       {       'in_octets': '367692822981',
                                                                                                'out_octets': '28482786557',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28482786557',
                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 701,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.324,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.784}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:40:d0:50:f6:20'],
                                                                       'id': '1',
                                                                       'in_octets': '28482786557',
                                                                       'mac_address': '68:d7:9a:07:87:03',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '367692822981',
                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12331 - William Cron - '
                                                 '13536',
                                         'serial_number': 'UBNT9a068703',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:87:03',
                                         'temperature': 34.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '678532036424',
                                                                       'links': [       {       'in_octets': '678532036424',
                                                                                                'out_octets': '32455680456',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '32455680456',
                                                                       'poller_hash': 'MThlODI5MTk2YzExcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4484758',
                                                                                                                        'fiber_length': 1721,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.934,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk2YzExcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a0:40:a0:71:2d:88'],
                                                                       'id': '1',
                                                                       'in_octets': '32455680456',
                                                                       'mac_address': '18:e8:29:1a:6c:11',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '678532036424',
                                                                       'poller_hash': 'MThlODI5MTk2YzExZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12705 - Karen '
                                                 'Mulvahill - 14204',
                                         'serial_number': 'UBNT29196c11',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:6c:11',
                                         'temperature': 28.0,
                                         'uptime': '4484807'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4915886238',
                                                                       'links': [       {       'in_octets': '4915886238',
                                                                                                'out_octets': '1239678225',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1239678225',
                                                                       'poller_hash': 'MThlODI5MTk3MDdicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 1419,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.016,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.66}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk3MDdicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:0c:6b:2d:94:8a'],
                                                                       'id': '1',
                                                                       'in_octets': '1239678225',
                                                                       'mac_address': '18:e8:29:1a:70:7b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4915886238',
                                                                       'poller_hash': 'MThlODI5MTk3MDdiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View-12545-John Wadas-16542',
                                         'serial_number': 'UBNT2919707b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:70:7b',
                                         'temperature': 40.0,
                                         'uptime': '5032193'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1375491216',
                                                                       'links': [       {       'in_octets': '1375491216',
                                                                                                'out_octets': '952532292',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '952532292',
                                                                       'poller_hash': 'MThlODI5MTk3NGU1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1361,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.406}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk3NGU1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:99:cd:79'],
                                                                       'id': '1',
                                                                       'in_octets': '952532292',
                                                                       'mac_address': '18:e8:29:1a:74:e5',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1375491216',
                                                                       'poller_hash': 'MThlODI5MTk3NGU1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12571 - John Scott - '
                                                 '18909',
                                         'serial_number': 'UBNT291974e5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:74:e5',
                                         'temperature': 37.0,
                                         'uptime': '5032194'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1734780886',
                                                                       'links': [       {       'in_octets': '1734780886',
                                                                                                'out_octets': '1260143510',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1260143510',
                                                                       'poller_hash': 'MThlODI5MTliMGE5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 1874,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.494,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.626}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMGE5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '3c:37:86:c8:4c:76'],
                                                                       'id': '1',
                                                                       'in_octets': '1260143510',
                                                                       'mac_address': '18:e8:29:1a:b0:a9',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1734780886',
                                                                       'poller_hash': 'MThlODI5MTliMGE5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12771 - Bill Brown - '
                                                 '13712',
                                         'serial_number': 'UBNT2919b0a9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b0:a9',
                                         'temperature': 30.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4845405777',
                                                                       'links': [       {       'in_octets': '4845405777',
                                                                                                'out_octets': '2380974756',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2380974756',
                                                                       'poller_hash': 'MThlODI5MTliMGY5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1340,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.168,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.64}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMGY5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b0:39:56:50:a7:80'],
                                                                       'id': '1',
                                                                       'in_octets': '2380974756',
                                                                       'mac_address': '18:e8:29:1a:b0:f9',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4845405777',
                                                                       'poller_hash': 'MThlODI5MTliMGY5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12563 - Don DAnnunzio '
                                                 '- 17717',
                                         'serial_number': 'UBNT2919b0f9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b0:f9',
                                         'temperature': 35.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '8140378726',
                                                                       'links': [       {       'in_octets': '8140378726',
                                                                                                'out_octets': '1472743210',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1472743210',
                                                                       'poller_hash': 'MThlODI5MTliMTEycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1356,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.326,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.692}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMTEycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a0:04:60:04:24:be'],
                                                                       'id': '1',
                                                                       'in_octets': '1472743210',
                                                                       'mac_address': '18:e8:29:1a:b1:12',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8140378726',
                                                                       'poller_hash': 'MThlODI5MTliMTEyZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12585 - Ronald Jones - '
                                                 '14376',
                                         'serial_number': 'UBNT2919b112',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b1:12',
                                         'temperature': 32.0,
                                         'uptime': '5032199'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '918992463273',
                                                                       'links': [       {       'in_octets': '918992463273',
                                                                                                'out_octets': '33981904572',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33981904572',
                                                                       'poller_hash': 'MThlODI5MTliMjU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1227,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.634,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.768}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjU3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f4:92:bf:66:6a:d1'],
                                                                       'id': '1',
                                                                       'in_octets': '33981904572',
                                                                       'mac_address': '18:e8:29:1a:b2:57',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '918992463273',
                                                                       'poller_hash': 'MThlODI5MTliMjU3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12527 - John '
                                                 'Christophersen - 17017',
                                         'serial_number': 'UBNT2919b257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:57',
                                         'temperature': 37.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '154147386163',
                                                                       'links': [       {       'in_octets': '154147386163',
                                                                                                'out_octets': '7464622801',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7464622801',
                                                                       'poller_hash': 'MThlODI5MTliMjYxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1776,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.042,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.496}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjYxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:b0:ce:10:fa:03'],
                                                                       'id': '1',
                                                                       'in_octets': '7464622801',
                                                                       'mac_address': '18:e8:29:1a:b2:61',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '154147386163',
                                                                       'poller_hash': 'MThlODI5MTliMjYxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12755 - Paul '
                                                 'Christopheren - 16068',
                                         'serial_number': 'UBNT2919b261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:61',
                                         'temperature': 30.0,
                                         'uptime': '5032201'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '40935539',
                                                                       'links': [       {       'in_octets': '40935539',
                                                                                                'out_octets': '36544651',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '36544651',
                                                                       'poller_hash': 'MThlODI5MTliMjZicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '185592',
                                                                                                                        'fiber_length': 1747,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.366,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.638}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjZicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:0c:6b:d6:f0:fe'],
                                                                       'id': '1',
                                                                       'in_octets': '36544651',
                                                                       'mac_address': '18:e8:29:1a:b2:6b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '40935539',
                                                                       'poller_hash': 'MThlODI5MTliMjZiZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12727 - Rich Sutliff - '
                                                 '14696',
                                         'serial_number': 'UBNT2919b26b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:6b',
                                         'temperature': 31.0,
                                         'uptime': '185648'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '337998269',
                                                                       'links': [       {       'in_octets': '337998269',
                                                                                                'out_octets': '1104833731',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1104833731',
                                                                       'poller_hash': 'MThlODI5MTliMjdmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1737394',
                                                                                                                        'fiber_length': 1929,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.19,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.39}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjdmcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:d2:94:18:c2:98'],
                                                                       'id': '1',
                                                                       'in_octets': '1104833731',
                                                                       'mac_address': '18:e8:29:1a:b2:7f',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '337998269',
                                                                       'poller_hash': 'MThlODI5MTliMjdmZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12811 - Robert Shirkey '
                                                 '- 13719',
                                         'serial_number': 'UBNT2919b27f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:7f',
                                         'temperature': 37.0,
                                         'uptime': '1737450'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '14599689500',
                                                                       'links': [       {       'in_octets': '14599689500',
                                                                                                'out_octets': '2776436093',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2776436093',
                                                                       'poller_hash': 'MThlODI5MTliMjk4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1626,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.272,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.088}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjk4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:07:b6:74:c5:ee'],
                                                                       'id': '1',
                                                                       'in_octets': '2776436093',
                                                                       'mac_address': '18:e8:29:1a:b2:98',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14599689500',
                                                                       'poller_hash': 'MThlODI5MTliMjk4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island VIew - 12655 - Al Blinke - '
                                                 '15472',
                                         'serial_number': 'UBNT2919b298',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:98',
                                         'temperature': 35.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '475854997',
                                                                       'links': [       {       'in_octets': '475854997',
                                                                                                'out_octets': '77755899',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '77755899',
                                                                       'poller_hash': 'MThlODI5MTliMmE3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 1966,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.362,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.428}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmE3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:32:e4:b2:fc:50'],
                                                                       'id': '1',
                                                                       'in_octets': '77755899',
                                                                       'mac_address': '18:e8:29:1a:b2:a7',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '475854997',
                                                                       'poller_hash': 'MThlODI5MTliMmE3ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12831 - DomeHouse LLC '
                                                 '- 13718',
                                         'serial_number': 'UBNT2919b2a7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:a7',
                                         'temperature': 30.0,
                                         'uptime': '5032200'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '27306362339',
                                                                       'links': [       {       'in_octets': '27306362339',
                                                                                                'out_octets': '2309536034',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2309536034',
                                                                       'poller_hash': 'MThlODI5MTliMmFjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 2131,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.644,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.742}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmFjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:36:c9:14:fc:10'],
                                                                       'id': '1',
                                                                       'in_octets': '2309536034',
                                                                       'mac_address': '18:e8:29:1a:b2:ac',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27306362339',
                                                                       'poller_hash': 'MThlODI5MTliMmFjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12891 - Terry Fera - '
                                                 '15115',
                                         'serial_number': 'UBNT2919b2ac',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:ac',
                                         'temperature': 34.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '33990849922',
                                                                       'links': [       {       'in_octets': '33990849922',
                                                                                                'out_octets': '3089520612',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3089520612',
                                                                       'poller_hash': 'MThlODI5MTliM2Y2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 2421,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.594,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.56}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliM2Y2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:3b:6b:92:e4:29'],
                                                                       'id': '1',
                                                                       'in_octets': '3089520612',
                                                                       'mac_address': '18:e8:29:1a:b3:f6',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '33990849922',
                                                                       'poller_hash': 'MThlODI5MTliM2Y2ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12973 - Christine Kay '
                                                 '- 16910',
                                         'serial_number': 'UBNT2919b3f6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b3:f6',
                                         'temperature': 34.0,
                                         'uptime': '5032192'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '139759797',
                                                                       'links': [       {       'in_octets': '139759797',
                                                                                                'out_octets': '388447918',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '388447918',
                                                                       'poller_hash': 'MThlODI5MTliNDBhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '575075',
                                                                                                                        'fiber_length': 1900,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.212,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.342}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNDBhcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:f9:95:4f'],
                                                                       'id': '1',
                                                                       'in_octets': '388447918',
                                                                       'mac_address': '18:e8:29:1a:b4:0a',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '139759797',
                                                                       'poller_hash': 'MThlODI5MTliNDBhZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12803 - Stephen '
                                                 'Rigotti - 14850',
                                         'serial_number': 'UBNT2919b40a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b4:0a',
                                         'temperature': 35.0,
                                         'uptime': '575128'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '297617759',
                                                                       'links': [       {       'in_octets': '297617759',
                                                                                                'out_octets': '435561254',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '435561254',
                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2134,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.544,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ed:00:85:28:a5'],
                                                                       'id': '1',
                                                                       'in_octets': '435561254',
                                                                       'mac_address': '78:45:58:91:da:70',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '297617759',
                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12875 - Bridget Lamont '
                                                 '- 13721',
                                         'serial_number': 'UBNT5890da70',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:da:70',
                                         'temperature': 28.0,
                                         'uptime': '5032195'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '410031384428',
                                                                       'links': [       {       'in_octets': '410031384428',
                                                                                                'out_octets': '27249793080',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '27249793080',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2734303',
                                                                                                                        'fiber_length': 2014,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.912,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.364}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c8:9e:43:db:81:8b'],
                                                                       'id': '1',
                                                                       'in_octets': '27249793080',
                                                                       'mac_address': '78:45:58:91:e0:f4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '410031384428',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12851 - Joanne Whitley '
                                                 '- 14649',
                                         'serial_number': 'UBNT5890e0f4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e0:f4',
                                         'temperature': 30.0,
                                         'uptime': '2734357'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '60424821524',
                                                                       'links': [       {       'in_octets': '60424821524',
                                                                                                'out_octets': '3237963499',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3237963499',
                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 2366,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.142,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.622}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:91:e3:43:0d:f4'],
                                                                       'id': '1',
                                                                       'in_octets': '3237963499',
                                                                       'mac_address': '78:45:58:91:e8:94',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '60424821524',
                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island Lake Dr - 13015 -Marilee '
                                                 'Milroy - 13348',
                                         'serial_number': 'UBNT5890e894',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e8:94',
                                         'temperature': 26.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '0',
                                                                       'links': [       {       'in_octets': '0',
                                                                                                'out_octets': '176',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '176',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 2134,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.798,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.486}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'mac_address': '68:d7:9a:07:8a:ad',
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island Dr - 12901 - Dan Cermak - '
                                                 '20905',
                                         'serial_number': 'UBNT9a068aad',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:8a:ad',
                                         'temperature': 23.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '31896289481',
                                                                       'links': [       {       'in_octets': '31896289481',
                                                                                                'out_octets': '51881481642',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '51881481642',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3377329',
                                                                                                                        'fiber_length': 1196,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.586,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.672}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:22:54:32:d5:d1'],
                                                                       'id': '1',
                                                                       'in_octets': '51881481642',
                                                                       'mac_address': '74:83:c2:44:f7:90',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '31896289481',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12531 - Malcolm Hickok '
                                                 '- 21903',
                                         'serial_number': 'UBNTc243f790',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:f7:90',
                                         'temperature': 31.0,
                                         'uptime': '3377385'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '178128411569',
                                                                       'links': [       {       'in_octets': '178128411569',
                                                                                                'out_octets': '7828326027',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7828326027',
                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '477264',
                                                                                                                        'fiber_length': 2310,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.31}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:91:82:2e:cf:55'],
                                                                       'id': '1',
                                                                       'in_octets': '7828326027',
                                                                       'mac_address': '74:83:c2:44:fb:46',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '178128411569',
                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View Dr - 12931 - Judy Burns '
                                                 '- 15696',
                                         'serial_number': 'UBNTc243fb46',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:fb:46',
                                         'temperature': 33.0,
                                         'uptime': '477324'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_4_9_172_21_44_6(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.4.9.172_21_44_6")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 16,
                'sw_version': '4.4.9',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 1
        }
        exp_sta_stats = {
                '18:e8:29:0b:9a:d8': {       'dev_macs': ['74:4d:28:5b:15:46'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:9a:d8',
                                             'name': '22062-christina-king'},
                '18:e8:29:0b:b2:60': {       'dev_macs': ['1c:b7:2c:73:fb:88'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:b2:60',
                                             'name': '756737-blake-bennetts'},
                '18:e8:29:0b:d5:8c': {       'dev_macs': ['78:9a:18:42:bd:d4'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:d5:8c',
                                             'name': '23673-luke-urbine-nanog'},
                '18:e8:29:0b:d5:e4': {       'dev_macs': ['c8:7f:54:27:30:80'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:d5:e4',
                                             'name': '756708-dallas-campbell'},
                '18:e8:29:0b:f3:0c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f3:0c',
                                             'name': ''},
                '18:e8:29:0b:f7:10': {       'dev_macs': ['48:a9:8a:3a:a4:36'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f7:10',
                                             'name': '756279-alison-peticolas'},
                '18:e8:29:0b:f8:04': {       'dev_macs': ['d8:07:b6:f8:97:5e'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f8:04',
                                             'name': '26323-brett-wingo'},
                '18:e8:29:0b:f9:c0': {       'dev_macs': ['48:8f:5a:48:c3:db'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f9:c0',
                                             'name': '21839-greg-turner'},
                '18:e8:29:0b:f9:ec': {       'dev_macs': ['78:9a:18:90:0c:6f'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f9:ec',
                                             'name': '756755-michael-blashka'},
                '18:e8:29:f5:80:54': {       'dev_macs': ['18:b1:69:e3:c3:a1'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:80:54',
                                             'name': '22049-Darren Patterson Christian '
                                                     'Academy'},
                '18:e8:29:f5:b0:72': {       'dev_macs': ['68:d7:9a:67:b9:2d'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:b0:72',
                                             'name': '10340-carlin-walsh-ufiberwifi'},
                '74:83:c2:f0:1e:90': {       'dev_macs': ['48:a9:8a:5f:bc:94'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:1e:90',
                                             'name': '756289-evan-bartlett-nanog'},
                '74:83:c2:f0:b1:a4': {       'dev_macs': ['18:fd:74:1c:bf:7a'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:b1:a4',
                                             'name': '756084-anna-toll'},
                'b4:fb:e4:eb:4d:58': {       'dev_macs': ['48:8f:5a:49:bf:9b'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:58',
                                             'name': '10523-jay-leaver-nanog'},
                'b4:fb:e4:eb:4d:62': {       'dev_macs': ['34:98:b5:c4:4e:11'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:62',
                                             'name': '24017-grace-garret-nanog'},
                'b4:fb:e4:eb:50:73': {       'dev_macs': ['48:8f:5a:82:a9:f7'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:50:73',
                                             'name': '20157-ellen-kelly-nanog'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '2',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '20388745886',
                                                              'in_ucast_pkts': '86765026',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '22445466182',
                                                              'out_ucast_pkts': '113743252',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1ZXRoMGludGY=',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'name': 'pon1',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uMWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '1120555480947',
                                                              'in_ucast_pkts': '3004647724',
                                                              'links': [       {       'in_octets': '60038134941',
                                                                                       'out_octets': '433845025854',
                                                                                       'poller_hash': 'MThlODI5MGI5YWQ4cGVlcmludGY='},
                                                                               {       'in_octets': '51597476640',
                                                                                       'out_octets': '376473216479',
                                                                                       'poller_hash': 'MThlODI5MGJiMjYwcGVlcmludGY='},
                                                                               {       'in_octets': '77031716161',
                                                                                       'out_octets': '1285929769043',
                                                                                       'poller_hash': 'MThlODI5MGJmODA0cGVlcmludGY='},
                                                                               {       'in_octets': '55272372563',
                                                                                       'out_octets': '654710786269',
                                                                                       'poller_hash': 'MThlODI5MGJmOWMwcGVlcmludGY='},
                                                                               {       'in_octets': '140405299525',
                                                                                       'out_octets': '758396543589',
                                                                                       'poller_hash': 'MThlODI5ZjU4MDU0cGVlcmludGY='},
                                                                               {       'in_octets': '13635545316',
                                                                                       'out_octets': '153401865394',
                                                                                       'poller_hash': 'MThlODI5ZjViMDcycGVlcmludGY='},
                                                                               {       'in_octets': '79506814602',
                                                                                       'out_octets': '877525143799',
                                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwcGVlcmludGY='},
                                                                               {       'in_octets': '33624625113',
                                                                                       'out_octets': '343333914855',
                                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0cGVlcmludGY='},
                                                                               {       'in_octets': '6190169311',
                                                                                       'out_octets': '26759028333',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4cGVlcmludGY='},
                                                                               {       'in_octets': '16408151466',
                                                                                       'out_octets': '244967364534',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYycGVlcmludGY='},
                                                                               {       'in_octets': '30361231639',
                                                                                       'out_octets': '882718479596',
                                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '11228178267328',
                                                              'out_ucast_pkts': '8601966144',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY=',
                                                              'pons': [       {       'description': 'pon2',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '5605556',
                                                                                                               'fiber_length': 330,
                                                                                                               'poller_hash': 'MThlODI5MGI5YWQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3604765',
                                                                                                               'fiber_length': 666,
                                                                                                               'poller_hash': 'MThlODI5MGJiMjYwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2561113',
                                                                                                               'fiber_length': 82,
                                                                                                               'poller_hash': 'MThlODI5MGJmODA0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3890178',
                                                                                                               'fiber_length': 407,
                                                                                                               'poller_hash': 'MThlODI5MGJmOWMwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3699886',
                                                                                                               'fiber_length': 775,
                                                                                                               'poller_hash': 'MThlODI5ZjU4MDU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '389919',
                                                                                                               'fiber_length': 14,
                                                                                                               'poller_hash': 'MThlODI5ZjViMDcycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496547',
                                                                                                               'fiber_length': 644,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2409532',
                                                                                                               'fiber_length': 892,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496546',
                                                                                                               'fiber_length': 276,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496546',
                                                                                                               'fiber_length': 299,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496537',
                                                                                                               'fiber_length': 333,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '127260632961',
                                                              'in_ucast_pkts': '499224099',
                                                              'links': [       {       'in_octets': '36518536949',
                                                                                       'out_octets': '548885766037',
                                                                                       'poller_hash': 'MThlODI5MGJkNThjcGVlcmludGY='},
                                                                               {       'in_octets': '11447796092',
                                                                                       'out_octets': '194847602663',
                                                                                       'poller_hash': 'MThlODI5MGJkNWU0cGVlcmludGY='},
                                                                               {       'in_octets': '44346977227',
                                                                                       'out_octets': '554524252919',
                                                                                       'poller_hash': 'MThlODI5MGJmNzEwcGVlcmludGY='},
                                                                               {       'in_octets': '28361070702',
                                                                                       'out_octets': '276946513313',
                                                                                       'poller_hash': 'MThlODI5MGJmOWVjcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '1645173503700',
                                                              'out_ucast_pkts': '1273390540',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY=',
                                                              'pons': [       {       'description': 'pon4',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '6636377',
                                                                                                               'fiber_length': 1098,
                                                                                                               'poller_hash': 'MThlODI5MGJkNThjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '6280693',
                                                                                                               'fiber_length': 980,
                                                                                                               'poller_hash': 'MThlODI5MGJkNWU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '6654297',
                                                                                                               'fiber_length': 920,
                                                                                                               'poller_hash': 'MThlODI5MGJmNzEwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2856206',
                                                                                                               'fiber_length': 852,
                                                                                                               'poller_hash': 'MThlODI5MGJmOWVjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon5',
                                                              'name': 'pon5',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon6',
                                                              'name': 'pon6',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNmludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon7',
                                                              'name': 'pon7',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uN2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon8',
                                                              'name': 'pon8',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uOGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '12833913779436',
                                                              'in_ucast_pkts': '9877430610',
                                                              'manufacturer': 'OEM',
                                                              'model': 'HWDA0001',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '1233848286561',
                                                              'out_ucast_pkts': '3503991099',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMWludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'sfp2',
                                                              'name': 'SFP+ 2',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMmludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 13.0,
                                'model': 'UFiber OLT',
                                'serial_number': 'UBNTe41b2875',
                                'sw_version': '4.4.9',
                                'system_mac_address': 'b4:fb:e4:1b:28:75',
                                'temperature': 30.25,
                                'uptime': '7496661'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MGJmMzBjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmMzBjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MGJmMzBjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': '',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'Power outage not '
                                                                  'detected.',
                                         'serial_number': 'UBNT290bf30c',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:0b:f3:0c'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '433845025854',
                                                                       'links': [       {       'in_octets': '433845025854',
                                                                                                'out_octets': '60038134941',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '60038134941',
                                                                       'poller_hash': 'MThlODI5MGI5YWQ4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '5605556',
                                                                                                                        'fiber_length': 330,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.392,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.716}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGI5YWQ4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:4d:28:5b:15:46'],
                                                                       'id': '1',
                                                                       'in_octets': '60038134941',
                                                                       'mac_address': '18:e8:29:0c:9a:d8',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '433845025854',
                                                                       'poller_hash': 'MThlODI5MGI5YWQ4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '22062-christina-king',
                                         'serial_number': 'UBNT290b9ad8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:9a:d8',
                                         'temperature': 48.0,
                                         'uptime': '5605599'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '376473216479',
                                                                       'links': [       {       'in_octets': '376473216479',
                                                                                                'out_octets': '51597476640',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '51597476640',
                                                                       'poller_hash': 'MThlODI5MGJiMjYwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3604765',
                                                                                                                        'fiber_length': 666,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.988,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.118}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJiMjYwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:b7:2c:73:fb:88'],
                                                                       'id': '1',
                                                                       'in_octets': '51597476640',
                                                                       'mac_address': '18:e8:29:0c:b2:60',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '376473216479',
                                                                       'poller_hash': 'MThlODI5MGJiMjYwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756737-blake-bennetts',
                                         'serial_number': 'UBNT290bb260',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:b2:60',
                                         'temperature': 50.0,
                                         'uptime': '3604806'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1285929769043',
                                                                       'links': [       {       'in_octets': '1285929769043',
                                                                                                'out_octets': '77031716161',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '77031716161',
                                                                       'poller_hash': 'MThlODI5MGJmODA0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2561113',
                                                                                                                        'fiber_length': 82,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.466,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.494}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmODA0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:07:b6:f8:97:5e'],
                                                                       'id': '1',
                                                                       'in_octets': '77031716161',
                                                                       'mac_address': '18:e8:29:0c:f8:04',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1285929769043',
                                                                       'poller_hash': 'MThlODI5MGJmODA0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '26323-brett-wingo',
                                         'serial_number': 'UBNT290bf804',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f8:04',
                                         'temperature': 37.0,
                                         'uptime': '2561157'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '654710786269',
                                                                       'links': [       {       'in_octets': '654710786269',
                                                                                                'out_octets': '55272372563',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '55272372563',
                                                                       'poller_hash': 'MThlODI5MGJmOWMwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3890178',
                                                                                                                        'fiber_length': 407,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.022,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.214}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmOWMwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:48:c3:db'],
                                                                       'id': '1',
                                                                       'in_octets': '55272372563',
                                                                       'mac_address': '18:e8:29:0c:f9:c0',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '654710786269',
                                                                       'poller_hash': 'MThlODI5MGJmOWMwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '21839-greg-turner',
                                         'serial_number': 'UBNT290bf9c0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f9:c0',
                                         'temperature': 40.0,
                                         'uptime': '3890220'},
                                 {       'admin_disabled': False,
                                         'cpu': 0.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '758396543589',
                                                                       'links': [       {       'in_octets': '758396543589',
                                                                                                'out_octets': '140405299525',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '140405299525',
                                                                       'poller_hash': 'MThlODI5ZjU4MDU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3699886',
                                                                                                                        'fiber_length': 775,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.766,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.532}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjU4MDU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:e3:c3:a1'],
                                                                       'id': '1',
                                                                       'in_octets': '140405299525',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '758396543589',
                                                                       'poller_hash': 'MThlODI5ZjU4MDU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Instant',
                                         'name': '22049-Darren Patterson Christian '
                                                 'Academy',
                                         'serial_number': 'UBNT29f58054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:f5:80:54',
                                         'temperature': 82.0,
                                         'uptime': '3699919'},
                                 {       'admin_disabled': False,
                                         'cpu': 50.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '153401865394',
                                                                       'links': [       {       'in_octets': '153401865394',
                                                                                                'out_octets': '13635545316',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '13635545316',
                                                                       'poller_hash': 'MThlODI5ZjViMDcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '389919',
                                                                                                                        'fiber_length': 14,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.52,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.648}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjViMDcycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'name': 'eth2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMw=='},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '68:d7:9a:67:b9:2d'],
                                                                       'id': '4',
                                                                       'in_octets': '276638288894',
                                                                       'name': 'eth3',
                                                                       'oper_up': True,
                                                                       'out_octets': '2564788784954',
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoNA==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 15.0,
                                         'model': 'WiFi',
                                         'name': '10340-carlin-walsh-ufiberwifi',
                                         'serial_number': 'UBNT29f5b072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:f5:b0:72',
                                         'temperature': 57.0,
                                         'uptime': '389959'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '877525143799',
                                                                       'links': [       {       'in_octets': '877525143799',
                                                                                                'out_octets': '79506814602',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '79506814602',
                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496547',
                                                                                                                        'fiber_length': 644,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.054,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.108}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:a9:8a:5f:bc:94'],
                                                                       'id': '1',
                                                                       'in_octets': '79506814602',
                                                                       'mac_address': '74:83:c2:f1:1e:90',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '877525143799',
                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '756289-evan-bartlett-nanog',
                                         'serial_number': 'UBNTc2f01e90',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '74:83:c2:f0:1e:90',
                                         'temperature': 50.0,
                                         'uptime': '8889556'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '343333914855',
                                                                       'links': [       {       'in_octets': '343333914855',
                                                                                                'out_octets': '33624625113',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33624625113',
                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2409532',
                                                                                                                        'fiber_length': 892,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.248,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.73}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:fd:74:1c:bf:7a'],
                                                                       'id': '1',
                                                                       'in_octets': '33624625113',
                                                                       'mac_address': '74:83:c2:f1:b1:a4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '343333914855',
                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756084-anna-toll',
                                         'serial_number': 'UBNTc2f0b1a4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '74:83:c2:f0:b1:a4',
                                         'temperature': 46.0,
                                         'uptime': '2409570'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '26759028333',
                                                                       'links': [       {       'in_octets': '26759028333',
                                                                                                'out_octets': '6190169311',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6190169311',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496546',
                                                                                                                        'fiber_length': 276,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.222,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.822}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:49:bf:9b'],
                                                                       'id': '1',
                                                                       'in_octets': '6190169311',
                                                                       'mac_address': 'b4:fb:e4:ec:4d:58',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26759028333',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '10523-jay-leaver-nanog',
                                         'serial_number': 'UBNTe4eb4d58',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:4d:58',
                                         'temperature': 53.0,
                                         'uptime': '8889544'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '244967364534',
                                                                       'links': [       {       'in_octets': '244967364534',
                                                                                                'out_octets': '16408151466',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '16408151466',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496546',
                                                                                                                        'fiber_length': 299,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.574,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.014}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '34:98:b5:c4:4e:11'],
                                                                       'id': '1',
                                                                       'in_octets': '16408151466',
                                                                       'mac_address': 'b4:fb:e4:ec:4d:62',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '244967364534',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '24017-grace-garret-nanog',
                                         'serial_number': 'UBNTe4eb4d62',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:4d:62',
                                         'temperature': 40.0,
                                         'uptime': '8889525'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '882718479596',
                                                                       'links': [       {       'in_octets': '882718479596',
                                                                                                'out_octets': '30361231639',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '30361231639',
                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496537',
                                                                                                                        'fiber_length': 333,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.172,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.078}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:82:a9:f7'],
                                                                       'id': '1',
                                                                       'in_octets': '30361231639',
                                                                       'mac_address': 'b4:fb:e4:ec:50:73',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '882718479596',
                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '20157-ellen-kelly-nanog',
                                         'serial_number': 'UBNTe4eb5073',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:50:73',
                                         'temperature': 48.0,
                                         'uptime': '8889522'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '548885766037',
                                                                       'links': [       {       'in_octets': '548885766037',
                                                                                                'out_octets': '36518536949',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '36518536949',
                                                                       'poller_hash': 'MThlODI5MGJkNThjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6636377',
                                                                                                                        'fiber_length': 1098,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.872,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.934}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJkNThjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:9a:18:42:bd:d4'],
                                                                       'id': '1',
                                                                       'in_octets': '36518536949',
                                                                       'mac_address': '18:e8:29:0c:d5:8c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '548885766037',
                                                                       'poller_hash': 'MThlODI5MGJkNThjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '23673-luke-urbine-nanog',
                                         'serial_number': 'UBNT290bd58c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:d5:8c',
                                         'temperature': 45.0,
                                         'uptime': '6636417'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '194847602663',
                                                                       'links': [       {       'in_octets': '194847602663',
                                                                                                'out_octets': '11447796092',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11447796092',
                                                                       'poller_hash': 'MThlODI5MGJkNWU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6280693',
                                                                                                                        'fiber_length': 980,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.47,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.772}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJkNWU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c8:7f:54:27:30:80'],
                                                                       'id': '1',
                                                                       'in_octets': '11447796092',
                                                                       'mac_address': '18:e8:29:0c:d5:e4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '194847602663',
                                                                       'poller_hash': 'MThlODI5MGJkNWU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756708-dallas-campbell',
                                         'serial_number': 'UBNT290bd5e4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:d5:e4',
                                         'temperature': 50.0,
                                         'uptime': '6280735'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '554524252919',
                                                                       'links': [       {       'in_octets': '554524252919',
                                                                                                'out_octets': '44346977227',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '44346977227',
                                                                       'poller_hash': 'MThlODI5MGJmNzEwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6654297',
                                                                                                                        'fiber_length': 920,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.01,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.744}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmNzEwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:a9:8a:3a:a4:36'],
                                                                       'id': '1',
                                                                       'in_octets': '44346977227',
                                                                       'mac_address': '18:e8:29:0c:f7:10',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '554524252919',
                                                                       'poller_hash': 'MThlODI5MGJmNzEwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756279-alison-peticolas',
                                         'serial_number': 'UBNT290bf710',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f7:10',
                                         'temperature': 40.0,
                                         'uptime': '6654336'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '276946513313',
                                                                       'links': [       {       'in_octets': '276946513313',
                                                                                                'out_octets': '28361070702',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28361070702',
                                                                       'poller_hash': 'MThlODI5MGJmOWVjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2856206',
                                                                                                                        'fiber_length': 852,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.86,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.06}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmOWVjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:9a:18:90:0c:6f'],
                                                                       'id': '1',
                                                                       'in_octets': '28361070702',
                                                                       'mac_address': '18:e8:29:0c:f9:ec',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '276946513313',
                                                                       'poller_hash': 'MThlODI5MGJmOWVjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756755-michael-blashka',
                                         'serial_number': 'UBNT290bf9ec',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f9:ec',
                                         'temperature': 48.0,
                                         'uptime': '2856244'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_8_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.8.0.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 33,
                'sw_version': '4.8.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 1
        }
        exp_sta_stats = {
                '18:e8:29:f5:6d:15': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:6d:15',
                                             'name': ''},
                '18:e8:29:f5:6d:1c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:6d:1c',
                                             'name': 'Ambulance Test'},
                '68:d7:9a:06:fc:fc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:fc:fc',
                                             'name': 'Hood V2'},
                '70:a7:41:33:1f:bc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:1f:bc',
                                             'name': 'Lauren-McGinnis'},
                '70:a7:41:33:20:a0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:20:a0',
                                             'name': 'CLARK FORK PANTRY'},
                '70:a7:41:33:f6:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:f6:b4',
                                             'name': 'Vicki Woodward'},
                '70:a7:41:33:fd:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:fd:6c',
                                             'name': 'Scott Carlon V2'},
                '70:a7:41:36:53:b0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:53:b0',
                                             'name': 'BNSF railway co'},
                '74:ac:b9:06:ad:78': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ad:78',
                                             'name': 'Joanne Wilson'},
                '74:ac:b9:06:ad:ee': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ad:ee',
                                             'name': 'Adrianna Malley'},
                '74:ac:b9:06:ae:09': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ae:09',
                                             'name': 'Marilyn Anderson'},
                '74:ac:b9:06:ae:16': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ae:16',
                                             'name': 'Taryn Maddox'},
                '74:ac:b9:06:b1:26': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:b1:26',
                                             'name': 'Dalton Bosscher'},
                '78:45:58:06:32:c9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:32:c9',
                                             'name': 'Greg Karraker'},
                '78:45:58:06:32:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:32:cd',
                                             'name': 'Donna Decker'},
                '78:45:58:06:34:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:34:cd',
                                             'name': 'Haley Poppleton'},
                '78:45:58:06:34:d3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:34:d3',
                                             'name': 'Railroad Ken Hays'},
                'ac:8b:a9:e5:3b:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e5:3b:6c',
                                             'name': 'Kim Derr ?'},
                'd0:21:f9:06:3f:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:06:3f:90',
                                             'name': 'Maranda Painter'},
                'fc:ec:da:eb:7a:5d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:7a:5d',
                                             'name': 'Triston-Miller'},
                'fc:ec:da:eb:9a:c4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9a:c4',
                                             'name': 'Dave Farley'},
                'fc:ec:da:eb:9a:c9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9a:c9',
                                             'name': 'Rosemary O’bryan'},
                'fc:ec:da:eb:9c:4f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9c:4f',
                                             'name': 'Amber Marcum'},
                'fc:ec:da:eb:9d:f3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9d:f3',
                                             'name': 'Cenex'},
                'fc:ec:da:eb:b6:35': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:35',
                                             'name': 'Heritage Shores Realty T '
                                                     'Stevens'},
                'fc:ec:da:eb:b6:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:49',
                                             'name': 'Michael Willey'},
                'fc:ec:da:eb:b6:67': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:67',
                                             'name': 'Aspen Personal Care'},
                'fc:ec:da:eb:b7:cf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b7:cf',
                                             'name': 'Shari Jones'},
                'fc:ec:da:eb:b7:fc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b7:fc',
                                             'name': 'Robert-Moore'},
                'fc:ec:da:eb:b8:9c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b8:9c',
                                             'name': 'Kaniksu Office'},
                'fc:ec:da:eb:b9:3c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:3c',
                                             'name': 'Bill-Warren'},
                'fc:ec:da:eb:b9:64': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:64',
                                             'name': 'Sherman Henderson'},
                'fc:ec:da:eb:b9:73': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:73',
                                             'name': 'Tim Knapp'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4c2ZwMWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp2',
                                                              'in_octets': '3286116448449',
                                                              'in_ucast_pkts': '2507410340',
                                                              'manufacturer': 'OEM',
                                                              'model': 'SFP-H10GB-CU1M',
                                                              'name': 'SFP+ 2',
                                                              'oper_up': True,
                                                              'out_octets': '210311843106',
                                                              'out_ucast_pkts': '753913677',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4c2ZwMmludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '55525339594',
                                                              'in_ucast_pkts': '177484870',
                                                              'links': [       {       'in_octets': '12781775655',
                                                                                       'out_octets': '135185803066',
                                                                                       'poller_hash': 'NzBhNzQxMzMxZmJjcGVlcmludGY='},
                                                                               {       'in_octets': '9002163043',
                                                                                       'out_octets': '99602809539',
                                                                                       'poller_hash': 'NzBhNzQxMzNmNmI0cGVlcmludGY='},
                                                                               {       'in_octets': '20751875520',
                                                                                       'out_octets': '196539817888',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZGVlcGVlcmludGY='},
                                                                               {       'in_octets': '8054214604',
                                                                                       'out_octets': '89860629017',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZTA5cGVlcmludGY='},
                                                                               {       'in_octets': '4935310772',
                                                                                       'out_octets': '155185915656',
                                                                                       'poller_hash': 'ZDAyMWY5MDYzZjkwcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '678048760779',
                                                              'out_ucast_pkts': '537866326',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY=',
                                                              'pons': [       {       'description': 'Blue',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '311068',
                                                                                                               'fiber_length': 544,
                                                                                                               'poller_hash': 'NzBhNzQxMzMxZmJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 651,
                                                                                                               'poller_hash': 'NzBhNzQxMzNmNmI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 477,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZGVlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 472,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZTA5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 472,
                                                                                                               'poller_hash': 'ZDAyMWY5MDYzZjkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '38336469612',
                                                              'in_ucast_pkts': '157047484',
                                                              'links': [       {       'in_octets': '2151469452',
                                                                                       'out_octets': '116831324957',
                                                                                       'poller_hash': 'NzBhNzQxMzNmZDZjcGVlcmludGY='},
                                                                               {       'in_octets': '7175125137',
                                                                                       'out_octets': '10321834793',
                                                                                       'poller_hash': 'NzRhY2I5MDZiMTI2cGVlcmludGY='},
                                                                               {       'in_octets': '2410307241',
                                                                                       'out_octets': '62876159271',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM0cGVlcmludGY='},
                                                                               {       'in_octets': '2058927817',
                                                                                       'out_octets': '39555315352',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM5cGVlcmludGY='},
                                                                               {       'in_octets': '11771178096',
                                                                                       'out_octets': '490512272621',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiOTY0cGVlcmludGY='},
                                                                               {       'in_octets': '12769461869',
                                                                                       'out_octets': '39767935958',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiOTczcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '761515140664',
                                                              'out_ucast_pkts': '576017036',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY=',
                                                              'pons': [       {       'description': 'Orange ',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '311059',
                                                                                                               'fiber_length': 478,
                                                                                                               'poller_hash': 'NzBhNzQxMzNmZDZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 406,
                                                                                                               'poller_hash': 'NzRhY2I5MDZiMTI2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 504,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '310259',
                                                                                                               'fiber_length': 529,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 560,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311059',
                                                                                                               'fiber_length': 425,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTczcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '21453110231',
                                                              'in_ucast_pkts': '72971103',
                                                              'links': [       {       'in_octets': '18736743395',
                                                                                       'out_octets': '210481783108',
                                                                                       'poller_hash': 'Nzg0NTU4MDYzNGNkcGVlcmludGY='},
                                                                               {       'in_octets': '2716366730',
    