import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):

    def test_ubnt_airfiber_airfiber_AF60_LR_v2_6_0_01(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60-LR.v2.6.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60-LR',
                'rf_chan_width': 2160,
                'rf_freq': 69120,
                'rf_tx_power': 0,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 9
        }
        exp_sta_stats = {
                '24:5a:4c:de:c5:cc': {       'dev_macs': {       '00:04:56:45:8e:77',
                                                                 '02:0c:05:00:e1:18',
                                                                 '08:55:31:20:02:b2',
                                                                 '08:55:31:20:31:70',
                                                                 '08:55:31:c8:9d:96',
                                                                 '08:55:31:c8:e5:7b',
                                                                 '08:55:31:c8:e5:d2',
                                                                 '08:55:31:c8:e6:53',
                                                                 '08:55:31:cb:81:97',
                                                                 '10:0c:6b:32:f4:cd',
                                                                 '10:da:43:dd:17:29',
                                                                 '14:59:c0:c7:df:08',
                                                                 '18:e8:29:80:52:55',
                                                                 '18:e8:29:80:55:50',
                                                                 '24:52:6a:e5:eb:23',
                                                                 '24:52:6a:f0:c4:f5',
                                                                 '24:52:6a:f0:c5:2b',
                                                                 '24:5a:4c:40:a4:1e',
                                                                 '24:5a:4c:46:02:76',
                                                                 '24:5a:4c:b0:4e:07',
                                                                 '24:5a:4c:b0:4e:8b',
                                                                 '24:5a:4c:de:ab:e6',
                                                                 '24:5a:4c:de:c5:e3',
                                                                 '24:5a:4c:de:c6:26',
                                                                 '24:5a:4c:e4:df:df',
                                                                 '24:5a:4c:e4:e6:39',
                                                                 '24:5a:4c:ec:74:4b',
                                                                 '24:5a:4c:ec:98:99',
                                                                 '24:5a:4c:ee:bf:ce',
                                                                 '24:5a:4c:f0:83:5d',
                                                                 '24:5a:4c:f0:86:eb',
                                                                 '24:5a:4c:f0:87:89',
                                                                 '2c:c8:1b:ae:78:55',
                                                                 '2c:c8:1b:ae:78:56',
                                                                 '2c:c8:1b:b0:20:c7',
                                                                 '2c:c8:1b:b0:20:c9',
                                                                 '3c:7d:0a:0e:ec:d1',
                                                                 '44:07:0b:26:c4:7e',
                                                                 '48:8f:5a:82:ca:a2',
                                                                 '48:8f:5a:d7:f0:85',
                                                                 '58:c1:7a:70:d2:12',
                                                                 '6c:1c:71:5c:41:22',
                                                                 '74:83:c2:e8:16:89',
                                                                 '74:a7:ea:69:ce:e9',
                                                                 '74:ac:b9:78:72:ae',
                                                                 '74:ac:b9:84:ae:56',
                                                                 '74:ac:b9:84:ae:a5',
                                                                 '84:d3:43:05:aa:7d',
                                                                 '84:d3:43:43:e0:8b',
                                                                 '84:d3:43:43:e8:33',
                                                                 '8a:50:83:e9:0c:f1',
                                                                 '9c:c9:eb:6d:8f:96',
                                                                 'b4:fb:e4:68:1b:b2',
                                                                 'b4:fb:e4:b8:e1:9c',
                                                                 'c0:06:c3:2f:7d:b5',
                                                                 'c0:4a:00:6d:19:c1',
                                                                 'c8:d7:19:a7:7c:d0',
                                                                 'd8:ec:5e:b4:27:05',
                                                                 'e0:63:da:0f:73:29',
                                                                 'e0:63:da:d6:4e:78',
                                                                 'e4:f4:c6:15:9e:b7',
                                                                 'e8:9f:80:be:1a:36',
                                                                 'e8:da:00:07:00:ef',
                                                                 'e8:da:00:07:0a:5b',
                                                                 'e8:da:00:07:14:81',
                                                                 'e8:da:00:07:27:53',
                                                                 'e8:da:00:07:41:75',
                                                                 'e8:da:00:0c:41:0d',
                                                                 'ec:13:b2:e2:44:68',
                                                                 'f4:92:bf:2f:60:f5',
                                                                 'f4:92:bf:3c:3a:98',
                                                                 'f4:92:bf:be:70:2d',
                                                                 'f4:92:bf:be:70:ca',
                                                                 'f4:92:bf:be:70:fe',
                                                                 'f4:92:bf:d2:dc:6e',
                                                                 'f4:92:bf:d2:dc:fb',
                                                                 'f4:92:bf:d6:bb:f4',
                                                                 'f4:92:bf:d6:c0:ad',
                                                                 'f4:92:bf:d6:c0:ec',
                                                                 'f4:92:bf:d6:c1:28',
                                                                 'f4:92:bf:d8:59:3d',
                                                                 'f4:92:bf:e0:0b:36',
                                                                 'f4:92:bf:e0:0c:63'},
                                             'ip_address': '100.64.29.84',
                                             'mac_address': '24:5a:4c:de:c5:cc',
                                             'name': 'BB-BBN-SLAVE'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.497512,
                                'elevation': 631.7,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_octets': '5232756045744',
                                                              'in_ucast_pkts': '4031928374',
                                                              'mac_address': '24:5a:4c:df:c2:d5',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '509400038979',
                                                              'out_ucast_pkts': '1550136494',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '508879723400',
                                                              'in_ucast_pkts': '1548995212',
                                                              'links': [       {       'in_octets': '508879723518',
                                                                                       'in_ucast_pkts': '1548995212',
                                                                                       'mac_address': '24:5a:4c:de:c5:cc',
                                                                                       'out_octets': '5232614337914',
                                                                                       'out_ucast_pkts': '4031428343'}],
                                                              'mac_address': '24:5a:4c:de:c2:d5',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_octets': '5232614336696',
                                                              'out_ucast_pkts': '4031428343',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 69120,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1364749',
                                                                                                                                            'distance': 850,
                                                                                                                                            'mac_address': '24:5a:4c:de:c5:cc',
                                                                                                                                            'noise_floor': -59.0,
                                                                                                                                            'rssi': -40.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KAN-BB-BBN'}],
                                                              'speed': '0'}],
                                'latitude': 48.237497,
                                'longitude': -116.444356,
                                'manufacturer': 'Ubiquiti',
                                'mem': 37.130196,
                                'model': 'AF60-LR',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:de:c2:d5',
                                'temperature': 28.0,
                                'uptime': '1365018'},
                'peers': [       {       'cpu': 0.4962,
                                         'elevation': 737.6,
                                         'gps_sats_tracked': 5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '5232614337914',
                                                                       'in_ucast_pkts': '4031428343',
                                                                       'links': [       {       'in_octets': '5232614337914',
                                                                                                'in_ucast_pkts': '4031428343',
                                                                                                'mac_address': '24:5a:4c:de:c2:d5',
                                                                                                'out_octets': '508879723518',
                                                                                                'out_ucast_pkts': '1548995212'}],
                                                                       'mac_address': '24:5a:4c:de:c5:cc',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '508879723518',
                                                                       'out_ucast_pkts': '1548995212',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 69120,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1951000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1364749',
                                                                                                                                                     'distance': 850,
                                                                                                                                                     'mac_address': '24:5a:4c:de:c2:d5',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -43.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '1951000000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '1951000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BB-BBN'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:04:56:45:8e:77',
                                                                                                        '02:0c:05:00:e1:18',
                                                                                                        '08:55:31:20:02:b2',
                                                                                                        '08:55:31:20:31:70',
                                                                                                        '08:55:31:c8:9d:96',
                                                                                                        '08:55:31:c8:e5:7b',
                                                                                                        '08:55:31:c8:e5:d2',
                                                                                                        '08:55:31:c8:e6:53',
                                                                                                        '08:55:31:cb:81:97',
                                                                                                        '10:0c:6b:32:f4:cd',
                                                                                                        '10:da:43:dd:17:29',
                                                                                                        '14:59:c0:c7:df:08',
                                                                                                        '18:e8:29:80:52:55',
                                                                                                        '18:e8:29:80:55:50',
                                                                                                        '24:52:6a:e5:eb:23',
                                                                                                        '24:52:6a:f0:c4:f5',
                                                                                                        '24:52:6a:f0:c5:2b',
                                                                                                        '24:5a:4c:40:a4:1e',
                                                                                                        '24:5a:4c:46:02:76',
                                                                                                        '24:5a:4c:b0:4e:07',
                                                                                                        '24:5a:4c:b0:4e:8b',
                                                                                                        '24:5a:4c:de:ab:e6',
                                                                                                        '24:5a:4c:de:c5:e3',
                                                                                                        '24:5a:4c:de:c6:26',
                                                                                                        '24:5a:4c:e4:df:df',
                                                                                                        '24:5a:4c:e4:e6:39',
                                                                                                        '24:5a:4c:ec:74:4b',
                                                                                                        '24:5a:4c:ec:98:99',
                                                                                                        '24:5a:4c:ee:bf:ce',
                                                                                                        '24:5a:4c:f0:83:5d',
                                                                                                        '24:5a:4c:f0:86:eb',
                                                                                                        '24:5a:4c:f0:87:89',
                                                                                                        '2c:c8:1b:ae:78:55',
                                                                                                        '2c:c8:1b:ae:78:56',
                                                                                                        '2c:c8:1b:b0:20:c7',
                                                                                                        '2c:c8:1b:b0:20:c9',
                                                                                                        '3c:7d:0a:0e:ec:d1',
                                                                                                        '44:07:0b:26:c4:7e',
                                                                                                        '48:8f:5a:82:ca:a2',
                                                                                                        '48:8f:5a:d7:f0:85',
                                                                                                        '58:c1:7a:70:d2:12',
                                                                                                        '6c:1c:71:5c:41:22',
                                                                                                        '74:83:c2:e8:16:89',
                                                                                                        '74:a7:ea:69:ce:e9',
                                                                                                        '74:ac:b9:78:72:ae',
                                                                                                        '74:ac:b9:84:ae:56',
                                                                                                        '74:ac:b9:84:ae:a5',
                                                                                                        '84:d3:43:05:aa:7d',
                                                                                                        '84:d3:43:43:e0:8b',
                                                                                                        '84:d3:43:43:e8:33',
                                                                                                        '8a:50:83:e9:0c:f1',
                                                                                                        '9c:c9:eb:6d:8f:96',
                                                                                                        'b4:fb:e4:68:1b:b2',
                                                                                                        'b4:fb:e4:b8:e1:9c',
                                                                                                        'c0:06:c3:2f:7d:b5',
                                                                                                        'c0:4a:00:6d:19:c1',
                                                                                                        'c8:d7:19:a7:7c:d0',
                                                                                                        'd8:ec:5e:b4:27:05',
                                                                                                        'e0:63:da:0f:73:29',
                                                                                                        'e0:63:da:d6:4e:78',
                                                                                                        'e4:f4:c6:15:9e:b7',
                                                                                                        'e8:9f:80:be:1a:36',
                                                                                                        'e8:da:00:07:00:ef',
                                                                                                        'e8:da:00:07:0a:5b',
                                                                                                        'e8:da:00:07:14:81',
                                                                                                        'e8:da:00:07:27:53',
                                                                                                        'e8:da:00:07:41:75',
                                                                                                        'e8:da:00:0c:41:0d',
                                                                                                        'ec:13:b2:e2:44:68',
                                                                                                        'f4:92:bf:2f:60:f5',
                                                                                                        'f4:92:bf:3c:3a:98',
                                                                                                        'f4:92:bf:be:70:2d',
                                                                                                        'f4:92:bf:be:70:ca',
                                                                                                        'f4:92:bf:be:70:fe',
                                                                                                        'f4:92:bf:d2:dc:6e',
                                                                                                        'f4:92:bf:d2:dc:fb',
                                                                                                        'f4:92:bf:d6:bb:f4',
                                                                                                        'f4:92:bf:d6:c0:ad',
                                                                                                        'f4:92:bf:d6:c0:ec',
                                                                                                        'f4:92:bf:d6:c1:28',
                                                                                                        'f4:92:bf:d8:59:3d',
                                                                                                        'f4:92:bf:e0:0b:36',
                                                                                                        'f4:92:bf:e0:0c:63'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '508879723518',
                                                                       'in_ucast_pkts': '1548995212',
                                                                       'mac_address': '24:5a:4c:df:c5:cc',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5232614337914',
                                                                       'out_ucast_pkts': '4031428343',
                                                                       'speed': '1000000000'}],
                                         'latitude': 48.238924,
                                         'longitude': -116.433185,
                                         'management_ip': '100.64.29.84',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.643044,
                                         'model': 'airFiber 60 LR',
                                         'name': 'BB-BBN-SLAVE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:de:c5:cc',
                                         'temperature': 26.0,
                                         'uptime': '4537490'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_LR_v2_6_0_02(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60-LR.v2.6.0.02")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60-LR',
                'rf_chan_width': 2160,
                'rf_freq': 65880,
                'rf_tx_power': 0,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 11
        }
        exp_sta_stats = {
                '24:5a:4c:de:c6:26': {       'dev_macs': {       '00:04:56:45:8e:77',
                                                                 '10:0c:6b:32:f4:cd',
                                                                 '14:59:c0:c7:df:08',
                                                                 '18:e8:29:80:52:55',
                                                                 '24:52:6a:e5:eb:23',
                                                                 '24:52:6a:f0:c4:f5',
                                                                 '24:52:6a:f0:c5:2b',
                                                                 '24:5a:4c:46:02:76',
                                                                 '24:5a:4c:b0:4e:07',
                                                                 '24:5a:4c:b0:4e:8b',
                                                                 '24:5a:4c:de:ab:e6',
                                                                 '24:5a:4c:e4:df:df',
                                                                 '24:5a:4c:ec:74:4b',
                                                                 '24:5a:4c:ec:98:99',
                                                                 '24:5a:4c:f0:83:5d',
                                                                 '24:5a:4c:f0:87:89',
                                                                 '2c:c8:1b:ae:78:55',
                                                                 '2c:c8:1b:ae:78:56',
                                                                 '2c:c8:1b:b0:20:c7',
                                                                 '2c:c8:1b:b0:20:c9',
                                                                 '3c:7d:0a:0e:ec:d1',
                                                                 '44:07:0b:26:c4:7e',
                                                                 '58:c1:7a:70:d2:11',
                                                                 '58:c1:7a:70:d2:12',
                                                                 '6c:1c:71:5c:41:22',
                                                                 '74:83:c2:e8:16:89',
                                                                 '74:a7:ea:69:ce:e9',
                                                                 '84:d3:43:43:e0:8b',
                                                                 '9c:c9:eb:6d:8f:96',
                                                                 'c0:4a:00:6d:19:c1',
                                                                 'c8:d7:19:a7:7c:d0',
                                                                 'd8:ec:5e:b4:27:05',
                                                                 'e0:63:da:0f:73:29',
                                                                 'e8:da:00:07:00:ef',
                                                                 'e8:da:00:07:14:81',
                                                                 'e8:da:00:07:27:53',
                                                                 'e8:da:00:0c:41:0d',
                                                                 'f4:92:bf:2f:60:f5',
                                                                 'f4:92:bf:be:70:2d',
                                                                 'f4:92:bf:be:70:fe',
                                                                 'f4:92:bf:d6:c1:28'},
                                             'ip_address': '100.64.28.252',
                                             'mac_address': '24:5a:4c:de:c6:26',
                                             'name': 'BBN-MOON-SLAVE'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 3.241895,
                                'elevation': 741.5,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '4856943956715',
                                                              'in_ucast_pkts': '4131533945',
                                                              'mac_address': '24:5a:4c:df:c5:e3',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '687812553823',
                                                              'out_ucast_pkts': '1639672460',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '686122131355',
                                                              'in_ucast_pkts': '1635778721',
                                                              'links': [       {       'in_octets': '296964937021',
                                                                                       'in_ucast_pkts': '710579732',
                                                                                       'mac_address': '24:5a:4c:de:c6:26',
                                                                                       'out_octets': '2121388422002',
                                                                                       'out_ucast_pkts': '1737714684'}],
                                                              'mac_address': '24:5a:4c:de:c5:e3',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '130055',
                                                              'out_errors': '0',
                                                              'out_octets': '4852249994495',
                                                              'out_ucast_pkts': '4069969091',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 65880,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1194409',
                                                                                                                                            'distance': 3820,
                                                                                                                                            'mac_address': '24:5a:4c:de:c6:26',
                                                                                                                                            'noise_floor': -71.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KAN-BBN-MOON'}],
                                                              'speed': '0'}],
                                'latitude': 48.238939,
                                'longitude': -116.433224,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.907322,
                                'model': 'AF60-LR',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:de:c5:e3',
                                'temperature': 18.0,
                                'uptime': '4537454'},
                'peers': [       {       'cpu': 0.995,
                                         'elevation': 761.9,
                                         'gps_sats_tracked': 7,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '2121388422002',
                                                                       'in_ucast_pkts': '1737714684',
                                                                       'links': [       {       'in_octets': '2121388422002',
                                                                                                'in_ucast_pkts': '1737714684',
                                                                                                'mac_address': '24:5a:4c:de:c5:e3',
                                                                                                'out_octets': '296964937021',
                                                                                                'out_ucast_pkts': '710579732'}],
                                                                       'mac_address': '24:5a:4c:de:c6:26',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '296964937021',
                                                                       'out_ucast_pkts': '710579732',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 65880,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1951000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1194409',
                                                                                                                                                     'distance': 3820,
                                                                                                                                                     'mac_address': '24:5a:4c:de:c5:e3',
                                                                                                                                                     'noise_floor': -72.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1951000000'}],
                                                                                                                            'noise_floor': -72.0}],
                                                                                                 'tx_link_rate': '1951000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BBN-MOON'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:04:56:45:8e:77',
                                                                                                        '10:0c:6b:32:f4:cd',
                                                                                                        '14:59:c0:c7:df:08',
                                                                                                        '18:e8:29:80:52:55',
                                                                                                        '24:52:6a:e5:eb:23',
                                                                                                        '24:52:6a:f0:c4:f5',
                                                                                                        '24:52:6a:f0:c5:2b',
                                                                                                        '24:5a:4c:46:02:76',
                                                                                                        '24:5a:4c:b0:4e:07',
                                                                                                        '24:5a:4c:b0:4e:8b',
                                                                                                        '24:5a:4c:de:ab:e6',
                                                                                                        '24:5a:4c:e4:df:df',
                                                                                                        '24:5a:4c:ec:74:4b',
                                                                                                        '24:5a:4c:ec:98:99',
                                                                                                        '24:5a:4c:f0:83:5d',
                                                                                                        '24:5a:4c:f0:87:89',
                                                                                                        '2c:c8:1b:ae:78:55',
                                                                                                        '2c:c8:1b:ae:78:56',
                                                                                                        '2c:c8:1b:b0:20:c7',
                                                                                                        '2c:c8:1b:b0:20:c9',
                                                                                                        '3c:7d:0a:0e:ec:d1',
                                                                                                        '44:07:0b:26:c4:7e',
                                                                                                        '58:c1:7a:70:d2:11',
                                                                                                        '58:c1:7a:70:d2:12',
                                                                                                        '6c:1c:71:5c:41:22',
                                                                                                        '74:83:c2:e8:16:89',
                                                                                                        '74:a7:ea:69:ce:e9',
                                                                                                        '84:d3:43:43:e0:8b',
                                                                                                        '9c:c9:eb:6d:8f:96',
                                                                                                        'c0:4a:00:6d:19:c1',
                                                                                                        'c8:d7:19:a7:7c:d0',
                                                                                                        'd8:ec:5e:b4:27:05',
                                                                                                        'e0:63:da:0f:73:29',
                                                                                                        'e8:da:00:07:00:ef',
                                                                                                        'e8:da:00:07:14:81',
                                                                                                        'e8:da:00:07:27:53',
                                                                                                        'e8:da:00:0c:41:0d',
                                                                                                        'f4:92:bf:2f:60:f5',
                                                                                                        'f4:92:bf:be:70:2d',
                                                                                                        'f4:92:bf:be:70:fe',
                                                                                                        'f4:92:bf:d6:c1:28'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '296964937021',
                                                                       'in_ucast_pkts': '710579732',
                                                                       'mac_address': '24:5a:4c:df:c6:26',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2121388422002',
                                                                       'out_ucast_pkts': '1737714684',
                                                                       'speed': '1000000000'}],
                                         'latitude': 48.254446,
                                         'longitude': -116.479074,
                                         'management_ip': '100.64.28.252',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 40.65529,
                                         'model': 'airFiber 60 LR',
                                         'name': 'BBN-MOON-SLAVE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:de:c6:26',
                                         'temperature': 27.0,
                                         'uptime': '1365015'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_LR_v2_6_0_03(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60-LR.v2.6.0.03")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60-LR',
                'rf_chan_width': 2160,
                'rf_freq': 69120,
                'rf_tx_power': 0,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 12
        }
        exp_sta_stats = {
                '24:5a:4c:f2:0a:3a': {       'dev_macs': {       '00:23:8a:a8:d5:f2',
                                                                 '00:23:8a:a8:d5:ff',
                                                                 '0c:8d:db:af:24:e5',
                                                                 '18:fd:74:17:3f:a0',
                                                                 '5c:e2:8c:5e:67:0e'},
                                             'ip_address': '10.6.9.71',
                                             'mac_address': '24:5a:4c:f2:0a:3a',
                                             'name': 'AF-Ramada_Plaza-WLT'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.992556,
                                'elevation': 192.7,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_octets': '713185749129',
                                                              'in_ucast_pkts': '566777627',
                                                              'mac_address': '24:5a:4c:f3:05:88',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '84356868736',
                                                              'out_ucast_pkts': '248365609',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '83989270159',
                                                              'in_ucast_pkts': '247738089',
                                                              'links': [       {       'in_octets': '80675795966',
                                                                                       'in_ucast_pkts': '244262613',
                                                                                       'mac_address': '24:5a:4c:f2:0a:3a',
                                                                                       'out_octets': '709805977258',
                                                                                       'out_ucast_pkts': '559835617'}],
                                                              'mac_address': '24:5a:4c:f2:05:88',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '4710',
                                                              'out_errors': '0',
                                                              'out_octets': '712978342520',
                                                              'out_ucast_pkts': '565163050',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 69120,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '500556',
                                                                                                                                            'distance': 2165,
                                                                                                                                            'mac_address': '24:5a:4c:f2:0a:3a',
                                                                                                                                            'noise_floor': -74.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 15.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Telegia-Ramada-P2P'}],
                                                              'speed': '0'}],
                                'latitude': 39.610632,
                                'longitude': -77.781623,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.031124,
                                'model': 'AF60-LR',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:f2:05:88',
                                'temperature': 40.0,
                                'uptime': '940340'},
                'peers': [       {       'cpu': 1.4925,
                                         'elevation': 191.9,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '709805977258',
                                                                       'in_ucast_pkts': '559835617',
                                                                       'links': [       {       'in_octets': '709805977258',
                                                                                                'in_ucast_pkts': '559835617',
                                                                                                'mac_address': '24:5a:4c:f2:05:88',
                                                                                                'out_octets': '80675795966',
                                                                                                'out_ucast_pkts': '244262613'}],
                                                                       'mac_address': '24:5a:4c:f2:0a:3a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '80675795966',
                                                                       'out_ucast_pkts': '244262613',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 69120,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1951000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '500556',
                                                                                                                                                     'distance': 2165,
                                                                                                                                                     'mac_address': '24:5a:4c:f2:05:88',
                                                                                                                                                     'noise_floor': -75.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'snr': 15.0,
                                                                                                                                                     'tx_link_rate': '1951000000'}],
                                                                                                                            'noise_floor': -75.0}],
                                                                                                 'tx_link_rate': '1951000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Telegia-Ramada-P2P'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:23:8a:a8:d5:f2',
                                                                                                        '00:23:8a:a8:d5:ff',
                                                                                                        '0c:8d:db:af:24:e5',
                                                                                                        '18:fd:74:17:3f:a0',
                                                                                                        '5c:e2:8c:5e:67:0e'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '80675795966',
                                                                       'in_ucast_pkts': '244262613',
                                                                       'mac_address': '24:5a:4c:f3:0a:3a',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '709805977258',
                                                                       'out_ucast_pkts': '559835617',
                                                                       'speed': '1000000000'}],
                                         'latitude': 39.628067,
                                         'longitude': -77.770466,
                                         'management_ip': '10.6.9.71',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.505386,
                                         'model': 'airFiber 60 LR',
                                         'name': 'AF-Ramada_Plaza-WLT',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:f2:0a:3a',
                                         'temperature': 53.0,
                                         'uptime': '940407'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_LR_v2_6_0_04(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60-LR.v2.6.0.04")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60-LR',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': 0,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 6
        }
        exp_sta_stats = {
                '24:5a:4c:3e:e4:02': {       'dev_macs': {       '10:05:ca:9a:c7:02',
                                                                 '10:05:ca:9a:c7:3f'},
                                             'ip_address': '10.6.9.13',
                                             'mac_address': '24:5a:4c:3e:e4:02',
                                             'name': 'AF-WLT-HST'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.249377,
                                'elevation': 192.9,
                                'gps_sats_tracked': 6,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '161847595573',
                                                              'in_ucast_pkts': '448495392',
                                                              'mac_address': '24:5a:4c:3f:e4:c1',
                                                              'mtu': 2000,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '876106259134',
                                                              'out_ucast_pkts': '709038442',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '872607445122',
                                                              'in_ucast_pkts': '702718246',
                                                              'links': [       {       'in_octets': '36049932',
                                                                                       'in_ucast_pkts': '383454',
                                                                                       'mac_address': '24:5a:4c:3e:e4:02',
                                                                                       'out_octets': '30693506',
                                                                                       'out_ucast_pkts': '373246'}],
                                                              'mac_address': '24:5a:4c:3e:e4:c1',
                                                              'mtu': 2000,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '16886',
                                                              'out_errors': '0',
                                                              'out_octets': '160061271692',
                                                              'out_ucast_pkts': '436086134',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '494479',
                                                                                                                                            'distance': 3352,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e4:02',
                                                                                                                                            'noise_floor': -77.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Telegia-HST-WLT'}],
                                                              'speed': '0'}],
                                'latitude': 39.612203,
                                'longitude': -77.74279,
                                'manufacturer': 'Ubiquiti',
                                'mem': 36.759754,
                                'model': 'AF60-LR',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:3e:e4:c1',
                                'temperature': 34.0,
                                'uptime': '8124875'},
                'peers': [       {       'cpu': 0.4962,
                                         'elevation': 190.4,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '30693506',
                                                                       'in_ucast_pkts': '373246',
                                                                       'links': [       {       'in_octets': '30693506',
                                                                                                'in_ucast_pkts': '373246',
                                                                                                'mac_address': '24:5a:4c:3e:e4:c1',
                                                                                                'out_octets': '36049932',
                                                                                                'out_ucast_pkts': '383454'}],
                                                                       'mac_address': '24:5a:4c:3e:e4:02',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36049932',
                                                                       'out_ucast_pkts': '383454',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 64800,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1951000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '494479',
                                                                                                                                                     'distance': 3352,
                                                                                                                                                     'mac_address': '24:5a:4c:3e:e4:c1',
                                                                                                                                                     'noise_floor': -76.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'snr': 14.0,
                                                                                                                                                     'tx_link_rate': '1951000000'}],
                                                                                                                            'noise_floor': -76.0}],
                                                                                                 'tx_link_rate': '1951000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Telegia-HST-WLT'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:05:ca:9a:c7:02',
                                                                                                        '10:05:ca:9a:c7:3f'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '36049932',
                                                                       'in_ucast_pkts': '383454',
                                                                       'mac_address': '24:5a:4c:3f:e4:02',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '30693506',
                                                                       'out_ucast_pkts': '373246',
                                                                       'speed': '1000000000'}],
                                         'latitude': 39.610628,
                                         'longitude': -77.781609,
                                         'management_ip': '10.6.9.13',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.9807,
                                         'model': 'airFiber 60 LR',
                                         'name': 'AF-WLT-HST',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:3e:e4:02',
                                         'temperature': 34.0,
                                         'uptime': '10200260'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_LR_v2_6_0_05(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60-LR.v2.6.0.05")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60-LR',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 0,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 12
        }
        exp_sta_stats = {
                '24:5a:4c:de:c3:bb': {       'dev_macs': {       'e0:2f:6d:91:21:83',
                                                                 'e0:2f:6d:91:21:bf',
                                                                 'e0:63:da:d8:4e:e8'},
                                             'ip_address': '10.6.13.14',
                                             'mac_address': '24:5a:4c:de:c3:bb',
                                             'name': 'AF-HST-ALX'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'elevation': 208.9,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '3',
                                                              'in_errors': '0',
                                                              'in_octets': '65356220171',
                                                              'in_ucast_pkts': '271015022',
                                                              'mac_address': '24:5a:4c:df:c3:bc',
                                                              'mtu': 2000,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '606161571947',
                                                              'out_ucast_pkts': '462734511',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '602251596331',
                                                              'in_ucast_pkts': '455771087',
                                                              'links': [       {       'in_octets': '32380637',
                                                                                       'in_ucast_pkts': '355973',
                                                                                       'mac_address': '24:5a:4c:de:c3:bb',
                                                                                       'out_octets': '30596453',
                                                                                       'out_ucast_pkts': '350974'}],
                                                              'mac_address': '24:5a:4c:de:c3:bc',
                                                              'mtu': 2000,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '134550',
                                                              'out_errors': '0',
                                                              'out_octets': '63365265214',
                                                              'out_ucast_pkts': '257336694',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 68040,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '500090',
                                                                                                                                            'distance': 3862,
                                                                                                                                            'mac_address': '24:5a:4c:de:c3:bb',
                                                                                                                                            'noise_floor': -77.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Telegia-ALX-HST'}],
                                                              'speed': '0'}],
                                'latitude': 39.641697,
                                'longitude': -77.71999,
                                'manufacturer': 'Ubiquiti',
                                'mem': 37.683315,
                                'model': 'AF60-LR',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:de:c3:bc',
                                'temperature': 33.0,
                                'uptime': '9422698'},
                'peers': [       {       'cpu': 0.4962,
                                         'elevation': 203.5,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '30596453',
                                                                       'in_ucast_pkts': '350974',
                                                                       'links': [       {       'in_octets': '30596453',
                                                                                                'in_ucast_pkts': '350974',
                                                                                                'mac_address': '24:5a:4c:de:c3:bc',
                                                                                                'out_octets': '32380637',
                                                                                                'out_ucast_pkts': '355973'}],
                                                                       'mac_address': '24:5a:4c:de:c3:bb',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '32380637',
                                                                       'out_ucast_pkts': '355973',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1951000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '500090',
                                                                                                                                                     'distance': 3862,
                                                                                                                                                     'mac_address': '24:5a:4c:de:c3:bc',
                                                                                                                                                     'noise_floor': -78.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '1951000000'}],
                                                                                                                            'noise_floor': -78.0}],
                                                                                                 'tx_link_rate': '1951000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Telegia-ALX-HST'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:2f:6d:91:21:83',
                                                                                                        'e0:2f:6d:91:21:bf',
                                                                                                        'e0:63:da:d8:4e:e8'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '32380637',
                                                                       'in_ucast_pkts': '355973',
                                                                       'mac_address': '24:5a:4c:df:c3:bb',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '30596453',
                                                                       'out_ucast_pkts': '350974',
                                                                       'speed': '1000000000'}],
                                         'latitude': 39.611682,
                                         'longitude': -77.742515,
                                         'management_ip': '10.6.13.14',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.659637,
                                         'model': 'airFiber 60 LR',
                                         'name': 'AF-HST-ALX',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:de:c3:bb',
                                         'temperature': 37.0,
                                         'uptime': '8124936'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_v2_6_0_01(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60.v2.6.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': None,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 8
        }
        exp_sta_stats = {
                'e0:63:da:fc:58:ea': {       'dev_macs': set(),
                                             'ip_address': '10.15.16.202',
                                             'mac_address': 'e0:63:da:fc:58:ea',
                                             'name': 'airFiber 60'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 3.0,
                                'elevation': 211.2,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 8,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '131762',
                                                              'in_octets': '3995240069',
                                                              'in_ucast_pkts': '75296083',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '8441103590',
                                                                                       'mac_address': 'e0:63:da:fc:58:ea',
                                                                                       'out_octets': '79479575245'}],
                                                              'mac_address': 'e0:63:da:fc:59:04',
                                                              'mtu': 1600,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1544666571',
                                                              'out_ucast_pkts': '215945127',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '67462',
                                                                                                                                            'distance': 1345,
                                                                                                                                            'mac_address': 'e0:63:da:fc:58:ea',
                                                                                                                                            'noise_floor': -69.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '1951000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 15.0,
                                                                                                                                            'tx_link_rate': '1951000000',
                                                                                                                                            'tx_mcs': 9}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '4659-centerpointsw'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '6',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2341474784',
                                                              'in_ucast_pkts': '976739631',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'e0:63:da:fd:59:04',
                                                              'mtu': 1600,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2441222439',
                                                              'out_ucast_pkts': '341379703',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 39.393296,
                                'longitude': -87.108936,
                                'manufacturer': 'Ubiquiti',
                                'model': 'AF60',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': 'e0:63:da:fc:59:04',
                                'uptime': '872654'},
                'peers': [       {       'counter_source': 'main',
                                         'errors': [{'http_auth': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '79479575245',
                                                                       'links': [       {       'in_octets': '79479575245',
                                                                                                'mac_address': 'e0:63:da:fc:59:04',
                                                                                                'out_octets': '8441103590'}],
                                                                       'mac_address': 'e0:63:da:fc:58:ea',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8441103590',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '67462',
                                                                                                                                                     'distance': 1345,
                                                                                                                                                     'mac_address': 'e0:63:da:fc:59:04',
                                                                                                                                                     'noise_floor': -70.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '1951000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 15.0,
                                                                                                                                                     'tx_link_rate': '1951000000',
                                                                                                                                                     'tx_mcs': 9}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4659-centerpointsw'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '8441103590',
                                                                       'mac_address': 'e0:63:da:fd:58:ea',
                                                                       'name': 'eth0',
                                                                       'out_octets': '79479575245'}],
                                         'management_ip': '10.15.16.202',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'system_mac_address': 'e0:63:da:fc:58:ea'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AF60_v2_6_0_02(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AF60.v2.6.0.02")
        exp_info = {
                'gps_sync': None,
                'model': 'AF60',
                'rf_chan_width': 2160,
                'rf_freq': 65880,
                'rf_tx_power': 25,
                'sw_version': 'v2.6.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 12
        }
        exp_sta_stats = {
                '24:5a:4c:f8:1c:38': {       'dev_macs': set(),
                                             'ip_address': '10.232.6.139',
                                             'mac_address': '24:5a:4c:f8:1c:38',
                                             'name': 'AF60-StoneGateMens-Twr1'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.881188,
                                'elevation': 288.8,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_octets': '1340197916111',
                                                              'in_ucast_pkts': '1048346205',
                                                              'mac_address': '24:5a:4c:f9:1c:db',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '89451644720',
                                                              'out_ucast_pkts': '421963985',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '88806827349',
                                                              'in_ucast_pkts': '420796894',
                                                              'links': [       {       'in_octets': '9870708631',
                                                                                       'in_ucast_pkts': '36072848',
                                                                                       'mac_address': '24:5a:4c:f8:1c:38',
                                                                                       'out_octets': '92457394797',
                                                                                       'out_ucast_pkts': '77328413'}],
                                                              'mac_address': '24:5a:4c:f8:1c:db',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '972',
                                                              'out_errors': '0',
                                                              'out_octets': '1340103518029',
                                                              'out_ucast_pkts': '1047370513',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 65880,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '30532000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '242299',
                                                                                                                                            'distance': 664,
                                                                                                                                            'mac_address': '24:5a:4c:f8:1c:38',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '30532000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '74238000',
                                                                                                                                            'tx_mcs': 9}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_link_rate': '74238000',
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'AF60-Twr1-StoneGateMens'}],
                                                              'speed': '0'}],
                                'latitude': 32.834,
                                'longitude': -97.611783,
                                'manufacturer': 'Ubiquiti',
                                'mem': 45.413486,
                                'model': 'AF60',
                                'sw_version': 'v2.6.0',
                                'system_mac_address': '24:5a:4c:f8:1c:db',
                                'temperature': 42.0,
                                'uptime': '3200821'},
                'peers': [       {       'cpu': 8.1885,
                                         'elevation': 246.0,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '92457394797',
                                                                       'in_ucast_pkts': '77328413',
                                                                       'links': [       {       'in_octets': '92457394797',
                                                                                                'in_ucast_pkts': '77328413',
                                                                                                'mac_address': '24:5a:4c:f8:1c:db',
                                                                                                'out_octets': '9870708631',
                                                                                                'out_ucast_pkts': '36072848'}],
                                                                       'mac_address': '24:5a:4c:f8:1c:38',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9870708631',
                                                                       'out_ucast_pkts': '36072848',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'dl_percent': 50,
                                                                                                 'frequency': 65880,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '74238000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '242299',
                                                                                                                                                     'distance': 664,
                                                                                                                                                     'mac_address': '24:5a:4c:f8:1c:db',
                                                                                                                                                     'noise_floor': -60.0,
                                                                                                                                                     'rssi': -43.0,
                                                                                                                                                     'rx_link_rate': '74238000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '30532000'}],
                                                                                                                            'noise_floor': -60.0}],
                                                                                                 'tx_link_rate': '30532000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AF60-Twr1-StoneGateMens'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '9870708631',
                                                                       'in_ucast_pkts': '36072848',
                                                                       'mac_address': '24:5a:4c:f9:1c:38',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '92457394797',
                                                                       'out_ucast_pkts': '77328413',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.830838,
                                         'longitude': -97.605901,
                                         'management_ip': '10.232.6.139',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 44.850216,
                                         'model': 'airFiber 60',
                                         'name': 'AF60-StoneGateMens-Twr1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.6.0',
                                         'system_mac_address': '24:5a:4c:f8:1c:38',
                                         'temperature': 45.0,
                                         'uptime': '7273178'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AirFiber_0_10_88_17_2(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AirFiber.0.10_88_17_2")
        exp_info = {
                'gps_sync': False,
                'model': 'airFiber 11FX',
                'rf_chan_width': 56,
                'rf_freq': 11405,
                'rf_tx_power': 55,
                'sw_version': '4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 0
        }
        exp_sta_stats = {
                '18:e8:29:1e:5c:2f': {       'dev_macs': None,
                                             'ip_address': '10.88.17.3',
                                             'mac_address': '18:e8:29:1e:5c:2f',
                                             'name': 'poncherlink'}
        }
        exp_ne_msg = {
                'data': {       'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '0',
                                                              'in_discards': '0',
                                                              'in_octets': '255485907',
                                                              'in_ucast_pkts': '1153885991',
                                                              'mac_address': '18:e8:29:1e:88:40',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1915989320',
                                                              'out_ucast_pkts': '979237835',
                                                              'poller_hash': 'MThlODI5MWU4ODQwZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '42',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1915989320',
                                                              'in_ucast_pkts': '979237835',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '3768391515',
                                                                                       'in_ucast_pkts': '2779273947',
                                                                                       'mac_address': '18:e8:29:1e:5c:2f',
                                                                                       'oper_up': True,
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3110607697',
                                                                                       'out_ucast_pkts': '3704074057'}],
                                                              'mac_address': '1a:e8:29:1e:88:40',
                                                              'mtu': 1500,
                                                              'name': 'air0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '255485907',
                                                              'out_ucast_pkts': '1153885991',
                                                              'radios': [       {       'chan_width': 56,
                                                                                        'frequency': 11405,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '671518720',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '7846509',
                                                                                                                                            'distance': 10392,
                                                                                                                                            'mac_address': '18:e8:29:1e:5c:2f',
                                                                                                                                            'rx_link_rate': '671518720',
                                                                                                                                            'tx_link_rate': '547733760',
                                                                                                                                            'tx_modulation_rate': 8.0}]}],
                                                                                        'tx_link_rate': '547733760',
                                                                                        'tx_power': 55}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 11FX',
                                'poller_hash': 'GugpHohA',
                                'sw_version': '4.1.0',
                                'system_mac_address': '1a:e8:29:1e:88:40',
                                'uptime': '19266618'},
                'peers': [       {       'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'in_discards': '0',
                                                                       'in_octets': '3768391515',
                                                                       'in_ucast_pkts': '2779273947',
                                                                       'mac_address': '18:e8:29:1e:5c:2f',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3110607697',
                                                                       'out_ucast_pkts': '3704074057',
                                                                       'speed': '10000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3110607697',
                                                                       'in_ucast_pkts': '3704074057',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3110607697',
                                                                                                'in_ucast_pkts': '3704074057',
                                                                                                'mac_address': '1a:e8:29:1e:88:40',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_octets': '3768391515',
                                                                                                'out_ucast_pkts': '2779273947'}],
                                                                       'mac_address': '1a:e8:29:1e:5c:2f',
                                                                       'mtu': 1500,
                                                                       'name': 'air0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '3768391515',
                                                                       'out_ucast_pkts': '2779273947',
                                                                       'poller_hash': 'MTg6ZTg6Mjk6MWU6NWM6MmYgYWlyMA==',
                                                                       'radios': [       {       'chan_width': 56,
                                                                                                 'frequency': 10915,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '547733760',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '7846509',
                                                                                                                                                     'distance': 10392,
                                                                                                                                                     'mac_address': '1a:e8:29:1e:88:40',
                                                                                                                                                     'rx_link_rate': '547733760',
                                                                                                                                                     'tx_link_rate': '671518720',
                                                                                                                                                     'tx_modulation_rate': 10.0}]}],
                                                                                                 'tx_link_rate': '671518720',
                                                                                                 'tx_power': 55}],
                                                                       'sectors': [       {       'mode': 'STA'}],
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'management_ip': '10.88.17.3',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 11FX',
                                         'name': 'poncherlink',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.1.0',
                                         'system_mac_address': '18:e8:29:1e:5c:2f',
                                         'uptime': '23081381'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AirFiber_4_1_0_172_16_4_186(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AirFiber.4.1.0.172_16_4_186")
        exp_info = {
                'gps_sync': True,
                'model': 'AirFiber',
                'rf_chan_width': 10,
                'rf_freq': 5550,
                'rf_tx_power': 20,
                'sw_version': '4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 11
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'elevation': 293.1,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '80:2a:a8:ce:02:a4',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'ODAyYWE4Y2UwMmE0ZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1925203778',
                                                              'in_ucast_pkts': '14705948',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '82:2a:a8:ce:02:a4',
                                                              'mtu': 1500,
                                                              'name': 'air0',
                                                              'oper_up': True,
                                                              'out_discards': '154679',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '690179949',
                                                              'out_ucast_pkts': '24412647',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'frequency': 5550,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'latitude': 40.068302,
                                'longitude': -85.846596,
                                'manufacturer': 'Ubiquiti',
                                'model': 'AirFiber',
                                'poller_hash': 'giqozgKk',
                                'sw_version': '4.1.0',
                                'system_mac_address': '82:2a:a8:ce:02:a4',
                                'uptime': '6209820'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AirFiber_4_1_0_172_16_4_190(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AirFiber.4.1.0.172_16_4_190")
        exp_info = {
                'gps_sync': True,
                'model': 'AirFiber',
                'rf_chan_width': 40,
                'rf_freq': 5490,
                'rf_tx_power': 30,
                'sw_version': '4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 8
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'elevation': 281.8,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 8,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '04:18:d6:e3:d1:90',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MDQxOGQ2ZTNkMTkwZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '580545366',
                                                              'in_ucast_pkts': '4284385',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '06:18:d6:e3:d1:90',
                                                              'mtu': 1500,
                                                              'name': 'air0',
                                                              'oper_up': True,
                                                              'out_discards': '6007',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1614765516',
                                                              'out_ucast_pkts': '7896422',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'frequency': 5490,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 30}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'latitude': 40.112164,
                                'longitude': -85.902245,
                                'manufacturer': 'Ubiquiti',
                                'model': 'AirFiber',
                                'poller_hash': 'BhjW49GQ',
                                'sw_version': '4.1.0',
                                'system_mac_address': '06:18:d6:e3:d1:90',
                                'uptime': '2025830'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_AirFiber_4_1_0_172_20_134_4(self):
        obj = self.run_data("ubnt-airfiber.airfiber.AirFiber.4.1.0.172_20_134_4")
        exp_info = {
                'gps_sync': False,
                'model': 'AirFiber',
                'rf_chan_width': 56,
                'rf_freq': 10915,
                'rf_tx_power': 55,
                'sw_version': '4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 0
        }
        exp_sta_stats = {
                '18:e8:29:1e:94:5f': {       'dev_macs': None,
                                             'ip_address': '172.20.134.5',
                                             'mac_address': '18:e8:29:1e:94:5f',
                                             'name': 'TF-PONCHA'}
        }
        exp_ne_msg = {
                'data': {       'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '18:e8:29:1e:a4:11',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'MThlODI5MWVhNDExZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1510789448',
                                                              'in_ucast_pkts': '9116948',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '22',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3418001623',
                                                                                       'in_ucast_pkts': '80547256',
                                                                                       'mac_address': '18:e8:29:1e:94:5f',
                                                                                       'oper_up': True,
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2577179161',
                                                                                       'out_ucast_pkts': '42685334'}],
                                                              'mac_address': '1a:e8:29:1e:a4:11',
                                                              'mtu': 1500,
                                                              'name': 'air0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3166625342',
                                                              'out_ucast_pkts': '9835454',
                                                              'radios': [       {       'chan_width': 56,
                                                                                        'frequency': 10915,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '674835200',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3304275',
                                                                                                                                            'distance': 9255,
                                                                                                                                            'mac_address': '18:e8:29:1e:94:5f',
                                                                                                                                            'rx_link_rate': '674835200',
                                                                                                                                            'tx_link_rate': '677646080',
                                                                                                                                            'tx_modulation_rate': 10.0}]}],
                                                                                        'tx_link_rate': '677646080',
                                                                                        'tx_power': 55}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'AirFiber',
                                'poller_hash': 'GugpHqQR',
                                'sw_version': '4.1.0',
                                'system_mac_address': '1a:e8:29:1e:a4:11',
                                'uptime': '3304376'},
                'peers': [       {       'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'in_unknown_protos': '0',
                                                                       'mac_address': '18:e8:29:1e:94:5f',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'speed': '10000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '4',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2577179161',
                                                                       'in_ucast_pkts': '42685334',
                                                                       'in_unknown_protos': '0',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2577179161',
                                                                                                'in_ucast_pkts': '42685334',
                                                                                                'mac_address': '1a:e8:29:1e:a4:11',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '22',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3418001623',
                                                                                                'out_ucast_pkts': '80547256'}],
                                                                       'mac_address': '1a:e8:29:1e:94:5f',
                                                                       'mtu': 1500,
                                                                       'name': 'air0',
                                                                       'oper_up': True,
                                                                       'out_discards': '22',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3418001623',
                                                                       'out_ucast_pkts': '80547256',
                                                                       'poller_hash': 'MTg6ZTg6Mjk6MWU6OTQ6NWYgYWlyMA==',
                                                                       'radios': [       {       'chan_width': 56,
                                                                                                 'frequency': 11405,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '677646080',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3304275',
                                                                                                                                                     'distance': 9255,
                                                                                                                                                     'mac_address': '1a:e8:29:1e:a4:11',
                                                                                                                                                     'rx_link_rate': '677646080',
                                                                                                                                                     'tx_link_rate': '674835200',
                                                                                                                                                     'tx_modulation_rate': 10.0}]}],
                                                                                                 'tx_link_rate': '674835200',
                                                                                                 'tx_power': 55}],
                                                                       'sectors': [       {       'mode': 'STA'}],
                                                                       'type': 6}],
                                         'management_ip': '172.20.134.5',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AirFiber',
                                         'name': 'TF-PONCHA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.1.0',
                                         'system_mac_address': '18:e8:29:1e:94:5f',
                                         'uptime': '19589033'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_airFiber_3X_4_1_0_01(self):
        obj = self.run_data("ubnt-airfiber.airfiber.airFiber 3X.4.1.0.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 3X',
                'rf_chan_width': 20,
                'rf_freq': 3690,
                'rf_tx_power': 43,
                'sw_version': '4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 11
        }
        exp_sta_stats = {
                '04:18:d6:e3:5a:b4': {       'dev_macs': None,
                                             'ip_address': '10.4.12.151',
                                             'mac_address': '04:18:d6:e3:5a:b4',
                                             'name': 'BB365_BH_AP'}
        }
        exp_ne_msg = {
                'data': {       'elevation': 569.9,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '0',
                                                              'in_discards': '0',
                                                              'in_octets': '808160695',
                                                              'in_ucast_pkts': '1696597422',
                                                              'mac_address': '04:18:d6:e3:5a:3d',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3863139186',
                                                              'out_ucast_pkts': '3411970430',
                                                              'poller_hash': 'MDQxOGQ2ZTM1YTNkZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '42',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3863139186',
                                                              'in_ucast_pkts': '3411970430',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '3588637929',
                                                                                       'in_ucast_pkts': '3261050574',
                                                                                       'mac_address': '04:18:d6:e3:5a:b4',
                                                                                       'oper_up': True,
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3094480368',
                                                                                       'out_ucast_pkts': '2495690095'}],
                                                              'mac_address': '06:18:d6:e3:5a:3d',
                                                              'mtu': 1500,
                                                              'name': 'air0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '808160695',
                                                              'out_ucast_pkts': '1696597422',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 3690,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '166524160',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1051376',
                                                                                                                                            'distance': 1741,
                                                                                                                                            'mac_address': '04:18:d6:e3:5a:b4',
                                                                                                                                            'rx_link_rate': '166524160',
                                                                                                                                            'tx_link_rate': '36498560',
                                                                                                                                            'tx_modulation_rate': 8.0}]}],
                                                                                        'tx_link_rate': '36498560',
                                                                                        'tx_power': 43}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 39.249825,
                                'longitude': -123.149284,
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 3X',
                                'poller_hash': 'BhjW41o9',
                                'sw_version': '4.1.0',
                                'system_mac_address': '06:18:d6:e3:5a:3d',
                                'uptime': '1051491'},
                'peers': [       {       'elevation': 548.5,
                                         'gps_sats_tracked': 8,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'in_discards': '0',
                                                                       'in_octets': '3588637929',
                                                                       'in_ucast_pkts': '3261050574',
                                                                       'mac_address': '04:18:d6:e3:5a:b4',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'out_discards': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3094480368',
                                                                       'out_ucast_pkts': '2495690095',
                                                                       'speed': '10000000',
                                                                       'type': 6},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3094480368',
                                                                       'in_ucast_pkts': '2495690095',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3094480368',
                                                                                                'in_ucast_pkts': '2495690095',
                                                                                                'mac_address': '06:18:d6:e3:5a:3d',
                                                                                                'oper_up': True,
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_octets': '3588637929',
                                                                                                'out_ucast_pkts': '3261050574'}],
                                                                       'mac_address': '06:18:d6:e3:5a:b4',
                                                                       'mtu': 1500,
                                                                       'name': 'air0',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '3588637929',
                                                                       'out_ucast_pkts': '3261050574',
                                                                       'poller_hash': 'MDQ6MTg6ZDY6ZTM6NWE6YjQgYWlyMA==',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 3690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '36498560',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1051376',
                                                                                                                                                     'distance': 1741,
                                                                                                                                                     'mac_address': '06:18:d6:e3:5a:3d',
                                                                                                                                                     'rx_link_rate': '36498560',
                                                                                                                                                     'tx_link_rate': '166524160',
                                                                                                                                                     'tx_modulation_rate': 10.0}]}],
                                                                                                 'tx_link_rate': '166524160',
                                                                                                 'tx_power': 43}],
                                                                       'sectors': [       {       'mode': 'STA'}],
                                                                       'speed': '1000000000',
                                                                       'type': 6}],
                                         'latitude': 39.263096,
                                         'longitude': -123.159653,
                                         'management_ip': '10.4.12.151',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 3X',
                                         'name': 'BB365_BH_AP',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.1.0',
                                         'system_mac_address': '04:18:d6:e3:5a:b4',
                                         'uptime': '10027221'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_airFiber_60_LR_v3_2_0_beta3_01(self):
        obj = self.run_data("ubnt-airfiber.airfiber.airFiber 60 LR.v3.2.0-beta3.01")
        exp_info = {
                'gps_sync': None,
                'model': 'airFiber 60 LR',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': 20,
                'sw_version': 'v3.2.0-beta3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': None
        }
        exp_sta_stats = {
                'f4:92:bf:32:b0:4b': {       'dev_macs': set(),
                                             'ip_address': '10.1.1.59',
                                             'mac_address': 'f4:92:bf:32:b0:4b',
                                             'name': 'Hibernia to Bussey 60LR'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 22.0,
                                'elevation': 222.0,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '3030604903',
                                                              'in_ucast_pkts': '1761565690',
                                                              'mac_address': '24:5a:4c:ce:64:f0',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '425197225',
                                                              'out_ucast_pkts': '3912910234',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_octets': '5013309524073',
                                                              'in_ucast_pkts': '3919748916',
                                                              'links': [       {       'in_octets': '37561395874',
                                                                                       'in_ucast_pkts': '32075306',
                                                                                       'mac_address': 'f4:92:bf:32:b0:4b',
                                                                                       'out_octets': '3744588910',
                                                                                       'out_ucast_pkts': '23255982'}],
                                                              'mac_address': '24:5a:4c:ce:64:ef',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '429720394823',
                                                              'out_ucast_pkts': '1761279411',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '875875000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '40693',
                                                                                                                                            'distance': 5499,
                                                                                                                                            'mac_address': 'f4:92:bf:32:b0:4b',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1000000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'CWBSY2HB'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 38.54666,
                                'longitude': -85.597914,
                                'manufacturer': 'Ubiquiti',
                                'mem': 30.0,
                                'model': 'airFiber 60 LR',
                                'sw_version': 'v3.2.0-beta3',
                                'system_mac_address': '24:5a:4c:ce:64:ef',
                                'temperature': 33.0,
                                'uptime': '3900071'},
                'peers': [       {       'cpu': 12.0,
                                         'elevation': 256.6,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3744588910',
                                                                       'in_ucast_pkts': '23255982',
                                                                       'links': [       {       'in_octets': '3744588910',
                                                                                                'in_ucast_pkts': '23255982',
                                                                                                'mac_address': '24:5a:4c:ce:64:ef',
                                                                                                'out_octets': '37561395874',
                                                                                                'out_ucast_pkts': '32075306'}],
                                                                       'mac_address': 'f4:92:bf:32:b0:4b',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '37561395874',
                                                                       'out_ucast_pkts': '32075306',
                                                                       'poller_hash': 'ZjQ5MmJmMzJiMDRid2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '40693',
                                                                                                                                                     'distance': 5499,
                                                                                                                                                     'mac_address': '24:5a:4c:ce:64:ef',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'CWBSY2HB'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '2715519367',
                                                                       'in_ucast_pkts': '3783409289',
                                                                       'mac_address': 'f4:92:bf:33:b0:4b',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3303984371',
                                                                       'out_ucast_pkts': '1701119969',
                                                                       'poller_hash': 'ZjQ5MmJmMzJiMDRiZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.526569,
                                         'longitude': -85.540313,
                                         'management_ip': '10.1.1.59',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 30.0,
                                         'model': 'AF60-LR',
                                         'name': 'Hibernia to Bussey 60LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta3',
                                         'system_mac_address': 'f4:92:bf:32:b0:4b',
                                         'uptime': '3774527'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airfiber_airfiber_airFiber_60_XR_v1_0_2_RC_01(self):
        obj = self.run_data("ubnt-airfiber.airfiber.airFiber 60 XR.v1.0.2-RC.01")
        exp_info = {
                'gps_sync': None,
                'model': 'airFiber 60 XR',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': None,
                'sw_version': 'v1.0.2-RC',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'gps_sats_tracked': 11
        }
        exp_sta_stats = {
                '24:5a:4c:2f:85:45': {       'dev_macs': set(),
                                             'ip_address': '10.200.70.51',
                                             'mac_address': '24:5a:4c:2f:85:45',
                                             'name': 'AF60XR-TR9-Whitt'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 3.0,
                                'elevation': 351.9,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '24:5a:4c:2f:85:c2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '6',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '361871265',
                                                              'in_ucast_pkts': '569245741',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2147483647',
                                                                                       'mac_address': '24:5a:4c:2f:85:45',
                                                                                       'out_octets': '2147483647'}],
                                                              'mac_address': '24:5a:4c:2f:85:c1',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1072955218',
                                                              'out_ucast_pkts': '1200821296',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'frequency': 68040,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1663331',
                                                                                                                                            'distance': 3688,
                                                                                                                                            'mac_address': '24:5a:4c:2f:85:45',
                                                                                                                                            'noise_floor': -53.0,
                                                                                                                                            'rssi': -34.0,
                                                                                                                                            'rx_link_rate': '3585582000',
                                                                                                                                            'rx_mcs': 0,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '3506302000',
                                                                                                                                            'tx_mcs': 12}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'AF60XR-Whitt-TR9'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.960032,
                                'longitude': -98.018003,
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 60 XR',
                                'sw_version': 'v1.0.2-RC',
                                'system_mac_address': '24:5a:4c:2f:85:c1',
                                'uptime': '1473696'},
                'peers': [       {       'counter_source': 'main',
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '2147483647',
                                                                       'links': [       {       'in_octets': '2147483647',
                                                                                                'mac_address': '24:5a:4c:2f:85:c1',
                                                                                                'out_octets': '2147483647'}],
                                                                       'mac_address': '24:5a:4c:2f:85:45',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2147483647',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1663331',
                                                                                                                                                     'distance': 3688,
                                                                                                                                                     'mac_address': '24:5a:4c:2f:85:c1',
                                                                                                                                                     'noise_floor': -59.0,
                                                                                                                                                     'rssi': -40.0,
                                                                                                                                                     'rx_link_rate': '3506302000',
                                                                                                                                                     'rx_mcs': 12,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '3585582000',
                                                                                                                                                     'tx_mcs': 0}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AF60XR-Whitt-TR9'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2147483647',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2147483647',
                                                                       'poller_hash': 'MjQ1YTRjMmY4NTQ1ZXRoMA=='}],
                                         'management_ip': '10.200.70.51',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-XR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:2f:85:45'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_AirFiber_5XHD_v1_1_0_RC6_00288_01(self):
        obj = self.run_data("ubnt.ltu.AirFiber 5XHD.v1.1.0-RC6.00288.01")
        exp_info = {
                'gps_sync': None,
                'model': 'AirFiber 5XHD',
                'rf_chan_width': 20,
                'rf_freq': 5740,
                'rf_tx_power': 19,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.1.0-RC6.00288',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 12.0,
                'dl_en_bytes': None,
                'dl_en_packets': 0,
                'dl_rf_bytes': 8363667477691,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': None,
                'ul_en_packets': 0,
                'ul_rf_bytes': 516250633307,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '7e:8a:20:5f:23:03': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 145920000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.16.17.3',
                                             'mac_address': '7e:8a:20:5f:23:03',
                                             'name': 'br-marshall.bri',
                                             'ul_link_rate': 46080000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 12.0,
                                'errors': [{'http_connect': {}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:5f:1d:1e',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '876',
                                                              'out_ucast_pkts': '10',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '903930826',
                                                              'in_ucast_pkts': '5833735',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '7e:8a:20:5f:23:03'}],
                                                              'mac_address': '7e:8a:20:5f:1d:1e',
                                                              'mtu': 1600,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '884927231',
                                                              'out_ucast_pkts': '5545167',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5740,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3957501',
                                                                                                                                            'distance': 4560,
                                                                                                                                            'mac_address': '7e:8a:20:5f:23:03',
                                                                                                                                            'rssi': -62.5,
                                                                                                                                            'rx_link_rate': '46080000',
                                                                                                                                            'tx_link_rate': '145920000'}]}],
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'marsh-briarwood'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'AirFiber 5XHD',
                                'name': 'br-briarwood.ma',
                                'sw_version': 'v1.1.0-RC6.00288',
                                'system_mac_address': '7e:8a:20:5f:1d:1e',
                                'uptime': '2545213'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '7e:8a:20:5f:1d:1e'}],
                                                                       'mac_address': '7e:8a:20:5f:23:03',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5740,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3957501',
                                                                                                                                                     'distance': 4560,
                                                                                                                                                     'mac_address': '7e:8a:20:5f:1d:1e',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '145920000',
                                                                                                                                                     'tx_link_rate': '46080000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'marsh-briarwood'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'N2U4YTIwNWYyMzAzZXRoMA=='}],
                                         'management_ip': '10.16.17.3',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AirFiber 5XHD',
                                         'name': 'br-marshall.bri',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.1.0-RC6.00288',
                                         'system_mac_address': '7e:8a:20:5f:23:03'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD__v1_1_1_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD..v1.1.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 40,
                'rf_freq': 5600,
                'rf_tx_power': 15,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': '.v1.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 11.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': None,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD__v1_1_2_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD..v1.1.2.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 60,
                'rf_freq': 5820,
                'rf_tx_power': 25,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': '.v1.1.2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 21.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD_v1_1_2_BETA4_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD.v1.1.2-BETA4.01")
        exp_info = {
                'gps_sync': None,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 30,
                'rf_freq': 5740,
                'rf_tx_power': 8,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.1.2-BETA4',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 18.0,
                'dl_en_bytes': 6062381890246,
                'dl_en_packets': 0,
                'dl_rf_bytes': 5941256151620,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 92607979385008,
                'ul_en_packets': 0,
                'ul_rf_bytes': 92229074982487,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '78:8a:20:5f:a3:af': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 51840000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.15.17.211',
                                             'mac_address': '78:8a:20:5f:a3:af',
                                             'name': 'br-nwgrain1.sul',
                                             'ul_link_rate': 275200000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 18.0,
                                'errors': [{'http_connect': {}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '7a:8a:20:5f:8e:80',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '802',
                                                              'out_ucast_pkts': '9',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '506863',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4119912915',
                                                              'in_ucast_pkts': '20943945',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '78:8a:20:5f:a3:af'}],
                                                              'mac_address': '78:8a:20:5f:8e:80',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4249915459',
                                                              'out_ucast_pkts': '18916831',
                                                              'radios': [       {       'chan_width': 30,
                                                                                        'frequency': 5740,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '15197739',
                                                                                                                                            'distance': 5080,
                                                                                                                                            'mac_address': '78:8a:20:5f:a3:af',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '275200000',
                                                                                                                                            'tx_link_rate': '51840000'}]}],
                                                                                        'tx_power': 8}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'slvn-graysville'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 5XHD',
                                'name': 'br-graysvilleN.',
                                'sw_version': 'v1.1.2-BETA4',
                                'system_mac_address': '78:8a:20:5f:8e:80',
                                'uptime': '26034437'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '78:8a:20:5f:8e:80'}],
                                                                       'mac_address': '78:8a:20:5f:a3:af',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'frequency': 5740,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '15197739',
                                                                                                                                                     'distance': 5080,
                                                                                                                                                     'mac_address': '78:8a:20:5f:8e:80',
                                                                                                                                                     'rssi': -54.5,
                                                                                                                                                     'rx_link_rate': '51840000',
                                                                                                                                                     'tx_link_rate': '275200000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'slvn-graysville'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwNWZhM2FmZXRoMA=='}],
                                         'management_ip': '10.15.17.211',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 5XHD',
                                         'name': 'br-nwgrain1.sul',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.1.2',
                                         'system_mac_address': '78:8a:20:5f:a3:af'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD_v1_3_0_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD.v1.3.0.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 100,
                'rf_freq': 6150,
                'rf_tx_power': 21,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.3.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 16.0,
                'dl_en_bytes': None,
                'dl_en_packets': 0,
                'dl_rf_bytes': None,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': None,
                'ul_en_packets': 0,
                'ul_rf_bytes': None,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '78:8a:20:5f:f2:be': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 826880000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.2.0.155',
                                             'mac_address': '78:8a:20:5f:f2:be',
                                             'name': 'Mountrath Hub l',
                                             'ul_link_rate': 273920000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'elevation': 122.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '7a:8a:20:5f:f2:bd',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '802',
                                                              'out_ucast_pkts': '9',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1542817367',
                                                              'in_ucast_pkts': '6653184',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '78:8a:20:5f:f2:be'}],
                                                              'mac_address': '78:8a:20:5f:f2:bd',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2561973824',
                                                              'out_ucast_pkts': '6038045',
                                                              'radios': [       {       'chan_width': 100,
                                                                                        'frequency': 6150,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 763,
                                                                                                                                            'mac_address': '78:8a:20:5f:f2:be',
                                                                                                                                            'rssi': -37.5,
                                                                                                                                            'rx_link_rate': '273920000',
                                                                                                                                            'tx_link_rate': '826880000'}]}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BHDCOUMHUB'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 52.999562,
                                'longitude': -7.487258,
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 5XHD',
                                'name': 'Derrycouch link',
                                'sw_version': 'v1.3.0',
                                'system_mac_address': '78:8a:20:5f:f2:bd',
                                'uptime': '4310635'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '78:8a:20:5f:f2:bd'}],
                                                                       'mac_address': '78:8a:20:5f:f2:be',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 100,
                                                                                                 'frequency': 6150,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 763,
                                                                                                                                                     'mac_address': '78:8a:20:5f:f2:bd',
                                                                                                                                                     'rssi': -36.0,
                                                                                                                                                     'rx_link_rate': '826880000',
                                                                                                                                                     'tx_link_rate': '273920000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BHDCOUMHUB'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwNWZmMmJlZXRoMA=='}],
                                         'management_ip': '10.2.0.155',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 5XHD',
                                         'name': 'Mountrath Hub l',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.3.0',
                                         'system_mac_address': '78:8a:20:5f:f2:be'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD_v1_3_0_BETA3_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD.v1.3.0-BETA3.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 60,
                'rf_freq': 5500,
                'rf_tx_power': -5,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': 'v1.3.0-BETA3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 17.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD_v1_3_1_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD.v1.3.1.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 20,
                'rf_freq': 5765,
                'rf_tx_power': 23,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': 'v1.3.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 12.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_5XHD_v1_4_0_BETA_00014_191010_1110_01(self):
        obj = self.run_data("ubnt.ltu.airFiber 5XHD.v1.4.0-BETA.00014.191010.1110.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber 5XHD',
                'rf_chan_width': 20,
                'rf_freq': 5770,
                'rf_tx_power': 29,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.0-BETA',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 16.0,
                'dl_en_bytes': 575564679673,
                'dl_en_packets': 0,
                'dl_rf_bytes': 573603222933,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 10,
                'ul_en_bytes': 38809464288,
                'ul_en_packets': 0,
                'ul_rf_bytes': 37696819679,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '78:8a:20:5f:cc:7b': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 118400000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.15.18.59',
                                             'mac_address': '78:8a:20:5f:cc:7b',
                                             'name': 'br-briarwood.cl',
                                             'ul_link_rate': 118400000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'elevation': 212.7,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '7a:8a:20:5f:23:a1',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '540',
                                                              'out_ucast_pkts': '6',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '5',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '5642410827',
                                                              'in_ucast_pkts': '91014999',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '78:8a:20:5f:cc:7b'}],
                                                              'mac_address': '78:8a:20:5f:23:a1',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '283751374',
                                                              'out_ucast_pkts': '1051658',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5770,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '894335',
                                                                                                                                            'distance': 3897,
                                                                                                                                            'mac_address': '78:8a:20:5f:cc:7b',
                                                                                                                                            'rssi': -45.0,
                                                                                                                                            'rx_link_rate': '118400000',
                                                                                                                                            'tx_link_rate': '118400000'}]}],
                                                                                        'tx_power': 29}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'briarwood-clarkc'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 39.360655,
                                'longitude': -87.734856,
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber 5XHD',
                                'name': 'br-clarkcenter.',
                                'sw_version': 'v1.4.0-BETA',
                                'system_mac_address': '78:8a:20:5f:23:a1',
                                'uptime': '895323'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '78:8a:20:5f:23:a1'}],
                                                                       'mac_address': '78:8a:20:5f:cc:7b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5770,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '894335',
                                                                                                                                                     'distance': 3897,
                                                                                                                                                     'mac_address': '78:8a:20:5f:23:a1',
                                                                                                                                                     'rssi': -47.5,
                                                                                                                                                     'rx_link_rate': '118400000',
                                                                                                                                                     'tx_link_rate': '118400000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'briarwood-clarkc'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwNWZjYzdiZXRoMA=='}],
                                         'management_ip': '10.15.18.59',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 5XHD',
                                         'name': 'br-briarwood.cl',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.4.0-BETA',
                                         'system_mac_address': '78:8a:20:5f:cc:7b'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_AirFiber_LTU_v1_2_0_BETA4secoff_01(self):
        obj = self.run_data("ubnt.ltu.AirFiber LTU.v1.2.0-BETA4secoff.01")
        exp_info = {
                'gps_sync': None,
                'model': 'AirFiber LTU',
                'rf_chan_width': 10,
                'rf_freq': 5180,
                'rf_tx_power': 29,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.2.0-BETA4secoff',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 11.0,
                'dl_en_bytes': None,
                'dl_en_packets': 0,
                'dl_rf_bytes': 940168895479,
                'dl_rf_packets': 0,
                'en_if_speed': 100000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': None,
                'ul_en_packets': 0,
                'ul_rf_bytes': 205189045700,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '7e:8a:20:5f:25:7b': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 57600000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.100.10.76',
                                             'mac_address': '7e:8a:20:5f:25:7b',
                                             'name': 'Butter Buds (Ac',
                                             'ul_link_rate': 57600000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'errors': [{'http_connect': {}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1098765153',
                                                              'in_ucast_pkts': '10705794',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '7e:8a:20:5f:25:7b'}],
                                                              'mac_address': '7e:8a:20:5f:25:98',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '2',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '592592170',
                                                              'out_ucast_pkts': '2552974',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'frequency': 5180,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '189568',
                                                                                                                                            'distance': 3656,
                                                                                                                                            'mac_address': '7e:8a:20:5f:25:7b',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '57600000',
                                                                                                                                            'tx_link_rate': '57600000'}]}],
                                                                                        'tx_power': 29}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Wood-NE'}],
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'AirFiber LTU',
                                'name': 'Wood NE',
                                'sw_version': 'v1.2.0-BETA4secoff',
                                'system_mac_address': '7e:8a:20:5f:25:98',
                                'uptime': '7192081'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '7e:8a:20:5f:25:98'}],
                                                                       'mac_address': '7e:8a:20:5f:25:7b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 10,
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '189568',
                                                                                                                                                     'distance': 3656,
                                                                                                                                                     'mac_address': '7e:8a:20:5f:25:98',
                                                                                                                                                     'rssi': -61.5,
                                                                                                                                                     'rx_link_rate': '57600000',
                                                                                                                                                     'tx_link_rate': '57600000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wood-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'N2U4YTIwNWYyNTdiZXRoMA=='}],
                                         'management_ip': '10.100.10.76',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AirFiber LTU',
                                         'name': 'Butter Buds (Ac',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.2.0-BETA4secoff',
                                         'system_mac_address': '7e:8a:20:5f:25:7b'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_LTU_v1_2_0_BETA5_01(self):
        obj = self.run_data("ubnt.ltu.airFiber LTU.v1.2.0-BETA5.01")
        exp_info = {
                'gps_sync': None,
                'model': 'airFiber LTU',
                'rf_chan_width': 50,
                'rf_freq': 5180,
                'rf_tx_power': 19,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.2.0-BETA5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 16.0,
                'dl_en_bytes': 232406686163,
                'dl_en_packets': 0,
                'dl_rf_bytes': 230757844438,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 78212601706,
                'ul_en_packets': 0,
                'ul_rf_bytes': 75933834198,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '78:8a:20:5f:0a:a2': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 58880000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.100.82.25',
                                             'mac_address': '78:8a:20:5f:0a:a2',
                                             'name': 'onSheraton2Toll',
                                             'ul_link_rate': 117760000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'errors': [{'http_connect': {}}],
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '6',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3571332993',
                                                              'in_ucast_pkts': '46675204',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '78:8a:20:5f:0a:a2'}],
                                                              'mac_address': '78:8a:20:5f:25:63',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1099598718',
                                                              'out_ucast_pkts': '7218429',
                                                              'radios': [       {       'chan_width': 50,
                                                                                        'frequency': 5180,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1295975',
                                                                                                                                            'distance': 3661,
                                                                                                                                            'mac_address': '78:8a:20:5f:0a:a2',
                                                                                                                                            'rssi': -67.5,
                                                                                                                                            'rx_link_rate': '117760000',
                                                                                                                                            'tx_link_rate': '58880000'}]}],
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TW1-N'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber LTU',
                                'name': 'TW1 -N',
                                'sw_version': 'v1.2.0-BETA5',
                                'system_mac_address': '78:8a:20:5f:25:63',
                                'uptime': '5006129'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '78:8a:20:5f:25:63'}],
                                                                       'mac_address': '78:8a:20:5f:0a:a2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 50,
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1295975',
                                                                                                                                                     'distance': 3661,
                                                                                                                                                     'mac_address': '78:8a:20:5f:25:63',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '58880000',
                                                                                                                                                     'tx_link_rate': '117760000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TW1-N'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwNWYwYWEyZXRoMA=='}],
                                         'management_ip': '10.100.82.25',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'airFiber 5XHD',
                                         'name': 'onSheraton2Toll',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.2.0-BETA5',
                                         'system_mac_address': '78:8a:20:5f:0a:a2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_airFiber_LTU_v2_0_3_BETA4_00023_190711_1007_01(self):
        obj = self.run_data("ubnt.ltu.airFiber LTU.v2.0.3-BETA4.00023.190711.1007.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber LTU',
                'rf_chan_width': 10,
                'rf_freq': 5160,
                'rf_tx_power': 29,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v2.0.3-BETA4',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 15.0,
                'dl_en_bytes': 281276087,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 100000000,
                'gps_sats_tracked': 8,
                'ul_en_bytes': 54766439,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 15.0,
                                'elevation': 307.6,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 8,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '215407535',
                                                              'in_ucast_pkts': '3433046',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:5f:25:98',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '53549904',
                                                              'out_ucast_pkts': '302097',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'frequency': 5160,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 29}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Wood-NE'}],
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'latitude': 42.669585,
                                'longitude': -87.847572,
                                'manufacturer': 'Ubiquiti',
                                'model': 'airFiber LTU',
                                'name': 'Wood NE',
                                'sw_version': 'v2.0.3-BETA4',
                                'system_mac_address': '78:8a:20:5f:25:98',
                                'uptime': '1112720'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_AirFiber_LTU_v2_0_6_BETA_00015_191129_1611_01(self):
        obj = self.run_data("ubnt.ltu.AirFiber LTU.v2.0.6-BETA.00015.191129.1611.01")
        exp_info = {
                'gps_sync': True,
                'model': 'airFiber LTU',
                'rf_chan_width': 30,
                'rf_freq': 5235,
                'rf_tx_power': 23,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': 'v2.0.6-BETA',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 21.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Instant_v2_2_1_01(self):
        obj = self.run_data("ubnt.ltu.LTU Instant.v2.2.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU Instant',
                'rf_chan_width': 20,
                'rf_freq': 5630,
                'rf_tx_power': 8,
                'sta_count': 1,
                'sta_mode_cpe': True,
                'sw_version': 'v2.2.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 29.364279,
                'dl_en_bytes': 255616713,
                'dl_en_packets': 1532812,
                'dl_rf_bytes': 340884556,
                'dl_rf_packets': 1687485,
                'en_if_speed': 0,
                'gps_sats_tracked': 0,
                'ul_en_bytes': 2002468331,
                'ul_en_packets': 2490476,
                'ul_rf_bytes': 2051477585,
                'ul_rf_packets': 2664550
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 29.364279,
                                'elevation': 0.0,
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '255616713',
                                                              'in_ucast_pkts': '1532812',
                                                              'mac_address': 'd6:21:f9:76:3d:4f',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '2002468331',
                                                              'out_ucast_pkts': '2490476',
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '2051477585',
                                                              'in_ucast_pkts': '2664550',
                                                              'mac_address': 'd0:21:f9:76:3d:4f',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '340884556',
                                                              'out_ucast_pkts': '1687485',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 67,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5630,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '52480000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'tx_link_rate': '160000000',
                                                                                        'tx_power': 8}],
                                                              'sectors': [       {       'mode': 'STA',
                                                                                         'ssid': 'WCC448'}],
                                                              'type': 6}],
                                'latitude': 35.40854,
                                'longitude': -120.44973,
                                'manufacturer': 'Ubiquiti',
                                'mem': 89.098076,
                                'model': 'LTU Instant',
                                'sw_version': 'v2.2.1',
                                'system_mac_address': 'd0:21:f9:76:3d:4f',
                                'temperature': 76.0,
                                'uptime': '46504'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Lite_v1_5_1_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Lite.v1.5.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Lite',
                'rf_chan_width': 100,
                'rf_freq': 5520,
                'rf_tx_power': 17,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.5.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 41.051567,
                'dl_en_bytes': 571872971525,
                'dl_en_packets': 649679657,
                'dl_rf_bytes': 570257491798,
                'dl_rf_packets': 651356064,
                'en_if_speed': 0,
                'gps_sats_tracked': 0,
                'ul_en_bytes': 20212349873,
                'ul_en_packets': 159174700,
                'ul_rf_bytes': 19503430213,
                'ul_rf_packets': 160244497
        }
        exp_sta_stats = {
                'e0:63:da:0f:96:e8': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 822400000,
                                             'dl_rf_bytes': 570254424267,
                                             'dl_rf_packets': 651324929,
                                             'ip_address': '100.112.129.96',
                                             'mac_address': 'e0:63:da:0f:96:e8',
                                             'name': 'cremin_apartment',
                                             'ul_link_rate': 268800000,
                                             'ul_rf_bytes': 19503456916,
                                             'ul_rf_packets': 160244732}
        }
        exp_ne_msg = {
                'data': {       'cpu': 41.051567,
                                'elevation': 0.0,
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '571872971525',
                                                              'in_ucast_pkts': '649679657',
                                                              'mac_address': 'e6:63:da:0f:ad:01',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '20212349873',
                                                              'out_ucast_pkts': '159174700',
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '19503430213',
                                                              'in_ucast_pkts': '160244497',
                                                              'links': [       {       'in_octets': '19503456916',
                                                                                       'in_ucast_pkts': '160244732',
                                                                                       'mac_address': 'e0:63:da:0f:96:e8',
                                                                                       'out_octets': '570254424267',
                                                                                       'out_ucast_pkts': '651324929'}],
                                                              'mac_address': 'e0:63:da:0f:ad:01',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '570257491798',
                                                              'out_ucast_pkts': '651356064',
                                                              'radios': [       {       'chan_width': 100,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5520,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '268800000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '993260',
                                                                                                                                            'distance': 25,
                                                                                                                                            'mac_address': 'e0:63:da:0f:96:e8',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '268800000',
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '822400000'}],
                                                                                                                   'noise_floor': -101.0}],
                                                                                        'tx_link_rate': '822400000',
                                                                                        'tx_power': 17}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'CREMIN.PTPAPT'}],
                                                              'type': 6}],
                                'latitude': 0.0,
                                'longitude': 0.0,
                                'manufacturer': 'Ubiquiti',
                                'mem': 79.13747,
                                'model': 'LTU-Lite',
                                'sw_version': 'v1.5.1',
                                'system_mac_address': 'e0:63:da:0f:ad:01',
                                'temperature': 73.0,
                                'uptime': '993349'},
                'peers': [       {       'cpu': 45.096,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '02:90:3a:0f:55:fc',
                                                                                                        '02:b7:97:a4:b5:9f',
                                                                                                        '08:55:31:0b:07:ea',
                                                                                                        '2c:c8:1b:37:b7:61',
                                                                                                        'c4:ad:34:2a:c1:ea',
                                                                                                        'd4:ca:6d:84:3f:95',
                                                                                                        'e0:63:da:0f:ad:01',
                                                                                                        'e6:63:da:0f:96:e8'],
                                                                       'id': 'ath0',
                                                                       'in_octets': '570254424267',
                                                                       'in_ucast_pkts': '651324929',
                                                                       'links': [       {       'in_octets': '570254424267',
                                                                                                'in_ucast_pkts': '651324929',
                                                                                                'mac_address': 'e0:63:da:0f:ad:01',
                                                                                                'out_octets': '19503456916',
                                                                                                'out_ucast_pkts': '160244732'}],
                                                                       'mac_address': 'e0:63:da:0f:96:e8',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '19503456916',
                                                                       'out_ucast_pkts': '160244732',
                                                                       'radios': [       {       'chan_width': 100,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5520,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '822400000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '993260',
                                                                                                                                                     'distance': 25,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:ad:01',
                                                                                                                                                     'noise_floor': -93.0,
                                                                                                                                                     'rssi': -38.0,
                                                                                                                                                     'rx_link_rate': '822400000',
                                                                                                                                                     'snr': 55.0,
                                                                                                                                                     'tx_link_rate': '268800000'}],
                                                                                                                            'noise_floor': -93.0}],
                                                                                                 'tx_link_rate': '268800000',
                                                                                                 'tx_power': 17}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'CREMIN.PTPAPT'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '19503456916',
                                                                       'in_ucast_pkts': '160244732',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '570254424267',
                                                                       'out_ucast_pkts': '651324929',
                                                                       'poller_hash': 'ZTA2M2RhMGY5NmU4ZXRoMA==',
                                                                       'speed': '100000000'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.112.129.96',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 78.118645,
                                         'model': 'LTU-Lite',
                                         'name': 'cremin_apartment',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.5.1',
                                         'system_mac_address': 'e0:63:da:0f:96:e8',
                                         'temperature': 52.0,
                                         'uptime': '993452'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_LR_v2_0_7_01(self):
        obj = self.run_data("ubnt.ltu.LTU-LR.v2.0.7.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-LR',
                'rf_chan_width': 20,
                'rf_freq': 5800,
                'rf_tx_power': 22,
                'sta_count': None,
                'sta_mode_cpe': True,
                'sw_version': 'v2.0.7',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 18.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 0,
                'gps_sats_tracked': 0,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Pro_v2_2_1_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Pro.v2.2.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Pro',
                'rf_chan_width': 20,
                'rf_freq': 5300,
                'rf_tx_power': 22,
                'sta_count': 1,
                'sta_mode_cpe': True,
                'sw_version': 'v2.2.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 31.919191,
                'dl_en_bytes': 443805497781,
                'dl_en_packets': 2427203046,
                'dl_rf_bytes': 446773460909,
                'dl_rf_packets': 2454405469,
                'en_if_speed': 0,
                'gps_sats_tracked': 7,
                'ul_en_bytes': 6011719209990,
                'ul_en_packets': 151060992,
                'ul_rf_bytes': 6003181640918,
                'ul_rf_packets': 185715687
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 31.919191,
                                'elevation': 350.9,
                                'gps_sats_tracked': 7,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '443805497781',
                                                              'in_ucast_pkts': '2427203046',
                                                              'mac_address': '7e:45:58:7f:03:33',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '6011719209990',
                                                              'out_ucast_pkts': '151060992',
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '6003181640918',
                                                              'in_ucast_pkts': '185715687',
                                                              'mac_address': '78:45:58:7f:03:33',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '446773460909',
                                                              'out_ucast_pkts': '2454405469',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5300,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '37437000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_link_rate': '182400000',
                                                                                        'tx_power': 22}],
                                                              'sectors': [       {       'mode': 'STA',
                                                                                         'ssid': 'WCC453'}],
                                                              'type': 6}],
                                'latitude': 35.409903,
                                'longitude': -120.554128,
                                'manufacturer': 'Ubiquiti',
                                'mem': 90.7692,
                                'model': 'LTU-Pro',
                                'sw_version': 'v2.2.1',
                                'system_mac_address': '78:45:58:7f:03:33',
                                'temperature': 84.0,
                                'uptime': '7110469'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_0_3_BETA_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.0.3-BETA.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5800,
                'rf_tx_power': None,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v2.0.3-BETA',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 75.0,
                'dl_en_bytes': 10393564703,
                'dl_en_packets': 94714968,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 9236248781,
                'ul_en_packets': 19511847,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 75.0,
                                'elevation': 198.3,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '10393564703',
                                                              'in_ucast_pkts': '94714968',
                                                              'mac_address': '1a:e8:29:1f:03:58',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '9236248781',
                                                              'out_ucast_pkts': '19511847',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '18:e8:29:1f:03:58',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -79.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ubnt'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 37.753704,
                                'longitude': -88.935545,
                                'manufacturer': 'Ubiquiti',
                                'mem': 77.64233,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.0.3-BETA',
                                'system_mac_address': '18:e8:29:1f:03:58',
                                'uptime': '39264061'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_0_5_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.0.5.01")
        exp_info = {
                'gps_sync': True,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5740,
                'rf_tx_power': 26,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v2.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 27.0,
                'dl_en_bytes': 124677288833,
                'dl_en_packets': 0,
                'dl_rf_bytes': 124041266989,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 29852531139,
                'ul_en_packets': 0,
                'ul_rf_bytes': 29947264922,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '18:e8:29:1f:13:83': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 179200000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.100.84.165',
                                             'mac_address': '18:e8:29:1f:13:83',
                                             'name': 'Cole Giles',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 27.0,
                                'elevation': 1001.9,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '393',
                                                              'in_octets': '7198286',
                                                              'in_ucast_pkts': '73087',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '1e:e8:29:1f:08:35',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '92761999901',
                                                              'out_ucast_pkts': '730903888',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '4',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2173677757',
                                                              'in_ucast_pkts': '12916631',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '18:e8:29:1f:13:83'}],
                                                              'mac_address': '18:e8:29:1f:08:35',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '330',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1029376953',
                                                              'out_ucast_pkts': '4365039',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5740,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1112622',
                                                                                                                                            'distance': 2009,
                                                                                                                                            'mac_address': '18:e8:29:1f:13:83',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'tx_link_rate': '179200000'}]}],
                                                                                        'tx_power': 26}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'LTU-AP1'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 35.543581,
                                'longitude': -100.989198,
                                'manufacturer': 'Ubiquiti',
                                'model': 'LTU-Rocket',
                                'name': 'LTU-AP1',
                                'sw_version': 'v2.0.5',
                                'system_mac_address': '18:e8:29:1f:08:35',
                                'uptime': '1451889'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': '18:e8:29:1f:08:35'}],
                                                                       'mac_address': '18:e8:29:1f:13:83',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5740,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1112622',
                                                                                                                                                     'distance': 2009,
                                                                                                                                                     'mac_address': '18:e8:29:1f:08:35',
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '179200000',
                                                                                                                                                     'tx_link_rate': '28078000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'LTU-AP1'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MWYxMzgzZXRoMA=='}],
                                         'management_ip': '10.100.84.165',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'LTU-Pro',
                                         'name': 'Cole Giles',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.5',
                                         'system_mac_address': '18:e8:29:1f:13:83'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_0_5_02(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.0.5.02")
        exp_info = {
                'gps_sync': True,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5840,
                'rf_tx_power': 30,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v2.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 27.0,
                'dl_en_bytes': 275754760848,
                'dl_en_packets': 0,
                'dl_rf_bytes': 273683059389,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 31021368787,
                'ul_en_packets': 0,
                'ul_rf_bytes': 31080131568,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '18:e8:29:1f:0c:38': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 92160000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.60.41.21',
                                             'mac_address': '18:e8:29:1f:0c:38',
                                             'name': 'Scotty Rice',
                                             'ul_link_rate': 82877000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None},
                'fc:ec:da:77:9b:03': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 92160000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.60.41.20',
                                             'mac_address': 'fc:ec:da:77:9b:03',
                                             'name': 'Cross Timbers A',
                                             'ul_link_rate': 82877000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 27.0,
                                'elevation': 342.5,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '160',
                                                              'in_octets': '2834391',
                                                              'in_ucast_pkts': '28666',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'fa:ec:da:77:ad:fb',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '31561943444',
                                                              'out_ucast_pkts': '287642341',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '473459104',
                                                              'in_ucast_pkts': '914004',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '18:e8:29:1f:0c:38'},
                                                                               {       'mac_address': 'fc:ec:da:77:9b:03'}],
                                                              'mac_address': 'fc:ec:da:77:ad:fb',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1249071502',
                                                              'out_ucast_pkts': '1361695',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5840,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '152176',
                                                                                                                                            'distance': 53,
                                                                                                                                            'mac_address': '18:e8:29:1f:0c:38',
                                                                                                                                            'rssi': -64.5,
                                                                                                                                            'rx_link_rate': '82877000',
                                                                                                                                            'tx_link_rate': '92160000'},
                                                                                                                                    {       'connected_time': '338613',
                                                                                                                                            'distance': 3609,
                                                                                                                                            'mac_address': 'fc:ec:da:77:9b:03',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '82877000',
                                                                                                                                            'tx_link_rate': '92160000'}]}],
                                                                                        'tx_power': 30}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'VRFTintop'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.663755,
                                'longitude': -97.797814,
                                'manufacturer': 'Ubiquiti',
                                'model': 'LTU-Rocket',
                                'name': 'LTU-Rocket',
                                'sw_version': 'v2.0.5',
                                'system_mac_address': 'fc:ec:da:77:ad:fb',
                                'uptime': '575229'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': 'fc:ec:da:77:ad:fb'}],
                                                                       'mac_address': '18:e8:29:1f:0c:38',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '152176',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'mac_address': 'fc:ec:da:77:ad:fb',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '92160000',
                                                                                                                                                     'tx_link_rate': '82877000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VRFTintop'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MWYwYzM4ZXRoMA=='}],
                                         'management_ip': '10.60.41.21',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'LTU-Lite',
                                         'name': 'Scotty Rice',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.5',
                                         'system_mac_address': '18:e8:29:1f:0c:38'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': 'fc:ec:da:77:ad:fb'}],
                                                                       'mac_address': 'fc:ec:da:77:9b:03',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '338613',
                                                                                                                                                     'distance': 3609,
                                                                                                                                                     'mac_address': 'fc:ec:da:77:ad:fb',
                                                                                                                                                     'rssi': -63.5,
                                                                                                                                                     'rx_link_rate': '92160000',
                                                                                                                                                     'tx_link_rate': '82877000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VRFTintop'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhNzc5YjAzZXRoMA=='}],
                                         'management_ip': '10.60.41.20',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'LTU-Pro',
                                         'name': 'Cross Timbers A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.5',
                                         'system_mac_address': 'fc:ec:da:77:9b:03'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_0_5_BETA4_00031_190919_1409_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.0.5-BETA4.00031.190919.1409.01")
        exp_info = {
                'gps_sync': True,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5830,
                'rf_tx_power': 23,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v2.0.5-BETA4',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 26.0,
                'dl_en_bytes': 415020940323,
                'dl_en_packets': 0,
                'dl_rf_bytes': 412811264608,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 13298311353,
                'ul_en_packets': 0,
                'ul_rf_bytes': 13415214877,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
                '18:e8:29:1f:0c:38': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 160000000,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'ip_address': '10.60.41.21',
                                             'mac_address': '18:e8:29:1f:0c:38',
                                             'name': 'Scotty Rice',
                                             'ul_link_rate': 54400000,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 26.0,
                                'elevation': 319.1,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '553',
                                                              'in_octets': '10042486',
                                                              'in_ucast_pkts': '101925',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'fa:ec:da:77:ad:fb',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '109673004583',
                                                              'out_ucast_pkts': '1024808746',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '591039545',
                                                              'in_ucast_pkts': '1452503',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '18:e8:29:1f:0c:38'}],
                                                              'mac_address': 'fc:ec:da:77:ad:fb',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '5',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1241309065',
                                                              'out_ucast_pkts': '1770581',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5830,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '881204',
                                                                                                                                            'distance': 47,
                                                                                                                                            'mac_address': '18:e8:29:1f:0c:38',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '54400000',
                                                                                                                                            'tx_link_rate': '160000000'}]}],
                                                                                        'tx_power': 23}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'VRFTintop'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.663759,
                                'longitude': -97.797815,
                                'manufacturer': 'Ubiquiti',
                                'model': 'LTU-Rocket',
                                'name': 'LTU-Rocket',
                                'sw_version': 'v2.0.5-BETA4',
                                'system_mac_address': 'fc:ec:da:77:ad:fb',
                                'uptime': '2049408'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'links': [       {       'mac_address': 'fc:ec:da:77:ad:fb'}],
                                                                       'mac_address': '18:e8:29:1f:0c:38',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frequency': 5830,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '881204',
                                                                                                                                                     'distance': 47,
                                                                                                                                                     'mac_address': 'fc:ec:da:77:ad:fb',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '160000000',
                                                                                                                                                     'tx_link_rate': '54400000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'VRFTintop'}]},
                                                               {       'id': 'eth0',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MWYwYzM4ZXRoMA=='}],
                                         'management_ip': '10.60.41.21',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'LTU-Lite',
                                         'name': 'Scotty Rice',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.5-BETA4',
                                         'system_mac_address': '18:e8:29:1f:0c:38'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5500,
                'rf_tx_power': 20,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 49.224808,
                'dl_en_bytes': 11082001324585,
                'dl_en_packets': 3890571239,
                'dl_rf_bytes': 11148489316131,
                'dl_rf_packets': 4119129829,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 495961471509,
                'ul_en_packets': 4190286705,
                'ul_rf_bytes': 624174196019,
                'ul_rf_packets': 188374381
        }
        exp_sta_stats = {
                '18:e8:29:08:e2:22': {       'alt_macs': ['18:e8:29:09:e2:22'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 72960000,
                                             'dl_rf_bytes': 16504906726,
                                             'dl_rf_packets': 67352911,
                                             'ip_address': '10.50.74.12',
                                             'mac_address': '18:e8:29:08:e2:22',
                                             'name': 'Woodson Bridge Estates Pump '
                                                     'House',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 23311660205,
                                             'ul_rf_packets': 70699189},
                '18:e8:29:08:e4:2f': {       'alt_macs': ['18:e8:29:09:e4:2f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 109440000,
                                             'dl_rf_bytes': 100302976795,
                                             'dl_rf_packets': 87972503,
                                             'ip_address': '10.50.74.18',
                                             'mac_address': '18:e8:29:08:e4:2f',
                                             'name': 'Susan and Jerry Bellamy',
                                             'ul_link_rate': 18718000,
                                             'ul_rf_bytes': 8145811044,
                                             'ul_rf_packets': 45078937},
                '18:e8:29:08:e4:7b': {       'alt_macs': ['18:e8:29:09:e4:7b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 145920000,
                                             'dl_rf_bytes': 41215667647,
                                             'dl_rf_packets': 59545969,
                                             'ip_address': '10.50.74.25',
                                             'mac_address': '18:e8:29:08:e4:7b',
                                             'name': 'Mimi and Carl Uhrmann',
                                             'ul_link_rate': 46796000,
                                             'ul_rf_bytes': 20883041657,
                                             'ul_rf_packets': 57857259},
                '18:e8:29:08:e9:84': {       'alt_macs': ['18:e8:29:09:e9:84'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 145920000,
                                             'dl_rf_bytes': 4227332529642,
                                             'dl_rf_packets': 3079428349,
                                             'ip_address': '10.50.74.21',
                                             'mac_address': '18:e8:29:08:e9:84',
                                             'name': 'Gail and Howard Hedlund',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 188951461742,
                                             'ul_rf_packets': 1540490066}
        }
        exp_ne_msg = {
                'data': {       'cpu': 49.224808,
                                'elevation': 80.5,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '11082001324585',
                                                              'in_ucast_pkts': '3890571239',
                                                              'mac_address': 'e6:63:da:0f:8c:d2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '495961471509',
                                                              'out_ucast_pkts': '4190286705',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '624174196019',
                                                              'in_ucast_pkts': '188374381',
                                                              'links': [       {       'in_octets': '188951461742',
                                                                                       'in_ucast_pkts': '1540490066',
                                                                                       'mac_address': '18:e8:29:08:e9:84',
                                                                                       'out_octets': '4227332529642',
                                                                                       'out_ucast_pkts': '3079428349'},
                                                                               {       'in_octets': '20883041657',
                                                                                       'in_ucast_pkts': '57857259',
                                                                                       'mac_address': '18:e8:29:08:e4:7b',
                                                                                       'out_octets': '41215667647',
                                                                                       'out_ucast_pkts': '59545969'},
                                                                               {       'in_octets': '23311660205',
                                                                                       'in_ucast_pkts': '70699189',
                                                                                       'mac_address': '18:e8:29:08:e2:22',
                                                                                       'out_octets': '16504906726',
                                                                                       'out_ucast_pkts': '67352911'},
                                                                               {       'in_octets': '8145811044',
                                                                                       'in_ucast_pkts': '45078937',
                                                                                       'mac_address': '18:e8:29:08:e4:2f',
                                                                                       'out_octets': '100302976795',
                                                                                       'out_ucast_pkts': '87972503'}],
                                                              'mac_address': 'e0:63:da:0f:8c:d2',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '11148489316131',
                                                              'out_ucast_pkts': '4119129829',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5500,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '30417000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '13617204',
                                                                                                                                            'distance': 442,
                                                                                                                                            'mac_address': '18:e8:29:08:e9:84',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -31.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 64.0,
                                                                                                                                            'tx_link_rate': '145920000'},
                                                                                                                                    {       'connected_time': '12355704',
                                                                                                                                            'distance': 388,
                                                                                                                                            'mac_address': '18:e8:29:08:e4:7b',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -34.0,
                                                                                                                                            'rx_link_rate': '46796000',
                                                                                                                                            'snr': 61.0,
                                                                                                                                            'tx_link_rate': '145920000'},
                                                                                                                                    {       'connected_time': '5000786',
                                                                                                                                            'distance': 201,
                                                                                                                                            'mac_address': '18:e8:29:08:e2:22',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -30.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '72960000'},
                                                                                                                                    {       'connected_time': '1878330',
                                                                                                                                            'distance': 335,
                                                                                                                                            'mac_address': '18:e8:29:08:e4:2f',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -28.0,
                                                                                                                                            'rx_link_rate': '18718000',
                                                                                                                                            'snr': 67.0,
                                                                                                                                            'tx_link_rate': '109440000'}],
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'tx_link_rate': '118560000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Zunter '
                                                                                                 'N '
                                                                                                 'LTU'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 39.908206,
                                'longitude': -122.095144,
                                'manufacturer': 'Ubiquiti',
                                'mem': 86.2192,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'e0:63:da:0f:8c:d2',
                                'temperature': 76.0,
                                'uptime': '28270039'},
                'peers': [       {       'cpu': 30.1615,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '4227332529642',
                                                                       'in_ucast_pkts': '3079428349',
                                                                       'links': [       {       'in_octets': '4227332529642',
                                                                                                'in_ucast_pkts': '3079428349',
                                                                                                'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                'out_octets': '188951461742',
                                                                                                'out_ucast_pkts': '1540490066'}],
                                                                       'mac_address': '18:e8:29:08:e9:84',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188951461742',
                                                                       'out_ucast_pkts': '1540490066',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5500,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '145920000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13617204',
                                                                                                                                                     'distance': 442,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '145920000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Zunter '
                                                                                                          'N '
                                                                                                          'LTU'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '188951461742',
                                                                       'in_ucast_pkts': '1540490066',
                                                                       'mac_address': '18:e8:29:09:e9:84',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4227332529642',
                                                                       'out_ucast_pkts': '3079428349',
                                                                       'speed': '100000000'}],
                                         'latitude': 39.910621,
                                         'longitude': -122.096342,
                                         'management_ip': '10.50.74.21',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.51571,
                                         'model': 'LTU-Lite',
                                         'name': 'Gail and Howard Hedlund',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:e9:84',
                                         'temperature': 61.0,
                                         'uptime': '13617951'},
                                 {       'cpu': 29.645,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '41215667647',
                                                                       'in_ucast_pkts': '59545969',
                                                                       'links': [       {       'in_octets': '41215667647',
                                                                                                'in_ucast_pkts': '59545969',
                                                                                                'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                'out_octets': '20883041657',
                                                                                                'out_ucast_pkts': '57857259'}],
                                                                       'mac_address': '18:e8:29:08:e4:7b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20883041657',
                                                                       'out_ucast_pkts': '57857259',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5500,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '145920000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '12355704',
                                                                                                                                                     'distance': 388,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '145920000',
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '46796000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '46796000',
                                                                                                 'tx_power': 15}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Zunter '
                                                                                                          'N '
                                                                                                          'LTU'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '20883041657',
                                                                       'in_ucast_pkts': '57857259',
                                                                       'mac_address': '18:e8:29:09:e4:7b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '41215667647',
                                                                       'out_ucast_pkts': '59545969',
                                                                       'speed': '100000000'}],
                                         'latitude': 39.910404,
                                         'longitude': -122.096278,
                                         'management_ip': '10.50.74.25',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.12497,
                                         'model': 'LTU-Lite',
                                         'name': 'Mimi and Carl Uhrmann',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:e4:7b',
                                         'temperature': 73.0,
                                         'uptime': '12356412'},
                                 {       'cpu': 32.5195,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '16504906726',
                                                                       'in_ucast_pkts': '67352911',
                                                                       'links': [       {       'in_octets': '16504906726',
                                                                                                'in_ucast_pkts': '67352911',
                                                                                                'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                'out_octets': '23311660205',
                                                                                                'out_ucast_pkts': '70699189'}],
                                                                       'mac_address': '18:e8:29:08:e2:22',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '23311660205',
                                                                       'out_ucast_pkts': '70699189',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5500,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '72960000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '5000786',
                                                                                                                                                     'distance': 201,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '72960000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Zunter '
                                                                                                          'N '
                                                                                                          'LTU'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '23311660205',
                                                                       'in_ucast_pkts': '70699189',
                                                                       'mac_address': '18:e8:29:09:e2:22',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16504906726',
                                                                       'out_ucast_pkts': '67352911',
                                                                       'speed': '100000000'}],
                                         'latitude': 39.909538,
                                         'longitude': -122.09668,
                                         'management_ip': '10.50.74.12',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.49149,
                                         'model': 'LTU-Lite',
                                         'name': 'Woodson Bridge Estates Pump House',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:e2:22',
                                         'temperature': 79.0,
                                         'uptime': '13618278'},
                                 {       'cpu': 38.0664,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '100302976795',
                                                                       'in_ucast_pkts': '87972503',
                                                                       'links': [       {       'in_octets': '100302976795',
                                                                                                'in_ucast_pkts': '87972503',
                                                                                                'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                'out_octets': '8145811044',
                                                                                                'out_ucast_pkts': '45078937'}],
                                                                       'mac_address': '18:e8:29:08:e4:2f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8145811044',
                                                                       'out_ucast_pkts': '45078937',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5500,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '109440000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1878330',
                                                                                                                                                     'distance': 335,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:8c:d2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '109440000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '18718000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '18718000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Zunter '
                                                                                                          'N '
                                                                                                          'LTU'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '8145811044',
                                                                       'in_ucast_pkts': '45078937',
                                                                       'mac_address': '18:e8:29:09:e4:2f',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '100302976795',
                                                                       'out_ucast_pkts': '87972503',
                                                                       'speed': '100000000'}],
                                         'latitude': 39.909813,
                                         'longitude': -122.096149,
                                         'management_ip': '10.50.74.18',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.3661,
                                         'model': 'LTU-Lite',
                                         'name': 'Susan and Jerry Bellamy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:e4:2f',
                                         'temperature': 76.0,
                                         'uptime': '1878335'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_02(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.02")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 30,
                'rf_freq': 5315,
                'rf_tx_power': 20,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 50.497017,
                'dl_en_bytes': 172763902917,
                'dl_en_packets': 130126519,
                'dl_rf_bytes': 173007687166,
                'dl_rf_packets': 131930634,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 9,
                'ul_en_bytes': 10878280899,
                'ul_en_packets': 52669709,
                'ul_rf_bytes': 11740147186,
                'ul_rf_packets': 54245109
        }
        exp_sta_stats = {
                'e0:63:da:0f:e2:82': {       'alt_macs': None,
                                             'dev_macs': {'cc:32:e5:64:83:2f'},
                                             'dl_link_rate': 272000000,
                                             'dl_rf_bytes': 103808901680,
                                             'dl_rf_packets': 74092148,
                                             'ip_address': '10.2.12.202',
                                             'mac_address': 'e0:63:da:0f:e2:82',
                                             'name': 'T2-AP4-A.Mahar',
                                             'ul_link_rate': 75200000,
                                             'ul_rf_bytes': 2907182284,
                                             'ul_rf_packets': 26281827},
                'f4:92:bf:5f:28:45': {       'alt_macs': None,
                                             'dev_macs': {'08:36:c9:8b:b9:46'},
                                             'dl_link_rate': 272000000,
                                             'dl_rf_bytes': 14243441890,
                                             'dl_rf_packets': 12430042,
                                             'ip_address': '10.2.12.201',
                                             'mac_address': 'f4:92:bf:5f:28:45',
                                             'name': 'T2-AP4-B&KO’Neil',
                                             'ul_link_rate': 75200000,
                                             'ul_rf_bytes': 1207787263,
                                             'ul_rf_packets': 5639978},
                'f4:92:bf:5f:28:62': {       'alt_macs': None,
                                             'dev_macs': {'b0:a7:b9:a5:6c:90'},
                                             'dl_link_rate': 272000000,
                                             'dl_rf_bytes': 16906189314,
                                             'dl_rf_packets': 13556981,
                                             'ip_address': '10.2.12.200',
                                             'mac_address': 'f4:92:bf:5f:28:62',
                                             'name': 'T2-AP4-M.Carey',
                                             'ul_link_rate': 75200000,
                                             'ul_rf_bytes': 977621079,
                                             'ul_rf_packets': 5671769},
                'f4:92:bf:5f:a8:24': {       'alt_macs': None,
                                             'dev_macs': {'b0:a7:b9:a5:b3:c0'},
                                             'dl_link_rate': 272000000,
                                             'dl_rf_bytes': 298653838,
                                             'dl_rf_packets': 1631629,
                                             'ip_address': '10.2.12.203',
                                             'mac_address': 'f4:92:bf:5f:a8:24',
                                             'name': 'T2-AP4-R.Lang',
                                             'ul_link_rate': 60160000,
                                             'ul_rf_bytes': 362822433,
                                             'ul_rf_packets': 637386},
                'f4:92:bf:5f:ab:8b': {       'alt_macs': None,
                                             'dev_macs': {'08:36:c9:92:50:b6'},
                                             'dl_link_rate': 272000000,
                                             'dl_rf_bytes': 38331943680,
                                             'dl_rf_packets': 34393672,
                                             'ip_address': '10.2.12.204',
                                             'mac_address': 'f4:92:bf:5f:ab:8b',
                                             'name': 'T2-AP4-C.Chavez',
                                             'ul_link_rate': 75200000,
                                             'ul_rf_bytes': 6289631587,
                                             'ul_rf_packets': 16044418}
        }
        exp_ne_msg = {
                'data': {       'cpu': 50.497017,
                                'elevation': 997.1,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '172763902917',
                                                              'in_ucast_pkts': '130126519',
                                                              'mac_address': 'f2:92:bf:2f:62:04',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '10878280899',
                                                              'out_ucast_pkts': '52669709',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '11740147186',
                                                              'in_ucast_pkts': '54245109',
                                                              'links': [       {       'in_octets': '977621079',
                                                                                       'in_ucast_pkts': '5671769',
                                                                                       'mac_address': 'f4:92:bf:5f:28:62',
                                                                                       'out_octets': '16906189314',
                                                                                       'out_ucast_pkts': '13556981'},
                                                                               {       'in_octets': '1207787263',
                                                                                       'in_ucast_pkts': '5639978',
                                                                                       'mac_address': 'f4:92:bf:5f:28:45',
                                                                                       'out_octets': '14243441890',
                                                                                       'out_ucast_pkts': '12430042'},
                                                                               {       'in_octets': '362822433',
                                                                                       'in_ucast_pkts': '637386',
                                                                                       'mac_address': 'f4:92:bf:5f:a8:24',
                                                                                       'out_octets': '298653838',
                                                                                       'out_ucast_pkts': '1631629'},
                                                                               {       'in_octets': '2907182284',
                                                                                       'in_ucast_pkts': '26281827',
                                                                                       'mac_address': 'e0:63:da:0f:e2:82',
                                                                                       'out_octets': '103808901680',
                                                                                       'out_ucast_pkts': '74092148'},
                                                                               {       'in_octets': '6289631587',
                                                                                       'in_ucast_pkts': '16044418',
                                                                                       'mac_address': 'f4:92:bf:5f:ab:8b',
                                                                                       'out_octets': '38331943680',
                                                                                       'out_ucast_pkts': '34393672'}],
                                                              'mac_address': 'f4:92:bf:2f:62:04',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '173007687166',
                                                              'out_ucast_pkts': '131930634',
                                                              'radios': [       {       'chan_width': 30,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5315,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '72192000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '206131',
                                                                                                                                            'distance': 2812,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:28:62',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -32.0,
                                                                                                                                            'rx_link_rate': '75200000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '272000000'},
                                                                                                                                    {       'connected_time': '206129',
                                                                                                                                            'distance': 3357,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:28:45',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -37.0,
                                                                                                                                            'rx_link_rate': '75200000',
                                                                                                                                            'snr': 53.0,
                                                                                                                                            'tx_link_rate': '272000000'},
                                                                                                                                    {       'connected_time': '206097',
                                                                                                                                            'distance': 3442,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:a8:24',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -34.0,
                                                                                                                                            'rx_link_rate': '60160000',
                                                                                                                                            'snr': 56.0,
                                                                                                                                            'tx_link_rate': '272000000'},
                                                                                                                                    {       'connected_time': '206081',
                                                                                                                                            'distance': 2866,
                                                                                                                                            'mac_address': 'e0:63:da:0f:e2:82',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -31.0,
                                                                                                                                            'rx_link_rate': '75200000',
                                                                                                                                            'snr': 59.0,
                                                                                                                                            'tx_link_rate': '272000000'},
                                                                                                                                    {       'connected_time': '206074',
                                                                                                                                            'distance': 3018,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:ab:8b',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -31.0,
                                                                                                                                            'rx_link_rate': '75200000',
                                                                                                                                            'snr': 59.0,
                                                                                                                                            'tx_link_rate': '272000000'}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_link_rate': '272000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW_T2_AP4'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.128371,
                                'longitude': -110.666687,
                                'manufacturer': 'Ubiquiti',
                                'mem': 84.242905,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'f4:92:bf:2f:62:04',
                                'temperature': 71.0,
                                'uptime': '206243'},
                'peers': [       {       'cpu': 33.9882,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '16906189314',
                                                                       'in_ucast_pkts': '13556981',
                                                                       'links': [       {       'in_octets': '16906189314',
                                                                                                'in_ucast_pkts': '13556981',
                                                                                                'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                'out_octets': '977621079',
                                                                                                'out_ucast_pkts': '5671769'}],
                                                                       'mac_address': 'f4:92:bf:5f:28:62',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '977621079',
                                                                       'out_ucast_pkts': '5671769',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5315,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '272000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '206131',
                                                                                                                                                     'distance': 2812,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                                                                     'noise_floor': -81.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '272000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '75200000'}],
                                                                                                                            'noise_floor': -81.0}],
                                                                                                 'tx_link_rate': '75200000',
                                                                                                 'tx_power': 17}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T2_AP4'}]},
                                                               {       'bridged_mac_addresses': [       'b0:a7:b9:a5:6c:90'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '977621079',
                                                                       'in_ucast_pkts': '5671769',
                                                                       'name': 'eth0',
                                                                       'out_octets': '16906189314',
                                                                       'out_ucast_pkts': '13556981',
                                                                       'poller_hash': 'ZjQ5MmJmNWYyODYyZXRoMA=='}],
                                         'latitude': 32.107976,
                                         'longitude': -110.683812,
                                         'management_ip': '10.2.12.200',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.81819,
                                         'model': 'LTU-LR',
                                         'name': 'T2-AP4-M.Carey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:28:62',
                                         'temperature': 70.0,
                                         'uptime': '206587'},
                                 {       'cpu': 33.6274,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '14243441890',
                                                                       'in_ucast_pkts': '12430042',
                                                                       'links': [       {       'in_octets': '14243441890',
                                                                                                'in_ucast_pkts': '12430042',
                                                                                                'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                'out_octets': '1207787263',
                                                                                                'out_ucast_pkts': '5639978'}],
                                                                       'mac_address': 'f4:92:bf:5f:28:45',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1207787263',
                                                                       'out_ucast_pkts': '5639978',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5315,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '272000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '206129',
                                                                                                                                                     'distance': 3357,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                                                                     'noise_floor': -81.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '272000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '75200000'}],
                                                                                                                            'noise_floor': -81.0}],
                                                                                                 'tx_link_rate': '75200000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T2_AP4'}]},
                                                               {       'bridged_mac_addresses': [       '08:36:c9:8b:b9:46'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '1207787263',
                                                                       'in_ucast_pkts': '5639978',
                                                                       'name': 'eth0',
                                                                       'out_octets': '14243441890',
                                                                       'out_ucast_pkts': '12430042',
                                                                       'poller_hash': 'ZjQ5MmJmNWYyODQ1ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '10.2.12.201',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.70517,
                                         'model': 'LTU-LR',
                                         'name': 'T2-AP4-B&KO’Neil',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:28:45',
                                         'temperature': 70.0,
                                         'uptime': '206584'},
                                 {       'cpu': 32.4913,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '298653838',
                                                                       'in_ucast_pkts': '1631629',
                                                                       'links': [       {       'in_octets': '298653838',
                                                                                                'in_ucast_pkts': '1631629',
                                                                                                'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                'out_octets': '362822433',
                                                                                                'out_ucast_pkts': '637386'}],
                                                                       'mac_address': 'f4:92:bf:5f:a8:24',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '362822433',
                                                                       'out_ucast_pkts': '637386',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5315,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '272000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '206097',
                                                                                                                                                     'distance': 3442,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                                                                     'noise_floor': -81.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '272000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '60160000'}],
                                                                                                                            'noise_floor': -81.0}],
                                                                                                 'tx_link_rate': '60160000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T2_AP4'}]},
                                                               {       'bridged_mac_addresses': [       'b0:a7:b9:a5:b3:c0'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '362822433',
                                                                       'in_ucast_pkts': '637386',
                                                                       'name': 'eth0',
                                                                       'out_octets': '298653838',
                                                                       'out_ucast_pkts': '1631629',
                                                                       'poller_hash': 'ZjQ5MmJmNWZhODI0ZXRoMA=='}],
                                         'latitude': 32.105627,
                                         'longitude': -110.689284,
                                         'management_ip': '10.2.12.203',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.72293,
                                         'model': 'LTU-LR',
                                         'name': 'T2-AP4-R.Lang',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:a8:24',
                                         'temperature': 82.0,
                                         'uptime': '206586'},
                                 {       'cpu': 41.5306,
                                         'elevation': 966.2,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '103808901680',
                                                                       'in_ucast_pkts': '74092148',
                                                                       'links': [       {       'in_octets': '103808901680',
                                                                                                'in_ucast_pkts': '74092148',
                                                                                                'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                'out_octets': '2907182284',
                                                                                                'out_ucast_pkts': '26281827'}],
                                                                       'mac_address': 'e0:63:da:0f:e2:82',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2907182284',
                                                                       'out_ucast_pkts': '26281827',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5315,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '272000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '206081',
                                                                                                                                                     'distance': 2866,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                                                                     'noise_floor': -81.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '272000000',
                                                                                                                                                     'snr': 21.0,
                                                                                                                                                     'tx_link_rate': '75200000'}],
                                                                                                                            'noise_floor': -81.0}],
                                                                                                 'tx_link_rate': '75200000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T2_AP4'}]},
                                                               {       'bridged_mac_addresses': [       'cc:32:e5:64:83:2f'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '2907182284',
                                                                       'in_ucast_pkts': '26281827',
                                                                       'name': 'eth0',
                                                                       'out_octets': '103808901680',
                                                                       'out_ucast_pkts': '74092148',
                                                                       'poller_hash': 'ZTA2M2RhMGZlMjgyZXRoMA=='}],
                                         'latitude': 32.108276,
                                         'longitude': -110.684124,
                                         'management_ip': '10.2.12.202',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.7633,
                                         'model': 'LTU-Pro',
                                         'name': 'T2-AP4-A.Mahar',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:0f:e2:82',
                                         'temperature': 81.0,
                                         'uptime': '206585'},
                                 {       'cpu': 33.0835,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '38331943680',
                                                                       'in_ucast_pkts': '34393672',
                                                                       'links': [       {       'in_octets': '38331943680',
                                                                                                'in_ucast_pkts': '34393672',
                                                                                                'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                'out_octets': '6289631587',
                                                                                                'out_ucast_pkts': '16044418'}],
                                                                       'mac_address': 'f4:92:bf:5f:ab:8b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6289631587',
                                                                       'out_ucast_pkts': '16044418',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5315,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '272000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '206074',
                                                                                                                                                     'distance': 3018,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:62:04',
                                                                                                                                                     'noise_floor': -81.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '272000000',
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '75200000'}],
                                                                                                                            'noise_floor': -81.0}],
                                                                                                 'tx_link_rate': '75200000',
                                                                                                 'tx_power': 17}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T2_AP4'}]},
                                                               {       'bridged_mac_addresses': [       '08:36:c9:92:50:b6'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '6289631587',
                                                                       'in_ucast_pkts': '16044418',
                                                                       'name': 'eth0',
                                                                       'out_octets': '38331943680',
                                                                       'out_ucast_pkts': '34393672',
                                                                       'poller_hash': 'ZjQ5MmJmNWZhYjhiZXRoMA=='}],
                                         'latitude': 32.109962,
                                         'longitude': -110.68903,
                                         'management_ip': '10.2.12.204',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 82.96251,
                                         'model': 'LTU-LR',
                                         'name': 'T2-AP4-C.Chavez',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:ab:8b',
                                         'temperature': 82.0,
                                         'uptime': '206583'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_03(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.03")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 30,
                'rf_freq': 5335,
                'rf_tx_power': 20,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 57.388664,
                'dl_en_bytes': 72281040764,
                'dl_en_packets': 58188745,
                'dl_rf_bytes': 72331750193,
                'dl_rf_packets': 58619878,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 7582950405,
                'ul_en_packets': 25084437,
                'ul_rf_bytes': 7589932188,
                'ul_rf_packets': 25354538
        }
        exp_sta_stats = {
                'e0:63:da:0f:af:66': {       'alt_macs': None,
                                             'dev_macs': {'b0:a7:b9:a5:93:2c'},
                                             'dl_link_rate': 142080000,
                                             'dl_rf_bytes': 76907304116,
                                             'dl_rf_packets': 58173119,
                                             'ip_address': '10.9.12.46',
                                             'mac_address': 'e0:63:da:0f:af:66',
                                             'name': 'T9-AP3.T.Smith',
                                             'ul_link_rate': 41438000,
                                             'ul_rf_bytes': 3237376244,
                                             'ul_rf_packets': 15014082},
                'f4:92:bf:5f:27:e8': {       'alt_macs': None,
                                             'dev_macs': {'bc:ae:c5:eb:2a:c1'},
                                             'dl_link_rate': 236800000,
                                             'dl_rf_bytes': 19581554298,
                                             'dl_rf_packets': 21579483,
                                             'ip_address': '10.9.12.45',
                                             'mac_address': 'f4:92:bf:5f:27:e8',
                                             'name': 'T9-AP3-J.Buell',
                                             'ul_link_rate': 103596000,
                                             'ul_rf_bytes': 2263811346,
                                             'ul_rf_packets': 10360241},
                'f4:92:bf:5f:28:27': {       'alt_macs': None,
                                             'dev_macs': {'ac:ec:85:3e:73:80'},
                                             'dl_link_rate': 236800000,
                                             'dl_rf_bytes': 31534445833,
                                             'dl_rf_packets': 23765342,
                                             'ip_address': '10.9.12.42',
                                             'mac_address': 'f4:92:bf:5f:28:27',
                                             'name': 'T9-AP3-J.Weber',
                                             'ul_link_rate': 103596000,
                                             'ul_rf_bytes': 4467964350,
                                             'ul_rf_packets': 12029490}
        }
        exp_ne_msg = {
                'data': {       'cpu': 57.388664,
                                'elevation': 1051.8,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '72281040764',
                                                              'in_ucast_pkts': '58188745',
                                                              'mac_address': 'f2:92:bf:2f:0d:5e',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '7582950405',
                                                              'out_ucast_pkts': '25084437',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '7589932188',
                                                              'in_ucast_pkts': '25354538',
                                                              'links': [       {       'in_octets': '3237376244',
                                                                                       'in_ucast_pkts': '15014082',
                                                                                       'mac_address': 'e0:63:da:0f:af:66',
                                                                                       'out_octets': '76907304116',
                                                                                       'out_ucast_pkts': '58173119'},
                                                                               {       'in_octets': '4467964350',
                                                                                       'in_ucast_pkts': '12029490',
                                                                                       'mac_address': 'f4:92:bf:5f:28:27',
                                                                                       'out_octets': '31534445833',
                                                                                       'out_ucast_pkts': '23765342'},
                                                                               {       'in_octets': '2263811346',
                                                                                       'in_ucast_pkts': '10360241',
                                                                                       'mac_address': 'f4:92:bf:5f:27:e8',
                                                                                       'out_octets': '19581554298',
                                                                                       'out_ucast_pkts': '21579483'}],
                                                              'mac_address': 'f4:92:bf:2f:0d:5e',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '72331750193',
                                                              'out_ucast_pkts': '58619878',
                                                              'radios': [       {       'chan_width': 30,
                                                                                        'dl_percent': 67,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5335,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '82876000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '110511',
                                                                                                                                            'distance': 3424,
                                                                                                                                            'mac_address': 'e0:63:da:0f:af:66',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -19.0,
                                                                                                                                            'rx_link_rate': '41438000',
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '142080000'},
                                                                                                                                    {       'connected_time': '110435',
                                                                                                                                            'distance': 1620,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:28:27',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -33.0,
                                                                                                                                            'rx_link_rate': '103596000',
                                                                                                                                            'snr': 51.0,
                                                                                                                                            'tx_link_rate': '236800000'},
                                                                                                                                    {       'connected_time': '105412',
                                                                                                                                            'distance': 4192,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:27:e8',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '103596000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '236800000'}],
                                                                                                                   'noise_floor': -84.0}],
                                                                                        'tx_link_rate': '205226000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW_T9_AP3'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 31.954154,
                                'longitude': -110.770203,
                                'manufacturer': 'Ubiquiti',
                                'mem': 84.100815,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'f4:92:bf:2f:0d:5e',
                                'temperature': 73.0,
                                'uptime': '110671'},
                'peers': [       {       'cpu': 33.6703,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '76907304116',
                                                                       'in_ucast_pkts': '58173119',
                                                                       'links': [       {       'in_octets': '76907304116',
                                                                                                'in_ucast_pkts': '58173119',
                                                                                                'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                'out_octets': '3237376244',
                                                                                                'out_ucast_pkts': '15014082'}],
                                                                       'mac_address': 'e0:63:da:0f:af:66',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3237376244',
                                                                       'out_ucast_pkts': '15014082',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5335,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '142080000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '110511',
                                                                                                                                                     'distance': 3424,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                                                                     'noise_floor': -74.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '142080000',
                                                                                                                                                     'snr': 15.0,
                                                                                                                                                     'tx_link_rate': '41438000'}],
                                                                                                                            'noise_floor': -74.0}],
                                                                                                 'tx_link_rate': '41438000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T9_AP3'}]},
                                                               {       'bridged_mac_addresses': [       'b0:a7:b9:a5:93:2c'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '3237376244',
                                                                       'in_ucast_pkts': '15014082',
                                                                       'name': 'eth0',
                                                                       'out_octets': '76907304116',
                                                                       'out_ucast_pkts': '58173119',
                                                                       'poller_hash': 'ZTA2M2RhMGZhZjY2ZXRoMA=='}],
                                         'latitude': 31.934124,
                                         'longitude': -110.781042,
                                         'management_ip': '10.9.12.46',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 85.88982,
                                         'model': 'LTU-Lite',
                                         'name': 'T9-AP3.T.Smith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:0f:af:66',
                                         'temperature': 79.0,
                                         'uptime': '209073'},
                                 {       'cpu': 33.6274,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '31534445833',
                                                                       'in_ucast_pkts': '23765342',
                                                                       'links': [       {       'in_octets': '31534445833',
                                                                                                'in_ucast_pkts': '23765342',
                                                                                                'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                'out_octets': '4467964350',
                                                                                                'out_ucast_pkts': '12029490'}],
                                                                       'mac_address': 'f4:92:bf:5f:28:27',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4467964350',
                                                                       'out_ucast_pkts': '12029490',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5335,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '236800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '110435',
                                                                                                                                                     'distance': 1620,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                                                                     'noise_floor': -74.0,
                                                                                                                                                     'rssi': -45.0,
                                                                                                                                                     'rx_link_rate': '236800000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '103596000'}],
                                                                                                                            'noise_floor': -74.0}],
                                                                                                 'tx_link_rate': '103596000',
                                                                                                 'tx_power': 16}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T9_AP3'}]},
                                                               {       'bridged_mac_addresses': [       'ac:ec:85:3e:73:80'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '4467964350',
                                                                       'in_ucast_pkts': '12029490',
                                                                       'name': 'eth0',
                                                                       'out_octets': '31534445833',
                                                                       'out_ucast_pkts': '23765342',
                                                                       'poller_hash': 'ZjQ5MmJmNWYyODI3ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '10.9.12.42',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.634155,
                                         'model': 'LTU-LR',
                                         'name': 'T9-AP3-J.Weber',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:28:27',
                                         'temperature': 77.0,
                                         'uptime': '110460'},
                                 {       'cpu': 38.2324,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '19581554298',
                                                                       'in_ucast_pkts': '21579483',
                                                                       'links': [       {       'in_octets': '19581554298',
                                                                                                'in_ucast_pkts': '21579483',
                                                                                                'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                'out_octets': '2263811346',
                                                                                                'out_ucast_pkts': '10360241'}],
                                                                       'mac_address': 'f4:92:bf:5f:27:e8',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2263811346',
                                                                       'out_ucast_pkts': '10360241',
                                                                       'radios': [       {       'chan_width': 30,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5335,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '236800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '105412',
                                                                                                                                                     'distance': 4192,
                                                                                                                                                     'mac_address': 'f4:92:bf:2f:0d:5e',
                                                                                                                                                     'noise_floor': -74.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '236800000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '103596000'}],
                                                                                                                            'noise_floor': -74.0}],
                                                                                                 'tx_link_rate': '103596000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T9_AP3'}]},
                                                               {       'bridged_mac_addresses': [       'bc:ae:c5:eb:2a:c1'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '2263811346',
                                                                       'in_ucast_pkts': '10360241',
                                                                       'name': 'eth0',
                                                                       'out_octets': '19581554298',
                                                                       'out_ucast_pkts': '21579483',
                                                                       'poller_hash': 'ZjQ5MmJmNWYyN2U4ZXRoMA=='}],
                                         'latitude': 31.925345,
                                         'longitude': -110.742717,
                                         'management_ip': '10.9.12.45',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 85.92211,
                                         'model': 'LTU-LR',
                                         'name': 'T9-AP3-J.Buell',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:27:e8',
                                         'temperature': 68.0,
                                         'uptime': '200630'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_04(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.04")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 40,
                'rf_freq': 5780,
                'rf_tx_power': 19,
                'sta_count': 9,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 62.066044,
                'dl_en_bytes': 151197353816,
                'dl_en_packets': 124157984,
                'dl_rf_bytes': 151217741961,
                'dl_rf_packets': 125817246,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 21669928103,
                'ul_en_packets': 65446310,
                'ul_rf_bytes': 22598596836,
                'ul_rf_packets': 67271413
        }
        exp_sta_stats = {
                '18:e8:29:08:f9:de': {       'alt_macs': ['18:e8:29:09:f9:de'],
                                             'dev_macs': {'dc:ef:09:14:99:99'},
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 7532935396,
                                             'dl_rf_packets': 9205515,
                                             'ip_address': '172.16.65.59',
                                             'mac_address': '18:e8:29:08:f9:de',
                                             'name': 'T6-AP1-A.Gallardo',
                                             'ul_link_rate': 85198000,
                                             'ul_rf_bytes': 1611652568,
                                             'ul_rf_packets': 4532962},
                '18:e8:29:1f:a0:a5': {       'alt_macs': None,
                                             'dev_macs': {'9c:c9:eb:0a:42:21'},
                                             'dl_link_rate': 64000000,
                                             'dl_rf_bytes': 26203909829,
                                             'dl_rf_packets': 21492195,
                                             'ip_address': '172.16.65.52',
                                             'mac_address': '18:e8:29:1f:a0:a5',
                                             'name': 'T6-AP1-J.Kahle',
                                             'ul_link_rate': 113597000,
                                             'ul_rf_bytes': 4137320744,
                                             'ul_rf_packets': 8446969},
                '18:e8:29:1f:a0:a7': {       'alt_macs': None,
                                             'dev_macs': {'bc:a5:11:3b:1c:ee'},
                                             'dl_link_rate': 128000000,
                                             'dl_rf_bytes': 147714178918,
                                             'dl_rf_packets': 118455790,
                                             'ip_address': '172.16.65.53',
                                             'mac_address': '18:e8:29:1f:a0:a7',
                                             'name': 'T6-AP1-B.Slosson',
                                             'ul_link_rate': 141996000,
                                             'ul_rf_bytes': 7788985027,
                                             'ul_rf_packets': 41683501},
                '18:e8:29:1f:aa:35': {       'alt_macs': None,
                                             'dev_macs': {'bc:a5:11:3a:87:60'},
                                             'dl_link_rate': 128000000,
                                             'dl_rf_bytes': 25360244690,
                                             'dl_rf_packets': 20091387,
                                             'ip_address': '172.16.65.57',
                                             'mac_address': '18:e8:29:1f:aa:35',
                                             'name': 'T6-AP1-L.Rogers',
                                             'ul_link_rate': 113597000,
                                             'ul_rf_bytes': 1665847892,
                                             'ul_rf_packets': 9918354},
                '18:e8:29:1f:c2:cb': {       'alt_macs': None,
                                             'dev_macs': {'18:e8:29:40:fb:81'},
                                             'dl_link_rate': 128000000,
                                             'dl_rf_bytes': 27205072620,
                                             'dl_rf_packets': 22428392,
                                             'ip_address': '172.16.65.56',
                                             'mac_address': '18:e8:29:1f:c2:cb',
                                             'name': 'T6-AP1-D.Ward',
                                             'ul_link_rate': 141996000,
                                             'ul_rf_bytes': 2710638322,
                                             'ul_rf_packets': 10469846},
                '18:e8:29:1f:c3:33': {       'alt_macs': None,
                                             'dev_macs': {'a0:63:91:31:db:0d'},
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 30203246658,
                                             'dl_rf_packets': 28344463,
                                             'ip_address': '172.16.65.51',
                                             'mac_address': '18:e8:29:1f:c3:33',
                                             'name': 'T6-AP1-D.Smith',
                                             'ul_link_rate': 141996000,
                                             'ul_rf_bytes': 6169512868,
                                             'ul_rf_packets': 17329280},
                '18:e8:29:1f:c3:3b': {       'alt_macs': None,
                                             'dev_macs': {       '00:51:ed:4e:ad:69',
                                                                 '0c:1c:57:aa:4a:93',
                                                                 '0c:ae:7d:be:f2:6d',
                                                                 '10:0c:6b:26:8b:0d',
                                                                 '20:d7:78:b9:44:6b',
                                                                 '2c:ab:33:14:ae:b4',
                                                                 '30:45:11:6d:e5:9f',
                                                                 '3c:a3:08:c8:e3:84',
                                                                 '40:9f:38:29:ae:36',
                                                                 '44:00:49:8c:36:56',
                                                                 '4c:17:44:b6:b7:8a',
                                                                 '4c:17:44:ec:49:2c',
                                                                 '50:02:91:6c:ac:9f',
                                                                 '50:02:91:6d:2e:b6',
                                                                 '50:65:83:f7:34:81',
                                                                 '50:65:83:fe:db:0d',
                                                                 '54:e0:19:01:d0:a7',
                                                                 '54:e0:19:02:e0:84',
                                                                 '54:e0:19:03:ae:16',
                                                                 '54:e0:19:06:1c:dc',
                                                                 '54:e0:19:35:57:8a',
                                                                 '60:6d:3c:02:af:22',
                                                                 '64:16:66:a5:df:c5',
                                                                 '64:16:7f:40:61:e1',
                                                                 '64:52:99:d9:4b:ae',
                                                                 '70:56:81:d1:c8:e1',
                                                                 '78:db:2f:e5:bc:17',
                                                                 '78:db:2f:e5:c3:d1',
                                                                 '78:db:2f:e5:db:0b',
                                                                 '78:db:2f:e5:dd:cb',
                                                                 '8c:aa:b5:c6:70:c9',
                                                                 '8c:ae:4c:e3:1b:eb',
                                                                 '9c:76:13:13:5f:34',
                                                                 '9c:76:13:13:61:4a',
                                                                 '9c:76:13:13:62:53',
                                                                 '9c:ad:ef:64:ef:d0',
                                                                 '9c:c9:eb:e3:14:1a',
                                                                 '9c:c9:eb:e3:21:0d',
                                                                 '9e:c9:eb:e3:14:1a',
                                                                 '9e:c9:eb:e3:21:0d',
                                                                 'a8:10:87:6b:20:f3',
                                                                 'ac:04:0b:71:af:f6',
                                                                 'b0:09:da:2f:7b:a1',
                                                                 'c8:2b:96:00:d7:58',
                                                                 'cc:04:b4:0b:1f:75',
                                                                 'cc:a7:c1:31:62:36',
                                                                 'f4:5e:ab:2e:d5:23'},
                                             'dl_link_rate': 128000000,
                                             'dl_rf_bytes': 21745156686,
                                             'dl_rf_packets': 24447251,
                                             'ip_address': '172.16.65.54',
                                             'mac_address': '18:e8:29:1f:c3:3b',
                                             'name': 'T6-AP1-E.Slay',
                                             'ul_link_rate': 141996000,
                                             'ul_rf_bytes': 12628997957,
                                             'ul_rf_packets': 22555348},
                '18:e8:29:1f:c4:6b': {       'alt_macs': None,
                                             'dev_macs': {'c4:41:1e:6d:22:34'},
                                             'dl_link_rate': 256000000,
                                             'dl_rf_bytes': 43685772076,
                                             'dl_rf_packets': 32604614,
                                             'ip_address': '172.16.65.58',
                                             'mac_address': '18:e8:29:1f:c4:6b',
                                             'name': 'T6-AP1-M.Accetta',
                                             'ul_link_rate': 113597000,
                                             'ul_rf_bytes': 1913726848,
                                             'ul_rf_packets': 10100079},
                '18:e8:29:1f:f2:ea': {       'alt_macs': None,
                                             'dev_macs': {'10:0c:6b:f6:38:9d'},
                                             'dl_link_rate': 192000000,
                                             'dl_rf_bytes': 299829521533,
                                             'dl_rf_packets': 242407267,
                                             'ip_address': '172.16.65.55',
                                             'mac_address': '18:e8:29:1f:f2:ea',
                                             'name': 'T6-AP1-A.Cook',
                                             'ul_link_rate': 141996000,
                                             'ul_rf_bytes': 26137427404,
                                             'ul_rf_packets': 118399842}
        }
        exp_ne_msg = {
                'data': {       'cpu': 62.066044,
                                'elevation': 1069.7,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '151197353816',
                                                              'in_ucast_pkts': '124157984',
                                                              'mac_address': 'e6:63:da:0f:53:a8',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '21669928103',
                                                              'out_ucast_pkts': '65446310',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '22598596836',
                                                              'in_ucast_pkts': '67271413',
                                                              'links': [       {       'in_octets': '12628997957',
                                                                                       'in_ucast_pkts': '22555348',
                                                                                       'mac_address': '18:e8:29:1f:c3:3b',
                                                                                       'out_octets': '21745156686',
                                                                                       'out_ucast_pkts': '24447251'},
                                                                               {       'in_octets': '26137427404',
                                                                                       'in_ucast_pkts': '118399842',
                                                                                       'mac_address': '18:e8:29:1f:f2:ea',
                                                                                       'out_octets': '299829521533',
                                                                                       'out_ucast_pkts': '242407267'},
                                                                               {       'in_octets': '1913726848',
                                                                                       'in_ucast_pkts': '10100079',
                                                                                       'mac_address': '18:e8:29:1f:c4:6b',
                                                                                       'out_octets': '43685772076',
                                                                                       'out_ucast_pkts': '32604614'},
                                                                               {       'in_octets': '1665847892',
                                                                                       'in_ucast_pkts': '9918354',
                                                                                       'mac_address': '18:e8:29:1f:aa:35',
                                                                                       'out_octets': '25360244690',
                                                                                       'out_ucast_pkts': '20091387'},
                                                                               {       'in_octets': '2710638322',
                                                                                       'in_ucast_pkts': '10469846',
                                                                                       'mac_address': '18:e8:29:1f:c2:cb',
                                                                                       'out_octets': '27205072620',
                                                                                       'out_ucast_pkts': '22428392'},
                                                                               {       'in_octets': '4137320744',
                                                                                       'in_ucast_pkts': '8446969',
                                                                                       'mac_address': '18:e8:29:1f:a0:a5',
                                                                                       'out_octets': '26203909829',
                                                                                       'out_ucast_pkts': '21492195'},
                                                                               {       'in_octets': '6169512868',
                                                                                       'in_ucast_pkts': '17329280',
                                                                                       'mac_address': '18:e8:29:1f:c3:33',
                                                                                       'out_octets': '30203246658',
                                                                                       'out_ucast_pkts': '28344463'},
                                                                               {       'in_octets': '7788985027',
                                                                                       'in_ucast_pkts': '41683501',
                                                                                       'mac_address': '18:e8:29:1f:a0:a7',
                                                                                       'out_octets': '147714178918',
                                                                                       'out_ucast_pkts': '118455790'},
                                                                               {       'in_octets': '1611652568',
                                                                                       'in_ucast_pkts': '4532962',
                                                                                       'mac_address': '18:e8:29:08:f9:de',
                                                                                       'out_octets': '7532935396',
                                                                                       'out_ucast_pkts': '9205515'}],
                                                              'mac_address': 'e0:63:da:0f:53:a8',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '151217741961',
                                                              'out_ucast_pkts': '125817246',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 67,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5780,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '126218000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '123071',
                                                                                                                                            'distance': 820,
                                                                                                                                            'mac_address': '18:e8:29:1f:c3:3b',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '141996000',
                                                                                                                                            'snr': 53.0,
                                                                                                                                            'tx_link_rate': '128000000'},
                                                                                                                                    {       'connected_time': '123071',
                                                                                                                                            'distance': 656,
                                                                                                                                            'mac_address': '18:e8:29:1f:f2:ea',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -32.0,
                                                                                                                                            'rx_link_rate': '141996000',
                                                                                                                                            'snr': 47.0,
                                                                                                                                            'tx_link_rate': '192000000'},
                                                                                                                                    {       'connected_time': '123070',
                                                                                                                                            'distance': 787,
                                                                                                                                            'mac_address': '18:e8:29:1f:c4:6b',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -27.0,
                                                                                                                                            'rx_link_rate': '113597000',
                                                                                                                                            'snr': 52.0,
                                                                                                                                            'tx_link_rate': '256000000'},
                                                                                                                                    {       'connected_time': '123070',
                                                                                                                                            'distance': 515,
                                                                                                                                            'mac_address': '18:e8:29:1f:aa:35',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -19.0,
                                                                                                                                            'rx_link_rate': '113597000',
                                                                                                                                            'snr': 60.0,
                                                                                                                                            'tx_link_rate': '128000000'},
                                                                                                                                    {       'connected_time': '123070',
                                                                                                                                            'distance': 763,
                                                                                                                                            'mac_address': '18:e8:29:1f:c2:cb',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '141996000',
                                                                                                                                            'snr': 53.0,
                                                                                                                                            'tx_link_rate': '128000000'},
                                                                                                                                    {       'connected_time': '123069',
                                                                                                                                            'distance': 629,
                                                                                                                                            'mac_address': '18:e8:29:1f:a0:a5',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -15.0,
                                                                                                                                            'rx_link_rate': '113597000',
                                                                                                                                            'snr': 64.0,
                                                                                                                                            'tx_link_rate': '64000000'},
                                                                                                                                    {       'connected_time': '123068',
                                                                                                                                            'distance': 777,
                                                                                                                                            'mac_address': '18:e8:29:1f:c3:33',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -27.0,
                                                                                                                                            'rx_link_rate': '141996000',
                                                                                                                                            'snr': 52.0,
                                                                                                                                            'tx_link_rate': '192000000'},
                                                                                                                                    {       'connected_time': '123013',
                                                                                                                                            'distance': 726,
                                                                                                                                            'mac_address': '18:e8:29:1f:a0:a7',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -21.0,
                                                                                                                                            'rx_link_rate': '141996000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '128000000'},
                                                                                                                                    {       'connected_time': '122975',
                                                                                                                                            'distance': 666,
                                                                                                                                            'mac_address': '18:e8:29:08:f9:de',
                                                                                                                                            'noise_floor': -79.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '85198000',
                                                                                                                                            'snr': 57.0,
                                                                                                                                            'tx_link_rate': '192000000'}],
                                                                                                                   'noise_floor': -79.0}],
                                                                                        'tx_link_rate': '156444000',
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW_T6_AP1'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.004522,
                                'longitude': -110.684437,
                                'manufacturer': 'Ubiquiti',
                                'mem': 84.57067,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'e0:63:da:0f:53:a8',
                                'temperature': 73.0,
                                'uptime': '123102'},
                'peers': [       {       'cpu': 46.1622,
                                         'elevation': 1083.9,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '21745156686',
                                                                       'in_ucast_pkts': '24447251',
                                                                       'links': [       {       'in_octets': '21745156686',
                                                                                                'in_ucast_pkts': '24447251',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '12628997957',
                                                                                                'out_ucast_pkts': '22555348'}],
                                                                       'mac_address': '18:e8:29:1f:c3:3b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12628997957',
                                                                       'out_ucast_pkts': '22555348',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '128000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123071',
                                                                                                                                                     'distance': 820,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '128000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '141996000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '141996000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       '00:51:ed:4e:ad:69',
                                                                                                        '0c:1c:57:aa:4a:93',
                                                                                                        '0c:ae:7d:be:f2:6d',
                                                                                                        '10:0c:6b:26:8b:0d',
                                                                                                        '20:d7:78:b9:44:6b',
                                                                                                        '2c:ab:33:14:ae:b4',
                                                                                                        '30:45:11:6d:e5:9f',
                                                                                                        '3c:a3:08:c8:e3:84',
                                                                                                        '40:9f:38:29:ae:36',
                                                                                                        '44:00:49:8c:36:56',
                                                                                                        '4c:17:44:b6:b7:8a',
                                                                                                        '4c:17:44:ec:49:2c',
                                                                                                        '50:02:91:6c:ac:9f',
                                                                                                        '50:02:91:6d:2e:b6',
                                                                                                        '50:65:83:f7:34:81',
                                                                                                        '50:65:83:fe:db:0d',
                                                                                                        '54:e0:19:01:d0:a7',
                                                                                                        '54:e0:19:02:e0:84',
                                                                                                        '54:e0:19:03:ae:16',
                                                                                                        '54:e0:19:06:1c:dc',
                                                                                                        '54:e0:19:35:57:8a',
                                                                                                        '60:6d:3c:02:af:22',
                                                                                                        '64:16:66:a5:df:c5',
                                                                                                        '64:16:7f:40:61:e1',
                                                                                                        '64:52:99:d9:4b:ae',
                                                                                                        '70:56:81:d1:c8:e1',
                                                                                                        '78:db:2f:e5:bc:17',
                                                                                                        '78:db:2f:e5:c3:d1',
                                                                                                        '78:db:2f:e5:db:0b',
                                                                                                        '78:db:2f:e5:dd:cb',
                                                                                                        '8c:aa:b5:c6:70:c9',
                                                                                                        '8c:ae:4c:e3:1b:eb',
                                                                                                        '9c:76:13:13:5f:34',
                                                                                                        '9c:76:13:13:61:4a',
                                                                                                        '9c:76:13:13:62:53',
                                                                                                        '9c:ad:ef:64:ef:d0',
                                                                                                        '9c:c9:eb:e3:14:1a',
                                                                                                        '9c:c9:eb:e3:21:0d',
                                                                                                        '9e:c9:eb:e3:14:1a',
                                                                                                        '9e:c9:eb:e3:21:0d',
                                                                                                        'a8:10:87:6b:20:f3',
                                                                                                        'ac:04:0b:71:af:f6',
                                                                                                        'b0:09:da:2f:7b:a1',
                                                                                                        'c8:2b:96:00:d7:58',
                                                                                                        'cc:04:b4:0b:1f:75',
                                                                                                        'cc:a7:c1:31:62:36',
                                                                                                        'f4:5e:ab:2e:d5:23'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '12628997957',
                                                                       'in_ucast_pkts': '22555348',
                                                                       'name': 'eth0',
                                                                       'out_octets': '21745156686',
                                                                       'out_ucast_pkts': '24447251',
                                                                       'poller_hash': 'MThlODI5MWZjMzNiZXRoMA=='}],
                                         'latitude': 31.998039,
                                         'longitude': -110.681992,
                                         'management_ip': '172.16.65.54',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 87.87419,
                                         'model': 'LTU-Pro',
                                         'name': 'T6-AP1-E.Slay',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:c3:3b',
                                         'temperature': 74.0,
                                         'uptime': '207961'},
                                 {       'cpu': 32.0202,
                                         'elevation': 1076.1,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '299829521533',
                                                                       'in_ucast_pkts': '242407267',
                                                                       'links': [       {       'in_octets': '299829521533',
                                                                                                'in_ucast_pkts': '242407267',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '26137427404',
                                                                                                'out_ucast_pkts': '118399842'}],
                                                                       'mac_address': '18:e8:29:1f:f2:ea',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26137427404',
                                                                       'out_ucast_pkts': '118399842',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '192000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123071',
                                                                                                                                                     'distance': 656,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -43.0,
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'snr': 49.0,
                                                                                                                                                     'tx_link_rate': '141996000'}],
                                                                                                                            'noise_floor': -92.0}],
                                                                                                 'tx_link_rate': '141996000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:0c:6b:f6:38:9d'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '26137427404',
                                                                       'in_ucast_pkts': '118399842',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '299829521533',
                                                                       'out_ucast_pkts': '242407267',
                                                                       'poller_hash': 'MThlODI5MWZmMmVhZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 31.999271,
                                         'longitude': -110.685588,
                                         'management_ip': '172.16.65.55',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 97.74437,
                                         'model': 'LTU-Pro',
                                         'name': 'T6-AP1-A.Cook',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': '18:e8:29:1f:f2:ea',
                                         'temperature': 87.0,
                                         'uptime': '813109'},
                                 {       'cpu': 36.1251,
                                         'elevation': 1076.5,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '43685772076',
                                                                       'in_ucast_pkts': '32604614',
                                                                       'links': [       {       'in_octets': '43685772076',
                                                                                                'in_ucast_pkts': '32604614',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '1913726848',
                                                                                                'out_ucast_pkts': '10100079'}],
                                                                       'mac_address': '18:e8:29:1f:c4:6b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1913726848',
                                                                       'out_ucast_pkts': '10100079',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '256000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123070',
                                                                                                                                                     'distance': 787,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '256000000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '113597000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '113597000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       'c4:41:1e:6d:22:34'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '1913726848',
                                                                       'in_ucast_pkts': '10100079',
                                                                       'name': 'eth0',
                                                                       'out_octets': '43685772076',
                                                                       'out_ucast_pkts': '32604614',
                                                                       'poller_hash': 'MThlODI5MWZjNDZiZXRoMA=='}],
                                         'latitude': 31.998061,
                                         'longitude': -110.683933,
                                         'management_ip': '172.16.65.58',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.710014,
                                         'model': 'LTU-Pro',
                                         'name': 'T6-AP1-M.Accetta',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:c4:6b',
                                         'temperature': 72.0,
                                         'uptime': '207964'},
                                 {       'cpu': 37.5,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '25360244690',
                                                                       'in_ucast_pkts': '20091387',
                                                                       'links': [       {       'in_octets': '25360244690',
                                                                                                'in_ucast_pkts': '20091387',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '1665847892',
                                                                                                'out_ucast_pkts': '9918354'}],
                                                                       'mac_address': '18:e8:29:1f:aa:35',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1665847892',
                                                                       'out_ucast_pkts': '9918354',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '128000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123070',
                                                                                                                                                     'distance': 515,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '128000000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '113597000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '113597000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       'bc:a5:11:3a:87:60'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '1665847892',
                                                                       'in_ucast_pkts': '9918354',
                                                                       'name': 'eth0',
                                                                       'out_octets': '25360244690',
                                                                       'out_ucast_pkts': '20091387',
                                                                       'poller_hash': 'MThlODI5MWZhYTM1ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '172.16.65.57',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.70517,
                                         'model': 'LTU-Lite',
                                         'name': 'T6-AP1-L.Rogers',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:aa:35',
                                         'temperature': 80.0,
                                         'uptime': '207962'},
                                 {       'cpu': 39.9235,
                                         'elevation': 1081.3,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '27205072620',
                                                                       'in_ucast_pkts': '22428392',
                                                                       'links': [       {       'in_octets': '27205072620',
                                                                                                'in_ucast_pkts': '22428392',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '2710638322',
                                                                                                'out_ucast_pkts': '10469846'}],
                                                                       'mac_address': '18:e8:29:1f:c2:cb',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2710638322',
                                                                       'out_ucast_pkts': '10469846',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '128000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123070',
                                                                                                                                                     'distance': 763,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '128000000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '141996000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '141996000',
                                                                                                 'tx_power': 16}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       '18:e8:29:40:fb:81'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '2710638322',
                                                                       'in_ucast_pkts': '10469846',
                                                                       'name': 'eth0',
                                                                       'out_octets': '27205072620',
                                                                       'out_ucast_pkts': '22428392',
                                                                       'poller_hash': 'MThlODI5MWZjMmNiZXRoMA=='}],
                                         'latitude': 31.998487,
                                         'longitude': -110.682618,
                                         'management_ip': '172.16.65.56',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.31608,
                                         'model': 'LTU-Pro',
                                         'name': 'T6-AP1-D.Ward',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:c2:cb',
                                         'temperature': 68.0,
                                         'uptime': '207964'},
                                 {       'cpu': 43.4042,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '26203909829',
                                                                       'in_ucast_pkts': '21492195',
                                                                       'links': [       {       'in_octets': '26203909829',
                                                                                                'in_ucast_pkts': '21492195',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '4137320744',
                                                                                                'out_ucast_pkts': '8446969'}],
                                                                       'mac_address': '18:e8:29:1f:a0:a5',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4137320744',
                                                                       'out_ucast_pkts': '8446969',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '64000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123069',
                                                                                                                                                     'distance': 629,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '64000000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '113597000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '113597000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       '9c:c9:eb:0a:42:21'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '4137320744',
                                                                       'in_ucast_pkts': '8446969',
                                                                       'name': 'eth0',
                                                                       'out_octets': '26203909829',
                                                                       'out_ucast_pkts': '21492195',
                                                                       'poller_hash': 'MThlODI5MWZhMGE1ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '172.16.65.52',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.98773,
                                         'model': 'LTU-Lite',
                                         'name': 'T6-AP1-J.Kahle',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:a0:a5',
                                         'temperature': 77.0,
                                         'uptime': '207962'},
                                 {       'cpu': 33.187,
                                         'elevation': 1075.4,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '30203246658',
                                                                       'in_ucast_pkts': '28344463',
                                                                       'links': [       {       'in_octets': '30203246658',
                                                                                                'in_ucast_pkts': '28344463',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '6169512868',
                                                                                                'out_ucast_pkts': '17329280'}],
                                                                       'mac_address': '18:e8:29:1f:c3:33',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6169512868',
                                                                       'out_ucast_pkts': '17329280',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '192000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123068',
                                                                                                                                                     'distance': 777,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '141996000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '141996000',
                                                                                                 'tx_power': 16}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       'a0:63:91:31:db:0d'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '6169512868',
                                                                       'in_ucast_pkts': '17329280',
                                                                       'name': 'eth0',
                                                                       'out_octets': '30203246658',
                                                                       'out_ucast_pkts': '28344463',
                                                                       'poller_hash': 'MThlODI5MWZjMzMzZXRoMA=='}],
                                         'latitude': 31.998103,
                                         'longitude': -110.684403,
                                         'management_ip': '172.16.65.51',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.34191,
                                         'model': 'LTU-Pro',
                                         'name': 'T6-AP1-D.Smith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:c3:33',
                                         'temperature': 65.0,
                                         'uptime': '207926'},
                                 {       'cpu': 43.0184,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '147714178918',
                                                                       'in_ucast_pkts': '118455790',
                                                                       'links': [       {       'in_octets': '147714178918',
                                                                                                'in_ucast_pkts': '118455790',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '7788985027',
                                                                                                'out_ucast_pkts': '41683501'}],
                                                                       'mac_address': '18:e8:29:1f:a0:a7',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7788985027',
                                                                       'out_ucast_pkts': '41683501',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '128000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '123013',
                                                                                                                                                     'distance': 726,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '128000000',
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '141996000'}],
                                                                                                                            'noise_floor': -92.0}],
                                                                                                 'tx_link_rate': '141996000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'bc:a5:11:3b:1c:ee'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '7788985027',
                                                                       'in_ucast_pkts': '41683501',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '147714178918',
                                                                       'out_ucast_pkts': '118455790',
                                                                       'poller_hash': 'MThlODI5MWZhMGE3ZXRoMA==',
                                                                       'speed': '100000000'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '172.16.65.53',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 98.04792,
                                         'model': 'LTU-Lite',
                                         'name': 'T6-AP1-B.Slosson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': '18:e8:29:1f:a0:a7',
                                         'temperature': 78.0,
                                         'uptime': '813124'},
                                 {       'cpu': 35.6292,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '7532935396',
                                                                       'in_ucast_pkts': '9205515',
                                                                       'links': [       {       'in_octets': '7532935396',
                                                                                                'in_ucast_pkts': '9205515',
                                                                                                'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                'out_octets': '1611652568',
                                                                                                'out_ucast_pkts': '4532962'}],
                                                                       'mac_address': '18:e8:29:08:f9:de',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1611652568',
                                                                       'out_ucast_pkts': '4532962',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '192000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '122975',
                                                                                                                                                     'distance': 666,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:53:a8',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '192000000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '85198000'}],
                                                                                                                            'noise_floor': -63.0}],
                                                                                                 'tx_link_rate': '85198000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T6_AP1'}]},
                                                               {       'bridged_mac_addresses': [       'dc:ef:09:14:99:99'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '1611652568',
                                                                       'in_ucast_pkts': '4532962',
                                                                       'mac_address': '18:e8:29:09:f9:de',
                                                                       'name': 'eth0',
                                                                       'out_octets': '7532935396',
                                                                       'out_ucast_pkts': '9205515'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '172.16.65.59',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.62605,
                                         'model': 'LTU-Lite',
                                         'name': 'T6-AP1-A.Gallardo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:f9:de',
                                         'temperature': 84.0,
                                         'uptime': '207959'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_05(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.05")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5805,
                'rf_tx_power': 20,
                'sta_count': 7,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 60.385441,
                'dl_en_bytes': 7652342321461,
                'dl_en_packets': 1222808545,
                'dl_rf_bytes': 7588705351015,
                'dl_rf_packets': 1210864103,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 290910393795,
                'ul_en_packets': 2173791704,
                'ul_rf_bytes': 297333183386,
                'ul_rf_packets': 2199627275
        }
        exp_sta_stats = {
                'e0:63:da:bf:f9:52': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:a0:3d:c5'},
                                             'dl_link_rate': 143360000,
                                             'dl_rf_bytes': 76360666393,
                                             'dl_rf_packets': 60619656,
                                             'ip_address': '10.10.6.247',
                                             'mac_address': 'e0:63:da:bf:f9:52',
                                             'name': 'Madison-Cooke-4561-A',
                                             'ul_link_rate': 46796000,
                                             'ul_rf_bytes': 3464753871,
                                             'ul_rf_packets': 18987085},
                'e0:63:da:bf:f9:5f': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:a0:49:b8'},
                                             'dl_link_rate': 179200000,
                                             'dl_rf_bytes': 1017506513706,
                                             'dl_rf_packets': 715984425,
                                             'ip_address': '10.10.6.251',
                                             'mac_address': 'e0:63:da:bf:f9:5f',
                                             'name': 'Isaac-Brandon-4511',
                                             'ul_link_rate': 46796000,
                                             'ul_rf_bytes': 32878505829,
                                             'ul_rf_packets': 334519001},
                'e0:63:da:bf:fb:53': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:a0:30:49'},
                                             'dl_link_rate': 179200000,
                                             'dl_rf_bytes': 1065381184569,
                                             'dl_rf_packets': 763339880,
                                             'ip_address': '10.10.6.245',
                                             'mac_address': 'e0:63:da:bf:fb:53',
                                             'name': 'Dion-Brandon-4526',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 27175298197,
                                             'ul_rf_packets': 292694426},
                'e0:63:da:bf:ff:e7': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:91:43:f3'},
                                             'dl_link_rate': 179200000,
                                             'dl_rf_bytes': 72103417540,
                                             'dl_rf_packets': 57058015,
                                             'ip_address': '10.10.6.252',
                                             'mac_address': 'e0:63:da:bf:ff:e7',
                                             'name': 'jackie-mckee-4511',
                                             'ul_link_rate': 46796000,
                                             'ul_rf_bytes': 3635074814,
                                             'ul_rf_packets': 17032735},
                'f4:92:bf:1f:00:7f': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:a0:22:a9'},
                                             'dl_link_rate': 107520000,
                                             'dl_rf_bytes': 366638152959,
                                             'dl_rf_packets': 272001636,
                                             'ip_address': '10.10.6.249',
                                             'mac_address': 'f4:92:bf:1f:00:7f',
                                             'name': 'Teresa-Davis-4650',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 16870104731,
                                             'ul_rf_packets': 80153970},
                'f4:92:bf:1f:02:05': {       'alt_macs': None,
                                             'dev_macs': {'2c:c8:1b:a0:30:1b'},
                                             'dl_link_rate': 179200000,
                                             'dl_rf_bytes': 146575260437,
                                             'dl_rf_packets': 120426886,
                                             'ip_address': '10.10.6.248',
                                             'mac_address': 'f4:92:bf:1f:02:05',
                                             'name': 'Morgan-Brandon-4517',
                                             'ul_link_rate': 46796000,
                                             'ul_rf_bytes': 9366966055,
                                             'ul_rf_packets': 40725703},
                'f4:92:bf:1f:24:e3': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 143360000,
                                             'dl_rf_bytes': 418408423090,
                                             'dl_rf_packets': 313858776,
                                             'ip_address': '10.10.6.243',
                                             'mac_address': 'f4:92:bf:1f:24:e3',
                                             'name': 'Maggie-Clearsky-4638',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 10935121699,
                                             'ul_rf_packets': 96692051}
        }
        exp_ne_msg = {
                'data': {       'cpu': 60.38544,
                                'elevation': 621.3,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '7652342321461',
                                                              'in_ucast_pkts': '1222808545',
                                                              'mac_address': 'e6:63:da:bf:23:f9',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '290910393795',
                                                              'out_ucast_pkts': '2173791704',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '297333183386',
                                                              'in_ucast_pkts': '2199627275',
                                                              'links': [       {       'in_octets': '9366966055',
                                                                                       'in_ucast_pkts': '40725703',
                                                                                       'mac_address': 'f4:92:bf:1f:02:05',
                                                                                       'out_octets': '146575260437',
                                                                                       'out_ucast_pkts': '120426886'},
                                                                               {       'in_octets': '32878505829',
                                                                                       'in_ucast_pkts': '334519001',
                                                                                       'mac_address': 'e0:63:da:bf:f9:5f',
                                                                                       'out_octets': '1017506513706',
                                                                                       'out_ucast_pkts': '715984425'},
                                                                               {       'in_octets': '10935121699',
                                                                                       'in_ucast_pkts': '96692051',
                                                                                       'mac_address': 'f4:92:bf:1f:24:e3',
                                                                                       'out_octets': '418408423090',
                                                                                       'out_ucast_pkts': '313858776'},
                                                                               {       'in_octets': '27175298197',
                                                                                       'in_ucast_pkts': '292694426',
                                                                                       'mac_address': 'e0:63:da:bf:fb:53',
                                                                                       'out_octets': '1065381184569',
                                                                                       'out_ucast_pkts': '763339880'},
                                                                               {       'in_octets': '16870104731',
                                                                                       'in_ucast_pkts': '80153970',
                                                                                       'mac_address': 'f4:92:bf:1f:00:7f',
                                                                                       'out_octets': '366638152959',
                                                                                       'out_ucast_pkts': '272001636'},
                                                                               {       'in_octets': '3464753871',
                                                                                       'in_ucast_pkts': '18987085',
                                                                                       'mac_address': 'e0:63:da:bf:f9:52',
                                                                                       'out_octets': '76360666393',
                                                                                       'out_ucast_pkts': '60619656'},
                                                                               {       'in_octets': '3635074814',
                                                                                       'in_ucast_pkts': '17032735',
                                                                                       'mac_address': 'e0:63:da:bf:ff:e7',
                                                                                       'out_octets': '72103417540',
                                                                                       'out_ucast_pkts': '57058015'}],
                                                              'mac_address': 'e0:63:da:bf:23:f9',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '7588705351015',
                                                              'out_ucast_pkts': '1210864103',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5805,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '41448000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1483020',
                                                                                                                                            'distance': 435,
                                                                                                                                            'mac_address': 'f4:92:bf:1f:02:05',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -38.0,
                                                                                                                                            'rx_link_rate': '46796000',
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '179200000'},
                                                                                                                                    {       'connected_time': '1483016',
                                                                                                                                            'distance': 234,
                                                                                                                                            'mac_address': 'e0:63:da:bf:f9:5f',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -38.0,
                                                                                                                                            'rx_link_rate': '46796000',
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '179200000'},
                                                                                                                                    {       'connected_time': '1121310',
                                                                                                                                            'distance': 2136,
                                                                                                                                            'mac_address': 'f4:92:bf:1f:24:e3',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 66.0,
                                                                                                                                            'tx_link_rate': '143360000'},
                                                                                                                                    {       'connected_time': '944248',
                                                                                                                                            'distance': 971,
                                                                                                                                            'mac_address': 'e0:63:da:bf:fb:53',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -25.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 63.0,
                                                                                                                                            'tx_link_rate': '179200000'},
                                                                                                                                    {       'connected_time': '693861',
                                                                                                                                            'distance': 2330,
                                                                                                                                            'mac_address': 'f4:92:bf:1f:00:7f',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 66.0,
                                                                                                                                            'tx_link_rate': '107520000'},
                                                                                                                                    {       'connected_time': '610023',
                                                                                                                                            'distance': 1178,
                                                                                                                                            'mac_address': 'e0:63:da:bf:f9:52',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -24.0,
                                                                                                                                            'rx_link_rate': '46796000',
                                                                                                                                            'snr': 64.0,
                                                                                                                                            'tx_link_rate': '143360000'},
                                                                                                                                    {       'connected_time': '284051',
                                                                                                                                            'distance': 281,
                                                                                                                                            'mac_address': 'e0:63:da:bf:ff:e7',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '46796000',
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '179200000'}],
                                                                                                                   'noise_floor': -88.0}],
                                                                                        'tx_link_rate': '158720000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ans-nw-ap5n'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 50.709063,
                                'longitude': -100.972617,
                                'manufacturer': 'Ubiquiti',
                                'mem': 79.566956,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'e0:63:da:bf:23:f9',
                                'temperature': 49.0,
                                'uptime': '2176773'},
                'peers': [       {       'cpu': 48.2658,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '146575260437',
                                                                       'in_ucast_pkts': '120426886',
                                                                       'links': [       {       'in_octets': '146575260437',
                                                                                                'in_ucast_pkts': '120426886',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '9366966055',
                                                                                                'out_ucast_pkts': '40725703'}],
                                                                       'mac_address': 'f4:92:bf:1f:02:05',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9366966055',
                                                                       'out_ucast_pkts': '40725703',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '179200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1483020',
                                                                                                                                                     'distance': 435,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -36.0,
                                                                                                                                                     'rx_link_rate': '179200000',
                                                                                                                                                     'snr': 43.0,
                                                                                                                                                     'tx_link_rate': '46796000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '46796000',
                                                                                                 'tx_power': 8}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:a0:30:1b'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '9366966055',
                                                                       'in_ucast_pkts': '40725703',
                                                                       'name': 'eth0',
                                                                       'out_octets': '146575260437',
                                                                       'out_ucast_pkts': '120426886',
                                                                       'poller_hash': 'ZjQ5MmJmMWYwMjA1ZXRoMA=='}],
                                         'latitude': 50.7116,
                                         'longitude': -100.973196,
                                         'management_ip': '10.10.6.248',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 87.02651,
                                         'model': 'LTU-LR',
                                         'name': 'Morgan-Brandon-4517',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:1f:02:05',
                                         'temperature': 45.0,
                                         'uptime': '1483054'},
                                 {       'cpu': 39.37,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1017506513706',
                                                                       'in_ucast_pkts': '715984425',
                                                                       'links': [       {       'in_octets': '1017506513706',
                                                                                                'in_ucast_pkts': '715984425',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '32878505829',
                                                                                                'out_ucast_pkts': '334519001'}],
                                                                       'mac_address': 'e0:63:da:bf:f9:5f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '32878505829',
                                                                       'out_ucast_pkts': '334519001',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '179200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1483016',
                                                                                                                                                     'distance': 234,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -35.0,
                                                                                                                                                     'rx_link_rate': '179200000',
                                                                                                                                                     'snr': 44.0,
                                                                                                                                                     'tx_link_rate': '46796000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '46796000',
                                                                                                 'tx_power': 2}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:a0:49:b8'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '32878505829',
                                                                       'in_ucast_pkts': '334519001',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1017506513706',
                                                                       'out_ucast_pkts': '715984425',
                                                                       'poller_hash': 'ZTA2M2RhYmZmOTVmZXRoMA=='}],
                                         'latitude': 50.709705,
                                         'longitude': -100.972417,
                                         'management_ip': '10.10.6.251',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.96516,
                                         'model': 'LTU-LR',
                                         'name': 'Isaac-Brandon-4511',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:f9:5f',
                                         'temperature': 41.0,
                                         'uptime': '1483051'},
                                 {       'cpu': 34.3503,
                                         'elevation': 0.0,
                                         'errors': [{'http_auth': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '418408423090',
                                                                       'in_ucast_pkts': '313858776',
                                                                       'links': [       {       'in_octets': '418408423090',
                                                                                                'in_ucast_pkts': '313858776',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '10935121699',
                                                                                                'out_ucast_pkts': '96692051'}],
                                                                       'mac_address': 'f4:92:bf:1f:24:e3',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10935121699',
                                                                       'out_ucast_pkts': '96692051',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '143360000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1121310',
                                                                                                                                                     'distance': 2136,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '143360000',
                                                                                                                                                     'snr': 14.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10935121699',
                                                                       'in_ucast_pkts': '96692051',
                                                                       'name': 'eth0',
                                                                       'out_octets': '418408423090',
                                                                       'out_ucast_pkts': '313858776',
                                                                       'poller_hash': 'ZjQ5MmJmMWYyNGUzZXRoMA=='}],
                                         'latitude': 50.72218,
                                         'longitude': -100.99188,
                                         'management_ip': '10.10.6.243',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 80.90548,
                                         'model': 'LTU-LR',
                                         'name': 'Maggie-Clearsky-4638',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:1f:24:e3',
                                         'temperature': 42.0,
                                         'uptime': '1121844'},
                                 {       'cpu': 51.6393,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1065381184569',
                                                                       'in_ucast_pkts': '763339880',
                                                                       'links': [       {       'in_octets': '1065381184569',
                                                                                                'in_ucast_pkts': '763339880',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '27175298197',
                                                                                                'out_ucast_pkts': '292694426'}],
                                                                       'mac_address': 'e0:63:da:bf:fb:53',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27175298197',
                                                                       'out_ucast_pkts': '292694426',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '179200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '944248',
                                                                                                                                                     'distance': 971,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '179200000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:a0:30:49'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '27175298197',
                                                                       'in_ucast_pkts': '292694426',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1065381184569',
                                                                       'out_ucast_pkts': '763339880',
                                                                       'poller_hash': 'ZTA2M2RhYmZmYjUzZXRoMA=='}],
                                         'latitude': 50.714162,
                                         'longitude': -100.981478,
                                         'management_ip': '10.10.6.245',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.76817,
                                         'model': 'LTU-LR',
                                         'name': 'Dion-Brandon-4526',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:fb:53',
                                         'temperature': 45.0,
                                         'uptime': '944286'},
                                 {       'cpu': 42.3976,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '366638152959',
                                                                       'in_ucast_pkts': '272001636',
                                                                       'links': [       {       'in_octets': '366638152959',
                                                                                                'in_ucast_pkts': '272001636',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '16870104731',
                                                                                                'out_ucast_pkts': '80153970'}],
                                                                       'mac_address': 'f4:92:bf:1f:00:7f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16870104731',
                                                                       'out_ucast_pkts': '80153970',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '107520000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '693861',
                                                                                                                                                     'distance': 2330,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '107520000',
                                                                                                                                                     'snr': 13.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:a0:22:a9'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '16870104731',
                                                                       'in_ucast_pkts': '80153970',
                                                                       'name': 'eth0',
                                                                       'out_octets': '366638152959',
                                                                       'out_ucast_pkts': '272001636',
                                                                       'poller_hash': 'ZjQ5MmJmMWYwMDdmZXRoMA=='}],
                                         'latitude': 50.724262,
                                         'longitude': -100.992485,
                                         'management_ip': '10.10.6.249',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.66645,
                                         'model': 'LTU-LR',
                                         'name': 'Teresa-Davis-4650',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:1f:00:7f',
                                         'temperature': 45.0,
                                         'uptime': '693919'},
                                 {       'cpu': 37.7303,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '76360666393',
                                                                       'in_ucast_pkts': '60619656',
                                                                       'links': [       {       'in_octets': '76360666393',
                                                                                                'in_ucast_pkts': '60619656',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '3464753871',
                                                                                                'out_ucast_pkts': '18987085'}],
                                                                       'mac_address': 'e0:63:da:bf:f9:52',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3464753871',
                                                                       'out_ucast_pkts': '18987085',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '143360000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '610023',
                                                                                                                                                     'distance': 1178,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '143360000',
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '46796000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '46796000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:a0:3d:c5'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '3464753871',
                                                                       'in_ucast_pkts': '18987085',
                                                                       'name': 'eth0',
                                                                       'out_octets': '76360666393',
                                                                       'out_ucast_pkts': '60619656',
                                                                       'poller_hash': 'ZTA2M2RhYmZmOTUyZXRoMA=='}],
                                         'latitude': 50.718253,
                                         'longitude': -100.97117,
                                         'management_ip': '10.10.6.247',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.41457,
                                         'model': 'LTU-LR',
                                         'name': 'Madison-Cooke-4561-A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:f9:52',
                                         'temperature': 67.0,
                                         'uptime': '610072'},
                                 {       'cpu': 47.883,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '72103417540',
                                                                       'in_ucast_pkts': '57058015',
                                                                       'links': [       {       'in_octets': '72103417540',
                                                                                                'in_ucast_pkts': '57058015',
                                                                                                'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                'out_octets': '3635074814',
                                                                                                'out_ucast_pkts': '17032735'}],
                                                                       'mac_address': 'e0:63:da:bf:ff:e7',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3635074814',
                                                                       'out_ucast_pkts': '17032735',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5805,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '179200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '284051',
                                                                                                                                                     'distance': 281,
                                                                                                                                                     'mac_address': 'e0:63:da:bf:23:f9',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -31.0,
                                                                                                                                                     'rx_link_rate': '179200000',
                                                                                                                                                     'snr': 48.0,
                                                                                                                                                     'tx_link_rate': '46796000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '46796000',
                                                                                                 'tx_power': 0}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ans-nw-ap5n'}]},
                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:91:43:f3'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '3635074814',
                                                                       'in_ucast_pkts': '17032735',
                                                                       'name': 'eth0',
                                                                       'out_octets': '72103417540',
                                                                       'out_ucast_pkts': '57058015',
                                                                       'poller_hash': 'ZTA2M2RhYmZmZmU3ZXRoMA=='}],
                                         'latitude': 50.709995,
                                         'longitude': -100.973019,
                                         'management_ip': '10.10.6.252',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 86.11263,
                                         'model': 'LTU-LR',
                                         'name': 'jackie-mckee-4511',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:ff:e7',
                                         'temperature': 39.0,
                                         'uptime': '284111'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_06(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0.06")
        exp_info = {
                'gps_sync': False,
                'model': 'LTU-Rocket',
                'rf_chan_width': 40,
                'rf_freq': 5230,
                'rf_tx_power': 30,
                'sta_count': 18,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 73.191902,
                'dl_en_bytes': 12969448487820,
                'dl_en_packets': 1873935790,
                'dl_rf_bytes': 12879638937230,
                'dl_rf_packets': 1936467905,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'ul_en_bytes': 1194653851607,
                'ul_en_packets': 735774685,
                'ul_rf_bytes': 1250861107233,
                'ul_rf_packets': 868367776
        }
        exp_sta_stats = {
                '18:e8:29:08:ef:68': {       'alt_macs': ['18:e8:29:09:ef:68'],
                                             'dev_macs': {       '08:55:31:20:01:38',
                                                                 '08:55:31:20:32:14',
                                                                 '24:5a:4c:44:d3:e7',
                                                                 '24:5a:4c:e4:cf:85',
                                                                 '48:8f:5a:67:8a:47',
                                                                 '48:8f:5a:d7:cb:38',
                                                                 '48:8f:5a:ef:f1:2d',
                                                                 '74:da:88:3d:8d:cd',
                                                                 '78:8a:20:1c:53:8b',
                                                                 'b4:fb:e4:a6:2d:06',
                                                                 'b4:fb:e4:b7:68:e5',
                                                                 'b4:fb:e4:b7:68:ea',
                                                                 'c0:06:c3:2e:5f:ed',
                                                                 'd0:17:c2:da:04:88',
                                                                 'e0:63:da:44:29:63',
                                                                 'f4:92:bf:4a:bd:33',
                                                                 'f4:92:bf:4a:be:0a',
                                                                 'f4:92:bf:de:d7:76',
                                                                 'f4:92:bf:de:e3:51'},
                                             'dl_link_rate': 70400000,
                                             'dl_rf_bytes': 1298906759832,
                                             'dl_rf_packets': 1286579984,
                                             'ip_address': '100.64.4.56',
                                             'mac_address': '18:e8:29:08:ef:68',
                                             'name': 'Edan-Shalev-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 202164701512,
                                             'ul_rf_packets': 644682647},
                '18:e8:29:08:f3:c0': {       'alt_macs': ['18:e8:29:09:f3:c0'],
                                             'dev_macs': {'48:8f:5a:72:19:5e'},
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 450186920471,
                                             'dl_rf_packets': 546311787,
                                             'ip_address': '100.64.0.73',
                                             'mac_address': '18:e8:29:08:f3:c0',
                                             'name': 'teridebrah-heyne-cpe',
                                             'ul_link_rate': 100396000,
                                             'ul_rf_bytes': 20024956791,
                                             'ul_rf_packets': 131972825},
                '18:e8:29:08:f6:08': {       'alt_macs': ['18:e8:29:09:f6:08'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 35200000,
                                             'dl_rf_bytes': 25517951310,
                                             'dl_rf_packets': 83179272,
                                             'ip_address': '100.64.11.176',
                                             'mac_address': '18:e8:29:08:f6:08',
                                             'name': 'Gail-Dullenkopf-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 15170737775,
                                             'ul_rf_packets': 18784678},
                '18:e8:29:1f:13:a2': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 181805694518,
                                             'dl_rf_packets': 373055903,
                                             'ip_address': '100.64.0.92',
                                             'mac_address': '18:e8:29:1f:13:a2',
                                             'name': 'Derek-Lisoski-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 29443740713,
                                             'ul_rf_packets': 85561191},
                '18:e8:29:1f:db:73': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 281600000,
                                             'dl_rf_bytes': 218356368116,
                                             'dl_rf_packets': 269129293,
                                             'ip_address': '100.64.0.77',
                                             'mac_address': '18:e8:29:1f:db:73',
                                             'name': 'john-fitgerald-cpe',
                                             'ul_link_rate': 80317000,
                                             'ul_rf_bytes': 10001516415,
                                             'ul_rf_packets': 81577927},
                '18:e8:29:1f:e9:87': {       'alt_macs': None,
                                             'dev_macs': {'08:55:31:cb:82:bd'},
                                             'dl_link_rate': 70400000,
                                             'dl_rf_bytes': 34499997753,
                                             'dl_rf_packets': 249799557,
                                             'ip_address': '100.64.7.30',
                                             'mac_address': '18:e8:29:1f:e9:87',
                                             'name': 'Darren-Lee-cpe',
                                             'ul_link_rate': 80317000,
                                             'ul_rf_bytes': 3536812650,
                                             'ul_rf_packets': 9749235},
                '18:e8:29:1f:ed:41': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 17740809458,
                                             'dl_rf_packets': 29199803,
                                             'ip_address': '100.64.13.119',
                                             'mac_address': '18:e8:29:1f:ed:41',
                                             'name': 'Kelly-Kearns-cpe',
                                             'ul_link_rate': 80317000,
                                             'ul_rf_bytes': 1508717937,
                                             'ul_rf_packets': 5307292},
                '18:e8:29:1f:ed:fd': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:83:b6:21'},
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 45223122838,
                                             'dl_rf_packets': 76414735,
                                             'ip_address': '100.64.9.87',
                                             'mac_address': '18:e8:29:1f:ed:fd',
                                             'name': 'sue-stephanson-cpe',
                                             'ul_link_rate': 80317000,
                                             'ul_rf_bytes': 5868350415,
                                             'ul_rf_packets': 22056594},
                'e0:63:da:0f:25:a9': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 35200000,
                                             'dl_rf_bytes': 817684743580,
                                             'dl_rf_packets': 789696342,
                                             'ip_address': '100.64.0.88',
                                             'mac_address': 'e0:63:da:0f:25:a9',
                                             'name': 'Howard-Ruth-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 27933645419,
                                             'ul_rf_packets': 303982184},
                'e0:63:da:0f:3f:a6': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 35200000,
                                             'dl_rf_bytes': 112187914144,
                                             'dl_rf_packets': 309198345,
                                             'ip_address': '100.64.0.80',
                                             'mac_address': 'e0:63:da:0f:3f:a6',
                                             'name': 'bob-stutzke-cpe',
                                             'ul_link_rate': 40158000,
                                             'ul_rf_bytes': 10321079600,
                                             'ul_rf_packets': 33921719},
                'e0:63:da:bf:cf:ef': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 273281556084,
                                             'dl_rf_packets': 436916416,
                                             'ip_address': '100.64.9.114',
                                             'mac_address': 'e0:63:da:bf:cf:ef',
                                             'name': 'stephen-morgan-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 31465446023,
                                             'ul_rf_packets': 91793625},
                'e0:63:da:bf:d0:05': {       'alt_macs': None,
                                             'dev_macs': {'6c:cd:d6:ae:d2:5f'},
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 390067473176,
                                             'dl_rf_packets': 501752223,
                                             'ip_address': '100.64.2.226',
                                             'mac_address': 'e0:63:da:bf:d0:05',
                                             'name': 'Katherine-Prike-cpe',
                                             'ul_link_rate': 100396000,
                                             'ul_rf_bytes': 19746649260,
                                             'ul_rf_packets': 130493897},
                'e0:63:da:bf:d1:17': {       'alt_macs': None,
                                             'dev_macs': {'08:55:31:c8:9d:26'},
                                             'dl_link_rate': 35200000,
                                             'dl_rf_bytes': 61467130328,
                                             'dl_rf_packets': 272645858,
                                             'ip_address': '100.64.11.44',
                                             'mac_address': 'e0:63:da:bf:d1:17',
                                             'name': 'cheryl-mishisenhimer-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 18755021871,
                                             'ul_rf_packets': 27355295},
                'e0:63:da:bf:d6:73': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 281186995139,
                                             'dl_rf_packets': 424981525,
                                             'ip_address': '100.64.3.203',
                                             'mac_address': 'e0:63:da:bf:d6:73',
                                             'name': 'dave-devries-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 21732630668,
                                             'ul_rf_packets': 71315387},
                'f4:92:bf:5f:38:41': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 585122109392,
                                             'dl_rf_packets': 638666090,
                                             'ip_address': '100.64.7.58',
                                             'mac_address': 'f4:92:bf:5f:38:41',
                                             'name': 'Kevin-Moorse-cpe',
                                             'ul_link_rate': 80317000,
                                             'ul_rf_bytes': 32685711771,
                                             'ul_rf_packets': 266785847},
                'f4:92:bf:5f:38:c5': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 211200000,
                                             'dl_rf_bytes': 13775462774,
                                             'dl_rf_packets': 71251818,
                                             'ip_address': '100.64.0.72',
                                             'mac_address': 'f4:92:bf:5f:38:c5',
                                             'name': 'George-Cordingly-cpe',
                                             'ul_link_rate': 60238000,
                                             'ul_rf_bytes': 3280365757,
                                             'ul_rf_packets': 9196783},
                'fc:ec:da:77:b8:78': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 352000000,
                                             'dl_rf_bytes': 214225778348,
                                             'dl_rf_packets': 381141173,
                                             'ip_address': '192.168.1.20',
                                             'mac_address': 'fc:ec:da:77:b8:78',
                                             'name': 'tamara-massasso-cpe',
                                             'ul_link_rate': 20079000,
                                             'ul_rf_bytes': 23730751989,
                                             'ul_rf_packets': 57391343},
                'fc:ec:da:77:b8:94': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 1023186533,
                                             'dl_rf_packets': 3181774,
                                             'ip_address': '100.64.7.181',
                                             'mac_address': 'fc:ec:da:77:b8:94',
                                             'name': 'nick-butler-cpe',
                                             'ul_link_rate': 40158000,
                                             'ul_rf_bytes': 219328664,
                                             'ul_rf_packets': 1076353}
        }
        exp_ne_msg = {
                'data': {       'cpu': 73.1919,
                                'elevation': 0.0,
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '12969448487820',
                                                              'in_ucast_pkts': '1873935790',
                                                              'mac_address': 'e6:63:da:0f:51:53',
                                                              'mtu': 1524,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '1194653851607',
                                                              'out_ucast_pkts': '735774685',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '1250861107233',
                                                              'in_ucast_pkts': '868367776',
                                                              'links': [       {       'in_octets': '3536812650',
                                                                                       'in_ucast_pkts': '9749235',
                                                                                       'mac_address': '18:e8:29:1f:e9:87',
                                                                                       'out_octets': '34499997753',
                                                                                       'out_ucast_pkts': '249799557'},
                                                                               {       'in_octets': '20024956791',
                                                                                       'in_ucast_pkts': '131972825',
                                                                                       'mac_address': '18:e8:29:08:f3:c0',
                                                                                       'out_octets': '450186920471',
                                                                                       'out_ucast_pkts': '546311787'},
                                                                               {       'in_octets': '19746649260',
                                                                                       'in_ucast_pkts': '130493897',
                                                                                       'mac_address': 'e0:63:da:bf:d0:05',
                                                                                       'out_octets': '390067473176',
                                                                                       'out_ucast_pkts': '501752223'},
                                                                               {       'in_octets': '202164701512',
                                                                                       'in_ucast_pkts': '644682647',
                                                                                       'mac_address': '18:e8:29:08:ef:68',
                                                                                       'out_octets': '1298906759832',
                                                                                       'out_ucast_pkts': '1286579984'},
                                                                               {       'in_octets': '21732630668',
                                                                                       'in_ucast_pkts': '71315387',
                                                                                       'mac_address': 'e0:63:da:bf:d6:73',
                                                                                       'out_octets': '281186995139',
                                                                                       'out_ucast_pkts': '424981525'},
                                                                               {       'in_octets': '18755021871',
                                                                                       'in_ucast_pkts': '27355295',
                                                                                       'mac_address': 'e0:63:da:bf:d1:17',
                                                                                       'out_octets': '61467130328',
                                                                                       'out_ucast_pkts': '272645858'},
                                                                               {       'in_octets': '32685711771',
                                                                                       'in_ucast_pkts': '266785847',
                                                                                       'mac_address': 'f4:92:bf:5f:38:41',
                                                                                       'out_octets': '585122109392',
                                                                                       'out_ucast_pkts': '638666090'},
                                                                               {       'in_octets': '23730751989',
                                                                                       'in_ucast_pkts': '57391343',
                                                                                       'mac_address': 'fc:ec:da:77:b8:78',
                                                                                       'out_octets': '214225778348',
                                                                                       'out_ucast_pkts': '381141173'},
                                                                               {       'in_octets': '31465446023',
                                                                                       'in_ucast_pkts': '91793625',
                                                                                       'mac_address': 'e0:63:da:bf:cf:ef',
                                                                                       'out_octets': '273281556084',
                                                                                       'out_ucast_pkts': '436916416'},
                                                                               {       'in_octets': '27933645419',
                                                                                       'in_ucast_pkts': '303982184',
                                                                                       'mac_address': 'e0:63:da:0f:25:a9',
                                                                                       'out_octets': '817684743580',
                                                                                       'out_ucast_pkts': '789696342'},
                                                                               {       'in_octets': '29443740713',
                                                                                       'in_ucast_pkts': '85561191',
                                                                                       'mac_address': '18:e8:29:1f:13:a2',
                                                                                       'out_octets': '181805694518',
                                                                                       'out_ucast_pkts': '373055903'},
                                                                               {       'in_octets': '10321079600',
                                                                                       'in_ucast_pkts': '33921719',
                                                                                       'mac_address': 'e0:63:da:0f:3f:a6',
                                                                                       'out_octets': '112187914144',
                                                                                       'out_ucast_pkts': '309198345'},
                                                                               {       'in_octets': '10001516415',
                                                                                       'in_ucast_pkts': '81577927',
                                                                                       'mac_address': '18:e8:29:1f:db:73',
                                                                                       'out_octets': '218356368116',
                                                                                       'out_ucast_pkts': '269129293'},
                                                                               {       'in_octets': '3280365757',
                                                                                       'in_ucast_pkts': '9196783',
                                                                                       'mac_address': 'f4:92:bf:5f:38:c5',
                                                                                       'out_octets': '13775462774',
                                                                                       'out_ucast_pkts': '71251818'},
                                                                               {       'in_octets': '15170737775',
                                                                                       'in_ucast_pkts': '18784678',
                                                                                       'mac_address': '18:e8:29:08:f6:08',
                                                                                       'out_octets': '25517951310',
                                                                                       'out_ucast_pkts': '83179272'},
                                                                               {       'in_octets': '5868350415',
                                                                                       'in_ucast_pkts': '22056594',
                                                                                       'mac_address': '18:e8:29:1f:ed:fd',
                                                                                       'out_octets': '45223122838',
                                                                                       'out_ucast_pkts': '76414735'},
                                                                               {       'in_octets': '1508717937',
                                                                                       'in_ucast_pkts': '5307292',
                                                                                       'mac_address': '18:e8:29:1f:ed:41',
                                                                                       'out_octets': '17740809458',
                                                                                       'out_ucast_pkts': '29199803'},
                                                                               {       'in_octets': '219328664',
                                                                                       'in_ucast_pkts': '1076353',
                                                                                       'mac_address': 'fc:ec:da:77:b8:94',
                                                                                       'out_octets': '1023186533',
                                                                                       'out_ucast_pkts': '3181774'}],
                                                              'mac_address': 'e0:63:da:0f:51:53',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '12879638937230',
                                                              'out_ucast_pkts': '1936467905',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '65815000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2602513',
                                                                                                                                            'distance': 2595,
                                                                                                                                            'mac_address': '18:e8:29:1f:e9:87',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -27.0,
                                                                                                                                            'rx_link_rate': '80317000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '70400000'},
                                                                                                                                    {       'connected_time': '2602511',
                                                                                                                                            'distance': 3040,
                                                                                                                                            'mac_address': '18:e8:29:08:f3:c0',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '100396000',
                                                                                                                                            'snr': 59.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '2602509',
                                                                                                                                            'distance': 2652,
                                                                                                                                            'mac_address': 'e0:63:da:bf:d0:05',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -27.0,
                                                                                                                                            'rx_link_rate': '100396000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '2602428',
                                                                                                                                            'distance': 7979,
                                                                                                                                            'mac_address': '18:e8:29:08:ef:68',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '70400000'},
                                                                                                                                    {       'connected_time': '2544733',
                                                                                                                                            'distance': 2782,
                                                                                                                                            'mac_address': 'e0:63:da:bf:d6:73',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -25.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 60.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '1877133',
                                                                                                                                            'distance': 2792,
                                                                                                                                            'mac_address': 'e0:63:da:bf:d1:17',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 63.0,
                                                                                                                                            'tx_link_rate': '35200000'},
                                                                                                                                    {       'connected_time': '1877132',
                                                                                                                                            'distance': 3298,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:38:41',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -19.0,
                                                                                                                                            'rx_link_rate': '80317000',
                                                                                                                                            'snr': 66.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '1877090',
                                                                                                                                            'distance': 3375,
                                                                                                                                            'mac_address': 'fc:ec:da:77:b8:78',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -13.0,
                                                                                                                                            'rx_link_rate': '20079000',
                                                                                                                                            'snr': 72.0,
                                                                                                                                            'tx_link_rate': '352000000'},
                                                                                                                                    {       'connected_time': '1877086',
                                                                                                                                            'distance': 3442,
                                                                                                                                            'mac_address': 'e0:63:da:bf:cf:ef',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -18.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 67.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '1877086',
                                                                                                                                            'distance': 7302,
                                                                                                                                            'mac_address': 'e0:63:da:0f:25:a9',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -17.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 68.0,
                                                                                                                                            'tx_link_rate': '35200000'},
                                                                                                                                    {       'connected_time': '1877082',
                                                                                                                                            'distance': 8126,
                                                                                                                                            'mac_address': '18:e8:29:1f:13:a2',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -20.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '1877072',
                                                                                                                                            'distance': 2528,
                                                                                                                                            'mac_address': 'e0:63:da:0f:3f:a6',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -19.0,
                                                                                                                                            'rx_link_rate': '40158000',
                                                                                                                                            'snr': 66.0,
                                                                                                                                            'tx_link_rate': '35200000'},
                                                                                                                                    {       'connected_time': '1362707',
                                                                                                                                            'distance': 3234,
                                                                                                                                            'mac_address': '18:e8:29:1f:db:73',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '80317000',
                                                                                                                                            'snr': 59.0,
                                                                                                                                            'tx_link_rate': '281600000'},
                                                                                                                                    {       'connected_time': '728739',
                                                                                                                                            'distance': 7604,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:38:c5',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 63.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '702332',
                                                                                                                                            'distance': 7339,
                                                                                                                                            'mac_address': '18:e8:29:08:f6:08',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -20.0,
                                                                                                                                            'rx_link_rate': '60238000',
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '35200000'},
                                                                                                                                    {       'connected_time': '494264',
                                                                                                                                            'distance': 7460,
                                                                                                                                            'mac_address': '18:e8:29:1f:ed:fd',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -24.0,
                                                                                                                                            'rx_link_rate': '80317000',
                                                                                                                                            'snr': 61.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '187946',
                                                                                                                                            'distance': 2866,
                                                                                                                                            'mac_address': '18:e8:29:1f:ed:41',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '80317000',
                                                                                                                                            'snr': 63.0,
                                                                                                                                            'tx_link_rate': '211200000'},
                                                                                                                                    {       'connected_time': '20908',
                                                                                                                                            'distance': 974,
                                                                                                                                            'mac_address': 'fc:ec:da:77:b8:94',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -18.0,
                                                                                                                                            'rx_link_rate': '40158000',
                                                                                                                                            'snr': 67.0,
                                                                                                                                            'tx_link_rate': '140800000'}],
                                                                                                                   'noise_floor': -85.0}],
                                                                                        'tx_link_rate': '164266000',
                                                                                        'tx_power': 30}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KAN-BH-CF-LTU1'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 48.113677,
                                'longitude': -116.124969,
                                'manufacturer': 'Ubiquiti',
                                'mem': 89.54371,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0',
                                'system_mac_address': 'e0:63:da:0f:51:53',
                                'temperature': 76.0,
                                'uptime': '5296459'},
                'peers': [       {       'cpu': 65.0,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '34499997753',
                                                                       'in_ucast_pkts': '249799557',
                                                                       'links': [       {       'in_octets': '34499997753',
                                                                                                'in_ucast_pkts': '249799557',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '3536812650',
                                                                                                'out_ucast_pkts': '9749235'}],
                                                                       'mac_address': '18:e8:29:1f:e9:87',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3536812650',
                                                                       'out_ucast_pkts': '9749235',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '70400000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2602513',
                                                                                                                                                     'distance': 2595,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '70400000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '80317000'}],
                                                                                                                            'noise_floor': -88.0}],
                                                                                                 'tx_link_rate': '80317000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '08:55:31:cb:82:bd'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '3536812650',
                                                                       'in_ucast_pkts': '9749235',
                                                                       'name': 'eth0',
                                                                       'out_octets': '34499997753',
                                                                       'out_ucast_pkts': '249799557',
                                                                       'poller_hash': 'MThlODI5MWZlOTg3ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.7.30',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.41399,
                                         'model': 'LTU-LR',
                                         'name': 'Darren-Lee-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': '18:e8:29:1f:e9:87',
                                         'temperature': 68.0,
                                         'uptime': '2602305'},
                                 {       'cpu': 40.5267,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '450186920471',
                                                                       'in_ucast_pkts': '546311787',
                                                                       'links': [       {       'in_octets': '450186920471',
                                                                                                'in_ucast_pkts': '546311787',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '20024956791',
                                                                                                'out_ucast_pkts': '131972825'}],
                                                                       'mac_address': '18:e8:29:08:f3:c0',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20024956791',
                                                                       'out_ucast_pkts': '131972825',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2602511',
                                                                                                                                                     'distance': 3040,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '100396000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '100396000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '48:8f:5a:72:19:5e'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '20024956791',
                                                                       'in_ucast_pkts': '131972825',
                                                                       'mac_address': '18:e8:29:09:f3:c0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '450186920471',
                                                                       'out_ucast_pkts': '546311787'}],
                                         'latitude': 48.124978,
                                         'longitude': -116.160852,
                                         'management_ip': '100.64.0.73',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.00065,
                                         'model': 'LTU-LR',
                                         'name': 'teridebrah-heyne-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:08:f3:c0',
                                         'temperature': 71.0,
                                         'uptime': '2602334'},
                                 {       'cpu': 43.4656,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '390067473176',
                                                                       'in_ucast_pkts': '501752223',
                                                                       'links': [       {       'in_octets': '390067473176',
                                                                                                'in_ucast_pkts': '501752223',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '19746649260',
                                                                                                'out_ucast_pkts': '130493897'}],
                                                                       'mac_address': 'e0:63:da:bf:d0:05',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '19746649260',
                                                                       'out_ucast_pkts': '130493897',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2602509',
                                                                                                                                                     'distance': 2652,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '100396000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '100396000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '6c:cd:d6:ae:d2:5f'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '19746649260',
                                                                       'in_ucast_pkts': '130493897',
                                                                       'name': 'eth0',
                                                                       'out_octets': '390067473176',
                                                                       'out_ucast_pkts': '501752223',
                                                                       'poller_hash': 'ZTA2M2RhYmZkMDA1ZXRoMA=='}],
                                         'latitude': 48.120434,
                                         'longitude': -116.157869,
                                         'management_ip': '100.64.2.226',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.99257,
                                         'model': 'LTU-LR',
                                         'name': 'Katherine-Prike-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:d0:05',
                                         'temperature': 68.0,
                                         'uptime': '2602457'},
                                 {       'cpu': 16.0,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1298906759832',
                                                                       'in_ucast_pkts': '1286579984',
                                                                       'links': [       {       'in_octets': '1298906759832',
                                                                                                'in_ucast_pkts': '1286579984',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '202164701512',
                                                                                                'out_ucast_pkts': '644682647'}],
                                                                       'mac_address': '18:e8:29:08:ef:68',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '202164701512',
                                                                       'out_ucast_pkts': '644682647',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '70400000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2602428',
                                                                                                                                                     'distance': 7979,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '70400000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '08:55:31:20:01:38',
                                                                                                        '08:55:31:20:32:14',
                                                                                                        '24:5a:4c:44:d3:e7',
                                                                                                        '24:5a:4c:e4:cf:85',
                                                                                                        '48:8f:5a:67:8a:47',
                                                                                                        '48:8f:5a:d7:cb:38',
                                                                                                        '48:8f:5a:ef:f1:2d',
                                                                                                        '74:da:88:3d:8d:cd',
                                                                                                        '78:8a:20:1c:53:8b',
                                                                                                        'b4:fb:e4:a6:2d:06',
                                                                                                        'b4:fb:e4:b7:68:e5',
                                                                                                        'b4:fb:e4:b7:68:ea',
                                                                                                        'c0:06:c3:2e:5f:ed',
                                                                                                        'd0:17:c2:da:04:88',
                                                                                                        'e0:63:da:44:29:63',
                                                                                                        'f4:92:bf:4a:bd:33',
                                                                                                        'f4:92:bf:4a:be:0a',
                                                                                                        'f4:92:bf:de:d7:76',
                                                                                                        'f4:92:bf:de:e3:51'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '202164701512',
                                                                       'in_ucast_pkts': '644682647',
                                                                       'mac_address': '18:e8:29:09:ef:68',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1298906759832',
                                                                       'out_ucast_pkts': '1286579984'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.4.56',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.37201,
                                         'model': 'LTU-LR',
                                         'name': 'Edan-Shalev-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': '18:e8:29:08:ef:68',
                                         'temperature': 65.0,
                                         'uptime': '2602256'},
                                 {       'cpu': 42.8819,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '281186995139',
                                                                       'in_ucast_pkts': '424981525',
                                                                       'links': [       {       'in_octets': '281186995139',
                                                                                                'in_ucast_pkts': '424981525',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '21732630668',
                                                                                                'out_ucast_pkts': '71315387'}],
                                                                       'mac_address': 'e0:63:da:bf:d6:73',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21732630668',
                                                                       'out_ucast_pkts': '71315387',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2544733',
                                                                                                                                                     'distance': 2782,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -88.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '21732630668',
                                                                       'in_ucast_pkts': '71315387',
                                                                       'name': 'eth0',
                                                                       'out_octets': '281186995139',
                                                                       'out_ucast_pkts': '424981525',
                                                                       'poller_hash': 'ZTA2M2RhYmZkNjczZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.3.203',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.032936,
                                         'model': 'LTU-LR',
                                         'name': 'dave-devries-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0-BETA4',
                                         'system_mac_address': 'e0:63:da:bf:d6:73',
                                         'temperature': 71.0,
                                         'uptime': '2602345'},
                                 {       'cpu': 12.9353,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '61467130328',
                                                                       'in_ucast_pkts': '272645858',
                                                                       'links': [       {       'in_octets': '61467130328',
                                                                                                'in_ucast_pkts': '272645858',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '18755021871',
                                                                                                'out_ucast_pkts': '27355295'}],
                                                                       'mac_address': 'e0:63:da:bf:d1:17',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '18755021871',
                                                                       'out_ucast_pkts': '27355295',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '35200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877133',
                                                                                                                                                     'distance': 2792,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '35200000',
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -88.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '08:55:31:c8:9d:26'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '18755021871',
                                                                       'in_ucast_pkts': '27355295',
                                                                       'name': 'eth0',
                                                                       'out_octets': '61467130328',
                                                                       'out_ucast_pkts': '272645858',
                                                                       'poller_hash': 'ZTA2M2RhYmZkMTE3ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.11.44',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.27029,
                                         'model': 'LTU-LR',
                                         'name': 'cheryl-mishisenhimer-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.0.6',
                                         'system_mac_address': 'e0:63:da:bf:d1:17',
                                         'temperature': 54.0,
                                         'uptime': '2602242'},
                                 {       'cpu': 42.1441,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '585122109392',
                                                                       'in_ucast_pkts': '638666090',
                                                                       'links': [       {       'in_octets': '585122109392',
                                                                                                'in_ucast_pkts': '638666090',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '32685711771',
                                                                                                'out_ucast_pkts': '266785847'}],
                                                                       'mac_address': 'f4:92:bf:5f:38:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '32685711771',
                                                                       'out_ucast_pkts': '266785847',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877132',
                                                                                                                                                     'distance': 3298,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '80317000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '80317000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '32685711771',
                                                                       'in_ucast_pkts': '266785847',
                                                                       'name': 'eth0',
                                                                       'out_octets': '585122109392',
                                                                       'out_ucast_pkts': '638666090',
                                                                       'poller_hash': 'ZjQ5MmJmNWYzODQxZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.7.58',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.08784,
                                         'model': 'LTU-LR',
                                         'name': 'Kevin-Moorse-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'f4:92:bf:5f:38:41',
                                         'temperature': 61.0,
                                         'uptime': '2602384'},
                                 {       'cpu': 10.0502,
                                         'elevation': 636.2,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 7,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '214225778348',
                                                                       'in_ucast_pkts': '381141173',
                                                                       'links': [       {       'in_octets': '214225778348',
                                                                                                'in_ucast_pkts': '381141173',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '23730751989',
                                                                                                'out_ucast_pkts': '57391343'}],
                                                                       'mac_address': 'fc:ec:da:77:b8:78',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '23730751989',
                                                                       'out_ucast_pkts': '57391343',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '352000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877090',
                                                                                                                                                     'distance': 3375,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '352000000',
                                                                                                                                                     'snr': 11.0,
                                                                                                                                                     'tx_link_rate': '20079000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '20079000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '23730751989',
                                                                       'in_ucast_pkts': '57391343',
                                                                       'name': 'eth0',
                                                                       'out_octets': '214225778348',
                                                                       'out_ucast_pkts': '381141173',
                                                                       'poller_hash': 'ZmNlY2RhNzdiODc4ZXRoMA=='}],
                                         'latitude': 48.127885,
                                         'longitude': -116.163783,
                                         'management_ip': '192.168.1.20',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.8026,
                                         'model': 'LTU-Pro',
                                         'name': 'tamara-massasso-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': 'fc:ec:da:77:b8:78',
                                         'temperature': 48.0,
                                         'uptime': '2602187'},
                                 {       'cpu': 44.2917,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '273281556084',
                                                                       'in_ucast_pkts': '436916416',
                                                                       'links': [       {       'in_octets': '273281556084',
                                                                                                'in_ucast_pkts': '436916416',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '31465446023',
                                                                                                'out_ucast_pkts': '91793625'}],
                                                                       'mac_address': 'e0:63:da:bf:cf:ef',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '31465446023',
                                                                       'out_ucast_pkts': '91793625',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877086',
                                                                                                                                                     'distance': 3442,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -88.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '31465446023',
                                                                       'in_ucast_pkts': '91793625',
                                                                       'name': 'eth0',
                                                                       'out_octets': '273281556084',
                                                                       'out_ucast_pkts': '436916416',
                                                                       'poller_hash': 'ZTA2M2RhYmZjZmVmZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.9.114',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.96835,
                                         'model': 'LTU-LR',
                                         'name': 'stephen-morgan-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'e0:63:da:bf:cf:ef',
                                         'temperature': 65.0,
                                         'uptime': '2602292'},
                                 {       'cpu': 73.0,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '817684743580',
                                                                       'in_ucast_pkts': '789696342',
                                                                       'links': [       {       'in_octets': '817684743580',
                                                                                                'in_ucast_pkts': '789696342',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '27933645419',
                                                                                                'out_ucast_pkts': '303982184'}],
                                                                       'mac_address': 'e0:63:da:0f:25:a9',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27933645419',
                                                                       'out_ucast_pkts': '303982184',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '35200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877086',
                                                                                                                                                     'distance': 7302,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '35200000',
                                                                                                                                                     'snr': 16.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -88.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '27933645419',
                                                                       'in_ucast_pkts': '303982184',
                                                                       'name': 'eth0',
                                                                       'out_octets': '817684743580',
                                                                       'out_ucast_pkts': '789696342',
                                                                       'poller_hash': 'ZTA2M2RhMGYyNWE5ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.0.88',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.841866,
                                         'model': 'LTU-LR',
                                         'name': 'Howard-Ruth-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': 'e0:63:da:0f:25:a9',
                                         'temperature': 65.0,
                                         'uptime': '2602282'},
                                 {       'cpu': 46.5094,
                                         'elevation': 634.6,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '181805694518',
                                                                       'in_ucast_pkts': '373055903',
                                                                       'links': [       {       'in_octets': '181805694518',
                                                                                                'in_ucast_pkts': '373055903',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '29443740713',
                                                                                                'out_ucast_pkts': '85561191'}],
                                                                       'mac_address': '18:e8:29:1f:13:a2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '29443740713',
                                                                       'out_ucast_pkts': '85561191',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877082',
                                                                                                                                                     'distance': 8126,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '29443740713',
                                                                       'in_ucast_pkts': '85561191',
                                                                       'name': 'eth0',
                                                                       'out_octets': '181805694518',
                                                                       'out_ucast_pkts': '373055903',
                                                                       'poller_hash': 'MThlODI5MWYxM2EyZXRoMA=='}],
                                         'latitude': 48.148706,
                                         'longitude': -116.219478,
                                         'management_ip': '100.64.0.92',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.02002,
                                         'model': 'LTU-Pro',
                                         'name': 'Derek-Lisoski-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:13:a2',
                                         'temperature': 54.0,
                                         'uptime': '2602295'},
                                 {       'cpu': 10.3773,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '112187914144',
                                                                       'in_ucast_pkts': '309198345',
                                                                       'links': [       {       'in_octets': '112187914144',
                                                                                                'in_ucast_pkts': '309198345',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '10321079600',
                                                                                                'out_ucast_pkts': '33921719'}],
                                                                       'mac_address': 'e0:63:da:0f:3f:a6',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10321079600',
                                                                       'out_ucast_pkts': '33921719',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '35200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1877072',
                                                                                                                                                     'distance': 2528,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '35200000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '40158000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '40158000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10321079600',
                                                                       'in_ucast_pkts': '33921719',
                                                                       'name': 'eth0',
                                                                       'out_octets': '112187914144',
                                                                       'out_ucast_pkts': '309198345',
                                                                       'poller_hash': 'ZTA2M2RhMGYzZmE2ZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.0.80',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.604515,
                                         'model': 'LTU-LR',
                                         'name': 'bob-stutzke-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': 'e0:63:da:0f:3f:a6',
                                         'temperature': 67.0,
                                         'uptime': '2602343'},
                                 {       'cpu': 27.7108,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '218356368116',
                                                                       'in_ucast_pkts': '269129293',
                                                                       'links': [       {       'in_octets': '218356368116',
                                                                                                'in_ucast_pkts': '269129293',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '10001516415',
                                                                                                'out_ucast_pkts': '81577927'}],
                                                                       'mac_address': '18:e8:29:1f:db:73',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10001516415',
                                                                       'out_ucast_pkts': '81577927',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '281600000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1362707',
                                                                                                                                                     'distance': 3234,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '281600000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '80317000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '80317000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10001516415',
                                                                       'in_ucast_pkts': '81577927',
                                                                       'name': 'eth0',
                                                                       'out_octets': '218356368116',
                                                                       'out_ucast_pkts': '269129293',
                                                                       'poller_hash': 'MThlODI5MWZkYjczZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.0.77',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.45274,
                                         'model': 'LTU-LR',
                                         'name': 'john-fitgerald-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': '18:e8:29:1f:db:73',
                                         'temperature': 76.0,
                                         'uptime': '1362668'},
                                 {       'cpu': 39.4949,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '13775462774',
                                                                       'in_ucast_pkts': '71251818',
                                                                       'links': [       {       'in_octets': '13775462774',
                                                                                                'in_ucast_pkts': '71251818',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '3280365757',
                                                                                                'out_ucast_pkts': '9196783'}],
                                                                       'mac_address': 'f4:92:bf:5f:38:c5',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3280365757',
                                                                       'out_ucast_pkts': '9196783',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '728739',
                                                                                                                                                     'distance': 7604,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -92.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '3280365757',
                                                                       'in_ucast_pkts': '9196783',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13775462774',
                                                                       'out_ucast_pkts': '71251818',
                                                                       'poller_hash': 'ZjQ5MmJmNWYzOGM1ZXRoMA==',
                                                                       'speed': '100000000'}],
                                         'latitude': 48.14553,
                                         'longitude': -116.21416,
                                         'management_ip': '100.64.0.72',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.157265,
                                         'model': 'LTU-LR',
                                         'name': 'George-Cordingly-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:5f:38:c5',
                                         'temperature': 71.0,
                                         'uptime': '728676'},
                                 {       'cpu': 27.6315,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '25517951310',
                                                                       'in_ucast_pkts': '83179272',
                                                                       'links': [       {       'in_octets': '25517951310',
                                                                                                'in_ucast_pkts': '83179272',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '15170737775',
                                                                                                'out_ucast_pkts': '18784678'}],
                                                                       'mac_address': '18:e8:29:08:f6:08',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15170737775',
                                                                       'out_ucast_pkts': '18784678',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '35200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '702332',
                                                                                                                                                     'distance': 7339,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '35200000',
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '60238000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '60238000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '15170737775',
                                                                       'in_ucast_pkts': '18784678',
                                                                       'mac_address': '18:e8:29:09:f6:08',
                                                                       'name': 'eth0',
                                                                       'out_octets': '25517951310',
                                                                       'out_ucast_pkts': '83179272'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.11.176',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.376854,
                                         'model': 'LTU-LR',
                                         'name': 'Gail-Dullenkopf-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.0.7',
                                         'system_mac_address': '18:e8:29:08:f6:08',
                                         'temperature': 55.0,
                                         'uptime': '702302'},
                                 {       'cpu': 38.8012,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '45223122838',
                                                                       'in_ucast_pkts': '76414735',
                                                                       'links': [       {       'in_octets': '45223122838',
                                                                                                'in_ucast_pkts': '76414735',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '5868350415',
                                                                                                'out_ucast_pkts': '22056594'}],
                                                                       'mac_address': '18:e8:29:1f:ed:fd',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5868350415',
                                                                       'out_ucast_pkts': '22056594',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '494264',
                                                                                                                                                     'distance': 7460,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '80317000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '80317000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'bridged_mac_addresses': [       '48:8f:5a:83:b6:21'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '5868350415',
                                                                       'in_ucast_pkts': '22056594',
                                                                       'name': 'eth0',
                                                                       'out_octets': '45223122838',
                                                                       'out_ucast_pkts': '76414735',
                                                                       'poller_hash': 'MThlODI5MWZlZGZkZXRoMA=='}],
                                         'latitude': 48.145786,
                                         'longitude': -116.211636,
                                         'management_ip': '100.64.9.87',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.37201,
                                         'model': 'LTU-LR',
                                         'name': 'sue-stephanson-cpe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:ed:fd',
                                         'temperature': 65.0,
                                         'uptime': '494265'},
                                 {       'cpu': 39.5147,
                                         'elevation': 0.0,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '17740809458',
                                                                       'in_ucast_pkts': '29199803',
                                                                       'links': [       {       'in_octets': '17740809458',
                                                                                                'in_ucast_pkts': '29199803',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '1508717937',
                                                                                                'out_ucast_pkts': '5307292'}],
                                                                       'mac_address': '18:e8:29:1f:ed:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1508717937',
                                                                       'out_ucast_pkts': '5307292',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '211200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '187946',
                                                                                                                                                     'distance': 2866,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '211200000',
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '80317000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '80317000',
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1508717937',
                                                                       'in_ucast_pkts': '5307292',
                                                                       'name': 'eth0',
                                                                       'out_octets': '17740809458',
                                                                       'out_ucast_pkts': '29199803',
                                                                       'poller_hash': 'MThlODI5MWZlZDQxZXRoMA=='}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '100.64.13.119',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.1718,
                                         'model': 'LTU-LR',
                                         'name': 'Kelly-Kearns-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': '18:e8:29:1f:ed:41',
                                         'temperature': 53.0,
                                         'uptime': '187947'},
                                 {       'cpu': 46.2894,
                                         'elevation': 677.2,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 7,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1023186533',
                                                                       'in_ucast_pkts': '3181774',
                                                                       'links': [       {       'in_octets': '1023186533',
                                                                                                'in_ucast_pkts': '3181774',
                                                                                                'mac_address': 'e0:63:da:0f:51:53',
                                                                                                'out_octets': '219328664',
                                                                                                'out_ucast_pkts': '1076353'}],
                                                                       'mac_address': 'fc:ec:da:77:b8:94',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '219328664',
                                                                       'out_ucast_pkts': '1076353',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '20908',
                                                                                                                                                     'distance': 974,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:51:53',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '40158000'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '40158000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KAN-BH-CF-LTU1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '219328664',
                                                                       'in_ucast_pkts': '1076353',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1023186533',
                                                                       'out_ucast_pkts': '3181774',
                                                                       'poller_hash': 'ZmNlY2RhNzdiODk0ZXRoMA=='}],
                                         'latitude': 48.112922,
                                         'longitude': -116.136669,
                                         'management_ip': '100.64.7.181',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 90.65457,
                                         'model': 'LTU-Pro',
                                         'name': 'nick-butler-cpe',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v2.1.0',
                                         'system_mac_address': 'fc:ec:da:77:b8:94',
                                         'temperature': 57.0,
                                         'uptime': '20930'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_1_0_505967_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.1.0-505967.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 50,
                'rf_freq': 5955,
                'rf_tx_power': 20,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v2.1.0-505967',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 55.81704753982249,
                'dl_en_bytes': 9607597748655,
                'dl_en_packets': 2007499193,
                'dl_rf_bytes': 9227381065030,
                'dl_rf_packets': 1726234572,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'ul_en_bytes': 6387246611695,
                'ul_en_packets': 3913696911,
                'ul_rf_bytes': 6471169421373,
                'ul_rf_packets': 4095279227
        }
        exp_sta_stats = {
                '18:e8:29:1f:ed:3c': {       'alt_macs': None,
                                             'dev_macs': {'18:b1:69:0c:f9:6f'},
                                             'dl_link_rate': 396800000,
                                             'dl_rf_bytes': 813778196218,
                                             'dl_rf_packets': 1312334169,
                                             'ip_address': '192.168.44.10',
                                             'mac_address': '18:e8:29:1f:ed:3c',
                                             'name': 'D&H-LTULR',
                                             'ul_link_rate': 180396000,
                                             'ul_rf_bytes': 558499918375,
                                             'ul_rf_packets': 493921263},
                'fc:ec:da:77:f3:2d': {       'alt_macs': None,
                                             'dev_macs': {'fc:ec:da:44:cf:1f'},
                                             'dl_link_rate': 317440000,
                                             'dl_rf_bytes': 1570614971953,
                                             'dl_rf_packets': 2566960990,
                                             'ip_address': '192.168.41.10',
                                             'mac_address': 'fc:ec:da:77:f3:2d',
                                             'name': 'Agudath_LTU_PRO',
                                             'ul_link_rate': 180396000,
                                             'ul_rf_bytes': 120199925779,
                                             'ul_rf_packets': 328894883}
        }
        exp_ne_msg = {
                'data': {       'cpu': 55.817047,
                                'elevation': 0.0,
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '9607597748655',
                                                              'in_ucast_pkts': '2007499193',
                                                              'mac_address': '1e:e8:29:1f:08:85',
                                                              'mtu': 1524,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '6387246611695',
                                                              'out_ucast_pkts': '3913696911',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '6471169421373',
                                                              'in_ucast_pkts': '4095279227',
                                                              'links': [       {       'in_octets': '120199925779',
                                                                                       'in_ucast_pkts': '328894883',
                                                                                       'mac_address': 'fc:ec:da:77:f3:2d',
                                                                                       'out_octets': '1570614971953',
                                                                                       'out_ucast_pkts': '2566960990'},
                                                                               {       'in_octets': '558499918375',
                                                                                       'in_ucast_pkts': '493921263',
                                                                                       'mac_address': '18:e8:29:1f:ed:3c',
                                                                                       'out_octets': '813778196218',
                                                                                       'out_ucast_pkts': '1312334169'}],
                                                              'mac_address': '18:e8:29:1f:08:85',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '9227381065030',
                                                              'out_ucast_pkts': '1726234572',
                                                              'radios': [       {       'chan_width': 50,
                                                                                        'dl_percent': 67,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5955,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '180396000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '11953894',
                                                                                                                                            'distance': 739,
                                                                                                                                            'mac_address': 'fc:ec:da:77:f3:2d',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -44.0,
                                                                                                                                            'rx_link_rate': '180396000',
                                                                                                                                            'snr': 53.0,
                                                                                                                                            'tx_link_rate': '317440000'},
                                                                                                                                    {       'connected_time': '4396037',
                                                                                                                                            'distance': 793,
                                                                                                                                            'mac_address': '18:e8:29:1f:ed:3c',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '180396000',
                                                                                                                                            'snr': 47.0,
                                                                                                                                            'tx_link_rate': '396800000'}],
                                                                                                                   'noise_floor': -97.0}],
                                                                                        'tx_link_rate': '357120000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'CBB44'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 0.0,
                                'longitude': 0.0,
                                'manufacturer': 'Ubiquiti',
                                'mem': 82.37317,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.1.0-505967',
                                'system_mac_address': '18:e8:29:1f:08:85',
                                'uptime': '39679055'},
                'peers': [       {       'cpu': 40.9504,
                                         'elevation': 402.2,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1570614971953',
                                                                       'in_ucast_pkts': '2566960990',
                                                                       'links': [       {       'in_octets': '1570614971953',
                                                                                                'in_ucast_pkts': '2566960990',
                                                                                                'mac_address': '18:e8:29:1f:08:85',
                                                                                                'out_octets': '120199925779',
                                                                                                'out_ucast_pkts': '328894883'}],
                                                                       'mac_address': 'fc:ec:da:77:f3:2d',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '120199925779',
                                                                       'out_ucast_pkts': '328894883',
                                                                       'radios': [       {       'chan_width': 50,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5955,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '317440000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '11953894',
                                                                                                                                                     'distance': 739,
                                                                                                                                                     'mac_address': '18:e8:29:1f:08:85',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '317440000',
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '180396000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '180396000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'CBB44'}]},
                                                               {       'bridged_mac_addresses': [       'fc:ec:da:44:cf:1f'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '120199925779',
                                                                       'in_ucast_pkts': '328894883',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1570614971953',
                                                                       'out_ucast_pkts': '2566960990',
                                                                       'poller_hash': 'ZmNlY2RhNzdmMzJkZXRoMA=='}],
                                         'latitude': 40.514027,
                                         'longitude': -78.408038,
                                         'management_ip': '192.168.41.10',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.261696,
                                         'model': 'LTU-Pro',
                                         'name': 'Agudath_LTU_PRO',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0-505967',
                                         'system_mac_address': 'fc:ec:da:77:f3:2d',
                                         'temperature': 57.0,
                                         'uptime': '11954068'},
                                 {       'cpu': 36.7195,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '813778196218',
                                                                       'in_ucast_pkts': '1312334169',
                                                                       'links': [       {       'in_octets': '813778196218',
                                                                                                'in_ucast_pkts': '1312334169',
                                                                                                'mac_address': '18:e8:29:1f:08:85',
                                                                                                'out_octets': '558499918375',
                                                                                                'out_ucast_pkts': '493921263'}],
                                                                       'mac_address': '18:e8:29:1f:ed:3c',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '558499918375',
                                                                       'out_ucast_pkts': '493921263',
                                                                       'radios': [       {       'chan_width': 50,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5955,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '396800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4396037',
                                                                                                                                                     'distance': 793,
                                                                                                                                                     'mac_address': '18:e8:29:1f:08:85',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -44.0,
                                                                                                                                                     'rx_link_rate': '396800000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '180396000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '180396000',
                                                                                                 'tx_power': 16}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'CBB44'}]},
                                                               {       'bridged_mac_addresses': [       '18:b1:69:0c:f9:6f'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '558499918375',
                                                                       'in_ucast_pkts': '493921263',
                                                                       'name': 'eth0',
                                                                       'out_octets': '813778196218',
                                                                       'out_ucast_pkts': '1312334169',
                                                                       'poller_hash': 'MThlODI5MWZlZDNjZXRoMA=='}],
                                         'latitude': 40.515157,
                                         'longitude': -78.405868,
                                         'management_ip': '192.168.44.10',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.90755,
                                         'model': 'LTU-LR',
                                         'name': 'D&H-LTULR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.1.0-505967',
                                         'system_mac_address': '18:e8:29:1f:ed:3c',
                                         'temperature': 61.0,
                                         'uptime': '4520715'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_2_0_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.2.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5765,
                'rf_tx_power': 20,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v2.2.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 47.826088,
                'dl_en_bytes': 190979422697,
                'dl_en_packets': 267719182,
                'dl_rf_bytes': 190660458071,
                'dl_rf_packets': 267357182,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 103236064173,
                'ul_en_packets': 158601608,
                'ul_rf_bytes': 103247804876,
                'ul_rf_packets': 160365386
        }
        exp_sta_stats = {
                'f4:92:bf:2f:df:20': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 138240000,
                                             'dl_rf_bytes': 190656697573,
                                             'dl_rf_packets': 267272831,
                                             'ip_address': '8.24.111.70',
                                             'mac_address': 'f4:92:bf:2f:df:20',
                                             'name': '1462399- Bond, Michelle',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 103248933834,
                                             'ul_rf_packets': 160366610}
        }
        exp_ne_msg = {
                'data': {       'cpu': 47.826088,
                                'elevation': 472.1,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '190979422697',
                                                              'in_ucast_pkts': '267719182',
                                                              'mac_address': 'e6:63:da:0f:90:46',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '103236064173',
                                                              'out_ucast_pkts': '158601608',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '103247804876',
                                                              'in_ucast_pkts': '160365386',
                                                              'links': [       {       'in_octets': '103248933834',
                                                                                       'in_ucast_pkts': '160366610',
                                                                                       'mac_address': 'f4:92:bf:2f:df:20',
                                                                                       'out_octets': '190656697573',
                                                                                       'out_ucast_pkts': '267272831'}],
                                                              'mac_address': 'e0:63:da:0f:90:46',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '190660458071',
                                                              'out_ucast_pkts': '267357182',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5765,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '37437000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '847338',
                                                                                                                                            'distance': 10594,
                                                                                                                                            'mac_address': 'f4:92:bf:2f:df:20',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -25.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 67.0,
                                                                                                                                            'tx_link_rate': '138240000'}],
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_link_rate': '138240000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Haase '
                                                                                                 'LTU '
                                                                                                 'NE '
                                                                                                 '30'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 44.053729,
                                'longitude': -91.781343,
                                'manufacturer': 'Ubiquiti',
                                'mem': 86.529205,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.2.0',
                                'system_mac_address': 'e0:63:da:0f:90:46',
                                'temperature': 51.0,
                                'uptime': '847417'},
                'peers': [       {       'cpu': 39.2979,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '190656697573',
                                                                       'in_ucast_pkts': '267272831',
                                                                       'links': [       {       'in_octets': '190656697573',
                                                                                                'in_ucast_pkts': '267272831',
                                                                                                'mac_address': 'e0:63:da:0f:90:46',
                                                                                                'out_octets': '103248933834',
                                                                                                'out_ucast_pkts': '160366610'}],
                                                                       'mac_address': 'f4:92:bf:2f:df:20',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '103248933834',
                                                                       'out_ucast_pkts': '160366610',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5765,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '138240000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '847338',
                                                                                                                                                     'distance': 10594,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:90:46',
                                                                                                                                                     'noise_floor': -100.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '138240000',
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -100.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Haase '
                                                                                                          'LTU '
                                                                                                          'NE '
                                                                                                          '30'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '103248933834',
                                                                       'in_ucast_pkts': '160366610',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '190656697573',
                                                                       'out_ucast_pkts': '267272831',
                                                                       'poller_hash': 'ZjQ5MmJmMmZkZjIwZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '8.24.111.70',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.17396,
                                         'model': 'LTU-LR',
                                         'name': '1462399- Bond, Michelle',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:2f:df:20',
                                         'temperature': 70.0,
                                         'uptime': '847565'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_2_0_02(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.2.0.02")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5840,
                'rf_tx_power': 18,
                'sta_count': 9,
                'sta_mode_cpe': False,
                'sw_version': 'v2.2.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 54.628689,
                'dl_en_bytes': 74634483307485,
                'dl_en_packets': 3621939586,
                'dl_rf_bytes': 73993783647192,
                'dl_rf_packets': 3809946440,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 11,
                'ul_en_bytes': 3782633233633,
                'ul_en_packets': 3610123318,
                'ul_rf_bytes': 4010081582979,
                'ul_rf_packets': 16542573
        }
        exp_sta_stats = {
                '78:45:58:5f:08:0b': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 105600000,
                                             'dl_rf_bytes': 1670007484984,
                                             'dl_rf_packets': 1321915583,
                                             'ip_address': '140.190.38.206',
                                             'mac_address': '78:45:58:5f:08:0b',
                                             'name': '1760799- Copeland,Sara',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 65208478199,
                                             'ul_rf_packets': 555202825},
                'd0:21:f9:f6:0c:fa': {       'alt_macs': ['d0:21:f9:f7:0c:fa'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 156765540987,
                                             'dl_rf_packets': 154044133,
                                             'ip_address': '140.190.38.238',
                                             'mac_address': 'd0:21:f9:f6:0c:fa',
                                             'name': '69115-Dammen,dan',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 14845376457,
                                             'ul_rf_packets': 61943637},
                'd0:21:f9:f6:2a:6a': {       'alt_macs': ['d0:21:f9:f7:2a:6a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 231294884186,
                                             'dl_rf_packets': 184007772,
                                             'ip_address': '140.190.38.234',
                                             'mac_address': 'd0:21:f9:f6:2a:6a',
                                             'name': '1617599:Althoff,Julia',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 8830212534,
                                             'ul_rf_packets': 43149352},
                'e0:63:da:bf:cf:e5': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 105600000,
                                             'dl_rf_bytes': 1312486574874,
                                             'dl_rf_packets': 1122954712,
                                             'ip_address': '140.190.38.218',
                                             'mac_address': 'e0:63:da:bf:cf:e5',
                                             'name': '72646- Waldo Cassandra',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 79238953127,
                                             'ul_rf_packets': 536247444},
                'f4:92:bf:2f:d9:39': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 76571465771,
                                             'dl_rf_packets': 124917921,
                                             'ip_address': '140.190.38.215',
                                             'mac_address': 'f4:92:bf:2f:d9:39',
                                             'name': '74375 - Gernes, Doug',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 6686876323,
                                             'ul_rf_packets': 28801540},
                'f4:92:bf:2f:e0:e2': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 176000000,
                                             'dl_rf_bytes': 224847862089,
                                             'dl_rf_packets': 184176540,
                                             'ip_address': '140.190.38.228',
                                             'mac_address': 'f4:92:bf:2f:e0:e2',
                                             'name': '144799-MEYER,SAMANTHA',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 6922925586,
                                             'ul_rf_packets': 47791836},
                'f4:92:bf:5f:a0:ff': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 88688449452,
                                             'dl_rf_packets': 136116016,
                                             'ip_address': '140.190.38.216',
                                             'mac_address': 'f4:92:bf:5f:a0:ff',
                                             'name': '69037 - Langowski, Troy & Sheila',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 9392705540,
                                             'ul_rf_packets': 25048621},
                'f4:92:bf:5f:a2:8b': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 1670714404107,
                                             'dl_rf_packets': 1379114478,
                                             'ip_address': '140.190.38.212',
                                             'mac_address': 'f4:92:bf:5f:a2:8b',
                                             'name': '13944- Crabtree, Joe',
                                             'ul_link_rate': 37437000,
                                             'ul_rf_bytes': 89326386609,
                                             'ul_rf_packets': 617158235},
                'f4:92:bf:5f:b0:75': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 140800000,
                                             'dl_rf_bytes': 334492307435,
                                             'dl_rf_packets': 251584645,
                                             'ip_address': '140.190.38.239',
                                             'mac_address': 'f4:92:bf:5f:b0:75',
                                             'name': '12260-Nissalke,Dan',
                                             'ul_link_rate': 28078000,
                                             'ul_rf_bytes': 12709585934,
                                             'ul_rf_packets': 75019462}
        }
        exp_ne_msg = {
                'data': {       'cpu': 54.62869,
                                'elevation': 500.9,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '74634483307485',
                                                              'in_ucast_pkts': '3621939586',
                                                              'mac_address': 'e6:63:da:0f:80:06',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '3782633233633',
                                                              'out_ucast_pkts': '3610123318',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '4010081582979',
                                                              'in_ucast_pkts': '16542573',
                                                              'links': [       {       'in_octets': '89326386609',
                                                                                       'in_ucast_pkts': '617158235',
                                                                                       'mac_address': 'f4:92:bf:5f:a2:8b',
                                                                                       'out_octets': '1670714404107',
                                                                                       'out_ucast_pkts': '1379114478'},
                                                                               {       'in_octets': '65208478199',
                                                                                       'in_ucast_pkts': '555202825',
                                                                                       'mac_address': '78:45:58:5f:08:0b',
                                                                                       'out_octets': '1670007484984',
                                                                                       'out_ucast_pkts': '1321915583'},
                                                                               {       'in_octets': '79238953127',
                                                                                       'in_ucast_pkts': '536247444',
                                                                                       'mac_address': 'e0:63:da:bf:cf:e5',
                                                                                       'out_octets': '1312486574874',
                                                                                       'out_ucast_pkts': '1122954712'},
                                                                               {       'in_octets': '6686876323',
                                                                                       'in_ucast_pkts': '28801540',
                                                                                       'mac_address': 'f4:92:bf:2f:d9:39',
                                                                                       'out_octets': '76571465771',
                                                                                       'out_ucast_pkts': '124917921'},
                                                                               {       'in_octets': '9392705540',
                                                                                       'in_ucast_pkts': '25048621',
                                                                                       'mac_address': 'f4:92:bf:5f:a0:ff',
                                                                                       'out_octets': '88688449452',
                                                                                       'out_ucast_pkts': '136116016'},
                                                                               {       'in_octets': '14845376457',
                                                                                       'in_ucast_pkts': '61943637',
                                                                                       'mac_address': 'd0:21:f9:f6:0c:fa',
                                                                                       'out_octets': '156765540987',
                                                                                       'out_ucast_pkts': '154044133'},
                                                                               {       'in_octets': '6922925586',
                                                                                       'in_ucast_pkts': '47791836',
                                                                                       'mac_address': 'f4:92:bf:2f:e0:e2',
                                                                                       'out_octets': '224847862089',
                                                                                       'out_ucast_pkts': '184176540'},
                                                                               {       'in_octets': '8830212534',
                                                                                       'in_ucast_pkts': '43149352',
                                                                                       'mac_address': 'd0:21:f9:f6:2a:6a',
                                                                                       'out_octets': '231294884186',
                                                                                       'out_ucast_pkts': '184007772'},
                                                                               {       'in_octets': '12709585934',
                                                                                       'in_ucast_pkts': '75019462',
                                                                                       'mac_address': 'f4:92:bf:5f:b0:75',
                                                                                       'out_octets': '334492307435',
                                                                                       'out_ucast_pkts': '251584645'}],
                                                              'mac_address': 'e0:63:da:0f:80:06',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '73993783647192',
                                                              'out_ucast_pkts': '3809946440',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5840,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '31197000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '4454656',
                                                                                                                                            'distance': 4567,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:a2:8b',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -24.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 64.0,
                                                                                                                                            'tx_link_rate': '140800000'},
                                                                                                                                    {       'connected_time': '4454653',
                                                                                                                                            'distance': 4640,
                                                                                                                                            'mac_address': '78:45:58:5f:08:0b',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -18.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 70.0,
                                                                                                                                            'tx_link_rate': '105600000'},
                                                                                                                                    {       'connected_time': '4454652',
                                                                                                                                            'distance': 7051,
                                                                                                                                            'mac_address': 'e0:63:da:bf:cf:e5',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -18.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 70.0,
                                                                                                                                            'tx_link_rate': '105600000'},
                                                                                                                                    {       'connected_time': '1747895',
                                                                                                                                            'distance': 6515,
                                                                                                                                            'mac_address': 'f4:92:bf:2f:d9:39',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 62.0,
                                                                                                                                            'tx_link_rate': '140800000'},
                                                                                                                                    {       'connected_time': '1747894',
                                                                                                                                            'distance': 6502,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:a0:ff',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -21.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 67.0,
                                                                                                                                            'tx_link_rate': '140800000'},
                                                                                                                                    {       'connected_time': '490890',
                                                                                                                                            'distance': 6448,
                                                                                                                                            'mac_address': 'd0:21:f9:f6:0c:fa',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -22.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 66.0,
                                                                                                                                            'tx_link_rate': '140800000'},
                                                                                                                                    {       'connected_time': '490889',
                                                                                                                                            'distance': 1125,
                                                                                                                                            'mac_address': 'f4:92:bf:2f:e0:e2',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -29.0,
                                                                                                                                            'rx_link_rate': '37437000',
                                                                                                                                            'snr': 59.0,
                                                                                                                                            'tx_link_rate': '176000000'},
                                                                                                                                    {       'connected_time': '490885',
                                                                                                                                            'distance': 6643,
                                                                                                                                            'mac_address': 'd0:21:f9:f6:2a:6a',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -23.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '140800000'},
                                                                                                                                    {       'connected_time': '490860',
                                                                                                                                            'distance': 4419,
                                                                                                                                            'mac_address': 'f4:92:bf:5f:b0:75',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -26.0,
                                                                                                                                            'rx_link_rate': '28078000',
                                                                                                                                            'snr': 62.0,
                                                                                                                                            'tx_link_rate': '140800000'}],
                                                                                                                   'noise_floor': -88.0}],
                                                                                        'tx_link_rate': '136888000',
                                                                                        'tx_power': 18}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Wilson '
                                                                                                 'LTU '
                                                                                                 '120'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 43.962107,
                                'longitude': -91.687567,
                                'manufacturer': 'Ubiquiti',
                                'mem': 82.032486,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.2.0',
                                'system_mac_address': 'e0:63:da:0f:80:06',
                                'temperature': 51.0,
                                'uptime': '37228003'},
                'peers': [       {       'cpu': 34.0748,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1670714404107',
                                                                       'in_ucast_pkts': '1379114478',
                                                                       'links': [       {       'in_octets': '1670714404107',
                                                                                                'in_ucast_pkts': '1379114478',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '89326386609',
                                                                                                'out_ucast_pkts': '617158235'}],
                                                                       'mac_address': 'f4:92:bf:5f:a2:8b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '89326386609',
                                                                       'out_ucast_pkts': '617158235',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4454656',
                                                                                                                                                     'distance': 4567,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '89326386609',
                                                                       'in_ucast_pkts': '617158235',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1670714404107',
                                                                       'out_ucast_pkts': '1379114478',
                                                                       'poller_hash': 'ZjQ5MmJmNWZhMjhiZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 43.935776,
                                         'longitude': -91.646326,
                                         'management_ip': '140.190.38.212',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 87.631996,
                                         'model': 'LTU-LR',
                                         'name': '13944- Crabtree, Joe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:5f:a2:8b',
                                         'temperature': 79.0,
                                         'uptime': '4454725'},
                                 {       'cpu': 33.3333,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1670007484984',
                                                                       'in_ucast_pkts': '1321915583',
                                                                       'links': [       {       'in_octets': '1670007484984',
                                                                                                'in_ucast_pkts': '1321915583',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '65208478199',
                                                                                                'out_ucast_pkts': '555202825'}],
                                                                       'mac_address': '78:45:58:5f:08:0b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '65208478199',
                                                                       'out_ucast_pkts': '555202825',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '105600000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4454653',
                                                                                                                                                     'distance': 4640,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -95.0,
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '105600000',
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -95.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '65208478199',
                                                                       'in_ucast_pkts': '555202825',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1670007484984',
                                                                       'out_ucast_pkts': '1321915583',
                                                                       'poller_hash': 'Nzg0NTU4NWYwODBiZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '140.190.38.206',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 87.11208,
                                         'model': 'LTU-LR',
                                         'name': '1760799- Copeland,Sara',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': '78:45:58:5f:08:0b',
                                         'temperature': 67.0,
                                         'uptime': '4454721'},
                                 {       'cpu': 35.6275,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1312486574874',
                                                                       'in_ucast_pkts': '1122954712',
                                                                       'links': [       {       'in_octets': '1312486574874',
                                                                                                'in_ucast_pkts': '1122954712',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '79238953127',
                                                                                                'out_ucast_pkts': '536247444'}],
                                                                       'mac_address': 'e0:63:da:bf:cf:e5',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '79238953127',
                                                                       'out_ucast_pkts': '536247444',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '105600000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4454652',
                                                                                                                                                     'distance': 7051,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '105600000',
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -97.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '79238953127',
                                                                       'in_ucast_pkts': '536247444',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1312486574874',
                                                                       'out_ucast_pkts': '1122954712',
                                                                       'poller_hash': 'ZTA2M2RhYmZjZmU1ZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 43.923168,
                                         'longitude': -91.620501,
                                         'management_ip': '140.190.38.218',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.48936,
                                         'model': 'LTU-LR',
                                         'name': '72646- Waldo Cassandra',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'e0:63:da:bf:cf:e5',
                                         'temperature': 64.0,
                                         'uptime': '4454719'},
                                 {       'cpu': 35.4838,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '76571465771',
                                                                       'in_ucast_pkts': '124917921',
                                                                       'links': [       {       'in_octets': '76571465771',
                                                                                                'in_ucast_pkts': '124917921',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '6686876323',
                                                                                                'out_ucast_pkts': '28801540'}],
                                                                       'mac_address': 'f4:92:bf:2f:d9:39',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6686876323',
                                                                       'out_ucast_pkts': '28801540',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1747895',
                                                                                                                                                     'distance': 6515,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '6686876323',
                                                                       'in_ucast_pkts': '28801540',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '76571465771',
                                                                       'out_ucast_pkts': '124917921',
                                                                       'poller_hash': 'ZjQ5MmJmMmZkOTM5ZXRoMA==',
                                                                       'speed': '100000000'}],
                                         'latitude': 43.935778,
                                         'longitude': -91.646333,
                                         'management_ip': '140.190.38.215',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.22617,
                                         'model': 'LTU-LR',
                                         'name': '74375 - Gernes, Doug',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:2f:d9:39',
                                         'temperature': 64.0,
                                         'uptime': '1747936'},
                                 {       'cpu': 32.3559,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '88688449452',
                                                                       'in_ucast_pkts': '136116016',
                                                                       'links': [       {       'in_octets': '88688449452',
                                                                                                'in_ucast_pkts': '136116016',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '9392705540',
                                                                                                'out_ucast_pkts': '25048621'}],
                                                                       'mac_address': 'f4:92:bf:5f:a0:ff',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9392705540',
                                                                       'out_ucast_pkts': '25048621',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1747894',
                                                                                                                                                     'distance': 6502,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '9392705540',
                                                                       'in_ucast_pkts': '25048621',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '88688449452',
                                                                       'out_ucast_pkts': '136116016',
                                                                       'poller_hash': 'ZjQ5MmJmNWZhMGZmZXRoMA==',
                                                                       'speed': '100000000'}],
                                         'latitude': 43.935778,
                                         'longitude': -91.646333,
                                         'management_ip': '140.190.38.216',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.43876,
                                         'model': 'LTU-LR',
                                         'name': '69037 - Langowski, Troy & Sheila',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:5f:a0:ff',
                                         'temperature': 60.0,
                                         'uptime': '1747940'},
                                 {       'cpu': 30.2325,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '156765540987',
                                                                       'in_ucast_pkts': '154044133',
                                                                       'links': [       {       'in_octets': '156765540987',
                                                                                                'in_ucast_pkts': '154044133',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '14845376457',
                                                                                                'out_ucast_pkts': '61943637'}],
                                                                       'mac_address': 'd0:21:f9:f6:0c:fa',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14845376457',
                                                                       'out_ucast_pkts': '61943637',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '490890',
                                                                                                                                                     'distance': 6448,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '14845376457',
                                                                       'in_ucast_pkts': '61943637',
                                                                       'mac_address': 'd0:21:f9:f7:0c:fa',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '156765540987',
                                                                       'out_ucast_pkts': '154044133',
                                                                       'speed': '1000000000'}],
                                         'latitude': 43.5649,
                                         'longitude': 91.3642,
                                         'management_ip': '140.190.38.238',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 76.215004,
                                         'model': 'LTU-LR',
                                         'name': '69115-Dammen,dan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.3.1',
                                         'system_mac_address': 'd0:21:f9:f6:0c:fa',
                                         'temperature': 61.0,
                                         'uptime': '490917'},
                                 {       'cpu': 32.5252,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '224847862089',
                                                                       'in_ucast_pkts': '184176540',
                                                                       'links': [       {       'in_octets': '224847862089',
                                                                                                'in_ucast_pkts': '184176540',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '6922925586',
                                                                                                'out_ucast_pkts': '47791836'}],
                                                                       'mac_address': 'f4:92:bf:2f:e0:e2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6922925586',
                                                                       'out_ucast_pkts': '47791836',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '176000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '490889',
                                                                                                                                                     'distance': 1125,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '176000000',
                                                                                                                                                     'snr': 45.0,
                                                                                                                                                     'tx_link_rate': '37437000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '37437000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '6922925586',
                                                                       'in_ucast_pkts': '47791836',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '224847862089',
                                                                       'out_ucast_pkts': '184176540',
                                                                       'poller_hash': 'ZjQ5MmJmMmZlMGUyZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 43.955546,
                                         'longitude': -91.67924,
                                         'management_ip': '140.190.38.228',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 88.52488,
                                         'model': 'LTU-LR',
                                         'name': '144799-MEYER,SAMANTHA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:2f:e0:e2',
                                         'temperature': 51.0,
                                         'uptime': '490920'},
                                 {       'cpu': 54.6733,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '231294884186',
                                                                       'in_ucast_pkts': '184007772',
                                                                       'links': [       {       'in_octets': '231294884186',
                                                                                                'in_ucast_pkts': '184007772',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '8830212534',
                                                                                                'out_ucast_pkts': '43149352'}],
                                                                       'mac_address': 'd0:21:f9:f6:2a:6a',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8830212534',
                                                                       'out_ucast_pkts': '43149352',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '490885',
                                                                                                                                                     'distance': 6643,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '8830212534',
                                                                       'in_ucast_pkts': '43149352',
                                                                       'mac_address': 'd0:21:f9:f7:2a:6a',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '231294884186',
                                                                       'out_ucast_pkts': '184007772',
                                                                       'speed': '1000000000'}],
                                         'latitude': 43.5618,
                                         'longitude': -91.6848,
                                         'management_ip': '140.190.38.234',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 74.95075,
                                         'model': 'LTU-LR',
                                         'name': '1617599:Althoff,Julia',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.3.1',
                                         'system_mac_address': 'd0:21:f9:f6:2a:6a',
                                         'temperature': 51.0,
                                         'uptime': '490918'},
                                 {       'cpu': 39.309,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '334492307435',
                                                                       'in_ucast_pkts': '251584645',
                                                                       'links': [       {       'in_octets': '334492307435',
                                                                                                'in_ucast_pkts': '251584645',
                                                                                                'mac_address': 'e0:63:da:0f:80:06',
                                                                                                'out_octets': '12709585934',
                                                                                                'out_ucast_pkts': '75019462'}],
                                                                       'mac_address': 'f4:92:bf:5f:b0:75',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12709585934',
                                                                       'out_ucast_pkts': '75019462',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '490860',
                                                                                                                                                     'distance': 4419,
                                                                                                                                                     'mac_address': 'e0:63:da:0f:80:06',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '140800000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '28078000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '28078000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wilson '
                                                                                                          'LTU '
                                                                                                          '120'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'eth0',
                                                                       'in_octets': '12709585934',
                                                                       'in_ucast_pkts': '75019462',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '334492307435',
                                                                       'out_ucast_pkts': '251584645',
                                                                       'poller_hash': 'ZjQ5MmJmNWZiMDc1ZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 0.0,
                                         'longitude': 0.0,
                                         'management_ip': '140.190.38.239',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 89.89246,
                                         'model': 'LTU-LR',
                                         'name': '12260-Nissalke,Dan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v2.2.0',
                                         'system_mac_address': 'f4:92:bf:5f:b0:75',
                                         'temperature': 62.0,
                                         'uptime': '490921'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_ltu_LTU_Rocket_v2_2_1_01(self):
        obj = self.run_data("ubnt.ltu.LTU-Rocket.v2.2.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'LTU-Rocket',
                'rf_chan_width': 20,
                'rf_freq': 5750,
                'rf_tx_power': 30,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v2.2.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 47.724976,
                'dl_en_bytes': 9989056501077,
                'dl_en_packets': 3961012747,
                'dl_rf_bytes': 9993529330868,
                'dl_rf_packets': 4038930434,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 10,
                'ul_en_bytes': 822312232013,
                'ul_en_packets': 271313478,
                'ul_rf_bytes': 841384172956,
                'ul_rf_packets': 342223779
        }
        exp_sta_stats = {
                '78:45:58:0b:76:54': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 115200000,
                                             'dl_rf_bytes': 3758536508535,
                                             'dl_rf_packets': 2983150823,
                                             'ip_address': '10.17.186.144',
                                             'mac_address': '78:45:58:0b:76:54',
                                             'name': 'RES - Etheridge, Patricia',
                                             'ul_link_rate': 106796000,
                                             'ul_rf_bytes': 281173751746,
                                             'ul_rf_packets': 1743776520},
                '78:45:58:0b:76:c7': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 115200000,
                                             'dl_rf_bytes': 286567199118,
                                             'dl_rf_packets': 397038640,
                                             'ip_address': '10.17.186.148',
                                             'mac_address': '78:45:58:0b:76:c7',
                                             'name': 'RES - Mulkey, Kathy',
                                             'ul_link_rate': 106796000,
                                             'ul_rf_bytes': 50540129065,
                                             'ul_rf_packets': 184711746},
                'e0:63:da:bf:b9:bf': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 115200000,
                                             'dl_rf_bytes': 4111063111855,
                                             'dl_rf_packets': 3694589262,
                                             'ip_address': '10.17.186.140',
                                             'mac_address': 'e0:63:da:bf:b9:bf',
                                             'name': 'RES - Brower, Sadie',
                                             'ul_link_rate': 106796000,
                                             'ul_rf_bytes': 341893283257,
                                             'ul_rf_packets': 1883180520}
        }
        exp_ne_msg = {
                'data': {       'cpu': 47.724976,
                                'elevation': 369.8,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '9989056501077',
                                                              'in_ucast_pkts': '3961012747',
                                                              'mac_address': 'f2:92:bf:2f:0b:b5',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '822312232013',
                                                              'out_ucast_pkts': '271313478',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_octets': '841384172956',
                                                              'in_ucast_pkts': '342223779',
                                                              'links': [       {       'in_octets': '341893283257',
                                                                                       'in_ucast_pkts': '1883180520',
                                                                                       'mac_address': 'e0:63:da:bf:b9:bf',
                                                                                       'out_octets': '4111063111855',
                                                                                       'out_ucast_pkts': '3694589262'},
                                                                               {       'in_octets': '281173751746',
                                                                                       'in_ucast_pkts': '1743776520',
                                                                                       'mac_address': '78:45:58:0b:76:54',
                                                                                       'out_octets': '3758536508535',
                                                                                       'out_ucast_pkts': '2983150823'},
                                                                               {       'in_octets': '50540129065',
                                                                                       'in_ucast_pkts': '184711746',
                                                                                       'mac_address': '78:45:58:0b:76:c7',
                                                                                       'out_octets': '286567199118',
                                                                                       'out_ucast_pkts': '397038640'}],
                                                              'mac_address': 'f4:92:bf:2f:0b:b5',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_octets': '9993529330868',
                                                              'out_ucast_pkts': '4038930434',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 2000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5750,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '106796000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '11983101',
                                                                                                                                            'distance': 850,
                                                                                                                                            'mac_address': 'e0:63:da:bf:b9:bf',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -34.0,
                                                                                                                                            'rx_link_rate': '106796000',
                                                                                                                                            'snr': 54.0,
                                                                                                                                            'tx_link_rate': '115200000'},
                                                                                                                                    {       'connected_time': '11983099',
                                                                                                                                            'distance': 596,
                                                                                                                                            'mac_address': '78:45:58:0b:76:54',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -36.0,
                                                                                                                                            'rx_link_rate': '106796000',
                                                                                                                                            'snr': 52.0,
                                                                                                                                            'tx_link_rate': '115200000'},
                                                                                                                                    {       'connected_time': '11481226',
                                                                                                                                            'distance': 502,
                                                                                                                                            'mac_address': '78:45:58:0b:76:c7',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -30.0,
                                                                                                                                            'rx_link_rate': '106796000',
                                                                                                                                            'snr': 58.0,
                                                                                                                                            'tx_link_rate': '115200000'}],
                                                                                                                   'noise_floor': -88.0}],
                                                                                        'tx_link_rate': '115200000',
                                                                                        'tx_power': 30}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BB-BV-SE-LTU-60'}],
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 61.078923,
                                'longitude': -149.724724,
                                'manufacturer': 'Ubiquiti',
                                'mem': 82.44099,
                                'model': 'LTU-Rocket',
                                'sw_version': 'v2.2.1',
                                'system_mac_address': 'f4:92:bf:2f:0b:b5',
                                'temperature': 44.0,
                                'uptime': '18731978'},
                'peers': [       {       'cpu': 31.3765,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '4111063111855',
                                                                       'in_ucast_pkts': '3694589262',
                                                                       'links': [       {       'in_octets': '4111063111855',
                                                                                                'in_ucast_pkts': '3694589262',
                                                                                                'mac_address': 'f4:92:bf:2f:0b:b5',
                                                                                                'out_octets': '341893283257',
                                                                                                'out_ucast_pkts': '1883180520'}],
                                                                       'mac_address': 'e0:63:da:bf:b9:bf',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '341893283257',
                                                                       'out_ucast_pkts': '1883180520',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 2000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '115200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '11983101',
                                                                                                                                                     'distance': 850,
        