import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestStarOsModels(DeviceTestCase):
    def setUp(self):
        super().setUp()

    def test_staros_staros_StarOS_None_01(self):
        obj = self.run_data("staros.staros.StarOS.None.01")
        exp_info = {
                'model': 'StarOS',
                'rf_freq': 2462,
                'sta_count': 0,
                'sw_version': b'Version 0.0.2 - 2007-12-22',
                'vendor': 'StarOS'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '2',
                                                              'mac_address': '00:19:5f:01:08:4b',
                                                              'name': 'eth0'},
                                                      {       'id': '4',
                                                              'mac_address': '00:15:6d:63:a1:8a',
                                                              'name': 'wifi0',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'StarOS',
                                'model': 'StarOS',
                                'sw_version': 'Version 0.0.2 - 2007-12-22',
                                'system_mac_address': '00:19:5f:01:08:4b'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
