import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestKwikbitModels(DeviceTestCase):
    def test_kwikbit_k60_K60_3_11_194_01(self):
        obj = self.run_data("kwikbit.k60.K60.3.11.194.01")
        exp_info = {
                'model': 'K60',
                'rf_freq': 62640,
                'sta_count': 2,
                'sw_version': '3.11.194',
                'vendor': 'Kwikbit'
        }
        exp_stats = {
                'dl_en_bytes': 3330147079034,
                'dl_en_packets': 2221207558,
                'dl_rf_bytes': 3356609188021,
                'dl_rf_packets': 2220822576,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 80567021140,
                'ul_en_packets': 1090589013,
                'ul_rf_bytes': 96369507882,
                'ul_rf_packets': 1089179626
        }
        exp_sta_stats = {
                '30:ab:6a:c3:b4:55': {       'alt_macs': ['70:88:6b:c6:1d:64'],
                                             'dev_macs': {'28:76:10:22:9a:15'},
                                             'dl_rf_bytes': 83730245847,
                                             'dl_rf_packets': 61698834,
                                             'dl_rssi': None,
                                             'ip_address': '10.200.0.77',
                                             'mac_address': '30:ab:6a:c3:b4:55',
                                             'name': 'KB-C6-1D-64',
                                             'ul_rf_bytes': 4051803596,
                                             'ul_rf_packets': 15374503,
                                             'ul_rssi': None},
                '30:ab:6a:c3:b4:a6': {       'alt_macs': ['70:88:6b:c6:19:b4'],
                                             'dev_macs': {'00:5f:67:ec:64:67'},
                                             'dl_rf_bytes': 3272596268470,
                                             'dl_rf_packets': 2158933788,
                                             'dl_rssi': None,
                                             'ip_address': '10.200.0.87',
                                             'mac_address': '30:ab:6a:c3:b4:a6',
                                             'name': 'KB-C6-19-B4',
                                             'ul_rf_bytes': 92303766563,
                                             'ul_rf_packets': 1073688515,
                                             'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_octets': '96369507882',
                                                              'in_ucast_pkts': '1089179626',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '92303766563',
                                                                                       'in_ucast_pkts': '1073688515',
                                                                                       'mac_address': '30:ab:6a:c3:b4:a6',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '6876',
                                                                                       'out_octets': '3272596268470',
                                                                                       'out_ucast_pkts': '2158933788'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '4051803596',
                                                                                       'in_ucast_pkts': '15374503',
                                                                                       'mac_address': '30:ab:6a:c3:b4:55',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '5035',
                                                                                       'out_octets': '83730245847',
                                                                                       'out_ucast_pkts': '61698834'}],
                                                              'mac_address': '30:ab:6a:c3:b7:af',
                                                              'mtu': 1612,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '7',
                                                              'out_errors': '13422',
                                                              'out_octets': '3356609188021',
                                                              'out_ucast_pkts': '2220822576',
                                                              'radios': [       {       'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '362230',
                                                                                                                                            'mac_address': '30:ab:6a:c3:b4:a6',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_mcs': 1},
                                                                                                                                    {       'connected_time': '212243',
                                                                                                                                            'mac_address': '30:ab:6a:c3:b4:55',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Kwikbit-TI'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_discards': '669525',
                                                              'in_errors': '0',
                                                              'in_octets': '3330147079034',
                                                              'in_ucast_pkts': '2221207558',
                                                              'mac_address': '70:88:6b:c6:14:d5',
                                                              'mtu': 1596,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '80567021140',
                                                              'out_ucast_pkts': '1090589013',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Kwikbit',
                                'model': 'K60',
                                'name': 'Kwikbit Black',
                                'serial_number': '699611KM21130001010KB-C6-14-D4:4',
                                'sw_version': '3.11.194',
                                'system_mac_address': '70:88:6b:c6:14:d4',
                                'uptime': '444892'},
                'peers': [       {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '6876',
                                                                       'in_octets': '3272596268470',
                                                                       'in_ucast_pkts': '2158933788',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '92303766563',
                                                                                                'in_ucast_pkts': '1073688515',
                                                                                                'mac_address': '30:ab:6a:c3:b4:a6',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '6876',
                                                                                                'out_octets': '3272596268470',
                                                                                                'out_ucast_pkts': '2158933788'}],
                                                                       'mac_address': '30:ab:6a:c3:b4:a6',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '92303766563',
                                                                       'out_ucast_pkts': '1073688515',
                                                                       'radios': [       {       'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362230',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:b4:a6'}]}]}]},
                                                               {       'bridged_mac_addresses': [       '00:5f:67:ec:64:67'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:19:b4',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.200.0.87',
                                         'name': 'KB-C6-19-B4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:19:b4'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '5035',
                                                                       'in_octets': '83730245847',
                                                                       'in_ucast_pkts': '61698834',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '4051803596',
                                                                                                'in_ucast_pkts': '15374503',
                                                                                                'mac_address': '30:ab:6a:c3:b4:55',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '5035',
                                                                                                'out_octets': '83730245847',
                                                                                                'out_ucast_pkts': '61698834'}],
                                                                       'mac_address': '30:ab:6a:c3:b4:55',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '4051803596',
                                                                       'out_ucast_pkts': '15374503',
                                                                       'radios': [       {       'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '212243',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:b4:55'}]}]}]},
                                                               {       'bridged_mac_addresses': [       '28:76:10:22:9a:15'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:1d:64',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.200.0.77',
                                         'name': 'KB-C6-1D-64',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:1d:64'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_kwikbit_k60_K60_3_13_01(self):
        obj = self.run_data("kwikbit.k60.K60.3.13.01")
        exp_info = {
                'model': 'K60',
                'rf_freq': 58320,
                'sta_count': 3,
                'sw_version': '3.13.204',
                'vendor': 'Kwikbit'
        }
        exp_stats = {
                'dl_en_bytes': 12343313858554,
                'dl_en_packets': 9473064168,
                'dl_rf_bytes': 12502867254576,
                'dl_rf_packets': 9963242537,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 1308968521876,
                'ul_en_packets': 3479392193,
                'ul_rf_bytes': 1311520401509,
                'ul_rf_packets': 3392870430
        }
        exp_sta_stats = {
                '30:ab:6a:c2:38:75': {       'alt_macs': ['70:88:6b:c6:2b:7e'],
                                             'dev_macs': {'f8:8e:a1:52:35:b4'},
                                             'dl_rf_bytes': 253033430635,
                                             'dl_rf_packets': 215813671,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.44',
                                             'mac_address': '30:ab:6a:c2:38:75',
                                             'name': 'KB-C6-2B-7E',
                                             'ul_rf_bytes': 60973790129,
                                             'ul_rf_packets': 96772136,
                                             'ul_rssi': None},
                '30:ab:6a:c3:bf:28': {       'alt_macs': ['70:88:6b:c6:2b:56'],
                                             'dev_macs': {'f8:8e:a1:52:37:58'},
                                             'dl_rf_bytes': 176652406705,
                                             'dl_rf_packets': 207020731,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.46',
                                             'mac_address': '30:ab:6a:c3:bf:28',
                                             'name': 'KB-C6-2B-56',
                                             'ul_rf_bytes': 67395251176,
                                             'ul_rf_packets': 97991221,
                                             'ul_rssi': None},
                '30:ab:6a:c3:bf:60': {       'alt_macs': ['70:88:6b:c6:2b:8c'],
                                             'dev_macs': {'f8:8e:a1:52:34:4c'},
                                             'dl_rf_bytes': 900290772954,
                                             'dl_rf_packets': 708008018,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.38',
                                             'mac_address': '30:ab:6a:c3:bf:60',
                                             'name': 'KB-C6-2B-8C',
                                             'ul_rf_bytes': 134495760456,
                                             'ul_rf_packets': 291947510,
                                             'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '1311520401509',
                                                              'in_ucast_pkts': '3392870430',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '60973790129',
                                                                                       'in_ucast_pkts': '96772136',
                                                                                       'mac_address': '30:ab:6a:c2:38:75',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '4779',
                                                                                       'out_octets': '253033430635',
                                                                                       'out_ucast_pkts': '215813671'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '67395251176',
                                                                                       'in_ucast_pkts': '97991221',
                                                                                       'mac_address': '30:ab:6a:c3:bf:28',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '4481',
                                                                                       'out_octets': '176652406705',
                                                                                       'out_ucast_pkts': '207020731'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '134495760456',
                                                                                       'in_ucast_pkts': '291947510',
                                                                                       'mac_address': '30:ab:6a:c3:bf:60',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '67657',
                                                                                       'out_octets': '900290772954',
                                                                                       'out_ucast_pkts': '708008018'}],
                                                              'mac_address': '30:ab:6a:c1:3b:7d',
                                                              'mtu': 1612,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '4504',
                                                              'out_errors': '159427',
                                                              'out_octets': '12502867254576',
                                                              'out_ucast_pkts': '9963242537',
                                                              'radios': [       {       'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1018121',
                                                                                                                                            'mac_address': '30:ab:6a:c2:38:75',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2420963',
                                                                                                                                            'mac_address': '30:ab:6a:c3:bf:28',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2420966',
                                                                                                                                            'mac_address': '30:ab:6a:c3:bf:60',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_mcs': 1}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KBAccess'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_discards': '4615154',
                                                              'in_errors': '0',
                                                              'in_octets': '12343313858554',
                                                              'in_ucast_pkts': '9473064168',
                                                              'mac_address': '70:88:6b:c6:1f:5d',
                                                              'mtu': 1596,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '1308968521876',
                                                              'out_ucast_pkts': '3479392193',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Kwikbit',
                                'model': 'K60',
                                'name': 'KBAccess-RecCenter-340Degrees-Ch1',
                                'serial_number': '699611KM21320001028KB-C6-1F-5C:4',
                                'sw_version': '3.13.204',
                                'system_mac_address': '70:88:6b:c6:1f:5c',
                                'uptime': '18929756'},
                'peers': [       {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '4779',
                                                                       'in_octets': '253033430635',
                                                                       'in_ucast_pkts': '215813671',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '60973790129',
                                                                                                'in_ucast_pkts': '96772136',
                                                                                                'mac_address': '30:ab:6a:c2:38:75',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '4779',
                                                                                                'out_octets': '253033430635',
                                                                                                'out_ucast_pkts': '215813671'}],
                                                                       'mac_address': '30:ab:6a:c2:38:75',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '60973790129',
                                                                       'out_ucast_pkts': '96772136',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1018121',
                                                                                                                                                     'mac_address': '30:ab:6a:c2:38:75'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:35:b4'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:2b:7e',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.44',
                                         'name': 'KB-C6-2B-7E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:2b:7e'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '4481',
                                                                       'in_octets': '176652406705',
                                                                       'in_ucast_pkts': '207020731',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '67395251176',
                                                                                                'in_ucast_pkts': '97991221',
                                                                                                'mac_address': '30:ab:6a:c3:bf:28',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '4481',
                                                                                                'out_octets': '176652406705',
                                                                                                'out_ucast_pkts': '207020731'}],
                                                                       'mac_address': '30:ab:6a:c3:bf:28',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '67395251176',
                                                                       'out_ucast_pkts': '97991221',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2420963',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:bf:28'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:37:58'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:2b:56',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.46',
                                         'name': 'KB-C6-2B-56',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:2b:56'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '67657',
                                                                       'in_octets': '900290772954',
                                                                       'in_ucast_pkts': '708008018',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '134495760456',
                                                                                                'in_ucast_pkts': '291947510',
                                                                                                'mac_address': '30:ab:6a:c3:bf:60',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '67657',
                                                                                                'out_octets': '900290772954',
                                                                                                'out_ucast_pkts': '708008018'}],
                                                                       'mac_address': '30:ab:6a:c3:bf:60',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '134495760456',
                                                                       'out_ucast_pkts': '291947510',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2420966',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:bf:60'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:34:4c'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:2b:8c',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.38',
                                         'name': 'KB-C6-2B-8C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:2b:8c'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_kwikbit_k60_K60_3_13_02(self):
        obj = self.run_data("kwikbit.k60.K60.3.13.02")
        exp_info = {
                'model': 'K60',
                'rf_freq': 58320,
                'sta_count': 4,
                'sw_version': '3.13.204',
                'vendor': 'Kwikbit'
        }
        exp_stats = {
                'dl_en_bytes': 2133362765233,
                'dl_en_packets': 1830665364,
                'dl_rf_bytes': 2167282375253,
                'dl_rf_packets': 1930151068,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 762051920371,
                'ul_en_packets': 953500834,
                'ul_rf_bytes': 768438062513,
                'ul_rf_packets': 943271573
        }
        exp_sta_stats = {
                '30:ab:6a:c3:b4:de': {       'alt_macs': ['70:88:6b:c6:1c:20'],
                                             'dev_macs': {'f8:8e:a1:52:37:62'},
                                             'dl_rf_bytes': 34178412147,
                                             'dl_rf_packets': 124111941,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.21',
                                             'mac_address': '30:ab:6a:c3:b4:de',
                                             'name': 'KB-C6-1C-20',
                                             'ul_rf_bytes': 104387609301,
                                             'ul_rf_packets': 109998116,
                                             'ul_rssi': None},
                '30:ab:6a:c3:b4:f5': {       'alt_macs': ['70:88:6b:c6:1b:de'],
                                             'dev_macs': {'f8:8e:a1:52:33:89'},
                                             'dl_rf_bytes': 169189543249,
                                             'dl_rf_packets': 203290176,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.29',
                                             'mac_address': '30:ab:6a:c3:b4:f5',
                                             'name': 'KB-C6-1B-DE',
                                             'ul_rf_bytes': 51840919761,
                                             'ul_rf_packets': 73316646,
                                             'ul_rssi': None},
                '30:ab:6a:c3:bf:00': {       'alt_macs': ['70:88:6b:c6:2a:f4'],
                                             'dev_macs': {'f8:8e:a1:52:35:32'},
                                             'dl_rf_bytes': 1261608772954,
                                             'dl_rf_packets': 985902343,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.40',
                                             'mac_address': '30:ab:6a:c3:bf:00',
                                             'name': 'KB-C6-2A-F4',
                                             'ul_rf_bytes': 142475575382,
                                             'ul_rf_packets': 283401301,
                                             'ul_rssi': None},
                '30:ab:6a:c3:bf:2b': {       'alt_macs': ['70:88:6b:c6:2b:66'],
                                             'dev_macs': {'4c:ed:fb:7c:7d:d8'},
                                             'dl_rf_bytes': 217271133274,
                                             'dl_rf_packets': 204815498,
                                             'dl_rssi': None,
                                             'ip_address': '10.201.0.51',
                                             'mac_address': '30:ab:6a:c3:bf:2b',
                                             'name': 'KB-C6-2B-66',
                                             'ul_rf_bytes': 258165761178,
                                             'ul_rf_packets': 222344876,
                                             'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '768438062513',
                                                              'in_ucast_pkts': '943271573',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '104387609301',
                                                                                       'in_ucast_pkts': '109998116',
                                                                                       'mac_address': '30:ab:6a:c3:b4:de',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '1146',
                                                                                       'out_octets': '34178412147',
                                                                                       'out_ucast_pkts': '124111941'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '51840919761',
                                                                                       'in_ucast_pkts': '73316646',
                                                                                       'mac_address': '30:ab:6a:c3:b4:f5',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '22842',
                                                                                       'out_octets': '169189543249',
                                                                                       'out_ucast_pkts': '203290176'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '258165761178',
                                                                                       'in_ucast_pkts': '222344876',
                                                                                       'mac_address': '30:ab:6a:c3:bf:2b',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '3593',
                                                                                       'out_octets': '217271133274',
                                                                                       'out_ucast_pkts': '204815498'},
                                                                               {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '142475575382',
                                                                                       'in_ucast_pkts': '283401301',
                                                                                       'mac_address': '30:ab:6a:c3:bf:00',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '8423',
                                                                                       'out_octets': '1261608772954',
                                                                                       'out_ucast_pkts': '985902343'}],
                                                              'mac_address': '30:ab:6a:c1:3a:8f',
                                                              'mtu': 1612,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '1218',
                                                              'out_errors': '43645',
                                                              'out_octets': '2167282375253',
                                                              'out_ucast_pkts': '1930151068',
                                                              'radios': [       {       'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2513370',
                                                                                                                                            'mac_address': '30:ab:6a:c3:b4:de',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '2420995',
                                                                                                                                            'mac_address': '30:ab:6a:c3:b4:f5',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '778994',
                                                                                                                                            'mac_address': '30:ab:6a:c3:bf:2b',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '2420994',
                                                                                                                                            'mac_address': '30:ab:6a:c3:bf:00',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_mcs': 8}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KBAccess'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_discards': '9812285',
                                                              'in_errors': '0',
                                                              'in_octets': '2133362765233',
                                                              'in_ucast_pkts': '1830665364',
                                                              'mac_address': '70:88:6b:c6:20:41',
                                                              'mtu': 1596,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '12611',
                                                              'out_errors': '0',
                                                              'out_octets': '762051920371',
                                                              'out_ucast_pkts': '953500834',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Kwikbit',
                                'model': 'K60',
                                'name': 'KBAccess-GHouseSouthMid-205Degrees-Ch1',
                                'serial_number': '699611KM21320001085KB-C6-20-40:4',
                                'sw_version': '3.13.204',
                                'system_mac_address': '70:88:6b:c6:20:40',
                                'uptime': '2513374'},
                'peers': [       {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '1146',
                                                                       'in_octets': '34178412147',
                                                                       'in_ucast_pkts': '124111941',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '104387609301',
                                                                                                'in_ucast_pkts': '109998116',
                                                                                                'mac_address': '30:ab:6a:c3:b4:de',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '1146',
                                                                                                'out_octets': '34178412147',
                                                                                                'out_ucast_pkts': '124111941'}],
                                                                       'mac_address': '30:ab:6a:c3:b4:de',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '104387609301',
                                                                       'out_ucast_pkts': '109998116',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2513370',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:b4:de'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:37:62'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:1c:20',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.21',
                                         'name': 'KB-C6-1C-20',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:1c:20'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '22842',
                                                                       'in_octets': '169189543249',
                                                                       'in_ucast_pkts': '203290176',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '51840919761',
                                                                                                'in_ucast_pkts': '73316646',
                                                                                                'mac_address': '30:ab:6a:c3:b4:f5',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '22842',
                                                                                                'out_octets': '169189543249',
                                                                                                'out_ucast_pkts': '203290176'}],
                                                                       'mac_address': '30:ab:6a:c3:b4:f5',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '51840919761',
                                                                       'out_ucast_pkts': '73316646',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2420995',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:b4:f5'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:33:89'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:1b:de',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.29',
                                         'name': 'KB-C6-1B-DE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:1b:de'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '3593',
                                                                       'in_octets': '217271133274',
                                                                       'in_ucast_pkts': '204815498',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '258165761178',
                                                                                                'in_ucast_pkts': '222344876',
                                                                                                'mac_address': '30:ab:6a:c3:bf:2b',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '3593',
                                                                                                'out_octets': '217271133274',
                                                                                                'out_ucast_pkts': '204815498'}],
                                                                       'mac_address': '30:ab:6a:c3:bf:2b',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '258165761178',
                                                                       'out_ucast_pkts': '222344876',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '778994',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:bf:2b'}]}]}]},
                                                               {       'bridged_mac_addresses': [       '4c:ed:fb:7c:7d:d8'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:2b:66',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.51',
                                         'name': 'KB-C6-2B-66',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:2b:66'},
                                 {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '8423',
                                                                       'in_octets': '1261608772954',
                                                                       'in_ucast_pkts': '985902343',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '142475575382',
                                                                                                'in_ucast_pkts': '283401301',
                                                                                                'mac_address': '30:ab:6a:c3:bf:00',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '8423',
                                                                                                'out_octets': '1261608772954',
                                                                                                'out_ucast_pkts': '985902343'}],
                                                                       'mac_address': '30:ab:6a:c3:bf:00',
                                                                       'name': 'wlan',
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_octets': '142475575382',
                                                                       'out_ucast_pkts': '283401301',
                                                                       'radios': [       {       'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2420994',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:bf:00'}]}]}]},
                                                               {       'bridged_mac_addresses': [       'f8:8e:a1:52:35:32'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:2a:f4',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.201.0.40',
                                         'name': 'KB-C6-2A-F4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:2a:f4'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_kwikbit_k60_K60x_3_16_217_01(self):
        obj = self.run_data("kwikbit.k60.K60x.3.16.217.01")
        exp_info = {
                'model': 'K60x',
                'rf_freq': 60480,
                'sta_count': 1,
                'sw_version': '3.16.217',
                'vendor': 'Kwikbit'
        }
        exp_stats = {
                'dl_en_bytes': 601041362,
                'dl_en_packets': 1148293,
                'dl_rf_bytes': 35308914,
                'dl_rf_packets': 58491,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 4865932103,
                'ul_en_packets': 13643817,
                'ul_rf_bytes': 207739070,
                'ul_rf_packets': 347307
        }
        exp_sta_stats = {
                '30:ab:6a:c3:b6:12': {       'alt_macs': ['70:88:6b:c6:1a:4c'],
                                             'dev_macs': {       '00:22:4d:d8:e1:f4',
                                                                 '00:22:4d:d8:e1:f5',
                                                                 '00:5f:67:ec:64:67',
                                                                 '00:90:0b:8f:ff:f2',
                                                                 '00:90:0b:8f:ff:f7',
                                                                 '08:12:a5:59:4d:18',
                                                                 '08:55:31:df:bc:2a',
                                                                 '08:55:31:df:bc:30',
                                                                 '08:55:31:df:bc:34',
                                                                 '14:44:8f:3c:cd:11',
                                                                 '14:44:8f:3c:cf:5a',
                                                                 '28:76:10:1f:d9:a8',
                                                                 '28:76:10:22:97:7b',
                                                                 '28:76:10:22:97:9f',
                                                                 '28:76:10:22:97:f9',
                                                                 '28:76:10:22:99:97',
                                                                 '28:76:10:22:99:df',
                                                                 '28:76:10:22:9a:15',
                                                                 '28:76:10:23:cb:62',
                                                                 '28:76:10:23:cc:ac',
                                                                 '28:76:10:23:cd:ba',
                                                                 '28:76:10:23:ce:73',
                                                                 '28:76:10:23:cf:9f',
                                                                 '28:76:10:23:cf:c2',
                                                                 '28:76:10:23:d2:88',
                                                                 '42:f6:d9:94:28:73',
                                                                 '4c:38:d5:11:f8:2b',
                                                                 '4c:38:d5:11:f8:2c',
                                                                 '4c:38:d5:12:06:1a',
                                                                 '5a:c1:7a:92:06:64',
                                                                 '5a:c1:7a:92:06:fe',
                                                                 '5a:c1:7a:92:07:6c',
                                                                 '5a:c1:7a:92:08:4a',
                                                                 '5a:c1:7a:92:09:6a',
                                                                 '5c:8f:e0:c4:4b:37',
                                                                 '5e:1c:00:86:41:2e',
                                                                 '70:88:6b:c6:0e:f8',
                                                                 '70:88:6b:c6:0f:00',
                                                                 '70:88:6b:c6:0f:28',
                                                                 '70:88:6b:c6:0f:34',
                                                                 '70:88:6b:c6:0f:38',
                                                                 '70:88:6b:c6:0f:d0',
                                                                 '70:88:6b:c6:10:40',
                                                                 '70:88:6b:c6:10:58',
                                                                 '70:88:6b:c6:10:98',
                                                                 '70:88:6b:c6:10:a4',
                                                                 '70:88:6b:c6:10:b4',
                                                                 '70:88:6b:c6:10:bc',
                                                                 '70:88:6b:c6:14:d4',
                                                                 '70:88:6b:c6:14:e8',
                                                                 '70:88:6b:c6:15:04',
                                                                 '70:88:6b:c6:15:0c',
                                                                 '70:88:6b:c6:15:14',
                                                                 '70:88:6b:c6:16:c4',
                                                                 '70:88:6b:c6:17:08',
                                                                 '70:88:6b:c6:19:94',
                                                                 '70:88:6b:c6:19:a2',
                                                                 '70:88:6b:c6:19:a6',
                                                                 '70:88:6b:c6:19:ac',
                                                                 '70:88:6b:c6:19:b2',
                                                                 '70:88:6b:c6:19:b4',
                                                                 '70:88:6b:c6:19:b6',
                                                                 '70:88:6b:c6:19:b8',
                                                                 '70:88:6b:c6:19:ba',
                                                                 '70:88:6b:c6:19:c0',
                                                                 '70:88:6b:c6:19:c2',
                                                                 '70:88:6b:c6:19:d0',
                                                                 '70:88:6b:c6:19:d2',
                                                                 '70:88:6b:c6:19:d6',
                                                                 '70:88:6b:c6:19:dc',
                                                                 '70:88:6b:c6:19:de',
                                                                 '70:88:6b:c6:19:f2',
                                                                 '70:88:6b:c6:19:f6',
                                                                 '70:88:6b:c6:19:fa',
                                                                 '70:88:6b:c6:19:fc',
                                                                 '70:88:6b:c6:1a:00',
                                                                 '70:88:6b:c6:1a:12',
                                                                 '70:88:6b:c6:1a:48',
                                                                 '70:88:6b:c6:1a:70',
                                                                 '70:88:6b:c6:1a:b4',
                                                                 '70:88:6b:c6:1a:c4',
                                                                 '70:88:6b:c6:1b:00',
                                                                 '70:88:6b:c6:1b:ce',
                                                                 '70:88:6b:c6:1b:d6',
                                                                 '70:88:6b:c6:1c:1c',
                                                                 '70:88:6b:c6:1c:66',
                                                                 '70:88:6b:c6:1c:7c',
                                                                 '70:88:6b:c6:1c:ec',
                                                                 '70:88:6b:c6:1d:34',
                                                                 '70:88:6b:c6:1d:36',
                                                                 '70:88:6b:c6:1d:44',
                                                                 '70:88:6b:c6:1d:46',
                                                                 '70:88:6b:c6:1d:64',
                                                                 '70:88:6b:c6:1d:9a',
                                                                 '70:88:6b:c6:1d:a6',
                                                                 '70:88:6b:c6:1d:a8',
                                                                 '70:88:6b:c6:1d:ae',
                                                                 '70:88:6b:c6:1d:b4',
                                                                 '70:88:6b:c6:1d:e2',
                                                                 '70:88:6b:c6:1d:fc',
                                                                 '70:88:6b:c6:1e:08',
                                                                 '70:88:6b:c6:1e:0e',
                                                                 '70:88:6b:c6:1e:1e',
                                                                 '70:88:6b:c6:1f:f4',
                                                                 '70:88:6b:c6:20:58',
                                                                 '70:88:6b:c6:20:d0',
                                                                 '70:88:6b:c6:21:14',
                                                                 '70:88:6b:c6:29:70',
                                                                 '70:88:6b:c6:29:a8',
                                                                 '70:88:6b:c6:2a:18',
                                                                 '70:88:6b:c6:2a:22',
                                                                 '70:88:6b:c6:2a:9e',
                                                                 '70:88:6b:c6:2a:be',
                                                                 '70:88:6b:c6:2b:80',
                                                                 '70:88:6b:c6:2c:d0',
                                                                 '70:88:6b:c6:2c:d4',
                                                                 '70:88:6b:c6:2c:dc',
                                                                 '70:88:6b:c6:2c:f0',
                                                                 '8c:1c:da:e8:24:45',
                                                                 '98:19:2c:f9:d7:c4',
                                                                 '98:19:2c:f9:dc:29',
                                                                 'ac:4a:56:f5:61:e4',
                                                                 'ac:4a:56:f5:9c:ed',
                                                                 'ac:4a:56:f5:9c:ef',
                                                                 'ac:4a:56:f5:e6:b8',
                                                                 'ae:16:ae:90:30:29',
                                                                 'd4:91:0f:cd:e3:30',
                                                                 'f8:0b:cb:11:51:3f',
                                                                 'f8:8e:a1:4b:54:32',
                                                                 'f8:8e:a1:4b:54:78',
                                                                 'f8:8e:a1:4b:54:96',
                                                                 'f8:8e:a1:4b:54:9b',
                                                                 'f8:8e:a1:4b:54:c3',
                                                                 'f8:8e:a1:4b:54:d2',
                                                                 'f8:8e:a1:4b:54:f5',
                                                                 'f8:8e:a1:4b:54:ff',
                                                                 'f8:8e:a1:4b:55:04',
                                                                 'f8:8e:a1:4b:55:09',
                                                                 'f8:8e:a1:52:33:93',
                                                                 'f8:8e:a1:52:33:d9',
                                                                 'f8:8e:a1:52:33:e3',
                                                                 'f8:8e:a1:52:33:ed',
                                                                 'f8:8e:a1:52:33:f2',
                                                                 'f8:8e:a1:52:34:2e',
                                                                 'f8:8e:a1:52:34:33',
                                                                 'f8:8e:a1:52:34:65',
                                                                 'f8:8e:a1:52:34:88',
                                                                 'f8:8e:a1:52:34:a6',
                                                                 'f8:8e:a1:52:34:b0',
                                                                 'f8:8e:a1:52:34:e2',
                                                                 'f8:8e:a1:52:34:e7',
                                                                 'f8:8e:a1:52:35:37',
                                                                 'f8:8e:a1:52:35:55',
                                                                 'f8:8e:a1:52:36:36',
                                                                 'f8:8e:a1:52:36:3b',
                                                                 'f8:8e:a1:52:36:40',
                                                                 'f8:8e:a1:52:36:ea',
                                                                 'f8:8e:a1:52:37:44',
                                                                 'f8:8e:a1:52:37:4e'},
                                             'dl_rf_bytes': 1474112,
                                             'dl_rf_packets': 2410,
                                             'dl_rssi': None,
                                             'ip_address': '10.200.0.27',
                                             'mac_address': '30:ab:6a:c3:b6:12',
                                             'name': 'KB-C6-1A-4C',
                                             'ul_rf_bytes': 7940569,
                                             'ul_rf_packets': 12752,
                                             'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'wlan0',
                                                              'in_discards': '13264',
                                                              'in_errors': '0',
                                                              'in_octets': '207739070',
                                                              'in_ucast_pkts': '347307',
                                                              'links': [       {       'in_discards': '1221',
                                                                                       'in_errors': '0',
                                                                                       'in_octets': '7940569',
                                                                                       'in_ucast_pkts': '12752',
                                                                                       'mac_address': '30:ab:6a:c3:b6:12',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_octets': '1474112',
                                                                                       'out_ucast_pkts': '2410'}],
                                                              'mac_address': 'b0:00:73:c7:1e:02',
                                                              'mtu': 1612,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '183',
                                                              'out_octets': '35308914',
                                                              'out_ucast_pkts': '58491',
                                                              'radios': [       {       'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '482',
                                                                                                                                            'mac_address': '30:ab:6a:c3:b6:12',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'tx_mcs': 1}]}]}],
                                                              'sectors': [       {       'mode': 'STA',
                                                                                         'ssid': 'Kwikbit-Distro'}],
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': 'eth1',
                                                              'in_discards': '629302',
                                                              'in_errors': '0',
                                                              'in_octets': '601041362',
                                                              'in_ucast_pkts': '1148293',
                                                              'mac_address': '70:88:6b:c6:0f:49',
                                                              'mtu': 1596,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '4865932103',
                                                              'out_ucast_pkts': '13643817',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Kwikbit',
                                'model': 'K60x',
                                'name': 'K60x MainOffice Distro to GuardShack',
                                'serial_number': '649710KM20310001043KB-C6-0F-48:4',
                                'sw_version': '3.16.217',
                                'system_mac_address': '70:88:6b:c6:0f:48',
                                'uptime': '900882'},
                'peers': [       {       'interfaces': [       {       'id': 'wlan',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_octets': '1474112',
                                                                       'in_ucast_pkts': '2410',
                                                                       'links': [       {       'in_discards': '1221',
                                                                                                'in_errors': '0',
                                                                                                'in_octets': '7940569',
                                                                                                'in_ucast_pkts': '12752',
                                                                                                'mac_address': '30:ab:6a:c3:b6:12',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_octets': '1474112',
                                                                                                'out_ucast_pkts': '2410'}],
                                                                       'mac_address': '30:ab:6a:c3:b6:12',
                                                                       'name': 'wlan',
                                                                       'out_discards': '1221',
                                                                       'out_errors': '0',
                                                                       'out_octets': '7940569',
                                                                       'out_ucast_pkts': '12752',
                                                                       'radios': [       {       'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '482',
                                                                                                                                                     'mac_address': '30:ab:6a:c3:b6:12'}]}]}]},
                                                               {       'bridged_mac_addresses': [       '00:90:0b:8f:ff:f7',
                                                                                                        '28:76:10:22:97:9f',
                                                                                                        '28:76:10:22:97:f9',
                                                                                                        '28:76:10:1f:d9:a8',
                                                                                                        'ae:16:ae:90:30:29',
                                                                                                        '28:76:10:22:97:7b',
                                                                                                        '5e:1c:00:86:41:2e',
                                                                                                        '8c:1c:da:e8:24:45',
                                                                                                        'f8:8e:a1:52:36:3b',
                                                                                                        '28:76:10:22:99:97',
                                                                                                        'ac:4a:56:f5:e6:b8',
                                                                                                        'f8:8e:a1:4b:54:f5',
                                                                                                        'f8:8e:a1:52:33:f2',
                                                                                                        'f8:8e:a1:4b:54:ff',
                                                                                                        'f8:8e:a1:52:33:93',
                                                                                                        'f8:8e:a1:52:34:65',
                                                                                                        'f8:8e:a1:52:34:e2',
                                                                                                        'f8:8e:a1:52:36:ea',
                                                                                                        '28:76:10:22:99:df',
                                                                                                        '5a:c1:7a:92:08:4a',
                                                                                                        'f8:8e:a1:52:33:e3',
                                                                                                        'f8:8e:a1:52:37:4e',
                                                                                                        '70:88:6b:c6:1b:ce',
                                                                                                        '70:88:6b:c6:19:c0',
                                                                                                        '70:88:6b:c6:2a:18',
                                                                                                        '70:88:6b:c6:19:c2',
                                                                                                        '70:88:6b:c6:20:d0',
                                                                                                        '70:88:6b:c6:2a:9e',
                                                                                                        '70:88:6b:c6:1c:66',
                                                                                                        '70:88:6b:c6:14:e8',
                                                                                                        '70:88:6b:c6:19:ba',
                                                                                                        '70:88:6b:c6:21:14',
                                                                                                        '70:88:6b:c6:1d:34',
                                                                                                        '70:88:6b:c6:2c:dc',
                                                                                                        '70:88:6b:c6:19:b6',
                                                                                                        '70:88:6b:c6:1d:9a',
                                                                                                        '70:88:6b:c6:1d:a8',
                                                                                                        '70:88:6b:c6:19:dc',
                                                                                                        '70:88:6b:c6:19:d6',
                                                                                                        '70:88:6b:c6:1d:46',
                                                                                                        '70:88:6b:c6:15:0c',
                                                                                                        '70:88:6b:c6:1d:e2',
                                                                                                        '70:88:6b:c6:19:a6',
                                                                                                        '70:88:6b:c6:2c:d4',
                                                                                                        '70:88:6b:c6:19:a2',
                                                                                                        '70:88:6b:c6:19:b8',
                                                                                                        '70:88:6b:c6:2a:22',
                                                                                                        '70:88:6b:c6:19:b2',
                                                                                                        '70:88:6b:c6:1c:7c',
                                                                                                        '70:88:6b:c6:1f:f4',
                                                                                                        'f8:8e:a1:4b:54:d2',
                                                                                                        '00:5f:67:ec:64:67',
                                                                                                        '28:76:10:23:cf:9f',
                                                                                                        'f8:8e:a1:52:34:a6',
                                                                                                        'f8:8e:a1:4b:54:c3',
                                                                                                        '28:76:10:22:9a:15',
                                                                                                        'f8:8e:a1:4b:54:96',
                                                                                                        'f8:8e:a1:52:36:36',
                                                                                                        '5a:c1:7a:92:06:fe',
                                                                                                        'f8:8e:a1:52:36:40',
                                                                                                        '5a:c1:7a:92:07:6c',
                                                                                                        '42:f6:d9:94:28:73',
                                                                                                        '70:88:6b:c6:15:14',
                                                                                                        '70:88:6b:c6:19:de',
                                                                                                        '70:88:6b:c6:1a:12',
                                                                                                        '70:88:6b:c6:1c:ec',
                                                                                                        '70:88:6b:c6:1c:1c',
                                                                                                        '70:88:6b:c6:1d:64',
                                                                                                        '70:88:6b:c6:19:fa',
                                                                                                        '70:88:6b:c6:2a:be',
                                                                                                        '70:88:6b:c6:19:fc',
                                                                                                        '70:88:6b:c6:1a:b4',
                                                                                                        '70:88:6b:c6:1d:a6',
                                                                                                        '70:88:6b:c6:1d:36',
                                                                                                        '70:88:6b:c6:1b:d6',
                                                                                                        '70:88:6b:c6:14:d4',
                                                                                                        '70:88:6b:c6:19:d2',
                                                                                                        '70:88:6b:c6:16:c4',
                                                                                                        '70:88:6b:c6:10:a4',
                                                                                                        '70:88:6b:c6:15:04',
                                                                                                        '70:88:6b:c6:0f:38',
                                                                                                        '70:88:6b:c6:19:f6',
                                                                                                        '70:88:6b:c6:1d:44',
                                                                                                        '70:88:6b:c6:1a:70',
                                                                                                        '70:88:6b:c6:29:a8',
                                                                                                        '70:88:6b:c6:19:d0',
                                                                                                        '70:88:6b:c6:19:b4',
                                                                                                        '70:88:6b:c6:17:08',
                                                                                                        '70:88:6b:c6:1e:08',
                                                                                                        '70:88:6b:c6:0e:f8',
                                                                                                        '70:88:6b:c6:0f:d0',
                                                                                                        '70:88:6b:c6:0f:28',
                                                                                                        '70:88:6b:c6:2c:d0',
                                                                                                        '70:88:6b:c6:19:ac',
                                                                                                        '70:88:6b:c6:10:58',
                                                                                                        '70:88:6b:c6:1a:c4',
                                                                                                        '70:88:6b:c6:1d:b4',
                                                                                                        '70:88:6b:c6:2c:f0',
                                                                                                        '70:88:6b:c6:0f:34',
                                                                                                        '70:88:6b:c6:0f:00',
                                                                                                        '70:88:6b:c6:1a:48',
                                                                                                        '70:88:6b:c6:1b:00',
                                                                                                        '70:88:6b:c6:29:70',
                                                                                                        '70:88:6b:c6:19:94',
                                                                                                        '70:88:6b:c6:1a:00',
                                                                                                        '70:88:6b:c6:19:f2',
                                                                                                        '70:88:6b:c6:1e:0e',
                                                                                                        '70:88:6b:c6:1e:1e',
                                                                                                        '70:88:6b:c6:2b:80',
                                                                                                        '70:88:6b:c6:1d:fc',
                                                                                                        '70:88:6b:c6:20:58',
                                                                                                        '70:88:6b:c6:10:b4',
                                                                                                        '70:88:6b:c6:1d:ae',
                                                                                                        '08:12:a5:59:4d:18',
                                                                                                        'f8:8e:a1:52:37:44',
                                                                                                        'f8:8e:a1:52:34:e7',
                                                                                                        'f8:8e:a1:4b:54:78',
                                                                                                        'ac:4a:56:f5:9c:ef',
                                                                                                        'f8:8e:a1:52:33:ed',
                                                                                                        'f8:8e:a1:52:33:d9',
                                                                                                        'f8:8e:a1:52:34:2e',
                                                                                                        'f8:8e:a1:4b:54:9b',
                                                                                                        '14:44:8f:3c:cd:11',
                                                                                                        'f8:8e:a1:4b:55:04',
                                                                                                        '14:44:8f:3c:cf:5a',
                                                                                                        'f8:8e:a1:52:35:37',
                                                                                                        '98:19:2c:f9:d7:c4',
                                                                                                        'f8:8e:a1:52:34:88',
                                                                                                        '98:19:2c:f9:dc:29',
                                                                                                        'f8:8e:a1:4b:55:09',
                                                                                                        'f8:8e:a1:52:34:b0',
                                                                                                        '5a:c1:7a:92:06:64',
                                                                                                        'f8:8e:a1:52:34:33',
                                                                                                        '08:55:31:df:bc:34',
                                                                                                        '08:55:31:df:bc:2a',
                                                                                                        'f8:8e:a1:52:35:55',
                                                                                                        '28:76:10:23:cc:ac',
                                                                                                        '28:76:10:23:cb:62',
                                                                                                        '28:76:10:23:ce:73',
                                                                                                        '00:22:4d:d8:e1:f4',
                                                                                                        '28:76:10:23:cf:c2',
                                                                                                        '5a:c1:7a:92:09:6a',
                                                                                                        '28:76:10:23:d2:88',
                                                                                                        '4c:38:d5:11:f8:2b',
                                                                                                        '28:76:10:23:cd:ba',
                                                                                                        '70:88:6b:c6:10:40',
                                                                                                        '70:88:6b:c6:10:98',
                                                                                                        '70:88:6b:c6:10:bc',
                                                                                                        'f8:8e:a1:4b:54:32',
                                                                                                        '5c:8f:e0:c4:4b:37',
                                                                                                        '4c:38:d5:11:f8:2c',
                                                                                                        '08:55:31:df:bc:30',
                                                                                                        '00:22:4d:d8:e1:f5',
                                                                                                        '00:90:0b:8f:ff:f2',
                                                                                                        '4c:38:d5:12:06:1a',
                                                                                                        'ac:4a:56:f5:9c:ed',
                                                                                                        'd4:91:0f:cd:e3:30',
                                                                                                        'ac:4a:56:f5:61:e4',
                                                                                                        'f8:0b:cb:11:51:3f'],
                                                                       'id': 'eth',
                                                                       'mac_address': '70:88:6b:c6:1a:4c',
                                                                       'name': 'eth'}],
                                         'management_ip': '10.200.0.27',
                                         'name': 'KB-C6-1A-4C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '70:88:6b:c6:1a:4c'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
