import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestRadioStats(DeviceTestCase):
    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 22,
                'sw_version': '4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 6
        }
        exp_sta_stats = {
                '68:d7:9a:06:a7:41': {       'dev_macs': ['2c:c8:1b:49:4c:df'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:a7:41',
                                             'name': '#15 14753 Melissa Smith'},
                '74:83:c2:43:fe:e7': {       'dev_macs': ['48:8f:5a:4e:d4:26'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:fe:e7',
                                             'name': '#10 12707 Laurel Schrang'},
                '74:83:c2:68:1f:80': {       'dev_macs': ['2c:c8:1b:49:64:1f'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:1f:80',
                                             'name': '#21 13024 Cindy Klugiewicz'},
                '74:83:c2:68:1f:fe': {       'dev_macs': ['48:8f:5a:c4:3d:5d'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:1f:fe',
                                             'name': '#17 12855 Pam Walter'},
                'b4:fb:e4:79:90:0b': {       'dev_macs': [       'c4:ad:34:40:74:55',
                                                                 'f0:9f:c2:08:80:d0'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:0b',
                                             'name': '#19 11810 Jason Davis'},
                'b4:fb:e4:79:90:51': {       'dev_macs': ['48:8f:5a:4e:d3:cb'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:51',
                                             'name': '#09 12025 Benjamin Durr'},
                'b4:fb:e4:79:90:92': {       'dev_macs': ['cc:2d:e0:91:ac:c5'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:92',
                                             'name': '#08 12313 Debra Zimbelman'},
                'b4:fb:e4:79:90:e2': {       'dev_macs': ['2c:c8:1b:49:63:8b'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:90:e2',
                                             'name': '#16 12185 Cody Chevalier'},
                'b4:fb:e4:79:9c:72': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:9c:72',
                                             'name': '#12 12449 VACANT'},
                'b4:fb:e4:eb:10:2c': {       'dev_macs': ['08:55:31:81:b3:22'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:10:2c',
                                             'name': '#02 11503 Nicholas Brieger'},
                'b4:fb:e4:eb:2b:57': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2b:57',
                                             'name': '#06 12193 VACANT'},
                'b4:fb:e4:eb:2b:d4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2b:d4',
                                             'name': '#22 11499 VACANT'},
                'b4:fb:e4:eb:2d:78': {       'dev_macs': ['c4:ad:34:40:73:ce'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:2d:78',
                                             'name': '#14 11601 Nicholas Peters'},
                'b4:fb:e4:f9:d6:88': {       'dev_macs': ['cc:2d:e0:91:ae:a8'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d6:88',
                                             'name': '#04 11629 Kristoffer Totos'},
                'b4:fb:e4:f9:d7:2d': {       'dev_macs': ['c4:ad:34:40:73:89'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:2d',
                                             'name': '#18 11537 Michael White'},
                'b4:fb:e4:f9:d7:3c': {       'dev_macs': ['cc:2d:e0:91:27:6e'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:3c',
                                             'name': '#23 11507 Chuck Rickards'},
                'b4:fb:e4:f9:d7:4b': {       'dev_macs': ['c4:ad:34:40:73:80'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:4b',
                                             'name': '#01 11849 Gary Neff'},
                'b4:fb:e4:f9:d7:55': {       'dev_macs': ['48:8f:5a:4e:d3:d9'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d7:55',
                                             'name': '#11 11609 Kelly Miller'},
                'b4:fb:e4:f9:d9:4e': {       'dev_macs': ['cc:2d:e0:91:ae:b6'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:4e',
                                             'name': '#20 11541 David Bluel'},
                'b4:fb:e4:f9:d9:62': {       'dev_macs': ['48:8f:5a:4e:d4:0a'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:62',
                                             'name': '#03 11528 Deirdra Hanners'},
                'b4:fb:e4:f9:d9:71': {       'dev_macs': ['cc:2d:e0:91:a4:12'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:d9:71',
                                             'name': '#07 12320 Lucas Piontkowski'},
                'b4:fb:e4:f9:da:f2': {       'dev_macs': ['cc:2d:e0:91:a9:36'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:f9:da:f2',
                                             'name': '#13 11936 Susan Cummings'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '83',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '147589048950',
                                                              'in_ucast_pkts': '525288465',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '136772539615',
                                                              'out_ucast_pkts': '653111196',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkZXRoMGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '17704692984121',
                                                              'in_ucast_pkts': '50631343977',
                                                              'links': [       {       'in_octets': '33519513519',
                                                                                       'out_octets': '902802075472',
                                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxcGVlcmludGY='},
                                                                               {       'in_octets': '27406148601',
                                                                                       'out_octets': '563043547298',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3cGVlcmludGY='},
                                                                               {       'in_octets': '22417660231',
                                                                                       'out_octets': '157368719312',
                                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwcGVlcmludGY='},
                                                                               {       'in_octets': '26911252637',
                                                                                       'out_octets': '257806782917',
                                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlcGVlcmludGY='},
                                                                               {       'in_octets': '2132227246',
                                                                                       'out_octets': '10137328279',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBicGVlcmludGY='},
                                                                               {       'in_octets': '5803933430',
                                                                                       'out_octets': '188152273569',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxcGVlcmludGY='},
                                                                               {       'in_octets': '34183478071',
                                                                                       'out_octets': '1328431239258',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkycGVlcmludGY='},
                                                                               {       'in_octets': '22202458405',
                                                                                       'out_octets': '277506574241',
                                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUycGVlcmludGY='},
                                                                               {       'in_octets': '1652995632',
                                                                                       'out_octets': '36117095748',
                                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjcGVlcmludGY='},
                                                                               {       'in_octets': '34378191363',
                                                                                       'out_octets': '1043877012242',
                                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4cGVlcmludGY='},
                                                                               {       'in_octets': '148556313823',
                                                                                       'out_octets': '1032306600644',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4cGVlcmludGY='},
                                                                               {       'in_octets': '343608052211',
                                                                                       'out_octets': '1033057469488',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkcGVlcmludGY='},
                                                                               {       'in_octets': '4037568999',
                                                                                       'out_octets': '21436654479',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjcGVlcmludGY='},
                                                                               {       'in_octets': '19600919925',
                                                                                       'out_octets': '188335141438',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRicGVlcmludGY='},
                                                                               {       'in_octets': '37886659693',
                                                                                       'out_octets': '561600328813',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1cGVlcmludGY='},
                                                                               {       'in_octets': '6338788982',
                                                                                       'out_octets': '77777982154',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlcGVlcmludGY='},
                                                                               {       'in_octets': '100281499482',
                                                                                       'out_octets': '1326028495831',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYycGVlcmludGY='},
                                                                               {       'in_octets': '626219251',
                                                                                       'out_octets': '5502382548',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxcGVlcmludGY='},
                                                                               {       'in_octets': '1049836548',
                                                                                       'out_octets': '34870727506',
                                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYycGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '152',
                                                              'out_octets': '170580221389923',
                                                              'out_ucast_pkts': '125884099823',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY=',
                                                              'pons': [       {       'description': 'Escalante',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '8104559',
                                                                                                               'fiber_length': 160,
                                                                                                               'poller_hash': 'NjhkNzlhMDZhNzQxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2386238',
                                                                                                               'fiber_length': 135,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmZWU3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104560',
                                                                                                               'fiber_length': 89,
                                                                                                               'poller_hash': 'NzQ4M2MyNjgxZjgwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104558',
                                                                                                               'fiber_length': 136,
                                                                                                               'poller_hash': 'NzQ4M2MyNjgxZmZlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1470464',
                                                                                                               'fiber_length': 113,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDBicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4375726',
                                                                                                               'fiber_length': 147,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDUxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104558',
                                                                                                               'fiber_length': 158,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDkycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4386466',
                                                                                                               'fiber_length': 148,
                                                                                                               'poller_hash': 'YjRmYmU0Nzk5MGUycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1428854',
                                                                                                               'fiber_length': 224,
                                                                                                               'poller_hash': 'YjRmYmU0ZWIxMDJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7072646',
                                                                                                               'fiber_length': 175,
                                                                                                               'poller_hash': 'YjRmYmU0ZWIyZDc4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '8104550',
                                                                                                               'fiber_length': 201,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNjg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1722055',
                                                                                                               'fiber_length': 124,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzJkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '93459',
                                                                                                               'fiber_length': 84,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzNjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2339528',
                                                                                                               'fiber_length': 235,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzRicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1478964',
                                                                                                               'fiber_length': 140,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzU1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1480754',
                                                                                                               'fiber_length': 100,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTRlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4723717',
                                                                                                               'fiber_length': 213,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '73619',
                                                                                                               'fiber_length': 169,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTcxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '613371',
                                                                                                               'fiber_length': 163,
                                                                                                               'poller_hash': 'YjRmYmU0ZjlkYWYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'name': 'pon2',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMmludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'name': 'pon4',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkcG9uNGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '170217517125291',
                                                              'in_ucast_pkts': '126109888153',
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-RJ45-1G',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '17649044948354',
                                                              'out_ucast_pkts': '50856362854',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkc2ZwMWludGY=',
                                                              'speed': '1000000000'},
                                                      {       'id': 'sfp2',
                                                              'name': 'SFP+ 2',
                                                              'poller_hash': 'YjRmYmU0YjQzZjFkc2ZwMmludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 17.0,
                                'model': 'UFiber OLT4',
                                'serial_number': 'UBNTe4b43f1d',
                                'sw_version': '4.0.5',
                                'system_mac_address': 'b4:fb:e4:b4:3f:1d',
                                'temperature': 34.75,
                                'uptime': '77941385'},
                'peers': [       {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0Nzk5YzcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5YzcycG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0Nzk5YzcyZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#12 12449 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4799c72',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:79:9c:72'},
                                 {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0ZWIyYjU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyYjU3cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0ZWIyYjU3ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#06 12193 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4eb2b57',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:eb:2b:57'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0ZWIyYmQ0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyYmQ0cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0ZWIyYmQ0ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': '#22 11499 VACANT',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected.',
                                         'serial_number': 'UBNTe4eb2bd4',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:eb:2b:d4'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '902802075472',
                                                                       'links': [       {       'in_octets': '902802075472',
                                                                                                'out_octets': '33519513519',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33519513519',
                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104559',
                                                                                                                        'fiber_length': 160,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.908,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.25}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDZhNzQxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:4c:df'],
                                                                       'id': '1',
                                                                       'in_octets': '33519513519',
                                                                       'mac_address': '68:d7:9a:07:a7:41',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '902802075472',
                                                                       'poller_hash': 'NjhkNzlhMDZhNzQxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#15 14753 Melissa Smith',
                                         'serial_number': 'UBNT9a06a741',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '68:d7:9a:06:a7:41',
                                         'temperature': 38.0,
                                         'uptime': '8104619'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '563043547298',
                                                                       'links': [       {       'in_octets': '563043547298',
                                                                                                'out_octets': '27406148601',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '27406148601',
                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2386238',
                                                                                                                        'fiber_length': 135,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.276,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.01}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmZWU3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d4:26'],
                                                                       'id': '1',
                                                                       'in_octets': '27406148601',
                                                                       'mac_address': '74:83:c2:44:fe:e7',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '563043547298',
                                                                       'poller_hash': 'NzQ4M2MyNDNmZWU3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#10 12707 Laurel Schrang',
                                         'serial_number': 'UBNTc243fee7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:43:fe:e7',
                                         'temperature': 38.0,
                                         'uptime': '3812018'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '157368719312',
                                                                       'links': [       {       'in_octets': '157368719312',
                                                                                                'out_octets': '22417660231',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '22417660231',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104560',
                                                                                                                        'fiber_length': 89,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.93,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.474}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjgxZjgwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:64:1f'],
                                                                       'id': '1',
                                                                       'in_octets': '22417660231',
                                                                       'mac_address': '74:83:c2:69:1f:80',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '157368719312',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZjgwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#21 13024 Cindy Klugiewicz',
                                         'serial_number': 'UBNTc2681f80',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:68:1f:80',
                                         'temperature': 39.0,
                                         'uptime': '8104619'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '257806782917',
                                                                       'links': [       {       'in_octets': '257806782917',
                                                                                                'out_octets': '26911252637',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '26911252637',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104558',
                                                                                                                        'fiber_length': 136,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.502,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.158}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjgxZmZlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:c4:3d:5d'],
                                                                       'id': '1',
                                                                       'in_octets': '26911252637',
                                                                       'mac_address': '74:83:c2:69:1f:fe',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '257806782917',
                                                                       'poller_hash': 'NzQ4M2MyNjgxZmZlZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#17 12855 Pam Walter',
                                         'serial_number': 'UBNTc2681ffe',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': '74:83:c2:68:1f:fe',
                                         'temperature': 46.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '10137328279',
                                                                       'links': [       {       'in_octets': '10137328279',
                                                                                                'out_octets': '2132227246',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2132227246',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1470464',
                                                                                                                        'fiber_length': 113,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.85,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.542}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDBicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:74:55',
                                                                                                        'f0:9f:c2:08:80:d0'],
                                                                       'id': '1',
                                                                       'in_octets': '2132227246',
                                                                       'mac_address': 'b4:fb:e4:7a:90:0b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10137328279',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDBiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#19 11810 Jason Davis',
                                         'serial_number': 'UBNTe479900b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:0b',
                                         'temperature': 45.0,
                                         'uptime': '5233507'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188152273569',
                                                                       'links': [       {       'in_octets': '188152273569',
                                                                                                'out_octets': '5803933430',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5803933430',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4375726',
                                                                                                                        'fiber_length': 147,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.784,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.972}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDUxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d3:cb'],
                                                                       'id': '1',
                                                                       'in_octets': '5803933430',
                                                                       'mac_address': 'b4:fb:e4:7a:90:51',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188152273569',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDUxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#09 12025 Benjamin Durr',
                                         'serial_number': 'UBNTe4799051',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:51',
                                         'temperature': 39.0,
                                         'uptime': '8106259'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1328431239258',
                                                                       'links': [       {       'in_octets': '1328431239258',
                                                                                                'out_octets': '34183478071',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '34183478071',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104558',
                                                                                                                        'fiber_length': 158,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.218,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.686}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MDkycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ac:c5'],
                                                                       'id': '1',
                                                                       'in_octets': '34183478071',
                                                                       'mac_address': 'b4:fb:e4:7a:90:92',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1328431239258',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MDkyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#08 12313 Debra Zimbelman',
                                         'serial_number': 'UBNTe4799092',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:92',
                                         'temperature': 57.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '277506574241',
                                                                       'links': [       {       'in_octets': '277506574241',
                                                                                                'out_octets': '22202458405',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '22202458405',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4386466',
                                                                                                                        'fiber_length': 148,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.892,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.908}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk5MGUycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:49:63:8b'],
                                                                       'id': '1',
                                                                       'in_octets': '22202458405',
                                                                       'mac_address': 'b4:fb:e4:7a:90:e2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '277506574241',
                                                                       'poller_hash': 'YjRmYmU0Nzk5MGUyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#16 12185 Cody Chevalier',
                                         'serial_number': 'UBNTe47990e2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:79:90:e2',
                                         'temperature': 60.0,
                                         'uptime': '4386526'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '36117095748',
                                                                       'links': [       {       'in_octets': '36117095748',
                                                                                                'out_octets': '1652995632',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1652995632',
                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1428854',
                                                                                                                        'fiber_length': 224,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.186,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.686}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIxMDJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:55:31:81:b3:22'],
                                                                       'id': '1',
                                                                       'in_octets': '1652995632',
                                                                       'mac_address': 'b4:fb:e4:ec:10:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36117095748',
                                                                       'poller_hash': 'YjRmYmU0ZWIxMDJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#02 11503 Nicholas Brieger',
                                         'serial_number': 'UBNTe4eb102c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:eb:10:2c',
                                         'temperature': 59.0,
                                         'uptime': '2874049'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1043877012242',
                                                                       'links': [       {       'in_octets': '1043877012242',
                                                                                                'out_octets': '34378191363',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '34378191363',
                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7072646',
                                                                                                                        'fiber_length': 175,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.624,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.538}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWIyZDc4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:ce'],
                                                                       'id': '1',
                                                                       'in_octets': '34378191363',
                                                                       'mac_address': 'b4:fb:e4:ec:2d:78',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1043877012242',
                                                                       'poller_hash': 'YjRmYmU0ZWIyZDc4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#14 11601 Nicholas Peters',
                                         'serial_number': 'UBNTe4eb2d78',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:eb:2d:78',
                                         'temperature': 58.0,
                                         'uptime': '7072701'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1032306600644',
                                                                       'links': [       {       'in_octets': '1032306600644',
                                                                                                'out_octets': '148556313823',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '148556313823',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '8104550',
                                                                                                                        'fiber_length': 201,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.648,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.492}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNjg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ae:a8'],
                                                                       'id': '1',
                                                                       'in_octets': '148556313823',
                                                                       'mac_address': 'b4:fb:e4:fa:d6:88',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1032306600644',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNjg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#04 11629 Kristoffer Totos',
                                         'serial_number': 'UBNTe4f9d688',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d6:88',
                                         'temperature': 41.0,
                                         'uptime': '8104618'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1033057469488',
                                                                       'links': [       {       'in_octets': '1033057469488',
                                                                                                'out_octets': '343608052211',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '343608052211',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1722055',
                                                                                                                        'fiber_length': 124,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.536,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.466}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzJkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:89'],
                                                                       'id': '1',
                                                                       'in_octets': '343608052211',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:2d',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1033057469488',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzJkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#18 11537 Michael White',
                                         'serial_number': 'UBNTe4f9d72d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:2d',
                                         'temperature': 39.0,
                                         'uptime': '3812461'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '21436654479',
                                                                       'links': [       {       'in_octets': '21436654479',
                                                                                                'out_octets': '4037568999',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4037568999',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '93459',
                                                                                                                        'fiber_length': 84,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.892,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzNjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:27:6e'],
                                                                       'id': '1',
                                                                       'in_octets': '4037568999',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:3c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21436654479',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzNjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#23 11507 Chuck Rickards',
                                         'serial_number': 'UBNTe4f9d73c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:3c',
                                         'temperature': 52.0,
                                         'uptime': '240140'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188335141438',
                                                                       'links': [       {       'in_octets': '188335141438',
                                                                                                'out_octets': '19600919925',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '19600919925',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2339528',
                                                                                                                        'fiber_length': 235,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.77,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.72}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzRicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c4:ad:34:40:73:80'],
                                                                       'id': '1',
                                                                       'in_octets': '19600919925',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:4b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188335141438',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzRiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#01 11849 Gary Neff',
                                         'serial_number': 'UBNTe4f9d74b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:4b',
                                         'temperature': 52.0,
                                         'uptime': '3812168'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '561600328813',
                                                                       'links': [       {       'in_octets': '561600328813',
                                                                                                'out_octets': '37886659693',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '37886659693',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1478964',
                                                                                                                        'fiber_length': 140,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.524,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.318}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkNzU1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d3:d9'],
                                                                       'id': '1',
                                                                       'in_octets': '37886659693',
                                                                       'mac_address': 'b4:fb:e4:fa:d7:55',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '561600328813',
                                                                       'poller_hash': 'YjRmYmU0ZjlkNzU1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#11 11609 Kelly Miller',
                                         'serial_number': 'UBNTe4f9d755',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d7:55',
                                         'temperature': 39.0,
                                         'uptime': '3271751'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '77777982154',
                                                                       'links': [       {       'in_octets': '77777982154',
                                                                                                'out_octets': '6338788982',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6338788982',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1480754',
                                                                                                                        'fiber_length': 100,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.732,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.616}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTRlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:ae:b6'],
                                                                       'id': '1',
                                                                       'in_octets': '6338788982',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:4e',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '77777982154',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTRlZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#20 11541 David Bluel',
                                         'serial_number': 'UBNTe4f9d94e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:4e',
                                         'temperature': 50.0,
                                         'uptime': '2345237'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1326028495831',
                                                                       'links': [       {       'in_octets': '1326028495831',
                                                                                                'out_octets': '100281499482',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '100281499482',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4723717',
                                                                                                                        'fiber_length': 213,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.758,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.718}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:4e:d4:0a'],
                                                                       'id': '1',
                                                                       'in_octets': '100281499482',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:62',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1326028495831',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#03 11528 Deirdra Hanners',
                                         'serial_number': 'UBNTe4f9d962',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:62',
                                         'temperature': 57.0,
                                         'uptime': '8106099'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '5502382548',
                                                                       'links': [       {       'in_octets': '5502382548',
                                                                                                'out_octets': '626219251',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '626219251',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '73619',
                                                                                                                        'fiber_length': 169,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.938,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.602}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkOTcxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:a4:12'],
                                                                       'id': '1',
                                                                       'in_octets': '626219251',
                                                                       'mac_address': 'b4:fb:e4:fa:d9:71',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5502382548',
                                                                       'poller_hash': 'YjRmYmU0ZjlkOTcxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#07 12320 Lucas Piontkowski',
                                         'serial_number': 'UBNTe4f9d971',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:d9:71',
                                         'temperature': 42.0,
                                         'uptime': '73697'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '34870727506',
                                                                       'links': [       {       'in_octets': '34870727506',
                                                                                                'out_octets': '1049836548',
                                                                                                'poller_hash': 'YjRmYmU0YjQzZjFkcG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1049836548',
                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '613371',
                                                                                                                        'fiber_length': 163,
                                                                                                                        'poller_hash': 'YjRmYmU0YjQzZjFkVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.898,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.764}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZjlkYWYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:2d:e0:91:a9:36'],
                                                                       'id': '1',
                                                                       'in_octets': '1049836548',
                                                                       'mac_address': 'b4:fb:e4:fa:da:f2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '34870727506',
                                                                       'poller_hash': 'YjRmYmU0ZjlkYWYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 52.0,
                                         'model': 'Loco',
                                         'name': '#13 11936 Susan Cummings',
                                         'serial_number': 'UBNTe4f9daf2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.0.5',
                                         'system_mac_address': 'b4:fb:e4:f9:da:f2',
                                         'temperature': 40.0,
                                         'uptime': '3812962'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_5_3_10_60_57_2(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.5.3.10_60_57_2")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 53,
                'sw_version': '4.5.3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 4
        }
        exp_sta_stats = {
                '18:e8:29:19:6c:11': {       'dev_macs': ['a0:40:a0:71:2d:88'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:6c:11',
                                             'name': 'Island View - 12705 - Karen '
                                                     'Mulvahill - 14204'},
                '18:e8:29:19:70:7b': {       'dev_macs': ['10:0c:6b:2d:94:8a'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:70:7b',
                                             'name': 'Island View-12545-John '
                                                     'Wadas-16542'},
                '18:e8:29:19:74:e5': {       'dev_macs': ['e0:63:da:99:cd:79'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:74:e5',
                                             'name': 'Island View - 12571 - John Scott '
                                                     '- 18909'},
                '18:e8:29:19:b0:a9': {       'dev_macs': ['3c:37:86:c8:4c:76'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b0:a9',
                                             'name': 'Island View - 12771 - Bill Brown '
                                                     '- 13712'},
                '18:e8:29:19:b0:f9': {       'dev_macs': ['b0:39:56:50:a7:80'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b0:f9',
                                             'name': 'Island View - 12563 - Don '
                                                     'DAnnunzio - 17717'},
                '18:e8:29:19:b1:12': {       'dev_macs': ['a0:04:60:04:24:be'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b1:12',
                                             'name': 'Island View - 12585 - Ronald '
                                                     'Jones - 14376'},
                '18:e8:29:19:b2:57': {       'dev_macs': ['f4:92:bf:66:6a:d1'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:57',
                                             'name': 'Island View - 12527 - John '
                                                     'Christophersen - 17017'},
                '18:e8:29:19:b2:61': {       'dev_macs': ['6c:b0:ce:10:fa:03'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:61',
                                             'name': 'Island View - 12755 - Paul '
                                                     'Christopheren - 16068'},
                '18:e8:29:19:b2:6b': {       'dev_macs': ['10:0c:6b:d6:f0:fe'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:6b',
                                             'name': 'Island View - 12727 - Rich '
                                                     'Sutliff - 14696'},
                '18:e8:29:19:b2:7f': {       'dev_macs': ['78:d2:94:18:c2:98'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:7f',
                                             'name': 'Island View - 12811 - Robert '
                                                     'Shirkey - 13719'},
                '18:e8:29:19:b2:98': {       'dev_macs': ['d8:07:b6:74:c5:ee'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:98',
                                             'name': 'Island VIew - 12655 - Al Blinke '
                                                     '- 15472'},
                '18:e8:29:19:b2:9d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:9d',
                                             'name': 'Island View - 12637 - Milton '
                                                     'Hartig - 13676'},
                '18:e8:29:19:b2:a7': {       'dev_macs': ['f8:32:e4:b2:fc:50'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:a7',
                                             'name': 'Island View - 12831 - DomeHouse '
                                                     'LLC - 13718'},
                '18:e8:29:19:b2:ac': {       'dev_macs': ['08:36:c9:14:fc:10'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:ac',
                                             'name': 'Island View - 12891 - Terry Fera '
                                                     '- 15115'},
                '18:e8:29:19:b2:b1': {       'dev_macs': ['78:d2:94:18:e9:d8'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b2:b1',
                                             'name': 'Island View - 12371 - Christine '
                                                     'Polo - 20910'},
                '18:e8:29:19:b3:f6': {       'dev_macs': ['6c:3b:6b:92:e4:29'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b3:f6',
                                             'name': 'Island View - 12973 - Christine '
                                                     'Kay - 16910'},
                '18:e8:29:19:b3:fb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b3:fb',
                                             'name': 'Island View - 12693 - Mary '
                                                     'Jaross - 15893'},
                '18:e8:29:19:b4:0a': {       'dev_macs': ['e0:63:da:f9:95:4f'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:0a',
                                             'name': 'Island View - 12803 - Stephen '
                                                     'Rigotti - 14850'},
                '18:e8:29:19:b4:91': {       'dev_macs': ['60:b7:6e:1e:fa:76'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:91',
                                             'name': 'Island View - 12515 - Brandon '
                                                     'Theophilus - 18564'},
                '18:e8:29:19:b4:c3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:b4:c3',
                                             'name': 'Island View - 12493 - Alex Parks '
                                                     '- 16106'},
                '18:e8:29:f5:ff:97': {       'dev_macs': ['74:ac:b9:46:e6:45'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:ff:97',
                                             'name': 'Foxview - 12010 - Douglas Jester '
                                                     '- 16616'},
                '68:d7:9a:06:87:03': {       'dev_macs': ['cc:40:d0:50:f6:20'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:87:03',
                                             'name': 'Island View - 12331 - William '
                                                     'Cron - 13536'},
                '68:d7:9a:06:88:e4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:88:e4',
                                             'name': 'UBNT9a0688e4'},
                '68:d7:9a:06:8a:ad': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:8a:ad',
                                             'name': 'Island Dr - 12901 - Dan Cermak - '
                                                     '20905'},
                '68:d7:9a:06:8a:f2': {       'dev_macs': ['40:ed:00:a9:df:2c'],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:8a:f2',
                                             'name': 'Island View - 12445 - Stanley '
                                                     'Pruss -  15077'},
                '74:83:c2:43:f7:28': {       'dev_macs': ['74:b6:b6:05:8c:80'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:f7:28',
                                             'name': 'Foxview - 11907 - Todd Hoogland '
                                                     '- 17100'},
                '74:83:c2:43:f7:90': {       'dev_macs': ['48:22:54:32:d5:d1'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:f7:90',
                                             'name': 'Island View - 12531 - Malcolm '
                                                     'Hickok - 21903'},
                '74:83:c2:43:fb:46': {       'dev_macs': ['14:91:82:2e:cf:55'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:43:fb:46',
                                             'name': 'Island View Dr - 12931 - Judy '
                                                     'Burns - 15696'},
                '74:83:c2:68:af:3b': {       'dev_macs': ['8c:3b:ad:f1:f0:12'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:af:3b',
                                             'name': 'N Foxview - 11981 - Tina Serne - '
                                                     '17978'},
                '78:45:58:90:da:70': {       'dev_macs': ['40:ed:00:85:28:a5'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:da:70',
                                             'name': 'Island View - 12875 - Bridget '
                                                     'Lamont - 13721'},
                '78:45:58:90:e0:f4': {       'dev_macs': ['c8:9e:43:db:81:8b'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e0:f4',
                                             'name': 'Island View - 12851 - Joanne '
                                                     'Whitley - 14649'},
                '78:45:58:90:e1:88': {       'dev_macs': ['c0:06:c3:2f:d4:3d'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e1:88',
                                             'name': 'Shores Ct - 12372 - Maginot, '
                                                     'Anne & Peter - 20791'},
                '78:45:58:90:e8:94': {       'dev_macs': ['50:91:e3:43:0d:f4'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:90:e8:94',
                                             'name': 'Island Lake Dr - 13015 -Marilee '
                                                     'Milroy - 13348'},
                '78:45:58:95:18:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:95:18:18',
                                             'name': 'Foxview - 11886 - James Hatch - '
                                                     '21764'},
                '78:45:58:95:28:a4': {       'dev_macs': ['28:87:ba:76:31:21'],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:95:28:a4',
                                             'name': 'Peterson Park - 10323 - Rich '
                                                     'Simons - 21424'},
                '78:8a:20:73:6f:2c': {       'dev_macs': ['24:4b:fe:39:0b:19'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:6f:2c',
                                             'name': 'Foxview - 11850 - Paul Belden - '
                                                     '17943'},
                '78:8a:20:73:72:15': {       'dev_macs': ['68:d7:9a:d0:82:f8'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:72:15',
                                             'name': 'Island View - 12260 - Thomas '
                                                     'Shaver - 13374'},
                '78:8a:20:73:72:bf': {       'dev_macs': ['80:02:9c:53:0a:b0'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:72:bf',
                                             'name': 'Foxview - 12155 - Jeffery '
                                                     'McGalliard - 17944'},
                '78:8a:20:73:79:18': {       'dev_macs': ['00:01:9f:1e:4b:01'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:79:18',
                                             'name': 'Foxview - 12097 - Steve Holmes - '
                                                     '18097'},
                '78:8a:20:78:e8:a3': {       'dev_macs': ['14:59:c0:a4:a6:6b'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:e8:a3',
                                             'name': 'Foxview - 12236 - Randy Harmson '
                                                     '- 15026'},
                '78:8a:20:78:f0:a5': {       'dev_macs': ['80:cc:9c:2c:d0:ac'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:f0:a5',
                                             'name': 'Foxview - 12191 - Jim Flutur -  '
                                                     '13587'},
                '78:8a:20:c0:40:96': {       'dev_macs': ['48:dd:0c:be:7a:20'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:96',
                                             'name': 'Foxview - 11945 - Phil Smith - '
                                                     '17942'},
                '78:8a:20:c0:40:aa': {       'dev_macs': ['74:ac:b9:fd:bc:a6'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:aa',
                                             'name': 'Foxview - 11963 - David Watkins '
                                                     '- 17965'},
                '78:8a:20:c0:40:c8': {       'dev_macs': ['30:de:4b:9e:af:e1'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:40:c8',
                                             'name': 'Island View - 12411 - Paul Hsieh '
                                                     '- 17977'},
                '78:8a:20:c0:41:18': {       'dev_macs': ['e0:63:da:f9:07:c8'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:18',
                                             'name': 'Foxview - 11920 - Chase, Janeen '
                                                     '- 21513'},
                '78:8a:20:c0:41:2c': {       'dev_macs': ['8c:3b:ad:3d:32:a3'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:2c',
                                             'name': 'Foxview - 12158 - Carolyn Grauer '
                                                     '- 21816'},
                '78:8a:20:c0:41:45': {       'dev_macs': ['00:01:9f:20:4e:b9'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:45',
                                             'name': 'Shores Ct - 12390 - Ann Anderson '
                                                     '- 18014'},
                '78:8a:20:c0:41:54': {       'dev_macs': ['48:8f:5a:d2:68:7d'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:54',
                                             'name': 'Christmas Cove - 10720 - Willard '
                                                     'Kolarik'},
                '78:8a:20:c0:41:72': {       'dev_macs': ['44:a5:6e:78:04:4a'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:41:72',
                                             'name': 'Island View - 12271 - Peter '
                                                     'Wolcott - 13381'},
                '78:8a:20:c0:42:b7': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:42:b7',
                                             'name': 'UBNT20c042b7'},
                '78:8a:20:c0:43:11': {       'dev_macs': ['38:94:ed:5a:74:1e'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:c0:43:11',
                                             'name': 'Shores Ct - 12375 - Joseph '
                                                     'Defors - 15486'},
                'b4:fb:e4:79:68:2e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:68:2e',
                                             'name': 'UBNTe479682e'},
                'fc:ec:da:e0:5e:65': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:e0:5e:65',
                                             'name': 'UBNTdae05e65'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 4.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '17432437662040',
                                                              'in_ucast_pkts': '13403734956',
                                                              'manufacturer': 'Maxxwax',
                                                              'model': 'MW-SFP+DAC-1M',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '1960754435039',
                                                              'out_ucast_pkts': '5159145010',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRic2ZwMWludGY=',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '132619257054',
                                                              'in_ucast_pkts': '478026886',
                                                              'links': [       {       'in_octets': '20334980259',
                                                                                       'out_octets': '382126985882',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4cGVlcmludGY='},
                                                                               {       'in_octets': '299534420',
                                                                                       'out_octets': '1200060485',
                                                                                       'poller_hash': 'MThlODI5MTliMmIxcGVlcmludGY='},
                                                                               {       'in_octets': '57927547038',
                                                                                       'out_octets': '738675917692',
                                                                                       'poller_hash': 'MThlODI5MTliNDkxcGVlcmludGY='},
                                                                               {       'in_octets': '54057044262',
                                                                                       'out_octets': '1084558219988',
                                                                                       'poller_hash': 'NjhkNzlhMDY4YWYycGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '2206807730808',
                                                              'out_ucast_pkts': '1642226790',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY=',
                                                              'pons': [       {       'description': 'pon1',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 805,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 753,
                                                                                                               'poller_hash': 'MThlODI5MTliMmIxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 979,
                                                                                                               'poller_hash': 'MThlODI5MTliNDkxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 837,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4YWYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '982136526966',
                                                              'in_ucast_pkts': '1764271804',
                                                              'links': [       {       'in_octets': '2875320771',
                                                                                       'out_octets': '6767013935',
                                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjcGVlcmludGY='},
                                                                               {       'in_octets': '28844222892',
                                                                                       'out_octets': '215852524750',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1cGVlcmludGY='},
                                                                               {       'in_octets': '29760272385',
                                                                                       'out_octets': '1004391321993',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmcGVlcmludGY='},
                                                                               {       'in_octets': '7011212619',
                                                                                       'out_octets': '5572730769',
                                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4cGVlcmludGY='},
                                                                               {       'in_octets': '65006343841',
                                                                                       'out_octets': '722698902912',
                                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzcGVlcmludGY='},
                                                                               {       'in_octets': '26498294287',
                                                                                       'out_octets': '645815695042',
                                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1cGVlcmludGY='},
                                                                               {       'in_octets': '28901479743',
                                                                                       'out_octets': '340845759857',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2cGVlcmludGY='},
                                                                               {       'in_octets': '525422464390',
                                                                                       'out_octets': '875156510117',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhcGVlcmludGY='},
                                                                               {       'in_octets': '6015029149',
                                                                                       'out_octets': '37764131492',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4cGVlcmludGY='},
                                                                               {       'in_octets': '9495503296',
                                                                                       'out_octets': '63838111302',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjcGVlcmludGY='},
                                                                               {       'in_octets': '14549160824',
                                                                                       'out_octets': '188409558464',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcycGVlcmludGY='},
                                                                               {       'in_octets': '214824761527',
                                                                                       'out_octets': '712397394726',
                                                                                       'poller_hash': 'MThlODI5ZjVmZjk3cGVlcmludGY='},
                                                                               {       'in_octets': '16592512237',
                                                                                       'out_octets': '252309439843',
                                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0cGVlcmludGY='},
                                                                               {       'in_octets': '2480037101',
                                                                                       'out_octets': '3867703421',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4cGVlcmludGY='},
                                                                               {       'in_octets': '3859797070',
                                                                                       'out_octets': '218246124809',
                                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNicGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '5294179544000',
                                                              'out_ucast_pkts': '4227859375',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY=',
                                                              'pons': [       {       'description': 'pon2',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2247,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 975,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1448,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1398,
                                                                                                               'poller_hash': 'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1137,
                                                                                                               'poller_hash': 'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1350,
                                                                                                               'poller_hash': 'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1904,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1833,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1894,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1296,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 951,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1475,
                                                                                                               'poller_hash': 'MThlODI5ZjVmZjk3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 2354,
                                                                                                               'poller_hash': 'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2019,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 1729,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'in_errors': '0',
                                                              'in_octets': '187879663770',
                                                              'in_ucast_pkts': '733145429',
                                                              'links': [       {       'in_octets': '63692729499',
                                                                                       'out_octets': '1248255671903',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1cGVlcmludGY='},
                                                                               {       'in_octets': '5530696993',
                                                                                       'out_octets': '76576807976',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0cGVlcmludGY='},
                                                                               {       'in_octets': '57572867345',
                                                                                       'out_octets': '514072433979',
                                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExcGVlcmludGY='},
                                                                               {       'in_octets': '5850564344',
                                                                                       'out_octets': '195572574649',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4cGVlcmludGY='},
                                                                               {       'in_octets': '28482786557',
                                                                                       'out_octets': '367692822981',
                                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon3',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '3205860065741',
                                                              'out_ucast_pkts': '2484178192',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY=',
                                                              'pons': [       {       'description': 'pon3',
                                                                                      'id': '3',
                                                                                      'links': [       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1051,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1254,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4322406',
                                                                                                               'fiber_length': 1160,
                                                                                                               'poller_hash': 'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '696276',
                                                                                                               'fiber_length': 963,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 701,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon3',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '324120174550',
                                                              'in_ucast_pkts': '1563494514',
                                                              'links': [       {       'in_octets': '32455680456',
                                                                                       'out_octets': '678532036424',
                                                                                       'poller_hash': 'MThlODI5MTk2YzExcGVlcmludGY='},
                                                                               {       'in_octets': '1239678225',
                                                                                       'out_octets': '4915886238',
                                                                                       'poller_hash': 'MThlODI5MTk3MDdicGVlcmludGY='},
                                                                               {       'in_octets': '952532292',
                                                                                       'out_octets': '1375491216',
                                                                                       'poller_hash': 'MThlODI5MTk3NGU1cGVlcmludGY='},
                                                                               {       'in_octets': '1260143510',
                                                                                       'out_octets': '1734780886',
                                                                                       'poller_hash': 'MThlODI5MTliMGE5cGVlcmludGY='},
                                                                               {       'in_octets': '2380974756',
                                                                                       'out_octets': '4845405777',
                                                                                       'poller_hash': 'MThlODI5MTliMGY5cGVlcmludGY='},
                                                                               {       'in_octets': '1472743210',
                                                                                       'out_octets': '8140378726',
                                                                                       'poller_hash': 'MThlODI5MTliMTEycGVlcmludGY='},
                                                                               {       'in_octets': '33981904572',
                                                                                       'out_octets': '918992463273',
                                                                                       'poller_hash': 'MThlODI5MTliMjU3cGVlcmludGY='},
                                                                               {       'in_octets': '7464622801',
                                                                                       'out_octets': '154147386163',
                                                                                       'poller_hash': 'MThlODI5MTliMjYxcGVlcmludGY='},
                                                                               {       'in_octets': '36544651',
                                                                                       'out_octets': '40935539',
                                                                                       'poller_hash': 'MThlODI5MTliMjZicGVlcmludGY='},
                                                                               {       'in_octets': '1104833731',
                                                                                       'out_octets': '337998269',
                                                                                       'poller_hash': 'MThlODI5MTliMjdmcGVlcmludGY='},
                                                                               {       'in_octets': '2776436093',
                                                                                       'out_octets': '14599689500',
                                                                                       'poller_hash': 'MThlODI5MTliMjk4cGVlcmludGY='},
                                                                               {       'in_octets': '77755899',
                                                                                       'out_octets': '475854997',
                                                                                       'poller_hash': 'MThlODI5MTliMmE3cGVlcmludGY='},
                                                                               {       'in_octets': '2309536034',
                                                                                       'out_octets': '27306362339',
                                                                                       'poller_hash': 'MThlODI5MTliMmFjcGVlcmludGY='},
                                                                               {       'in_octets': '3089520612',
                                                                                       'out_octets': '33990849922',
                                                                                       'poller_hash': 'MThlODI5MTliM2Y2cGVlcmludGY='},
                                                                               {       'in_octets': '388447918',
                                                                                       'out_octets': '139759797',
                                                                                       'poller_hash': 'MThlODI5MTliNDBhcGVlcmludGY='},
                                                                               {       'in_octets': '435561254',
                                                                                       'out_octets': '297617759',
                                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwcGVlcmludGY='},
                                                                               {       'in_octets': '27249793080',
                                                                                       'out_octets': '410031384428',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0cGVlcmludGY='},
                                                                               {       'in_octets': '3237963499',
                                                                                       'out_octets': '60424821524',
                                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0cGVlcmludGY='},
                                                                               {       'in_octets': '176',
                                                                                       'out_octets': '0',
                                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkcGVlcmludGY='},
                                                                               {       'in_octets': '51881481642',
                                                                                       'out_octets': '31896289481',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwcGVlcmludGY='},
                                                                               {       'in_octets': '7828326027',
                                                                                       'out_octets': '178128411569',
                                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '4842897763204',
                                                              'out_ucast_pkts': '3568612716',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY=',
                                                              'pons': [       {       'description': 'pon4',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '4484758',
                                                                                                               'fiber_length': 1721,
                                                                                                               'poller_hash': 'MThlODI5MTk2YzExcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 1419,
                                                                                                               'poller_hash': 'MThlODI5MTk3MDdicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1361,
                                                                                                               'poller_hash': 'MThlODI5MTk3NGU1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 1874,
                                                                                                               'poller_hash': 'MThlODI5MTliMGE5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1340,
                                                                                                               'poller_hash': 'MThlODI5MTliMGY5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1356,
                                                                                                               'poller_hash': 'MThlODI5MTliMTEycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 1227,
                                                                                                               'poller_hash': 'MThlODI5MTliMjU3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1776,
                                                                                                               'poller_hash': 'MThlODI5MTliMjYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '185592',
                                                                                                               'fiber_length': 1747,
                                                                                                               'poller_hash': 'MThlODI5MTliMjZicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1737394',
                                                                                                               'fiber_length': 1929,
                                                                                                               'poller_hash': 'MThlODI5MTliMjdmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 1626,
                                                                                                               'poller_hash': 'MThlODI5MTliMjk4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 1966,
                                                                                                               'poller_hash': 'MThlODI5MTliMmE3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 2131,
                                                                                                               'poller_hash': 'MThlODI5MTliMmFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581158',
                                                                                                               'fiber_length': 2421,
                                                                                                               'poller_hash': 'MThlODI5MTliM2Y2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '575075',
                                                                                                               'fiber_length': 1900,
                                                                                                               'poller_hash': 'MThlODI5MTliNDBhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581168',
                                                                                                               'fiber_length': 2134,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2734303',
                                                                                                               'fiber_length': 2014,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581167',
                                                                                                               'fiber_length': 2366,
                                                                                                               'poller_hash': 'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '4581166',
                                                                                                               'fiber_length': 2134,
                                                                                                               'poller_hash': 'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3377329',
                                                                                                               'fiber_length': 1196,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '477264',
                                                                                                               'fiber_length': 2310,
                                                                                                               'poller_hash': 'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '1',
                                                              'in_errors': '3',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '21243180341',
                                                              'in_ucast_pkts': '127696014',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '36341474912',
                                                              'out_ucast_pkts': '125425445',
                                                              'poller_hash': 'Nzg4YTIwZmRmNzRiZXRoMGludGY=',
                                                              'speed': '1000000000'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 13.0,
                                'model': 'UFiber OLT4',
                                'serial_number': 'UBNT20fdf74b',
                                'sw_version': '4.5.3',
                                'system_mac_address': '78:8a:20:fd:f7:4b',
                                'temperature': 45.25,
                                'uptime': '5032002'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'Nzg4YTIwYzA0MmI3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MmI3cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MmI3ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNT20c042b7',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT20c042b7',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '78:8a:20:c0:42:b7'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliMjlkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjlkcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliMjlkZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12637 - Milton Hartig '
                                                 '- 13676',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b29d',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b2:9d'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliM2ZicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliM2ZicG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliM2ZiZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12693 - Mary Jaross - '
                                                 '15893',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b3fb',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b3:fb'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MTliNGMzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNGMzcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MTliNGMzZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Island View - 12493 - Alex Parks - '
                                                 '16106',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT2919b4c3',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:19:b4:c3'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'Nzg0NTU4OTUxODE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTUxODE4cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'Nzg0NTU4OTUxODE4ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Foxview - 11886 - James Hatch - '
                                                 '21764',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT58951818',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '78:45:58:95:18:18'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjhkNzlhMDY4OGU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4OGU0cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'NjhkNzlhMDY4OGU0ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNT9a0688e4',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT9a0688e4',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '68:d7:9a:06:88:e4'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZmNlY2RhZTA1ZTY1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZTA1ZTY1cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhZTA1ZTY1ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNTdae05e65',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTdae05e65',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'fc:ec:da:e0:5e:65'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'YjRmYmU0Nzk2ODJlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0Nzk2ODJlcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'YjRmYmU0Nzk2ODJlZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': 'UBNTe479682e',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTe479682e',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'b4:fb:e4:79:68:2e'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '382126985882',
                                                                       'links': [       {       'in_octets': '382126985882',
                                                                                                'out_octets': '20334980259',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '20334980259',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 805,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.538,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.948}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '30:de:4b:9e:af:e1'],
                                                                       'id': '1',
                                                                       'in_octets': '20334980259',
                                                                       'mac_address': '78:8a:20:c1:40:c8',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '382126985882',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGM4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12411 - Paul Hsieh - '
                                                 '17977',
                                         'serial_number': 'UBNT20c040c8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:c8',
                                         'temperature': 35.0,
                                         'uptime': '5032189'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1200060485',
                                                                       'links': [       {       'in_octets': '1200060485',
                                                                                                'out_octets': '299534420',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '299534420',
                                                                       'poller_hash': 'MThlODI5MTliMmIxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 753,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.832,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.28}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmIxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:d2:94:18:e9:d8'],
                                                                       'id': '1',
                                                                       'in_octets': '299534420',
                                                                       'mac_address': '18:e8:29:1a:b2:b1',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1200060485',
                                                                       'poller_hash': 'MThlODI5MTliMmIxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12371 - Christine Polo '
                                                 '- 20910',
                                         'serial_number': 'UBNT2919b2b1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:b1',
                                         'temperature': 27.0,
                                         'uptime': '5032195'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '738675917692',
                                                                       'links': [       {       'in_octets': '738675917692',
                                                                                                'out_octets': '57927547038',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '57927547038',
                                                                       'poller_hash': 'MThlODI5MTliNDkxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 979,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.728,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.618}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNDkxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:b7:6e:1e:fa:76'],
                                                                       'id': '1',
                                                                       'in_octets': '57927547038',
                                                                       'mac_address': '18:e8:29:1a:b4:91',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '738675917692',
                                                                       'poller_hash': 'MThlODI5MTliNDkxZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12515 - Brandon '
                                                 'Theophilus - 18564',
                                         'serial_number': 'UBNT2919b491',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b4:91',
                                         'temperature': 35.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1084558219988',
                                                                       'links': [       {       'in_octets': '1084558219988',
                                                                                                'out_octets': '54057044262',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '54057044262',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 837,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.354,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4YWYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ed:00:a9:df:2c'],
                                                                       'id': '1',
                                                                       'in_octets': '54057044262',
                                                                       'mac_address': '68:d7:9a:07:8a:f2',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1084558219988',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12445 - Stanley Pruss '
                                                 '-  15077',
                                         'serial_number': 'UBNT9a068af2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:8a:f2',
                                         'temperature': 32.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '6767013935',
                                                                       'links': [       {       'in_octets': '6767013935',
                                                                                                'out_octets': '2875320771',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2875320771',
                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2247,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.426,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.566}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '24:4b:fe:39:0b:19'],
                                                                       'id': '1',
                                                                       'in_octets': '2875320771',
                                                                       'mac_address': '78:8a:20:74:6f:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6767013935',
                                                                       'poller_hash': 'Nzg4YTIwNzM2ZjJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 11850 - Paul Belden - '
                                                 '17943',
                                         'serial_number': 'UBNT20736f2c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:6f:2c',
                                         'temperature': 36.0,
                                         'uptime': '5032237'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '215852524750',
                                                                       'links': [       {       'in_octets': '215852524750',
                                                                                                'out_octets': '28844222892',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28844222892',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 975,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.412,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.414}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '68:d7:9a:d0:82:f8'],
                                                                       'id': '1',
                                                                       'in_octets': '28844222892',
                                                                       'mac_address': '78:8a:20:74:72:15',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '215852524750',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MjE1ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Island View - 12260 - Thomas Shaver '
                                                 '- 13374',
                                         'serial_number': 'UBNT20737215',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:72:15',
                                         'temperature': 32.0,
                                         'uptime': '5032234'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1004391321993',
                                                                       'links': [       {       'in_octets': '1004391321993',
                                                                                                'out_octets': '29760272385',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '29760272385',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1448,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.45,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.278}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:02:9c:53:0a:b0'],
                                                                       'id': '1',
                                                                       'in_octets': '29760272385',
                                                                       'mac_address': '78:8a:20:74:72:bf',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1004391321993',
                                                                       'poller_hash': 'Nzg4YTIwNzM3MmJmZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 12155 - Jeffery McGalliard '
                                                 '- 17944',
                                         'serial_number': 'UBNT207372bf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:72:bf',
                                         'temperature': 37.0,
                                         'uptime': '5032231'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '5572730769',
                                                                       'links': [       {       'in_octets': '5572730769',
                                                                                                'out_octets': '7011212619',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7011212619',
                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1398,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.788,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.412}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:01:9f:1e:4b:01'],
                                                                       'id': '1',
                                                                       'in_octets': '7011212619',
                                                                       'mac_address': '78:8a:20:74:79:18',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5572730769',
                                                                       'poller_hash': 'Nzg4YTIwNzM3OTE4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'NanoG',
                                         'name': 'Foxview - 12097 - Steve Holmes - '
                                                 '18097',
                                         'serial_number': 'UBNT20737918',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:73:79:18',
                                         'temperature': 35.0,
                                         'uptime': '5032242'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '722698902912',
                                                                       'links': [       {       'in_octets': '722698902912',
                                                                                                'out_octets': '65006343841',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '65006343841',
                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1137,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.86,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.986}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:59:c0:a4:a6:6b'],
                                                                       'id': '1',
                                                                       'in_octets': '65006343841',
                                                                       'mac_address': '78:8a:20:79:e8:a3',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '722698902912',
                                                                       'poller_hash': 'Nzg4YTIwNzhlOGEzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12236 - Randy Harmson - '
                                                 '15026',
                                         'serial_number': 'UBNT2078e8a3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:78:e8:a3',
                                         'temperature': 38.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '645815695042',
                                                                       'links': [       {       'in_octets': '645815695042',
                                                                                                'out_octets': '26498294287',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '26498294287',
                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1350,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.398,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.99}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '80:cc:9c:2c:d0:ac'],
                                                                       'id': '1',
                                                                       'in_octets': '26498294287',
                                                                       'mac_address': '78:8a:20:79:f0:a5',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '645815695042',
                                                                       'poller_hash': 'Nzg4YTIwNzhmMGE1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12191 - Jim Flutur -  '
                                                 '13587',
                                         'serial_number': 'UBNT2078f0a5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:78:f0:a5',
                                         'temperature': 43.0,
                                         'uptime': '5032187'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '340845759857',
                                                                       'links': [       {       'in_octets': '340845759857',
                                                                                                'out_octets': '28901479743',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28901479743',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1904,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.078,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:dd:0c:be:7a:20'],
                                                                       'id': '1',
                                                                       'in_octets': '28901479743',
                                                                       'mac_address': '78:8a:20:c1:40:96',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '340845759857',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MDk2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11945 - Phil Smith - 17942',
                                         'serial_number': 'UBNT20c04096',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:96',
                                         'temperature': 31.0,
                                         'uptime': '5032187'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '875156510117',
                                                                       'links': [       {       'in_octets': '875156510117',
                                                                                                'out_octets': '525422464390',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '525422464390',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1833,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.872,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.906}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:ac:b9:fd:bc:a6'],
                                                                       'id': '1',
                                                                       'in_octets': '525422464390',
                                                                       'mac_address': '78:8a:20:c1:40:aa',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '875156510117',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MGFhZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11963 - David Watkins - '
                                                 '17965',
                                         'serial_number': 'UBNT20c040aa',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:40:aa',
                                         'temperature': 27.0,
                                         'uptime': '5032188'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '37764131492',
                                                                       'links': [       {       'in_octets': '37764131492',
                                                                                                'out_octets': '6015029149',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6015029149',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1894,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.078,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:f9:07:c8'],
                                                                       'id': '1',
                                                                       'in_octets': '6015029149',
                                                                       'mac_address': '78:8a:20:c1:41:18',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '37764131492',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTE4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11920 - Chase, Janeen - '
                                                 '21513',
                                         'serial_number': 'UBNT20c04118',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:18',
                                         'temperature': 33.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '63838111302',
                                                                       'links': [       {       'in_octets': '63838111302',
                                                                                                'out_octets': '9495503296',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9495503296',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1296,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.416,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.662}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:3b:ad:3d:32:a3'],
                                                                       'id': '1',
                                                                       'in_octets': '9495503296',
                                                                       'mac_address': '78:8a:20:c1:41:2c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '63838111302',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12158 - Carolyn Grauer - '
                                                 '21816',
                                         'serial_number': 'UBNT20c0412c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:2c',
                                         'temperature': 32.0,
                                         'uptime': '5032191'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '188409558464',
                                                                       'links': [       {       'in_octets': '188409558464',
                                                                                                'out_octets': '14549160824',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '14549160824',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 951,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.562}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '44:a5:6e:78:04:4a'],
                                                                       'id': '1',
                                                                       'in_octets': '14549160824',
                                                                       'mac_address': '78:8a:20:c1:41:72',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '188409558464',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTcyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12271 - Peter Wolcott '
                                                 '- 13381',
                                         'serial_number': 'UBNT20c04172',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:72',
                                         'temperature': 36.0,
                                         'uptime': '5032188'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '712397394726',
                                                                       'links': [       {       'in_octets': '712397394726',
                                                                                                'out_octets': '214824761527',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '214824761527',
                                                                       'poller_hash': 'MThlODI5ZjVmZjk3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1475,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.564,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.032}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjVmZjk3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:ac:b9:46:e6:45'],
                                                                       'id': '1',
                                                                       'in_octets': '214824761527',
                                                                       'mac_address': '18:e8:29:f6:ff:97',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '712397394726',
                                                                       'poller_hash': 'MThlODI5ZjVmZjk3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 12010 - Douglas Jester - '
                                                 '16616',
                                         'serial_number': 'UBNT29f5ff97',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:f5:ff:97',
                                         'temperature': 28.0,
                                         'uptime': '5032179'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '252309439843',
                                                                       'links': [       {       'in_octets': '252309439843',
                                                                                                'out_octets': '16592512237',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '16592512237',
                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 2354,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.938,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.556}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '28:87:ba:76:31:21'],
                                                                       'id': '1',
                                                                       'in_octets': '16592512237',
                                                                       'mac_address': '78:45:58:96:28:a4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '252309439843',
                                                                       'poller_hash': 'Nzg0NTU4OTUyOGE0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Peterson Park - 10323 - Rich Simons '
                                                 '- 21424',
                                         'serial_number': 'UBNT589528a4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:95:28:a4',
                                         'temperature': 31.0,
                                         'uptime': '8187325'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '3867703421',
                                                                       'links': [       {       'in_octets': '3867703421',
                                                                                                'out_octets': '2480037101',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2480037101',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2019,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -25.228,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.696}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:b6:b6:05:8c:80'],
                                                                       'id': '1',
                                                                       'in_octets': '2480037101',
                                                                       'mac_address': '74:83:c2:44:f7:28',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3867703421',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzI4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Foxview - 11907 - Todd Hoogland - '
                                                 '17100',
                                         'serial_number': 'UBNTc243f728',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:f7:28',
                                         'temperature': 26.0,
                                         'uptime': '5032181'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '218246124809',
                                                                       'links': [       {       'in_octets': '218246124809',
                                                                                                'out_octets': '3859797070',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3859797070',
                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 1729,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.35,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.708}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '8c:3b:ad:f1:f0:12'],
                                                                       'id': '1',
                                                                       'in_octets': '3859797070',
                                                                       'mac_address': '74:83:c2:69:af:3b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '218246124809',
                                                                       'poller_hash': 'NzQ4M2MyNjhhZjNiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': 'N Foxview - 11981 - Tina Serne - '
                                                 '17978',
                                         'serial_number': 'UBNTc268af3b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:68:af:3b',
                                         'temperature': 27.0,
                                         'uptime': '5032221'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1248255671903',
                                                                       'links': [       {       'in_octets': '1248255671903',
                                                                                                'out_octets': '63692729499',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '63692729499',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1051,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.532,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.618}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:01:9f:20:4e:b9'],
                                                                       'id': '1',
                                                                       'in_octets': '63692729499',
                                                                       'mac_address': '78:8a:20:c1:41:45',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1248255671903',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTQ1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12390 - Ann Anderson - '
                                                 '18014',
                                         'serial_number': 'UBNT20c04145',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:45',
                                         'temperature': 31.0,
                                         'uptime': '5032190'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '76576807976',
                                                                       'links': [       {       'in_octets': '76576807976',
                                                                                                'out_octets': '5530696993',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5530696993',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1254,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.898}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:d2:68:7d'],
                                                                       'id': '1',
                                                                       'in_octets': '5530696993',
                                                                       'mac_address': '78:8a:20:c1:41:54',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '76576807976',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MTU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Christmas Cove - 10720 - Willard '
                                                 'Kolarik',
                                         'serial_number': 'UBNT20c04154',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:41:54',
                                         'temperature': 33.0,
                                         'uptime': '5255084'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '514072433979',
                                                                       'links': [       {       'in_octets': '514072433979',
                                                                                                'out_octets': '57572867345',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '57572867345',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4322406',
                                                                                                                        'fiber_length': 1160,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.982}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '38:94:ed:5a:74:1e'],
                                                                       'id': '1',
                                                                       'in_octets': '57572867345',
                                                                       'mac_address': '78:8a:20:c1:43:11',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '514072433979',
                                                                       'poller_hash': 'Nzg4YTIwYzA0MzExZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12375 - Joseph Defors - '
                                                 '15486',
                                         'serial_number': 'UBNT20c04311',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:8a:20:c0:43:11',
                                         'temperature': 34.0,
                                         'uptime': '4322459'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '195572574649',
                                                                       'links': [       {       'in_octets': '195572574649',
                                                                                                'out_octets': '5850564344',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5850564344',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '696276',
                                                                                                                        'fiber_length': 963,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.316,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.266}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c0:06:c3:2f:d4:3d'],
                                                                       'id': '1',
                                                                       'in_octets': '5850564344',
                                                                       'mac_address': '78:45:58:91:e1:88',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '195572574649',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMTg4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Shores Ct - 12372 - Maginot, Anne & '
                                                 'Peter - 20791',
                                         'serial_number': 'UBNT5890e188',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e1:88',
                                         'temperature': 28.0,
                                         'uptime': '738817'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '367692822981',
                                                                       'links': [       {       'in_octets': '367692822981',
                                                                                                'out_octets': '28482786557',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28482786557',
                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 701,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.324,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.784}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:40:d0:50:f6:20'],
                                                                       'id': '1',
                                                                       'in_octets': '28482786557',
                                                                       'mac_address': '68:d7:9a:07:87:03',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '367692822981',
                                                                       'poller_hash': 'NjhkNzlhMDY4NzAzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12331 - William Cron - '
                                                 '13536',
                                         'serial_number': 'UBNT9a068703',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:87:03',
                                         'temperature': 34.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '678532036424',
                                                                       'links': [       {       'in_octets': '678532036424',
                                                                                                'out_octets': '32455680456',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '32455680456',
                                                                       'poller_hash': 'MThlODI5MTk2YzExcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4484758',
                                                                                                                        'fiber_length': 1721,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.934,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.534}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk2YzExcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a0:40:a0:71:2d:88'],
                                                                       'id': '1',
                                                                       'in_octets': '32455680456',
                                                                       'mac_address': '18:e8:29:1a:6c:11',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '678532036424',
                                                                       'poller_hash': 'MThlODI5MTk2YzExZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12705 - Karen '
                                                 'Mulvahill - 14204',
                                         'serial_number': 'UBNT29196c11',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:6c:11',
                                         'temperature': 28.0,
                                         'uptime': '4484807'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4915886238',
                                                                       'links': [       {       'in_octets': '4915886238',
                                                                                                'out_octets': '1239678225',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1239678225',
                                                                       'poller_hash': 'MThlODI5MTk3MDdicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 1419,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.016,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.66}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk3MDdicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:0c:6b:2d:94:8a'],
                                                                       'id': '1',
                                                                       'in_octets': '1239678225',
                                                                       'mac_address': '18:e8:29:1a:70:7b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4915886238',
                                                                       'poller_hash': 'MThlODI5MTk3MDdiZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View-12545-John Wadas-16542',
                                         'serial_number': 'UBNT2919707b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:70:7b',
                                         'temperature': 40.0,
                                         'uptime': '5032193'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1375491216',
                                                                       'links': [       {       'in_octets': '1375491216',
                                                                                                'out_octets': '952532292',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '952532292',
                                                                       'poller_hash': 'MThlODI5MTk3NGU1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1361,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.406}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTk3NGU1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:99:cd:79'],
                                                                       'id': '1',
                                                                       'in_octets': '952532292',
                                                                       'mac_address': '18:e8:29:1a:74:e5',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1375491216',
                                                                       'poller_hash': 'MThlODI5MTk3NGU1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12571 - John Scott - '
                                                 '18909',
                                         'serial_number': 'UBNT291974e5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:74:e5',
                                         'temperature': 37.0,
                                         'uptime': '5032194'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1734780886',
                                                                       'links': [       {       'in_octets': '1734780886',
                                                                                                'out_octets': '1260143510',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1260143510',
                                                                       'poller_hash': 'MThlODI5MTliMGE5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 1874,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.494,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.626}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMGE5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '3c:37:86:c8:4c:76'],
                                                                       'id': '1',
                                                                       'in_octets': '1260143510',
                                                                       'mac_address': '18:e8:29:1a:b0:a9',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1734780886',
                                                                       'poller_hash': 'MThlODI5MTliMGE5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12771 - Bill Brown - '
                                                 '13712',
                                         'serial_number': 'UBNT2919b0a9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b0:a9',
                                         'temperature': 30.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4845405777',
                                                                       'links': [       {       'in_octets': '4845405777',
                                                                                                'out_octets': '2380974756',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2380974756',
                                                                       'poller_hash': 'MThlODI5MTliMGY5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1340,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.168,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.64}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMGY5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'b0:39:56:50:a7:80'],
                                                                       'id': '1',
                                                                       'in_octets': '2380974756',
                                                                       'mac_address': '18:e8:29:1a:b0:f9',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4845405777',
                                                                       'poller_hash': 'MThlODI5MTliMGY5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12563 - Don DAnnunzio '
                                                 '- 17717',
                                         'serial_number': 'UBNT2919b0f9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b0:f9',
                                         'temperature': 35.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '8140378726',
                                                                       'links': [       {       'in_octets': '8140378726',
                                                                                                'out_octets': '1472743210',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1472743210',
                                                                       'poller_hash': 'MThlODI5MTliMTEycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1356,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.326,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.692}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMTEycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'a0:04:60:04:24:be'],
                                                                       'id': '1',
                                                                       'in_octets': '1472743210',
                                                                       'mac_address': '18:e8:29:1a:b1:12',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8140378726',
                                                                       'poller_hash': 'MThlODI5MTliMTEyZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12585 - Ronald Jones - '
                                                 '14376',
                                         'serial_number': 'UBNT2919b112',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b1:12',
                                         'temperature': 32.0,
                                         'uptime': '5032199'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '918992463273',
                                                                       'links': [       {       'in_octets': '918992463273',
                                                                                                'out_octets': '33981904572',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33981904572',
                                                                       'poller_hash': 'MThlODI5MTliMjU3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 1227,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.634,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.768}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjU3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f4:92:bf:66:6a:d1'],
                                                                       'id': '1',
                                                                       'in_octets': '33981904572',
                                                                       'mac_address': '18:e8:29:1a:b2:57',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '918992463273',
                                                                       'poller_hash': 'MThlODI5MTliMjU3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12527 - John '
                                                 'Christophersen - 17017',
                                         'serial_number': 'UBNT2919b257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:57',
                                         'temperature': 37.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '154147386163',
                                                                       'links': [       {       'in_octets': '154147386163',
                                                                                                'out_octets': '7464622801',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7464622801',
                                                                       'poller_hash': 'MThlODI5MTliMjYxcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1776,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.042,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.496}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjYxcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:b0:ce:10:fa:03'],
                                                                       'id': '1',
                                                                       'in_octets': '7464622801',
                                                                       'mac_address': '18:e8:29:1a:b2:61',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '154147386163',
                                                                       'poller_hash': 'MThlODI5MTliMjYxZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12755 - Paul '
                                                 'Christopheren - 16068',
                                         'serial_number': 'UBNT2919b261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:61',
                                         'temperature': 30.0,
                                         'uptime': '5032201'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '40935539',
                                                                       'links': [       {       'in_octets': '40935539',
                                                                                                'out_octets': '36544651',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '36544651',
                                                                       'poller_hash': 'MThlODI5MTliMjZicGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '185592',
                                                                                                                        'fiber_length': 1747,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.366,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.638}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjZicG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '10:0c:6b:d6:f0:fe'],
                                                                       'id': '1',
                                                                       'in_octets': '36544651',
                                                                       'mac_address': '18:e8:29:1a:b2:6b',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '40935539',
                                                                       'poller_hash': 'MThlODI5MTliMjZiZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12727 - Rich Sutliff - '
                                                 '14696',
                                         'serial_number': 'UBNT2919b26b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:6b',
                                         'temperature': 31.0,
                                         'uptime': '185648'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '337998269',
                                                                       'links': [       {       'in_octets': '337998269',
                                                                                                'out_octets': '1104833731',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '1104833731',
                                                                       'poller_hash': 'MThlODI5MTliMjdmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '1737394',
                                                                                                                        'fiber_length': 1929,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.19,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.39}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjdmcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:d2:94:18:c2:98'],
                                                                       'id': '1',
                                                                       'in_octets': '1104833731',
                                                                       'mac_address': '18:e8:29:1a:b2:7f',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '337998269',
                                                                       'poller_hash': 'MThlODI5MTliMjdmZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12811 - Robert Shirkey '
                                                 '- 13719',
                                         'serial_number': 'UBNT2919b27f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:7f',
                                         'temperature': 37.0,
                                         'uptime': '1737450'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '14599689500',
                                                                       'links': [       {       'in_octets': '14599689500',
                                                                                                'out_octets': '2776436093',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2776436093',
                                                                       'poller_hash': 'MThlODI5MTliMjk4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 1626,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.272,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.088}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMjk4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:07:b6:74:c5:ee'],
                                                                       'id': '1',
                                                                       'in_octets': '2776436093',
                                                                       'mac_address': '18:e8:29:1a:b2:98',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14599689500',
                                                                       'poller_hash': 'MThlODI5MTliMjk4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island VIew - 12655 - Al Blinke - '
                                                 '15472',
                                         'serial_number': 'UBNT2919b298',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:98',
                                         'temperature': 35.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '475854997',
                                                                       'links': [       {       'in_octets': '475854997',
                                                                                                'out_octets': '77755899',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '77755899',
                                                                       'poller_hash': 'MThlODI5MTliMmE3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 1966,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.362,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.428}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmE3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'f8:32:e4:b2:fc:50'],
                                                                       'id': '1',
                                                                       'in_octets': '77755899',
                                                                       'mac_address': '18:e8:29:1a:b2:a7',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '475854997',
                                                                       'poller_hash': 'MThlODI5MTliMmE3ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12831 - DomeHouse LLC '
                                                 '- 13718',
                                         'serial_number': 'UBNT2919b2a7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:a7',
                                         'temperature': 30.0,
                                         'uptime': '5032200'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '27306362339',
                                                                       'links': [       {       'in_octets': '27306362339',
                                                                                                'out_octets': '2309536034',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2309536034',
                                                                       'poller_hash': 'MThlODI5MTliMmFjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 2131,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.644,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.742}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliMmFjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '08:36:c9:14:fc:10'],
                                                                       'id': '1',
                                                                       'in_octets': '2309536034',
                                                                       'mac_address': '18:e8:29:1a:b2:ac',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '27306362339',
                                                                       'poller_hash': 'MThlODI5MTliMmFjZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12891 - Terry Fera - '
                                                 '15115',
                                         'serial_number': 'UBNT2919b2ac',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b2:ac',
                                         'temperature': 34.0,
                                         'uptime': '5032197'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '33990849922',
                                                                       'links': [       {       'in_octets': '33990849922',
                                                                                                'out_octets': '3089520612',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3089520612',
                                                                       'poller_hash': 'MThlODI5MTliM2Y2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581158',
                                                                                                                        'fiber_length': 2421,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.594,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.56}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliM2Y2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '6c:3b:6b:92:e4:29'],
                                                                       'id': '1',
                                                                       'in_octets': '3089520612',
                                                                       'mac_address': '18:e8:29:1a:b3:f6',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '33990849922',
                                                                       'poller_hash': 'MThlODI5MTliM2Y2ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12973 - Christine Kay '
                                                 '- 16910',
                                         'serial_number': 'UBNT2919b3f6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b3:f6',
                                         'temperature': 34.0,
                                         'uptime': '5032192'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '139759797',
                                                                       'links': [       {       'in_octets': '139759797',
                                                                                                'out_octets': '388447918',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '388447918',
                                                                       'poller_hash': 'MThlODI5MTliNDBhcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '575075',
                                                                                                                        'fiber_length': 1900,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.212,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.342}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MTliNDBhcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'e0:63:da:f9:95:4f'],
                                                                       'id': '1',
                                                                       'in_octets': '388447918',
                                                                       'mac_address': '18:e8:29:1a:b4:0a',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '139759797',
                                                                       'poller_hash': 'MThlODI5MTliNDBhZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12803 - Stephen '
                                                 'Rigotti - 14850',
                                         'serial_number': 'UBNT2919b40a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '18:e8:29:19:b4:0a',
                                         'temperature': 35.0,
                                         'uptime': '575128'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '297617759',
                                                                       'links': [       {       'in_octets': '297617759',
                                                                                                'out_octets': '435561254',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '435561254',
                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581168',
                                                                                                                        'fiber_length': 2134,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.544,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '40:ed:00:85:28:a5'],
                                                                       'id': '1',
                                                                       'in_octets': '435561254',
                                                                       'mac_address': '78:45:58:91:da:70',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '297617759',
                                                                       'poller_hash': 'Nzg0NTU4OTBkYTcwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12875 - Bridget Lamont '
                                                 '- 13721',
                                         'serial_number': 'UBNT5890da70',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:da:70',
                                         'temperature': 28.0,
                                         'uptime': '5032195'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '410031384428',
                                                                       'links': [       {       'in_octets': '410031384428',
                                                                                                'out_octets': '27249793080',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '27249793080',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2734303',
                                                                                                                        'fiber_length': 2014,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.912,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.364}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c8:9e:43:db:81:8b'],
                                                                       'id': '1',
                                                                       'in_octets': '27249793080',
                                                                       'mac_address': '78:45:58:91:e0:f4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '410031384428',
                                                                       'poller_hash': 'Nzg0NTU4OTBlMGY0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12851 - Joanne Whitley '
                                                 '- 14649',
                                         'serial_number': 'UBNT5890e0f4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e0:f4',
                                         'temperature': 30.0,
                                         'uptime': '2734357'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '60424821524',
                                                                       'links': [       {       'in_octets': '60424821524',
                                                                                                'out_octets': '3237963499',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '3237963499',
                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581167',
                                                                                                                        'fiber_length': 2366,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.142,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.622}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '50:91:e3:43:0d:f4'],
                                                                       'id': '1',
                                                                       'in_octets': '3237963499',
                                                                       'mac_address': '78:45:58:91:e8:94',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '60424821524',
                                                                       'poller_hash': 'Nzg0NTU4OTBlODk0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island Lake Dr - 13015 -Marilee '
                                                 'Milroy - 13348',
                                         'serial_number': 'UBNT5890e894',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '78:45:58:90:e8:94',
                                         'temperature': 26.0,
                                         'uptime': '5032196'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '0',
                                                                       'links': [       {       'in_octets': '0',
                                                                                                'out_octets': '176',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '176',
                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '4581166',
                                                                                                                        'fiber_length': 2134,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.798,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.486}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'mac_address': '68:d7:9a:07:8a:ad',
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NjhkNzlhMDY4YWFkZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island Dr - 12901 - Dan Cermak - '
                                                 '20905',
                                         'serial_number': 'UBNT9a068aad',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '68:d7:9a:06:8a:ad',
                                         'temperature': 23.0,
                                         'uptime': '5032185'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '31896289481',
                                                                       'links': [       {       'in_octets': '31896289481',
                                                                                                'out_octets': '51881481642',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '51881481642',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3377329',
                                                                                                                        'fiber_length': 1196,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.586,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.672}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:22:54:32:d5:d1'],
                                                                       'id': '1',
                                                                       'in_octets': '51881481642',
                                                                       'mac_address': '74:83:c2:44:f7:90',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '31896289481',
                                                                       'poller_hash': 'NzQ4M2MyNDNmNzkwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View - 12531 - Malcolm Hickok '
                                                 '- 21903',
                                         'serial_number': 'UBNTc243f790',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:f7:90',
                                         'temperature': 31.0,
                                         'uptime': '3377385'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '178128411569',
                                                                       'links': [       {       'in_octets': '178128411569',
                                                                                                'out_octets': '7828326027',
                                                                                                'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7828326027',
                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '477264',
                                                                                                                        'fiber_length': 2310,
                                                                                                                        'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.31}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '14:91:82:2e:cf:55'],
                                                                       'id': '1',
                                                                       'in_octets': '7828326027',
                                                                       'mac_address': '74:83:c2:44:fb:46',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '178128411569',
                                                                       'poller_hash': 'NzQ4M2MyNDNmYjQ2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Island View Dr - 12931 - Judy Burns '
                                                 '- 15696',
                                         'serial_number': 'UBNTc243fb46',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.5.3',
                                         'system_mac_address': '74:83:c2:43:fb:46',
                                         'temperature': 33.0,
                                         'uptime': '477324'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_4_9_172_21_44_6(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.4.9.172_21_44_6")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 16,
                'sw_version': '4.4.9',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 1
        }
        exp_sta_stats = {
                '18:e8:29:0b:9a:d8': {       'dev_macs': ['74:4d:28:5b:15:46'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:9a:d8',
                                             'name': '22062-christina-king'},
                '18:e8:29:0b:b2:60': {       'dev_macs': ['1c:b7:2c:73:fb:88'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:b2:60',
                                             'name': '756737-blake-bennetts'},
                '18:e8:29:0b:d5:8c': {       'dev_macs': ['78:9a:18:42:bd:d4'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:d5:8c',
                                             'name': '23673-luke-urbine-nanog'},
                '18:e8:29:0b:d5:e4': {       'dev_macs': ['c8:7f:54:27:30:80'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:d5:e4',
                                             'name': '756708-dallas-campbell'},
                '18:e8:29:0b:f3:0c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f3:0c',
                                             'name': ''},
                '18:e8:29:0b:f7:10': {       'dev_macs': ['48:a9:8a:3a:a4:36'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f7:10',
                                             'name': '756279-alison-peticolas'},
                '18:e8:29:0b:f8:04': {       'dev_macs': ['d8:07:b6:f8:97:5e'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f8:04',
                                             'name': '26323-brett-wingo'},
                '18:e8:29:0b:f9:c0': {       'dev_macs': ['48:8f:5a:48:c3:db'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f9:c0',
                                             'name': '21839-greg-turner'},
                '18:e8:29:0b:f9:ec': {       'dev_macs': ['78:9a:18:90:0c:6f'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:f9:ec',
                                             'name': '756755-michael-blashka'},
                '18:e8:29:f5:80:54': {       'dev_macs': ['18:b1:69:e3:c3:a1'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:80:54',
                                             'name': '22049-Darren Patterson Christian '
                                                     'Academy'},
                '18:e8:29:f5:b0:72': {       'dev_macs': ['68:d7:9a:67:b9:2d'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:b0:72',
                                             'name': '10340-carlin-walsh-ufiberwifi'},
                '74:83:c2:f0:1e:90': {       'dev_macs': ['48:a9:8a:5f:bc:94'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:1e:90',
                                             'name': '756289-evan-bartlett-nanog'},
                '74:83:c2:f0:b1:a4': {       'dev_macs': ['18:fd:74:1c:bf:7a'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:b1:a4',
                                             'name': '756084-anna-toll'},
                'b4:fb:e4:eb:4d:58': {       'dev_macs': ['48:8f:5a:49:bf:9b'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:58',
                                             'name': '10523-jay-leaver-nanog'},
                'b4:fb:e4:eb:4d:62': {       'dev_macs': ['34:98:b5:c4:4e:11'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:62',
                                             'name': '24017-grace-garret-nanog'},
                'b4:fb:e4:eb:50:73': {       'dev_macs': ['48:8f:5a:82:a9:f7'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:50:73',
                                             'name': '20157-ellen-kelly-nanog'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '2',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '20388745886',
                                                              'in_ucast_pkts': '86765026',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '22445466182',
                                                              'out_ucast_pkts': '113743252',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1ZXRoMGludGY=',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'name': 'pon1',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uMWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '1120555480947',
                                                              'in_ucast_pkts': '3004647724',
                                                              'links': [       {       'in_octets': '60038134941',
                                                                                       'out_octets': '433845025854',
                                                                                       'poller_hash': 'MThlODI5MGI5YWQ4cGVlcmludGY='},
                                                                               {       'in_octets': '51597476640',
                                                                                       'out_octets': '376473216479',
                                                                                       'poller_hash': 'MThlODI5MGJiMjYwcGVlcmludGY='},
                                                                               {       'in_octets': '77031716161',
                                                                                       'out_octets': '1285929769043',
                                                                                       'poller_hash': 'MThlODI5MGJmODA0cGVlcmludGY='},
                                                                               {       'in_octets': '55272372563',
                                                                                       'out_octets': '654710786269',
                                                                                       'poller_hash': 'MThlODI5MGJmOWMwcGVlcmludGY='},
                                                                               {       'in_octets': '140405299525',
                                                                                       'out_octets': '758396543589',
                                                                                       'poller_hash': 'MThlODI5ZjU4MDU0cGVlcmludGY='},
                                                                               {       'in_octets': '13635545316',
                                                                                       'out_octets': '153401865394',
                                                                                       'poller_hash': 'MThlODI5ZjViMDcycGVlcmludGY='},
                                                                               {       'in_octets': '79506814602',
                                                                                       'out_octets': '877525143799',
                                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwcGVlcmludGY='},
                                                                               {       'in_octets': '33624625113',
                                                                                       'out_octets': '343333914855',
                                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0cGVlcmludGY='},
                                                                               {       'in_octets': '6190169311',
                                                                                       'out_octets': '26759028333',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4cGVlcmludGY='},
                                                                               {       'in_octets': '16408151466',
                                                                                       'out_octets': '244967364534',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYycGVlcmludGY='},
                                                                               {       'in_octets': '30361231639',
                                                                                       'out_octets': '882718479596',
                                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '11228178267328',
                                                              'out_ucast_pkts': '8601966144',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY=',
                                                              'pons': [       {       'description': 'pon2',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '5605556',
                                                                                                               'fiber_length': 330,
                                                                                                               'poller_hash': 'MThlODI5MGI5YWQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3604765',
                                                                                                               'fiber_length': 666,
                                                                                                               'poller_hash': 'MThlODI5MGJiMjYwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2561113',
                                                                                                               'fiber_length': 82,
                                                                                                               'poller_hash': 'MThlODI5MGJmODA0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3890178',
                                                                                                               'fiber_length': 407,
                                                                                                               'poller_hash': 'MThlODI5MGJmOWMwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '3699886',
                                                                                                               'fiber_length': 775,
                                                                                                               'poller_hash': 'MThlODI5ZjU4MDU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '389919',
                                                                                                               'fiber_length': 14,
                                                                                                               'poller_hash': 'MThlODI5ZjViMDcycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496547',
                                                                                                               'fiber_length': 644,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2409532',
                                                                                                               'fiber_length': 892,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496546',
                                                                                                               'fiber_length': 276,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496546',
                                                                                                               'fiber_length': 299,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '7496537',
                                                                                                               'fiber_length': 333,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '127260632961',
                                                              'in_ucast_pkts': '499224099',
                                                              'links': [       {       'in_octets': '36518536949',
                                                                                       'out_octets': '548885766037',
                                                                                       'poller_hash': 'MThlODI5MGJkNThjcGVlcmludGY='},
                                                                               {       'in_octets': '11447796092',
                                                                                       'out_octets': '194847602663',
                                                                                       'poller_hash': 'MThlODI5MGJkNWU0cGVlcmludGY='},
                                                                               {       'in_octets': '44346977227',
                                                                                       'out_octets': '554524252919',
                                                                                       'poller_hash': 'MThlODI5MGJmNzEwcGVlcmludGY='},
                                                                               {       'in_octets': '28361070702',
                                                                                       'out_octets': '276946513313',
                                                                                       'poller_hash': 'MThlODI5MGJmOWVjcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '1645173503700',
                                                              'out_ucast_pkts': '1273390540',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY=',
                                                              'pons': [       {       'description': 'pon4',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '6636377',
                                                                                                               'fiber_length': 1098,
                                                                                                               'poller_hash': 'MThlODI5MGJkNThjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '6280693',
                                                                                                               'fiber_length': 980,
                                                                                                               'poller_hash': 'MThlODI5MGJkNWU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '6654297',
                                                                                                               'fiber_length': 920,
                                                                                                               'poller_hash': 'MThlODI5MGJmNzEwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2856206',
                                                                                                               'fiber_length': 852,
                                                                                                               'poller_hash': 'MThlODI5MGJmOWVjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon5',
                                                              'name': 'pon5',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon6',
                                                              'name': 'pon6',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uNmludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon7',
                                                              'name': 'pon7',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uN2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon8',
                                                              'name': 'pon8',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1cG9uOGludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '12833913779436',
                                                              'in_ucast_pkts': '9877430610',
                                                              'manufacturer': 'OEM',
                                                              'model': 'HWDA0001',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '1233848286561',
                                                              'out_ucast_pkts': '3503991099',
                                                              'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMWludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'sfp2',
                                                              'name': 'SFP+ 2',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMmludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 13.0,
                                'model': 'UFiber OLT',
                                'serial_number': 'UBNTe41b2875',
                                'sw_version': '4.4.9',
                                'system_mac_address': 'b4:fb:e4:1b:28:75',
                                'temperature': 30.25,
                                'uptime': '7496661'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5MGJmMzBjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmMzBjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5MGJmMzBjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': '',
                                         'offline_reason': 'OFFLINE_REASON_LOSS_OF_SIGNAL',
                                         'offline_reason_detail': 'Power outage not '
                                                                  'detected.',
                                         'serial_number': 'UBNT290bf30c',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:0b:f3:0c'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '433845025854',
                                                                       'links': [       {       'in_octets': '433845025854',
                                                                                                'out_octets': '60038134941',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '60038134941',
                                                                       'poller_hash': 'MThlODI5MGI5YWQ4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '5605556',
                                                                                                                        'fiber_length': 330,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.392,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.716}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGI5YWQ4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '74:4d:28:5b:15:46'],
                                                                       'id': '1',
                                                                       'in_octets': '60038134941',
                                                                       'mac_address': '18:e8:29:0c:9a:d8',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '433845025854',
                                                                       'poller_hash': 'MThlODI5MGI5YWQ4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '22062-christina-king',
                                         'serial_number': 'UBNT290b9ad8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:9a:d8',
                                         'temperature': 48.0,
                                         'uptime': '5605599'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '376473216479',
                                                                       'links': [       {       'in_octets': '376473216479',
                                                                                                'out_octets': '51597476640',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '51597476640',
                                                                       'poller_hash': 'MThlODI5MGJiMjYwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3604765',
                                                                                                                        'fiber_length': 666,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.988,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.118}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJiMjYwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '1c:b7:2c:73:fb:88'],
                                                                       'id': '1',
                                                                       'in_octets': '51597476640',
                                                                       'mac_address': '18:e8:29:0c:b2:60',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '376473216479',
                                                                       'poller_hash': 'MThlODI5MGJiMjYwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756737-blake-bennetts',
                                         'serial_number': 'UBNT290bb260',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:b2:60',
                                         'temperature': 50.0,
                                         'uptime': '3604806'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '1285929769043',
                                                                       'links': [       {       'in_octets': '1285929769043',
                                                                                                'out_octets': '77031716161',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '77031716161',
                                                                       'poller_hash': 'MThlODI5MGJmODA0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2561113',
                                                                                                                        'fiber_length': 82,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.466,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.494}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmODA0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:07:b6:f8:97:5e'],
                                                                       'id': '1',
                                                                       'in_octets': '77031716161',
                                                                       'mac_address': '18:e8:29:0c:f8:04',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1285929769043',
                                                                       'poller_hash': 'MThlODI5MGJmODA0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '26323-brett-wingo',
                                         'serial_number': 'UBNT290bf804',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f8:04',
                                         'temperature': 37.0,
                                         'uptime': '2561157'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '654710786269',
                                                                       'links': [       {       'in_octets': '654710786269',
                                                                                                'out_octets': '55272372563',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '55272372563',
                                                                       'poller_hash': 'MThlODI5MGJmOWMwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3890178',
                                                                                                                        'fiber_length': 407,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.022,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.214}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmOWMwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:48:c3:db'],
                                                                       'id': '1',
                                                                       'in_octets': '55272372563',
                                                                       'mac_address': '18:e8:29:0c:f9:c0',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '654710786269',
                                                                       'poller_hash': 'MThlODI5MGJmOWMwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '21839-greg-turner',
                                         'serial_number': 'UBNT290bf9c0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f9:c0',
                                         'temperature': 40.0,
                                         'uptime': '3890220'},
                                 {       'admin_disabled': False,
                                         'cpu': 0.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '758396543589',
                                                                       'links': [       {       'in_octets': '758396543589',
                                                                                                'out_octets': '140405299525',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '140405299525',
                                                                       'poller_hash': 'MThlODI5ZjU4MDU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '3699886',
                                                                                                                        'fiber_length': 775,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.766,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.532}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjU4MDU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:b1:69:e3:c3:a1'],
                                                                       'id': '1',
                                                                       'in_octets': '140405299525',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '758396543589',
                                                                       'poller_hash': 'MThlODI5ZjU4MDU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Instant',
                                         'name': '22049-Darren Patterson Christian '
                                                 'Academy',
                                         'serial_number': 'UBNT29f58054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:f5:80:54',
                                         'temperature': 82.0,
                                         'uptime': '3699919'},
                                 {       'admin_disabled': False,
                                         'cpu': 50.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '153401865394',
                                                                       'links': [       {       'in_octets': '153401865394',
                                                                                                'out_octets': '13635545316',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '13635545316',
                                                                       'poller_hash': 'MThlODI5ZjViMDcycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '389919',
                                                                                                                        'fiber_length': 14,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.52,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.648}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjViMDcycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'name': 'eth0',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMg=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'name': 'eth2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoMw=='},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '68:d7:9a:67:b9:2d'],
                                                                       'id': '4',
                                                                       'in_octets': '276638288894',
                                                                       'name': 'eth3',
                                                                       'oper_up': True,
                                                                       'out_octets': '2564788784954',
                                                                       'poller_hash': 'MThlODI5ZjViMDcyZXRoNA==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 15.0,
                                         'model': 'WiFi',
                                         'name': '10340-carlin-walsh-ufiberwifi',
                                         'serial_number': 'UBNT29f5b072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:f5:b0:72',
                                         'temperature': 57.0,
                                         'uptime': '389959'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '877525143799',
                                                                       'links': [       {       'in_octets': '877525143799',
                                                                                                'out_octets': '79506814602',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '79506814602',
                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496547',
                                                                                                                        'fiber_length': 644,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.054,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.108}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:a9:8a:5f:bc:94'],
                                                                       'id': '1',
                                                                       'in_octets': '79506814602',
                                                                       'mac_address': '74:83:c2:f1:1e:90',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '877525143799',
                                                                       'poller_hash': 'NzQ4M2MyZjAxZTkwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '756289-evan-bartlett-nanog',
                                         'serial_number': 'UBNTc2f01e90',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '74:83:c2:f0:1e:90',
                                         'temperature': 50.0,
                                         'uptime': '8889556'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '343333914855',
                                                                       'links': [       {       'in_octets': '343333914855',
                                                                                                'out_octets': '33624625113',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '33624625113',
                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2409532',
                                                                                                                        'fiber_length': 892,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.248,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.73}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:fd:74:1c:bf:7a'],
                                                                       'id': '1',
                                                                       'in_octets': '33624625113',
                                                                       'mac_address': '74:83:c2:f1:b1:a4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '343333914855',
                                                                       'poller_hash': 'NzQ4M2MyZjBiMWE0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756084-anna-toll',
                                         'serial_number': 'UBNTc2f0b1a4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '74:83:c2:f0:b1:a4',
                                         'temperature': 46.0,
                                         'uptime': '2409570'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '26759028333',
                                                                       'links': [       {       'in_octets': '26759028333',
                                                                                                'out_octets': '6190169311',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6190169311',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496546',
                                                                                                                        'fiber_length': 276,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.222,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.822}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:49:bf:9b'],
                                                                       'id': '1',
                                                                       'in_octets': '6190169311',
                                                                       'mac_address': 'b4:fb:e4:ec:4d:58',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26759028333',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDU4ZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '10523-jay-leaver-nanog',
                                         'serial_number': 'UBNTe4eb4d58',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:4d:58',
                                         'temperature': 53.0,
                                         'uptime': '8889544'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '244967364534',
                                                                       'links': [       {       'in_octets': '244967364534',
                                                                                                'out_octets': '16408151466',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '16408151466',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYycGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496546',
                                                                                                                        'fiber_length': 299,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.574,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.014}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '34:98:b5:c4:4e:11'],
                                                                       'id': '1',
                                                                       'in_octets': '16408151466',
                                                                       'mac_address': 'b4:fb:e4:ec:4d:62',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '244967364534',
                                                                       'poller_hash': 'YjRmYmU0ZWI0ZDYyZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '24017-grace-garret-nanog',
                                         'serial_number': 'UBNTe4eb4d62',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:4d:62',
                                         'temperature': 40.0,
                                         'uptime': '8889525'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '882718479596',
                                                                       'links': [       {       'in_octets': '882718479596',
                                                                                                'out_octets': '30361231639',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '30361231639',
                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '7496537',
                                                                                                                        'fiber_length': 333,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.172,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.078}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:8f:5a:82:a9:f7'],
                                                                       'id': '1',
                                                                       'in_octets': '30361231639',
                                                                       'mac_address': 'b4:fb:e4:ec:50:73',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '882718479596',
                                                                       'poller_hash': 'YjRmYmU0ZWI1MDczZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'NanoG',
                                         'name': '20157-ellen-kelly-nanog',
                                         'serial_number': 'UBNTe4eb5073',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': 'b4:fb:e4:eb:50:73',
                                         'temperature': 48.0,
                                         'uptime': '8889522'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '548885766037',
                                                                       'links': [       {       'in_octets': '548885766037',
                                                                                                'out_octets': '36518536949',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '36518536949',
                                                                       'poller_hash': 'MThlODI5MGJkNThjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6636377',
                                                                                                                        'fiber_length': 1098,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.872,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.934}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJkNThjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:9a:18:42:bd:d4'],
                                                                       'id': '1',
                                                                       'in_octets': '36518536949',
                                                                       'mac_address': '18:e8:29:0c:d5:8c',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '548885766037',
                                                                       'poller_hash': 'MThlODI5MGJkNThjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '23673-luke-urbine-nanog',
                                         'serial_number': 'UBNT290bd58c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:d5:8c',
                                         'temperature': 45.0,
                                         'uptime': '6636417'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '194847602663',
                                                                       'links': [       {       'in_octets': '194847602663',
                                                                                                'out_octets': '11447796092',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11447796092',
                                                                       'poller_hash': 'MThlODI5MGJkNWU0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6280693',
                                                                                                                        'fiber_length': 980,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.47,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.772}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJkNWU0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c8:7f:54:27:30:80'],
                                                                       'id': '1',
                                                                       'in_octets': '11447796092',
                                                                       'mac_address': '18:e8:29:0c:d5:e4',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '194847602663',
                                                                       'poller_hash': 'MThlODI5MGJkNWU0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756708-dallas-campbell',
                                         'serial_number': 'UBNT290bd5e4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:d5:e4',
                                         'temperature': 50.0,
                                         'uptime': '6280735'},
                                 {       'admin_disabled': False,
                                         'cpu': 1.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '554524252919',
                                                                       'links': [       {       'in_octets': '554524252919',
                                                                                                'out_octets': '44346977227',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '44346977227',
                                                                       'poller_hash': 'MThlODI5MGJmNzEwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '6654297',
                                                                                                                        'fiber_length': 920,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -23.01,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.744}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmNzEwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:a9:8a:3a:a4:36'],
                                                                       'id': '1',
                                                                       'in_octets': '44346977227',
                                                                       'mac_address': '18:e8:29:0c:f7:10',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '554524252919',
                                                                       'poller_hash': 'MThlODI5MGJmNzEwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756279-alison-peticolas',
                                         'serial_number': 'UBNT290bf710',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f7:10',
                                         'temperature': 40.0,
                                         'uptime': '6654336'},
                                 {       'admin_disabled': False,
                                         'cpu': 2.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '276946513313',
                                                                       'links': [       {       'in_octets': '276946513313',
                                                                                                'out_octets': '28361070702',
                                                                                                'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '28361070702',
                                                                       'poller_hash': 'MThlODI5MGJmOWVjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '2856206',
                                                                                                                        'fiber_length': 852,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.86,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.06}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5MGJmOWVjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '78:9a:18:90:0c:6f'],
                                                                       'id': '1',
                                                                       'in_octets': '28361070702',
                                                                       'mac_address': '18:e8:29:0c:f9:ec',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '276946513313',
                                                                       'poller_hash': 'MThlODI5MGJmOWVjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'NanoG',
                                         'name': '756755-michael-blashka',
                                         'serial_number': 'UBNT290bf9ec',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.4.9',
                                         'system_mac_address': '18:e8:29:0b:f9:ec',
                                         'temperature': 48.0,
                                         'uptime': '2856244'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_8_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.8.0.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 33,
                'sw_version': '4.8.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 1
        }
        exp_sta_stats = {
                '18:e8:29:f5:6d:15': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:6d:15',
                                             'name': ''},
                '18:e8:29:f5:6d:1c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:6d:1c',
                                             'name': 'Ambulance Test'},
                '68:d7:9a:06:fc:fc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '68:d7:9a:06:fc:fc',
                                             'name': 'Hood V2'},
                '70:a7:41:33:1f:bc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:1f:bc',
                                             'name': 'Lauren-McGinnis'},
                '70:a7:41:33:20:a0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:20:a0',
                                             'name': 'CLARK FORK PANTRY'},
                '70:a7:41:33:f6:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:f6:b4',
                                             'name': 'Vicki Woodward'},
                '70:a7:41:33:fd:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:33:fd:6c',
                                             'name': 'Scott Carlon V2'},
                '70:a7:41:36:53:b0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:36:53:b0',
                                             'name': 'BNSF railway co'},
                '74:ac:b9:06:ad:78': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ad:78',
                                             'name': 'Joanne Wilson'},
                '74:ac:b9:06:ad:ee': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ad:ee',
                                             'name': 'Adrianna Malley'},
                '74:ac:b9:06:ae:09': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ae:09',
                                             'name': 'Marilyn Anderson'},
                '74:ac:b9:06:ae:16': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:ae:16',
                                             'name': 'Taryn Maddox'},
                '74:ac:b9:06:b1:26': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:06:b1:26',
                                             'name': 'Dalton Bosscher'},
                '78:45:58:06:32:c9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:32:c9',
                                             'name': 'Greg Karraker'},
                '78:45:58:06:32:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:32:cd',
                                             'name': 'Donna Decker'},
                '78:45:58:06:34:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:34:cd',
                                             'name': 'Haley Poppleton'},
                '78:45:58:06:34:d3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:45:58:06:34:d3',
                                             'name': 'Railroad Ken Hays'},
                'ac:8b:a9:e5:3b:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ac:8b:a9:e5:3b:6c',
                                             'name': 'Kim Derr ?'},
                'd0:21:f9:06:3f:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:06:3f:90',
                                             'name': 'Maranda Painter'},
                'fc:ec:da:eb:7a:5d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:7a:5d',
                                             'name': 'Triston-Miller'},
                'fc:ec:da:eb:9a:c4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9a:c4',
                                             'name': 'Dave Farley'},
                'fc:ec:da:eb:9a:c9': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9a:c9',
                                             'name': 'Rosemary O’bryan'},
                'fc:ec:da:eb:9c:4f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9c:4f',
                                             'name': 'Amber Marcum'},
                'fc:ec:da:eb:9d:f3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:9d:f3',
                                             'name': 'Cenex'},
                'fc:ec:da:eb:b6:35': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:35',
                                             'name': 'Heritage Shores Realty T '
                                                     'Stevens'},
                'fc:ec:da:eb:b6:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:49',
                                             'name': 'Michael Willey'},
                'fc:ec:da:eb:b6:67': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b6:67',
                                             'name': 'Aspen Personal Care'},
                'fc:ec:da:eb:b7:cf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b7:cf',
                                             'name': 'Shari Jones'},
                'fc:ec:da:eb:b7:fc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b7:fc',
                                             'name': 'Robert-Moore'},
                'fc:ec:da:eb:b8:9c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b8:9c',
                                             'name': 'Kaniksu Office'},
                'fc:ec:da:eb:b9:3c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:3c',
                                             'name': 'Bill-Warren'},
                'fc:ec:da:eb:b9:64': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:64',
                                             'name': 'Sherman Henderson'},
                'fc:ec:da:eb:b9:73': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:b9:73',
                                             'name': 'Tim Knapp'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4c2ZwMWludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'sfp2',
                                                              'in_octets': '3286116448449',
                                                              'in_ucast_pkts': '2507410340',
                                                              'manufacturer': 'OEM',
                                                              'model': 'SFP-H10GB-CU1M',
                                                              'name': 'SFP+ 2',
                                                              'oper_up': True,
                                                              'out_octets': '210311843106',
                                                              'out_ucast_pkts': '753913677',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4c2ZwMmludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '55525339594',
                                                              'in_ucast_pkts': '177484870',
                                                              'links': [       {       'in_octets': '12781775655',
                                                                                       'out_octets': '135185803066',
                                                                                       'poller_hash': 'NzBhNzQxMzMxZmJjcGVlcmludGY='},
                                                                               {       'in_octets': '9002163043',
                                                                                       'out_octets': '99602809539',
                                                                                       'poller_hash': 'NzBhNzQxMzNmNmI0cGVlcmludGY='},
                                                                               {       'in_octets': '20751875520',
                                                                                       'out_octets': '196539817888',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZGVlcGVlcmludGY='},
                                                                               {       'in_octets': '8054214604',
                                                                                       'out_octets': '89860629017',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZTA5cGVlcmludGY='},
                                                                               {       'in_octets': '4935310772',
                                                                                       'out_octets': '155185915656',
                                                                                       'poller_hash': 'ZDAyMWY5MDYzZjkwcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '678048760779',
                                                              'out_ucast_pkts': '537866326',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY=',
                                                              'pons': [       {       'description': 'Blue',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '311068',
                                                                                                               'fiber_length': 544,
                                                                                                               'poller_hash': 'NzBhNzQxMzMxZmJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 651,
                                                                                                               'poller_hash': 'NzBhNzQxMzNmNmI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 477,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZGVlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 472,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZTA5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 472,
                                                                                                               'poller_hash': 'ZDAyMWY5MDYzZjkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '38336469612',
                                                              'in_ucast_pkts': '157047484',
                                                              'links': [       {       'in_octets': '2151469452',
                                                                                       'out_octets': '116831324957',
                                                                                       'poller_hash': 'NzBhNzQxMzNmZDZjcGVlcmludGY='},
                                                                               {       'in_octets': '7175125137',
                                                                                       'out_octets': '10321834793',
                                                                                       'poller_hash': 'NzRhY2I5MDZiMTI2cGVlcmludGY='},
                                                                               {       'in_octets': '2410307241',
                                                                                       'out_octets': '62876159271',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM0cGVlcmludGY='},
                                                                               {       'in_octets': '2058927817',
                                                                                       'out_octets': '39555315352',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM5cGVlcmludGY='},
                                                                               {       'in_octets': '11771178096',
                                                                                       'out_octets': '490512272621',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiOTY0cGVlcmludGY='},
                                                                               {       'in_octets': '12769461869',
                                                                                       'out_octets': '39767935958',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiOTczcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '761515140664',
                                                              'out_ucast_pkts': '576017036',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY=',
                                                              'pons': [       {       'description': 'Orange ',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '311059',
                                                                                                               'fiber_length': 478,
                                                                                                               'poller_hash': 'NzBhNzQxMzNmZDZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 406,
                                                                                                               'poller_hash': 'NzRhY2I5MDZiMTI2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 504,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '310259',
                                                                                                               'fiber_length': 529,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 560,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311059',
                                                                                                               'fiber_length': 425,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTczcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'name': 'pon3',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uM2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '21453110231',
                                                              'in_ucast_pkts': '72971103',
                                                              'links': [       {       'in_octets': '18736743395',
                                                                                       'out_octets': '210481783108',
                                                                                       'poller_hash': 'Nzg0NTU4MDYzNGNkcGVlcmludGY='},
                                                                               {       'in_octets': '2716366730',
                                                                                       'out_octets': '59705121384',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiNjQ5cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '271860689339',
                                                              'out_ucast_pkts': '234061953',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNGludGY=',
                                                              'pons': [       {       'description': 'Brown',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '311069',
                                                                                                               'fiber_length': 320,
                                                                                                               'poller_hash': 'Nzg0NTU4MDYzNGNkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 312,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjQ5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon5',
                                                              'in_errors': '0',
                                                              'in_octets': '7578422415',
                                                              'in_ucast_pkts': '64988246',
                                                              'links': [       {       'in_octets': '423305280',
                                                                                       'out_octets': '45954009558',
                                                                                       'poller_hash': 'Nzg0NTU4MDYzMmNkcGVlcmludGY='},
                                                                               {       'in_octets': '7155117135',
                                                                                       'out_octets': '262334510464',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZDc4cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon5',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '309962304701',
                                                              'out_ucast_pkts': '242353707',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNWludGY=',
                                                              'pons': [       {       'description': 'pon5',
                                                                                      'id': '5',
                                                                                      'links': [       {       'connected_time': '311069',
                                                                                                               'fiber_length': 150,
                                                                                                               'poller_hash': 'Nzg0NTU4MDYzMmNkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 401,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZDc4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon5',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys1',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon6',
                                                              'name': 'pon6',
                                                              'oper_up': False,
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNmludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon7',
                                                              'in_errors': '0',
                                                              'in_octets': '36313385931',
                                                              'in_ucast_pkts': '137197725',
                                                              'links': [       {       'in_octets': '2173538191',
                                                                                       'out_octets': '4100034678',
                                                                                       'poller_hash': 'NzBhNzQxMzY1M2IwcGVlcmludGY='},
                                                                               {       'in_octets': '2329067484',
                                                                                       'out_octets': '186992794526',
                                                                                       'poller_hash': 'Nzg0NTU4MDYzNGQzcGVlcmludGY='},
                                                                               {       'in_octets': '8442800612',
                                                                                       'out_octets': '71640579910',
                                                                                       'poller_hash': 'YWM4YmE5ZTUzYjZjcGVlcmludGY='},
                                                                               {       'in_octets': '6327065972',
                                                                                       'out_octets': '81105201304',
                                                                                       'poller_hash': 'ZmNlY2RhZWI3YTVkcGVlcmludGY='},
                                                                               {       'in_octets': '17040913672',
                                                                                       'out_octets': '516888560110',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5YzRmcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon7',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '862400501932',
                                                              'out_ucast_pkts': '648779707',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY=',
                                                              'pons': [       {       'description': 'pon7',
                                                                                      'id': '7',
                                                                                      'links': [       {       'connected_time': '311069',
                                                                                                               'fiber_length': 581,
                                                                                                               'poller_hash': 'NzBhNzQxMzY1M2IwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311049',
                                                                                                               'fiber_length': 661,
                                                                                                               'poller_hash': 'Nzg0NTU4MDYzNGQzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 440,
                                                                                                               'poller_hash': 'YWM4YmE5ZTUzYjZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311059',
                                                                                                               'fiber_length': 708,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI3YTVkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 425,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5YzRmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon7',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon8',
                                                              'in_errors': '0',
                                                              'in_octets': '53162656216',
                                                              'in_ucast_pkts': '143608668',
                                                              'links': [       {       'in_octets': '5334383430',
                                                                                       'out_octets': '85794231593',
                                                                                       'poller_hash': 'NzBhNzQxMzMyMGEwcGVlcmludGY='},
                                                                               {       'in_octets': '432261920',
                                                                                       'out_octets': '5101396295',
                                                                                       'poller_hash': 'Nzg0NTU4MDYzMmM5cGVlcmludGY='},
                                                                               {       'in_octets': '579407628',
                                                                                       'out_octets': '21316757263',
                                                                                       'poller_hash': 'NjhkNzlhMDZmY2ZjcGVlcmludGY='},
                                                                               {       'in_octets': '21154071418',
                                                                                       'out_octets': '259990899818',
                                                                                       'poller_hash': 'NzRhY2I5MDZhZTE2cGVlcmludGY='},
                                                                               {       'in_octets': '9045987323',
                                                                                       'out_octets': '12790727547',
                                                                                       'poller_hash': 'ZmNlY2RhZWI5ZGYzcGVlcmludGY='},
                                                                               {       'in_octets': '8430288154',
                                                                                       'out_octets': '13564429572',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiNjM1cGVlcmludGY='},
                                                                               {       'in_octets': '123491358',
                                                                                       'out_octets': '154808249',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiNjY3cGVlcmludGY='},
                                                                               {       'in_octets': '7852748263',
                                                                                       'out_octets': '14604299273',
                                                                                       'poller_hash': 'ZmNlY2RhZWJiODljcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-C+',
                                                              'name': 'pon8',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '418808109110',
                                                              'out_ucast_pkts': '355193394',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY=',
                                                              'pons': [       {       'description': 'pon8',
                                                                                      'id': '8',
                                                                                      'links': [       {       'connected_time': '311068',
                                                                                                               'fiber_length': 596,
                                                                                                               'poller_hash': 'NzBhNzQxMzMyMGEwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 887,
                                                                                                               'poller_hash': 'Nzg0NTU4MDYzMmM5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '162027',
                                                                                                               'fiber_length': 565,
                                                                                                               'poller_hash': 'NjhkNzlhMDZmY2ZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 651,
                                                                                                               'poller_hash': 'NzRhY2I5MDZhZTE2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311069',
                                                                                                               'fiber_length': 658,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI5ZGYzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 877,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjM1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 883,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjY3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '311068',
                                                                                                               'fiber_length': 880,
                                                                                                               'poller_hash': 'ZmNlY2RhZWJiODljcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -12.0,
                                                                                      'minimum_loss': -30.0,
                                                                                      'name': 'pon8',
                                                                                      'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'eth0',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2359251883',
                                                              'in_ucast_pkts': '25494075',
                                                              'in_unknown_protos': '0',
                                                              'name': 'MGMT',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1267910123',
                                                              'out_ucast_pkts': '4652604',
                                                              'poller_hash': 'YjRmYmU0MWIyMDk4ZXRoMGludGY='}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 12.0,
                                'model': 'UFiber OLT',
                                'serial_number': 'UBNTe41b2098',
                                'sw_version': '4.8.0',
                                'system_mac_address': 'b4:fb:e4:1b:20:98',
                                'temperature': 31.75,
                                'uptime': '311220'},
                'peers': [       {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjU2ZDE1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjU2ZDE1cG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5ZjU2ZDE1ZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': '',
                                         'name': '',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT29f56d15',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:f5:6d:15'},
                                 {       'admin_disabled': False,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MThlODI5ZjU2ZDFjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'MThlODI5ZjU2ZDFjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'MThlODI5ZjU2ZDFjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'WiFi',
                                         'name': 'Ambulance Test',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNT29f56d1c',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '18:e8:29:f5:6d:1c'},
                                 {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZmNlY2RhZWJiN2NmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiN2NmcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhZWJiN2NmZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Shari Jones',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTdaebb7cf',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'fc:ec:da:eb:b7:cf'},
                                 {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZmNlY2RhZWJiN2ZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiN2ZjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhZWJiN2ZjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Robert-Moore',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTdaebb7fc',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'fc:ec:da:eb:b7:fc'},
                                 {       'admin_disabled': True,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '0',
                                                                       'name': 'pon1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTNjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTNjcG9ubGluaw=='}]},
                                                               {       'id': '1',
                                                                       'name': 'eth0',
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTNjZXRoMQ=='}],
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'Loco',
                                         'name': 'Bill-Warren',
                                         'offline_reason': 'OFFLINE_REASON_OTHER',
                                         'offline_reason_detail': 'Disconnected due to '
                                                                  'unknown reason.',
                                         'serial_number': 'UBNTdaebb93c',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': 'fc:ec:da:eb:b9:3c'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '135185803066',
                                                                       'links': [       {       'in_octets': '135185803066',
                                                                                                'out_octets': '12781775655',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '12781775655',
                                                                       'poller_hash': 'NzBhNzQxMzMxZmJjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 544,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.926,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.674}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzMxZmJjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '12781775655',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '135185803066',
                                                                       'poller_hash': 'NzBhNzQxMzMxZmJjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Lauren-McGinnis',
                                         'serial_number': 'UBNT41331fbc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '70:a7:41:33:1f:bc',
                                         'temperature': 35.0,
                                         'uptime': '311214'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '99602809539',
                                                                       'links': [       {       'in_octets': '99602809539',
                                                                                                'out_octets': '9002163043',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9002163043',
                                                                       'poller_hash': 'NzBhNzQxMzNmNmI0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 651,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.808,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.012}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzNmNmI0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '9002163043',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '99602809539',
                                                                       'poller_hash': 'NzBhNzQxMzNmNmI0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Vicki Woodward',
                                         'serial_number': 'UBNT4133f6b4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '70:a7:41:33:f6:b4',
                                         'temperature': 35.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '196539817888',
                                                                       'links': [       {       'in_octets': '196539817888',
                                                                                                'out_octets': '20751875520',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '20751875520',
                                                                       'poller_hash': 'NzRhY2I5MDZhZGVlcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 477,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.968,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.948}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzRhY2I5MDZhZGVlcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '20751875520',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '196539817888',
                                                                       'poller_hash': 'NzRhY2I5MDZhZGVlZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Adrianna Malley',
                                         'serial_number': 'UBNTb906adee',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '74:ac:b9:06:ad:ee',
                                         'temperature': 33.0,
                                         'uptime': '311212'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '89860629017',
                                                                       'links': [       {       'in_octets': '89860629017',
                                                                                                'out_octets': '8054214604',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '8054214604',
                                                                       'poller_hash': 'NzRhY2I5MDZhZTA5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 472,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.938,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.108}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzRhY2I5MDZhZTA5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '8054214604',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '89860629017',
                                                                       'poller_hash': 'NzRhY2I5MDZhZTA5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Marilyn Anderson',
                                         'serial_number': 'UBNTb906ae09',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '74:ac:b9:06:ae:09',
                                         'temperature': 35.0,
                                         'uptime': '311214'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '155185915656',
                                                                       'links': [       {       'in_octets': '155185915656',
                                                                                                'out_octets': '4935310772',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '4935310772',
                                                                       'poller_hash': 'ZDAyMWY5MDYzZjkwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 472,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.914,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.968}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZDAyMWY5MDYzZjkwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '4935310772',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '155185915656',
                                                                       'poller_hash': 'ZDAyMWY5MDYzZjkwZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Maranda Painter',
                                         'serial_number': 'UBNTf9063f90',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'd0:21:f9:06:3f:90',
                                         'temperature': 30.0,
                                         'uptime': '311214'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '116831324957',
                                                                       'links': [       {       'in_octets': '116831324957',
                                                                                                'out_octets': '2151469452',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2151469452',
                                                                       'poller_hash': 'NzBhNzQxMzNmZDZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311059',
                                                                                                                        'fiber_length': 478,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -8.382,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.348}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzNmZDZjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2151469452',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '116831324957',
                                                                       'poller_hash': 'NzBhNzQxMzNmZDZjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Scott Carlon V2',
                                         'serial_number': 'UBNT4133fd6c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '70:a7:41:33:fd:6c',
                                         'temperature': 35.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '10321834793',
                                                                       'links': [       {       'in_octets': '10321834793',
                                                                                                'out_octets': '7175125137',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7175125137',
                                                                       'poller_hash': 'NzRhY2I5MDZiMTI2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 406,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.02,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.648}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzRhY2I5MDZiMTI2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7175125137',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10321834793',
                                                                       'poller_hash': 'NzRhY2I5MDZiMTI2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Dalton Bosscher',
                                         'serial_number': 'UBNTb906b126',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '74:ac:b9:06:b1:26',
                                         'temperature': 41.0,
                                         'uptime': '311212'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '62876159271',
                                                                       'links': [       {       'in_octets': '62876159271',
                                                                                                'out_octets': '2410307241',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2410307241',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 504,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.906,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.822}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2410307241',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '62876159271',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Dave Farley',
                                         'serial_number': 'UBNTdaeb9ac4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:9a:c4',
                                         'temperature': 39.0,
                                         'uptime': '311215'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '39555315352',
                                                                       'links': [       {       'in_octets': '39555315352',
                                                                                                'out_octets': '2058927817',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2058927817',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '310259',
                                                                                                                        'fiber_length': 529,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.038,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.224}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWI5YWM5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2058927817',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39555315352',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YWM5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Rosemary O’bryan',
                                         'serial_number': 'UBNTdaeb9ac9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:9a:c9',
                                         'temperature': 36.0,
                                         'uptime': '310325'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '490512272621',
                                                                       'links': [       {       'in_octets': '490512272621',
                                                                                                'out_octets': '11771178096',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '11771178096',
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTY0cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 560,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.018,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.442}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTY0cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '11771178096',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '490512272621',
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTY0ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Sherman Henderson',
                                         'serial_number': 'UBNTdaebb964',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b9:64',
                                         'temperature': 40.0,
                                         'uptime': '1833872'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '39767935958',
                                                                       'links': [       {       'in_octets': '39767935958',
                                                                                                'out_octets': '12769461869',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uMmludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '12769461869',
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTczcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311059',
                                                                                                                        'fiber_length': 425,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQisy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -9.054,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.992}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiOTczcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '12769461869',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39767935958',
                                                                       'poller_hash': 'ZmNlY2RhZWJiOTczZXRoMQ==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Tim Knapp',
                                         'serial_number': 'UBNTdaebb973',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b9:73',
                                         'temperature': 36.0,
                                         'uptime': '3548559'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '210481783108',
                                                                       'links': [       {       'in_octets': '210481783108',
                                                                                                'out_octets': '18736743395',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '18736743395',
                                                                       'poller_hash': 'Nzg0NTU4MDYzNGNkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 320,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.168,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.046}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDYzNGNkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '18736743395',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '210481783108',
                                                                       'poller_hash': 'Nzg0NTU4MDYzNGNkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Haley Poppleton',
                                         'serial_number': 'UBNT580634cd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '78:45:58:06:34:cd',
                                         'temperature': 31.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '59705121384',
                                                                       'links': [       {       'in_octets': '59705121384',
                                                                                                'out_octets': '2716366730',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2716366730',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjQ5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 312,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQis0',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.088,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.612}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjQ5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2716366730',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '59705121384',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjQ5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Michael Willey',
                                         'serial_number': 'UBNTdaebb649',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b6:49',
                                         'temperature': 39.0,
                                         'uptime': '311215'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '45954009558',
                                                                       'links': [       {       'in_octets': '45954009558',
                                                                                                'out_octets': '423305280',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '423305280',
                                                                       'poller_hash': 'Nzg0NTU4MDYzMmNkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 150,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.174,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.116}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDYzMmNkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '423305280',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '45954009558',
                                                                       'poller_hash': 'Nzg0NTU4MDYzMmNkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Donna Decker',
                                         'serial_number': 'UBNT580632cd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '78:45:58:06:32:cd',
                                         'temperature': 31.0,
                                         'uptime': '311215'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '262334510464',
                                                                       'links': [       {       'in_octets': '262334510464',
                                                                                                'out_octets': '7155117135',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uNWludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7155117135',
                                                                       'poller_hash': 'NzRhY2I5MDZhZDc4cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 401,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.996,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.664}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzRhY2I5MDZhZDc4cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7155117135',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '262334510464',
                                                                       'poller_hash': 'NzRhY2I5MDZhZDc4ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Joanne Wilson',
                                         'serial_number': 'UBNTb906ad78',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '74:ac:b9:06:ad:78',
                                         'temperature': 34.0,
                                         'uptime': '311215'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '4100034678',
                                                                       'links': [       {       'in_octets': '4100034678',
                                                                                                'out_octets': '2173538191',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2173538191',
                                                                       'poller_hash': 'NzBhNzQxMzY1M2IwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 581,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.382,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.02}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzY1M2IwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2173538191',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4100034678',
                                                                       'poller_hash': 'NzBhNzQxMzY1M2IwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'BNSF railway co',
                                         'serial_number': 'UBNT413653b0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '70:a7:41:36:53:b0',
                                         'temperature': 31.0,
                                         'uptime': '1715941'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '186992794526',
                                                                       'links': [       {       'in_octets': '186992794526',
                                                                                                'out_octets': '2329067484',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '2329067484',
                                                                       'poller_hash': 'Nzg0NTU4MDYzNGQzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311049',
                                                                                                                        'fiber_length': 661,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.914,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.74}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDYzNGQzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2329067484',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '186992794526',
                                                                       'poller_hash': 'Nzg0NTU4MDYzNGQzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Railroad Ken Hays',
                                         'serial_number': 'UBNT580634d3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '78:45:58:06:34:d3',
                                         'temperature': 36.0,
                                         'uptime': '311212'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '71640579910',
                                                                       'links': [       {       'in_octets': '71640579910',
                                                                                                'out_octets': '8442800612',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '8442800612',
                                                                       'poller_hash': 'YWM4YmE5ZTUzYjZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 440,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.432,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.826}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'YWM4YmE5ZTUzYjZjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '8442800612',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '71640579910',
                                                                       'poller_hash': 'YWM4YmE5ZTUzYjZjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Kim Derr ?',
                                         'serial_number': 'UBNTa9e53b6c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'ac:8b:a9:e5:3b:6c',
                                         'temperature': 35.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '81105201304',
                                                                       'links': [       {       'in_octets': '81105201304',
                                                                                                'out_octets': '6327065972',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '6327065972',
                                                                       'poller_hash': 'ZmNlY2RhZWI3YTVkcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311059',
                                                                                                                        'fiber_length': 708,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.518,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.852}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWI3YTVkcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '6327065972',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '81105201304',
                                                                       'poller_hash': 'ZmNlY2RhZWI3YTVkZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Triston-Miller',
                                         'serial_number': 'UBNTdaeb7a5d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:7a:5d',
                                         'temperature': 33.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '516888560110',
                                                                       'links': [       {       'in_octets': '516888560110',
                                                                                                'out_octets': '17040913672',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uN2ludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '17040913672',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YzRmcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 425,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -8.582,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.758}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWI5YzRmcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '17040913672',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '516888560110',
                                                                       'poller_hash': 'ZmNlY2RhZWI5YzRmZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Amber Marcum',
                                         'serial_number': 'UBNTdaeb9c4f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:9c:4f',
                                         'temperature': 36.0,
                                         'uptime': '311215'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '85794231593',
                                                                       'links': [       {       'in_octets': '85794231593',
                                                                                                'out_octets': '5334383430',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '5334383430',
                                                                       'poller_hash': 'NzBhNzQxMzMyMGEwcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 596,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.048,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.792}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzBhNzQxMzMyMGEwcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '5334383430',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '85794231593',
                                                                       'poller_hash': 'NzBhNzQxMzMyMGEwZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'CLARK FORK PANTRY',
                                         'serial_number': 'UBNT413320a0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '70:a7:41:33:20:a0',
                                         'temperature': 30.0,
                                         'uptime': '311210'},
                                 {       'admin_disabled': False,
                                         'cpu': 3.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '5101396295',
                                                                       'links': [       {       'in_octets': '5101396295',
                                                                                                'out_octets': '432261920',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '432261920',
                                                                       'poller_hash': 'Nzg0NTU4MDYzMmM5cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 887,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.386,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 0.294}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'Nzg0NTU4MDYzMmM5cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '432261920',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5101396295',
                                                                       'poller_hash': 'Nzg0NTU4MDYzMmM5ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Greg Karraker',
                                         'serial_number': 'UBNT580632c9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '78:45:58:06:32:c9',
                                         'temperature': 44.0,
                                         'uptime': '1714347'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '21316757263',
                                                                       'links': [       {       'in_octets': '21316757263',
                                                                                                'out_octets': '579407628',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '579407628',
                                                                       'poller_hash': 'NjhkNzlhMDZmY2ZjcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '162027',
                                                                                                                        'fiber_length': 565,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -10.776,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.546}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NjhkNzlhMDZmY2ZjcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '579407628',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21316757263',
                                                                       'poller_hash': 'NjhkNzlhMDZmY2ZjZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 54.0,
                                         'model': 'Loco',
                                         'name': 'Hood V2',
                                         'serial_number': 'UBNT9a06fcfc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '68:d7:9a:06:fc:fc',
                                         'temperature': 32.0,
                                         'uptime': '162089'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '259990899818',
                                                                       'links': [       {       'in_octets': '259990899818',
                                                                                                'out_octets': '21154071418',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '21154071418',
                                                                       'poller_hash': 'NzRhY2I5MDZhZTE2cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 651,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.894,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.98}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'NzRhY2I5MDZhZTE2cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '21154071418',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '259990899818',
                                                                       'poller_hash': 'NzRhY2I5MDZhZTE2ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Taryn Maddox',
                                         'serial_number': 'UBNTb906ae16',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': '74:ac:b9:06:ae:16',
                                         'temperature': 28.0,
                                         'uptime': '311212'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '12790727547',
                                                                       'links': [       {       'in_octets': '12790727547',
                                                                                                'out_octets': '9045987323',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '9045987323',
                                                                       'poller_hash': 'ZmNlY2RhZWI5ZGYzcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311069',
                                                                                                                        'fiber_length': 658,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.664,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.614}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWI5ZGYzcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '9045987323',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12790727547',
                                                                       'poller_hash': 'ZmNlY2RhZWI5ZGYzZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Cenex',
                                         'serial_number': 'UBNTdaeb9df3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:9d:f3',
                                         'temperature': 38.0,
                                         'uptime': '311214'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '13564429572',
                                                                       'links': [       {       'in_octets': '13564429572',
                                                                                                'out_octets': '8430288154',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '8430288154',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjM1cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 877,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.746,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 3.128}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjM1cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '8430288154',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13564429572',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjM1ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Heritage Shores Realty T Stevens',
                                         'serial_number': 'UBNTdaebb635',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b6:35',
                                         'temperature': 47.0,
                                         'uptime': '311214'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '154808249',
                                                                       'links': [       {       'in_octets': '154808249',
                                                                                                'out_octets': '123491358',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '123491358',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjY3cGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 883,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.268,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.678}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiNjY3cG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '123491358',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '154808249',
                                                                       'poller_hash': 'ZmNlY2RhZWJiNjY3ZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 55.0,
                                         'model': 'Loco',
                                         'name': 'Aspen Personal Care',
                                         'serial_number': 'UBNTdaebb667',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b6:67',
                                         'temperature': 46.0,
                                         'uptime': '311213'},
                                 {       'admin_disabled': False,
                                         'cpu': 4.0,
                                         'interfaces': [       {       'id': '0',
                                                                       'in_octets': '14604299273',
                                                                       'links': [       {       'in_octets': '14604299273',
                                                                                                'out_octets': '7852748263',
                                                                                                'poller_hash': 'YjRmYmU0MWIyMDk4cG9uOGludGY='}],
                                                                       'name': 'pon1',
                                                                       'out_octets': '7852748263',
                                                                       'poller_hash': 'ZmNlY2RhZWJiODljcGVlcmludGY=',
                                                                       'pons': [       {       'description': 'pon1',
                                                                                               'id': '0',
                                                                                               'links': [       {       'connected_time': '311068',
                                                                                                                        'fiber_length': 880,
                                                                                                                        'poller_hash': 'YjRmYmU0MWIyMDk4VUYtR1AtQys4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.704,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.964}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -28.0,
                                                                                               'name': 'pon1',
                                                                                               'poller_hash': 'ZmNlY2RhZWJiODljcG9ubGluaw==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7852748263',
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14604299273',
                                                                       'poller_hash': 'ZmNlY2RhZWJiODljZXRoMQ==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 56.0,
                                         'model': 'Loco',
                                         'name': 'Kaniksu Office',
                                         'serial_number': 'UBNTdaebb89c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.8.0',
                                         'system_mac_address': 'fc:ec:da:eb:b8:9c',
                                         'temperature': 49.0,
                                         'uptime': '1714446'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_9_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.9.3.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 155,
                'sw_version': '4.9.3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 27
        }
        exp_sta_stats = {
                '18:e8:29:0b:41:0c': {       'dev_macs': ['54:af:97:78:6b:e8'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:41:0c',
                                             'name': '18:e8:29:0b:41:0c'},
                '18:e8:29:0b:41:d0': {       'dev_macs': ['ac:15:a2:b2:04:0c'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:41:d0',
                                             'name': '18:e8:29:0b:41:d0'},
                '18:e8:29:0b:41:e4': {       'dev_macs': ['d8:07:b6:6f:e9:a9'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:41:e4',
                                             'name': '18:e8:29:0b:41:e4'},
                '18:e8:29:0b:45:98': {       'dev_macs': ['8c:90:2d:20:c5:78'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:45:98',
                                             'name': '18:e8:29:0b:45:98'},
                '18:e8:29:0b:45:b8': {       'dev_macs': ['14:eb:b6:0f:b6:ac'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:45:b8',
                                             'name': '18:e8:29:0b:45:b8'},
                '18:e8:29:0b:4d:6c': {       'dev_macs': ['40:ed:00:a9:f3:f4'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:4d:6c',
                                             'name': '18:e8:29:0b:4d:6c'},
                '18:e8:29:0b:62:0c': {       'dev_macs': ['ac:15:a2:b1:ff:94'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:62:0c',
                                             'name': '18:e8:29:0b:62:0c'},
                '18:e8:29:0b:8d:d4': {       'dev_macs': ['48:22:54:56:e7:5c'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:8d:d4',
                                             'name': '18:e8:29:0b:8d:d4'},
                '18:e8:29:0b:90:00': {       'dev_macs': ['54:af:97:78:77:98'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:90:00',
                                             'name': '18:e8:29:0b:90:00'},
                '18:e8:29:0b:91:fc': {       'dev_macs': ['5c:62:8b:ef:68:7c'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:91:fc',
                                             'name': '18:e8:29:0b:91:fc'},
                '18:e8:29:0b:93:48': {       'dev_macs': ['f0:a7:31:09:aa:88'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:93:48',
                                             'name': '18:e8:29:0b:93:48'},
                '18:e8:29:0b:93:4c': {       'dev_macs': ['f0:a7:31:09:b5:a0'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:93:4c',
                                             'name': '18:e8:29:0b:93:4c'},
                '18:e8:29:0b:99:dc': {       'dev_macs': ['98:25:4a:2f:8f:34'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:99:dc',
                                             'name': '18:e8:29:0b:99:dc'},
                '18:e8:29:19:2a:1c': {       'dev_macs': ['98:25:4a:2f:7f:c0'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:2a:1c',
                                             'name': 'Vernon Root'},
                '18:e8:29:19:64:af': {       'dev_macs': ['2c:b8:ed:cf:2d:01'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:19:64:af',
                                             'name': 'Adam Eller - Village Market'},
                '18:e8:29:f0:c2:9b': {       'dev_macs': ['d8:47:32:da:2e:94'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:c2:9b',
                                             'name': 'Barb Matteson'},
                '18:e8:29:f0:c3:74': {       'dev_macs': ['54:af:97:78:72:bc'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f0:c3:74',
                                             'name': 'Dan Herald'},
                '18:e8:29:f5:22:f1': {       'dev_macs': ['60:32:b1:3d:d7:51'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:22:f1',
                                             'name': 'Julie Webster'},
                '18:e8:29:f5:24:1d': {       'dev_macs': ['d8:47:32:da:1e:50'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:24:1d',
                                             'name': 'Kurt Keiffer'},
                '18:e8:29:f5:24:b3': {       'dev_macs': ['3c:84:6a:c8:39:98'],
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:24:b3',
                                             'name': 'Richard Gonzales'},
                '44:d9:e7:96:3d:51': {       'dev_macs': ['d8:07:b6:fc:56:f0'],
                                             'ip_address': None,
                                             'mac_address': '44:d9:e7:96:3d:51',
                                             'name': 'Open Door Fellowship'},
                '70:a7:41:50:23:58': {       'dev_macs': ['f0:a7:31:c3:60:fc'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:23:58',
                                             'name': '70:a7:41:50:23:58'},
                '70:a7:41:50:39:48': {       'dev_macs': ['8c:90:2d:20:b8:90'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:39:48',
                                             'name': '70:a7:41:50:39:48'},
                '70:a7:41:50:49:bc': {       'dev_macs': ['f0:a7:31:c3:6a:c8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:49:bc',
                                             'name': '70:a7:41:50:49:bc'},
                '70:a7:41:50:4c:a4': {       'dev_macs': ['5c:62:8b:ef:69:dc'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:4c:a4',
                                             'name': '70:a7:41:50:4c:a4'},
                '70:a7:41:50:5c:94': {       'dev_macs': ['ec:75:0c:d7:83:ac'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:5c:94',
                                             'name': '70:a7:41:50:5c:94'},
                '70:a7:41:50:6d:ec': {       'dev_macs': ['68:3a:1e:44:7c:de'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:6d:ec',
                                             'name': '70:a7:41:50:6d:ec'},
                '70:a7:41:50:6e:f4': {       'dev_macs': ['5c:62:8b:ef:6b:04'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:6e:f4',
                                             'name': '70:a7:41:50:6e:f4'},
                '70:a7:41:50:75:ac': {       'dev_macs': ['f0:a7:31:c3:60:e4'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:75:ac',
                                             'name': '70:a7:41:50:75:ac'},
                '70:a7:41:50:75:d8': {       'dev_macs': ['f0:a7:31:c3:6a:ec'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:75:d8',
                                             'name': '70:a7:41:50:75:d8'},
                '70:a7:41:50:82:80': {       'dev_macs': ['50:91:e3:43:0a:14'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:82:80',
                                             'name': '70:a7:41:50:82:80'},
                '70:a7:41:50:83:dc': {       'dev_macs': ['e8:9f:80:a1:3b:60'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:83:dc',
                                             'name': '70:a7:41:50:83:dc'},
                '70:a7:41:50:86:18': {       'dev_macs': ['7c:f1:7e:8e:66:dc'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:86:18',
                                             'name': '70:a7:41:50:86:18'},
                '70:a7:41:50:86:20': {       'dev_macs': ['3c:52:a1:25:34:bc'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:86:20',
                                             'name': '70:a7:41:50:86:20'},
                '70:a7:41:50:92:1c': {       'dev_macs': ['ec:75:0c:d7:9f:d8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:92:1c',
                                             'name': '70:a7:41:50:92:1c'},
                '70:a7:41:50:95:20': {       'dev_macs': ['8c:90:2d:20:b3:a8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:95:20',
                                             'name': '70:a7:41:50:95:20'},
                '70:a7:41:50:b2:50': {       'dev_macs': ['a0:21:b7:b4:bf:99'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:b2:50',
                                             'name': '70:a7:41:50:b2:50'},
                '70:a7:41:50:b2:d8': {       'dev_macs': ['6c:5a:b0:40:c0:eb'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:b2:d8',
                                             'name': '70:a7:41:50:b2:d8'},
                '70:a7:41:50:b4:38': {       'dev_macs': ['ec:75:0c:d7:9f:94'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:b4:38',
                                             'name': '70:a7:41:50:b4:38'},
                '70:a7:41:50:b4:4c': {       'dev_macs': ['ec:75:0c:d7:98:28'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:b4:4c',
                                             'name': '70:a7:41:50:b4:4c'},
                '70:a7:41:50:ba:60': {       'dev_macs': ['68:ff:7b:e4:d0:1c'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:ba:60',
                                             'name': '70:a7:41:50:ba:60'},
                '70:a7:41:50:c8:9c': {       'dev_macs': ['50:d4:f7:fe:11:c5'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:c8:9c',
                                             'name': '70:a7:41:50:c8:9c'},
                '70:a7:41:50:cf:34': {       'dev_macs': ['e8:9c:25:b8:85:58'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:cf:34',
                                             'name': '70:a7:41:50:cf:34'},
                '70:a7:41:50:db:d4': {       'dev_macs': ['6c:5a:b0:90:1c:31'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:db:d4',
                                             'name': '70:a7:41:50:db:d4'},
                '70:a7:41:50:dc:1c': {       'dev_macs': ['74:fe:ce:0b:7c:38'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:dc:1c',
                                             'name': '70:a7:41:50:dc:1c'},
                '70:a7:41:50:dd:a8': {       'dev_macs': ['5c:a6:e6:be:52:f8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:dd:a8',
                                             'name': '70:a7:41:50:dd:a8'},
                '70:a7:41:50:dd:c8': {       'dev_macs': ['ec:75:0c:d7:9f:38'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:dd:c8',
                                             'name': '70:a7:41:50:dd:c8'},
                '70:a7:41:50:df:44': {       'dev_macs': ['54:af:97:78:7a:b8'],
                                             'ip_address': None,
                                             'mac_address': '70:a7:41:50:df:44',
                                             'name': '70:a7:41:50:df:44'},
                '74:83:c2:68:95:e9': {       'dev_macs': ['cc:32:e5:4a:71:29'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:95:e9',
                                             'name': 'Awnda Vargas'},
                '74:83:c2:68:b2:32': {       'dev_macs': ['3c:64:cf:2e:a2:0c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b2:32',
                                             'name': '74:83:c2:68:b2:32'},
                '74:83:c2:68:b4:4a': {       'dev_macs': ['40:3f:8c:a7:23:4a'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b4:4a',
                                             'name': 'Janet Kelly'},
                '74:83:c2:68:b4:6a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b4:6a',
                                             'name': 'Jessi Osterman'},
                '74:83:c2:68:b4:7c': {       'dev_macs': ['98:da:c4:77:2d:06'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b4:7c',
                                             'name': 'Kelsey Kasper'},
                '74:83:c2:68:b4:a2': {       'dev_macs': ['3c:84:6a:c8:1e:41'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b4:a2',
                                             'name': 'Rose Peiffer'},
                '74:83:c2:68:b5:5d': {       'dev_macs': ['40:ed:00:a9:f3:30'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b5:5d',
                                             'name': 'Sandy Alexander'},
                '74:83:c2:68:b8:52': {       'dev_macs': ['74:da:88:57:db:92'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:b8:52',
                                             'name': 'Ronald Schultz'},
                '74:83:c2:68:be:de': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:be:de',
                                             'name': 'Janet Copeland'},
                '74:83:c2:68:be:f2': {       'dev_macs': ['50:91:e3:ac:eb:7c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:be:f2',
                                             'name': '74:83:c2:68:be:f2'},
                '74:83:c2:68:bf:9a': {       'dev_macs': ['c4:6e:1f:96:bc:3f'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:bf:9a',
                                             'name': 'Charlotte Tabor'},
                '74:83:c2:68:c0:8f': {       'dev_macs': ['54:af:97:78:5c:48'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:c0:8f',
                                             'name': 'Amy Darling'},
                '74:83:c2:68:c0:d3': {       'dev_macs': ['74:da:88:57:aa:b1'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:c0:d3',
                                             'name': 'Gene Harlow'},
                '74:83:c2:68:c0:d6': {       'dev_macs': ['40:ed:00:a9:fa:9c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:c0:d6',
                                             'name': 'Emily Sprunk'},
                '74:83:c2:68:c0:dc': {       'dev_macs': ['00:90:7f:01:c6:c3'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:c0:dc',
                                             'name': 'Donohue & Donohue'},
                '74:83:c2:68:d9:61': {       'dev_macs': ['b0:be:76:62:cb:88'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:d9:61',
                                             'name': 'Norma Schafer'},
                '74:83:c2:68:d9:62': {       'dev_macs': ['d8:07:b6:66:b0:e8'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:d9:62',
                                             'name': 'Keishia Bupp'},
                '74:83:c2:68:db:de': {       'dev_macs': ['8c:90:2d:20:b8:c0'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:db:de',
                                             'name': 'Bernadette Roberts'},
                '74:83:c2:68:dc:21': {       'dev_macs': ['d8:07:b6:66:b7:db'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:dc:21',
                                             'name': 'Hollie Latimer'},
                '74:83:c2:68:dc:28': {       'dev_macs': ['d8:47:32:d8:20:82'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:dc:28',
                                             'name': 'Bryce Stout'},
                '74:83:c2:68:de:e6': {       'dev_macs': ['24:2f:d0:a8:f5:80'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:de:e6',
                                             'name': 'Kelsey Peterson'},
                '74:83:c2:68:df:f4': {       'dev_macs': ['40:3f:8c:a7:23:59'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:df:f4',
                                             'name': 'Nancy Fenn'},
                '74:83:c2:68:e0:07': {       'dev_macs': ['14:eb:b6:0f:ad:38'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:e0:07',
                                             'name': 'Arbutus Whitacre'},
                '74:83:c2:68:e2:b1': {       'dev_macs': ['b0:95:75:83:dd:3e'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:68:e2:b1',
                                             'name': 'Teresa Marks'},
                '74:83:c2:f0:00:d0': {       'dev_macs': ['bc:a5:11:d8:71:90'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:00:d0',
                                             'name': 'Stephany Botero'},
                '74:83:c2:f0:25:10': {       'dev_macs': ['00:31:92:da:68:8c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:25:10',
                                             'name': 'Fred Hawn'},
                '74:83:c2:f0:28:1c': {       'dev_macs': ['78:d2:94:71:8c:ed'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:28:1c',
                                             'name': 'Bill Wohlscheid'},
                '74:83:c2:f0:28:8c': {       'dev_macs': ['e4:c3:2a:da:57:8b'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:28:8c',
                                             'name': "Dallas O'Green"},
                '74:83:c2:f0:29:98': {       'dev_macs': ['e4:c3:2a:da:57:8e'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:29:98',
                                             'name': 'Becka Eldridge'},
                '74:83:c2:f0:29:b0': {       'dev_macs': ['e4:c3:2a:da:68:1a'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:29:b0',
                                             'name': 'Gail Litwiller'},
                '74:83:c2:f0:2b:60': {       'dev_macs': ['98:25:4a:2f:6e:54'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:2b:60',
                                             'name': '74:83:c2:f0:2b:60'},
                '74:83:c2:f0:2d:68': {       'dev_macs': ['3c:6a:d2:d8:40:d0'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:2d:68',
                                             'name': 'Amanda Stout - Muffin Top Bakery '
                                                     '& Deli'},
                '74:83:c2:f0:31:6c': {       'dev_macs': ['84:d8:1b:cc:6c:1f'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:31:6c',
                                             'name': 'John Martin'},
                '74:83:c2:f0:3e:1c': {       'dev_macs': ['ac:15:a2:b2:00:78'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:3e:1c',
                                             'name': 'Adam Cook '},
                '74:83:c2:f0:3e:44': {       'dev_macs': ['f0:a7:31:09:b8:6c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:3e:44',
                                             'name': '74:83:c2:f0:3e:44'},
                '74:83:c2:f0:3e:d8': {       'dev_macs': ['7c:10:c9:7e:f6:58'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:3e:d8',
                                             'name': 'Caden Foster'},
                '74:83:c2:f0:44:24': {       'dev_macs': ['5c:a6:e6:c0:9c:80'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:44:24',
                                             'name': '74:83:c2:f0:44:24'},
                '74:83:c2:f0:4e:b4': {       'dev_macs': ['c0:56:27:e5:35:aa'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:4e:b4',
                                             'name': 'Mary Cogswell'},
                '74:83:c2:f0:80:cc': {       'dev_macs': ['28:87:ba:74:90:e8'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:80:cc',
                                             'name': '74:83:c2:f0:80:cc'},
                '74:83:c2:f0:89:70': {       'dev_macs': ['ac:15:a2:b1:fc:fc'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:89:70',
                                             'name': '74:83:c2:f0:89:70'},
                '74:83:c2:f0:8c:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:8c:80',
                                             'name': '74:83:c2:f0:8c:80'},
                '74:83:c2:f0:90:b8': {       'dev_macs': ['54:af:97:78:55:3c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:90:b8',
                                             'name': '74:83:c2:f0:90:b8'},
                '74:83:c2:f0:95:f4': {       'dev_macs': ['54:af:97:78:60:d4'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:95:f4',
                                             'name': '74:83:c2:f0:95:f4'},
                '74:83:c2:f0:96:a4': {       'dev_macs': ['5c:a6:e6:be:4b:8c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:96:a4',
                                             'name': 'Tyler Beltz'},
                '74:83:c2:f0:97:44': {       'dev_macs': ['5c:a6:e6:be:48:58'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:97:44',
                                             'name': '74:83:c2:f0:97:44'},
                '74:83:c2:f0:9b:14': {       'dev_macs': ['14:eb:b6:0f:c3:34'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:9b:14',
                                             'name': '74:83:c2:f0:9b:14'},
                '74:83:c2:f0:a0:20': {       'dev_macs': ['3c:84:6a:c8:0a:f1'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:a0:20',
                                             'name': '74:83:c2:f0:a0:20'},
                '74:83:c2:f0:a2:b4': {       'dev_macs': ['b0:be:76:c4:54:1b'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:a2:b4',
                                             'name': 'Travis Bridson'},
                '74:83:c2:f0:ae:80': {       'dev_macs': ['5c:a5:bc:9e:77:a1'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:ae:80',
                                             'name': '74:83:c2:f0:ae:80'},
                '74:83:c2:f0:b4:7c': {       'dev_macs': ['28:87:ba:74:88:18'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:b4:7c',
                                             'name': '74:83:c2:f0:b4:7c'},
                '74:83:c2:f0:b4:94': {       'dev_macs': ['94:a6:7e:dd:c0:44'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:b4:94',
                                             'name': '74:83:c2:f0:b4:94'},
                '74:83:c2:f0:c8:90': {       'dev_macs': ['54:af:97:4f:82:7c'],
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:c8:90',
                                             'name': '74:83:c2:f0:c8:90'},
                '74:ac:b9:99:75:98': {       'dev_macs': ['1c:3b:f3:3d:de:4f'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:75:98',
                                             'name': 'Thomas Haradine'},
                '74:ac:b9:99:75:ef': {       'dev_macs': ['98:da:c4:55:cb:26'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:75:ef',
                                             'name': 'Heather Kapustka'},
                '74:ac:b9:99:76:86': {       'dev_macs': ['d8:47:32:d8:2d:54'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:76:86',
                                             'name': 'Sheila Fields'},
                '74:ac:b9:99:76:8a': {       'dev_macs': ['50:d4:f7:fe:17:5f'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:76:8a',
                                             'name': 'Janell Toth'},
                '74:ac:b9:99:76:90': {       'dev_macs': ['f0:a7:31:c3:69:d8'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:76:90',
                                             'name': 'Richard Schmidt'},
                '74:ac:b9:99:76:9b': {       'dev_macs': ['cc:32:e5:4b:ad:70'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:76:9b',
                                             'name': 'David Chandler'},
                '74:ac:b9:99:77:61': {       'dev_macs': ['ac:15:a2:b2:05:34'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:77:61',
                                             'name': 'Mark Jolls'},
                '74:ac:b9:99:77:86': {       'dev_macs': ['10:7b:44:e3:e6:58'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:77:86',
                                             'name': 'Cortnie Beechler'},
                '74:ac:b9:99:77:8b': {       'dev_macs': ['74:da:88:41:45:72'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:77:8b',
                                             'name': 'Dean Slack'},
                '74:ac:b9:99:78:44': {       'dev_macs': ['98:da:c4:f8:cf:ee'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:78:44',
                                             'name': 'Ken Kipp'},
                '74:ac:b9:99:78:48': {       'dev_macs': ['ac:9e:17:8b:fa:d0'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:78:48',
                                             'name': 'Betty Kellenberger'},
                '74:ac:b9:99:78:51': {       'dev_macs': ['10:0c:6b:f8:69:a2'],
                                             'ip_address': None,
                                             'mac_address': '74:ac:b9:99:78:51',
                                             'name': 'Kevin Reeder'},
                '78:8a:20:73:3c:19': {       'dev_macs': ['d8:07:b6:fc:3e:69'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:3c:19',
                                             'name': 'Samantha Gallagher'},
                '78:8a:20:73:dd:1d': {       'dev_macs': ['5c:62:8b:ef:72:38'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:dd:1d',
                                             'name': 'John Smith'},
                '78:8a:20:73:dd:31': {       'dev_macs': ['60:63:4c:61:06:af'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:dd:31',
                                             'name': '78:8a:20:73:dd:31'},
                '78:8a:20:73:dd:3b': {       'dev_macs': ['8c:90:2d:20:bc:94'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:dd:3b',
                                             'name': 'David Gage'},
                '78:8a:20:73:dd:59': {       'dev_macs': ['98:da:c4:0d:a8:03'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:dd:59',
                                             'name': 'Dan Curtis'},
                '78:8a:20:73:dd:5e': {       'dev_macs': ['d8:07:b6:d7:03:5c'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:dd:5e',
                                             'name': 'Steve Brown'},
                '78:8a:20:73:df:43': {       'dev_macs': ['3c:37:86:81:82:8e'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:df:43',
                                             'name': 'Joni Jegla'},
                '78:8a:20:73:df:52': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:df:52',
                                             'name': 'Pam Hagerman'},
                '78:8a:20:73:df:61': {       'dev_macs': ['8c:3b:ad:ed:09:77'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:df:61',
                                             'name': 'Autumn Parshall'},
                '78:8a:20:73:e1:8c': {       'dev_macs': ['40:ed:00:a9:fa:5c'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:e1:8c',
                                             'name': 'Al Horak'},
                '78:8a:20:73:e1:91': {       'dev_macs': ['3c:37:86:3e:53:79'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:e1:91',
                                             'name': 'Patricia Farmer'},
                '78:8a:20:73:f4:5b': {       'dev_macs': ['3c:84:6a:c8:14:e1'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:73:f4:5b',
                                             'name': 'Whitney Selleck'},
                '78:8a:20:78:0b:40': {       'dev_macs': ['50:91:e3:43:0c:a8'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:0b:40',
                                             'name': 'Hailey Whitcomb'},
                '78:8a:20:78:2b:2a': {       'dev_macs': ['d8:47:32:da:2e:a9'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:2b:2a',
                                             'name': 'Paula Tabor'},
                '78:8a:20:78:2d:96': {       'dev_macs': ['2c:4d:54:6f:54:4c'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:2d:96',
                                             'name': 'Ted Kelly'},
                '78:8a:20:78:32:14': {       'dev_macs': ['b0:a7:b9:a7:11:78'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:32:14',
                                             'name': 'Tim Stout'},
                '78:8a:20:78:39:2b': {       'dev_macs': ['e8:48:b8:70:de:a6'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:39:2b',
                                             'name': 'Paul Fancher'},
                '78:8a:20:78:3f:07': {       'dev_macs': ['98:da:c4:77:47:55'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:3f:07',
                                             'name': 'Michelle Bidwell'},
                '78:8a:20:78:3f:20': {       'dev_macs': ['d8:47:32:da:3d:79'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:3f:20',
                                             'name': 'Dennis Krick'},
                '78:8a:20:78:47:72': {       'dev_macs': ['d8:47:32:d8:8b:74'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:47:72',
                                             'name': 'Nathan Walker'},
                '78:8a:20:78:53:8e': {       'dev_macs': ['1c:3b:f3:87:7a:61'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:53:8e',
                                             'name': 'Cheryl Miller'},
                '78:8a:20:78:57:53': {       'dev_macs': ['98:03:8e:64:4f:51'],
                                             'ip_address': None,
                                             'mac_address': '78:8a:20:78:57:53',
                                             'name': 'Michelle Curtis'},
                'b4:fb:e4:79:0f:37': {       'dev_macs': ['50:c7:bf:9f:37:8e'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:0f:37',
                                             'name': 'Jesse Yeomans'},
                'b4:fb:e4:79:1d:65': {       'dev_macs': ['d8:47:32:da:32:72'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:79:1d:65',
                                             'name': 'Brenda Abbott'},
                'b4:fb:e4:e6:d0:00': {       'dev_macs': ['d8:47:32:da:2d:0b'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:e6:d0:00',
                                             'name': 'Bobbie Jo Johnson'},
                'b4:fb:e4:eb:47:0e': {       'dev_macs': ['74:da:88:6f:b6:68'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:47:0e',
                                             'name': 'Gale Beardslee'},
                'b4:fb:e4:eb:47:27': {       'dev_macs': ['b0:be:76:c4:53:46'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:47:27',
                                             'name': 'Zach Cooper'},
                'b4:fb:e4:eb:4b:ff': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4b:ff',
                                             'name': 'Donald Larsen'},
                'b4:fb:e4:eb:4c:3b': {       'dev_macs': ['98:ba:5f:61:3d:ab'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4c:3b',
                                             'name': 'Amanda Andrews'},
                'b4:fb:e4:eb:4f:7e': {       'dev_macs': ['78:d2:94:b1:dc:38'],
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4f:7e',
                                             'name': 'Russell Stanton'},
                'd0:21:f9:9a:23:c0': {       'dev_macs': ['8c:90:2d:20:b6:74'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:23:c0',
                                             'name': 'd0:21:f9:9a:23:c0'},
                'd0:21:f9:9a:36:a0': {       'dev_macs': ['70:8b:cd:e9:1f:c4'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:36:a0',
                                             'name': 'd0:21:f9:9a:36:a0'},
                'd0:21:f9:9a:77:c0': {       'dev_macs': ['e8:9f:80:76:33:c3'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:77:c0',
                                             'name': 'd0:21:f9:9a:77:c0'},
                'd0:21:f9:9a:a3:2c': {       'dev_macs': ['5c:a6:e6:c0:9c:18'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:a3:2c',
                                             'name': 'd0:21:f9:9a:a3:2c'},
                'd0:21:f9:9a:b3:dc': {       'dev_macs': ['ec:75:0c:d7:9a:a4'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:b3:dc',
                                             'name': 'd0:21:f9:9a:b3:dc'},
                'd0:21:f9:9a:bc:54': {       'dev_macs': ['9c:c9:eb:16:ac:93'],
                                             'ip_address': None,
                                             'mac_address': 'd0:21:f9:9a:bc:54',
                                             'name': 'd0:21:f9:9a:bc:54'},
                'f4:92:bf:06:4b:ee': {       'dev_macs': ['40:ed:00:a9:e0:00'],
                                             'ip_address': None,
                                             'mac_address': 'f4:92:bf:06:4b:ee',
                                             'name': 'f4:92:bf:06:4b:ee'},
                'f4:92:bf:06:4d:a7': {       'dev_macs': ['00:31:92:db:a6:eb'],
                                             'ip_address': None,
                                             'mac_address': 'f4:92:bf:06:4d:a7',
                                             'name': 'f4:92:bf:06:4d:a7'},
                'f4:92:bf:06:54:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f4:92:bf:06:54:b4',
                                             'name': 'f4:92:bf:06:54:b4'},
                'fc:ec:da:e0:ad:75': {       'dev_macs': ['d8:07:b6:fc:63:aa'],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:e0:ad:75',
                                             'name': 'Julie Jason'},
                'fc:ec:da:e0:af:19': {       'dev_macs': ['3c:84:6a:c8:11:18'],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:e0:af:19',
                                             'name': 'John Lewis'},
                'fc:ec:da:eb:4d:d5': {       'dev_macs': ['d8:07:b6:66:ee:29'],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:4d:d5',
                                             'name': 'fc:ec:da:eb:4d:d5'},
                'fc:ec:da:eb:51:86': {       'dev_macs': ['18:c2:41:60:e6:91'],
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:eb:51:86',
                                             'name': 'Carson City Lumber'}
        }
        exp_ne_msg = {
                'data': {       'cpu': 27.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': 'sfp1',
                                                              'in_octets': '64344079033565',
                                                              'in_ucast_pkts': '46930192808',
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-MM-10G',
                                                              'name': 'SFP+ 1',
                                                              'oper_up': True,
                                                              'out_octets': '4000441192968',
                                                              'out_ucast_pkts': '14223413713',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhic2ZwMWludGY=',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'sfp2',
                                                              'in_octets': '3312456686',
                                                              'in_ucast_pkts': '19374156',
                                                              'manufacturer': 'FS',
                                                              'model': 'SFP-GB-GE-T',
                                                              'name': 'SFP+ 2',
                                                              'oper_up': True,
                                                              'out_octets': '30383141938',
                                                              'out_ucast_pkts': '27431263',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhic2ZwMmludGY=',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon1',
                                                              'in_errors': '0',
                                                              'in_octets': '939390040577',
                                                              'in_ucast_pkts': '2984554145',
                                                              'links': [       {       'in_octets': '18639453465',
                                                                                       'out_octets': '242900771334',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZDVlcGVlcmludGY='},
                                                                               {       'in_octets': '5872755540',
                                                                                       'out_octets': '112587407398',
                                                                                       'poller_hash': 'Nzg4YTIwNzNlMThjcGVlcmludGY='},
                                                                               {       'in_octets': '5396451594',
                                                                                       'out_octets': '78942531540',
                                                                                       'poller_hash': 'Nzg4YTIwNzgzOTJicGVlcmludGY='},
                                                                               {       'in_octets': '36589359694',
                                                                                       'out_octets': '660205586860',
                                                                                       'poller_hash': 'MThlODI5MGI0MWU0cGVlcmludGY='},
                                                                               {       'in_octets': '10727180320',
                                                                                       'out_octets': '279466659184',
                                                                                       'poller_hash': 'MThlODI5MGI2MjBjcGVlcmludGY='},
                                                                               {       'in_octets': '46722095565',
                                                                                       'out_octets': '840946331913',
                                                                                       'poller_hash': 'MThlODI5MGI5MDAwcGVlcmludGY='},
                                                                               {       'in_octets': '3731498103',
                                                                                       'out_octets': '93716900363',
                                                                                       'poller_hash': 'MThlODI5MTkyYTFjcGVlcmludGY='},
                                                                               {       'in_octets': '366488045659',
                                                                                       'out_octets': '1638086863019',
                                                                                       'poller_hash': 'MThlODI5MTk2NGFmcGVlcmludGY='},
                                                                               {       'in_octets': '23798160338',
                                                                                       'out_octets': '242589571589',
                                                                                       'poller_hash': 'NzBhNzQxNTAzOTQ4cGVlcmludGY='},
                                                                               {       'in_octets': '62356039305',
                                                                                       'out_octets': '707471008023',
                                                                                       'poller_hash': 'NzBhNzQxNTA4NjE4cGVlcmludGY='},
                                                                               {       'in_octets': '3469170540',
                                                                                       'out_octets': '83107762913',
                                                                                       'poller_hash': 'NzBhNzQxNTA4NjIwcGVlcmludGY='},
                                                                               {       'in_octets': '4540051509',
                                                                                       'out_octets': '183826678407',
                                                                                       'poller_hash': 'NzBhNzQxNTBiNDRjcGVlcmludGY='},
                                                                               {       'in_octets': '13839194140',
                                                                                       'out_octets': '468445787524',
                                                                                       'poller_hash': 'NzBhNzQxNTBjODljcGVlcmludGY='},
                                                                               {       'in_octets': '10176476249',
                                                                                       'out_octets': '164944964864',
                                                                                       'poller_hash': 'NzBhNzQxNTBkZjQ0cGVlcmludGY='},
                                                                               {       'in_octets': '22334204580',
                                                                                       'out_octets': '1047741188938',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NzYxcGVlcmludGY='},
                                                                               {       'in_octets': '4224044',
                                                                                       'out_octets': '23654910',
                                                                                       'poller_hash': 'NzRhY2I5OTk3ODQ4cGVlcmludGY='},
                                                                               {       'in_octets': '93995912399',
                                                                                       'out_octets': '816388991709',
                                                                                       'poller_hash': 'ZjQ5MmJmMDY0YmVlcGVlcmludGY='},
                                                                               {       'in_octets': '768149842',
                                                                                       'out_octets': '13255407092',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiNDZhcGVlcmludGY='},
                                                                               {       'in_octets': '15737955025',
                                                                                       'out_octets': '582238002575',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiZWYycGVlcmludGY='},
                                                                               {       'in_octets': '48100944722',
                                                                                       'out_octets': '575334800740',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyOTk4cGVlcmludGY='},
                                                                               {       'in_octets': '25553577844',
                                                                                       'out_octets': '280078701866',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyYjYwcGVlcmludGY='},
                                                                               {       'in_octets': '6612136639',
                                                                                       'out_octets': '44819476861',
                                                                                       'poller_hash': 'NzQ4M2MyZjA0ZWI0cGVlcmludGY='},
                                                                               {       'in_octets': '10341299658',
                                                                                       'out_octets': '626894198719',
                                                                                       'poller_hash': 'NzQ4M2MyZjBjODkwcGVlcmludGY='},
                                                                               {       'in_octets': '38713462215',
                                                                                       'out_octets': '188739628036',
                                                                                       'poller_hash': 'ZmNlY2RhZWI1MTg2cGVlcmludGY='},
                                                                               {       'in_octets': '10545535358',
                                                                                       'out_octets': '88137082456',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0NzBlcGVlcmludGY='},
                                                                               {       'in_octets': '8656819344',
                                                                                       'out_octets': '406667030803',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0NzI3cGVlcmludGY='},
                                                                               {       'in_octets': '20462662798',
                                                                                       'out_octets': '395645646429',
                                                                                       'poller_hash': 'ZDAyMWY5OWE3N2MwcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon1',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '11382645603986',
                                                              'out_ucast_pkts': '8394141234',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uMWludGY=',
                                                              'pons': [       {       'description': 'pon1',
                                                                                      'id': '1',
                                                                                      'links': [       {       'connected_time': '1031598',
                                                                                                               'fiber_length': 725,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZDVlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031598',
                                                                                                               'fiber_length': 1214,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNlMThjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 1188,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgzOTJicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 1231,
                                                                                                               'poller_hash': 'MThlODI5MGI0MWU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '674052',
                                                                                                               'fiber_length': 915,
                                                                                                               'poller_hash': 'MThlODI5MGI2MjBjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 1154,
                                                                                                               'poller_hash': 'MThlODI5MGI5MDAwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 1040,
                                                                                                               'poller_hash': 'MThlODI5MTkyYTFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 2510,
                                                                                                               'poller_hash': 'MThlODI5MTk2NGFmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 1239,
                                                                                                               'poller_hash': 'NzBhNzQxNTAzOTQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 1112,
                                                                                                               'poller_hash': 'NzBhNzQxNTA4NjE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 408,
                                                                                                               'poller_hash': 'NzBhNzQxNTA4NjIwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407434',
                                                                                                               'fiber_length': 888,
                                                                                                               'poller_hash': 'NzBhNzQxNTBiNDRjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1350073',
                                                                                                               'fiber_length': 1123,
                                                                                                               'poller_hash': 'NzBhNzQxNTBjODljcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407434',
                                                                                                               'fiber_length': 965,
                                                                                                               'poller_hash': 'NzBhNzQxNTBkZjQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 665,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NzYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 875,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3ODQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 769,
                                                                                                               'poller_hash': 'ZjQ5MmJmMDY0YmVlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '126313',
                                                                                                               'fiber_length': 756,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiNDZhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 1311,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiZWYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 786,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyOTk4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 881,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyYjYwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 724,
                                                                                                               'poller_hash': 'NzQ4M2MyZjA0ZWI0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 579,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBjODkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404534',
                                                                                                               'fiber_length': 2527,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI1MTg2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407443',
                                                                                                               'fiber_length': 799,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0NzBlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407444',
                                                                                                               'fiber_length': 428,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0NzI3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407442',
                                                                                                               'fiber_length': 1266,
                                                                                                               'poller_hash': 'ZDAyMWY5OWE3N2MwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon1',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQisx',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon2',
                                                              'in_errors': '0',
                                                              'in_octets': '262003412987',
                                                              'in_ucast_pkts': '1272297995',
                                                              'links': [       {       'in_octets': '37637814171',
                                                                                       'out_octets': '635371058855',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZDNicGVlcmludGY='},
                                                                               {       'in_octets': '35760888963',
                                                                                       'out_octets': '1125963062810',
                                                                                       'poller_hash': 'MThlODI5MGI0MTBjcGVlcmludGY='},
                                                                               {       'in_octets': '19012675588',
                                                                                       'out_octets': '460720683448',
                                                                                       'poller_hash': 'MThlODI5MGI0NWI4cGVlcmludGY='},
                                                                               {       'in_octets': '29536272',
                                                                                       'out_octets': '288377634',
                                                                                       'poller_hash': 'MThlODI5ZjBjMjlicGVlcmludGY='},
                                                                               {       'in_octets': '9713286442',
                                                                                       'out_octets': '432101574719',
                                                                                       'poller_hash': 'MThlODI5ZjUyNDFkcGVlcmludGY='},
                                                                               {       'in_octets': '6604506875',
                                                                                       'out_octets': '303048777545',
                                                                                       'poller_hash': 'NzBhNzQxNTA1Yzk0cGVlcmludGY='},
                                                                               {       'in_octets': '3625885294',
                                                                                       'out_octets': '73158117404',
                                                                                       'poller_hash': 'NzBhNzQxNTA4M2RjcGVlcmludGY='},
                                                                               {       'in_octets': '22158171241',
                                                                                       'out_octets': '421611693347',
                                                                                       'poller_hash': 'NzBhNzQxNTA5MjFjcGVlcmludGY='},
                                                                               {       'in_octets': '12309737681',
                                                                                       'out_octets': '528272284968',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NjlicGVlcmludGY='},
                                                                               {       'in_octets': '15878192997',
                                                                                       'out_octets': '537231282811',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkYzIxcGVlcmludGY='},
                                                                               {       'in_octets': '1243425767',
                                                                                       'out_octets': '56463840765',
                                                                                       'poller_hash': 'NzQ4M2MyZjAzMTZjcGVlcmludGY='},
                                                                               {       'in_octets': '28884935552',
                                                                                       'out_octets': '460940635693',
                                                                                       'poller_hash': 'NzQ4M2MyZjA5NWY0cGVlcmludGY='},
                                                                               {       'in_octets': '8529929939',
                                                                                       'out_octets': '777516661834',
                                                                                       'poller_hash': 'NzQ4M2MyZjBhZTgwcGVlcmludGY='},
                                                                               {       'in_octets': '11486667743',
                                                                                       'out_octets': '301958210413',
                                                                                       'poller_hash': 'ZmNlY2RhZTBhZDc1cGVlcmludGY='},
                                                                               {       'in_octets': '3063110739',
                                                                                       'out_octets': '59093613538',
                                                                                       'poller_hash': 'ZDAyMWY5OWEyM2MwcGVlcmludGY='},
                                                                               {       'in_octets': '1415449939',
                                                                                       'out_octets': '2977898415',
                                                                                       'poller_hash': 'ZDAyMWY5OWFhMzJjcGVlcmludGY='},
                                                                               {       'in_octets': '25609643143',
                                                                                       'out_octets': '462288222841',
                                                                                       'poller_hash': 'ZDAyMWY5OWFiYzU0cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon2',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '6974916250259',
                                                              'out_ucast_pkts': '5009124804',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uMmludGY=',
                                                              'pons': [       {       'description': 'pon2',
                                                                                      'id': '2',
                                                                                      'links': [       {       'connected_time': '1407713',
                                                                                                               'fiber_length': 3673,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZDNicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407714',
                                                                                                               'fiber_length': 2751,
                                                                                                               'poller_hash': 'MThlODI5MGI0MTBjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407714',
                                                                                                               'fiber_length': 3606,
                                                                                                               'poller_hash': 'MThlODI5MGI0NWI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '2051',
                                                                                                               'fiber_length': 3037,
                                                                                                               'poller_hash': 'MThlODI5ZjBjMjlicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405144',
                                                                                                               'fiber_length': 3292,
                                                                                                               'poller_hash': 'MThlODI5ZjUyNDFkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407713',
                                                                                                               'fiber_length': 3295,
                                                                                                               'poller_hash': 'NzBhNzQxNTA1Yzk0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407713',
                                                                                                               'fiber_length': 3939,
                                                                                                               'poller_hash': 'NzBhNzQxNTA4M2RjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407714',
                                                                                                               'fiber_length': 3091,
                                                                                                               'poller_hash': 'NzBhNzQxNTA5MjFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405144',
                                                                                                               'fiber_length': 3295,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NjlicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031048',
                                                                                                               'fiber_length': 2408,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkYzIxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031668',
                                                                                                               'fiber_length': 3387,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAzMTZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407704',
                                                                                                               'fiber_length': 2529,
                                                                                                               'poller_hash': 'NzQ4M2MyZjA5NWY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407713',
                                                                                                               'fiber_length': 3886,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBhZTgwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407714',
                                                                                                               'fiber_length': 3634,
                                                                                                               'poller_hash': 'ZmNlY2RhZTBhZDc1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '839115',
                                                                                                               'fiber_length': 3154,
                                                                                                               'poller_hash': 'ZDAyMWY5OWEyM2MwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407713',
                                                                                                               'fiber_length': 3906,
                                                                                                               'poller_hash': 'ZDAyMWY5OWFhMzJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407714',
                                                                                                               'fiber_length': 2405,
                                                                                                               'poller_hash': 'ZDAyMWY5OWFiYzU0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon2',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQisy',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon3',
                                                              'in_errors': '0',
                                                              'in_octets': '371875119714',
                                                              'in_ucast_pkts': '1320140384',
                                                              'links': [       {       'in_octets': '2017393115',
                                                                                       'out_octets': '191427317244',
                                                                                       'poller_hash': 'Nzg4YTIwNzMzYzE5cGVlcmludGY='},
                                                                               {       'in_octets': '3507663896',
                                                                                       'out_octets': '58505224047',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZDFkcGVlcmludGY='},
                                                                               {       'in_octets': '10547509826',
                                                                                       'out_octets': '458522118477',
                                                                                       'poller_hash': 'Nzg4YTIwNzgyYjJhcGVlcmludGY='},
                                                                               {       'in_octets': '4596281928',
                                                                                       'out_octets': '96596730135',
                                                                                       'poller_hash': 'Nzg4YTIwNzgzMjE0cGVlcmludGY='},
                                                                               {       'in_octets': '9944526046',
                                                                                       'out_octets': '262095592389',
                                                                                       'poller_hash': 'MThlODI5MGI0ZDZjcGVlcmludGY='},
                                                                               {       'in_octets': '16737188045',
                                                                                       'out_octets': '500942241671',
                                                                                       'poller_hash': 'MThlODI5MGI4ZGQ0cGVlcmludGY='},
                                                                               {       'in_octets': '1806905949',
                                                                                       'out_octets': '13926758266',
                                                                                       'poller_hash': 'MThlODI5MGI5MzQ4cGVlcmludGY='},
                                                                               {       'in_octets': '30071213231',
                                                                                       'out_octets': '163115431189',
                                                                                       'poller_hash': 'NzBhNzQxNTA0Y2E0cGVlcmludGY='},
                                                                               {       'in_octets': '17851414284',
                                                                                       'out_octets': '464066919784',
                                                                                       'poller_hash': 'NzBhNzQxNTBkZGM4cGVlcmludGY='},
                                                                               {       'in_octets': '5470645247',
                                                                                       'out_octets': '79537799472',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NTk4cGVlcmludGY='},
                                                                               {       'in_octets': '12603614508',
                                                                                       'out_octets': '39457631363',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NjkwcGVlcmludGY='},
                                                                               {       'in_octets': '6871280044',
                                                                                       'out_octets': '324764091901',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiNTVkcGVlcmludGY='},
                                                                               {       'in_octets': '4757618645',
                                                                                       'out_octets': '59170595569',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiZjlhcGVlcmludGY='},
                                                                               {       'in_octets': '171173425',
                                                                                       'out_octets': '2389621938',
                                                                                       'poller_hash': 'NzQ4M2MyNjhjMGQzcGVlcmludGY='},
                                                                               {       'in_octets': '40011105492',
                                                                                       'out_octets': '448841768566',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkZWU2cGVlcmludGY='},
                                                                               {       'in_octets': '36520778961',
                                                                                       'out_octets': '164853232799',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyNTEwcGVlcmludGY='},
                                                                               {       'in_octets': '6843762863',
                                                                                       'out_octets': '293111473558',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyODFjcGVlcmludGY='},
                                                                               {       'in_octets': '1648589658',
                                                                                       'out_octets': '60262568369',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyOWIwcGVlcmludGY='},
                                                                               {       'in_octets': '16714227824',
                                                                                       'out_octets': '732989420463',
                                                                                       'poller_hash': 'NzQ4M2MyZjAzZTFjcGVlcmludGY='},
                                                                               {       'in_octets': '19737359508',
                                                                                       'out_octets': '844428583707',
                                                                                       'poller_hash': 'NzQ4M2MyZjBhMDIwcGVlcmludGY='},
                                                                               {       'in_octets': '44692296148',
                                                                                       'out_octets': '374077799379',
                                                                                       'poller_hash': 'YjRmYmU0NzkwZjM3cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon3',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '6833020094953',
                                                              'out_ucast_pkts': '5074199097',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uM2ludGY=',
                                                              'pons': [       {       'description': 'pon3',
                                                                                      'id': '3',
                                                                                      'links': [       {       'connected_time': '779274',
                                                                                                               'fiber_length': 2073,
                                                                                                               'poller_hash': 'Nzg4YTIwNzMzYzE5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407174',
                                                                                                               'fiber_length': 1749,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZDFkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 3974,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgyYjJhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '71782',
                                                                                                               'fiber_length': 2180,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgzMjE0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407174',
                                                                                                               'fiber_length': 2169,
                                                                                                               'poller_hash': 'MThlODI5MGI0ZDZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 2132,
                                                                                                               'poller_hash': 'MThlODI5MGI4ZGQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 2194,
                                                                                                               'poller_hash': 'MThlODI5MGI5MzQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 4163,
                                                                                                               'poller_hash': 'NzBhNzQxNTA0Y2E0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407174',
                                                                                                               'fiber_length': 1894,
                                                                                                               'poller_hash': 'NzBhNzQxNTBkZGM4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1357283',
                                                                                                               'fiber_length': 4046,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NTk4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404224',
                                                                                                               'fiber_length': 1875,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NjkwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407172',
                                                                                                               'fiber_length': 4154,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiNTVkcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 4105,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiZjlhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407164',
                                                                                                               'fiber_length': 3991,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhjMGQzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1030508',
                                                                                                               'fiber_length': 2192,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkZWU2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407174',
                                                                                                               'fiber_length': 1871,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyNTEwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 3749,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyODFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407174',
                                                                                                               'fiber_length': 2064,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyOWIwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407172',
                                                                                                               'fiber_length': 4133,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAzZTFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 2152,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBhMDIwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1407173',
                                                                                                               'fiber_length': 1761,
                                                                                                               'poller_hash': 'YjRmYmU0NzkwZjM3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon3',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQisz',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon4',
                                                              'in_errors': '0',
                                                              'in_octets': '622314649876',
                                                              'in_ucast_pkts': '2435570639',
                                                              'links': [       {       'in_octets': '16416915714',
                                                                                       'out_octets': '350557387547',
                                                                                       'poller_hash': 'Nzg4YTIwNzNmNDVicGVlcmludGY='},
                                                                               {       'in_octets': '10386415992',
                                                                                       'out_octets': '106000617351',
                                                                                       'poller_hash': 'Nzg4YTIwNzgyZDk2cGVlcmludGY='},
                                                                               {       'in_octets': '10143127955',
                                                                                       'out_octets': '158319409617',
                                                                                       'poller_hash': 'Nzg4YTIwNzgzZjA3cGVlcmludGY='},
                                                                               {       'in_octets': '6728404564',
                                                                                       'out_octets': '419520430582',
                                                                                       'poller_hash': 'MThlODI5MGI0MWQwcGVlcmludGY='},
                                                                               {       'in_octets': '21871073289',
                                                                                       'out_octets': '237086341944',
                                                                                       'poller_hash': 'MThlODI5MGI5MWZjcGVlcmludGY='},
                                                                               {       'in_octets': '1407490547',
                                                                                       'out_octets': '43121709053',
                                                                                       'poller_hash': 'MThlODI5ZjUyNGIzcGVlcmludGY='},
                                                                               {       'in_octets': '15418097207',
                                                                                       'out_octets': '69258235866',
                                                                                       'poller_hash': 'NzBhNzQxNTA2ZGVjcGVlcmludGY='},
                                                                               {       'in_octets': '4266381758',
                                                                                       'out_octets': '62539243265',
                                                                                       'poller_hash': 'NzBhNzQxNTBiMjUwcGVlcmludGY='},
                                                                               {       'in_octets': '4969279979',
                                                                                       'out_octets': '223275318578',
                                                                                       'poller_hash': 'NzBhNzQxNTBiMmQ4cGVlcmludGY='},
                                                                               {       'in_octets': '23869465738',
                                                                                       'out_octets': '42354500052',
                                                                                       'poller_hash': 'NzBhNzQxNTBiNDM4cGVlcmludGY='},
                                                                               {       'in_octets': '728686596',
                                                                                       'out_octets': '22373785936',
                                                                                       'poller_hash': 'NzBhNzQxNTBiYTYwcGVlcmludGY='},
                                                                               {       'in_octets': '5900070790',
                                                                                       'out_octets': '261663227098',
                                                                                       'poller_hash': 'NzBhNzQxNTBkZGE4cGVlcmludGY='},
                                                                               {       'in_octets': '19464512770',
                                                                                       'out_octets': '922228035012',
                                                                                       'poller_hash': 'NzRhY2I5OTk3Njg2cGVlcmludGY='},
                                                                               {       'in_octets': '14575964984',
                                                                                       'out_octets': '648134960708',
                                                                                       'poller_hash': 'NzRhY2I5OTk3Nzg2cGVlcmludGY='},
                                                                               {       'in_octets': '5446616207',
                                                                                       'out_octets': '228200799297',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiNDdjcGVlcmludGY='},
                                                                               {       'in_octets': '3770101377',
                                                                                       'out_octets': '107643707129',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiODUycGVlcmludGY='},
                                                                               {       'in_octets': '110242754130',
                                                                                       'out_octets': '284588275457',
                                                                                       'poller_hash': 'NzQ4M2MyNjhjMGRjcGVlcmludGY='},
                                                                               {       'in_octets': '24936747378',
                                                                                       'out_octets': '588750334825',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkOTYxcGVlcmludGY='},
                                                                               {       'in_octets': '17318254665',
                                                                                       'out_octets': '433744722507',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkYzI4cGVlcmludGY='},
                                                                               {       'in_octets': '72020274413',
                                                                                       'out_octets': '629359281785',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkZmY0cGVlcmludGY='},
                                                                               {       'in_octets': '29238260717',
                                                                                       'out_octets': '435337636918',
                                                                                       'poller_hash': 'NzQ4M2MyZjAwMGQwcGVlcmludGY='},
                                                                               {       'in_octets': '5459340179',
                                                                                       'out_octets': '262662910743',
                                                                                       'poller_hash': 'NzQ4M2MyZjAzZTQ0cGVlcmludGY='},
                                                                               {       'in_octets': '14484476540',
                                                                                       'out_octets': '192778614476',
                                                                                       'poller_hash': 'ZmNlY2RhZWI0ZGQ1cGVlcmludGY='},
                                                                               {       'in_octets': '52145522533',
                                                                                       'out_octets': '1184317020326',
                                                                                       'poller_hash': 'YjRmYmU0ZTZkMDAwcGVlcmludGY='},
                                                                               {       'in_octets': '16269550827',
                                                                                       'out_octets': '954437516142',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0YzNicGVlcmludGY='},
                                                                               {       'in_octets': '123068641',
                                                                                       'out_octets': '2056087603',
                                                                                       'poller_hash': 'NDRkOWU3OTYzZDUxcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon4',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '10631254365545',
                                                              'out_ucast_pkts': '7704060241',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uNGludGY=',
                                                              'pons': [       {       'description': 'pon4',
                                                                                      'id': '4',
                                                                                      'links': [       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1764,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNmNDVicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406623',
                                                                                                               'fiber_length': 1770,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgyZDk2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1017368',
                                                                                                               'fiber_length': 2161,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgzZjA3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1017128',
                                                                                                               'fiber_length': 2176,
                                                                                                               'poller_hash': 'MThlODI5MGI0MWQwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406624',
                                                                                                               'fiber_length': 1874,
                                                                                                               'poller_hash': 'MThlODI5MGI5MWZjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405754',
                                                                                                               'fiber_length': 1092,
                                                                                                               'poller_hash': 'MThlODI5ZjUyNGIzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406623',
                                                                                                               'fiber_length': 1091,
                                                                                                               'poller_hash': 'NzBhNzQxNTA2ZGVjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406634',
                                                                                                               'fiber_length': 1021,
                                                                                                               'poller_hash': 'NzBhNzQxNTBiMjUwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406634',
                                                                                                               'fiber_length': 1041,
                                                                                                               'poller_hash': 'NzBhNzQxNTBiMmQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1016268',
                                                                                                               'fiber_length': 2158,
                                                                                                               'poller_hash': 'NzBhNzQxNTBiNDM4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '70222',
                                                                                                               'fiber_length': 1388,
                                                                                                               'poller_hash': 'NzBhNzQxNTBiYTYwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406623',
                                                                                                               'fiber_length': 1934,
                                                                                                               'poller_hash': 'NzBhNzQxNTBkZGE4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405754',
                                                                                                               'fiber_length': 1777,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3Njg2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1025618',
                                                                                                               'fiber_length': 2197,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3Nzg2cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1026628',
                                                                                                               'fiber_length': 1909,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiNDdjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406634',
                                                                                                               'fiber_length': 1905,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiODUycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031718',
                                                                                                               'fiber_length': 1888,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhjMGRjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406614',
                                                                                                               'fiber_length': 1930,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkOTYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031598',
                                                                                                               'fiber_length': 2189,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkYzI4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406624',
                                                                                                               'fiber_length': 1760,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkZmY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406623',
                                                                                                               'fiber_length': 1355,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAwMGQwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406624',
                                                                                                               'fiber_length': 1845,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAzZTQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031648',
                                                                                                               'fiber_length': 2192,
                                                                                                               'poller_hash': 'ZmNlY2RhZWI0ZGQ1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1017358',
                                                                                                               'fiber_length': 2056,
                                                                                                               'poller_hash': 'YjRmYmU0ZTZkMDAwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406614',
                                                                                                               'fiber_length': 1788,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0YzNicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1017368',
                                                                                                               'fiber_length': 1294,
                                                                                                               'poller_hash': 'NDRkOWU3OTYzZDUxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon4',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQis0',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon5',
                                                              'in_errors': '0',
                                                              'in_octets': '349944350099',
                                                              'in_ucast_pkts': '1395372112',
                                                              'links': [       {       'in_octets': '3336426608',
                                                                                       'out_octets': '94783008857',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZDMxcGVlcmludGY='},
                                                                               {       'in_octets': '10411551012',
                                                                                       'out_octets': '113696342847',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZjQzcGVlcmludGY='},
                                                                               {       'in_octets': '8072649646',
                                                                                       'out_octets': '168253993783',
                                                                                       'poller_hash': 'Nzg4YTIwNzg1NzUzcGVlcmludGY='},
                                                                               {       'in_octets': '8902172717',
                                                                                       'out_octets': '378327332352',
                                                                                       'poller_hash': 'NzBhNzQxNTAyMzU4cGVlcmludGY='},
                                                                               {       'in_octets': '5506933895',
                                                                                       'out_octets': '45525612360',
                                                                                       'poller_hash': 'NzBhNzQxNTA3NWQ4cGVlcmludGY='},
                                                                               {       'in_octets': '39483103189',
                                                                                       'out_octets': '1329440870480',
                                                                                       'poller_hash': 'NzBhNzQxNTBkYmQ0cGVlcmludGY='},
                                                                               {       'in_octets': '16880218820',
                                                                                       'out_octets': '542526845346',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NWVmcGVlcmludGY='},
                                                                               {       'in_octets': '7669450365',
                                                                                       'out_octets': '408048307361',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NjhhcGVlcmludGY='},
                                                                               {       'in_octets': '12070672527',
                                                                                       'out_octets': '361587668008',
                                                                                       'poller_hash': 'NzRhY2I5OTk3ODQ0cGVlcmludGY='},
                                                                               {       'in_octets': '36135439351',
                                                                                       'out_octets': '324495246389',
                                                                                       'poller_hash': 'NzRhY2I5OTk3ODUxcGVlcmludGY='},
                                                                               {       'in_octets': '53591789927',
                                                                                       'out_octets': '850693876724',
                                                                                       'poller_hash': 'NzQ4M2MyNjg5NWU5cGVlcmludGY='},
                                                                               {       'in_octets': '8465035618',
                                                                                       'out_octets': '140739432490',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiNGEycGVlcmludGY='},
                                                                               {       'in_octets': '2829112634',
                                                                                       'out_octets': '128635733662',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkOTYycGVlcmludGY='},
                                                                               {       'in_octets': '43900700709',
                                                                                       'out_octets': '201880756204',
                                                                                       'poller_hash': 'NzQ4M2MyNjhkYmRlcGVlcmludGY='},
                                                                               {       'in_octets': '389788845',
                                                                                       'out_octets': '9651197379',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyODhjcGVlcmludGY='},
                                                                               {       'in_octets': '20262134216',
                                                                                       'out_octets': '480663961536',
                                                                                       'poller_hash': 'NzQ4M2MyZjBiNDk0cGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon5',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '6701913233205',
                                                              'out_ucast_pkts': '4965412959',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uNWludGY=',
                                                              'pons': [       {       'description': 'pon5',
                                                                                      'id': '5',
                                                                                      'links': [       {       'connected_time': '1031598',
                                                                                                               'fiber_length': 952,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZDMxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406904',
                                                                                                               'fiber_length': 916,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZjQzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '757843',
                                                                                                               'fiber_length': 979,
                                                                                                               'poller_hash': 'Nzg4YTIwNzg1NzUzcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406904',
                                                                                                               'fiber_length': 1023,
                                                                                                               'poller_hash': 'NzBhNzQxNTAyMzU4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406904',
                                                                                                               'fiber_length': 939,
                                                                                                               'poller_hash': 'NzBhNzQxNTA3NWQ4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406903',
                                                                                                               'fiber_length': 1466,
                                                                                                               'poller_hash': 'NzBhNzQxNTBkYmQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405444',
                                                                                                               'fiber_length': 1533,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NWVmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405454',
                                                                                                               'fiber_length': 1089,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NjhhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1405454',
                                                                                                               'fiber_length': 1497,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3ODQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031718',
                                                                                                               'fiber_length': 926,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3ODUxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1252812',
                                                                                                               'fiber_length': 1490,
                                                                                                               'poller_hash': 'NzQ4M2MyNjg5NWU5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031598',
                                                                                                               'fiber_length': 1232,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiNGEycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406904',
                                                                                                               'fiber_length': 945,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkOTYycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406903',
                                                                                                               'fiber_length': 1092,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhkYmRlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '43332',
                                                                                                               'fiber_length': 1087,
                                                                                                               'poller_hash': 'NzQ4M2MyZjAyODhjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406914',
                                                                                                               'fiber_length': 1455,
                                                                                                               'poller_hash': 'NzQ4M2MyZjBiNDk0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon5',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQis1',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon6',
                                                              'in_errors': '0',
                                                              'in_octets': '860299211240',
                                                              'in_ucast_pkts': '2029859612',
                                                              'links': [       {       'in_octets': '13176815651',
                                                                                       'out_octets': '241737803753',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZDU5cGVlcmludGY='},
                                                                               {       'in_octets': '64345771465',
                                                                                       'out_octets': '1203708003949',
                                                                                       'poller_hash': 'Nzg4YTIwNzNkZjYxcGVlcmludGY='},
                                                                               {       'in_octets': '18892214014',
                                                                                       'out_octets': '264212251421',
                                                                                       'poller_hash': 'Nzg4YTIwNzNlMTkxcGVlcmludGY='},
                                                                               {       'in_octets': '135840046518',
                                                                                       'out_octets': '1510358602929',
                                                                                       'poller_hash': 'Nzg4YTIwNzgwYjQwcGVlcmludGY='},
                                                                               {       'in_octets': '8549821211',
                                                                                       'out_octets': '604997255840',
                                                                                       'poller_hash': 'Nzg4YTIwNzgzZjIwcGVlcmludGY='},
                                                                               {       'in_octets': '3249480808',
                                                                                       'out_octets': '112023305777',
                                                                                       'poller_hash': 'Nzg4YTIwNzg0NzcycGVlcmludGY='},
                                                                               {       'in_octets': '11085937460',
                                                                                       'out_octets': '117760562367',
                                                                                       'poller_hash': 'Nzg4YTIwNzg1MzhlcGVlcmludGY='},
                                                                               {       'in_octets': '30179396265',
                                                                                       'out_octets': '146646851478',
                                                                                       'poller_hash': 'MThlODI5ZjBjMzc0cGVlcmludGY='},
                                                                               {       'in_octets': '23254642186',
                                                                                       'out_octets': '630014932267',
                                                                                       'poller_hash': 'NzRhY2I5OTk3NzhicGVlcmludGY='},
                                                                               {       'in_octets': '377606582245',
                                                                                       'out_octets': '656576138709',
                                                                                       'poller_hash': 'ZjQ5MmJmMDY0ZGE3cGVlcmludGY='},
                                                                               {       'in_octets': '8731697130',
                                                                                       'out_octets': '654097052545',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiMjMycGVlcmludGY='},
                                                                               {       'in_octets': '23429470841',
                                                                                       'out_octets': '180927228190',
                                                                                       'poller_hash': 'NzQ4M2MyNjhjMDhmcGVlcmludGY='},
                                                                               {       'in_octets': '32819711863',
                                                                                       'out_octets': '111481825373',
                                                                                       'poller_hash': 'NzQ4M2MyNjhlMDA3cGVlcmludGY='},
                                                                               {       'in_octets': '3133299383',
                                                                                       'out_octets': '75209791274',
                                                                                       'poller_hash': 'NzQ4M2MyZjA5NzQ0cGVlcmludGY='},
                                                                               {       'in_octets': '19053944349',
                                                                                       'out_octets': '526721112858',
                                                                                       'poller_hash': 'ZmNlY2RhZTBhZjE5cGVlcmludGY='},
                                                                               {       'in_octets': '2964786727',
                                                                                       'out_octets': '57636096097',
                                                                                       'poller_hash': 'YjRmYmU0NzkxZDY1cGVlcmludGY='},
                                                                               {       'in_octets': '94',
                                                                                       'out_octets': '0',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0YmZmcGVlcmludGY='},
                                                                               {       'in_octets': '7095456609',
                                                                                       'out_octets': '53735086104',
                                                                                       'poller_hash': 'YjRmYmU0ZWI0ZjdlcGVlcmludGY='},
                                                                               {       'in_octets': '41106969147',
                                                                                       'out_octets': '653253061015',
                                                                                       'poller_hash': 'ZDAyMWY5OWFiM2RjcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon6',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '9087956055416',
                                                              'out_ucast_pkts': '6772111881',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uNmludGY=',
                                                              'pons': [       {       'description': 'pon6',
                                                                                      'id': '6',
                                                                                      'links': [       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1573,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZDU5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406344',
                                                                                                               'fiber_length': 1313,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNkZjYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406343',
                                                                                                               'fiber_length': 1463,
                                                                                                               'poller_hash': 'Nzg4YTIwNzNlMTkxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406343',
                                                                                                               'fiber_length': 1318,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgwYjQwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406342',
                                                                                                               'fiber_length': 2009,
                                                                                                               'poller_hash': 'Nzg4YTIwNzgzZjIwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406344',
                                                                                                               'fiber_length': 1029,
                                                                                                               'poller_hash': 'Nzg4YTIwNzg0NzcycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1395,
                                                                                                               'poller_hash': 'Nzg4YTIwNzg1MzhlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1502,
                                                                                                               'poller_hash': 'MThlODI5ZjBjMzc0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404844',
                                                                                                               'fiber_length': 1466,
                                                                                                               'poller_hash': 'NzRhY2I5OTk3NzhicG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1404844',
                                                                                                               'fiber_length': 607,
                                                                                                               'poller_hash': 'ZjQ5MmJmMDY0ZGE3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406344',
                                                                                                               'fiber_length': 611,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiMjMycG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1245,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhjMDhmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406343',
                                                                                                               'fiber_length': 1177,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhlMDA3cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '621751',
                                                                                                               'fiber_length': 1684,
                                                                                                               'poller_hash': 'NzQ4M2MyZjA5NzQ0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406334',
                                                                                                               'fiber_length': 689,
                                                                                                               'poller_hash': 'ZmNlY2RhZTBhZjE5cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '595201',
                                                                                                               'fiber_length': 1123,
                                                                                                               'poller_hash': 'YjRmYmU0NzkxZDY1cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406343',
                                                                                                               'fiber_length': 2003,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0YmZmcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406344',
                                                                                                               'fiber_length': 1515,
                                                                                                               'poller_hash': 'YjRmYmU0ZWI0ZjdlcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406344',
                                                                                                               'fiber_length': 1989,
                                                                                                               'poller_hash': 'ZDAyMWY5OWFiM2RjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'}],
                                                                                      'max_distance': 20000,
                                                                                      'maximum_loss': -8.0,
                                                                                      'minimum_loss': -28.0,
                                                                                      'name': 'pon6',
                                                                                      'poller_hash': 'Nzg4YTIwMGQ3ODhiVUYtR1AtQis2',
                                                                                      'pon_technology': 'GPON',
                                                                                      'rx_link_rate': '1244160000',
                                                                                      'split_ratio': 128,
                                                                                      'tx_link_rate': '2488320000'}],
                                                              'speed': '2500000000'},
                                                      {       'admin_up': True,
                                                              'id': 'pon7',
                                                              'name': 'pon7',
                                                              'oper_up': False,
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uN2ludGY='},
                                                      {       'admin_up': True,
                                                              'id': 'pon8',
                                                              'in_errors': '0',
                                                              'in_octets': '594689436699',
                                                              'in_ucast_pkts': '2787218672',
                                                              'links': [       {       'in_octets': '60757111988',
                                                                                       'out_octets': '545367815054',
                                                                                       'poller_hash': 'MThlODI5MGI0NTk4cGVlcmludGY='},
                                                                               {       'in_octets': '14428376256',
                                                                                       'out_octets': '506554741603',
                                                                                       'poller_hash': 'MThlODI5MGI5MzRjcGVlcmludGY='},
                                                                               {       'in_octets': '5138820222',
                                                                                       'out_octets': '259102659789',
                                                                                       'poller_hash': 'MThlODI5MGI5OWRjcGVlcmludGY='},
                                                                               {       'in_octets': '4087138159',
                                                                                       'out_octets': '69653552107',
                                                                                       'poller_hash': 'MThlODI5ZjUyMmYxcGVlcmludGY='},
                                                                               {       'in_octets': '2520298600',
                                                                                       'out_octets': '45695622566',
                                                                                       'poller_hash': 'NzBhNzQxNTA0OWJjcGVlcmludGY='},
                                                                               {       'in_octets': '17419901740',
                                                                                       'out_octets': '87104071790',
                                                                                       'poller_hash': 'NzBhNzQxNTA2ZWY0cGVlcmludGY='},
                                                                               {       'in_octets': '563713215',
                                                                                       'out_octets': '8312839951',
                                                                                       'poller_hash': 'NzBhNzQxNTA3NWFjcGVlcmludGY='},
                                                                               {       'in_octets': '10497676766',
                                                                                       'out_octets': '293324032788',
                                                                                       'poller_hash': 'NzBhNzQxNTA4MjgwcGVlcmludGY='},
                                                                               {       'in_octets': '80418069756',
                                                                                       'out_octets': '864985730207',
                                                                                       'poller_hash': 'NzBhNzQxNTA5NTIwcGVlcmludGY='},
                                                                               {       'in_octets': '9952577098',
                                                                                       'out_octets': '699638874901',
                                                                                       'poller_hash': 'NzBhNzQxNTBjZjM0cGVlcmludGY='},
                                                                               {       'in_octets': '3174648902',
                                                                                       'out_octets': '24656389339',
                                                                                       'poller_hash': 'NzBhNzQxNTBkYzFjcGVlcmludGY='},
                                                                               {       'in_octets': '1381539387',
                                                                                       'out_octets': '8218842952',
                                                                                       'poller_hash': 'NzQ4M2MyNjhiNDRhcGVlcmludGY='},
                                                                               {       'in_octets': '35109416182',
                                                                                       'out_octets': '797618165813',
                                                                                       'poller_hash': 'NzQ4M2MyNjhjMGQ2cGVlcmludGY='},
                                                                               {       'in_octets': '73484932',
                                                                                       'out_octets': '25893802237',
                                                                                       'poller_hash': 'NzQ4M2MyNjhlMmIxcGVlcmludGY='},
                                                                               {       'in_octets': '16854410793',
                                                                                       'out_octets': '108089836138',
                                                                                       'poller_hash': 'NzQ4M2MyZjAyZDY4cGVlcmludGY='},
                                                                               {       'in_octets': '35334362850',
                                                                                       'out_octets': '726834090214',
                                                                                       'poller_hash': 'NzQ4M2MyZjAzZWQ4cGVlcmludGY='},
                                                                               {       'in_octets': '48784811927',
                                                                                       'out_octets': '1360462448966',
                                                                                       'poller_hash': 'NzQ4M2MyZjA0NDI0cGVlcmludGY='},
                                                                               {       'in_octets': '5876219160',
                                                                                       'out_octets': '435384647896',
                                                                                       'poller_hash': 'NzQ4M2MyZjA4MGNjcGVlcmludGY='},
                                                                               {       'in_octets': '36805088748',
                                                                                       'out_octets': '511202373170',
                                                                                       'poller_hash': 'NzQ4M2MyZjA4OTcwcGVlcmludGY='},
                                                                               {       'in_octets': '16119824757',
                                                                                       'out_octets': '599074423086',
                                                                                       'poller_hash': 'NzQ4M2MyZjA5MGI4cGVlcmludGY='},
                                                                               {       'in_octets': '57008908593',
                                                                                       'out_octets': '1616962298402',
                                                                                       'poller_hash': 'NzQ4M2MyZjA5NmE0cGVlcmludGY='},
                                                                               {       'in_octets': '6647631977',
                                                                                       'out_octets': '16046770220',
                                                                                       'poller_hash': 'NzQ4M2MyZjA5YjE0cGVlcmludGY='},
                                                                               {       'in_octets': '9672007596',
                                                                                       'out_octets': '108215184347',
                                                                                       'poller_hash': 'NzQ4M2MyZjBhMmI0cGVlcmludGY='},
                                                                               {       'in_octets': '15880179319',
                                                                                       'out_octets': '171448166880',
                                                                                       'poller_hash': 'NzQ4M2MyZjBiNDdjcGVlcmludGY='},
                                                                               {       'in_octets': '10952770158',
                                                                                       'out_octets': '527208990334',
                                                                                       'poller_hash': 'ZDAyMWY5OWEzNmEwcGVlcmludGY='}],
                                                              'manufacturer': 'Ubiquiti',
                                                              'model': 'UF-GP-B+',
                                                              'name': 'pon8',
                                                              'oper_up': True,
                                                              'out_errors': '0',
                                                              'out_octets': '12754328295546',
                                                              'out_ucast_pkts': '9293524982',
                                                              'poller_hash': 'Nzg4YTIwMGQ3ODhicG9uOGludGY=',
                                                              'pons': [       {       'description': 'pon8',
                                                                                      'id': '8',
                                                                                      'links': [       {       'connected_time': '1406073',
                                                                                                               'fiber_length': 2045,
                                                                                                               'poller_hash': 'MThlODI5MGI0NTk4cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406073',
                                                                                                               'fiber_length': 2147,
                                                                                                               'poller_hash': 'MThlODI5MGI5MzRjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406074',
                                                                                                               'fiber_length': 1622,
                                                                                                               'poller_hash': 'MThlODI5MGI5OWRjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1403934',
                                                                                                               'fiber_length': 1225,
                                                                                                               'poller_hash': 'MThlODI5ZjUyMmYxcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1090279',
                                                                                                               'fiber_length': 2058,
                                                                                                               'poller_hash': 'NzBhNzQxNTA0OWJjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406074',
                                                                                                               'fiber_length': 1910,
                                                                                                               'poller_hash': 'NzBhNzQxNTA2ZWY0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406073',
                                                                                                               'fiber_length': 2257,
                                                                                                               'poller_hash': 'NzBhNzQxNTA3NWFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406074',
                                                                                                               'fiber_length': 2048,
                                                                                                               'poller_hash': 'NzBhNzQxNTA4MjgwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406072',
                                                                                                               'fiber_length': 1563,
                                                                                                               'poller_hash': 'NzBhNzQxNTA5NTIwcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1406064',
                                                                                                               'fiber_length': 1775,
                                                                                                               'poller_hash': 'NzBhNzQxNTBjZjM0cG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1030128',
                                                                                                               'fiber_length': 2058,
                                                                                                               'poller_hash': 'NzBhNzQxNTBkYzFjcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                                               'tx_link_rate': '2488320000'},
                                                                                                       {       'connected_time': '1031658',
                                                                                                               'fiber_length': 1756,
                                                                                                               'poller_hash': 'NzQ4M2MyNjhiNDRhcG9ubGluaw==',
                                                                                                               'rx_link_rate': '1244160000',
                                                                                              